/*
tls.h - MessageWall TLS declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _TLS_H
#define _TLS_H

#include <openssl/ssl.h>

int tls_client_eread(int client, struct firestring_estr_t *f);
int tls_backend_eread(int backend, struct firestring_estr_t *f);
int tls_client_write(int client, char *buf, int len);
int tls_client_read(int client, char *buf, int len);
int tls_backend_write(int backend, char *buf, int len);
int tls_backend_read(int backend, char *buf, int len);
int tls_start(int client);
int tls_handshake(int client);
int tls_client_start(int backend);
int tls_client_handshake(int backend);
void tls_client_error(int client);
void tls_backend_error(int backend);

#endif
