/*
** Automatically generated from `timeout.m'
** by the Mercury compiler,
** version rotd-2004-05-11, configured for i686-pc-linux-gnu.
** Do not edit.
**
** The autoconfigured grade settings governing
** the generation of this C file were
**
** TAG_BITS=2
** UNBOXED_FLOAT=no
**
** END_OF_C_GRADE_INFO
*/


/* :- module timeout. */
/* :- implementation. */

#include "timeout.mih"


#include "array.mih"
#include "assoc_list.mih"
#include "benchmarking.mih"
#include "bool.mih"
#include "builtin.mih"
#include "char.mih"
#include "construct.mih"
#include "deconstruct.mih"
#include "dir.mih"
#include "enum.mih"
#include "exception.mih"
#include "float.mih"
#include "int.mih"
#include "integer.mih"
#include "io.mih"
#include "list.mih"
#include "map.mih"
#include "ops.mih"
#include "parser.mih"
#include "private_builtin.mih"
#include "random.mih"
#include "require.mih"
#include "rtti_implementation.mih"
#include "set.mih"
#include "set_ordlist.mih"
#include "set_unordlist.mih"
#include "std_util.mih"
#include "store.mih"
#include "string.mih"
#include "table_builtin.mih"
#include "term.mih"
#include "term_io.mih"
#include "time.mih"
#include "tree234.mih"
#include "type_desc.mih"
#include "varset.mih"



#line 625 "timeout.m"
static void MR_CALL timeout__do_release_lock_3_p_0(
#line 625 "timeout.m"
  MR_String timeout__MutexFile_1);
#line 611 "timeout.m"
static void MR_CALL timeout__do_get_lock_3_p_0(
#line 611 "timeout.m"
  MR_String timeout__MutexFile_1);

#include "timeout.mh"
#include "io.mh"
#include "io.mh"
#include "string.mh"
#include "time.mh"
#include "time.mh"
#include "array.mh"
#include "array.mh"
#include "dir.mh"
#include "dir.mh"
#include "table_builtin.mh"
#include "table_builtin.mh"
#line 146 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED

#include	<sys/types.h>

const char	*MP_cleanup_files[MP_MAX_CLEANUP_FILES];
int		MP_cleanup_file_next = 0;

int		MP_timeout_seconds = 30 * 60;
const char	*MP_timeout_mutex_file = NULL;
const char	*MP_timeout_want_dir = NULL;
const char	*MP_timeout_want_prefix = NULL;

/* set this variable to MR_TRUE to debug the code cleanup array */
MR_bool		MP_print_cleanup_files = MR_FALSE;

void
MP_maybe_print_cleanup_files(const char *msg)
{
	int	i;

	if (MP_print_cleanup_files) {
		fprintf(stderr, "\n%s cleanup files:\n", msg);
		for (i = 0; i < MP_cleanup_file_next; i++) {
			fprintf(stderr, "%i %s\n", i, MP_cleanup_files[i]);
		}
	}
}

void
MP_register_cleanup_file(const char *filename)
{
	int	i;

	if (MP_cleanup_file_next >= MP_MAX_CLEANUP_FILES - 1) {
		MR_fatal_error("MP_register_cleanup_file: too many entries");
	}

	for (i = 0; i < MP_cleanup_file_next; i++) {
		if (MR_streq(filename, MP_cleanup_files[i])) {
			MR_fatal_error("MP_register_cleanup_file: duplicate");
		}
	}

	MP_cleanup_files[MP_cleanup_file_next] = filename;
	MP_cleanup_file_next++;
	MP_maybe_print_cleanup_files("register");
}

void
MP_unregister_cleanup_file(const char *filename)
{
	int	i;
	int	j;

	for (i = 0; i < MP_cleanup_file_next; i++) {
		if (MR_streq(filename, MP_cleanup_files[i])) {
			/* shift the array entries above index i down one */
			for (j = i + 1; j < MP_cleanup_file_next; j++) {
				MP_cleanup_files[j - 1] = MP_cleanup_files[j];
			}

			MP_cleanup_file_next--;
			MP_maybe_print_cleanup_files("unregister");
			return;
		}
	}

	MR_fatal_error("MP_unregister_cleanup_file: not found");
}

void
MP_handle_fatal_exception(void *data)
{
	/* we ignore data */
	MP_delete_cleanup_files();
}

void
MP_delete_cleanup_files(void)
{
	int	i;
	MR_bool	delayed_mutex_file;

	/*
	** We want to remove the mutex file only after we have removed the
	** files manipulated by the critical section it was protecting.
	*/

	MP_maybe_print_cleanup_files("delete");

	delayed_mutex_file = MR_FALSE;
	for (i = 0; i < MP_cleanup_file_next; i++) {
		if (MR_streq(MP_timeout_mutex_file, MP_cleanup_files[i])) {
			delayed_mutex_file = MR_TRUE;
		} else {
			if (remove(MP_cleanup_files[i]) != 0) {
				perror(MP_cleanup_files[i]);
			}
		}
	}

	if (delayed_mutex_file) {
		if (remove(MP_timeout_mutex_file) != 0) {
			perror(MP_timeout_mutex_file);
		}
	}

	MP_cleanup_file_next = 0;
}

void
MP_delete_cleanup_files_and_exit_failure(const char *signal_name)
{
	FILE	*fp;
	char	buf[1024];	/* that should be big enough */

#ifdef	MP_DEBUG_MDPROF_SIGNAL
	fp = fopen("/tmp/mdprof_signal", "w");
	if (fp != NULL) {
		fprintf(fp, "%s\n", signal_name);
		(void) fclose(fp);
	}
#endif

	MP_delete_cleanup_files();

#ifdef	MP_DEBUG_MDPROF_SIGNAL
	sprintf(buf, "Mercury deep profiler: received unexpected signal %s",
		signal_name);
	MR_fatal_error(buf);
#else
	exit(EXIT_FAILURE);
#endif
}

/*
** SIGALRM alarm signal indicates a timeout. SIGTERM usually indicates the
** machine is being shut down. The others are there to catch forceful shutdowns
** during development, both intentional ones where the programmer sends the
** signal and those caused by bugs in the server code. We would like to include
** all catchable, fatal signals in this list, but that set is somewhat OS
** dependent. The set whose existence we test for here includes all the
** signals that are at all likely to be sent to server process.
**
** We don't test for the existence of SIGALRM, because we want compilation to
** fail if it does not exist. Without alarm signals, server processes will
** never be timed out, and thus constitute a resource leak (mostly of virtual
** memory/swap space).
**
** We could avoid this problem if we had a version of atexit that executed
** its actions even when the program exits after a signal.
*/

const MP_sig_handler MP_signal_structs[] =
{
	{ SIGALRM,	MP_handle_timeout },
#ifdef SIGTERM
	{ SIGTERM,	MP_handle_sig_term },
#endif
#ifdef SIGHUP
	{ SIGHUP,	MP_handle_sig_hup },
#endif
#ifdef SIGINT
	{ SIGINT,	MP_handle_sig_int },
#endif
#ifdef SIGQUIT
	{ SIGQUIT,	MP_handle_sig_quit },
#endif
#ifdef SIGILL
	{ SIGILL,	MP_handle_sig_ill },
#endif
#ifdef SIGABRT
	{ SIGABRT,	MP_handle_sig_abrt },
#endif
#ifdef SIGBUS
	{ SIGBUS,	MP_handle_sig_bus },
#endif
#ifdef SIGFPE
	{ SIGFPE,	MP_handle_sig_fpe },
#endif
#ifdef SIGSEGV
	{ SIGSEGV,	MP_handle_sig_segv },
#endif
#ifdef SIGPIPE
	{ SIGPIPE,	MP_handle_sig_pipe },
#endif
	{ -1, 		NULL }
};

void
MP_handle_timeout(void)
{
	DIR		*dir;
	struct	dirent	*dirent;
	int		matchlen;
	MR_bool		success;

	if (MP_timeout_want_dir == NULL || MP_timeout_want_prefix == NULL) {
		MR_fatal_error("MP_handle_timeout: null dir or prefix");
	}

	matchlen = strlen(MP_timeout_want_prefix);

	success = MP_do_try_get_lock(MP_timeout_mutex_file);
	if (! success) {
		/*
		** We could not get the lock, so some other process holds it.
		** We therefore abort the timeout, but schedule the next one.
		*/

		(void) alarm(MP_timeout_seconds);
		return;
	}

	dir = opendir(MP_timeout_want_dir);
	if (dir == NULL) {
		MR_fatal_error("MP_handle_timeout: opendir failed");
	}

	while ((dirent = readdir(dir)) != NULL) {
		if (MR_strneq(dirent->d_name, MP_timeout_want_prefix,
			matchlen))
		{
			/* abort the timeout */
			(void) closedir(dir);
			(void) alarm(MP_timeout_seconds);
			return;
		}
	}

	(void) closedir(dir);

	/*
	** This call will delete the mutex file last, releasing the mutex
	*/
	MP_delete_cleanup_files();
	exit(EXIT_SUCCESS);

}

void
MP_handle_sig_term(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGTERM");
}

void
MP_handle_sig_hup(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGHUP");
}

void
MP_handle_sig_int(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGINT");
}

void
MP_handle_sig_quit(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGQUIT");
}

void
MP_handle_sig_ill(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGILL");
}

void
MP_handle_sig_abrt(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGABRT");
}

void
MP_handle_sig_bus(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGBUS");
}

void
MP_handle_sig_fpe(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGFPE");
}

void
MP_handle_sig_segv(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGSEGV");
}

void
MP_handle_sig_pipe(void)
{
	MP_delete_cleanup_files_and_exit_failure("SIGPIPE");
}

MR_bool
MP_do_try_get_lock(const char *mutex_file)
{
	int	res;
	MR_bool	success;

	res = open(mutex_file, O_CREAT | O_EXCL, 0);
	if (res >= 0) {
		(void) close(res);
		MP_register_cleanup_file(mutex_file);
		success = MR_TRUE;
	} else if (res < 0 && errno == EEXIST) {
		success = MR_FALSE;
	} else {
		MR_fatal_error("MP_do_try_get_lock failed");
	}

	return res;
}

void
MP_do_get_lock(const char *mutex_file)
{
	int	res;

	for (;;) {
		res = open(mutex_file, O_CREAT | O_EXCL, 0);
		if (res >= 0) {
			(void) close(res);
			MP_register_cleanup_file(mutex_file);
			return;
		} else if (res < 0 && errno == EEXIST) {
			sleep(5);
			continue;
		} else {
			MR_fatal_error("MP_do_get_lock failed");
		}
	}
}

void
MP_do_release_lock(const char *mutex_file)
{
	MP_unregister_cleanup_file(mutex_file);
	(void) unlink(mutex_file);
}

#endif	/* MR_DEEP_PROFILER_ENABLED */



#line 625 "timeout.m"
static void MR_CALL timeout__do_release_lock_3_p_0(
#line 625 "timeout.m"
  MR_String timeout__MutexFile_1)
#line 625 "timeout.m"
{
#line 628 "timeout.m"
  {
#line 628 "timeout.m"
    MR_bool timeout__succeeded;

#line 631 "timeout.m"
{
#define MR_PROC_LABEL timeout__do_release_lock_3_p_0

	MR_String MutexFile;
	MR_Word S0;
	MR_Word S;

	MutexFile = 
timeout__MutexFile_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 631 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_do_release_lock(MutexFile);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 472 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 631 "timeout.m"
}
#line 628 "timeout.m"
  }
#line 625 "timeout.m"
}

#line 611 "timeout.m"
static void MR_CALL timeout__do_get_lock_3_p_0(
#line 611 "timeout.m"
  MR_String timeout__MutexFile_1)
#line 611 "timeout.m"
{
#line 613 "timeout.m"
  {
#line 613 "timeout.m"
    MR_bool timeout__succeeded;

#line 616 "timeout.m"
{
#define MR_PROC_LABEL timeout__do_get_lock_3_p_0

	MR_String MutexFile;
	MR_Word S0;
	MR_Word S;

	MutexFile = 
timeout__MutexFile_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 616 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_do_get_lock(MutexFile);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 518 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 616 "timeout.m"
}
#line 613 "timeout.m"
  }
#line 611 "timeout.m"
}

#line 79 "timeout.m"
void MR_CALL timeout__remove_want_file_3_p_0(
#line 79 "timeout.m"
  MR_String timeout__WantFileName_1)
#line 79 "timeout.m"
{
#line 659 "timeout.m"
  {
#line 659 "timeout.m"
    MR_bool timeout__succeeded;

#line 662 "timeout.m"
{
#define MR_PROC_LABEL timeout__remove_want_file_3_p_0

	MR_String WantFileName;
	MR_Word S0;
	MR_Word S;

	WantFileName = 
timeout__WantFileName_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 662 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_unregister_cleanup_file(WantFileName);
	(void) unlink(WantFileName);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 565 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 662 "timeout.m"
}
#line 659 "timeout.m"
  }
#line 79 "timeout.m"
}

#line 75 "timeout.m"
void MR_CALL timeout__make_want_file_3_p_0(
#line 75 "timeout.m"
  MR_String timeout__WantFileName_1)
#line 75 "timeout.m"
{
#line 640 "timeout.m"
  {
#line 640 "timeout.m"
    MR_bool timeout__succeeded;

#line 643 "timeout.m"
{
#define MR_PROC_LABEL timeout__make_want_file_3_p_0

	MR_String WantFileName;
	MR_Word S0;
	MR_Word S;

	WantFileName = 
timeout__WantFileName_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 643 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	int	fd;

	fd = open(WantFileName, O_CREAT, 0);
	if (fd < 0) {
		MR_fatal_error("make_want_file: open failed");
	}
	(void) close(fd);
	MP_register_cleanup_file(WantFileName);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 618 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 643 "timeout.m"
}
#line 640 "timeout.m"
  }
#line 75 "timeout.m"
}

#line 70 "timeout.m"
void MR_CALL timeout__release_lock_4_p_0(
#line 70 "timeout.m"
  MR_Word timeout__Debug_5,
#line 70 "timeout.m"
  MR_String timeout__MutexFile_6)
#line 70 "timeout.m"
{
#line 606 "timeout.m"
  {
#line 606 "timeout.m"
    MR_bool timeout__succeeded;

#line 606 "timeout.m"
#line 606 "timeout.m"
    switch (timeout__Debug_5) {
#line 606 "timeout.m"
      default: /*NOTREACHED*/ MR_assert(0);
#line 606 "timeout.m"
      case (MR_Integer) 0:
#line 628 "timeout.m"
        {
#line 631 "timeout.m"
{
#define MR_PROC_LABEL timeout__release_lock_4_p_0

	MR_String MutexFile;
	MR_Word S0;
	MR_Word S;

	MutexFile = 
timeout__MutexFile_6
;
	S0 = 
(MR_Integer) 0
;
		{
#line 631 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_do_release_lock(MutexFile);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 675 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 631 "timeout.m"
}
#line 628 "timeout.m"
        }
#line 606 "timeout.m"
        break;
#line 606 "timeout.m"
      case (MR_Integer) 1:
#line 606 "timeout.m"
        {
#line 606 "timeout.m"
        }
#line 606 "timeout.m"
        break;
#line 606 "timeout.m"
    }
#line 606 "timeout.m"
  }
#line 70 "timeout.m"
}

#line 63 "timeout.m"
void MR_CALL timeout__get_lock_4_p_0(
#line 63 "timeout.m"
  MR_Word timeout__Debug_5,
#line 63 "timeout.m"
  MR_String timeout__MutexFile_6)
#line 63 "timeout.m"
{
#line 598 "timeout.m"
  {
#line 598 "timeout.m"
    MR_bool timeout__succeeded;

#line 598 "timeout.m"
#line 598 "timeout.m"
    switch (timeout__Debug_5) {
#line 598 "timeout.m"
      default: /*NOTREACHED*/ MR_assert(0);
#line 598 "timeout.m"
      case (MR_Integer) 0:
#line 613 "timeout.m"
        {
#line 616 "timeout.m"
{
#define MR_PROC_LABEL timeout__get_lock_4_p_0

	MR_String MutexFile;
	MR_Word S0;
	MR_Word S;

	MutexFile = 
timeout__MutexFile_6
;
	S0 = 
(MR_Integer) 0
;
		{
#line 616 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_do_get_lock(MutexFile);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 746 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 616 "timeout.m"
}
#line 613 "timeout.m"
        }
#line 598 "timeout.m"
        break;
#line 598 "timeout.m"
      case (MR_Integer) 1:
#line 598 "timeout.m"
        {
#line 598 "timeout.m"
        }
#line 598 "timeout.m"
        break;
#line 598 "timeout.m"
    }
#line 598 "timeout.m"
  }
#line 63 "timeout.m"
}

#line 57 "timeout.m"
void MR_CALL timeout__setup_timeout_3_p_0(
#line 57 "timeout.m"
  MR_Integer timeout__Minutes_1)
#line 57 "timeout.m"
{
#line 580 "timeout.m"
  {
#line 580 "timeout.m"
    MR_bool timeout__succeeded;

#line 583 "timeout.m"
{
#define MR_PROC_LABEL timeout__setup_timeout_3_p_0

	MR_Integer Minutes;
	MR_Word S0;
	MR_Word S;

	Minutes = 
timeout__Minutes_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 583 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_timeout_seconds = Minutes * 60;
	(void) alarm(MP_timeout_seconds);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 807 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 583 "timeout.m"
}
#line 580 "timeout.m"
  }
#line 57 "timeout.m"
}

#line 52 "timeout.m"
void MR_CALL timeout__setup_signals_5_p_0(
#line 52 "timeout.m"
  MR_String timeout__MutexFile_1,
#line 52 "timeout.m"
  MR_String timeout__WantDir_2,
#line 52 "timeout.m"
  MR_String timeout__WantPrefix_3)
#line 52 "timeout.m"
{
#line 546 "timeout.m"
  {
#line 546 "timeout.m"
    MR_bool timeout__succeeded;

#line 550 "timeout.m"
{
#define MR_PROC_LABEL timeout__setup_signals_5_p_0

	MR_String MutexFile;
	MR_String WantDir;
	MR_String WantPrefix;
	MR_Word S0;
	MR_Word S;

	MutexFile = 
timeout__MutexFile_1
;
	WantDir = 
timeout__WantDir_2
;
	WantPrefix = 
timeout__WantPrefix_3
;
	S0 = 
(MR_Integer) 0
;
		{
#line 550 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	int	i;

	MP_timeout_mutex_file = MutexFile;
	MP_timeout_want_dir = WantDir;
	MP_timeout_want_prefix = WantPrefix;

	for (i = 0; MP_signal_structs[i].MP_signum >= 0; i++) {
		MR_setup_signal(MP_signal_structs[i].MP_signum,
			MP_signal_structs[i].MP_handler, MR_FALSE,
			"Mercury deep profiler: cannot setup signal exit");
	}

	/*
	** Mercury exceptions do not cause signals. The default exception
	** handler prints and error message and exits. To ensure that
	** we delete up the files we need to clean up, we get the exit
	** library function to invoke MP_delete_cleanup_files through
	** MP_handle_fatal_exception.
	*/

	MR_register_exception_cleanup(MP_handle_fatal_exception, NULL);

	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 886 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 550 "timeout.m"
}
#line 546 "timeout.m"
  }
#line 52 "timeout.m"
}

#line 46 "timeout.m"
void MR_CALL timeout__delete_cleanup_files_2_p_0(void)
#line 46 "timeout.m"
{
#line 534 "timeout.m"
  {
#line 534 "timeout.m"
    MR_bool timeout__succeeded;

#line 537 "timeout.m"
{
#define MR_PROC_LABEL timeout__delete_cleanup_files_2_p_0

	MR_Word S0;
	MR_Word S;

	S0 = 
(MR_Integer) 0
;
		{
#line 537 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_delete_cleanup_files();
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 926 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 537 "timeout.m"
}
#line 534 "timeout.m"
  }
#line 46 "timeout.m"
}

#line 42 "timeout.m"
void MR_CALL timeout__unregister_all_files_for_cleanup_2_p_0(void)
#line 42 "timeout.m"
{
#line 522 "timeout.m"
  {
#line 522 "timeout.m"
    MR_bool timeout__succeeded;

#line 525 "timeout.m"
{
#define MR_PROC_LABEL timeout__unregister_all_files_for_cleanup_2_p_0

	MR_Word S0;
	MR_Word S;

	S0 = 
(MR_Integer) 0
;
		{
#line 525 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_cleanup_file_next = 0;
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 966 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 525 "timeout.m"
}
#line 522 "timeout.m"
  }
#line 42 "timeout.m"
}

#line 37 "timeout.m"
void MR_CALL timeout__unregister_file_for_cleanup_3_p_0(
#line 37 "timeout.m"
  MR_String timeout__File_1)
#line 37 "timeout.m"
{
#line 510 "timeout.m"
  {
#line 510 "timeout.m"
    MR_bool timeout__succeeded;

#line 513 "timeout.m"
{
#define MR_PROC_LABEL timeout__unregister_file_for_cleanup_3_p_0

	MR_String File;
	MR_Word S0;
	MR_Word S;

	File = 
timeout__File_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 513 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_unregister_cleanup_file(File);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 1012 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 513 "timeout.m"
}
#line 510 "timeout.m"
  }
#line 37 "timeout.m"
}

#line 32 "timeout.m"
void MR_CALL timeout__register_file_for_cleanup_3_p_0(
#line 32 "timeout.m"
  MR_String timeout__File_1)
#line 32 "timeout.m"
{
#line 498 "timeout.m"
  {
#line 498 "timeout.m"
    MR_bool timeout__succeeded;

#line 501 "timeout.m"
{
#define MR_PROC_LABEL timeout__register_file_for_cleanup_3_p_0

	MR_String File;
	MR_Word S0;
	MR_Word S;

	File = 
timeout__File_1
;
	S0 = 
(MR_Integer) 0
;
		{
#line 501 "timeout.m"

#ifdef	MR_DEEP_PROFILER_ENABLED
	MP_register_cleanup_file(File);
	S = S0;
#else
	MR_fatal_error("deep profiler not enabled");
#endif

#line 1058 "timeout.c"

		;}
#undef MR_PROC_LABEL
#line 501 "timeout.m"
}
#line 498 "timeout.m"
  }
#line 32 "timeout.m"
}

void mercury__timeout__init(void)
{
}

void mercury__timeout__init_type_tables(void)
{
}

void mercury__timeout__init_debugger(void)
{
	MR_fatal_error("debugger initialization in MLDS grade");
}


/* ensure everything is compiled with the same grade */
static const void *const MR_grade = &MR_GRADE_VAR;

/* :- end_module timeout. */
