// Copyright (c) 2009, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

//
// Used by MercurialPristineTar.  Holds all information that is needed to
// recreate a pristine tarball from a component branch.
//
class Pristine
{
	// The Mercurial revision of the component branch from where the tarball can
	// be regenerated.
	public var revision (default,null) : String;
	// The xdelta patch file to make the recreated tarball identical to the
	// original tarball.
	public var tarballDelta (default,null) : String;
	// One of gz, bz2, or lzma.
	public var compression (default,null) : String;
	// The pristine-{gz,bz2} patch file to compress the patched, recreated
	// tarball the same way as the original, compressed tarball.
	public var compressionDelta (default,null) : String;

	public function new
	(
		compression : String,
		compressionDelta : String,
		tarballDelta : String,
		revision : String
	)
	{
		this.compression = compression;
		this.compressionDelta = compressionDelta;
		this.tarballDelta = tarballDelta;
		this.revision = revision;
	}
}
