---
# Acknowledgements
---

Authors
-------

Meep originated as part of graduate research at [MIT](https://en.wikipedia.org/wiki/Massachusetts_Institute_of_Technology) in the mid 2000s with initial contributions by [Steven G. Johnson](http://math.mit.edu/~stevenj/), [Ardavan Oskooi](http://ab-initio.mit.edu/~oskooi/), [David Roundy](http://physics.oregonstate.edu/~roundyd/), [Mihai Ibanescu](https://www.linkedin.com/in/mihai-ibanescu-2b147825/), and [Peter Bermel](http://web.ics.purdue.edu/~pbermel/). The project has been under continuous development for nearly 20 years. Currently, the Meep project is maintained by an active developer community on [GitHub](https://github.com/NanoComp/meep). [Christopher Hogan](https://github.com/ChristopherHogan) and [M.T. Homer Reid](http://homerreid.dyndns.org/) lead the development of the [Python interface](Python_User_Interface.md), [mode-decomposition feature](Python_Tutorials/Mode_Decomposition.md), and [GDSII import routines](Python_Tutorials/GDSII_Import.md). M.T. Homer Reid and [Alec Hammond](https://github.com/smartalecH/) developed the [adjoint solver](Python_Tutorials/Adjoint_Solver.md). [Alex Cerjan](http://www.alexcerjan.com/) assisted with adding support for saturable absorption via [multilevel atomic gain media](Materials.md#saturable-gain-and-absorption). Alec Hammond developed the [visualization module](Python_User_Interface.md#data-visualization). [Yidong Chong](http://www1.spms.ntu.edu.sg/~ydchong/bio.html) and Alex Cerjan added support for [gyrotropic media](Materials.md#gyrotropic-media). [Andreas Hoenselaar](https://github.com/ahoenselaar) contributed to several performance enhancements.

Referencing
-----------

We request that you cite the following technical reference in any work for which you used Meep:

- A. Oskooi, D. Roundy, M. Ibanescu, P. Bermel, J.D. Joannopoulos, and S.G. Johnson, [MEEP: A flexible free-software package for electromagnetic simulations by the FDTD method](http://dx.doi.org/doi:10.1016/j.cpc.2009.11.008), Computer Physics Communications, Vol. 181, pp. 687-702 (2010) ([pdf](http://ab-initio.mit.edu/~oskooi/papers/Oskooi10.pdf)).

If you want a one-sentence description of the algorithm for inclusion in a publication, we recommend something like:

- "Simulations were performed with the finite-difference time-domain (FDTD) method [ref FDTD], using an open-source software package [ref Meep]."

General references on the FDTD method include, for example:

- A. Taflove and S.C. Hagness, [Computational Electrodynamics: The Finite-Difference Time-Domain Method](https://www.amazon.com/Computational-Electrodynamics-Finite-Difference-Time-Domain-Method/dp/1580538320), Artech: Norwood, MA, 2005.

- A. Taflove, A. Oskooi, and S.G. Johnson, [Advances in FDTD Computational Electrodynamics: Photonics and Nanotechnology](https://www.amazon.com/Advances-FDTD-Computational-Electrodynamics-Nanotechnology/dp/1608071707), Artech: Norwood, MA, 2013.

Financial Support
-----------------

Meep's development has been supported by Small Business Innovation Research (SBIR) Phase 1 and 2 awards from the National Science Foundation (NSF) under award numbers [1647206](https://www.nsf.gov/awardsearch/showAward?AWD_ID=1647206) and [1758596](https://www.nsf.gov/awardsearch/showAward?AWD_ID=1758596). Initial development was supported in part by the Materials Research Science and Engineering Center program of the NSF under award numbers DMR-9400334 and DMR-0819762, by the Army Research Office through the Institute for Soldier Nanotechnologies under DAAD-19-02-D0002, and DARPA under N00014-05-1-0700 administered by the Office of Naval Research.
