{-# LANGUAGE TemplateHaskell #-}
module Static where
import Data.FileEmbed
import Data.ByteString
import System.Directory
import Data.ByteString.UTF8

headerFiles :: [(FilePath, ByteString)]
headerFiles = $(embedDir "./document/headers")

babelFiles :: [(FilePath, ByteString)]
babelFiles = $(embedDir "./src/babel")

createDirectories :: String -> IO [()]
createDirectories pathname = mapM (\s->(createDirectoryIfMissing True (pathname++"/document/"++s))) ["images","headers", "main"]

writeFiles::String->[(FilePath, Data.ByteString.ByteString)]->IO ()
writeFiles pathname filelist= do _<-(mapM (\(name,content) ->Data.ByteString.writeFile (pathname++ name) content) filelist)
                                 return ()

latexHeader :: ByteString
latexHeader = $(embedFile "./latex/my-head.tex")



latexFooter :: ByteString
latexFooter = $(embedFile "./latex/my-tail.tex")

latexPreamble :: ByteString
latexPreamble = $(embedFile "./latex/preamble.tex")


latexTableHeader :: ByteString
latexTableHeader = $(embedFile "./latex/my-tabhead.tex")

latexTableFooter :: ByteString
latexTableFooter = $(embedFile "./latex/my-tabtail.tex")


userTemplates :: String
userTemplates = toString $(embedFile "./latex/templates.user")

extract :: String -> IO ()
extract pathname = do _<-createDirectories pathname
                      writeFiles (pathname++"/document/headers/") headerFiles
                      

