import Network
import GHC.IO.Handle
import System.Environment
import Text.XML.HaXml.SAX
import Text.XML.HaXml.Types
import Control.Monad
import Data.Maybe
import Text.XML.HXT.DOM.QualifiedName
import Data.Text (strip,pack)
data VectorInfo = VectorInfo {vectorNameInfo::NameInfo,group::String,device::String}
  deriving Show
data SwitchState = On | Off
  deriving Show

data NameInfo = NameInfo{name::String, label::String}
  deriving Show

data DefSwitch = DefSwitch {switchElementInfo::NameInfo, state::SwitchState}
  deriving Show
data DefText = DefText {textElementInfo::NameInfo, text::String}
  deriving Show
data DefNumber = DefNumber {numberElementInfo::NameInfo, number::Double, minValue::Double, maxValue::Double}
  deriving Show
data IndiEvent = DefSwitchVector VectorInfo [DefSwitch] | DefTextVector VectorInfo [DefText] | DefNumberVector VectorInfo [DefNumber]
  deriving Show
data Node = Node{nodeName::String,attributes::[Attribute],elements::[Node],charData::String} 
  deriving Show
parseNodes::[SaxElement]->[Node] 
parseNodes ((SaxElementOpen n a):xs) = let (nn,xxs)=(parseNodeClose n "" [] a xs) in (nn:(parseNodes xxs))
parseNodes (_:xs) = (parseNodes xs)
parseNodeClose::String->String->[Node]->[Attribute]->[SaxElement]->(Node,[SaxElement]) 
parseNodeClose n b l a ((SaxCharData c):xs)= parseNodeClose n (b++c) l a xs
parseNodeClose n b l a ((SaxElementOpen nn aa):xs)= let (node,xxs)=parseNodeClose nn "" [] aa xs in parseNodeClose n b (l++[node]) a xxs
parseNodeClose n b l a ((SaxElementClose nn):xs)= if (nn==n) then (Node{nodeName=n,attributes=a,elements=l,charData=b},xs) else parseNodeClose n b l a xs
parseNodeClose n b l a (_:xs)= parseNodeClose n b l a xs


parse::[Node]->[IndiEvent]
parse (n:xs) | nodeName n== "defSwitchVector" = (DefSwitchVector (parseVectorInfo (attributes n)) (map parseDefSwitch (elements n)) ):(parse xs)
parse (n:xs) | nodeName n== "defTextVector" = (DefTextVector (parseVectorInfo (attributes n)) (map parseDefText (elements n)) ):(parse xs)
parse (n:xs) | nodeName n== "defNumberVector" = (DefNumberVector (parseVectorInfo (attributes n)) (map parseDefNumber (elements n)) ):(parse xs)
parse (_:xs) = (parse xs)

parseDefSwitch::Node->DefSwitch
parseDefSwitch x= DefSwitch{switchElementInfo=parseNameInfo (attributes x),state=if (strip (pack (charData x)))==(pack "On") then On else Off}

parseDefText::Node->DefText
parseDefText x= DefText{textElementInfo=parseNameInfo (attributes x),text=charData x}

parseDefNumber::Node->DefNumber
parseDefNumber x= DefNumber{numberElementInfo=parseNameInfo (attributes x),minValue=lu "min", maxValue= lu "max", number=case reads (charData x) :: [(Double,String)] of
              [(f, _)] -> f
              _ -> 0.0}
  where 
    lu a = case reads (show (fromJust (lookup (N a) (attributes x) )))  :: [(Double,String)] of 
                [(f, _)] -> f
                _ -> 0.0

parseNameInfo x= NameInfo{name=lu "name" , label= lu "label"}
  where
    lu::String->String
    lu a = show (fromJust (lookup (N a) x ))

parseVectorInfo :: [Attribute]->VectorInfo
parseVectorInfo a = VectorInfo {device=lu "device",vectorNameInfo=parseNameInfo a, group=lu "group" } 
  where 
    lu::String->String
    lu x = show (fromJust (lookup (N x) a))

main = withSocketsDo $ do handle <- connectTo "localhost" (PortNumber 7624)
                          hPutStr handle "<getProperties version='1.5'/>"
		          s <- hGetContents handle
		          mapM_ print (parse (parseNodes (fst (saxParse "filename" s)))) 
