<?php
/**
 * Internationalisation file for extension LanguageSelector.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English
 * @author SPQRobin
*/
$messages['en'] = array(
	'languageselector'         => 'Language',
	'languageselector-desc'    => 'Language selector on every page, also for visitors',
	'languageselector-setlang' => 'set',
);

/** Message documentation (Message documentation)
 * @author Jon Harald Søby
 * @author SPQRobin
 */
$messages['qqq'] = array(
	'languageselector' => 'Part of the "LanguageSelector" extension. You can see it when the wiki administrator has chosen for a language selector in the sidebar, so this message would be the title, like you have "navigation", "search" and "toolbox".

{{Identical|Language}}',
	'languageselector-desc' => 'Part of the "LanguageSelector" extension. This is a description of this extension shown on [[Special:Version]].',
	'languageselector-setlang' => 'Part of the "LanguageSelector" extension. This is the text of a submit button to select your user interface language. Mostly the button  is not shown, but sometimes it appears next to the language selector (a dropdown box like in your [[Special:Preferences|user preferences]]).',
);

/** Abkhazian (Аҧсуа)
 * @author Temuri rajavi
 */
$messages['ab'] = array(
	'languageselector' => 'Абызшәа',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 * @author SPQRobin
 */
$messages['af'] = array(
	'languageselector' => 'Taal',
	'languageselector-desc' => 'Taalkeuse op elke bladsy, ook vir besoekers',
	'languageselector-setlang' => 'stel',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'languageselector' => 'Gjuhë',
	'languageselector-desc' => 'Gjuha seleksionues në çdo faqe, edhe për vizitorët',
	'languageselector-setlang' => 'vendosur',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'languageselector' => 'ቋንቋ',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'languageselector' => 'اللغة',
	'languageselector-desc' => 'اختيار اللغة في كل صفحة، أيضا للزائرين',
	'languageselector-setlang' => 'ضبط',
);

/** Araucanian (Mapudungun)
 * @author Kaniw
 * @author Lin linao
 */
$messages['arn'] = array(
	'languageselector' => 'Cezugun',
	'languageselector-desc' => 'Cezugun ñi zujipeyvm fijke aztapvl mew, keyv jajitufe',
	'languageselector-setlang' => 'zujipe',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Meno25
 */
$messages['arz'] = array(
	'languageselector' => 'اللغة',
	'languageselector-desc' => 'اختيار اللغة فى كل صفحة، أيضا للزائرين',
	'languageselector-setlang' => 'ضبط',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'languageselector' => 'Llingua',
	'languageselector-desc' => 'Selector de llingua en cada páxina, tamién pa visitantes',
	'languageselector-setlang' => 'establecer',
);

/** Bashkir (Башҡорт)
 * @author Рустам Нурыев
 */
$messages['ba'] = array(
	'languageselector' => 'Тышҡы күренештә ҡулланылған тел:',
	'languageselector-desc' => 'Һәр биткә йәки ҡулланыусыға телде һайларға',
	'languageselector-setlang' => 'Билдәләргә',
);

/** Bavarian (Boarisch)
 * @author Man77
 */
$messages['bar'] = array(
	'languageselector' => 'Språch',
	'languageselector-desc' => 'Språchnauswåih auf jeda Seitn, aa fia Bsuacha',
	'languageselector-setlang' => 'setzn',
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author Jim-by
 * @author Red Winged Duck
 */
$messages['be-tarask'] = array(
	'languageselector' => 'Мова',
	'languageselector-desc' => 'Выбар мовы на кожнай старонцы, таксама і для наведвальнікаў',
	'languageselector-setlang' => 'усталяваць',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'languageselector' => 'Език',
);

/** Bengali (বাংলা)
 * @author Bellayet
 */
$messages['bn'] = array(
	'languageselector' => 'ভাষা',
	'languageselector-desc' => 'প্রতি পাতায় ভাষা নির্বাচক, পরিদর্শকের জন্যেও',
	'languageselector-setlang' => 'স্থাপন',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'languageselector' => 'Yezh',
	'languageselector-desc' => 'Dibaber yezhoù war pep pajenn, evit ar weladennerien zoken.',
	'languageselector-setlang' => 'Termeniñ',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'languageselector' => 'Jezik',
	'languageselector-desc' => 'Odabir jezika na svakoj stranici, također i za posjetioce',
	'languageselector-setlang' => 'postavi',
);

/** Catalan (Català)
 * @author Jordi Roqué
 * @author SMP
 */
$messages['ca'] = array(
	'languageselector' => 'Idioma',
	'languageselector-desc' => "Selector d'idioma a cada pàgina (incloent visitants anònims)",
	'languageselector-setlang' => 'selecciona',
);

/** Sorani (Arabic script) (‫کوردی (عەرەبی)‬)
 * @author Marmzok
 * @author رزگار
 */
$messages['ckb-arab'] = array(
	'languageselector' => 'زمان',
	'languageselector-desc' => 'ھەڵبژێری زمان لە ھەموو پەڕەکان، ھەروەھا بۆ بینەران',
	'languageselector-setlang' => 'داینێ',
);

/** Czech (Česky)
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'languageselector' => 'Jazyk',
	'languageselector-desc' => 'Výběr jazyka na každé straně, také pro návštěvníky',
	'languageselector-setlang' => 'nastavit',
);

/** Kashubian (Kaszëbsczi)
 * @author Kaszeba
 */
$messages['csb'] = array(
	'languageselector' => 'Jãzëk',
	'languageselector-desc' => 'Wëbiérk jãzëka na kòżdi starnie, a téż dlô gòsców',
	'languageselector-setlang' => 'nastôwi',
);

/** Church Slavic (Словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'languageselector' => 'ѩꙁꙑ́къ',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'languageselector' => 'Iaith',
	'languageselector-desc' => 'Yn gosod botwm dewis iaith ar bob tudalen, sydd ar gael i ymwelwyr hefyd',
	'languageselector-setlang' => 'gosod',
);

/** Danish (Dansk)
 * @author Jon Harald Søby
 */
$messages['da'] = array(
	'languageselector' => 'Sprog',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Raimond Spekking
 */
$messages['de'] = array(
	'languageselector' => 'Sprache',
	'languageselector-desc' => 'Sprachenauswahl auf jeder Seite, auch für Besucher',
	'languageselector-setlang' => 'setzen',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'languageselector' => 'Rěc',
	'languageselector-desc' => 'Wuběrk rěcy na kuždem boku, teke za wobglědarjow',
	'languageselector-setlang' => 'stajiś',
);

/** Ewe (Eʋegbe)
 * @author Natsubee
 */
$messages['ee'] = array(
	'languageselector' => 'Gbe',
	'languageselector-desc' => 'Gbe tiala le axa ɖesiaɖe dzi, na ŋkɔmaŋlɔlawo hã',
	'languageselector-setlang' => 'wɔe',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'languageselector' => 'Γλώσσα',
	'languageselector-desc' => 'Επιλογέας γλώσσας σε κάθε σελίδα, το ίδιο και για τους επισκέπτες',
	'languageselector-setlang' => 'ρύθμιση',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'languageselector' => 'Lingvo',
	'languageselector-desc' => 'Lingvo-selektilo en ĉiuj paĝo, ankaŭ por vizitantoj',
	'languageselector-setlang' => 'fari',
);

/** Spanish (Español)
 * @author Sanbec
 */
$messages['es'] = array(
	'languageselector' => 'Idioma',
	'languageselector-desc' => 'Selector de idioma en cada página, incluso para visitantes',
	'languageselector-setlang' => 'selecciona',
);

/** Estonian (Eesti)
 * @author Silvar
 */
$messages['et'] = array(
	'languageselector' => 'Keel',
	'languageselector-desc' => 'Keele valik kõikidele lehtedele, sama ka külastajatele',
	'languageselector-setlang' => 'vali',
);

/** Basque (Euskara)
 * @author Theklan
 */
$messages['eu'] = array(
	'languageselector' => 'Hizkuntza',
	'languageselector-desc' => 'Orrialde guztietako hizkuntza aukeraketa, baita bisitarientzat ere',
	'languageselector-setlang' => 'ezarri',
);

/** Extremaduran (Estremeñu)
 * @author Better
 */
$messages['ext'] = array(
	'languageselector' => 'Palra',
	'languageselector-setlang' => 'Acetal',
);

/** Persian (فارسی)
 * @author Huji
 * @author Vahid
 */
$messages['fa'] = array(
	'languageselector' => 'زبان',
	'languageselector-desc' => 'انتخاب کنندهٔ زبان در همهٔ صفحه‌ها باشد، و نیز برای مشاهده کنندگان',
	'languageselector-setlang' => 'اعمال',
);

/** Finnish (Suomi)
 * @author Crt
 * @author Nike
 */
$messages['fi'] = array(
	'languageselector' => 'Kieli',
	'languageselector-desc' => 'Kielen valinta jokaisella sivulla, myös vierailijoille.',
	'languageselector-setlang' => 'aseta',
);

/** French (Français)
 * @author Bertrand GRONDIN
 */
$messages['fr'] = array(
	'languageselector' => 'Langue',
	'languageselector-desc' => 'Sélecteur de langue sur chaque page, même pour les visiteurs.',
	'languageselector-setlang' => 'Définir',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'languageselector' => 'Lengoua',
	'languageselector-desc' => 'Chouèx de lengoua sur châque pâge, por los visitors avouéc.',
	'languageselector-setlang' => 'Dèfenir',
);

/** Galician (Galego)
 * @author Alma
 * @author Toliño
 */
$messages['gl'] = array(
	'languageselector' => 'Lingua',
	'languageselector-desc' => 'Seleccionador da lingua en todas as páxinas, tamén para os visitantes',
	'languageselector-setlang' => 'elixir',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'languageselector' => 'Γλῶττα',
	'languageselector-desc' => 'Ἐπιλογεὺς γλῶττας ἐν πἀσαις δέλτοις, τῶν ἐπισκεπτῶν συμπεριλαμβανομένων',
	'languageselector-setlang' => 'τιθέναι',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'languageselector' => 'Sproch',
	'languageselector-desc' => 'Sprochenuuswahl uf jedere Syte, au fir Bsuecher',
	'languageselector-setlang' => 'setze',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'languageselector' => 'Çhengey',
	'languageselector-desc' => 'Reihder çhengey er dagh ooilley ghuillag, gys sleih er keayrt myrgeddin',
	'languageselector-setlang' => 'soiaghey',
);

/** Hawaiian (Hawai`i)
 * @author Kalani
 */
$messages['haw'] = array(
	'languageselector' => 'ʻŌlelo',
);

/** Hebrew (עברית)
 * @author Agbad
 * @author Rotemliss
 */
$messages['he'] = array(
	'languageselector' => 'שפה',
	'languageselector-desc' => 'אפשרות בחירת שפה בכל דף, גם למבקרים',
	'languageselector-setlang' => 'בחירה',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'languageselector' => 'भाषा',
	'languageselector-desc' => 'हर पन्नेपर भाषा-सिलेक्टर, भेंट देनेवालोंके लिये भी',
	'languageselector-setlang' => 'सैट करें',
);

/** Croatian (Hrvatski)
 * @author Ex13
 */
$messages['hr'] = array(
	'languageselector' => 'Jezik',
	'languageselector-desc' => 'Jezični izbornik na svakoj stranici, također i za posjetitelje',
	'languageselector-setlang' => 'postavi',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'languageselector' => 'Rěč',
	'languageselector-desc' => 'Wuběr rěčow na kóždej stronje, tež za wopytowarjow',
	'languageselector-setlang' => 'stajić',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Dorgan
 */
$messages['hu'] = array(
	'languageselector' => 'Nyelv',
	'languageselector-desc' => 'Nyelvválasztó minden lapon, látogatók számára is',
	'languageselector-setlang' => 'beállítás',
);

/** Interlingua (Interlingua)
 * @author Malafaya
 * @author McDutchie
 */
$messages['ia'] = array(
	'languageselector' => 'Lingua',
	'languageselector-desc' => 'Selector de lingua in omne pagina, etiam pro visitatores',
	'languageselector-setlang' => 'seliger',
);

/** Indonesian (Bahasa Indonesia)
 * @author Rex
 */
$messages['id'] = array(
	'languageselector' => 'Bahasa',
	'languageselector-desc' => 'Menambahkan pemilih bahasa di setiap halaman, juga untuk pengunjung',
	'languageselector-setlang' => 'set',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'languageselector' => 'Linguo',
	'languageselector-setlang' => 'establisar',
);

/** Icelandic (Íslenska) */
$messages['is'] = array(
	'languageselector' => 'Tungumál',
);

/** Italian (Italiano)
 * @author Darth Kule
 * @author Nemo bis
 */
$messages['it'] = array(
	'languageselector' => 'Lingua',
	'languageselector-desc' => 'Selettore della lingua in tutte le pagine, anche per gli ospiti',
	'languageselector-setlang' => 'imposta',
);

/** Japanese (日本語)
 * @author JtFuruhata
 */
$messages['ja'] = array(
	'languageselector' => '言語選択',
	'languageselector-desc' => 'ログイン状況を問わず利用できる、各ページの言語選択機能',
	'languageselector-setlang' => '設定',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'languageselector' => 'Basa',
	'languageselector-desc' => 'Pamilih basa ana ing saben kaca, uga kanggo tamu',
	'languageselector-setlang' => 'sèt',
);

/** Georgian (ქართული)
 * @author Temuri rajavi
 */
$messages['ka'] = array(
	'languageselector' => 'ენა',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬)
 * @author AlefZet
 */
$messages['kk-arab'] = array(
	'languageselector' => 'تٸل',
	'languageselector-setlang' => 'انىقتاۋ',
);

/** Kazakh (Cyrillic) (Қазақша (Cyrillic)) */
$messages['kk-cyrl'] = array(
	'languageselector' => 'Тіл',
	'languageselector-setlang' => 'анықтау',
);

/** Kazakh (Latin) (Қазақша (Latin)) */
$messages['kk-latn'] = array(
	'languageselector' => 'Til',
	'languageselector-setlang' => 'anıqtaw',
);

/** Kalaallisut (Kalaallisut)
 * @author Qaqqalik
 */
$messages['kl'] = array(
	'languageselector' => 'Oqaatsit',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'languageselector' => 'ភាសា',
	'languageselector-desc' => 'ឧបករណ៍​ជ្រើសយក​ភាសា​លើ​​រាល់ទំព័រ, សម្រាប់​អ្នកទស្សនា​ផងដែរ',
	'languageselector-setlang' => 'ប្តូរ',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'languageselector' => 'ಭಾಷೆ',
);

/** Korean (한국어)
 * @author Kwj2772
 */
$messages['ko'] = array(
	'languageselector' => '언어',
	'languageselector-desc' => '방문자에게도 모든 문서에 언어 선택기를 추가',
	'languageselector-setlang' => '설정',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'languageselector' => 'Sproch',
	'languageselector-desc' => 'Shprooche-Wahl op jede Sigk, och för namelose Metmaacher, un oohne Aanmëllde.',
	'languageselector-setlang' => 'Setze',
);

/** Cornish (Kernewek)
 * @author Kw-Moon
 */
$messages['kw'] = array(
	'languageselector' => 'Yeth',
);

/** Latin (Latina)
 * @author SPQRobin
 */
$messages['la'] = array(
	'languageselector' => 'Lingua',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'languageselector' => 'Sprooch',
	'languageselector-desc' => 'Wiel vun der Sprooch op all Säit, och fir Visiteuren.',
	'languageselector-setlang' => 'Wielt',
);

/** Ganda (Luganda)
 * @author Kizito
 */
$messages['lg'] = array(
	'languageselector' => 'Lulimi',
	'languageselector-desc' => "Buli alaba olupapula abe ng'asobola okwerondera lulimi mw'alusomera",
	'languageselector-setlang' => 'lukakase',
);

/** Limburgish (Limburgs)
 * @author Aelske
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'languageselector' => 'Taal',
	'languageselector-desc' => 'Taalselectie op eder pagina, ouch veur gebroekers die neet aangemeld zin',
	'languageselector-setlang' => 'instèlle',
);

/** Lithuanian (Lietuvių)
 * @author Hugo.arg
 */
$messages['lt'] = array(
	'languageselector' => 'Kalba',
	'languageselector-setlang' => 'nustatyti',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'languageselector' => 'Јазик',
	'languageselector-desc' => 'Избирач на јазик на секоја страница, исто така за посетители',
	'languageselector-setlang' => 'постави',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'languageselector' => 'ഭാഷ',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'languageselector' => 'भाषा',
	'languageselector-desc' => 'प्रत्येक पानावर भाषा-निवडक (selector), भेट देणार्‍यांसाठी सुद्धा',
	'languageselector-setlang' => 'सेट (set)',
);

/** Malay (Bahasa Melayu)
 * @author Zamwan
 */
$messages['ms'] = array(
	'languageselector' => 'Bahasa',
	'languageselector-desc' => 'Pilihan bahasa pada setiap laman, termasuk untuk para pelawat.',
	'languageselector-setlang' => 'set',
);

/** Maltese (Malti)
 * @author Roderick Mallia
 */
$messages['mt'] = array(
	'languageselector' => 'Lingwa',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'languageselector' => 'Кель',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'languageselector' => 'Tlahtōlli',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'languageselector' => 'Spraak',
	'languageselector-setlang' => 'setten',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 */
$messages['nl'] = array(
	'languageselector' => 'Taal',
	'languageselector-desc' => 'Taalselectie op iedere pagina, ook voor gebruikers die niet aangemeld zijn',
	'languageselector-setlang' => 'instellen',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 * @author Jon Harald Søby
 */
$messages['nn'] = array(
	'languageselector' => 'Språk',
	'languageselector-desc' => 'Spåkveljar på kvar sida, òg for gjester',
	'languageselector-setlang' => 'set',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'languageselector' => 'Språk',
	'languageselector-desc' => 'Valg av språk på alle sider, også for gjester',
	'languageselector-setlang' => 'sett',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'languageselector' => 'Polelo',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'languageselector' => 'Lenga',
	'languageselector-desc' => 'Selector de lenga sus cada pagina, quitament pels visitaires.',
	'languageselector-setlang' => 'Definir',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'languageselector' => 'Æвзаг',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'languageselector' => 'Schprooch',
);

/** Polish (Polski)
 * @author McMonster
 * @author Wpedzich
 */
$messages['pl'] = array(
	'languageselector' => 'Język',
	'languageselector-desc' => 'Wybór języka dla każdej strony, również dla osób odwiedzających',
	'languageselector-setlang' => 'ustaw',
);

/** Piedmontese (Piemontèis)
 * @author Dragonòt
 */
$messages['pms'] = array(
	'languageselector' => 'Lenga',
	'languageselector-desc' => 'Seletor ëd la lenga an dzora a mincadun-a pàgina, ëdcò për ij visitador',
	'languageselector-setlang' => 'Ampòsta',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'languageselector' => 'ژبه',
	'languageselector-desc' => 'د ژب ټاکنې پټه دې په هر مخ وي، د کتونکو لپاره هم',
	'languageselector-setlang' => 'ټاکل',
);

/** Portuguese (Português)
 * @author 555
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'languageselector' => 'Língua',
	'languageselector-desc' => 'Selector de língua em todas as páginas, também para visitantes',
	'languageselector-setlang' => 'seleccionar',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 * @author MF-Warburg
 */
$messages['pt-br'] = array(
	'languageselector' => 'Idioma',
	'languageselector-desc' => 'Seletor de língua em todas as páginas, também para visitantes',
	'languageselector-setlang' => 'selecionar',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'languageselector' => 'Rimay',
	'languageselector-desc' => "Tukuy p'anqakunapi rimay akllana, watukuqkunapaqpas",
	'languageselector-setlang' => 'churay',
);

/** Romanian (Română)
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'languageselector' => 'Limbă',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'languageselector' => 'Lènghe',
	'languageselector-desc' => "'U selezzionatore de le lènghe sus a ogne pàgene, pure pe le visitature",
	'languageselector-setlang' => "'mboste",
);

/** Russian (Русский)
 * @author Kaganer
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'languageselector' => 'Язык',
	'languageselector-desc' => 'Выбор языка на каждой странице, доступный также и для посетителей',
	'languageselector-setlang' => 'установить',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'languageselector' => 'Омук тыла',
	'languageselector-desc' => 'Хас сирэй аайы омук тылын талыы баар, көрөөччүлэргэ эмиэ',
	'languageselector-setlang' => 'туруор',
);

/** Tachelhit (Tašlḥiyt)
 * @author Zanatos
 */
$messages['shi'] = array(
	'languageselector' => 'tutlayt',
);

/** Sinhala (සිංහල)
 * @author නන්දිමිතුරු
 */
$messages['si'] = array(
	'languageselector' => 'භාෂාව',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'languageselector' => 'Jazyk',
	'languageselector-desc' => 'Výber jazyka na každej stránke, aj pre návštevníkov',
	'languageselector-setlang' => 'nastaviť',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 * @author Smihael
 */
$messages['sl'] = array(
	'languageselector' => 'Jezik',
	'languageselector-desc' => 'Izbirnik jezika na vsaki strani, tudi za obiskovalce',
	'languageselector-setlang' => 'določi',
);

/** Lower Silesian (Schläsch)
 * @author Jonny84
 * @author Piotron
 */
$messages['sli'] = array(
	'languageselector' => 'Sproache',
	'languageselector-desc' => 'Sproachaauswoahl uff jeder Seite, au fier Besucher',
	'languageselector-setlang' => 'setza',
);

/** Serbian Cyrillic ekavian (Српски (ћирилица))
 * @author Sasa Stefanovic
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'languageselector' => 'Језик',
	'languageselector-desc' => 'Избирач језика на сваком језику, и такође за посетиоце',
	'languageselector-setlang' => 'постави',
);

/** Serbian Latin ekavian (Srpski (latinica))
 * @author Michaello
 */
$messages['sr-el'] = array(
	'languageselector' => 'Jezik',
	'languageselector-desc' => 'Izbirač jezika na svakom jeziku, i takođe za posetioce',
	'languageselector-setlang' => 'postavi',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'languageselector' => 'Sproake',
	'languageselector-desc' => 'Sproakenuutwoal ap älke Siede, uk foar Besäikere',
	'languageselector-setlang' => 'sätte',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 */
$messages['su'] = array(
	'languageselector' => 'Basa',
	'languageselector-desc' => 'Pilihan basa keur kabeh kaca, ogé keur nu sindang',
	'languageselector-setlang' => 'set',
);

/** Swedish (Svenska)
 * @author Lejonel
 * @author M.M.S.
 */
$messages['sv'] = array(
	'languageselector' => 'Språk',
	'languageselector-desc' => 'Språkväljare på varje sida, också för besökare',
	'languageselector-setlang' => 'välj',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'languageselector' => 'భాష',
	'languageselector-desc' => 'ప్రతీ పేజీలోనూ భాషా ఎంపిక, సందర్శకులకు కూడా',
	'languageselector-setlang' => 'అమర్చు',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'languageselector' => 'Lian',
	'languageselector-desc' => 'Hili lian iha pájina hotu, mós ba vizitante',
	'languageselector-setlang' => 'hili',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'languageselector' => 'Забон',
	'languageselector-desc' => 'Забон интихобкунанда дар ҳар саҳифа, барои ташрифоварандагон низ',
);

/** Tajik (Latin) (Тоҷикӣ (Latin))
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'languageselector' => 'Zabon',
	'languageselector-desc' => 'Zabon intixobkunanda dar har sahifa, baroi taşrifovarandagon niz',
);

/** Thai (ไทย)
 * @author Passawuth
 */
$messages['th'] = array(
	'languageselector' => 'ภาษา',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'languageselector' => 'Dil',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'languageselector' => 'Wika',
	'languageselector-desc' => 'Pampili ng wika na nasa ibabaw ng bawat pahina, para rin sa mga panauhin',
	'languageselector-setlang' => 'itakda',
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 */
$messages['tr'] = array(
	'languageselector' => 'Dil',
	'languageselector-desc' => 'Her sayfada dil seçicisi, aynı zamanda ziyaretçiler için',
	'languageselector-setlang' => 'ayar',
);

/** Uighur (Latin) (Uyghurche‎ / ئۇيغۇرچە (Latin))
 * @author Jose77
 */
$messages['ug-latn'] = array(
	'languageselector' => 'Til',
);

/** Ukrainian (Українська)
 * @author AS
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'languageselector' => 'Мова',
	'languageselector-desc' => 'Вибір мови на кожній сторінці, а також для відвідувачів',
	'languageselector-setlang' => 'встановити',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'languageselector' => 'Lengua',
	'languageselector-desc' => 'Un seletor de la lengua su tute le pagine, anca par i visitatori',
	'languageselector-setlang' => 'selessiona',
);

/** Veps (Vepsan kel')
 * @author Triple-ADHD-AS
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'languageselector' => 'Kel’',
	'languageselector-desc' => 'Kelen valičend kaikuččen lehtpolen täht, mugažo adivoile-ki.',
	'languageselector-setlang' => 'panda',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 */
$messages['vi'] = array(
	'languageselector' => 'Ngôn ngữ',
	'languageselector-desc' => 'Hộp để chọn ngôn ngữ ở các trang, cũng được cung cấp cho những người vô danh',
	'languageselector-setlang' => 'đổi',
);

/** Volapük (Volapük)
 * @author Malafaya
 */
$messages['vo'] = array(
	'languageselector' => 'Pük',
);

/** Cantonese (粵語)
 * @author Shinjiman
 */
$messages['yue'] = array(
	'languageselector' => '語言',
	'languageselector-setlang' => '設',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author PhiLiP
 * @author Shinjiman
 */
$messages['zh-hans'] = array(
	'languageselector' => '语言',
	'languageselector-desc' => '在每一页面上添加语言选择项，对匿名访问者亦有效',
	'languageselector-setlang' => '设置',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Liangent
 * @author Shinjiman
 */
$messages['zh-hant'] = array(
	'languageselector' => '語言',
	'languageselector-desc' => '在每一頁面上添加語言選擇項，對匿名訪問者亦有效',
	'languageselector-setlang' => '設定',
);

