/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_PROPERTYSCHEMA_H
#define MEDIASCANNER_PROPERTYSCHEMA_H

// Media Scanner
#include "mediascanner/property.h"

namespace mediascanner {
namespace schema {

// Generic Properties //////////////////////////////////////////////////////////

// Public playback URL of the media, taken from GStreamer
struct ExternalUrl : public StringProperty { ExternalUrl(); }
extern const kExternalUrl;

// Home page URL of the media, taken from GStreamer
struct HomepageUrl : public StringProperty { HomepageUrl(); }
extern const kHomepageUrl;

// Author of the media, taken from Internet
struct Author : public TextProperty { Author(); }
extern const kAuthor;

// License of the media, taken from Internet
struct License : public StringProperty { License(); }
extern const kLicense;

// Copyright of the media, taken from Internet
struct Copyright : public StringProperty { Copyright(); }
extern const kCopyright;

struct CopyrightUri : public StringProperty { CopyrightUri(); }
extern const kCopyrightUri;

struct LicenseUri : public StringProperty { LicenseUri(); }
extern const kLicenseUri;

// Description of the media, taken from Internet
struct Description : public TextProperty { Description(); }
extern const kDescription;

// Rating of the media, taken from Internet and User
struct Rating : public NumericProperty<double> { Rating(); }
extern const kRating;

// Title of the media, taken from Internet
struct Title : public TextProperty { Title(); }
extern const kTitle;

// Original, untranslated title of the media, taken from Internet
struct OriginalTitle : public TextProperty { OriginalTitle(); }
extern const kOriginalTitle;

// Age certification of the media, taken from Internet
struct Certification : public StringProperty { Certification(); }
extern const kCertification;

// Region of an age certification
struct Region : public StringProperty { Region(); }
extern const kRegion;

// Comments of the media, taken from Internet
struct Comment : public TextProperty { Comment(); }
extern const kComment;

// Keywords of the media, taken from Internet and User
struct Keyword : public StringProperty { Keyword(); }
extern const kKeyword;

// Languages of the media, taken from Internet
struct Language : public StringProperty { Language(); }
extern const kLanguage;

struct Version : public StringProperty { Version(); }
extern const kVersion;

struct Organization : public StringProperty { Organization(); }
extern const kOrganization;

struct Contact : public StringProperty { Contact(); }
extern const kContact;

struct Grouping : public StringProperty { Grouping(); }
extern const kGrouping;

struct ApplicationName : public StringProperty { ApplicationName(); }
extern const kApplicationName;

struct Favourite : public NumericProperty<bool> { Favourite(); }
extern const kFavourite;

// File Properties /////////////////////////////////////////////////////////////

// Local URL of the media, taken from File System
struct Url : public StringProperty { Url(); }
extern const kUrl;

// Last-change identifier of the media, taken from File System
struct ETag : public StringProperty { ETag(); }
extern const kETag;

// MIME type of the media, taken from GStreamer
struct MimeType : public StringProperty { MimeType(); }
extern const kMimeType;

// Last modification time of the media, taken from File System
struct LastModified : public DateTimeProperty { LastModified(); }
extern const kLastModified;

// File size of the media, taken from File System
struct FileSize : public NumericProperty<uint64_t> { FileSize(); }
extern const kFileSize;

// Last accessed time of the media, taken from File System
struct LastAccessed : public DateTimeProperty { LastAccessed(); }
extern const kLastAccessed;

// Media Properties ////////////////////////////////////////////////////////////

// Duration of the media, taken from GStreamer
struct Duration : public NumericProperty<int32_t> { Duration(); }
extern const kDuration;

// Seekability of the media, taken from GStreamer
struct Seekable : public NumericProperty<bool> { Seekable(); }
extern const kSeekable;

// Last played time of the media, taken from Client Apps
struct LastPlayed : public DateTimeProperty { LastPlayed(); }
extern const kLastPlayed;

// Play count of the media, taken from Client Apps
struct PlayCount : public NumericProperty<int32_t> { PlayCount(); }
extern const kPlayCount;

// Last playing position of the media, taken from Client Apps
struct LastPosition : public NumericProperty<int32_t> { LastPosition(); }
extern const kLastPosition;

// Producer of the media, taken from Internet
struct Producer : public TextProperty { Producer(); }
extern const kProducer;

// Performer of the media, taken from Internet
struct Performer : public TextProperty { Performer(); }
extern const kPerformer;

// Cover URLs for the media, taken from Internet
struct Cover : public StringProperty { Cover(); }
extern const kCover;

// Poster URLs for the media, taken from Internet
struct Poster : public StringProperty { Poster(); }
extern const kPoster;

// Date when the media was first published
struct PublicationDate : public DateTimeProperty { PublicationDate(); }
extern const kPublicationDate;

// Date when the media was first published
struct Studio : public StringProperty { Studio(); }
extern const kStudio;

// Genre of the media, taken from GStreamer
struct Genre : public StringProperty { Genre(); }
extern const kGenre;

struct EncodedBy : public StringProperty { EncodedBy(); }
extern const kEncodedBy;

struct ContainerFormat : public StringProperty { ContainerFormat(); }
extern const kContainerFormat;

struct Encoder : public StringProperty { Encoder(); }
extern const kEncoder;

struct EncoderVersion : public NumericProperty<int32_t>  { EncoderVersion(); }
extern const kEncoderVersion;

// Music Properties ////////////////////////////////////////////////////////////

// Bitrate of the audio, taken from GStreamer
struct AudioBitRate : public NumericProperty<int32_t> { AudioBitRate(); }
extern const kAudioBitRate;

// Maximum bitrate of the audio, taken from GStreamer
struct MaximumAudioBitRate
        : public NumericProperty<int32_t> { MaximumAudioBitRate(); }
extern const kMaximumAudioBitRate;

// Codec of the audio, taken from GStreamer
struct AudioCodec : public StringProperty { AudioCodec(); }
extern const kAudioCodec;

// Sample rate of the audio, taken from GStreamer
struct SampleRate : public NumericProperty<int32_t> { SampleRate(); }
extern const kSampleRate;

// Channel count of the audio, taken from GStreamer
struct ChannelCount : public NumericProperty<int32_t> { ChannelCount(); }
extern const kChannelCount;

// Album artist of the audio, taken from GStreamer
struct AlbumArtist : public TextProperty { AlbumArtist(); }
extern const kAlbumArtist;

// Composer of the audio, taken from GStreamer
struct Composer : public TextProperty { Composer(); }
extern const kComposer;

// Track count of the audio, taken from GStreamer
struct TrackCount : public NumericProperty<int32_t> { TrackCount(); }
extern const kTrackCount;

// Disc number of the audio, taken from GStreamer
struct DiscNumber : public NumericProperty<int32_t> { DiscNumber(); }
extern const kDiscNumber;

// Artist of the music, taken from GStreamer
struct Artist : public TextProperty { Artist(); }
extern const kArtist;

// Album of the music, taken from GStreamer
struct Album : public TextProperty { Album(); }
extern const kAlbum;

// Lyrics of the music, taken from GStreamer
struct Lyrics : public TextProperty { Lyrics(); }
extern const kLyrics;

// Track number of the music, taken from GStreamer
struct TrackNumber : public NumericProperty<int32_t> { TrackNumber(); }
extern const kTrackNumber;

struct AlbumVolumeNumber
        : public NumericProperty<int32_t> { AlbumVolumeNumber(); }
extern const kAlbumVolumeNumber;

struct AlbumVolumeCount
        : public NumericProperty<int32_t> { AlbumVolumeCount(); }
extern const kAlbumVolumeCount;

struct ISRC : public StringProperty { ISRC(); }
extern const kISRC;

struct TrackGain : public NumericProperty<double> { TrackGain(); }
extern const kTrackGain;

struct TrackPeak : public NumericProperty<double> { TrackPeak(); }
extern const kTrackPeak;

struct AlbumGain : public NumericProperty<double> { AlbumGain(); }
extern const kAlbumGain;

struct AlbumPeak : public NumericProperty<double> { AlbumPeak(); }
extern const kAlbumPeak;

struct ReferenceLevel : public NumericProperty<double> { ReferenceLevel(); }
extern const kReferenceLevel;

struct BeatsPerMinute : public NumericProperty<double> { BeatsPerMinute(); }
extern const kBeatsPerMinute;

// Image Properties ////////////////////////////////////////////////////////////

// Width of the media, taken from GStreamer
struct Width : public NumericProperty<int32_t> { Width(); }
extern const kWidth;

// Height of the media, taken from GStreamer
struct Height : public NumericProperty<int32_t> { Height(); }
extern const kHeight;

// Orientation of the image, taken from GStreamer/EXIF
struct ImageOrientation : public StringProperty {
    class Private;
    ImageOrientation();
} extern const kImageOrientation;

struct HorizontalResolution
        : public NumericProperty<double> { HorizontalResolution(); }
extern const kHorizontalResolution;

struct VerticalResolution
        : public NumericProperty<double> { VerticalResolution(); }
extern const kVerticalResolution;

// Photo Properties ////////////////////////////////////////////////////////////

// Date taken of the photo, taken from GStreamer/EXIF
struct DateTaken : public DateTimeProperty { DateTaken(); }
extern const kDateTaken;

// Camera model of the photo, taken from GStreamer/EXIF
struct DeviceModel : public TextProperty { DeviceModel(); }
extern const kDeviceModel;

// ISO speed of the photo, taken from GStreamer/EXIF
struct IsoSpeed : public NumericProperty<double> { IsoSpeed(); }
extern const kIsoSpeed;

// Exposure time of the photo, taken from GStreamer/EXIF
struct ExposureTime : public NumericProperty<Fraction> { ExposureTime(); }
extern const kExposureTime;

// Flash used of the photo, taken from GStreamer/EXIF
struct FlashUsed : public NumericProperty<bool> { FlashUsed(); }
extern const kFlashUsed;

// Camera manufacturer of the photo, taken from GStreamer/EXIF
struct DeviceManufacturer : public TextProperty { DeviceManufacturer(); }
extern const kDeviceManufacturer;

// Focal ratio of the photo, taken from GStreamer/EXIF
struct FocalRatio : public NumericProperty<double> { FocalRatio(); }
extern const kFocalRatio;

// Focal length of the photo, taken from GStreamer/EXIF
struct FocalLength : public NumericProperty<double> { FocalLength(); }
extern const kFocalLength;

// Metering mode of the photo, taken from GStreamer/EXIF
struct MeteringMode : public StringProperty { MeteringMode(); }
extern const kMeteringMode;

// White balance of the photo, taken from GStreamer/EXIF
struct WhiteBalance : public StringProperty { WhiteBalance(); }
extern const kWhiteBalance;

struct GeoLocationName : public StringProperty { GeoLocationName(); }
extern const kGeoLocationName;

struct GeoLocationLatitude
        : public NumericProperty<double> { GeoLocationLatitude(); }
extern const kGeoLocationLatitude;

struct GeoLocationLongitude
        : public NumericProperty<double> { GeoLocationLongitude(); }
extern const kGeoLocationLongitude;

struct GeoLocationElevation
        : public NumericProperty<double> { GeoLocationElevation(); }
extern const kGeoLocationElevation;

struct GeoLocationCountry : public StringProperty { GeoLocationCountry(); }
extern const kGeoLocationCountry;

struct GeoLocationCity : public StringProperty { GeoLocationCity(); }
extern const kGeoLocationCity;

struct GeoLocationSublocation
        : public StringProperty { GeoLocationSublocation(); }
extern const kGeoLocationSublocation;

struct GeoLocationHorizontalError
        : public NumericProperty<double> { GeoLocationHorizontalError(); }
extern const kGeoLocationHorizontalError;

struct GeoLocationMovementSpeed
        : public NumericProperty<double> { GeoLocationMovementSpeed(); }
extern const kGeoLocationMovementSpeed;

struct GeoLocationMovementDirection
        : public NumericProperty<double> { GeoLocationMovementDirection(); }
extern const kGeoLocationMovementDirection;

struct GeoLocationCaptureDirection
        : public NumericProperty<double> { GeoLocationCaptureDirection(); }
extern const kGeoLocationCaptureDirection;

struct CapturingDigitalZoomRatio
        : public NumericProperty<double> { CapturingDigitalZoomRatio(); }
extern const kCapturingDigitalZoomRatio;

struct CapturingExposureProgram
        : public StringProperty { CapturingExposureProgram(); }
extern const kCapturingExposureProgram;

struct CapturingExposureMode
        : public StringProperty { CapturingExposureMode(); }
extern const kCapturingExposureMode;

struct CapturingExposureCompensation
        : public NumericProperty<double> { CapturingExposureCompensation(); }
extern const kCapturingExposureCompensation;

struct CapturingSceneCaptureType
        : public StringProperty { CapturingSceneCaptureType(); }
extern const kCapturingSceneCaptureType;

struct CapturingGainAdjustment
        : public StringProperty { CapturingGainAdjustment(); }
extern const kCapturingGainAdjustment;

struct CapturingContrast : public StringProperty { CapturingContrast(); }
extern const kCapturingContrast;

struct CapturingSaturation : public StringProperty { CapturingSaturation(); }
extern const kCapturingSaturation;

struct CapturingSharpness : public StringProperty { CapturingSharpness(); }
extern const kCapturingSharpness;

struct CapturingFlashMode : public StringProperty { CapturingFlashMode(); }
extern const kCapturingFlashMode;

struct CapturingSource : public StringProperty { CapturingSource(); }
extern const kCapturingSource;

// Movie Properties ////////////////////////////////////////////////////////////

// Frame rate of the video, taken from GStreamer
struct FrameRate : public NumericProperty<Fraction> { FrameRate(); }
extern const kFrameRate;

// Show of the video, taken from Internet
struct ShowName : public TextProperty { ShowName(); }
extern const kShowName;

// Episode of the video, taken from Internet
struct Episode : public NumericProperty<int32_t> { Episode(); }
extern const kEpisode;

// Season of the video, taken from Internet
struct Season : public NumericProperty<int32_t> { Season(); }
extern const kSeason;

// Backdrops of the video, taken from Internet
struct Backdrop : public StringProperty { Backdrop(); }
extern const kBackdrop;

// Codec of the video, taken from GStreamer
struct VideoCodec : public StringProperty { VideoCodec(); }
extern const kVideoCodec;

// Bitrate of the video, taken from GStreamer
struct VideoBitRate : public NumericProperty<int32_t> { VideoBitRate(); }
extern const kVideoBitRate;

// Maximum bitrate of the video, taken from GStreamer
struct MaximumVideoBitRate
        : public NumericProperty<int32_t> { MaximumVideoBitRate(); }
extern const kMaximumVideoBitRate;

// Director of the video, taken from Internet
struct Director : public TextProperty { Director(); }
extern const kDirector;

// Internet Movie Database ID, taken from TMDB
struct ImdbId : public StringProperty { ImdbId(); }
extern const kImdbId;

// The Movie Database ID, taken from TMDB
struct TmdbId : public StringProperty { TmdbId(); }
extern const kTmdbId;

} // namespace schema
} // namespace mediascanner

#endif // MEDIASCANNER_PROPERTYSCHEMA_H
