/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_DECLARATIONS_H
#define MEDIASCANNER_DECLARATIONS_H

// C Standard Library
#include <stdint.h>

// C++ Standard Library
#include <string>

#define NONCOPYABLE(classname) \
    classname(classname const &) = delete; \
    classname& operator=(classname const &) = delete

// Forward declarations of some types to avoid hard dependency on GLib,
// Grilo or Lucene++ to avoid hard dependencies for API users that don't
// use that features. Especially Lucene++ doesn't guarantee source
// compatibility.

typedef struct _GFile GFile;
typedef struct _GKeyFile GKeyFile;
typedef struct _GList GList;
typedef struct _GParamSpec GParamSpec;
typedef struct _GValue GValue;
typedef struct _GVariant GVariant;

typedef struct _GstDiscovererInfo GstDiscovererInfo;
typedef struct _GstDiscovererStreamInfo GstDiscovererStreamInfo;
typedef struct _GstDiscovererAudioInfo GstDiscovererAudioInfo;
typedef struct _GstDiscovererVideoInfo GstDiscovererVideoInfo;

typedef uint32_t GQuark;
typedef unsigned long GType; // NOLINT: runtime/int

typedef uint32_t GrlKeyID;

/*
 * This is horrible, you should never forward declare things
 * in the std namespace (or boost for that matter). Unfortunately
 * old code did this so the only short-to-medium term solution is
 * to do this.
 */
namespace std {

template<typename T> class shared_ptr;
}

namespace boost {

template<typename T> class shared_ptr;

namespace filesystem {

// template<class String, class Traits> class basic_path;
class path;

} // namespace filesystem

namespace locale {

template<typename T> class basic_format;

typedef basic_format<char> format;
typedef basic_format<wchar_t> wformat;

} // namespace locale
} // namespace boost

namespace Lucene {

template<typename> class Collection;

/*
 * These must be boost::shared_ptrs instead of std::shared_ptr
 * because they come from Lucene's headers.
 */
typedef boost::shared_ptr<class Analyzer> AnalyzerPtr;
typedef boost::shared_ptr<class Directory> DirectoryPtr;
typedef boost::shared_ptr<class Document> DocumentPtr;
typedef boost::shared_ptr<class Fieldable> FieldablePtr;
typedef boost::shared_ptr<class IndexReader> IndexReaderPtr;
typedef boost::shared_ptr<class IndexWriter> IndexWriterPtr;
typedef boost::shared_ptr<class Query> QueryPtr;
typedef boost::shared_ptr<class Term> TermPtr;

} // namespace Lucene

namespace mediascanner {
namespace internal {

template<typename T> struct CopyHelper;

} // namespace internal

class CommitPolicy;
class Filter;
class MediaIndex;
class MediaInfo;
class MediaRoot;
class MediaRootManager;
class MetadataResolver;
class RefreshPolicy;
class TaskManager;
class WritableMediaIndex;

template<typename T> class MediaIndexFacade;

template<typename T, typename CopyHelper = internal::CopyHelper<T> >
class Wrapper;

typedef std::shared_ptr<CommitPolicy> CommitPolicyPtr;
typedef std::shared_ptr<MediaRootManager> MediaRootManagerPtr;
typedef std::shared_ptr<MetadataResolver> MetadataResolverPtr;
typedef std::shared_ptr<TaskManager> TaskManagerPtr;

typedef boost::filesystem::path FileSystemPath;

} // namespace mediascanner

#endif // MEDIASCANNER_DECLARATIONS_H
