/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_TASKFACADES_H
#define MEDIASCANNER_TASKFACADES_H

// GLib
#include <glib.h>

// Boost C++
#include <boost/bind.hpp>
#include <boost/function.hpp>

// C++ Standard Library
#include <string>

// Media Scanner Library
#include "mediascanner/declarations.h"
#include "mediascanner/taskmanager.h"

namespace mediascanner {

template<typename MediaIndexType>
class MediaIndexFacade {
    NONCOPYABLE(MediaIndexFacade);
    class Private;

public:
    explicit MediaIndexFacade(MediaRootManagerPtr root_manager);
    explicit MediaIndexFacade(MediaRootManagerPtr root_manager,
                              const FileSystemPath &path);
    ~MediaIndexFacade();

    void set_media_index_path(const FileSystemPath &path);
    FileSystemPath media_index_path() const;

    MediaRootManagerPtr root_manager() const;

    typedef boost::function<void(MediaIndexType *media_index)> TaskFunction;
    typedef boost::function<void(const std::string &message)> ErrorFunction;

    TaskManager::TaskFunction bind(const TaskFunction &task,
                                   const ErrorFunction &report_error) {
        return boost::bind(&MediaIndexFacade::Run, this, task, report_error);
    }

protected:
    void Run(const TaskFunction &run_task, const ErrorFunction &report_error);

private:
    Private *const d;
};

} // namespace mediascanner

#endif // MEDIASCANNER_TASKFACADES_H
