#!/bin/sh -e

stampfile="$PWD/checkstyle-stamp"

if test "$1" = "--force-all"
then
    shift
    rm -f "$stampfile"
fi

if ! test -f "$stampfile"
then
    touch -t 197001010000 "$stampfile"
fi

basedir="$1"
python="${2:-python}"

if test -z "$basedir"
then
  echo "Usage: $0 BASEDIR" >&2
  exit 2
fi

cd "$basedir"

find docs src tests \
    -newer "$stampfile" \
    \( -name '*.cpp' -o -name '*.h' \) \
    -not -name enums.[ch] |
xargs -r "$python" tools/cpplint.py \
    --filter=-readability/streams,-whitespace/labels,-build/header_guard

touch "$stampfile"

"$python" tools/licensecheck.py
