/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include <boost/tuple/tuple_io.hpp>
#include <boost/variant.hpp>
#include <string>

#include "mediascanner/dbusservice.h"

using mediascanner::null_ptr;
using mediascanner::take;
using mediascanner::Wrapper;
using mediascanner::dbus::InterfaceProxy;
using mediascanner::dbus::MediaScannerProxy;
using boost::tuples::element;
using boost::tuples::null_type;

// FIXME(M2): This must be an automatic test

class TestProxy : public MediaScannerProxy {
protected:
    void connected() {
        GError *err = 0;
        std::cout << "Connected!" << std::endl;

         const std::string good_uri =
                "file:///home/mathias/Musik/"
                "Jim%20Pavloff%20-%20Voodoo%20People%20(tribute).mp3";

         {
             Wrapper<GVariant> param =
                     take(g_variant_new("(s)", good_uri.c_str()));

             Wrapper<GVariant> result =
                     take(g_dbus_proxy_call_sync(handle().get(),
                                                 "MediaInfoExists",
                                                 param.release(),
                                                 G_DBUS_CALL_FLAGS_NONE, -1,
                                                 null_ptr, &err));
             if (err) {
                 std::cout << "DBus error: " << err->message << std::endl;
                 return;
             }
             std::cout << g_variant_print(result.get(), true) << std::endl;
         }

         {
             Wrapper<GError> error;
             bool result = MediaInfoExists
                     [G_DBUS_CALL_FLAGS_NONE]
                     [boost::posix_time::minutes(1)]
                     [Wrapper<GCancellable>()]
                     (good_uri, error.out_param());
             std::cout << "media_info_exists:"
                       << result
                       << ", error: " << to_string(error)
                       << std::endl;
         }
    }
};

int main() {
    TestProxy proxy;

    proxy.connect();

    g_main_loop_run(take(g_main_loop_new(null_ptr, false)).get());

    return 0;
}
