/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_FILESYSTEMWALKER_H
#define MEDIASCANNER_FILESYSTEMWALKER_H

// Boost C++
#include <boost/noncopyable.hpp>

// Standard Library
#include <string>
#include <vector>

// Media Scanner Library
#include "mediascanner/declarations.h"

namespace mediascanner {

class FileSystemWalker : boost::noncopyable {
    class Private;

public:
    typedef MediaIndexFacade<WritableMediaIndex> TaskFacade;
    typedef boost::shared_ptr<TaskFacade> TaskFacadePtr;

    FileSystemWalker(const MediaRoot &media_root,
                     MetadataResolverPtr resolver,
                     TaskManagerPtr file_task_manager,
                     TaskManagerPtr index_task_manager,
                     TaskFacadePtr index_task_facade);
    ~FileSystemWalker();

    MediaRoot media_root() const;

    void set_file_monitor_enabled(bool enable);
    bool file_monitor_enabled() const;

    std::string error_message() const;
    bool is_cancelled() const;

    size_t task_group() const;

    bool start();
    void cancel();
    bool Join();

private:
    Private *const d;
};

} // namespace mediascanner

#endif // MEDIASCANNER_FILESYSTEMWALKER_H
