/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#ifndef MEDIASCANNER_FILESYSTEMSCANNER_H
#define MEDIASCANNER_FILESYSTEMSCANNER_H

// Boost C++
#include <boost/noncopyable.hpp>

// Standard Library
#include <string>
#include <vector>

// Media Scanner Library
#include "mediascanner/declarations.h"

namespace mediascanner {

class FileSystemScanner : boost::noncopyable {
    class Private;

public:
    class Listener {
    public:
        virtual ~Listener() { }
        virtual void OnScanningStarted() { }
        virtual void OnScanningFinished(const std::string &/*error_message*/) {
        }
    };

    typedef MediaIndexFacade<WritableMediaIndex> TaskFacade;
    typedef boost::shared_ptr<TaskFacade> TaskFacadePtr;

    FileSystemScanner(MetadataResolverPtr resolver,
                      TaskManagerPtr media_task_manager,
                      TaskFacadePtr media_task_facade);
    ~FileSystemScanner();

    void set_directories(const std::vector<std::string> &paths);
    bool add_directory(const std::string &path);
    bool remove_directory(const std::string &path);
    std::vector<std::string> directories() const;

    void add_listener(Listener *listener);
    void remove_listener(Listener *listener);

    void set_file_monitor_enabled(bool enable);
    bool file_monitor_enabled() const;

    bool start_scanning();
    bool is_idle() const;

private:
    Private *const d;
};

} // namespace mediascanner

#endif // MEDIASCANNER_FILESYSTEMSCANNER_H
