# Check for proper version of Lucene++

# =============================================================================
# Copyright (C) 2012 Canonical Ltd. - All Rights Reserved
# Contact: Jim Hodapp <jim.hodapp@canonical.com>
# =============================================================================

MACRO(CHECK_LUCENE_PLUSPLUS)
  INCLUDE(CheckCXXSourceCompiles)

  MESSAGE(STATUS "Checking features of Lucene++")

  # Backup include directories
  SET(_CMAKE_REQUIRED_INCLUDES_TMP ${CMAKE_REQUIRED_INCLUDES})
  SET(CMAKE_REQUIRED_INCLUDES ${CMAKE_REQUIRED_INCLUDES} ${DEPS_INCLUDE_DIRS})

  # Backup libraries
  SET(_CMAKE_REQUIRED_LIBRARIES_TMP ${CMAKE_REQUIRED_LIBRARIES})
  SET(CMAKE_REQUIRED_LIBRARIES ${CMAKE_REQUIRED_LIBRARIES} ${DEPS_LDFLAGS} ${Boost_LIBRARIES})

  # Build a small test program checking Lucene++ configuration
  CHECK_CXX_SOURCE_COMPILES(
    "
    #include <Lucene.h>
    #include <memory>

    int
    main()
    {
      #ifdef LPP_USE_ALLOCATOR
      #error Disable LPP_USE_ALLOCATOR in Lucene++
      #endif
      #ifndef LuceneAllocator
      #error LuceneAllocator is not defined
      #endif
      std::allocator<wchar_t>(LuceneAllocator<wchar_t>());
      LuceneAllocator<wchar_t>(std::allocator<wchar_t>());

      return 0;
    }
    "

    HAVE_LUCENE_WITH_STANDARD_ALLOCATOR)

  # Resource include directories and libraries
  SET(CMAKE_REQUIRED_INCLUDES ${_CMAKE_REQUIRED_INCLUDES_TMP})
  SET(CMAKE_REQUIRED_LIBRARIES ${_CMAKE_REQUIRED_LIBRARIES_TMP})

  # Report results
  IF(NOT HAVE_LUCENE_WITH_STANDARD_ALLOCATOR)
    MESSAGE(FATAL_ERROR
            "Please disable LPP_USE_ALLOCATOR in your Lucene++ build")
  ENDIF(NOT HAVE_LUCENE_WITH_STANDARD_ALLOCATOR)
ENDMACRO(CHECK_LUCENE_PLUSPLUS)


