/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

void
_MEDlocalizationRd30(int dummy, ...) {

  va_list params;
  va_start(params,dummy);

  const med_idt                 fid               = va_arg(params,const med_idt                  );
  const char*            const  localizationname  = va_arg(params,const char*            const   );
  const med_switch_mode         switchmode        = va_arg(params,const med_switch_mode          );
        med_float*       const  elementcoordinate = va_arg(params,      med_float*       const   );
        med_float*       const  ipointcoordinate  = va_arg(params,      med_float*       const   );
        med_float*       const  weight            = va_arg(params,      med_float*       const   );
  med_err *                     fret              = va_arg(params,      med_err *         );

  med_err _ret = -1;
  med_idt _lzid=0, _root=0;
  med_int _nentity=0,_nbofipoint=0,_spacedimension=0;
  med_int _intgeotype = -1;
  char    _path[MED_TAILLE_GAUSS+MED_NAME_SIZE+1]=MED_GAUSS;
  med_filter     _filter        = MED_FILTER_INIT;

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /*
   * MED_GAUSS_ELNO est un mot cle reserve
   */
  if (! strcmp(localizationname,MED_GAUSS_ELNO)) {
    MED_ERR_(_ret,MED_ERR_INVALID,MED_ERR_LOCALIZATION,localizationname);
    goto ERROR;
  }

  /*
   * Ouverture du dataGroup /GAUSS/
   */
  if ((_root = _MEDdatagroupOuvrir(fid,_path)) < 0) {
    MED_ERR_(_ret,MED_ERR_OPEN,MED_ERR_DATAGROUP,_path);
    goto ERROR;
  }

  NOFINALBLANK(localizationname,ERROR);
  /*
   * Ouverture du dataGroup  /GAUSS/<localizationname>
   */
  if ((_lzid = _MEDdatagroupOuvrir(_root,localizationname)) < 0) {
    MED_ERR_(_ret,MED_ERR_OPEN,MED_ERR_DATAGROUP,localizationname);
    SSCRUTE(_path);goto ERROR;
  }

  strcat(_path,localizationname);


  /*
   * On lit <nbofipoint> sous forme d'attribut
   */
  if (_MEDattrEntierLire(_lzid,MED_NOM_NBR,&_nbofipoint) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_LOCALIZATION_MSG);
    SSCRUTE(localizationname);SSCRUTE(MED_NOM_NBR);ISCRUTE(_nbofipoint);
    goto ERROR;
  }

  /*
   * On lit <typgeo> sous forme d'attribut
   */
  /* sizeof(enum) tjrs = sizeof(int) en C, or
     sur machines 64 bits par d�faut med_int==long,
     du coup sur  machines 64 bits _MEDattributeIntWr utilise 
     le type hdf NATIVE_LONG, ce qui pose un probl�me qd on passe
     un enum.
  */
  if (_MEDattrEntierLire(_lzid,MED_NOM_GEO,&_intgeotype) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_LOCALIZATION_MSG);
    SSCRUTE(localizationname);SSCRUTE(MED_NOM_GEO);ISCRUTE(_intgeotype);
    goto ERROR;
  };

  /*
   * On lit <spacedimension>
   */
  if (_MEDattrEntierLire(_lzid,MED_NOM_DIM,&_spacedimension) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_ATTRIBUTE,MED_ERR_LOCALIZATION_MSG);
    SSCRUTE(localizationname);SSCRUTE(MED_NOM_DIM);ISCRUTE(_spacedimension);
    goto ERROR;
  };


  /*
   * On lit les coordonn�es de r�f�rence dans un dataset
   */
  if ( ! ((_intgeotype > MED_STRUCT_GEO_INTERNAL    ) &&
	  (_intgeotype < MED_STRUCT_GEO_SUP_INTERNAL)    ) ) {

    _nentity = (_intgeotype%100);

    if ( MEDfilterEntityCr(fid,_nentity, 1, _spacedimension, MED_ALL_CONSTITUENT,
			   switchmode,MED_UNDEF_PFLMODE,
			   MED_NO_PROFILE, MED_UNDEF_SIZE, NULL, &_filter) < 0 ) {
      MED_ERR_(_ret,MED_ERR_CREATE,MED_ERR_FILTER,MED_ERR_INTERNAL_MSG);
      goto ERROR;
    }

    if ( _MEDdatasetRd(_lzid,MED_NOM_COO,MED_INTERNAL_FLOAT64,&_filter,
		       (unsigned char *) elementcoordinate) < 0) {
      MED_ERR_(_ret,MED_ERR_READ,MED_ERR_DATASET,MED_NOM_COO);SSCRUTE(_path);
      goto ERROR;
    }

    if ( MEDfilterClose(&_filter) < 0 ) {
      MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_FILTER,MED_ERR_LOCALIZATION_MSG); SSCRUTE(_path);
      goto ERROR;
    }
  }

  /*
   * On stocke les points d'int�gration dans un dataset
   */

  _nentity = _nbofipoint;
  if ( MEDfilterEntityCr(fid,_nentity, 1, _spacedimension, MED_ALL_CONSTITUENT,
			 switchmode,MED_UNDEF_PFLMODE,
			 MED_NO_PROFILE, MED_UNDEF_SIZE, NULL, &_filter) < 0 ) {
    MED_ERR_(_ret,MED_ERR_CREATE,MED_ERR_FILTER,MED_ERR_INTERNAL_MSG);
    goto ERROR;
  }

#ifdef _DEBUG_
    ISCRUTE((_filter).nbofentity              );
    ISCRUTE((_filter).nbofvaluesperentity     );
    ISCRUTE((_filter).nbofconstituentpervalue );
    ISCRUTE((_filter).constituentselect       );
    ISCRUTE_int((_filter).switchmode              );
    ISCRUTE((_filter).filterarraysize         );
    ISCRUTE((_filter).profilearraysize        );
    ISCRUTE_int((_filter).storagemode             );
    SSCRUTE((_filter).profilename             );
#endif

  if ( _MEDdatasetRd(_lzid,MED_NOM_GAU,MED_INTERNAL_FLOAT64,&_filter, 
		     (unsigned char *)  ipointcoordinate) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_DATASET,MED_NOM_GAU);SSCRUTE(_path);
    goto ERROR;
  }

  if ( MEDfilterClose(&_filter) < 0 ) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_FILTER,MED_ERR_LOCALIZATION_MSG); SSCRUTE(_path);
    goto ERROR;
  }

  /*
   * On stocke les poids dans un dataset
   */

  _nentity = _nbofipoint;
  if ( MEDfilterEntityCr(fid,_nentity, 1, 1, MED_ALL_CONSTITUENT,
			 switchmode,MED_UNDEF_PFLMODE,
			 MED_NO_PROFILE, MED_UNDEF_SIZE, NULL, &_filter) < 0 ) {
    MED_ERR_(_ret,MED_ERR_CREATE,MED_ERR_FILTER,MED_ERR_INTERNAL_MSG);
    goto ERROR;
  }

  if ( _MEDdatasetRd(_lzid,MED_NOM_VAL,MED_INTERNAL_FLOAT64,&_filter,
		     (unsigned char *) weight) < 0) {
    MED_ERR_(_ret,MED_ERR_READ,MED_ERR_DATASET,MED_NOM_VAL);SSCRUTE(_path);
    goto ERROR;
  }

  if ( MEDfilterClose(&_filter) < 0 ) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_FILTER,MED_ERR_LOCALIZATION_MSG); SSCRUTE(_path);
    goto ERROR;
  }


  _ret = 0;

 ERROR:

  if (_lzid>0)            if (_MEDdatagroupFermer(_lzid) < 0) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_DATAGROUP,localizationname);
    ISCRUTE_id(_lzid);
  }

  if (_root>0)            if (_MEDdatagroupFermer(_root) < 0) {
    MED_ERR_(_ret,MED_ERR_CLOSE,MED_ERR_DATAGROUP,MED_GAUSS);
    ISCRUTE_id(_root);
  }

  va_end(params);
  *fret = _ret;

  return;
}
