/*************************************************************************
 * COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
 * THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
 * IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
 * AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 *  
 * THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
 * WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
 * LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
 *
 * YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
 * ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
 * INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
 *
 *************************************************************************/

/* L'utilisation des med_utils n'est pas optionelle
   dans l'outil medimport, elle revet cependant deux
   formes :
   - Si -DWITH_EXCEPTION EXITIF renvoie une exception MEDerreur 
   - Sinon excute l'instruction return */

#define MESGERR


#ifdef HAVE_STDBOOL_H
# include <stdbool.h>
#else
# ifndef HAVE__BOOL
#  ifdef __cplusplus
typedef bool _Bool;
#  else
#   define _Bool signed char
#  endif
# endif
# define bool _Bool
# define false 0
# define true 1
# define __bool_true_false_are_defined 1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Pour faciliter la detection autotools */
int HAVE_MEDimport=1;

/*Inclusion des .h de la version de la bibliothque courante*/
#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <stdio.h>
#include <string.h>

#include <libgen.h>

#ifdef __cplusplus
}
#endif

/*Inclusion des .h spcifiques  medimport */

/* Interface publique de l'outil medimport */
/* MEDimport.h == MEDimport.hxx */
#include "MEDimport.h"

/* Interfaces prives  l'outil medimport  */
#include "MAJ_21_22.h"
#include "MAJ_231_232.h"


#ifdef __cplusplus
extern "C" void _MEDmodeErreurVerrouiller(void);
#endif


static void MAJ_version(med_idt fid)
{
  med_err ret;
  med_idt gid;
  med_int majeur, mineur, release;

  /* On ecrit le bon numero de version */
  majeur = MED_NUM_MAJEUR ;
  mineur = MED_NUM_MINEUR ;
  release = MED_NUM_RELEASE ;
  gid = _MEDdatagroupOuvrir(fid,MED_INFOS);
  if (gid < 0)
    gid = _MEDdatagroupCreer(fid,MED_INFOS);
  ret = _MEDattrEntierEcrire(gid,MED_NOM_MAJEUR,&majeur);
  EXIT_IF(ret < 0,"Ecriture du numro majeur",NULL);
  ret = _MEDattrEntierEcrire(gid,MED_NOM_MINEUR,&mineur);
  EXIT_IF(ret < 0,"Ecriture du numro mineur",NULL);
  ret = _MEDattrEntierEcrire(gid,MED_NOM_RELEASE,&release);
  EXIT_IF(ret < 0,"Ecrriture du numro de release",NULL);
  ret = _MEDdatagroupFermer(gid);
  EXIT_IF(ret < 0,"Fermeture du groupe HDF MED_INFOS",NULL);
}


int MEDimport(char * filein, char *  fileout) {

  med_idt fid, gid;
  med_err ret;
  med_int majeur, mineur, release;
  char *_fileout,*tmp;
  int   _fileoutsize;
  bool  hasfileout=false;
  char *commande;
  med_int nprofil;
  char chemin_profils[MED_TAILLE_PROFILS+1];
  char chemin_liens[MED_TAILLE_LIENS+1];
  char version[9];
  int MAJ_21_22 = 0, MAJ_231_232 = 0;

  hasfileout = strcmp(fileout,"");
  if ( hasfileout ) {
    _fileoutsize = strlen(fileout);
    _fileout     = fileout;
  } else {
    _fileoutsize = strlen(filein)+strlen("2.3");
    tmp          = (char *) malloc(sizeof(char)*(_fileoutsize+1));
    strcpy(tmp,filein);
    strcat(tmp,"2.3");
    EXIT_IF(_fileout == NULL,NULL,NULL);
    _fileout     = basename(tmp);
    _fileoutsize = strlen(_fileout);

  }
  
  /* Test du format du fichier */
  EXIT_IF(MEDformatConforme(filein) < 0,
	  "Le fichier d'entre n'est pas au format HDF 5 : ", filein);

  /* Creation et ouverture du fichier que l'on va convertir au format MED V2.3 */
  commande = (char *) malloc(sizeof(char)*(strlen("cp ")+strlen(filein)+
					   strlen(" ")+_fileoutsize + 4 +1  ) );
  EXIT_IF(commande == NULL,NULL,NULL);
  strcpy(commande,"cp \"");
  strcat(commande,filein);
  strcat(commande,"\" \"");
  strcat(commande,_fileout);
  strcat(commande,"\"");
  fprintf(stdout,">>> Creation du fichier %s : %s \n",_fileout,commande);
  system(commande);
  free(commande);
  commande = (char *) malloc(sizeof(char)*(strlen("chmod u+w \"") + _fileoutsize +1 +1  ) );
  EXIT_IF(commande == NULL,NULL,NULL);
  strcpy(commande,"chmod u+w \"");
  strcat(commande,_fileout);
  strcat(commande,"\"");
  fprintf(stdout,">>> Chmod +w du fichier %s : %s \n",_fileout,commande);
  system(commande);
  free(commande);

  fid = MEDouvrir(_fileout,MED_LECTURE_ECRITURE);
  EXIT_IF(fid < 0,"Ouverture du fichier : ", _fileout);

  /* Verification du numero de version */
  ret = MEDversionLire(fid,&majeur,&mineur,&release);
  sprintf(version, IFORMAT"_"IFORMAT"_"IFORMAT, majeur, mineur, release);
  EXIT_IF(ret < 0,"Lecture du numero de version de MED-fichier",NULL);
  if (strcmp(version, "2_2_0") < 0)
    MAJ_21_22 = 1;
  if (strcmp(version, "2_3_2") < 0)
    MAJ_231_232 = 1;
  if (MAJ_231_232 == 0) {
    fprintf(stdout,"Le fichier %s est dj au bon format !!! \n",_fileout);
    ret = MEDfermer(fid);
    EXIT_IF(ret < 0,"Fermeture du fichier",filein); 
    return 0;
  }
  
  /* On avertit qu'on commence la conversion */
  fprintf(stdout,">>> Lancement de la normalisation du fichier selon le format " PACKAGE_VERSION " ...\n");

  /* On inhibe le gestionnaire d'erreur HDF5 */
  _MEDmodeErreurVerrouiller();  

  /* Mise a jour du numero de version */
  fprintf(stdout,"- Lancement de la mise  jour du numro de version ... \n");
  MAJ_version(fid);
  fprintf(stdout,"  Numro de version : ... OK ... \n");

  if (MAJ_21_22) {

    /* Mise a jour des maillages : type = MED_NON_STRUCTURE, description, ... */
    fprintf(stdout,"- Lancement de la mise  jour des maillages ... \n"); 
    MAJ_21_22_maillages(fid); 
    fprintf(stdout,"  Maillage(s) : ... OK ...\n"); 

    /* Mise a jour des champs */
    fprintf(stdout,"- Lancement de la mise  jour des champs de rsultats ... \n");
    MAJ_21_22_champs(fid);
    fprintf(stdout,"  Champs(s) : ... OK ...\n");

    /* Mise a jour des profils eventuels */
    nprofil = MEDnProfil(fid);
    if (nprofil > 0) {
      fprintf(stdout,"- Lancement de la mise  jour des profils ... \n");
      MAJ_21_22_profils(fid,nprofil);
      fprintf(stdout,"  Profils(s) : ... OK ...\n");
    } else {
      strncpy(chemin_profils,MED_PROFILS,MED_TAILLE_PROFILS-1);
      chemin_profils[MED_TAILLE_PROFILS-1] = '\0';
      gid = _MEDdatagroupCreer(fid,chemin_profils);
      EXIT_IF(gid < 0,"Creation du groupe HDF sur les profils",chemin_profils);
      ret = _MEDdatagroupFermer(gid);
      EXIT_IF(ret < 0,"Fermeture du groupe HDF sur les profils",chemin_profils);
    }

    /* On cree le groupe HDF pour les liens */
    strncpy(chemin_liens,MED_LIENS,MED_TAILLE_LIENS-1);
    chemin_liens[MED_TAILLE_LIENS-1] = '\0';
    gid = _MEDdatagroupCreer(fid,chemin_liens);
    EXIT_IF(gid < 0,"Creation du groupe HDF sur les liens",chemin_liens);
    ret = _MEDdatagroupFermer(gid);
    EXIT_IF(ret < 0,"Fermeture du groupe HDF sur les liens",chemin_liens);
  }

  if (MAJ_231_232) {
    /* Mise a jour des champs */
    fprintf(stdout,"- Lancement de la mise  jour des champs de rsultats ... \n");
    MAJ_231_232_champs(fid);
    fprintf(stdout,"  Champs(s) : ... OK ...\n");
  }

  /* Fermeture du fichier */
  ret = MEDfermer(fid);
  EXIT_IF(ret < 0,"Fermeture du fichier",_fileout);

  /* On avertit que c'est fini */
  fprintf(stdout,">>> Conversion du fichier %s au format MED V" PACKAGE_VERSION " termine\n",
	  _fileout);

  /* On libere la memoire */
  if (!hasfileout) free(tmp);

  return 0;
}

