/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/


/******************************************************************************
 * - Nom du fichier : test3.c
 *
 * - Description : lecture des informations sur les maillages d'un fichier MED.
 *
 *****************************************************************************/

#include <med.h>
#define MESGERR
#include <med_utils.h>

#ifdef DEF_LECT_ECR
#define MODE_ACCES MED_LECTURE_ECRITURE
#elif DEF_LECT_AJOUT
#define MODE_ACCES MED_LECTURE_AJOUT
#else
#define MODE_ACCES MED_CREATION
#endif

int main (int argc, char **argv)


{
  med_err ret = 0;
  med_idt fid;
  med_int nmaa,i,mdim,edim;
  char maa[MED_TAILLE_NOM+1];
  char nomu[MED_TAILLE_LNOM+1];
  char desc[MED_TAILLE_DESC+1];
  med_maillage type;
  med_err inomu;

  /* Ouverture du fichier "test2.med" en lecture seule */
  fid = MEDouvrir("test2.med",MED_LECTURE);
  if (fid < 0) {
    MESSAGE("Erreur a l'ouverture du fichier test2.med");
    return -1;
  }

  /* Lecture du nombre de maillage dans le fichier */
  nmaa = MEDnMaa(fid);
  if (nmaa < 0) {
    MESSAGE("Erreur a la lecture du nombre de maillage");
    ret = -1;
  } 
  if (ret == 0)
    printf("- Nombre de maillage dans test2.med = "IFORMAT"\n",nmaa);

  /* Boucle sur tous les maillages, pour chaque maillage, on lit :
     - Le nom.
     - Le type
     - La dimension
     - La description
     - La dimension de l'espace si elle existe
     - Le nom universel s'il existe 
     */
  if (ret == 0)
    for (i=0;i<nmaa;i++) {
      /* lecture des informations */
      if (MEDmaaInfo(fid,i+1,maa,&mdim,&type,desc) < 0) {
	MESSAGE("Erreur a la lecture des informations du maillage :"); SSCRUTE(maa);
	ret = -1;
      }
      /* lecture de la dimension de l'espace */
      edim = MEDdimEspaceLire(fid,maa);
      /* lecture du nom universel */
      inomu = MEDunvLire(fid,maa,nomu);
      /* affichage des donnees lues */
      if (inomu < 0)
	printf("maillage "IFORMAT" de nom %s, de dimension "IFORMAT" \n",i+1,maa,mdim);
      else
	printf("maillage "IFORMAT" de nom %s, de dimension "IFORMAT" et de nom univ. %s\n",i+1,maa,mdim,nomu);	
      if (edim > 0)
	printf("La dimension de l'espace est "IFORMAT" \n",edim);
      else
	printf("La dimension de l'espace est "IFORMAT" \n",mdim);
      if (type == MED_STRUCTURE)
	printf("Il s'agit d'un maillage structure \n");
      else
	printf("Il s'agit d'un maillage non structure \n");
      printf("Description associee au maillage : %s \n\n",desc);
    }

  /* Fermeture du fichier */
  ret = MEDfermer(fid);
  if (ret < 0) {
    MESSAGE("Erreur a la fermeture du fichier test2.med");
    return -1;
  }
  
  return ret;
}




