/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <stdio.h>
#include <med_config.h>
#include <med_misc.h>
#include <med_hdfi.h>
#include <med_utils.h>

typedef unsigned long   keyType;
typedef keyType         fileNo;
typedef med_mode_acces  valueType;

extern valueType getModeAcces(keyType key);
extern med_err   setModeAcces(keyType key,valueType v);

/*
 * - Nom de la fonction : _MEDmodeAcces
 * - Description : Renvoi le mode d'accs du fichier contenant
                   l'objet identifi par oid.
		   Ce mode d'accs est positionn par MEDouvrir.
 * - Parametres :
 *     - id1    (IN)  : identificateur de l'objet
 * - Resultat : mode d'accs au fichier eventuellement
 *               MED_UNDEF_MODE_ACCES
 */ 

med_mode_acces _MEDmodeAcces(med_idt oid) {

  fileNo fileno;
  
  if ( _MEDfichierNo(oid,&fileno) < 0 ) {
    ISCRUTE_id(oid);
    ISCRUTE_int((int)(fileno));
    return MED_UNDEF_MODE_ACCES;
  }  else {
/*     ISCRUTE_id(oid); */
/*     ISCRUTE(fileno); */
/*     ISCRUTE( getModeAcces(fileno)); */
    return getModeAcces(fileno);
  }
}

med_err _MEDsetModeAcces(med_idt fid, med_mode_acces mode) {

  fileNo fileno;
  med_err ret;

  if ( _MEDfichierNo(fid,&fileno) < 0 ) {
    MESSAGE("Impossible de positioner le mode d'accs au fichier.");
    ISCRUTE_id(fid);
    ISCRUTE_int((int)(fileno));
    return -1;
  }

  ret = setModeAcces(fileno,mode);
/*   ISCRUTE(setModeAcces(fileno,mode)); */

  return ret;
}
