/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>
#include <hdf5.h>

/*
 * - Nom de la fonction : _MEDattrStringEcrire
 * - Description : ecriture d'un attribut chaine de caracteres
 * - Parametres :
 *     - pere (IN)     : l'ID de l'objet HDF pere ou placer l'attribut
 *     - nom  (IN)     : le nom de l'attribut 
 *     - longueur (IN) : strlen(val)
 *     - val  (IN)     : la valeur de l'attribut
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 
med_err _MEDattrStringEcrire(med_idt pere,char *nom,int longueur,char *val)
{
  med_idt aid,attr, datatype;
  med_err ret;
  med_mode_acces MED_MODE_ACCES;

  if ( (MED_MODE_ACCES = _MEDmodeAcces(pere) ) == MED_UNDEF_MODE_ACCES ) {
    MESSAGE("Impossible de dterminer le mode d'acces au fichier ");
    return -1;
  }

  if ((aid = H5Screate(H5S_SCALAR)) < 0)
    return -1;
  if((datatype = H5Tcopy(H5T_C_S1)) < 0)
    return -1;
  if((ret = H5Tset_size(datatype,longueur+1)) < 0)
    return -1;

  if ( ((attr = H5Aopen_name(pere,nom)) > 0)
       && ( MED_MODE_ACCES == MED_LECTURE_AJOUT) )
    return -1;
  else
    if ( attr < 0)
      if ((attr = H5Acreate(pere,nom,datatype,aid,H5P_DEFAULT)) < 0) return -1;
  
  if ((ret = H5Awrite(attr, datatype, val)) < 0)
    return -1;

  if ((ret = H5Sclose(aid)) < 0)
    return -1;
  if ((ret = H5Tclose(datatype)) < 0)
    return -1;
  if ((ret = H5Aclose(attr)) < 0)
    return -1;

  return 0;
}
