/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

extern int mode_interlace; 

med_err
MEDjointTypeCorres(med_idt fid, char *maa, char *jn,int ind,
		    med_entite_maillage *typ_ent_local,   med_geometrie_element *typ_geo_local,
		    med_entite_maillage *typ_ent_distant, med_geometrie_element *typ_geo_distant)
{
  med_idt corrid, datagroup;
  med_int n,ret,num,idx,nent;

  static med_int geo_ent_local=0,geo_ent_distant=0;
  static int ind_type_courrant=0;
  int ind_type_a_trouver=ind;

  const med_int nb_geo_ent=1+MED_NBR_GEOMETRIE_MAILLE+MED_NBR_GEOMETRIE_ARETE+MED_NBR_GEOMETRIE_FACE;

  med_geometrie_element typ_geo_ent[1+MED_NBR_GEOMETRIE_MAILLE+MED_NBR_GEOMETRIE_ARETE+MED_NBR_GEOMETRIE_FACE][2]=
    {
      {MED_NOEUD,0},
      {MED_MAILLE,MED_POINT1   },
      {MED_MAILLE,MED_SEG2     },
      {MED_MAILLE,MED_SEG3     },
      {MED_MAILLE,MED_TRIA3    },
      {MED_MAILLE,MED_TRIA6    },
      {MED_MAILLE,MED_QUAD4    },
      {MED_MAILLE,MED_QUAD8    },
      {MED_MAILLE,MED_TETRA4   },
      {MED_MAILLE,MED_TETRA10  },
      {MED_MAILLE,MED_HEXA8    },
      {MED_MAILLE,MED_HEXA20   },
      {MED_MAILLE,MED_PENTA6   },
      {MED_MAILLE,MED_PENTA15  },
      {MED_MAILLE,MED_PYRA5    },
      {MED_MAILLE,MED_PYRA13   },
      {MED_ARETE ,MED_SEG2     },
      {MED_ARETE ,MED_SEG3     },
      {MED_FACE  ,MED_TRIA3    },
      {MED_FACE  ,MED_TRIA6    },
      {MED_FACE  ,MED_QUAD4    },
      {MED_FACE  ,MED_QUAD8    }
    };

  if (ind != -1) {
    geo_ent_local=0;geo_ent_distant=0;
    ind_type_courrant=0;
    ind_type_a_trouver=ind;
  } 
  else {
    ind_type_a_trouver=ind_type_courrant+1;
  }

  
  /* recherche du type des entites en regard... passage par toutes les combinaisons */

  for (;ind_type_courrant!=ind_type_a_trouver && geo_ent_local<nb_geo_ent;geo_ent_local++) {
    for (;ind_type_courrant!=ind_type_a_trouver && geo_ent_distant<nb_geo_ent;geo_ent_distant++) {
      *typ_ent_local = typ_geo_ent[geo_ent_local][0];
      *typ_geo_local = typ_geo_ent[geo_ent_local][1];
      *typ_ent_distant = typ_geo_ent[geo_ent_distant][0];
      *typ_geo_distant = typ_geo_ent[geo_ent_distant][1];
      
      if ( (nent=MEDjointnCorres(fid,maa,jn,*typ_ent_local,*typ_geo_local,
				*typ_ent_distant,*typ_geo_distant)
	    ) >0 ) {
	ind_type_courrant ++;
      }
    }
  }
  
  if (ind_type_courrant!=ind_type_a_trouver) {
    return -1;
  }

  return 0;  

}



