#ifndef MED_VERSIONED_API_HXX
#define MED_VERSIONED_API_HXX

#include <string>
#include <map>
#include <cassert>
#include <cstdarg>

extern "C" {
#include <med_misc.h>
}

typedef std::string     keyType;

class MED_VERSIONED_API : public std::map<keyType,
					  MedFuncType > 
{
public :
  static MED_VERSIONED_API& Instance();
  MedFuncType operator[]( const keyType & c ) const;
  void f77ApiIsSet();

private:
  bool _f77ApiIsSet;
  MED_VERSIONED_API();
  MED_VERSIONED_API(const MED_VERSIONED_API &){};
  //MED_VERSIONED_API& operator =(const MED_VERSIONED_API &){};
  ~MED_VERSIONED_API(){};
};


extern "C" MedFuncType 
getVersionedApi(const char * const keycharpart,
		const char * const keynumpart);


#endif
