/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test29.c
 *
 * - Description : ecriture d'un joint dans un maillage MED 
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
  med_idt fid;

  char maa[MED_TAILLE_NOM+1]= "maa1";
  char jnt[MED_TAILLE_NOM+1] = "joint";
  char des_jnt[MED_TAILLE_DESC+1] = "joint avec le sous-domaine 2";
  char maa_distant[MED_TAILLE_NOM+1]= "maa1";
  med_int dom_dist = 2;

  med_int mdim = 3;
  med_int ncor = 3;
  med_int cor[6] = {1,2,3,4,5,6};
  med_int cor2[6] = {10,20,30,40,50,60};

  /* Creation du fichier "test29.med" */
  if ((fid = MEDouvrir("test29.med",MED_CREATION)) < 0) {
    MESSAGE("Erreur a la creation du fichier test29.med");
    return -1;
  }
  
  /* Creation du maillage */
  if (MEDmaaCr(fid,maa,3,MED_NON_STRUCTURE,
		   "Un maillage pour test29") < 0) {
    MESSAGE("Erreur a la creation du maillage");
    return -1;
  }
  
  /* Creation du joint */
  if (MEDjointCr(fid,maa,jnt,des_jnt,dom_dist,maa_distant) < 0) {
    MESSAGE("Erreur a la creation du joint");
    return -1;
  }

  /* Ecriture de la correspondance Noeud, Noeud */
  if (MEDjointEcr(fid,maa,jnt,cor,ncor,
		      MED_NOEUD,0,MED_NOEUD,0) < 0) {
    MESSAGE("Erreur a l'ecriture du tableau des correspondances (noeud,noeud)");
    return -1;
  }
			

  /* Ecriture de la correspondance Noeud Maille */
  if (MEDjointEcr(fid,maa,jnt,cor2,ncor,
                      MED_NOEUD,0,MED_MAILLE,MED_TRIA3) < 0) {
    MESSAGE("Erreur a l'ecriture du tableau des correspondances (noeud,maille TRIA3)");
    return -1;
  }

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }

  return 0;
}




