/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

med_int 
MEDnGauss(med_idt fid)
{
  int n=0;
  med_idt datagroup=0;

  _MEDmodeErreurVerrouiller();
  
  if ( (datagroup = _MEDdatagroupOuvrir(fid,MED_GAUSS)) < 0) 
    return 0;
  else
    if (datagroup) if ( _MEDdatagroupFermer(datagroup) < 0) {
      MESSAGE("Impossible de fermer le datagroup : ");
      ISCRUTE(datagroup); return -1; 
    }
  
  if ( _MEDnObjets(fid,MED_GAUSS,&n) < 0 ) return -1;
  
  return (med_int) n;
}
