/*************************************************************************
* COPYRIGHT (C) 1999 - 2002  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

/*
 * - Nom de la fonction : MEDlienLire
 * - Description : Ecrit le chemin d'accs  un maillage distant
 * - Parametres :
 *   - fid     (IN) : ID du fichier HDF courant
 *   - lienval (IN) : le chemin d'accs au fichier contenant le maillage distant
 *   - maa     (IN) : le nom du lien  lire <=> nom du maillage
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 

med_err
MEDlienLire(_IN med_idt fid, _OUT char * lienval, _IN char * maa)
{
  med_err ret = 0;
  med_idt gid;
  char chemin[MED_TAILLE_LIENS+MED_TAILLE_NOM+1]; 

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /* 
   * ouverture du groupe /LIENS/"maa"
   */  
  strcpy(chemin,MED_LIENS);
  strcat(chemin,maa); 
  if ((gid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'ouvrir le datagroup <maa> : ");
    SSCRUTE(maa); return -1;
  }

  /*
   * Lecture du lien
   */

  if ((ret = _MEDdatasetStringLire(gid,MED_NOM_LIE,lienval)) < 0) {
    MESSAGE("Erreur  la lecture du dataset lienval : ");
    SSCRUTE(lienval); return -1;
  }
  
  /*
   * On ferme tout
   */
  if ((ret = _MEDdatagroupFermer(gid)) < 0)
    return -1; 

  return ret;
}
