#!/bin/sh

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9]\)~.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
SVN_COMMIT='svn log http://svn.drobilla.net/lad/trunk/mda-lv2/ -l 1 | sed -ne "s/r\([0-9]\+\).*/\1/p"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
MDA_LV2_SVN_COMMIT=$(eval "${SVN_COMMIT}")
svn export -r ${MDA_LV2_SVN_COMMIT} http://svn.drobilla.net/lad/trunk/mda-lv2/ mda-lv2
cd mda-lv2/
cd .. && tar cjf \
	${OLDDIR}/mda-lv2_${BASE_REL}~svn${MDA_LV2_SVN_COMMIT}.orig.tar.bz2 \
	mda-lv2 --exclude=.svn --exclude=lv2_ui.h
rm -rf ${GOS_DIR}
