Summary: SELinux Translation Daemon
Name: mcstrans
Version: 0.1.5
Release: 1
License: GPL
Group: System Environment/Daemons
Source: http://fedora.redhat.com/projects/%{name}-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libselinux-devel >= 1.30.3-1
BuildRequires: libcap-devel 
Requires(pre): /sbin/chkconfig /sbin/service
Requires(post):/sbin/chkconfig /sbin/service
Provides: setransd
Provides: libsetrans
Obsoletes: libsetrans

%description
Security-enhanced Linux is a feature of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

mcstrans provides an translation daemon to translate SELinux categories 
from internal representations to user defined representation.

%prep
%setup -q

%build
make clean
make CFLAGS="-g %{optflags}"

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/%{_lib} 
mkdir -p %{buildroot}/%{_libdir} 
make DESTDIR="%{buildroot}" LIBDIR="%{buildroot}%{_libdir}" SHLIBDIR="%{buildroot}/%{_lib}" install
rm -f %{buildroot}%{_sbindir}/*
rm -f %{buildroot}%{_libdir}/*.a

%clean
rm -rf %{buildroot}

%post 
chkconfig --add mcstrans

%preun
if [ $1 -eq 0 ]; then
   service mcstrans stop > /dev/null 2>&1
   chkconfig --del mcstrans
fi

%postun 
if [ $1 -ge 1 ]; then
   service mcstrans condrestart > /dev/null 2>&1 || :
fi

%files
%defattr(-,root,root,0755)
%{_mandir}/man8/mcs.8.gz
/sbin/mcstransd
%{_sysconfdir}/rc.d/init.d/mcstrans

%changelog
* Tue May 16 2006 Dan Walsh <dwalsh@redhat.com> 0.1.5-1
- Fix sighup handling
 
* Mon May 15 2006 Dan Walsh <dwalsh@redhat.com> 0.1.4-1
- Add patch from sgrubb
- 	Fix 64 bit size problems
- 	Increase the open file limit
-	Make sure maximum size is not exceeded

* Fri May 12 2006 Dan Walsh <dwalsh@redhat.com> 0.1.3-1
- Move initscripts to /etc/rc.d/init.d

* Thu May 11 2006 Dan Walsh <dwalsh@redhat.com> 0.1.2-1
- Drop Privs

* Mon May 8 2006 Dan Walsh <dwalsh@redhat.com> 0.1.1-1
- Initial Version
- This daemon reuses the code from libsetrans
