// Author(s): Jeroen Keiren
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
/// \file mcrl2/lps/print.h
/// \brief add your file description here.

#ifndef MCRL2_LPS_PRINT_H
#define MCRL2_LPS_PRINT_H

#include "mcrl2/core/print.h"
#include "mcrl2/lps/summand.h"

namespace mcrl2
{

namespace lps
{

inline
std::string pp(const action_summand_vector& v)
{
  std::ostringstream out;
  for (action_summand_vector::const_iterator i = v.begin(); i != v.end(); ++i)
  {
    out << core::pp(action_summand_to_aterm(*i)) << std::endl;
  }
  return out.str();
}

inline
std::string pp(const deadlock_summand_vector& v)
{
  std::ostringstream out;
  for (deadlock_summand_vector::const_iterator i = v.begin(); i != v.end(); ++i)
  {
    out << core::pp(deadlock_summand_to_aterm(*i)) << std::endl;
  }
  return out.str();
}

} // namespace lps

} // namespace mcrl2

#endif // MCRL2_LPS_PRINT_H
