#pragma once

#include "DBusEnvironment.h"

#include <OnlineAccounts/Manager>
#include <QDBusConnection>
#include <unity/storage/provider/testing/TestServer.h>
#include <unity/storage/qt/client-api.h>

#include <memory>

class ProviderEnvironment
{
public:
    ProviderEnvironment(std::unique_ptr<unity::storage::provider::ProviderBase>&& provider,
                        OnlineAccounts::AccountId account_id,
                        DBusEnvironment const& dbus_env);
    ~ProviderEnvironment();

    unity::storage::qt::Account get_client() const;

private:
    std::unique_ptr<QDBusConnection> client_connection_;
    std::unique_ptr<QDBusConnection> server_connection_;
    std::unique_ptr<OnlineAccounts::Manager> account_manager_;
    std::unique_ptr<unity::storage::provider::testing::TestServer> server_;

    unity::storage::qt::Runtime runtime_;
    unity::storage::qt::Account account_;
};
