/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_SYNCMANAGERPRIV_H_
#define MCLOUD_API_SYNCMANAGERPRIV_H_

#include <mcloud/api/taskqueue.h>
#include <mcloud/api/downloadtask.h>
#include <mcloud/api/uploadtask.h>
#include <mcloud/api/visibility.h>

#include "syncthread.h"

namespace mcloud {
namespace api {

class ClientPriv;

class SyncManagerPriv {
public:
    SyncManagerPriv(ClientPriv *client);

    ~SyncManagerPriv();

    DownloadTask::Ptr add_download_task(const std::string &content_id);

    DownloadTask::Ptr add_download_task(const DownloadBufferCb &buffer_cb);

    UploadTask::Ptr add_upload_task(const UploadRequest &request_item);

    UploadTask::Ptr add_upload_task(const UploadBufferCb &buffer_cb);

    TaskQueue<DownloadTask::Ptr>  download_queue();

    TaskQueue<UploadTask::Ptr>    upload_queue();

    void start();

    void cancel();

    void pause();

private:
    SyncThread<DownloadTaskPriv>   download_thread_;
    SyncThread<UploadTaskPriv>     upload_thread_;

    TaskQueue<DownloadTask::Ptr> download_queue_;
    TaskQueue<UploadTask::Ptr>   upload_queue_;

    ClientPriv*     client_;
};


}
}

#endif // MCLOUD_API_SYNCMANAGERPRIV_H_
