/*
 * Copyright (C) 2016 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Gary Wang <gary.wang@canonical.com>
 */

#pragma once

#include <unity/storage/provider/ProviderBase.h>
#include <mcloud/api/client.h>

using namespace std;
using namespace mcloud::api;

class McloudProvider : public unity::storage::provider::ProviderBase {
public:

    enum class JobMode {
        Upload,
        Download,
        Unknown
    };

    McloudProvider();

    boost::future<unity::storage::provider::ItemList> roots(
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;
    boost::future<tuple<unity::storage::provider::ItemList,string>> list(
          string const& item_id, string const& page_token,
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;
    boost::future<unity::storage::provider::ItemList> lookup(
          string const& parent_id, string const& name,
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;
    boost::future<unity::storage::provider::Item> metadata(
          string const& item_id, vector<string> const& keys,
          unity::storage::provider::Context const& ctx) override;
    boost::future<unity::storage::provider::Item> create_folder(
          string const& parent_id, string const& name,
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;

    boost::future<unique_ptr<unity::storage::provider::UploadJob>> create_file(
          string const& parent_id, string const& name,
          int64_t size, string const& content_type, bool allow_overwrite,
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;
    boost::future<unique_ptr<unity::storage::provider::UploadJob>> update(
          string const& item_id, int64_t size,  string const& old_etag,
          vector<string> const& keys, unity::storage::provider::Context const& ctx) override;
      
    boost::future<unique_ptr<unity::storage::provider::DownloadJob>> download(
          string const& item_id, string const& match_etag,
          unity::storage::provider::Context const& ctx) override;
      
    boost::future<void> delete_item(
          string const& item_id, unity::storage::provider::Context const& ctx) override;
    boost::future<unity::storage::provider::Item> move(
          string const& item_id, string const& new_parent_id,
          string const& new_name, vector<string> const& keys,
          unity::storage::provider::Context const& ctx) override;
    boost::future<unity::storage::provider::Item> copy(
          string const& item_id, string const& new_parent_id,
          string const& new_name, vector<string> const& keys,
          unity::storage::provider::Context const& ctx) override;
  
private: 
    Client::Ptr assign_client(unity::storage::provider::Context const& ctx, JobMode job = JobMode::Unknown);
private:
    vector<Client::Ptr>    client_list_;
};
