/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#ifndef MCLOUD_API_EXCEPTIONS_H_
#define MCLOUD_API_EXCEPTIONS_H_

#include <mcloud/api/visibility.h>

#include <exception>

namespace mcloud {
namespace api {

	/**
	 * \brief Indicates an invalid content id when querying content infomation by an id.
     * or an invalid folder id when listing or looup content in one specific folder. 
	 */

    class MCLOUD_API_DLL_PUBLIC InvalidIDException : public std::runtime_error {
		public:
			using runtime_error::runtime_error;
	};

    /*
	 * \brief Indicates a content or folder can not be found on mcloud.
     */
    class MCLOUD_API_DLL_PUBLIC NonExistentException : public std::runtime_error {
		public:
			using runtime_error::runtime_error;
	};

    /**
     * \brief User ran out of space on mcloud storage.
     */
    class MCLOUD_API_DLL_PUBLIC OutofSpaceException : public std::runtime_error {
        public:
            using runtime_error::runtime_error;
    };
   
    /**
     * \brief Indicates a timeout on HTTP requests.
     */
    class  MCLOUD_API_DLL_PUBLIC HttpTimeoutException : public std::runtime_error {
        public:
            using runtime_error::runtime_error;
    };

    /*
     * \brief Indicates one or more http request parameters are invalid.
     */
    class MCLOUD_API_DLL_PUBLIC ParameterInvalidException : public std::runtime_error {
        public:
            using runtime_error::runtime_error;
    };

    /*
     * \brief Indicates access token is invalid or expired.
     */
    class MCLOUD_API_DLL_PUBLIC CredentialException : public std::runtime_error {
        public:
            using runtime_error::runtime_error;
    };

}
}

#endif // MCLOUD_API_EXCEPTIONS_H_
