/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Gary Wang <gary.wang@canonical.com>
 */

#include <mcloud/api/cloudcontent.h>
#include <tinyxml2.h>
#include <iostream>

using namespace mcloud::api;
using namespace std;

extern std::time_t string_to_time(const std::string dt);

class CloudContent::Priv {
public:
    Priv(const tinyxml2::XMLElement *root) {
        name_= root->FirstChildElement("contentName")->GetText();
        id_ = root->FirstChildElement("contentID")->GetText();
        created_date_ = string_to_time(root->FirstChildElement("uploadTime")->GetText());
        updated_date_ = string_to_time(root->FirstChildElement("updateTime")->GetText());
        parent_catalog_id_ = root->FirstChildElement("parentCatalogId")->GetText();
        owner_ = root->FirstChildElement("owner")->GetText();
        content_size_ = atoi(root->FirstChildElement("contentSize")->GetText());
        type_ = (CloudContent::Type)atoi(root->FirstChildElement("contentType")->GetText());

        auto suffix_ele = root->FirstChildElement("contentSuffix");
        if (suffix_ele && suffix_ele->GetText()) {
            suffix_ = suffix_ele->GetText();
        }

        auto desc_ele = root->FirstChildElement("contentDesc");
        if (desc_ele && desc_ele->GetText()) {
            description_ = desc_ele->GetText();
        }

        auto thumbnail_ele = root->FirstChildElement("thumbnailURL");
        if (thumbnail_ele && thumbnail_ele->GetText()) {
            thumbnail_url_ = thumbnail_ele->GetText();
        }

        auto big_thumbnail_ele = root->FirstChildElement("bigthumbnailURL");
        if (big_thumbnail_ele && big_thumbnail_ele->GetText()) {
            big_thumbnail_url_ = big_thumbnail_ele->GetText();
        }

        auto present_ele = root->FirstChildElement("presentURL");
        if (present_ele && present_ele->GetText()) {
            present_url_ = present_ele->GetText();
        }

        auto etag_ele = root->FirstChildElement("fileEtag");
        if (etag_ele && etag_ele->GetText()) {
            etag_ = etag_ele->GetText();
        }

    #ifndef NDEBUG
        cout << "id: "<< id_ << " name: " << name_ << "  etag: "<< etag_ << endl;
    #endif
    }

  std::string id_;

  std::string name_;

  std::time_t created_date_;

  std::time_t updated_date_;

  std::string etag_;

  std::string owner_;

  std::string suffix_;

  CloudContent::Type type_;

  int64_t     content_size_;

  std::string description_;

  std::string thumbnail_url_;

  std::string big_thumbnail_url_;

  std::string present_url_;

  std::string parent_catalog_id_;
};

CloudContent::CloudContent(const tinyxml2::XMLElement *root)
    : p(std::make_shared<Priv>(root)){
}

const string &CloudContent::id() const {
    return p->id_;
}

const string &CloudContent::name() const {
    return  p->name_;
}

const time_t &CloudContent::created_date() const {
    return p->created_date_;
}

const time_t &CloudContent::updated_date() const {
    return p->updated_date_;
}

const string &CloudContent::parent_catalog_id() const {
    return p->parent_catalog_id_;
}

const string &CloudContent::etag() const {
    return p->etag_;
}

const string &CloudContent::owner() const {
    return p->owner_;
}

CloudResource::Property CloudContent::property() const {
    return CloudResource::Property::Content;
}

const string &CloudContent::suffix() const {
    return p->suffix_;
}

CloudContent::Type CloudContent::type() const {
    return p->type_;
}

int64_t CloudContent::content_size() const {
    return p->content_size_;
}

const string &CloudContent::description() const {
    return p->description_;
}

const string &CloudContent::thumbnail_url() const {
    return p->thumbnail_url_;
}

const string &CloudContent::big_thumbnail_url() const {
    return p->big_thumbnail_url_;
}

const string &CloudContent::present_url() const {
    return p->present_url_;
}
