      SUBROUTINE FUNC2AD(A, b, c, d, e)
      IMPLICIT NONE
      DOUBLE PRECISION A(3, 3), b(3), c(3), d(3), e
      DOUBLE PRECISION tmp1(3)
      INTEGER I, J
      DO I=1, 3
            tmp1(I) = 0D0
            DO J=1, 3
                    tmp1(I) = tmp1(I) + A(I, J) * (b(J) - c(J))
            ENDDO
       END DO
       
       DO I=1, 3
            d(I) = 0D0
            DO J=1, 3
                    d(I) = d(I) + A(J, I) * tmp1(J)
            ENDDO
            d(I) = d(I) * e
       ENDDO
       END
       
       SUBROUTINE FUNC2ADDAD(x, y, z, N)
       IMPLICIT NONE
       INTEGER N
       DOUBLE PRECISION x(N), y(N), z(N)
       INTEGER I
       DO I=1,N
        z(I) = x(I) + y(I)
       END DO
       END
       
       SUBROUTINE FUNC2MULAD(x, y, z, N)
       IMPLICIT NONE
       INTEGER N
       DOUBLE PRECISION x(N), y(N), z(N)
       INTEGER I
       DO I=1,N
        z(I) = x(I) * y(I)
       END DO
       END       
C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.5 (r3618) - 22 Dec 2010 11:39
C
C  Differentiation of func2ad in forward (tangent) mode: (multi-directional mode)
C   variations   of useful results: d
C   with respect to varying inputs: a b c
C   RW status of diff variables: d:out a:in b:in c:in
      SUBROUTINE FUNC2AD_DV(a, ad, b, bd, c, cd, d, dd, e, nbdirs)
      IMPLICIT NONE
      INTEGER nbdirsmax
      PARAMETER (nbdirsmax = 12)
C  Hint: nbdirsmax should be the maximum number of differentiation directions
      DOUBLE PRECISION a(3, 3), b(3), c(3), d(3), e
      DOUBLE PRECISION ad(nbdirsmax, 3, 3), bd(nbdirsmax, 3), cd(
     +                 nbdirsmax, 3), dd(nbdirsmax, 3)
      DOUBLE PRECISION tmp1(3)
      DOUBLE PRECISION tmp1d(nbdirsmax, 3)
      INTEGER i, j
      INTEGER nd
      INTEGER nbdirs
      INTEGER ii1
      DO nd=1,nbdirs
        DO ii1=1,3
          tmp1d(nd, ii1) = 0.D0
        ENDDO
      ENDDO
      DO i=1,3
        DO nd=1,nbdirs
          tmp1d(nd, i) = 0.D0
        ENDDO
        tmp1(i) = 0d0
        DO j=1,3
          DO nd=1,nbdirs
            tmp1d(nd, i) = tmp1d(nd, i) + ad(nd, i, j)*(b(j)-c(j)) + a(i
     +        , j)*(bd(nd, j)-cd(nd, j))
          ENDDO
          tmp1(i) = tmp1(i) + a(i, j)*(b(j)-c(j))
        ENDDO
      ENDDO
      DO nd=1,nbdirs
        DO ii1=1,3
          dd(nd, ii1) = 0.D0
        ENDDO
      ENDDO
      DO i=1,3
        DO nd=1,nbdirs
          dd(nd, i) = 0.D0
        ENDDO
        d(i) = 0d0
        DO j=1,3
          DO nd=1,nbdirs
            dd(nd, i) = dd(nd, i) + ad(nd, j, i)*tmp1(j) + a(j, i)*tmp1d
     +        (nd, j)
          ENDDO
          d(i) = d(i) + a(j, i)*tmp1(j)
        ENDDO
        DO nd=1,nbdirs
          dd(nd, i) = e*dd(nd, i)
        ENDDO
        d(i) = d(i)*e
      ENDDO
      END

C  Tapenade 3.10 (r5498) - 20 Jan 2015 09:48
C
C  Differentiation of func2addad in forward (tangent) mode:
C   variations   of useful results: z
C   with respect to varying inputs: x y
C   RW status of diff variables: x:in y:in z:out
      SUBROUTINE FUNC2ADDAD_DV(x, xd, y, yd, z, zd, n, nbdirs)
      IMPLICIT NONE
C  Hint: nbdirsmax should be the maximum number of differentiation directions
      INTEGER n
      DOUBLE PRECISION x(n), y(n), z(n)
      DOUBLE PRECISION xd(nbdirs, n), yd(nbdirs, n), zd(nbdirs, n)
      INTEGER i
      INTEGER nd
      INTEGER nbdirs
C       INTEGER ii1
C       DO nd=1,nbdirs
C         DO ii1=1,n
C           zd(nd, ii1) = 0.D0
C         ENDDO
C       ENDDO
      DO i=1,n
        DO nd=1,nbdirs
          zd(nd, i) = xd(nd, i) + yd(nd, i)
        ENDDO
        z(i) = x(i) + y(i)
      ENDDO
      END
      
C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.10 (r5498) - 20 Jan 2015 09:48
C
C  Differentiation of func2mulad in forward (tangent) mode:
C   variations   of useful results: z
C   with respect to varying inputs: x y
C   RW status of diff variables: x:in y:in z:out
      SUBROUTINE FUNC2MULAD_DV(x, xd, y, yd, z, zd, n, nbdirs)
      IMPLICIT NONE
C  Hint: nbdirsmax should be the maximum number of differentiation directions
      INTEGER n
      DOUBLE PRECISION x(n), y(n), z(n)
      DOUBLE PRECISION xd(nbdirs, n), yd(nbdirs, n), zd(nbdirs, n)
      INTEGER i
      INTEGER nd
      INTEGER nbdirs
C       INTEGER ii1
C       DO nd=1,nbdirs
C         DO ii1=1,n
C           zd(nd, ii1) = 0.D0
C         ENDDO
C       ENDDO
      DO i=1,n
        DO nd=1,nbdirs
          zd(nd, i) = xd(nd, i)*y(i) + x(i)*yd(nd, i)
        ENDDO
        z(i) = x(i)*y(i)
      ENDDO
      END      