/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __PROGRAMITEM_H__
#define __PROGRAMITEM_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qlistview.h>
#include <qpainter.h>
#include <qdatetime.h>
#include "program.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ProgramItem : public QListViewItem
{
public:
	ProgramItem(MainWidget *parent, QListView *lv, Program *program, QString time, QString title, QString duration, QString channel);

	Program* program() { return(m_program); }
	Program* program() const { return(m_program); }
	int channelSort(ProgramItem *pi) const;

protected:
	virtual void paintCell(QPainter *p, const QColorGroup & cg, int column, int width, int align);
	virtual int compare(QListViewItem * with, int col, bool ascending) const;

private:
	MainWidget *m_parent;
	Program *m_program;
	QDateTime m_time;
//	QPixmap m_pixmap;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
