/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include "parser.h"
//-----------------------------------------------------------------------------------------------------------------------
Parser::Parser(QPtrList<Channel> *channels, QPtrList<Program> *programs, QStringList *categories)
{
	m_channels = channels;
	m_programs = programs;
	m_categories = categories;
	m_channel = NULL;
	m_program = NULL;
}
//-----------------------------------------------------------------------------------------------------------------------
bool Parser::startElement(const QString& /*uri*/, const QString& /*localName*/, const QString& qName, const QXmlAttributes& attr)
{
	if(qName == "channel") {
		m_element = CHANNEL;
		m_channel = new Channel();
		m_channel->setId(attr.value("id"));
	} else if(qName == "display-name") {
		m_element = DISPLAYNAME;
	} else if(qName == "icon") {
		m_element = ICON;
		if(!attr.value("src").isEmpty() && m_channel != NULL)
			m_channel->setImageLocation(attr.value("src"));
	} else if(qName == "programme") {
		m_element = PROGRAM;
		m_program = new Program();
		m_program->setStart(attr.value("start").section(' ', 0, 0));
		m_program->setStop(attr.value("stop").section(' ', 0, 0));
		m_program->setChannelId(attr.value("channel"));
		m_program->setShowView(attr.value("showview"));
	} else if(qName == "title") {
		m_element = TITLE;
	} else if(qName == "sub-title") {
		m_element = SUBTITLE;
	} else if(qName == "desc") {
		m_element = DESC;
	} else if(qName == "category") {
		m_element = CATEGORY;
	} else if(qName == "actor") {
		m_element = ACTOR;
	} else if(qName == "director") {
		m_element = DIRECTOR;
	} else if(qName == "date") {
		m_element = DATE;
	} else if(qName == "aspect") {
		m_element = ASPECT;
	} else if(qName == "episode-num") {
		if(attr.value("system").compare("onscreen") == 0)
			m_element = EPISODE;
		else
			m_element = NONE;
	} else
		m_element = NONE;
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
bool Parser::endElement(const QString&, const QString&, const QString& qName)
{
	if(qName == "channel" && m_channel) {
		m_channels->append(m_channel);
		m_channel = NULL;
	}
	if(qName == "programme" && m_program) {
		m_programs->append(m_program);
		m_program = NULL;
	}
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
bool Parser::characters(const QString& ch)
{
	QString text = ch.stripWhiteSpace();

	switch(m_element) {
		case CHANNEL:
			break;
		case DISPLAYNAME:
			if(m_channel && !text.isEmpty() && m_channel->name().isEmpty())
				m_channel->setName(text);
			break;
		case PROGRAM:
			break;
		case TITLE:
			if(m_program && !text.isEmpty() && m_program->title().isEmpty())
				m_program->setTitle(text);
			break;
		case SUBTITLE:
			if(m_program && !text.isEmpty() && m_program->subtitle().isEmpty())
				m_program->setSubtitle(text);
			break;
		case DESC:
			if(m_program && !text.isEmpty())
				m_program->setDesc(text);
			break;
		case CATEGORY:
			if(m_program && !text.isEmpty())
				m_program->setCategory(text);
			if(m_categories->grep(text).isEmpty())
				m_categories->append(text);
			break;
		case ACTOR:
			if(m_program && !text.isEmpty())
				m_program->setActors(text);
			break;
		case DIRECTOR:
			if(m_program && !text.isEmpty())
				m_program->setDirector(text);
			break;
		case DATE:
			if(m_program && !text.isEmpty())
				m_program->setDate(text);
			break;
		case ASPECT:
			if(m_program && !text.isEmpty())
				m_program->setAspect(text);
			break;
		case EPISODE:
			if(m_program && !text.isEmpty())
				m_program->setEpisode(text);
			break;
		default:
			break;
	}
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
