/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __MAINWIDGET_H__
#define __MAINWIDGET_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <kmainwindow.h>
#include <kglobalaccel.h>
#include <kshortcut.h>
#include <kaction.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <qvaluelist.h>
#include "wmainwidget.h"
#include "trayicon.h"
#include "favouritemaster.h"
#include "channelview.h"
#include "programmaster.h"
#include "programview.h"
#include "searchview.h"
#include "blistmaster.h"
#include "parsemaster.h"
#include "baseview.h"
#include "completeview.h"
#include "forumview.h"
#include "prefsdialog.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget : public MainWgt
{
	Q_OBJECT
public:
	MainWidget(KMainWindow * parent = 0);
	~MainWidget();

	void loadSettings();
	void saveSettings();

	bool okToClose() { return(m_okToClose); }
	void downloadListings(bool autoClose = false);
	void parse();
	void postParse();
	FavouriteMaster* favouriteMaster() { return(m_favouriteMaster); }
	BlistMaster* blistMaster() { return(m_blistMaster); }
	ParseMaster* parseMaster() { return(m_parseMaster); }
	void wireHotkeys();
	void initMain();
	void rebuildCategories(); // TODO: Move this to a more appropriate place
	QPtrList<Channel>* channels() { return(m_parseMaster->channels()); }
	PrefsDialog* prefs() { return(&m_prefsDialog); }
	void newUserCheck();

	// Views
	BaseView* activeView();

public slots:
	virtual void browseUpdateCmdClicked();
	virtual void browseCommandClicked();
	virtual void updateNowClicked() { rebuild(true); }
	virtual void aboutClicked();
	virtual void prefsClicked();
	virtual void rebuildView();
	virtual void defaultColoursClicked();
	virtual void detailTagsChanged() { activeView()->updateDesc(); }
	virtual void updateChannels() { m_channelView->update(); }
	virtual void manualColWidth(bool manual);
	virtual void toggleDetails();
	virtual void setView(int view) { ws_main->raiseWidget(view); }
	virtual void refresh();

	void rebuild(bool forceDownload = false);
	void capturedShortcut(const KShortcut&);
	void shuttingDown() { m_okToClose = true; m_parent->close(); }
	void timerDone();
	void favColChanged(const QColor &col) { lv_favourite->setPaletteBackgroundColor(col); }

	// AccelKeys
	void switchToDayView() { ws_main->raiseWidget(0); }
	void switchToFullView() { ws_main->raiseWidget(2); }
	void switchToSearchView() { ws_main->raiseWidget(1); }
	void switchToForum() { if(activeView()->listView() && activeView()->listView()->selectedItem()) ws_main->raiseWidget(3); }
	void toggleHidePast() { activeView()->toggleHidePast(); }
	void toggleFavsOnly() { activeView()->toggleFavsOnly(); }

private:
	FavouriteMaster *m_favouriteMaster;
	BlistMaster *m_blistMaster;
	ProgramMaster *m_programMaster;
	ParseMaster *m_parseMaster;
	ProgramView *m_programView;
	SearchView *m_searchView;
	CompleteView *m_completeView;
	ForumView *m_forumView;
	ChannelView *m_channelView;
	PrefsDialog m_prefsDialog;
	TrayIcon *m_tray;
	bool m_okToClose;
	bool m_blockUpdate;
	QTimer *m_timer;
	KMainWindow *m_parent;
	KActionCollection m_actionCollection;
	KGlobalAccel m_globalAccel;
	QValueList<int> m_detailSize;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
