#include <iostream.h>
#include <ctype.h>

//
// This file is an illustration of the various kinds of simple functions you
// can set up with matwrap, and also a test for a number of special cases.
// None of these functions are likely to be especially useful; they are only
// for examples.
//

typedef float numtype;		// The type to use for numbers in this example
				// file.  Change this to int, short, double,
				// complex,  or whatever you want.  Matwrap
				// should correctly handle interconversion 
				// between types automatically.

//
// Just print out a number and return it.
//
inline numtype print_num(numtype num) { cout << num << '\n'; return num; }


//
// Print out a vector, with its indices, and return the vector:
//
inline void
print_vec(const numtype *v, unsigned n, numtype *v_out)
{
  for (unsigned idx = 0; idx < n; ++idx)
  {
    cout << idx << ' ' << v[idx] << '\n';
    v_out[idx] = v[idx];
  }
} //%input v(n)
//%output v_out(n)

//
// Print out a matrix, with its indices, and return the matrix:
//
inline void 
print_mat(const numtype *mat, unsigned m, unsigned n, numtype *mat_out)
{
  for (unsigned j_idx = 0; j_idx < n; ++j_idx)
    for (unsigned i_idx = 0; i_idx < m; ++i_idx)
    {
      cout << '(' << i_idx << ',' << j_idx << "): "
	   << mat[i_idx+j_idx*m] << '\n';
      mat_out[i_idx+j_idx*m] = mat[i_idx+j_idx*m];
    }
} //%input mat(m,n)
//%output mat_out(m,n)

//
// Print out an array of characters and return them:
//
inline void
print_cmat(const char *mat, unsigned m, unsigned n, char *mat_out)
{
  for (unsigned j_idx = 0; j_idx < n; ++j_idx)
    for (unsigned i_idx = 0; i_idx < m; ++i_idx)
    {
      cout << '(' << i_idx << ',' << j_idx << "): "
	   << mat[i_idx+j_idx*m] << '\n';
      mat_out[i_idx+j_idx*m] = mat[i_idx+j_idx*m];
    }
} //%input mat(m,n)
//%output mat_out(m,n)

//
// Flip the case in a string:
//
inline char
flip_case(char c)
{
  if (isupper(c))
    c = tolower(c);
  else if (islower(c))
    c = toupper(c);
  return c;
}

//
// Print a string:
// This is not recommended as a replacement for disp(), it's just a simple
// illustration of how to use null terminated strings.
//
void
print_str(const char *str)
{
  cout << str << '\n';
}

extern "C" {
extern int strcmp(const char *, const char *); //%name real_strcmp
				// Call the real strcmp function from matlab,
				// not the hacked one that returns 0 or 1,
				// but one that returns -1, 0, 1.
}

//
// Illustration of a function that returns a string.
//
const char *
get_str(unsigned idx)
{
  static const char *messages[] = {"Hello world", "Guten Tag, Welt"};

  if (idx < sizeof (messages)/sizeof (const char *))
    return messages[idx];
  else
    return "Illegal index";
}

//
// Illustration of wrapping a global variable:
//
numtype some_global_var = 0;

//
// Illustration of a simple class:
//
class abc {
public:
  numtype jkl_plus(numtype x) { return jkl+x; }
  static numtype ghi;
  numtype jkl;
};

numtype abc::ghi = 0;
