# Summary

# Introduction
- [Welcome and Overview](welcome_and_overview.md)

# Setup
  - [Installation](setup/installation.md)
  - [Using Postgres](postgres.md)
  - [Configuring a Reverse Proxy](reverse_proxy.md)
  - [Configuring a Forward/Outbound Proxy](setup/forward_proxy.md)
  - [Configuring a Turn Server](turn-howto.md)
  - [Delegation](delegate.md)

# Upgrading
  - [Upgrading between Synapse Versions](upgrade.md)

# Usage
  - [Federation](federate.md)
  - [Configuration](usage/configuration/README.md)
    - [Configuration Manual](usage/configuration/config_documentation.md) 
    - [Homeserver Sample Config File](usage/configuration/homeserver_sample_config.md)
    - [Logging Sample Config File](usage/configuration/logging_sample_config.md)
    - [Structured Logging](structured_logging.md)
    - [Templates](templates.md)
    - [User Authentication](usage/configuration/user_authentication/README.md)
      - [Single-Sign On](usage/configuration/user_authentication/single_sign_on/README.md)
        - [OpenID Connect](openid.md)
        - [SAML](usage/configuration/user_authentication/single_sign_on/saml.md)
        - [CAS](usage/configuration/user_authentication/single_sign_on/cas.md)
        - [SSO Mapping Providers](sso_mapping_providers.md)
      - [Password Auth Providers](password_auth_providers.md)
      - [JSON Web Tokens](jwt.md)
      - [Refresh Tokens](usage/configuration/user_authentication/refresh_tokens.md)
    - [Registration Captcha](CAPTCHA_SETUP.md)
    - [Application Services](application_services.md)
    - [Server Notices](server_notices.md)
    - [Consent Tracking](consent_tracking.md)
    - [URL Previews](development/url_previews.md)
    - [User Directory](user_directory.md)
    - [Message Retention Policies](message_retention_policies.md)
    - [Pluggable Modules](modules/index.md)
      - [Writing a module](modules/writing_a_module.md)
        - [Spam checker callbacks](modules/spam_checker_callbacks.md)
        - [Third-party rules callbacks](modules/third_party_rules_callbacks.md)
        - [Presence router callbacks](modules/presence_router_callbacks.md)
        - [Account validity callbacks](modules/account_validity_callbacks.md)
        - [Password auth provider callbacks](modules/password_auth_provider_callbacks.md)
        - [Background update controller callbacks](modules/background_update_controller_callbacks.md)
        - [Account data callbacks](modules/account_data_callbacks.md)
        - [Porting a legacy module to the new interface](modules/porting_legacy_module.md)
    - [Workers](workers.md)
      - [Using `synctl` with Workers](synctl_workers.md)
      - [Systemd](systemd-with-workers/README.md)
  - [Administration](usage/administration/README.md)
    - [Admin API](usage/administration/admin_api/README.md)
      - [Account Validity](admin_api/account_validity.md)
      - [Background Updates](usage/administration/admin_api/background_updates.md)
      - [Delete Group](admin_api/delete_group.md)
      - [Event Reports](admin_api/event_reports.md)
      - [Media](admin_api/media_admin_api.md)
      - [Purge History](admin_api/purge_history_api.md)
      - [Register Users](admin_api/register_api.md)
      - [Registration Tokens](usage/administration/admin_api/registration_tokens.md)
      - [Manipulate Room Membership](admin_api/room_membership.md)
      - [Rooms](admin_api/rooms.md)
      - [Server Notices](admin_api/server_notices.md)
      - [Statistics](admin_api/statistics.md)
      - [Users](admin_api/user_admin_api.md)
      - [Server Version](admin_api/version_api.md)
      - [Federation](usage/administration/admin_api/federation.md)
    - [Manhole](manhole.md)
    - [Monitoring](metrics-howto.md)
    - [Understanding Synapse Through Grafana Graphs](usage/administration/understanding_synapse_through_grafana_graphs.md)
    - [Useful SQL for Admins](usage/administration/useful_sql_for_admins.md)
    - [Database Maintenance Tools](usage/administration/database_maintenance_tools.md)
    - [State Groups](usage/administration/state_groups.md)
    - [Request log format](usage/administration/request_log.md)
    - [Admin FAQ](usage/administration/admin_faq.md)
    - [Scripts]()

# Development
  - [Contributing Guide](development/contributing_guide.md)
  - [Code Style](code_style.md)
  - [Release Cycle](development/releases.md)
  - [Git Usage](development/git.md)
  - [Testing]()
    - [Demo scripts](development/demo.md)
  - [OpenTracing](opentracing.md)
  - [Database Schemas](development/database_schema.md)
  - [Experimental features](development/experimental_features.md)
  - [Synapse Architecture]()
    - [Cancellation](development/synapse_architecture/cancellation.md)
    - [Log Contexts](log_contexts.md)
    - [Replication](replication.md)
    - [TCP Replication](tcp_replication.md)
  - [Internal Documentation](development/internal_documentation/README.md)
    - [Single Sign-On]()
      - [SAML](development/saml.md)
      - [CAS](development/cas.md)
    - [Room DAG concepts](development/room-dag-concepts.md)
    - [State Resolution]()
      - [The Auth Chain Difference Algorithm](auth_chain_difference_algorithm.md)
    - [Media Repository](media_repository.md)
    - [Room and User Statistics](room_and_user_statistics.md)
  - [Scripts]()

# Other
  - [Dependency Deprecation Policy](deprecation_policy.md)
  - [Running Synapse on a Single-Board Computer](other/running_synapse_on_single_board_computers.md)
