/*
 * This file contains the test/example program
 * for the Mathomatic symbolic math library and API.
 * Copy or refer to this, if you are going to use the Mathomatic code in other projects.
 */

#include <stdio.h>
#include <stdlib.h>
#include "mathomatic.h"

int
main(int argc, char **argv)
{
	char		*cp;		/* character pointer */
	const char	*ocp;		/* output character pointer */
	int		rv;		/* return value */
	char		buf[1000];	/* buffer */

	printf("Mathomatic library test program.\n");
	/* Initialize all global variables and arrays so that Mathomatic will work properly. */
	if (!matho_init()) {	/* call this function exactly once in your program */
		fprintf(stderr, "Not enough memory.\n");
		exit(1);
	}
	/* Mathomatic is ready for use. */
	/* This is a standard input/output loop for testing. */
	for (;;) {
		printf("%d-> ", cur_equation + 1);
		if ((cp = fgets(buf, sizeof(buf), stdin)) == NULL)
			break;
		rv = matho_process(cp, &ocp);
		if (ocp) {
			printf("%s\n", ocp);
			if (rv) {
				free((void *) ocp);
			} else {
				printf("Error return.\n");
			}
		}
	}
	printf("\n");
	exit(0);
}
