# Emacs Markdown Mode

<!-- This file is autogenerated by webpage.sh from the comments at the top of
     markdown-mode.el. Make edits there, not here. -->

markdown-mode is a major mode for editing [Markdown][]-formatted
text files in GNU Emacs.  markdown-mode is free software, licensed
under the GNU GPL.

 [Markdown]: http://daringfireball.net/projects/markdown/

The latest stable version is markdown-mode 2.0, released on March 24, 2013:

   * [markdown-mode.el][]
   * [Screenshot][][^theme]
   * [Release notes][]

 [markdown-mode.el]: http://jblevins.org/projects/markdown-mode/markdown-mode.el
 [Screenshot]: http://jblevins.org/projects/markdown-mode/screenshots/20130131-002.png
 [Release notes]: http://jblevins.org/projects/markdown-mode/rev-2-0

[^theme]: The theme used in the screenshot is
    [color-theme-twilight](https://github.com/crafterm/twilight-emacs).

markdown-mode is also available in several package managers, including:

   * Debian Linux: [emacs-goodies-el][]
   * Ubuntu Linux: [emacs-goodies-el][emacs-goodies-el-ubuntu]
   * RedHat and Fedora Linux: [emacs-goodies][]
   * NetBSD: [textproc/markdown-mode][]
   * Arch Linux (AUR): [emacs-markdown-mode-git][]
   * MacPorts: [markdown-mode.el][macports-package] ([pending][macports-ticket])
   * FreeBSD: [textproc/markdown-mode.el][freebsd-port]

 [emacs-goodies-el]: http://packages.debian.org/emacs-goodies-el
 [emacs-goodies-el-ubuntu]: http://packages.ubuntu.com/search?keywords=emacs-goodies-el
 [emacs-goodies]: https://apps.fedoraproject.org/packages/emacs-goodies
 [textproc/markdown-mode]: http://pkgsrc.se/textproc/markdown-mode
 [emacs-markdown-mode-git]: https://aur.archlinux.org/packages/emacs-goodies-el/
 [macports-package]: https://trac.macports.org/browser/trunk/dports/editors/markdown-mode.el/Portfile
 [macports-ticket]: http://trac.macports.org/ticket/35716
 [freebsd-port]: http://svnweb.freebsd.org/ports/head/textproc/markdown-mode.el

The latest development version can be downloaded directly
([markdown-mode.el][devel.el]) or it can be obtained from the
(browsable and clonable) Git repository at
<http://jblevins.org/git/markdown-mode.git>.  The entire repository,
including the full project history, can be cloned via the Git protocol
by running

    git clone git://jblevins.org/git/markdown-mode.git

 [devel.el]: http://jblevins.org/git/markdown-mode.git/plain/markdown-mode.el

## Installation

Make sure to place `markdown-mode.el` somewhere in the load-path and add
the following lines to your `.emacs` file to associate markdown-mode
with `.text`, `.markdown`, and `.md` files:

    (autoload 'markdown-mode "markdown-mode"
       "Major mode for editing Markdown files" t)
    (add-to-list 'auto-mode-alist '("\\.text\\'" . markdown-mode))
    (add-to-list 'auto-mode-alist '("\\.markdown\\'" . markdown-mode))
    (add-to-list 'auto-mode-alist '("\\.md\\'" . markdown-mode))

There is no official Markdown file extension, nor is there even a
_de facto_ standard, so you can easily add, change, or remove any
of the file extensions above as needed.

## Usage

Keybindings are grouped by prefixes based on their function.  For
example, the commands for inserting links are grouped under `C-c
C-a`, where the <kbd>C-a</kbd> is a mnemonic for the HTML `<a>` tag.  In
other cases, the connection to HTML is not direct.  For example,
commands dealing with headings begin with <kbd>C-c C-t</kbd> (mnemonic:
titling).  The primary commands in each group will are described
below.  You can obtain a list of all keybindings by pressing `C-c
C-h`.  Movement and shifting commands tend to be associated with
paired delimiters such as <kbd>M-{</kbd> and <kbd>M-}</kbd> or <kbd>C-c <</kbd> and <kbd>C-c ></kbd>.
Outline navigation keybindings the same as in `org-mode`.  Finally,
commands for running Markdown or doing maintenance on an open file
are grouped under the <kbd>C-c C-c</kbd> prefix.  The most commonly used
commands are described below.  You can obtain a list of all
keybindings by pressing <kbd>C-c C-h</kbd>.

  * Hyperlinks: <kbd>C-c C-a</kbd>

    In this group, <kbd>C-c C-a l</kbd> inserts an inline link of the form
    `[text](url)`.  The link text is determined as follows.  First,
    if there is an active region (i.e., when transient mark mode is
    on and the mark is active), use it as the link text.  Second,
    if the point is at a word, use that word as the link text.  In
    these two cases, the original text will be replaced with the
    link and point will be left at the position for inserting a
    URL.  Otherwise, insert empty link markup and place the point
    for inserting the link text.

    <kbd>C-c C-a L</kbd> inserts a reference link of the form `[text][label]`
    and, optionally, a corresponding reference label definition.
    The link text is determined in the same way as with an inline
    link (using the region, when active, or the word at the point),
    but instead of inserting empty markup as a last resort, the
    link text will be read from the minibuffer.  The reference
    label will be read from the minibuffer in both cases, with
    completion from the set of currently defined references.  To
    create an implicit reference link, press <kbd>RET</kbd> to accept the
    default, an empty label.  If the entered referenced label is
    not defined, additionally prompt for the URL and (optional)
    title.  If a URL is provided, a reference definition will be
    inserted in accordance with `markdown-reference-location`.
    If a title is given, it will be added to the end of the
    reference definition and will be used to populate the title
    attribute when converted to XHTML.

    <kbd>C-c C-a u</kbd> inserts a bare url, delimited by angle brackets.  When
    there is an active region, the text in the region is used as the
    URL.  If the point is at a URL, that url is used.  Otherwise,
    insert angle brackets and position the point in between them
    for inserting the URL.

    <kbd>C-c C-a f</kbd> inserts a footnote marker at the point, inserts a
    footnote definition below, and positions the point for
    inserting the footnote text.  Note that footnotes are an
    extension to Markdown and are not supported by all processors.

    <kbd>C-c C-a w</kbd> behaves much like the inline link insertion command
    and inserts a wiki link of the form `[[WikiLink]]`.  If there
    is an active region, use the region as the link text.  If the
    point is at a word, use the word as the link text.  If there is
    no active region and the point is not at word, simply insert
    link markup.  Note that wiki links are an extension to Markdown
    and are not supported by all processors.

  * Images: <kbd>C-c C-i</kbd>

    <kbd>C-c C-i i</kbd> inserts markup for an inline image, using the
    active region or the word at point, if any, as the alt text.
    <kbd>C-c C-i I</kbd> behaves similarly and inserts a reference-style
    image.

  * Styles: <kbd>C-c C-s</kbd>

    <kbd>C-c C-s e</kbd> inserts markup to make a region or word italic (<kbd>e</kbd>
    for `<em>` or emphasis).  If there is an active region, make
    the region italic.  If the point is at a non-italic word, make
    the word italic.  If the point is at an italic word or phrase,
    remove the italic markup.  Otherwise, simply insert italic
    delimiters and place the cursor in between them.  Similarly,
    use <kbd>C-c C-s s</kbd> for bold (`<strong>`) and <kbd>C-c C-s c</kbd> for
    inline code (`<code>`).

    <kbd>C-c C-s b</kbd> inserts a blockquote using the active region, if any,
    or starts a new blockquote.  <kbd>C-c C-s C-b</kbd> is a variation which
    always operates on the region, regardless of whether it is
    active or not.  The appropriate amount of indentation, if any,
    is calculated automatically given the surrounding context, but
    may be adjusted later using the region indentation commands.

    <kbd>C-c C-s p</kbd> behaves similarly for inserting preformatted code
    blocks, with <kbd>C-c C-s C-p</kbd> being the region-only counterpart.

  * Headings: <kbd>C-c C-t</kbd>

    All heading insertion commands use the text in the active
    region, if any, as the heading text.  Otherwise, if the current
    line is not blank, they use the text on the current line.
    Finally, the setext commands will prompt for heading text if
    there is no active region and the current line is blank.

    <kbd>C-c C-t h</kbd> inserts a heading with automatically chosen type and
    level (both determined by the previous heading).  <kbd>C-c C-t H</kbd>
    behaves similarly, but uses setext (underlined) headings when
    possible, still calculating the level automatically.
    In cases where the automatically-determined level is not what
    you intended, the level can be quickly promoted or demoted
    (as described below).  Alternatively, a <kbd>C-u</kbd> prefix can be
    given to insert a heading promoted by one level or a <kbd>C-u C-u</kbd>
    prefix can be given to insert a heading demoted by one level.

    To insert a heading of a specific level and type, use <kbd>C-c C-t 1</kbd>
    through <kbd>C-c C-t 6</kbd> for atx (hash mark) headings and <kbd>C-c C-t !</kbd> or
    <kbd>C-c C-t @</kbd> for setext headings of level one or two, respectively.
    Note that <kbd>!</kbd> is <kbd>S-1</kbd> and <kbd>@</kbd> is <kbd>S-2</kbd>.

    If the point is at a heading, these commands will replace the
    existing markup in order to update the level and/or type of the
    heading.  To remove the markup of the heading at the point,
    press <kbd>C-c C-k</kbd> to kill the heading and press <kbd>C-y</kbd> to yank the
    heading text back into the buffer.

  * Horizontal Rules: <kbd>C-c -</kbd>

    <kbd>C-c -</kbd> inserts a horizontal rule.  By default, insert the
    first string in the list `markdown-hr-strings` (the most
    prominent rule).  With a <kbd>C-u</kbd> prefix, insert the last string.
    With a numeric prefix <kbd>N</kbd>, insert the string in position <kbd>N</kbd>
    (counting from 1).

  * Markdown and Maintenance Commands: <kbd>C-c C-c</kbd>

    *Compile:* <kbd>C-c C-c m</kbd> will run Markdown on the current buffer
    and show the output in another buffer.  *Preview*: <kbd>C-c C-c p</kbd>
    runs Markdown on the current buffer and previews, stores the
    output in a temporary file, and displays the file in a browser.
    *Export:* <kbd>C-c C-c e</kbd> will run Markdown on the current buffer
    and save the result in the file `basename.html`, where
    `basename` is the name of the Markdown file with the extension
    removed.  *Export and View:* press <kbd>C-c C-c v</kbd> to export the
    file and view it in a browser.  **For both export commands, the
    output file will be overwritten without notice.**
    *Open:* <kbd>C-c C-c o</kbd> will open the Markdown source file directly
    using `markdown-open-command`.

    To summarize:

      - <kbd>C-c C-c m</kbd>: `markdown-command` > `*markdown-output*` buffer.
      - <kbd>C-c C-c p</kbd>: `markdown-command` > temporary file > browser.
      - <kbd>C-c C-c e</kbd>: `markdown-command` > `basename.html`.
      - <kbd>C-c C-c v</kbd>: `markdown-command` > `basename.html` > browser.
      - <kbd>C-c C-c w</kbd>: `markdown-command` > kill ring.
      - <kbd>C-c C-c o</kbd>: `markdown-open-command`.

    <kbd>C-c C-c c</kbd> will check for undefined references.  If there are
    any, a small buffer will open with a list of undefined
    references and the line numbers on which they appear.  In Emacs
    22 and greater, selecting a reference from this list and
    pressing <kbd>RET</kbd> will insert an empty reference definition at the
    end of the buffer.  Similarly, selecting the line number will
    jump to the corresponding line.

    <kbd>C-c C-c n</kbd> renumbers any ordered lists in the buffer that are
    out of sequence.

    <kbd>C-c C-c ]</kbd> completes all headings and normalizes all horizontal
    rules in the buffer.

  * Following Links: <kbd>C-c C-o</kbd>

    Press <kbd>C-c C-o</kbd> when the point is on an inline or reference
    link to open the URL in a browser.  When the point is at a
    wiki link, open it in another buffer (in the current window,
    or in the other window with the <kbd>C-u</kbd> prefix).  Use <kbd>M-p</kbd> and
    <kbd>M-n</kbd> to quickly jump to the previous or next link of any type.

  * Jumping: <kbd>C-c C-j</kbd>

    Use <kbd>C-c C-j</kbd> to jump from the object at point to its counterpart
    elsewhere in the text, when possible.  Jumps between reference
    links and definitions; between footnote markers and footnote
    text.  If more than one link uses the same reference name, a
    new buffer will be created containing clickable buttons for jumping
    to each link.  You may press <kbd>TAB</kbd> or <kbd>S-TAB</kbd> to jump between
    buttons in this window.

  * Promotion and Demotion: <kbd>C-c C--</kbd> and <kbd>C-c C-=</kbd>

    Headings, horizontal rules, and list items can be promoted and
    demoted, as well as bold and italic text.  For headings,
    "promotion" means *decreasing* the level (i.e., moving from
    `<h2>` to `<h1>`) while "demotion" means *increasing* the
    level.  For horizontal rules, promotion and demotion means
    moving backward or forward through the list of rule strings in
    `markdown-hr-strings`.  For bold and italic text, promotion and
    demotion means changing the markup from underscores to asterisks.
    Press <kbd>C-c C--</kbd> or <kbd>M-LEFT</kbd> to promote the element at the point
    if possible.

    To remember these commands, note that <kbd>-</kbd> is for decreasing the
    level (promoting), and <kbd>=</kbd> (on the same key as <kbd>+</kbd>) is for
    increasing the level (demoting).  Similarly, the left and right
    arrow keys indicate the direction that the atx heading markup
    is moving in when promoting or demoting.

  * Completion: <kbd>C-c C-]</kbd>

    Complete markup is in normalized form, which means, for
    example, that the underline portion of a setext header is the
    same length as the heading text, or that the number of leading
    and trailing hash marks of an atx header are equal and that
    there is no extra whitespace in the header text.  <kbd>C-c C-]</kbd>
    completes the markup at the point, if it is determined to be
    incomplete.

  * Editing Lists: <kbd>M-RET</kbd>, <kbd>M-UP</kbd>, <kbd>M-DOWN</kbd>, <kbd>M-LEFT</kbd>, and <kbd>M-RIGHT</kbd>

    New list items can be inserted with <kbd>M-RET</kbd>.  This command
    determines the appropriate marker (one of the possible
    unordered list markers or the next number in sequence for an
    ordered list) and indentation level by examining nearby list
    items.  If there is no list before or after the point, start a
    new list.  Prefix this command by <kbd>C-u</kbd> to decrease the
    indentation by one level.  Prefix this command by <kbd>C-u C-u</kbd> to
    increase the indentation by one level.

    Existing list items can be moved up or down with <kbd>M-UP</kbd> or
    <kbd>M-DOWN</kbd> and indented or exdented with <kbd>M-RIGHT</kbd> or <kbd>M-LEFT</kbd>.

  * Editing Subtrees: <kbd>M-S-UP</kbd>, <kbd>M-S-DOWN</kbd>, <kbd>M-S-LEFT</kbd>, and <kbd>M-S-RIGHT</kbd>

    Entire subtrees of ATX headings can be promoted and demoted
    with <kbd>M-S-LEFT</kbd> and <kbd>M-S-RIGHT</kbd>, which mirror the bindings
    for promotion and demotion of list items. Similarly, subtrees
    can be moved up and down with <kbd>M-S-UP</kbd> and <kbd>M-S-DOWN</kbd>.

    Please note the following "boundary" behavior for promotion and
    demotion.  Any level-six headings will not be demoted further
    (i.e., they remain at level six, since Markdown and HTML define
    only six levels) and any level-one headings will promoted away
    entirely (i.e., heading markup will be removed, since a
    level-zero heading is not defined).

  * Shifting the Region: <kbd>C-c <</kbd> and <kbd>C-c ></kbd>

    Text in the region can be indented or exdented as a group using
    <kbd>C-c ></kbd> to indent to the next indentation point (calculated in
    the current context), and <kbd>C-c <</kbd> to exdent to the previous
    indentation point.  These keybindings are the same as those for
    similar commands in `python-mode`.

  * Killing Elements: <kbd>C-c C-k</kbd>

    Press <kbd>C-c C-k</kbd> to kill the thing at point and add important
    text, without markup, to the kill ring.  Possible things to
    kill include (roughly in order of precedece): inline code,
    headings, horizonal rules, links (add link text to kill ring),
    images (add alt text to kill ring), angle URIs, email
    addresses, bold, italics, reference definitions (add URI to
    kill ring), footnote markers and text (kill both marker and
    text, add text to kill ring), and list items.

  * Outline Navigation: <kbd>C-c C-n</kbd>, <kbd>C-c C-p</kbd>, <kbd>C-c C-f</kbd>, <kbd>C-c C-b</kbd>, and <kbd>C-c C-u</kbd>

    Navigation between headings is possible using `outline-mode`.
    Use <kbd>C-c C-n</kbd> and <kbd>C-c C-p</kbd> to move between the next and previous
    visible headings.  Similarly, <kbd>C-c C-f</kbd> and <kbd>C-c C-b</kbd> move to the
    next and previous visible headings at the same level as the one
    at the point.  Finally, <kbd>C-c C-u</kbd> will move up to a lower-level
    (higher precedence) visible heading.

  * Movement by Paragraph or Block: <kbd>M-{</kbd> and <kbd>M-}</kbd>

    The definition of a "paragraph" is slightly different in
    markdown-mode than, say, text-mode, because markdown-mode
    supports filling for list items and respects hard line breaks,
    both of which break paragraphs.  So, markdown-mode overrides
    the usual paragraph navigation commands <kbd>M-{</kbd> and <kbd>M-}</kbd> so that
    with a <kbd>C-u</kbd> prefix, these commands jump to the beginning or
    end of an entire block of text, respectively, where "blocks"
    are separated by one or more lines.

  * Movement by Defun: <kbd>C-M-a</kbd>, <kbd>C-M-e</kbd>, and <kbd>C-M-h</kbd>

    The usual Emacs commands can be used to move by defuns
    (top-level major definitions).  In markdown-mode, a defun is a
    section.  As usual, <kbd>C-M-a</kbd> will move the point to the
    beginning of the current or preceding defun, <kbd>C-M-e</kbd> will move
    to the end of the current or following defun, and <kbd>C-M-h</kbd> will
    put the region around the entire defun.

As noted, many of the commands above behave differently depending
on whether Transient Mark mode is enabled or not.  When it makes
sense, if Transient Mark mode is on and the region is active, the
command applies to the text in the region (e.g., <kbd>C-c C-s s</kbd> makes the
region bold).  For users who prefer to work outside of Transient
Mark mode, since Emacs 22 it can be enabled temporarily by pressing
<kbd>C-SPC C-SPC</kbd>.  When this is not the case, many commands then
proceed to look work with the word or line at the point.

When applicable, commands that specifically act on the region even
outside of Transient Mark mode have the same keybinding as their
standard counterpart, but the letter is uppercase.  For example,
`markdown-insert-blockquote` is bound to <kbd>C-c C-s b</kbd> and only acts on
the region in Transient Mark mode while `markdown-blockquote-region`
is bound to <kbd>C-c C-s B</kbd> and always applies to the region (when nonempty).

Note that these region-specific functions are useful in many
cases where it may not be obvious.  For example, yanking text from
the kill ring sets the mark at the beginning of the yanked text
and moves the point to the end.  Therefore, the (inactive) region
contains the yanked text.  So, <kbd>C-y</kbd> followed by <kbd>C-c C-s C-b</kbd> will
yank text and turn it into a blockquote.

markdown-mode attempts to be flexible in how it handles
indentation.  When you press <kbd>TAB</kbd> repeatedly, the point will cycle
through several possible indentation levels corresponding to things
you might have in mind when you press <kbd>RET</kbd> at the end of a line or
<kbd>TAB</kbd>.  For example, you may want to start a new list item,
continue a list item with hanging indentation, indent for a nested
pre block, and so on.  Exdention is handled similarly when backspace
is pressed at the beginning of the non-whitespace portion of a line.

markdown-mode supports outline-minor-mode as well as org-mode-style
visibility cycling for atx- or hash-style headings.  There are two
types of visibility cycling: Pressing <kbd>S-TAB</kbd> cycles globally between
the table of contents view (headings only), outline view (top-level
headings only), and the full document view.  Pressing <kbd>TAB</kbd> while the
point is at a heading will cycle through levels of visibility for the
subtree: completely folded, visible children, and fully visible.
Note that mixing hash and underline style headings will give undesired
results.

## Customization

Although no configuration is *necessary* there are a few things
that can be customized.  The <kbd>M-x customize-mode</kbd> command
provides an interface to all of the possible customizations:

  * `markdown-command` - the command used to run Markdown (default:
    `markdown`).  This variable may be customized to pass
    command-line options to your Markdown processor of choice.

  * `markdown-command-needs-filename` - set to <kbd>t</kbd> if
    `markdown-command` does not accept standard input (default:
    `nil`).  When `nil`, `markdown-mode` will pass the Markdown
    content to `markdown-command` using standard input (`stdin`).
    When set to <kbd>t</kbd>, `markdown-mode` will pass the name of the file
    as the final command-line argument to `markdown-command`.  Note
    that in the latter case, you will only be able to run
    `markdown-command` from buffers which are visiting a file.

  * `markdown-open-command` - the command used for calling a standalone
    Markdown previewer which is capable of opening Markdown source files
    directly (default: `nil`).  This command will be called
    with a single argument, the filename of the current buffer.
    A representative program is the Mac app [Marked 2][], a
    live-updating Markdown previewer which can be [called from a
    simple shell script](http://jblevins.org/log/marked-2-command).

  * `markdown-hr-strings` - list of strings to use when inserting
    horizontal rules.  Different strings will not be distinguished
    when converted to HTML--they will all be converted to
    `<hr/>`--but they may add visual distinction and style to plain
    text documents.  To maintain some notion of promotion and
    demotion, keep these sorted from largest to smallest.

  * `markdown-bold-underscore` - set to a non-nil value to use two
    underscores for bold instead of two asterisks (default: `nil`).

  * `markdown-italic-underscore` - set to a non-nil value to use
    underscores for italic instead of asterisks (default: `nil`).

  * `markdown-indent-function` - the function to use for automatic
    indentation (default: `markdown-indent-line`).

  * `markdown-indent-on-enter` - set to a non-nil value to
    automatically indent new lines when the enter key is pressed
    (default: <kbd>t</kbd>)

  * `markdown-wiki-link-alias-first` - set to a non-nil value to
    treat aliased wiki links like `[[link text|PageName]]`
    (default: <kbd>t</kbd>).  When set to nil, they will be treated as
    `[[PageName|link text]]`.

  * `markdown-uri-types` - a list of protocol schemes (e.g., "http")
    for URIs that `markdown-mode` should highlight.

  * `markdown-enable-math` - syntax highlighting for LaTeX
    fragments (default: `nil`).  Set this to <kbd>t</kbd> to turn on math
    support by default.  Math support can be toggled later using
    the function `markdown-enable-math`."

  * `markdown-css-paths` - CSS files to link to in XHTML output
    (default: `nil`).

  * `markdown-content-type` - when set to a nonempty string, an
    `http-equiv` attribute will be included in the XHTML `<head>`
    block (default: `""`).  If needed, the suggested values are
    `application/xhtml+xml` or `text/html`.  See also:
    `markdown-coding-system`.

  * `markdown-coding-system` - used for specifying the character
    set identifier in the `http-equiv` attribute when included
    (default: `nil`).  See `markdown-content-type`, which must
    be set before this variable has any effect.  When set to `nil`,
    `buffer-file-coding-system` will be used to automatically
    determine the coding system string (falling back to
    `iso-8859-1` when unavailable).  Common settings are `utf-8`
    and `iso-latin-1`.

  * `markdown-xhtml-header-content` - additional content to include
    in the XHTML `<head>` block (default: `""`).

  * `markdown-xhtml-standalone-regexp` - a regular expression which
    `markdown-mode` uses to determine whether the output of
    `markdown-command` is a standalone XHTML document or an XHTML
    fragment (default: `"^\\(<\\?xml\\|<!DOCTYPE\\|<html\\)"`).  If
    this regular expression not matched in the first five lines of
    output, `markdown-mode` assumes the output is a fragment and
    adds a header and footer.

  * `markdown-link-space-sub-char` - a character to replace spaces
    when mapping wiki links to filenames (default: `"_"`).
    For example, use an underscore for compatibility with the
    Python Markdown WikiLinks extension.  In `gfm-mode`, this is
    set to `"-"` to conform with GitHub wiki links.

  * `markdown-reference-location` - where to insert reference
    definitions (default: `header`).  The possible locations are
    the end of the document (`end`), after the current block
    (`immediately`), before the next header (`header`).

  * `markdown-footnote-location` - where to insert footnote text
    (default: `end`).  The set of location options is the same as
    for `markdown-reference-location`.

  * `markdown-font-lock-support-mode` - the variable
    `font-lock-support-mode` is made buffer-local and set to
    `markdown-font-lock-support-mode`, which is `jit-mode` by
    default. This is currently the default support mode in Emacs as
    well.  However, if fontification of multi-line constructs such
    as preformatted code blocks, nested lists, and so on is
    inaccurate, setting this to `nil` will allow more aggressive
    fontification at the expense of some performance.

  * `comment-auto-fill-only-comments` - variable is made
    buffer-local and set to `nil` by default.  In programming
    language modes, when this variable is non-nil, only comments
    will be filled by auto-fill-mode.  However, comments in
    Markdown documents are rare and the most users probably intend
    for the actual content of the document to be filled.  Making
    this variable buffer-local allows `markdown-mode` to override
    the default behavior induced when the global variable is non-nil.

  * `markdown-make-gfm-checkboxes-buttons` - Whether GitHub Flavored
    Markdown style checkboxes should be turned into buttons that can
    be toggled with mouse-1 or RET. If non-nil buttons are enabled, the
    default is t. This works in `markdown-mode` as well as `gfm-mode`.

Additionally, the faces used for syntax highlighting can be modified to
your liking by issuing <kbd>M-x customize-group RET markdown-faces</kbd>
or by using the "Markdown Faces" link at the bottom of the mode
customization screen.

[Marked 2]: https://itunes.apple.com/us/app/marked-2/id890031187?mt=12&uo=4&at=11l5Vs&ct=mm

## Extensions

Besides supporting the basic Markdown syntax, markdown-mode also
includes syntax highlighting for `[[Wiki Links]]` by default.  Wiki
links may be followed by pressing <kbd>C-c C-o</kbd> when the point
is at a wiki link.  Use <kbd>M-p</kbd> and <kbd>M-n</kbd> to quickly jump to the
previous and next links (including links of other types).
Aliased or piped wiki links of the form `[[link text|PageName]]`
are also supported.  Since some wikis reverse these components, set
`markdown-wiki-link-alias-first` to nil to treat them as
`[[PageName|link text]]`.  By default, Markdown Mode only searches
for target files in the current directory.  Sequential parent
directory search (as in [Ikiwiki][]) can be enabled by setting
`markdown-wiki-link-search-parent-directories` to a non-nil value.

[Ikiwiki]: https://ikiwiki.info

[SmartyPants][] support is possible by customizing `markdown-command`.
If you install `SmartyPants.pl` at, say, `/usr/local/bin/smartypants`,
then you can set `markdown-command` to `"markdown | smartypants"`.
You can do this either by using <kbd>M-x customize-group markdown</kbd>
or by placing the following in your `.emacs` file:

    (defun markdown-custom ()
      "markdown-mode-hook"
      (setq markdown-command "markdown | smartypants"))
    (add-hook 'markdown-mode-hook '(lambda() (markdown-custom)))

[SmartyPants]: http://daringfireball.net/projects/smartypants/

Syntax highlighting for mathematical expressions written
in LaTeX (only expressions denoted by `$..$`, `$$..$$`, or `\[..\]`)
can be enabled by setting `markdown-enable-math` to a non-nil value,
either via customize or by placing `(setq markdown-enable-math t)`
in `.emacs`, and then restarting Emacs or calling
`markdown-reload-extensions`.

## GitHub Flavored Markdown

A [GitHub Flavored Markdown][GFM] (GFM) mode, `gfm-mode`, is also
available.  The GitHub implementation of differs slightly from
standard Markdown.  The most important differences are that
newlines are significant, triggering hard line breaks, and that
underscores inside of words (e.g., variable names) need not be
escaped.  As such, `gfm-mode` turns off `auto-fill-mode` and turns
on `visual-line-mode` (or `longlines-mode` if `visual-line-mode` is
not available).  Underscores inside of words (such as
test_variable) will not trigger emphasis.

Wiki links in this mode will be treated as on GitHub, with hyphens
replacing spaces in filenames and where the first letter of the
filename capitalized.  For example, `[[wiki link]]` will map to a
file named `Wiki-link` with the same extension as the current file.

GFM code blocks, with optional programming language keywords, will
be highlighted.  They can be inserted with <kbd>C-c C-s P</kbd>.  If there
is an active region, the text in the region will be placed inside
the code block.  You will be prompted for the name of the language,
but may press enter to continue without naming a language.

Similarly, strike through text is supoorted in GFM mode and can be
inserted (and toggled) using <kbd>C-c C-s d</kbd>. Following the mnemonics
for the other style keybindings, the letter <kbd>d</kbd> coincides with the
HTML tag `<del>`.

For GFM preview can be powered by setting `markdown-command` to
use [Docter][].  This may also be configured to work with [Marked 2][]
for `markdown-open-command`.

[GFM]: http://github.github.com/github-flavored-markdown/
[Docter]: https://github.com/alampros/Docter

## Acknowledgments

markdown-mode has benefited greatly from the efforts of the
following people:

  * Cyril Brulebois for Debian packaging.
  * Conal Elliott for a font-lock regexp patch.
  * Edward O'Connor for a font-lock regexp fix and
    GitHub Flavored Markdown mode (`gfm-mode`).
  * Greg Bognar for menus and running
    `markdown` with an active region.
  * Daniel Burrows for filing Debian bug #456592.
  * Peter S. Galbraith for maintaining `emacs-goodies-el`.
  * Dmitry Dzhus for undefined reference checking.
  * Carsten Dominik for `org-mode`, from which the
    visibility cycling functionality was derived, and for a bug fix
    related to `orgtbl-mode`.
  * Bryan Kyle for indentation code.
  * Ben Voui for font-lock face customizations.
  * Ankit Solanki for `longlines.el`
    compatibility and custom CSS.
  * Hilko Bengen for proper XHTML output.
  * Jose A. Ortega Ruiz for Emacs 23 fixes.
  * Nelson Minar for `html-helper-mode`, from which
    comment matching functions were derived.
  * Alec Resnick for bug reports.
  * Joost Kremers for footnote-handling
    functions, bug reports regarding indentation, and
    fixes for byte-compilation warnings.
  * Peter Williams for `fill-paragraph`
    enhancements.
  * George Ogata for fixing several
    byte-compilation warnings.
  * Eric Merritt for wiki link features.
  * Philippe Ivaldi for XHTML preview
    customizations and XHTML export.
  * Jeremiah Dodds for supporting
    Markdown processors which do not accept input from stdin.
  * Werner Dittmann for bug reports
    regarding the `cl` dependency and `auto-fill-mode` and indentation.
  * Scott Pfister for generalizing the space
    substitution character for mapping wiki links to filenames.
  * Marcin Kasperski for a patch to
    escape shell commands.
  * Christopher J. Madsen for patches to fix a match
    data bug and to prefer `visual-line-mode` in `gfm-mode`.
  * Shigeru Fukaya for better adherence to
    Emacs Lisp coding conventions.
  * Donald Ephraim Curtis for fixing the `fill-paragraph`
    regexp, refactoring the compilation and preview functions,
    heading font-lock generalizations, list renumbering,
    and kill ring save.
  * Kevin Porter for wiki link handling in `gfm-mode`.
  * Max Penet and Peter Eisentraut <peter_e@gmx.net>
    for an autoload token for `gfm-mode`.
  * Ian Yang for improving the reference definition regex.
  * Akinori Musha for an imenu index function.
  * Michael Sperber for XEmacs fixes.
  * Francois Gannaz for suggesting charset
    declaration in XHTML output.
  * Zhenlei Jia for smart exdention function.
  * Matus Goljer for improved wiki link following
    and GFM code block insertion.
  * Peter Jones for link following functions.
  * Bryan Fink for a bug report regarding
    externally modified files.
  * Vegard Vesterheim for a bug fix
    related to `orgtbl-mode`.
  * Makoto Motohashi for before- and after-
    export hooks, unit test improvements, and updates to support
    wide characters.
  * Michael Dwyer for `gfm-mode` underscore regexp.
  * Chris Lott for suggesting reference label
    completion.
  * Gunnar Franke for a completion bug report.
  * David Glasser for a `paragraph-separate` fix.
  * Daniel Brotsky for better auto-fill defaults.
  * Samuel Freilich for improved filling
    behavior regarding list items, footnotes, and reference
    definitions, improved killing of footnotes, and numerous other
    tests and bug fixes.
  * Antonis Kanouras for strike through support.
  * Tim Visher for multiple CSS files and other
    general improvements.
  * Matt McClure for a patch to prevent
    overwriting source files with .html extensions upon export.
  * Roger Bolsius for ordered list improvements.
  * Google's Open Source Programs Office for recognizing the project with
    a monetary contribution in June 2015.
  * Howard Melman for supporting GFM checkboxes
    as buttons.

## Bugs

Although markdown-mode is developed and tested primarily using
GNU Emacs 24, compatibility with earlier Emacsen is also a
priority.

If you find any bugs in markdown-mode, please construct a test case
or a patch and open a ticket on the [GitHub issue tracker][issues].

 [issues]: https://github.com/jrblevin/markdown-mode/issues

## History

markdown-mode was written and is maintained by Jason Blevins.  The
first version was released on May 24, 2007.

  * 2007-05-24: Version 1.1
  * 2007-05-25: Version 1.2
  * 2007-06-05: [Version 1.3][]
  * 2007-06-29: Version 1.4
  * 2007-10-11: [Version 1.5][]
  * 2008-06-04: [Version 1.6][]
  * 2009-10-01: [Version 1.7][]
  * 2011-08-12: [Version 1.8][]
  * 2011-08-15: [Version 1.8.1][]
  * 2013-01-25: [Version 1.9][]
  * 2013-03-24: [Version 2.0][]

[Version 1.3]: http://jblevins.org/projects/markdown-mode/rev-1-3
[Version 1.5]: http://jblevins.org/projects/markdown-mode/rev-1-5
[Version 1.6]: http://jblevins.org/projects/markdown-mode/rev-1-6
[Version 1.7]: http://jblevins.org/projects/markdown-mode/rev-1-7
[Version 1.8]: http://jblevins.org/projects/markdown-mode/rev-1-8
[Version 1.8.1]: http://jblevins.org/projects/markdown-mode/rev-1-8-1
[Version 1.9]: http://jblevins.org/projects/markdown-mode/rev-1-9
[Version 2.0]: http://jblevins.org/projects/markdown-mode/rev-2-0

