# Variables and options
## Aria_pagecache_blocks_not_flushed
|name|value|
|----|-----|
|Name|`Aria_pagecache_blocks_not_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_blocks_not_flushed](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_blocks_not_flushed)|

## Aria_pagecache_blocks_unused
|name|value|
|----|-----|
|Name|`Aria_pagecache_blocks_unused`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_blocks_unused](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_blocks_unused)|

## Aria_pagecache_blocks_used
|name|value|
|----|-----|
|Name|`Aria_pagecache_blocks_used`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_blocks_used](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_blocks_used)|

## Aria_pagecache_read_requests
|name|value|
|----|-----|
|Name|`Aria_pagecache_read_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_read_requests](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_read_requests)|

## Aria_pagecache_reads
|name|value|
|----|-----|
|Name|`Aria_pagecache_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_reads](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_reads)|

## Aria_pagecache_write_requests
|name|value|
|----|-----|
|Name|`Aria_pagecache_write_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_write_requests](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_write_requests)|

## Aria_pagecache_writes
|name|value|
|----|-----|
|Name|`Aria_pagecache_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_writes](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_pagecache_writes)|

## Aria_transaction_log_syncs
|name|value|
|----|-----|
|Name|`Aria_transaction_log_syncs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_transaction_log_syncs](https://mariadb.com/kb/en/library/documentation/aria-server-status-variables/#aria_transaction_log_syncs)|

## aria_block_size
|name|value|
|----|-----|
|Name|`aria_block_size`|
|Command line|`--aria-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8192`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_block_size)|

## aria_checkpoint_interval
|name|value|
|----|-----|
|Name|`aria_checkpoint_interval`|
|Command line|`--aria-checkpoint-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`30`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_checkpoint_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_checkpoint_interval)|

## aria_checkpoint_log_activity
|name|value|
|----|-----|
|Name|`aria_checkpoint_log_activity`|
|Command line|`aria-checkpoint-log-activity=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1048576`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_checkpoint_log_activity](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_checkpoint_log_activity)|

## aria_encrypt_tables
|name|value|
|----|-----|
|Name|`aria_encrypt_tables`|
|Command line|`aria-encrypt-tables={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_encrypt_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_encrypt_tables)|

## aria_force_start_after_recovery_failures
|name|value|
|----|-----|
|Name|`aria_force_start_after_recovery_failures`|
|Command line|`--aria-force-start-after-recovery-failures=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_force_start_after_recovery_failures](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_force_start_after_recovery_failures)|

## aria_group_commit
|name|value|
|----|-----|
|Name|`aria_group_commit`|
|Command line|`--aria_group_commit="value"`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`none`|
|Dynamic|`false`|
|Valid value(s)|`none`, `hard`, `soft`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_group_commit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_group_commit)|

## aria_group_commit_interval
|name|value|
|----|-----|
|Name|`aria_group_commit_interval`|
|Command line|`--aria_group_commit_interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0 (no waiting)`|
|Dynamic|`false`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_group_commit_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_group_commit_interval)|

## aria_log_file_size
|name|value|
|----|-----|
|Name|`aria_log_file_size`|
|Command line|`--aria-log-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1073741824`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_log_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_log_file_size)|

## aria_log_purge_type
|name|value|
|----|-----|
|Name|`aria_log_purge_type`|
|Command line|`--aria-log-purge-type=name`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`immediate`|
|Dynamic|`true`|
|Valid value(s)|`immediate`, `external`, `at_flush`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_log_purge_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_log_purge_type)|

## aria_max_sort_file_size
|name|value|
|----|-----|
|Name|`aria_max_sort_file_size`|
|Command line|`--aria-max-sort-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`9223372036853727232`|
|Dynamic|`true`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_max_sort_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_max_sort_file_size)|

## aria_page_checksum
|name|value|
|----|-----|
|Name|`aria_page_checksum`|
|Command line|`--aria-page-checksum=#`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_page_checksum](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_page_checksum)|

## aria_pagecache_age_threshold
|name|value|
|----|-----|
|Name|`aria_pagecache_age_threshold`|
|Command line|`--aria-pagecache-age-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`300`|
|Dynamic|`true`|
|Range|from: `100` to: `9999900`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_age_threshold](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_pagecache_age_threshold)|

## aria_pagecache_buffer_size
|name|value|
|----|-----|
|Name|`aria_pagecache_buffer_size`|
|Command line|`--aria-pagecache-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`134217720 (128MB)`|
|Dynamic|`false`|
|Range|from: `131072` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_pagecache_buffer_size)|

## aria_pagecache_division_limit
|name|value|
|----|-----|
|Name|`aria_pagecache_division_limit`|
|Command line|`--aria-pagecache-division-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_division_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_pagecache_division_limit)|

## aria_pagecache_file_hash_size
|name|value|
|----|-----|
|Name|`aria_pagecache_file_hash_size`|
|Command line|`--aria-pagecache-file-hash-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`512`|
|Dynamic|`false`|
|Range|from: `128` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_pagecache_file_hash_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_pagecache_file_hash_size)|

## aria_recover
|name|value|
|----|-----|
|Name|`aria_recover`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_recover](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_recover)|

## aria_recover_options
|name|value|
|----|-----|
|Name|`aria_recover_options`|
|Command line|`--aria-recover-options[=#]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`BACKUP,QUICK (>= MariaDB 10.2.4), NORMAL (<= MariaDB 10.2.3)`|
|Dynamic|`true`|
|Valid value(s)|`NORMAL`, `BACKUP`, `FORCE`, `QUICK`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_recover_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_recover_options)|

## aria_repair_threads
|name|value|
|----|-----|
|Name|`aria_repair_threads`|
|Command line|`--aria-repair-threads=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_repair_threads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_repair_threads)|

## aria_sort_buffer_size
|name|value|
|----|-----|
|Name|`aria_sort_buffer_size`|
|Command line|`--aria-sort-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`268434432 (from MariaDB 10.0.3), 134217728 (before MariaDB 10.0.3)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_sort_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_sort_buffer_size)|

## aria_stats_method
|name|value|
|----|-----|
|Name|`aria_stats_method`|
|Command line|`--aria-stats-method=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`nulls_unequal`|
|Dynamic|`true`|
|Valid value(s)|`nulls_equal`, `nulls_unequal`, `nulls_ignored`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_stats_method](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_stats_method)|

## aria_sync_log_dir
|name|value|
|----|-----|
|Name|`aria_sync_log_dir`|
|Command line|`--aria-sync-log-dir=#`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NEWFILE`|
|Dynamic|`true`|
|Valid value(s)|`NEWFILE`, `NEVER`, `ALWAYS`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_sync_log_dir](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_sync_log_dir)|

## aria_used_for_temp_tables
|name|value|
|----|-----|
|Name|`aria_used_for_temp_tables`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aria_used_for_temp_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#aria_used_for_temp_tables)|

## deadlock_search_depth_long
|name|value|
|----|-----|
|Name|`deadlock_search_depth_long`|
|Command line|`--deadlock-search-depth-long=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`15`|
|Dynamic|`true`|
|Range|from: `0` to: `33`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[deadlock_search_depth_long](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#deadlock_search_depth_long)|

## deadlock_search_depth_short
|name|value|
|----|-----|
|Name|`deadlock_search_depth_short`|
|Command line|`--deadlock-search-depth-short=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4`|
|Dynamic|`true`|
|Range|from: `0` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[deadlock_search_depth_short](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#deadlock_search_depth_short)|

## deadlock_timeout_long
|name|value|
|----|-----|
|Name|`deadlock_timeout_long`|
|Command line|`--deadlock-timeout-long=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`50000000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[deadlock_timeout_long](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#deadlock_timeout_long)|

## deadlock_timeout_short
|name|value|
|----|-----|
|Name|`deadlock_timeout_short`|
|Command line|`--deadlock-timeout-short=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`10000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[deadlock_timeout_short](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/aria/aria-system-variables/#deadlock_timeout_short)|

## Cassandra_multiget_keys_scanned
|name|value|
|----|-----|
|Name|`Cassandra_multiget_keys_scanned`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_multiget_keys_scanned](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_multiget_keys_scanned)|

## Cassandra_multiget_reads
|name|value|
|----|-----|
|Name|`Cassandra_multiget_reads`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_multiget_reads](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_multiget_reads)|

## Cassandra_multiget_rows_read
|name|value|
|----|-----|
|Name|`Cassandra_multiget_rows_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_multiget_rows_read](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_multiget_rows_read)|

## Cassandra_network_exceptions
|name|value|
|----|-----|
|Name|`Cassandra_network_exceptions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_network_exceptions](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_network_exceptions)|

## Cassandra_row_insert_batches
|name|value|
|----|-----|
|Name|`Cassandra_row_insert_batches`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_row_insert_batches](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_row_insert_batches)|

## Cassandra_row_inserts
|name|value|
|----|-----|
|Name|`Cassandra_row_inserts`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_row_inserts](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_row_inserts)|

## Cassandra_timeout_exceptions
|name|value|
|----|-----|
|Name|`Cassandra_timeout_exceptions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_timeout_exceptions](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_timeout_exceptions)|

## Cassandra_unavailable_exceptions
|name|value|
|----|-----|
|Name|`Cassandra_unavailable_exceptions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_unavailable_exceptions](https://mariadb.com/kb/en/library/documentation/cassandra-status-variables/#cassandra_unavailable_exceptions)|

## cassandra_default_thrift_host
|name|value|
|----|-----|
|Name|`cassandra_default_thrift_host`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_default_thrift_host](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_default_thrift_host)|

## cassandra_failure_retries
|name|value|
|----|-----|
|Name|`cassandra_failure_retries`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`3`|
|Dynamic|`true`|
|Valid value(s)|`1`, `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_failure_retries](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_failure_retries)|

## cassandra_insert_batch_size
|name|value|
|----|-----|
|Name|`cassandra_insert_batch_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100`|
|Dynamic|`true`|
|Valid value(s)|`1`, `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_insert_batch_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_insert_batch_size)|

## cassandra_multiget_batch_size
|name|value|
|----|-----|
|Name|`cassandra_multiget_batch_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100`|
|Dynamic|`true`|
|Valid value(s)|`1`, `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_multiget_batch_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_multiget_batch_size)|

## cassandra_read_consistency
|name|value|
|----|-----|
|Name|`cassandra_read_consistency`|
|Scope|`global`, `session`|
|Default value|`ONE`|
|Valid value(s)|`ONE`, `TWO`, `THREE`, `ANY`, `ALL`, `QUORUM`, `EACH_QUORUM`, `LOCAL_QUORUM`, `
`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_read_consistency](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_read_consistency)|

## cassandra_rnd_batch_size
|name|value|
|----|-----|
|Name|`cassandra_rnd_batch_size`|
|Scope|`global`, `session`|
|Default value|`10000`|
|Valid value(s)|`1`, `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_rnd_batch_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_rnd_batch_size)|

## cassandra_write_consistency
|name|value|
|----|-----|
|Name|`cassandra_write_consistency`|
|Scope|`global`, `session`|
|Default value|`ONE`|
|Valid value(s)|`ONE`, `TWO`, `THREE`, `ANY`, `ALL`, `QUORUM`, `EACH_QUORUM`, `LOCAL_QUORUM`, `
`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cassandra_write_consistency](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/cassandra/cassandra-system-variables/#cassandra_write_consistency)|

## connect_class_path
|name|value|
|----|-----|
|Name|`connect_class_path`|
|Command line|`--connect-class-path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_class_path](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_class_path)|

## connect_cond_push
|name|value|
|----|-----|
|Name|`connect_cond_push`|
|Command line|`--connect-cond-push={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_cond_push](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_cond_push)|

## connect_conv_size
|name|value|
|----|-----|
|Name|`connect_conv_size`|
|Command line|`--connect-conv-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`>= MariaDB 10.4.8, MariaDB 10.3.18, MariaDB 10.2.27: 1024, <= MariaDB 10.4.7, MariaDB 10.3.17, MariaDB 10.2.26: 8192`|
|Dynamic|`true`|
|Range|from: `0` to: `65500`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_conv_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_conv_size)|

## connect_default_depth
|name|value|
|----|-----|
|Name|`connect_default_depth`|
|Command line|`--connect-default-depth=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `-1` to: `16`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_default_depth](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_default_depth)|

## connect_default_prec
|name|value|
|----|-----|
|Name|`connect_default_prec`|
|Command line|`--connect-default-prec=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`6`|
|Dynamic|`true`|
|Range|from: `0` to: `16`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_default_prec](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_default_prec)|

## connect_enable_mongo
|name|value|
|----|-----|
|Name|`connect_enable_mongo`|
|Command line|`--connect-enable-mongo={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_enable_mongo](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_enable_mongo)|

## connect_exact_info
|name|value|
|----|-----|
|Name|`connect_exact_info`|
|Command line|`--connect-exact-info={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_exact_info](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_exact_info)|

## connect_force_bson
|name|value|
|----|-----|
|Name|`connect_force_bson`|
|Command line|`--connect-force-bson={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_force_bson](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_force_bson)|

## connect_indx_map
|name|value|
|----|-----|
|Name|`connect_indx_map`|
|Command line|`--connect-indx-map=#`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_indx_map](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_indx_map)|

## connect_java_wrapper
|name|value|
|----|-----|
|Name|`connect_java_wrapper`|
|Command line|`--connect-java-wrapper=val`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`wrappers/JdbcInterface`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_java_wrapper](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_java_wrapper)|

## connect_json_all_path
|name|value|
|----|-----|
|Name|`connect_json_all_path`|
|Command line|`--connect-json-all-path={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_json_all_path](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_json_all_path)|

## connect_json_grp_size
|name|value|
|----|-----|
|Name|`connect_json_grp_size`|
|Command line|`--connect-json-grp-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`50 (>= Connect 1.7.0003), 10 (<= Connect 1.7.0002)`|
|Dynamic|`true`|
|Range|from: `1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_json_grp_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_json_grp_size)|

## connect_json_null
|name|value|
|----|-----|
|Name|`connect_json_null`|
|Command line|`--connect-json-null=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`<null>`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_json_null](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_json_null)|

## connect_jvm_path
|name|value|
|----|-----|
|Name|`connect_jvm_path`|
|Command line|`--connect-jvm_path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_jvm_path](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_jvm_path)|

## connect_type_conv
|name|value|
|----|-----|
|Name|`connect_type_conv`|
|Command line|`--connect-type-conv=#`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`YES`|
|Dynamic|`true`|
|Valid value(s)|`NO`, `YES`, `FORCE`, `SKIP`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_type_conv](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_type_conv)|

## connect_use_tempfile
|name|value|
|----|-----|
|Name|`connect_use_tempfile`|
|Command line|`--connect-use-tempfile=#`|
|Type of variable|`enumeration`|
|Scope|`session`|
|Default value|`AUTO`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_use_tempfile](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_use_tempfile)|

## connect_work_size
|name|value|
|----|-----|
|Name|`connect_work_size`|
|Command line|`--connect-work-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`67108864`|
|Dynamic|`true`|
|Range|from: `4194304` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_work_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_work_size)|

## connect_xtrace
|name|value|
|----|-----|
|Name|`connect_xtrace`|
|Command line|`--connect-xtrace=#`|
|Type of variable|`set`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_xtrace](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/connect/connect-system-variables/#connect_xtrace)|

## wsrep_applier_thread_count
|name|value|
|----|-----|
|Name|`wsrep_applier_thread_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_applier_thread_count](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_applier_thread_count)|

## wsrep_apply_oooe
|name|value|
|----|-----|
|Name|`wsrep_apply_oooe`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_apply_oooe](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_apply_oooe)|

## wsrep_apply_oool
|name|value|
|----|-----|
|Name|`wsrep_apply_oool`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_apply_oool](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_apply_oool)|

## wsrep_apply_window
|name|value|
|----|-----|
|Name|`wsrep_apply_window`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_apply_window](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_apply_window)|

## wsrep_cert_deps_distance
|name|value|
|----|-----|
|Name|`wsrep_cert_deps_distance`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cert_deps_distance](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cert_deps_distance)|

## wsrep_cert_index_size
|name|value|
|----|-----|
|Name|`wsrep_cert_index_size`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cert_index_size](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cert_index_size)|

## wsrep_cert_interval
|name|value|
|----|-----|
|Name|`wsrep_cert_interval`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cert_interval](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cert_interval)|

## wsrep_cluster_capabilities
|name|value|
|----|-----|
|Name|`wsrep_cluster_capabilities`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_capabilities](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_capabilities)|

## wsrep_cluster_conf_id
|name|value|
|----|-----|
|Name|`wsrep_cluster_conf_id`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_conf_id](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_conf_id)|

## wsrep_cluster_size
|name|value|
|----|-----|
|Name|`wsrep_cluster_size`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_size](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_size)|

## wsrep_cluster_state_uuid
|name|value|
|----|-----|
|Name|`wsrep_cluster_state_uuid`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_state_uuid](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_state_uuid)|

## wsrep_cluster_status
|name|value|
|----|-----|
|Name|`wsrep_cluster_status`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_status](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_status)|

## wsrep_cluster_weight
|name|value|
|----|-----|
|Name|`wsrep_cluster_weight`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_weight](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_cluster_weight)|

## wsrep_commit_oooe
|name|value|
|----|-----|
|Name|`wsrep_commit_oooe`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_commit_oooe](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_commit_oooe)|

## wsrep_commit_oool
|name|value|
|----|-----|
|Name|`wsrep_commit_oool`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_commit_oool](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_commit_oool)|

## wsrep_commit_window
|name|value|
|----|-----|
|Name|`wsrep_commit_window`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_commit_window](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_commit_window)|

## wsrep_connected
|name|value|
|----|-----|
|Name|`wsrep_connected`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_connected](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_connected)|

## wsrep_desync_count
|name|value|
|----|-----|
|Name|`wsrep_desync_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_desync_count](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_desync_count)|

## wsrep_evs_delayed
|name|value|
|----|-----|
|Name|`wsrep_evs_delayed`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_evs_delayed](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_evs_delayed)|

## wsrep_evs_evict_list
|name|value|
|----|-----|
|Name|`wsrep_evs_evict_list`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_evs_evict_list](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_evs_evict_list)|

## wsrep_evs_repl_latency
|name|value|
|----|-----|
|Name|`wsrep_evs_repl_latency`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_evs_repl_latency](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_evs_repl_latency)|

## wsrep_evs_state
|name|value|
|----|-----|
|Name|`wsrep_evs_state`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_evs_state](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_evs_state)|

## wsrep_flow_control_paused
|name|value|
|----|-----|
|Name|`wsrep_flow_control_paused`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_flow_control_paused](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_flow_control_paused)|

## wsrep_flow_control_paused_ns
|name|value|
|----|-----|
|Name|`wsrep_flow_control_paused_ns`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_flow_control_paused_ns](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_flow_control_paused_ns)|

## wsrep_flow_control_recv
|name|value|
|----|-----|
|Name|`wsrep_flow_control_recv`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_flow_control_recv](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_flow_control_recv)|

## wsrep_flow_control_sent
|name|value|
|----|-----|
|Name|`wsrep_flow_control_sent`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_flow_control_sent](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_flow_control_sent)|

## wsrep_gcomm_uuid
|name|value|
|----|-----|
|Name|`wsrep_gcomm_uuid`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_gcomm_uuid](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_gcomm_uuid)|

## wsrep_incoming_addresses
|name|value|
|----|-----|
|Name|`wsrep_incoming_addresses`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_incoming_addresses](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_incoming_addresses)|

## wsrep_last_committed
|name|value|
|----|-----|
|Name|`wsrep_last_committed`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_last_committed](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_last_committed)|

## wsrep_local_bf_aborts
|name|value|
|----|-----|
|Name|`wsrep_local_bf_aborts`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_bf_aborts](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_bf_aborts)|

## wsrep_local_cached_downto
|name|value|
|----|-----|
|Name|`wsrep_local_cached_downto`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_cached_downto](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_cached_downto)|

## wsrep_local_cert_failures
|name|value|
|----|-----|
|Name|`wsrep_local_cert_failures`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_cert_failures](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_cert_failures)|

## wsrep_local_commits
|name|value|
|----|-----|
|Name|`wsrep_local_commits`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_commits](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_commits)|

## wsrep_local_index
|name|value|
|----|-----|
|Name|`wsrep_local_index`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_index](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_index)|

## wsrep_local_recv_queue
|name|value|
|----|-----|
|Name|`wsrep_local_recv_queue`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_recv_queue](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_recv_queue)|

## wsrep_local_recv_queue_avg
|name|value|
|----|-----|
|Name|`wsrep_local_recv_queue_avg`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_recv_queue_avg](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_recv_queue_avg)|

## wsrep_local_recv_queue_max
|name|value|
|----|-----|
|Name|`wsrep_local_recv_queue_max`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_recv_queue_max](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_recv_queue_max)|

## wsrep_local_recv_queue_min
|name|value|
|----|-----|
|Name|`wsrep_local_recv_queue_min`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_recv_queue_min](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_recv_queue_min)|

## wsrep_local_replays
|name|value|
|----|-----|
|Name|`wsrep_local_replays`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_replays](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_replays)|

## wsrep_local_send_queue
|name|value|
|----|-----|
|Name|`wsrep_local_send_queue`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_send_queue](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_send_queue)|

## wsrep_local_send_queue_avg
|name|value|
|----|-----|
|Name|`wsrep_local_send_queue_avg`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_send_queue_avg](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_send_queue_avg)|

## wsrep_local_send_queue_max
|name|value|
|----|-----|
|Name|`wsrep_local_send_queue_max`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_send_queue_max](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_send_queue_max)|

## wsrep_local_send_queue_min
|name|value|
|----|-----|
|Name|`wsrep_local_send_queue_min`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_send_queue_min](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_send_queue_min)|

## wsrep_local_state
|name|value|
|----|-----|
|Name|`wsrep_local_state`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_state](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_state)|

## wsrep_local_state_comment
|name|value|
|----|-----|
|Name|`wsrep_local_state_comment`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_state_comment](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_state_comment)|

## wsrep_local_state_uuid
|name|value|
|----|-----|
|Name|`wsrep_local_state_uuid`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_local_state_uuid](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_local_state_uuid)|

## wsrep_open_connections
|name|value|
|----|-----|
|Name|`wsrep_open_connections`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_open_connections](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_open_connections)|

## wsrep_open_transactions
|name|value|
|----|-----|
|Name|`wsrep_open_transactions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_open_transactions](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_open_transactions)|

## wsrep_protocol_version
|name|value|
|----|-----|
|Name|`wsrep_protocol_version`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_protocol_version](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_protocol_version)|

## wsrep_provider_name
|name|value|
|----|-----|
|Name|`wsrep_provider_name`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_provider_name](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_provider_name)|

## wsrep_provider_vendor
|name|value|
|----|-----|
|Name|`wsrep_provider_vendor`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_provider_vendor](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_provider_vendor)|

## wsrep_provider_version
|name|value|
|----|-----|
|Name|`wsrep_provider_version`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_provider_version](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_provider_version)|

## wsrep_ready
|name|value|
|----|-----|
|Name|`wsrep_ready`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_ready](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_ready)|

## wsrep_received
|name|value|
|----|-----|
|Name|`wsrep_received`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_received](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_received)|

## wsrep_received_bytes
|name|value|
|----|-----|
|Name|`wsrep_received_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_received_bytes](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_received_bytes)|

## wsrep_repl_data_bytes
|name|value|
|----|-----|
|Name|`wsrep_repl_data_bytes`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_repl_data_bytes](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_repl_data_bytes)|

## wsrep_repl_keys
|name|value|
|----|-----|
|Name|`wsrep_repl_keys`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_repl_keys](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_repl_keys)|

## wsrep_repl_keys_bytes
|name|value|
|----|-----|
|Name|`wsrep_repl_keys_bytes`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_repl_keys_bytes](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_repl_keys_bytes)|

## wsrep_repl_other_bytes
|name|value|
|----|-----|
|Name|`wsrep_repl_other_bytes`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_repl_other_bytes](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_repl_other_bytes)|

## wsrep_replicated
|name|value|
|----|-----|
|Name|`wsrep_replicated`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_replicated](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_replicated)|

## wsrep_replicated_bytes
|name|value|
|----|-----|
|Name|`wsrep_replicated_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_replicated_bytes](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_replicated_bytes)|

## wsrep_rollbacker_thread_count
|name|value|
|----|-----|
|Name|`wsrep_rollbacker_thread_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_rollbacker_thread_count](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_rollbacker_thread_count)|

## wsrep_thread_count
|name|value|
|----|-----|
|Name|`wsrep_thread_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_thread_count](https://mariadb.com/kb/en/library/documentation/galera-cluster-status-variables/#wsrep_thread_count)|

## wsrep_auto_increment_control
|name|value|
|----|-----|
|Name|`wsrep_auto_increment_control`|
|Command line|`--wsrep-auto-increment-control[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_auto_increment_control](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_auto_increment_control)|

## wsrep_causal_reads
|name|value|
|----|-----|
|Name|`wsrep_causal_reads`|
|Command line|`--wsrep-causal-reads[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_causal_reads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_causal_reads)|

## wsrep_certification_rules
|name|value|
|----|-----|
|Name|`wsrep_certification_rules`|
|Command line|`--wsrep-certifcation-rules`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`strict`|
|Dynamic|`true`|
|Valid value(s)|`strict`, `optimized`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_certification_rules](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_certification_rules)|

## wsrep_certify_nonPK
|name|value|
|----|-----|
|Name|`wsrep_certify_nonPK`|
|Command line|`--wsrep-certify-nonPK[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_certify_nonpk](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_certify_nonpk)|

## wsrep_cluster_address
|name|value|
|----|-----|
|Name|`wsrep_cluster_address`|
|Command line|`--wsrep-cluster-address=value`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_address](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_cluster_address)|

## wsrep_cluster_name
|name|value|
|----|-----|
|Name|`wsrep_cluster_name`|
|Command line|`--wsrep-cluster-name=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`my_wsrep_cluster`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_cluster_name](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_cluster_name)|

## wsrep_convert_LOCK_to_trx
|name|value|
|----|-----|
|Name|`wsrep_convert_LOCK_to_trx`|
|Command line|`--wsrep-convert-LOCK-to-trx[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_convert_lock_to_trx](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_convert_lock_to_trx)|

## wsrep_data_home_dir
|name|value|
|----|-----|
|Name|`wsrep_data_home_dir`|
|Command line|`--wsrep-data-home-dir=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`The datadir variable value.`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_data_home_dir](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_data_home_dir)|

## wsrep_dbug_option
|name|value|
|----|-----|
|Name|`wsrep_dbug_option`|
|Command line|`--wsrep-dbug-option=value`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_dbug_option](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_dbug_option)|

## wsrep_debug
|name|value|
|----|-----|
|Name|`wsrep_debug`|
|Command line|`--wsrep-debug[={0|1}]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE (>= MariaDB 10.4.3),  OFF (<= MariaDB 10.4.2)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_debug](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_debug)|

## wsrep_desync
|name|value|
|----|-----|
|Name|`wsrep_desync`|
|Command line|`--wsrep-desync[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_desync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_desync)|

## wsrep_dirty_reads
|name|value|
|----|-----|
|Name|`wsrep_dirty_reads`|
|Command line|`--wsrep-dirty-reads[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_dirty_reads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_dirty_reads)|

## wsrep_drupal_282555_workaround
|name|value|
|----|-----|
|Name|`wsrep_drupal_282555_workaround`|
|Command line|`--wsrep-drupal-282555-workaround[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_drupal_282555_workaround](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_drupal_282555_workaround)|

## wsrep_forced_binlog_format
|name|value|
|----|-----|
|Name|`wsrep_forced_binlog_format`|
|Command line|`--wsrep-forced-binlog-format=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE`|
|Dynamic|`true`|
|Valid value(s)|`STATEMENT`, `ROW`, `MIXED`, `NONE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_forced_binlog_format](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_forced_binlog_format)|

## wsrep_gtid_domain_id
|name|value|
|----|-----|
|Name|`wsrep_gtid_domain_id`|
|Command line|`--wsrep-gtid-domain-id=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_gtid_domain_id](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_gtid_domain_id)|

## wsrep_gtid_mode
|name|value|
|----|-----|
|Name|`wsrep_gtid_mode`|
|Command line|`--wsrep-gtid-mode[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_gtid_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_gtid_mode)|

## wsrep_gtid_seq_no
|name|value|
|----|-----|
|Name|`wsrep_gtid_seq_no`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_gtid_seq_no](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_gtid_seq_no)|

## wsrep_ignore_apply_errors
|name|value|
|----|-----|
|Name|`wsrep_ignore_apply_errors`|
|Command line|`--wsrep-ignore-apply-errors`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`7`|
|Dynamic|`true`|
|Range|from: `0` to: `7`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_ignore_apply_errors](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_ignore_apply_errors)|

## wsrep_load_data_splitting
|name|value|
|----|-----|
|Name|`wsrep_load_data_splitting`|
|Command line|`--wsrep-load-data-splitting[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF (>= MariaDB 10.4.3), ON (<= MariaDB 10.4.2)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_load_data_splitting](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_load_data_splitting)|

## wsrep_log_conflicts
|name|value|
|----|-----|
|Name|`wsrep_log_conflicts`|
|Command line|`--wsrep-log-conflicts[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_log_conflicts](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_log_conflicts)|

## wsrep_max_ws_rows
|name|value|
|----|-----|
|Name|`wsrep_max_ws_rows`|
|Command line|`--wsrep-max-ws-rows=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0 (>= MariaDB Galera 10.0.27, MariaDB 10.1.17), 131072 (<= MariaDB Galera 10.0.26, MariaDB 10.1.16)`|
|Dynamic|`true`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_max_ws_rows](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_max_ws_rows)|

## wsrep_max_ws_size
|name|value|
|----|-----|
|Name|`wsrep_max_ws_size`|
|Command line|`--wsrep-max-ws-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2147483647 (2GB, >= MariaDB Galera 10.0.27, MariaDB 10.1.17), 1073741824 (1GB, <= MariaDB Galera 10.0.26, MariaDB 10.1.16)`|
|Dynamic|`true`|
|Range|from: `1024` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_max_ws_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_max_ws_size)|

## wsrep_mode
|name|value|
|----|-----|
|Name|`wsrep_mode`|
|Command line|`--wsrep-mode=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|
|Valid value(s)|`BINLOG_ROW_FORMAT_ONLY`, `DISALLOW_LOCAL_GTID`, `REQUIRED_PRIMARY_KEY`, `REPLICATE_ARIA`, `REPLICATE_MYISAM`, `STRICT_REPLICATION`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_mode)|

## wsrep_mysql_replication_bundle
|name|value|
|----|-----|
|Name|`wsrep_mysql_replication_bundle`|
|Command line|`--wsrep-mysql-replication-bundle=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_mysql_replication_bundle](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_mysql_replication_bundle)|

## wsrep_node_address
|name|value|
|----|-----|
|Name|`wsrep_node_address`|
|Command line|`--wsrep-node-address=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Primary network address, usually eth0 with a default port of 4567, or 0.0.0.0 if no IP address.`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_node_address](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_node_address)|

## wsrep_node_incoming_address
|name|value|
|----|-----|
|Name|`wsrep_node_incoming_address`|
|Command line|`--wsrep-node-incoming-address=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`AUTO`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_node_incoming_address](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_node_incoming_address)|

## wsrep_node_name
|name|value|
|----|-----|
|Name|`wsrep_node_name`|
|Command line|`--wsrep-node-name=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`The server's hostname.`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_node_name](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_node_name)|

## wsrep_notify_cmd
|name|value|
|----|-----|
|Name|`wsrep_notify_cmd`|
|Command line|`--wsrep-notify-command=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_notify_cmd](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_notify_cmd)|

## wsrep_on
|name|value|
|----|-----|
|Name|`wsrep_on`|
|Command line|`--wsrep-on[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF (>= MariaDB 10.1), ON (<= MariaDB Galera Cluster 10.0),`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_on](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_on)|

## wsrep_OSU_method
|name|value|
|----|-----|
|Name|`wsrep_OSU_method`|
|Command line|`--wsrep-OSU-method[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`TOI`|
|Dynamic|`true`|
|Valid value(s)|`TOI`, `RSU`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_osu_method](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_osu_method)|

## wsrep_patch_version
|name|value|
|----|-----|
|Name|`wsrep_patch_version`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`None`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_patch_version](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_patch_version)|

## wsrep_provider
|name|value|
|----|-----|
|Name|`wsrep_provider`|
|Command line|`--wsrep-provider=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`None`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_provider](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_provider)|

## wsrep_provider_options
|name|value|
|----|-----|
|Name|`wsrep_provider_options`|
|Command line|`--wsrep-provider-options=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_provider_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_provider_options)|

## wsrep_recover
|name|value|
|----|-----|
|Name|`wsrep_recover`|
|Command line|`--wsrep-recover[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_recover](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_recover)|

## wsrep_reject_queries
|name|value|
|----|-----|
|Name|`wsrep_reject_queries`|
|Command line|`--wsrep-reject-queries[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE`|
|Dynamic|`true`|
|Valid value(s)|`NONE`, `ALL`, `ALL_KILL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_reject_queries](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_reject_queries)|

## wsrep_replicate_myisam
|name|value|
|----|-----|
|Name|`wsrep_replicate_myisam`|
|Command line|`--wsrep-replicate-myisam[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_replicate_myisam](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_replicate_myisam)|

## wsrep_restart_slave
|name|value|
|----|-----|
|Name|`wsrep_restart_slave`|
|Command line|`--wsrep-restart-slave[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_restart_slave](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_restart_slave)|

## wsrep_retry_autocommit
|name|value|
|----|-----|
|Name|`wsrep_retry_autocommit`|
|Command line|`--wsrep-retry-autocommit=value`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `0` to: `10000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_retry_autocommit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_retry_autocommit)|

## wsrep_slave_FK_checks
|name|value|
|----|-----|
|Name|`wsrep_slave_FK_checks`|
|Command line|`--wsrep-slave-FK-checks[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_slave_fk_checks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_slave_fk_checks)|

## wsrep_slave_threads
|name|value|
|----|-----|
|Name|`wsrep_slave_threads`|
|Command line|`--wsrep-slave-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `512`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_slave_threads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_slave_threads)|

## wsrep_slave_UK_checks
|name|value|
|----|-----|
|Name|`wsrep_slave_UK_checks`|
|Command line|`--wsrep-slave-UK-checks[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_slave_uk_checks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_slave_uk_checks)|

## wsrep_sr_store
|name|value|
|----|-----|
|Name|`wsrep_sr_store`|
|Command line|`--wsrep-sr-store=val`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`table`|
|Dynamic|`false`|
|Valid value(s)|`table`, `none`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sr_store](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sr_store)|

## wsrep_sst_auth
|name|value|
|----|-----|
|Name|`wsrep_sst_auth`|
|Command line|`--wsrep-sst-auth=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sst_auth](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sst_auth)|

## wsrep_sst_donor
|name|value|
|----|-----|
|Name|`wsrep_sst_donor`|
|Command line|`--wsrep-sst-donor=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sst_donor](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sst_donor)|

## wsrep_sst_donor_rejects_queries
|name|value|
|----|-----|
|Name|`wsrep_sst_donor_rejects_queries`|
|Command line|`--wsrep-sst-donor-rejects-queries[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sst_donor_rejects_queries](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sst_donor_rejects_queries)|

## wsrep_sst_method
|name|value|
|----|-----|
|Name|`wsrep_sst_method`|
|Command line|`--wsrep-sst-method=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`rsync`|
|Dynamic|`true`|
|Valid value(s)|`rsync`, `mysqldump`, `xtrabackup`, `xtrabackup-v2`, `mariabackup`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sst_method](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sst_method)|

## wsrep_sst_receive_address
|name|value|
|----|-----|
|Name|`wsrep_sst_receive_address`|
|Command line|`--wsrep-sst-receive-address=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`AUTO`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sst_receive_address](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sst_receive_address)|

## wsrep_start_position
|name|value|
|----|-----|
|Name|`wsrep_start_position`|
|Command line|`--wsrep-start-position=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`00000000-0000-0000-0000-000000000000:-1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_start_position](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_start_position)|

## wsrep_strict_ddl
|name|value|
|----|-----|
|Name|`wsrep_strict_ddl`|
|Command line|`--wsrep-strict-ddl[={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_strict_ddl](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_strict_ddl)|

## wsrep_sync_wait
|name|value|
|----|-----|
|Name|`wsrep_sync_wait`|
|Command line|`--wsrep-sync-wait=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `15`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_sync_wait](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_sync_wait)|

## wsrep_trx_fragment_size
|name|value|
|----|-----|
|Name|`wsrep_trx_fragment_size`|
|Command line|`--wsrep-trx-fragment-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_trx_fragment_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_trx_fragment_size)|

## wsrep_trx_fragment_unit
|name|value|
|----|-----|
|Name|`wsrep_trx_fragment_unit`|
|Command line|`--wsrep-trx-fragment-unit=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`bytes`|
|Dynamic|`true`|
|Valid value(s)|`bytes`, `rows`, `statements`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wsrep_trx_fragment_unit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/galera-cluster/galera-cluster-system-variables/#wsrep_trx_fragment_unit)|

## gtid_slave_pos
|name|value|
|----|-----|
|Name|`gtid_slave_pos`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Null`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_slave_pos](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_slave_pos)|

## gtid_binlog_pos
|name|value|
|----|-----|
|Name|`gtid_binlog_pos`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Null`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_binlog_pos](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_binlog_pos)|

## gtid_binlog_state
|name|value|
|----|-----|
|Name|`gtid_binlog_state`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Null`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_binlog_state](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_binlog_state)|

## gtid_current_pos
|name|value|
|----|-----|
|Name|`gtid_current_pos`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Null`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_current_pos](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_current_pos)|

## gtid_strict_mode
|name|value|
|----|-----|
|Name|`gtid_strict_mode`|
|Command line|`--gtid-strict-mode[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`Off`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_strict_mode](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_strict_mode)|

## gtid_domain_id
|name|value|
|----|-----|
|Name|`gtid_domain_id`|
|Command line|`--gtid-domain-id=#`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_domain_id](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_domain_id)|

## last_gtid
|name|value|
|----|-----|
|Name|`last_gtid`|
|Type of variable|`string`|
|Scope|`session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[last_gtid](https://mariadb.com/kb/en/library/documentation/gtid/#last_gtid)|

## server_id
|name|value|
|----|-----|
|Name|`server_id`|
|Type of variable|`integer`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_id](https://mariadb.com/kb/en/library/documentation/gtid/#server_id)|
|mariadb.com|[server_id](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#server_id)|
|dev.mysql.com|[sysvar_server_id](https://dev.mysql.com/doc/refman/8.0/en/replication-options.html#sysvar_server_id)|

## gtid_seq_no
|name|value|
|----|-----|
|Name|`gtid_seq_no`|
|Scope|`session`|
|Default value|`Null`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_seq_no](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_seq_no)|

## gtid_ignore_duplicates
|name|value|
|----|-----|
|Name|`gtid_ignore_duplicates`|
|Command line|`--gtid-ignore-duplicates=#`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_ignore_duplicates](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_ignore_duplicates)|

## gtid_pos_auto_engines
|name|value|
|----|-----|
|Name|`gtid_pos_auto_engines`|
|Command line|`--gtid-pos-auto-engines=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`empty`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_pos_auto_engines](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_pos_auto_engines)|

## gtid_cleanup_batch_size
|name|value|
|----|-----|
|Name|`gtid_cleanup_batch_size`|
|Command line|`--gtid-cleanup-batch-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`64`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[gtid_cleanup_batch_size](https://mariadb.com/kb/en/library/documentation/gtid/#gtid_cleanup_batch_size)|

## Server_audit_active
|name|value|
|----|-----|
|Name|`Server_audit_active`|
|Type of variable|`boolean`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_active](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-status-variables/#server_audit_active)|

## Server_audit_current_log
|name|value|
|----|-----|
|Name|`Server_audit_current_log`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_current_log](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-status-variables/#server_audit_current_log)|

## Server_audit_last_error
|name|value|
|----|-----|
|Name|`Server_audit_last_error`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_last_error](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-status-variables/#server_audit_last_error)|

## Server_audit_writes_failed
|name|value|
|----|-----|
|Name|`Server_audit_writes_failed`|
|Type of variable|`integer`|
|Default value|`0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_writes_failed](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-status-variables/#server_audit_writes_failed)|

## server_audit_events
|name|value|
|----|-----|
|Name|`server_audit_events`|
|Command line|`--server-audit-events=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty string`|
|Dynamic|`true`|
|Valid value(s)|`CONNECT`, `QUERY`, `TABLE`, `CONNECT`, `QUERY`, `TABLE`, `QUERY_DDL`, `QUERY_DML`, `CONNECT`, `QUERY`, `TABLE`, `QUERY_DDL`, `QUERY_DML`, `QUERY_DCL`, `CONNECT`, `QUERY`, `TABLE`, `QUERY_DDL`, `QUERY_DML`, `QUERY_DCL`, `QUERY_DML_NO_SELECT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_events](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_events)|

## server_audit_excl_users
|name|value|
|----|-----|
|Name|`server_audit_excl_users`|
|Command line|`--server-audit-excl-users=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty string`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_excl_users](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_excl_users)|

## server_audit_file_path
|name|value|
|----|-----|
|Name|`server_audit_file_path`|
|Command line|`--server-audit-file-path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`server_audit.log`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_file_path](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_file_path)|

## server_audit_file_rotate_now
|name|value|
|----|-----|
|Name|`server_audit_file_rotate_now`|
|Command line|`--server-audit-rotate-now[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_file_rotate_now](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_file_rotate_now)|

## server_audit_file_rotate_size
|name|value|
|----|-----|
|Name|`server_audit_file_rotate_size`|
|Command line|`--server-audit-rotate-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000000`|
|Dynamic|`true`|
|Range|from: `100` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_file_rotate_size](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_file_rotate_size)|

## server_audit_file_rotations
|name|value|
|----|-----|
|Name|`server_audit_file_rotations`|
|Command line|`--server-audit-rotations=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`9`|
|Dynamic|`true`|
|Range|from: `0` to: `999`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_file_rotations](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_file_rotations)|

## server_audit_incl_users
|name|value|
|----|-----|
|Name|`server_audit_incl_users`|
|Command line|`--server-audit-incl-users=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty string`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_incl_users](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_incl_users)|

## server_audit_loc_info
|name|value|
|----|-----|
|Name|`server_audit_loc_info`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty string`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_loc_info](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_loc_info)|

## server_audit_logging
|name|value|
|----|-----|
|Name|`server_audit_logging`|
|Command line|`--server-audit-logging[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_logging](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_logging)|

## server_audit_mode
|name|value|
|----|-----|
|Name|`server_audit_mode`|
|Command line|`--server-audit-mode[=#]`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_mode](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_mode)|

## server_audit_output_type
|name|value|
|----|-----|
|Name|`server_audit_output_type`|
|Command line|`--server-audit-output-type=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`file`|
|Dynamic|`true`|
|Valid value(s)|`SYSLOG`, `FILE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_output_type](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_output_type)|

## server_audit_query_log_limit
|name|value|
|----|-----|
|Name|`server_audit_query_log_limit`|
|Command line|`--server-audit-query-log-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_query_log_limit](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_query_log_limit)|

## server_audit_syslog_facility
|name|value|
|----|-----|
|Name|`server_audit_syslog_facility`|
|Command line|`--server-audit-syslog-facility=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`LOG_USER`|
|Dynamic|`true`|
|Valid value(s)|`LOG_USER`, `LOG_MAIL`, `LOG_DAEMON`, `LOG_AUTH`, `LOG_SYSLOG`, `LOG_LPR`, `LOG_NEWS`, `LOG_UUCP`, `LOG_CRON`, `LOG_AUTHPRIV`, `LOG_FTP`, `LOG_LOCAL0`, `LOG_LOCAL7`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_syslog_facility](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_syslog_facility)|

## server_audit_syslog_ident
|name|value|
|----|-----|
|Name|`server_audit_syslog_ident`|
|Command line|`--server-audit-syslog-ident=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`mysql-server_auditing`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_syslog_ident](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_syslog_ident)|

## server_audit_syslog_info
|name|value|
|----|-----|
|Name|`server_audit_syslog_info`|
|Command line|`--server-audit-syslog-info=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Empty string`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_syslog_info](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_syslog_info)|

## server_audit_syslog_priority
|name|value|
|----|-----|
|Name|`server_audit_syslog_priority`|
|Command line|`--server-audit-syslog-priority=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`LOG_INFO`|
|Dynamic|`true`|
|Valid value(s)|`LOG_EMERG`, `LOG_ALERT`, `LOG_CRIT`, `LOG_ERR`, `LOG_WARNING`, `LOG_NOTICE`, `LOG_INFO`, `LOG_DEBUG`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit_syslog_priority](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit_syslog_priority)|

## server_audit
|name|value|
|----|-----|
|Name|`server_audit`|
|Command line|`--server-audit=val`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`OFF`, `ON`, `FORCE`, `FORCE_PLUS_PERMANENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[server_audit](https://mariadb.com/kb/en/library/documentation/mariadb-audit-plugin-system-variables/#server_audit)|

## Mroonga_count_skip
|name|value|
|----|-----|
|Name|`Mroonga_count_skip`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_count_skip](https://mariadb.com/kb/en/library/documentation/mroonga-status-variables/#mroonga_count_skip)|

## Mroonga_fast_order_limit
|name|value|
|----|-----|
|Name|`Mroonga_fast_order_limit`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_fast_order_limit](https://mariadb.com/kb/en/library/documentation/mroonga-status-variables/#mroonga_fast_order_limit)|

## mroonga_action_on_fulltext_query_error
|name|value|
|----|-----|
|Name|`mroonga_action_on_fulltext_query_error`|
|Command line|`--mroonga-action-on-fulltext-query-error=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`ERROR_AND_LOG`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_action_on_fulltext_query_error](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_action_on_fulltext_query_error)|

## mroonga_boolean_mode_syntax_flags
|name|value|
|----|-----|
|Name|`mroonga_boolean_mode_syntax_flags`|
|Command line|`--mroonga-boolean-mode-syntax-flags=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`DEFAULT`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_boolean_mode_syntax_flags](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_boolean_mode_syntax_flags)|

## mroonga_database_path_prefix
|name|value|
|----|-----|
|Name|`mroonga_database_path_prefix`|
|Command line|`--mroonga-database-path-prefix=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_database_path_prefix](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_database_path_prefix)|

## mroonga_default_parser
|name|value|
|----|-----|
|Name|`mroonga_default_parser`|
|Command line|`--mroonga-default-parser=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`TokenBigram`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_default_parser](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_default_parser)|

## mroonga_default_tokenizer
|name|value|
|----|-----|
|Name|`mroonga_default_tokenizer`|
|Command line|`--mroonga-default-tokenizer=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`TokenBigram`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_default_tokenizer](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_default_tokenizer)|

## mroonga_default_wrapper_engine
|name|value|
|----|-----|
|Name|`mroonga_default_wrapper_engine`|
|Command line|`--mroonga-default-wrapper-engine=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_default_wrapper_engine](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_default_wrapper_engine)|

## mroonga_dry_write
|name|value|
|----|-----|
|Name|`mroonga_dry_write`|
|Command line|`--mroonga-dry-write[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`off`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_dry_write](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_dry_write)|

## mroonga_enable_operations_recording
|name|value|
|----|-----|
|Name|`mroonga_enable_operations_recording`|
|Command line|`--mroonga-enable-operations-recording={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_enable_operations_recording](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_enable_operations_recording)|

## mroonga_enable_optimization
|name|value|
|----|-----|
|Name|`mroonga_enable_optimization`|
|Command line|`--mroonga-enable-optimization={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`on`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_enable_optimization](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_enable_optimization)|

## mroonga_libgroonga_embedded
|name|value|
|----|-----|
|Name|`mroonga_libgroonga_embedded`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_libgroonga_embedded](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_libgroonga_embedded)|

## mroonga_libgroonga_support_lz4
|name|value|
|----|-----|
|Name|`mroonga_libgroonga_support_lz4`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_libgroonga_support_lz4](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_libgroonga_support_lz4)|

## mroonga_libgroonga_support_zlib
|name|value|
|----|-----|
|Name|`mroonga_libgroonga_support_zlib`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_libgroonga_support_zlib](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_libgroonga_support_zlib)|

## mroonga_libgroonga_support_zstd
|name|value|
|----|-----|
|Name|`mroonga_libgroonga_support_zstd`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_libgroonga_support_zstd](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_libgroonga_support_zstd)|

## mroonga_libgroonga_version
|name|value|
|----|-----|
|Name|`mroonga_libgroonga_version`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_libgroonga_version](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_libgroonga_version)|

## mroonga_lock_timeout
|name|value|
|----|-----|
|Name|`mroonga_lock_timeout`|
|Command line|`--mroonga-lock-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`900000`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_lock_timeout](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_lock_timeout)|

## mroonga_log_file
|name|value|
|----|-----|
|Name|`mroonga_log_file`|
|Command line|`--mroonga-log-file=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`groonga.log`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_log_file](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_log_file)|

## mroonga_log_level
|name|value|
|----|-----|
|Name|`mroonga_log_level`|
|Command line|`--mroonga-log-level=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NOTICE`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_log_level](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_log_level)|

## mroonga_match_escalation_threshold
|name|value|
|----|-----|
|Name|`mroonga_match_escalation_threshold`|
|Command line|`--mroonga-match-escalation-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_match_escalation_threshold](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_match_escalation_threshold)|

## mroonga_max_n_records_for_estimate
|name|value|
|----|-----|
|Name|`mroonga_max_n_records_for_estimate`|
|Command line|`--mroonga-max-n-records-for-estimate=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_max_n_records_for_estimate](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_max_n_records_for_estimate)|

## mroonga_query_log_file
|name|value|
|----|-----|
|Name|`mroonga_query_log_file`|
|Command line|`--mroonga-query-log-file=filename`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty string)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_query_log_file](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_query_log_file)|

## mroonga_vector_column_delimiter
|name|value|
|----|-----|
|Name|`mroonga_vector_column_delimiter`|
|Command line|`--mroonga-vector-column-delimiter=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(white space)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_vector_column_delimiter](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_vector_column_delimiter)|

## mroonga_version
|name|value|
|----|-----|
|Name|`mroonga_version`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mroonga_version](https://mariadb.com/kb/en/library/documentation/mroonga-system-variables/#mroonga_version)|

## key_buffer_size
|name|value|
|----|-----|
|Name|`key_buffer_size`|
|Command line|`--key-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `8` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_buffer_size)|
|dev.mysql.com|[sysvar_key_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_buffer_size)|

## key_cache_age_threshold
|name|value|
|----|-----|
|Name|`key_cache_age_threshold`|
|Command line|`--key-cache-age-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`300`|
|Dynamic|`true`|
|Range|from: `100` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_cache_age_threshold](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_cache_age_threshold)|
|dev.mysql.com|[sysvar_key_cache_age_threshold](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_age_threshold)|

## key_cache_block_size
|name|value|
|----|-----|
|Name|`key_cache_block_size`|
|Command line|`--key-cache-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Dynamic|`true`|
|Range|from: `512` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_cache_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_cache_block_size)|
|dev.mysql.com|[sysvar_key_cache_block_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_block_size)|

## key_cache_division_limit
|name|value|
|----|-----|
|Name|`key_cache_division_limit`|
|Command line|`--key-cache-division-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_cache_division_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_cache_division_limit)|
|dev.mysql.com|[sysvar_key_cache_division_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_division_limit)|

## key_cache_file_hash_size
|name|value|
|----|-----|
|Name|`key_cache_file_hash_size`|
|Command line|`--key-cache-file-hash-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`512`|
|Dynamic|`true`|
|Range|from: `128` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_cache_file_hash_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_cache_file_hash_size)|

## key_cache_segments
|name|value|
|----|-----|
|Name|`key_cache_segments`|
|Command line|`--key-cache-segments=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0 (non-segmented)`|
|Dynamic|`true`|
|Range|from: `0` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_cache_segments](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#key_cache_segments)|

## myisam_block_size
|name|value|
|----|-----|
|Name|`myisam_block_size`|
|Command line|`--myisam-block-size=#`|
|Type of variable|`integer`|
|Default value|`1024`|
|Range|from: `1024` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_block_size)|
|dev.mysql.com|[option_mysqld_myisam-block-size](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_myisam-block-size)|

## myisam_data_pointer_size
|name|value|
|----|-----|
|Name|`myisam_data_pointer_size`|
|Command line|`--myisam-data-pointer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`6`|
|Dynamic|`true`|
|Range|from: `2` to: `7`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_data_pointer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_data_pointer_size)|
|dev.mysql.com|[sysvar_myisam_data_pointer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_data_pointer_size)|

## myisam_max_extra_sort_file_size
|name|value|
|----|-----|
|Name|`myisam_max_extra_sort_file_size`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_max_extra_sort_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_max_extra_sort_file_size)|

## myisam_max_sort_file_size
|name|value|
|----|-----|
|Name|`myisam_max_sort_file_size`|
|Command line|`--myisam-max-sort-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_max_sort_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_max_sort_file_size)|
|dev.mysql.com|[sysvar_myisam_max_sort_file_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_max_sort_file_size)|

## myisam_mmap_size
|name|value|
|----|-----|
|Name|`myisam_mmap_size`|
|Command line|`--myisam-mmap-size=#`|
|Type of variable|`integer`|
|Range|from: `7`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_mmap_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_mmap_size)|
|dev.mysql.com|[sysvar_myisam_mmap_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_mmap_size)|

## myisam_recover_options
|name|value|
|----|-----|
|Name|`myisam_recover_options`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Valid value(s)|`OFF`, `DEFAULT`, `BACKUP`, `BACKUP_ALL`, `FORCE`, `QUICK`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_recover_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_recover_options)|
|dev.mysql.com|[sysvar_myisam_recover_options](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_recover_options)|

## myisam_repair_threads
|name|value|
|----|-----|
|Name|`myisam_repair_threads`|
|Command line|`--myisam-repair-threads=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_repair_threads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_repair_threads)|
|dev.mysql.com|[sysvar_myisam_repair_threads](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_repair_threads)|

## myisam_sort_buffer_size
|name|value|
|----|-----|
|Name|`myisam_sort_buffer_size`|
|Command line|`--myisam-sort-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `4096` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_sort_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_sort_buffer_size)|
|dev.mysql.com|[sysvar_myisam_sort_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_sort_buffer_size)|

## myisam_stats_method
|name|value|
|----|-----|
|Name|`myisam_stats_method`|
|Command line|`--myisam-stats-method=name`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`nulls_unequal`|
|Dynamic|`true`|
|Valid value(s)|`nulls_unequal`, `nulls_equal`, `nulls_ignored`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_stats_method](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_stats_method)|
|dev.mysql.com|[sysvar_myisam_stats_method](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_stats_method)|

## myisam_use_mmap
|name|value|
|----|-----|
|Name|`myisam_use_mmap`|
|Command line|`--myisam-use-mmap[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[myisam_use_mmap](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myisam/myisam-system-variables/#myisam_use_mmap)|
|dev.mysql.com|[sysvar_myisam_use_mmap](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_use_mmap)|

## rocksdb_access_hint_on_compaction_start
|name|value|
|----|-----|
|Name|`rocksdb_access_hint_on_compaction_start`|
|Command line|`--rocksdb-access-hint-on-compaction-start=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `0` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_access_hint_on_compaction_start](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_access_hint_on_compaction_start)|

## rocksdb_advise_random_on_open
|name|value|
|----|-----|
|Name|`rocksdb_advise_random_on_open`|
|Command line|`--rocksdb-advise-random-on-open={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_advise_random_on_open](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_advise_random_on_open)|

## rocksdb_allow_concurrent_memtable_write
|name|value|
|----|-----|
|Name|`rocksdb_allow_concurrent_memtable_write`|
|Command line|`--rocksdb-allow-concurrent-memtable-write={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_allow_concurrent_memtable_write](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_allow_concurrent_memtable_write)|

## rocksdb_allow_mmap_reads
|name|value|
|----|-----|
|Name|`rocksdb_allow_mmap_reads`|
|Command line|`--rocksdb-allow-mmap-reads={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_allow_mmap_reads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_allow_mmap_reads)|

## rocksdb_allow_mmap_writes
|name|value|
|----|-----|
|Name|`rocksdb_allow_mmap_writes`|
|Command line|`--rocksdb-allow-mmap-writes={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_allow_mmap_writes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_allow_mmap_writes)|

## rocksdb_allow_to_start_after_corruption
|name|value|
|----|-----|
|Name|`rocksdb_allow_to_start_after_corruption`|
|Command line|`--rocksdb-allow-to-start-after-corruption={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_allow_to_start_after_corruption](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_allow_to_start_after_corruption)|

## rocksdb_background_sync
|name|value|
|----|-----|
|Name|`rocksdb_background_sync`|
|Command line|`--rocksdb-background-sync={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_background_sync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_background_sync)|

## rocksdb_base_background_compactions
|name|value|
|----|-----|
|Name|`rocksdb_base_background_compactions`|
|Command line|`--rocksdb-base-background-compactions=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `-1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_base_background_compactions](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_base_background_compactions)|

## rocksdb_blind_delete_primary_key
|name|value|
|----|-----|
|Name|`rocksdb_blind_delete_primary_key`|
|Command line|`--rocksdb-blind-delete-primary-key={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_blind_delete_primary_key](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_blind_delete_primary_key)|

## rocksdb_block_cache_size
|name|value|
|----|-----|
|Name|`rocksdb_block_cache_size`|
|Command line|`--rocksdb-block-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`536870912`|
|Dynamic|`false`|
|Range|from: `1024` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_block_cache_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_block_cache_size)|

## rocksdb_block_restart_interval
|name|value|
|----|-----|
|Name|`rocksdb_block_restart_interval`|
|Command line|`--rocksdb-block-restart-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`16`|
|Dynamic|`false`|
|Range|from: `1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_block_restart_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_block_restart_interval)|

## rocksdb_block_size
|name|value|
|----|-----|
|Name|`rocksdb_block_size`|
|Command line|`--rocksdb-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4096`|
|Dynamic|`false`|
|Range|from: `1` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_block_size)|

## rocksdb_block_size_deviation
|name|value|
|----|-----|
|Name|`rocksdb_block_size_deviation`|
|Command line|`--rocksdb-block-size-deviation=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_block_size_deviation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_block_size_deviation)|

## rocksdb_bulk_load
|name|value|
|----|-----|
|Name|`rocksdb_bulk_load`|
|Command line|`--rocksdb-bulk-load={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_bulk_load](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_bulk_load)|

## rocksdb_bulk_load_allow_sk
|name|value|
|----|-----|
|Name|`rocksdb_bulk_load_allow_sk`|
|Command line|`--rocksdb-bulk-load_allow_sk={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_bulk_load_allow_sk](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_bulk_load_allow_sk)|

## rocksdb_bulk_load_allow_unsorted
|name|value|
|----|-----|
|Name|`rocksdb_bulk_load_allow_unsorted`|
|Command line|`--rocksdb-bulk-load_allow_unsorted={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_bulk_load_allow_unsorted](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_bulk_load_allow_unsorted)|

## rocksdb_bulk_load_size
|name|value|
|----|-----|
|Name|`rocksdb_bulk_load_size`|
|Command line|`--rocksdb-bulk-load-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `1` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_bulk_load_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_bulk_load_size)|

## rocksdb_bytes_per_sync
|name|value|
|----|-----|
|Name|`rocksdb_bytes_per_sync`|
|Command line|`--rocksdb-bytes-per-sync=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_bytes_per_sync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_bytes_per_sync)|

## rocksdb_cache_dump
|name|value|
|----|-----|
|Name|`rocksdb_cache_dump`|
|Command line|`--rocksdb-cache-dump={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_cache_dump](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_cache_dump)|

## rocksdb_cache_high_pri_pool_ratio
|name|value|
|----|-----|
|Name|`rocksdb_cache_high_pri_pool_ratio`|
|Command line|`--rocksdb-cache-high-pri-pool-ratio=#`|
|Scope|`global`|
|Default value|`0.000000`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_cache_high_pri_pool_ratio](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_cache_high_pri_pool_ratio)|

## rocksdb_cache_index_and_filter_blocks
|name|value|
|----|-----|
|Name|`rocksdb_cache_index_and_filter_blocks`|
|Command line|`--rocksdb-cache-index-and-filter-blocks={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_cache_index_and_filter_blocks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_cache_index_and_filter_blocks)|

## rocksdb_cache_index_and_filter_with_high_priority
|name|value|
|----|-----|
|Name|`rocksdb_cache_index_and_filter_with_high_priority`|
|Command line|`--rocksdb-cache-index-and-filter-with-high-priority={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_cache_index_and_filter_with_high_priority](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_cache_index_and_filter_with_high_priority)|

## rocksdb_checksums_pct
|name|value|
|----|-----|
|Name|`rocksdb_checksums_pct`|
|Command line|`--rocksdb-checksums-pct=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_checksums_pct](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_checksums_pct)|

## rocksdb_collect_sst_properties
|name|value|
|----|-----|
|Name|`rocksdb_collect_sst_properties`|
|Command line|`--rocksdb-collect-sst-properties={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_collect_sst_properties](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_collect_sst_properties)|

## rocksdb_commit_in_the_middle
|name|value|
|----|-----|
|Name|`rocksdb_commit_in_the_middle`|
|Command line|`--rocksdb-commit-in-the-middle={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_commit_in_the_middle](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_commit_in_the_middle)|

## rocksdb_commit_time_batch_for_recovery
|name|value|
|----|-----|
|Name|`rocksdb_commit_time_batch_for_recovery`|
|Command line|`--rocksdb-commit-time-batch-for-recovery={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_commit_time_batch_for_recovery](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_commit_time_batch_for_recovery)|

## rocksdb_compact_cf
|name|value|
|----|-----|
|Name|`rocksdb_compact_cf`|
|Command line|`--rocksdb-compact-cf=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compact_cf](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compact_cf)|

## rocksdb_compaction_readahead_size
|name|value|
|----|-----|
|Name|`rocksdb_compaction_readahead_size`|
|Command line|`--rocksdb-compaction-readahead-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compaction_readahead_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compaction_readahead_size)|

## rocksdb_compaction_sequential_deletes
|name|value|
|----|-----|
|Name|`rocksdb_compaction_sequential_deletes`|
|Command line|`--rocksdb-compaction-sequential-deletes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compaction_sequential_deletes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compaction_sequential_deletes)|

## rocksdb_compaction_sequential_deletes_count_sd
|name|value|
|----|-----|
|Name|`rocksdb_compaction_sequential_deletes_count_sd`|
|Command line|`--rocksdb-compaction-sequential-deletes-count-sd={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compaction_sequential_deletes_count_sd](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compaction_sequential_deletes_count_sd)|

## rocksdb_compaction_sequential_deletes_file_size
|name|value|
|----|-----|
|Name|`rocksdb_compaction_sequential_deletes_file_size`|
|Command line|`--rocksdb-compaction-sequential-deletes-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compaction_sequential_deletes_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compaction_sequential_deletes_file_size)|

## rocksdb_compaction_sequential_deletes_window
|name|value|
|----|-----|
|Name|`rocksdb_compaction_sequential_deletes_window`|
|Command line|`--rocksdb-compaction-sequential-deletes-window=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_compaction_sequential_deletes_window](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_compaction_sequential_deletes_window)|

## rocksdb_concurrent_prepare
|name|value|
|----|-----|
|Name|`rocksdb_concurrent_prepare`|
|Command line|`--rocksdb-coconcurrent-prepare={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_concurrent_prepare](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_concurrent_prepare)|

## rocksdb_create_checkpoint
|name|value|
|----|-----|
|Name|`rocksdb_create_checkpoint`|
|Command line|`--rocksdb-create-checkpoint=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_create_checkpoint](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_create_checkpoint)|

## rocksdb_create_if_missing
|name|value|
|----|-----|
|Name|`rocksdb_create_if_missing`|
|Command line|`--rocksdb-create-if-missing={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_create_if_missing](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_create_if_missing)|

## rocksdb_create_missing_column_families
|name|value|
|----|-----|
|Name|`rocksdb_create_missing_column_families`|
|Command line|`--rocksdb-create-missing-column-families={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_create_missing_column_families](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_create_missing_column_families)|

## rocksdb_datadir
|name|value|
|----|-----|
|Name|`rocksdb_datadir`|
|Command line|`--rocksdb-datadir[=value]`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`./#rocksdb`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_datadir](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_datadir)|

## rocksdb_db_write_buffer_size
|name|value|
|----|-----|
|Name|`rocksdb_db_write_buffer_size`|
|Command line|`--rocksdb-db-write-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_db_write_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_db_write_buffer_size)|

## rocksdb_deadlock_detect
|name|value|
|----|-----|
|Name|`rocksdb_deadlock_detect`|
|Command line|`--rocksdb-deadlock-detect={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_deadlock_detect](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_deadlock_detect)|

## rocksdb_deadlock_detect_depth
|name|value|
|----|-----|
|Name|`rocksdb_deadlock_detect_depth`|
|Command line|`--rocksdb-deadlock-detect-depth=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `2` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_deadlock_detect_depth](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_deadlock_detect_depth)|

## rocksdb_debug_manual_compaction_delay
|name|value|
|----|-----|
|Name|`rocksdb_debug_manual_compaction_delay`|
|Command line|`--rocksdb-debug_manual_compaction_delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_manual_compaction_delay](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_manual_compaction_delay)|

## rocksdb_debug_optimizer_no_zero_cardinality
|name|value|
|----|-----|
|Name|`rocksdb_debug_optimizer_no_zero_cardinality`|
|Command line|`--rocksdb-debug-optimizer-no-zero-cardinality={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_optimizer_no_zero_cardinality](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_optimizer_no_zero_cardinality)|

## rocksdb_debug_ttl_ignore_pk
|name|value|
|----|-----|
|Name|`rocksdb_debug_ttl_ignore_pk`|
|Command line|`--rocksdb-debug-ttl-ignore-pk={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_ttl_ignore_pk](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_ttl_ignore_pk)|

## rocksdb_debug_ttl_read_filter_ts
|name|value|
|----|-----|
|Name|`rocksdb_debug_ttl_read_filter_ts`|
|Command line|`--rocksdb-debug-ttl-read-filter-ts=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `-3600` to: `3600`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_ttl_read_filter_ts](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_ttl_read_filter_ts)|

## rocksdb_debug_ttl_rec_ts
|name|value|
|----|-----|
|Name|`rocksdb_debug_ttl_rec_ts`|
|Command line|`--rocksdb-debug-ttl-read-filter-ts=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `-3600` to: `3600`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_ttl_rec_ts](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_ttl_rec_ts)|

## rocksdb_debug_ttl_snapshot_ts
|name|value|
|----|-----|
|Name|`rocksdb_debug_ttl_snapshot_ts`|
|Command line|`--rocksdb-debug-ttl-snapshot-ts=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `-3600` to: `3600`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_debug_ttl_snapshot_ts](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_debug_ttl_snapshot_ts)|

## rocksdb_default_cf_options
|name|value|
|----|-----|
|Name|`rocksdb_default_cf_options`|
|Command line|`--rocksdb-default-cf-options=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_default_cf_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_default_cf_options)|

## rocksdb_delayed_write_rate
|name|value|
|----|-----|
|Name|`rocksdb_delayed_write_rate`|
|Command line|`--rocksdb-delayed-write-rate=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0 (Previously 16777216)`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_delayed_write_rate](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_delayed_write_rate)|

## rocksdb_delete_cf
|name|value|
|----|-----|
|Name|`rocksdb_delete_cf`|
|Command line|`--rocksdb-delete-cf=val`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty string)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_delete_cf](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_delete_cf)|

## rocksdb_delete_obsolete_files_period_micros
|name|value|
|----|-----|
|Name|`rocksdb_delete_obsolete_files_period_micros`|
|Command line|`--rocksdb-delete-obsolete-files-period-micros=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`21600000000`|
|Dynamic|`false`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_delete_obsolete_files_period_micros](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_delete_obsolete_files_period_micros)|

## rocksdb_enable_2pc
|name|value|
|----|-----|
|Name|`rocksdb_enable_2pc`|
|Command line|`--rocksdb-enable-2pc={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_2pc](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_2pc)|

## rocksdb_enable_bulk_load_api
|name|value|
|----|-----|
|Name|`rocksdb_enable_bulk_load_api`|
|Command line|`--rocksdb-enable-bulk-load-api={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_bulk_load_api](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_bulk_load_api)|

## rocksdb_enable_insert_with_update_caching
|name|value|
|----|-----|
|Name|`rocksdb_enable_insert_with_update_caching`|
|Command line|`--rocksdb-enable-insert-with-update-caching={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_insert_with_update_caching](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_insert_with_update_caching)|

## rocksdb_enable_thread_tracking
|name|value|
|----|-----|
|Name|`rocksdb_enable_thread_tracking`|
|Command line|`--rocksdb-enable-thread-tracking={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_thread_tracking](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_thread_tracking)|

## rocksdb_enable_ttl
|name|value|
|----|-----|
|Name|`rocksdb_enable_ttl`|
|Command line|`--rocksdb-enable-ttl={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_ttl](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_ttl)|

## rocksdb_enable_ttl_read_filtering
|name|value|
|----|-----|
|Name|`rocksdb_enable_ttl_read_filtering`|
|Command line|`--rocksdb-enable-ttl-read-filtering={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_ttl_read_filtering](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_ttl_read_filtering)|

## rocksdb_enable_write_thread_adaptive_yield
|name|value|
|----|-----|
|Name|`rocksdb_enable_write_thread_adaptive_yield`|
|Command line|`--rocksdb-enable-write-thread-adaptive-yield={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_enable_write_thread_adaptive_yield](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_enable_write_thread_adaptive_yield)|

## rocksdb_error_if_exists
|name|value|
|----|-----|
|Name|`rocksdb_error_if_exists`|
|Command line|`--rocksdb-error-if-exists={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_error_if_exists](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_error_if_exists)|

## rocksdb_error_on_suboptimal_collation
|name|value|
|----|-----|
|Name|`rocksdb_error_on_suboptimal_collation`|
|Command line|`--rocksdb-error-on-suboptimal-collation={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_error_on_suboptimal_collation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_error_on_suboptimal_collation)|

## rocksdb_flush_log_at_trx_commit
|name|value|
|----|-----|
|Name|`rocksdb_flush_log_at_trx_commit`|
|Command line|`--rocksdb-flush-log-at-trx-commit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_flush_log_at_trx_commit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_flush_log_at_trx_commit)|

## rocksdb_flush_memtable_on_analyze
|name|value|
|----|-----|
|Name|`rocksdb_flush_memtable_on_analyze`|
|Command line|`--rocksdb-flush-memtable-on-analyze={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_flush_memtable_on_analyze](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_flush_memtable_on_analyze)|

## rocksdb_force_compute_memtable_stats
|name|value|
|----|-----|
|Name|`rocksdb_force_compute_memtable_stats`|
|Command line|`--rocksdb-force-compute-memtable-stats={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_force_compute_memtable_stats](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_force_compute_memtable_stats)|

## rocksdb_force_compute_memtable_stats_cachetime
|name|value|
|----|-----|
|Name|`rocksdb_force_compute_memtable_stats_cachetime`|
|Command line|`--rocksdb-force-compute-memtable-stats-cachetime=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60000000`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_force_compute_memtable_stats_cachetime](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_force_compute_memtable_stats_cachetime)|

## rocksdb_force_flush_memtable_and_lzero_now
|name|value|
|----|-----|
|Name|`rocksdb_force_flush_memtable_and_lzero_now`|
|Command line|`--rocksdb-force-flush-memtable-and-lzero-now={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_force_flush_memtable_and_lzero_now](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_force_flush_memtable_and_lzero_now)|

## rocksdb_force_flush_memtable_now
|name|value|
|----|-----|
|Name|`rocksdb_force_flush_memtable_now`|
|Command line|`--rocksdb-force-flush-memtable-now={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_force_flush_memtable_now](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_force_flush_memtable_now)|

## rocksdb_force_index_records_in_range
|name|value|
|----|-----|
|Name|`rocksdb_force_index_records_in_range`|
|Command line|`--rocksdb-force-index-records-in-range=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_force_index_records_in_range](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_force_index_records_in_range)|

## rocksdb_git_hash
|name|value|
|----|-----|
|Name|`rocksdb_git_hash`|
|Command line|`--rocksdb-git-hash=value=#`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`As per git revision.`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_git_hash](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_git_hash)|

## rocksdb_hash_index_allow_collision
|name|value|
|----|-----|
|Name|`rocksdb_hash_index_allow_collision`|
|Command line|`--rocksdb-hash-index-allow-collision={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_hash_index_allow_collision](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_hash_index_allow_collision)|

## rocksdb_ignore_unknown_options
|name|value|
|----|-----|
|Name|`rocksdb_ignore_unknown_options`|
|Command line|`--rocksdb-ignore-unknown-options={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_ignore_unknown_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_ignore_unknown_options)|

## rocksdb_index_type
|name|value|
|----|-----|
|Name|`rocksdb_index_type`|
|Command line|`--rocksdb-index-type=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`kBinarySearch`|
|Dynamic|`false`|
|Valid value(s)|`kBinarySearch`, `kHashSearch`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_index_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_index_type)|

## rocksdb_info_log_level
|name|value|
|----|-----|
|Name|`rocksdb_info_log_level`|
|Command line|`--rocksdb-info-log-level=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`error_level`|
|Dynamic|`true`|
|Valid value(s)|`error_level`, `debug_level`, `info_level`, `warn_level`, `fatal_level`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_info_log_level](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_info_log_level)|

## rocksdb_io_write_timeout
|name|value|
|----|-----|
|Name|`rocksdb_io_write_timeout`|
|Command line|`--rocksdb-io-write-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Valid value(s)|`0`, `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_io_write_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_io_write_timeout)|

## rocksdb_is_fd_close_on_exec
|name|value|
|----|-----|
|Name|`rocksdb_is_fd_close_on_exec`|
|Command line|`--rocksdb-is-fd-close-on-exec={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_is_fd_close_on_exec](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_is_fd_close_on_exec)|

## rocksdb_keep_log_file_num
|name|value|
|----|-----|
|Name|`rocksdb_keep_log_file_num`|
|Command line|`--rocksdb-keep-log-file-num=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_keep_log_file_num](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_keep_log_file_num)|

## rocksdb_large_prefix
|name|value|
|----|-----|
|Name|`rocksdb_large_prefix`|
|Command line|`--rocksdb-large_prefix={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_large_prefix](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_large_prefix)|

## rocksdb_lock_scanned_rows
|name|value|
|----|-----|
|Name|`rocksdb_lock_scanned_rows`|
|Command line|`--rocksdb-lock-scanned-rows={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_lock_scanned_rows](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_lock_scanned_rows)|

## rocksdb_lock_wait_timeout
|name|value|
|----|-----|
|Name|`rocksdb_lock_wait_timeout`|
|Command line|`--rocksdb-lock-wait-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_lock_wait_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_lock_wait_timeout)|

## rocksdb_log_file_time_to_roll
|name|value|
|----|-----|
|Name|`rocksdb_log_file_time_to_roll`|
|Command line|`--rocksdb-log-file-time-to_roll=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_log_file_time_to_roll](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_log_file_time_to_roll)|

## rocksdb_manifest_preallocation_size
|name|value|
|----|-----|
|Name|`rocksdb_manifest_preallocation_size`|
|Command line|`--rocksdb-manifest-preallocation-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4194304`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_manifest_preallocation_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_manifest_preallocation_size)|

## rocksdb_manual_compaction_threads
|name|value|
|----|-----|
|Name|`rocksdb_manual_compaction_threads`|
|Command line|`--rocksdb-manual-compation-threads=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_manual_compaction_threads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_manual_compaction_threads)|

## rocksdb_manual_wal_flush
|name|value|
|----|-----|
|Name|`rocksdb_manual_wal_flush`|
|Command line|`--rocksdb-manual-wal-flush={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_manual_wal_flush](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_manual_wal_flush)|

## rocksdb_master_skip_tx_api
|name|value|
|----|-----|
|Name|`rocksdb_master_skip_tx_api`|
|Command line|`--rocksdb-master-skip-tx-api={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_master_skip_tx_api](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_master_skip_tx_api)|

## rocksdb_max_background_compactions
|name|value|
|----|-----|
|Name|`rocksdb_max_background_compactions`|
|Command line|`--rocksdb-max-background-compactions=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_background_compactions](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_background_compactions)|

## rocksdb_max_background_flushes
|name|value|
|----|-----|
|Name|`rocksdb_max_background_flushes`|
|Command line|`--rocksdb-max-background-flushes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_background_flushes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_background_flushes)|

## rocksdb_max_background_jobs
|name|value|
|----|-----|
|Name|`rocksdb_max_background_jobs`|
|Command line|`--rocksdb-max-background-jobs=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2`|
|Dynamic|`true`|
|Range|from: `-1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_background_jobs](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_background_jobs)|

## rocksdb_max_latest_deadlocks
|name|value|
|----|-----|
|Name|`rocksdb_max_latest_deadlocks`|
|Command line|`--rocksdb-max-latest-deadlocks=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_latest_deadlocks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_latest_deadlocks)|

## rocksdb_max_log_file_size
|name|value|
|----|-----|
|Name|`rocksdb_max_log_file_size`|
|Command line|`--rocksdb-max-log-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_log_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_log_file_size)|

## rocksdb_max_manifest_file_size
|name|value|
|----|-----|
|Name|`rocksdb_max_manifest_file_size`|
|Command line|`--rocksdb-manifest-log-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1073741824`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_manifest_file_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_manifest_file_size)|

## rocksdb_max_manual_compactions
|name|value|
|----|-----|
|Name|`rocksdb_max_manual_compactions`|
|Command line|`--rocksdb-manual_compactions=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_manual_compactions](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_manual_compactions)|

## rocksdb_max_open_files
|name|value|
|----|-----|
|Name|`rocksdb_max_open_files`|
|Command line|`--rocksdb-max-open-files=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`-2`|
|Dynamic|`false`|
|Range|from: `-2` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_open_files](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_open_files)|

## rocksdb_max_row_locks
|name|value|
|----|-----|
|Name|`rocksdb_max_row_locks`|
|Command line|`--rocksdb-max-row-locks=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1048576`|
|Dynamic|`true`|
|Range|from: `1` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_row_locks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_row_locks)|

## rocksdb_max_subcompactions
|name|value|
|----|-----|
|Name|`rocksdb_max_subcompactions`|
|Command line|`--rocksdb-max-subcompactions=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_subcompactions](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_subcompactions)|

## rocksdb_max_total_wal_size
|name|value|
|----|-----|
|Name|`rocksdb_max_total_wal_size`|
|Command line|`--rocksdb-max-total-wal-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_max_total_wal_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_max_total_wal_size)|

## rocksdb_merge_buf_size
|name|value|
|----|-----|
|Name|`rocksdb_merge_buf_size`|
|Command line|`--rocksdb-merge-buf-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`67108864`|
|Dynamic|`true`|
|Range|from: `100` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_merge_buf_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_merge_buf_size)|

## rocksdb_merge_combine_read_size
|name|value|
|----|-----|
|Name|`rocksdb_merge_combine_read_size`|
|Command line|`--rocksdb-merge-combine-read-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1073741824`|
|Dynamic|`true`|
|Range|from: `100` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_merge_combine_read_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_merge_combine_read_size)|

## rocksdb_merge_tmp_file_removal_delay_ms
|name|value|
|----|-----|
|Name|`rocksdb_merge_tmp_file_removal_delay_ms`|
|Command line|`--rocksdb-merge-tmp-file-removal-delay-ms=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_merge_tmp_file_removal_delay_ms](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_merge_tmp_file_removal_delay_ms)|

## rocksdb_new_table_reader_for_compaction_inputs
|name|value|
|----|-----|
|Name|`rocksdb_new_table_reader_for_compaction_inputs`|
|Command line|`--rocksdb-new-table-reader-for-compaction-inputs={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_new_table_reader_for_compaction_inputs](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_new_table_reader_for_compaction_inputs)|

## rocksdb_no_block_cache
|name|value|
|----|-----|
|Name|`rocksdb_no_block_cache`|
|Command line|`--rocksdb-no-block-cache={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_no_block_cache](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_no_block_cache)|

## rocksdb_override_cf_options
|name|value|
|----|-----|
|Name|`rocksdb_override_cf_options`|
|Command line|`--rocksdb-override-cf-options=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_override_cf_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_override_cf_options)|

## rocksdb_paranoid_checks
|name|value|
|----|-----|
|Name|`rocksdb_paranoid_checks`|
|Command line|`--rocksdb-paranoid-checks={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_paranoid_checks](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_paranoid_checks)|

## rocksdb_pause_background_work
|name|value|
|----|-----|
|Name|`rocksdb_pause_background_work`|
|Command line|`--rocksdb-pause-background-work={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_pause_background_work](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_pause_background_work)|

## rocksdb_perf_context_level
|name|value|
|----|-----|
|Name|`rocksdb_perf_context_level`|
|Command line|`--rocksdb-perf-context-level=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `5`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_perf_context_level](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_perf_context_level)|

## rocksdb_persistent_cache_path
|name|value|
|----|-----|
|Name|`rocksdb_persistent_cache_path`|
|Command line|`--rocksdb-persistent-cache-path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_persistent_cache_path](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_persistent_cache_path)|

## rocksdb_persistent_cache_size_mb
|name|value|
|----|-----|
|Name|`rocksdb_persistent_cache_size_mb`|
|Command line|`--rocksdb-persistent-cache-size-mb=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_persistent_cache_size_mb](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_persistent_cache_size_mb)|

## rocksdb_pin_l0_filter_and_index_blocks_in_cache
|name|value|
|----|-----|
|Name|`rocksdb_pin_l0_filter_and_index_blocks_in_cache`|
|Command line|`--rocksdb-pin-l0-filter-and-index-blocks-in-cache={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_pin_l0_filter_and_index_blocks_in_cache](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_pin_l0_filter_and_index_blocks_in_cache)|

## rocksdb_print_snapshot_conflict_queries
|name|value|
|----|-----|
|Name|`rocksdb_print_snapshot_conflict_queries`|
|Command line|`--rocksdb-print-snapshot-conflict-queries={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_print_snapshot_conflict_queries](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_print_snapshot_conflict_queries)|

## rocksdb_rate_limiter_bytes_per_sec
|name|value|
|----|-----|
|Name|`rocksdb_rate_limiter_bytes_per_sec`|
|Command line|`--rocksdb-rate-limiter-bytes-per-sec=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_rate_limiter_bytes_per_sec](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_rate_limiter_bytes_per_sec)|

## rocksdb_read_free_rpl_tables
|name|value|
|----|-----|
|Name|`rocksdb_read_free_rpl_tables`|
|Command line|`--rocksdb-read-free-rpl-tables=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_read_free_rpl_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_read_free_rpl_tables)|

## rocksdb_records_in_range
|name|value|
|----|-----|
|Name|`rocksdb_records_in_range`|
|Command line|`--rocksdb-records-in-range=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_records_in_range](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_records_in_range)|

## rocksdb_remove_mariabackup_checkpoint
|name|value|
|----|-----|
|Name|`rocksdb_remove_mariabackup_checkpoint`|
|Command line|`--rocksdb-remove-mariabackup-checkpoint={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_remove_mariabackup_checkpoint](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_remove_mariabackup_checkpoint)|

## rocksdb_reset_stats
|name|value|
|----|-----|
|Name|`rocksdb_reset_stats`|
|Command line|`--rocksdb-reset-stats={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_reset_stats](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_reset_stats)|

## rocksdb_rollback_on_timeout
|name|value|
|----|-----|
|Name|`rocksdb_rollback_on_timeout`|
|Command line|`--rocksdb-rollback-on-timeout={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_rollback_on_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_rollback_on_timeout)|

## rocksdb_seconds_between_stat_computes
|name|value|
|----|-----|
|Name|`rocksdb_seconds_between_stat_computes`|
|Command line|`--rocksdb-seconds-between-stat-computes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3600`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_seconds_between_stat_computes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_seconds_between_stat_computes)|

## rocksdb_signal_drop_index_thread
|name|value|
|----|-----|
|Name|`rocksdb_signal_drop_index_thread`|
|Command line|`--rocksdb-signal-drop-index-thread={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_signal_drop_index_thread](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_signal_drop_index_thread)|

## rocksdb_sim_cache_size
|name|value|
|----|-----|
|Name|`rocksdb_sim_cache_size`|
|Command line|`--rocksdb-sim-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_sim_cache_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_sim_cache_size)|

## rocksdb_skip_bloom_filter_on_read
|name|value|
|----|-----|
|Name|`rocksdb_skip_bloom_filter_on_read`|
|Command line|`--rocksdb-skip-bloom-filter-on_read={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_skip_bloom_filter_on_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_skip_bloom_filter_on_read)|

## rocksdb_skip_fill_cache
|name|value|
|----|-----|
|Name|`rocksdb_skip_fill_cache`|
|Command line|`--rocksdb-skip-fill-cache={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_skip_fill_cache](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_skip_fill_cache)|

## rocksdb_skip_unique_check_tables
|name|value|
|----|-----|
|Name|`rocksdb_skip_unique_check_tables`|
|Command line|`--rocksdb-skip-unique-check-tables=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`.*`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_skip_unique_check_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_skip_unique_check_tables)|

## rocksdb_sst_mgr_rate_bytes_per_sec
|name|value|
|----|-----|
|Name|`rocksdb_sst_mgr_rate_bytes_per_sec`|
|Command line|`--rocksdb-sst-mgr-rate-bytes-per-sec=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_sst_mgr_rate_bytes_per_sec](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_sst_mgr_rate_bytes_per_sec)|

## rocksdb_stats_dump_period_sec
|name|value|
|----|-----|
|Name|`rocksdb_stats_dump_period_sec`|
|Command line|`--rocksdb-stats-dump-period-sec=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`600`|
|Dynamic|`false`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_stats_dump_period_sec](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_stats_dump_period_sec)|

## rocksdb_stats_level
|name|value|
|----|-----|
|Name|`rocksdb_stats_level`|
|Command line|`--rocksdb-stats-level=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_stats_level](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_stats_level)|

## rocksdb_stats_recalc_rate
|name|value|
|----|-----|
|Name|`rocksdb_stats_recalc_rate`|
|Command line|`--rocksdb-stats-recalc_rate=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_stats_recalc_rate](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_stats_recalc_rate)|

## rocksdb_store_row_debug_checksums
|name|value|
|----|-----|
|Name|`rocksdb_store_row_debug_checksums`|
|Command line|`--rocksdb-store-row-debug-checksums={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_store_row_debug_checksums](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_store_row_debug_checksums)|

## rocksdb_strict_collation_check
|name|value|
|----|-----|
|Name|`rocksdb_strict_collation_check`|
|Command line|`--rocksdb-strict-collation-check={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_strict_collation_check](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_strict_collation_check)|

## rocksdb_strict_collation_exceptions
|name|value|
|----|-----|
|Name|`rocksdb_strict_collation_exceptions`|
|Command line|`--rocksdb-strict-collation-exceptions=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_strict_collation_exceptions](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_strict_collation_exceptions)|

## rocksdb_supported_compression_types
|name|value|
|----|-----|
|Name|`rocksdb_supported_compression_types`|
|Command line|`--rocksdb-supported-compression-types=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Snappy,Zlib,ZSTDNotFinal`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_supported_compression_types](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_supported_compression_types)|

## rocksdb_table_cache_numshardbits
|name|value|
|----|-----|
|Name|`rocksdb_table_cache_numshardbits`|
|Command line|`--rocksdb-table-cache-numshardbits=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`6`|
|Dynamic|`false`|
|Range|from: `0` to: `19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_table_cache_numshardbits](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_table_cache_numshardbits)|

## rocksdb_table_stats_sampling_pct
|name|value|
|----|-----|
|Name|`rocksdb_table_stats_sampling_pct`|
|Command line|`--rocksdb-table-stats-sampling-pct=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_table_stats_sampling_pct](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_table_stats_sampling_pct)|

## rocksdb_tmpdir
|name|value|
|----|-----|
|Name|`rocksdb_tmpdir`|
|Command line|`--rocksdb-tmpdir[=value]`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_tmpdir](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_tmpdir)|

## rocksdb_trace_sst_api
|name|value|
|----|-----|
|Name|`rocksdb_trace_sst_api`|
|Command line|`--rocksdb-trace-sst-api={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_trace_sst_api](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_trace_sst_api)|

## rocksdb_two_write_queues
|name|value|
|----|-----|
|Name|`rocksdb_two_write_queues`|
|Command line|`--rocksdb-two-write-queues={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_two_write_queues](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_two_write_queues)|

## rocksdb_unsafe_for_binlog
|name|value|
|----|-----|
|Name|`rocksdb_unsafe_for_binlog`|
|Command line|`--rocksdb-unsafe-for-binlog={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_unsafe_for_binlog](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_unsafe_for_binlog)|

## rocksdb_update_cf_options
|name|value|
|----|-----|
|Name|`rocksdb_update_cf_options`|
|Command line|`--rocksdb-update-cf-options=value`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_update_cf_options](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_update_cf_options)|

## rocksdb_use_adaptive_mutex
|name|value|
|----|-----|
|Name|`rocksdb_use_adaptive_mutex`|
|Command line|`--rocksdb-use-adaptive-mutex={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_adaptive_mutex](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_adaptive_mutex)|

## rocksdb_use_clock_cache
|name|value|
|----|-----|
|Name|`rocksdb_use_clock_cache`|
|Command line|`--rocksdb-use-clock-cache={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_clock_cache](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_clock_cache)|

## rocksdb_use_direct_io_for_flush_and_compaction
|name|value|
|----|-----|
|Name|`rocksdb_use_direct_io_for_flush_and_compaction`|
|Command line|`--rocksdb-use-direct-io-for-flush-and-compaction={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_direct_io_for_flush_and_compaction](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_direct_io_for_flush_and_compaction)|

## rocksdb_use_direct_reads
|name|value|
|----|-----|
|Name|`rocksdb_use_direct_reads`|
|Command line|`--rocksdb-use-direct-reads={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_direct_reads](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_direct_reads)|

## rocksdb_use_direct_writes
|name|value|
|----|-----|
|Name|`rocksdb_use_direct_writes`|
|Command line|`--rocksdb-use-direct-reads={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_direct_writes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_direct_writes)|

## rocksdb_use_fsync
|name|value|
|----|-----|
|Name|`rocksdb_use_fsync`|
|Command line|`--rocksdb-use-fsync={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_use_fsync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_use_fsync)|

## rocksdb_validate_tables
|name|value|
|----|-----|
|Name|`rocksdb_validate_tables`|
|Command line|`--rocksdb-validate-tables=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_validate_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_validate_tables)|

## rocksdb_verify_row_debug_checksums
|name|value|
|----|-----|
|Name|`rocksdb_verify_row_debug_checksums`|
|Command line|`--rocksdb-verify-row-debug-checksums={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_verify_row_debug_checksums](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_verify_row_debug_checksums)|

## rocksdb_wal_bytes_per_sync
|name|value|
|----|-----|
|Name|`rocksdb_wal_bytes_per_sync`|
|Command line|`--rocksdb-wal-bytes-per-sync=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_wal_bytes_per_sync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_wal_bytes_per_sync)|

## rocksdb_wal_dir
|name|value|
|----|-----|
|Name|`rocksdb_wal_dir`|
|Command line|`--rocksdb-wal-dir=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_wal_dir](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_wal_dir)|

## rocksdb_wal_recovery_mode
|name|value|
|----|-----|
|Name|`rocksdb_wal_recovery_mode`|
|Command line|`--rocksdb-wal-recovery-mode=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_wal_recovery_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_wal_recovery_mode)|

## rocksdb_wal_size_limit_mb
|name|value|
|----|-----|
|Name|`rocksdb_wal_size_limit_mb`|
|Command line|`--rocksdb-wal-size-limit-mb=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_wal_size_limit_mb](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_wal_size_limit_mb)|

## rocksdb_wal_ttl_seconds
|name|value|
|----|-----|
|Name|`rocksdb_wal_ttl_seconds`|
|Command line|`--rocksdb-wal-ttl-seconds=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_wal_ttl_seconds](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_wal_ttl_seconds)|

## rocksdb_whole_key_filtering
|name|value|
|----|-----|
|Name|`rocksdb_whole_key_filtering`|
|Command line|`--rocksdb-whole-key-filtering={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_whole_key_filtering](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_whole_key_filtering)|

## rocksdb_write_batch_max_bytes
|name|value|
|----|-----|
|Name|`rocksdb_write_batch_max_bytes`|
|Command line|`--rocksdb-write-batch-max-bytes=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_write_batch_max_bytes](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_write_batch_max_bytes)|

## rocksdb_write_disable_wal
|name|value|
|----|-----|
|Name|`rocksdb_write_disable_wal`|
|Command line|`--rocksdb-write-disable-wal={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_write_disable_wal](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_write_disable_wal)|

## rocksdb_write_ignore_missing_column_families
|name|value|
|----|-----|
|Name|`rocksdb_write_ignore_missing_column_families`|
|Command line|`--rocksdb-write-ignore-missing-column-families={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_write_ignore_missing_column_families](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_write_ignore_missing_column_families)|

## rocksdb_write_policy
|name|value|
|----|-----|
|Name|`rocksdb_write_policy`|
|Command line|`--rocksdb-write-policy=val`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`write_committed`|
|Dynamic|`false`|
|Valid value(s)|`write_committed`, `write_prepared`, `write_unprepared`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rocksdb_write_policy](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/myrocks/myrocks-system-variables/#rocksdb_write_policy)|

## oqgraph_allow_create_integer_latch
|name|value|
|----|-----|
|Name|`oqgraph_allow_create_integer_latch`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[oqgraph_allow_create_integer_latch](https://mariadb.com/kb/en/library/documentation/oqgraph-system-and-status-variables/#oqgraph_allow_create_integer_latch)|

## Oqgraph_boost_version
|name|value|
|----|-----|
|Name|`Oqgraph_boost_version`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[oqgraph_boost_version](https://mariadb.com/kb/en/library/documentation/oqgraph-system-and-status-variables/#oqgraph_boost_version)|

## Oqgraph_compat_mode
|name|value|
|----|-----|
|Name|`Oqgraph_compat_mode`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[oqgraph_compat_mode](https://mariadb.com/kb/en/library/documentation/oqgraph-system-and-status-variables/#oqgraph_compat_mode)|

## Oqgraph_verbose_debug
|name|value|
|----|-----|
|Name|`Oqgraph_verbose_debug`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[oqgraph_verbose_debug](https://mariadb.com/kb/en/library/documentation/oqgraph-system-and-status-variables/#oqgraph_verbose_debug)|

## performance_schema
|name|value|
|----|-----|
|Name|`performance_schema`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema)|
|dev.mysql.com|[sysvar_performance_schema](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema)|

## performance_schema_accounts_size
|name|value|
|----|-----|
|Name|`performance_schema_accounts_size`|
|Command line|`--performance-schema-accounts-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `-1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_accounts_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_accounts_size)|
|dev.mysql.com|[sysvar_performance_schema_accounts_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_accounts_size)|

## performance_schema_digests_size
|name|value|
|----|-----|
|Name|`performance_schema_digests_size`|
|Command line|`--performance-schema-digests-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `-1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_digests_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_digests_size)|
|dev.mysql.com|[sysvar_performance_schema_digests_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_digests_size)|

## performance_schema_events_stages_history_long_size
|name|value|
|----|-----|
|Name|`performance_schema_events_stages_history_long_size`|
|Command line|`--performance-schema-events-stages-history-long-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_stages_history_long_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_stages_history_long_size)|
|dev.mysql.com|[sysvar_performance_schema_events_stages_history_long_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_stages_history_long_size)|

## performance_schema_events_stages_history_size
|name|value|
|----|-----|
|Name|`performance_schema_events_stages_history_size`|
|Command line|`--performance-schema-events-stages-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_stages_history_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_stages_history_size)|
|dev.mysql.com|[sysvar_performance_schema_events_stages_history_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_stages_history_size)|

## performance_schema_events_statements_history_long_size
|name|value|
|----|-----|
|Name|`performance_schema_events_statements_history_long_size`|
|Command line|`--performance-schema-events-statements-history-long-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_statements_history_long_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_statements_history_long_size)|
|dev.mysql.com|[sysvar_performance_schema_events_statements_history_long_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_statements_history_long_size)|

## performance_schema_events_statements_history_size
|name|value|
|----|-----|
|Name|`performance_schema_events_statements_history_size`|
|Command line|`--performance-schema-events-statements-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_statements_history_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_statements_history_size)|
|dev.mysql.com|[sysvar_performance_schema_events_statements_history_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_statements_history_size)|

## performance_schema_events_transactions_history_long_size
|name|value|
|----|-----|
|Name|`performance_schema_events_transactions_history_long_size`|
|Command line|`--performance-schema-events-transactions-history-long-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_transactions_history_long_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_transactions_history_long_size)|
|dev.mysql.com|[sysvar_performance_schema_events_transactions_history_long_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_transactions_history_long_size)|

## performance_schema_events_transactions_history_size
|name|value|
|----|-----|
|Name|`performance_schema_events_transactions_history_size`|
|Command line|`--performance-schema-events-transactions-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_transactions_history_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_transactions_history_size)|
|dev.mysql.com|[sysvar_performance_schema_events_transactions_history_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_transactions_history_size)|

## performance_schema_events_waits_history_long_size
|name|value|
|----|-----|
|Name|`performance_schema_events_waits_history_long_size`|
|Command line|`--performance-schema-events-waits-history-long-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_waits_history_long_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_waits_history_long_size)|
|dev.mysql.com|[sysvar_performance_schema_events_waits_history_long_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_waits_history_long_size)|

## performance_schema_events_waits_history_size
|name|value|
|----|-----|
|Name|`performance_schema_events_waits_history_size`|
|Command line|`--performance-schema-events-waits-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_events_waits_history_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_events_waits_history_size)|
|dev.mysql.com|[sysvar_performance_schema_events_waits_history_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_events_waits_history_size)|

## performance_schema_hosts_size
|name|value|
|----|-----|
|Name|`performance_schema_hosts_size`|
|Command line|`--performance-schema-hosts-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `-1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_hosts_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_hosts_size)|
|dev.mysql.com|[sysvar_performance_schema_hosts_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_hosts_size)|

## performance_schema_max_cond_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_cond_classes`|
|Command line|`--performance-schema-max-cond-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_cond_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_cond_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_cond_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_cond_classes)|

## performance_schema_max_cond_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_cond_instances`|
|Command line|`--performance-schema-max-cond-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_cond_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_cond_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_cond_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_cond_instances)|

## performance_schema_max_digest_length
|name|value|
|----|-----|
|Name|`performance_schema_max_digest_length`|
|Command line|`--performance-schema-max-digest-length=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Dynamic|`false`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_digest_length](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_digest_length)|
|dev.mysql.com|[sysvar_performance_schema_max_digest_length](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_digest_length)|

## performance_schema_max_file_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_file_classes`|
|Command line|`--performance-schema-max-file-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`80`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_file_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_file_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_file_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_file_classes)|

## performance_schema_max_file_handles
|name|value|
|----|-----|
|Name|`performance_schema_max_file_handles`|
|Command line|`--performance-schema-max-file-handles=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32768`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_file_handles](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_file_handles)|
|dev.mysql.com|[sysvar_performance_schema_max_file_handles](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_file_handles)|

## performance_schema_max_file_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_file_instances`|
|Command line|`--performance-schema-max-file-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_file_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_file_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_file_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_file_instances)|

## performance_schema_max_index_stat
|name|value|
|----|-----|
|Name|`performance_schema_max_index_stat`|
|Command line|`--performance-schema-max-index-stat=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_index_stat](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_index_stat)|
|dev.mysql.com|[sysvar_performance_schema_max_index_stat](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_index_stat)|

## performance_schema_max_memory_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_memory_classes`|
|Command line|`--performance-schema-max-memory-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_memory_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_memory_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_memory_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_memory_classes)|

## performance_schema_max_metadata_locks
|name|value|
|----|-----|
|Name|`performance_schema_max_metadata_locks`|
|Command line|`--performance-schema-max-metadata-locks=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_metadata_locks](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_metadata_locks)|
|dev.mysql.com|[sysvar_performance_schema_max_metadata_locks](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_metadata_locks)|

## performance_schema_max_mutex_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_mutex_classes`|
|Command line|`--performance-schema-max-mutex-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_mutex_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_mutex_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_mutex_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_mutex_classes)|

## performance_schema_max_mutex_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_mutex_instances`|
|Command line|`--performance-schema-max-mutex-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_mutex_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_mutex_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_mutex_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_mutex_instances)|

## performance_schema_max_prepared_statement_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_prepared_statement_instances`|
|Command line|`--performance-schema-max-prepared-statement-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`-1`|
|Dynamic|`false`|
|Range|from: `-1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_prepared_statement_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_prepared_statement_instances)|

## performance_schema_max_program_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_program_instances`|
|Command line|`--performance-schema-max-program-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_program_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_program_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_program_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_program_instances)|

## performance_schema_max_rwlock_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_rwlock_classes`|
|Command line|`--performance-schema-max-rwlock-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_rwlock_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_rwlock_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_rwlock_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_rwlock_classes)|

## performance_schema_max_rwlock_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_rwlock_instances`|
|Command line|`--performance-schema-max-rwlock-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_rwlock_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_rwlock_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_rwlock_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_rwlock_instances)|

## performance_schema_max_socket_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_socket_classes`|
|Command line|`--performance-schema-max-socket-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_socket_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_socket_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_socket_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_socket_classes)|

## performance_schema_max_socket_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_socket_instances`|
|Command line|`--performance-schema-max-socket-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_socket_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_socket_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_socket_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_socket_instances)|

## performance_schema_max_sql_text_length
|name|value|
|----|-----|
|Name|`performance_schema_max_sql_text_length`|
|Command line|`--performance-schema-max-sql-text-length=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Dynamic|`false`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_sql_text_length](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_sql_text_length)|
|dev.mysql.com|[sysvar_performance_schema_max_sql_text_length](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_sql_text_length)|

## performance_schema_max_stage_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_stage_classes`|
|Command line|`--performance-schema-max-stage-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_stage_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_stage_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_stage_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_stage_classes)|

## performance_schema_max_statement_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_statement_classes`|
|Command line|`--performance-schema-max-statement-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`(-1 signifies autosizing; do not use -1)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_statement_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_statement_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_statement_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_statement_classes)|

## performance_schema_max_statement_stack
|name|value|
|----|-----|
|Name|`performance_schema_max_statement_stack`|
|Command line|`--performance-schema-max-statement-stack=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_statement_stack](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_statement_stack)|
|dev.mysql.com|[sysvar_performance_schema_max_statement_stack](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_statement_stack)|

## performance_schema_max_table_handles
|name|value|
|----|-----|
|Name|`performance_schema_max_table_handles`|
|Command line|`--performance-schema-max-table-handles=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_table_handles](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_table_handles)|
|dev.mysql.com|[sysvar_performance_schema_max_table_handles](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_table_handles)|

## performance_schema_max_table_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_table_instances`|
|Command line|`--performance-schema-max-table-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_table_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_table_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_table_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_table_instances)|

## performance_schema_max_table_lock_stat
|name|value|
|----|-----|
|Name|`performance_schema_max_table_lock_stat`|
|Command line|`--performance-schema-max-table-lock-stat=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_table_lock_stat](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_table_lock_stat)|
|dev.mysql.com|[sysvar_performance_schema_max_table_lock_stat](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_table_lock_stat)|

## performance_schema_max_thread_classes
|name|value|
|----|-----|
|Name|`performance_schema_max_thread_classes`|
|Command line|`--performance-schema-max-thread-classes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_thread_classes](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_thread_classes)|
|dev.mysql.com|[sysvar_performance_schema_max_thread_classes](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_thread_classes)|

## performance_schema_max_thread_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_thread_instances`|
|Command line|`--performance-schema-max-thread-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_max_thread_instances](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_max_thread_instances)|
|dev.mysql.com|[sysvar_performance_schema_max_thread_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_thread_instances)|

## performance_schema_session_connect_attrs_size
|name|value|
|----|-----|
|Name|`performance_schema_session_connect_attrs_size`|
|Command line|`--performance-schema-session-connect-attrs-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `-1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_session_connect_attrs_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_session_connect_attrs_size)|
|dev.mysql.com|[sysvar_performance_schema_session_connect_attrs_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_session_connect_attrs_size)|

## performance_schema_setup_actors_size
|name|value|
|----|-----|
|Name|`performance_schema_setup_actors_size`|
|Command line|`--performance-schema-setup-actors-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_setup_actors_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_setup_actors_size)|
|dev.mysql.com|[sysvar_performance_schema_setup_actors_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_setup_actors_size)|

## performance_schema_setup_objects_size
|name|value|
|----|-----|
|Name|`performance_schema_setup_objects_size`|
|Command line|`--performance-schema-setup-objects-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_setup_objects_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_setup_objects_size)|
|dev.mysql.com|[sysvar_performance_schema_setup_objects_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_setup_objects_size)|

## performance_schema_users_size
|name|value|
|----|-----|
|Name|`performance_schema_users_size`|
|Command line|`--performance-schema-users-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `-1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[performance_schema_users_size](https://mariadb.com/kb/en/library/documentation/performance-schema-system-variables/#performance_schema_users_size)|
|dev.mysql.com|[sysvar_performance_schema_users_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_users_size)|

## auto_increment_increment
|name|value|
|----|-----|
|Name|`auto_increment_increment`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[auto_increment_increment](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#auto_increment_increment)|
|dev.mysql.com|[sysvar_auto_increment_increment](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment)|

## auto_increment_offset
|name|value|
|----|-----|
|Name|`auto_increment_offset`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[auto_increment_offset](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#auto_increment_offset)|
|dev.mysql.com|[sysvar_auto_increment_offset](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset)|

## binlog_annotate_row_events
|name|value|
|----|-----|
|Name|`binlog_annotate_row_events`|
|Command line|`--binlog-annotate-row-events[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON (>= MariaDB 10.2.4), OFF (<= MariaDB 10.2.3)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_annotate_row_events](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_annotate_row_events)|

## binlog_cache_size
|name|value|
|----|-----|
|Name|`binlog_cache_size`|
|Command line|`--binlog-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32768`|
|Dynamic|`true`|
|Range|from: `4096`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_cache_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_cache_size)|
|dev.mysql.com|[sysvar_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_cache_size)|
|dev.mysql.com|[sysvar_binlog_cache_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_cache_size)|

## binlog_checksum
|name|value|
|----|-----|
|Name|`binlog_checksum`|
|Command line|`--binlog-checksum=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`CRC32`|
|Dynamic|`true`|
|Valid value(s)|`NONE`, `0`, `CRC32`, `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_checksum](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_checksum)|
|dev.mysql.com|[option_mysqld_binlog-checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_binlog-checksum)|
|dev.mysql.com|[sysvar_binlog_checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_checksum)|
|dev.mysql.com|[option_mysqld_binlog-checksum](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_binlog-checksum)|
|dev.mysql.com|[sysvar_binlog_checksum](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_checksum)|

## binlog_commit_wait_count
|name|value|
|----|-----|
|Name|`binlog_commit_wait_count`|
|Command line|`--binlog-commit-wait-count=#]`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_commit_wait_count](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_commit_wait_count)|

## binlog_commit_wait_usec
|name|value|
|----|-----|
|Name|`binlog_commit_wait_usec`|
|Command line|`--binlog-commit-wait-usec#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100000`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_commit_wait_usec](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_commit_wait_usec)|

## binlog_direct_non_transactional_updates
|name|value|
|----|-----|
|Name|`binlog_direct_non_transactional_updates`|
|Command line|`--binlog-direct-non-transactional-updates[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_direct_non_transactional_updates](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_direct_non_transactional_updates)|
|dev.mysql.com|[sysvar_binlog_direct_non_transactional_updates](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_direct_non_transactional_updates)|
|dev.mysql.com|[sysvar_binlog_direct_non_transactional_updates](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_direct_non_transactional_updates)|

## binlog_expire_logs_seconds
|name|value|
|----|-----|
|Name|`binlog_expire_logs_seconds`|
|Command line|`--binlog-expire-logs-seconds=#`|
|Type of variable|`integer`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_expire_logs_seconds](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_expire_logs_seconds)|
|dev.mysql.com|[sysvar_binlog_expire_logs_seconds](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_expire_logs_seconds)|

## binlog_file_cache_size
|name|value|
|----|-----|
|Name|`binlog_file_cache_size`|
|Command line|`--binlog-file-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`16384`|
|Dynamic|`true`|
|Range|from: `8192` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_file_cache_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_file_cache_size)|

## binlog_format
|name|value|
|----|-----|
|Name|`binlog_format`|
|Command line|`--binlog-format=format`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`ROW`|
|Dynamic|`true`|
|Valid value(s)|`MIXED`, `STATEMENT`, `ROW`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_format](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_format)|
|dev.mysql.com|[sysvar_binlog_format](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_format)|
|dev.mysql.com|[sysvar_binlog_format](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_format)|

## binlog_optimize_thread_scheduling
|name|value|
|----|-----|
|Name|`binlog_optimize_thread_scheduling`|
|Command line|`--binlog-optimize-thread-scheduling or --skip-binlog-optimize-thread-scheduling`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_optimize_thread_scheduling](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_optimize_thread_scheduling)|

## binlog_row_image
|name|value|
|----|-----|
|Name|`binlog_row_image`|
|Command line|`--binlog-row-image=image_type`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`full`|
|Dynamic|`true`|
|Valid value(s)|`FULL`, `NOBLOB`, `MINIMAL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_row_image](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_row_image)|
|dev.mysql.com|[sysvar_binlog_row_image](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_image)|
|dev.mysql.com|[sysvar_binlog_row_image](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_row_image)|

## binlog_row_metadata
|name|value|
|----|-----|
|Name|`binlog_row_metadata`|
|Type of variable|`enumeration`|
|Default value|`MINIMAL`|
|Dynamic|`true`|
|Valid value(s)|`NO_LOG`, `MINIMAL`, `FULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_row_metadata](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_row_metadata)|
|dev.mysql.com|[sysvar_binlog_row_metadata](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_metadata)|

## binlog_stmt_cache_size
|name|value|
|----|-----|
|Name|`binlog_stmt_cache_size`|
|Command line|`--binlog-stmt-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32768`|
|Dynamic|`true`|
|Range|from: `4096`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_stmt_cache_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#binlog_stmt_cache_size)|
|dev.mysql.com|[sysvar_binlog_stmt_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_stmt_cache_size)|
|dev.mysql.com|[sysvar_binlog_stmt_cache_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_stmt_cache_size)|

## default_master_connection
|name|value|
|----|-----|
|Name|`default_master_connection`|
|Type of variable|`string`|
|Scope|`session`|
|Default value|`'' (empty string)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_master_connection](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#default_master_connection)|

## encrypt_binlog
|name|value|
|----|-----|
|Name|`encrypt_binlog`|
|Command line|`--encrypt-binlog[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[encrypt_binlog](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#encrypt_binlog)|

## expire_logs_days
|name|value|
|----|-----|
|Name|`expire_logs_days`|
|Command line|`--expire-logs-days=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `99`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[expire_logs_days](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#expire_logs_days)|
|dev.mysql.com|[sysvar_expire_logs_days](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_expire_logs_days)|
|dev.mysql.com|[sysvar_expire_logs_days](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_expire_logs_days)|

## init_slave
|name|value|
|----|-----|
|Name|`init_slave`|
|Command line|`--init-slave=name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[init_slave](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#init_slave)|
|dev.mysql.com|[sysvar_init_slave](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_init_slave)|

## log_bin
|name|value|
|----|-----|
|Name|`log_bin`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin)|
|dev.mysql.com|[option_mysqld_log-bin](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_log-bin)|
|dev.mysql.com|[sysvar_log_bin](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_bin)|
|dev.mysql.com|[option_mysqld_log-bin](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_log-bin)|
|dev.mysql.com|[sysvar_log_bin](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_bin)|

## log_bin_basename
|name|value|
|----|-----|
|Name|`log_bin_basename`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin_basename](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin_basename)|
|dev.mysql.com|[sysvar_log_bin_basename](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_bin_basename)|
|dev.mysql.com|[sysvar_log_bin_basename](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_bin_basename)|

## log_bin_compress
|name|value|
|----|-----|
|Name|`log_bin_compress`|
|Command line|`--log-bin-compress`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin_compress](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin_compress)|

## log_bin_compress_min_len
|name|value|
|----|-----|
|Name|`log_bin_compress_min_len`|
|Command line|`--log-bin-compress-min-len`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`256`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin_compress_min_len](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin_compress_min_len)|

## log_bin_index
|name|value|
|----|-----|
|Name|`log_bin_index`|
|Command line|`--log-bin-index=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin_index](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin_index)|
|dev.mysql.com|[option_mysqld_log-bin-index](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_log-bin-index)|
|dev.mysql.com|[sysvar_log_bin_index](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_bin_index)|
|dev.mysql.com|[option_mysqld_log-bin-index](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_log-bin-index)|
|dev.mysql.com|[sysvar_log_bin_index](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_bin_index)|

## log_bin_trust_function_creators
|name|value|
|----|-----|
|Name|`log_bin_trust_function_creators`|
|Command line|`--log-bin-trust-function-creators[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_bin_trust_function_creators](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_bin_trust_function_creators)|
|dev.mysql.com|[sysvar_log_bin_trust_function_creators](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_bin_trust_function_creators)|
|dev.mysql.com|[sysvar_log_bin_trust_function_creators](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_bin_trust_function_creators)|

## log_slow_slave_statements
|name|value|
|----|-----|
|Name|`log_slow_slave_statements`|
|Command line|`--log-slow-slave-statements[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_slave_statements](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_slow_slave_statements)|
|dev.mysql.com|[sysvar_log_slow_slave_statements](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_log_slow_slave_statements)|

## log_slave_updates
|name|value|
|----|-----|
|Name|`log_slave_updates`|
|Command line|`--log-slave-updates[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slave_updates](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#log_slave_updates)|
|dev.mysql.com|[sysvar_log_slave_updates](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_slave_updates)|
|dev.mysql.com|[sysvar_log_slave_updates](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_slave_updates)|

## master_verify_checksum
|name|value|
|----|-----|
|Name|`master_verify_checksum`|
|Command line|`--master-verify-checksum[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[master_verify_checksum](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#master_verify_checksum)|
|dev.mysql.com|[sysvar_master_verify_checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_master_verify_checksum)|
|dev.mysql.com|[sysvar_master_verify_checksum](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_master_verify_checksum)|

## max_binlog_cache_size
|name|value|
|----|-----|
|Name|`max_binlog_cache_size`|
|Command line|`--max-binlog-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`18446744073709547520`|
|Dynamic|`true`|
|Range|from: `4096` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_binlog_cache_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#max_binlog_cache_size)|
|dev.mysql.com|[sysvar_max_binlog_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size)|
|dev.mysql.com|[sysvar_max_binlog_cache_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_max_binlog_cache_size)|

## max_binlog_size
|name|value|
|----|-----|
|Name|`max_binlog_size`|
|Command line|`--max-binlog-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1073741824`|
|Dynamic|`true`|
|Range|from: `4096` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_binlog_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#max_binlog_size)|
|dev.mysql.com|[sysvar_max_binlog_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_size)|
|dev.mysql.com|[sysvar_max_binlog_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_max_binlog_size)|

## max_binlog_stmt_cache_size
|name|value|
|----|-----|
|Name|`max_binlog_stmt_cache_size`|
|Command line|`--max-binlog-stmt-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`18446744073709547520`|
|Dynamic|`true`|
|Range|from: `4096` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_binlog_stmt_cache_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#max_binlog_stmt_cache_size)|
|dev.mysql.com|[sysvar_max_binlog_stmt_cache_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_max_binlog_stmt_cache_size)|
|dev.mysql.com|[sysvar_max_binlog_stmt_cache_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_max_binlog_stmt_cache_size)|

## max_relay_log_size
|name|value|
|----|-----|
|Name|`max_relay_log_size`|
|Command line|`--max-relay-log-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_relay_log_size](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#max_relay_log_size)|
|dev.mysql.com|[option_mysqld_max-relay-log-size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_max-relay-log-size)|
|dev.mysql.com|[sysvar_max_relay_log_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_max_relay_log_size)|

## read_binlog_speed_limit
|name|value|
|----|-----|
|Name|`read_binlog_speed_limit`|
|Command line|`--read-binlog-speed-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0 (no limit)`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[read_binlog_speed_limit](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#read_binlog_speed_limit)|

## relay_log
|name|value|
|----|-----|
|Name|`relay_log`|
|Command line|`--relay-log=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log)|
|dev.mysql.com|[sysvar_relay_log](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log)|

## relay_log_basename
|name|value|
|----|-----|
|Name|`relay_log_basename`|
|Scope|`global`|
|Default value|`datadir + '/' + hostname + '-relay-bin'`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_basename](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_basename)|
|dev.mysql.com|[sysvar_relay_log_basename](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_basename)|

## relay_log_index
|name|value|
|----|-----|
|Name|`relay_log_index`|
|Scope|`global`|
|Default value|`*host_name*-relay-bin.index`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_index](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_index)|
|dev.mysql.com|[sysvar_relay_log_index](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_index)|

## relay_log_info_file
|name|value|
|----|-----|
|Name|`relay_log_info_file`|
|Command line|`--relay-log-info-file=file_name`|
|Scope|`global`|
|Default value|`relay-log.info`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_info_file](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_info_file)|
|dev.mysql.com|[sysvar_relay_log_info_file](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_info_file)|

## relay_log_purge
|name|value|
|----|-----|
|Name|`relay_log_purge`|
|Command line|`--relay-log-purge[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_purge](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_purge)|
|dev.mysql.com|[option_mysqld_relay-log-purge](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_relay-log-purge)|
|dev.mysql.com|[sysvar_relay_log_purge](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_purge)|

## relay_log_recovery
|name|value|
|----|-----|
|Name|`relay_log_recovery`|
|Command line|`--relay-log-recovery[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_recovery](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_recovery)|
|dev.mysql.com|[sysvar_relay_log_recovery](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_recovery)|

## relay_log_space_limit
|name|value|
|----|-----|
|Name|`relay_log_space_limit`|
|Command line|`--relay-log-space-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[relay_log_space_limit](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#relay_log_space_limit)|
|dev.mysql.com|[option_mysqld_relay-log-space-limit](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_relay-log-space-limit)|
|dev.mysql.com|[sysvar_relay_log_space_limit](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_space_limit)|

## replicate_annotate_row_events
|name|value|
|----|-----|
|Name|`replicate_annotate_row_events`|
|Command line|`--replicate-annotate-row-events`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON (>= MariaDB 10.2.4), OFF (<= MariaDB 10.2.3)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_annotate_row_events](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_annotate_row_events)|

## replicate_do_db
|name|value|
|----|-----|
|Name|`replicate_do_db`|
|Command line|`--replicate-do-db=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_do_db](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_do_db)|
|dev.mysql.com|[option_mysqld_replicate-do-db](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-do-db)|

## replicate_do_table
|name|value|
|----|-----|
|Name|`replicate_do_table`|
|Command line|`--replicate-do-table=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_do_table](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_do_table)|
|dev.mysql.com|[option_mysqld_replicate-do-table](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-do-table)|

## replicate_events_marked_for_skip
|name|value|
|----|-----|
|Name|`replicate_events_marked_for_skip`|
|Command line|`--replicate-events-marked-for-skip`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`replicate`|
|Dynamic|`true`|
|Valid value(s)|`REPLICATE`, `FILTER_ON_SLAVE`, `FILTER_ON_MASTER`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_events_marked_for_skip](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_events_marked_for_skip)|

## replicate_ignore_db
|name|value|
|----|-----|
|Name|`replicate_ignore_db`|
|Command line|`--replicate-ignore-db=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_ignore_db](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_ignore_db)|
|dev.mysql.com|[option_mysqld_replicate-ignore-db](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-ignore-db)|

## replicate_ignore_table
|name|value|
|----|-----|
|Name|`replicate_ignore_table`|
|Command line|`--replicate-ignore-table=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_ignore_table](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_ignore_table)|
|dev.mysql.com|[option_mysqld_replicate-ignore-table](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-ignore-table)|

## replicate_rewrite_db
|name|value|
|----|-----|
|Name|`replicate_rewrite_db`|
|Command line|`--replicate-rewrite-db=old_name->new_name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_rewrite_db](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_rewrite_db)|
|dev.mysql.com|[option_mysqld_replicate-rewrite-db](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-rewrite-db)|

## replicate_wild_do_table
|name|value|
|----|-----|
|Name|`replicate_wild_do_table`|
|Command line|`--replicate-wild-do-table=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_wild_do_table](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_wild_do_table)|
|dev.mysql.com|[option_mysqld_replicate-wild-do-table](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-wild-do-table)|

## replicate_wild_ignore_table
|name|value|
|----|-----|
|Name|`replicate_wild_ignore_table`|
|Command line|`--replicate-wild-ignore-table=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[replicate_wild_ignore_table](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#replicate_wild_ignore_table)|
|dev.mysql.com|[option_mysqld_replicate-wild-ignore-table](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-wild-ignore-table)|

## report_host
|name|value|
|----|-----|
|Name|`report_host`|
|Command line|`--report-host=host_name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[report_host](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#report_host)|
|dev.mysql.com|[sysvar_report_host](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_report_host)|

## report_password
|name|value|
|----|-----|
|Name|`report_password`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[report_password](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#report_password)|
|dev.mysql.com|[sysvar_report_password](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_report_password)|

## report_port
|name|value|
|----|-----|
|Name|`report_port`|
|Command line|`--report-port=port-num`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`[slave_port]`|
|Dynamic|`false`|
|Range|from: `0` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[report_port](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#report_port)|
|dev.mysql.com|[sysvar_report_port](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_report_port)|

## report_user
|name|value|
|----|-----|
|Name|`report_user`|
|Command line|`--report-user=name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[report_user](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#report_user)|
|dev.mysql.com|[sysvar_report_user](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_report_user)|

## skip_parallel_replication
|name|value|
|----|-----|
|Name|`skip_parallel_replication`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_parallel_replication](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#skip_parallel_replication)|

## skip_replication
|name|value|
|----|-----|
|Name|`skip_replication`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_replication](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#skip_replication)|

## slave_compressed_protocol
|name|value|
|----|-----|
|Name|`slave_compressed_protocol`|
|Command line|`--slave-compressed-protocol[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_compressed_protocol](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_compressed_protocol)|
|dev.mysql.com|[sysvar_slave_compressed_protocol](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_compressed_protocol)|

## slave_ddl_exec_mode
|name|value|
|----|-----|
|Name|`slave_ddl_exec_mode`|
|Command line|`--slave-ddl-exec-mode=name`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`IDEMPOTENT`|
|Dynamic|`true`|
|Valid value(s)|`IDEMPOTENT`, `STRICT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_ddl_exec_mode](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_ddl_exec_mode)|

## slave_domain_parallel_threads
|name|value|
|----|-----|
|Name|`slave_domain_parallel_threads`|
|Command line|`--slave-domain-parallel-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Valid value(s)|`0`, `16383`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_domain_parallel_threads](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_domain_parallel_threads)|

## slave_exec_mode
|name|value|
|----|-----|
|Name|`slave_exec_mode`|
|Command line|`--slave-exec-mode=mode`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`IDEMPOTENT (NDB)STRICT (Other)`|
|Dynamic|`true`|
|Valid value(s)|`STRICT`, `IDEMPOTENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_exec_mode](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_exec_mode)|
|dev.mysql.com|[sysvar_slave_exec_mode](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_exec_mode)|

## slave_load_tmpdir
|name|value|
|----|-----|
|Name|`slave_load_tmpdir`|
|Command line|`--slave-load-tmpdir=path`|
|Scope|`global`|
|Default value|`Value of --tmpdir`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_load_tmpdir](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_load_tmpdir)|
|dev.mysql.com|[sysvar_slave_load_tmpdir](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_load_tmpdir)|

## slave_max_allowed_packet
|name|value|
|----|-----|
|Name|`slave_max_allowed_packet`|
|Command line|`--slave-max-allowed-packet=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1073741824`|
|Dynamic|`true`|
|Range|from: `1024` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_max_allowed_packet](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_max_allowed_packet)|
|dev.mysql.com|[sysvar_slave_max_allowed_packet](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_max_allowed_packet)|

## slave_net_timeout
|name|value|
|----|-----|
|Name|`slave_net_timeout`|
|Command line|`--slave-net-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60`|
|Dynamic|`true`|
|Range|from: `1` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_net_timeout](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_net_timeout)|
|dev.mysql.com|[sysvar_slave_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_net_timeout)|

## slave_parallel_max_queued
|name|value|
|----|-----|
|Name|`slave_parallel_max_queued`|
|Command line|`--slave-parallel-max-queued=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`131072`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_parallel_max_queued](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_parallel_max_queued)|

## slave_parallel_mode
|name|value|
|----|-----|
|Name|`slave_parallel_mode`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`optimistic (>= MariaDB 10.5.1), conservative (<= MariaDB 10.5.0)`|
|Dynamic|`true`|
|Valid value(s)|`conservative`, `optimistic`, `none`, `aggressive`, `minimal`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_parallel_mode](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_parallel_mode)|

## slave_parallel_threads
|name|value|
|----|-----|
|Name|`slave_parallel_threads`|
|Command line|`--slave-parallel-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `16383`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_parallel_threads](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_parallel_threads)|

## slave_parallel_workers
|name|value|
|----|-----|
|Name|`slave_parallel_workers`|
|Command line|`--slave-parallel-workers=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_parallel_workers](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_parallel_workers)|
|dev.mysql.com|[sysvar_slave_parallel_workers](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_parallel_workers)|

## slave_run_triggers_for_rbr
|name|value|
|----|-----|
|Name|`slave_run_triggers_for_rbr`|
|Command line|`--slave-run-triggers-for-rbr=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NO`|
|Valid value(s)|`NO`, `YES`, `LOGGING`, `ENFORCE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_run_triggers_for_rbr](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_run_triggers_for_rbr)|

## slave_skip_errors
|name|value|
|----|-----|
|Name|`slave_skip_errors`|
|Command line|`--slave-skip-errors=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|
|Valid value(s)|`[list of error codes]`, `ALL`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_skip_errors](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_skip_errors)|
|dev.mysql.com|[option_mysqld_slave-skip-errors](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_slave-skip-errors)|
|dev.mysql.com|[sysvar_slave_skip_errors](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_skip_errors)|

## slave_sql_verify_checksum
|name|value|
|----|-----|
|Name|`slave_sql_verify_checksum`|
|Command line|`--slave-sql-verify-checksum[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_sql_verify_checksum](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_sql_verify_checksum)|
|dev.mysql.com|[option_mysqld_slave-sql-verify-checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_slave-sql-verify-checksum)|
|dev.mysql.com|[sysvar_slave_sql_verify_checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_sql_verify_checksum)|

## slave_transaction_retries
|name|value|
|----|-----|
|Name|`slave_transaction_retries`|
|Command line|`--slave-transaction-retries=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_transaction_retries](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_transaction_retries)|
|dev.mysql.com|[sysvar_slave_transaction_retries](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_transaction_retries)|

## slave_transaction_retry_errors
|name|value|
|----|-----|
|Name|`slave_transaction_retry_errors`|
|Command line|`--slave-transaction_retry-errors=[error_code1,error_code2,...]`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`1158,1159,1160,1161,1205,1213,1429,2013,12701 (>= MariaDB 10.4.5), 1213,1205 (>= MariaDB 10.3.3)`|
|Dynamic|`false`|
|Valid value(s)|`comma-separated list of error codes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_transaction_retry_errors](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_transaction_retry_errors)|

## slave_transaction_retry_interval
|name|value|
|----|-----|
|Name|`slave_transaction_retry_interval`|
|Command line|`--slave-transaction-retry-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `3600`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_transaction_retry_interval](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_transaction_retry_interval)|

## slave_type_conversions
|name|value|
|----|-----|
|Name|`slave_type_conversions`|
|Command line|`--slave-type-conversions=set`|
|Type of variable|`set`|
|Scope|`global`|
|Default value|``|
|Dynamic|`true`|
|Valid value(s)|`ALL_LOSSY`, `ALL_NON_LOSSY`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_type_conversions](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#slave_type_conversions)|
|dev.mysql.com|[sysvar_slave_type_conversions](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_type_conversions)|

## sql_log_bin
|name|value|
|----|-----|
|Name|`sql_log_bin`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_log_bin](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sql_log_bin)|
|dev.mysql.com|[sysvar_sql_log_bin](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_sql_log_bin)|
|dev.mysql.com|[sysvar_sql_log_bin](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_sql_log_bin)|

## sql_slave_skip_counter
|name|value|
|----|-----|
|Name|`sql_slave_skip_counter`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_slave_skip_counter](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sql_slave_skip_counter)|
|dev.mysql.com|[sysvar_sql_slave_skip_counter](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_sql_slave_skip_counter)|

## sync_binlog
|name|value|
|----|-----|
|Name|`sync_binlog`|
|Command line|`--sync-binlog=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sync_binlog](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sync_binlog)|
|dev.mysql.com|[sysvar_sync_binlog](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_sync_binlog)|
|dev.mysql.com|[sysvar_sync_binlog](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_sync_binlog)|

## sync_master_info
|name|value|
|----|-----|
|Name|`sync_master_info`|
|Command line|`--sync-master-info=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sync_master_info](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sync_master_info)|
|dev.mysql.com|[sysvar_sync_master_info](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_sync_master_info)|

## sync_relay_log
|name|value|
|----|-----|
|Name|`sync_relay_log`|
|Command line|`--sync-relay-log=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sync_relay_log](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sync_relay_log)|
|dev.mysql.com|[sysvar_sync_relay_log](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_sync_relay_log)|

## sync_relay_log_info
|name|value|
|----|-----|
|Name|`sync_relay_log_info`|
|Command line|`--sync-relay-log-info=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sync_relay_log_info](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-server-system-variables/#sync_relay_log_info)|
|dev.mysql.com|[sysvar_sync_relay_log_info](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_sync_relay_log_info)|

## Binlog_bytes_written
|name|value|
|----|-----|
|Name|`Binlog_bytes_written`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_bytes_written](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_bytes_written)|

## Binlog_cache_disk_use
|name|value|
|----|-----|
|Name|`Binlog_cache_disk_use`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_cache_disk_use](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_cache_disk_use)|

## Binlog_cache_use
|name|value|
|----|-----|
|Name|`Binlog_cache_use`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_cache_use](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_cache_use)|

## Binlog_commits
|name|value|
|----|-----|
|Name|`Binlog_commits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_commits](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_commits)|

## Binlog_group_commit_trigger_count
|name|value|
|----|-----|
|Name|`Binlog_group_commit_trigger_count`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_group_commit_trigger_count](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_group_commit_trigger_count)|

## Binlog_group_commit_trigger_lock_wait
|name|value|
|----|-----|
|Name|`Binlog_group_commit_trigger_lock_wait`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_group_commit_trigger_lock_wait](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_group_commit_trigger_lock_wait)|

## Binlog_group_commit_trigger_timeout
|name|value|
|----|-----|
|Name|`Binlog_group_commit_trigger_timeout`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_group_commit_trigger_timeout](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_group_commit_trigger_timeout)|

## Binlog_group_commits
|name|value|
|----|-----|
|Name|`Binlog_group_commits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_group_commits](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_group_commits)|

## Binlog_snapshot_file
|name|value|
|----|-----|
|Name|`Binlog_snapshot_file`|
|Type of variable|`string`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_snapshot_file](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_snapshot_file)|

## Binlog_snapshot_position
|name|value|
|----|-----|
|Name|`Binlog_snapshot_position`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_snapshot_position](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_snapshot_position)|

## Binlog_stmt_cache_disk_use
|name|value|
|----|-----|
|Name|`Binlog_stmt_cache_disk_use`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_stmt_cache_disk_use](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_stmt_cache_disk_use)|

## Binlog_stmt_cache_use
|name|value|
|----|-----|
|Name|`Binlog_stmt_cache_use`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[binlog_stmt_cache_use](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#binlog_stmt_cache_use)|

## Com_change_master
|name|value|
|----|-----|
|Name|`Com_change_master`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_change_master](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_change_master)|

## Com_show_binlog_status
|name|value|
|----|-----|
|Name|`Com_show_binlog_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_binlog_status](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_show_binlog_status)|

## Com_show_master_status
|name|value|
|----|-----|
|Name|`Com_show_master_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_master_status](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_show_master_status)|

## Com_show_new_master
|name|value|
|----|-----|
|Name|`Com_show_new_master`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_new_master](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_show_new_master)|

## Com_show_slave_hosts
|name|value|
|----|-----|
|Name|`Com_show_slave_hosts`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_slave_hosts](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_show_slave_hosts)|

## Com_show_slave_status
|name|value|
|----|-----|
|Name|`Com_show_slave_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_slave_status](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_show_slave_status)|

## Com_slave_start
|name|value|
|----|-----|
|Name|`Com_slave_start`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_slave_start](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_slave_start)|

## Com_slave_stop
|name|value|
|----|-----|
|Name|`Com_slave_stop`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_slave_stop](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_slave_stop)|

## Com_start_all_slaves
|name|value|
|----|-----|
|Name|`Com_start_all_slaves`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_start_all_slaves](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_start_all_slaves)|

## Com_start_slave
|name|value|
|----|-----|
|Name|`Com_start_slave`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_start_slave](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_start_slave)|

## Com_stop_all_slaves
|name|value|
|----|-----|
|Name|`Com_stop_all_slaves`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stop_all_slaves](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_stop_all_slaves)|

## Com_stop_slave
|name|value|
|----|-----|
|Name|`Com_stop_slave`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stop_slave](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#com_stop_slave)|

## Master_gtid_wait_count
|name|value|
|----|-----|
|Name|`Master_gtid_wait_count`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[master_gtid_wait_count](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#master_gtid_wait_count)|

## Master_gtid_wait_time
|name|value|
|----|-----|
|Name|`Master_gtid_wait_time`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[master_gtid_wait_time](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#master_gtid_wait_time)|

## Master_gtid_wait_timeouts
|name|value|
|----|-----|
|Name|`Master_gtid_wait_timeouts`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[master_gtid_wait_timeouts](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#master_gtid_wait_timeouts)|

## Rpl_status
|name|value|
|----|-----|
|Name|`Rpl_status`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_status](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#rpl_status)|

## Rpl_transactions_multi_engine
|name|value|
|----|-----|
|Name|`Rpl_transactions_multi_engine`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_transactions_multi_engine](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#rpl_transactions_multi_engine)|

## Slave_connections
|name|value|
|----|-----|
|Name|`Slave_connections`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_connections](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_connections)|

## Slave_heartbeat_period
|name|value|
|----|-----|
|Name|`Slave_heartbeat_period`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_heartbeat_period](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_heartbeat_period)|

## Slave_open_temp_tables
|name|value|
|----|-----|
|Name|`Slave_open_temp_tables`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_open_temp_tables](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_open_temp_tables)|

## Slave_received_heartbeats
|name|value|
|----|-----|
|Name|`Slave_received_heartbeats`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_received_heartbeats](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_received_heartbeats)|

## Slave_retried_transactions
|name|value|
|----|-----|
|Name|`Slave_retried_transactions`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_retried_transactions](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_retried_transactions)|

## Slave_running
|name|value|
|----|-----|
|Name|`Slave_running`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_running](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_running)|

## Slave_skipped_errors
|name|value|
|----|-----|
|Name|`Slave_skipped_errors`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slave_skipped_errors](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slave_skipped_errors)|

## Slaves_connected
|name|value|
|----|-----|
|Name|`Slaves_connected`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slaves_connected](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slaves_connected)|

## Slaves_running
|name|value|
|----|-----|
|Name|`Slaves_running`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slaves_running](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#slaves_running)|

## Transactions_gtid_foreign_engine
|name|value|
|----|-----|
|Name|`Transactions_gtid_foreign_engine`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[transactions_gtid_foreign_engine](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#transactions_gtid_foreign_engine)|

## Transactions_multi_engine
|name|value|
|----|-----|
|Name|`Transactions_multi_engine`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[transactions_multi_engine](https://mariadb.com/kb/en/library/documentation/replication-and-binary-log-status-variables/#transactions_multi_engine)|

## s3_access_key
|name|value|
|----|-----|
|Name|`s3_access_key`|
|Command line|`--s3-access-key=val`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_access_key](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_access_key)|

## s3_block_size
|name|value|
|----|-----|
|Name|`s3_block_size`|
|Command line|`--s3-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4194304`|
|Dynamic|`true`|
|Range|from: `4194304` to: `16777216`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_block_size)|

## s3_bucket
|name|value|
|----|-----|
|Name|`s3_bucket`|
|Command line|`--s3-bucket=val`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`MariaDB`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_bucket](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_bucket)|

## s3_debug
|name|value|
|----|-----|
|Name|`s3_debug`|
|Command line|`--s3-debug{=0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Valid value(s)|`0`, `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_debug](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_debug)|

## s3_host_name
|name|value|
|----|-----|
|Name|`s3_host_name`|
|Command line|`--s3-host-name=val`|
|Type of variable|`string`|
|Scope|``|
|Default value|`s3.amazonaws.com`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_host_name](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_host_name)|

## s3_pagecache_age_threshold
|name|value|
|----|-----|
|Name|`s3_pagecache_age_threshold`|
|Command line|`--s3-pagecache-age-threshold=val`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`300`|
|Dynamic|`true`|
|Range|from: `100` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_pagecache_age_threshold](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_pagecache_age_threshold)|

## s3_pagecache_buffer_size
|name|value|
|----|-----|
|Name|`s3_pagecache_buffer_size`|
|Command line|`--s3-pagecache-buffer-size=val`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`134217728 (128M)`|
|Dynamic|`false`|
|Range|from: `33554432` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_pagecache_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_pagecache_buffer_size)|

## s3_pagecache_division_limit
|name|value|
|----|-----|
|Name|`s3_pagecache_division_limit`|
|Command line|`--s3-pagecache-division-limit=val`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_pagecache_division_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_pagecache_division_limit)|

## s3_pagecache_file_hash_size
|name|value|
|----|-----|
|Name|`s3_pagecache_file_hash_size`|
|Command line|`--s3-pagecache-file-hash-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`512`|
|Dynamic|`false`|
|Range|from: `32` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_pagecache_file_hash_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_pagecache_file_hash_size)|

## s3_port
|name|value|
|----|-----|
|Name|`s3_port`|
|Command line|`--s3-port=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_port](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_port)|

## s3_protocol_version
|name|value|
|----|-----|
|Name|`s3_protocol_version`|
|Command line|`--s3-protocol-version=val`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`Auto`|
|Dynamic|`true`|
|Valid value(s)|`Auto`, `Amazon`, `Original`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_protocol_version](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_protocol_version)|

## s3_region
|name|value|
|----|-----|
|Name|`s3_region`|
|Command line|`--s3-region=val`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_region](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_region)|

## s3_replicate_alter_as_create_select
|name|value|
|----|-----|
|Name|`s3_replicate_alter_as_create_select`|
|Command line|`--s3-replicate-alter-as-create-select{=0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_replicate_alter_as_create_select](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_replicate_alter_as_create_select)|

## s3_secret_key
|name|value|
|----|-----|
|Name|`s3_secret_key`|
|Command line|`--s3-secret-key=val`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(Empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_secret_key](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_secret_key)|

## s3_slave_ignore_updates
|name|value|
|----|-----|
|Name|`s3_slave_ignore_updates`|
|Command line|`--s3-slave-ignore-updates{=0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_slave_ignore_updates](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_slave_ignore_updates)|

## s3_use_http
|name|value|
|----|-----|
|Name|`s3_use_http`|
|Command line|`--s3-use-http{=0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[s3_use_http](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/s3-storage-engine/s3-storage-engine-system-variables/#s3_use_http)|

## Rpl_semi_sync_master_clients
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_clients`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_clients](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_clients)|

## Rpl_semi_sync_master_net_avg_wait_time
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_net_avg_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_net_avg_wait_time](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_net_avg_wait_time)|

## Rpl_semi_sync_master_net_wait_time
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_net_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_net_wait_time](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_net_wait_time)|

## Rpl_semi_sync_master_net_waits
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_net_waits`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_net_waits](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_net_waits)|

## Rpl_semi_sync_master_no_times
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_no_times`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_no_times](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_no_times)|

## Rpl_semi_sync_master_no_tx
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_no_tx`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_no_tx](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_no_tx)|

## Rpl_semi_sync_master_status
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_status`|
|Type of variable|`boolean`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_status](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_status)|

## Rpl_semi_sync_master_timefunc_failures
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_timefunc_failures`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_timefunc_failures](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_timefunc_failures)|

## Rpl_semi_sync_master_tx_avg_wait_time
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_tx_avg_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_tx_avg_wait_time](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_tx_avg_wait_time)|

## Rpl_semi_sync_master_tx_wait_time
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_tx_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_tx_wait_time](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_tx_wait_time)|

## Rpl_semi_sync_master_tx_waits
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_tx_waits`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_tx_waits](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_tx_waits)|

## Rpl_semi_sync_master_wait_pos_backtraverse
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_wait_pos_backtraverse`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_wait_pos_backtraverse](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_wait_pos_backtraverse)|

## Rpl_semi_sync_master_wait_sessions
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_wait_sessions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_wait_sessions](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_wait_sessions)|

## Rpl_semi_sync_master_yes_tx
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_master_yes_tx`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_yes_tx](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_master_yes_tx)|

## Rpl_semi_sync_slave_status
|name|value|
|----|-----|
|Name|`Rpl_semi_sync_slave_status`|
|Type of variable|`boolean`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave_status](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication-plugin-status-variables/#rpl_semi_sync_slave_status)|

## rpl_semi_sync_master_enabled
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master_enabled`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_enabled](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master_enabled)|
|dev.mysql.com|[sysvar_rpl_semi_sync_master_enabled](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_enabled)|

## rpl_semi_sync_master_timeout
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master_timeout`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10000`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_timeout](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master_timeout)|
|dev.mysql.com|[sysvar_rpl_semi_sync_master_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_timeout)|

## rpl_semi_sync_master_trace_level
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master_trace_level`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_trace_level](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master_trace_level)|
|dev.mysql.com|[sysvar_rpl_semi_sync_master_trace_level](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_trace_level)|

## rpl_semi_sync_master_wait_no_slave
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master_wait_no_slave`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_wait_no_slave](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master_wait_no_slave)|
|dev.mysql.com|[sysvar_rpl_semi_sync_master_wait_no_slave](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_wait_no_slave)|

## rpl_semi_sync_master_wait_point
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master_wait_point`|
|Command line|`--rpl-semi-sync-master-wait-point=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`AFTER_SYNC`|
|Dynamic|`true`|
|Valid value(s)|`AFTER_SYNC`, `AFTER_COMMIT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master_wait_point](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master_wait_point)|
|dev.mysql.com|[sysvar_rpl_semi_sync_master_wait_point](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_wait_point)|

## rpl_semi_sync_slave_delay_master
|name|value|
|----|-----|
|Name|`rpl_semi_sync_slave_delay_master`|
|Command line|`--rpl-semi-sync-slave-delay-master[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave_delay_master](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_slave_delay_master)|

## rpl_semi_sync_slave_enabled
|name|value|
|----|-----|
|Name|`rpl_semi_sync_slave_enabled`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave_enabled](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_slave_enabled)|
|dev.mysql.com|[sysvar_rpl_semi_sync_slave_enabled](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_rpl_semi_sync_slave_enabled)|

## rpl_semi_sync_slave_kill_conn_timeout
|name|value|
|----|-----|
|Name|`rpl_semi_sync_slave_kill_conn_timeout`|
|Command line|`--rpl-semi-sync-slave-kill-conn-timeout[={0|1}]`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave_kill_conn_timeout](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_slave_kill_conn_timeout)|

## rpl_semi_sync_slave_trace_level
|name|value|
|----|-----|
|Name|`rpl_semi_sync_slave_trace_level`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave_trace_level](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_slave_trace_level)|
|dev.mysql.com|[sysvar_rpl_semi_sync_slave_trace_level](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_rpl_semi_sync_slave_trace_level)|

## rpl_semi_sync_master
|name|value|
|----|-----|
|Name|`rpl_semi_sync_master`|
|Command line|`--rpl-semi-sync-master=value`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`OFF`, `ON`, `FORCE`, `FORCE_PLUS_PERMANENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_master](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_master)|

## rpl_semi_sync_slave
|name|value|
|----|-----|
|Name|`rpl_semi_sync_slave`|
|Command line|`--rpl-semi-sync-slave=value`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`OFF`, `ON`, `FORCE`, `FORCE_PLUS_PERMANENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_semi_sync_slave](https://mariadb.com/kb/en/library/documentation/semisynchronous-replication/#rpl_semi_sync_slave)|

## Aborted_clients
|name|value|
|----|-----|
|Name|`Aborted_clients`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aborted_clients](https://mariadb.com/kb/en/library/documentation/server-status-variables/#aborted_clients)|

## Aborted_connects
|name|value|
|----|-----|
|Name|`Aborted_connects`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aborted_connects](https://mariadb.com/kb/en/library/documentation/server-status-variables/#aborted_connects)|

## Aborted_connects_preauth
|name|value|
|----|-----|
|Name|`Aborted_connects_preauth`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[aborted_connects_preauth](https://mariadb.com/kb/en/library/documentation/server-status-variables/#aborted_connects_preauth)|

## Access_denied_errors
|name|value|
|----|-----|
|Name|`Access_denied_errors`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[access_denied_errors](https://mariadb.com/kb/en/library/documentation/server-status-variables/#access_denied_errors)|

## Acl_column_grants
|name|value|
|----|-----|
|Name|`Acl_column_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_column_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_column_grants)|

## Acl_database_grants
|name|value|
|----|-----|
|Name|`Acl_database_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_database_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_database_grants)|

## Acl_function_grants
|name|value|
|----|-----|
|Name|`Acl_function_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_function_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_function_grants)|

## Acl_package_body_grants
|name|value|
|----|-----|
|Name|`Acl_package_body_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_package_body_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_package_body_grants)|

## Acl_package_spec_grants
|name|value|
|----|-----|
|Name|`Acl_package_spec_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_package_spec_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_package_spec_grants)|

## Acl_procedure_grants
|name|value|
|----|-----|
|Name|`Acl_procedure_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_procedure_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_procedure_grants)|

## Acl_proxy_users
|name|value|
|----|-----|
|Name|`Acl_proxy_users`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_proxy_users](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_proxy_users)|

## Acl_role_grants
|name|value|
|----|-----|
|Name|`Acl_role_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_role_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_role_grants)|

## Acl_roles
|name|value|
|----|-----|
|Name|`Acl_roles`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_roles](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_roles)|

## Acl_table_grants
|name|value|
|----|-----|
|Name|`Acl_table_grants`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_table_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_table_grants)|

## Acl_users
|name|value|
|----|-----|
|Name|`Acl_users`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[acl_users](https://mariadb.com/kb/en/library/documentation/server-status-variables/#acl_users)|

## Busy_time
|name|value|
|----|-----|
|Name|`Busy_time`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[busy_time](https://mariadb.com/kb/en/library/documentation/server-status-variables/#busy_time)|

## Bytes_received
|name|value|
|----|-----|
|Name|`Bytes_received`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[bytes_received](https://mariadb.com/kb/en/library/documentation/server-status-variables/#bytes_received)|

## Bytes_sent
|name|value|
|----|-----|
|Name|`Bytes_sent`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[bytes_sent](https://mariadb.com/kb/en/library/documentation/server-status-variables/#bytes_sent)|

## Com_admin_commands
|name|value|
|----|-----|
|Name|`Com_admin_commands`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_admin_commands](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_admin_commands)|

## Com_alter_db
|name|value|
|----|-----|
|Name|`Com_alter_db`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_db](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_db)|

## Com_alter_db_upgrade
|name|value|
|----|-----|
|Name|`Com_alter_db_upgrade`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_db_upgrade](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_db_upgrade)|

## Com_alter_event
|name|value|
|----|-----|
|Name|`Com_alter_event`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_event](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_event)|

## Com_alter_function
|name|value|
|----|-----|
|Name|`Com_alter_function`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_function](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_function)|

## Com_alter_procedure
|name|value|
|----|-----|
|Name|`Com_alter_procedure`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_procedure](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_procedure)|

## Com_alter_sequence
|name|value|
|----|-----|
|Name|`Com_alter_sequence`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_sequence](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_sequence)|

## Com_alter_server
|name|value|
|----|-----|
|Name|`Com_alter_server`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_server](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_server)|

## Com_alter_table
|name|value|
|----|-----|
|Name|`Com_alter_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_table)|

## Com_alter_tablespace
|name|value|
|----|-----|
|Name|`Com_alter_tablespace`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_tablespace](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_tablespace)|

## Com_alter_user
|name|value|
|----|-----|
|Name|`Com_alter_user`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_alter_user](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_alter_user)|

## Com_analyze
|name|value|
|----|-----|
|Name|`Com_analyze`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_analyze](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_analyze)|

## Com_assign_to_keycache
|name|value|
|----|-----|
|Name|`Com_assign_to_keycache`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_assign_to_keycache](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_assign_to_keycache)|

## Com_backup
|name|value|
|----|-----|
|Name|`Com_backup`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_backup](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_backup)|

## Com_backup_lock
|name|value|
|----|-----|
|Name|`Com_backup_lock`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_backup_lock](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_backup_lock)|

## Com_backup_table
|name|value|
|----|-----|
|Name|`Com_backup_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_backup_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_backup_table)|

## Com_begin
|name|value|
|----|-----|
|Name|`Com_begin`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_begin](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_begin)|

## Com_binlog
|name|value|
|----|-----|
|Name|`Com_binlog`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_binlog](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_binlog)|

## Com_call_procedure
|name|value|
|----|-----|
|Name|`Com_call_procedure`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_call_procedure](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_call_procedure)|

## Com_change_db
|name|value|
|----|-----|
|Name|`Com_change_db`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_change_db](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_change_db)|

## Com_check
|name|value|
|----|-----|
|Name|`Com_check`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_check](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_check)|

## Com_checksum
|name|value|
|----|-----|
|Name|`Com_checksum`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_checksum](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_checksum)|

## Com_commit
|name|value|
|----|-----|
|Name|`Com_commit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_commit](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_commit)|

## Com_compound_sql
|name|value|
|----|-----|
|Name|`Com_compound_sql`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_compound_sql](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_compound_sql)|

## Com_create_db
|name|value|
|----|-----|
|Name|`Com_create_db`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_db](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_db)|

## Com_create_event
|name|value|
|----|-----|
|Name|`Com_create_event`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_event](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_event)|

## Com_create_function
|name|value|
|----|-----|
|Name|`Com_create_function`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_function](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_function)|

## Com_create_index
|name|value|
|----|-----|
|Name|`Com_create_index`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_index](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_index)|

## Com_create_package
|name|value|
|----|-----|
|Name|`Com_create_package`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_package](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_package)|

## Com_create_package_body
|name|value|
|----|-----|
|Name|`Com_create_package_body`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_package_body](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_package_body)|

## Com_create_procedure
|name|value|
|----|-----|
|Name|`Com_create_procedure`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_procedure](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_procedure)|

## Com_create_role
|name|value|
|----|-----|
|Name|`Com_create_role`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_role](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_role)|

## Com_create_sequence
|name|value|
|----|-----|
|Name|`Com_create_sequence`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_sequence](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_sequence)|

## Com_create_server
|name|value|
|----|-----|
|Name|`Com_create_server`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_server](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_server)|

## Com_create_table
|name|value|
|----|-----|
|Name|`Com_create_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_table)|

## Com_create_temporary_table
|name|value|
|----|-----|
|Name|`Com_create_temporary_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_temporary_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_temporary_table)|

## Com_create_trigger
|name|value|
|----|-----|
|Name|`Com_create_trigger`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_trigger](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_trigger)|

## Com_create_udf
|name|value|
|----|-----|
|Name|`Com_create_udf`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_udf](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_udf)|

## Com_create_user
|name|value|
|----|-----|
|Name|`Com_create_user`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_user](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_user)|

## Com_create_view
|name|value|
|----|-----|
|Name|`Com_create_view`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_create_view](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_create_view)|

## Com_dealloc_sql
|name|value|
|----|-----|
|Name|`Com_dealloc_sql`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_dealloc_sql](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_dealloc_sql)|

## Com_delete
|name|value|
|----|-----|
|Name|`Com_delete`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_delete](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_delete)|

## Com_delete_multi
|name|value|
|----|-----|
|Name|`Com_delete_multi`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_delete_multi](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_delete_multi)|

## Com_do
|name|value|
|----|-----|
|Name|`Com_do`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_do](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_do)|

## Com_drop_db
|name|value|
|----|-----|
|Name|`Com_drop_db`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_db](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_db)|

## Com_drop_event
|name|value|
|----|-----|
|Name|`Com_drop_event`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_event](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_event)|

## Com_drop_function
|name|value|
|----|-----|
|Name|`Com_drop_function`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_function](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_function)|

## Com_drop_index
|name|value|
|----|-----|
|Name|`Com_drop_index`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_index](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_index)|

## Com_drop_package
|name|value|
|----|-----|
|Name|`Com_drop_package`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_package](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_package)|

## Com_drop_package_body
|name|value|
|----|-----|
|Name|`Com_drop_package_body`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_package_body](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_package_body)|

## Com_drop_procedure
|name|value|
|----|-----|
|Name|`Com_drop_procedure`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_procedure](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_procedure)|

## Com_drop_role
|name|value|
|----|-----|
|Name|`Com_drop_role`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_role](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_role)|

## Com_drop_sequence
|name|value|
|----|-----|
|Name|`Com_drop_sequence`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_sequence](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_sequence)|

## Com_drop_server
|name|value|
|----|-----|
|Name|`Com_drop_server`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_server](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_server)|

## Com_drop_table
|name|value|
|----|-----|
|Name|`Com_drop_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_table)|

## Com_drop_temporary_table
|name|value|
|----|-----|
|Name|`Com_drop_temporary_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_temporary_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_temporary_table)|

## Com_drop_trigger
|name|value|
|----|-----|
|Name|`Com_drop_trigger`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_trigger](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_trigger)|

## Com_drop_user
|name|value|
|----|-----|
|Name|`Com_drop_user`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_user](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_user)|

## Com_drop_view
|name|value|
|----|-----|
|Name|`Com_drop_view`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_drop_view](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_drop_view)|

## Com_empty_query
|name|value|
|----|-----|
|Name|`Com_empty_query`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_empty_query](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_empty_query)|

## Com_execute_immediate
|name|value|
|----|-----|
|Name|`Com_execute_immediate`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_execute_immediate](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_execute_immediate)|

## Com_execute_sql
|name|value|
|----|-----|
|Name|`Com_execute_sql`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_execute_sql](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_execute_sql)|

## Com_flush
|name|value|
|----|-----|
|Name|`Com_flush`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_flush](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_flush)|

## Com_get_diagnostics
|name|value|
|----|-----|
|Name|`Com_get_diagnostics`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_get_diagnostics](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_get_diagnostics)|

## Com_grant
|name|value|
|----|-----|
|Name|`Com_grant`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_grant](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_grant)|

## Com_grant_role
|name|value|
|----|-----|
|Name|`Com_grant_role`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_grant_role](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_grant_role)|

## Com_ha_close
|name|value|
|----|-----|
|Name|`Com_ha_close`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_ha_close](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_ha_close)|

## Com_ha_open
|name|value|
|----|-----|
|Name|`Com_ha_open`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_ha_open](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_ha_open)|

## Com_ha_read
|name|value|
|----|-----|
|Name|`Com_ha_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_ha_read](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_ha_read)|

## Com_help
|name|value|
|----|-----|
|Name|`Com_help`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_help](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_help)|

## Com_insert
|name|value|
|----|-----|
|Name|`Com_insert`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_insert](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_insert)|

## Com_insert_select
|name|value|
|----|-----|
|Name|`Com_insert_select`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_insert_select](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_insert_select)|

## Com_install_plugin
|name|value|
|----|-----|
|Name|`Com_install_plugin`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_install_plugin](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_install_plugin)|

## Com_kill
|name|value|
|----|-----|
|Name|`Com_kill`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_kill](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_kill)|

## Com_load
|name|value|
|----|-----|
|Name|`Com_load`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_load](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_load)|

## Com_load_master_data
|name|value|
|----|-----|
|Name|`Com_load_master_data`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_load_master_data](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_load_master_data)|

## Com_load_master_table
|name|value|
|----|-----|
|Name|`Com_load_master_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_load_master_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_load_master_table)|

## Com_multi
|name|value|
|----|-----|
|Name|`Com_multi`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_multi](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_multi)|

## Com_lock_tables
|name|value|
|----|-----|
|Name|`Com_lock_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_lock_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_lock_tables)|

## Com_optimize
|name|value|
|----|-----|
|Name|`Com_optimize`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_optimize](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_optimize)|

## Com_preload_keys
|name|value|
|----|-----|
|Name|`Com_preload_keys`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_preload_keys](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_preload_keys)|

## Com_prepare_sql
|name|value|
|----|-----|
|Name|`Com_prepare_sql`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_prepare_sql](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_prepare_sql)|

## Com_purge
|name|value|
|----|-----|
|Name|`Com_purge`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_purge](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_purge)|

## Com_purge_before_date
|name|value|
|----|-----|
|Name|`Com_purge_before_date`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_purge_before_date](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_purge_before_date)|

## Com_release_savepoint
|name|value|
|----|-----|
|Name|`Com_release_savepoint`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_release_savepoint](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_release_savepoint)|

## Com_rename_table
|name|value|
|----|-----|
|Name|`Com_rename_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_rename_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_rename_table)|

## Com_rename_user
|name|value|
|----|-----|
|Name|`Com_rename_user`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_rename_user](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_rename_user)|

## Com_repair
|name|value|
|----|-----|
|Name|`Com_repair`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_repair](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_repair)|

## Com_replace
|name|value|
|----|-----|
|Name|`Com_replace`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_replace](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_replace)|

## Com_replace_select
|name|value|
|----|-----|
|Name|`Com_replace_select`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_replace_select](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_replace_select)|

## Com_reset
|name|value|
|----|-----|
|Name|`Com_reset`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_reset](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_reset)|

## Com_resignal
|name|value|
|----|-----|
|Name|`Com_resignal`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_resignal](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_resignal)|

## Com_restore_table
|name|value|
|----|-----|
|Name|`Com_restore_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_restore_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_restore_table)|

## Com_revoke
|name|value|
|----|-----|
|Name|`Com_revoke`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_revoke](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_revoke)|

## Com_revoke_all
|name|value|
|----|-----|
|Name|`Com_revoke_all`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_revoke_all](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_revoke_all)|

## Com_revoke_grant
|name|value|
|----|-----|
|Name|`Com_revoke_grant`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_revoke_grant](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_revoke_grant)|

## Com_rollback
|name|value|
|----|-----|
|Name|`Com_rollback`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_rollback](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_rollback)|

## Com_rollback_to_savepoint
|name|value|
|----|-----|
|Name|`Com_rollback_to_savepoint`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_rollback_to_savepoint](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_rollback_to_savepoint)|

## Com_savepoint
|name|value|
|----|-----|
|Name|`Com_savepoint`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_savepoint](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_savepoint)|

## Com_select
|name|value|
|----|-----|
|Name|`Com_select`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_select](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_select)|

## Com_set_option
|name|value|
|----|-----|
|Name|`Com_set_option`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_set_option](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_set_option)|

## Com_signal
|name|value|
|----|-----|
|Name|`Com_signal`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_signal](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_signal)|

## Com_show_authors
|name|value|
|----|-----|
|Name|`Com_show_authors`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_authors](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_authors)|

## Com_show_binlog_events
|name|value|
|----|-----|
|Name|`Com_show_binlog_events`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_binlog_events](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_binlog_events)|

## Com_show_binlogs
|name|value|
|----|-----|
|Name|`Com_show_binlogs`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_binlogs](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_binlogs)|

## Com_show_charsets
|name|value|
|----|-----|
|Name|`Com_show_charsets`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_charsets](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_charsets)|

## Com_show_client_statistics
|name|value|
|----|-----|
|Name|`Com_show_client_statistics`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_client_statistics](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_client_statistics)|

## Com_show_collations
|name|value|
|----|-----|
|Name|`Com_show_collations`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_collations](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_collations)|

## Com_show_column_types
|name|value|
|----|-----|
|Name|`Com_show_column_types`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_column_types](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_column_types)|

## Com_show_contributors
|name|value|
|----|-----|
|Name|`Com_show_contributors`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_contributors](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_contributors)|

## Com_show_create_db
|name|value|
|----|-----|
|Name|`Com_show_create_db`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_db](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_db)|

## Com_show_create_event
|name|value|
|----|-----|
|Name|`Com_show_create_event`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_event](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_event)|

## Com_show_create_func
|name|value|
|----|-----|
|Name|`Com_show_create_func`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_func](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_func)|

## Com_show_create_package
|name|value|
|----|-----|
|Name|`Com_show_create_package`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_package](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_package)|

## Com_show_create_package_body
|name|value|
|----|-----|
|Name|`Com_show_create_package_body`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_package_body](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_package_body)|

## Com_show_create_proc
|name|value|
|----|-----|
|Name|`Com_show_create_proc`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_proc](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_proc)|

## Com_show_create_table
|name|value|
|----|-----|
|Name|`Com_show_create_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_table](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_table)|

## Com_show_create_trigger
|name|value|
|----|-----|
|Name|`Com_show_create_trigger`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_trigger](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_trigger)|

## Com_show_create_user
|name|value|
|----|-----|
|Name|`Com_show_create_user`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_create_user](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_create_user)|

## Com_show_databases
|name|value|
|----|-----|
|Name|`Com_show_databases`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_databases](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_databases)|

## Com_show_engine_logs
|name|value|
|----|-----|
|Name|`Com_show_engine_logs`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_engine_logs](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_engine_logs)|

## Com_show_engine_mutex
|name|value|
|----|-----|
|Name|`Com_show_engine_mutex`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_engine_mutex](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_engine_mutex)|

## Com_show_engine_status
|name|value|
|----|-----|
|Name|`Com_show_engine_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_engine_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_engine_status)|

## Com_show_events
|name|value|
|----|-----|
|Name|`Com_show_events`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_events](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_events)|

## Com_show_errors
|name|value|
|----|-----|
|Name|`Com_show_errors`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_errors](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_errors)|

## Com_show_explain
|name|value|
|----|-----|
|Name|`Com_show_explain`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_explain](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_explain)|

## Com_show_fields
|name|value|
|----|-----|
|Name|`Com_show_fields`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_fields](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_fields)|

## Com_show_function_status
|name|value|
|----|-----|
|Name|`Com_show_function_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_function_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_function_status)|

## Com_show_generic
|name|value|
|----|-----|
|Name|`Com_show_generic`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_generic](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_generic)|

## Com_show_grants
|name|value|
|----|-----|
|Name|`Com_show_grants`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_grants](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_grants)|

## Com_show_keys
|name|value|
|----|-----|
|Name|`Com_show_keys`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_keys](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_keys)|

## Com_show_index_statistics
|name|value|
|----|-----|
|Name|`Com_show_index_statistics`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_index_statistics](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_index_statistics)|

## Com_show_open_tables
|name|value|
|----|-----|
|Name|`Com_show_open_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_open_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_open_tables)|

## Com_show_package_status
|name|value|
|----|-----|
|Name|`Com_show_package_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_package_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_package_status)|

## Com_show_package_body_status
|name|value|
|----|-----|
|Name|`Com_show_package_body_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_package_body_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_package_body_status)|

## Com_show_plugins
|name|value|
|----|-----|
|Name|`Com_show_plugins`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_plugins](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_plugins)|

## Com_show_privileges
|name|value|
|----|-----|
|Name|`Com_show_privileges`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_privileges](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_privileges)|

## Com_show_procedure_status
|name|value|
|----|-----|
|Name|`Com_show_procedure_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_procedure_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_procedure_status)|

## Com_show_processlist
|name|value|
|----|-----|
|Name|`Com_show_processlist`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_processlist](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_processlist)|

## Com_show_profile
|name|value|
|----|-----|
|Name|`Com_show_profile`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_profile](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_profile)|

## Com_show_profiles
|name|value|
|----|-----|
|Name|`Com_show_profiles`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_profiles](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_profiles)|

## Com_show_relaylog_events
|name|value|
|----|-----|
|Name|`Com_show_relaylog_events`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_relaylog_events](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_relaylog_events)|

## Com_show_status
|name|value|
|----|-----|
|Name|`Com_show_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_status)|

## Com_show_storage_engines
|name|value|
|----|-----|
|Name|`Com_show_storage_engines`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_storage_engines](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_storage_engines)|

## Com_show_table_statistics
|name|value|
|----|-----|
|Name|`Com_show_table_statistics`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_table_statistics](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_table_statistics)|

## Com_show_table_status
|name|value|
|----|-----|
|Name|`Com_show_table_status`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_table_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_table_status)|

## Com_show_tables
|name|value|
|----|-----|
|Name|`Com_show_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_tables)|

## Com_show_triggers
|name|value|
|----|-----|
|Name|`Com_show_triggers`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_triggers](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_triggers)|

## Com_show_user_statistics
|name|value|
|----|-----|
|Name|`Com_show_user_statistics`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_user_statistics](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_user_statistics)|

## Com_show_variable
|name|value|
|----|-----|
|Name|`Com_show_variable`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_variable](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_variable)|

## Com_show_warnings
|name|value|
|----|-----|
|Name|`Com_show_warnings`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_show_warnings](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_show_warnings)|

## Com_shutdown
|name|value|
|----|-----|
|Name|`Com_shutdown`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_shutdown](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_shutdown)|

## Com_stmt_close
|name|value|
|----|-----|
|Name|`Com_stmt_close`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_close](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_close)|

## Com_stmt_execute
|name|value|
|----|-----|
|Name|`Com_stmt_execute`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_execute](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_execute)|

## Com_stmt_fetch
|name|value|
|----|-----|
|Name|`Com_stmt_fetch`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_fetch](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_fetch)|

## Com_stmt_prepare
|name|value|
|----|-----|
|Name|`Com_stmt_prepare`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_prepare](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_prepare)|

## Com_stmt_reprepare
|name|value|
|----|-----|
|Name|`Com_stmt_reprepare`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_reprepare](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_reprepare)|

## Com_stmt_reset
|name|value|
|----|-----|
|Name|`Com_stmt_reset`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_reset](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_reset)|

## Com_stmt_send_long_data
|name|value|
|----|-----|
|Name|`Com_stmt_send_long_data`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_stmt_send_long_data](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_stmt_send_long_data)|

## Com_truncate
|name|value|
|----|-----|
|Name|`Com_truncate`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_truncate](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_truncate)|

## Com_uninstall_plugin
|name|value|
|----|-----|
|Name|`Com_uninstall_plugin`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_uninstall_plugin](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_uninstall_plugin)|

## Com_unlock_tables
|name|value|
|----|-----|
|Name|`Com_unlock_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_unlock_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_unlock_tables)|

## Com_update
|name|value|
|----|-----|
|Name|`Com_update`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_update](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_update)|

## Com_update_multi
|name|value|
|----|-----|
|Name|`Com_update_multi`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_update_multi](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_update_multi)|

## Com_xa_commit
|name|value|
|----|-----|
|Name|`Com_xa_commit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_commit](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_commit)|

## Com_xa_end
|name|value|
|----|-----|
|Name|`Com_xa_end`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_end](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_end)|

## Com_xa_prepare
|name|value|
|----|-----|
|Name|`Com_xa_prepare`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_prepare](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_prepare)|

## Com_xa_recover
|name|value|
|----|-----|
|Name|`Com_xa_recover`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_recover](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_recover)|

## Com_xa_rollback
|name|value|
|----|-----|
|Name|`Com_xa_rollback`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_rollback](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_rollback)|

## Com_xa_start
|name|value|
|----|-----|
|Name|`Com_xa_start`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[com_xa_start](https://mariadb.com/kb/en/library/documentation/server-status-variables/#com_xa_start)|

## Compression
|name|value|
|----|-----|
|Name|`Compression`|
|Type of variable|`boolean`|
|Scope|`session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[compression](https://mariadb.com/kb/en/library/documentation/server-status-variables/#compression)|

## Connection_errors_accept
|name|value|
|----|-----|
|Name|`Connection_errors_accept`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_accept](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_accept)|

## Connection_errors_internal
|name|value|
|----|-----|
|Name|`Connection_errors_internal`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_internal](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_internal)|

## Connection_errors_max_connections
|name|value|
|----|-----|
|Name|`Connection_errors_max_connections`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_max_connections](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_max_connections)|

## Connection_errors_peer_address
|name|value|
|----|-----|
|Name|`Connection_errors_peer_address`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_peer_address](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_peer_address)|

## Connection_errors_select
|name|value|
|----|-----|
|Name|`Connection_errors_select`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_select](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_select)|

## Connection_errors_tcpwrap
|name|value|
|----|-----|
|Name|`Connection_errors_tcpwrap`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connection_errors_tcpwrap](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connection_errors_tcpwrap)|

## Connections
|name|value|
|----|-----|
|Name|`Connections`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connections](https://mariadb.com/kb/en/library/documentation/server-status-variables/#connections)|

## Cpu_time
|name|value|
|----|-----|
|Name|`Cpu_time`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[cpu_time](https://mariadb.com/kb/en/library/documentation/server-status-variables/#cpu_time)|

## Created_tmp_disk_tables
|name|value|
|----|-----|
|Name|`Created_tmp_disk_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[created_tmp_disk_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#created_tmp_disk_tables)|

## Created_tmp_files
|name|value|
|----|-----|
|Name|`Created_tmp_files`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[created_tmp_files](https://mariadb.com/kb/en/library/documentation/server-status-variables/#created_tmp_files)|

## Created_tmp_tables
|name|value|
|----|-----|
|Name|`Created_tmp_tables`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[created_tmp_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#created_tmp_tables)|

## Delayed_errors
|name|value|
|----|-----|
|Name|`Delayed_errors`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_errors](https://mariadb.com/kb/en/library/documentation/server-status-variables/#delayed_errors)|

## Delayed_insert_threads
|name|value|
|----|-----|
|Name|`Delayed_insert_threads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_insert_threads](https://mariadb.com/kb/en/library/documentation/server-status-variables/#delayed_insert_threads)|

## Delayed_writes
|name|value|
|----|-----|
|Name|`Delayed_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_writes](https://mariadb.com/kb/en/library/documentation/server-status-variables/#delayed_writes)|

## Delete_scan
|name|value|
|----|-----|
|Name|`Delete_scan`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delete_scan](https://mariadb.com/kb/en/library/documentation/server-status-variables/#delete_scan)|

## Empty_queries
|name|value|
|----|-----|
|Name|`Empty_queries`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[empty_queries](https://mariadb.com/kb/en/library/documentation/server-status-variables/#empty_queries)|

## Executed_events
|name|value|
|----|-----|
|Name|`Executed_events`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[executed_events](https://mariadb.com/kb/en/library/documentation/server-status-variables/#executed_events)|

## Executed_triggers
|name|value|
|----|-----|
|Name|`Executed_triggers`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[executed_triggers](https://mariadb.com/kb/en/library/documentation/server-status-variables/#executed_triggers)|

## Feature_application_time_periods
|name|value|
|----|-----|
|Name|`Feature_application_time_periods`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_application_time_periods](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_application_time_periods)|

## Feature_check_constraint
|name|value|
|----|-----|
|Name|`Feature_check_constraint`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_check_constraint](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_check_constraint)|

## Feature_custom_aggregate_functions
|name|value|
|----|-----|
|Name|`Feature_custom_aggregate_functions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_custom_aggregate_functions](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_custom_aggregate_functions)|

## Feature_delay_key_write
|name|value|
|----|-----|
|Name|`Feature_delay_key_write`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_delay_key_write](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_delay_key_write)|

## Feature_dynamic_columns
|name|value|
|----|-----|
|Name|`Feature_dynamic_columns`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_dynamic_columns](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_dynamic_columns)|

## Feature_fulltext
|name|value|
|----|-----|
|Name|`Feature_fulltext`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_fulltext](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_fulltext)|

## Feature_gis
|name|value|
|----|-----|
|Name|`Feature_gis`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_gis](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_gis)|

## Feature_insert_returning
|name|value|
|----|-----|
|Name|`Feature_insert_returning`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_insert_returning](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_insert_returning)|

## Feature_invisible_columns
|name|value|
|----|-----|
|Name|`Feature_invisible_columns`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_invisible_columns](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_invisible_columns)|

## Feature_json
|name|value|
|----|-----|
|Name|`Feature_json`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_json](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_json)|

## Feature_locale
|name|value|
|----|-----|
|Name|`Feature_locale`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_locale](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_locale)|

## Feature_subquery
|name|value|
|----|-----|
|Name|`Feature_subquery`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_subquery](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_subquery)|

## Feature_system_versioning
|name|value|
|----|-----|
|Name|`Feature_system_versioning`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_system_versioning](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_system_versioning)|

## Feature_timezone
|name|value|
|----|-----|
|Name|`Feature_timezone`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_timezone](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_timezone)|

## Feature_trigger
|name|value|
|----|-----|
|Name|`Feature_trigger`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_trigger](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_trigger)|

## Feature_window_functions
|name|value|
|----|-----|
|Name|`Feature_window_functions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_window_functions](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_window_functions)|

## Feature_xml
|name|value|
|----|-----|
|Name|`Feature_xml`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[feature_xml](https://mariadb.com/kb/en/library/documentation/server-status-variables/#feature_xml)|

## Flush_commands
|name|value|
|----|-----|
|Name|`Flush_commands`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[flush_commands](https://mariadb.com/kb/en/library/documentation/server-status-variables/#flush_commands)|

## Handler_commit
|name|value|
|----|-----|
|Name|`Handler_commit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_commit](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_commit)|

## Handler_delete
|name|value|
|----|-----|
|Name|`Handler_delete`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_delete](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_delete)|

## Handler_discover
|name|value|
|----|-----|
|Name|`Handler_discover`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_discover](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_discover)|

## Handler_external_lock
|name|value|
|----|-----|
|Name|`Handler_external_lock`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_external_lock](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_external_lock)|

## Handler_icp_attempts
|name|value|
|----|-----|
|Name|`Handler_icp_attempts`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_icp_attempts](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_icp_attempts)|

## Handler_icp_match
|name|value|
|----|-----|
|Name|`Handler_icp_match`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_icp_match](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_icp_match)|

## Handler_mrr_init
|name|value|
|----|-----|
|Name|`Handler_mrr_init`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_mrr_init](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_mrr_init)|

## Handler_mrr_key_refills
|name|value|
|----|-----|
|Name|`Handler_mrr_key_refills`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_mrr_key_refills](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_mrr_key_refills)|

## Handler_mrr_rowid_refills
|name|value|
|----|-----|
|Name|`Handler_mrr_rowid_refills`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_mrr_rowid_refills](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_mrr_rowid_refills)|

## Handler_prepare
|name|value|
|----|-----|
|Name|`Handler_prepare`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_prepare](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_prepare)|

## Handler_read_first
|name|value|
|----|-----|
|Name|`Handler_read_first`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_first](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_first)|

## Handler_read_key
|name|value|
|----|-----|
|Name|`Handler_read_key`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_key](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_key)|

## Handler_read_last
|name|value|
|----|-----|
|Name|`Handler_read_last`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_last](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_last)|

## Handler_read_next
|name|value|
|----|-----|
|Name|`Handler_read_next`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_next](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_next)|

## Handler_read_prev
|name|value|
|----|-----|
|Name|`Handler_read_prev`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_prev](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_prev)|

## Handler_read_retry
|name|value|
|----|-----|
|Name|`Handler_read_retry`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_retry](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_retry)|

## Handler_read_rnd
|name|value|
|----|-----|
|Name|`Handler_read_rnd`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_rnd](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_rnd)|

## Handler_read_rnd_deleted
|name|value|
|----|-----|
|Name|`Handler_read_rnd_deleted`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_rnd_deleted](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_rnd_deleted)|

## Handler_read_rnd_next
|name|value|
|----|-----|
|Name|`Handler_read_rnd_next`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_read_rnd_next](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_read_rnd_next)|

## Handler_rollback
|name|value|
|----|-----|
|Name|`Handler_rollback`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_rollback](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_rollback)|

## Handler_savepoint
|name|value|
|----|-----|
|Name|`Handler_savepoint`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_savepoint](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_savepoint)|

## Handler_savepoint_rollback
|name|value|
|----|-----|
|Name|`Handler_savepoint_rollback`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_savepoint_rollback](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_savepoint_rollback)|

## Handler_tmp_delete
|name|value|
|----|-----|
|Name|`Handler_tmp_delete`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_tmp_delete](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_tmp_delete)|

## Handler_tmp_update
|name|value|
|----|-----|
|Name|`Handler_tmp_update`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_tmp_update](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_tmp_update)|

## Handler_tmp_write
|name|value|
|----|-----|
|Name|`Handler_tmp_write`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_tmp_write](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_tmp_write)|

## Handler_update
|name|value|
|----|-----|
|Name|`Handler_update`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_update](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_update)|

## Handler_write
|name|value|
|----|-----|
|Name|`Handler_write`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[handler_write](https://mariadb.com/kb/en/library/documentation/server-status-variables/#handler_write)|

## Key_blocks_not_flushed
|name|value|
|----|-----|
|Name|`Key_blocks_not_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_blocks_not_flushed](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_blocks_not_flushed)|

## Key_blocks_unused
|name|value|
|----|-----|
|Name|`Key_blocks_unused`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_blocks_unused](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_blocks_unused)|

## Key_blocks_used
|name|value|
|----|-----|
|Name|`Key_blocks_used`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_blocks_used](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_blocks_used)|

## Key_blocks_warm
|name|value|
|----|-----|
|Name|`Key_blocks_warm`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_blocks_warm](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_blocks_warm)|

## Key_read_requests
|name|value|
|----|-----|
|Name|`Key_read_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_read_requests](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_read_requests)|

## Key_reads
|name|value|
|----|-----|
|Name|`Key_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_reads](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_reads)|

## Key_write_requests
|name|value|
|----|-----|
|Name|`Key_write_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_write_requests](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_write_requests)|

## Key_writes
|name|value|
|----|-----|
|Name|`Key_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[key_writes](https://mariadb.com/kb/en/library/documentation/server-status-variables/#key_writes)|

## Last_query_cost
|name|value|
|----|-----|
|Name|`Last_query_cost`|
|Type of variable|`integer`|
|Scope|`session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[last_query_cost](https://mariadb.com/kb/en/library/documentation/server-status-variables/#last_query_cost)|

## Maria_*
|name|value|
|----|-----|
|Name|`Maria_*`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[maria_](https://mariadb.com/kb/en/library/documentation/server-status-variables/#maria_)|

## Max_statement_time_exceeded
|name|value|
|----|-----|
|Name|`Max_statement_time_exceeded`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_statement_time_exceeded](https://mariadb.com/kb/en/library/documentation/server-status-variables/#max_statement_time_exceeded)|

## Max_used_connections
|name|value|
|----|-----|
|Name|`Max_used_connections`|
|Type of variable|`integer`|
|Scope|`session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_used_connections](https://mariadb.com/kb/en/library/documentation/server-status-variables/#max_used_connections)|

## Memory_used
|name|value|
|----|-----|
|Name|`Memory_used`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[memory_used](https://mariadb.com/kb/en/library/documentation/server-status-variables/#memory_used)|

## Memory_used_initial
|name|value|
|----|-----|
|Name|`Memory_used_initial`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[memory_used_initial](https://mariadb.com/kb/en/library/documentation/server-status-variables/#memory_used_initial)|

## Not_flushed_delayed_rows
|name|value|
|----|-----|
|Name|`Not_flushed_delayed_rows`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[not_flushed_delayed_rows](https://mariadb.com/kb/en/library/documentation/server-status-variables/#not_flushed_delayed_rows)|

## Open_files
|name|value|
|----|-----|
|Name|`Open_files`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[open_files](https://mariadb.com/kb/en/library/documentation/server-status-variables/#open_files)|

## Open_streams
|name|value|
|----|-----|
|Name|`Open_streams`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[open_streams](https://mariadb.com/kb/en/library/documentation/server-status-variables/#open_streams)|

## Open_table_definitions
|name|value|
|----|-----|
|Name|`Open_table_definitions`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[open_table_definitions](https://mariadb.com/kb/en/library/documentation/server-status-variables/#open_table_definitions)|

## Open_tables
|name|value|
|----|-----|
|Name|`Open_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[open_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#open_tables)|

## Opened_files
|name|value|
|----|-----|
|Name|`Opened_files`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[opened_files](https://mariadb.com/kb/en/library/documentation/server-status-variables/#opened_files)|

## Opened_plugin_libraries
|name|value|
|----|-----|
|Name|`Opened_plugin_libraries`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[opened_plugin_libraries](https://mariadb.com/kb/en/library/documentation/server-status-variables/#opened_plugin_libraries)|

## Opened_table_definitions
|name|value|
|----|-----|
|Name|`Opened_table_definitions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[opened_table_definitions](https://mariadb.com/kb/en/library/documentation/server-status-variables/#opened_table_definitions)|

## Opened_tables
|name|value|
|----|-----|
|Name|`Opened_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[opened_tables](https://mariadb.com/kb/en/library/documentation/server-status-variables/#opened_tables)|

## Opened_views
|name|value|
|----|-----|
|Name|`Opened_views`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[opened_views](https://mariadb.com/kb/en/library/documentation/server-status-variables/#opened_views)|

## Prepared_stmt_count
|name|value|
|----|-----|
|Name|`Prepared_stmt_count`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[prepared_stmt_count](https://mariadb.com/kb/en/library/documentation/server-status-variables/#prepared_stmt_count)|

## Qcache_free_blocks
|name|value|
|----|-----|
|Name|`Qcache_free_blocks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_free_blocks](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_free_blocks)|

## Qcache_free_memory
|name|value|
|----|-----|
|Name|`Qcache_free_memory`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_free_memory](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_free_memory)|

## Qcache_hits
|name|value|
|----|-----|
|Name|`Qcache_hits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_hits](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_hits)|

## Qcache_inserts
|name|value|
|----|-----|
|Name|`Qcache_inserts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_inserts](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_inserts)|

## Qcache_lowmem_prunes
|name|value|
|----|-----|
|Name|`Qcache_lowmem_prunes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_lowmem_prunes](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_lowmem_prunes)|

## Qcache_not_cached
|name|value|
|----|-----|
|Name|`Qcache_not_cached`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_not_cached](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_not_cached)|

## Qcache_queries_in_cache
|name|value|
|----|-----|
|Name|`Qcache_queries_in_cache`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_queries_in_cache](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_queries_in_cache)|

## Qcache_total_blocks
|name|value|
|----|-----|
|Name|`Qcache_total_blocks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[qcache_total_blocks](https://mariadb.com/kb/en/library/documentation/server-status-variables/#qcache_total_blocks)|

## Queries
|name|value|
|----|-----|
|Name|`Queries`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[queries](https://mariadb.com/kb/en/library/documentation/server-status-variables/#queries)|

## Questions
|name|value|
|----|-----|
|Name|`Questions`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[questions](https://mariadb.com/kb/en/library/documentation/server-status-variables/#questions)|

## Rows_read
|name|value|
|----|-----|
|Name|`Rows_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rows_read](https://mariadb.com/kb/en/library/documentation/server-status-variables/#rows_read)|

## Rows_sent
|name|value|
|----|-----|
|Name|`Rows_sent`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rows_sent](https://mariadb.com/kb/en/library/documentation/server-status-variables/#rows_sent)|

## Rows_tmp_read
|name|value|
|----|-----|
|Name|`Rows_tmp_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rows_tmp_read](https://mariadb.com/kb/en/library/documentation/server-status-variables/#rows_tmp_read)|

## Select_full_join
|name|value|
|----|-----|
|Name|`Select_full_join`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[select_full_join](https://mariadb.com/kb/en/library/documentation/server-status-variables/#select_full_join)|

## Select_full_range_join
|name|value|
|----|-----|
|Name|`Select_full_range_join`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[select_full_range_join](https://mariadb.com/kb/en/library/documentation/server-status-variables/#select_full_range_join)|

## Select_range
|name|value|
|----|-----|
|Name|`Select_range`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[select_range](https://mariadb.com/kb/en/library/documentation/server-status-variables/#select_range)|

## Select_range_check
|name|value|
|----|-----|
|Name|`Select_range_check`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[select_range_check](https://mariadb.com/kb/en/library/documentation/server-status-variables/#select_range_check)|

## Select_scan
|name|value|
|----|-----|
|Name|`Select_scan`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[select_scan](https://mariadb.com/kb/en/library/documentation/server-status-variables/#select_scan)|

## Slow_launch_threads
|name|value|
|----|-----|
|Name|`Slow_launch_threads`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slow_launch_threads](https://mariadb.com/kb/en/library/documentation/server-status-variables/#slow_launch_threads)|

## Slow_queries
|name|value|
|----|-----|
|Name|`Slow_queries`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slow_queries](https://mariadb.com/kb/en/library/documentation/server-status-variables/#slow_queries)|

## Sort_merge_passes
|name|value|
|----|-----|
|Name|`Sort_merge_passes`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_merge_passes](https://mariadb.com/kb/en/library/documentation/server-status-variables/#sort_merge_passes)|

## Sort_priority_queue_sorts
|name|value|
|----|-----|
|Name|`Sort_priority_queue_sorts`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_priority_queue_sorts](https://mariadb.com/kb/en/library/documentation/server-status-variables/#sort_priority_queue_sorts)|

## Sort_range
|name|value|
|----|-----|
|Name|`Sort_range`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_range](https://mariadb.com/kb/en/library/documentation/server-status-variables/#sort_range)|

## Sort_rows
|name|value|
|----|-----|
|Name|`Sort_rows`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_rows](https://mariadb.com/kb/en/library/documentation/server-status-variables/#sort_rows)|

## Sort_scan
|name|value|
|----|-----|
|Name|`Sort_scan`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_scan](https://mariadb.com/kb/en/library/documentation/server-status-variables/#sort_scan)|

## Subquery_cache_hit
|name|value|
|----|-----|
|Name|`Subquery_cache_hit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[subquery_cache_hit](https://mariadb.com/kb/en/library/documentation/server-status-variables/#subquery_cache_hit)|

## Subquery_cache_miss
|name|value|
|----|-----|
|Name|`Subquery_cache_miss`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[subquery_cache_miss](https://mariadb.com/kb/en/library/documentation/server-status-variables/#subquery_cache_miss)|

## Syncs
|name|value|
|----|-----|
|Name|`Syncs`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[syncs](https://mariadb.com/kb/en/library/documentation/server-status-variables/#syncs)|

## Table_locks_immediate
|name|value|
|----|-----|
|Name|`Table_locks_immediate`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_locks_immediate](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_locks_immediate)|

## Table_locks_waited
|name|value|
|----|-----|
|Name|`Table_locks_waited`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_locks_waited](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_locks_waited)|

## Table_open_cache_active_instances
|name|value|
|----|-----|
|Name|`Table_open_cache_active_instances`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache_active_instances](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_open_cache_active_instances)|

## Table_open_cache_hits
|name|value|
|----|-----|
|Name|`Table_open_cache_hits`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache_hits](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_open_cache_hits)|

## Table_open_cache_misses
|name|value|
|----|-----|
|Name|`Table_open_cache_misses`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache_misses](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_open_cache_misses)|

## Table_open_cache_overflows
|name|value|
|----|-----|
|Name|`Table_open_cache_overflows`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache_overflows](https://mariadb.com/kb/en/library/documentation/server-status-variables/#table_open_cache_overflows)|

## Tc_log_max_pages_used
|name|value|
|----|-----|
|Name|`Tc_log_max_pages_used`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tc_log_max_pages_used](https://mariadb.com/kb/en/library/documentation/server-status-variables/#tc_log_max_pages_used)|

## Tc_log_page_size
|name|value|
|----|-----|
|Name|`Tc_log_page_size`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tc_log_page_size](https://mariadb.com/kb/en/library/documentation/server-status-variables/#tc_log_page_size)|

## Tc_log_page_waits
|name|value|
|----|-----|
|Name|`Tc_log_page_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tc_log_page_waits](https://mariadb.com/kb/en/library/documentation/server-status-variables/#tc_log_page_waits)|

## Threads_cached
|name|value|
|----|-----|
|Name|`Threads_cached`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threads_cached](https://mariadb.com/kb/en/library/documentation/server-status-variables/#threads_cached)|

## Threads_connected
|name|value|
|----|-----|
|Name|`Threads_connected`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threads_connected](https://mariadb.com/kb/en/library/documentation/server-status-variables/#threads_connected)|

## Threads_created
|name|value|
|----|-----|
|Name|`Threads_created`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threads_created](https://mariadb.com/kb/en/library/documentation/server-status-variables/#threads_created)|

## Threads_running
|name|value|
|----|-----|
|Name|`Threads_running`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threads_running](https://mariadb.com/kb/en/library/documentation/server-status-variables/#threads_running)|

## Update_scan
|name|value|
|----|-----|
|Name|`Update_scan`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[update_scan](https://mariadb.com/kb/en/library/documentation/server-status-variables/#update_scan)|

## Uptime
|name|value|
|----|-----|
|Name|`Uptime`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[uptime](https://mariadb.com/kb/en/library/documentation/server-status-variables/#uptime)|

## Uptime_since_flush_status
|name|value|
|----|-----|
|Name|`Uptime_since_flush_status`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[uptime_since_flush_status](https://mariadb.com/kb/en/library/documentation/server-status-variables/#uptime_since_flush_status)|

## alter_algorithm
|name|value|
|----|-----|
|Name|`alter_algorithm`|
|Command line|`--alter-algorithm=default`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`DEFAULT`|
|Dynamic|`true`|
|Valid value(s)|`DEFAULT`, `COPY`, `INPLACE`, `NOCOPY`, `INSTANT`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[alter_algorithm](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#alter_algorithm)|

## analyze_sample_percentage
|name|value|
|----|-----|
|Name|`analyze_sample_percentage`|
|Command line|`--analyze-sample-percentage=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100.000000`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[analyze_sample_percentage](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#analyze_sample_percentage)|

## autocommit
|name|value|
|----|-----|
|Name|`autocommit`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[autocommit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#autocommit)|
|dev.mysql.com|[sysvar_autocommit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_autocommit)|

## automatic_sp_privileges
|name|value|
|----|-----|
|Name|`automatic_sp_privileges`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[automatic_sp_privileges](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#automatic_sp_privileges)|
|dev.mysql.com|[sysvar_automatic_sp_privileges](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_automatic_sp_privileges)|

## back_log
|name|value|
|----|-----|
|Name|`back_log`|
|Command line|`--back-log=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`(-1 signifies autosizing; do not use -1)`|
|Dynamic|`false`|
|Range|from: `1` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[back_log](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#back_log)|
|dev.mysql.com|[sysvar_back_log](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_back_log)|

## basedir
|name|value|
|----|-----|
|Name|`basedir`|
|Command line|`--basedir=path or -b path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`parent of mysqld installation directory`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[basedir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#basedir)|
|dev.mysql.com|[sysvar_basedir](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#sysvar_basedir)|
|dev.mysql.com|[sysvar_basedir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_basedir)|

## big_tables
|name|value|
|----|-----|
|Name|`big_tables`|
|Command line|`--big-tables[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[big_tables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#big_tables)|
|dev.mysql.com|[sysvar_big_tables](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_big_tables)|

## bind_address
|name|value|
|----|-----|
|Name|`bind_address`|
|Command line|`--bind-address=addr`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`*`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[bind_address](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#bind_address)|
|dev.mysql.com|[sysvar_bind_address](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_bind_address)|

## bulk_insert_buffer_size
|name|value|
|----|-----|
|Name|`bulk_insert_buffer_size`|
|Command line|`--bulk-insert-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`8388608`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[bulk_insert_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#bulk_insert_buffer_size)|
|dev.mysql.com|[sysvar_bulk_insert_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_bulk_insert_buffer_size)|

## character_set_client
|name|value|
|----|-----|
|Name|`character_set_client`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_client](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_client)|
|dev.mysql.com|[sysvar_character_set_client](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_client)|

## character_set_connection
|name|value|
|----|-----|
|Name|`character_set_connection`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_connection](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_connection)|
|dev.mysql.com|[sysvar_character_set_connection](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_connection)|

## character_set_database
|name|value|
|----|-----|
|Name|`character_set_database`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_database](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_database)|
|dev.mysql.com|[sysvar_character_set_database](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_database)|

## character_set_filesystem
|name|value|
|----|-----|
|Name|`character_set_filesystem`|
|Command line|`--character-set-filesystem=name`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`binary`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_filesystem](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_filesystem)|
|dev.mysql.com|[sysvar_character_set_filesystem](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_filesystem)|

## character_set_results
|name|value|
|----|-----|
|Name|`character_set_results`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_results](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_results)|
|dev.mysql.com|[sysvar_character_set_results](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_results)|

## character_set_server
|name|value|
|----|-----|
|Name|`character_set_server`|
|Command line|`--character-set-server=name`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_server](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_server)|
|dev.mysql.com|[sysvar_character_set_server](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_server)|

## character_set_system
|name|value|
|----|-----|
|Name|`character_set_system`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`utf8`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_set_system](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_set_system)|
|dev.mysql.com|[sysvar_character_set_system](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_system)|

## character_sets_dir
|name|value|
|----|-----|
|Name|`character_sets_dir`|
|Command line|`--character-sets-dir=path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[character_sets_dir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#character_sets_dir)|
|dev.mysql.com|[sysvar_character_sets_dir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_sets_dir)|

## check_constraint_checks
|name|value|
|----|-----|
|Name|`check_constraint_checks`|
|Command line|`--check-constraint-checks=[0|1]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[check_constraint_checks](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#check_constraint_checks)|

## collation_connection
|name|value|
|----|-----|
|Name|`collation_connection`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[collation_connection](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#collation_connection)|
|dev.mysql.com|[sysvar_collation_connection](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_connection)|

## collation_database
|name|value|
|----|-----|
|Name|`collation_database`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4_0900_ai_ci`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[collation_database](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#collation_database)|
|dev.mysql.com|[sysvar_collation_database](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_database)|

## collation_server
|name|value|
|----|-----|
|Name|`collation_server`|
|Command line|`--collation-server=name`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`utf8mb4_0900_ai_ci`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[collation_server](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#collation_server)|
|dev.mysql.com|[sysvar_collation_server](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_server)|

## completion_type
|name|value|
|----|-----|
|Name|`completion_type`|
|Command line|`--completion-type=name`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`NO_CHAIN`|
|Dynamic|`true`|
|Valid value(s)|`NO_CHAIN`, `CHAIN`, `RELEASE`, `0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[completion_type](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#completion_type)|
|dev.mysql.com|[sysvar_completion_type](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_completion_type)|

## concurrent_insert
|name|value|
|----|-----|
|Name|`concurrent_insert`|
|Command line|`--concurrent-insert[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`AUTO`|
|Dynamic|`true`|
|Valid value(s)|`NEVER`, `AUTO`, `ALWAYS`, `0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[concurrent_insert](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#concurrent_insert)|
|dev.mysql.com|[sysvar_concurrent_insert](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_concurrent_insert)|

## connect_timeout
|name|value|
|----|-----|
|Name|`connect_timeout`|
|Command line|`--connect-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `2` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[connect_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#connect_timeout)|
|dev.mysql.com|[sysvar_connect_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)|

## core_file
|name|value|
|----|-----|
|Name|`core_file`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[core_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#core_file)|
|dev.mysql.com|[option_mysqld_core-file](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_core-file)|
|dev.mysql.com|[sysvar_core_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_core_file)|

## datadir
|name|value|
|----|-----|
|Name|`datadir`|
|Command line|`--datadir=path or -h path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[datadir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#datadir)|
|dev.mysql.com|[sysvar_datadir](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#sysvar_datadir)|
|dev.mysql.com|[sysvar_datadir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_datadir)|

## date_format
|name|value|
|----|-----|
|Name|`date_format`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[date_format](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#date_format)|

## datetime_format
|name|value|
|----|-----|
|Name|`datetime_format`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[datetime_format](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#datetime_format)|

## debug/debug_dbug
|name|value|
|----|-----|
|Name|`debug/debug_dbug`|
|Command line|`-#, --debug[=debug_options]`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`<= MariaDB 10.4: d:t:i:o,/tmp/mysqld.trace (Unix) or d:t:i:O,\mysqld.trace (Windows), >= MariaDB 10.5: d:t:i:o,/tmp/mariadbd.trace (Unix) or d:t:i:O,\mariadbd.trace (Windows)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[debugdebug_dbug](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#debugdebug_dbug)|

## debug_no_thread_alarm
|name|value|
|----|-----|
|Name|`debug_no_thread_alarm`|
|Command line|`--debug-no-thead-alarm=#`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[debug_no_thread_alarm](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#debug_no_thread_alarm)|

## debug_sync
|name|value|
|----|-----|
|Name|`debug_sync`|
|Type of variable|`string`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[debug_sync](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#debug_sync)|
|dev.mysql.com|[sysvar_debug_sync](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_debug_sync)|

## default_password_lifetime
|name|value|
|----|-----|
|Name|`default_password_lifetime`|
|Command line|`--default-password-lifetime=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_password_lifetime](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_password_lifetime)|
|dev.mysql.com|[sysvar_default_password_lifetime](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_password_lifetime)|

## default_regex_flags
|name|value|
|----|-----|
|Name|`default_regex_flags`|
|Command line|`--default-regex-flags=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`empty`|
|Dynamic|`true`|
|Valid value(s)|`DOTALL`, `DUPNAMES`, `EXTENDED`, `EXTRA`, `MULTILINE`, `UNGREEDY`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_regex_flags](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_regex_flags)|

## default_storage_engine
|name|value|
|----|-----|
|Name|`default_storage_engine`|
|Command line|`--default-storage-engine=name`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`InnoDB`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_storage_engine](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_storage_engine)|
|dev.mysql.com|[sysvar_default_storage_engine](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_storage_engine)|

## default_table_type
|name|value|
|----|-----|
|Name|`default_table_type`|
|Command line|`--default-table-type=name`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_table_type](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_table_type)|

## default_tmp_storage_engine
|name|value|
|----|-----|
|Name|`default_tmp_storage_engine`|
|Command line|`--default-tmp-storage-engine=name`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`InnoDB`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_tmp_storage_engine](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_tmp_storage_engine)|
|dev.mysql.com|[sysvar_default_tmp_storage_engine](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_tmp_storage_engine)|

## default_week_format
|name|value|
|----|-----|
|Name|`default_week_format`|
|Command line|`--default-week-format=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `7`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[default_week_format](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#default_week_format)|
|dev.mysql.com|[sysvar_default_week_format](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_week_format)|

## delay_key_write
|name|value|
|----|-----|
|Name|`delay_key_write`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|
|Valid value(s)|`OFF`, `ON`, `ALL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delay_key_write](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#delay_key_write)|
|dev.mysql.com|[sysvar_delay_key_write](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delay_key_write)|

## delayed_insert_limit
|name|value|
|----|-----|
|Name|`delayed_insert_limit`|
|Command line|`--delayed-insert-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_insert_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#delayed_insert_limit)|
|dev.mysql.com|[sysvar_delayed_insert_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_insert_limit)|

## delayed_insert_timeout
|name|value|
|----|-----|
|Name|`delayed_insert_timeout`|
|Command line|`--delayed-insert-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`300`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_insert_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#delayed_insert_timeout)|
|dev.mysql.com|[sysvar_delayed_insert_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_insert_timeout)|

## delayed_queue_size
|name|value|
|----|-----|
|Name|`delayed_queue_size`|
|Command line|`--delayed-queue-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[delayed_queue_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#delayed_queue_size)|
|dev.mysql.com|[sysvar_delayed_queue_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_queue_size)|

## disconnect_on_expired_password
|name|value|
|----|-----|
|Name|`disconnect_on_expired_password`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[disconnect_on_expired_password](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#disconnect_on_expired_password)|
|dev.mysql.com|[sysvar_disconnect_on_expired_password](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_disconnect_on_expired_password)|

## div_precision_increment
|name|value|
|----|-----|
|Name|`div_precision_increment`|
|Command line|`--div-precision-increment=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4`|
|Dynamic|`true`|
|Range|from: `0` to: `30`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[div_precision_increment](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#div_precision_increment)|
|dev.mysql.com|[sysvar_div_precision_increment](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_div_precision_increment)|

## encrypt_tmp_disk_tables
|name|value|
|----|-----|
|Name|`encrypt_tmp_disk_tables`|
|Command line|`--encrypt-tmp-disk-tables[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[encrypt_tmp_disk_tables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#encrypt_tmp_disk_tables)|

## encrypt_tmp_files
|name|value|
|----|-----|
|Name|`encrypt_tmp_files`|
|Command line|`--encrypt-tmp-files[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF (>= MariaDB 10.1.7), ON (<= MariaDB 10.1.6)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[encrypt_tmp_files](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#encrypt_tmp_files)|

## encryption_algorithm
|name|value|
|----|-----|
|Name|`encryption_algorithm`|
|Command line|`--encryption-algorithm=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`none`|
|Dynamic|`false`|
|Valid value(s)|`none`, `aes_ecb`, `aes_cbc`, `aes_ctr`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[encryption_algorithm](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#encryption_algorithm)|

## enforce_storage_engine
|name|value|
|----|-----|
|Name|`enforce_storage_engine`|
|Type of variable|`string`|
|Scope|`session`|
|Default value|`none`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[enforce_storage_engine](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#enforce_storage_engine)|

## engine_condition_pushdown
|name|value|
|----|-----|
|Name|`engine_condition_pushdown`|
|Command line|`--engine-condition-pushdown`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[engine_condition_pushdown](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#engine_condition_pushdown)|

## eq_range_index_dive_limit
|name|value|
|----|-----|
|Name|`eq_range_index_dive_limit`|
|Command line|`--eq-range-index-dive-limit=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`200`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[eq_range_index_dive_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#eq_range_index_dive_limit)|
|dev.mysql.com|[sysvar_eq_range_index_dive_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_eq_range_index_dive_limit)|

## error_count
|name|value|
|----|-----|
|Name|`error_count`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[error_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#error_count)|

## event_scheduler
|name|value|
|----|-----|
|Name|`event_scheduler`|
|Command line|`--event-scheduler[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `1`, `OFF`, `0`, `DISABLED`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[event_scheduler](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#event_scheduler)|
|dev.mysql.com|[sysvar_event_scheduler](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_event_scheduler)|

## expensive_subquery_limit
|name|value|
|----|-----|
|Name|`expensive_subquery_limit`|
|Command line|`--expensive-subquery-limit=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `0` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[expensive_subquery_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#expensive_subquery_limit)|

## explicit_defaults_for_timestamp
|name|value|
|----|-----|
|Name|`explicit_defaults_for_timestamp`|
|Type of variable|`boolean`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[explicit_defaults_for_timestamp](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#explicit_defaults_for_timestamp)|
|dev.mysql.com|[sysvar_explicit_defaults_for_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)|

## external_user
|name|value|
|----|-----|
|Name|`external_user`|
|Type of variable|`string`|
|Scope|`session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[external_user](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#external_user)|
|dev.mysql.com|[sysvar_external_user](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_external_user)|

## flush
|name|value|
|----|-----|
|Name|`flush`|
|Command line|`--flush[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[flush](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#flush)|
|dev.mysql.com|[option_mysqld_flush](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_flush)|
|dev.mysql.com|[sysvar_flush](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_flush)|

## flush_time
|name|value|
|----|-----|
|Name|`flush_time`|
|Command line|`--flush-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[flush_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#flush_time)|
|dev.mysql.com|[sysvar_flush_time](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_flush_time)|

## foreign_key_checks
|name|value|
|----|-----|
|Name|`foreign_key_checks`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[foreign_key_checks](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#foreign_key_checks)|
|dev.mysql.com|[sysvar_foreign_key_checks](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_foreign_key_checks)|

## ft_boolean_syntax
|name|value|
|----|-----|
|Name|`ft_boolean_syntax`|
|Command line|`--ft-boolean-syntax=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`+ -><()~*:""&|`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ft_boolean_syntax](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ft_boolean_syntax)|
|dev.mysql.com|[sysvar_ft_boolean_syntax](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_boolean_syntax)|

## ft_max_word_len
|name|value|
|----|-----|
|Name|`ft_max_word_len`|
|Command line|`--ft-max-word-len=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `10`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ft_max_word_len](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ft_max_word_len)|
|dev.mysql.com|[sysvar_ft_max_word_len](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_max_word_len)|

## ft_min_word_len
|name|value|
|----|-----|
|Name|`ft_min_word_len`|
|Command line|`--ft-min-word-len=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4`|
|Dynamic|`false`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ft_min_word_len](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ft_min_word_len)|
|dev.mysql.com|[sysvar_ft_min_word_len](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_min_word_len)|

## ft_query_expansion_limit
|name|value|
|----|-----|
|Name|`ft_query_expansion_limit`|
|Command line|`--ft-query-expansion-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`false`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ft_query_expansion_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ft_query_expansion_limit)|
|dev.mysql.com|[sysvar_ft_query_expansion_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_query_expansion_limit)|

## ft_stopword_file
|name|value|
|----|-----|
|Name|`ft_stopword_file`|
|Command line|`--ft-stopword-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ft_stopword_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ft_stopword_file)|
|dev.mysql.com|[sysvar_ft_stopword_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_stopword_file)|

## general_log
|name|value|
|----|-----|
|Name|`general_log`|
|Command line|`--general-log[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[general_log](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#general_log)|
|dev.mysql.com|[sysvar_general_log](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_general_log)|

## general_log_file
|name|value|
|----|-----|
|Name|`general_log_file`|
|Command line|`--general-log-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`host_name.log`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[general_log_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#general_log_file)|
|dev.mysql.com|[sysvar_general_log_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_general_log_file)|

## group_concat_max_len
|name|value|
|----|-----|
|Name|`group_concat_max_len`|
|Command line|`--group-concat-max-len=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `4`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[group_concat_max_len](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#group_concat_max_len)|
|dev.mysql.com|[sysvar_group_concat_max_len](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)|

## have_compress
|name|value|
|----|-----|
|Name|`have_compress`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_compress](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_compress)|

## have_crypt
|name|value|
|----|-----|
|Name|`have_crypt`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_crypt](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_crypt)|

## have_csv
|name|value|
|----|-----|
|Name|`have_csv`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_csv](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_csv)|

## have_dynamic_loading
|name|value|
|----|-----|
|Name|`have_dynamic_loading`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_dynamic_loading](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_dynamic_loading)|

## have_geometry
|name|value|
|----|-----|
|Name|`have_geometry`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_geometry](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_geometry)|

## have_ndbcluster
|name|value|
|----|-----|
|Name|`have_ndbcluster`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_ndbcluster](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_ndbcluster)|

## have_partitioning
|name|value|
|----|-----|
|Name|`have_partitioning`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_partitioning](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_partitioning)|

## have_profiling
|name|value|
|----|-----|
|Name|`have_profiling`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_profiling](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_profiling)|

## have_query_cache
|name|value|
|----|-----|
|Name|`have_query_cache`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_query_cache](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_query_cache)|

## have_rtree_keys
|name|value|
|----|-----|
|Name|`have_rtree_keys`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_rtree_keys](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_rtree_keys)|

## have_symlink
|name|value|
|----|-----|
|Name|`have_symlink`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_symlink](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#have_symlink)|

## histogram_size
|name|value|
|----|-----|
|Name|`histogram_size`|
|Command line|`--histogram-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`254 (>= MariaDB 10.4.3), 0 (<= MariaDB 10.4.2)`|
|Dynamic|`true`|
|Range|from: `0` to: `255`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[histogram_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#histogram_size)|

## histogram_type
|name|value|
|----|-----|
|Name|`histogram_type`|
|Command line|`--histogram-type=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`DOUBLE_PREC_HB (>= MariaDB 10.4.3), SINGLE_PREC_HB(<= MariaDB 10.4.2)`|
|Dynamic|`true`|
|Valid value(s)|`SINGLE_PREC_HB`, `DOUBLE_PREC_HB`, `SINGLE_PREC_HB`, `DOUBLE_PREC_HB`, `JSON_HB`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[histogram_type](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#histogram_type)|

## host_cache_size
|name|value|
|----|-----|
|Name|`host_cache_size`|
|Command line|`--host-cache-size=#.`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[host_cache_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#host_cache_size)|
|dev.mysql.com|[sysvar_host_cache_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_host_cache_size)|

## hostname
|name|value|
|----|-----|
|Name|`hostname`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[hostname](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#hostname)|
|dev.mysql.com|[sysvar_hostname](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_hostname)|

## identity
|name|value|
|----|-----|
|Name|`identity`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[identity](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#identity)|

## idle_readonly_transaction_timeout
|name|value|
|----|-----|
|Name|`idle_readonly_transaction_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[idle_readonly_transaction_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#idle_readonly_transaction_timeout)|

## idle_transaction_timeout
|name|value|
|----|-----|
|Name|`idle_transaction_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[idle_transaction_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#idle_transaction_timeout)|

## idle_write_transaction_timeout
|name|value|
|----|-----|
|Name|`idle_write_transaction_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[idle_write_transaction_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#idle_write_transaction_timeout)|

## ignore_db_dirs
|name|value|
|----|-----|
|Name|`ignore_db_dirs`|
|Command line|`--ignore-db-dirs=dir.`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ignore_db_dirs](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#ignore_db_dirs)|

## in_predicate_conversion_threshold
|name|value|
|----|-----|
|Name|`in_predicate_conversion_threshold`|
|Command line|`--in-predicate-conversion-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1000`|
|Dynamic|`false`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[in_predicate_conversion_threshold](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#in_predicate_conversion_threshold)|

## in_transaction
|name|value|
|----|-----|
|Name|`in_transaction`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[in_transaction](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#in_transaction)|

## init_connect
|name|value|
|----|-----|
|Name|`init_connect`|
|Command line|`--init-connect=name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[init_connect](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#init_connect)|
|dev.mysql.com|[sysvar_init_connect](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_init_connect)|

## init_file
|name|value|
|----|-----|
|Name|`init_file`|
|Command line|`--init-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[init_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#init_file)|
|dev.mysql.com|[sysvar_init_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_init_file)|

## insert_id
|name|value|
|----|-----|
|Name|`insert_id`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[insert_id](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#insert_id)|

## interactive_timeout
|name|value|
|----|-----|
|Name|`interactive_timeout`|
|Command line|`--interactive-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`28800`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[interactive_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#interactive_timeout)|
|dev.mysql.com|[sysvar_interactive_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)|

## join_buffer_size
|name|value|
|----|-----|
|Name|`join_buffer_size`|
|Command line|`--join-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`262144`|
|Dynamic|`true`|
|Range|from: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[join_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#join_buffer_size)|
|dev.mysql.com|[sysvar_join_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size)|

## join_buffer_space_limit
|name|value|
|----|-----|
|Name|`join_buffer_space_limit`|
|Command line|`--join-buffer-space-limit=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`2097152`|
|Dynamic|`true`|
|Range|from: `2048` to: `99999999997952`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[join_buffer_space_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#join_buffer_space_limit)|

## join_cache_level
|name|value|
|----|-----|
|Name|`join_cache_level`|
|Command line|`--join-cache-level=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`2`|
|Dynamic|`true`|
|Range|from: `0` to: `8`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[join_cache_level](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#join_cache_level)|

## keep_files_on_create
|name|value|
|----|-----|
|Name|`keep_files_on_create`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[keep_files_on_create](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#keep_files_on_create)|
|dev.mysql.com|[sysvar_keep_files_on_create](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keep_files_on_create)|

## large_files_support
|name|value|
|----|-----|
|Name|`large_files_support`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[large_files_support](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#large_files_support)|
|dev.mysql.com|[sysvar_large_files_support](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_large_files_support)|

## large_page_size
|name|value|
|----|-----|
|Name|`large_page_size`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[large_page_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#large_page_size)|
|dev.mysql.com|[sysvar_large_page_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_large_page_size)|

## large_pages
|name|value|
|----|-----|
|Name|`large_pages`|
|Command line|`--large-pages[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[large_pages](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#large_pages)|
|dev.mysql.com|[option_mysqld_large-pages](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_large-pages)|
|dev.mysql.com|[sysvar_large_pages](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_large_pages)|

## last_insert_id
|name|value|
|----|-----|
|Name|`last_insert_id`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[last_insert_id](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#last_insert_id)|

## lc_messages
|name|value|
|----|-----|
|Name|`lc_messages`|
|Command line|`--lc-messages=name`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`en_US`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lc_messages](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lc_messages)|
|dev.mysql.com|[option_mysqld_lc-messages](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_lc-messages)|
|dev.mysql.com|[sysvar_lc_messages](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lc_messages)|

## lc_messages_dir
|name|value|
|----|-----|
|Name|`lc_messages_dir`|
|Command line|`--lc-messages-dir=path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lc_messages_dir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lc_messages_dir)|
|dev.mysql.com|[option_mysqld_lc-messages-dir](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_lc-messages-dir)|
|dev.mysql.com|[sysvar_lc_messages_dir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lc_messages_dir)|

## lc_time_names
|name|value|
|----|-----|
|Name|`lc_time_names`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lc_time_names](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lc_time_names)|
|dev.mysql.com|[sysvar_lc_time_names](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lc_time_names)|

## license
|name|value|
|----|-----|
|Name|`license`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`GPL`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[license](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#license)|
|dev.mysql.com|[sysvar_license](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_license)|

## local_infile
|name|value|
|----|-----|
|Name|`local_infile`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[local_infile](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#local_infile)|
|dev.mysql.com|[sysvar_local_infile](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)|

## lock_wait_timeout
|name|value|
|----|-----|
|Name|`lock_wait_timeout`|
|Command line|`--lock-wait-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lock_wait_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lock_wait_timeout)|
|dev.mysql.com|[sysvar_lock_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_wait_timeout)|

## locked_in_memory
|name|value|
|----|-----|
|Name|`locked_in_memory`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[locked_in_memory](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#locked_in_memory)|
|dev.mysql.com|[sysvar_locked_in_memory](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_locked_in_memory)|

## log
|name|value|
|----|-----|
|Name|`log`|
|Command line|`-l [filename] or --log[=filename]`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log)|

## log_disabled_statements
|name|value|
|----|-----|
|Name|`log_disabled_statements`|
|Command line|`--log-disabled_statements=value`|
|Type of variable|`set`|
|Scope|`global`, `session`|
|Default value|`sp`|
|Dynamic|`false`|
|Valid value(s)|`slave`, `sp`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_disabled_statements](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_disabled_statements)|

## log_error
|name|value|
|----|-----|
|Name|`log_error`|
|Command line|`--log-error[=file_name]`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_error](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_error)|
|dev.mysql.com|[option_mysqld_log-error](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_log-error)|
|dev.mysql.com|[sysvar_log_error](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error)|

## log_output
|name|value|
|----|-----|
|Name|`log_output`|
|Command line|`--log-output=name`|
|Type of variable|`set`|
|Scope|`global`|
|Default value|`FILE`|
|Dynamic|`true`|
|Valid value(s)|`TABLE`, `FILE`, `NONE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_output](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_output)|
|dev.mysql.com|[sysvar_log_output](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_output)|

## log_queries_not_using_indexes
|name|value|
|----|-----|
|Name|`log_queries_not_using_indexes`|
|Command line|`--log-queries-not-using-indexes[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_queries_not_using_indexes](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_queries_not_using_indexes)|
|dev.mysql.com|[sysvar_log_queries_not_using_indexes](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_queries_not_using_indexes)|

## log_slow_admin_statements
|name|value|
|----|-----|
|Name|`log_slow_admin_statements`|
|Command line|`--log-slow-admin-statements[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_admin_statements](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_admin_statements)|
|dev.mysql.com|[sysvar_log_slow_admin_statements](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slow_admin_statements)|

## log_slow_disabled_statements
|name|value|
|----|-----|
|Name|`log_slow_disabled_statements`|
|Command line|`--log-slow-disabled_statements=value`|
|Type of variable|`set`|
|Scope|`global`, `session`|
|Default value|`sp`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_disabled_statements](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_disabled_statements)|

## log_slow_filter
|name|value|
|----|-----|
|Name|`log_slow_filter`|
|Command line|`log-slow-filter=value1[,value2...]`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`admin, filesort, filesort_on_disk, full_join, full_scan, query_cache, query_cache_miss, tmp_table, tmp_table_on_disk (<= MariaDB 10.3.0), admin, filesort, filesort_on_disk, filesort_priority_queue, full_join, full_scan, query_cache, query_cache_miss, tmp_table, tmp_table_on_disk (>= MariaDB 10.3.1)`|
|Dynamic|`true`|
|Valid value(s)|`admin`, `filesort`, `filesort_on_disk`, `filesort_priority_queue`, `full_join`, `full_scan`, `query_cache`, `query_cache_miss`, `tmp_table`, `tmp_table_on_disk`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_filter](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_filter)|

## log_slow_queries
|name|value|
|----|-----|
|Name|`log_slow_queries`|
|Command line|`--log-slow-queries[=name]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_queries](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_queries)|

## log_slow_rate_limit
|name|value|
|----|-----|
|Name|`log_slow_rate_limit`|
|Command line|`log-slow-rate-limit=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_rate_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_rate_limit)|

## log_slow_verbosity
|name|value|
|----|-----|
|Name|`log_slow_verbosity`|
|Command line|`log-slow-verbosity=value1[,value2...]`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`(Empty)`|
|Dynamic|`true`|
|Valid value(s)|`query_plan`, `innodb`, `explain`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_slow_verbosity](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_slow_verbosity)|

## log_tc_size
|name|value|
|----|-----|
|Name|`log_tc_size`|
|Command line|`--log-tc-size=#`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_tc_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_tc_size)|
|dev.mysql.com|[option_mysqld_log-tc-size](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_log-tc-size)|

## log_warnings
|name|value|
|----|-----|
|Name|`log_warnings`|
|Command line|`-W [level] or --log-warnings[=level]`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`2 (>= MariaDB 10.2.4), 1 (<= MariaDB 10.2.3)`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[log_warnings](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#log_warnings)|

## long_query_time
|name|value|
|----|-----|
|Name|`long_query_time`|
|Command line|`--long-query-time=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[long_query_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#long_query_time)|
|dev.mysql.com|[sysvar_long_query_time](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time)|

## low_priority_updates
|name|value|
|----|-----|
|Name|`low_priority_updates`|
|Command line|`--low-priority-updates[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[low_priority_updates](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#low_priority_updates)|
|dev.mysql.com|[sysvar_low_priority_updates](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_low_priority_updates)|

## lower_case_file_system
|name|value|
|----|-----|
|Name|`lower_case_file_system`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lower_case_file_system](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lower_case_file_system)|
|dev.mysql.com|[sysvar_lower_case_file_system](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_file_system)|

## lower_case_table_names
|name|value|
|----|-----|
|Name|`lower_case_table_names`|
|Command line|`--lower-case-table-names[=#]`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[lower_case_table_names](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#lower_case_table_names)|
|dev.mysql.com|[sysvar_lower_case_table_names](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names)|

## max_allowed_packet
|name|value|
|----|-----|
|Name|`max_allowed_packet`|
|Command line|`--max-allowed-packet=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Range|from: `1024` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_allowed_packet](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_allowed_packet)|
|dev.mysql.com|[sysvar_max_allowed_packet](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_allowed_packet)|

## max_connect_errors
|name|value|
|----|-----|
|Name|`max_connect_errors`|
|Command line|`--max-connect-errors=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_connect_errors](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_connect_errors)|
|dev.mysql.com|[sysvar_max_connect_errors](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_connect_errors)|

## max_connections
|name|value|
|----|-----|
|Name|`max_connections`|
|Command line|`--max-connections=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`151`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_connections](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_connections)|
|dev.mysql.com|[sysvar_max_connections](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_connections)|

## max_delayed_threads
|name|value|
|----|-----|
|Name|`max_delayed_threads`|
|Command line|`--max-delayed-threads=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`20`|
|Dynamic|`true`|
|Range|from: `0` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_delayed_threads](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_delayed_threads)|
|dev.mysql.com|[sysvar_max_delayed_threads](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_delayed_threads)|

## max_digest_length
|name|value|
|----|-----|
|Name|`max_digest_length`|
|Command line|`--max-digest-length=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_digest_length](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_digest_length)|
|dev.mysql.com|[sysvar_max_digest_length](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_digest_length)|

## max_error_count
|name|value|
|----|-----|
|Name|`max_error_count`|
|Command line|`--max-error-count=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_error_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_error_count)|
|dev.mysql.com|[sysvar_max_error_count](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_error_count)|

## max_heap_table_size
|name|value|
|----|-----|
|Name|`max_heap_table_size`|
|Command line|`--max-heap-table-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`16777216`|
|Dynamic|`true`|
|Range|from: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_heap_table_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_heap_table_size)|
|dev.mysql.com|[sysvar_max_heap_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)|

## max_insert_delayed_threads
|name|value|
|----|-----|
|Name|`max_insert_delayed_threads`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_insert_delayed_threads](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_insert_delayed_threads)|
|dev.mysql.com|[sysvar_max_insert_delayed_threads](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_insert_delayed_threads)|

## max_join_size
|name|value|
|----|-----|
|Name|`max_join_size`|
|Command line|`--max-join-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`18446744073709551615`|
|Dynamic|`true`|
|Range|from: `1` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_join_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_join_size)|
|dev.mysql.com|[sysvar_max_join_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_join_size)|

## max_length_for_sort_data
|name|value|
|----|-----|
|Name|`max_length_for_sort_data`|
|Command line|`--max-length-for-sort-data=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `4` to: `8388608`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_length_for_sort_data](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_length_for_sort_data)|
|dev.mysql.com|[sysvar_max_length_for_sort_data](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_length_for_sort_data)|

## max_long_data_size
|name|value|
|----|-----|
|Name|`max_long_data_size`|
|Command line|`--max-long-data-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`16777216 (16M) >= MariaDB 10.2.4, 4194304 (4M) <= MariaDB 10.2.3, >= MariaDB 10.1.7, 1048576 (1M) <= MariaDB 10.1.6`|
|Dynamic|`false`|
|Range|from: `1024` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_long_data_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_long_data_size)|

## max_password_errors
|name|value|
|----|-----|
|Name|`max_password_errors`|
|Command line|`--max-password-errors=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4294967295`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_password_errors](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_password_errors)|

## max_prepared_stmt_count
|name|value|
|----|-----|
|Name|`max_prepared_stmt_count`|
|Command line|`--max-prepared-stmt-count=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`16382`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_prepared_stmt_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_prepared_stmt_count)|
|dev.mysql.com|[sysvar_max_prepared_stmt_count](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_prepared_stmt_count)|

## max_recursive_iterations
|name|value|
|----|-----|
|Name|`max_recursive_iterations`|
|Command line|`--max-recursive-iterations=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1000  (>= MariaDB 10.6.0), 4294967295 (<= MariaDB 10.5)`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_recursive_iterations](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_recursive_iterations)|

## max_rowid_filter_size
|name|value|
|----|-----|
|Name|`max_rowid_filter_size`|
|Command line|`--max-rowid-filter-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`131072`|
|Dynamic|`true`|
|Range|from: `1024` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_rowid_filter_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_rowid_filter_size)|

## max_seeks_for_key
|name|value|
|----|-----|
|Name|`max_seeks_for_key`|
|Command line|`--max-seeks-for-key=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_seeks_for_key](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_seeks_for_key)|
|dev.mysql.com|[sysvar_max_seeks_for_key](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key)|

## max_session_mem_used
|name|value|
|----|-----|
|Name|`max_session_mem_used`|
|Command line|`--max-session-mem-used=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`9223372036854775807 (8192 PB)`|
|Dynamic|`true`|
|Range|from: `8192` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_session_mem_used](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_session_mem_used)|

## max_sort_length
|name|value|
|----|-----|
|Name|`max_sort_length`|
|Command line|`--max-sort-length=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1024`|
|Dynamic|`true`|
|Range|from: `4` to: `8388608`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_sort_length](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_sort_length)|
|dev.mysql.com|[sysvar_max_sort_length](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_sort_length)|

## max_sp_recursion_depth
|name|value|
|----|-----|
|Name|`max_sp_recursion_depth`|
|Command line|`--max-sp-recursion-depth[=#]`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_sp_recursion_depth](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_sp_recursion_depth)|
|dev.mysql.com|[sysvar_max_sp_recursion_depth](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_sp_recursion_depth)|

## max_statement_time
|name|value|
|----|-----|
|Name|`max_statement_time`|
|Command line|`--max-statement-time[=#]`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0.000000 >= MariaDB 10.1.13, 0 <= MariaDB 10.1.12`|
|Dynamic|`true`|
|Range|from: `0` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_statement_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_statement_time)|

## max_tmp_tables
|name|value|
|----|-----|
|Name|`max_tmp_tables`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_tmp_tables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_tmp_tables)|

## max_user_connections
|name|value|
|----|-----|
|Name|`max_user_connections`|
|Command line|`--max-user-connections=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_user_connections](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_user_connections)|
|dev.mysql.com|[sysvar_max_user_connections](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections)|

## max_write_lock_count
|name|value|
|----|-----|
|Name|`max_write_lock_count`|
|Command line|`--max-write-lock-count=#`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[max_write_lock_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#max_write_lock_count)|
|dev.mysql.com|[sysvar_max_write_lock_count](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_write_lock_count)|

## metadata_locks_cache_size
|name|value|
|----|-----|
|Name|`metadata_locks_cache_size`|
|Command line|`--metadata-locks-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1024`|
|Dynamic|`false`|
|Range|from: `1` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[metadata_locks_cache_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#metadata_locks_cache_size)|
|dev.mysql.com|[sysvar_metadata_locks_cache_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_metadata_locks_cache_size)|

## metadata_locks_hash_instances
|name|value|
|----|-----|
|Name|`metadata_locks_hash_instances`|
|Command line|`--metadata-locks-hash-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`false`|
|Range|from: `1` to: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[metadata_locks_hash_instances](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#metadata_locks_hash_instances)|
|dev.mysql.com|[sysvar_metadata_locks_hash_instances](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_metadata_locks_hash_instances)|

## min_examined_row_limit
|name|value|
|----|-----|
|Name|`min_examined_row_limit`|
|Command line|`--min-examined-row-limit=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[min_examined_row_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#min_examined_row_limit)|
|dev.mysql.com|[sysvar_min_examined_row_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_min_examined_row_limit)|

## mrr_buffer_size
|name|value|
|----|-----|
|Name|`mrr_buffer_size`|
|Command line|`--mrr-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`262144`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mrr_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#mrr_buffer_size)|

## multi_range_count
|name|value|
|----|-----|
|Name|`multi_range_count`|
|Command line|`--multi-range-count=#`|
|Default value|`256`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[multi_range_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#multi_range_count)|

## mysql56_temporal_format
|name|value|
|----|-----|
|Name|`mysql56_temporal_format`|
|Command line|`--mysql56-temporal-format`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[mysql56_temporal_format](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#mysql56_temporal_format)|

## named_pipe
|name|value|
|----|-----|
|Name|`named_pipe`|
|Command line|`--named-pipe[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[named_pipe](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#named_pipe)|
|dev.mysql.com|[sysvar_named_pipe](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_named_pipe)|

## net_buffer_length
|name|value|
|----|-----|
|Name|`net_buffer_length`|
|Command line|`--net-buffer-length=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`16384`|
|Dynamic|`true`|
|Range|from: `1024` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[net_buffer_length](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#net_buffer_length)|
|dev.mysql.com|[sysvar_net_buffer_length](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_buffer_length)|

## net_read_timeout
|name|value|
|----|-----|
|Name|`net_read_timeout`|
|Command line|`--net-read-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`30`|
|Dynamic|`true`|
|Range|from: `1` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[net_read_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#net_read_timeout)|
|dev.mysql.com|[sysvar_net_read_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)|

## net_retry_count
|name|value|
|----|-----|
|Name|`net_retry_count`|
|Command line|`--net-retry-count=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[net_retry_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#net_retry_count)|
|dev.mysql.com|[sysvar_net_retry_count](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_retry_count)|

## net_write_timeout
|name|value|
|----|-----|
|Name|`net_write_timeout`|
|Command line|`--net-write-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`60`|
|Dynamic|`true`|
|Range|from: `1` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[net_write_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#net_write_timeout)|
|dev.mysql.com|[sysvar_net_write_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)|

## old
|name|value|
|----|-----|
|Name|`old`|
|Command line|`--old[={OFF|ON}]`|
|Type of variable|`boolean`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[old](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#old)|
|dev.mysql.com|[sysvar_old](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_old)|

## old_alter_table
|name|value|
|----|-----|
|Name|`old_alter_table`|
|Command line|`--old-alter-table[={OFF|ON}]`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[old_alter_table](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#old_alter_table)|
|dev.mysql.com|[sysvar_old_alter_table](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_old_alter_table)|

## old_mode
|name|value|
|----|-----|
|Name|`old_mode`|
|Command line|`--old-mode`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`UTF8_IS_UTF8MB3 (>= MariaDB 10.6) (empty string) (<= MariaDB 10.5)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[old_mode](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#old_mode)|

## old_passwords
|name|value|
|----|-----|
|Name|`old_passwords`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[old_passwords](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#old_passwords)|

## open_files_limit
|name|value|
|----|-----|
|Name|`open_files_limit`|
|Command line|`--open-files-limit=count`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[open_files_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#open_files_limit)|
|dev.mysql.com|[sysvar_open_files_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_open_files_limit)|

## optimizer_max_sel_arg_weight
|name|value|
|----|-----|
|Name|`optimizer_max_sel_arg_weight`|
|Command line|`--optimizer-max-sel-arg-weight=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`32000`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_max_sel_arg_weight](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_max_sel_arg_weight)|

## optimizer_prune_level
|name|value|
|----|-----|
|Name|`optimizer_prune_level`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_prune_level](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_prune_level)|
|dev.mysql.com|[sysvar_optimizer_prune_level](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_prune_level)|

## optimizer_search_depth
|name|value|
|----|-----|
|Name|`optimizer_search_depth`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`62`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_search_depth](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_search_depth)|
|dev.mysql.com|[sysvar_optimizer_search_depth](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_search_depth)|

## optimizer_selectivity_sampling_limit
|name|value|
|----|-----|
|Name|`optimizer_selectivity_sampling_limit`|
|Command line|`optimizer-selectivity-sampling-limit[=#]`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `10` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_selectivity_sampling_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_selectivity_sampling_limit)|

## optimizer_switch
|name|value|
|----|-----|
|Name|`optimizer_switch`|
|Command line|`--optimizer-switch=value`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_switch](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_switch)|
|dev.mysql.com|[sysvar_optimizer_switch](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch)|

## optimizer_trace
|name|value|
|----|-----|
|Name|`optimizer_trace`|
|Command line|`--optimizer-trace=value`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_trace](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_trace)|
|dev.mysql.com|[sysvar_optimizer_trace](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace)|

## optimizer_trace_max_mem_size
|name|value|
|----|-----|
|Name|`optimizer_trace_max_mem_size`|
|Command line|`--optimizer-trace-max-mem-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1048576`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_trace_max_mem_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_trace_max_mem_size)|
|dev.mysql.com|[sysvar_optimizer_trace_max_mem_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace_max_mem_size)|

## optimizer_use_condition_selectivity
|name|value|
|----|-----|
|Name|`optimizer_use_condition_selectivity`|
|Command line|`--optimizer-use-condition-selectivity=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4 (>= MariaDB 10.4.1), 1 (<= MariaDB 10.4.0)`|
|Dynamic|`true`|
|Range|from: `1` to: `5`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[optimizer_use_condition_selectivity](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#optimizer_use_condition_selectivity)|

## pid_file
|name|value|
|----|-----|
|Name|`pid_file`|
|Command line|`--pid-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[pid_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#pid_file)|
|dev.mysql.com|[sysvar_pid_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pid_file)|

## plugin_dir
|name|value|
|----|-----|
|Name|`plugin_dir`|
|Command line|`--plugin-dir=path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`BASEDIR/lib/plugin`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[plugin_dir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#plugin_dir)|
|dev.mysql.com|[sysvar_plugin_dir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_plugin_dir)|

## plugin_maturity
|name|value|
|----|-----|
|Name|`plugin_maturity`|
|Command line|`--plugin-maturity=level`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`One less than the server maturity (>= MariaDB 10.3.3), unknown (<= MariaDB 10.3.2)`|
|Dynamic|`false`|
|Valid value(s)|`unknown`, `experimental`, `alpha`, `beta`, `gamma`, `stable`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[plugin_maturity](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#plugin_maturity)|

## port
|name|value|
|----|-----|
|Name|`port`|
|Command line|`--port=port_num`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3306`|
|Dynamic|`false`|
|Range|from: `0` to: `65535`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[port](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#port)|
|dev.mysql.com|[option_mysqld_port](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_port)|
|dev.mysql.com|[sysvar_port](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_port)|

## preload_buffer_size
|name|value|
|----|-----|
|Name|`preload_buffer_size`|
|Command line|`--preload-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`32768`|
|Dynamic|`true`|
|Range|from: `1024` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[preload_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#preload_buffer_size)|
|dev.mysql.com|[sysvar_preload_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_preload_buffer_size)|

## profiling
|name|value|
|----|-----|
|Name|`profiling`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[profiling](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#profiling)|

## profiling_history_size
|name|value|
|----|-----|
|Name|`profiling_history_size`|
|Command line|`--profiling-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`15`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[profiling_history_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#profiling_history_size)|

## progress_report_time
|name|value|
|----|-----|
|Name|`progress_report_time`|
|Command line|`--progress-report-time=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[progress_report_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#progress_report_time)|

## protocol_version
|name|value|
|----|-----|
|Name|`protocol_version`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[protocol_version](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#protocol_version)|
|dev.mysql.com|[sysvar_protocol_version](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_protocol_version)|

## proxy_protocol_networks
|name|value|
|----|-----|
|Name|`proxy_protocol_networks`|
|Command line|`--proxy-protocol-networks=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(empty)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[proxy_protocol_networks](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#proxy_protocol_networks)|

## proxy_user
|name|value|
|----|-----|
|Name|`proxy_user`|
|Type of variable|`string`|
|Scope|`session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[proxy_user](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#proxy_user)|
|dev.mysql.com|[sysvar_proxy_user](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_proxy_user)|

## pseudo_slave_mode
|name|value|
|----|-----|
|Name|`pseudo_slave_mode`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[pseudo_slave_mode](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#pseudo_slave_mode)|
|dev.mysql.com|[sysvar_pseudo_slave_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pseudo_slave_mode)|

## pseudo_thread_id
|name|value|
|----|-----|
|Name|`pseudo_thread_id`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[pseudo_thread_id](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#pseudo_thread_id)|
|dev.mysql.com|[sysvar_pseudo_thread_id](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pseudo_thread_id)|

## query_alloc_block_size
|name|value|
|----|-----|
|Name|`query_alloc_block_size`|
|Command line|`--query-alloc-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `1024` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_alloc_block_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_alloc_block_size)|
|dev.mysql.com|[sysvar_query_alloc_block_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_alloc_block_size)|

## query_cache_limit
|name|value|
|----|-----|
|Name|`query_cache_limit`|
|Command line|`--query-cache-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1048576 (1MB)`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_limit)|

## query_cache_min_res_unit
|name|value|
|----|-----|
|Name|`query_cache_min_res_unit`|
|Command line|`--query-cache-min-res-unit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4096 (4KB)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_min_res_unit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_min_res_unit)|

## query_cache_size
|name|value|
|----|-----|
|Name|`query_cache_size`|
|Command line|`--query-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1M (>= MariaDB 10.1.7), 0 (<= MariaDB 10.1.6) (although frequently given a default value in some setups)`|
|Dynamic|`true`|
|Valid value(s)|`0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_size)|

## query_cache_strip_comments
|name|value|
|----|-----|
|Name|`query_cache_strip_comments`|
|Command line|`query-cache-strip-comments`|
|Type of variable|`boolean`|
|Scope|`session`, `global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_strip_comments](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_strip_comments)|

## query_cache_type
|name|value|
|----|-----|
|Name|`query_cache_type`|
|Command line|`--query-cache-type=#`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`OFF (>= MariaDB 10.1.7), ON (<= MariaDB 10.1.6)`|
|Dynamic|`true`|
|Valid value(s)|`0`, `OFF`, `1`, `ON`, `2`, `DEMAND`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_type](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_type)|

## query_cache_wlock_invalidate
|name|value|
|----|-----|
|Name|`query_cache_wlock_invalidate`|
|Command line|`--query-cache-wlock-invalidate`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_cache_wlock_invalidate](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_cache_wlock_invalidate)|

## query_prealloc_size
|name|value|
|----|-----|
|Name|`query_prealloc_size`|
|Command line|`--query-prealloc-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[query_prealloc_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#query_prealloc_size)|
|dev.mysql.com|[sysvar_query_prealloc_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_prealloc_size)|

## rand_seed1
|name|value|
|----|-----|
|Name|`rand_seed1`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rand_seed1](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#rand_seed1)|
|dev.mysql.com|[sysvar_rand_seed1](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rand_seed1)|

## rand_seed2
|name|value|
|----|-----|
|Name|`rand_seed2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rand_seed2](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#rand_seed2)|

## range_alloc_block_size
|name|value|
|----|-----|
|Name|`range_alloc_block_size`|
|Command line|`--range-alloc-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4096`|
|Dynamic|`true`|
|Range|from: `4096` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[range_alloc_block_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#range_alloc_block_size)|
|dev.mysql.com|[sysvar_range_alloc_block_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_alloc_block_size)|

## read_buffer_size
|name|value|
|----|-----|
|Name|`read_buffer_size`|
|Command line|`--read-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`131072`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[read_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#read_buffer_size)|
|dev.mysql.com|[sysvar_read_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_buffer_size)|

## read_only
|name|value|
|----|-----|
|Name|`read_only`|
|Command line|`--read-only[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[read_only](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#read_only)|
|dev.mysql.com|[sysvar_read_only](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_only)|

## read_rnd_buffer_size
|name|value|
|----|-----|
|Name|`read_rnd_buffer_size`|
|Command line|`--read-rnd-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`262144`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[read_rnd_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#read_rnd_buffer_size)|
|dev.mysql.com|[sysvar_read_rnd_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_rnd_buffer_size)|

## require_secure_transport
|name|value|
|----|-----|
|Name|`require_secure_transport`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[require_secure_transport](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#require_secure_transport)|
|dev.mysql.com|[sysvar_require_secure_transport](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)|

## rowid_merge_buff_size
|name|value|
|----|-----|
|Name|`rowid_merge_buff_size`|
|Command line|`--rowid-merge-buff-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`8388608`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rowid_merge_buff_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#rowid_merge_buff_size)|

## rpl_recovery_rank
|name|value|
|----|-----|
|Name|`rpl_recovery_rank`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[rpl_recovery_rank](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#rpl_recovery_rank)|

## safe_show_database
|name|value|
|----|-----|
|Name|`safe_show_database`|
|Command line|`--safe-show-database (until MySQL 4.1.1)`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[safe_show_database](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#safe_show_database)|

## secure_auth
|name|value|
|----|-----|
|Name|`secure_auth`|
|Command line|`--secure-auth`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON (>= MariaDB 10.1.7), OFF (<= MariaDB 10.1.6)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[secure_auth](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#secure_auth)|

## secure_file_priv
|name|value|
|----|-----|
|Name|`secure_file_priv`|
|Command line|`--secure-path-priv=path`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`platform specific`|
|Dynamic|`false`|
|Valid value(s)|`empty string`, `dirname`, `NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[secure_file_priv](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#secure_file_priv)|
|dev.mysql.com|[sysvar_secure_file_priv](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_secure_file_priv)|

## secure_timestamp
|name|value|
|----|-----|
|Name|`secure_timestamp`|
|Command line|`--secure-timestamp=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NO`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[secure_timestamp](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#secure_timestamp)|

## session_track_schema
|name|value|
|----|-----|
|Name|`session_track_schema`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[session_track_schema](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#session_track_schema)|
|dev.mysql.com|[sysvar_session_track_schema](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_schema)|

## session_track_state_change
|name|value|
|----|-----|
|Name|`session_track_state_change`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[session_track_state_change](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#session_track_state_change)|
|dev.mysql.com|[sysvar_session_track_state_change](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_state_change)|

## session_track_system_variables
|name|value|
|----|-----|
|Name|`session_track_system_variables`|
|Command line|`--session-track-system-variables=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`time_z1e, autocommit, character_set_client, character_set_results, character_set_c1necti1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[session_track_system_variables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#session_track_system_variables)|
|dev.mysql.com|[sysvar_session_track_system_variables](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_system_variables)|

## session_track_transaction_info
|name|value|
|----|-----|
|Name|`session_track_transaction_info`|
|Command line|`--session-track-transaction-info=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`OFF`, `STATE`, `CHARACTERISTICS`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[session_track_transaction_info](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#session_track_transaction_info)|
|dev.mysql.com|[sysvar_session_track_transaction_info](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_transaction_info)|

## shared_memory
|name|value|
|----|-----|
|Name|`shared_memory`|
|Command line|`--shared-memory[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[shared_memory](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#shared_memory)|
|dev.mysql.com|[sysvar_shared_memory](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_shared_memory)|

## shared_memory_base_name
|name|value|
|----|-----|
|Name|`shared_memory_base_name`|
|Command line|`--shared-memory-base-name=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`MYSQL`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[shared_memory_base_name](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#shared_memory_base_name)|
|dev.mysql.com|[sysvar_shared_memory_base_name](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_shared_memory_base_name)|

## skip_external_locking
|name|value|
|----|-----|
|Name|`skip_external_locking`|
|Command line|`--skip-external-locking[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_external_locking](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#skip_external_locking)|
|dev.mysql.com|[sysvar_skip_external_locking](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_external_locking)|

## skip_name_resolve
|name|value|
|----|-----|
|Name|`skip_name_resolve`|
|Command line|`--skip-name-resolve[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_name_resolve](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#skip_name_resolve)|
|dev.mysql.com|[sysvar_skip_name_resolve](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_name_resolve)|

## skip_networking
|name|value|
|----|-----|
|Name|`skip_networking`|
|Command line|`--skip-networking[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_networking](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#skip_networking)|
|dev.mysql.com|[sysvar_skip_networking](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_networking)|

## skip_show_database
|name|value|
|----|-----|
|Name|`skip_show_database`|
|Command line|`--skip-show-database`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[skip_show_database](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#skip_show_database)|
|dev.mysql.com|[option_mysqld_skip-show-database](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_skip-show-database)|
|dev.mysql.com|[sysvar_skip_show_database](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_show_database)|

## slow_launch_time
|name|value|
|----|-----|
|Name|`slow_launch_time`|
|Command line|`--slow-launch-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slow_launch_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#slow_launch_time)|
|dev.mysql.com|[sysvar_slow_launch_time](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_launch_time)|

## slow_query_log
|name|value|
|----|-----|
|Name|`slow_query_log`|
|Command line|`--slow-query-log[={OFF|ON}]`|
|Type of variable|`boolean`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slow_query_log](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#slow_query_log)|
|dev.mysql.com|[sysvar_slow_query_log](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_query_log)|

## slow_query_log_file
|name|value|
|----|-----|
|Name|`slow_query_log_file`|
|Command line|`--slow-query-log-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`host_name-slow.log`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[slow_query_log_file](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#slow_query_log_file)|
|dev.mysql.com|[sysvar_slow_query_log_file](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_query_log_file)|

## socket
|name|value|
|----|-----|
|Name|`socket`|
|Command line|`--socket={file_name|pipe_name}`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[socket](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#socket)|
|dev.mysql.com|[option_mysqld_socket](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_socket)|
|dev.mysql.com|[sysvar_socket](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_socket)|

## sort_buffer_size
|name|value|
|----|-----|
|Name|`sort_buffer_size`|
|Command line|`--sort-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `32768`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sort_buffer_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sort_buffer_size)|
|dev.mysql.com|[sysvar_sort_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sort_buffer_size)|

## sql_auto_is_null
|name|value|
|----|-----|
|Name|`sql_auto_is_null`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_auto_is_null](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_auto_is_null)|
|dev.mysql.com|[sysvar_sql_auto_is_null](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_auto_is_null)|

## sql_big_selects
|name|value|
|----|-----|
|Name|`sql_big_selects`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_big_selects](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_big_selects)|
|dev.mysql.com|[sysvar_sql_big_selects](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_big_selects)|

## sql_big_tables
|name|value|
|----|-----|
|Name|`sql_big_tables`|
|Command line|`--sql-big-tables`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_big_tables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_big_tables)|

## sql_buffer_result
|name|value|
|----|-----|
|Name|`sql_buffer_result`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_buffer_result](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_buffer_result)|
|dev.mysql.com|[sysvar_sql_buffer_result](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_buffer_result)|

## sql_if_exists
|name|value|
|----|-----|
|Name|`sql_if_exists`|
|Command line|`--sql-if-exists[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_if_exists](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_if_exists)|

## sql_log_off
|name|value|
|----|-----|
|Name|`sql_log_off`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Valid value(s)|`OFF`, `ON`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_log_off](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_log_off)|
|dev.mysql.com|[sysvar_sql_log_off](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_log_off)|

## sql_log_update
|name|value|
|----|-----|
|Name|`sql_log_update`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_log_update](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_log_update)|

## sql_low_priority_updates
|name|value|
|----|-----|
|Name|`sql_low_priority_updates`|
|Command line|`--sql-low-priority-updates`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_low_priority_updates](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_low_priority_updates)|

## sql_max_join_size
|name|value|
|----|-----|
|Name|`sql_max_join_size`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_max_join_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_max_join_size)|

## sql_mode
|name|value|
|----|-----|
|Name|`sql_mode`|
|Command line|`--sql-mode=name`|
|Type of variable|`set`|
|Scope|`global`, `session`|
|Default value|`ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_ZERO_IN_DATE NO_ZERO_DATE ERROR_FOR_DIVISION_BY_ZERO NO_ENGINE_SUBSTITUTION`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_mode](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_mode)|
|dev.mysql.com|[option_mysqld_sql-mode](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_sql-mode)|
|dev.mysql.com|[sysvar_sql_mode](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_mode)|

## sql_notes
|name|value|
|----|-----|
|Name|`sql_notes`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_notes](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_notes)|
|dev.mysql.com|[sysvar_sql_notes](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_notes)|

## sql_quote_show_create
|name|value|
|----|-----|
|Name|`sql_quote_show_create`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_quote_show_create](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_quote_show_create)|
|dev.mysql.com|[sysvar_sql_quote_show_create](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_quote_show_create)|

## sql_safe_updates
|name|value|
|----|-----|
|Name|`sql_safe_updates`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_safe_updates](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_safe_updates)|
|dev.mysql.com|[sysvar_sql_safe_updates](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_safe_updates)|

## sql_select_limit
|name|value|
|----|-----|
|Name|`sql_select_limit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_select_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_select_limit)|
|dev.mysql.com|[sysvar_sql_select_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_select_limit)|

## sql_warnings
|name|value|
|----|-----|
|Name|`sql_warnings`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sql_warnings](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sql_warnings)|
|dev.mysql.com|[sysvar_sql_warnings](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_warnings)|

## storage_engine
|name|value|
|----|-----|
|Name|`storage_engine`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[storage_engine](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#storage_engine)|

## standard_compliant_cte
|name|value|
|----|-----|
|Name|`standard_compliant_cte`|
|Command line|`--standard-compliant-cte={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[standard_compliant_cte](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#standard_compliant_cte)|

## stored_program_cache
|name|value|
|----|-----|
|Name|`stored_program_cache`|
|Command line|`--stored-program-cache=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`256`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[stored_program_cache](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#stored_program_cache)|
|dev.mysql.com|[sysvar_stored_program_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_stored_program_cache)|

## strict_password_validation
|name|value|
|----|-----|
|Name|`strict_password_validation`|
|Command line|`--strict-password-validation`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[strict_password_validation](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#strict_password_validation)|

## sync_frm
|name|value|
|----|-----|
|Name|`sync_frm`|
|Command line|`--sync-frm`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`TRUE`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sync_frm](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#sync_frm)|

## system_time_zone
|name|value|
|----|-----|
|Name|`system_time_zone`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[system_time_zone](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#system_time_zone)|
|dev.mysql.com|[sysvar_system_time_zone](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_system_time_zone)|

## table_definition_cache
|name|value|
|----|-----|
|Name|`table_definition_cache`|
|Command line|`--table-definition-cache=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `400`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_definition_cache](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#table_definition_cache)|
|dev.mysql.com|[sysvar_table_definition_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)|

## table_lock_wait_timeout
|name|value|
|----|-----|
|Name|`table_lock_wait_timeout`|
|Command line|`--table-lock-wait-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `1` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_lock_wait_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#table_lock_wait_timeout)|

## table_open_cache
|name|value|
|----|-----|
|Name|`table_open_cache`|
|Command line|`--table-open-cache=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#table_open_cache)|
|dev.mysql.com|[sysvar_table_open_cache](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)|

## table_open_cache_instances
|name|value|
|----|-----|
|Name|`table_open_cache_instances`|
|Command line|`--table-open-cache-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_open_cache_instances](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#table_open_cache_instances)|
|dev.mysql.com|[sysvar_table_open_cache_instances](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache_instances)|

## table_type
|name|value|
|----|-----|
|Name|`table_type`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[table_type](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#table_type)|

## tcp_keepalive_interval
|name|value|
|----|-----|
|Name|`tcp_keepalive_interval`|
|Command line|`--tcp-keepalive-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tcp_keepalive_interval](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tcp_keepalive_interval)|

## tcp_keepalive_probes
|name|value|
|----|-----|
|Name|`tcp_keepalive_probes`|
|Command line|`--tcp-keepalive-probes=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tcp_keepalive_probes](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tcp_keepalive_probes)|

## tcp_keepalive_time
|name|value|
|----|-----|
|Name|`tcp_keepalive_time`|
|Command line|`--tcp-keepalive-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tcp_keepalive_time](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tcp_keepalive_time)|

## tcp_nodelay
|name|value|
|----|-----|
|Name|`tcp_nodelay`|
|Command line|`--tcp-nodelay={0|1}`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tcp_nodelay](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tcp_nodelay)|

## thread_cache_size
|name|value|
|----|-----|
|Name|`thread_cache_size`|
|Command line|`--thread-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`(-1 signifies autosizing; do not use -1)`|
|Dynamic|`true`|
|Range|from: `0` to: `16384`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_cache_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#thread_cache_size)|
|dev.mysql.com|[sysvar_thread_cache_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_cache_size)|

## thread_concurrency
|name|value|
|----|-----|
|Name|`thread_concurrency`|
|Command line|`--thread-concurrency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|
|Range|from: `1` to: `512`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_concurrency](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#thread_concurrency)|

## thread_stack
|name|value|
|----|-----|
|Name|`thread_stack`|
|Command line|`--thread-stack=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `131072` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_stack](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#thread_stack)|
|dev.mysql.com|[sysvar_thread_stack](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_stack)|

## time_format
|name|value|
|----|-----|
|Name|`time_format`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[time_format](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#time_format)|

## time_zone
|name|value|
|----|-----|
|Name|`time_zone`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`SYSTEM`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[time_zone](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#time_zone)|
|dev.mysql.com|[sysvar_time_zone](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_time_zone)|

## timed_mutexes
|name|value|
|----|-----|
|Name|`timed_mutexes`|
|Command line|`--timed-mutexes`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[timed_mutexes](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#timed_mutexes)|

## timestamp
|name|value|
|----|-----|
|Name|`timestamp`|
|Type of variable|`numeric`|
|Scope|`session`|
|Default value|`UNIX_TIMESTAMP()`|
|Dynamic|`true`|
|Range|from: `1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[timestamp](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#timestamp)|
|dev.mysql.com|[sysvar_timestamp](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_timestamp)|

## tmp_disk_table_size
|name|value|
|----|-----|
|Name|`tmp_disk_table_size`|
|Command line|`--tmp-disk-table-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`18446744073709551615 (max unsigned integer, no limit)`|
|Dynamic|`true`|
|Range|from: `1024` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tmp_disk_table_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tmp_disk_table_size)|

## tmp_memory_table_size
|name|value|
|----|-----|
|Name|`tmp_memory_table_size`|
|Command line|`--tmp-memory-table-size=#`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tmp_memory_table_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tmp_memory_table_size)|

## tmp_table_size
|name|value|
|----|-----|
|Name|`tmp_table_size`|
|Command line|`--tmp-table-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`16777216`|
|Dynamic|`true`|
|Range|from: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tmp_table_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tmp_table_size)|
|dev.mysql.com|[sysvar_tmp_table_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)|

## tmpdir
|name|value|
|----|-----|
|Name|`tmpdir`|
|Command line|`--tmpdir=path or -t path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tmpdir](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tmpdir)|
|dev.mysql.com|[option_mysqld_tmpdir](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_tmpdir)|
|dev.mysql.com|[sysvar_tmpdir](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmpdir)|

## transaction_alloc_block_size
|name|value|
|----|-----|
|Name|`transaction_alloc_block_size`|
|Command line|`--transaction-alloc-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`8192`|
|Dynamic|`true`|
|Range|from: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[transaction_alloc_block_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#transaction_alloc_block_size)|
|dev.mysql.com|[sysvar_transaction_alloc_block_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_alloc_block_size)|

## transaction_prealloc_size
|name|value|
|----|-----|
|Name|`transaction_prealloc_size`|
|Command line|`--transaction-prealloc-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4096`|
|Dynamic|`true`|
|Range|from: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[transaction_prealloc_size](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#transaction_prealloc_size)|
|dev.mysql.com|[sysvar_transaction_prealloc_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_prealloc_size)|

## tx_isolation
|name|value|
|----|-----|
|Name|`tx_isolation`|
|Command line|`--transaction-isolation=name`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`REPEATABLE-READ`|
|Dynamic|`true`|
|Valid value(s)|`READ-UNCOMMITTED`, `READ-COMMITTED`, `REPEATABLE-READ`, `SERIALIZABLE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tx_isolation](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tx_isolation)|

## tx_read_only
|name|value|
|----|-----|
|Name|`tx_read_only`|
|Command line|`--transaction-read-only=#`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tx_read_only](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#tx_read_only)|

## unique_checks
|name|value|
|----|-----|
|Name|`unique_checks`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[unique_checks](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#unique_checks)|
|dev.mysql.com|[sysvar_unique_checks](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_unique_checks)|

## updatable_views_with_limit
|name|value|
|----|-----|
|Name|`updatable_views_with_limit`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[updatable_views_with_limit](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#updatable_views_with_limit)|
|dev.mysql.com|[sysvar_updatable_views_with_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_updatable_views_with_limit)|

## use_stat_tables
|name|value|
|----|-----|
|Name|`use_stat_tables`|
|Command line|`--use-stat-tables=mode`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`preferably_for_queries (>= MariaDB 10.4.1), never (<= MariaDB 10.4.0)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[use_stat_tables](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#use_stat_tables)|

## version
|name|value|
|----|-----|
|Name|`version`|
|Command line|`-V, --version[=name] (>= MariaDB 10.2.1), --version (<= MariaDB 10.2.0)`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version)|

## version_comment
|name|value|
|----|-----|
|Name|`version_comment`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_comment](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version_comment)|
|dev.mysql.com|[sysvar_version_comment](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_comment)|

## version_compile_machine
|name|value|
|----|-----|
|Name|`version_compile_machine`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_compile_machine](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version_compile_machine)|
|dev.mysql.com|[sysvar_version_compile_machine](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_compile_machine)|

## version_compile_os
|name|value|
|----|-----|
|Name|`version_compile_os`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_compile_os](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version_compile_os)|
|dev.mysql.com|[sysvar_version_compile_os](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_compile_os)|

## version_malloc_library
|name|value|
|----|-----|
|Name|`version_malloc_library`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_malloc_library](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version_malloc_library)|

## version_source_revision
|name|value|
|----|-----|
|Name|`version_source_revision`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_source_revision](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#version_source_revision)|

## wait_timeout
|name|value|
|----|-----|
|Name|`wait_timeout`|
|Command line|`--wait-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`28800`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[wait_timeout](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#wait_timeout)|
|dev.mysql.com|[sysvar_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)|

## warning_count
|name|value|
|----|-----|
|Name|`warning_count`|
|Type of variable|`integer`|
|Scope|`session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[warning_count](https://mariadb.com/kb/en/library/documentation/replication/optimization-and-tuning/system-variables/server-system-variables/#warning_count)|

## Sphinx_error
|name|value|
|----|-----|
|Name|`Sphinx_error`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_error](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_error)|

## Sphinx_time
|name|value|
|----|-----|
|Name|`Sphinx_time`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_time](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_time)|

## Sphinx_total
|name|value|
|----|-----|
|Name|`Sphinx_total`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_total](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_total)|

## Sphinx_total_found
|name|value|
|----|-----|
|Name|`Sphinx_total_found`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_total_found](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_total_found)|

## Sphinx_word_count
|name|value|
|----|-----|
|Name|`Sphinx_word_count`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_word_count](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_word_count)|

## Sphinx_words
|name|value|
|----|-----|
|Name|`Sphinx_words`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[sphinx_words](https://mariadb.com/kb/en/library/documentation/sphinx-status-variables/#sphinx_words)|

## Spider_direct_aggregate
|name|value|
|----|-----|
|Name|`Spider_direct_aggregate`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_aggregate](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_direct_aggregate)|

## Spider_direct_delete
|name|value|
|----|-----|
|Name|`Spider_direct_delete`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_delete](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_direct_delete)|

## Spider_direct_order_limit
|name|value|
|----|-----|
|Name|`Spider_direct_order_limit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_order_limit](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_direct_order_limit)|

## Spider_direct_update
|name|value|
|----|-----|
|Name|`Spider_direct_update`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_update](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_direct_update)|

## Spider_mon_table_cache_version
|name|value|
|----|-----|
|Name|`Spider_mon_table_cache_version`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_mon_table_cache_version](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_mon_table_cache_version)|

## Spider_mon_table_cache_version_req
|name|value|
|----|-----|
|Name|`Spider_mon_table_cache_version_req`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_mon_table_cache_version_req](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_mon_table_cache_version_req)|

## Spider_parallel_search
|name|value|
|----|-----|
|Name|`Spider_parallel_search`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_parallel_search](https://mariadb.com/kb/en/library/documentation/spider-server-status-variables/#spider_parallel_search)|

## spider_auto_increment_mode
|name|value|
|----|-----|
|Name|`spider_auto_increment_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_auto_increment_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_auto_increment_mode)|

## spider_bgs_first_read
|name|value|
|----|-----|
|Name|`spider_bgs_first_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bgs_first_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bgs_first_read)|

## spider_bgs_mode
|name|value|
|----|-----|
|Name|`spider_bgs_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bgs_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bgs_mode)|

## spider_bgs_second_read
|name|value|
|----|-----|
|Name|`spider_bgs_second_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bgs_second_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bgs_second_read)|

## spider_bka_engine
|name|value|
|----|-----|
|Name|`spider_bka_engine`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bka_engine](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bka_engine)|

## spider_bka_mode
|name|value|
|----|-----|
|Name|`spider_bka_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bka_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bka_mode)|

## spider_bka_table_name_type
|name|value|
|----|-----|
|Name|`spider_bka_table_name_type`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bka_table_name_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bka_table_name_type)|

## spider_block_size
|name|value|
|----|-----|
|Name|`spider_block_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_block_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_block_size)|

## spider_buffer_size
|name|value|
|----|-----|
|Name|`spider_buffer_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_buffer_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_buffer_size)|

## spider_bulk_size
|name|value|
|----|-----|
|Name|`spider_bulk_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bulk_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bulk_size)|

## spider_bulk_update_mode
|name|value|
|----|-----|
|Name|`spider_bulk_update_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bulk_update_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bulk_update_mode)|

## spider_bulk_update_size
|name|value|
|----|-----|
|Name|`spider_bulk_update_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_bulk_update_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_bulk_update_size)|

## spider_casual_read
|name|value|
|----|-----|
|Name|`spider_casual_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `63`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_casual_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_casual_read)|

## spider_conn_recycle_mode
|name|value|
|----|-----|
|Name|`spider_conn_recycle_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_conn_recycle_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_conn_recycle_mode)|

## spider_conn_recycle_strict
|name|value|
|----|-----|
|Name|`spider_conn_recycle_strict`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_conn_recycle_strict](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_conn_recycle_strict)|

## spider_conn_wait_timeout
|name|value|
|----|-----|
|Name|`spider_conn_wait_timeout`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_conn_wait_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_conn_wait_timeout)|

## spider_connect_error_interval
|name|value|
|----|-----|
|Name|`spider_connect_error_interval`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_connect_error_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_connect_error_interval)|

## spider_connect_mutex
|name|value|
|----|-----|
|Name|`spider_connect_mutex`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_connect_mutex](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_connect_mutex)|

## spider_connect_retry_count
|name|value|
|----|-----|
|Name|`spider_connect_retry_count`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_connect_retry_count](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_connect_retry_count)|

## spider_connect_retry_interval
|name|value|
|----|-----|
|Name|`spider_connect_retry_interval`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_connect_retry_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_connect_retry_interval)|

## spider_connect_timeout
|name|value|
|----|-----|
|Name|`spider_connect_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_connect_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_connect_timeout)|

## spider_crd_bg_mode
|name|value|
|----|-----|
|Name|`spider_crd_bg_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_bg_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_bg_mode)|

## spider_crd_interval
|name|value|
|----|-----|
|Name|`spider_crd_interval`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_interval)|

## spider_crd_mode
|name|value|
|----|-----|
|Name|`spider_crd_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_mode)|

## spider_crd_sync
|name|value|
|----|-----|
|Name|`spider_crd_sync`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_sync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_sync)|

## spider_crd_type
|name|value|
|----|-----|
|Name|`spider_crd_type`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_type)|

## spider_crd_weight
|name|value|
|----|-----|
|Name|`spider_crd_weight`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_crd_weight](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_crd_weight)|

## spider_delete_all_rows_type
|name|value|
|----|-----|
|Name|`spider_delete_all_rows_type`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_delete_all_rows_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_delete_all_rows_type)|

## spider_direct_dup_insert
|name|value|
|----|-----|
|Name|`spider_direct_dup_insert`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_dup_insert](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_direct_dup_insert)|

## spider_direct_order_limit
|name|value|
|----|-----|
|Name|`spider_direct_order_limit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_direct_order_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_direct_order_limit)|

## spider_dry_access
|name|value|
|----|-----|
|Name|`spider_dry_access`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_dry_access](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_dry_access)|

## spider_error_read_mode
|name|value|
|----|-----|
|Name|`spider_error_read_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_error_read_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_error_read_mode)|

## spider_error_write_mode
|name|value|
|----|-----|
|Name|`spider_error_write_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_error_write_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_error_write_mode)|

## spider_first_read
|name|value|
|----|-----|
|Name|`spider_first_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_first_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_first_read)|

## spider_force_commit
|name|value|
|----|-----|
|Name|`spider_force_commit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_force_commit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_force_commit)|

## spider_general_log
|name|value|
|----|-----|
|Name|`spider_general_log`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_general_log](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_general_log)|

## spider_index_hint_pushdown
|name|value|
|----|-----|
|Name|`spider_index_hint_pushdown`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_index_hint_pushdown](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_index_hint_pushdown)|

## spider_init_sql_alloc_size
|name|value|
|----|-----|
|Name|`spider_init_sql_alloc_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_init_sql_alloc_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_init_sql_alloc_size)|

## spider_internal_limit
|name|value|
|----|-----|
|Name|`spider_internal_limit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_limit)|

## spider_internal_offset
|name|value|
|----|-----|
|Name|`spider_internal_offset`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_offset](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_offset)|

## spider_internal_optimize
|name|value|
|----|-----|
|Name|`spider_internal_optimize`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_optimize](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_optimize)|

## spider_internal_optimize_local
|name|value|
|----|-----|
|Name|`spider_internal_optimize_local`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_optimize_local](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_optimize_local)|

## spider_internal_sql_log_off
|name|value|
|----|-----|
|Name|`spider_internal_sql_log_off`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_sql_log_off](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_sql_log_off)|

## spider_internal_unlock
|name|value|
|----|-----|
|Name|`spider_internal_unlock`|
|Type of variable|`boolean`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_unlock](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_unlock)|

## spider_internal_xa
|name|value|
|----|-----|
|Name|`spider_internal_xa`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_xa](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_xa)|

## spider_internal_xa_id_type
|name|value|
|----|-----|
|Name|`spider_internal_xa_id_type`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_xa_id_type](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_xa_id_type)|

## spider_internal_xa_snapshot
|name|value|
|----|-----|
|Name|`spider_internal_xa_snapshot`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_internal_xa_snapshot](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_internal_xa_snapshot)|

## spider_load_crd_at_startup
|name|value|
|----|-----|
|Name|`spider_load_crd_at_startup`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_load_crd_at_startup](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_load_crd_at_startup)|

## spider_load_sts_at_startup
|name|value|
|----|-----|
|Name|`spider_load_sts_at_startup`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_load_sts_at_startup](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_load_sts_at_startup)|

## spider_local_lock_table
|name|value|
|----|-----|
|Name|`spider_local_lock_table`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_local_lock_table](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_local_lock_table)|

## spider_lock_exchange
|name|value|
|----|-----|
|Name|`spider_lock_exchange`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_lock_exchange](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_lock_exchange)|

## spider_log_result_error_with_sql
|name|value|
|----|-----|
|Name|`spider_log_result_error_with_sql`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_log_result_error_with_sql](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_log_result_error_with_sql)|

## spider_log_result_errors
|name|value|
|----|-----|
|Name|`spider_log_result_errors`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_log_result_errors](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_log_result_errors)|

## spider_low_mem_read
|name|value|
|----|-----|
|Name|`spider_low_mem_read`|
|Type of variable|`integer`|
|Default value|`-1`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_low_mem_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_low_mem_read)|

## spider_max_connections
|name|value|
|----|-----|
|Name|`spider_max_connections`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `99999`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_max_connections](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_max_connections)|

## spider_max_order
|name|value|
|----|-----|
|Name|`spider_max_order`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `32767`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_max_order](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_max_order)|

## spider_multi_split_read
|name|value|
|----|-----|
|Name|`spider_multi_split_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_multi_split_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_multi_split_read)|

## spider_net_read_timeout
|name|value|
|----|-----|
|Name|`spider_net_read_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_net_read_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_net_read_timeout)|

## spider_net_write_timeout
|name|value|
|----|-----|
|Name|`spider_net_write_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_net_write_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_net_write_timeout)|

## spider_ping_interval_at_trx_start
|name|value|
|----|-----|
|Name|`spider_ping_interval_at_trx_start`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`3600`|
|Dynamic|`true`|
|Range|from: `0` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_ping_interval_at_trx_start](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_ping_interval_at_trx_start)|

## spider_quick_mode
|name|value|
|----|-----|
|Name|`spider_quick_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_quick_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_quick_mode)|

## spider_quick_page_byte
|name|value|
|----|-----|
|Name|`spider_quick_page_byte`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_quick_page_byte](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_quick_page_byte)|

## spider_quick_page_size
|name|value|
|----|-----|
|Name|`spider_quick_page_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_quick_page_size](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_quick_page_size)|

## spider_read_only_mode
|name|value|
|----|-----|
|Name|`spider_read_only_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_read_only_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_read_only_mode)|

## spider_remote_access_charset
|name|value|
|----|-----|
|Name|`spider_remote_access_charset`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_access_charset](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_access_charset)|

## spider_remote_autocommit
|name|value|
|----|-----|
|Name|`spider_remote_autocommit`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_autocommit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_autocommit)|

## spider_remote_default_database
|name|value|
|----|-----|
|Name|`spider_remote_default_database`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_default_database](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_default_database)|

## spider_remote_sql_log_off
|name|value|
|----|-----|
|Name|`spider_remote_sql_log_off`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_sql_log_off](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_sql_log_off)|

## spider_remote_time_zone
|name|value|
|----|-----|
|Name|`spider_remote_time_zone`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_time_zone](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_time_zone)|

## spider_remote_trx_isolation
|name|value|
|----|-----|
|Name|`spider_remote_trx_isolation`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_trx_isolation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_trx_isolation)|

## spider_remote_wait_timeout
|name|value|
|----|-----|
|Name|`spider_remote_wait_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_remote_wait_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_remote_wait_timeout)|

## spider_reset_sql_alloc
|name|value|
|----|-----|
|Name|`spider_reset_sql_alloc`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_reset_sql_alloc](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_reset_sql_alloc)|

## spider_same_server_link
|name|value|
|----|-----|
|Name|`spider_same_server_link`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_same_server_link](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_same_server_link)|

## spider_second_read
|name|value|
|----|-----|
|Name|`spider_second_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_second_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_second_read)|

## spider_select_column_mode
|name|value|
|----|-----|
|Name|`spider_select_column_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_select_column_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_select_column_mode)|

## spider_selupd_lock_mode
|name|value|
|----|-----|
|Name|`spider_selupd_lock_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_selupd_lock_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_selupd_lock_mode)|

## spider_semi_split_read
|name|value|
|----|-----|
|Name|`spider_semi_split_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_split_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_split_read)|

## spider_semi_split_read_limit
|name|value|
|----|-----|
|Name|`spider_semi_split_read_limit`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_split_read_limit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_split_read_limit)|

## spider_semi_table_lock
|name|value|
|----|-----|
|Name|`spider_semi_table_lock`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_table_lock](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_table_lock)|

## spider_semi_table_lock_connection
|name|value|
|----|-----|
|Name|`spider_semi_table_lock_connection`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_table_lock_connection](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_table_lock_connection)|

## spider_semi_trx
|name|value|
|----|-----|
|Name|`spider_semi_trx`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_trx](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_trx)|

## spider_semi_trx_isolation
|name|value|
|----|-----|
|Name|`spider_semi_trx_isolation`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_semi_trx_isolation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_semi_trx_isolation)|

## spider_skip_default_condition
|name|value|
|----|-----|
|Name|`spider_skip_default_condition`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_skip_default_condition](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_skip_default_condition)|

## spider_skip_parallel_search
|name|value|
|----|-----|
|Name|`spider_skip_parallel_search`|
|Command line|`--spider-skip-parallel-search=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_skip_parallel_search](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_skip_parallel_search)|

## spider_slave_trx_isolation
|name|value|
|----|-----|
|Name|`spider_slave_trx_isolation`|
|Command line|`--spider-slave-trx-isolation=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_slave_trx_isolation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_slave_trx_isolation)|

## spider_split_read
|name|value|
|----|-----|
|Name|`spider_split_read`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_split_read](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_split_read)|

## spider_store_last_crd
|name|value|
|----|-----|
|Name|`spider_store_last_crd`|
|Command line|`--spider-store-last-crd=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_store_last_crd](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_store_last_crd)|

## spider_store_last_sts
|name|value|
|----|-----|
|Name|`spider_store_last_sts`|
|Command line|`--spider-store-last-sts=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_store_last_sts](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_store_last_sts)|

## spider_strict_group_by
|name|value|
|----|-----|
|Name|`spider_strict_group_by`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_strict_group_by](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_strict_group_by)|

## spider_sts_bg_mode
|name|value|
|----|-----|
|Name|`spider_sts_bg_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sts_bg_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sts_bg_mode)|

## spider_sts_interval
|name|value|
|----|-----|
|Name|`spider_sts_interval`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sts_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sts_interval)|

## spider_sts_mode
|name|value|
|----|-----|
|Name|`spider_sts_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sts_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sts_mode)|

## spider_sts_sync
|name|value|
|----|-----|
|Name|`spider_sts_sync`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sts_sync](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sts_sync)|

## spider_support_xa
|name|value|
|----|-----|
|Name|`spider_support_xa`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_support_xa](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_support_xa)|

## spider_sync_autocommit
|name|value|
|----|-----|
|Name|`spider_sync_autocommit`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sync_autocommit](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sync_autocommit)|

## spider_sync_sql_mode
|name|value|
|----|-----|
|Name|`spider_sync_sql_mode`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sync_sql_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sync_sql_mode)|

## spider_sync_time_zone
|name|value|
|----|-----|
|Name|`spider_sync_time_zone`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sync_time_zone](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sync_time_zone)|

## spider_sync_trx_isolation
|name|value|
|----|-----|
|Name|`spider_sync_trx_isolation`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_sync_trx_isolation](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_sync_trx_isolation)|

## spider_table_crd_thread_count
|name|value|
|----|-----|
|Name|`spider_table_crd_thread_count`|
|Command line|`--spider-table-crd-thread-count=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_table_crd_thread_count](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_table_crd_thread_count)|

## spider_table_init_error_interval
|name|value|
|----|-----|
|Name|`spider_table_init_error_interval`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_table_init_error_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_table_init_error_interval)|

## spider_table_sts_thread_count
|name|value|
|----|-----|
|Name|`spider_table_sts_thread_count`|
|Command line|`--spider-table-sts-thread-count=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`false`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_table_sts_thread_count](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_table_sts_thread_count)|

## spider_udf_ct_bulk_insert_interval
|name|value|
|----|-----|
|Name|`spider_udf_ct_bulk_insert_interval`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_ct_bulk_insert_interval](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_ct_bulk_insert_interval)|

## spider_udf_ct_bulk_insert_rows
|name|value|
|----|-----|
|Name|`spider_udf_ct_bulk_insert_rows`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_ct_bulk_insert_rows](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_ct_bulk_insert_rows)|

## spider_udf_ds_bulk_insert_rows
|name|value|
|----|-----|
|Name|`spider_udf_ds_bulk_insert_rows`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_ds_bulk_insert_rows](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_ds_bulk_insert_rows)|

## spider_udf_ds_table_loop_mode
|name|value|
|----|-----|
|Name|`spider_udf_ds_table_loop_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_ds_table_loop_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_ds_table_loop_mode)|

## spider_udf_ds_use_real_table
|name|value|
|----|-----|
|Name|`spider_udf_ds_use_real_table`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_ds_use_real_table](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_ds_use_real_table)|

## spider_udf_table_lock_mutex_count
|name|value|
|----|-----|
|Name|`spider_udf_table_lock_mutex_count`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`false`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_table_lock_mutex_count](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_table_lock_mutex_count)|

## spider_udf_table_mon_mutex_count
|name|value|
|----|-----|
|Name|`spider_udf_table_mon_mutex_count`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`false`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_udf_table_mon_mutex_count](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_udf_table_mon_mutex_count)|

## spider_use_all_conns_snapshot
|name|value|
|----|-----|
|Name|`spider_use_all_conns_snapshot`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_all_conns_snapshot](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_all_conns_snapshot)|

## spider_use_cond_other_than_pk_for_update
|name|value|
|----|-----|
|Name|`spider_use_cond_other_than_pk_for_update`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_cond_other_than_pk_for_update](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_cond_other_than_pk_for_update)|

## spider_use_consistent_snapshot
|name|value|
|----|-----|
|Name|`spider_use_consistent_snapshot`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_consistent_snapshot](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_consistent_snapshot)|

## spider_use_default_database
|name|value|
|----|-----|
|Name|`spider_use_default_database`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_default_database](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_default_database)|

## spider_use_flash_logs
|name|value|
|----|-----|
|Name|`spider_use_flash_logs`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_flash_logs](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_flash_logs)|

## spider_use_handler
|name|value|
|----|-----|
|Name|`spider_use_handler`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_handler](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_handler)|

## spider_use_pushdown_udf
|name|value|
|----|-----|
|Name|`spider_use_pushdown_udf`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_pushdown_udf](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_pushdown_udf)|

## spider_use_snapshot_with_flush_tables
|name|value|
|----|-----|
|Name|`spider_use_snapshot_with_flush_tables`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_snapshot_with_flush_tables](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_snapshot_with_flush_tables)|

## spider_use_table_charset
|name|value|
|----|-----|
|Name|`spider_use_table_charset`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`-1`|
|Dynamic|`true`|
|Range|from: `-1` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_use_table_charset](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_use_table_charset)|

## spider_version
|name|value|
|----|-----|
|Name|`spider_version`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_version](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_version)|

## spider_wait_timeout
|name|value|
|----|-----|
|Name|`spider_wait_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`604800`|
|Dynamic|`true`|
|Range|from: `-1` to: `2147483647`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_wait_timeout](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_wait_timeout)|

## spider_xa_register_mode
|name|value|
|----|-----|
|Name|`spider_xa_register_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[spider_xa_register_mode](https://mariadb.com/kb/en/library/documentation/columns-storage-engines-and-plugins/storage-engines/spider/spider-server-system-variables/#spider_xa_register_mode)|

## Ssl_accept_renegotiates
|name|value|
|----|-----|
|Name|`Ssl_accept_renegotiates`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_accept_renegotiates](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_accept_renegotiates)|

## Ssl_accepts
|name|value|
|----|-----|
|Name|`Ssl_accepts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_accepts](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_accepts)|

## Ssl_callback_cache_hits
|name|value|
|----|-----|
|Name|`Ssl_callback_cache_hits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_callback_cache_hits](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_callback_cache_hits)|

## Ssl_cipher
|name|value|
|----|-----|
|Name|`Ssl_cipher`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_cipher](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_cipher)|

## Ssl_cipher_list
|name|value|
|----|-----|
|Name|`Ssl_cipher_list`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_cipher_list](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_cipher_list)|

## Ssl_client_connects
|name|value|
|----|-----|
|Name|`Ssl_client_connects`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_client_connects](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_client_connects)|

## Ssl_connect_renegotiates
|name|value|
|----|-----|
|Name|`Ssl_connect_renegotiates`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_connect_renegotiates](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_connect_renegotiates)|

## Ssl_ctx_verify_depth
|name|value|
|----|-----|
|Name|`Ssl_ctx_verify_depth`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_ctx_verify_depth](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_ctx_verify_depth)|

## Ssl_ctx_verify_mode
|name|value|
|----|-----|
|Name|`Ssl_ctx_verify_mode`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_ctx_verify_mode](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_ctx_verify_mode)|

## Ssl_default_timeout
|name|value|
|----|-----|
|Name|`Ssl_default_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_default_timeout](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_default_timeout)|

## Ssl_finished_accepts
|name|value|
|----|-----|
|Name|`Ssl_finished_accepts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_finished_accepts](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_finished_accepts)|

## Ssl_finished_connects
|name|value|
|----|-----|
|Name|`Ssl_finished_connects`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_finished_connects](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_finished_connects)|

## Ssl_server_not_after
|name|value|
|----|-----|
|Name|`Ssl_server_not_after`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_server_not_after](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_server_not_after)|

## Ssl_server_not_before
|name|value|
|----|-----|
|Name|`Ssl_server_not_before`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_server_not_before](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_server_not_before)|

## Ssl_session_cache_hits
|name|value|
|----|-----|
|Name|`Ssl_session_cache_hits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_hits](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_hits)|

## Ssl_session_cache_misses
|name|value|
|----|-----|
|Name|`Ssl_session_cache_misses`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_misses](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_misses)|

## Ssl_session_cache_mode
|name|value|
|----|-----|
|Name|`Ssl_session_cache_mode`|
|Type of variable|`string`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_mode](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_mode)|

## Ssl_session_cache_overflows
|name|value|
|----|-----|
|Name|`Ssl_session_cache_overflows`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_overflows](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_overflows)|

## Ssl_session_cache_size
|name|value|
|----|-----|
|Name|`Ssl_session_cache_size`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_size](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_size)|

## Ssl_session_cache_timeouts
|name|value|
|----|-----|
|Name|`Ssl_session_cache_timeouts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_session_cache_timeouts](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_session_cache_timeouts)|

## Ssl_sessions_reused
|name|value|
|----|-----|
|Name|`Ssl_sessions_reused`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_sessions_reused](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_sessions_reused)|

## Ssl_used_session_cache_entries
|name|value|
|----|-----|
|Name|`Ssl_used_session_cache_entries`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_used_session_cache_entries](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_used_session_cache_entries)|

## Ssl_verify_depth
|name|value|
|----|-----|
|Name|`Ssl_verify_depth`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_verify_depth](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_verify_depth)|

## Ssl_verify_mode
|name|value|
|----|-----|
|Name|`Ssl_verify_mode`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_verify_mode](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_verify_mode)|

## Ssl_version
|name|value|
|----|-----|
|Name|`Ssl_version`|
|Type of variable|`string`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_version](https://mariadb.com/kb/en/library/documentation/ssltls-status-variables/#ssl_version)|

## have_openssl
|name|value|
|----|-----|
|Name|`have_openssl`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_openssl](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#have_openssl)|

## have_ssl
|name|value|
|----|-----|
|Name|`have_ssl`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|
|Valid value(s)|`YES`, `DISABLED`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_ssl](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#have_ssl)|
|dev.mysql.com|[sysvar_have_ssl](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_ssl)|

## ssl_ca
|name|value|
|----|-----|
|Name|`ssl_ca`|
|Command line|`--ssl-ca=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_ca](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_ca)|
|dev.mysql.com|[sysvar_ssl_ca](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_ca)|

## ssl_capath
|name|value|
|----|-----|
|Name|`ssl_capath`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_capath](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_capath)|
|dev.mysql.com|[sysvar_ssl_capath](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_capath)|

## ssl_cert
|name|value|
|----|-----|
|Name|`ssl_cert`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_cert](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_cert)|
|dev.mysql.com|[sysvar_ssl_cert](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_cert)|

## ssl_cipher
|name|value|
|----|-----|
|Name|`ssl_cipher`|
|Command line|`--ssl-cipher=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_cipher](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_cipher)|
|dev.mysql.com|[sysvar_ssl_cipher](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_cipher)|

## ssl_crl
|name|value|
|----|-----|
|Name|`ssl_crl`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_crl](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_crl)|
|dev.mysql.com|[sysvar_ssl_crl](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_crl)|

## ssl_crlpath
|name|value|
|----|-----|
|Name|`ssl_crlpath`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_crlpath](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_crlpath)|
|dev.mysql.com|[sysvar_ssl_crlpath](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_crlpath)|

## ssl_key
|name|value|
|----|-----|
|Name|`ssl_key`|
|Scope|`global`|
|Default value|`NULL`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ssl_key](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#ssl_key)|
|dev.mysql.com|[sysvar_ssl_key](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_key)|

## tls_version
|name|value|
|----|-----|
|Name|`tls_version`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tls_version](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#tls_version)|
|dev.mysql.com|[sysvar_tls_version](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tls_version)|

## version_ssl_library
|name|value|
|----|-----|
|Name|`version_ssl_library`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`None`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[version_ssl_library](https://mariadb.com/kb/en/library/documentation/ssltls-system-variables/#version_ssl_library)|

## extra_max_connections
|name|value|
|----|-----|
|Name|`extra_max_connections`|
|Command line|`--extra-max-connections=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `100000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[extra_max_connections](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#extra_max_connections)|

## extra_port
|name|value|
|----|-----|
|Name|`extra_port`|
|Command line|`--extra-port=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[extra_port](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#extra_port)|

## thread_handling
|name|value|
|----|-----|
|Name|`thread_handling`|
|Command line|`--thread-handling=name`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`one-thread-per-connection`|
|Dynamic|`false`|
|Valid value(s)|`no-threads`, `one-thread-per-connection`, `pool-of-threads`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_handling](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_handling)|
|dev.mysql.com|[sysvar_thread_handling](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_handling)|

## thread_pool_dedicated_listener
|name|value|
|----|-----|
|Name|`thread_pool_dedicated_listener`|
|Command line|`thread-pool-dedicated-listener={0|1}`|
|Type of variable|`boolean`|
|Scope|``|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_dedicated_listener](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_dedicated_listener)|

## thread_pool_exact_stats
|name|value|
|----|-----|
|Name|`thread_pool_exact_stats`|
|Command line|`thread-pool-exact-stats={0|1}`|
|Type of variable|`boolean`|
|Scope|``|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_exact_stats](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_exact_stats)|

## thread_pool_idle_timeout
|name|value|
|----|-----|
|Name|`thread_pool_idle_timeout`|
|Command line|`thread-pool-idle-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_idle_timeout](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_idle_timeout)|

## thread_pool_max_threads
|name|value|
|----|-----|
|Name|`thread_pool_max_threads`|
|Command line|`thread-pool-max-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`65536 (>= MariaDB 10.2.4), 1000 (<= MariaDB 10.2.3, >= MariaDB 10.1), 500 (<= MariaDB 10.0)`|
|Dynamic|`true`|
|Range|from: `1` to: `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_max_threads](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_max_threads)|

## thread_pool_min_threads
|name|value|
|----|-----|
|Name|`thread_pool_min_threads`|
|Command line|`thread-pool-min-threads=#`|
|Type of variable|`integer`|
|Default value|`1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_min_threads](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_min_threads)|

## thread_pool_oversubscribe
|name|value|
|----|-----|
|Name|`thread_pool_oversubscribe`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3`|
|Dynamic|`true`|
|Range|from: `1` to: `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_oversubscribe](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_oversubscribe)|

## thread_pool_prio_kickup_timer
|name|value|
|----|-----|
|Name|`thread_pool_prio_kickup_timer`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_prio_kickup_timer](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_prio_kickup_timer)|
|dev.mysql.com|[sysvar_thread_pool_prio_kickup_timer](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_prio_kickup_timer)|

## thread_pool_priority
|name|value|
|----|-----|
|Name|`thread_pool_priority`|
|Command line|`--thread-pool-priority=#`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`auto`|
|Valid value(s)|`high`, `low`, `auto`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_priority](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_priority)|

## thread_pool_size
|name|value|
|----|-----|
|Name|`thread_pool_size`|
|Command line|`--thread-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Range|from: `1` to: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_size](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_size)|
|dev.mysql.com|[sysvar_thread_pool_size](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size)|

## thread_pool_stall_limit
|name|value|
|----|-----|
|Name|`thread_pool_stall_limit`|
|Command line|`--thread-pool-stall-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[thread_pool_stall_limit](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#thread_pool_stall_limit)|
|dev.mysql.com|[sysvar_thread_pool_stall_limit](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_stall_limit)|

## Threadpool_idle_threads
|name|value|
|----|-----|
|Name|`Threadpool_idle_threads`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threadpool_idle_threads](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#threadpool_idle_threads)|

## Threadpool_threads
|name|value|
|----|-----|
|Name|`Threadpool_threads`|
|Type of variable|`integer`|
|Scope|`global`, `session`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[threadpool_threads](https://mariadb.com/kb/en/library/documentation/thread-pool-system-and-status-variables/#threadpool_threads)|

## Tokudb_basement_deserialization_fixed_key
|name|value|
|----|-----|
|Name|`Tokudb_basement_deserialization_fixed_key`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basement_deserialization_fixed_key](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basement_deserialization_fixed_key)|

## Tokudb_basement_deserialization_variable_key
|name|value|
|----|-----|
|Name|`Tokudb_basement_deserialization_variable_key`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basement_deserialization_variable_key](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basement_deserialization_variable_key)|

## Tokudb_basements_decompressed_for_write
|name|value|
|----|-----|
|Name|`Tokudb_basements_decompressed_for_write`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_decompressed_for_write](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_decompressed_for_write)|

## Tokudb_basements_decompressed_prefetch
|name|value|
|----|-----|
|Name|`Tokudb_basements_decompressed_prefetch`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_decompressed_prefetch](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_decompressed_prefetch)|

## Tokudb_basements_decompressed_prelocked_range
|name|value|
|----|-----|
|Name|`Tokudb_basements_decompressed_prelocked_range`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_decompressed_prelocked_range](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_decompressed_prelocked_range)|

## Tokudb_basements_decompressed_target_query
|name|value|
|----|-----|
|Name|`Tokudb_basements_decompressed_target_query`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_decompressed_target_query](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_decompressed_target_query)|

## Tokudb_basements_fetched_for_write
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_for_write`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_for_write](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_for_write)|

## Tokudb_basements_fetched_for_write_bytes
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_for_write_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_for_write_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_for_write_bytes)|

## Tokudb_basements_fetched_for_write_seconds
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_for_write_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_for_write_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_for_write_seconds)|

## Tokudb_basements_fetched_prefetch
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prefetch`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prefetch](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prefetch)|

## Tokudb_basements_fetched_prefetch_bytes
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prefetch_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prefetch_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prefetch_bytes)|

## Tokudb_basements_fetched_prefetch_seconds
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prefetch_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prefetch_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prefetch_seconds)|

## Tokudb_basements_fetched_prelocked_range
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prelocked_range`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prelocked_range](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prelocked_range)|

## Tokudb_basements_fetched_prelocked_range_bytes
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prelocked_range_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prelocked_range_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prelocked_range_bytes)|

## Tokudb_basements_fetched_prelocked_range_seconds
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_prelocked_range_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_prelocked_range_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_prelocked_range_seconds)|

## Tokudb_basements_fetched_target_query
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_target_query`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_target_query](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_target_query)|

## Tokudb_basements_fetched_target_query_bytes
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_target_query_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_target_query_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_target_query_bytes)|

## Tokudb_basements_fetched_target_query_seconds
|name|value|
|----|-----|
|Name|`Tokudb_basements_fetched_target_query_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_basements_fetched_target_query_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_basements_fetched_target_query_seconds)|

## Tokudb_broadcase_messages_injected_at_root
|name|value|
|----|-----|
|Name|`Tokudb_broadcase_messages_injected_at_root`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_broadcase_messages_injected_at_root](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_broadcase_messages_injected_at_root)|

## Tokudb_buffers_decompressed_for_write
|name|value|
|----|-----|
|Name|`Tokudb_buffers_decompressed_for_write`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_decompressed_for_write](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_decompressed_for_write)|

## Tokudb_buffers_decompressed_prefetch
|name|value|
|----|-----|
|Name|`Tokudb_buffers_decompressed_prefetch`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_decompressed_prefetch](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_decompressed_prefetch)|

## Tokudb_buffers_decompressed_prelocked_range
|name|value|
|----|-----|
|Name|`Tokudb_buffers_decompressed_prelocked_range`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_decompressed_prelocked_range](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_decompressed_prelocked_range)|

## Tokudb_buffers_decompressed_target_query
|name|value|
|----|-----|
|Name|`Tokudb_buffers_decompressed_target_query`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_decompressed_target_query](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_decompressed_target_query)|

## Tokudb_buffers_fetched_for_write
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_for_write`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_for_write](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_for_write)|

## Tokudb_buffers_fetched_for_write_bytes
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_for_write_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_for_write_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_for_write_bytes)|

## Tokudb_buffers_fetched_for_write_seconds
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_for_write_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_for_write_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_for_write_seconds)|

## Tokudb_buffers_fetched_prefetch
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prefetch`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prefetch](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prefetch)|

## Tokudb_buffers_fetched_prefetch_bytes
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prefetch_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prefetch_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prefetch_bytes)|

## Tokudb_buffers_fetched_prefetch_seconds
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prefetch_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prefetch_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prefetch_seconds)|

## Tokudb_buffers_fetched_prelocked_range
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prelocked_range`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prelocked_range](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prelocked_range)|

## Tokudb_buffers_fetched_prelocked_range_bytes
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prelocked_range_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prelocked_range_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prelocked_range_bytes)|

## Tokudb_buffers_fetched_prelocked_range_seconds
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_prelocked_range_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_prelocked_range_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_prelocked_range_seconds)|

## Tokudb_buffers_fetched_target_query
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_target_query`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_target_query](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_target_query)|

## Tokudb_buffers_fetched_target_query_bytes
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_target_query_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_target_query_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_target_query_bytes)|

## Tokudb_buffers_fetched_target_query_seconds
|name|value|
|----|-----|
|Name|`Tokudb_buffers_fetched_target_query_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_buffers_fetched_target_query_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_buffers_fetched_target_query_seconds)|

## Tokudb_cachetable_cleaner_executions
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_cleaner_executions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_cleaner_executions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_cleaner_executions)|

## Tokudb_cachetable_cleaner_iterations
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_cleaner_iterations`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_cleaner_iterations](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_cleaner_iterations)|

## Tokudb_cachetable_cleaner_period
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_cleaner_period`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_cleaner_period](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_cleaner_period)|

## Tokudb_cachetable_evictions
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_evictions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_evictions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_evictions)|

## Tokudb_cachetable_long_wait_pressure_count
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_long_wait_pressure_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_long_wait_pressure_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_long_wait_pressure_count)|

## Tokudb_cachetable_long_wait_pressure_time
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_long_wait_pressure_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_long_wait_pressure_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_long_wait_pressure_time)|

## Tokudb_cachetable_miss
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_miss`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_miss](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_miss)|

## Tokudb_cachetable_miss_time
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_miss_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_miss_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_miss_time)|

## Tokudb_cachetable_prefetches
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_prefetches`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_prefetches](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_prefetches)|

## Tokudb_cachetable_size_cachepressure
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_cachepressure`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_cachepressure](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_cachepressure)|

## Tokudb_cachetable_size_cloned
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_cloned`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_cloned](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_cloned)|

## Tokudb_cachetable_size_current
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_current`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_current](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_current)|

## Tokudb_cachetable_size_leaf
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_leaf`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_leaf](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_leaf)|

## Tokudb_cachetable_size_limit
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_limit`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_limit](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_limit)|

## Tokudb_cachetable_size_nonleaf
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_nonleaf`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_nonleaf](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_nonleaf)|

## Tokudb_cachetable_size_rollback
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_rollback`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_rollback](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_rollback)|

## Tokudb_cachetable_size_writing
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_size_writing`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_size_writing](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_size_writing)|

## Tokudb_cachetable_wait_pressure_count
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_wait_pressure_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_wait_pressure_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_wait_pressure_count)|

## Tokudb_cachetable_wait_pressure_time
|name|value|
|----|-----|
|Name|`Tokudb_cachetable_wait_pressure_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cachetable_wait_pressure_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cachetable_wait_pressure_time)|

## Tokudb_checkpoint_begin_time
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_begin_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_begin_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_begin_time)|

## Tokudb_checkpoint_duration
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_duration`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_duration](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_duration)|

## Tokudb_checkpoint_duration_last
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_duration_last`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_duration_last](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_duration_last)|

## Tokudb_checkpoint_failed
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_failed`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_failed](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_failed)|

## Tokudb_checkpoint_last_began
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_last_began`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_last_began](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_last_began)|

## Tokudb_checkpoint_last_complete_began
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_last_complete_began`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_last_complete_began](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_last_complete_began)|

## Tokudb_checkpoint_last_complete_ended
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_last_complete_ended`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_last_complete_ended](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_last_complete_ended)|

## Tokudb_checkpoint_long_begin_count
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_long_begin_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_long_begin_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_long_begin_count)|

## Tokudb_checkpoint_long_begin_time
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_long_begin_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_long_begin_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_long_begin_time)|

## Tokudb_checkpoint_period
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_period`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_period](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_period)|

## Tokudb_checkpoint_taken
|name|value|
|----|-----|
|Name|`Tokudb_checkpoint_taken`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_taken](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_checkpoint_taken)|

## Tokudb_cursor_skip_deleted_leaf_entry
|name|value|
|----|-----|
|Name|`Tokudb_cursor_skip_deleted_leaf_entry`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cursor_skip_deleted_leaf_entry](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_cursor_skip_deleted_leaf_entry)|

## Tokudb_db_closes
|name|value|
|----|-----|
|Name|`Tokudb_db_closes`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_db_closes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_db_closes)|

## Tokudb_db_open_current
|name|value|
|----|-----|
|Name|`Tokudb_db_open_current`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_db_open_current](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_db_open_current)|

## Tokudb_db_open_max
|name|value|
|----|-----|
|Name|`Tokudb_db_open_max`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_db_open_max](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_db_open_max)|

## Tokudb_db_opens
|name|value|
|----|-----|
|Name|`Tokudb_db_opens`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_db_opens](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_db_opens)|

## Tokudb_descriptor_set
|name|value|
|----|-----|
|Name|`Tokudb_descriptor_set`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_descriptor_set](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_descriptor_set)|

## Tokudb_dictionary_broadcast_updates
|name|value|
|----|-----|
|Name|`Tokudb_dictionary_broadcast_updates`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_dictionary_broadcast_updates](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_dictionary_broadcast_updates)|

## Tokudb_dictionary_updates
|name|value|
|----|-----|
|Name|`Tokudb_dictionary_updates`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_dictionary_updates](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_dictionary_updates)|

## Tokudb_filesystem_fsync_num
|name|value|
|----|-----|
|Name|`Tokudb_filesystem_fsync_num`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_filesystem_fsync_num](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_filesystem_fsync_num)|

## Tokudb_filesystem_fsync_time
|name|value|
|----|-----|
|Name|`Tokudb_filesystem_fsync_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_filesystem_fsync_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_filesystem_fsync_time)|

## Tokudb_filesystem_long_fsync_num
|name|value|
|----|-----|
|Name|`Tokudb_filesystem_long_fsync_num`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_filesystem_long_fsync_num](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_filesystem_long_fsync_num)|

## Tokudb_filesystem_long_fsync_time
|name|value|
|----|-----|
|Name|`Tokudb_filesystem_long_fsync_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_filesystem_long_fsync_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_filesystem_long_fsync_time)|

## Tokudb_filesystem_threads_blocked_by_full_disk
|name|value|
|----|-----|
|Name|`Tokudb_filesystem_threads_blocked_by_full_disk`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_filesystem_threads_blocked_by_full_disk](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_filesystem_threads_blocked_by_full_disk)|

## Tokudb_leaf_compression_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_compression_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_compression_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_compression_to_memory_seconds)|

## Tokudb_leaf_decompression_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_decompression_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_decompression_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_decompression_to_memory_seconds)|

## Tokudb_leaf_deserialization_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_deserialization_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_deserialization_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_deserialization_to_memory_seconds)|

## Tokudb_leaf_node_compression_ratio
|name|value|
|----|-----|
|Name|`Tokudb_leaf_node_compression_ratio`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_node_compression_ratio](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_node_compression_ratio)|

## Tokudb_leaf_node_full_evictions
|name|value|
|----|-----|
|Name|`Tokudb_leaf_node_full_evictions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_node_full_evictions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_node_full_evictions)|

## Tokudb_leaf_node_full_evictions_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_node_full_evictions_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_node_full_evictions_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_node_full_evictions_bytes)|

## Tokudb_leaf_node_partial_evictions
|name|value|
|----|-----|
|Name|`Tokudb_leaf_node_partial_evictions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_node_partial_evictions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_node_partial_evictions)|

## Tokudb_leaf_node_partial_evictions_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_node_partial_evictions_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_node_partial_evictions_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_node_partial_evictions_bytes)|

## Tokudb_leaf_nodes_created
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_created`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_created](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_created)|

## Tokudb_leaf_nodes_destroyed
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_destroyed`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_destroyed](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_destroyed)|

## Tokudb_leaf_nodes_flushed_checkpoint
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_checkpoint`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_checkpoint](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_checkpoint)|

## Tokudb_leaf_nodes_flushed_checkpoint_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_checkpoint_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_checkpoint_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_checkpoint_bytes)|

## Tokudb_leaf_nodes_flushed_checkpoint_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_checkpoint_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_checkpoint_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_checkpoint_seconds)|

## Tokudb_leaf_nodes_flushed_checkpoint_uncompressed_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_checkpoint_uncompressed_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_checkpoint_uncompressed_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_checkpoint_uncompressed_bytes)|

## Tokudb_leaf_nodes_flushed_not_checkpoint
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_not_checkpoint`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_not_checkpoint](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_not_checkpoint)|

## Tokudb_leaf_nodes_flushed_not_checkpoint_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_not_checkpoint_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_not_checkpoint_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_not_checkpoint_bytes)|

## Tokudb_leaf_nodes_flushed_not_checkpoint_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_not_checkpoint_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_not_checkpoint_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_not_checkpoint_seconds)|

## Tokudb_leaf_nodes_flushed_not_checkpoint_uncompressed_bytes
|name|value|
|----|-----|
|Name|`Tokudb_leaf_nodes_flushed_not_checkpoint_uncompressed_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_nodes_flushed_not_checkpoint_uncompressed_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_nodes_flushed_not_checkpoint_uncompressed_bytes)|

## Tokudb_leaf_serialization_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_leaf_serialization_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_leaf_serialization_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_leaf_serialization_to_memory_seconds)|

## Tokudb_loader_num_created
|name|value|
|----|-----|
|Name|`Tokudb_loader_num_created`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_loader_num_created](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_loader_num_created)|

## Tokudb_loader_num_current
|name|value|
|----|-----|
|Name|`Tokudb_loader_num_current`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_loader_num_current](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_loader_num_current)|

## Tokudb_loader_num_max
|name|value|
|----|-----|
|Name|`Tokudb_loader_num_max`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_loader_num_max](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_loader_num_max)|

## Tokudb_locktree_escalation_num
|name|value|
|----|-----|
|Name|`Tokudb_locktree_escalation_num`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_escalation_num](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_escalation_num)|

## Tokudb_locktree_escalation_seconds
|name|value|
|----|-----|
|Name|`Tokudb_locktree_escalation_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_escalation_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_escalation_seconds)|

## Tokudb_locktree_latest_post_escalation_memory_size
|name|value|
|----|-----|
|Name|`Tokudb_locktree_latest_post_escalation_memory_size`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_latest_post_escalation_memory_size](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_latest_post_escalation_memory_size)|

## Tokudb_locktree_long_wait_count
|name|value|
|----|-----|
|Name|`Tokudb_locktree_long_wait_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_long_wait_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_long_wait_count)|

## Tokudb_locktree_long_wait_escalation_count
|name|value|
|----|-----|
|Name|`Tokudb_locktree_long_wait_escalation_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_long_wait_escalation_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_long_wait_escalation_count)|

## Tokudb_locktree_long_wait_escalation_time
|name|value|
|----|-----|
|Name|`Tokudb_locktree_long_wait_escalation_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_long_wait_escalation_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_long_wait_escalation_time)|

## Tokudb_locktree_long_wait_time
|name|value|
|----|-----|
|Name|`Tokudb_locktree_long_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_long_wait_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_long_wait_time)|

## Tokudb_locktree_memory_size
|name|value|
|----|-----|
|Name|`Tokudb_locktree_memory_size`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_memory_size](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_memory_size)|

## Tokudb_locktree_memory_size_limit
|name|value|
|----|-----|
|Name|`Tokudb_locktree_memory_size_limit`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_memory_size_limit](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_memory_size_limit)|

## Tokudb_locktree_open_current
|name|value|
|----|-----|
|Name|`Tokudb_locktree_open_current`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_open_current](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_open_current)|

## Tokudb_locktree_pending_lock_requests
|name|value|
|----|-----|
|Name|`Tokudb_locktree_pending_lock_requests`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_pending_lock_requests](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_pending_lock_requests)|

## Tokudb_locktree_sto_eligible_num
|name|value|
|----|-----|
|Name|`Tokudb_locktree_sto_eligible_num`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_sto_eligible_num](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_sto_eligible_num)|

## Tokudb_locktree_sto_ended_num
|name|value|
|----|-----|
|Name|`Tokudb_locktree_sto_ended_num`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_sto_ended_num](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_sto_ended_num)|

## Tokudb_locktree_sto_ended_seconds
|name|value|
|----|-----|
|Name|`Tokudb_locktree_sto_ended_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_sto_ended_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_sto_ended_seconds)|

## Tokudb_locktree_timeout_count
|name|value|
|----|-----|
|Name|`Tokudb_locktree_timeout_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_timeout_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_timeout_count)|

## Tokudb_locktree_wait_count
|name|value|
|----|-----|
|Name|`Tokudb_locktree_wait_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_wait_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_wait_count)|

## Tokudb_locktree_wait_escalation_count
|name|value|
|----|-----|
|Name|`Tokudb_locktree_wait_escalation_count`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_wait_escalation_count](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_wait_escalation_count)|

## Tokudb_locktree_wait_escalation_time
|name|value|
|----|-----|
|Name|`Tokudb_locktree_wait_escalation_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_wait_escalation_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_wait_escalation_time)|

## Tokudb_locktree_wait_time
|name|value|
|----|-----|
|Name|`Tokudb_locktree_wait_time`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_locktree_wait_time](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_locktree_wait_time)|

## Tokudb_logger_wait_long
|name|value|
|----|-----|
|Name|`Tokudb_logger_wait_long`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_logger_wait_long](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_logger_wait_long)|

## Tokudb_logger_writes
|name|value|
|----|-----|
|Name|`Tokudb_logger_writes`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_logger_writes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_logger_writes)|

## Tokudb_logger_writes_bytes
|name|value|
|----|-----|
|Name|`Tokudb_logger_writes_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_logger_writes_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_logger_writes_bytes)|

## Tokudb_logger_writes_seconds
|name|value|
|----|-----|
|Name|`Tokudb_logger_writes_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_logger_writes_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_logger_writes_seconds)|

## Tokudb_logger_writes_uncompressed_bytes
|name|value|
|----|-----|
|Name|`Tokudb_logger_writes_uncompressed_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_logger_writes_uncompressed_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_logger_writes_uncompressed_bytes)|

## Tokudb_mem_estimated_maximum_memory_footprint
|name|value|
|----|-----|
|Name|`Tokudb_mem_estimated_maximum_memory_footprint`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_mem_estimated_maximum_memory_footprint](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_mem_estimated_maximum_memory_footprint)|

## Tokudb_messages_flushed_from_h1_to_leaves_bytes
|name|value|
|----|-----|
|Name|`Tokudb_messages_flushed_from_h1_to_leaves_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_messages_flushed_from_h1_to_leaves_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_messages_flushed_from_h1_to_leaves_bytes)|

## Tokudb_messages_ignored_by_leaf_due_to_msn
|name|value|
|----|-----|
|Name|`Tokudb_messages_ignored_by_leaf_due_to_msn`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_messages_ignored_by_leaf_due_to_msn](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_messages_ignored_by_leaf_due_to_msn)|

## Tokudb_messages_in_trees_estimate_bytes
|name|value|
|----|-----|
|Name|`Tokudb_messages_in_trees_estimate_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_messages_in_trees_estimate_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_messages_in_trees_estimate_bytes)|

## Tokudb_messages_injected_at_root
|name|value|
|----|-----|
|Name|`Tokudb_messages_injected_at_root`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_messages_injected_at_root](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_messages_injected_at_root)|

## Tokudb_messages_injected_at_root_bytes
|name|value|
|----|-----|
|Name|`Tokudb_messages_injected_at_root_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_messages_injected_at_root_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_messages_injected_at_root_bytes)|

## Tokudb_nonleaf_compression_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_compression_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_compression_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_compression_to_memory_seconds)|

## Tokudb_nonleaf_decompression_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_decompression_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_decompression_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_decompression_to_memory_seconds)|

## Tokudb_nonleaf_deserialization_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_deserialization_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_deserialization_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_deserialization_to_memory_seconds)|

## Tokudb_nonleaf_node_compression_ratio
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_node_compression_ratio`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_node_compression_ratio](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_node_compression_ratio)|

## Tokudb_nonleaf_node_full_evictions
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_node_full_evictions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_node_full_evictions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_node_full_evictions)|

## Tokudb_nonleaf_node_full_evictions_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_node_full_evictions_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_node_full_evictions_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_node_full_evictions_bytes)|

## Tokudb_nonleaf_node_partial_evictions
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_node_partial_evictions`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_node_partial_evictions](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_node_partial_evictions)|

## Tokudb_nonleaf_node_partial_evictions_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_node_partial_evictions_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_node_partial_evictions_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_node_partial_evictions_bytes)|

## Tokudb_nonleaf_nodes_created
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_created`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_created](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_created)|

## Tokudb_nonleaf_nodes_destroyed
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_destroyed`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_destroyed](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_destroyed)|

## Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_checkpoint](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_checkpoint)|

## Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_bytes)|

## Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_seconds)|

## Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_uncompressed_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_uncompressed_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_uncompressed_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_checkpoint_uncompressed_bytes)|

## Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint)|

## Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_bytes)|

## Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_seconds)|

## Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_uncompressed_bytes
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_uncompressed_bytes`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_uncompressed_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_nodes_flushed_to_disk_not_checkpoint_uncompressed_bytes)|

## Tokudb_nonleaf_serialization_to_memory_seconds
|name|value|
|----|-----|
|Name|`Tokudb_nonleaf_serialization_to_memory_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_nonleaf_serialization_to_memory_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_nonleaf_serialization_to_memory_seconds)|

## Tokudb_overall_node_compression_ratio
|name|value|
|----|-----|
|Name|`Tokudb_overall_node_compression_ratio`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_overall_node_compression_ratio](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_overall_node_compression_ratio)|

## Tokudb_pivots_fetched_for_query
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_query`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_query](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_query)|

## Tokudb_pivots_fetched_for_query_bytes
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_query_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_query_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_query_bytes)|

## Tokudb_pivots_fetched_for_query_seconds
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_query_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_query_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_query_seconds)|

## Tokudb_pivots_fetched_for_prefetch
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_prefetch`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_prefetch](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_prefetch)|

## Tokudb_pivots_fetched_for_prefetch_bytes
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_prefetch_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_prefetch_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_prefetch_bytes)|

## Tokudb_pivots_fetched_for_prefetch_seconds
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_prefetch_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_prefetch_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_prefetch_seconds)|

## Tokudb_pivots_fetched_for_write
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_write`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_write](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_write)|

## Tokudb_pivots_fetched_for_write_bytes
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_write_bytes`|
|Type of variable|`byte`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_write_bytes](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_write_bytes)|

## Tokudb_pivots_fetched_for_write_seconds
|name|value|
|----|-----|
|Name|`Tokudb_pivots_fetched_for_write_seconds`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pivots_fetched_for_write_seconds](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_pivots_fetched_for_write_seconds)|

## Tokudb_promotion_h1_roots_injected_into
|name|value|
|----|-----|
|Name|`Tokudb_promotion_h1_roots_injected_into`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_h1_roots_injected_into](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_h1_roots_injected_into)|

## Tokudb_promotion_injections_at_depth_0
|name|value|
|----|-----|
|Name|`Tokudb_promotion_injections_at_depth_0`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_injections_at_depth_0](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_injections_at_depth_0)|

## Tokudb_promotion_injections_at_depth_1
|name|value|
|----|-----|
|Name|`Tokudb_promotion_injections_at_depth_1`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_injections_at_depth_1](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_injections_at_depth_1)|

## Tokudb_promotion_injections_at_depth_2
|name|value|
|----|-----|
|Name|`Tokudb_promotion_injections_at_depth_2`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_injections_at_depth_2](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_injections_at_depth_2)|

## Tokudb_promotion_injections_at_depth_3
|name|value|
|----|-----|
|Name|`Tokudb_promotion_injections_at_depth_3`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_injections_at_depth_3](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_injections_at_depth_3)|

## Tokudb_promotion_injections_lower_than_depth_3
|name|value|
|----|-----|
|Name|`Tokudb_promotion_injections_lower_than_depth_3`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_injections_lower_than_depth_3](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_injections_lower_than_depth_3)|

## Tokudb_promotion_leaf_roots_injected_into
|name|value|
|----|-----|
|Name|`Tokudb_promotion_leaf_roots_injected_into`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_leaf_roots_injected_into](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_leaf_roots_injected_into)|

## Tokudb_promotion_roots_split
|name|value|
|----|-----|
|Name|`Tokudb_promotion_roots_split`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_roots_split](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_roots_split)|

## Tokudb_promotion_stopped_after_locking_child
|name|value|
|----|-----|
|Name|`Tokudb_promotion_stopped_after_locking_child`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_stopped_after_locking_child](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_stopped_after_locking_child)|

## Tokudb_promotion_stopped_at_height_1
|name|value|
|----|-----|
|Name|`Tokudb_promotion_stopped_at_height_1`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_stopped_at_height_1](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_stopped_at_height_1)|

## Tokudb_promotion_stopped_child_locked_or_not_in_memory
|name|value|
|----|-----|
|Name|`Tokudb_promotion_stopped_child_locked_or_not_in_memory`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_stopped_child_locked_or_not_in_memory](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_stopped_child_locked_or_not_in_memory)|

## Tokudb_promotion_stopped_child_not_fully_in_memory
|name|value|
|----|-----|
|Name|`Tokudb_promotion_stopped_child_not_fully_in_memory`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_stopped_child_not_fully_in_memory](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_stopped_child_not_fully_in_memory)|

## Tokudb_promotion_stopped_nonempty_buffer
|name|value|
|----|-----|
|Name|`Tokudb_promotion_stopped_nonempty_buffer`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_promotion_stopped_nonempty_buffer](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_promotion_stopped_nonempty_buffer)|

## Tokudb_txn_aborts
|name|value|
|----|-----|
|Name|`Tokudb_txn_aborts`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_txn_aborts](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_txn_aborts)|

## Tokudb_txn_begin
|name|value|
|----|-----|
|Name|`Tokudb_txn_begin`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_txn_begin](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_txn_begin)|

## Tokudb_txn_begin_read_only
|name|value|
|----|-----|
|Name|`Tokudb_txn_begin_read_only`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_txn_begin_read_only](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_txn_begin_read_only)|

## Tokudb_txn_commits
|name|value|
|----|-----|
|Name|`Tokudb_txn_commits`|
|Type of variable|`integer`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_txn_commits](https://mariadb.com/kb/en/library/documentation/tokudb-status-variables/#tokudb_txn_commits)|

## tokudb_alter_print_error
|name|value|
|----|-----|
|Name|`tokudb_alter_print_error`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_alter_print_error](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_alter_print_error)|

## tokudb_analyze_time
|name|value|
|----|-----|
|Name|`tokudb_analyze_time`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_analyze_time](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_analyze_time)|

## tokudb_block_size
|name|value|
|----|-----|
|Name|`tokudb_block_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4194304 (4MB)`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_block_size](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_block_size)|

## tokudb_bulk_fetch
|name|value|
|----|-----|
|Name|`tokudb_bulk_fetch`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_bulk_fetch](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_bulk_fetch)|

## tokudb_cache_size
|name|value|
|----|-----|
|Name|`tokudb_cache_size`|
|Type of variable|`integer`|
|Default value|`Half of the total system memory`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cache_size](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_cache_size)|

## tokudb_check_jemalloc
|name|value|
|----|-----|
|Name|`tokudb_check_jemalloc`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Valid value(s)|`0`, `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_check_jemalloc](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_check_jemalloc)|

## tokudb_checkpoint_lock
|name|value|
|----|-----|
|Name|`tokudb_checkpoint_lock`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_lock](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_checkpoint_lock)|

## tokudb_checkpoint_on_flush_logs
|name|value|
|----|-----|
|Name|`tokudb_checkpoint_on_flush_logs`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpoint_on_flush_logs](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_checkpoint_on_flush_logs)|

## tokudb_checkpointing_period
|name|value|
|----|-----|
|Name|`tokudb_checkpointing_period`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_checkpointing_period](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_checkpointing_period)|

## tokudb_cleaner_iterations
|name|value|
|----|-----|
|Name|`tokudb_cleaner_iterations`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cleaner_iterations](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_cleaner_iterations)|

## tokudb_cleaner_period
|name|value|
|----|-----|
|Name|`tokudb_cleaner_period`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_cleaner_period](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_cleaner_period)|

## tokudb_commit_sync
|name|value|
|----|-----|
|Name|`tokudb_commit_sync`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_commit_sync](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_commit_sync)|

## tokudb_create_index_online
|name|value|
|----|-----|
|Name|`tokudb_create_index_online`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_create_index_online](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_create_index_online)|

## tokudb_data_dir
|name|value|
|----|-----|
|Name|`tokudb_data_dir`|
|Type of variable|`string`|
|Default value|`Empty (the MariaDB datadir is used)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_data_dir](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_data_dir)|

## tokudb_debug
|name|value|
|----|-----|
|Name|`tokudb_debug`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_debug](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_debug)|

## tokudb_directio
|name|value|
|----|-----|
|Name|`tokudb_directio`|
|Type of variable|`boolean`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_directio](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_directio)|

## tokudb_disable_hot_alter
|name|value|
|----|-----|
|Name|`tokudb_disable_hot_alter`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_disable_hot_alter](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_disable_hot_alter)|

## tokudb_disable_prefetching
|name|value|
|----|-----|
|Name|`tokudb_disable_prefetching`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_disable_prefetching](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_disable_prefetching)|

## tokudb_disable_slow_alter
|name|value|
|----|-----|
|Name|`tokudb_disable_slow_alter`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_disable_slow_alter](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_disable_slow_alter)|

## tokudb_empty_scan
|name|value|
|----|-----|
|Name|`tokudb_empty_scan`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`rl`|
|Dynamic|`true`|
|Valid value(s)|`lr`, `rl`, `disabled`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_empty_scan](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_empty_scan)|

## tokudb_fs_reserve_percent
|name|value|
|----|-----|
|Name|`tokudb_fs_reserve_percent`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_fs_reserve_percent](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_fs_reserve_percent)|

## tokudb_fsync_log_period
|name|value|
|----|-----|
|Name|`tokudb_fsync_log_period`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_fsync_log_period](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_fsync_log_period)|

## tokudb_hide_default_row_format
|name|value|
|----|-----|
|Name|`tokudb_hide_default_row_format`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_hide_default_row_format](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_hide_default_row_format)|

## tokudb_killed_time
|name|value|
|----|-----|
|Name|`tokudb_killed_time`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4000`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_killed_time](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_killed_time)|

## tokudb_last_lock_timeout
|name|value|
|----|-----|
|Name|`tokudb_last_lock_timeout`|
|Scope|`global`, `session`|
|Default value|`Empty`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_last_lock_timeout](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_last_lock_timeout)|

## tokudb_load_save_space
|name|value|
|----|-----|
|Name|`tokudb_load_save_space`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_load_save_space](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_load_save_space)|

## tokudb_loader_memory_size
|name|value|
|----|-----|
|Name|`tokudb_loader_memory_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`100000000 (100M)`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_loader_memory_size](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_loader_memory_size)|

## tokudb_lock_timeout
|name|value|
|----|-----|
|Name|`tokudb_lock_timeout`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4000 (4 seconds)`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_lock_timeout](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_lock_timeout)|

## tokudb_lock_timeout_debug
|name|value|
|----|-----|
|Name|`tokudb_lock_timeout_debug`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_lock_timeout_debug](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_lock_timeout_debug)|

## tokudb_log_dir
|name|value|
|----|-----|
|Name|`tokudb_log_dir`|
|Type of variable|`string`|
|Default value|`Empty (the MariaDB datadir is used)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_log_dir](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_log_dir)|

## tokudb_max_lock_memory
|name|value|
|----|-----|
|Name|`tokudb_max_lock_memory`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`130653952`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_max_lock_memory](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_max_lock_memory)|

## tokudb_optimize_index_fraction
|name|value|
|----|-----|
|Name|`tokudb_optimize_index_fraction`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1.000000`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_optimize_index_fraction](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_optimize_index_fraction)|

## tokudb_optimize_index_name
|name|value|
|----|-----|
|Name|`tokudb_optimize_index_name`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`None`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_optimize_index_name](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_optimize_index_name)|

## tokudb_optimize_throttle
|name|value|
|----|-----|
|Name|`tokudb_optimize_throttle`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_optimize_throttle](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_optimize_throttle)|

## tokudb_pk_insert_mode
|name|value|
|----|-----|
|Name|`tokudb_pk_insert_mode`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Valid value(s)|`0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_pk_insert_mode](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_pk_insert_mode)|

## tokudb_prelock_empty
|name|value|
|----|-----|
|Name|`tokudb_prelock_empty`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_prelock_empty](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_prelock_empty)|

## tokudb_read_block_size
|name|value|
|----|-----|
|Name|`tokudb_read_block_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`65536 (64KB)`|
|Dynamic|`true`|
|Range|from: `4096` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_read_block_size](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_read_block_size)|

## tokudb_read_buf_size
|name|value|
|----|-----|
|Name|`tokudb_read_buf_size`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`131072 (128KB)`|
|Dynamic|`true`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_read_buf_size](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_read_buf_size)|

## tokudb_read_status_frequency
|name|value|
|----|-----|
|Name|`tokudb_read_status_frequency`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_read_status_frequency](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_read_status_frequency)|

## tokudb_row_format
|name|value|
|----|-----|
|Name|`tokudb_row_format`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`tokudb_zlib`|
|Dynamic|`true`|
|Valid value(s)|`tokudb_default`, `tokudb_fast`, `tokudb_small`, `tokudb_zlib`, `tokudb_quicklz`, `tokudb_lzma`, `tokudb_uncompressed`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_row_format](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_row_format)|

## tokudb_rpl_check_readonly
|name|value|
|----|-----|
|Name|`tokudb_rpl_check_readonly`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_rpl_check_readonly](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_rpl_check_readonly)|

## tokudb_rpl_lookup_rows
|name|value|
|----|-----|
|Name|`tokudb_rpl_lookup_rows`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_rpl_lookup_rows](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_rpl_lookup_rows)|

## tokudb_rpl_lookup_rows_delay
|name|value|
|----|-----|
|Name|`tokudb_rpl_lookup_rows_delay`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_rpl_lookup_rows_delay](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_rpl_lookup_rows_delay)|

## tokudb_rpl_unique_checks
|name|value|
|----|-----|
|Name|`tokudb_rpl_unique_checks`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_rpl_unique_checks](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_rpl_unique_checks)|

## tokudb_rpl_unique_checks_delay
|name|value|
|----|-----|
|Name|`tokudb_rpl_unique_checks_delay`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_rpl_unique_checks_delay](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_rpl_unique_checks_delay)|

## tokudb_support_xa
|name|value|
|----|-----|
|Name|`tokudb_support_xa`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_support_xa](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_support_xa)|

## tokudb_tmp_dir
|name|value|
|----|-----|
|Name|`tokudb_tmp_dir`|
|Type of variable|`directory name`|
|Default value|`Empty (the MariaDB datadir is used)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_tmp_dir](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_tmp_dir)|

## tokudb_version
|name|value|
|----|-----|
|Name|`tokudb_version`|
|Type of variable|`string`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_version](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_version)|

## tokudb_write_status_frequency
|name|value|
|----|-----|
|Name|`tokudb_write_status_frequency`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[tokudb_write_status_frequency](https://mariadb.com/kb/en/library/documentation/tokudb-system-variables/#tokudb_write_status_frequency)|

## system_versioning_alter_history
|name|value|
|----|-----|
|Name|`system_versioning_alter_history`|
|Command line|`--system-versioning-alter-history=value`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`ERROR`|
|Dynamic|`true`|
|Valid value(s)|`ERROR`, `KEEP`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[system_versioning_alter_history](https://mariadb.com/kb/en/library/documentation/system-versioned-tables/#system_versioning_alter_history)|

## system_versioning_asof
|name|value|
|----|-----|
|Name|`system_versioning_asof`|
|Scope|`global`, `session`|
|Default value|`DEFAULT`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[system_versioning_asof](https://mariadb.com/kb/en/library/documentation/system-versioned-tables/#system_versioning_asof)|

## system_versioning_innodb_algorithm_simple
|name|value|
|----|-----|
|Name|`system_versioning_innodb_algorithm_simple`|
|Command line|`--system-versioning-innodb-algorithm-simple[={0|1}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[system_versioning_innodb_algorithm_simple](https://mariadb.com/kb/en/library/documentation/system-versioned-tables/#system_versioning_innodb_algorithm_simple)|

## Innodb_adaptive_hash_cells
|name|value|
|----|-----|
|Name|`Innodb_adaptive_hash_cells`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_cells](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_adaptive_hash_cells)|

## Innodb_adaptive_hash_hash_searches
|name|value|
|----|-----|
|Name|`Innodb_adaptive_hash_hash_searches`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_hash_searches](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_adaptive_hash_hash_searches)|

## Innodb_adaptive_hash_heap_buffers
|name|value|
|----|-----|
|Name|`Innodb_adaptive_hash_heap_buffers`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_heap_buffers](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_adaptive_hash_heap_buffers)|

## Innodb_adaptive_hash_non_hash_searches
|name|value|
|----|-----|
|Name|`Innodb_adaptive_hash_non_hash_searches`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_non_hash_searches](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_adaptive_hash_non_hash_searches)|

## Innodb_available_undo_logs
|name|value|
|----|-----|
|Name|`Innodb_available_undo_logs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_available_undo_logs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_available_undo_logs)|

## Innodb_background_log_sync
|name|value|
|----|-----|
|Name|`Innodb_background_log_sync`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_background_log_sync](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_background_log_sync)|

## Innodb_buffer_pool_bytes_data
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_bytes_data`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_bytes_data](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_bytes_data)|

## Innodb_buffer_pool_bytes_dirty
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_bytes_dirty`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_bytes_dirty](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_bytes_dirty)|

## Innodb_buffer_pool_dump_status
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_dump_status`|
|Type of variable|`string`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_dump_status](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_dump_status)|

## Innodb_buffer_pool_load_incomplete
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_load_incomplete`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_incomplete](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_load_incomplete)|

## Innodb_buffer_pool_load_status
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_load_status`|
|Type of variable|`string`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_status](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_load_status)|

## Innodb_buffer_pool_pages_data
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_data`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_data](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_data)|

## Innodb_buffer_pool_pages_dirty
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_dirty`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_dirty](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_dirty)|

## Innodb_buffer_pool_pages_flushed
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_flushed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_flushed)|

## Innodb_buffer_pool_pages_LRU_flushed
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_LRU_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_lru_flushed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_lru_flushed)|

## Innodb_buffer_pool_pages_LRU_freed
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_LRU_freed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_lru_freed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_lru_freed)|

## Innodb_buffer_pool_pages_free
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_free`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_free](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_free)|

## Innodb_buffer_pool_pages_made_not_young
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_made_not_young`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_made_not_young](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_made_not_young)|

## Innodb_buffer_pool_pages_made_young
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_made_young`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_made_young](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_made_young)|

## Innodb_buffer_pool_pages_misc
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_misc`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_misc](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_misc)|

## Innodb_buffer_pool_pages_old
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_old`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_old](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_old)|

## Innodb_buffer_pool_pages_total
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_pages_total`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_pages_total](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_pages_total)|

## Innodb_buffer_pool_read_ahead
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_read_ahead`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_read_ahead](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_read_ahead)|

## Innodb_buffer_pool_read_ahead_evicted
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_read_ahead_evicted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_read_ahead_evicted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_read_ahead_evicted)|

## Innodb_buffer_pool_read_ahead_rnd
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_read_ahead_rnd`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_read_ahead_rnd](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_read_ahead_rnd)|

## Innodb_buffer_pool_read_requests
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_read_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_read_requests](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_read_requests)|

## Innodb_buffer_pool_reads
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_reads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_reads)|

## Innodb_buffer_pool_resize_status
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_resize_status`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_resize_status](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_resize_status)|

## Innodb_buffer_pool_wait_free
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_wait_free`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_wait_free](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_wait_free)|

## Innodb_buffer_pool_write_requests
|name|value|
|----|-----|
|Name|`Innodb_buffer_pool_write_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_write_requests](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffer_pool_write_requests)|

## Innodb_buffered_aio_submitted
|name|value|
|----|-----|
|Name|`Innodb_buffered_aio_submitted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffered_aio_submitted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_buffered_aio_submitted)|

## Innodb_checkpoint_age
|name|value|
|----|-----|
|Name|`Innodb_checkpoint_age`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checkpoint_age](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_checkpoint_age)|

## Innodb_checkpoint_max_age
|name|value|
|----|-----|
|Name|`Innodb_checkpoint_max_age`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checkpoint_max_age](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_checkpoint_max_age)|

## Innodb_checkpoint_target_age
|name|value|
|----|-----|
|Name|`Innodb_checkpoint_target_age`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checkpoint_target_age](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_checkpoint_target_age)|

## Innodb_current_row_locks
|name|value|
|----|-----|
|Name|`Innodb_current_row_locks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_current_row_locks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_current_row_locks)|

## Innodb_data_fsyncs
|name|value|
|----|-----|
|Name|`Innodb_data_fsyncs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_fsyncs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_fsyncs)|

## Innodb_data_pending_fsyncs
|name|value|
|----|-----|
|Name|`Innodb_data_pending_fsyncs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_pending_fsyncs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_pending_fsyncs)|

## Innodb_data_pending_reads
|name|value|
|----|-----|
|Name|`Innodb_data_pending_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_pending_reads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_pending_reads)|

## Innodb_data_pending_writes
|name|value|
|----|-----|
|Name|`Innodb_data_pending_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_pending_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_pending_writes)|

## Innodb_data_read
|name|value|
|----|-----|
|Name|`Innodb_data_read`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_read](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_read)|

## Innodb_data_reads
|name|value|
|----|-----|
|Name|`Innodb_data_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_reads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_reads)|

## Innodb_data_writes
|name|value|
|----|-----|
|Name|`Innodb_data_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_writes)|

## Innodb_data_written
|name|value|
|----|-----|
|Name|`Innodb_data_written`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_data_written)|

## Innodb_dblwr_pages_written
|name|value|
|----|-----|
|Name|`Innodb_dblwr_pages_written`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_dblwr_pages_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_dblwr_pages_written)|

## Innodb_dblwr_writes
|name|value|
|----|-----|
|Name|`Innodb_dblwr_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_dblwr_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_dblwr_writes)|

## Innodb_deadlocks
|name|value|
|----|-----|
|Name|`Innodb_deadlocks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_deadlocks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_deadlocks)|

## Innodb_defragment_compression_failures
|name|value|
|----|-----|
|Name|`Innodb_defragment_compression_failures`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_compression_failures](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_defragment_compression_failures)|

## Innodb_defragment_count
|name|value|
|----|-----|
|Name|`Innodb_defragment_count`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_count](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_defragment_count)|

## Innodb_defragment_failures
|name|value|
|----|-----|
|Name|`Innodb_defragment_failures`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_failures](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_defragment_failures)|

## Innodb_dict_tables
|name|value|
|----|-----|
|Name|`Innodb_dict_tables`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_dict_tables](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_dict_tables)|

## Innodb_encryption_n_merge_blocks_decrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_merge_blocks_decrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_merge_blocks_decrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_merge_blocks_decrypted)|

## Innodb_encryption_n_merge_blocks_encrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_merge_blocks_encrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_merge_blocks_encrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_merge_blocks_encrypted)|

## Innodb_encryption_n_rowlog_blocks_decrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_rowlog_blocks_decrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_rowlog_blocks_decrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_rowlog_blocks_decrypted)|

## Innodb_encryption_n_rowlog_blocks_encrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_rowlog_blocks_encrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_rowlog_blocks_encrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_rowlog_blocks_encrypted)|

## Innodb_encryption_n_temp_blocks_decrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_temp_blocks_decrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_temp_blocks_decrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_temp_blocks_decrypted)|

## Innodb_encryption_n_temp_blocks_encrypted
|name|value|
|----|-----|
|Name|`Innodb_encryption_n_temp_blocks_encrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_n_temp_blocks_encrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_n_temp_blocks_encrypted)|

## Innodb_encryption_num_key_requests
|name|value|
|----|-----|
|Name|`Innodb_encryption_num_key_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_num_key_requests](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_num_key_requests)|

## Innodb_encryption_rotation_estimated_iops
|name|value|
|----|-----|
|Name|`Innodb_encryption_rotation_estimated_iops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_estimated_iops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_rotation_estimated_iops)|

## Innodb_encryption_rotation_pages_flushed
|name|value|
|----|-----|
|Name|`Innodb_encryption_rotation_pages_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_pages_flushed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_rotation_pages_flushed)|

## Innodb_encryption_rotation_pages_modified
|name|value|
|----|-----|
|Name|`Innodb_encryption_rotation_pages_modified`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_pages_modified](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_rotation_pages_modified)|

## Innodb_encryption_rotation_pages_read_from_cache
|name|value|
|----|-----|
|Name|`Innodb_encryption_rotation_pages_read_from_cache`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_pages_read_from_cache](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_rotation_pages_read_from_cache)|

## Innodb_encryption_rotation_pages_read_from_disk
|name|value|
|----|-----|
|Name|`Innodb_encryption_rotation_pages_read_from_disk`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_pages_read_from_disk](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_encryption_rotation_pages_read_from_disk)|

## Innodb_have_atomic_builtins
|name|value|
|----|-----|
|Name|`Innodb_have_atomic_builtins`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_atomic_builtins](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_atomic_builtins)|

## Innodb_have_bzip2
|name|value|
|----|-----|
|Name|`Innodb_have_bzip2`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_bzip2](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_bzip2)|

## Innodb_have_lz4
|name|value|
|----|-----|
|Name|`Innodb_have_lz4`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_lz4](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_lz4)|

## Innodb_have_lzma
|name|value|
|----|-----|
|Name|`Innodb_have_lzma`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_lzma](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_lzma)|

## Innodb_have_lzo
|name|value|
|----|-----|
|Name|`Innodb_have_lzo`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_lzo](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_lzo)|

## Innodb_have_punch_hole
|name|value|
|----|-----|
|Name|`Innodb_have_punch_hole`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_punch_hole](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_punch_hole)|

## Innodb_have_snappy
|name|value|
|----|-----|
|Name|`Innodb_have_snappy`|
|Type of variable|`boolean`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_have_snappy](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_have_snappy)|

## Innodb_history_list_length
|name|value|
|----|-----|
|Name|`Innodb_history_list_length`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_history_list_length](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_history_list_length)|

## Innodb_ibuf_discarded_delete_marks
|name|value|
|----|-----|
|Name|`Innodb_ibuf_discarded_delete_marks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_discarded_delete_marks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_discarded_delete_marks)|

## Innodb_ibuf_discarded_deletes
|name|value|
|----|-----|
|Name|`Innodb_ibuf_discarded_deletes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_discarded_deletes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_discarded_deletes)|

## Innodb_ibuf_discarded_inserts
|name|value|
|----|-----|
|Name|`Innodb_ibuf_discarded_inserts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_discarded_inserts](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_discarded_inserts)|

## Innodb_ibuf_free_list
|name|value|
|----|-----|
|Name|`Innodb_ibuf_free_list`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_free_list](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_free_list)|

## Innodb_ibuf_merged_delete_marks
|name|value|
|----|-----|
|Name|`Innodb_ibuf_merged_delete_marks`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_merged_delete_marks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_merged_delete_marks)|

## Innodb_ibuf_merged_deletes
|name|value|
|----|-----|
|Name|`Innodb_ibuf_merged_deletes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_merged_deletes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_merged_deletes)|

## Innodb_ibuf_merged_inserts
|name|value|
|----|-----|
|Name|`Innodb_ibuf_merged_inserts`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_merged_inserts](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_merged_inserts)|

## Innodb_ibuf_merges
|name|value|
|----|-----|
|Name|`Innodb_ibuf_merges`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_merges](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_merges)|

## Innodb_ibuf_segment_size
|name|value|
|----|-----|
|Name|`Innodb_ibuf_segment_size`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_segment_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_segment_size)|

## Innodb_ibuf_size
|name|value|
|----|-----|
|Name|`Innodb_ibuf_size`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_ibuf_size)|

## Innodb_instant_alter_column
|name|value|
|----|-----|
|Name|`Innodb_instant_alter_column`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_instant_alter_column](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_instant_alter_column)|

## Innodb_log_waits
|name|value|
|----|-----|
|Name|`Innodb_log_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_log_waits)|

## Innodb_log_write_requests
|name|value|
|----|-----|
|Name|`Innodb_log_write_requests`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_write_requests](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_log_write_requests)|

## Innodb_log_writes
|name|value|
|----|-----|
|Name|`Innodb_log_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_log_writes)|

## Innodb_lsn_current
|name|value|
|----|-----|
|Name|`Innodb_lsn_current`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lsn_current](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_lsn_current)|

## Innodb_lsn_flushed
|name|value|
|----|-----|
|Name|`Innodb_lsn_flushed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lsn_flushed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_lsn_flushed)|

## Innodb_lsn_last_checkpoint
|name|value|
|----|-----|
|Name|`Innodb_lsn_last_checkpoint`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lsn_last_checkpoint](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_lsn_last_checkpoint)|

## Innodb_master_thread_1_second_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_1_second_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_1_second_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_1_second_loops)|

## Innodb_master_thread_10_second_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_10_second_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_10_second_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_10_second_loops)|

## Innodb_master_thread_active_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_active_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_active_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_active_loops)|

## Innodb_master_thread_background_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_background_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_background_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_background_loops)|

## Innodb_master_thread_idle_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_idle_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_idle_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_idle_loops)|

## Innodb_master_thread_main_flush_loops
|name|value|
|----|-----|
|Name|`Innodb_master_thread_main_flush_loops`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_main_flush_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_main_flush_loops)|

## Innodb_master_thread_sleeps
|name|value|
|----|-----|
|Name|`Innodb_master_thread_sleeps`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_master_thread_sleeps](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_master_thread_sleeps)|

## Innodb_max_trx_id
|name|value|
|----|-----|
|Name|`Innodb_max_trx_id`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_trx_id](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_max_trx_id)|

## Innodb_mem_adaptive_hash
|name|value|
|----|-----|
|Name|`Innodb_mem_adaptive_hash`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mem_adaptive_hash](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mem_adaptive_hash)|

## Innodb_mem_dictionary
|name|value|
|----|-----|
|Name|`Innodb_mem_dictionary`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mem_dictionary](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mem_dictionary)|

## Innodb_mem_total
|name|value|
|----|-----|
|Name|`Innodb_mem_total`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mem_total](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mem_total)|

## Innodb_mutex_os_waits
|name|value|
|----|-----|
|Name|`Innodb_mutex_os_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mutex_os_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mutex_os_waits)|

## Innodb_mutex_spin_rounds
|name|value|
|----|-----|
|Name|`Innodb_mutex_spin_rounds`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mutex_spin_rounds](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mutex_spin_rounds)|

## Innodb_mutex_spin_waits
|name|value|
|----|-----|
|Name|`Innodb_mutex_spin_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mutex_spin_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_mutex_spin_waits)|

## Innodb_num_index_pages_written
|name|value|
|----|-----|
|Name|`Innodb_num_index_pages_written`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_index_pages_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_index_pages_written)|

## Innodb_num_non_index_pages_written
|name|value|
|----|-----|
|Name|`Innodb_num_non_index_pages_written`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_non_index_pages_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_non_index_pages_written)|

## Innodb_num_open_files
|name|value|
|----|-----|
|Name|`Innodb_num_open_files`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_open_files](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_open_files)|

## Innodb_num_page_compressed_trim_op
|name|value|
|----|-----|
|Name|`Innodb_num_page_compressed_trim_op`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_page_compressed_trim_op](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_page_compressed_trim_op)|

## Innodb_num_page_compressed_trim_op_saved
|name|value|
|----|-----|
|Name|`Innodb_num_page_compressed_trim_op_saved`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_page_compressed_trim_op_saved](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_page_compressed_trim_op_saved)|

## Innodb_num_pages_decrypted
|name|value|
|----|-----|
|Name|`Innodb_num_pages_decrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_decrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_decrypted)|

## Innodb_num_pages_encrypted
|name|value|
|----|-----|
|Name|`Innodb_num_pages_encrypted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_encrypted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_encrypted)|

## Innodb_num_pages_page_compressed
|name|value|
|----|-----|
|Name|`Innodb_num_pages_page_compressed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_page_compressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_page_compressed)|

## Innodb_num_pages_page_compression_error
|name|value|
|----|-----|
|Name|`Innodb_num_pages_page_compression_error`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_page_compression_error](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_page_compression_error)|

## Innodb_num_pages_page_decompressed
|name|value|
|----|-----|
|Name|`Innodb_num_pages_page_decompressed`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_page_decompressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_page_decompressed)|

## Innodb_num_pages_page_encryption_error
|name|value|
|----|-----|
|Name|`Innodb_num_pages_page_encryption_error`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_num_pages_page_encryption_error](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_num_pages_page_encryption_error)|

## Innodb_oldest_view_low_limit_trx_id
|name|value|
|----|-----|
|Name|`Innodb_oldest_view_low_limit_trx_id`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_oldest_view_low_limit_trx_id](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_oldest_view_low_limit_trx_id)|

## Innodb_onlineddl_pct_progress
|name|value|
|----|-----|
|Name|`Innodb_onlineddl_pct_progress`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_onlineddl_pct_progress](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_onlineddl_pct_progress)|

## Innodb_onlineddl_rowlog_pct_used
|name|value|
|----|-----|
|Name|`Innodb_onlineddl_rowlog_pct_used`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_onlineddl_rowlog_pct_used](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_onlineddl_rowlog_pct_used)|

## Innodb_onlineddl_rowlog_rows
|name|value|
|----|-----|
|Name|`Innodb_onlineddl_rowlog_rows`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_onlineddl_rowlog_rows](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_onlineddl_rowlog_rows)|

## Innodb_os_log_fsyncs
|name|value|
|----|-----|
|Name|`Innodb_os_log_fsyncs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_os_log_fsyncs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_os_log_fsyncs)|

## Innodb_os_log_pending_fsyncs
|name|value|
|----|-----|
|Name|`Innodb_os_log_pending_fsyncs`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_os_log_pending_fsyncs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_os_log_pending_fsyncs)|

## Innodb_os_log_pending_writes
|name|value|
|----|-----|
|Name|`Innodb_os_log_pending_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_os_log_pending_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_os_log_pending_writes)|

## Innodb_os_log_written
|name|value|
|----|-----|
|Name|`Innodb_os_log_written`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_os_log_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_os_log_written)|

## Innodb_page_compression_saved
|name|value|
|----|-----|
|Name|`Innodb_page_compression_saved`|
|Type of variable|`byte`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_saved](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_saved)|

## Innodb_page_compression_trim_sect512
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect512`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect512](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect512)|

## Innodb_page_compression_trim_sect1024
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect1024`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect1024](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect1024)|

## Innodb_page_compression_trim_sect2048
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect2048`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect2048](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect2048)|

## Innodb_page_compression_trim_sect4096
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect4096`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect4096](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect4096)|

## Innodb_page_compression_trim_sect8192
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect8192`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect8192](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect8192)|

## Innodb_page_compression_trim_sect16384
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect16384`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect16384](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect16384)|

## Innodb_page_compression_trim_sect32768
|name|value|
|----|-----|
|Name|`Innodb_page_compression_trim_sect32768`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_compression_trim_sect32768](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_compression_trim_sect32768)|

## Innodb_page_size
|name|value|
|----|-----|
|Name|`Innodb_page_size`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_page_size)|

## Innodb_pages_created
|name|value|
|----|-----|
|Name|`Innodb_pages_created`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_pages_created](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_pages_created)|

## Innodb_pages_read
|name|value|
|----|-----|
|Name|`Innodb_pages_read`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_pages_read](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_pages_read)|

## Innodb_pages0_read
|name|value|
|----|-----|
|Name|`Innodb_pages0_read`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_pages0_read](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_pages0_read)|

## Innodb_pages_written
|name|value|
|----|-----|
|Name|`Innodb_pages_written`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_pages_written](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_pages_written)|

## Innodb_purge_trx_id
|name|value|
|----|-----|
|Name|`Innodb_purge_trx_id`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_purge_trx_id](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_purge_trx_id)|

## Innodb_purge_undo_no
|name|value|
|----|-----|
|Name|`Innodb_purge_undo_no`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_purge_undo_no](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_purge_undo_no)|

## Innodb_read_views_memory
|name|value|
|----|-----|
|Name|`Innodb_read_views_memory`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_views_memory](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_read_views_memory)|

## Innodb_row_lock_current_waits
|name|value|
|----|-----|
|Name|`Innodb_row_lock_current_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_current_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_current_waits)|

## Innodb_row_lock_numbers
|name|value|
|----|-----|
|Name|`Innodb_row_lock_numbers`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_numbers](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_numbers)|

## Innodb_row_lock_time
|name|value|
|----|-----|
|Name|`Innodb_row_lock_time`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_time](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_time)|

## Innodb_row_lock_time_avg
|name|value|
|----|-----|
|Name|`Innodb_row_lock_time_avg`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_time_avg](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_time_avg)|

## Innodb_row_lock_time_max
|name|value|
|----|-----|
|Name|`Innodb_row_lock_time_max`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_time_max](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_time_max)|

## Innodb_row_lock_waits
|name|value|
|----|-----|
|Name|`Innodb_row_lock_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_row_lock_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_row_lock_waits)|

## Innodb_rows_deleted
|name|value|
|----|-----|
|Name|`Innodb_rows_deleted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rows_deleted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_rows_deleted)|

## Innodb_rows_inserted
|name|value|
|----|-----|
|Name|`Innodb_rows_inserted`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rows_inserted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_rows_inserted)|

## Innodb_rows_read
|name|value|
|----|-----|
|Name|`Innodb_rows_read`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rows_read](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_rows_read)|

## Innodb_rows_updated
|name|value|
|----|-----|
|Name|`Innodb_rows_updated`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rows_updated](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_rows_updated)|

## Innodb_s_lock_os_waits
|name|value|
|----|-----|
|Name|`Innodb_s_lock_os_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_s_lock_os_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_s_lock_os_waits)|

## Innodb_s_lock_spin_rounds
|name|value|
|----|-----|
|Name|`Innodb_s_lock_spin_rounds`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_s_lock_spin_rounds](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_s_lock_spin_rounds)|

## Innodb_s_lock_spin_waits
|name|value|
|----|-----|
|Name|`Innodb_s_lock_spin_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_s_lock_spin_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_s_lock_spin_waits)|

## Innodb_scrub_background_page_reorganizations
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_reorganizations`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_reorganizations](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_reorganizations)|

## Innodb_scrub_background_page_split_failures_missing_index
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_split_failures_missing_index`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_split_failures_missing_index](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_split_failures_missing_index)|

## Innodb_scrub_background_page_split_failures_out_of_filespace
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_split_failures_out_of_filespace`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_split_failures_out_of_filespace](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_split_failures_out_of_filespace)|

## Innodb_scrub_background_page_split_failures_underflow
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_split_failures_underflow`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_split_failures_underflow](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_split_failures_underflow)|

## Innodb_scrub_background_page_split_failures_unknown
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_split_failures_unknown`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_split_failures_unknown](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_split_failures_unknown)|

## Innodb_scrub_background_page_splits
|name|value|
|----|-----|
|Name|`Innodb_scrub_background_page_splits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_background_page_splits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_background_page_splits)|

## Innodb_scrub_log
|name|value|
|----|-----|
|Name|`Innodb_scrub_log`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_log](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_scrub_log)|

## Innodb_secondary_index_triggered_cluster_reads
|name|value|
|----|-----|
|Name|`Innodb_secondary_index_triggered_cluster_reads`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_secondary_index_triggered_cluster_reads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_secondary_index_triggered_cluster_reads)|

## Innodb_secondary_index_triggered_cluster_reads_avoided
|name|value|
|----|-----|
|Name|`Innodb_secondary_index_triggered_cluster_reads_avoided`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_secondary_index_triggered_cluster_reads_avoided](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_secondary_index_triggered_cluster_reads_avoided)|

## Innodb_system_rows_deleted
|name|value|
|----|-----|
|Name|`Innodb_system_rows_deleted`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_system_rows_deleted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_system_rows_deleted)|

## Innodb_system_rows_inserted
|name|value|
|----|-----|
|Name|`Innodb_system_rows_inserted`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_system_rows_inserted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_system_rows_inserted)|

## Innodb_system_rows_read
|name|value|
|----|-----|
|Name|`Innodb_system_rows_read`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_system_rows_read](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_system_rows_read)|

## Innodb_system_rows_updated
|name|value|
|----|-----|
|Name|`Innodb_system_rows_updated`|
|Type of variable|`integer`|
|Scope|``|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_system_rows_updated](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_system_rows_updated)|

## Innodb_truncated_status_writes
|name|value|
|----|-----|
|Name|`Innodb_truncated_status_writes`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_truncated_status_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_truncated_status_writes)|

## Innodb_undo_truncations
|name|value|
|----|-----|
|Name|`Innodb_undo_truncations`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_undo_truncations](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_undo_truncations)|

## Innodb_x_lock_os_waits
|name|value|
|----|-----|
|Name|`Innodb_x_lock_os_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_x_lock_os_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_x_lock_os_waits)|

## Innodb_x_lock_spin_rounds
|name|value|
|----|-----|
|Name|`Innodb_x_lock_spin_rounds`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_x_lock_spin_rounds](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_x_lock_spin_rounds)|

## Innodb_x_lock_spin_waits
|name|value|
|----|-----|
|Name|`Innodb_x_lock_spin_waits`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_x_lock_spin_waits](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-status-variables/#innodb_x_lock_spin_waits)|

## have_innodb
|name|value|
|----|-----|
|Name|`have_innodb`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[have_innodb](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#have_innodb)|

## ignore_builtin_innodb
|name|value|
|----|-----|
|Name|`ignore_builtin_innodb`|
|Command line|`--ignore-builtin-innodb`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[ignore_builtin_innodb](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#ignore_builtin_innodb)|

## innodb_adaptive_checkpoint
|name|value|
|----|-----|
|Name|`innodb_adaptive_checkpoint`|
|Command line|`--innodb-adaptive-checkpoint=#`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`estimate`|
|Dynamic|`true`|
|Valid value(s)|`none`, `0`, `reflex`, `1`, `estimate`, `2`, `keep_average`, `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_checkpoint](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_checkpoint)|

## innodb_adaptive_flushing
|name|value|
|----|-----|
|Name|`innodb_adaptive_flushing`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_flushing](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_flushing)|
|dev.mysql.com|[sysvar_innodb_adaptive_flushing](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_flushing)|

## innodb_adaptive_flushing_lwm
|name|value|
|----|-----|
|Name|`innodb_adaptive_flushing_lwm`|
|Command line|`--innodb-adaptive-flushing-lwm=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `70`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_flushing_lwm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_flushing_lwm)|
|dev.mysql.com|[sysvar_innodb_adaptive_flushing_lwm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_flushing_lwm)|

## innodb_adaptive_flushing_method
|name|value|
|----|-----|
|Name|`innodb_adaptive_flushing_method`|
|Command line|`innodb-adaptive-flushing-method=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`estimate`|
|Dynamic|`true`|
|Valid value(s)|`native`, `0`, `estimate`, `1`, `keep_average`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_flushing_method](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_flushing_method)|

## innodb_adaptive_hash_index
|name|value|
|----|-----|
|Name|`innodb_adaptive_hash_index`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_index](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_hash_index)|
|dev.mysql.com|[sysvar_innodb_adaptive_hash_index](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index)|

## innodb_adaptive_hash_index_partitions
|name|value|
|----|-----|
|Name|`innodb_adaptive_hash_index_partitions`|
|Command line|`innodb-adaptive-hash-index-partitions=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_index_partitions](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_hash_index_partitions)|

## innodb_adaptive_hash_index_parts
|name|value|
|----|-----|
|Name|`innodb_adaptive_hash_index_parts`|
|Command line|`--innodb-adaptive-hash-index-parts=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`false`|
|Range|from: `1` to: `512`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_hash_index_parts](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_hash_index_parts)|
|dev.mysql.com|[sysvar_innodb_adaptive_hash_index_parts](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index_parts)|

## innodb_adaptive_max_sleep_delay
|name|value|
|----|-----|
|Name|`innodb_adaptive_max_sleep_delay`|
|Command line|`--innodb-adaptive-max-sleep-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `1000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_adaptive_max_sleep_delay](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_adaptive_max_sleep_delay)|
|dev.mysql.com|[sysvar_innodb_adaptive_max_sleep_delay](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_max_sleep_delay)|

## innodb_additional_mem_pool_size
|name|value|
|----|-----|
|Name|`innodb_additional_mem_pool_size`|
|Command line|`--innodb-additional-mem-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8388608`|
|Dynamic|`false`|
|Range|from: `2097152` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_additional_mem_pool_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_additional_mem_pool_size)|

## innodb_api_bk_commit_interval
|name|value|
|----|-----|
|Name|`innodb_api_bk_commit_interval`|
|Command line|`--innodb-api-bk-commit-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `1` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_api_bk_commit_interval](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_api_bk_commit_interval)|
|dev.mysql.com|[sysvar_innodb_api_bk_commit_interval](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_api_bk_commit_interval)|

## innodb_api_disable_rowlock
|name|value|
|----|-----|
|Name|`innodb_api_disable_rowlock`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_api_disable_rowlock](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_api_disable_rowlock)|
|dev.mysql.com|[sysvar_innodb_api_disable_rowlock](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_api_disable_rowlock)|

## innodb_api_enable_binlog
|name|value|
|----|-----|
|Name|`innodb_api_enable_binlog`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_api_enable_binlog](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_api_enable_binlog)|
|dev.mysql.com|[sysvar_innodb_api_enable_binlog](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_api_enable_binlog)|

## innodb_api_enable_mdl
|name|value|
|----|-----|
|Name|`innodb_api_enable_mdl`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_api_enable_mdl](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_api_enable_mdl)|
|dev.mysql.com|[sysvar_innodb_api_enable_mdl](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_api_enable_mdl)|

## innodb_api_trx_level
|name|value|
|----|-----|
|Name|`innodb_api_trx_level`|
|Command line|`--innodb-api-trx-level=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_api_trx_level](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_api_trx_level)|
|dev.mysql.com|[sysvar_innodb_api_trx_level](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_api_trx_level)|

## innodb_auto_lru_dump
|name|value|
|----|-----|
|Name|`innodb_auto_lru_dump`|
|Command line|`--innodb-auto-lru-dump=#`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_auto_lru_dump](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_auto_lru_dump)|

## innodb_autoextend_increment
|name|value|
|----|-----|
|Name|`innodb_autoextend_increment`|
|Command line|`--innodb-autoextend-increment=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`64`|
|Dynamic|`true`|
|Range|from: `1` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_autoextend_increment](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_autoextend_increment)|
|dev.mysql.com|[sysvar_innodb_autoextend_increment](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoextend_increment)|

## innodb_autoinc_lock_mode
|name|value|
|----|-----|
|Name|`innodb_autoinc_lock_mode`|
|Command line|`--innodb-autoinc-lock-mode=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Valid value(s)|`0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_autoinc_lock_mode](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_autoinc_lock_mode)|
|dev.mysql.com|[sysvar_innodb_autoinc_lock_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_autoinc_lock_mode)|

## innodb_background_scrub_data_check_interval
|name|value|
|----|-----|
|Name|`innodb_background_scrub_data_check_interval`|
|Command line|`--innodb-background-scrub-data-check-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3600`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_background_scrub_data_check_interval](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_background_scrub_data_check_interval)|

## innodb_background_scrub_data_compressed
|name|value|
|----|-----|
|Name|`innodb_background_scrub_data_compressed`|
|Command line|`--innodb-background-scrub-data-compressed={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_background_scrub_data_compressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_background_scrub_data_compressed)|

## innodb_background_scrub_data_interval
|name|value|
|----|-----|
|Name|`innodb_background_scrub_data_interval`|
|Command line|`--innodb-background-scrub-data-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`604800`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_background_scrub_data_interval](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_background_scrub_data_interval)|

## innodb_background_scrub_data_uncompressed
|name|value|
|----|-----|
|Name|`innodb_background_scrub_data_uncompressed`|
|Command line|`--innodb-background-scrub-data-uncompressed={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_background_scrub_data_uncompressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_background_scrub_data_uncompressed)|

## innodb_blocking_buffer_pool_restore
|name|value|
|----|-----|
|Name|`innodb_blocking_buffer_pool_restore`|
|Command line|`innodb-blocking-buffer-pool-restore={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_blocking_buffer_pool_restore](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_blocking_buffer_pool_restore)|

## innodb_buf_dump_status_frequency
|name|value|
|----|-----|
|Name|`innodb_buf_dump_status_frequency`|
|Command line|`--innodb-buf-dump-status-frequency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buf_dump_status_frequency](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buf_dump_status_frequency)|

## innodb_buffer_pool_chunk_size
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_chunk_size`|
|Command line|`--innodb-buffer-pool-chunk-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`134217728`|
|Dynamic|`false`|
|Range|from: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_chunk_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_chunk_size)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_chunk_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_chunk_size)|

## innodb_buffer_pool_dump_at_shutdown
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_dump_at_shutdown`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_dump_at_shutdown](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_dump_at_shutdown)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_dump_at_shutdown](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_at_shutdown)|

## innodb_buffer_pool_dump_now
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_dump_now`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_dump_now](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_dump_now)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_dump_now](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_now)|

## innodb_buffer_pool_dump_pct
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_dump_pct`|
|Command line|`--innodb-buffer-pool-dump-pct={0|1}`|
|Scope|`global`|
|Default value|`25`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_dump_pct](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_dump_pct)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_dump_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_dump_pct)|

## innodb_buffer_pool_evict
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_evict`|
|Command line|`--innodb-buffer-pool-evict=#`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`""`|
|Dynamic|`true`|
|Valid value(s)|`""`, `"uncompressed"`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_evict](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_evict)|

## innodb_buffer_pool_filename
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_filename`|
|Command line|`--innodb-buffer-pool-pathname=path-name`|
|Scope|`global`|
|Default value|`ib_buffer_pool`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_filename](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_filename)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_filename](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_filename)|

## innodb_buffer_pool_instances
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_instances`|
|Command line|`--innodb-buffer-pool-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_instances](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_instances)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_instances](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_instances)|

## innodb_buffer_pool_load_abort
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_load_abort`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_abort](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_load_abort)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_load_abort](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_load_abort)|

## innodb_buffer_pool_load_at_startup
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_load_at_startup`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_at_startup](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_load_at_startup)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_load_at_startup](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_load_at_startup)|

## innodb_buffer_pool_load_now
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_load_now`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_now](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_load_now)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_load_now](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_load_now)|

## innodb_buffer_pool_load_pages_abort
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_load_pages_abort`|
|Command line|`--innodb-buffer-pool-load-pages-abort=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`9223372036854775807`|
|Dynamic|`true`|
|Range|from: `1` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_load_pages_abort](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_load_pages_abort)|

## innodb_buffer_pool_populate
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_populate`|
|Command line|`innodb-buffer-pool-populate={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_populate](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_populate)|

## innodb_buffer_pool_restore_at_startup
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_restore_at_startup`|
|Command line|`innodb-buffer-pool-restore-at-startup`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_restore_at_startup](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_restore_at_startup)|

## innodb_buffer_pool_shm_checksum
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_shm_checksum`|
|Command line|`innodb-buffer-pool-shm-checksum={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_shm_checksum](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_shm_checksum)|

## innodb_buffer_pool_shm_key
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_shm_key`|
|Command line|`innodb-buffer-pool-shm-key={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_shm_key](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_shm_key)|

## innodb_buffer_pool_size
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_size`|
|Command line|`--innodb-buffer-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`134217728`|
|Range|from: `5242880` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_buffer_pool_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_buffer_pool_size)|
|dev.mysql.com|[sysvar_innodb_buffer_pool_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size)|

## innodb_change_buffer_dump
|name|value|
|----|-----|
|Name|`innodb_change_buffer_dump`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_change_buffer_dump](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_change_buffer_dump)|

## innodb_change_buffer_max_size
|name|value|
|----|-----|
|Name|`innodb_change_buffer_max_size`|
|Command line|`--innodb-change-buffer-max-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`25`|
|Dynamic|`true`|
|Range|from: `0` to: `50`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_change_buffer_max_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_change_buffer_max_size)|
|dev.mysql.com|[sysvar_innodb_change_buffer_max_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffer_max_size)|

## innodb_change_buffering
|name|value|
|----|-----|
|Name|`innodb_change_buffering`|
|Command line|`--innodb-change-buffering=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`all`|
|Dynamic|`true`|
|Valid value(s)|`none`, `inserts`, `deletes`, `changes`, `purges`, `all`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_change_buffering](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_change_buffering)|
|dev.mysql.com|[sysvar_innodb_change_buffering](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering)|

## innodb_change_buffering_debug
|name|value|
|----|-----|
|Name|`innodb_change_buffering_debug`|
|Command line|`--innodb-change-buffering-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_change_buffering_debug](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_change_buffering_debug)|
|dev.mysql.com|[sysvar_innodb_change_buffering_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering_debug)|

## innodb_checkpoint_age_target
|name|value|
|----|-----|
|Name|`innodb_checkpoint_age_target`|
|Command line|`innodb-checkpoint-age-target=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `upwards`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checkpoint_age_target](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_checkpoint_age_target)|

## innodb_checksum_algorithm
|name|value|
|----|-----|
|Name|`innodb_checksum_algorithm`|
|Command line|`--innodb-checksum-algorithm=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`crc32`|
|Dynamic|`true`|
|Valid value(s)|`crc32`, `full_crc32`, `strict_crc32`, `strict_full_crc32`, `innodb`, `crc32`, `full_crc32`, `none`, `strict_innodb`, `strict_crc32`, `strict_none`, `strict_full_crc32`, `innodb`, `crc32`, `none`, `strict_innodb`, `strict_crc32`, `strict_none`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checksum_algorithm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_checksum_algorithm)|
|dev.mysql.com|[sysvar_innodb_checksum_algorithm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_checksum_algorithm)|

## innodb_checksums
|name|value|
|----|-----|
|Name|`innodb_checksums`|
|Command line|`--innodb-checksums, --skip-innodb-checksums`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_checksums](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_checksums)|

## innodb_cleaner_lsn_age_factor
|name|value|
|----|-----|
|Name|`innodb_cleaner_lsn_age_factor`|
|Command line|`--innodb-cleaner-lsn-age-factor=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`deprecated (>= MariaDB 10.2.6), high_checkpoint (<= MariaDB 10.1)`|
|Dynamic|`true`|
|Valid value(s)|`high_checkpoint`, `legacy`, `deprecated`, `high_checkpoint`, `legacy`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_cleaner_lsn_age_factor](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_cleaner_lsn_age_factor)|

## innodb_cmp_per_index_enabled
|name|value|
|----|-----|
|Name|`innodb_cmp_per_index_enabled`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_cmp_per_index_enabled](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_cmp_per_index_enabled)|
|dev.mysql.com|[sysvar_innodb_cmp_per_index_enabled](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_cmp_per_index_enabled)|

## innodb_commit_concurrency
|name|value|
|----|-----|
|Name|`innodb_commit_concurrency`|
|Command line|`--innodb-commit-concurrency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_commit_concurrency](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_commit_concurrency)|
|dev.mysql.com|[sysvar_innodb_commit_concurrency](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_commit_concurrency)|

## innodb_compression_algorithm
|name|value|
|----|-----|
|Name|`innodb_compression_algorithm`|
|Command line|`--innodb-compression-algorithm=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`zlib (>= MariaDB 10.2.4, MariaDB 10.1.22), none (<= MariaDB 10.2.3, MariaDB 10.1.21)`|
|Dynamic|`true`|
|Valid value(s)|`none`, `zlib`, `lz4`, `lzo`, `lzma`, `bzip2`, `snappy`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_compression_algorithm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_compression_algorithm)|

## innodb_compression_default
|name|value|
|----|-----|
|Name|`innodb_compression_default`|
|Command line|`--innodb-compression-default={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_compression_default](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_compression_default)|

## innodb_compression_failure_threshold_pct
|name|value|
|----|-----|
|Name|`innodb_compression_failure_threshold_pct`|
|Command line|`--innodb-compression-failure-threshold-pct=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`5`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_compression_failure_threshold_pct](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_compression_failure_threshold_pct)|
|dev.mysql.com|[sysvar_innodb_compression_failure_threshold_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_compression_failure_threshold_pct)|

## innodb_compression_level
|name|value|
|----|-----|
|Name|`innodb_compression_level`|
|Command line|`--innodb-compression-level=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`6`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_compression_level](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_compression_level)|
|dev.mysql.com|[sysvar_innodb_compression_level](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_compression_level)|

## innodb_compression_pad_pct_max
|name|value|
|----|-----|
|Name|`innodb_compression_pad_pct_max`|
|Command line|`--innodb-compression-pad-pct-max=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `0` to: `75`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_compression_pad_pct_max](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_compression_pad_pct_max)|
|dev.mysql.com|[sysvar_innodb_compression_pad_pct_max](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_compression_pad_pct_max)|

## innodb_concurrency_tickets
|name|value|
|----|-----|
|Name|`innodb_concurrency_tickets`|
|Command line|`--innodb-concurrency-tickets=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_concurrency_tickets](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_concurrency_tickets)|
|dev.mysql.com|[sysvar_innodb_concurrency_tickets](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_concurrency_tickets)|

## innodb_corrupt_table_action
|name|value|
|----|-----|
|Name|`innodb_corrupt_table_action`|
|Command line|`innodb-corrupt-table-action=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`assert (<= MariaDB 10.1), deprecated (<= MariaDB 10.2.6)`|
|Dynamic|`true`|
|Valid value(s)|`deprecated`, `assert`, `warn`, `salvage`, `assert`, `warn`, `salvage`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_corrupt_table_action](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_corrupt_table_action)|

## innodb_data_file_path
|name|value|
|----|-----|
|Name|`innodb_data_file_path`|
|Scope|`global`|
|Default value|`ibdata1:12M:autoextend`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_file_path](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_data_file_path)|
|dev.mysql.com|[sysvar_innodb_data_file_path](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_data_file_path)|

## innodb_data_home_dir
|name|value|
|----|-----|
|Name|`innodb_data_home_dir`|
|Command line|`--innodb-data-home-dir=path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_data_home_dir](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_data_home_dir)|
|dev.mysql.com|[sysvar_innodb_data_home_dir](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_data_home_dir)|

## innodb_deadlock_detect
|name|value|
|----|-----|
|Name|`innodb_deadlock_detect`|
|Command line|`--innodb-deadlock-detect[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_deadlock_detect](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_deadlock_detect)|
|dev.mysql.com|[sysvar_innodb_deadlock_detect](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_deadlock_detect)|

## innodb_deadlock_report
|name|value|
|----|-----|
|Name|`innodb_deadlock_report`|
|Command line|`--innodb-deadlock-report=val`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`full`|
|Dynamic|`true`|
|Valid value(s)|`off`, `basic`, `full`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_deadlock_report](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_deadlock_report)|

## innodb_default_page_encryption_key
|name|value|
|----|-----|
|Name|`innodb_default_page_encryption_key`|
|Command line|`--innodb-default-page-encryption-key=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `255`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_default_page_encryption_key](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_default_page_encryption_key)|

## innodb_default_encryption_key_id
|name|value|
|----|-----|
|Name|`innodb_default_encryption_key_id`|
|Command line|`--innodb-default-encryption-key-id=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_default_encryption_key_id](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_default_encryption_key_id)|

## innodb_default_row_format
|name|value|
|----|-----|
|Name|`innodb_default_row_format`|
|Command line|`--innodb-default-row-format=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`DYNAMIC`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_default_row_format](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_default_row_format)|
|dev.mysql.com|[sysvar_innodb_default_row_format](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_default_row_format)|

## innodb_defragment
|name|value|
|----|-----|
|Name|`innodb_defragment`|
|Command line|`--innodb-defragment={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment)|

## innodb_defragment_fill_factor
|name|value|
|----|-----|
|Name|`innodb_defragment_fill_factor`|
|Command line|`--innodb-defragment-fill-factor=#`|
|Scope|`global`|
|Default value|`0.9`|
|Dynamic|`true`|
|Range|from: `0.7` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_fill_factor](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment_fill_factor)|

## innodb_defragment_fill_factor_n_recs
|name|value|
|----|-----|
|Name|`innodb_defragment_fill_factor_n_recs`|
|Command line|`--innodb-defragment-fill-factor-n-recs=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_fill_factor_n_recs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment_fill_factor_n_recs)|

## innodb_defragment_frequency
|name|value|
|----|-----|
|Name|`innodb_defragment_frequency`|
|Command line|`--innodb-defragment-frequency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`40`|
|Dynamic|`true`|
|Range|from: `1` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_frequency](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment_frequency)|

## innodb_defragment_n_pages
|name|value|
|----|-----|
|Name|`innodb_defragment_n_pages`|
|Command line|`--innodb-defragment-n-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`7`|
|Dynamic|`true`|
|Range|from: `2` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_n_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment_n_pages)|

## innodb_defragment_stats_accuracy
|name|value|
|----|-----|
|Name|`innodb_defragment_stats_accuracy`|
|Command line|`--innodb-defragment-stats-accuracy=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_defragment_stats_accuracy](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_defragment_stats_accuracy)|

## innodb_dict_size_limit
|name|value|
|----|-----|
|Name|`innodb_dict_size_limit`|
|Command line|`innodb-dict-size-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_dict_size_limit](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_dict_size_limit)|

## innodb_disable_sort_file_cache
|name|value|
|----|-----|
|Name|`innodb_disable_sort_file_cache`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_disable_sort_file_cache](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_disable_sort_file_cache)|
|dev.mysql.com|[sysvar_innodb_disable_sort_file_cache](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_disable_sort_file_cache)|

## innodb_disallow_writes
|name|value|
|----|-----|
|Name|`innodb_disallow_writes`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_disallow_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_disallow_writes)|

## innodb_doublewrite
|name|value|
|----|-----|
|Name|`innodb_doublewrite`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_doublewrite](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_doublewrite)|
|dev.mysql.com|[sysvar_innodb_doublewrite](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_doublewrite)|

## innodb_doublewrite_file
|name|value|
|----|-----|
|Name|`innodb_doublewrite_file`|
|Command line|`innodb-doublewrite-file=filename`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_doublewrite_file](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_doublewrite_file)|

## innodb_empty_free_list_algorithm
|name|value|
|----|-----|
|Name|`innodb_empty_free_list_algorithm`|
|Command line|`innodb-empty-free-list-algorithm=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`deprecated (>= MariaDB 10.2.6), legacy (>= MariaDB 10.1.24), backoff (<= MariaDB 10.1.23)`|
|Dynamic|`true`|
|Valid value(s)|`deprecated`, `backoff`, `legacy`, `backoff`, `legacy`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_empty_free_list_algorithm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_empty_free_list_algorithm)|

## innodb_enable_unsafe_group_commit
|name|value|
|----|-----|
|Name|`innodb_enable_unsafe_group_commit`|
|Command line|`--innodb-enable-unsafe-group-commit`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_enable_unsafe_group_commit](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_enable_unsafe_group_commit)|

## innodb_encrypt_log
|name|value|
|----|-----|
|Name|`innodb_encrypt_log`|
|Command line|`--innodb-encrypt-log`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encrypt_log](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encrypt_log)|

## innodb_encrypt_tables
|name|value|
|----|-----|
|Name|`innodb_encrypt_tables`|
|Command line|`--innodb-encrypt-tables={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `OFF`, `FORCE`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encrypt_tables](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encrypt_tables)|

## innodb_encrypt_temporary_tables
|name|value|
|----|-----|
|Name|`innodb_encrypt_temporary_tables`|
|Command line|`--innodb-encrypt-temporary-tables={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|
|Valid value(s)|`ON`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encrypt_temporary_tables](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encrypt_temporary_tables)|

## innodb_encryption_rotate_key_age
|name|value|
|----|-----|
|Name|`innodb_encryption_rotate_key_age`|
|Command line|`--innodb-encryption-rotate-key-age=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotate_key_age](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encryption_rotate_key_age)|

## innodb_encryption_rotation_iops
|name|value|
|----|-----|
|Name|`innodb_encryption_rotation_iops`|
|Command line|`--innodb-encryption-rotation_iops=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_rotation_iops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encryption_rotation_iops)|

## innodb_encryption_threads
|name|value|
|----|-----|
|Name|`innodb_encryption_threads`|
|Command line|`--innodb-encryption-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_encryption_threads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_encryption_threads)|

## innodb_extra_rsegments
|name|value|
|----|-----|
|Name|`innodb_extra_rsegments`|
|Command line|`--innodb-extra-rsegments=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `126`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_extra_rsegments](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_extra_rsegments)|

## innodb_extra_undoslots
|name|value|
|----|-----|
|Name|`innodb_extra_undoslots`|
|Command line|`--innodb-extra-undoslots={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_extra_undoslots](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_extra_undoslots)|

## innodb_fake_changes
|name|value|
|----|-----|
|Name|`innodb_fake_changes`|
|Command line|`--innodb-fake-changes={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_fake_changes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_fake_changes)|

## innodb_fast_checksum
|name|value|
|----|-----|
|Name|`innodb_fast_checksum`|
|Command line|`--innodb-fast-checksum={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_fast_checksum](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_fast_checksum)|

## innodb_fast_shutdown
|name|value|
|----|-----|
|Name|`innodb_fast_shutdown`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Valid value(s)|`0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_fast_shutdown](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_fast_shutdown)|
|dev.mysql.com|[sysvar_innodb_fast_shutdown](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_fast_shutdown)|

## innodb_fatal_semaphore_wait_threshold
|name|value|
|----|-----|
|Name|`innodb_fatal_semaphore_wait_threshold`|
|Command line|`--innodb-fatal-semaphore-wait-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`600`|
|Dynamic|`false`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_fatal_semaphore_wait_threshold](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_fatal_semaphore_wait_threshold)|

## innodb_file_format
|name|value|
|----|-----|
|Name|`innodb_file_format`|
|Command line|`--innodb-file-format=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Barracuda (>= MariaDB 10.2.2), Antelope (<= MariaDB 10.2.1)`|
|Dynamic|`true`|
|Valid value(s)|`Antelope`, `Barracuda`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_file_format](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_file_format)|

## innodb_file_format_check
|name|value|
|----|-----|
|Name|`innodb_file_format_check`|
|Command line|`--innodb-file-format-check={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_file_format_check](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_file_format_check)|

## innodb_file_format_max
|name|value|
|----|-----|
|Name|`innodb_file_format_max`|
|Command line|`--innodb-file-format-max=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`Antelope`|
|Dynamic|`true`|
|Valid value(s)|`Antelope`, `Barracuda`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_file_format_max](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_file_format_max)|

## innodb_file_per_table
|name|value|
|----|-----|
|Name|`innodb_file_per_table`|
|Command line|`--innodb-path-per-table[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_file_per_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_file_per_table)|
|dev.mysql.com|[sysvar_innodb_file_per_table](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_file_per_table)|

## innodb_fill_factor
|name|value|
|----|-----|
|Name|`innodb_fill_factor`|
|Command line|`--innodb-fill-factor=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `10` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_fill_factor](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_fill_factor)|
|dev.mysql.com|[sysvar_innodb_fill_factor](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_fill_factor)|

## innodb_flush_log_at_timeout
|name|value|
|----|-----|
|Name|`innodb_flush_log_at_timeout`|
|Command line|`--innodb-flush-log-at-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_log_at_timeout](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_log_at_timeout)|
|dev.mysql.com|[sysvar_innodb_flush_log_at_timeout](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_log_at_timeout)|

## innodb_flush_log_at_trx_commit
|name|value|
|----|-----|
|Name|`innodb_flush_log_at_trx_commit`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Valid value(s)|`0`, `1`, `2`, `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_log_at_trx_commit](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_log_at_trx_commit)|
|dev.mysql.com|[sysvar_innodb_flush_log_at_trx_commit](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_log_at_trx_commit)|

## innodb_flush_method
|name|value|
|----|-----|
|Name|`innodb_flush_method`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_method](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_method)|
|dev.mysql.com|[sysvar_innodb_flush_method](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_method)|

## innodb_flush_neighbor_pages
|name|value|
|----|-----|
|Name|`innodb_flush_neighbor_pages`|
|Command line|`innodb-flush-neighbor-pages=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`area`|
|Dynamic|`true`|
|Valid value(s)|`none`, `0`, `area`, `1`, `cont`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_neighbor_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_neighbor_pages)|

## innodb_flush_neighbors
|name|value|
|----|-----|
|Name|`innodb_flush_neighbors`|
|Command line|`--innodb-flush-neighbors=#`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Dynamic|`true`|
|Valid value(s)|`0`, `1`, `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_neighbors](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_neighbors)|
|dev.mysql.com|[sysvar_innodb_flush_neighbors](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_neighbors)|

## innodb_flush_sync
|name|value|
|----|-----|
|Name|`innodb_flush_sync`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flush_sync](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flush_sync)|
|dev.mysql.com|[sysvar_innodb_flush_sync](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_sync)|

## innodb_flushing_avg_loops
|name|value|
|----|-----|
|Name|`innodb_flushing_avg_loops`|
|Command line|`--innodb-flushing-avg-loops=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`30`|
|Dynamic|`true`|
|Range|from: `1` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_flushing_avg_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_flushing_avg_loops)|
|dev.mysql.com|[sysvar_innodb_flushing_avg_loops](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flushing_avg_loops)|

## innodb_force_load_corrupted
|name|value|
|----|-----|
|Name|`innodb_force_load_corrupted`|
|Command line|`--innodb-force-load-corrupted[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_force_load_corrupted](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_force_load_corrupted)|
|dev.mysql.com|[sysvar_innodb_force_load_corrupted](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_force_load_corrupted)|

## innodb_force_primary_key
|name|value|
|----|-----|
|Name|`innodb_force_primary_key`|
|Command line|`--innodb-force-primary-key`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_force_primary_key](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_force_primary_key)|

## innodb_force_recovery
|name|value|
|----|-----|
|Name|`innodb_force_recovery`|
|Command line|`--innodb-force-recovery=#`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `6`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_force_recovery](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_force_recovery)|
|dev.mysql.com|[sysvar_innodb_force_recovery](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_force_recovery)|

## innodb_foreground_preflush
|name|value|
|----|-----|
|Name|`innodb_foreground_preflush`|
|Command line|`innodb-foreground-preflush=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`deprecated (>= MariaDB 10.2.6), exponential_backoff (<= MariaDB 10.1)`|
|Dynamic|`true`|
|Valid value(s)|`deprecated`, `exponential_backoff`, `sync_preflush`, `exponential_backoff`, `sync_preflush`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_foreground_preflush](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_foreground_preflush)|

## innodb_ft_aux_table
|name|value|
|----|-----|
|Name|`innodb_ft_aux_table`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_aux_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_aux_table)|
|dev.mysql.com|[sysvar_innodb_ft_aux_table](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_aux_table)|

## innodb_ft_cache_size
|name|value|
|----|-----|
|Name|`innodb_ft_cache_size`|
|Command line|`--innodb-ft-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8000000`|
|Dynamic|`false`|
|Range|from: `1600000` to: `80000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_cache_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_cache_size)|
|dev.mysql.com|[sysvar_innodb_ft_cache_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_cache_size)|

## innodb_ft_enable_diag_print
|name|value|
|----|-----|
|Name|`innodb_ft_enable_diag_print`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_enable_diag_print](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_enable_diag_print)|
|dev.mysql.com|[sysvar_innodb_ft_enable_diag_print](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_enable_diag_print)|

## innodb_ft_enable_stopword
|name|value|
|----|-----|
|Name|`innodb_ft_enable_stopword`|
|Type of variable|`boolean`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_enable_stopword](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_enable_stopword)|
|dev.mysql.com|[sysvar_innodb_ft_enable_stopword](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_enable_stopword)|

## innodb_ft_max_token_size
|name|value|
|----|-----|
|Name|`innodb_ft_max_token_size`|
|Command line|`--innodb-ft-max-token-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`84`|
|Dynamic|`false`|
|Range|from: `10`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_max_token_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_max_token_size)|
|dev.mysql.com|[sysvar_innodb_ft_max_token_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_max_token_size)|

## innodb_ft_min_token_size
|name|value|
|----|-----|
|Name|`innodb_ft_min_token_size`|
|Command line|`--innodb-ft-min-token-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3`|
|Dynamic|`false`|
|Range|from: `0` to: `16`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_min_token_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_min_token_size)|
|dev.mysql.com|[sysvar_innodb_ft_min_token_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_min_token_size)|

## innodb_ft_num_word_optimize
|name|value|
|----|-----|
|Name|`innodb_ft_num_word_optimize`|
|Command line|`--innodb-ft-num-word-optimize=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2000`|
|Dynamic|`true`|
|Range|from: `1000` to: `10000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_num_word_optimize](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_num_word_optimize)|
|dev.mysql.com|[sysvar_innodb_ft_num_word_optimize](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_num_word_optimize)|

## innodb_ft_result_cache_limit
|name|value|
|----|-----|
|Name|`innodb_ft_result_cache_limit`|
|Command line|`--innodb-ft-result-cache-limit=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2000000000`|
|Dynamic|`true`|
|Range|from: `1000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_result_cache_limit](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_result_cache_limit)|
|dev.mysql.com|[sysvar_innodb_ft_result_cache_limit](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_result_cache_limit)|

## innodb_ft_server_stopword_table
|name|value|
|----|-----|
|Name|`innodb_ft_server_stopword_table`|
|Command line|`--innodb-ft-server-stopword-table=db_name/table_name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_server_stopword_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_server_stopword_table)|
|dev.mysql.com|[sysvar_innodb_ft_server_stopword_table](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_server_stopword_table)|

## innodb_ft_sort_pll_degree
|name|value|
|----|-----|
|Name|`innodb_ft_sort_pll_degree`|
|Command line|`--innodb-ft-sort-pll-degree=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`2`|
|Dynamic|`false`|
|Range|from: `1` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_sort_pll_degree](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_sort_pll_degree)|
|dev.mysql.com|[sysvar_innodb_ft_sort_pll_degree](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_sort_pll_degree)|

## innodb_ft_total_cache_size
|name|value|
|----|-----|
|Name|`innodb_ft_total_cache_size`|
|Command line|`--innodb-ft-total-cache-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`640000000`|
|Dynamic|`false`|
|Range|from: `32000000` to: `1600000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_total_cache_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_total_cache_size)|
|dev.mysql.com|[sysvar_innodb_ft_total_cache_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_total_cache_size)|

## innodb_ft_user_stopword_table
|name|value|
|----|-----|
|Name|`innodb_ft_user_stopword_table`|
|Command line|`--innodb-ft-user-stopword-table=db_name/table_name`|
|Type of variable|`string`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ft_user_stopword_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ft_user_stopword_table)|
|dev.mysql.com|[sysvar_innodb_ft_user_stopword_table](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_user_stopword_table)|

## innodb_ibuf_accel_rate
|name|value|
|----|-----|
|Name|`innodb_ibuf_accel_rate`|
|Command line|`innodb-ibuf-accel-rate=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `100` to: `999999999`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_accel_rate](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ibuf_accel_rate)|

## innodb_ibuf_active_contract
|name|value|
|----|-----|
|Name|`innodb_ibuf_active_contract`|
|Command line|`innodb-ibuf-active-contract=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_active_contract](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ibuf_active_contract)|

## innodb_ibuf_max_size
|name|value|
|----|-----|
|Name|`innodb_ibuf_max_size`|
|Command line|`innodb-ibuf-max-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1/2 the size of the InnoDB buffer pool`|
|Dynamic|`false`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_ibuf_max_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_ibuf_max_size)|

## innodb_idle_flush_pct
|name|value|
|----|-----|
|Name|`innodb_idle_flush_pct`|
|Command line|`--innodb-idle-flush-pct=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`100`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_idle_flush_pct](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_idle_flush_pct)|
|dev.mysql.com|[sysvar_innodb_idle_flush_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_idle_flush_pct)|

## innodb_immediate_scrub_data_uncompressed
|name|value|
|----|-----|
|Name|`innodb_immediate_scrub_data_uncompressed`|
|Command line|`--innodb-immediate-scrub-data-uncompressed={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_immediate_scrub_data_uncompressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_immediate_scrub_data_uncompressed)|

## innodb_import_table_from_xtrabackup
|name|value|
|----|-----|
|Name|`innodb_import_table_from_xtrabackup`|
|Command line|`innodb-import-table-from-xtrabackup=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_import_table_from_xtrabackup](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_import_table_from_xtrabackup)|

## innodb_instant_alter_column_allowed
|name|value|
|----|-----|
|Name|`innodb_instant_alter_column_allowed`|
|Command line|`--innodb-instant-alter-column-allowed=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`<= MariaDB 10.3: add_last, >= MariaDB 10.4: add_drop_reorder`|
|Dynamic|`true`|
|Valid value(s)|`never`, `add_last`, `never`, `add_last`, `add_drop_reorder`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_instant_alter_column_allowed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_instant_alter_column_allowed)|

## innodb_instrument_semaphores
|name|value|
|----|-----|
|Name|`innodb_instrument_semaphores`|
|Command line|`--innodb-instrument-semaphores={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_instrument_semaphores](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_instrument_semaphores)|

## innodb_io_capacity
|name|value|
|----|-----|
|Name|`innodb_io_capacity`|
|Command line|`--innodb-io-capacity=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`200`|
|Dynamic|`true`|
|Range|from: `100` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_io_capacity](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_io_capacity)|
|dev.mysql.com|[sysvar_innodb_io_capacity](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_io_capacity)|

## innodb_io_capacity_max
|name|value|
|----|-----|
|Name|`innodb_io_capacity_max`|
|Command line|`--innodb-io-capacity-max=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_io_capacity_max](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_io_capacity_max)|
|dev.mysql.com|[sysvar_innodb_io_capacity_max](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_io_capacity_max)|

## innodb_kill_idle_transaction
|name|value|
|----|-----|
|Name|`innodb_kill_idle_transaction`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `9.2233720368548E+18`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_kill_idle_transaction](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_kill_idle_transaction)|

## innodb_large_prefix
|name|value|
|----|-----|
|Name|`innodb_large_prefix`|
|Command line|`--innodb-large-prefix`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON (>= MariaDB 10.2.2), OFF (<= MariaDB 10.2.1)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_large_prefix](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_large_prefix)|

## innodb_lazy_drop_table
|name|value|
|----|-----|
|Name|`innodb_lazy_drop_table`|
|Command line|`innodb-lazy-drop-table={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lazy_drop_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_lazy_drop_table)|

## innodb_lock_schedule_algorithm
|name|value|
|----|-----|
|Name|`innodb_lock_schedule_algorithm`|
|Command line|`--innodb-lock-schedule-algorithm=#`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`FCFS (MariaDB 10.3.9, MariaDB 10.2.17), VATS (MariaDB 10.2.3), FCFS (MariaDB 10.1)`|
|Dynamic|`false`|
|Valid value(s)|`FCFS`, `VATS`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lock_schedule_algorithm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_lock_schedule_algorithm)|

## innodb_lock_wait_timeout
|name|value|
|----|-----|
|Name|`innodb_lock_wait_timeout`|
|Command line|`--innodb-lock-wait-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`50`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lock_wait_timeout](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_lock_wait_timeout)|
|dev.mysql.com|[sysvar_innodb_lock_wait_timeout](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_lock_wait_timeout)|

## innodb_locking_fake_changes
|name|value|
|----|-----|
|Name|`innodb_locking_fake_changes`|
|Command line|`--innodb-locking-fake-changes`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_locking_fake_changes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_locking_fake_changes)|

## innodb_locks_unsafe_for_binlog
|name|value|
|----|-----|
|Name|`innodb_locks_unsafe_for_binlog`|
|Command line|`--innodb-locks-unsafe-for-binlog`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_locks_unsafe_for_binlog](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_locks_unsafe_for_binlog)|

## innodb_log_arch_dir
|name|value|
|----|-----|
|Name|`innodb_log_arch_dir`|
|Command line|`--innodb-log-arch-dir=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`./`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_arch_dir](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_arch_dir)|

## innodb_log_arch_expire_sec
|name|value|
|----|-----|
|Name|`innodb_log_arch_expire_sec`|
|Command line|`--innodb-log-arch-expire-sec=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_arch_expire_sec](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_arch_expire_sec)|

## innodb_log_archive
|name|value|
|----|-----|
|Name|`innodb_log_archive`|
|Command line|`--innodb-log-archive={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_archive](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_archive)|

## innodb_log_block_size
|name|value|
|----|-----|
|Name|`innodb_log_block_size`|
|Command line|`innodb-log-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`512`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_block_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_block_size)|

## innodb_log_buffer_size
|name|value|
|----|-----|
|Name|`innodb_log_buffer_size`|
|Command line|`--innodb-log-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`16777216`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_buffer_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_buffer_size)|
|dev.mysql.com|[sysvar_innodb_log_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_buffer_size)|

## innodb_log_checksum_algorithm
|name|value|
|----|-----|
|Name|`innodb_log_checksum_algorithm`|
|Command line|`innodb-log-checksum-algorithm=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`deprecated (>= MariaDB 10.2.6), innodb (<= MariaDB 10.1)`|
|Dynamic|`true`|
|Valid value(s)|`deprecated`, `innodb`, `none`, `crc32`, `strict_none`, `strict_innodb`, `strict_crc32`, `innodb`, `none`, `crc32`, `strict_none`, `strict_innodb`, `strict_crc32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_checksum_algorithm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_checksum_algorithm)|

## innodb_log_checksums
|name|value|
|----|-----|
|Name|`innodb_log_checksums`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_checksums](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_checksums)|
|dev.mysql.com|[sysvar_innodb_log_checksums](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_checksums)|

## innodb_log_compressed_pages
|name|value|
|----|-----|
|Name|`innodb_log_compressed_pages`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_compressed_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_compressed_pages)|
|dev.mysql.com|[sysvar_innodb_log_compressed_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_compressed_pages)|

## innodb_log_file_size
|name|value|
|----|-----|
|Name|`innodb_log_file_size`|
|Command line|`--innodb-log-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_file_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_file_size)|
|dev.mysql.com|[sysvar_innodb_log_file_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_file_size)|

## innodb_log_files_in_group
|name|value|
|----|-----|
|Name|`innodb_log_files_in_group`|
|Command line|`--innodb-log-files-in-group=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_files_in_group](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_files_in_group)|
|dev.mysql.com|[sysvar_innodb_log_files_in_group](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_files_in_group)|

## innodb_log_group_home_dir
|name|value|
|----|-----|
|Name|`innodb_log_group_home_dir`|
|Command line|`--innodb-log-group-home-dir=path`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_group_home_dir](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_group_home_dir)|
|dev.mysql.com|[sysvar_innodb_log_group_home_dir](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_group_home_dir)|

## innodb_log_optimize_ddl
|name|value|
|----|-----|
|Name|`innodb_log_optimize_ddl`|
|Command line|`--innodb-log-optimize-ddl={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF (>= MariaDB 10.5.1, MariaDB 10.4.16, MariaDB 10.3.26, MariaDB 10.2.35), ON (<= MariaDB 10.5.0, MariaDB 10.4.15, MariaDB 10.3.25, MariaDB 10.2.34)`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_optimize_ddl](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_optimize_ddl)|

## innodb_log_write_ahead_size
|name|value|
|----|-----|
|Name|`innodb_log_write_ahead_size`|
|Command line|`--innodb-log-write-ahead-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8192`|
|Dynamic|`true`|
|Range|from: `512`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_log_write_ahead_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_log_write_ahead_size)|
|dev.mysql.com|[sysvar_innodb_log_write_ahead_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_write_ahead_size)|

## innodb_lru_flush_size
|name|value|
|----|-----|
|Name|`innodb_lru_flush_size`|
|Command line|`--innodb-lru-flush-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32`|
|Dynamic|`true`|
|Range|from: `1` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lru_flush_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_lru_flush_size)|

## innodb_lru_scan_depth
|name|value|
|----|-----|
|Name|`innodb_lru_scan_depth`|
|Command line|`--innodb-lru-scan-depth=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_lru_scan_depth](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_lru_scan_depth)|
|dev.mysql.com|[sysvar_innodb_lru_scan_depth](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_lru_scan_depth)|

## innodb_max_bitmap_file_size
|name|value|
|----|-----|
|Name|`innodb_max_bitmap_file_size`|
|Command line|`innodb-max-bitmap-file-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4096 (4KB)`|
|Dynamic|`true`|
|Range|from: `4096` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_bitmap_file_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_bitmap_file_size)|

## innodb_max_changed_pages
|name|value|
|----|-----|
|Name|`innodb_max_changed_pages`|
|Command line|`innodb-max-changed-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000000`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_changed_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_changed_pages)|

## innodb_max_dirty_pages_pct
|name|value|
|----|-----|
|Name|`innodb_max_dirty_pages_pct`|
|Command line|`--innodb-max-dirty-pages-pct=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`90`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_dirty_pages_pct](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_dirty_pages_pct)|
|dev.mysql.com|[sysvar_innodb_max_dirty_pages_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_max_dirty_pages_pct)|

## innodb_max_dirty_pages_pct_lwm
|name|value|
|----|-----|
|Name|`innodb_max_dirty_pages_pct_lwm`|
|Command line|`--innodb-max-dirty-pages-pct-lwm=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_dirty_pages_pct_lwm](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_dirty_pages_pct_lwm)|
|dev.mysql.com|[sysvar_innodb_max_dirty_pages_pct_lwm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_max_dirty_pages_pct_lwm)|

## innodb_max_purge_lag
|name|value|
|----|-----|
|Name|`innodb_max_purge_lag`|
|Command line|`--innodb-max-purge-lag=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_purge_lag](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_purge_lag)|
|dev.mysql.com|[sysvar_innodb_max_purge_lag](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_max_purge_lag)|

## innodb_max_purge_lag_delay
|name|value|
|----|-----|
|Name|`innodb_max_purge_lag_delay`|
|Command line|`--innodb-max-purge-lag-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `10000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_purge_lag_delay](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_purge_lag_delay)|
|dev.mysql.com|[sysvar_innodb_max_purge_lag_delay](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_max_purge_lag_delay)|

## innodb_max_purge_lag_wait
|name|value|
|----|-----|
|Name|`innodb_max_purge_lag_wait`|
|Command line|`--innodb-max-purge-wait=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4294967295`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_purge_lag_wait](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_purge_lag_wait)|

## innodb_max_undo_log_size
|name|value|
|----|-----|
|Name|`innodb_max_undo_log_size`|
|Command line|`--innodb-max-undo-log-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `10485760`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_max_undo_log_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_max_undo_log_size)|
|dev.mysql.com|[sysvar_innodb_max_undo_log_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_max_undo_log_size)|

## innodb_merge_sort_block_size
|name|value|
|----|-----|
|Name|`innodb_merge_sort_block_size`|
|Command line|`innodb-merge-sort-block-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1048576 (1M)`|
|Dynamic|`true`|
|Range|from: `1048576` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_merge_sort_block_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_merge_sort_block_size)|

## innodb_mirrored_log_groups
|name|value|
|----|-----|
|Name|`innodb_mirrored_log_groups`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mirrored_log_groups](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_mirrored_log_groups)|

## innodb_mtflush_threads
|name|value|
|----|-----|
|Name|`innodb_mtflush_threads`|
|Command line|`--innodb-mtflush-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_mtflush_threads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_mtflush_threads)|

## innodb_monitor_disable
|name|value|
|----|-----|
|Name|`innodb_monitor_disable`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_monitor_disable](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_monitor_disable)|
|dev.mysql.com|[sysvar_innodb_monitor_disable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_monitor_disable)|

## innodb_monitor_enable
|name|value|
|----|-----|
|Name|`innodb_monitor_enable`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_monitor_enable](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_monitor_enable)|
|dev.mysql.com|[sysvar_innodb_monitor_enable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_monitor_enable)|

## innodb_monitor_reset
|name|value|
|----|-----|
|Name|`innodb_monitor_reset`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|
|Valid value(s)|`counter`, `module`, `pattern`, `all`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_monitor_reset](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_monitor_reset)|
|dev.mysql.com|[sysvar_innodb_monitor_reset](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_monitor_reset)|

## innodb_monitor_reset_all
|name|value|
|----|-----|
|Name|`innodb_monitor_reset_all`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|
|Valid value(s)|`counter`, `module`, `pattern`, `all`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_monitor_reset_all](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_monitor_reset_all)|
|dev.mysql.com|[sysvar_innodb_monitor_reset_all](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_monitor_reset_all)|

## innodb_numa_interleave
|name|value|
|----|-----|
|Name|`innodb_numa_interleave`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_numa_interleave](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_numa_interleave)|
|dev.mysql.com|[sysvar_innodb_numa_interleave](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave)|

## innodb_old_blocks_pct
|name|value|
|----|-----|
|Name|`innodb_old_blocks_pct`|
|Command line|`--innodb-old-blocks-pct=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`37`|
|Dynamic|`true`|
|Range|from: `5` to: `95`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_old_blocks_pct](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_old_blocks_pct)|
|dev.mysql.com|[sysvar_innodb_old_blocks_pct](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_old_blocks_pct)|

## innodb_old_blocks_time
|name|value|
|----|-----|
|Name|`innodb_old_blocks_time`|
|Command line|`--innodb-old-blocks-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_old_blocks_time](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_old_blocks_time)|
|dev.mysql.com|[sysvar_innodb_old_blocks_time](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_old_blocks_time)|

## innodb_online_alter_log_max_size
|name|value|
|----|-----|
|Name|`innodb_online_alter_log_max_size`|
|Command line|`--innodb-online-alter-log-max-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`134217728`|
|Dynamic|`true`|
|Range|from: `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_online_alter_log_max_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_online_alter_log_max_size)|
|dev.mysql.com|[sysvar_innodb_online_alter_log_max_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size)|

## innodb_open_files
|name|value|
|----|-----|
|Name|`innodb_open_files`|
|Command line|`--innodb-open-files=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`(-1 signifies autosizing; do not use -1)`|
|Range|from: `10`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_open_files](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_open_files)|
|dev.mysql.com|[sysvar_innodb_open_files](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_open_files)|

## innodb_optimize_fulltext_only
|name|value|
|----|-----|
|Name|`innodb_optimize_fulltext_only`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_optimize_fulltext_only](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_optimize_fulltext_only)|
|dev.mysql.com|[sysvar_innodb_optimize_fulltext_only](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_optimize_fulltext_only)|

## innodb_page_cleaners
|name|value|
|----|-----|
|Name|`innodb_page_cleaners`|
|Command line|`--innodb-page-cleaners=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_cleaners](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_page_cleaners)|
|dev.mysql.com|[sysvar_innodb_page_cleaners](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_page_cleaners)|

## innodb_page_size
|name|value|
|----|-----|
|Name|`innodb_page_size`|
|Command line|`--innodb-page-size=#`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`16384`|
|Dynamic|`false`|
|Valid value(s)|`4096`, `8192`, `16384`, `32768`, `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_page_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_page_size)|
|dev.mysql.com|[sysvar_innodb_page_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_page_size)|

## innodb_pass_corrupt_table
|name|value|
|----|-----|
|Name|`innodb_pass_corrupt_table`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_pass_corrupt_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_pass_corrupt_table)|

## innodb_prefix_index_cluster_optimization
|name|value|
|----|-----|
|Name|`innodb_prefix_index_cluster_optimization`|
|Command line|`--innodb-prefix-index-cluster-optimization={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_prefix_index_cluster_optimization](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_prefix_index_cluster_optimization)|

## innodb_print_all_deadlocks
|name|value|
|----|-----|
|Name|`innodb_print_all_deadlocks`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_print_all_deadlocks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_print_all_deadlocks)|
|dev.mysql.com|[sysvar_innodb_print_all_deadlocks](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_print_all_deadlocks)|

## innodb_purge_batch_size
|name|value|
|----|-----|
|Name|`innodb_purge_batch_size`|
|Command line|`--innodb-purge-batch-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Range|from: `1` to: `5000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_purge_batch_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_purge_batch_size)|
|dev.mysql.com|[sysvar_innodb_purge_batch_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_purge_batch_size)|

## innodb_purge_rseg_truncate_frequency
|name|value|
|----|-----|
|Name|`innodb_purge_rseg_truncate_frequency`|
|Command line|`--innodb-purge-rseg-truncate-frequency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`128`|
|Dynamic|`true`|
|Range|from: `1` to: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_purge_rseg_truncate_frequency](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_purge_rseg_truncate_frequency)|
|dev.mysql.com|[sysvar_innodb_purge_rseg_truncate_frequency](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_purge_rseg_truncate_frequency)|

## innodb_purge_threads
|name|value|
|----|-----|
|Name|`innodb_purge_threads`|
|Command line|`--innodb-purge-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4`|
|Dynamic|`false`|
|Range|from: `1` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_purge_threads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_purge_threads)|
|dev.mysql.com|[sysvar_innodb_purge_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_purge_threads)|

## innodb_random_read_ahead
|name|value|
|----|-----|
|Name|`innodb_random_read_ahead`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_random_read_ahead](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_random_read_ahead)|
|dev.mysql.com|[sysvar_innodb_random_read_ahead](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_random_read_ahead)|

## innodb_read_ahead
|name|value|
|----|-----|
|Name|`innodb_read_ahead`|
|Command line|`innodb-read-ahead=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`linear`|
|Dynamic|`true`|
|Valid value(s)|`none`, `random`, `linear`, `both`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_ahead](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_read_ahead)|

## innodb_read_ahead_threshold
|name|value|
|----|-----|
|Name|`innodb_read_ahead_threshold`|
|Command line|`--innodb-read-ahead-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`56`|
|Dynamic|`true`|
|Range|from: `0` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_ahead_threshold](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_read_ahead_threshold)|
|dev.mysql.com|[sysvar_innodb_read_ahead_threshold](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_read_ahead_threshold)|

## innodb_read_io_threads
|name|value|
|----|-----|
|Name|`innodb_read_io_threads`|
|Command line|`--innodb-read-io-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_io_threads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_read_io_threads)|
|dev.mysql.com|[sysvar_innodb_read_io_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_read_io_threads)|

## innodb_read_only
|name|value|
|----|-----|
|Name|`innodb_read_only`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_only](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_read_only)|
|dev.mysql.com|[sysvar_innodb_read_only](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_read_only)|

## innodb_read_only_compressed
|name|value|
|----|-----|
|Name|`innodb_read_only_compressed`|
|Command line|`--innodb-read-only-compressed, --skip-innodb-read-only-compressed`|
|Type of variable|`boolean`|
|Scope|``|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_read_only_compressed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_read_only_compressed)|

## innodb_recovery_stats
|name|value|
|----|-----|
|Name|`innodb_recovery_stats`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_recovery_stats](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_recovery_stats)|

## innodb_recovery_update_relay_log
|name|value|
|----|-----|
|Name|`innodb_recovery_update_relay_log`|
|Command line|`innodb-recovery-update-relay-log={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_recovery_update_relay_log](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_recovery_update_relay_log)|

## innodb_replication_delay
|name|value|
|----|-----|
|Name|`innodb_replication_delay`|
|Command line|`--innodb-replication-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_replication_delay](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_replication_delay)|
|dev.mysql.com|[sysvar_innodb_replication_delay](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_replication_delay)|

## innodb_rollback_on_timeout
|name|value|
|----|-----|
|Name|`innodb_rollback_on_timeout`|
|Command line|`--innodb-rollback-on-timeout[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rollback_on_timeout](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_rollback_on_timeout)|
|dev.mysql.com|[sysvar_innodb_rollback_on_timeout](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_on_timeout)|

## innodb_rollback_segments
|name|value|
|----|-----|
|Name|`innodb_rollback_segments`|
|Command line|`--innodb-rollback-segments=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`128`|
|Dynamic|`true`|
|Range|from: `1` to: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_rollback_segments](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_rollback_segments)|
|dev.mysql.com|[sysvar_innodb_rollback_segments](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_rollback_segments)|

## innodb_safe_truncate
|name|value|
|----|-----|
|Name|`innodb_safe_truncate`|
|Command line|`--innodb-safe-truncate={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_safe_truncate](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_safe_truncate)|

## innodb_scrub_log
|name|value|
|----|-----|
|Name|`innodb_scrub_log`|
|Command line|`--innodb-scrub-log`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_log](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_scrub_log)|

## innodb_scrub_log_interval
|name|value|
|----|-----|
|Name|`innodb_scrub_log_interval`|
|Command line|`--innodb-scrub-log-interval=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`56`|
|Dynamic|`true`|
|Range|from: `0` to: `50000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_log_interval](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_scrub_log_interval)|

## innodb_scrub_log_speed
|name|value|
|----|-----|
|Name|`innodb_scrub_log_speed`|
|Command line|`--innodb-scrub-log-speed=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`256`|
|Dynamic|`true`|
|Range|from: `1` to: `50000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_scrub_log_speed](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_scrub_log_speed)|

## innodb_sched_priority_cleaner
|name|value|
|----|-----|
|Name|`innodb_sched_priority_cleaner`|
|Command line|`innodb-sched-priority-cleaner=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`19`|
|Dynamic|`true`|
|Range|from: `0` to: `39`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_sched_priority_cleaner](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_sched_priority_cleaner)|

## innodb_show_locks_held
|name|value|
|----|-----|
|Name|`innodb_show_locks_held`|
|Command line|`innodb-show-locks-held=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_show_locks_held](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_show_locks_held)|

## innodb_show_verbose_locks
|name|value|
|----|-----|
|Name|`innodb_show_verbose_locks`|
|Command line|`innodb-show-verbose-locks=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_show_verbose_locks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_show_verbose_locks)|

## innodb_simulate_comp_failures
|name|value|
|----|-----|
|Name|`innodb_simulate_comp_failures`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `99`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_simulate_comp_failures](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_simulate_comp_failures)|

## innodb_sort_buffer_size
|name|value|
|----|-----|
|Name|`innodb_sort_buffer_size`|
|Command line|`--innodb-sort-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1048576`|
|Dynamic|`false`|
|Range|from: `65536` to: `67108864`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_sort_buffer_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_sort_buffer_size)|
|dev.mysql.com|[sysvar_innodb_sort_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sort_buffer_size)|

## innodb_spin_wait_delay
|name|value|
|----|-----|
|Name|`innodb_spin_wait_delay`|
|Command line|`--innodb-spin-wait-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_spin_wait_delay](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_spin_wait_delay)|
|dev.mysql.com|[sysvar_innodb_spin_wait_delay](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_spin_wait_delay)|

## innodb_stats_auto_recalc
|name|value|
|----|-----|
|Name|`innodb_stats_auto_recalc`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_auto_recalc](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_auto_recalc)|
|dev.mysql.com|[sysvar_innodb_stats_auto_recalc](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_auto_recalc)|

## innodb_stats_auto_update
|name|value|
|----|-----|
|Name|`innodb_stats_auto_update`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_auto_update](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_auto_update)|

## innodb_stats_include_delete_marked
|name|value|
|----|-----|
|Name|`innodb_stats_include_delete_marked`|
|Command line|`--innodb-stats-include-delete-marked[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_include_delete_marked](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_include_delete_marked)|
|dev.mysql.com|[sysvar_innodb_stats_include_delete_marked](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_include_delete_marked)|

## innodb_stats_method
|name|value|
|----|-----|
|Name|`innodb_stats_method`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`nulls_equal`|
|Dynamic|`true`|
|Valid value(s)|`nulls_equal`, `nulls_unequal`, `nulls_ignored`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_method](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_method)|
|dev.mysql.com|[sysvar_innodb_stats_method](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_method)|

## innodb_stats_modified_counter
|name|value|
|----|-----|
|Name|`innodb_stats_modified_counter`|
|Command line|`--innodb-stats-modified-counter=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_modified_counter](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_modified_counter)|

## innodb_stats_on_metadata
|name|value|
|----|-----|
|Name|`innodb_stats_on_metadata`|
|Command line|`--innodb-stats-on-metadata[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_on_metadata](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_on_metadata)|
|dev.mysql.com|[sysvar_innodb_stats_on_metadata](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_on_metadata)|

## innodb_stats_persistent
|name|value|
|----|-----|
|Name|`innodb_stats_persistent`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_persistent](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_persistent)|
|dev.mysql.com|[sysvar_innodb_stats_persistent](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent)|

## innodb_stats_persistent_sample_pages
|name|value|
|----|-----|
|Name|`innodb_stats_persistent_sample_pages`|
|Command line|`--innodb-stats-persistent-sample-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`true`|
|Range|from: `1` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_persistent_sample_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_persistent_sample_pages)|
|dev.mysql.com|[sysvar_innodb_stats_persistent_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_persistent_sample_pages)|

## innodb_stats_sample_pages
|name|value|
|----|-----|
|Name|`innodb_stats_sample_pages`|
|Command line|`--innodb-stats-sample-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`true`|
|Range|from: `1` to: `264`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_sample_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_sample_pages)|

## innodb_stats_traditional
|name|value|
|----|-----|
|Name|`innodb_stats_traditional`|
|Command line|`--innodb-stats-traditional={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_traditional](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_traditional)|

## innodb_stats_transient_sample_pages
|name|value|
|----|-----|
|Name|`innodb_stats_transient_sample_pages`|
|Command line|`--innodb-stats-transient-sample-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_transient_sample_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_transient_sample_pages)|
|dev.mysql.com|[sysvar_innodb_stats_transient_sample_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_stats_transient_sample_pages)|

## innodb_stats_update_need_lock
|name|value|
|----|-----|
|Name|`innodb_stats_update_need_lock`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_stats_update_need_lock](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_stats_update_need_lock)|

## innodb_status_output
|name|value|
|----|-----|
|Name|`innodb_status_output`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_status_output](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_status_output)|
|dev.mysql.com|[sysvar_innodb_status_output](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_status_output)|

## innodb_status_output_locks
|name|value|
|----|-----|
|Name|`innodb_status_output_locks`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_status_output_locks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_status_output_locks)|
|dev.mysql.com|[sysvar_innodb_status_output_locks](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_status_output_locks)|

## innodb_strict_mode
|name|value|
|----|-----|
|Name|`innodb_strict_mode`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_strict_mode](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_strict_mode)|
|dev.mysql.com|[sysvar_innodb_strict_mode](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode)|

## innodb_support_xa
|name|value|
|----|-----|
|Name|`innodb_support_xa`|
|Command line|`--innodb-support-xa`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_support_xa](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_support_xa)|

## innodb_sync_array_size
|name|value|
|----|-----|
|Name|`innodb_sync_array_size`|
|Command line|`--innodb-sync-array-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `1` to: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_sync_array_size](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_sync_array_size)|
|dev.mysql.com|[sysvar_innodb_sync_array_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sync_array_size)|

## innodb_sync_spin_loops
|name|value|
|----|-----|
|Name|`innodb_sync_spin_loops`|
|Command line|`--innodb-sync-spin-loops=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`30`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_sync_spin_loops](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_sync_spin_loops)|
|dev.mysql.com|[sysvar_innodb_sync_spin_loops](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sync_spin_loops)|

## innodb_table_locks
|name|value|
|----|-----|
|Name|`innodb_table_locks`|
|Command line|`--innodb-table-locks[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_table_locks](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_table_locks)|
|dev.mysql.com|[sysvar_innodb_table_locks](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_table_locks)|

## innodb_thread_concurrency
|name|value|
|----|-----|
|Name|`innodb_thread_concurrency`|
|Command line|`--innodb-thread-concurrency=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_thread_concurrency](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_thread_concurrency)|
|dev.mysql.com|[sysvar_innodb_thread_concurrency](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_thread_concurrency)|

## innodb_thread_concurrency_timer_based
|name|value|
|----|-----|
|Name|`innodb_thread_concurrency_timer_based`|
|Command line|`innodb-thread-concurrency-timer-based={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_thread_concurrency_timer_based](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_thread_concurrency_timer_based)|

## innodb_thread_sleep_delay
|name|value|
|----|-----|
|Name|`innodb_thread_sleep_delay`|
|Command line|`--innodb-thread-sleep-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `1000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_thread_sleep_delay](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_thread_sleep_delay)|
|dev.mysql.com|[sysvar_innodb_thread_sleep_delay](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_thread_sleep_delay)|

## innodb_temp_data_file_path
|name|value|
|----|-----|
|Name|`innodb_temp_data_file_path`|
|Command line|`--innodb-temp-data-path-path=path-name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`ibtmp1:12M:autoextend`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_temp_data_file_path](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_temp_data_file_path)|
|dev.mysql.com|[sysvar_innodb_temp_data_file_path](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_temp_data_file_path)|

## innodb_tmpdir
|name|value|
|----|-----|
|Name|`innodb_tmpdir`|
|Command line|`--innodb-tmpdir=path`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_tmpdir](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_tmpdir)|
|dev.mysql.com|[sysvar_innodb_tmpdir](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_tmpdir)|

## innodb_track_changed_pages
|name|value|
|----|-----|
|Name|`innodb_track_changed_pages`|
|Command line|`innodb-track-changed-pages={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_track_changed_pages](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_track_changed_pages)|

## innodb_track_redo_log_now
|name|value|
|----|-----|
|Name|`innodb_track_redo_log_now`|
|Command line|`innodb-track-redo-log-now={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_track_redo_log_now](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_track_redo_log_now)|

## innodb_undo_directory
|name|value|
|----|-----|
|Name|`innodb_undo_directory`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_undo_directory](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_undo_directory)|
|dev.mysql.com|[sysvar_innodb_undo_directory](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_directory)|

## innodb_undo_log_truncate
|name|value|
|----|-----|
|Name|`innodb_undo_log_truncate`|
|Type of variable|`boolean`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_undo_log_truncate](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_undo_log_truncate)|
|dev.mysql.com|[sysvar_innodb_undo_log_truncate](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_truncate)|

## innodb_undo_logs
|name|value|
|----|-----|
|Name|`innodb_undo_logs`|
|Command line|`--innodb-undo-logs=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`128`|
|Dynamic|`true`|
|Range|from: `0` to: `128`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_undo_logs](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_undo_logs)|

## innodb_undo_tablespaces
|name|value|
|----|-----|
|Name|`innodb_undo_tablespaces`|
|Command line|`--innodb-undo-tablespaces=#`|
|Type of variable|`integer`|
|Scope|`global`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_undo_tablespaces](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_undo_tablespaces)|
|dev.mysql.com|[sysvar_innodb_undo_tablespaces](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_tablespaces)|

## innodb_use_atomic_writes
|name|value|
|----|-----|
|Name|`innodb_use_atomic_writes`|
|Command line|`innodb-use-atomic-writes={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON (>= MariaDB 10.2.4), OFF (<= MariaDB 10.2.3)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_atomic_writes](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_atomic_writes)|

## innodb_use_fallocate
|name|value|
|----|-----|
|Name|`innodb_use_fallocate`|
|Command line|`innodb-use-fallocate={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_fallocate](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_fallocate)|

## innodb_use_global_flush_log_at_trx_commit
|name|value|
|----|-----|
|Name|`innodb_use_global_flush_log_at_trx_commit`|
|Command line|`innodb-use-global-flush-log-at-trx_commit={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_global_flush_log_at_trx_commit](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_global_flush_log_at_trx_commit)|

## innodb_use_mtflush
|name|value|
|----|-----|
|Name|`innodb_use_mtflush`|
|Command line|`--innodb-use-mtflush={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_mtflush](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_mtflush)|

## innodb_use_native_aio
|name|value|
|----|-----|
|Name|`innodb_use_native_aio`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_native_aio](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_native_aio)|
|dev.mysql.com|[sysvar_innodb_use_native_aio](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_use_native_aio)|

## innodb_use_purge_thread
|name|value|
|----|-----|
|Name|`innodb_use_purge_thread`|
|Command line|`--innodb-use-purge-thread=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `0` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_purge_thread](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_purge_thread)|

## innodb_use_stacktrace
|name|value|
|----|-----|
|Name|`innodb_use_stacktrace`|
|Command line|`--innodb-use-stacktrace={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_stacktrace](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_stacktrace)|

## innodb_use_sys_malloc
|name|value|
|----|-----|
|Name|`innodb_use_sys_malloc`|
|Command line|`--innodb-use-sys-malloc={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_sys_malloc](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_sys_malloc)|

## innodb_use_sys_stats_table
|name|value|
|----|-----|
|Name|`innodb_use_sys_stats_table`|
|Command line|`innodb-use-sys-stats-table={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_sys_stats_table](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_sys_stats_table)|

## innodb_use_trim
|name|value|
|----|-----|
|Name|`innodb_use_trim`|
|Command line|`--innodb-use-trim={0|1}`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON (>= MariaDB 10.2.4), OFF (<= MariaDB 10.2.3)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_use_trim](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_use_trim)|

## innodb_version
|name|value|
|----|-----|
|Name|`innodb_version`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_version](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_version)|

## innodb_write_io_threads
|name|value|
|----|-----|
|Name|`innodb_write_io_threads`|
|Command line|`--innodb-write-io-threads=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`4`|
|Dynamic|`false`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|mariadb.com|[innodb_write_io_threads](https://mariadb.com/kb/en/library/documentation/xtradbinnodb-server-system-variables/#innodb_write_io_threads)|
|dev.mysql.com|[sysvar_innodb_write_io_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_write_io_threads)|

## audit_log
|name|value|
|----|-----|
|Name|`audit_log`|
|Command line|`--audit-log[=value]`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`ON`, `OFF`, `FORCE`, `FORCE_PLUS_PERMANENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_audit-log](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#option_mysqld_audit-log)|

## audit_log_buffer_size
|name|value|
|----|-----|
|Name|`audit_log_buffer_size`|
|Command line|`--audit-log-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1048576`|
|Dynamic|`false`|
|Range|from: `4096`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_buffer_size)|

## audit_log_compression
|name|value|
|----|-----|
|Name|`audit_log_compression`|
|Command line|`--audit-log-compression=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE`|
|Dynamic|`false`|
|Valid value(s)|`NONE`, `GZIP`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_compression](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_compression)|

## audit_log_connection_policy
|name|value|
|----|-----|
|Name|`audit_log_connection_policy`|
|Command line|`--audit-log-connection-policy=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ALL`|
|Dynamic|`true`|
|Valid value(s)|`ALL`, `ERRORS`, `NONE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_connection_policy](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_connection_policy)|

## audit_log_current_session
|name|value|
|----|-----|
|Name|`audit_log_current_session`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`depends on filtering policy`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_current_session](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_current_session)|

## audit_log_encryption
|name|value|
|----|-----|
|Name|`audit_log_encryption`|
|Command line|`--audit-log-encryption=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE`|
|Dynamic|`false`|
|Valid value(s)|`NONE`, `AES`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_encryption](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_encryption)|

## audit_log_exclude_accounts
|name|value|
|----|-----|
|Name|`audit_log_exclude_accounts`|
|Command line|`--audit-log-exclude-accounts=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_exclude_accounts](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_exclude_accounts)|

## audit_log_file
|name|value|
|----|-----|
|Name|`audit_log_file`|
|Command line|`--audit-log-file=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`audit.log`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_file](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_file)|

## audit_log_filter_id
|name|value|
|----|-----|
|Name|`audit_log_filter_id`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_filter_id](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_filter_id)|

## audit_log_flush
|name|value|
|----|-----|
|Name|`audit_log_flush`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_flush](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_flush)|

## audit_log_format
|name|value|
|----|-----|
|Name|`audit_log_format`|
|Command line|`--audit-log-format=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NEW`|
|Dynamic|`false`|
|Valid value(s)|`OLD`, `NEW`, `JSON`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_format](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_format)|

## audit_log_format_unix_timestamp
|name|value|
|----|-----|
|Name|`audit_log_format_unix_timestamp`|
|Command line|`--audit-log-format-unix-timestamp[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_format_unix_timestamp](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_format_unix_timestamp)|

## audit_log_include_accounts
|name|value|
|----|-----|
|Name|`audit_log_include_accounts`|
|Command line|`--audit-log-include-accounts=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_include_accounts](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_include_accounts)|

## audit_log_max_size
|name|value|
|----|-----|
|Name|`audit_log_max_size`|
|Command line|`--audit-log-max-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_max_size](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_max_size)|

## audit_log_password_history_keep_days
|name|value|
|----|-----|
|Name|`audit_log_password_history_keep_days`|
|Command line|`--audit-log-password-history-keep-days=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_password_history_keep_days](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_password_history_keep_days)|

## audit_log_policy
|name|value|
|----|-----|
|Name|`audit_log_policy`|
|Command line|`--audit-log-policy=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ALL`|
|Dynamic|`false`|
|Valid value(s)|`ALL`, `LOGINS`, `QUERIES`, `NONE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_policy](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_policy)|

## audit_log_prune_seconds
|name|value|
|----|-----|
|Name|`audit_log_prune_seconds`|
|Command line|`--audit-log-prune-seconds=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_prune_seconds](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_prune_seconds)|

## audit_log_read_buffer_size
|name|value|
|----|-----|
|Name|`audit_log_read_buffer_size`|
|Command line|`--audit-log-read-buffer-size=#`|
|Type of variable|`integer`|
|Range|to: `4194304`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_read_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_read_buffer_size)|

## audit_log_rotate_on_size
|name|value|
|----|-----|
|Name|`audit_log_rotate_on_size`|
|Command line|`--audit-log-rotate-on-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1.844674407371E+19`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_rotate_on_size](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_rotate_on_size)|

## audit_log_statement_policy
|name|value|
|----|-----|
|Name|`audit_log_statement_policy`|
|Command line|`--audit-log-statement-policy=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ALL`|
|Dynamic|`true`|
|Valid value(s)|`ALL`, `ERRORS`, `NONE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_statement_policy](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_statement_policy)|

## audit_log_strategy
|name|value|
|----|-----|
|Name|`audit_log_strategy`|
|Command line|`--audit-log-strategy=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ASYNCHRONOUS`|
|Dynamic|`false`|
|Valid value(s)|`ASYNCHRONOUS`, `PERFORMANCE`, `SEMISYNCHRONOUS`, `SYNCHRONOUS`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_audit_log_strategy](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_strategy)|

## innodb
|name|value|
|----|-----|
|Name|`innodb`|
|Command line|`--innodb[=value]`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`OFF`, `ON`, `FORCE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_innodb](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#option_mysqld_innodb)|

## innodb_status_file
|name|value|
|----|-----|
|Name|`innodb_status_file`|
|Command line|`--innodb-status-file[={OFF|ON}]`|
|Type of variable|`boolean`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_innodb-status-file](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#option_mysqld_innodb-status-file)|

## daemon_memcached_enable_binlog
|name|value|
|----|-----|
|Name|`daemon_memcached_enable_binlog`|
|Command line|`--daemon-memcached-enable-binlog[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_enable_binlog](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_enable_binlog)|

## daemon_memcached_engine_lib_name
|name|value|
|----|-----|
|Name|`daemon_memcached_engine_lib_name`|
|Command line|`--daemon-memcached-engine-lib-name=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`innodb_engine.so`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_engine_lib_name](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_engine_lib_name)|

## daemon_memcached_engine_lib_path
|name|value|
|----|-----|
|Name|`daemon_memcached_engine_lib_path`|
|Command line|`--daemon-memcached-engine-lib-path=dir_name`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_engine_lib_path](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_engine_lib_path)|

## daemon_memcached_option
|name|value|
|----|-----|
|Name|`daemon_memcached_option`|
|Command line|`--daemon-memcached-option=options`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_option](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_option)|

## daemon_memcached_r_batch_size
|name|value|
|----|-----|
|Name|`daemon_memcached_r_batch_size`|
|Command line|`--daemon-memcached-r-batch-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_r_batch_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_r_batch_size)|

## daemon_memcached_w_batch_size
|name|value|
|----|-----|
|Name|`daemon_memcached_w_batch_size`|
|Command line|`--daemon-memcached-w-batch-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_daemon_memcached_w_batch_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_daemon_memcached_w_batch_size)|

## innodb_background_drop_list_empty
|name|value|
|----|-----|
|Name|`innodb_background_drop_list_empty`|
|Command line|`--innodb-background-drop-list-empty[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_background_drop_list_empty](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_background_drop_list_empty)|

## innodb_buffer_pool_debug
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_debug`|
|Command line|`--innodb-buffer-pool-debug[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_buffer_pool_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_debug)|

## innodb_buffer_pool_in_core_file
|name|value|
|----|-----|
|Name|`innodb_buffer_pool_in_core_file`|
|Command line|`--innodb-buffer-pool-in-core-file[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_buffer_pool_in_core_file](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_in_core_file)|

## innodb_checkpoint_disabled
|name|value|
|----|-----|
|Name|`innodb_checkpoint_disabled`|
|Command line|`--innodb-checkpoint-disabled[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_checkpoint_disabled](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_checkpoint_disabled)|

## innodb_compress_debug
|name|value|
|----|-----|
|Name|`innodb_compress_debug`|
|Command line|`--innodb-compress-debug=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`none`|
|Dynamic|`true`|
|Valid value(s)|`none`, `zlib`, `lz4`, `lz4hc`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_compress_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_compress_debug)|

## innodb_ddl_buffer_size
|name|value|
|----|-----|
|Name|`innodb_ddl_buffer_size`|
|Command line|`--innodb-ddl-buffer-size=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1048576`|
|Dynamic|`true`|
|Range|from: `65536` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_ddl_buffer_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_buffer_size)|

## innodb_ddl_log_crash_reset_debug
|name|value|
|----|-----|
|Name|`innodb_ddl_log_crash_reset_debug`|
|Command line|`--innodb-ddl-log-crash-reset-debug[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_ddl_log_crash_reset_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_log_crash_reset_debug)|

## innodb_ddl_threads
|name|value|
|----|-----|
|Name|`innodb_ddl_threads`|
|Command line|`--innodb-ddl-threads=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`4`|
|Dynamic|`true`|
|Range|from: `1` to: `64`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_ddl_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ddl_threads)|

## innodb_dedicated_server
|name|value|
|----|-----|
|Name|`innodb_dedicated_server`|
|Command line|`--innodb-dedicated-server[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_dedicated_server](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_dedicated_server)|

## innodb_directories
|name|value|
|----|-----|
|Name|`innodb_directories`|
|Command line|`--innodb-directories=dir_name`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_directories](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_directories)|

## innodb_doublewrite_batch_size
|name|value|
|----|-----|
|Name|`innodb_doublewrite_batch_size`|
|Command line|`--innodb-doublewrite-batch-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`false`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_doublewrite_batch_size](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_doublewrite_batch_size)|

## innodb_doublewrite_dir
|name|value|
|----|-----|
|Name|`innodb_doublewrite_dir`|
|Command line|`--innodb-doublewrite-dir=dir_name`|
|Type of variable|`directory name`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_doublewrite_dir](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_doublewrite_dir)|

## innodb_doublewrite_files
|name|value|
|----|-----|
|Name|`innodb_doublewrite_files`|
|Command line|`--innodb-doublewrite-files=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`innodb_buffer_pool_instances * 2`|
|Dynamic|`false`|
|Range|from: `2` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_doublewrite_files](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_doublewrite_files)|

## innodb_doublewrite_pages
|name|value|
|----|-----|
|Name|`innodb_doublewrite_pages`|
|Command line|`--innodb-doublewrite-pages=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`innodb_write_io_threads value`|
|Dynamic|`false`|
|Range|to: `512`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_doublewrite_pages](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_doublewrite_pages)|

## innodb_extend_and_initialize
|name|value|
|----|-----|
|Name|`innodb_extend_and_initialize`|
|Command line|`--innodb=extend-and-initialize[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_extend_and_initialize](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_extend_and_initialize)|

## innodb_fil_make_page_dirty_debug
|name|value|
|----|-----|
|Name|`innodb_fil_make_page_dirty_debug`|
|Command line|`--innodb-fil-make-page-dirty-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_fil_make_page_dirty_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_fil_make_page_dirty_debug)|

## innodb_fsync_threshold
|name|value|
|----|-----|
|Name|`innodb_fsync_threshold`|
|Command line|`--innodb-fsync-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_fsync_threshold](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_fsync_threshold)|

## innodb_limit_optimistic_insert_debug
|name|value|
|----|-----|
|Name|`innodb_limit_optimistic_insert_debug`|
|Command line|`--innodb-limit-optimistic-insert-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_limit_optimistic_insert_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_limit_optimistic_insert_debug)|

## innodb_log_checkpoint_fuzzy_now
|name|value|
|----|-----|
|Name|`innodb_log_checkpoint_fuzzy_now`|
|Command line|`--innodb-log-checkpoint-fuzzy-now[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_checkpoint_fuzzy_now](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_checkpoint_fuzzy_now)|

## innodb_log_checkpoint_now
|name|value|
|----|-----|
|Name|`innodb_log_checkpoint_now`|
|Command line|`--innodb-log-checkpoint-now[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_checkpoint_now](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_checkpoint_now)|

## innodb_log_spin_cpu_abs_lwm
|name|value|
|----|-----|
|Name|`innodb_log_spin_cpu_abs_lwm`|
|Command line|`--innodb-log-spin-cpu-abs-lwm=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`80`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_spin_cpu_abs_lwm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_spin_cpu_abs_lwm)|

## innodb_log_spin_cpu_pct_hwm
|name|value|
|----|-----|
|Name|`innodb_log_spin_cpu_pct_hwm`|
|Command line|`--innodb-log-spin-cpu-pct-hwm=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `0` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_spin_cpu_pct_hwm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_spin_cpu_pct_hwm)|

## innodb_log_wait_for_flush_spin_hwm
|name|value|
|----|-----|
|Name|`innodb_log_wait_for_flush_spin_hwm`|
|Command line|`--innodb-log-wait-for-flush-spin-hwm=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`400`|
|Dynamic|`true`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_wait_for_flush_spin_hwm](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_wait_for_flush_spin_hwm)|

## innodb_log_writer_threads
|name|value|
|----|-----|
|Name|`innodb_log_writer_threads`|
|Command line|`--innodb-log-writer-threads[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_log_writer_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_writer_threads)|

## innodb_merge_threshold_set_all_debug
|name|value|
|----|-----|
|Name|`innodb_merge_threshold_set_all_debug`|
|Command line|`--innodb-merge-threshold-set-all-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `1` to: `50`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_merge_threshold_set_all_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_merge_threshold_set_all_debug)|

## innodb_parallel_read_threads
|name|value|
|----|-----|
|Name|`innodb_parallel_read_threads`|
|Command line|`--innodb-parallel-read-threads=#`|
|Type of variable|`integer`|
|Scope|`session`|
|Default value|`4`|
|Dynamic|`true`|
|Range|from: `1` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_parallel_read_threads](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_parallel_read_threads)|

## innodb_print_ddl_logs
|name|value|
|----|-----|
|Name|`innodb_print_ddl_logs`|
|Command line|`--innodb-print-ddl-logs[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_print_ddl_logs](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_print_ddl_logs)|

## innodb_redo_log_archive_dirs
|name|value|
|----|-----|
|Name|`innodb_redo_log_archive_dirs`|
|Command line|`--innodb-redo-log-archive-dirs`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_redo_log_archive_dirs](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_archive_dirs)|

## innodb_redo_log_encrypt
|name|value|
|----|-----|
|Name|`innodb_redo_log_encrypt`|
|Command line|`--innodb-redo-log-encrypt[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_redo_log_encrypt](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_redo_log_encrypt)|

## innodb_saved_page_number_debug
|name|value|
|----|-----|
|Name|`innodb_saved_page_number_debug`|
|Command line|`--innodb-saved-page-number-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|to: `2`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_saved_page_number_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_saved_page_number_debug)|

## innodb_segment_reserve_factor
|name|value|
|----|-----|
|Name|`innodb_segment_reserve_factor`|
|Command line|`--innodb-segment-reserve-factor=#`|
|Type of variable|`numeric`|
|Scope|`global`|
|Default value|`12.5`|
|Dynamic|`true`|
|Range|from: `0.03` to: `40`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_segment_reserve_factor](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_segment_reserve_factor)|

## innodb_spin_wait_pause_multiplier
|name|value|
|----|-----|
|Name|`innodb_spin_wait_pause_multiplier`|
|Command line|`--innodb-spin-wait-pause-multiplier=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`50`|
|Dynamic|`true`|
|Range|from: `1` to: `100`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_spin_wait_pause_multiplier](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_spin_wait_pause_multiplier)|

## innodb_sync_debug
|name|value|
|----|-----|
|Name|`innodb_sync_debug`|
|Command line|`--innodb-sync-debug[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_sync_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_sync_debug)|

## innodb_temp_tablespaces_dir
|name|value|
|----|-----|
|Name|`innodb_temp_tablespaces_dir`|
|Command line|`--innodb-temp-tablespaces-dir=dir_name`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`#innodb_temp`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_temp_tablespaces_dir](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_temp_tablespaces_dir)|

## innodb_trx_purge_view_update_only_debug
|name|value|
|----|-----|
|Name|`innodb_trx_purge_view_update_only_debug`|
|Command line|`--innodb-trx-purge-view-update-only-debug[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_trx_purge_view_update_only_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_trx_purge_view_update_only_debug)|

## innodb_trx_rseg_n_slots_debug
|name|value|
|----|-----|
|Name|`innodb_trx_rseg_n_slots_debug`|
|Command line|`--innodb-trx-rseg-n-slots-debug=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|to: `1024`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_trx_rseg_n_slots_debug](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_trx_rseg_n_slots_debug)|

## innodb_undo_log_encrypt
|name|value|
|----|-----|
|Name|`innodb_undo_log_encrypt`|
|Command line|`--innodb-undo-log-encrypt[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_undo_log_encrypt](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_undo_log_encrypt)|

## innodb_use_fdatasync
|name|value|
|----|-----|
|Name|`innodb_use_fdatasync`|
|Command line|`--innodb-use-fdatasync[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_use_fdatasync](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_use_fdatasync)|

## innodb_validate_tablespace_paths
|name|value|
|----|-----|
|Name|`innodb_validate_tablespace_paths`|
|Command line|`--innodb-validate-tablespace-paths[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_innodb_validate_tablespace_paths](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_validate_tablespace_paths)|

## ndbcluster
|name|value|
|----|-----|
|Name|`ndbcluster`|
|Command line|`--ndbcluster[=value]`|
|Type of variable|`boolean`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndbcluster](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndbcluster)|

## ndb_allow_copying_alter_table
|name|value|
|----|-----|
|Name|`ndb_allow_copying_alter_table`|
|Command line|`--ndb-allow-copying-alter-table[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-allow-copying-alter-table](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-allow-copying-alter-table)|

## ndb_batch_size
|name|value|
|----|-----|
|Name|`ndb_batch_size`|
|Command line|`--ndb-batch-size`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32768`|
|Dynamic|`false`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-batch-size](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-batch-size)|

## ndb_cluster_connection_pool
|name|value|
|----|-----|
|Name|`ndb_cluster_connection_pool`|
|Command line|`--ndb-cluster-connection-pool`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`false`|
|Range|from: `1` to: `63`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-cluster-connection-pool](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-cluster-connection-pool)|

## ndb_cluster_connection_pool_nodeids
|name|value|
|----|-----|
|Name|`ndb_cluster_connection_pool_nodeids`|
|Command line|`--ndb-cluster-connection-pool-nodeids`|
|Type of variable|`set`|
|Default value|``|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-cluster-connection-pool-nodeids](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-cluster-connection-pool-nodeids)|

## ndb_blob_read_batch_bytes
|name|value|
|----|-----|
|Name|`ndb_blob_read_batch_bytes`|
|Command line|`--ndb-blob-read-batch-bytes`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`65536`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-blob-read-batch-bytes](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-blob-read-batch-bytes)|

## ndb_blob_write_batch_bytes
|name|value|
|----|-----|
|Name|`ndb_blob_write_batch_bytes`|
|Command line|`--ndb-blob-write-batch-bytes`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`65536`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-blob-write-batch-bytes](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-blob-write-batch-bytes)|

## ndb_connectstring
|name|value|
|----|-----|
|Name|`ndb_connectstring`|
|Command line|`--ndb-connectstring`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-connectstring](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-connectstring)|

## ndb_default_column_format
|name|value|
|----|-----|
|Name|`ndb_default_column_format`|
|Command line|`--ndb-default-column-format={FIXED|DYNAMIC}`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Dynamic|`true`|
|Valid value(s)|`FIXED`, `DYNAMIC`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-default-column-format](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-default-column-format)|
|dev.mysql.com|[sysvar_ndb_default_column_format](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_default_column_format)|

## ndb_deferred_constraints
|name|value|
|----|-----|
|Name|`ndb_deferred_constraints`|
|Command line|`--ndb-deferred-constraints=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-deferred-constraints](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-deferred-constraints)|
|dev.mysql.com|[sysvar_ndb_deferred_constraints](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_deferred_constraints)|

## ndb_distribution
|name|value|
|----|-----|
|Name|`ndb_distribution`|
|Command line|`--ndb-distribution={KEYHASH|LINHASH}`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`KEYHASH`|
|Dynamic|`true`|
|Valid value(s)|`LINHASH`, `KEYHASH`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-distribution](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-distribution)|
|dev.mysql.com|[sysvar_ndb_distribution](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_distribution)|

## ndb_log_apply_status
|name|value|
|----|-----|
|Name|`ndb_log_apply_status`|
|Command line|`--ndb-log-apply-status[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-apply-status](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-apply-status)|
|dev.mysql.com|[sysvar_ndb_log_apply_status](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_apply_status)|

## ndb_log_empty_epochs
|name|value|
|----|-----|
|Name|`ndb_log_empty_epochs`|
|Command line|`--ndb-log-empty-epochs[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-empty-epochs](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-empty-epochs)|
|dev.mysql.com|[sysvar_ndb_log_empty_epochs](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_empty_epochs)|

## ndb_log_empty_update
|name|value|
|----|-----|
|Name|`ndb_log_empty_update`|
|Command line|`--ndb-log-empty-update[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-empty-update](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-empty-update)|
|dev.mysql.com|[sysvar_ndb_log_empty_update](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_empty_update)|

## ndb_log_exclusive_reads
|name|value|
|----|-----|
|Name|`ndb_log_exclusive_reads`|
|Command line|`--ndb-log-exclusive-reads[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-exclusive-reads](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-exclusive-reads)|
|dev.mysql.com|[sysvar_ndb_log_exclusive_reads](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_exclusive_reads)|

## ndb_log_fail_terminate
|name|value|
|----|-----|
|Name|`ndb_log_fail_terminate`|
|Command line|`--ndb-log-fail-terminate`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`FALSE`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-fail-terminate](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-fail-terminate)|

## ndb_log_orig
|name|value|
|----|-----|
|Name|`ndb_log_orig`|
|Command line|`--ndb-log-orig[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-orig](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-orig)|
|dev.mysql.com|[sysvar_ndb_log_orig](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_orig)|

## ndb_log_transaction_id
|name|value|
|----|-----|
|Name|`ndb_log_transaction_id`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-transaction-id](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-transaction-id)|
|dev.mysql.com|[sysvar_ndb_log_transaction_id](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_transaction_id)|

## ndb_log_update_as_write
|name|value|
|----|-----|
|Name|`ndb_log_update_as_write`|
|Command line|`--ndb-log-update-as-write[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-update-as-write](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-update-as-write)|

## ndb_log_updated_only
|name|value|
|----|-----|
|Name|`ndb_log_updated_only`|
|Command line|`--ndb-log-updated-only[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-updated-only](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-updated-only)|

## ndb_log_update_minimal
|name|value|
|----|-----|
|Name|`ndb_log_update_minimal`|
|Command line|`--ndb-log-update-minimal[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-log-update-minimal](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-log-update-minimal)|

## ndb_mgmd_host
|name|value|
|----|-----|
|Name|`ndb_mgmd_host`|
|Command line|`--ndb-mgmd-host=host_name[:port_num]`|
|Type of variable|`string`|
|Default value|`localhost:1186`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-mgmd-host](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-mgmd-host)|

## ndb_nodeid
|name|value|
|----|-----|
|Name|`ndb_nodeid`|
|Command line|`--ndb-nodeid=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`false`|
|Range|from: `1` to: `63`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-nodeid](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-nodeid)|

## ndb_optimization_delay
|name|value|
|----|-----|
|Name|`ndb_optimization_delay`|
|Command line|`--ndb-optimization-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `100000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-optimization-delay](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-optimization-delay)|

## ndb_optimized_node_selection
|name|value|
|----|-----|
|Name|`ndb_optimized_node_selection`|
|Command line|`--ndb-optimized-node-selection=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`3`|
|Dynamic|`false`|
|Range|from: `0` to: `3`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-optimized-node-selection](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-optimized-node-selection)|
|dev.mysql.com|[sysvar_ndb_optimized_node_selection](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_optimized_node_selection)|

## ndb_transid_mysql_connection_map
|name|value|
|----|-----|
|Name|`ndb_transid_mysql_connection_map`|
|Command line|`--ndb-transid-mysql-connection-map[=state]`|
|Type of variable|`enumeration`|
|Default value|`ON`|
|Valid value(s)|`ON`, `OFF`, `FORCE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-transid-mysql-connection-map](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-transid-mysql-connection-map)|

## ndb_wait_connected
|name|value|
|----|-----|
|Name|`ndb_wait_connected`|
|Command line|`--ndb-wait-connected=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`30`|
|Dynamic|`false`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-wait-connected](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-wait-connected)|

## ndb_wait_setup
|name|value|
|----|-----|
|Name|`ndb_wait_setup`|
|Command line|`--ndb-wait-setup=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`15`|
|Dynamic|`false`|
|Range|from: `0` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_ndb-wait-setup](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_ndb-wait-setup)|

## skip_ndbcluster
|name|value|
|----|-----|
|Name|`skip_ndbcluster`|
|Command line|`--skip-ndbcluster`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_skip-ndbcluster](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#option_mysqld_skip-ndbcluster)|

## ndb_autoincrement_prefetch_sz
|name|value|
|----|-----|
|Name|`ndb_autoincrement_prefetch_sz`|
|Command line|`--ndb-autoincrement-prefetch-sz=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1` to: `65536`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_autoincrement_prefetch_sz](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_autoincrement_prefetch_sz)|

## ndb_cache_check_time
|name|value|
|----|-----|
|Name|`ndb_cache_check_time`|
|Command line|`--ndb-cache-check-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_cache_check_time](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_cache_check_time)|

## ndb_clear_apply_status
|name|value|
|----|-----|
|Name|`ndb_clear_apply_status`|
|Command line|`--ndb-clear-apply-status[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_clear_apply_status](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_clear_apply_status)|

## ndb_data_node_neighbour
|name|value|
|----|-----|
|Name|`ndb_data_node_neighbour`|
|Command line|`--ndb-data-node-neighbour=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `255`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_data_node_neighbour](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_data_node_neighbour)|

## ndb_eventbuffer_free_percent
|name|value|
|----|-----|
|Name|`ndb_eventbuffer_free_percent`|
|Command line|`--ndb-eventbuffer-free-percent=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`20`|
|Dynamic|`true`|
|Range|from: `1` to: `99`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_eventbuffer_free_percent](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_eventbuffer_free_percent)|

## ndb_eventbuffer_max_alloc
|name|value|
|----|-----|
|Name|`ndb_eventbuffer_max_alloc`|
|Command line|`--ndb-eventbuffer-max-alloc=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_eventbuffer_max_alloc](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_eventbuffer_max_alloc)|

## ndb_extra_logging
|name|value|
|----|-----|
|Name|`ndb_extra_logging`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_extra_logging](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_extra_logging)|

## ndb_force_send
|name|value|
|----|-----|
|Name|`ndb_force_send`|
|Command line|`--ndb-force-send[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_force_send](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_force_send)|

## ndb_fully_replicated
|name|value|
|----|-----|
|Name|`ndb_fully_replicated`|
|Command line|`--ndb-fully-replicated[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_fully_replicated](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_fully_replicated)|

## ndb_index_stat_enable
|name|value|
|----|-----|
|Name|`ndb_index_stat_enable`|
|Command line|`--ndb-index-stat-enable[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_index_stat_enable](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_index_stat_enable)|

## ndb_index_stat_option
|name|value|
|----|-----|
|Name|`ndb_index_stat_option`|
|Command line|`--ndb-index-stat-option=value`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Default value|`loop_checkon=1000ms,loop_idle=1000ms,loop_busy=100ms,         update_batch=1,read_batch=4,idle_batch=32,check_batch=32,         check_delay=1m,delete_batch=8,clean_delay=0,error_batch=4,         error_delay=1m,evict_batch=8,evict_delay=1m,cache_limit=32M,         cache_lowpct=90`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_index_stat_option](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_index_stat_option)|

## ndb_join_pushdown
|name|value|
|----|-----|
|Name|`ndb_join_pushdown`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_join_pushdown](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_join_pushdown)|

## ndb_log_bin
|name|value|
|----|-----|
|Name|`ndb_log_bin`|
|Command line|`--ndb-log-bin[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_log_bin](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_bin)|

## ndb_log_binlog_index
|name|value|
|----|-----|
|Name|`ndb_log_binlog_index`|
|Command line|`--ndb-log-binlog-index[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_log_binlog_index](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_log_binlog_index)|

## ndb_read_backup
|name|value|
|----|-----|
|Name|`ndb_read_backup`|
|Command line|`--ndb-read-backup[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_read_backup](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_read_backup)|

## ndb_recv_thread_activation_threshold
|name|value|
|----|-----|
|Name|`ndb_recv_thread_activation_threshold`|
|Command line|`--ndb-recv-thread-activation-threshold=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`8`|
|Dynamic|`true`|
|Range|from: `0` to: `16`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_recv_thread_activation_threshold](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_recv_thread_activation_threshold)|

## ndb_recv_thread_cpu_mask
|name|value|
|----|-----|
|Name|`ndb_recv_thread_cpu_mask`|
|Command line|`--ndb-recv-thread-cpu-mask=mask`|
|Scope|`global`|
|Default value|`[empty]`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_recv_thread_cpu_mask](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_recv_thread_cpu_mask)|

## ndb_report_thresh_binlog_epoch_slip
|name|value|
|----|-----|
|Name|`ndb_report_thresh_binlog_epoch_slip`|
|Command line|`--ndb-report-thresh-binlog-epoch-slip=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_report_thresh_binlog_epoch_slip](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_report_thresh_binlog_epoch_slip)|

## ndb_report_thresh_binlog_mem_usage
|name|value|
|----|-----|
|Name|`ndb_report_thresh_binlog_mem_usage`|
|Command line|`--ndb-report-thresh-binlog-mem-usage=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `10`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_report_thresh_binlog_mem_usage](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_report_thresh_binlog_mem_usage)|

## ndb_row_checksum
|name|value|
|----|-----|
|Name|`ndb_row_checksum`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `0` to: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_row_checksum](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_row_checksum)|

## ndb_show_foreign_key_mock_tables
|name|value|
|----|-----|
|Name|`ndb_show_foreign_key_mock_tables`|
|Command line|`--ndb-show-foreign-key-mock-tables[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_show_foreign_key_mock_tables](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_show_foreign_key_mock_tables)|

## ndb_slave_conflict_role
|name|value|
|----|-----|
|Name|`ndb_slave_conflict_role`|
|Command line|`--ndb-slave-conflict-role=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`NONE`|
|Dynamic|`true`|
|Valid value(s)|`NONE`, `PRIMARY`, `SECONDARY`, `PASS`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_slave_conflict_role](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_slave_conflict_role)|

## ndb_table_no_logging
|name|value|
|----|-----|
|Name|`ndb_table_no_logging`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_table_no_logging](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_table_no_logging)|

## ndb_table_temporary
|name|value|
|----|-----|
|Name|`ndb_table_temporary`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_table_temporary](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_table_temporary)|

## ndb_use_copying_alter_table
|name|value|
|----|-----|
|Name|`ndb_use_copying_alter_table`|
|Scope|`global`, `session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_use_copying_alter_table](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_use_copying_alter_table)|

## ndb_use_exact_count
|name|value|
|----|-----|
|Name|`ndb_use_exact_count`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_use_exact_count](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_use_exact_count)|

## ndb_use_transactions
|name|value|
|----|-----|
|Name|`ndb_use_transactions`|
|Command line|`--ndb-use-transactions[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_use_transactions](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_use_transactions)|

## ndb_version
|name|value|
|----|-----|
|Name|`ndb_version`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_version](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_version)|

## ndb_version_string
|name|value|
|----|-----|
|Name|`ndb_version_string`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndb_version_string](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndb_version_string)|

## server_id_bits
|name|value|
|----|-----|
|Name|`server_id_bits`|
|Command line|`--server-id-bits=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`32`|
|Dynamic|`false`|
|Range|from: `7` to: `32`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_server_id_bits](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_server_id_bits)|

## slave_allow_batching
|name|value|
|----|-----|
|Name|`slave_allow_batching`|
|Command line|`--slave-allow-batching[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_slave_allow_batching](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_slave_allow_batching)|

## transaction_allow_batching
|name|value|
|----|-----|
|Name|`transaction_allow_batching`|
|Type of variable|`boolean`|
|Scope|`session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_transaction_allow_batching](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_transaction_allow_batching)|

## ndbinfo_database
|name|value|
|----|-----|
|Name|`ndbinfo_database`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`ndbinfo`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_database](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_database)|

## ndbinfo_max_bytes
|name|value|
|----|-----|
|Name|`ndbinfo_max_bytes`|
|Command line|`--ndbinfo-max-bytes=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_max_bytes](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_max_bytes)|

## ndbinfo_max_rows
|name|value|
|----|-----|
|Name|`ndbinfo_max_rows`|
|Command line|`--ndbinfo-max-rows=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`10`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_max_rows](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_max_rows)|

## ndbinfo_offline
|name|value|
|----|-----|
|Name|`ndbinfo_offline`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_offline](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_offline)|

## ndbinfo_show_hidden
|name|value|
|----|-----|
|Name|`ndbinfo_show_hidden`|
|Command line|`--ndbinfo-show-hidden[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`ON`, `OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_show_hidden](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_show_hidden)|

## ndbinfo_table_prefix
|name|value|
|----|-----|
|Name|`ndbinfo_table_prefix`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`ndb$`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_table_prefix](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_table_prefix)|

## ndbinfo_version
|name|value|
|----|-----|
|Name|`ndbinfo_version`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|``|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_ndbinfo_version](https://dev.mysql.com/doc/refman/5.7/en/mysql-cluster-options-variables.html#sysvar_ndbinfo_version)|

## performance_schema_error_size
|name|value|
|----|-----|
|Name|`performance_schema_error_size`|
|Command line|`--performance-schema-error-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`number of server error codes`|
|Dynamic|`false`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_performance_schema_error_size](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_error_size)|

## performance_schema_max_digest_sample_age
|name|value|
|----|-----|
|Name|`performance_schema_max_digest_sample_age`|
|Command line|`--performance-schema-max-digest-sample-age=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60`|
|Dynamic|`true`|
|Range|from: `0` to: `1048576`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_performance_schema_max_digest_sample_age](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_digest_sample_age)|

## performance_schema_max_prepared_statements_instances
|name|value|
|----|-----|
|Name|`performance_schema_max_prepared_statements_instances`|
|Command line|`--performance-schema-max-prepared-statements-instances=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`(-1 signifies autoscaling; do not use -1)`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_performance_schema_max_prepared_statements_instances](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_max_prepared_statements_instances)|

## performance_schema_show_processlist
|name|value|
|----|-----|
|Name|`performance_schema_show_processlist`|
|Command line|`--performance-schema-show-processlist[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_performance_schema_show_processlist](https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html#sysvar_performance_schema_show_processlist)|

## authentication_fido_rp_id
|name|value|
|----|-----|
|Name|`authentication_fido_rp_id`|
|Command line|`--authentication-fido-rp-id=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`MySQL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_fido_rp_id](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_fido_rp_id)|

## authentication_kerberos_service_key_tab
|name|value|
|----|-----|
|Name|`authentication_kerberos_service_key_tab`|
|Command line|`--authentication-kerberos-service-key-tab=file_name`|
|Type of variable|`file name`|
|Scope|`global`|
|Default value|`datadir/mysql.keytab`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_kerberos_service_key_tab](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_kerberos_service_key_tab)|

## authentication_kerberos_service_principal
|name|value|
|----|-----|
|Name|`authentication_kerberos_service_principal`|
|Command line|`--authentication-kerberos-service-principal=name`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`mysql/host_name@realm_name`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_kerberos_service_principal](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_kerberos_service_principal)|

## authentication_ldap_sasl_auth_method_name
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_auth_method_name`|
|Command line|`--authentication-ldap-sasl-auth-method-name=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`SCRAM-SHA-1`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_auth_method_name](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_auth_method_name)|

## authentication_ldap_sasl_bind_base_dn
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_bind_base_dn`|
|Command line|`--authentication-ldap-sasl-bind-base-dn=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_bind_base_dn](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_bind_base_dn)|

## authentication_ldap_sasl_bind_root_dn
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_bind_root_dn`|
|Command line|`--authentication-ldap-sasl-bind-root-dn=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_bind_root_dn](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_bind_root_dn)|

## authentication_ldap_sasl_bind_root_pwd
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_bind_root_pwd`|
|Command line|`--authentication-ldap-sasl-bind-root-pwd=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_bind_root_pwd](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_bind_root_pwd)|

## authentication_ldap_sasl_ca_path
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_ca_path`|
|Command line|`--authentication-ldap-sasl-ca-path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_ca_path](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_ca_path)|

## authentication_ldap_sasl_group_search_attr
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_group_search_attr`|
|Command line|`--authentication-ldap-sasl-group-search-attr=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`cn`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_group_search_attr](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_group_search_attr)|

## authentication_ldap_sasl_group_search_filter
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_group_search_filter`|
|Command line|`--authentication-ldap-sasl-group-search-filter=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(|(&(objectClass=posixGroup)(memberUid=%s))(&(objectClass=group)(member=%s)))`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_group_search_filter](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_group_search_filter)|

## authentication_ldap_sasl_init_pool_size
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_init_pool_size`|
|Command line|`--authentication-ldap-sasl-init-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `32767`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_init_pool_size](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_init_pool_size)|

## authentication_ldap_sasl_log_status
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_log_status`|
|Command line|`--authentication-ldap-sasl-log-status=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_log_status](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_log_status)|

## authentication_ldap_sasl_max_pool_size
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_max_pool_size`|
|Command line|`--authentication-ldap-sasl-max-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `0` to: `32767`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_max_pool_size](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_max_pool_size)|

## authentication_ldap_sasl_referral
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_referral`|
|Command line|`--authentication-ldap-sasl-referral[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_referral](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_referral)|

## authentication_ldap_sasl_server_host
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_server_host`|
|Command line|`--authentication-ldap-sasl-server-host=host_name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_server_host](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_server_host)|

## authentication_ldap_sasl_server_port
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_server_port`|
|Command line|`--authentication-ldap-sasl-server-port=port_num`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`389`|
|Dynamic|`true`|
|Range|from: `1` to: `32376`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_server_port](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_server_port)|

## authentication_ldap_sasl_tls
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_tls`|
|Command line|`--authentication-ldap-sasl-tls[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_tls](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_tls)|

## authentication_ldap_sasl_user_search_attr
|name|value|
|----|-----|
|Name|`authentication_ldap_sasl_user_search_attr`|
|Command line|`--authentication-ldap-sasl-user-search-attr=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`uid`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_sasl_user_search_attr](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_sasl_user_search_attr)|

## authentication_ldap_simple_auth_method_name
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_auth_method_name`|
|Command line|`--authentication-ldap-simple-auth-method-name=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`SIMPLE`|
|Dynamic|`true`|
|Valid value(s)|`SIMPLE`, `AD-FOREST`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_auth_method_name](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_auth_method_name)|

## authentication_ldap_simple_bind_base_dn
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_bind_base_dn`|
|Command line|`--authentication-ldap-simple-bind-base-dn=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_bind_base_dn](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_bind_base_dn)|

## authentication_ldap_simple_bind_root_dn
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_bind_root_dn`|
|Command line|`--authentication-ldap-simple-bind-root-dn=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_bind_root_dn](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_bind_root_dn)|

## authentication_ldap_simple_bind_root_pwd
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_bind_root_pwd`|
|Command line|`--authentication-ldap-simple-bind-root-pwd=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_bind_root_pwd](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_bind_root_pwd)|

## authentication_ldap_simple_ca_path
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_ca_path`|
|Command line|`--authentication-ldap-simple-ca-path=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`NULL`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_ca_path](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_ca_path)|

## authentication_ldap_simple_group_search_attr
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_group_search_attr`|
|Command line|`--authentication-ldap-simple-group-search-attr=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`cn`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_group_search_attr](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_group_search_attr)|

## authentication_ldap_simple_group_search_filter
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_group_search_filter`|
|Command line|`--authentication-ldap-simple-group-search-filter=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`(|(&(objectClass=posixGroup)(memberUid=%s))(&(objectClass=group)(member=%s)))`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_group_search_filter](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_group_search_filter)|

## authentication_ldap_simple_init_pool_size
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_init_pool_size`|
|Command line|`--authentication-ldap-simple-init-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`10`|
|Dynamic|`true`|
|Range|from: `0` to: `32767`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_init_pool_size](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_init_pool_size)|

## authentication_ldap_simple_log_status
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_log_status`|
|Command line|`--authentication-ldap-simple-log-status=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1`|
|Dynamic|`true`|
|Range|from: `1`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_log_status](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_log_status)|

## authentication_ldap_simple_max_pool_size
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_max_pool_size`|
|Command line|`--authentication-ldap-simple-max-pool-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1000`|
|Dynamic|`true`|
|Range|from: `0` to: `32767`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_max_pool_size](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_max_pool_size)|

## authentication_ldap_simple_referral
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_referral`|
|Command line|`--authentication-ldap-simple-referral[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_referral](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_referral)|

## authentication_ldap_simple_server_host
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_server_host`|
|Command line|`--authentication-ldap-simple-server-host=host_name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_server_host](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_server_host)|

## authentication_ldap_simple_server_port
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_server_port`|
|Command line|`--authentication-ldap-simple-server-port=port_num`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`389`|
|Dynamic|`true`|
|Range|from: `1` to: `32376`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_server_port](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_server_port)|

## authentication_ldap_simple_tls
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_tls`|
|Command line|`--authentication-ldap-simple-tls[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_tls](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_tls)|

## authentication_ldap_simple_user_search_attr
|name|value|
|----|-----|
|Name|`authentication_ldap_simple_user_search_attr`|
|Command line|`--authentication-ldap-simple-user-search-attr=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`uid`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_authentication_ldap_simple_user_search_attr](https://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication-system-variables.html#sysvar_authentication_ldap_simple_user_search_attr)|

## binlog_row_event_max_size
|name|value|
|----|-----|
|Name|`binlog_row_event_max_size`|
|Command line|`--binlog-row-event-max-size=#`|
|Type of variable|`integer`|
|Default value|`8192`|
|Range|from: `256`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_binlog-row-event-max-size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_binlog-row-event-max-size)|
|dev.mysql.com|[sysvar_binlog_row_event_max_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_event_max_size)|
|dev.mysql.com|[option_mysqld_binlog-row-event-max-size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_binlog-row-event-max-size)|

## binlog_do_db
|name|value|
|----|-----|
|Name|`binlog_do_db`|
|Command line|`--binlog-do-db=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_binlog-do-db](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_binlog-do-db)|
|dev.mysql.com|[option_mysqld_binlog-do-db](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_binlog-do-db)|

## binlog_ignore_db
|name|value|
|----|-----|
|Name|`binlog_ignore_db`|
|Command line|`--binlog-ignore-db=name`|
|Type of variable|`string`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_binlog-ignore-db](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_binlog-ignore-db)|
|dev.mysql.com|[option_mysqld_binlog-ignore-db](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_binlog-ignore-db)|

## max_binlog_dump_events
|name|value|
|----|-----|
|Name|`max_binlog_dump_events`|
|Command line|`--max-binlog-dump-events=#`|
|Type of variable|`integer`|
|Default value|`0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_max-binlog-dump-events](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_max-binlog-dump-events)|
|dev.mysql.com|[option_mysqld_max-binlog-dump-events](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_max-binlog-dump-events)|

## sporadic_binlog_dump_fail
|name|value|
|----|-----|
|Name|`sporadic_binlog_dump_fail`|
|Command line|`--sporadic-binlog-dump-fail[={OFF|ON}]`|
|Type of variable|`boolean`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_sporadic-binlog-dump-fail](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#option_mysqld_sporadic-binlog-dump-fail)|
|dev.mysql.com|[option_mysqld_sporadic-binlog-dump-fail](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#option_mysqld_sporadic-binlog-dump-fail)|

## binlog_encryption
|name|value|
|----|-----|
|Name|`binlog_encryption`|
|Command line|`--binlog-encryption[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_encryption](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_encryption)|

## binlog_error_action
|name|value|
|----|-----|
|Name|`binlog_error_action`|
|Command line|`--binlog-error-action[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`ABORT_SERVER`|
|Dynamic|`true`|
|Valid value(s)|`IGNORE_ERROR`, `ABORT_SERVER`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_error_action](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_error_action)|
|dev.mysql.com|[sysvar_binlog_error_action](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_error_action)|

## binlog_group_commit_sync_delay
|name|value|
|----|-----|
|Name|`binlog_group_commit_sync_delay`|
|Command line|`--binlog-group-commit-sync-delay=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `1000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)|
|dev.mysql.com|[sysvar_binlog_group_commit_sync_delay](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay)|

## binlog_group_commit_sync_no_delay_count
|name|value|
|----|-----|
|Name|`binlog_group_commit_sync_no_delay_count`|
|Command line|`--binlog-group-commit-sync-no-delay-count=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `100000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)|
|dev.mysql.com|[sysvar_binlog_group_commit_sync_no_delay_count](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_no_delay_count)|

## binlog_max_flush_queue_time
|name|value|
|----|-----|
|Name|`binlog_max_flush_queue_time`|
|Command line|`--binlog-max-flush-queue-time=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`0`|
|Dynamic|`true`|
|Range|from: `0` to: `100000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_max_flush_queue_time](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_max_flush_queue_time)|
|dev.mysql.com|[sysvar_binlog_max_flush_queue_time](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_max_flush_queue_time)|

## binlog_order_commits
|name|value|
|----|-----|
|Name|`binlog_order_commits`|
|Command line|`--binlog-order-commits[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_order_commits](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_order_commits)|
|dev.mysql.com|[sysvar_binlog_order_commits](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_order_commits)|

## binlog_rotate_encryption_master_key_at_startup
|name|value|
|----|-----|
|Name|`binlog_rotate_encryption_master_key_at_startup`|
|Command line|`--binlog-rotate-encryption-master-key-at-startup[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_rotate_encryption_master_key_at_startup](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_rotate_encryption_master_key_at_startup)|

## binlog_row_value_options
|name|value|
|----|-----|
|Name|`binlog_row_value_options`|
|Command line|`--binlog-row-value-options=#`|
|Type of variable|`set`|
|Scope|`global`, `session`|
|Default value|``|
|Dynamic|`true`|
|Valid value(s)|`PARTIAL_JSON`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_row_value_options](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_value_options)|

## binlog_rows_query_log_events
|name|value|
|----|-----|
|Name|`binlog_rows_query_log_events`|
|Command line|`--binlog-rows-query-log-events[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_rows_query_log_events](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_rows_query_log_events)|
|dev.mysql.com|[sysvar_binlog_rows_query_log_events](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_rows_query_log_events)|

## binlog_transaction_compression
|name|value|
|----|-----|
|Name|`binlog_transaction_compression`|
|Command line|`--binlog-transaction-compression[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`, `session`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_transaction_compression](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression)|

## binlog_transaction_compression_level_zstd
|name|value|
|----|-----|
|Name|`binlog_transaction_compression_level_zstd`|
|Command line|`--binlog-transaction-compression-level-zstd=#`|
|Type of variable|`integer`|
|Scope|`global`, `session`|
|Default value|`3`|
|Dynamic|`true`|
|Range|from: `1` to: `22`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_transaction_compression_level_zstd](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_compression_level_zstd)|

## binlog_transaction_dependency_tracking
|name|value|
|----|-----|
|Name|`binlog_transaction_dependency_tracking`|
|Command line|`--binlog-transaction-dependency-tracking=value`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`COMMIT_ORDER`|
|Dynamic|`true`|
|Valid value(s)|`COMMIT_ORDER`, `WRITESET`, `WRITESET_SESSION`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_transaction_dependency_tracking](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_dependency_tracking)|
|dev.mysql.com|[sysvar_binlog_transaction_dependency_tracking](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_transaction_dependency_tracking)|

## binlog_transaction_dependency_history_size
|name|value|
|----|-----|
|Name|`binlog_transaction_dependency_history_size`|
|Command line|`--binlog-transaction-dependency-history-size=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`25000`|
|Dynamic|`true`|
|Range|from: `1` to: `1000000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_transaction_dependency_history_size](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_dependency_history_size)|
|dev.mysql.com|[sysvar_binlog_transaction_dependency_history_size](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_binlog_transaction_dependency_history_size)|

## log_bin_use_v1_row_events
|name|value|
|----|-----|
|Name|`log_bin_use_v1_row_events`|
|Command line|`--log-bin-use-v1-row-events[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_log_bin_use_v1_row_events](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_bin_use_v1_row_events)|
|dev.mysql.com|[sysvar_log_bin_use_v1_row_events](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_bin_use_v1_row_events)|

## log_replica_updates
|name|value|
|----|-----|
|Name|`log_replica_updates`|
|Command line|`--log-replica-updates[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_log_replica_updates](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_replica_updates)|

## log_statements_unsafe_for_binlog
|name|value|
|----|-----|
|Name|`log_statements_unsafe_for_binlog`|
|Command line|`--log-statements-unsafe-for-binlog[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_log_statements_unsafe_for_binlog](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_log_statements_unsafe_for_binlog)|
|dev.mysql.com|[sysvar_log_statements_unsafe_for_binlog](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_statements_unsafe_for_binlog)|

## original_commit_timestamp
|name|value|
|----|-----|
|Name|`original_commit_timestamp`|
|Type of variable|`numeric`|
|Scope|`session`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_original_commit_timestamp](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_original_commit_timestamp)|

## source_verify_checksum
|name|value|
|----|-----|
|Name|`source_verify_checksum`|
|Command line|`--source-verify-checksum[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_source_verify_checksum](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_source_verify_checksum)|

## transaction_write_set_extraction
|name|value|
|----|-----|
|Name|`transaction_write_set_extraction`|
|Command line|`--transaction-write-set-extraction[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`, `session`|
|Default value|`0`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_transaction_write_set_extraction](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_transaction_write_set_extraction)|
|dev.mysql.com|[sysvar_transaction_write_set_extraction](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_transaction_write_set_extraction)|

## log_builtin_as_identified_by_password
|name|value|
|----|-----|
|Name|`log_builtin_as_identified_by_password`|
|Command line|`--log-builtin-as-identified-by-password[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_log_builtin_as_identified_by_password](https://dev.mysql.com/doc/refman/5.7/en/replication-options-binary-log.html#sysvar_log_builtin_as_identified_by_password)|

## binlog_gtid_simple_recovery
|name|value|
|----|-----|
|Name|`binlog_gtid_simple_recovery`|
|Command line|`--binlog-gtid-simple-recovery[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`ON`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_binlog_gtid_simple_recovery](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_binlog_gtid_simple_recovery)|

## enforce_gtid_consistency
|name|value|
|----|-----|
|Name|`enforce_gtid_consistency`|
|Command line|`--enforce-gtid-consistency[=value]`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`OFF`, `ON`, `WARN`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_enforce_gtid_consistency](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_enforce_gtid_consistency)|

## gtid_executed
|name|value|
|----|-----|
|Name|`gtid_executed`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_executed](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_executed)|

## gtid_executed_compression_period
|name|value|
|----|-----|
|Name|`gtid_executed_compression_period`|
|Command line|`--gtid-executed-compression-period=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Dynamic|`true`|
|Range|from: `0` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_executed_compression_period](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_executed_compression_period)|

## gtid_mode
|name|value|
|----|-----|
|Name|`gtid_mode`|
|Command line|`--gtid-mode=MODE`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|
|Valid value(s)|`OFF`, `OFF_PERMISSIVE`, `ON_PERMISSIVE`, `ON`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_mode](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_mode)|

## gtid_next
|name|value|
|----|-----|
|Name|`gtid_next`|
|Type of variable|`enumeration`|
|Scope|`session`|
|Default value|`AUTOMATIC`|
|Dynamic|`true`|
|Valid value(s)|`AUTOMATIC`, `ANONYMOUS`, `UUID:NUMBER`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_next](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_next)|

## gtid_owned
|name|value|
|----|-----|
|Name|`gtid_owned`|
|Type of variable|`string`|
|Scope|`global`, `session`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_owned](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_owned)|

## gtid_purged
|name|value|
|----|-----|
|Name|`gtid_purged`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_gtid_purged](https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html#sysvar_gtid_purged)|

## master_info_file
|name|value|
|----|-----|
|Name|`master_info_file`|
|Command line|`--master-info-file=file_name`|
|Type of variable|`file name`|
|Default value|`master.info`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_master-info-file](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_master-info-file)|

## master_retry_count
|name|value|
|----|-----|
|Name|`master_retry_count`|
|Command line|`--master-retry-count=#`|
|Type of variable|`integer`|
|Default value|`86400`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_master-retry-count](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_master-retry-count)|

## replicate_same_server_id
|name|value|
|----|-----|
|Name|`replicate_same_server_id`|
|Command line|`--replicate-same-server-id[={OFF|ON}]`|
|Type of variable|`boolean`|
|Default value|`OFF`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_replicate-same-server-id](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_replicate-same-server-id)|

## skip_replica_start
|name|value|
|----|-----|
|Name|`skip_replica_start`|
|Command line|`--skip-replica-start[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_skip-replica-start](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_skip-replica-start)|
|dev.mysql.com|[sysvar_skip_replica_start](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_skip_replica_start)|

## skip_slave_start
|name|value|
|----|-----|
|Name|`skip_slave_start`|
|Command line|`--skip-slave-start[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_skip-slave-start](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_skip-slave-start)|
|dev.mysql.com|[sysvar_skip_slave_start](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_skip_slave_start)|

## abort_slave_event_count
|name|value|
|----|-----|
|Name|`abort_slave_event_count`|
|Command line|`--abort-slave-event-count=#`|
|Type of variable|`integer`|
|Default value|`0`|
|Range|from: `0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_abort-slave-event-count](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_abort-slave-event-count)|

## disconnect_slave_event_count
|name|value|
|----|-----|
|Name|`disconnect_slave_event_count`|
|Command line|`--disconnect-slave-event-count=#`|
|Type of variable|`integer`|
|Default value|`0`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[option_mysqld_disconnect-slave-event-count](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#option_mysqld_disconnect-slave-event-count)|

## init_replica
|name|value|
|----|-----|
|Name|`init_replica`|
|Command line|`--init-replica=name`|
|Type of variable|`string`|
|Scope|`global`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_init_replica](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_init_replica)|

## log_slow_replica_statements
|name|value|
|----|-----|
|Name|`log_slow_replica_statements`|
|Command line|`--log-slow-replica-statements[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_log_slow_replica_statements](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_log_slow_replica_statements)|

## master_info_repository
|name|value|
|----|-----|
|Name|`master_info_repository`|
|Command line|`--master-info-repository={FILE|TABLE}`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`TABLE`|
|Dynamic|`true`|
|Valid value(s)|`FILE`, `TABLE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_master_info_repository](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_master_info_repository)|

## relay_log_info_repository
|name|value|
|----|-----|
|Name|`relay_log_info_repository`|
|Command line|`--relay-log-info-repository=value`|
|Type of variable|`string`|
|Scope|`global`|
|Default value|`TABLE`|
|Dynamic|`true`|
|Valid value(s)|`FILE`, `TABLE`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_relay_log_info_repository](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_relay_log_info_repository)|

## replica_checkpoint_group
|name|value|
|----|-----|
|Name|`replica_checkpoint_group`|
|Command line|`--replica-checkpoint-group=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`512`|
|Dynamic|`true`|
|Range|from: `32` to: `524280`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_checkpoint_group](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_checkpoint_group)|

## replica_checkpoint_period
|name|value|
|----|-----|
|Name|`replica_checkpoint_period`|
|Command line|`--replica-checkpoint-period=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`300`|
|Dynamic|`true`|
|Range|from: `1` to: `4294967295`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_checkpoint_period](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_checkpoint_period)|

## replica_compressed_protocol
|name|value|
|----|-----|
|Name|`replica_compressed_protocol`|
|Command line|`--replica-compressed-protocol[={OFF|ON}]`|
|Type of variable|`boolean`|
|Scope|`global`|
|Default value|`OFF`|
|Dynamic|`true`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_compressed_protocol](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_compressed_protocol)|

## replica_exec_mode
|name|value|
|----|-----|
|Name|`replica_exec_mode`|
|Command line|`--replica-exec-mode=mode`|
|Type of variable|`enumeration`|
|Scope|`global`|
|Default value|`IDEMPOTENT (NDB)STRICT (Other)`|
|Dynamic|`true`|
|Valid value(s)|`STRICT`, `IDEMPOTENT`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_exec_mode](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_exec_mode)|

## replica_load_tmpdir
|name|value|
|----|-----|
|Name|`replica_load_tmpdir`|
|Command line|`--replica-load-tmpdir=dir_name`|
|Type of variable|`directory name`|
|Scope|`global`|
|Default value|`Value of --tmpdir`|
|Dynamic|`false`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_load_tmpdir](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_load_tmpdir)|

## replica_max_allowed_packet
|name|value|
|----|-----|
|Name|`replica_max_allowed_packet`|
|Command line|`--replica-max-allowed-packet=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`1073741824`|
|Dynamic|`true`|
|Range|from: `1024` to: `1073741824`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_max_allowed_packet](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_max_allowed_packet)|

## replica_net_timeout
|name|value|
|----|-----|
|Name|`replica_net_timeout`|
|Command line|`--replica-net-timeout=#`|
|Type of variable|`integer`|
|Scope|`global`|
|Default value|`60`|
|Dynamic|`true`|
|Range|from: `1` to: `31536000`|

### Documentation(s)
|source|anchor name|
|------|----|
|dev.mysql.com|[sysvar_replica_net_timeout](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replica_net_tim