
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/git/sql/sql_yacc.yy"

#define YYLIP (& thd->m_parser_state->m_lip)
#define YYPS (& thd->m_parser_state->m_yacc)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Alter_table*_statement
#include "sql_truncate.h"                      // Truncate_statement
#include "sql_admin.h"                         // Analyze/Check..._table_stmt
#include "sql_partition_admin.h"               // Alter_table_*_partition_stmt
#include "sql_signal.h"
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable_t *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->dflt)
    it= spv->dflt;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_NO_WRITE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}



/* Line 189 of yacc.c  */
#line 790 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ALWAYS_SYM = 269,
     ANALYZE_SYM = 270,
     AND_AND_SYM = 271,
     AND_SYM = 272,
     ANY_SYM = 273,
     AS = 274,
     ASC = 275,
     ASCII_SYM = 276,
     ASENSITIVE_SYM = 277,
     AT_SYM = 278,
     AUTHORS_SYM = 279,
     AUTOEXTEND_SIZE_SYM = 280,
     AUTO_INC = 281,
     AVG_ROW_LENGTH = 282,
     AVG_SYM = 283,
     BACKUP_SYM = 284,
     BEFORE_SYM = 285,
     BEGIN_SYM = 286,
     BETWEEN_SYM = 287,
     BIGINT = 288,
     BINARY = 289,
     BINLOG_SYM = 290,
     BIN_NUM = 291,
     BIT_AND = 292,
     BIT_OR = 293,
     BIT_SYM = 294,
     BIT_XOR = 295,
     BLOB_SYM = 296,
     BLOCK_SYM = 297,
     BOOLEAN_SYM = 298,
     BOOL_SYM = 299,
     BOTH = 300,
     BTREE_SYM = 301,
     BY = 302,
     BYTE_SYM = 303,
     CACHE_SYM = 304,
     CALL_SYM = 305,
     CASCADE = 306,
     CASCADED = 307,
     CASE_SYM = 308,
     CAST_SYM = 309,
     CATALOG_NAME_SYM = 310,
     CHAIN_SYM = 311,
     CHANGE = 312,
     CHANGED = 313,
     CHARSET = 314,
     CHAR_SYM = 315,
     CHECKPOINT_SYM = 316,
     CHECKSUM_SYM = 317,
     CHECK_SYM = 318,
     CIPHER_SYM = 319,
     CLASS_ORIGIN_SYM = 320,
     CLIENT_SYM = 321,
     CLIENT_STATS_SYM = 322,
     CLOSE_SYM = 323,
     COALESCE = 324,
     CODE_SYM = 325,
     COLLATE_SYM = 326,
     COLLATION_SYM = 327,
     COLUMNS = 328,
     COLUMN_ADD_SYM = 329,
     COLUMN_CREATE_SYM = 330,
     COLUMN_DELETE_SYM = 331,
     COLUMN_EXISTS_SYM = 332,
     COLUMN_GET_SYM = 333,
     COLUMN_LIST_SYM = 334,
     COLUMN_SYM = 335,
     COLUMN_NAME_SYM = 336,
     COMMENT_SYM = 337,
     COMMITTED_SYM = 338,
     COMMIT_SYM = 339,
     COMPACT_SYM = 340,
     COMPLETION_SYM = 341,
     COMPRESSED_SYM = 342,
     CONCURRENT = 343,
     CONDITION_SYM = 344,
     CONNECTION_SYM = 345,
     CONSISTENT_SYM = 346,
     CONSTRAINT = 347,
     CONSTRAINT_CATALOG_SYM = 348,
     CONSTRAINT_NAME_SYM = 349,
     CONSTRAINT_SCHEMA_SYM = 350,
     CONTAINS_SYM = 351,
     CONTEXT_SYM = 352,
     CONTINUE_SYM = 353,
     CONTRIBUTORS_SYM = 354,
     CONVERT_SYM = 355,
     COUNT_SYM = 356,
     CPU_SYM = 357,
     CREATE = 358,
     CROSS = 359,
     CUBE_SYM = 360,
     CURDATE = 361,
     CURRENT_USER = 362,
     CURSOR_SYM = 363,
     CURSOR_NAME_SYM = 364,
     CURTIME = 365,
     DATABASE = 366,
     DATABASES = 367,
     DATAFILE_SYM = 368,
     DATA_SYM = 369,
     DATETIME = 370,
     DATE_ADD_INTERVAL = 371,
     DATE_SUB_INTERVAL = 372,
     DATE_SYM = 373,
     DAY_HOUR_SYM = 374,
     DAY_MICROSECOND_SYM = 375,
     DAY_MINUTE_SYM = 376,
     DAY_SECOND_SYM = 377,
     DAY_SYM = 378,
     DEALLOCATE_SYM = 379,
     DECIMAL_NUM = 380,
     DECIMAL_SYM = 381,
     DECLARE_SYM = 382,
     DEFAULT = 383,
     DEFINER_SYM = 384,
     DELAYED_SYM = 385,
     DELAY_KEY_WRITE_SYM = 386,
     DELETE_SYM = 387,
     DESC = 388,
     DESCRIBE = 389,
     DES_KEY_FILE = 390,
     DETERMINISTIC_SYM = 391,
     DIRECTORY_SYM = 392,
     DISABLE_SYM = 393,
     DISCARD = 394,
     DISK_SYM = 395,
     DISTINCT = 396,
     DIV_SYM = 397,
     DOUBLE_SYM = 398,
     DO_SYM = 399,
     DROP = 400,
     DUAL_SYM = 401,
     DUMPFILE = 402,
     DUPLICATE_SYM = 403,
     DYNAMIC_SYM = 404,
     EACH_SYM = 405,
     ELSE = 406,
     ELSEIF_SYM = 407,
     ENABLE_SYM = 408,
     ENCLOSED = 409,
     END = 410,
     ENDS_SYM = 411,
     END_OF_INPUT = 412,
     ENGINES_SYM = 413,
     ENGINE_SYM = 414,
     ENUM = 415,
     EQ = 416,
     EQUAL_SYM = 417,
     ERROR_SYM = 418,
     ERRORS = 419,
     ESCAPED = 420,
     ESCAPE_SYM = 421,
     EVENTS_SYM = 422,
     EVENT_SYM = 423,
     EVERY_SYM = 424,
     EXAMINED_SYM = 425,
     EXECUTE_SYM = 426,
     EXISTS = 427,
     EXIT_SYM = 428,
     EXPANSION_SYM = 429,
     EXTENDED_SYM = 430,
     EXTENT_SIZE_SYM = 431,
     EXTRACT_SYM = 432,
     FALSE_SYM = 433,
     FAST_SYM = 434,
     FAULTS_SYM = 435,
     FETCH_SYM = 436,
     FILE_SYM = 437,
     FIRST_SYM = 438,
     FIXED_SYM = 439,
     FLOAT_NUM = 440,
     FLOAT_SYM = 441,
     FLUSH_SYM = 442,
     FORCE_SYM = 443,
     FOREIGN = 444,
     FOR_SYM = 445,
     FOUND_SYM = 446,
     FROM = 447,
     FULL = 448,
     FULLTEXT_SYM = 449,
     FUNCTION_SYM = 450,
     GE = 451,
     GENERAL = 452,
     GENERATED_SYM = 453,
     GEOMETRYCOLLECTION = 454,
     GEOMETRY_SYM = 455,
     GET_FORMAT = 456,
     GLOBAL_SYM = 457,
     GRANT = 458,
     GRANTS = 459,
     GROUP_SYM = 460,
     GROUP_CONCAT_SYM = 461,
     GT_SYM = 462,
     HANDLER_SYM = 463,
     HARD_SYM = 464,
     HASH_SYM = 465,
     HAVING = 466,
     HELP_SYM = 467,
     HEX_NUM = 468,
     HEX_STRING = 469,
     HIGH_PRIORITY = 470,
     HOST_SYM = 471,
     HOSTS_SYM = 472,
     HOUR_MICROSECOND_SYM = 473,
     HOUR_MINUTE_SYM = 474,
     HOUR_SECOND_SYM = 475,
     HOUR_SYM = 476,
     IDENT = 477,
     IDENTIFIED_SYM = 478,
     IDENT_QUOTED = 479,
     IF = 480,
     IGNORE_SYM = 481,
     IGNORE_SERVER_IDS_SYM = 482,
     IMPORT = 483,
     INDEXES = 484,
     INDEX_SYM = 485,
     INDEX_STATS_SYM = 486,
     INFILE = 487,
     INITIAL_SIZE_SYM = 488,
     INNER_SYM = 489,
     INOUT_SYM = 490,
     INSENSITIVE_SYM = 491,
     INSERT = 492,
     INSERT_METHOD = 493,
     INSTALL_SYM = 494,
     INTERVAL_SYM = 495,
     INTO = 496,
     INT_SYM = 497,
     INVOKER_SYM = 498,
     IN_SYM = 499,
     IO_SYM = 500,
     IPC_SYM = 501,
     IS = 502,
     ISOLATION = 503,
     ISSUER_SYM = 504,
     ITERATE_SYM = 505,
     JOIN_SYM = 506,
     KEYS = 507,
     KEY_BLOCK_SIZE = 508,
     KEY_SYM = 509,
     KILL_SYM = 510,
     LANGUAGE_SYM = 511,
     LAST_SYM = 512,
     LAST_VALUE = 513,
     LE = 514,
     LEADING = 515,
     LEAVES = 516,
     LEAVE_SYM = 517,
     LEFT = 518,
     LESS_SYM = 519,
     LEVEL_SYM = 520,
     LEX_HOSTNAME = 521,
     LIKE = 522,
     LIMIT = 523,
     LINEAR_SYM = 524,
     LINES = 525,
     LINESTRING = 526,
     LIST_SYM = 527,
     LOAD = 528,
     LOCAL_SYM = 529,
     LOCATOR_SYM = 530,
     LOCKS_SYM = 531,
     LOCK_SYM = 532,
     LOGFILE_SYM = 533,
     LOGS_SYM = 534,
     LONGBLOB = 535,
     LONGTEXT = 536,
     LONG_NUM = 537,
     LONG_SYM = 538,
     LOOP_SYM = 539,
     LOW_PRIORITY = 540,
     LT = 541,
     MASTER_CONNECT_RETRY_SYM = 542,
     MASTER_HOST_SYM = 543,
     MASTER_LOG_FILE_SYM = 544,
     MASTER_LOG_POS_SYM = 545,
     MASTER_PASSWORD_SYM = 546,
     MASTER_PORT_SYM = 547,
     MASTER_SERVER_ID_SYM = 548,
     MASTER_SSL_CAPATH_SYM = 549,
     MASTER_SSL_CA_SYM = 550,
     MASTER_SSL_CERT_SYM = 551,
     MASTER_SSL_CIPHER_SYM = 552,
     MASTER_SSL_KEY_SYM = 553,
     MASTER_SSL_SYM = 554,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 555,
     MASTER_SYM = 556,
     MASTER_USER_SYM = 557,
     MASTER_HEARTBEAT_PERIOD_SYM = 558,
     MATCH = 559,
     MAX_CONNECTIONS_PER_HOUR = 560,
     MAX_QUERIES_PER_HOUR = 561,
     MAX_ROWS = 562,
     MAX_SIZE_SYM = 563,
     MAX_SYM = 564,
     MAX_UPDATES_PER_HOUR = 565,
     MAX_USER_CONNECTIONS_SYM = 566,
     MAX_VALUE_SYM = 567,
     MEDIUMBLOB = 568,
     MEDIUMINT = 569,
     MEDIUMTEXT = 570,
     MEDIUM_SYM = 571,
     MEMORY_SYM = 572,
     MERGE_SYM = 573,
     MESSAGE_TEXT_SYM = 574,
     MICROSECOND_SYM = 575,
     MIGRATE_SYM = 576,
     MINUTE_MICROSECOND_SYM = 577,
     MINUTE_SECOND_SYM = 578,
     MINUTE_SYM = 579,
     MIN_ROWS = 580,
     MIN_SYM = 581,
     MODE_SYM = 582,
     MODIFIES_SYM = 583,
     MODIFY_SYM = 584,
     MOD_SYM = 585,
     MONTH_SYM = 586,
     MULTILINESTRING = 587,
     MULTIPOINT = 588,
     MULTIPOLYGON = 589,
     MUTEX_SYM = 590,
     MYSQL_SYM = 591,
     MYSQL_ERRNO_SYM = 592,
     NAMES_SYM = 593,
     NAME_SYM = 594,
     NATIONAL_SYM = 595,
     NATURAL = 596,
     NCHAR_STRING = 597,
     NCHAR_SYM = 598,
     NDBCLUSTER_SYM = 599,
     NE = 600,
     NEG = 601,
     NEW_SYM = 602,
     NEXT_SYM = 603,
     NODEGROUP_SYM = 604,
     NONE_SYM = 605,
     NOT2_SYM = 606,
     NOT_SYM = 607,
     NOW_SYM = 608,
     NO_SYM = 609,
     NO_WAIT_SYM = 610,
     NO_WRITE_TO_BINLOG = 611,
     NULL_SYM = 612,
     NUM = 613,
     NUMERIC_SYM = 614,
     NVARCHAR_SYM = 615,
     OFFSET_SYM = 616,
     OLD_PASSWORD = 617,
     ON = 618,
     ONE_SHOT_SYM = 619,
     ONE_SYM = 620,
     ONLINE_SYM = 621,
     OPEN_SYM = 622,
     OPTIMIZE = 623,
     OPTIONS_SYM = 624,
     OPTION = 625,
     OPTIONALLY = 626,
     OR2_SYM = 627,
     ORDER_SYM = 628,
     OR_OR_SYM = 629,
     OR_SYM = 630,
     OUTER = 631,
     OUTFILE = 632,
     OUT_SYM = 633,
     OWNER_SYM = 634,
     PACK_KEYS_SYM = 635,
     PAGE_SYM = 636,
     PAGE_CHECKSUM_SYM = 637,
     PARAM_MARKER = 638,
     PARSER_SYM = 639,
     PARSE_VCOL_EXPR_SYM = 640,
     PARTIAL = 641,
     PARTITIONING_SYM = 642,
     PARTITIONS_SYM = 643,
     PARTITION_SYM = 644,
     PASSWORD = 645,
     PERSISTENT_SYM = 646,
     PHASE_SYM = 647,
     PLUGINS_SYM = 648,
     PLUGIN_SYM = 649,
     POINT_SYM = 650,
     POLYGON = 651,
     PORT_SYM = 652,
     POSITION_SYM = 653,
     PRECISION = 654,
     PREPARE_SYM = 655,
     PRESERVE_SYM = 656,
     PREV_SYM = 657,
     PRIMARY_SYM = 658,
     PRIVILEGES = 659,
     PROCEDURE_SYM = 660,
     PROCESS = 661,
     PROCESSLIST_SYM = 662,
     PROFILE_SYM = 663,
     PROFILES_SYM = 664,
     PROXY_SYM = 665,
     PURGE = 666,
     QUARTER_SYM = 667,
     QUERY_SYM = 668,
     QUICK = 669,
     RANGE_SYM = 670,
     READS_SYM = 671,
     READ_ONLY_SYM = 672,
     READ_SYM = 673,
     READ_WRITE_SYM = 674,
     REAL = 675,
     REBUILD_SYM = 676,
     RECOVER_SYM = 677,
     REDOFILE_SYM = 678,
     REDO_BUFFER_SIZE_SYM = 679,
     REDUNDANT_SYM = 680,
     REFERENCES = 681,
     REGEXP = 682,
     RELAY = 683,
     RELAYLOG_SYM = 684,
     RELAY_LOG_FILE_SYM = 685,
     RELAY_LOG_POS_SYM = 686,
     RELAY_THREAD = 687,
     RELEASE_SYM = 688,
     RELOAD = 689,
     REMOVE_SYM = 690,
     RENAME = 691,
     REORGANIZE_SYM = 692,
     REPAIR = 693,
     REPEATABLE_SYM = 694,
     REPEAT_SYM = 695,
     REPLACE = 696,
     REPLICATION = 697,
     REQUIRE_SYM = 698,
     RESET_SYM = 699,
     RESIGNAL_SYM = 700,
     RESOURCES = 701,
     RESTORE_SYM = 702,
     RESTRICT = 703,
     RESUME_SYM = 704,
     RETURNS_SYM = 705,
     RETURN_SYM = 706,
     REVOKE = 707,
     RIGHT = 708,
     ROLLBACK_SYM = 709,
     ROLLUP_SYM = 710,
     ROUTINE_SYM = 711,
     ROWS_SYM = 712,
     ROW_FORMAT_SYM = 713,
     ROW_SYM = 714,
     RTREE_SYM = 715,
     SAVEPOINT_SYM = 716,
     SCHEDULE_SYM = 717,
     SCHEMA_NAME_SYM = 718,
     SECOND_MICROSECOND_SYM = 719,
     SECOND_SYM = 720,
     SECURITY_SYM = 721,
     SELECT_SYM = 722,
     SENSITIVE_SYM = 723,
     SEPARATOR_SYM = 724,
     SERIALIZABLE_SYM = 725,
     SERIAL_SYM = 726,
     SESSION_SYM = 727,
     SERVER_SYM = 728,
     SERVER_OPTIONS = 729,
     SET = 730,
     SET_VAR = 731,
     SHARE_SYM = 732,
     SHIFT_LEFT = 733,
     SHIFT_RIGHT = 734,
     SHOW = 735,
     SHUTDOWN = 736,
     SIGNAL_SYM = 737,
     SIGNED_SYM = 738,
     SIMPLE_SYM = 739,
     SLAVE = 740,
     SLOW = 741,
     SMALLINT = 742,
     SNAPSHOT_SYM = 743,
     SOCKET_SYM = 744,
     SOFT_SYM = 745,
     SONAME_SYM = 746,
     SOUNDS_SYM = 747,
     SOURCE_SYM = 748,
     SPATIAL_SYM = 749,
     SPECIFIC_SYM = 750,
     SQLEXCEPTION_SYM = 751,
     SQLSTATE_SYM = 752,
     SQLWARNING_SYM = 753,
     SQL_BIG_RESULT = 754,
     SQL_BUFFER_RESULT = 755,
     SQL_CACHE_SYM = 756,
     SQL_CALC_FOUND_ROWS = 757,
     SQL_NO_CACHE_SYM = 758,
     SQL_SMALL_RESULT = 759,
     SQL_SYM = 760,
     SQL_THREAD = 761,
     SSL_SYM = 762,
     STARTING = 763,
     STARTS_SYM = 764,
     START_SYM = 765,
     STATUS_SYM = 766,
     STDDEV_SAMP_SYM = 767,
     STD_SYM = 768,
     STOP_SYM = 769,
     STORAGE_SYM = 770,
     STRAIGHT_JOIN = 771,
     STRING_SYM = 772,
     SUBCLASS_ORIGIN_SYM = 773,
     SUBDATE_SYM = 774,
     SUBJECT_SYM = 775,
     SUBPARTITIONS_SYM = 776,
     SUBPARTITION_SYM = 777,
     SUBSTRING = 778,
     SUM_SYM = 779,
     SUPER_SYM = 780,
     SUSPEND_SYM = 781,
     SWAPS_SYM = 782,
     SWITCHES_SYM = 783,
     SYSDATE = 784,
     TABLES = 785,
     TABLESPACE = 786,
     TABLE_REF_PRIORITY = 787,
     TABLE_STATS_SYM = 788,
     TABLE_SYM = 789,
     TABLE_CHECKSUM_SYM = 790,
     TABLE_NAME_SYM = 791,
     TEMPORARY = 792,
     TEMPTABLE_SYM = 793,
     TERMINATED = 794,
     TEXT_STRING = 795,
     TEXT_SYM = 796,
     THAN_SYM = 797,
     THEN_SYM = 798,
     TIMESTAMP = 799,
     TIMESTAMP_ADD = 800,
     TIMESTAMP_DIFF = 801,
     TIME_SYM = 802,
     TINYBLOB = 803,
     TINYINT = 804,
     TINYTEXT = 805,
     TO_SYM = 806,
     TRAILING = 807,
     TRANSACTION_SYM = 808,
     TRANSACTIONAL_SYM = 809,
     TRIGGERS_SYM = 810,
     TRIGGER_SYM = 811,
     TRIM = 812,
     TRUE_SYM = 813,
     TRUNCATE_SYM = 814,
     TYPES_SYM = 815,
     TYPE_SYM = 816,
     UDF_RETURNS_SYM = 817,
     ULONGLONG_NUM = 818,
     UNCOMMITTED_SYM = 819,
     UNDEFINED_SYM = 820,
     UNDERSCORE_CHARSET = 821,
     UNDOFILE_SYM = 822,
     UNDO_BUFFER_SIZE_SYM = 823,
     UNDO_SYM = 824,
     UNICODE_SYM = 825,
     UNINSTALL_SYM = 826,
     UNION_SYM = 827,
     UNIQUE_SYM = 828,
     UNKNOWN_SYM = 829,
     UNLOCK_SYM = 830,
     UNSIGNED = 831,
     UNTIL_SYM = 832,
     UPDATE_SYM = 833,
     UPGRADE_SYM = 834,
     USAGE = 835,
     USER = 836,
     USER_STATS_SYM = 837,
     USE_FRM = 838,
     USE_SYM = 839,
     USING = 840,
     UTC_DATE_SYM = 841,
     UTC_TIMESTAMP_SYM = 842,
     UTC_TIME_SYM = 843,
     VALUES = 844,
     VALUE_SYM = 845,
     VARBINARY = 846,
     VARCHAR = 847,
     VARIABLES = 848,
     VARIANCE_SYM = 849,
     VARYING = 850,
     VAR_SAMP_SYM = 851,
     VIA_SYM = 852,
     VIEW_SYM = 853,
     VIRTUAL_SYM = 854,
     WAIT_SYM = 855,
     WARNINGS = 856,
     WEEK_SYM = 857,
     WHEN_SYM = 858,
     WHERE = 859,
     WHILE_SYM = 860,
     WITH = 861,
     WITH_CUBE_SYM = 862,
     WITH_ROLLUP_SYM = 863,
     WORK_SYM = 864,
     WRAPPER_SYM = 865,
     WRITE_SYM = 866,
     X509_SYM = 867,
     XA_SYM = 868,
     XML_SYM = 869,
     XOR = 870,
     YEAR_MONTH_SYM = 871,
     YEAR_SYM = 872,
     ZEROFILL = 873,
     IMPOSSIBLE_ACTION = 874
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ALWAYS_SYM 269
#define ANALYZE_SYM 270
#define AND_AND_SYM 271
#define AND_SYM 272
#define ANY_SYM 273
#define AS 274
#define ASC 275
#define ASCII_SYM 276
#define ASENSITIVE_SYM 277
#define AT_SYM 278
#define AUTHORS_SYM 279
#define AUTOEXTEND_SIZE_SYM 280
#define AUTO_INC 281
#define AVG_ROW_LENGTH 282
#define AVG_SYM 283
#define BACKUP_SYM 284
#define BEFORE_SYM 285
#define BEGIN_SYM 286
#define BETWEEN_SYM 287
#define BIGINT 288
#define BINARY 289
#define BINLOG_SYM 290
#define BIN_NUM 291
#define BIT_AND 292
#define BIT_OR 293
#define BIT_SYM 294
#define BIT_XOR 295
#define BLOB_SYM 296
#define BLOCK_SYM 297
#define BOOLEAN_SYM 298
#define BOOL_SYM 299
#define BOTH 300
#define BTREE_SYM 301
#define BY 302
#define BYTE_SYM 303
#define CACHE_SYM 304
#define CALL_SYM 305
#define CASCADE 306
#define CASCADED 307
#define CASE_SYM 308
#define CAST_SYM 309
#define CATALOG_NAME_SYM 310
#define CHAIN_SYM 311
#define CHANGE 312
#define CHANGED 313
#define CHARSET 314
#define CHAR_SYM 315
#define CHECKPOINT_SYM 316
#define CHECKSUM_SYM 317
#define CHECK_SYM 318
#define CIPHER_SYM 319
#define CLASS_ORIGIN_SYM 320
#define CLIENT_SYM 321
#define CLIENT_STATS_SYM 322
#define CLOSE_SYM 323
#define COALESCE 324
#define CODE_SYM 325
#define COLLATE_SYM 326
#define COLLATION_SYM 327
#define COLUMNS 328
#define COLUMN_ADD_SYM 329
#define COLUMN_CREATE_SYM 330
#define COLUMN_DELETE_SYM 331
#define COLUMN_EXISTS_SYM 332
#define COLUMN_GET_SYM 333
#define COLUMN_LIST_SYM 334
#define COLUMN_SYM 335
#define COLUMN_NAME_SYM 336
#define COMMENT_SYM 337
#define COMMITTED_SYM 338
#define COMMIT_SYM 339
#define COMPACT_SYM 340
#define COMPLETION_SYM 341
#define COMPRESSED_SYM 342
#define CONCURRENT 343
#define CONDITION_SYM 344
#define CONNECTION_SYM 345
#define CONSISTENT_SYM 346
#define CONSTRAINT 347
#define CONSTRAINT_CATALOG_SYM 348
#define CONSTRAINT_NAME_SYM 349
#define CONSTRAINT_SCHEMA_SYM 350
#define CONTAINS_SYM 351
#define CONTEXT_SYM 352
#define CONTINUE_SYM 353
#define CONTRIBUTORS_SYM 354
#define CONVERT_SYM 355
#define COUNT_SYM 356
#define CPU_SYM 357
#define CREATE 358
#define CROSS 359
#define CUBE_SYM 360
#define CURDATE 361
#define CURRENT_USER 362
#define CURSOR_SYM 363
#define CURSOR_NAME_SYM 364
#define CURTIME 365
#define DATABASE 366
#define DATABASES 367
#define DATAFILE_SYM 368
#define DATA_SYM 369
#define DATETIME 370
#define DATE_ADD_INTERVAL 371
#define DATE_SUB_INTERVAL 372
#define DATE_SYM 373
#define DAY_HOUR_SYM 374
#define DAY_MICROSECOND_SYM 375
#define DAY_MINUTE_SYM 376
#define DAY_SECOND_SYM 377
#define DAY_SYM 378
#define DEALLOCATE_SYM 379
#define DECIMAL_NUM 380
#define DECIMAL_SYM 381
#define DECLARE_SYM 382
#define DEFAULT 383
#define DEFINER_SYM 384
#define DELAYED_SYM 385
#define DELAY_KEY_WRITE_SYM 386
#define DELETE_SYM 387
#define DESC 388
#define DESCRIBE 389
#define DES_KEY_FILE 390
#define DETERMINISTIC_SYM 391
#define DIRECTORY_SYM 392
#define DISABLE_SYM 393
#define DISCARD 394
#define DISK_SYM 395
#define DISTINCT 396
#define DIV_SYM 397
#define DOUBLE_SYM 398
#define DO_SYM 399
#define DROP 400
#define DUAL_SYM 401
#define DUMPFILE 402
#define DUPLICATE_SYM 403
#define DYNAMIC_SYM 404
#define EACH_SYM 405
#define ELSE 406
#define ELSEIF_SYM 407
#define ENABLE_SYM 408
#define ENCLOSED 409
#define END 410
#define ENDS_SYM 411
#define END_OF_INPUT 412
#define ENGINES_SYM 413
#define ENGINE_SYM 414
#define ENUM 415
#define EQ 416
#define EQUAL_SYM 417
#define ERROR_SYM 418
#define ERRORS 419
#define ESCAPED 420
#define ESCAPE_SYM 421
#define EVENTS_SYM 422
#define EVENT_SYM 423
#define EVERY_SYM 424
#define EXAMINED_SYM 425
#define EXECUTE_SYM 426
#define EXISTS 427
#define EXIT_SYM 428
#define EXPANSION_SYM 429
#define EXTENDED_SYM 430
#define EXTENT_SIZE_SYM 431
#define EXTRACT_SYM 432
#define FALSE_SYM 433
#define FAST_SYM 434
#define FAULTS_SYM 435
#define FETCH_SYM 436
#define FILE_SYM 437
#define FIRST_SYM 438
#define FIXED_SYM 439
#define FLOAT_NUM 440
#define FLOAT_SYM 441
#define FLUSH_SYM 442
#define FORCE_SYM 443
#define FOREIGN 444
#define FOR_SYM 445
#define FOUND_SYM 446
#define FROM 447
#define FULL 448
#define FULLTEXT_SYM 449
#define FUNCTION_SYM 450
#define GE 451
#define GENERAL 452
#define GENERATED_SYM 453
#define GEOMETRYCOLLECTION 454
#define GEOMETRY_SYM 455
#define GET_FORMAT 456
#define GLOBAL_SYM 457
#define GRANT 458
#define GRANTS 459
#define GROUP_SYM 460
#define GROUP_CONCAT_SYM 461
#define GT_SYM 462
#define HANDLER_SYM 463
#define HARD_SYM 464
#define HASH_SYM 465
#define HAVING 466
#define HELP_SYM 467
#define HEX_NUM 468
#define HEX_STRING 469
#define HIGH_PRIORITY 470
#define HOST_SYM 471
#define HOSTS_SYM 472
#define HOUR_MICROSECOND_SYM 473
#define HOUR_MINUTE_SYM 474
#define HOUR_SECOND_SYM 475
#define HOUR_SYM 476
#define IDENT 477
#define IDENTIFIED_SYM 478
#define IDENT_QUOTED 479
#define IF 480
#define IGNORE_SYM 481
#define IGNORE_SERVER_IDS_SYM 482
#define IMPORT 483
#define INDEXES 484
#define INDEX_SYM 485
#define INDEX_STATS_SYM 486
#define INFILE 487
#define INITIAL_SIZE_SYM 488
#define INNER_SYM 489
#define INOUT_SYM 490
#define INSENSITIVE_SYM 491
#define INSERT 492
#define INSERT_METHOD 493
#define INSTALL_SYM 494
#define INTERVAL_SYM 495
#define INTO 496
#define INT_SYM 497
#define INVOKER_SYM 498
#define IN_SYM 499
#define IO_SYM 500
#define IPC_SYM 501
#define IS 502
#define ISOLATION 503
#define ISSUER_SYM 504
#define ITERATE_SYM 505
#define JOIN_SYM 506
#define KEYS 507
#define KEY_BLOCK_SIZE 508
#define KEY_SYM 509
#define KILL_SYM 510
#define LANGUAGE_SYM 511
#define LAST_SYM 512
#define LAST_VALUE 513
#define LE 514
#define LEADING 515
#define LEAVES 516
#define LEAVE_SYM 517
#define LEFT 518
#define LESS_SYM 519
#define LEVEL_SYM 520
#define LEX_HOSTNAME 521
#define LIKE 522
#define LIMIT 523
#define LINEAR_SYM 524
#define LINES 525
#define LINESTRING 526
#define LIST_SYM 527
#define LOAD 528
#define LOCAL_SYM 529
#define LOCATOR_SYM 530
#define LOCKS_SYM 531
#define LOCK_SYM 532
#define LOGFILE_SYM 533
#define LOGS_SYM 534
#define LONGBLOB 535
#define LONGTEXT 536
#define LONG_NUM 537
#define LONG_SYM 538
#define LOOP_SYM 539
#define LOW_PRIORITY 540
#define LT 541
#define MASTER_CONNECT_RETRY_SYM 542
#define MASTER_HOST_SYM 543
#define MASTER_LOG_FILE_SYM 544
#define MASTER_LOG_POS_SYM 545
#define MASTER_PASSWORD_SYM 546
#define MASTER_PORT_SYM 547
#define MASTER_SERVER_ID_SYM 548
#define MASTER_SSL_CAPATH_SYM 549
#define MASTER_SSL_CA_SYM 550
#define MASTER_SSL_CERT_SYM 551
#define MASTER_SSL_CIPHER_SYM 552
#define MASTER_SSL_KEY_SYM 553
#define MASTER_SSL_SYM 554
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 555
#define MASTER_SYM 556
#define MASTER_USER_SYM 557
#define MASTER_HEARTBEAT_PERIOD_SYM 558
#define MATCH 559
#define MAX_CONNECTIONS_PER_HOUR 560
#define MAX_QUERIES_PER_HOUR 561
#define MAX_ROWS 562
#define MAX_SIZE_SYM 563
#define MAX_SYM 564
#define MAX_UPDATES_PER_HOUR 565
#define MAX_USER_CONNECTIONS_SYM 566
#define MAX_VALUE_SYM 567
#define MEDIUMBLOB 568
#define MEDIUMINT 569
#define MEDIUMTEXT 570
#define MEDIUM_SYM 571
#define MEMORY_SYM 572
#define MERGE_SYM 573
#define MESSAGE_TEXT_SYM 574
#define MICROSECOND_SYM 575
#define MIGRATE_SYM 576
#define MINUTE_MICROSECOND_SYM 577
#define MINUTE_SECOND_SYM 578
#define MINUTE_SYM 579
#define MIN_ROWS 580
#define MIN_SYM 581
#define MODE_SYM 582
#define MODIFIES_SYM 583
#define MODIFY_SYM 584
#define MOD_SYM 585
#define MONTH_SYM 586
#define MULTILINESTRING 587
#define MULTIPOINT 588
#define MULTIPOLYGON 589
#define MUTEX_SYM 590
#define MYSQL_SYM 591
#define MYSQL_ERRNO_SYM 592
#define NAMES_SYM 593
#define NAME_SYM 594
#define NATIONAL_SYM 595
#define NATURAL 596
#define NCHAR_STRING 597
#define NCHAR_SYM 598
#define NDBCLUSTER_SYM 599
#define NE 600
#define NEG 601
#define NEW_SYM 602
#define NEXT_SYM 603
#define NODEGROUP_SYM 604
#define NONE_SYM 605
#define NOT2_SYM 606
#define NOT_SYM 607
#define NOW_SYM 608
#define NO_SYM 609
#define NO_WAIT_SYM 610
#define NO_WRITE_TO_BINLOG 611
#define NULL_SYM 612
#define NUM 613
#define NUMERIC_SYM 614
#define NVARCHAR_SYM 615
#define OFFSET_SYM 616
#define OLD_PASSWORD 617
#define ON 618
#define ONE_SHOT_SYM 619
#define ONE_SYM 620
#define ONLINE_SYM 621
#define OPEN_SYM 622
#define OPTIMIZE 623
#define OPTIONS_SYM 624
#define OPTION 625
#define OPTIONALLY 626
#define OR2_SYM 627
#define ORDER_SYM 628
#define OR_OR_SYM 629
#define OR_SYM 630
#define OUTER 631
#define OUTFILE 632
#define OUT_SYM 633
#define OWNER_SYM 634
#define PACK_KEYS_SYM 635
#define PAGE_SYM 636
#define PAGE_CHECKSUM_SYM 637
#define PARAM_MARKER 638
#define PARSER_SYM 639
#define PARSE_VCOL_EXPR_SYM 640
#define PARTIAL 641
#define PARTITIONING_SYM 642
#define PARTITIONS_SYM 643
#define PARTITION_SYM 644
#define PASSWORD 645
#define PERSISTENT_SYM 646
#define PHASE_SYM 647
#define PLUGINS_SYM 648
#define PLUGIN_SYM 649
#define POINT_SYM 650
#define POLYGON 651
#define PORT_SYM 652
#define POSITION_SYM 653
#define PRECISION 654
#define PREPARE_SYM 655
#define PRESERVE_SYM 656
#define PREV_SYM 657
#define PRIMARY_SYM 658
#define PRIVILEGES 659
#define PROCEDURE_SYM 660
#define PROCESS 661
#define PROCESSLIST_SYM 662
#define PROFILE_SYM 663
#define PROFILES_SYM 664
#define PROXY_SYM 665
#define PURGE 666
#define QUARTER_SYM 667
#define QUERY_SYM 668
#define QUICK 669
#define RANGE_SYM 670
#define READS_SYM 671
#define READ_ONLY_SYM 672
#define READ_SYM 673
#define READ_WRITE_SYM 674
#define REAL 675
#define REBUILD_SYM 676
#define RECOVER_SYM 677
#define REDOFILE_SYM 678
#define REDO_BUFFER_SIZE_SYM 679
#define REDUNDANT_SYM 680
#define REFERENCES 681
#define REGEXP 682
#define RELAY 683
#define RELAYLOG_SYM 684
#define RELAY_LOG_FILE_SYM 685
#define RELAY_LOG_POS_SYM 686
#define RELAY_THREAD 687
#define RELEASE_SYM 688
#define RELOAD 689
#define REMOVE_SYM 690
#define RENAME 691
#define REORGANIZE_SYM 692
#define REPAIR 693
#define REPEATABLE_SYM 694
#define REPEAT_SYM 695
#define REPLACE 696
#define REPLICATION 697
#define REQUIRE_SYM 698
#define RESET_SYM 699
#define RESIGNAL_SYM 700
#define RESOURCES 701
#define RESTORE_SYM 702
#define RESTRICT 703
#define RESUME_SYM 704
#define RETURNS_SYM 705
#define RETURN_SYM 706
#define REVOKE 707
#define RIGHT 708
#define ROLLBACK_SYM 709
#define ROLLUP_SYM 710
#define ROUTINE_SYM 711
#define ROWS_SYM 712
#define ROW_FORMAT_SYM 713
#define ROW_SYM 714
#define RTREE_SYM 715
#define SAVEPOINT_SYM 716
#define SCHEDULE_SYM 717
#define SCHEMA_NAME_SYM 718
#define SECOND_MICROSECOND_SYM 719
#define SECOND_SYM 720
#define SECURITY_SYM 721
#define SELECT_SYM 722
#define SENSITIVE_SYM 723
#define SEPARATOR_SYM 724
#define SERIALIZABLE_SYM 725
#define SERIAL_SYM 726
#define SESSION_SYM 727
#define SERVER_SYM 728
#define SERVER_OPTIONS 729
#define SET 730
#define SET_VAR 731
#define SHARE_SYM 732
#define SHIFT_LEFT 733
#define SHIFT_RIGHT 734
#define SHOW 735
#define SHUTDOWN 736
#define SIGNAL_SYM 737
#define SIGNED_SYM 738
#define SIMPLE_SYM 739
#define SLAVE 740
#define SLOW 741
#define SMALLINT 742
#define SNAPSHOT_SYM 743
#define SOCKET_SYM 744
#define SOFT_SYM 745
#define SONAME_SYM 746
#define SOUNDS_SYM 747
#define SOURCE_SYM 748
#define SPATIAL_SYM 749
#define SPECIFIC_SYM 750
#define SQLEXCEPTION_SYM 751
#define SQLSTATE_SYM 752
#define SQLWARNING_SYM 753
#define SQL_BIG_RESULT 754
#define SQL_BUFFER_RESULT 755
#define SQL_CACHE_SYM 756
#define SQL_CALC_FOUND_ROWS 757
#define SQL_NO_CACHE_SYM 758
#define SQL_SMALL_RESULT 759
#define SQL_SYM 760
#define SQL_THREAD 761
#define SSL_SYM 762
#define STARTING 763
#define STARTS_SYM 764
#define START_SYM 765
#define STATUS_SYM 766
#define STDDEV_SAMP_SYM 767
#define STD_SYM 768
#define STOP_SYM 769
#define STORAGE_SYM 770
#define STRAIGHT_JOIN 771
#define STRING_SYM 772
#define SUBCLASS_ORIGIN_SYM 773
#define SUBDATE_SYM 774
#define SUBJECT_SYM 775
#define SUBPARTITIONS_SYM 776
#define SUBPARTITION_SYM 777
#define SUBSTRING 778
#define SUM_SYM 779
#define SUPER_SYM 780
#define SUSPEND_SYM 781
#define SWAPS_SYM 782
#define SWITCHES_SYM 783
#define SYSDATE 784
#define TABLES 785
#define TABLESPACE 786
#define TABLE_REF_PRIORITY 787
#define TABLE_STATS_SYM 788
#define TABLE_SYM 789
#define TABLE_CHECKSUM_SYM 790
#define TABLE_NAME_SYM 791
#define TEMPORARY 792
#define TEMPTABLE_SYM 793
#define TERMINATED 794
#define TEXT_STRING 795
#define TEXT_SYM 796
#define THAN_SYM 797
#define THEN_SYM 798
#define TIMESTAMP 799
#define TIMESTAMP_ADD 800
#define TIMESTAMP_DIFF 801
#define TIME_SYM 802
#define TINYBLOB 803
#define TINYINT 804
#define TINYTEXT 805
#define TO_SYM 806
#define TRAILING 807
#define TRANSACTION_SYM 808
#define TRANSACTIONAL_SYM 809
#define TRIGGERS_SYM 810
#define TRIGGER_SYM 811
#define TRIM 812
#define TRUE_SYM 813
#define TRUNCATE_SYM 814
#define TYPES_SYM 815
#define TYPE_SYM 816
#define UDF_RETURNS_SYM 817
#define ULONGLONG_NUM 818
#define UNCOMMITTED_SYM 819
#define UNDEFINED_SYM 820
#define UNDERSCORE_CHARSET 821
#define UNDOFILE_SYM 822
#define UNDO_BUFFER_SIZE_SYM 823
#define UNDO_SYM 824
#define UNICODE_SYM 825
#define UNINSTALL_SYM 826
#define UNION_SYM 827
#define UNIQUE_SYM 828
#define UNKNOWN_SYM 829
#define UNLOCK_SYM 830
#define UNSIGNED 831
#define UNTIL_SYM 832
#define UPDATE_SYM 833
#define UPGRADE_SYM 834
#define USAGE 835
#define USER 836
#define USER_STATS_SYM 837
#define USE_FRM 838
#define USE_SYM 839
#define USING 840
#define UTC_DATE_SYM 841
#define UTC_TIMESTAMP_SYM 842
#define UTC_TIME_SYM 843
#define VALUES 844
#define VALUE_SYM 845
#define VARBINARY 846
#define VARCHAR 847
#define VARIABLES 848
#define VARIANCE_SYM 849
#define VARYING 850
#define VAR_SAMP_SYM 851
#define VIA_SYM 852
#define VIEW_SYM 853
#define VIRTUAL_SYM 854
#define WAIT_SYM 855
#define WARNINGS 856
#define WEEK_SYM 857
#define WHEN_SYM 858
#define WHERE 859
#define WHILE_SYM 860
#define WITH 861
#define WITH_CUBE_SYM 862
#define WITH_ROLLUP_SYM 863
#define WORK_SYM 864
#define WRAPPER_SYM 865
#define WRITE_SYM 866
#define X509_SYM 867
#define XA_SYM 868
#define XML_SYM 869
#define XOR 870
#define YEAR_MONTH_SYM 871
#define YEAR_SYM 872
#define ZEROFILL 873
#define IMPOSSIBLE_ACTION 874




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 732 "/home/buildbot/git/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  LEX_TYPE lex_type;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2119 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 785 "/home/buildbot/git/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2136 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  604
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   56493

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  639
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  925
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2636
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4464

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   874

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   632,     2,     2,     2,   626,   621,     2,
     629,   630,   624,   623,   631,   622,   637,   625,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   638,   635,
       2,     2,     2,     2,   636,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   627,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   633,   620,   634,   628,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   131,   133,   135,   140,   142,   145,
     146,   151,   152,   155,   159,   161,   164,   165,   169,   170,
     176,   178,   182,   186,   190,   194,   198,   202,   206,   210,
     214,   218,   222,   226,   230,   234,   240,   242,   243,   245,
     249,   251,   255,   259,   263,   267,   268,   276,   277,   290,
     291,   304,   305,   318,   319,   326,   327,   331,   336,   341,
     345,   348,   359,   361,   365,   368,   371,   374,   377,   380,
     383,   386,   387,   401,   402,   409,   412,   413,   415,   419,
     421,   422,   425,   426,   429,   430,   432,   436,   441,   442,
     445,   446,   449,   451,   453,   455,   457,   459,   461,   463,
     465,   467,   469,   471,   473,   475,   476,   480,   482,   483,
     486,   487,   490,   493,   496,   499,   502,   506,   510,   512,
     514,   516,   519,   523,   527,   528,   533,   534,   538,   539,
     541,   545,   547,   548,   550,   554,   556,   557,   561,   562,
     564,   568,   570,   575,   576,   578,   580,   582,   583,   587,
     590,   594,   595,   599,   600,   606,   612,   613,   621,   627,
     628,   631,   633,   635,   637,   641,   643,   645,   647,   651,
     652,   654,   656,   658,   660,   663,   665,   669,   671,   673,
     674,   676,   677,   680,   684,   690,   692,   694,   696,   698,
     700,   702,   704,   706,   708,   710,   712,   714,   716,   718,
     720,   724,   726,   730,   731,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   754,   756,   758,   760,   761,
     767,   768,   771,   772,   776,   777,   780,   783,   786,   789,
     790,   797,   800,   801,   804,   806,   808,   812,   813,   814,
     815,   823,   824,   827,   830,   832,   834,   835,   836,   845,
     846,   853,   855,   858,   860,   863,   864,   865,   872,   873,
     874,   881,   882,   885,   886,   892,   893,   895,   896,   902,
     903,   906,   907,   913,   918,   919,   920,   929,   930,   938,
     940,   942,   944,   946,   948,   951,   956,   962,   963,   968,
     973,   978,   982,   986,   989,   992,   993,   996,   998,  1001,
    1005,  1007,  1009,  1011,  1013,  1015,  1018,  1022,  1024,  1026,
    1028,  1030,  1032,  1034,  1036,  1038,  1040,  1042,  1045,  1049,
    1051,  1053,  1055,  1057,  1059,  1061,  1063,  1066,  1070,  1072,
    1074,  1076,  1078,  1080,  1082,  1084,  1086,  1088,  1091,  1095,
    1097,  1099,  1101,  1104,  1107,  1110,  1112,  1114,  1116,  1118,
    1121,  1125,  1129,  1133,  1137,  1141,  1145,  1149,  1153,  1158,
    1159,  1161,  1163,  1165,  1167,  1169,  1172,  1176,  1179,  1184,
    1185,  1192,  1193,  1199,  1200,  1201,  1207,  1208,  1216,  1218,
    1219,  1221,  1222,  1227,  1228,  1229,  1233,  1239,  1246,  1247,
    1252,  1255,  1258,  1261,  1264,  1265,  1267,  1268,  1272,  1273,
    1275,  1277,  1281,  1283,  1288,  1294,  1300,  1301,  1304,  1305,
    1306,  1314,  1315,  1326,  1328,  1332,  1334,  1336,  1337,  1340,
    1341,  1345,  1347,  1351,  1352,  1359,  1361,  1362,  1363,  1369,
    1370,  1375,  1377,  1379,  1381,  1385,  1387,  1391,  1392,  1393,
    1399,  1401,  1405,  1407,  1409,  1410,  1414,  1416,  1420,  1421,
    1426,  1428,  1429,  1431,  1434,  1436,  1440,  1445,  1449,  1453,
    1457,  1461,  1466,  1471,  1475,  1476,  1477,  1484,  1485,  1487,
    1488,  1490,  1492,  1495,  1497,  1499,  1500,  1502,  1504,  1507,
    1509,  1510,  1514,  1515,  1517,  1519,  1522,  1524,  1527,  1531,
    1535,  1539,  1543,  1547,  1551,  1555,  1559,  1563,  1567,  1571,
    1575,  1579,  1583,  1587,  1588,  1595,  1597,  1599,  1603,  1608,
    1613,  1616,  1619,  1622,  1626,  1630,  1634,  1638,  1642,  1646,
    1650,  1655,  1660,  1662,  1664,  1666,  1668,  1670,  1672,  1674,
    1676,  1678,  1680,  1682,  1684,  1686,  1689,  1691,  1693,  1695,
    1697,  1699,  1701,  1705,  1707,  1709,  1712,  1715,  1716,  1725,
    1726,  1736,  1737,  1747,  1748,  1758,  1767,  1770,  1771,  1773,
    1778,  1779,  1781,  1784,  1785,  1789,  1792,  1793,  1803,  1804,
    1807,  1808,  1810,  1812,  1813,  1815,  1818,  1820,  1822,  1825,
    1828,  1833,  1837,  1841,  1845,  1849,  1851,  1854,  1856,  1858,
    1862,  1865,  1869,  1872,  1875,  1877,  1881,  1885,  1888,  1892,
    1894,  1897,  1900,  1903,  1905,  1908,  1910,  1912,  1914,  1917,
    1921,  1924,  1928,  1931,  1934,  1938,  1942,  1946,  1947,  1954,
    1955,  1962,  1965,  1967,  1969,  1971,  1973,  1975,  1977,  1979,
    1981,  1983,  1985,  1987,  1990,  1993,  1995,  1998,  2000,  2003,
    2007,  2010,  2012,  2014,  2016,  2018,  2020,  2022,  2024,  2027,
    2028,  2030,  2032,  2038,  2039,  2041,  2044,  2046,  2048,  2050,
    2052,  2056,  2060,  2064,  2068,  2069,  2071,  2072,  2074,  2075,
    2077,  2080,  2082,  2084,  2087,  2090,  2095,  2097,  2101,  2104,
    2106,  2109,  2112,  2115,  2119,  2123,  2127,  2131,  2134,  2137,
    2139,  2141,  2143,  2146,  2148,  2150,  2152,  2154,  2156,  2157,
    2160,  2162,  2164,  2166,  2168,  2170,  2171,  2174,  2176,  2178,
    2179,  2181,  2183,  2186,  2189,  2191,  2194,  2197,  2198,  2200,
    2202,  2204,  2208,  2210,  2214,  2215,  2217,  2218,  2220,  2226,
    2227,  2231,  2235,  2237,  2238,  2241,  2244,  2247,  2248,  2252,
    2256,  2263,  2270,  2272,  2274,  2277,  2280,  2283,  2285,  2288,
    2291,  2293,  2295,  2296,  2298,  2300,  2302,  2304,  2305,  2307,
    2309,  2311,  2312,  2314,  2317,  2318,  2320,  2321,  2323,  2324,
    2326,  2328,  2331,  2333,  2336,  2338,  2341,  2344,  2347,  2351,
    2354,  2358,  2362,  2366,  2370,  2372,  2374,  2376,  2378,  2382,
    2384,  2386,  2388,  2393,  2396,  2398,  2403,  2404,  2406,  2407,
    2410,  2412,  2416,  2417,  2424,  2425,  2431,  2439,  2440,  2446,
    2447,  2453,  2454,  2460,  2461,  2466,  2467,  2478,  2482,  2487,
    2491,  2495,  2503,  2504,  2508,  2510,  2515,  2516,  2520,  2521,
    2524,  2525,  2527,  2528,  2531,  2534,  2537,  2540,  2542,  2544,
    2546,  2550,  2555,  2556,  2563,  2568,  2569,  2575,  2576,  2583,
    2588,  2592,  2594,  2597,  2599,  2601,  2602,  2608,  2609,  2613,
    2616,  2617,  2623,  2624,  2625,  2632,  2634,  2638,  2640,  2642,
    2646,  2649,  2653,  2656,  2661,  2662,  2669,  2670,  2671,  2679,
    2684,  2689,  2693,  2697,  2700,  2703,  2710,  2716,  2720,  2726,
    2728,  2730,  2732,  2733,  2735,  2736,  2738,  2739,  2742,  2743,
    2745,  2748,  2750,  2752,  2754,  2755,  2757,  2759,  2760,  2763,
    2765,  2766,  2768,  2770,  2772,  2773,  2779,  2783,  2784,  2790,
    2794,  2798,  2799,  2803,  2804,  2807,  2809,  2813,  2814,  2816,
    2818,  2819,  2822,  2824,  2828,  2829,  2835,  2836,  2838,  2840,
    2841,  2848,  2849,  2851,  2853,  2856,  2858,  2860,  2862,  2865,
    2866,  2872,  2875,  2876,  2882,  2883,  2885,  2887,  2890,  2892,
    2894,  2896,  2898,  2900,  2903,  2904,  2910,  2911,  2913,  2915,
    2916,  2921,  2926,  2930,  2936,  2938,  2942,  2946,  2947,  2954,
    2956,  2958,  2960,  2964,  2967,  2971,  2973,  2975,  2976,  2983,
    2985,  2987,  2989,  2993,  2997,  3002,  3003,  3010,  3011,  3014,
    3015,  3020,  3021,  3024,  3026,  3029,  3034,  3037,  3041,  3044,
    3048,  3049,  3053,  3054,  3055,  3062,  3065,  3067,  3069,  3072,
    3075,  3084,  3089,  3090,  3092,  3095,  3097,  3099,  3101,  3103,
    3104,  3107,  3112,  3116,  3118,  3120,  3124,  3129,  3130,  3131,
    3132,  3135,  3138,  3140,  3142,  3143,  3146,  3150,  3151,  3154,
    3158,  3162,  3166,  3169,  3173,  3178,  3182,  3187,  3191,  3196,
    3198,  3202,  3207,  3211,  3215,  3222,  3224,  3230,  3237,  3243,
    3251,  3258,  3267,  3273,  3280,  3285,  3290,  3296,  3300,  3305,
    3307,  3311,  3315,  3319,  3323,  3327,  3331,  3337,  3343,  3347,
    3351,  3355,  3359,  3363,  3367,  3369,  3371,  3373,  3375,  3377,
    3379,  3381,  3383,  3385,  3387,  3389,  3391,  3393,  3395,  3397,
    3399,  3401,  3402,  3405,  3407,  3410,  3412,  3414,  3416,  3419,
    3422,  3424,  3426,  3429,  3432,  3437,  3439,  3443,  3445,  3447,
    3449,  3451,  3453,  3457,  3459,  3461,  3463,  3465,  3469,  3472,
    3475,  3478,  3481,  3485,  3489,  3495,  3502,  3507,  3512,  3520,
    3523,  3530,  3536,  3543,  3550,  3555,  3560,  3566,  3571,  3578,
    3581,  3586,  3591,  3596,  3607,  3614,  3623,  3630,  3635,  3640,
    3647,  3652,  3657,  3662,  3669,  3674,  3682,  3690,  3698,  3705,
    3712,  3719,  3726,  3730,  3735,  3742,  3751,  3754,  3757,  3766,
    3775,  3782,  3789,  3792,  3799,  3806,  3815,  3824,  3831,  3840,
    3847,  3850,  3859,  3868,  3871,  3874,  3877,  3884,  3891,  3898,
    3903,  3908,  3917,  3922,  3927,  3932,  3937,  3941,  3950,  3955,
    3960,  3967,  3972,  3977,  3982,  3989,  3998,  4005,  4010,  4017,
    4019,  4026,  4031,  4036,  4041,  4046,  4051,  4058,  4063,  4064,
    4070,  4077,  4080,  4084,  4085,  4090,  4091,  4095,  4096,  4098,
    4100,  4104,  4109,  4114,  4120,  4125,  4130,  4135,  4141,  4146,
    4147,  4148,  4156,  4161,  4167,  4172,  4178,  4183,  4188,  4193,
    4198,  4203,  4209,  4210,  4219,  4220,  4224,  4228,  4230,  4235,
    4236,  4238,  4239,  4242,  4243,  4244,  4249,  4254,  4257,  4258,
    4262,  4265,  4269,  4272,  4274,  4276,  4279,  4281,  4284,  4286,
    4289,  4292,  4295,  4296,  4300,  4301,  4303,  4305,  4309,  4311,
    4315,  4317,  4321,  4322,  4324,  4325,  4328,  4333,  4339,  4341,
    4343,  4345,  4347,  4352,  4354,  4358,  4362,  4366,  4367,  4374,
    4375,  4382,  4383,  4392,  4397,  4398,  4407,  4408,  4419,  4426,
    4427,  4436,  4437,  4448,  4455,  4457,  4460,  4463,  4464,  4469,
    4473,  4479,  4482,  4483,  4484,  4492,  4494,  4495,  4496,  4503,
    4504,  4508,  4509,  4510,  4516,  4517,  4519,  4520,  4522,  4523,
    4526,  4530,  4534,  4536,  4538,  4539,  4547,  4548,  4556,  4558,
    4561,  4562,  4563,  4566,  4567,  4570,  4571,  4573,  4575,  4577,
    4579,  4583,  4585,  4589,  4591,  4593,  4595,  4597,  4599,  4601,
    4603,  4605,  4607,  4609,  4611,  4613,  4615,  4617,  4619,  4621,
    4623,  4625,  4627,  4629,  4631,  4633,  4635,  4637,  4639,  4640,
    4642,  4644,  4645,  4648,  4649,  4651,  4652,  4653,  4657,  4658,
    4659,  4663,  4666,  4667,  4668,  4673,  4678,  4681,  4682,  4684,
    4686,  4690,  4694,  4696,  4699,  4700,  4702,  4703,  4708,  4713,
    4716,  4717,  4719,  4721,  4722,  4724,  4725,  4727,  4730,  4736,
    4741,  4743,  4747,  4751,  4753,  4755,  4757,  4759,  4761,  4763,
    4764,  4767,  4771,  4776,  4778,  4781,  4784,  4786,  4788,  4790,
    4792,  4794,  4796,  4798,  4800,  4802,  4804,  4806,  4808,  4810,
    4812,  4814,  4816,  4818,  4820,  4822,  4824,  4826,  4828,  4830,
    4832,  4834,  4836,  4837,  4838,  4845,  4846,  4848,  4852,  4854,
    4858,  4859,  4862,  4866,  4868,  4871,  4873,  4874,  4878,  4879,
    4880,  4888,  4891,  4893,  4894,  4898,  4899,  4907,  4908,  4915,
    4920,  4927,  4932,  4937,  4942,  4943,  4950,  4955,  4960,  4966,
    4973,  4978,  4980,  4984,  4986,  4988,  4992,  4994,  4995,  4998,
    4999,  5001,  5002,  5003,  5012,  5013,  5014,  5021,  5022,  5024,
    5026,  5028,  5030,  5032,  5035,  5037,  5039,  5041,  5045,  5050,
    5051,  5055,  5059,  5061,  5064,  5067,  5068,  5072,  5073,  5079,
    5083,  5085,  5089,  5091,  5095,  5097,  5099,  5100,  5102,  5103,
    5108,  5109,  5111,  5115,  5117,  5119,  5121,  5122,  5123,  5130,
    5131,  5132,  5144,  5148,  5150,  5154,  5158,  5160,  5164,  5165,
    5167,  5168,  5173,  5174,  5181,  5182,  5188,  5189,  5196,  5198,
    5202,  5205,  5210,  5211,  5214,  5215,  5218,  5220,  5222,  5224,
    5225,  5230,  5231,  5233,  5234,  5236,  5238,  5242,  5244,  5246,
    5249,  5252,  5255,  5257,  5259,  5261,  5263,  5264,  5268,  5269,
    5273,  5276,  5281,  5286,  5290,  5295,  5300,  5302,  5306,  5310,
    5317,  5320,  5323,  5324,  5331,  5332,  5339,  5345,  5348,  5350,
    5352,  5354,  5360,  5366,  5369,  5372,  5374,  5379,  5383,  5386,
    5390,  5393,  5396,  5398,  5402,  5407,  5411,  5415,  5418,  5421,
    5423,  5425,  5427,  5429,  5433,  5437,  5441,  5445,  5449,  5453,
    5457,  5461,  5463,  5465,  5467,  5469,  5471,  5472,  5474,  5475,
    5478,  5479,  5481,  5483,  5485,  5486,  5489,  5490,  5493,  5494,
    5497,  5500,  5501,  5506,  5507,  5512,  5514,  5516,  5517,  5519,
    5521,  5522,  5524,  5526,  5527,  5532,  5533,  5534,  5540,  5542,
    5543,  5548,  5552,  5554,  5557,  5560,  5563,  5566,  5569,  5572,
    5575,  5577,  5579,  5581,  5583,  5585,  5587,  5589,  5591,  5593,
    5595,  5597,  5599,  5600,  5602,  5603,  5607,  5608,  5612,  5616,
    5618,  5619,  5623,  5625,  5628,  5629,  5631,  5632,  5636,  5640,
    5643,  5646,  5647,  5653,  5654,  5656,  5658,  5659,  5661,  5663,
    5665,  5668,  5671,  5672,  5673,  5674,  5675,  5697,  5699,  5701,
    5702,  5704,  5705,  5707,  5709,  5710,  5712,  5714,  5715,  5718,
    5721,  5723,  5727,  5732,  5736,  5740,  5741,  5744,  5747,  5749,
    5753,  5757,  5758,  5763,  5764,  5768,  5770,  5772,  5773,  5777,
    5780,  5784,  5786,  5788,  5791,  5792,  5795,  5799,  5801,  5807,
    5809,  5811,  5814,  5817,  5819,  5821,  5823,  5825,  5827,  5829,
    5832,  5835,  5837,  5839,  5841,  5843,  5845,  5847,  5849,  5851,
    5854,  5857,  5860,  5863,  5866,  5868,  5870,  5872,  5874,  5876,
    5878,  5880,  5884,  5890,  5892,  5894,  5896,  5898,  5900,  5904,
    5909,  5915,  5917,  5923,  5927,  5930,  5932,  5936,  5939,  5942,
    5947,  5949,  5951,  5953,  5955,  5957,  5959,  5961,  5963,  5965,
    5967,  5969,  5971,  5973,  5975,  5979,  5982,  5984,  5986,  5988,
    5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,
    6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,
    6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,
    6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,
    6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,
    6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,  6108,
    6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,  6128,
    6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,  6148,
    6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,  6168,
    6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,  6188,
    6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,  6208,
    6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,  6228,
    6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,  6248,
    6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,
    6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,
    6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,
    6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,  6328,
    6330,  6332,  6334,  6336,  6338,  6340,  6342,  6344,  6346,  6348,
    6350,  6352,  6354,  6356,  6358,  6360,  6362,  6364,  6366,  6368,
    6370,  6372,  6374,  6376,  6378,  6380,  6382,  6384,  6386,  6388,
    6390,  6392,  6394,  6396,  6398,  6400,  6402,  6404,  6406,  6408,
    6410,  6412,  6414,  6416,  6418,  6420,  6422,  6424,  6426,  6428,
    6430,  6432,  6434,  6436,  6438,  6440,  6442,  6444,  6446,  6448,
    6450,  6452,  6454,  6456,  6458,  6460,  6462,  6464,  6466,  6468,
    6470,  6472,  6474,  6476,  6478,  6480,  6482,  6484,  6486,  6488,
    6490,  6492,  6494,  6496,  6498,  6500,  6502,  6504,  6506,  6508,
    6510,  6512,  6514,  6516,  6518,  6520,  6522,  6524,  6526,  6528,
    6530,  6532,  6534,  6536,  6538,  6540,  6542,  6544,  6546,  6548,
    6550,  6552,  6554,  6556,  6558,  6560,  6562,  6564,  6566,  6568,
    6570,  6572,  6574,  6576,  6578,  6580,  6582,  6584,  6586,  6588,
    6590,  6592,  6594,  6596,  6598,  6600,  6602,  6604,  6606,  6608,
    6610,  6612,  6614,  6616,  6618,  6620,  6622,  6624,  6626,  6628,
    6630,  6632,  6634,  6636,  6638,  6640,  6642,  6644,  6646,  6648,
    6650,  6652,  6654,  6656,  6658,  6660,  6662,  6664,  6666,  6668,
    6670,  6672,  6674,  6676,  6678,  6680,  6682,  6684,  6686,  6687,
    6692,  6693,  6695,  6697,  6701,  6702,  6705,  6707,  6709,  6711,
    6713,  6714,  6716,  6717,  6719,  6721,  6723,  6724,  6727,  6730,
    6733,  6735,  6738,  6743,  6749,  6754,  6761,  6764,  6768,  6772,
    6776,  6782,  6784,  6788,  6792,  6795,  6798,  6801,  6803,  6805,
    6810,  6815,  6817,  6819,  6821,  6823,  6825,  6826,  6831,  6833,
    6835,  6837,  6839,  6841,  6845,  6849,  6851,  6853,  6856,  6859,
    6862,  6863,  6867,  6872,  6876,  6877,  6885,  6887,  6890,  6892,
    6894,  6896,  6898,  6900,  6902,  6903,  6909,  6911,  6913,  6915,
    6917,  6919,  6923,  6930,  6937,  6944,  6952,  6958,  6962,  6971,
    6980,  6989,  6996,  6997,  6999,  7001,  7004,  7005,  7007,  7009,
    7013,  7014,  7018,  7019,  7023,  7024,  7028,  7029,  7033,  7035,
    7037,  7039,  7041,  7043,  7045,  7047,  7049,  7051,  7053,  7055,
    7058,  7061,  7063,  7067,  7070,  7073,  7076,  7079,  7082,  7085,
    7088,  7091,  7093,  7095,  7098,  7099,  7101,  7105,  7107,  7110,
    7113,  7116,  7118,  7122,  7126,  7128,  7130,  7134,  7136,  7140,
    7142,  7144,  7146,  7148,  7153,  7159,  7164,  7171,  7173,  7174,
    7178,  7182,  7184,  7186,  7187,  7190,  7193,  7196,  7199,  7200,
    7203,  7204,  7208,  7211,  7213,  7216,  7219,  7222,  7225,  7228,
    7229,  7233,  7234,  7236,  7237,  7241,  7244,  7245,  7247,  7250,
    7251,  7253,  7258,  7263,  7269,  7272,  7276,  7277,  7279,  7280,
    7285,  7286,  7288,  7290,  7291,  7293,  7294,  7297,  7300,  7302,
    7303,  7305,  7307,  7310,  7314,  7317,  7318,  7325,  7329,  7330,
    7331,  7332,  7334,  7337,  7339,  7341,  7343,  7345,  7347,  7349,
    7351,  7353,  7355,  7358,  7361,  7365,  7367,  7369,  7371,  7373,
    7375,  7377,  7379,  7381,  7383,  7385,  7387,  7389,  7391,  7392,
    7396,  7398,  7401,  7403,  7406,  7410,  7414,  7418,  7419,  7423,
    7427,  7428,  7436,  7437,  7441,  7443,  7447,  7448,  7452,  7455,
    7460,  7461,  7465,  7470,  7475,  7476,  7477,  7478,  7495,  7504,
    7512,  7513,  7514,  7515,  7516,  7517,  7533,  7534,  7535,  7536,
    7537,  7550,  7555,  7560,  7564,  7569,  7573,  7576,  7578,  7582,
    7588,  7590,  7592,  7593,  7595,  7597,  7598,  7601,  7602,  7603,
    7607,  7608,  7611,  7617,  7621,  7625,  7629
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     640,     0,    -1,   157,    -1,    -1,   643,   641,   635,   642,
      -1,   643,   157,    -1,    -1,   157,    -1,   644,    -1,  1491,
      -1,  1002,    -1,  1064,    -1,  1066,    -1,   693,    -1,   656,
      -1,  1067,    -1,  1056,    -1,  1497,    -1,   663,    -1,   645,
      -1,  1314,    -1,  1346,    -1,  1266,    -1,  1268,    -1,   649,
      -1,  1352,    -1,  1463,    -1,  1454,    -1,   654,    -1,  1278,
      -1,  1561,    -1,  1563,    -1,  1080,    -1,  1372,    -1,  1378,
      -1,  1445,    -1,  1072,    -1,   928,    -1,   837,    -1,  1087,
      -1,   647,    -1,  1368,    -1,  1500,    -1,  1075,    -1,  1059,
      -1,  1281,    -1,  1362,    -1,   728,    -1,  1461,    -1,  1498,
      -1,  1499,    -1,  1099,    -1,  1428,    -1,   721,    -1,  1332,
      -1,  1045,    -1,  1048,    -1,  1325,    -1,  1562,    -1,  1452,
      -1,  1306,    -1,  1377,    -1,  1553,    -1,   646,   400,  1422,
      -1,   124,    -1,   145,    -1,   400,  1422,   192,   648,    -1,
    1419,    -1,   636,  1424,    -1,    -1,   171,  1422,   650,   651,
      -1,    -1,   585,   652,    -1,   652,   631,   653,    -1,   653,
      -1,   636,  1424,    -1,    -1,   212,   655,  1424,    -1,    -1,
      57,   301,   551,   657,   658,    -1,   659,    -1,   658,   631,
     659,    -1,   288,   161,  1419,    -1,   302,   161,  1419,    -1,
     291,   161,  1419,    -1,   292,   161,  1245,    -1,   287,   161,
    1245,    -1,   299,   161,  1245,    -1,   295,   161,  1419,    -1,
     294,   161,  1419,    -1,   296,   161,  1419,    -1,   297,   161,
    1419,    -1,   298,   161,  1419,    -1,   300,   161,  1245,    -1,
     303,   161,  1407,    -1,   227,   161,   629,   660,   630,    -1,
     662,    -1,    -1,   661,    -1,   660,   631,   661,    -1,  1245,
      -1,   289,   161,  1419,    -1,   290,   161,  1247,    -1,   430,
     161,  1419,    -1,   431,   161,  1245,    -1,    -1,   103,   889,
     534,   892,  1415,   664,   825,    -1,    -1,   103,   980,   230,
    1422,   984,   363,  1415,   665,   629,   997,   630,   985,    -1,
      -1,   103,   981,   230,  1422,   983,   363,  1415,   666,   629,
     997,   630,   986,    -1,    -1,   103,   982,   230,  1422,   983,
     363,  1415,   667,   629,   997,   630,   987,    -1,    -1,   103,
     111,   892,  1422,   668,   886,    -1,    -1,   103,   669,  1519,
      -1,   103,   581,   686,  1479,    -1,   103,   278,   205,   788,
      -1,   103,   531,   785,    -1,   103,   670,    -1,   473,  1424,
     189,   114,   610,  1424,   369,   629,   671,   630,    -1,   672,
      -1,   671,   631,   672,    -1,   581,  1419,    -1,   216,  1419,
      -1,   111,  1419,    -1,   379,  1419,    -1,   390,  1419,    -1,
     489,  1419,    -1,   397,  1245,    -1,    -1,  1116,   168,   892,
     687,   674,   363,   462,   675,   680,   677,   682,   144,   683,
      -1,    -1,   169,  1121,  1215,   676,   678,   679,    -1,    23,
    1121,    -1,    -1,   153,    -1,   138,   363,   485,    -1,   138,
      -1,    -1,   509,  1121,    -1,    -1,   156,  1121,    -1,    -1,
     681,    -1,   363,    86,   401,    -1,   363,    86,   352,   401,
      -1,    -1,    82,  1419,    -1,    -1,   684,   685,    -1,   734,
      -1,   736,    -1,   732,    -1,   753,    -1,   771,    -1,   773,
      -1,   768,    -1,   738,    -1,   740,    -1,   741,    -1,   742,
      -1,   743,    -1,   745,    -1,    -1,  1422,   637,  1422,    -1,
    1422,    -1,    -1,   688,   690,    -1,    -1,   689,   691,    -1,
      82,  1419,    -1,   256,   505,    -1,   354,   505,    -1,    96,
     505,    -1,   416,   505,   114,    -1,   328,   505,   114,    -1,
     692,    -1,   690,    -1,   136,    -1,  1127,   136,    -1,   505,
     466,   129,    -1,   505,   466,   243,    -1,    -1,    50,   687,
     694,   695,    -1,    -1,   629,   696,   630,    -1,    -1,   697,
      -1,   697,   631,  1121,    -1,  1121,    -1,    -1,   699,    -1,
     699,   631,   701,    -1,   701,    -1,    -1,  1422,   700,   951,
      -1,    -1,   703,    -1,   703,   631,   704,    -1,   704,    -1,
     705,   700,  1422,   951,    -1,    -1,   244,    -1,   378,    -1,
     235,    -1,    -1,   706,   731,   635,    -1,   731,   635,    -1,
     707,   731,   635,    -1,    -1,   708,   709,   635,    -1,    -1,
     127,   729,   710,   951,   730,    -1,   127,  1422,    89,   190,
     717,    -1,    -1,   127,   714,   208,   190,   711,   715,   731,
      -1,   127,  1422,   108,   190,   712,    -1,    -1,   713,  1099,
      -1,   173,    -1,    98,    -1,   716,    -1,   715,   631,   716,
      -1,   720,    -1,  1245,    -1,   718,    -1,   497,   719,  1420,
      -1,    -1,   590,    -1,   717,    -1,  1422,    -1,   498,    -1,
    1127,   191,    -1,   496,    -1,   482,   722,   724,    -1,  1422,
      -1,   718,    -1,    -1,   722,    -1,    -1,   475,   725,    -1,
     727,   161,   726,    -1,   725,   631,   727,   161,   726,    -1,
    1406,    -1,  1152,    -1,  1411,    -1,    65,    -1,   518,    -1,
      93,    -1,    95,    -1,    94,    -1,    55,    -1,   463,    -1,
     536,    -1,    81,    -1,   109,    -1,   319,    -1,   337,    -1,
     445,   723,   724,    -1,  1422,    -1,   729,   631,  1422,    -1,
      -1,   128,  1121,    -1,   734,    -1,   736,    -1,   732,    -1,
     753,    -1,   771,    -1,   773,    -1,   768,    -1,   738,    -1,
     740,    -1,   741,    -1,   742,    -1,   743,    -1,   745,    -1,
      -1,   225,   733,   748,   155,   225,    -1,    -1,   735,   644,
      -1,    -1,   451,   737,  1121,    -1,    -1,   739,   777,    -1,
     262,  1423,    -1,   250,  1423,    -1,   367,  1422,    -1,    -1,
     181,   746,  1422,   241,   744,   747,    -1,    68,  1422,    -1,
      -1,   348,   192,    -1,   192,    -1,  1422,    -1,   747,   631,
    1422,    -1,    -1,    -1,    -1,   749,  1121,   543,   750,   707,
     751,   752,    -1,    -1,   152,   748,    -1,   151,   707,    -1,
     754,    -1,   757,    -1,    -1,    -1,    53,   755,  1121,   756,
     759,   767,   155,    53,    -1,    -1,    53,   758,   760,   767,
     155,    53,    -1,   761,    -1,   759,   761,    -1,   764,    -1,
     760,   764,    -1,    -1,    -1,   603,   762,  1121,   763,   543,
     707,    -1,    -1,    -1,   603,   765,  1121,   766,   543,   707,
      -1,    -1,   151,   707,    -1,    -1,  1423,   638,   769,   777,
     770,    -1,    -1,  1423,    -1,    -1,  1423,   638,   772,   775,
     770,    -1,    -1,   774,   775,    -1,    -1,    31,   776,   708,
     706,   155,    -1,   284,   707,   155,   284,    -1,    -1,    -1,
     605,   778,  1121,   144,   779,   707,   155,   605,    -1,    -1,
     440,   707,   577,   780,  1121,   155,   440,    -1,    30,    -1,
       8,    -1,   237,    -1,   578,    -1,   132,    -1,   810,   812,
      -1,   810,    57,   807,   791,    -1,   810,     6,   807,   786,
     795,    -1,    -1,   584,   278,   205,  1422,    -1,   810,     6,
     807,   798,    -1,   810,   145,   807,   798,    -1,   811,   790,
     801,    -1,   811,   790,   804,    -1,     6,   808,    -1,     6,
     809,    -1,    -1,   792,   793,    -1,   794,    -1,   793,   794,
      -1,   793,   631,   794,    -1,   813,    -1,   814,    -1,   815,
      -1,   796,    -1,   797,    -1,   796,   797,    -1,   796,   631,
     797,    -1,   813,    -1,   814,    -1,   815,    -1,   816,    -1,
     819,    -1,   821,    -1,   823,    -1,   820,    -1,   799,    -1,
     800,    -1,   799,   800,    -1,   799,   631,   800,    -1,   813,
      -1,   814,    -1,   815,    -1,   821,    -1,   823,    -1,   802,
      -1,   803,    -1,   802,   803,    -1,   802,   631,   803,    -1,
     813,    -1,   817,    -1,   818,    -1,   819,    -1,   821,    -1,
     823,    -1,   820,    -1,   805,    -1,   806,    -1,   805,   806,
      -1,   805,   631,   806,    -1,   813,    -1,   821,    -1,   823,
      -1,   113,  1419,    -1,   567,  1419,    -1,   423,  1419,    -1,
    1422,    -1,  1422,    -1,   417,    -1,   419,    -1,   352,     4,
      -1,   233,  1298,   824,    -1,    25,  1298,   824,    -1,   308,
    1298,   824,    -1,   176,  1298,   824,    -1,   568,  1298,   824,
      -1,   424,  1298,   824,    -1,   349,  1298,  1246,    -1,    82,
    1298,  1419,    -1,  1339,   159,  1298,   900,    -1,    -1,   823,
      -1,   600,    -1,   355,    -1,  1248,    -1,  1418,    -1,   629,
     826,    -1,   893,   832,   829,    -1,   267,  1415,    -1,   629,
     267,  1415,   630,    -1,    -1,   906,   630,   827,   893,   832,
     829,    -1,    -1,   832,   882,   630,   828,  1504,    -1,    -1,
      -1,  1386,   885,   882,   830,  1501,    -1,    -1,  1386,   885,
     629,   882,   630,   831,  1504,    -1,   833,    -1,    -1,   834,
      -1,    -1,   389,   836,   835,   839,    -1,    -1,    -1,   389,
     838,   839,    -1,    47,   840,   850,   851,   858,    -1,   842,
     254,   843,   629,   844,   630,    -1,    -1,   842,   210,   841,
     848,    -1,   415,   848,    -1,   415,   847,    -1,   272,   848,
      -1,   272,   847,    -1,    -1,   269,    -1,    -1,    11,   161,
    1246,    -1,    -1,   845,    -1,   846,    -1,   845,   631,   846,
      -1,  1422,    -1,    73,   629,   844,   630,    -1,   629,  1116,
     856,  1117,   630,    -1,   629,  1116,   856,  1117,   630,    -1,
      -1,   388,  1246,    -1,    -1,    -1,   522,    47,   842,   210,
     849,   852,   857,    -1,    -1,   522,    47,   842,   254,   843,
     629,   854,   630,   853,   857,    -1,   855,    -1,   854,   631,
     855,    -1,  1422,    -1,  1124,    -1,    -1,   521,  1246,    -1,
      -1,   629,   859,   630,    -1,   860,    -1,   859,   631,   860,
      -1,    -1,   389,   861,   862,   863,   879,   874,    -1,  1422,
      -1,    -1,    -1,   589,   264,   542,   864,   866,    -1,    -1,
     589,   244,   865,   867,    -1,   312,    -1,   869,    -1,   869,
      -1,   629,   868,   630,    -1,   869,    -1,   868,   631,   869,
      -1,    -1,    -1,   629,   870,   872,   871,   630,    -1,   873,
      -1,   872,   631,   873,    -1,   312,    -1,  1124,    -1,    -1,
     629,   875,   630,    -1,   876,    -1,   875,   631,   876,    -1,
      -1,   522,   877,   878,   879,    -1,  1424,    -1,    -1,   880,
      -1,   880,   881,    -1,   881,    -1,   531,  1298,  1424,    -1,
    1339,   159,  1298,   900,    -1,    90,  1298,  1419,    -1,   349,
    1298,  1246,    -1,   307,  1298,  1248,    -1,   325,  1298,  1248,
      -1,   114,   137,  1298,  1419,    -1,   230,   137,  1298,  1419,
      -1,    82,  1298,  1419,    -1,    -1,    -1,   467,   883,  1110,
    1114,   884,   904,    -1,    -1,    19,    -1,    -1,   887,    -1,
     888,    -1,   887,   888,    -1,   899,    -1,   898,    -1,    -1,
     890,    -1,   891,    -1,   891,   890,    -1,   537,    -1,    -1,
     225,  1127,   172,    -1,    -1,   895,    -1,   896,    -1,   896,
     894,    -1,   896,    -1,   896,   895,    -1,   896,   631,   895,
      -1,   159,  1298,   900,    -1,   307,  1298,  1247,    -1,   325,
    1298,  1247,    -1,    27,  1298,  1245,    -1,   390,  1298,  1419,
      -1,    82,  1298,  1419,    -1,    26,  1298,  1247,    -1,   380,
    1298,  1245,    -1,   380,  1298,   128,    -1,    62,  1298,  1245,
      -1,   535,  1298,  1245,    -1,   382,  1298,  1251,    -1,   131,
    1298,  1245,    -1,   458,  1298,   902,    -1,    -1,   572,  1298,
     897,   629,  1360,   630,    -1,   898,    -1,   899,    -1,   238,
    1298,   903,    -1,   114,   137,  1298,  1419,    -1,   230,   137,
    1298,  1419,    -1,   531,  1422,    -1,   515,   140,    -1,   515,
     317,    -1,    90,  1298,  1419,    -1,   253,  1298,  1245,    -1,
     554,  1298,  1251,    -1,  1418,  1297,  1419,    -1,  1418,  1297,
    1422,    -1,  1418,  1297,  1248,    -1,  1418,  1297,   128,    -1,
     963,   954,  1298,   956,    -1,   963,    71,  1298,   962,    -1,
    1424,    -1,  1424,    -1,   128,    -1,   184,    -1,   149,    -1,
      87,    -1,   425,    -1,    85,    -1,   381,    -1,   354,    -1,
     183,    -1,   257,    -1,  1238,    -1,  1109,  1113,    -1,   517,
      -1,   420,    -1,   126,    -1,   242,    -1,   907,    -1,   908,
      -1,   907,   631,   908,    -1,   909,    -1,   910,    -1,   919,
     915,    -1,   919,   969,    -1,    -1,   975,   999,   984,   629,
     997,   630,   911,   985,    -1,    -1,   981,   978,   999,   983,
     629,   997,   630,   912,   986,    -1,    -1,   982,   978,   999,
     983,   629,   997,   630,   913,   987,    -1,    -1,   917,   976,
     999,   984,   629,   997,   630,   914,   985,    -1,   917,   189,
     254,   999,   629,   997,   630,   969,    -1,   917,   916,    -1,
      -1,   916,    -1,    63,   629,  1121,   630,    -1,    -1,   918,
      -1,    92,   999,    -1,    -1,  1414,   920,   921,    -1,   930,
     948,    -1,    -1,   930,   923,    19,   922,   629,   929,   630,
     924,   925,    -1,    -1,   198,    14,    -1,    -1,   599,    -1,
     391,    -1,    -1,   926,    -1,   926,   927,    -1,   927,    -1,
     573,    -1,   573,   254,    -1,    82,  1419,    -1,   385,   629,
     929,   630,    -1,  1116,  1121,  1117,    -1,   938,   946,   942,
      -1,   939,   947,   942,    -1,   186,   940,   942,    -1,    39,
      -1,    39,   945,    -1,    44,    -1,    43,    -1,   934,   945,
     966,    -1,   934,   966,    -1,   935,   945,   967,    -1,   935,
     967,    -1,    34,   945,    -1,    34,    -1,   936,   945,   966,
      -1,   937,   945,   967,    -1,   591,   945,    -1,   617,   946,
     942,    -1,   118,    -1,   547,   946,    -1,   544,   946,    -1,
     115,   946,    -1,   548,    -1,    41,   946,    -1,   933,    -1,
     313,    -1,   280,    -1,   283,   591,    -1,   283,   936,   966,
      -1,   550,   966,    -1,   541,   946,   966,    -1,   315,   966,
      -1,   281,   966,    -1,   126,   940,   942,    -1,   359,   940,
     942,    -1,   184,   940,   942,    -1,    -1,   160,   931,   629,
    1001,   630,   966,    -1,    -1,   475,   932,   629,  1001,   630,
     966,    -1,   283,   966,    -1,   471,    -1,   200,    -1,   199,
      -1,   395,    -1,   333,    -1,   271,    -1,   332,    -1,   396,
      -1,   334,    -1,    60,    -1,   343,    -1,   340,    60,    -1,
     934,   595,    -1,   592,    -1,   340,   592,    -1,   360,    -1,
     343,   592,    -1,   340,    60,   595,    -1,   343,   595,    -1,
     242,    -1,   549,    -1,   487,    -1,   314,    -1,    33,    -1,
     420,    -1,   143,    -1,   143,   399,    -1,    -1,   945,    -1,
     941,    -1,   629,   358,   631,   358,   630,    -1,    -1,   943,
      -1,   943,   944,    -1,   944,    -1,   483,    -1,   576,    -1,
     618,    -1,   629,   282,   630,    -1,   629,   563,   630,    -1,
     629,   125,   630,    -1,   629,   358,   630,    -1,    -1,   945,
      -1,    -1,   941,    -1,    -1,   949,    -1,   949,   950,    -1,
     950,    -1,   357,    -1,  1127,   357,    -1,   128,   952,    -1,
     363,   578,   353,  1120,    -1,    26,    -1,   471,   128,   590,
      -1,   968,   254,    -1,   573,    -1,   573,   254,    -1,    82,
    1419,    -1,    71,   960,    -1,  1418,  1297,  1419,    -1,  1418,
    1297,  1422,    -1,  1418,  1297,  1248,    -1,  1418,  1297,   128,
      -1,   930,   961,    -1,   353,  1120,    -1,  1405,    -1,   213,
      -1,   214,    -1,    60,   475,    -1,    59,    -1,  1424,    -1,
      34,    -1,   955,    -1,   128,    -1,    -1,   954,   956,    -1,
    1424,    -1,    34,    -1,   958,    -1,   128,    -1,  1424,    -1,
      -1,    71,   962,    -1,   960,    -1,   128,    -1,    -1,   128,
      -1,    21,    -1,    34,    21,    -1,    21,    34,    -1,   570,
      -1,   570,    34,    -1,    34,   570,    -1,    -1,   964,    -1,
     965,    -1,    48,    -1,   954,   955,   967,    -1,    34,    -1,
      34,   954,   955,    -1,    -1,    34,    -1,    -1,   403,    -1,
     426,  1415,   970,   972,   973,    -1,    -1,   629,   971,   630,
      -1,   971,   631,  1422,    -1,  1422,    -1,    -1,   304,   193,
      -1,   304,   386,    -1,   304,   484,    -1,    -1,   363,   578,
     974,    -1,   363,   132,   974,    -1,   363,   578,   974,   363,
     132,   974,    -1,   363,   132,   974,   363,   578,   974,    -1,
     448,    -1,    51,    -1,   475,   357,    -1,   354,     5,    -1,
     475,   128,    -1,   977,    -1,   403,   254,    -1,   573,   978,
      -1,   254,    -1,   230,    -1,    -1,   977,    -1,   252,    -1,
     230,    -1,   229,    -1,    -1,   573,    -1,   194,    -1,   494,
      -1,    -1,   983,    -1,   983,   991,    -1,    -1,   988,    -1,
      -1,   990,    -1,    -1,   989,    -1,   993,    -1,   988,   993,
      -1,   994,    -1,   989,   994,    -1,   995,    -1,   990,   995,
      -1,   585,   996,    -1,   561,   996,    -1,   253,  1298,  1245,
      -1,    82,  1419,    -1,  1418,  1297,  1419,    -1,  1418,  1297,
    1422,    -1,  1418,  1297,  1248,    -1,  1418,  1297,   128,    -1,
     992,    -1,   991,    -1,   992,    -1,   992,    -1,   606,   384,
    1418,    -1,    46,    -1,   460,    -1,   210,    -1,   997,   631,
     998,  1236,    -1,   998,  1236,    -1,  1422,    -1,  1422,   629,
     358,   630,    -1,    -1,  1414,    -1,    -1,   637,  1422,    -1,
    1403,    -1,  1001,   631,  1403,    -1,    -1,    13,  1037,   534,
    1415,  1003,  1014,    -1,    -1,    13,   111,  1013,  1004,   887,
      -1,    13,   111,  1422,   579,   114,   137,   339,    -1,    -1,
      13,   405,   687,  1005,   688,    -1,    -1,    13,   195,   687,
    1006,   688,    -1,    -1,    13,  1527,  1522,  1007,  1529,    -1,
      -1,    13,  1522,  1008,  1529,    -1,    -1,    13,  1522,   168,
     687,  1009,  1010,  1011,   677,   682,  1012,    -1,    13,   531,
     787,    -1,    13,   278,   205,   789,    -1,    13,   531,   784,
      -1,    13,   531,   783,    -1,    13,   473,  1424,   369,   629,
     671,   630,    -1,    -1,   363,   462,   675,    -1,   681,    -1,
     363,   462,   675,   681,    -1,    -1,   436,   551,   687,    -1,
      -1,   144,   683,    -1,    -1,  1422,    -1,    -1,   139,   531,
      -1,   228,   531,    -1,  1029,   833,    -1,  1029,  1018,    -1,
    1018,    -1,   834,    -1,  1020,    -1,   145,   389,  1027,    -1,
     421,   389,  1074,  1019,    -1,    -1,   368,   389,  1074,  1019,
    1015,  1074,    -1,    15,   389,  1074,  1019,    -1,    -1,    63,
     389,  1019,  1016,  1069,    -1,    -1,   438,   389,  1074,  1019,
    1017,  1061,    -1,    69,   389,  1074,  1246,    -1,   559,   389,
    1019,    -1,  1023,    -1,   435,   387,    -1,    12,    -1,  1027,
      -1,    -1,     6,   389,  1074,  1021,  1022,    -1,    -1,   629,
     859,   630,    -1,   388,  1246,    -1,    -1,   437,   389,  1074,
    1024,  1025,    -1,    -1,    -1,  1027,  1026,   241,   629,   859,
     630,    -1,  1028,    -1,  1027,   631,  1028,    -1,  1422,    -1,
    1031,    -1,  1029,   631,  1031,    -1,     6,  1035,    -1,  1030,
     909,  1043,    -1,     6,   910,    -1,  1030,   629,   906,   630,
      -1,    -1,    57,  1035,  1414,  1032,   919,  1043,    -1,    -1,
      -1,   329,  1035,  1414,  1033,   921,  1034,  1043,    -1,   145,
    1035,  1414,  1042,    -1,   145,   189,   254,   999,    -1,   145,
     403,   254,    -1,   145,   977,  1414,    -1,   138,   252,    -1,
     153,   252,    -1,    13,  1035,  1414,   475,   128,  1405,    -1,
      13,  1035,  1414,   145,   128,    -1,   436,  1044,  1415,    -1,
     100,   551,   954,   956,   961,    -1,   894,    -1,   188,    -1,
    1229,    -1,    -1,    80,    -1,    -1,   226,    -1,    -1,  1038,
    1039,    -1,    -1,  1040,    -1,  1040,  1041,    -1,  1041,    -1,
     226,    -1,   366,    -1,    -1,   448,    -1,    51,    -1,    -1,
       8,  1422,    -1,   183,    -1,    -1,   551,    -1,   161,    -1,
      19,    -1,    -1,   510,   485,  1050,  1046,  1054,    -1,   514,
     485,  1050,    -1,    -1,   485,   510,  1050,  1047,  1054,    -1,
     485,   514,  1050,    -1,   510,   553,  1049,    -1,    -1,   606,
      91,   488,    -1,    -1,  1051,  1052,    -1,  1053,    -1,  1052,
     631,  1053,    -1,    -1,   506,    -1,   432,    -1,    -1,   577,
    1055,    -1,   662,    -1,  1055,   631,   662,    -1,    -1,    62,
    1447,  1057,  1272,  1058,    -1,    -1,   414,    -1,   175,    -1,
      -1,   438,  1074,  1448,  1060,  1272,  1061,    -1,    -1,  1062,
      -1,  1063,    -1,  1063,  1062,    -1,   414,    -1,   175,    -1,
     583,    -1,   192,   336,    -1,    -1,    15,  1074,  1447,  1065,
    1272,    -1,    35,  1419,    -1,    -1,    63,  1448,  1068,  1272,
    1069,    -1,    -1,  1070,    -1,  1071,    -1,  1071,  1070,    -1,
     414,    -1,   179,    -1,   316,    -1,   175,    -1,    58,    -1,
     190,   579,    -1,    -1,   368,  1074,  1447,  1073,  1272,    -1,
      -1,   356,    -1,   274,    -1,    -1,   436,  1447,  1076,  1078,
      -1,   436,   581,   686,  1077,    -1,  1425,   551,  1425,    -1,
    1077,   631,  1425,   551,  1425,    -1,  1079,    -1,  1078,   631,
    1079,    -1,  1415,   551,  1415,    -1,    -1,    49,   230,  1081,
    1082,   244,  1086,    -1,  1083,    -1,  1085,    -1,  1084,    -1,
    1083,   631,  1084,    -1,  1415,  1095,    -1,  1415,  1093,  1095,
      -1,  1422,    -1,   128,    -1,    -1,   273,   230,   241,    49,
    1088,  1089,    -1,  1092,    -1,  1090,    -1,  1091,    -1,  1090,
     631,  1091,    -1,  1415,  1095,  1098,    -1,  1415,  1093,  1095,
    1098,    -1,    -1,   389,   836,  1094,   629,  1019,   630,    -1,
      -1,  1096,  1097,    -1,    -1,   977,   629,  1211,   630,    -1,
      -1,   226,   261,    -1,  1100,    -1,   467,  1103,    -1,   629,
    1101,   630,  1504,    -1,   467,  1105,    -1,   629,  1101,   630,
      -1,   467,  1190,    -1,   629,  1102,   630,    -1,    -1,  1105,
    1104,  1501,    -1,    -1,    -1,  1106,  1110,  1114,  1107,  1108,
    1113,    -1,  1232,  1238,    -1,  1261,    -1,  1109,    -1,  1261,
    1109,    -1,  1109,  1261,    -1,   192,  1172,  1221,  1226,  1223,
    1232,  1238,  1252,    -1,   192,   146,  1221,  1238,    -1,    -1,
    1111,    -1,  1111,  1112,    -1,  1112,    -1,  1518,    -1,   503,
      -1,   501,    -1,    -1,   190,   578,    -1,   277,   244,   477,
     327,    -1,  1114,   631,  1115,    -1,  1115,    -1,   624,    -1,
    1116,  1409,  1117,    -1,  1116,  1121,  1117,  1118,    -1,    -1,
      -1,    -1,    19,  1422,    -1,    19,  1419,    -1,  1422,    -1,
    1419,    -1,    -1,   629,   630,    -1,   629,  1246,   630,    -1,
      -1,   629,   630,    -1,  1121,  1125,  1121,    -1,  1121,   615,
    1121,    -1,  1121,  1126,  1121,    -1,   352,  1121,    -1,  1122,
     247,   558,    -1,  1122,   247,  1127,   558,    -1,  1122,   247,
     178,    -1,  1122,   247,  1127,   178,    -1,  1122,   247,   574,
      -1,  1122,   247,  1127,   574,    -1,  1122,    -1,  1122,   247,
     357,    -1,  1122,   247,  1127,   357,    -1,  1122,   162,  1123,
      -1,  1122,  1129,  1123,    -1,  1122,  1129,  1130,   629,  1513,
     630,    -1,  1123,    -1,  1124,   244,   629,  1513,   630,    -1,
    1124,  1127,   244,   629,  1513,   630,    -1,  1124,   244,   629,
    1121,   630,    -1,  1124,   244,   629,  1121,   631,  1165,   630,
      -1,  1124,  1127,   244,   629,  1121,   630,    -1,  1124,  1127,
     244,   629,  1121,   631,  1165,   630,    -1,  1124,    32,  1124,
      17,  1123,    -1,  1124,  1127,    32,  1124,    17,  1123,    -1,
    1124,   492,   267,  1124,    -1,  1124,   267,  1135,  1225,    -1,
    1124,  1127,   267,  1135,  1225,    -1,  1124,   427,  1124,    -1,
    1124,  1127,   427,  1124,    -1,  1124,    -1,  1124,   620,  1124,
      -1,  1124,   621,  1124,    -1,  1124,   478,  1124,    -1,  1124,
     479,  1124,    -1,  1124,   623,  1124,    -1,  1124,   622,  1124,
      -1,  1124,   623,   240,  1121,  1215,    -1,  1124,   622,   240,
    1121,  1215,    -1,  1124,   624,  1124,    -1,  1124,   625,  1124,
      -1,  1124,   626,  1124,    -1,  1124,   142,  1124,    -1,  1124,
     330,  1124,    -1,  1124,   627,  1124,    -1,  1135,    -1,   375,
      -1,   372,    -1,    17,    -1,    16,    -1,   352,    -1,   351,
      -1,   632,    -1,   351,    -1,   161,    -1,   196,    -1,   207,
      -1,   259,    -1,   286,    -1,   345,    -1,    12,    -1,    18,
      -1,    -1,    19,  1132,    -1,   242,    -1,   576,   242,    -1,
     143,    -1,   420,    -1,   186,    -1,   126,   940,    -1,   934,
     966,    -1,   935,    -1,   118,    -1,   547,   946,    -1,   115,
     946,    -1,  1121,   631,  1121,  1131,    -1,  1133,    -1,  1134,
     631,  1133,    -1,  1411,    -1,  1136,    -1,  1137,    -1,  1140,
      -1,  1138,    -1,  1135,    71,  1424,    -1,  1406,    -1,  1404,
      -1,  1152,    -1,  1148,    -1,  1135,   374,  1135,    -1,   623,
    1135,    -1,   622,  1135,    -1,   628,  1135,    -1,  1128,  1135,
      -1,   629,  1513,   630,    -1,   629,  1121,   630,    -1,   629,
    1121,   631,  1165,   630,    -1,   459,   629,  1121,   631,  1165,
     630,    -1,   172,   629,  1513,   630,    -1,   633,  1422,  1121,
     634,    -1,   304,  1166,     9,   629,  1124,  1142,   630,    -1,
      34,  1135,    -1,    54,   629,  1121,    19,  1162,   630,    -1,
      53,  1168,  1170,  1169,   155,    -1,   100,   629,  1121,   631,
    1162,   630,    -1,   100,   629,  1121,   585,   955,   630,    -1,
     128,   629,  1411,   630,    -1,   589,   629,  1412,   630,    -1,
     240,  1121,  1215,   623,  1121,    -1,    60,   629,  1165,   630,
      -1,    60,   629,  1165,   585,   955,   630,    -1,   107,  1120,
      -1,   118,   629,  1121,   630,    -1,   123,   629,  1121,   630,
      -1,   221,   629,  1121,   630,    -1,   237,   629,  1121,   631,
    1121,   631,  1121,   631,  1121,   630,    -1,   240,   629,  1121,
     631,  1121,   630,    -1,   240,   629,  1121,   631,  1121,   631,
    1165,   630,    -1,   263,   629,  1121,   631,  1121,   630,    -1,
     324,   629,  1121,   630,    -1,   331,   629,  1121,   630,    -1,
     453,   629,  1121,   631,  1121,   630,    -1,   465,   629,  1121,
     630,    -1,   547,   629,  1121,   630,    -1,   544,   629,  1121,
     630,    -1,   544,   629,  1121,   631,  1121,   630,    -1,   557,
     629,  1121,   630,    -1,   557,   629,   260,  1121,   192,  1121,
     630,    -1,   557,   629,   552,  1121,   192,  1121,   630,    -1,
     557,   629,    45,  1121,   192,  1121,   630,    -1,   557,   629,
     260,   192,  1121,   630,    -1,   557,   629,   552,   192,  1121,
     630,    -1,   557,   629,    45,   192,  1121,   630,    -1,   557,
     629,  1121,   192,  1121,   630,    -1,   581,   629,   630,    -1,
     617,   629,  1121,   630,    -1,     7,   629,  1121,   631,  1121,
     630,    -1,     7,   629,  1121,   631,   240,  1121,  1215,   630,
      -1,   106,  1120,    -1,   110,  1119,    -1,   116,   629,  1121,
     631,   240,  1121,  1215,   630,    -1,   117,   629,  1121,   631,
     240,  1121,  1215,   630,    -1,   177,   629,  1215,   192,  1121,
     630,    -1,   201,   629,  1217,   631,  1121,   630,    -1,   353,
    1119,    -1,   398,   629,  1124,   244,  1121,   630,    -1,   519,
     629,  1121,   631,  1121,   630,    -1,   519,   629,  1121,   631,
     240,  1121,  1215,   630,    -1,   523,   629,  1121,   631,  1121,
     631,  1121,   630,    -1,   523,   629,  1121,   631,  1121,   630,
      -1,   523,   629,  1121,   192,  1121,   190,  1121,   630,    -1,
     523,   629,  1121,   192,  1121,   630,    -1,   529,  1119,    -1,
     545,   629,  1216,   631,  1121,   631,  1121,   630,    -1,   546,
     629,  1216,   631,  1121,   631,  1121,   630,    -1,   586,  1120,
      -1,   588,  1119,    -1,   587,  1119,    -1,    74,   629,  1121,
     631,  1134,   630,    -1,    76,   629,  1121,   631,  1165,   630,
      -1,    77,   629,  1121,   631,  1121,   630,    -1,    79,   629,
    1121,   630,    -1,    75,   629,  1134,   630,    -1,    78,   629,
    1121,   631,  1121,    19,  1162,   630,    -1,    21,   629,  1121,
     630,    -1,    59,   629,  1121,   630,    -1,    69,   629,  1165,
     630,    -1,    72,   629,  1121,   630,    -1,   111,   629,   630,
      -1,   225,   629,  1121,   631,  1121,   631,  1121,   630,    -1,
     258,   629,  1165,   630,    -1,   320,   629,  1121,   630,    -1,
     330,   629,  1121,   631,  1121,   630,    -1,   362,   629,  1121,
     630,    -1,   390,   629,  1121,   630,    -1,   412,   629,  1121,
     630,    -1,   440,   629,  1121,   631,  1121,   630,    -1,   441,
     629,  1121,   631,  1121,   631,  1121,   630,    -1,   559,   629,
    1121,   631,  1121,   630,    -1,   602,   629,  1121,   630,    -1,
     602,   629,  1121,   631,  1121,   630,    -1,  1139,    -1,    96,
     629,  1121,   631,  1121,   630,    -1,   199,   629,  1165,   630,
      -1,   271,   629,  1165,   630,    -1,   332,   629,  1165,   630,
      -1,   333,   629,  1165,   630,    -1,   334,   629,  1165,   630,
      -1,   395,   629,  1121,   631,  1121,   630,    -1,   396,   629,
    1165,   630,    -1,    -1,  1418,   629,  1141,  1145,   630,    -1,
    1422,   637,  1422,   629,  1164,   630,    -1,  1143,  1144,    -1,
     244,    43,   327,    -1,    -1,   244,   341,   256,   327,    -1,
      -1,   606,   413,   174,    -1,    -1,  1146,    -1,  1147,    -1,
    1146,   631,  1147,    -1,  1116,  1121,  1117,  1118,    -1,    28,
     629,  1160,   630,    -1,    28,   629,   141,  1160,   630,    -1,
      37,   629,  1160,   630,    -1,    38,   629,  1160,   630,    -1,
      40,   629,  1160,   630,    -1,   101,   629,  1220,   624,   630,
      -1,   101,   629,  1160,   630,    -1,    -1,    -1,   101,   629,
     141,  1149,  1165,  1150,   630,    -1,   326,   629,  1160,   630,
      -1,   326,   629,   141,  1160,   630,    -1,   309,   629,  1160,
     630,    -1,   309,   629,   141,  1160,   630,    -1,   513,   629,
    1160,   630,    -1,   594,   629,  1160,   630,    -1,   512,   629,
    1160,   630,    -1,   596,   629,  1160,   630,    -1,   524,   629,
    1160,   630,    -1,   524,   629,   141,  1160,   630,    -1,    -1,
     206,   629,  1155,  1151,  1165,  1157,  1156,   630,    -1,    -1,
     636,  1153,  1154,    -1,  1424,   476,  1121,    -1,  1424,    -1,
     636,  1437,  1424,  1000,    -1,    -1,   141,    -1,    -1,   469,
    1403,    -1,    -1,    -1,   373,    47,  1158,  1159,    -1,  1159,
     631,  1410,  1236,    -1,  1410,  1236,    -1,    -1,  1220,  1161,
    1121,    -1,    34,   946,    -1,    60,   946,   966,    -1,   343,
     946,    -1,   242,    -1,   483,    -1,   483,   242,    -1,   576,
      -1,   576,   242,    -1,   118,    -1,   547,   946,    -1,   115,
     946,    -1,   126,   940,    -1,    -1,   143,  1163,   947,    -1,
      -1,  1165,    -1,  1121,    -1,  1165,   631,  1121,    -1,  1167,
      -1,   629,  1167,   630,    -1,  1411,    -1,  1167,   631,  1411,
      -1,    -1,  1121,    -1,    -1,   151,  1121,    -1,   603,  1121,
     543,  1121,    -1,  1170,   603,  1121,   543,  1121,    -1,  1184,
      -1,  1175,    -1,  1174,    -1,  1171,    -1,   633,  1422,  1171,
     634,    -1,  1173,    -1,  1174,   631,  1173,    -1,  1171,  1183,
    1171,    -1,  1171,   516,  1184,    -1,    -1,  1171,  1183,  1171,
     363,  1176,  1121,    -1,    -1,  1171,   516,  1184,   363,  1177,
    1121,    -1,    -1,  1171,  1183,  1171,   585,  1178,   629,  1214,
     630,    -1,  1171,   341,   251,  1184,    -1,    -1,  1171,   263,
    1200,   251,  1171,   363,  1179,  1121,    -1,    -1,  1171,   263,
    1200,   251,  1184,  1180,   585,   629,  1214,   630,    -1,  1171,
     341,   263,  1200,   251,  1184,    -1,    -1,  1171,   453,  1200,
     251,  1171,   363,  1181,  1121,    -1,    -1,  1171,   453,  1200,
     251,  1184,  1182,   585,   629,  1214,   630,    -1,  1171,   341,
     453,  1200,   251,  1184,    -1,   251,    -1,   234,   251,    -1,
     104,   251,    -1,    -1,  1185,  1415,  1219,  1209,    -1,  1199,
    1198,  1195,    -1,   629,  1198,  1186,   630,  1219,    -1,  1193,
    1505,    -1,    -1,    -1,  1186,   572,  1509,  1187,  1510,  1188,
    1505,    -1,  1190,    -1,    -1,    -1,  1191,  1516,  1114,  1192,
     904,  1113,    -1,    -1,  1198,  1194,  1174,    -1,    -1,    -1,
    1196,  1110,  1114,  1197,   904,    -1,    -1,   467,    -1,    -1,
     376,    -1,    -1,   190,   251,    -1,   190,   373,    47,    -1,
     190,   205,    47,    -1,   188,    -1,   226,    -1,    -1,  1202,
     977,  1201,  1204,   629,  1213,   630,    -1,    -1,   584,   977,
    1201,  1205,   629,  1211,   630,    -1,  1203,    -1,  1206,  1203,
      -1,    -1,    -1,  1208,  1206,    -1,    -1,  1210,  1207,    -1,
      -1,  1213,    -1,  1422,    -1,   403,    -1,  1212,    -1,  1213,
     631,  1212,    -1,  1422,    -1,  1214,   631,  1422,    -1,  1216,
      -1,   119,    -1,   120,    -1,   121,    -1,   122,    -1,   218,
      -1,   219,    -1,   220,    -1,   322,    -1,   323,    -1,   464,
      -1,   616,    -1,   123,    -1,   602,    -1,   221,    -1,   324,
      -1,   331,    -1,   412,    -1,   465,    -1,   320,    -1,   617,
      -1,   118,    -1,   547,    -1,   115,    -1,   544,    -1,    -1,
      19,    -1,   161,    -1,    -1,  1218,  1422,    -1,    -1,    12,
      -1,    -1,    -1,   604,  1222,  1121,    -1,    -1,    -1,   211,
    1224,  1121,    -1,   166,  1135,    -1,    -1,    -1,   205,    47,
    1227,  1228,    -1,  1227,   631,  1410,  1236,    -1,  1410,  1236,
      -1,    -1,   607,    -1,   608,    -1,   373,    47,  1230,    -1,
    1230,   631,  1231,    -1,  1231,    -1,  1412,  1236,    -1,    -1,
    1233,    -1,    -1,   373,    47,  1234,  1235,    -1,  1235,   631,
    1410,  1236,    -1,  1410,  1236,    -1,    -1,    20,    -1,   133,
      -1,    -1,  1239,    -1,    -1,  1239,    -1,   268,  1240,    -1,
     268,  1240,   457,   170,  1242,    -1,   268,   457,   170,  1242,
      -1,  1241,    -1,  1241,   631,  1241,    -1,  1241,   361,  1241,
      -1,  1422,    -1,  1404,    -1,   563,    -1,   282,    -1,   358,
      -1,  1241,    -1,    -1,   268,  1241,    -1,   268,   457,   170,
      -1,   268,  1241,   457,   170,    -1,   358,    -1,   622,   358,
      -1,   622,   282,    -1,   358,    -1,   213,    -1,   282,    -1,
     563,    -1,   125,    -1,   185,    -1,   358,    -1,   213,    -1,
     282,    -1,   563,    -1,  1249,    -1,   358,    -1,   563,    -1,
     282,    -1,   125,    -1,   185,    -1,   358,    -1,   563,    -1,
     213,    -1,   282,    -1,  1249,    -1,  1250,    -1,   125,    -1,
     185,    -1,  1245,    -1,   128,    -1,    -1,    -1,   405,  1422,
    1253,   629,  1254,   630,    -1,    -1,  1255,    -1,  1255,   631,
    1256,    -1,  1256,    -1,  1116,  1121,  1117,    -1,    -1,  1258,
    1259,    -1,  1259,   631,  1260,    -1,  1260,    -1,   636,  1424,
      -1,  1424,    -1,    -1,   241,  1262,  1263,    -1,    -1,    -1,
     377,  1421,  1264,   957,  1265,  1387,  1390,    -1,   147,  1421,
      -1,  1257,    -1,    -1,   144,  1267,  1165,    -1,    -1,   145,
    1277,  1447,  1276,  1269,  1272,  1042,    -1,    -1,   145,   230,
    1422,   363,  1415,  1270,    -1,   145,   111,  1276,  1422,    -1,
     145,   195,  1276,  1422,   637,  1422,    -1,   145,   195,  1276,
    1422,    -1,   145,   405,  1276,   687,    -1,   145,   581,   686,
    1478,    -1,    -1,   145,   598,  1276,  1271,  1272,  1042,    -1,
     145,   168,  1276,   687,    -1,   145,   556,  1276,   687,    -1,
     145,   531,   810,   821,   822,    -1,   145,   278,   205,   811,
     821,   822,    -1,   145,   473,  1276,  1424,    -1,  1273,    -1,
    1272,   631,  1273,    -1,  1415,    -1,  1275,    -1,  1274,   631,
    1275,    -1,  1416,    -1,    -1,   225,   172,    -1,    -1,   537,
      -1,    -1,    -1,   237,  1279,  1284,  1036,  1286,  1280,  1288,
    1304,    -1,    -1,    -1,   441,  1282,  1285,  1286,  1283,  1288,
      -1,    -1,   285,    -1,   130,    -1,   215,    -1,  1313,    -1,
     130,    -1,   241,  1287,    -1,  1287,    -1,  1273,    -1,  1291,
      -1,   629,   630,  1291,    -1,   629,  1290,   630,  1291,    -1,
      -1,   475,  1289,  1295,    -1,  1290,   631,  1408,    -1,  1408,
      -1,   589,  1294,    -1,   590,  1294,    -1,    -1,   882,  1292,
    1501,    -1,    -1,   629,   882,   630,  1293,  1504,    -1,  1294,
     631,  1299,    -1,  1299,    -1,  1295,   631,  1296,    -1,  1296,
      -1,  1412,  1297,  1303,    -1,   161,    -1,   476,    -1,    -1,
    1297,    -1,    -1,   629,  1300,  1301,   630,    -1,    -1,  1302,
      -1,  1302,   631,  1303,    -1,  1303,    -1,  1121,    -1,   128,
      -1,    -1,    -1,   363,   148,  1305,   254,   578,  1311,    -1,
      -1,    -1,   578,  1307,  1313,  1036,  1172,   475,  1309,  1308,
    1221,  1232,  1243,    -1,  1309,   631,  1310,    -1,  1310,    -1,
    1412,  1297,  1303,    -1,  1311,   631,  1312,    -1,  1312,    -1,
    1412,  1297,  1303,    -1,    -1,   285,    -1,    -1,   132,  1315,
    1323,  1316,    -1,    -1,   192,  1415,  1317,  1221,  1232,  1243,
      -1,    -1,  1320,  1318,   192,  1172,  1221,    -1,    -1,   192,
    1274,  1319,   585,  1172,  1221,    -1,  1321,    -1,  1320,   631,
    1321,    -1,  1422,  1322,    -1,  1422,   637,  1422,  1322,    -1,
      -1,   637,   624,    -1,    -1,  1324,  1323,    -1,   414,    -1,
     285,    -1,   226,    -1,    -1,   559,  1327,  1326,  1273,    -1,
      -1,   534,    -1,    -1,  1329,    -1,  1330,    -1,  1329,   631,
    1330,    -1,   102,    -1,   317,    -1,    42,   245,    -1,    97,
     528,    -1,   381,   180,    -1,   246,    -1,   527,    -1,   493,
      -1,    12,    -1,    -1,   190,   413,   358,    -1,    -1,   480,
    1333,  1334,    -1,   112,  1345,    -1,  1341,   530,  1340,  1345,
      -1,  1341,   555,  1340,  1345,    -1,   167,  1340,  1345,    -1,
     534,   511,  1340,  1345,    -1,   367,   530,  1340,  1345,    -1,
     393,    -1,   159,   901,  1337,    -1,   159,    12,  1337,    -1,
    1341,    73,  1342,  1415,  1340,  1345,    -1,  1338,   279,    -1,
     485,   217,    -1,    -1,    35,   167,  1343,  1344,  1335,  1237,
      -1,    -1,   429,   167,  1343,  1344,  1336,  1237,    -1,   979,
    1342,  1415,  1340,  1221,    -1,  1339,   158,    -1,    24,    -1,
      99,    -1,   404,    -1,   101,   629,   624,   630,   601,    -1,
     101,   629,   624,   630,   164,    -1,   601,  1237,    -1,   164,
    1237,    -1,   409,    -1,   408,  1328,  1331,  1237,    -1,  1436,
     511,  1345,    -1,  1341,   407,    -1,  1436,   593,  1345,    -1,
     954,  1345,    -1,    72,  1345,    -1,   204,    -1,   204,   190,
    1425,    -1,   103,   111,   892,  1422,    -1,   103,   534,  1415,
      -1,   103,   598,  1415,    -1,   301,   511,    -1,   485,   511,
      -1,    67,    -1,   582,    -1,   533,    -1,   231,    -1,   103,
     405,   687,    -1,   103,   195,   687,    -1,   103,   556,   687,
      -1,   405,   511,  1345,    -1,   195,   511,  1345,    -1,   405,
      70,   687,    -1,   195,    70,   687,    -1,   103,   168,   687,
      -1,   511,    -1,   335,    -1,   279,    -1,   301,    -1,    34,
      -1,    -1,   515,    -1,    -1,  1342,  1422,    -1,    -1,   193,
      -1,   192,    -1,   244,    -1,    -1,   244,  1419,    -1,    -1,
     192,  1247,    -1,    -1,   267,  1419,    -1,   604,  1121,    -1,
      -1,  1349,  1415,  1347,  1351,    -1,    -1,  1349,  1350,  1348,
    1099,    -1,   133,    -1,   134,    -1,    -1,   175,    -1,   388,
      -1,    -1,  1403,    -1,  1422,    -1,    -1,   187,  1074,  1353,
    1354,    -1,    -1,    -1,  1447,  1355,  1360,  1356,  1357,    -1,
    1358,    -1,    -1,   606,   418,   277,  1361,    -1,  1358,   631,
    1359,    -1,  1359,    -1,   163,   279,    -1,   159,   279,    -1,
     197,   279,    -1,   486,   279,    -1,    34,   279,    -1,   428,
     279,    -1,   413,    49,    -1,   217,    -1,   404,    -1,   279,
      -1,   511,    -1,   485,    -1,    67,    -1,   582,    -1,   533,
      -1,   231,    -1,   301,    -1,   135,    -1,   446,    -1,    -1,
    1272,    -1,    -1,    17,   138,    61,    -1,    -1,   444,  1363,
    1364,    -1,  1364,   631,  1365,    -1,  1365,    -1,    -1,   485,
    1366,  1367,    -1,   301,    -1,   413,    49,    -1,    -1,    12,
      -1,    -1,   411,  1369,  1370,    -1,  1338,   279,  1371,    -1,
     551,  1419,    -1,    30,  1121,    -1,    -1,   255,  1373,  1374,
    1375,  1376,    -1,    -1,   209,    -1,   490,    -1,    -1,    90,
      -1,   413,    -1,  1121,    -1,   581,  1425,    -1,   584,  1422,
      -1,    -1,    -1,    -1,    -1,   273,  1383,  1379,  1385,  1384,
     232,  1421,  1380,  1386,   241,   534,  1415,  1381,   957,  1382,
    1393,  1387,  1390,  1394,  1396,  1399,    -1,   114,    -1,   614,
      -1,    -1,   274,    -1,    -1,    88,    -1,   285,    -1,    -1,
     441,    -1,   226,    -1,    -1,    73,  1388,    -1,  1388,  1389,
      -1,  1389,    -1,   539,    47,  1403,    -1,   371,   154,    47,
    1403,    -1,   154,    47,  1403,    -1,   165,    47,  1403,    -1,
      -1,   270,  1391,    -1,  1391,  1392,    -1,  1392,    -1,   539,
      47,  1403,    -1,   508,    47,  1403,    -1,    -1,   457,   223,
      47,  1403,    -1,    -1,   226,   358,  1395,    -1,   270,    -1,
     457,    -1,    -1,   629,  1397,   630,    -1,   629,   630,    -1,
    1397,   631,  1398,    -1,  1398,    -1,  1412,    -1,   636,  1424,
      -1,    -1,   475,  1400,    -1,  1400,   631,  1401,    -1,  1401,
      -1,  1412,  1297,  1116,  1303,  1117,    -1,   540,    -1,   342,
      -1,   566,   540,    -1,  1402,  1420,    -1,  1420,    -1,   213,
      -1,   214,    -1,    36,    -1,   383,    -1,  1406,    -1,   623,
    1407,    -1,   622,  1407,    -1,  1402,    -1,  1407,    -1,   357,
      -1,   178,    -1,   558,    -1,   213,    -1,   214,    -1,    36,
      -1,   566,   953,    -1,   566,    36,    -1,   118,  1402,    -1,
     547,  1402,    -1,   544,  1402,    -1,   358,    -1,   282,    -1,
     563,    -1,   125,    -1,   185,    -1,  1412,    -1,  1409,    -1,
    1422,   637,   624,    -1,  1422,   637,  1422,   637,   624,    -1,
    1121,    -1,  1422,    -1,  1413,    -1,  1422,    -1,  1413,    -1,
    1422,   637,  1422,    -1,   637,  1422,   637,  1422,    -1,  1422,
     637,  1422,   637,  1422,    -1,  1422,    -1,  1422,   637,  1422,
     637,  1422,    -1,  1422,   637,  1422,    -1,   637,  1422,    -1,
    1422,    -1,  1422,   637,  1422,    -1,   637,  1422,    -1,  1422,
    1322,    -1,  1422,   637,  1422,  1322,    -1,  1422,    -1,   222,
      -1,   224,    -1,   540,    -1,   540,    -1,   540,    -1,  1418,
      -1,  1426,    -1,  1418,    -1,  1427,    -1,  1422,    -1,  1419,
      -1,   266,    -1,  1424,    -1,  1424,   636,  1424,    -1,   107,
    1120,    -1,  1427,    -1,    21,    -1,    29,    -1,    31,    -1,
      48,    -1,    49,    -1,    59,    -1,    62,    -1,    61,    -1,
      68,    -1,    74,    -1,    75,    -1,    76,    -1,    77,    -1,
      78,    -1,    79,    -1,    82,    -1,    84,    -1,    96,    -1,
     124,    -1,   144,    -1,   155,    -1,   170,    -1,   171,    -1,
     187,    -1,   208,    -1,   212,    -1,   216,    -1,   239,    -1,
     256,    -1,   354,    -1,   367,    -1,   370,    -1,   369,    -1,
     379,    -1,   384,    -1,   389,    -1,   397,    -1,   400,    -1,
     435,    -1,   438,    -1,   444,    -1,   447,    -1,   454,    -1,
     461,    -1,   466,    -1,   473,    -1,   483,    -1,   489,    -1,
     485,    -1,   491,    -1,   510,    -1,   514,    -1,   559,    -1,
     570,    -1,   571,    -1,   610,    -1,   613,    -1,   579,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,
      11,    -1,    14,    -1,    18,    -1,    23,    -1,    24,    -1,
      26,    -1,    25,    -1,    27,    -1,    28,    -1,    35,    -1,
      39,    -1,    42,    -1,    44,    -1,    43,    -1,    46,    -1,
      52,    -1,    55,    -1,    56,    -1,    58,    -1,    64,    -1,
      67,    -1,    66,    -1,    65,    -1,    69,    -1,    70,    -1,
      72,    -1,    81,    -1,    73,    -1,    83,    -1,    85,    -1,
      86,    -1,    87,    -1,    88,    -1,    90,    -1,    91,    -1,
      93,    -1,    95,    -1,    94,    -1,    97,    -1,    99,    -1,
     102,    -1,   105,    -1,   109,    -1,   114,    -1,   113,    -1,
     115,    -1,   118,    -1,   123,    -1,   129,    -1,   131,    -1,
     135,    -1,   137,    -1,   138,    -1,   139,    -1,   140,    -1,
     147,    -1,   148,    -1,   149,    -1,   156,    -1,   160,    -1,
     159,    -1,   158,    -1,   163,    -1,   164,    -1,   166,    -1,
     168,    -1,   167,    -1,   169,    -1,   174,    -1,   175,    -1,
     176,    -1,   180,    -1,   179,    -1,   191,    -1,   153,    -1,
     193,    -1,   182,    -1,   183,    -1,   184,    -1,   197,    -1,
     198,    -1,   200,    -1,   199,    -1,   201,    -1,   204,    -1,
     202,    -1,   210,    -1,   209,    -1,   217,    -1,   221,    -1,
     223,    -1,   227,    -1,   231,    -1,   243,    -1,   228,    -1,
     229,    -1,   233,    -1,   245,    -1,   246,    -1,   248,    -1,
     249,    -1,   238,    -1,   253,    -1,   258,    -1,   257,    -1,
     261,    -1,   264,    -1,   265,    -1,   271,    -1,   272,    -1,
     274,    -1,   276,    -1,   278,    -1,   279,    -1,   307,    -1,
     301,    -1,   303,    -1,   288,    -1,   292,    -1,   289,    -1,
     290,    -1,   302,    -1,   291,    -1,   293,    -1,   287,    -1,
     299,    -1,   295,    -1,   294,    -1,   296,    -1,   297,    -1,
     298,    -1,   305,    -1,   306,    -1,   308,    -1,   310,    -1,
     311,    -1,   316,    -1,   317,    -1,   318,    -1,   319,    -1,
     320,    -1,   321,    -1,   324,    -1,   325,    -1,   329,    -1,
     327,    -1,   331,    -1,   332,    -1,   333,    -1,   334,    -1,
     335,    -1,   336,    -1,   337,    -1,   339,    -1,   338,    -1,
     340,    -1,   343,    -1,   344,    -1,   348,    -1,   347,    -1,
     355,    -1,   349,    -1,   350,    -1,   360,    -1,   361,    -1,
     362,    -1,   364,    -1,   365,    -1,   366,    -1,   380,    -1,
     381,    -1,   386,    -1,   387,    -1,   388,    -1,   390,    -1,
     391,    -1,   392,    -1,   394,    -1,   393,    -1,   395,    -1,
     396,    -1,   401,    -1,   402,    -1,   404,    -1,   406,    -1,
     407,    -1,   408,    -1,   409,    -1,   410,    -1,   412,    -1,
     413,    -1,   414,    -1,   417,    -1,   421,    -1,   422,    -1,
     424,    -1,   423,    -1,   425,    -1,   428,    -1,   429,    -1,
     430,    -1,   431,    -1,   432,    -1,   434,    -1,   437,    -1,
     439,    -1,   442,    -1,   446,    -1,   449,    -1,   450,    -1,
     455,    -1,   456,    -1,   457,    -1,   458,    -1,   459,    -1,
     460,    -1,   462,    -1,   463,    -1,   465,    -1,   471,    -1,
     470,    -1,   472,    -1,   484,    -1,   477,    -1,   481,    -1,
     486,    -1,   488,    -1,   490,    -1,   492,    -1,   493,    -1,
     501,    -1,   500,    -1,   503,    -1,   506,    -1,   509,    -1,
     511,    -1,   515,    -1,   517,    -1,   518,    -1,   519,    -1,
     520,    -1,   522,    -1,   521,    -1,   525,    -1,   526,    -1,
     527,    -1,   528,    -1,   536,    -1,   533,    -1,   530,    -1,
     535,    -1,   531,    -1,   537,    -1,   538,    -1,   541,    -1,
     542,    -1,   553,    -1,   554,    -1,   555,    -1,   544,    -1,
     545,    -1,   546,    -1,   547,    -1,   560,    -1,   561,    -1,
     562,    -1,   195,    -1,   564,    -1,   565,    -1,   568,    -1,
     567,    -1,   574,    -1,   577,    -1,   581,    -1,   582,    -1,
     583,    -1,   593,    -1,   598,    -1,   599,    -1,   590,    -1,
     601,    -1,   600,    -1,   602,    -1,   609,    -1,   612,    -1,
     614,    -1,   617,    -1,   597,    -1,    -1,   475,  1430,  1429,
    1431,    -1,    -1,   370,    -1,  1432,    -1,  1431,   631,  1432,
      -1,    -1,  1433,  1438,    -1,  1435,    -1,   202,    -1,   274,
      -1,   472,    -1,    -1,   364,    -1,    -1,   202,    -1,   274,
      -1,   472,    -1,    -1,   202,   637,    -1,   274,   637,    -1,
     472,   637,    -1,  1439,    -1,  1435,  1440,    -1,  1434,  1441,
    1297,  1444,    -1,  1434,   553,   248,   265,  1442,    -1,   636,
    1424,  1297,  1121,    -1,   636,   636,  1437,  1441,  1297,  1444,
      -1,   954,   959,    -1,   338,  1297,  1121,    -1,   338,   956,
     961,    -1,   390,  1297,  1443,    -1,   390,   190,  1425,  1297,
    1443,    -1,  1422,    -1,  1422,   637,  1422,    -1,   128,   637,
    1422,    -1,   418,   564,    -1,   418,    83,    -1,   439,   418,
      -1,   470,    -1,   540,    -1,   390,   629,   540,   630,    -1,
     362,   629,   540,   630,    -1,  1121,    -1,   128,    -1,   363,
      -1,    12,    -1,    34,    -1,    -1,   277,  1447,  1446,  1449,
      -1,   534,    -1,   530,    -1,  1447,    -1,   598,    -1,  1450,
      -1,  1449,   631,  1450,    -1,  1415,  1219,  1451,    -1,   418,
      -1,   611,    -1,   611,    88,    -1,   285,   611,    -1,   418,
     274,    -1,    -1,   575,  1453,  1447,    -1,   208,  1415,   367,
    1219,    -1,   208,  1417,    68,    -1,    -1,   208,  1417,   418,
    1455,  1456,  1221,  1238,    -1,  1457,    -1,  1422,  1458,    -1,
     183,    -1,   348,    -1,   183,    -1,   348,    -1,   402,    -1,
     257,    -1,    -1,  1460,  1459,   629,  1302,   630,    -1,   161,
      -1,   196,    -1,   259,    -1,   207,    -1,   286,    -1,   452,
     686,  1462,    -1,  1466,   363,  1465,  1477,   192,  1478,    -1,
    1466,   363,   195,  1477,   192,  1478,    -1,  1466,   363,   405,
    1477,   192,  1478,    -1,    12,  1467,   631,   203,   370,   192,
    1478,    -1,   410,   363,  1425,   192,  1478,    -1,   203,   686,
    1464,    -1,  1466,   363,  1465,  1477,   551,  1479,  1486,  1487,
      -1,  1466,   363,   195,  1477,   551,  1479,  1486,  1487,    -1,
    1466,   363,   405,  1477,   551,  1479,  1486,  1487,    -1,   410,
     363,  1425,   551,  1479,  1488,    -1,    -1,   534,    -1,  1468,
      -1,    12,  1467,    -1,    -1,   404,    -1,  1469,    -1,  1468,
     631,  1469,    -1,    -1,   467,  1470,  1483,    -1,    -1,   237,
    1471,  1483,    -1,    -1,   578,  1472,  1483,    -1,    -1,   426,
    1473,  1483,    -1,   132,    -1,   580,    -1,   230,    -1,    13,
      -1,   103,    -1,   145,    -1,   171,    -1,   434,    -1,   481,
      -1,   406,    -1,   182,    -1,   203,   370,    -1,   480,   112,
      -1,   525,    -1,   103,   537,   530,    -1,   277,   530,    -1,
     442,   485,    -1,   442,    66,    -1,   103,   598,    -1,   480,
     598,    -1,   103,   456,    -1,    13,   456,    -1,   103,   581,
      -1,   168,    -1,   556,    -1,   103,   531,    -1,    -1,    17,
      -1,  1476,  1474,  1475,    -1,  1476,    -1,   520,   540,    -1,
     249,   540,    -1,    64,   540,    -1,   624,    -1,  1422,   637,
     624,    -1,   624,   637,   624,    -1,  1415,    -1,  1425,    -1,
    1478,   631,  1425,    -1,  1482,    -1,  1479,   631,  1482,    -1,
     597,    -1,   606,    -1,   585,    -1,    19,    -1,  1425,   223,
      47,   540,    -1,  1425,   223,    47,   390,   540,    -1,  1425,
     223,  1480,  1424,    -1,  1425,   223,  1480,  1424,  1481,  1419,
      -1,  1425,    -1,    -1,   629,  1484,   630,    -1,  1484,   631,
    1485,    -1,  1485,    -1,  1422,    -1,    -1,   443,  1475,    -1,
     443,   507,    -1,   443,   612,    -1,   443,   350,    -1,    -1,
     606,  1489,    -1,    -1,   606,   203,   370,    -1,  1489,  1490,
      -1,  1490,    -1,   203,   370,    -1,   306,  1245,    -1,   310,
    1245,    -1,   305,  1245,    -1,   311,  1244,    -1,    -1,    31,
    1492,  1493,    -1,    -1,   609,    -1,    -1,    17,   354,    56,
      -1,    17,    56,    -1,    -1,   433,    -1,   354,   433,    -1,
      -1,   461,    -1,    84,  1493,  1494,  1495,    -1,   454,  1493,
    1494,  1495,    -1,   454,  1493,   551,  1496,  1422,    -1,   461,
    1422,    -1,   433,   461,  1422,    -1,    -1,  1502,    -1,    -1,
     572,  1509,  1503,  1100,    -1,    -1,  1502,    -1,  1506,    -1,
      -1,  1506,    -1,    -1,  1507,  1508,    -1,  1233,  1237,    -1,
    1239,    -1,    -1,   141,    -1,    12,    -1,   467,  1189,    -1,
     629,  1102,   630,    -1,  1510,  1505,    -1,    -1,  1511,   572,
    1509,  1512,  1510,  1505,    -1,  1514,  1511,  1515,    -1,    -1,
      -1,    -1,  1517,    -1,  1517,  1518,    -1,  1518,    -1,   516,
      -1,   215,    -1,   141,    -1,   504,    -1,   499,    -1,   500,
      -1,   502,    -1,    12,    -1,  1524,  1520,    -1,  1523,  1521,
      -1,  1525,  1522,  1529,    -1,  1529,    -1,  1537,    -1,  1548,
      -1,  1542,    -1,   673,    -1,  1529,    -1,  1537,    -1,  1548,
      -1,  1542,    -1,  1541,    -1,   673,    -1,  1523,    -1,  1524,
      -1,    -1,   129,   161,  1425,    -1,  1526,    -1,  1526,  1527,
      -1,  1527,    -1,   375,   441,    -1,    11,   161,   565,    -1,
      11,   161,   318,    -1,    11,   161,   538,    -1,    -1,   505,
     466,   129,    -1,   505,   466,   243,    -1,    -1,  1528,   598,
    1415,  1530,  1531,    19,  1533,    -1,    -1,   629,  1532,   630,
      -1,  1422,    -1,  1532,   631,  1422,    -1,    -1,  1534,  1535,
    1536,    -1,   467,  1103,    -1,   629,  1101,   630,  1504,    -1,
      -1,   606,    63,   370,    -1,   606,    52,    63,   370,    -1,
     606,   274,    63,   370,    -1,    -1,    -1,    -1,   556,  1116,
     687,   781,   782,   363,  1116,  1538,  1415,   190,  1116,  1539,
     150,   459,  1540,   731,    -1,    10,  1116,   195,  1422,   450,
     905,   491,  1419,    -1,  1116,   195,  1422,   450,   905,   491,
    1419,    -1,    -1,    -1,    -1,    -1,    -1,  1116,   195,   687,
     629,  1543,   698,   630,  1544,   450,  1545,   951,  1546,   689,
    1547,   731,    -1,    -1,    -1,    -1,    -1,   405,  1116,   687,
    1549,   629,  1550,   702,   630,  1551,   689,  1552,   731,    -1,
     613,  1555,  1554,  1556,    -1,   613,   155,  1554,  1558,    -1,
     613,   400,  1554,    -1,   613,    84,  1554,  1557,    -1,   613,
     454,  1554,    -1,   613,   422,    -1,  1403,    -1,  1403,   631,
    1403,    -1,  1403,   631,  1403,   631,  1245,    -1,    31,    -1,
     510,    -1,    -1,   251,    -1,   449,    -1,    -1,   365,   392,
      -1,    -1,    -1,   526,  1559,  1560,    -1,    -1,   190,   321,
      -1,   239,   394,  1422,   491,  1419,    -1,   239,   491,  1419,
      -1,   571,   394,  1422,    -1,   571,   491,  1419,    -1,   619,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1710,  1710,  1722,  1721,  1746,  1753,  1755,  1759,  1760,
    1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
    1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,
    1785,  1786,  1787,  1788,  1789,  1790,  1791,  1792,  1793,  1794,
    1795,  1796,  1797,  1798,  1799,  1800,  1801,  1802,  1803,  1804,
    1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,
    1815,  1816,  1817,  1821,  1830,  1831,  1835,  1844,  1850,  1860,
    1859,  1869,  1871,  1875,  1876,  1880,  1893,  1892,  1912,  1911,
    1920,  1921,  1925,  1929,  1933,  1937,  1941,  1945,  1950,  1954,
    1958,  1962,  1966,  1970,  1976,  2007,  2012,  2015,  2017,  2018,
    2022,  2028,  2032,  2048,  2052,  2064,  2063,  2104,  2103,  2115,
    2113,  2126,  2124,  2136,  2135,  2148,  2147,  2155,  2159,  2163,
    2167,  2174,  2187,  2188,  2192,  2196,  2200,  2204,  2208,  2212,
    2216,  2224,  2223,  2254,  2253,  2260,  2267,  2268,  2274,  2280,
    2290,  2296,  2302,  2304,  2311,  2312,  2316,  2322,  2331,  2332,
    2340,  2340,  2396,  2397,  2398,  2399,  2400,  2401,  2402,  2403,
    2404,  2405,  2406,  2407,  2408,  2413,  2427,  2443,  2461,  2462,
    2466,  2467,  2472,  2474,  2476,  2478,  2480,  2482,  2484,  2490,
    2491,  2492,  2496,  2500,  2508,  2507,  2520,  2522,  2525,  2527,
    2531,  2535,  2542,  2544,  2548,  2549,  2554,  2574,  2600,  2602,
    2606,  2607,  2611,  2637,  2638,  2639,  2640,  2644,  2645,  2649,
    2650,  2655,  2658,  2685,  2684,  2748,  2764,  2763,  2817,  2843,
    2843,  2866,  2867,  2872,  2874,  2879,  2902,  2915,  2919,  2936,
    2937,  2941,  2945,  2954,  2961,  2968,  2978,  2992,  3015,  3021,
    3022,  3028,  3031,  3035,  3043,  3063,  3065,  3083,  3089,  3091,
    3093,  3095,  3097,  3099,  3101,  3103,  3105,  3107,  3109,  3111,
    3116,  3130,  3145,  3163,  3164,  3168,  3169,  3170,  3171,  3172,
    3173,  3174,  3175,  3176,  3177,  3178,  3179,  3180,  3185,  3184,
    3191,  3191,  3246,  3245,  3274,  3274,  3288,  3341,  3384,  3405,
    3404,  3426,  3445,  3447,  3448,  3452,  3472,  3495,  3497,  3513,
    3495,  3532,  3534,  3535,  3539,  3540,  3545,  3551,  3544,  3572,
    3571,  3587,  3588,  3592,  3593,  3598,  3602,  3597,  3623,  3627,
    3622,  3646,  3656,  3661,  3660,  3696,  3697,  3702,  3701,  3734,
    3734,  3749,  3748,  3784,  3796,  3798,  3795,  3825,  3824,  3845,
    3847,  3852,  3854,  3856,  3873,  3878,  3884,  3891,  3892,  3900,
    3906,  3915,  3921,  3927,  3928,  3932,  3932,  3937,  3938,  3939,
    3943,  3944,  3945,  3949,  3953,  3954,  3955,  3959,  3960,  3961,
    3962,  3963,  3964,  3965,  3966,  3970,  3974,  3975,  3976,  3980,
    3981,  3982,  3983,  3984,  3988,  3992,  3993,  3994,  3998,  3999,
    4000,  4001,  4002,  4003,  4004,  4008,  4012,  4013,  4014,  4018,
    4019,  4020,  4025,  4033,  4041,  4049,  4061,  4073,  4078,  4083,
    4091,  4099,  4107,  4115,  4123,  4131,  4139,  4152,  4165,  4178,
    4180,  4184,  4189,  4202,  4203,  4254,  4255,  4258,  4272,  4290,
    4289,  4298,  4296,  4303,  4305,  4304,  4308,  4307,  4313,  4350,
    4351,  4356,  4355,  4374,  4393,  4392,  4409,  4413,  4421,  4420,
    4423,  4425,  4427,  4429,  4434,  4435,  4441,  4442,  4459,  4460,
    4464,  4465,  4469,  4488,  4498,  4509,  4518,  4519,  4535,  4537,
    4536,  4541,  4539,  4550,  4551,  4555,  4573,  4589,  4590,  4606,
    4621,  4643,  4644,  4649,  4648,  4672,  4682,  4704,  4703,  4721,
    4720,  4740,  4762,  4766,  4795,  4807,  4808,  4813,  4824,  4812,
    4849,  4850,  4854,  4867,  4888,  4901,  4927,  4928,  4933,  4932,
    4969,  4974,  4975,  4979,  4980,  4984,  4986,  4992,  4998,  5000,
    5002,  5004,  5006,  5008,  5018,  5033,  5017,  5047,  5048,  5052,
    5053,  5057,  5058,  5062,  5063,  5067,  5068,  5072,  5073,  5077,
    5081,  5082,  5085,  5087,  5091,  5092,  5096,  5097,  5098,  5102,
    5107,  5112,  5117,  5122,  5127,  5132,  5137,  5152,  5158,  5163,
    5168,  5173,  5178,  5184,  5183,  5209,  5210,  5211,  5216,  5221,
    5226,  5228,  5230,  5232,  5238,  5243,  5248,  5254,  5260,  5266,
    5275,  5293,  5310,  5333,  5347,  5348,  5349,  5350,  5351,  5352,
    5353,  5357,  5358,  5359,  5363,  5364,  5368,  5369,  5370,  5371,
    5376,  5383,  5384,  5388,  5389,  5393,  5394,  5402,  5401,  5410,
    5408,  5418,  5416,  5426,  5424,  5432,  5451,  5457,  5459,  5463,
    5467,  5468,  5472,  5477,  5476,  5502,  5505,  5504,  5514,  5516,
    5521,  5524,  5528,  5535,  5536,  5540,  5541,  5545,  5551,  5557,
    5561,  5577,  5593,  5594,  5595,  5596,  5601,  5605,  5610,  5615,
    5619,  5624,  5629,  5635,  5640,  5646,  5650,  5655,  5660,  5678,
    5680,  5682,  5695,  5697,  5702,  5707,  5719,  5724,  5729,  5734,
    5736,  5738,  5740,  5742,  5744,  5746,  5748,  5751,  5750,  5755,
    5754,  5758,  5760,  5769,  5770,  5771,  5777,  5778,  5779,  5780,
    5781,  5785,  5789,  5790,  5794,  5795,  5799,  5800,  5801,  5802,
    5803,  5807,  5808,  5809,  5810,  5811,  5815,  5820,  5822,  5828,
    5829,  5831,  5836,  5845,  5846,  5850,  5851,  5855,  5856,  5857,
    5861,  5862,  5863,  5864,  5867,  5868,  5872,  5873,  5877,  5878,
    5882,  5883,  5887,  5888,  5889,  5890,  5897,  5898,  5904,  5910,
    5916,  5922,  5923,  5936,  5942,  5948,  5954,  5963,  5984,  5990,
    5995,  5996,  6000,  6001,  6005,  6013,  6017,  6018,  6022,  6023,
    6027,  6036,  6040,  6041,  6045,  6056,  6057,  6061,  6062,  6066,
    6067,  6072,  6073,  6077,  6084,  6093,  6101,  6112,  6113,  6114,
    6115,  6116,  6117,  6122,  6130,  6131,  6135,  6137,  6141,  6153,
    6154,  6158,  6165,  6178,  6179,  6181,  6183,  6189,  6194,  6200,
    6206,  6213,  6223,  6224,  6225,  6226,  6227,  6231,  6235,  6236,
    6240,  6241,  6245,  6246,  6250,  6251,  6252,  6256,  6257,  6261,
    6265,  6278,  6290,  6291,  6295,  6296,  6300,  6301,  6305,  6306,
    6310,  6311,  6315,  6316,  6320,  6321,  6325,  6326,  6330,  6332,
    6333,  6339,  6345,  6351,  6359,  6360,  6364,  6368,  6369,  6382,
    6383,  6384,  6388,  6389,  6393,  6399,  6413,  6414,  6418,  6419,
    6423,  6424,  6432,  6431,  6468,  6467,  6481,  6493,  6492,  6511,
    6510,  6529,  6528,  6547,  6541,  6561,  6560,  6593,  6598,  6603,
    6608,  6613,  6623,  6624,  6625,  6626,  6630,  6631,  6643,  6644,
    6648,  6649,  6652,  6654,  6655,  6656,  6658,  6660,  6661,  6670,
    6671,  6675,  6684,  6682,  6695,  6708,  6707,  6720,  6718,  6731,
    6738,  6748,  6752,  6759,  6763,  6768,  6767,  6783,  6785,  6790,
    6798,  6797,  6813,  6817,  6816,  6828,  6829,  6833,  6848,  6849,
    6853,  6862,  6866,  6871,  6876,  6875,  6887,  6898,  6886,  6914,
    6923,  6927,  6936,  6945,  6951,  6957,  6966,  6975,  6994,  7014,
    7024,  7028,  7036,  7037,  7041,  7042,  7046,  7046,  7049,  7051,
    7055,  7056,  7060,  7061,  7065,  7066,  7067,  7071,  7072,  7073,
    7077,  7078,  7079,  7080,  7089,  7088,  7097,  7105,  7104,  7112,
    7121,  7130,  7131,  7138,  7138,  7144,  7145,  7149,  7150,  7151,
    7155,  7156,  7172,  7173,  7178,  7177,  7189,  7190,  7191,  7196,
    7195,  7225,  7226,  7230,  7231,  7235,  7236,  7237,  7238,  7243,
    7242,  7263,  7272,  7271,  7304,  7305,  7309,  7310,  7314,  7315,
    7316,  7317,  7318,  7319,  7324,  7323,  7344,  7345,  7346,  7351,
    7350,  7356,  7363,  7368,  7376,  7377,  7381,  7395,  7394,  7408,
    7409,  7413,  7414,  7418,  7428,  7438,  7439,  7444,  7443,  7455,
    7456,  7460,  7461,  7465,  7475,  7486,  7485,  7493,  7493,  7502,
    7503,  7508,  7509,  7518,  7527,  7528,  7532,  7537,  7542,  7547,
    7552,  7551,  7571,  7579,  7571,  7586,  7587,  7588,  7589,  7590,
    7594,  7601,  7608,  7610,  7621,  7622,  7626,  7627,  7655,  7685,
    7687,  7693,  7703,  7704,  7705,  7719,  7724,  7749,  7755,  7761,
    7762,  7763,  7764,  7765,  7769,  7770,  7771,  7775,  7776,  7781,
    7832,  7839,  7882,  7888,  7894,  7900,  7906,  7912,  7918,  7924,
    7928,  7934,  7940,  7946,  7952,  7958,  7962,  7968,  7977,  7983,
    7991,  7997,  8007,  8013,  8022,  8032,  8038,  8048,  8054,  8063,
    8067,  8073,  8079,  8085,  8091,  8097,  8103,  8109,  8115,  8121,
    8127,  8133,  8139,  8145,  8151,  8155,  8156,  8160,  8161,  8165,
    8166,  8170,  8171,  8175,  8176,  8177,  8178,  8179,  8180,  8184,
    8185,  8190,  8196,  8200,  8207,  8214,  8221,  8228,  8235,  8240,
    8246,  8253,  8260,  8268,  8279,  8301,  8308,  8316,  8317,  8318,
    8319,  8320,  8321,  8332,  8333,  8334,  8335,  8336,  8342,  8346,
    8352,  8358,  8364,  8370,  8372,  8379,  8386,  8392,  8394,  8403,
    8410,  8418,  8424,  8431,  8437,  8451,  8458,  8474,  8480,  8486,
    8494,  8500,  8506,  8512,  8518,  8532,  8543,  8549,  8555,  8561,
    8567,  8573,  8579,  8585,  8591,  8597,  8603,  8609,  8615,  8621,
    8627,  8633,  8639,  8647,  8668,  8675,  8681,  8688,  8695,  8702,
    8709,  8715,  8721,  8728,  8734,  8741,  8747,  8753,  8759,  8765,
    8771,  8789,  8795,  8801,  8808,  8815,  8823,  8830,  8837,  8844,
    8851,  8858,  8875,  8881,  8887,  8893,  8899,  8906,  8912,  8918,
    8924,  8930,  8936,  8947,  8953,  8959,  8965,  8971,  8982,  8988,
    9004,  9010,  9017,  9024,  9031,  9038,  9045,  9049,  9069,  9068,
    9140,  9181,  9183,  9188,  9189,  9193,  9194,  9198,  9199,  9203,
    9210,  9218,  9245,  9251,  9257,  9263,  9269,  9275,  9284,  9291,
    9293,  9290,  9300,  9311,  9317,  9323,  9329,  9335,  9341,  9347,
    9353,  9359,  9366,  9365,  9385,  9384,  9399,  9409,  9417,  9433,
    9434,  9439,  9444,  9447,  9450,  9449,  9466,  9468,  9474,  9473,
    9490,  9492,  9494,  9496,  9498,  9500,  9502,  9504,  9506,  9508,
    9514,  9520,  9523,  9522,  9528,  9529,  9533,  9540,  9548,  9549,
    9553,  9560,  9568,  9569,  9573,  9574,  9578,  9586,  9597,  9598,
    9610,  9621,  9622,  9628,  9629,  9649,  9651,  9655,  9653,  9670,
    9668,  9686,  9684,  9691,  9700,  9698,  9716,  9715,  9725,  9736,
    9734,  9753,  9752,  9763,  9774,  9775,  9776,  9788,  9788,  9802,
    9842,  9918,  9929,  9934,  9926,  9953,  9973,  9981,  9973,  9990,
    9989, 10012, 10029, 10012, 10036, 10040, 10066, 10067, 10072, 10075,
   10076, 10077, 10081, 10082, 10087, 10086, 10092, 10091, 10099, 10100,
   10103, 10105, 10105, 10109, 10109, 10114, 10115, 10119, 10121, 10126,
   10127, 10131, 10142, 10155, 10156, 10157, 10158, 10159, 10160, 10161,
   10162, 10163, 10164, 10165, 10166, 10170, 10171, 10172, 10173, 10174,
   10175, 10176, 10177, 10178, 10182, 10183, 10184, 10185, 10188, 10190,
   10191, 10195, 10196, 10204, 10206, 10210, 10212, 10211, 10225, 10228,
   10227, 10242, 10248, 10262, 10264, 10268, 10270, 10275, 10276, 10296,
   10321, 10325, 10326, 10330, 10342, 10344, 10349, 10348, 10383, 10385,
   10390, 10391, 10392, 10397, 10404, 10408, 10409, 10413, 10417, 10421,
   10428, 10435, 10442, 10452, 10485, 10489, 10495, 10501, 10510, 10518,
   10522, 10529, 10530, 10534, 10535, 10536, 10540, 10541, 10542, 10543,
   10544, 10545, 10549, 10550, 10551, 10552, 10553, 10557, 10558, 10559,
   10560, 10561, 10565, 10566, 10567, 10568, 10569, 10573, 10578, 10579,
   10583, 10584, 10587, 10590, 10589, 10620, 10621, 10625, 10626, 10630,
   10640, 10640, 10650, 10651, 10655, 10674, 10707, 10706, 10719, 10727,
   10718, 10729, 10741, 10753, 10752, 10770, 10769, 10780, 10780, 10796,
   10803, 10825, 10845, 10857, 10862, 10861, 10871, 10877, 10884, 10889,
   10894, 10904, 10905, 10909, 10920, 10921, 10925, 10936, 10937, 10941,
   10942, 10950, 10958, 10949, 10968, 10975, 10967, 10985, 10993, 10994,
   11002, 11006, 11007, 11018, 11019, 11023, 11032, 11033, 11034, 11036,
   11035, 11046, 11047, 11051, 11052, 11054, 11053, 11057, 11056, 11062,
   11063, 11067, 11068, 11072, 11082, 11083, 11087, 11088, 11093, 11092,
   11106, 11107, 11111, 11116, 11124, 11125, 11133, 11135, 11135, 11143,
   11151, 11142, 11173, 11174, 11178, 11186, 11187, 11191, 11201, 11202,
   11209, 11208, 11224, 11223, 11235, 11234, 11246, 11245, 11259, 11260,
   11264, 11277, 11293, 11294, 11298, 11299, 11303, 11304, 11305, 11310,
   11309, 11330, 11332, 11335, 11337, 11340, 11341, 11344, 11348, 11352,
   11356, 11360, 11364, 11368, 11372, 11376, 11384, 11387, 11397, 11396,
   11411, 11418, 11426, 11434, 11442, 11450, 11458, 11465, 11467, 11469,
   11478, 11482, 11487, 11486, 11492, 11491, 11496, 11505, 11512, 11521,
   11530, 11535, 11537, 11539, 11541, 11543, 11545, 11552, 11560, 11562,
   11570, 11577, 11584, 11594, 11601, 11607, 11616, 11624, 11628, 11632,
   11639, 11646, 11653, 11660, 11667, 11674, 11680, 11687, 11694, 11699,
   11704, 11712, 11714, 11716, 11721, 11722, 11725, 11727, 11731, 11732,
   11736, 11737, 11741, 11742, 11746, 11747, 11751, 11752, 11755, 11757,
   11764, 11775, 11774, 11790, 11789, 11799, 11800, 11804, 11805, 11806,
   11810, 11811, 11812, 11827, 11826, 11839, 11848, 11838, 11850, 11854,
   11855, 11869, 11870, 11875, 11877, 11879, 11881, 11883, 11885, 11887,
   11889, 11891, 11893, 11895, 11897, 11902, 11904, 11906, 11908, 11910,
   11912, 11914, 11919, 11920, 11924, 11925, 11929, 11928, 11938, 11939,
   11943, 11943, 11945, 11946, 11950, 11951, 11956, 11955, 11966, 11970,
   11974, 11987, 11986, 12000, 12001, 12002, 12005, 12006, 12007, 12011,
   12016, 12026, 12038, 12049, 12059, 12069, 12037, 12077, 12078, 12082,
   12083, 12087, 12088, 12096, 12100, 12101, 12102, 12105, 12107, 12111,
   12112, 12116, 12121, 12128, 12133, 12140, 12142, 12146, 12147, 12151,
   12156, 12164, 12165, 12168, 12170, 12178, 12180, 12184, 12185, 12186,
   12190, 12192, 12197, 12198, 12207, 12208, 12212, 12213, 12217, 12230,
   12253, 12265, 12276, 12295, 12303, 12315, 12323, 12338, 12358, 12359,
   12360, 12368, 12369, 12370, 12377, 12383, 12389, 12395, 12401, 12407,
   12436, 12464, 12465, 12466, 12470, 12480, 12490, 12496, 12505, 12520,
   12521, 12525, 12534, 12549, 12553, 12599, 12603, 12620, 12624, 12702,
   12726, 12756, 12757, 12773, 12783, 12787, 12793, 12799, 12809, 12815,
   12824, 12834, 12835, 12863, 12877, 12891, 12906, 12907, 12917, 12918,
   12928, 12929, 12930, 12934, 12950, 12971, 12986, 12987, 12988, 12989,
   12990, 12991, 12992, 12993, 12994, 12995, 12996, 12997, 12998, 12999,
   13000, 13001, 13002, 13003, 13004, 13005, 13006, 13007, 13008, 13009,
   13010, 13011, 13012, 13013, 13014, 13015, 13016, 13017, 13018, 13019,
   13020, 13021, 13022, 13023, 13024, 13025, 13026, 13027, 13028, 13029,
   13030, 13031, 13032, 13033, 13034, 13035, 13036, 13037, 13038, 13039,
   13040, 13041, 13042, 13043, 13044, 13054, 13055, 13056, 13057, 13058,
   13059, 13060, 13061, 13062, 13063, 13064, 13065, 13066, 13067, 13068,
   13069, 13070, 13071, 13072, 13073, 13074, 13075, 13076, 13077, 13078,
   13079, 13080, 13081, 13082, 13083, 13084, 13085, 13086, 13087, 13088,
   13089, 13090, 13091, 13092, 13093, 13094, 13095, 13096, 13097, 13098,
   13099, 13100, 13101, 13102, 13103, 13104, 13105, 13106, 13107, 13108,
   13109, 13110, 13111, 13112, 13113, 13114, 13115, 13116, 13117, 13118,
   13119, 13120, 13121, 13122, 13123, 13124, 13125, 13126, 13127, 13128,
   13129, 13130, 13131, 13132, 13133, 13134, 13135, 13136, 13137, 13138,
   13139, 13140, 13141, 13142, 13143, 13144, 13145, 13146, 13147, 13148,
   13149, 13150, 13151, 13152, 13153, 13154, 13155, 13156, 13157, 13158,
   13159, 13160, 13161, 13162, 13163, 13164, 13165, 13166, 13167, 13168,
   13169, 13170, 13171, 13172, 13173, 13174, 13175, 13176, 13177, 13178,
   13179, 13180, 13181, 13182, 13183, 13184, 13185, 13186, 13187, 13188,
   13189, 13190, 13191, 13192, 13193, 13194, 13195, 13196, 13197, 13198,
   13199, 13200, 13201, 13202, 13203, 13204, 13205, 13206, 13207, 13208,
   13209, 13210, 13211, 13212, 13213, 13214, 13215, 13216, 13217, 13218,
   13219, 13220, 13221, 13222, 13223, 13224, 13225, 13226, 13227, 13228,
   13229, 13230, 13231, 13232, 13233, 13234, 13235, 13236, 13237, 13238,
   13239, 13240, 13241, 13242, 13243, 13244, 13245, 13246, 13247, 13248,
   13249, 13250, 13251, 13252, 13253, 13254, 13255, 13256, 13257, 13258,
   13259, 13260, 13261, 13262, 13263, 13264, 13265, 13266, 13267, 13268,
   13269, 13270, 13271, 13272, 13273, 13274, 13275, 13276, 13277, 13278,
   13279, 13280, 13281, 13282, 13283, 13284, 13285, 13286, 13287, 13288,
   13289, 13290, 13291, 13292, 13293, 13294, 13295, 13296, 13297, 13298,
   13299, 13300, 13301, 13302, 13303, 13304, 13305, 13306, 13307, 13308,
   13309, 13310, 13311, 13312, 13313, 13314, 13315, 13316, 13317, 13318,
   13319, 13320, 13321, 13322, 13323, 13324, 13325, 13326, 13327, 13328,
   13329, 13330, 13331, 13332, 13333, 13334, 13335, 13336, 13337, 13338,
   13339, 13340, 13341, 13342, 13343, 13344, 13345, 13346, 13353, 13352,
   13367, 13368, 13372, 13373, 13377, 13377, 13457, 13458, 13459, 13460,
   13464, 13465, 13469, 13470, 13471, 13472, 13476, 13477, 13478, 13479,
   13483, 13484, 13488, 13529, 13547, 13558, 13570, 13583, 13598, 13617,
   13643, 13656, 13682, 13725, 13739, 13740, 13741, 13742, 13746, 13747,
   13756, 13768, 13769, 13770, 13776, 13782, 13794, 13793, 13809, 13810,
   13814, 13815, 13819, 13820, 13824, 13839, 13840, 13841, 13846, 13847,
   13852, 13851, 13871, 13883, 13896, 13895, 13929, 13930, 13934, 13935,
   13939, 13940, 13941, 13942, 13944, 13943, 13956, 13957, 13958, 13959,
   13960, 13966, 13971, 13977, 13988, 13999, 14003, 14013, 14018, 14025,
   14037, 14049, 14058, 14060, 14064, 14065, 14072, 14074, 14078, 14079,
   14084, 14083, 14087, 14086, 14090, 14089, 14093, 14092, 14095, 14096,
   14097, 14098, 14099, 14100, 14101, 14102, 14103, 14104, 14105, 14106,
   14107, 14108, 14109, 14110, 14111, 14112, 14113, 14114, 14115, 14116,
   14117, 14118, 14119, 14120, 14124, 14125, 14129, 14130, 14134, 14144,
   14154, 14167, 14182, 14195, 14208, 14220, 14225, 14233, 14238, 14245,
   14245, 14246, 14246, 14249, 14276, 14281, 14287, 14293, 14299, 14303,
   14307, 14308, 14312, 14339, 14341, 14345, 14349, 14353, 14360, 14361,
   14365, 14366, 14370, 14371, 14375, 14376, 14382, 14388, 14394, 14404,
   14403, 14413, 14414, 14419, 14420, 14421, 14426, 14427, 14428, 14432,
   14433, 14437, 14449, 14458, 14468, 14477, 14491, 14492, 14497, 14496,
   14512, 14513, 14514, 14518, 14519, 14523, 14523, 14545, 14546, 14550,
   14551, 14552, 14556, 14560, 14567, 14570, 14568, 14584, 14591, 14612,
   14636, 14638, 14642, 14643, 14647, 14648, 14656, 14657, 14658, 14659,
   14665, 14671, 14681, 14683, 14685, 14690, 14691, 14692, 14693, 14694,
   14698, 14699, 14700, 14701, 14702, 14703, 14713, 14714, 14719, 14732,
   14745, 14747, 14749, 14754, 14759, 14761, 14763, 14769, 14770, 14772,
   14778, 14777, 14794, 14795, 14799, 14804, 14812, 14812, 14836, 14837,
   14842, 14843, 14845, 14847, 14865, 14871, 14876, 14858, 14937, 14954,
   14978, 15009, 15013, 15022, 15045, 14974, 15108, 15132, 15141, 15148,
   15107, 15168, 15172, 15176, 15180, 15184, 15188, 15195, 15202, 15209,
   15219, 15220, 15224, 15225, 15226, 15230, 15231, 15236, 15238, 15237,
   15243, 15244, 15248, 15255, 15265, 15271, 15282
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM", "ANALYZE_SYM",
  "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASCII_SYM",
  "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BETWEEN_SYM", "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM",
  "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM",
  "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY", "BYTE_SYM",
  "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET",
  "CHAR_SYM", "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CREATE_SYM", "COLUMN_DELETE_SYM",
  "COLUMN_EXISTS_SYM", "COLUMN_GET_SYM", "COLUMN_LIST_SYM", "COLUMN_SYM",
  "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM", "DIRECTORY_SYM",
  "DISABLE_SYM", "DISCARD", "DISK_SYM", "DISTINCT", "DIV_SYM",
  "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM",
  "DYNAMIC_SYM", "EACH_SYM", "ELSE", "ELSEIF_SYM", "ENABLE_SYM",
  "ENCLOSED", "END", "ENDS_SYM", "END_OF_INPUT", "ENGINES_SYM",
  "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERROR_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EVENT_SYM", "EVERY_SYM",
  "EXAMINED_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM", "EXPANSION_SYM",
  "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM",
  "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM", "FIRST_SYM",
  "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM",
  "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "GE", "GENERAL", "GENERATED_SYM", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING",
  "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM",
  "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT",
  "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM",
  "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LAST_VALUE", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT",
  "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM",
  "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEG", "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM",
  "NOT2_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM",
  "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM",
  "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PAGE_CHECKSUM_SYM", "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM",
  "PARTIAL", "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM",
  "PASSWORD", "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM",
  "REVOKE", "RIGHT", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM", "SAVEPOINT_SYM",
  "SCHEDULE_SYM", "SCHEMA_NAME_SYM", "SECOND_MICROSECOND_SYM",
  "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM",
  "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM",
  "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM",
  "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNAL_SYM",
  "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT", "SNAPSHOT_SYM",
  "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM",
  "SUBJECT_SYM", "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING",
  "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM",
  "SYSDATE", "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY",
  "TABLE_STATS_SYM", "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "THAN_SYM", "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF",
  "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE", "WHILE_SYM",
  "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM", "WRAPPER_SYM",
  "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR", "YEAR_MONTH_SYM",
  "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION", "'|'", "'&'", "'-'", "'+'",
  "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'",
  "'}'", "';'", "'@'", "'.'", "':'", "$accept", "query", "$@1",
  "opt_end_of_input", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "$@2",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "$@3",
  "change", "$@4", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "master_file_def", "create", "$@5", "$@6", "$@7",
  "$@8", "$@9", "$@10", "server_def", "server_options_list",
  "server_option", "event_tail", "$@11", "ev_schedule_time", "$@12",
  "opt_ev_status", "ev_starts", "ev_ends", "opt_ev_on_completion",
  "ev_on_completion", "opt_ev_comment", "ev_sql_stmt", "$@13",
  "ev_sql_stmt_inner", "clear_privileges", "sp_name", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "$@14",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "$@15", "$@16",
  "sp_cursor_stmt", "$@17", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "sqlstate", "opt_value", "sp_hcond",
  "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "sp_decl_idents", "sp_opt_default", "sp_proc_stmt",
  "sp_proc_stmt_if", "$@18", "sp_proc_stmt_statement", "$@19",
  "sp_proc_stmt_return", "$@20", "sp_proc_stmt_unlabeled", "$@21",
  "sp_proc_stmt_leave", "sp_proc_stmt_iterate", "sp_proc_stmt_open",
  "sp_proc_stmt_fetch", "$@22", "sp_proc_stmt_close", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "$@23", "$@24", "$@25", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "$@26", "$@27",
  "searched_case_stmt", "$@28", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "$@29", "$@30",
  "searched_when_clause", "$@31", "$@32", "else_clause_opt",
  "sp_labeled_control", "$@33", "sp_opt_label", "sp_labeled_block", "$@34",
  "sp_unlabeled_block", "$@35", "sp_block_content", "$@36",
  "sp_unlabeled_control", "$@37", "$@38", "$@39", "trg_action_time",
  "trg_event", "change_tablespace_access", "change_tablespace_info",
  "tablespace_info", "opt_logfile_group_name", "alter_tablespace_info",
  "logfile_group_info", "alter_logfile_group_info", "add_log_file",
  "change_ts_option_list", "$@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "$@41", "$@42", "create3", "$@43", "$@44",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@45",
  "have_partitioning", "partition_entry", "$@46", "partition",
  "part_type_def", "$@47", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@48",
  "$@49", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@50", "part_name", "opt_part_values", "$@51", "$@52", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@53", "$@54",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@55", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@56", "$@57", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@58", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "$@59", "$@60", "$@61", "$@62", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "$@63",
  "field_def", "@64", "opt_generated_always", "vcol_opt_specifier",
  "vcol_opt_attribute", "vcol_opt_attribute_list", "vcol_attribute",
  "parse_vcol_expr", "virtual_column_func", "type", "$@65", "$@66",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "hex_num_or_string",
  "charset", "charset_name", "charset_name_or_default",
  "opt_load_data_charset", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "ascii", "unicode",
  "opt_binary", "opt_bin_mod", "opt_primary", "references", "opt_ref_list",
  "ref_list", "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@67", "$@68", "$@69", "$@70", "$@71", "$@72",
  "$@73", "ev_alter_on_schedule_completion", "opt_ev_rename_to",
  "opt_ev_sql_stmt", "ident_or_empty", "alter_commands", "$@74", "$@75",
  "$@76", "remove_partitioning", "all_or_alt_part_name_list",
  "add_partition_rule", "$@77", "add_part_extra", "reorg_partition_rule",
  "$@78", "reorg_parts_rule", "$@79", "alt_part_name_list",
  "alt_part_name_item", "alter_list", "add_column", "alter_list_item",
  "$@80", "$@81", "$@82", "opt_column", "opt_ignore", "alter_options",
  "$@83", "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@84", "$@85", "start",
  "start_transaction_opts", "slave_thread_opts", "$@86",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@87", "opt_checksum_type", "repair",
  "$@88", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@89", "binlog_base64_event", "check", "$@90",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@91", "opt_no_write_to_binlog", "rename", "$@92", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@93",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@94",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@95", "cache_keys_spec", "$@96",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@97",
  "select_part2", "$@98", "$@99", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_time_precision", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "opt_dyncol_type", "dyncol_type",
  "dyncall_create_element", "dyncall_create_list", "simple_expr",
  "function_call_keyword", "function_call_nonkeyword",
  "function_call_conflict", "geometry_function", "function_call_generic",
  "@100", "fulltext_options", "opt_natural_language_mode",
  "opt_query_expansion", "opt_udf_expr_list", "udf_expr_list", "udf_expr",
  "sum_expr", "$@101", "$@102", "$@103", "variable", "$@104",
  "variable_aux", "opt_distinct", "opt_gconcat_separator",
  "opt_gorder_clause", "$@105", "gorder_list", "in_sum_expr", "$@106",
  "cast_type", "$@107", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@108", "$@109", "$@110", "$@111", "$@112", "$@113", "$@114",
  "normal_join", "table_factor", "$@115", "select_derived_union", "$@116",
  "$@117", "select_init2_derived", "select_part2_derived", "$@118",
  "$@119", "select_derived", "$@120", "select_derived2", "$@121", "$@122",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@123",
  "$@124", "index_hints_list", "opt_index_hints_list", "$@125",
  "opt_key_definition", "$@126", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@127", "having_clause", "$@128", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@129", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@130", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@131",
  "select_var_list", "select_var_ident", "into", "$@132",
  "into_destination", "$@133", "$@134", "do", "$@135", "drop", "$@136",
  "$@137", "$@138", "table_list", "table_name", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "insert", "$@139",
  "$@140", "replace", "$@141", "$@142", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@143", "fields", "insert_values", "$@144", "$@145", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@146", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@147", "update", "$@148", "$@149", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@150", "single_multi", "$@151", "$@152", "$@153", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@154", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@155", "show_param",
  "$@156", "$@157", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@158", "$@159", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@160",
  "flush_options", "$@161", "$@162", "opt_with_read_lock",
  "flush_options_list", "flush_option", "opt_table_list",
  "optional_flush_tables_arguments", "reset", "$@163", "reset_options",
  "reset_option", "$@164", "slave_reset_options", "purge", "$@165",
  "purge_options", "purge_option", "kill", "$@166", "kill_type",
  "kill_option", "kill_expr", "use", "load", "$@167", "$@168", "$@169",
  "$@170", "data_or_xml", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_xml_rows_identified_by",
  "opt_ignore_lines", "lines_or_rows", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "load_data_set_list", "load_data_set_elem", "text_literal",
  "text_string", "param_marker", "signed_literal", "literal",
  "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "$@171", "opt_option", "option_value_list", "option_type_value",
  "$@172", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@173",
  "table_or_tables", "table_or_view", "table_lock_list", "table_lock",
  "lock_option", "unlock", "$@174", "handler", "$@175",
  "handler_read_or_scan", "handler_scan_function", "handler_rkey_function",
  "$@176", "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@177", "$@178", "$@179",
  "$@180", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@181", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@182",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@183",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@184", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@185",
  "view_list_opt", "view_list", "view_select", "$@186", "view_select_aux",
  "view_check_option", "trigger_tail", "$@187", "$@188", "$@189",
  "udf_tail", "sf_tail", "$@190", "$@191", "$@192", "$@193", "$@194",
  "sp_tail", "$@195", "$@196", "$@197", "$@198", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@199", "opt_migrate", "install", "uninstall", "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     124,    38,    45,    43,    42,    47,    37,    94,   126,    40,
      41,    44,    33,   123,   125,    59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   639,   640,   641,   640,   640,   642,   642,   643,   643,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   644,   644,   644,   644,   644,   644,   644,
     644,   644,   644,   645,   646,   646,   647,   648,   648,   650,
     649,   651,   651,   652,   652,   653,   655,   654,   657,   656,
     658,   658,   659,   659,   659,   659,   659,   659,   659,   659,
     659,   659,   659,   659,   659,   659,   659,   660,   660,   660,
     661,   662,   662,   662,   662,   664,   663,   665,   663,   666,
     663,   667,   663,   668,   663,   669,   663,   663,   663,   663,
     663,   670,   671,   671,   672,   672,   672,   672,   672,   672,
     672,   674,   673,   676,   675,   675,   677,   677,   677,   677,
     678,   678,   679,   679,   680,   680,   681,   681,   682,   682,
     684,   683,   685,   685,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   685,   685,   686,   687,   687,   688,   688,
     689,   689,   690,   690,   690,   690,   690,   690,   690,   691,
     691,   691,   692,   692,   694,   693,   695,   695,   696,   696,
     697,   697,   698,   698,   699,   699,   700,   701,   702,   702,
     703,   703,   704,   705,   705,   705,   705,   706,   706,   707,
     707,   708,   708,   710,   709,   709,   711,   709,   709,   713,
     712,   714,   714,   715,   715,   716,   717,   717,   718,   719,
     719,   720,   720,   720,   720,   720,   721,   722,   722,   723,
     723,   724,   724,   725,   725,   726,   726,   726,   727,   727,
     727,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     728,   729,   729,   730,   730,   731,   731,   731,   731,   731,
     731,   731,   731,   731,   731,   731,   731,   731,   733,   732,
     735,   734,   737,   736,   739,   738,   740,   741,   742,   744,
     743,   745,   746,   746,   746,   747,   747,   749,   750,   751,
     748,   752,   752,   752,   753,   753,   755,   756,   754,   758,
     757,   759,   759,   760,   760,   762,   763,   761,   765,   766,
     764,   767,   767,   769,   768,   770,   770,   772,   771,   774,
     773,   776,   775,   777,   778,   779,   777,   780,   777,   781,
     781,   782,   782,   782,   783,   784,   785,   786,   786,   787,
     787,   788,   789,   790,   790,   792,   791,   793,   793,   793,
     794,   794,   794,   795,   796,   796,   796,   797,   797,   797,
     797,   797,   797,   797,   797,   798,   799,   799,   799,   800,
     800,   800,   800,   800,   801,   802,   802,   802,   803,   803,
     803,   803,   803,   803,   803,   804,   805,   805,   805,   806,
     806,   806,   807,   808,   809,   810,   811,   812,   812,   812,
     813,   814,   815,   816,   817,   818,   819,   820,   821,   822,
     822,   823,   823,   824,   824,   825,   825,   825,   825,   827,
     826,   828,   826,   829,   830,   829,   831,   829,   832,   833,
     833,   835,   834,   836,   838,   837,   839,   840,   841,   840,
     840,   840,   840,   840,   842,   842,   843,   843,   844,   844,
     845,   845,   846,   847,   848,   849,   850,   850,   851,   852,
     851,   853,   851,   854,   854,   855,   856,   857,   857,   858,
     858,   859,   859,   861,   860,   862,   863,   864,   863,   865,
     863,   866,   866,   867,   867,   868,   868,   870,   871,   869,
     872,   872,   873,   873,   874,   874,   875,   875,   877,   876,
     878,   879,   879,   880,   880,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   883,   884,   882,   885,   885,   886,
     886,   887,   887,   888,   888,   889,   889,   890,   890,   891,
     892,   892,   893,   893,   894,   894,   895,   895,   895,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   897,   896,   896,   896,   896,   896,   896,
     896,   896,   896,   896,   896,   896,   896,   896,   896,   896,
     898,   899,   900,   901,   902,   902,   902,   902,   902,   902,
     902,   903,   903,   903,   904,   904,   905,   905,   905,   905,
     906,   907,   907,   908,   908,   909,   909,   911,   910,   912,
     910,   913,   910,   914,   910,   910,   910,   915,   915,   916,
     917,   917,   918,   920,   919,   921,   922,   921,   923,   923,
     924,   924,   924,   925,   925,   926,   926,   927,   927,   927,
     928,   929,   930,   930,   930,   930,   930,   930,   930,   930,
     930,   930,   930,   930,   930,   930,   930,   930,   930,   930,
     930,   930,   930,   930,   930,   930,   930,   930,   930,   930,
     930,   930,   930,   930,   930,   930,   930,   931,   930,   932,
     930,   930,   930,   933,   933,   933,   933,   933,   933,   933,
     933,   934,   935,   935,   936,   936,   937,   937,   937,   937,
     937,   938,   938,   938,   938,   938,   939,   939,   939,   940,
     940,   940,   941,   942,   942,   943,   943,   944,   944,   944,
     945,   945,   945,   945,   946,   946,   947,   947,   948,   948,
     949,   949,   950,   950,   950,   950,   950,   950,   950,   950,
     950,   950,   950,   950,   950,   950,   950,   951,   952,   952,
     953,   953,   954,   954,   955,   955,   956,   956,   957,   957,
     958,   958,   959,   959,   960,   961,   961,   962,   962,   963,
     963,   964,   964,   964,   965,   965,   965,   966,   966,   966,
     966,   966,   966,   966,   967,   967,   968,   968,   969,   970,
     970,   971,   971,   972,   972,   972,   972,   973,   973,   973,
     973,   973,   974,   974,   974,   974,   974,   975,   976,   976,
     977,   977,   978,   978,   979,   979,   979,   980,   980,   981,
     982,   983,   984,   984,   985,   985,   986,   986,   987,   987,
     988,   988,   989,   989,   990,   990,   991,   991,   992,   992,
     992,   992,   992,   992,   993,   993,   994,   995,   995,   996,
     996,   996,   997,   997,   998,   998,   999,   999,  1000,  1000,
    1001,  1001,  1003,  1002,  1004,  1002,  1002,  1005,  1002,  1006,
    1002,  1007,  1002,  1008,  1002,  1009,  1002,  1002,  1002,  1002,
    1002,  1002,  1010,  1010,  1010,  1010,  1011,  1011,  1012,  1012,
    1013,  1013,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1015,  1014,  1014,  1016,  1014,  1017,  1014,  1014,
    1014,  1014,  1018,  1019,  1019,  1021,  1020,  1022,  1022,  1022,
    1024,  1023,  1025,  1026,  1025,  1027,  1027,  1028,  1029,  1029,
    1030,  1031,  1031,  1031,  1032,  1031,  1033,  1034,  1031,  1031,
    1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,  1031,
    1031,  1031,  1035,  1035,  1036,  1036,  1038,  1037,  1039,  1039,
    1040,  1040,  1041,  1041,  1042,  1042,  1042,  1043,  1043,  1043,
    1044,  1044,  1044,  1044,  1046,  1045,  1045,  1047,  1045,  1045,
    1048,  1049,  1049,  1051,  1050,  1052,  1052,  1053,  1053,  1053,
    1054,  1054,  1055,  1055,  1057,  1056,  1058,  1058,  1058,  1060,
    1059,  1061,  1061,  1062,  1062,  1063,  1063,  1063,  1063,  1065,
    1064,  1066,  1068,  1067,  1069,  1069,  1070,  1070,  1071,  1071,
    1071,  1071,  1071,  1071,  1073,  1072,  1074,  1074,  1074,  1076,
    1075,  1075,  1077,  1077,  1078,  1078,  1079,  1081,  1080,  1082,
    1082,  1083,  1083,  1084,  1085,  1086,  1086,  1088,  1087,  1089,
    1089,  1090,  1090,  1091,  1092,  1094,  1093,  1096,  1095,  1097,
    1097,  1098,  1098,  1099,  1100,  1100,  1101,  1101,  1102,  1102,
    1104,  1103,  1106,  1107,  1105,  1108,  1108,  1108,  1108,  1108,
    1109,  1109,  1110,  1110,  1111,  1111,  1112,  1112,  1112,  1113,
    1113,  1113,  1114,  1114,  1114,  1115,  1115,  1116,  1117,  1118,
    1118,  1118,  1118,  1118,  1119,  1119,  1119,  1120,  1120,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,
    1122,  1122,  1122,  1122,  1122,  1122,  1123,  1123,  1123,  1123,
    1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,  1123,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1124,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1125,  1125,  1126,  1126,  1127,
    1127,  1128,  1128,  1129,  1129,  1129,  1129,  1129,  1129,  1130,
    1130,  1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1132,
    1132,  1132,  1132,  1132,  1133,  1134,  1134,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1137,  1137,  1137,  1137,  1137,  1137,
    1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,
    1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,  1137,
    1137,  1137,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,
    1139,  1139,  1139,  1139,  1139,  1139,  1139,  1139,  1141,  1140,
    1140,  1142,  1142,  1143,  1143,  1144,  1144,  1145,  1145,  1146,
    1146,  1147,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1149,
    1150,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1151,  1148,  1153,  1152,  1154,  1154,  1154,  1155,
    1155,  1156,  1156,  1157,  1158,  1157,  1159,  1159,  1161,  1160,
    1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,
    1162,  1162,  1163,  1162,  1164,  1164,  1165,  1165,  1166,  1166,
    1167,  1167,  1168,  1168,  1169,  1169,  1170,  1170,  1171,  1171,
    1172,  1173,  1173,  1174,  1174,  1175,  1175,  1176,  1175,  1177,
    1175,  1178,  1175,  1175,  1179,  1175,  1180,  1175,  1175,  1181,
    1175,  1182,  1175,  1175,  1183,  1183,  1183,  1185,  1184,  1184,
    1184,  1186,  1187,  1188,  1186,  1189,  1191,  1192,  1190,  1194,
    1193,  1196,  1197,  1195,  1198,  1199,  1200,  1200,  1201,  1201,
    1201,  1201,  1202,  1202,  1204,  1203,  1205,  1203,  1206,  1206,
    1207,  1208,  1207,  1210,  1209,  1211,  1211,  1212,  1212,  1213,
    1213,  1214,  1214,  1215,  1215,  1215,  1215,  1215,  1215,  1215,
    1215,  1215,  1215,  1215,  1215,  1216,  1216,  1216,  1216,  1216,
    1216,  1216,  1216,  1216,  1217,  1217,  1217,  1217,  1218,  1218,
    1218,  1219,  1219,  1220,  1220,  1221,  1222,  1221,  1223,  1224,
    1223,  1225,  1225,  1226,  1226,  1227,  1227,  1228,  1228,  1228,
    1229,  1230,  1230,  1231,  1232,  1232,  1234,  1233,  1235,  1235,
    1236,  1236,  1236,  1237,  1237,  1238,  1238,  1239,  1239,  1239,
    1240,  1240,  1240,  1241,  1241,  1241,  1241,  1241,  1242,  1243,
    1243,  1243,  1243,  1244,  1244,  1244,  1245,  1245,  1245,  1245,
    1245,  1245,  1246,  1246,  1246,  1246,  1246,  1247,  1247,  1247,
    1247,  1247,  1248,  1248,  1248,  1248,  1248,  1249,  1250,  1250,
    1251,  1251,  1252,  1253,  1252,  1254,  1254,  1255,  1255,  1256,
    1258,  1257,  1259,  1259,  1260,  1260,  1262,  1261,  1264,  1265,
    1263,  1263,  1263,  1267,  1266,  1269,  1268,  1270,  1268,  1268,
    1268,  1268,  1268,  1268,  1271,  1268,  1268,  1268,  1268,  1268,
    1268,  1272,  1272,  1273,  1274,  1274,  1275,  1276,  1276,  1277,
    1277,  1279,  1280,  1278,  1282,  1283,  1281,  1284,  1284,  1284,
    1284,  1285,  1285,  1286,  1286,  1287,  1288,  1288,  1288,  1289,
    1288,  1290,  1290,  1291,  1291,  1292,  1291,  1293,  1291,  1294,
    1294,  1295,  1295,  1296,  1297,  1297,  1298,  1298,  1300,  1299,
    1301,  1301,  1302,  1302,  1303,  1303,  1304,  1305,  1304,  1307,
    1308,  1306,  1309,  1309,  1310,  1311,  1311,  1312,  1313,  1313,
    1315,  1314,  1317,  1316,  1318,  1316,  1319,  1316,  1320,  1320,
    1321,  1321,  1322,  1322,  1323,  1323,  1324,  1324,  1324,  1326,
    1325,  1327,  1327,  1328,  1328,  1329,  1329,  1330,  1330,  1330,
    1330,  1330,  1330,  1330,  1330,  1330,  1331,  1331,  1333,  1332,
    1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,
    1334,  1334,  1335,  1334,  1336,  1334,  1334,  1334,  1334,  1334,
    1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,
    1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,
    1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,  1334,
    1334,  1337,  1337,  1337,  1338,  1338,  1339,  1339,  1340,  1340,
    1341,  1341,  1342,  1342,  1343,  1343,  1344,  1344,  1345,  1345,
    1345,  1347,  1346,  1348,  1346,  1349,  1349,  1350,  1350,  1350,
    1351,  1351,  1351,  1353,  1352,  1355,  1356,  1354,  1354,  1357,
    1357,  1358,  1358,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
    1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,  1359,
    1359,  1359,  1360,  1360,  1361,  1361,  1363,  1362,  1364,  1364,
    1366,  1365,  1365,  1365,  1367,  1367,  1369,  1368,  1370,  1371,
    1371,  1373,  1372,  1374,  1374,  1374,  1375,  1375,  1375,  1376,
    1376,  1377,  1379,  1380,  1381,  1382,  1378,  1383,  1383,  1384,
    1384,  1385,  1385,  1385,  1386,  1386,  1386,  1387,  1387,  1388,
    1388,  1389,  1389,  1389,  1389,  1390,  1390,  1391,  1391,  1392,
    1392,  1393,  1393,  1394,  1394,  1395,  1395,  1396,  1396,  1396,
    1397,  1397,  1398,  1398,  1399,  1399,  1400,  1400,  1401,  1402,
    1402,  1402,  1402,  1403,  1403,  1403,  1403,  1404,  1405,  1405,
    1405,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,
    1406,  1406,  1406,  1406,  1407,  1407,  1407,  1407,  1407,  1408,
    1408,  1409,  1409,  1410,  1411,  1411,  1412,  1412,  1413,  1413,
    1413,  1414,  1414,  1414,  1414,  1415,  1415,  1415,  1416,  1416,
    1417,  1418,  1418,  1419,  1420,  1421,  1422,  1422,  1423,  1423,
    1424,  1424,  1424,  1425,  1425,  1425,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,  1426,
    1426,  1426,  1426,  1426,  1426,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,
    1427,  1427,  1427,  1427,  1427,  1427,  1427,  1427,  1429,  1428,
    1430,  1430,  1431,  1431,  1433,  1432,  1434,  1434,  1434,  1434,
    1435,  1435,  1436,  1436,  1436,  1436,  1437,  1437,  1437,  1437,
    1438,  1438,  1439,  1439,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1441,  1441,  1441,  1442,  1442,  1442,  1442,  1443,  1443,
    1443,  1444,  1444,  1444,  1444,  1444,  1446,  1445,  1447,  1447,
    1448,  1448,  1449,  1449,  1450,  1451,  1451,  1451,  1451,  1451,
    1453,  1452,  1454,  1454,  1455,  1454,  1456,  1456,  1457,  1457,
    1458,  1458,  1458,  1458,  1459,  1458,  1460,  1460,  1460,  1460,
    1460,  1461,  1462,  1462,  1462,  1462,  1462,  1463,  1464,  1464,
    1464,  1464,  1465,  1465,  1466,  1466,  1467,  1467,  1468,  1468,
    1470,  1469,  1471,  1469,  1472,  1469,  1473,  1469,  1469,  1469,
    1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,
    1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,  1469,
    1469,  1469,  1469,  1469,  1474,  1474,  1475,  1475,  1476,  1476,
    1476,  1477,  1477,  1477,  1477,  1478,  1478,  1479,  1479,  1480,
    1480,  1481,  1481,  1482,  1482,  1482,  1482,  1482,  1483,  1483,
    1484,  1484,  1485,  1486,  1486,  1486,  1486,  1486,  1487,  1487,
    1488,  1488,  1489,  1489,  1490,  1490,  1490,  1490,  1490,  1492,
    1491,  1493,  1493,  1494,  1494,  1494,  1495,  1495,  1495,  1496,
    1496,  1497,  1498,  1498,  1499,  1500,  1501,  1501,  1503,  1502,
    1504,  1504,  1504,  1505,  1505,  1507,  1506,  1508,  1508,  1509,
    1509,  1509,  1510,  1510,  1511,  1512,  1511,  1513,  1514,  1515,
    1516,  1516,  1517,  1517,  1518,  1518,  1518,  1518,  1518,  1518,
    1518,  1518,  1519,  1519,  1519,  1520,  1520,  1520,  1520,  1520,
    1521,  1521,  1521,  1521,  1521,  1521,  1522,  1522,  1523,  1524,
    1525,  1525,  1525,  1526,  1527,  1527,  1527,  1528,  1528,  1528,
    1530,  1529,  1531,  1531,  1532,  1532,  1534,  1533,  1535,  1535,
    1536,  1536,  1536,  1536,  1538,  1539,  1540,  1537,  1541,  1541,
    1543,  1544,  1545,  1546,  1547,  1542,  1549,  1550,  1551,  1552,
    1548,  1553,  1553,  1553,  1553,  1553,  1553,  1554,  1554,  1554,
    1555,  1555,  1556,  1556,  1556,  1557,  1557,  1558,  1559,  1558,
    1560,  1560,  1561,  1561,  1562,  1562,  1563
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     0,     1,     3,
       1,     3,     3,     3,     3,     0,     7,     0,    12,     0,
      12,     0,    12,     0,     6,     0,     3,     4,     4,     3,
       2,    10,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     0,    13,     0,     6,     2,     0,     1,     3,     1,
       0,     2,     0,     2,     0,     1,     3,     4,     0,     2,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     1,     0,     2,
       0,     2,     2,     2,     2,     2,     3,     3,     1,     1,
       1,     2,     3,     3,     0,     4,     0,     3,     0,     1,
       3,     1,     0,     1,     3,     1,     0,     3,     0,     1,
       3,     1,     4,     0,     1,     1,     1,     0,     3,     2,
       3,     0,     3,     0,     5,     5,     0,     7,     5,     0,
       2,     1,     1,     1,     3,     1,     1,     1,     3,     0,
       1,     1,     1,     1,     2,     1,     3,     1,     1,     0,
       1,     0,     2,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     5,
       0,     2,     0,     3,     0,     2,     2,     2,     2,     0,
       6,     2,     0,     2,     1,     1,     3,     0,     0,     0,
       7,     0,     2,     2,     1,     1,     0,     0,     8,     0,
       6,     1,     2,     1,     2,     0,     0,     6,     0,     0,
       6,     0,     2,     0,     5,     0,     1,     0,     5,     0,
       2,     0,     5,     4,     0,     0,     8,     0,     7,     1,
       1,     1,     1,     1,     2,     4,     5,     0,     4,     4,
       4,     3,     3,     2,     2,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     3,     1,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     0,
       1,     1,     1,     1,     1,     2,     3,     2,     4,     0,
       6,     0,     5,     0,     0,     5,     0,     7,     1,     0,
       1,     0,     4,     0,     0,     3,     5,     6,     0,     4,
       2,     2,     2,     2,     0,     1,     0,     3,     0,     1,
       1,     3,     1,     4,     5,     5,     0,     2,     0,     0,
       7,     0,    10,     1,     3,     1,     1,     0,     2,     0,
       3,     1,     3,     0,     6,     1,     0,     0,     5,     0,
       4,     1,     1,     1,     3,     1,     3,     0,     0,     5,
       1,     3,     1,     1,     0,     3,     1,     3,     0,     4,
       1,     0,     1,     2,     1,     3,     4,     3,     3,     3,
       3,     4,     4,     3,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     0,     6,     1,     1,     3,     4,     4,
       2,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     2,     2,     0,     8,     0,
       9,     0,     9,     0,     9,     8,     2,     0,     1,     4,
       0,     1,     2,     0,     3,     2,     0,     9,     0,     2,
       0,     1,     1,     0,     1,     2,     1,     1,     2,     2,
       4,     3,     3,     3,     3,     1,     2,     1,     1,     3,
       2,     3,     2,     2,     1,     3,     3,     2,     3,     1,
       2,     2,     2,     1,     2,     1,     1,     1,     2,     3,
       2,     3,     2,     2,     3,     3,     3,     0,     6,     0,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     2,     1,     2,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     5,     0,     1,     2,     1,     1,     1,     1,
       3,     3,     3,     3,     0,     1,     0,     1,     0,     1,
       2,     1,     1,     2,     2,     4,     1,     3,     2,     1,
       2,     2,     2,     3,     3,     3,     3,     2,     2,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     0,
       1,     1,     2,     2,     1,     2,     2,     0,     1,     1,
       1,     3,     1,     3,     0,     1,     0,     1,     5,     0,
       3,     3,     1,     0,     2,     2,     2,     0,     3,     3,
       6,     6,     1,     1,     2,     2,     2,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     0,     1,     1,
       1,     0,     1,     2,     0,     1,     0,     1,     0,     1,
       1,     2,     1,     2,     1,     2,     2,     2,     3,     2,
       3,     3,     3,     3,     1,     1,     1,     1,     3,     1,
       1,     1,     4,     2,     1,     4,     0,     1,     0,     2,
       1,     3,     0,     6,     0,     5,     7,     0,     5,     0,
       5,     0,     5,     0,     4,     0,    10,     3,     4,     3,
       3,     7,     0,     3,     1,     4,     0,     3,     0,     2,
       0,     1,     0,     2,     2,     2,     2,     1,     1,     1,
       3,     4,     0,     6,     4,     0,     5,     0,     6,     4,
       3,     1,     2,     1,     1,     0,     5,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     7,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     2,     0,     1,
       2,     1,     1,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     5,     3,     0,     5,     3,
       3,     0,     3,     0,     2,     1,     3,     0,     1,     1,
       0,     2,     1,     3,     0,     5,     0,     1,     1,     0,
       6,     0,     1,     1,     2,     1,     1,     1,     2,     0,
       5,     2,     0,     5,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     0,     5,     0,     1,     1,     0,
       4,     4,     3,     5,     1,     3,     3,     0,     6,     1,
       1,     1,     3,     2,     3,     1,     1,     0,     6,     1,
       1,     1,     3,     3,     4,     0,     6,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     2,     3,
       0,     3,     0,     0,     6,     2,     1,     1,     2,     2,
       8,     4,     0,     1,     2,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     3,     4,     0,     0,     0,
       2,     2,     1,     1,     0,     2,     3,     0,     2,     3,
       3,     3,     2,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     3,     3,     3,     3,     3,     5,     5,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     2,     1,     1,     1,     2,     2,
       1,     1,     2,     2,     4,     1,     3,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     8,     8,
       6,     6,     2,     6,     6,     8,     8,     6,     8,     6,
       2,     8,     8,     2,     2,     2,     6,     6,     6,     4,
       4,     8,     4,     4,     4,     4,     3,     8,     4,     4,
       6,     4,     4,     4,     6,     8,     6,     4,     6,     1,
       6,     4,     4,     4,     4,     4,     6,     4,     0,     5,
       6,     2,     3,     0,     4,     0,     3,     0,     1,     1,
       3,     4,     4,     5,     4,     4,     4,     5,     4,     0,
       0,     7,     4,     5,     4,     5,     4,     4,     4,     4,
       4,     5,     0,     8,     0,     3,     3,     1,     4,     0,
       1,     0,     2,     0,     0,     4,     4,     2,     0,     3,
       2,     3,     2,     1,     1,     2,     1,     2,     1,     2,
       2,     2,     0,     3,     0,     1,     1,     3,     1,     3,
       1,     3,     0,     1,     0,     2,     4,     5,     1,     1,
       1,     1,     4,     1,     3,     3,     3,     0,     6,     0,
       6,     0,     8,     4,     0,     8,     0,    10,     6,     0,
       8,     0,    10,     6,     1,     2,     2,     0,     4,     3,
       5,     2,     0,     0,     7,     1,     0,     0,     6,     0,
       3,     0,     0,     5,     0,     1,     0,     1,     0,     2,
       3,     3,     1,     1,     0,     7,     0,     7,     1,     2,
       0,     0,     2,     0,     2,     0,     1,     1,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     0,     2,     0,     1,     0,     0,     3,     0,     0,
       3,     2,     0,     0,     4,     4,     2,     0,     1,     1,
       3,     3,     1,     2,     0,     1,     0,     4,     4,     2,
       0,     1,     1,     0,     1,     0,     1,     2,     5,     4,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     0,
       2,     3,     4,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     0,     6,     0,     1,     3,     1,     3,
       0,     2,     3,     1,     2,     1,     0,     3,     0,     0,
       7,     2,     1,     0,     3,     0,     7,     0,     6,     4,
       6,     4,     4,     4,     0,     6,     4,     4,     5,     6,
       4,     1,     3,     1,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     6,     0,     5,     0,     6,     1,     3,
       2,     4,     0,     2,     0,     2,     1,     1,     1,     0,
       4,     0,     1,     0,     1,     1,     3,     1,     1,     2,
       2,     2,     1,     1,     1,     1,     0,     3,     0,     3,
       2,     4,     4,     3,     4,     4,     1,     3,     3,     6,
       2,     2,     0,     6,     0,     6,     5,     2,     1,     1,
       1,     5,     5,     2,     2,     1,     4,     3,     2,     3,
       2,     2,     1,     3,     4,     3,     3,     2,     2,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     0,     1,     0,     2,
       0,     1,     1,     1,     0,     2,     0,     2,     0,     2,
       2,     0,     4,     0,     4,     1,     1,     0,     1,     1,
       0,     1,     1,     0,     4,     0,     0,     5,     1,     0,
       4,     3,     1,     2,     2,     2,     2,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     0,     3,     0,     3,     3,     1,
       0,     3,     1,     2,     0,     1,     0,     3,     3,     2,
       2,     0,     5,     0,     1,     1,     0,     1,     1,     1,
       2,     2,     0,     0,     0,     0,    21,     1,     1,     0,
       1,     0,     1,     1,     0,     1,     1,     0,     2,     2,
       1,     3,     4,     3,     3,     0,     2,     2,     1,     3,
       3,     0,     4,     0,     3,     1,     1,     0,     3,     2,
       3,     1,     1,     2,     0,     2,     3,     1,     5,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     5,     1,     1,     1,     1,     1,     3,     4,
       5,     1,     5,     3,     2,     1,     3,     2,     2,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     1,     1,     3,     3,     1,     1,     2,     2,     2,
       0,     3,     4,     3,     0,     7,     1,     2,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     1,     1,     1,
       1,     3,     6,     6,     6,     7,     5,     3,     8,     8,
       8,     6,     0,     1,     1,     2,     0,     1,     1,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     2,     0,     1,     3,     1,     2,     2,
       2,     1,     3,     3,     1,     1,     3,     1,     3,     1,
       1,     1,     1,     4,     5,     4,     6,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       0,     3,     2,     1,     2,     2,     2,     2,     2,     0,
       3,     0,     1,     0,     3,     2,     0,     1,     2,     0,
       1,     4,     4,     5,     2,     3,     0,     1,     0,     4,
       0,     1,     1,     0,     1,     0,     2,     2,     1,     0,
       1,     1,     2,     3,     2,     0,     6,     3,     0,     0,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       1,     2,     1,     2,     3,     3,     3,     0,     3,     3,
       0,     7,     0,     3,     1,     3,     0,     3,     2,     4,
       0,     3,     4,     4,     0,     0,     0,    16,     8,     7,
       0,     0,     0,     0,     0,    15,     0,     0,     0,     0,
      12,     4,     4,     3,     4,     3,     2,     1,     3,     5,
       1,     1,     0,     1,     1,     0,     2,     0,     0,     3,
       0,     2,     5,     3,     3,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   956,  1026,  2499,     0,     0,     0,     0,     0,     0,
    2501,   115,    64,  1670,  1785,  1786,  1583,  1609,     2,     0,
    1026,   165,     0,    76,  1611,     0,  1841,     0,     0,  1026,
       0,   444,     0,  1836,     0,     0,  1026,  1614,  1826,   239,
     165,  2501,     0,  1072,  2320,  1708,     0,     0,     0,     0,
    1691,     0,  2380,  1659,     0,     0,  2636,     0,     0,     3,
       8,    19,     0,    40,    24,    28,    14,    18,    13,    53,
      47,    38,    37,    10,    55,    56,    16,    44,    11,    12,
      15,    36,    43,    32,    39,    51,  1063,    22,    23,    29,
      45,    60,    20,    57,    54,    21,  1787,    25,    46,    41,
      33,    61,    34,    52,    35,    59,    27,    48,    26,     9,
      17,    49,    50,    42,    62,    30,    58,    31,     0,   890,
       0,     0,     0,     0,     0,     0,     0,   958,   873,  2566,
    2567,  2568,  1028,  1027,     0,  2501,  1953,  1011,  1037,  2025,
    2026,  2027,  2028,  2029,  2030,  2031,  2032,  1967,  2033,  2034,
    2036,  2035,  2037,  2038,  1968,  1969,  2039,  2040,  2041,  2043,
    2042,  2044,  1970,  1971,  2045,  2046,  2047,  2048,  1972,  1974,
    1973,  2049,  2052,  2051,  2050,  1975,  2053,  2054,  2055,  2057,
    1976,  1977,  1978,  1979,  1980,  1981,  2056,  1982,  2058,  1983,
    2059,  2060,  2061,  2062,  2063,  2064,  2065,  2067,  2066,  1984,
    2068,  2069,  2070,  2071,  2072,  2074,  2073,  2075,  2076,  2077,
    1985,  2078,  2079,  2080,  2081,  2082,  2083,  2084,  1986,  2085,
    2086,  2087,  2104,  1987,  2088,  2091,  2090,  2089,  2092,  2093,
    2094,  2096,  2095,  2097,  1988,  1989,  2098,  2099,  2100,  2102,
    2101,  2106,  2107,  2108,  1990,  2103,  2105,  2296,  2109,  2110,
    2112,  2111,  2113,  2115,  2114,  1991,  2117,  2116,  1992,  1993,
    2118,  2119,  1951,  2120,  1952,  2121,  2124,  2125,  2122,  2126,
    2131,  1994,  2123,  2127,  2128,  2129,  2130,  2132,  1995,  2134,
    2133,  2135,  2136,  2137,  2138,  2139,  2140,  2141,  2142,  2143,
    2154,  2147,  2149,  2150,  2152,  2148,  2153,  2157,  2156,  2158,
    2159,  2160,  2155,  2145,  2151,  2146,  2161,  2162,  2144,  2163,
    2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,
    2175,  2174,  2176,  2177,  2178,  2179,  2180,  2181,  2182,  2184,
    2183,  2185,  2186,  2187,  2189,  2188,  2191,  2192,  1996,  2190,
    2193,  2194,  2195,  2196,  2197,  2198,  1997,  1999,  1998,  2000,
    2199,  2200,  2001,  2201,  2202,  2203,  2002,  2204,  2205,  2206,
    2208,  2207,  2209,  2210,  2003,  2004,  2211,  2212,  2213,  2214,
    2215,  2216,  2217,  2218,  2219,  2220,  2221,  2222,  2223,  2224,
    2226,  2225,  2227,  2228,  2229,  2230,  2231,  2232,  2233,  2005,
    2234,  2006,  2235,  2236,  2007,  2237,  2008,  2238,  2239,  2009,
    2240,  2241,  2242,  2243,  2244,  2245,  2010,  2246,  2247,  2248,
    2011,  2250,  2249,  2251,  2012,  2253,  2254,  2013,  2252,  2015,
    2255,  2256,  2014,  2257,  2016,  2258,  2259,  2261,  2260,  2262,
    2263,  2264,  2017,  2265,  2018,  2266,  2267,  2268,  2269,  2270,
    2272,  2271,  2273,  2274,  2275,  2276,  2279,  2281,  2278,  2280,
    2277,  2282,  2283,  2284,  2285,  2289,  2290,  2291,  2292,  2286,
    2287,  2288,  2019,  2293,  2294,  2295,  2297,  2298,  2300,  2299,
    2020,  2021,  2301,  2302,  2024,  2303,  2304,  2305,  2309,  2306,
    2317,  2307,  2308,  2311,  2310,  2312,  2313,  2022,  2314,  2023,
    2315,  2316,   184,  1956,   167,  1957,  1966,     0,  2369,  2368,
     994,  2371,  2370,  1012,  2502,  2503,   540,   819,     0,     0,
     820,     0,   539,   818,   165,  2568,   120,     0,   536,   537,
       0,     0,     0,  1684,     0,  1607,  1607,  1607,     0,     0,
    1607,  1607,     0,  1610,  1607,   165,  1607,     0,    69,  1793,
       0,     0,     0,     0,  1950,     0,  1617,     0,     0,  1843,
    1857,     0,  1858,  1852,  2366,     0,  1097,     0,     0,     0,
       0,   165,  1029,     0,  1668,     0,   229,   238,   240,   241,
     237,     0,  2503,  2514,  1064,  1070,  1082,  2321,  2318,  1770,
     241,   983,   983,   983,   981,   983,  1692,  1689,     0,     0,
       0,  1668,  1851,  2620,     0,     0,     0,  2616,     0,  2621,
       0,  1072,     0,     0,     1,     5,     0,     0,  2099,  2203,
    1783,  1781,  1945,     0,   864,   891,     0,   869,     0,   867,
    1962,  1961,  1960,     0,   880,   879,   877,     0,   405,     0,
     962,   963,   957,   959,   961,     0,  2577,   871,  1009,  2500,
       0,   186,     0,    78,     0,     0,     0,  2506,     0,     0,
       0,     0,   119,     0,     0,     0,   116,  1097,  1097,  2568,
    2570,  2572,   540,   538,     0,     0,     0,  1688,  1687,  1686,
       0,  1684,  2026,  1967,  2038,     0,  1918,     0,     0,     0,
    1372,     0,  1972,     0,  2053,  2055,  1976,  1977,  1978,  1979,
    1980,  1981,  1984,     0,     0,  1107,  1107,  1104,     0,     0,
       0,  2076,  2077,  1927,     0,     0,     0,  1914,  1928,  2112,
    2113,     0,  1916,  1917,  2119,     0,     0,     0,  2133,     0,
    2138,  1925,     0,     0,  2170,  2172,     0,     0,  2176,  2177,
    2178,  2179,  1900,  1162,     0,  1104,  1913,  1924,  2195,  1907,
    2204,  2209,  2210,     0,  2219,     0,     0,     0,  2244,  2248,
       0,     0,  2269,     0,     0,  1104,  1899,  2289,  2290,  2291,
    2292,     0,  1915,  2019,  1926,     0,  2303,  1107,  1104,  1104,
       0,     0,     0,  2312,  2316,     0,     0,     0,  2538,  1161,
       0,  1334,     0,  1366,  1119,  1125,  1139,     0,  1154,  1188,
    1189,  1191,  1289,  1190,  1196,  1195,  1584,  1911,  1194,  1193,
    1912,  1187,  1935,  1956,  1934,     0,     0,     0,     0,     0,
       0,     0,     0,  1766,     0,     0,  1594,  1607,    71,     0,
    2416,  2431,  2432,  2428,  2433,  2451,  2434,  2438,     0,  2430,
    2422,     0,  2437,     0,  2426,  2435,     0,  2420,     0,  2436,
    2441,  2452,  2424,  2429,  2407,     0,  2414,  2418,  1947,  1478,
    2383,  2384,     0,    77,  1619,  1620,  1618,   954,     0,  2633,
    1844,  1845,  1846,     0,  1861,     0,  1024,     0,     0,   454,
     445,     0,  1765,  1764,     0,  1837,  2515,     0,     0,   999,
    1622,  1669,     0,  1621,  1832,     0,  1830,  1827,  1829,   230,
       0,     0,   260,  2416,     0,  2401,     0,  2509,  2506,  2516,
    2551,  2546,  2545,  2548,  2549,  1088,  2550,  1087,  2547,  2544,
    1097,  1083,  1085,  1086,  2324,  1728,     0,   753,     0,  1749,
    1778,  1729,     0,     0,  1778,     0,  1513,  1768,  1771,     0,
    2333,  1742,   816,   815,  1752,   814,  2334,  1764,     0,  1716,
    1730,     0,  1693,  1735,     0,  2335,     0,  1767,  1751,     0,
    1750,  1513,  1778,     0,  1709,     0,     0,     0,     0,   236,
     977,   987,   979,   974,     0,   980,   976,     0,  2634,  2635,
    2381,   954,  1906,  1904,  1905,  1954,  2617,  1903,  2625,  2627,
    2613,  2615,  2622,  1066,     0,  2520,     6,    63,     0,  1790,
    2575,  2576,  2574,   769,     0,  1107,  1963,  2569,   168,   878,
       0,   406,   168,     0,     0,     0,     0,     0,   407,   408,
     344,   862,   960,   875,     0,     0,   874,  2577,     0,     0,
    1039,  1041,  1040,  1057,   188,   185,   166,     0,   996,  1601,
    1603,  1014,  2505,     0,     0,  2507,  2511,  1160,  1159,     0,
     113,   118,     0,     0,     0,  2477,   117,  2467,  2573,  1097,
    1097,  1097,  2565,     0,  2553,  2560,  2561,  2564,  2563,  2562,
    2559,     0,  2552,  2555,  2556,  2558,  2557,  2577,  2571,     0,
     821,   821,   821,     0,  1671,  1674,  1678,  1682,  1685,     0,
       0,  1483,  1209,  1483,  1483,  1483,  1373,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1483,     0,  1246,  1219,     0,  1247,     0,     0,     0,
       0,     0,  1921,     0,     0,  2538,     0,     0,     0,  1339,
       0,     0,     0,  2538,     0,     0,     0,     0,     0,     0,
    1368,  1370,  1934,  1483,     0,     0,  1483,     0,     0,     0,
       0,     0,  1112,  1252,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1483,  1483,     0,     0,  1483,
    1260,     0,  1923,     0,     0,     0,  1922,     0,     0,  1920,
     750,   751,  1901,  1919,     0,  1263,  1265,  1264,     0,  1483,
    1483,     0,     0,  1199,  1198,  1200,     0,     0,     0,     0,
       0,     0,  1158,  1157,  1156,  1155,     0,     0,     0,  1163,
       0,  1164,  1165,     0,  1166,  1167,  1168,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1201,     0,     0,     0,
    1902,  1298,     0,  1608,  1589,  1596,  1591,     0,  1766,  1592,
    1600,   419,     0,  1597,  2465,  1593,     0,  1585,     0,    70,
       0,  1815,  1820,     0,     0,     0,  1810,  1818,  1812,  1819,
    1811,     0,     0,  1821,  1814,     0,  1813,  1817,  1816,  1794,
    1798,  1802,  1795,  2417,  2415,  2449,  2448,  2453,     0,  2450,
    2446,  2439,  2478,  2443,     0,  2478,  2445,  2444,  2478,  2440,
    2447,  2478,  2412,     0,  1479,  1480,     0,  2382,     0,  1946,
     955,     0,     0,  1847,  1848,     0,  1047,  1862,  1863,  1859,
    1478,  2367,  2372,     0,   640,  1098,   455,     0,     0,   466,
       0,     0,    66,    67,     0,  1031,     0,  1030,  1034,     0,
       0,     0,  1625,  1615,  1624,  1833,  1834,     0,   228,   253,
     248,   256,   250,   252,   251,   257,   258,   259,   254,   249,
     255,   242,     0,  2415,     0,  2412,  2510,     0,  2512,  2529,
    1071,  2517,  1094,  1073,  1093,     0,  1084,  2319,  2322,  2330,
    1774,   752,     0,     0,  1741,     0,   540,     0,     0,     0,
       0,     0,     0,  1710,     0,     0,   583,     0,  1734,  1514,
    1772,  1773,  1778,     0,     0,  1778,     0,  1747,  1768,     0,
    1778,  1705,     0,     0,  1697,  1702,  1698,     0,  1704,  1703,
    1706,  1694,  1695,  1774,  1721,  1748,  1768,  1733,  1740,     0,
    1720,  1727,     0,  1738,  1768,  1768,  1778,  1778,   990,   989,
     988,   984,   985,   990,     0,  1690,  1407,     0,     0,  2614,
    2628,  2612,  2623,  2624,  2611,  1067,  2521,  1065,  2522,     0,
       7,     4,  1784,  1782,  1791,  1792,   770,   769,   531,   534,
     533,     0,     0,  1965,     0,   870,     0,  1766,   868,     0,
       0,  1766,   355,  1766,   409,   769,   882,     0,     0,   872,
    1010,     0,     0,   443,  1057,  1043,  1059,     0,   189,   191,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    79,    80,
      96,   998,   997,     0,   995,  1022,  1021,  1019,     0,  1020,
    1018,  1013,  1015,  1016,  2504,  2508,   541,   769,  1766,     0,
     347,     0,     0,     0,     0,     0,   540,     0,     0,  2554,
     105,   822,     0,     0,     0,  1676,  1604,  1672,  1606,  1945,
       0,     0,     0,  1680,     0,     0,  1484,  1483,     0,  1348,
       0,     0,     0,     0,  1374,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1319,     0,  1348,  1108,  1558,  1559,  1543,  1544,  1542,  1545,
    1105,     0,  1546,  1557,  1276,     0,     0,     0,     0,     0,
       0,  1454,  1455,  1456,  1457,  1465,  1458,  1459,  1460,  1467,
    1472,  1461,  1462,  1468,  1469,  1470,  1463,  1471,  1466,  1464,
    1473,     0,  1453,     0,  1476,  1474,  1477,  1475,     0,  1340,
    1332,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1483,     0,     0,     0,  1483,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1483,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1242,     0,  1937,  1936,     0,     0,     0,     0,  1203,     0,
    1202,  1416,     0,  2523,  2539,     0,  2336,  1335,  1337,     0,
    1110,  1109,  1111,  1122,  1115,  1120,  1113,  1117,     0,  1169,
    2032,  1123,     0,     0,  1151,  2538,  1492,  1152,  1137,  1142,
    1143,     0,  1140,  1141,     0,  1145,     0,  1144,  1148,  1149,
    1150,  1153,     0,     0,     0,     0,  1192,  1197,  1367,  1097,
    1938,     0,  1587,   419,   422,   421,  1598,   420,  1646,     0,
     964,     0,     0,    72,    74,  1807,  1804,  1803,  1805,  1809,
    1808,  1806,     0,  1822,  2442,     0,  2423,     0,  2427,  2421,
    2425,     0,     0,  2413,     0,  2419,  1482,  2107,  2188,     0,
    1485,  2386,  1612,  2632,  2303,  1849,  1842,     0,  1860,     0,
       0,     0,  1025,   641,     0,  1097,   453,   452,   451,   450,
       0,   468,   448,   456,    68,     0,     0,  1838,     0,     0,
       0,     0,  1001,  1623,     0,  1835,  1831,  1828,     0,     0,
       0,     0,     0,     0,     0,  2513,  2531,  2530,  2518,  1097,
    1504,  1098,  1098,  1934,  2324,  2327,  2328,  2331,  2329,     0,
    2326,  2325,  2340,     0,  1776,  1779,  1780,     0,     0,  1760,
    1754,  1753,  1745,  1755,  1746,  1763,  1762,  1761,  1718,  1717,
    1526,  1527,  2242,  1525,  1517,  1520,  1524,  1523,  1713,  1769,
    1759,  1757,  1743,  1778,  1758,  1756,  1699,  1700,  1701,     0,
    1513,     0,  1776,  1778,  1768,     0,  1778,  1778,  1737,  1739,
       0,   978,   987,   975,   982,  1425,  1424,     0,  1381,     0,
    1383,  1380,  1379,  1378,     0,  1424,  2618,  2626,  2630,     0,
    1513,  2528,  2526,   532,  1646,  1646,     0,  1964,     0,     0,
       0,     0,     0,     0,     0,   169,   178,     0,     0,   353,
     354,  1646,   352,   395,   396,   399,   400,   401,     0,     0,
       0,     0,     0,     0,     0,     0,   122,   402,  1646,  1646,
     349,   375,   376,   379,   380,   381,   382,   383,   345,     0,
     350,   952,   952,     0,  1646,  1646,   952,  1646,     0,     0,
    1646,  1646,     0,     0,  1646,     0,     0,   952,     0,  1646,
     950,     0,     0,  1646,  1646,  1646,  1646,   952,     0,     0,
    1646,  1646,   443,  1646,     0,     0,   970,     0,     0,  1646,
       0,     0,  1646,  1646,     0,  1646,   898,   949,   544,   565,
     566,   863,   897,   899,   911,   439,     0,   928,   951,     0,
       0,   884,   886,  2578,  2579,  2580,  1046,  1038,  1045,  1042,
    1057,  1055,  1044,   811,   810,     0,  1058,   187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1602,  1023,
    1017,   114,   769,  1646,  1646,  1646,  1646,   351,   384,   385,
     388,   389,   390,   391,   394,   392,   393,     0,     0,  1766,
       0,  2469,  2470,     0,  2468,     0,  2606,     0,     0,     0,
     167,   542,     0,     0,   823,     0,     0,     0,     0,     0,
    1485,     0,  1948,  1679,  1407,  1683,  1682,     0,  1272,     0,
    1312,     0,  1314,  1315,  1316,     0,     0,     0,     0,     0,
    1273,     0,  1217,  1274,  1275,     0,     0,  1270,     0,     0,
       0,     0,  1269,     0,     0,     0,     0,  1318,     0,  1106,
       0,     0,  1220,  1221,  1214,  1206,     0,  1291,     0,     0,
    1222,     0,     0,     0,     0,  1278,     0,  1292,  1369,     0,
    1371,  1938,     0,  1324,  1279,  1227,     0,  1322,     0,  1228,
    1293,  1294,  1295,  1281,  1282,     0,  1297,     0,  1283,     0,
       0,     0,     0,  1230,  1328,  1326,     0,     0,     0,     0,
    1330,  1232,     0,     0,     0,  1231,     0,     0,     0,     0,
       0,     0,     0,  1234,     0,  1215,  1327,  1329,  1287,     0,
    1243,     0,  2532,  1415,  2540,  1416,     0,     0,  2534,  2524,
    2529,  2537,  1207,     0,     0,     0,     0,     0,  1939,  1116,
    1121,  1114,  1118,  2538,     0,     0,     0,     0,  1135,  1134,
       0,     0,     0,  2538,  1492,  1138,     0,     0,  1308,  1309,
    1364,     0,  1590,  1588,  1599,  1644,  1645,  1647,     0,  2466,
     966,   965,  1595,   964,    75,     0,  1801,  1823,  1796,  2482,
       0,  2481,     0,  2461,  2464,  1945,     0,     0,     0,  2396,
    2390,  2397,  2399,  2393,  2398,  2400,  2391,  2392,  2387,  2394,
    1486,  1515,     0,  1850,  1048,  1050,  1051,  1049,  1057,     0,
       0,  2375,  2376,  2374,  2373,   458,     0,   467,     0,   479,
       0,     0,     0,  1840,  1839,     0,  1032,  1035,  1036,  1006,
       0,  1005,  1007,  1000,  1002,  1003,   524,  1629,     0,     0,
       0,  1635,  1616,  1626,     0,  2076,  2289,  2292,   243,   246,
     245,   247,     0,     0,     0,     0,     0,     0,  1092,  1407,
    1576,  1089,  1077,  1515,  1505,  1076,  1099,  1095,     0,  2323,
       0,  2286,  2351,     0,     0,     0,     0,     0,  2341,  1775,
       0,  1722,     0,  1744,     0,     0,     0,     0,  1715,     0,
    1736,  1696,  1724,  1714,  1485,  1768,  1711,  1712,   992,   991,
     986,  1424,  1407,     0,     0,  1404,  1426,     0,  1426,  1407,
    1407,     0,  1407,  1478,  1421,     0,     0,  2629,  1506,  2527,
       0,     0,   866,   172,   175,   173,     0,   174,     0,     0,
     404,   403,     0,  1766,   397,   126,   125,   127,   128,  1540,
    1541,  1537,  1538,  1536,  1539,   130,   129,   124,   881,     0,
       0,     0,  1766,   377,   356,   357,   360,   361,   362,   953,
     856,  1026,   932,     0,   621,   856,   807,   812,   812,   930,
       0,  1026,     0,     0,     0,     0,     0,  1026,     0,     0,
       0,  1646,     0,   943,   893,     0,     0,     0,     0,     0,
     944,     0,   894,  1646,     0,     0,     0,     0,     0,  1026,
       0,     0,     0,   441,     0,  1026,   912,   973,   972,   971,
       0,  1026,  1026,     0,   571,   572,   570,     0,     0,     0,
     563,   545,   769,   895,   440,   896,   620,     0,   967,   617,
     623,  1941,     0,     0,     0,     0,   136,  2582,     0,  1445,
     190,    97,    86,    82,   101,  1550,  1551,  1549,  1547,  1548,
     102,    84,    85,    89,    88,    90,    91,    92,    87,    93,
      83,    94,   103,   104,    81,     0,     0,     0,     0,  1766,
     386,     0,     0,  1646,   346,   363,   364,   367,   368,   369,
     370,   371,   374,   372,   373,     0,  2473,  2475,     0,     0,
     340,   339,     0,   131,  2600,     0,     0,   620,   106,   439,
     543,   546,   849,   851,   850,   837,   836,   107,   109,   111,
    1605,  1682,  1407,  1504,  1946,  1485,     0,  1681,     0,     0,
    1313,  1349,     0,  1375,     0,  1211,   724,   724,   724,  1358,
     709,  1362,  1353,   724,  1354,   724,  1356,     0,   755,     0,
     754,     0,  1171,  1186,     0,     0,     0,     0,     0,     0,
    1320,  1317,     0,     0,     0,     0,  1343,     0,     0,     0,
    1216,     0,  1303,  1325,  1323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1331,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1204,
    1097,  2541,  2543,  1068,     0,  2533,  2535,  2337,  2338,  2339,
     858,  1336,     0,  1132,  1128,     0,  1126,  1491,  1147,  1146,
       0,     0,     0,  1136,  1098,  1299,  1097,     0,  1365,  1940,
     418,   582,  1586,    73,  1799,  2479,     0,  2490,     0,     0,
       0,     0,     0,     0,     0,  2385,  1516,  1656,     0,  1057,
    1061,  1955,  1853,  2378,  2379,  2377,     0,   459,   460,   462,
    1098,   476,   454,     0,   446,   449,     0,   458,     0,  1008,
    1004,  1082,     0,  1648,  1633,  1640,  1634,     0,     0,     0,
    1632,  1930,  1929,  1936,  2516,     0,     0,  2406,     0,     0,
       0,  2519,  1485,  1485,  1570,     0,     0,  1074,  1079,  1075,
    1078,     0,  1096,  1103,  1102,  1931,  1938,     0,     0,     0,
       0,   757,   756,   765,     0,     0,     0,  2336,     0,   761,
     763,   762,  2346,   760,  1777,  1513,  1732,  1731,  1528,  1519,
       0,  1522,  1521,  1707,  1513,  1726,  1778,     0,     0,  2523,
    1419,     0,  1406,  1405,  1427,     0,  1407,  1426,  1426,     0,
    1386,  1385,  1660,  1663,     0,  1384,  1443,  1409,  1082,  2619,
    2631,     0,   768,   767,   581,   764,   580,   177,   176,   182,
     183,  1554,  1555,  1552,  1553,   410,   423,  1556,   424,   398,
     123,   411,   412,   378,     0,   358,   622,   857,   915,     0,
       0,     0,   812,   616,   856,   821,   813,   856,   856,     0,
       0,   555,   552,   934,   558,   913,   905,   914,   925,   927,
       0,   554,   573,     0,     0,   561,   856,   900,   941,   942,
     964,   549,     0,   592,   593,   591,   567,   574,   550,   551,
     936,     0,  1500,  1502,  1510,   557,   556,  1561,  1560,   560,
       0,   553,     0,   947,   920,     0,   589,   587,   584,   586,
     585,   590,   588,   562,   559,   575,   910,     0,   952,   952,
     929,     0,   600,   601,   603,   604,  1944,     0,   969,   931,
       0,   605,   618,   606,     0,     0,   579,   578,   576,   577,
       0,   146,     0,     0,   883,     0,   139,   137,   148,     0,
       0,     0,  1448,     0,  1449,  1446,  1447,     0,    98,   100,
     417,   416,   415,   414,   387,     0,     0,     0,  1766,   365,
    2474,  2472,  2471,     0,     0,  2607,   343,   341,   342,     0,
       0,   192,   598,   599,   597,   596,     0,   427,     0,  2002,
     425,     0,   438,     0,  1864,   769,   547,     0,     0,     0,
       0,  1485,  1529,  1949,  1675,     0,  1244,  1376,     0,     0,
     725,  1350,   777,  1360,     0,  1361,   711,   710,   726,  1352,
    1355,  1359,  1357,  1210,  1218,  1266,     0,  1184,  1267,  1268,
       0,  1290,  1213,  1212,     0,     0,     0,  1250,  1251,     0,
    1341,     0,     0,  1224,     0,  1226,     0,     0,  1305,  1280,
    1296,  1253,  1284,     0,  1229,  1205,     0,  1254,     0,  1259,
    1257,     0,  1233,     0,     0,  1240,     0,  1238,     0,  1239,
       0,  1241,  1286,  1288,  1417,  2542,  1069,     0,     0,  1338,
    1124,     0,  1133,  1130,     0,  1127,  1099,  1310,  1300,     0,
    1797,  2480,     0,  2411,  2463,  2462,  2483,  2483,  2483,     0,
    1487,     0,  1613,  1052,  1057,  1061,     0,  1053,  1864,   463,
       0,     0,     0,   483,     0,   481,   457,     0,  1033,  1097,
    1630,  1642,     0,  1650,     0,     0,  1627,  1637,     0,     0,
       0,  1636,   244,     0,  2403,  2404,  2402,  1515,  1493,     0,
       0,  1582,     0,  1577,  1090,     0,  1101,  1100,     0,  2353,
       0,  2352,  2364,  2365,  2362,  2363,  2361,  2342,     0,  2348,
    2347,     0,     0,     0,  2358,  2349,     0,     0,  1723,  1518,
    1725,  1719,   993,  2529,  1478,  1411,  1407,  1382,  1407,  1393,
       0,     0,  1407,  1389,  1387,  1391,     0,  1485,     0,  1408,
    1440,  1097,  1933,  1507,  1510,   359,   917,     0,   856,   808,
     809,   821,     0,   821,   821,     0,     0,   904,     0,  1014,
       0,   909,   765,   568,   940,   939,   569,     0,   902,     0,
    1511,  1512,  1503,   442,   901,   922,   907,  1822,   933,   620,
     968,   789,   705,   654,   645,   724,   648,   647,   691,   724,
     659,   709,   707,   677,   709,   709,   684,   683,   701,   687,
     667,   777,   777,   666,   704,   777,   688,   686,   690,     0,
     692,   709,   697,   685,   689,   706,   682,   679,   703,   724,
     724,   724,   663,   702,   777,     0,   695,   724,   624,   728,
     665,   777,   784,     0,     0,   724,   726,  1943,   147,   135,
       0,     0,   885,   887,     0,     0,   888,  2584,     0,  2586,
       0,  1060,     0,    95,     0,     0,   348,   413,   366,  2476,
       0,   203,  1097,     0,     0,   193,   195,   196,     0,     0,
       0,   429,  1866,  1865,   426,   527,   548,     0,     0,     0,
    1682,  1677,     0,  1673,     0,  1377,     0,     0,     0,     0,
     771,   782,   780,   774,     0,   778,   779,  1351,     0,     0,
     727,  1363,   724,  1181,   709,  1175,  1177,  1173,     0,   692,
    1176,   724,     0,   777,  1180,  1172,     0,  1321,     0,     0,
    1344,     0,     0,     0,     0,     0,     0,     0,  1208,     0,
    1301,     0,     0,     0,     0,     0,     0,  1237,  1235,  1236,
    1515,  2523,   859,  1129,     0,  1311,     0,     0,     0,  2488,
    2488,  2488,  1655,  1654,     0,  1653,  1657,  1054,  1062,     0,
     461,   464,     0,   456,     0,   480,     0,   447,   525,     0,
       0,     0,  1651,  1639,  2520,  1628,  1631,  1938,  2405,  1081,
       0,  1488,  1581,  1578,     0,  1571,  1573,  1575,     0,  1932,
       0,     0,  2357,  2343,   766,     0,     0,     0,     0,  2344,
    1412,  1410,  1420,     0,  1378,  1407,  1407,     0,  1378,     0,
       0,     0,  1662,  1504,  1664,  1444,     0,  1422,     0,  1509,
       0,     0,   916,     0,     0,     0,     0,     0,     0,   946,
       0,   967,   906,   926,   948,   937,  1026,  1501,   921,   923,
    1001,     0,   602,     0,   793,   653,   646,   664,   662,   713,
     708,     0,   713,   713,   673,   691,   668,     0,   777,   681,
     672,   693,   696,   698,   700,   713,     0,   777,   661,   660,
     670,   657,   713,   736,     0,     0,     0,     0,   732,     0,
     787,     0,   739,     0,   625,   729,   731,     0,     0,     0,
     694,   777,   650,   785,   784,   652,   777,   784,   713,   713,
       0,   133,   138,   149,   150,   876,  2583,     0,  2581,     0,
    1056,  1450,    99,     0,     0,   206,   204,   205,     0,   199,
     201,   196,  2594,     0,  2601,     0,     0,  2599,   428,   431,
     542,   528,     0,     0,  1510,   854,     0,     0,  2242,  1530,
    1245,   722,   720,   723,   721,   773,   772,   776,     0,   775,
     784,     0,     0,  1183,  1178,   693,  1182,  1174,  1179,  1271,
    1248,  1249,     0,  1342,  1333,  1277,     0,  1225,  1302,     0,
       0,  1285,  1255,  1258,  1256,  1261,  1262,  1089,  1089,   594,
    2536,  1131,  1824,  2491,     0,     0,  2487,  2485,     0,  2486,
    2484,  2454,     0,  2409,  2410,  2408,  2395,     0,     0,     0,
    1097,   469,     0,   486,   485,   482,  1515,  1641,  1643,  1649,
    1638,     0,  1489,  1504,   758,  1574,     0,  1091,  2355,  2354,
    2356,  2350,     0,     0,     0,     0,  1394,     0,  1398,  1403,
    1399,     0,  1390,  1388,     0,  1529,  1432,  1433,     0,     0,
    1438,  1442,  1515,  1510,   919,     0,   619,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   945,  1908,   935,
     967,   903,     0,   908,   564,     0,   792,     0,   797,   717,
     718,   719,   674,   714,   716,     0,   676,   644,   669,   699,
     675,     0,   671,   658,   742,   741,  1107,   734,   749,   629,
       0,     0,   740,   626,   730,   738,   733,     0,   649,   651,
     655,   656,   642,   643,  1942,   140,   889,   280,  2585,  1072,
       0,  2590,   121,  2598,  2608,   203,     0,     0,   144,     0,
     194,   765,   197,  2520,   439,     0,   434,   824,     0,   853,
       0,   826,   828,  1531,     0,   783,   781,     0,  1345,  1510,
       0,  1304,  1306,  1418,   595,     0,  1800,  2460,  2459,  2458,
    2455,     0,     0,     0,     0,     0,     0,  2489,  2493,  1652,
       0,     0,     0,   477,     0,     0,   511,   526,  1497,  1510,
       0,  1515,     0,  1579,  1572,  2360,  2359,  2345,  1413,     0,
       0,     0,     0,     0,  1451,  1661,  1428,  1428,  1439,  1423,
    1508,   918,     0,     0,   607,     0,     0,  1910,  1909,   938,
       0,   790,     0,   794,   795,   796,     0,   788,   715,     0,
     860,     0,   748,  1107,   737,     0,   746,   745,   743,   744,
       0,   142,   306,     0,   292,   278,     0,     0,     0,   282,
     151,   154,   152,     0,   153,   159,     0,   160,   161,   162,
     163,   164,   155,   304,   305,   158,   156,   157,     0,  1958,
       0,  1959,  2588,     0,     0,  2587,   170,   200,     0,     0,
     136,   145,  2602,   747,   432,  1864,     0,  2516,     0,  1646,
     108,   825,   845,   844,   830,     0,  1510,     0,     0,   110,
     827,   847,   834,   112,   829,   846,   832,  1532,   712,     0,
    1347,  1223,     0,  2456,  2494,  2497,  2495,  2496,  1533,     0,
    2498,  2492,     0,  1854,  1098,     0,   470,     0,   473,   475,
     489,     0,  1646,  1646,     0,     0,  1646,  1646,  1646,  1646,
     504,   512,   514,     0,  1498,  1499,     0,  1494,  1496,  1490,
    1562,   759,  1867,  2523,  1395,     0,  1400,     0,  1392,     0,
       0,  1436,  1434,     0,   613,   824,   609,   611,     0,   791,
       0,     0,   777,     0,   777,   735,  1097,   141,     0,   134,
       0,     0,   291,   294,     0,     0,   297,   287,   286,   288,
       0,   281,   280,   280,   334,   285,   331,   330,   323,  2520,
       0,     0,     0,  2609,   202,  1097,   148,     0,   430,   436,
     435,   839,     0,   831,     0,   852,   855,     0,   835,   833,
    1510,  1825,  1535,  1534,  1658,  1666,     0,   758,     0,   478,
     471,     0,     0,   487,     0,     0,  1646,  1646,     0,     0,
       0,     0,     0,   484,   513,  1646,  1510,     0,  1080,     0,
    1875,  1414,     0,     0,  1452,     0,  1429,     0,     0,     0,
     615,   824,   608,   826,   828,     0,   803,     0,   802,     0,
     799,   798,   678,   861,   680,     0,   143,   307,   318,   321,
     313,   293,     0,     0,     0,   283,   280,     0,   267,   265,
     266,   272,   273,   274,   275,   276,   277,   268,   271,   269,
     270,   280,     0,   211,     0,     0,  2589,     0,  2591,     0,
     180,   179,   171,     0,   280,  2595,     0,  2603,  2520,   838,
     843,   842,   840,   841,   848,  1346,     0,     0,  1855,   465,
     477,   474,   497,   490,   493,     0,   523,   517,     0,     0,
     519,   520,   518,   515,   508,     0,   506,     0,  1495,  1563,
       0,     0,     0,     0,  1868,  1870,     0,  1580,  1397,  1402,
    1431,  1430,  1445,     0,   614,   610,   612,   924,   805,   806,
     804,     0,     0,   630,     0,     0,   280,   314,     0,   289,
       0,     0,     0,     0,   209,   337,     0,   207,   325,   325,
    2592,  2593,   181,  2610,     0,   150,   170,   437,  1665,  1667,
    1881,   472,   497,     0,   495,     0,   491,   488,   492,   521,
     522,     0,   505,     0,   516,     0,     0,     0,     0,     0,
    1869,     0,     0,  1876,  1878,     0,     0,     0,     0,   632,
     631,   633,   315,   321,   311,   319,   280,     0,     0,   279,
     298,   333,   210,     0,   335,     0,   280,     0,   324,   326,
     328,     0,   132,  2604,     0,  1867,   494,     0,   502,   498,
     500,   503,   511,   510,   507,  1097,  1873,  1874,     0,  1871,
       0,     0,  1877,  1437,  1435,   801,   800,     0,   637,   627,
     634,   636,     0,   312,     0,     0,   310,   290,   295,   280,
       0,   280,   222,   221,     0,   213,   261,   332,     0,   212,
    2596,   280,     0,  1875,   496,     0,     0,   509,     0,     0,
    1566,  1568,  1872,  1880,  1879,   639,   638,   635,   316,     0,
     280,     0,   280,     0,   280,     0,     0,     0,     0,     0,
     208,   280,  2605,     0,  1883,   501,   499,  1098,  1564,  1097,
       0,   308,   280,   296,   301,   338,     0,   216,   262,   263,
       0,   219,  2597,  1882,     0,  1887,  1569,  1567,   280,   280,
     297,   300,   336,     0,     0,   214,   215,   227,   226,   218,
       0,     0,     0,  1894,   280,   280,   302,   235,   233,   280,
     223,   231,   225,     0,   232,   264,   220,  1885,  1886,  1884,
    1889,     0,     0,  1891,  1892,     0,  1856,     0,   217,   234,
    1893,  1888,     0,  1895,  1897,     0,   224,  1890,     0,  1097,
    1896,     0,  1098,  1898
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    58,   606,  1451,    59,    60,    61,    62,    63,  1322,
      64,   818,  1249,  1753,  1754,    65,   545,    66,  1027,  1508,
    1509,  2977,  2978,  1510,    67,  2091,  3017,  3018,  3019,  1527,
     515,   516,  1945,  1946,  1052,  3000,  2964,  3775,  2968,  3891,
    4029,  3930,  2021,  3316,  3776,  3777,  3900,   540,  2089,  1465,
    4053,  1925,  4162,  1926,    68,   641,  1025,  1487,  1488,  3334,
    3335,  3596,  3336,  3588,  3589,  3590,  3591,  4296,  4136,  4237,
    4297,  4377,  4413,  4419,  4420,  4344,  4429,  4430,  4431,  4417,
     890,  4432,    69,   568,   569,   892,  1351,  2338,  1352,    70,
    4345,  4415,  4137,  4138,  4036,  4139,  3903,  4140,  4040,  4141,
    3906,  4142,  4143,  4144,  4145,  4288,  4146,  4035,  4337,  4133,
    4134,  4339,  4394,  4411,  4147,  3913,  4030,  4224,  3914,  4031,
    4283,  4129,  4284,  4332,  4390,  4130,  4225,  4335,  4228,  4148,
    4154,  4298,  4149,  4155,  4150,  3918,  4047,  4153,  4045,  4152,
    4341,  4293,  2582,  2999,   624,   625,   652,  2079,   626,  1041,
     999,  1467,  1958,  1959,  2444,  2445,  2564,  2565,  2566,  1950,
    1951,  1952,  2067,  2068,  2069,  1932,  1933,  1934,  1471,  1929,
    1930,   627,  1000,  1010,  1953,  1954,  1955,  2570,  2071,  2072,
    2073,  2074,  1956,  1746,  1957,  2855,  2588,  3010,  3600,  3793,
    3344,  3937,  4168,  3011,  3012,  2514,  2920,  2493,    71,   557,
     870,  1319,  2310,  1320,  2312,  2736,  2737,  2738,  1796,  1797,
    3671,  1801,  2309,  3833,  4180,  3977,  3978,  2740,  3976,  2744,
    3134,  3135,  3434,  3673,  3836,  4185,  4082,  4257,  4183,  4253,
    4184,  4255,  4356,  4309,  4310,  4093,  4195,  4196,  4261,  4312,
    3990,  3991,  3992,  2331,  2751,  3676,  3602,  2061,  1457,  1458,
     517,   518,   519,   649,  2589,  2007,  2590,  2591,  2937,  2009,
    2010,  2710,  1385,  2933,  2906,  3647,  3006,  2941,  2942,  2943,
    2944,  2945,  4015,  4113,  4114,  4111,  2951,  2873,  2453,  2454,
    2519,  2954,  3298,  3885,  3553,  4281,  4329,  4330,  4331,    72,
     867,  3791,  3521,  3536,  3300,  3301,  3302,  3303,  3304,  3305,
    3306,  3035,  3036,  3742,  3743,  3744,  3030,  3031,  3371,  3554,
    3555,  3556,  3792,  3757,  1173,  3364,  2792,  2793,  3843,  2801,
    2802,  2843,  3179,  2844,  1461,  3365,  3366,  3367,  3565,  3557,
    2953,  3514,  3735,  3738,  3877,  4120,  2455,  2874,  2456,  2877,
     953,   520,  2457,  2458,  1541,  1542,  3940,  3949,  3953,  3941,
    3954,  3950,  3942,  3943,  3944,  3956,  3952,  2595,  3603,  3604,
    2866,  3099,  3879,    73,  1475,   993,  1002,   998,  1017,   636,
    1476,  2022,  2526,  3575,   614,  2011,  3506,  3229,  3510,  2012,
    2886,  2013,  3216,  3492,  2014,  3245,  3508,  3732,  2887,  2888,
    2015,  2016,  2017,  3228,  3237,  3730,  2459,  1301,   126,   127,
     632,   633,   634,  2262,  2949,  2500,    74,  1433,  1428,    75,
     965,   960,   961,  1431,  1432,  1891,  2389,    76,   644,  1514,
      77,  1330,  2323,  2324,  2325,    78,  1018,    79,    80,   645,
    1521,  1522,  1523,    81,  1313,   134,    82,   878,  1325,  1327,
    1328,    83,   640,  1019,  1020,  1021,  1022,  2027,    84,  1787,
    2294,  2295,  2296,  2297,  1484,  2528,  1485,  1486,  2036,  3127,
      85,    86,   603,  2217,   574,   899,   575,   576,  1830,  2351,
    3648,   910,   911,   912,  2777,  1363,  1364,  1365,  1793,  2782,
    1106,  1103,   783,   784,   785,   786,  1197,  1198,  3558,   787,
    1207,  1712,  3047,  3385,  1572,  1573,   788,   789,   790,   791,
     792,   793,  1739,  3067,  3068,  3400,  2247,  2248,  2249,   794,
    2136,  3054,  2149,   795,  1190,  1697,  1630,  3392,  3060,  3632,
    3808,  1558,  2111,  2627,  3038,  2707,  2211,  1129,  1130,  1087,
    2118,  1564,  1898,  1899,  1900,  1901,  1902,  3480,  3479,  3481,
    3849,  3697,  3851,  3701,  2400,  1903,  1904,  2818,  3695,  4003,
    2212,  2213,  2214,  3410,  2819,  3196,  2837,  2838,  3712,  2391,
    1905,  2825,  4011,  3709,  3710,  4109,  4108,  3711,  3485,  3486,
    3209,  3210,  2973,  2974,  2975,  3853,  1621,  1622,  1628,  1296,
    1297,  1559,  2291,  2724,  3683,  3840,  2238,  3451,  3838,  3997,
    2018,  2912,  2913,  2353,  2354,  2841,  3213,  3242,  1388,  3649,
    2726,  1864,  2808,  2809,  3353,  3970,  4418,  1591,  2540,  2856,
    2857,  1593,  2919,  4098,  4265,  4359,  4360,  4361,  3161,  3162,
    3455,  3456,  2355,  2774,  3163,  3684,  4002,    87,   524,    88,
    1751,  2253,  1246,  2267,  1029,  1545,  1546,   806,   537,    89,
     546,  2292,    90,   564,  1814,   857,   882,  1333,  1334,  2332,
    2752,  2759,  2333,  2764,  3444,  2754,  3140,  3141,  2257,  2258,
    2755,  3143,  3441,  3424,  3425,  3122,  3668,    91,   591,  3207,
    2832,  2833,  4074,  4075,   883,    92,   523,  1074,  2100,  1551,
    2099,  1075,  1076,  2102,   670,   671,    93,   967,   587,  1410,
    1411,  1412,  1880,    94,   579,   954,  2805,  2814,  1858,   874,
    1242,  1392,   957,  1393,  1844,  2371,  1374,    95,   989,   988,
      96,   610,  1453,    97,   819,  1269,  1763,  2714,  3110,  1270,
    1271,  2268,  3816,    98,   565,   887,   888,  1336,  1816,    99,
     559,   875,  1807,   100,   549,   862,  1305,  1786,   101,   102,
     864,  3128,  4077,  4250,   553,  1789,  1309,  3345,  4100,  4204,
    4205,  4207,  4273,  4274,  4305,  4405,  4439,  4423,  4442,  4443,
    4446,  4453,  4454,   797,   976,   798,  3727,   799,   800,  2760,
    2761,  3214,   801,  2762,   802,  2867,  1030,  1548,   543,   493,
     621,   977,  2732,   804,  3920,   996,  1045,   495,   496,   103,
     914,   578,  1367,  1368,  1369,  1839,  1840,   958,  2226,  1841,
    1842,  2368,  2363,  3463,  3185,  3177,   104,   865,   502,   503,
    1311,  1312,  2303,   105,   590,   106,  1298,  1780,  1781,  2288,
    2723,  2289,   107,   895,   108,   844,  1774,   845,  1274,   846,
     847,  1288,  1282,  1291,  1285,  3821,  3660,  3661,  2276,  1245,
    1046,  2083,  2993,  1047,  1766,  2270,  2271,  3419,  3663,  3113,
    3827,  3828,   109,   135,   505,   647,  1036,  1357,   110,   111,
     112,   113,  1360,  1446,  2347,  1447,  2218,  1448,  1449,  1912,
    1828,  1693,  1694,  3097,  1187,  1188,  2221,  2680,  2681,   913,
     656,  1062,  1054,   128,   129,   130,   659,   660,   131,  1015,
    1016,  2527,  2970,  3318,  3578,  3579,  3781,  3925,  1056,  3787,
    4244,  4381,  1057,  1058,  3001,  3789,  4057,  4246,  4351,  1059,
    2579,  3331,  3926,  4164,   114,   978,   600,  1444,  1439,  1441,
    1908,  2407,   115,   116,   117
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3833
static const int yypact[] =
{
    5687,  2488,  1005, -3833,  -134,   182, 48544,   116,  -112,  1140,
     393,  3210, -3833, -3833, -3833, -3833, -3833,  2799, -3833, 48544,
    1005, -3833, 24688, -3833, -3833,   -28, -3833,   113,  -112,  1005,
     384, -3833, 48544, -3833,   574,  1039,  1005, -3833, -3833, 43656,
   -3833,   393, 48544, -3833,   694, -3833, 43656,  1212,  -113,   616,
     580,   -26, -3833, -3833, 48544,  2257, -3833,   550,  1223,  1144,
   -3833, -3833,   910, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, 25303, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  1185, 48544,
    1253, 48544,  1221, 48544, 41823, 48544,   904,  1104,  1280, -3833,
   -3833,  1342, -3833, -3833,  -112,   393, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833,   945, -3833, -3833,   953, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  1530,  1382, -3833,  1456, 41823,
   -3833, 48544, -3833, -3833, -3833,   242, -3833,  1150, -3833,  1157,
    1503,  1542,  1552,    76, 11562,  1472,  1472,  1472, 48544,  1526,
    1472,  1472, 48544, -3833,  1472, -3833,  1472,  -112, -3833, -3833,
    4212, 48544,  1341,   170,  -120, 41823,  1445, 48544,  -134,   758,
   -3833,  1536, -3833, -3833, -3833,  -112, -3833,  1745,  1604,   948,
   48544, -3833, -3833,  1140,  1176,   713,  1220, -3833, -3833,  1337,
   -3833,  4495,   177, -3833, -3833, -3833,  2540, -3833, -3833,  6863,
    1337, -3833, -3833, -3833,  1219, -3833, -3833, -3833, 48544,  -134,
    -112,  1578, -3833, -3833,   186,   186,   186, -3833,   186, -3833,
     186, -3833,   550,  1197, -3833, -3833,  1235, 48544,   715,   876,
   -3833, -3833,  1248,   863, -3833,  1293, 39379, -3833, 48544, -3833,
   -3833, -3833, -3833,  1527, -3833, -3833, -3833,  2191, -3833, 24688,
   -3833, -3833, -3833,  1104, -3833, 48544,  1395, -3833, -3833, -3833,
   24688,  1273, 48544, -3833, 24688, 24688,   245,    25,  1013, 48544,
   48544,  1715, -3833,  1903, 39379,  1509, -3833,   382,   -94,  1342,
    1960, -3833,  1382, -3833, 48544, 48544, 48544, -3833, -3833, -3833,
   44267,    76,  1339,  1346,  1359, 16626, -3833,  1367,  1371,  1374,
   11562,  1380,  1388,  1394,  1397,  1399,  1420,  1425,  1459,  1470,
    1474,  1489,  1491,  1493,  1495,  1508,  1508,  1511,  1532,  1537,
    1543,   771,  1548, -3833,  1589,  1598,  1605, -3833, -3833,  1627,
    1636,  1646, -3833, -3833,  1648,  1651,  1657, 12195,  1676,  1681,
    1686, -3833, 21604,  1689,  1691,  1697,  1701,  1704,  1706,  1716,
    1719,  1730, -3833, -3833, 11562,  1511, -3833, -3833,  1736, -3833,
    1740,  1743,  1753,  1760,  1765,  1770,  1778,  1781,  1792,  1795,
    1811,  1813,  1816,  1819,  1821,  1511, -3833,  1020,  1830,  1833,
    1111,  1835, -3833,  1838, -3833,   207,  1842,  1508,  1511,  1511,
    1852,  1862,  1873,  1890,  1901, 16626, 16626, 16626, 11562, -3833,
   48544, -3833, 48544,  2044,  3073, -3833,  2685, 16626,   895, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833,  1465,  1471, -3833, -3833,
   -3833, -3833, -3833,  1907,  1393,  2009, 48544, 48544, 48544,  1853,
   48544, 48544, 41823,  1747, 48544, 39379, -3833,  1472,  1673,  3743,
    1904,  1999,  1978, -3833, -3833, -3833, -3833, -3833,  2172, -3833,
   -3833,  2018, -3833,  2182, -3833, -3833,   180, -3833,    91, -3833,
   -3833, -3833, -3833, -3833, -3833,  2188,  1924, -3833, -3833,   146,
   -3833, -3833, 48544, -3833, -3833, -3833, -3833,  2335,  2076, -3833,
   -3833, -3833,   828,  2515,   891, 24688, -3833,  1939, 11562,  1679,
   -3833,  -189, -3833, -3833,  2294, -3833, -3833, 39379, 24688, -3833,
   -3833, -3833, 22221, -3833, -3833,  2526, -3833,  1952, -3833, -3833,
    1471,  3156, -3833,  1904,  2215, -3833,  2229,  2128,    25,  2029,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
    1983,  2540, -3833, -3833, -3833, -3833,  2438, -3833,  2140, -3833,
      18, -3833,  1993,  1059,    18, 39990,  2371,   193, -3833,   338,
   -3833,  2456, -3833, -3833, -3833, -3833, -3833,  2137,  2125, -3833,
   -3833,   375,  2111, -3833,  2483, -3833,    31, -3833, -3833,  2149,
   -3833,  2371,    18,   193, -3833,  2386,  2520,   618,   829, -3833,
   -3833,   -49, -3833, -3833,  2591, -3833, -3833, 24688, -3833, -3833,
   -3833,  2335, -3833, -3833, -3833, -3833,  2055, -3833,  2333,  2179,
   -3833, -3833,    43, -3833,  2102,   688,  2581, -3833,  1026, 35713,
   -3833, -3833, -3833,  2612,  2631,  1508,  2118, -3833, -3833, -3833,
    2750, -3833, -3833,  2132,  2657,  2657,  2657,  2775, -3833, -3833,
   -3833, -3833, -3833, -3833,  2321,  2192, -3833,  1395, 24688,  2548,
    2167, -3833, -3833,  2412, 11562, -3833, -3833,  3947,    50, -3833,
   -3833,   179, -3833,  2747,  2373, -3833, -3833, -3833, -3833,  2638,
   -3833, -3833,  2750,  2700,  2657,  2593,  2199, -3833, -3833, -3833,
   -3833, -3833, -3833,   239, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  1278, -3833, -3833, -3833, -3833, -3833,  1395, -3833, 24688,
   -3833, -3833, -3833, 24688, -3833,  2205, -3833,  2208, -3833, 11562,
   11562,   939,  2763,  2828,  2828,  2828,  2044,  2247, 11562, 11562,
   11562, 11562, 11562, 11562, 11562, 11562, 11562, 11562, 11562, 11562,
   11562,  1054,  2223, -3833, -3833,  1355, -3833,  2234, 11562, 11562,
    2316, 11562,  1471, 11562, 25918, -3833,  4349, 11562,   376,  2726,
   11562, 11562, 11562, 11562,  3347, 11562, 11562, 11562, 25918,  2860,
    2254, -3833,  2249,  1454, 11562, 11562,  1547, 11562, 11562, 11562,
   11562, 11562, -3833, -3833, 11562, 11562, 11562, 11562, 16626, 11562,
   11562, 11562, 11562, 11562, 11562,  2828,  2828, 11562, 11562,  1593,
   -3833, 11562,  1471,  1881,  1881, 11562,  1471,  8397, 11562, -3833,
   -3833, -3833, -3833, -3833,  2259, -3833, -3833, -3833, 25918,  2828,
    2828, 11562, 11562,  2763,  2763,  2763,   223,  2264,  1083, 11562,
   27148,  2261, -3833, -3833, -3833, -3833, 11562, 11562, 11562, -3833,
   16626, -3833, -3833,  1661, -3833, -3833, -3833, 12828, 16626, 16626,
    2267, 16626, 16626, 16626, 16626, 16626,  2633, 16626, 16626, 17259,
   17892, 16626, 16626, 16626, 16626,   867,  2763, 41823, 16626, 11562,
   -3833, -3833, 48544, -3833, -3833, -3833,  2265, 24688,  1747, -3833,
   -3833,   -57,  2742, -3833, -3833,  2273, 24688, -3833,  2270, -3833,
    2628, -3833, -3833,  2630,  2634,  2651, -3833, -3833, -3833, -3833,
   -3833,  2862,  2652, -3833, -3833,  2653, -3833, -3833, -3833, -3833,
    2281, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2387, -3833,
   -3833, -3833,  2304, -3833, 39379,  2304, -3833, -3833,  2304, -3833,
   -3833,  2304,   695,  3825, -3833, -3833, 48544, -3833, 49155, -3833,
   -3833, 22221,  -134, -3833, -3833, 13461, -3833, -3833, -3833,  2660,
     188,  2308, -3833, 24688, -3833,  2044, -3833,    85,    85,  2547,
     174, 41823, -3833, -3833,   167,  2309,  2392,  2314, -3833,  2396,
   24688, 24688, -3833, -3833, -3833, -3833,  2938,   713, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2320,  2795,  2327, 39379,   813, -3833, 48544, -3833,  1629,
   -3833, -3833, -3833,  2329, -3833, 11562, -3833,  2331, -3833,  1115,
    2720, -3833,  -134, 11562, -3833,  2342,  1382, 48544, 48544, 48544,
   24688, 48544, 24688, -3833,    10,    10, -3833, 36324, -3833, -3833,
   -3833, -3833,    18, 48544, 48544,    18, 39379, -3833,   193, 48544,
      18, -3833,  2723,  2446, -3833, -3833, -3833,  2790, -3833, -3833,
    2785,  2345, -3833,  2720, -3833, -3833,   193, -3833, -3833, 24688,
   -3833, -3833,   193, -3833,   193,   193,    18,    18,  2400, -3833,
   -3833,  2350, -3833,  2400,  2500, -3833,  1222,   186,  2597, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,    94,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833,   123, -3833, -3833,
   -3833,  2210,  2853, -3833, 41823,  1909,   -88,    21,  1909,  2322,
    -134,  1096, -3833,  1096, -3833,  3396,  2635,   231, 24688, -3833,
    2370, 44878, 24688, -3833, -3833, -3833,  1007,  2393,  2372,  2044,
    2861,  2864,  2865,  2867,  2869,  2870,  2871,  2873,  2877,  2887,
    2891,  2892,  2900,  2909,  2930,  2932,  2934,  2936,  2458, -3833,
   -3833, -3833, -3833, 24688, -3833, -3833, -3833, -3833,  2523, -3833,
   -3833, -3833, -3833,  2702, -3833, -3833, -3833,   153,  1825,  2493,
    2524,   165, 39379,  2914, 48544, 48544,  1382, 48544, 48544, -3833,
   -3833,  -132,  2748,  2752,  2757,  2479, -3833, -3833, -3833,  1055,
   48544,  2927, 30214, -3833,   358,   414, -3833,  2828,  2491, -3833,
    2492,  2506,  2508, 11562,    59,   152,   740,  1258,  1316,  1080,
     407,   439, -3833,  1350,   444,   464,   536,  1102,   560,   176,
   -3833,  2509,  2499, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2510, -3833, -3833, -3833,   562,   615,  1139,  1141,  2511,
    2512, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2953, -3833,  1416, -3833, -3833, -3833, -3833,  2518, -3833,
   -3833,  1191,   624,   667,   233,  2527,  1438,   727,  1455,  1499,
    2517, 25918, 48544,  2828,  2522,  1199,  1216,  2828,  2525,   752,
    1234,  1518,  1538,  1556,  1241,  1250,   777,  1562,  2505,  1254,
     834,   881,   893,   905,  1267,  2530,  2531,   927,   198,  2828,
    2535,   258,  2537,  2539,  1271,  9663, 10296, 10929,   212,   933,
   -3833,  2541, -3833,  2249,  2543,  2544,   299,  1304, -3833, 11562,
   -3833, -3833,  1094,  1281,  2582,   139,   772, -3833,  2677, 48544,
    2226,   202, -3833, -3833, -3833, -3833, -3833, -3833,   862, -3833,
    2528, -3833,  2549,  2046,  2552, 11562,  1109,  2552,  2749,  2442,
    2442, 16626,  2299,  3083, 12195,  1211, 12195,  1211,  2552,  2552,
    2552, -3833, 16626,  2556, 16626, 16626, -3833,  2763,  2044,  2551,
     436, 48544, -3833,   -57, -3833, -3833, -3833, -3833,   815, 39379,
     149, 24688, 41823,  2559, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,  4125, 24688, -3833, 48544, -3833,  2636, -3833, -3833,
   -3833, 22836, 22836, -3833, 22836, -3833, -3833,  1017,  1063,  3141,
    2585, -3833, -3833, -3833, 29601,  2044, -3833, 24688, -3833,  2960,
      36, 24688,  2370, -3833,  2564, -3833, -3833, -3833, -3833, -3833,
    2675,  2674, -3833,  3190, -3833, 11562,  -134, -3833, 39379, 39379,
   24688, 24688,   858, -3833,  1650, -3833, -3833, -3833,  3156, 18525,
    3003,  3015, 22836, 22836, 22836, -3833, -3833, -3833, -3833, -3833,
     136,  2044, -3833,  2571, -3833, -3833, -3833, -3833, -3833, 45489,
     265, -3833, -3833,  -134,  3017, -3833,  2044,  2587, 48544, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,  3045, -3833,  2761,   513, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833,    18, -3833, -3833, -3833, -3833, -3833,  2806,
    2371,  2111,  3017,    18,   193, 24688,    18,    18, -3833, -3833,
    1837, -3833,   -49, -3833, -3833, -3833, -3833, 48544,  2632,  2751,
   -3833,  2592, -3833, -3833, 24688, -3833,  2599, -3833,  3041,  3189,
    2371, -3833, -3833, -3833,   815,   815,  2901, -3833,  -134,  2741,
    2743,  2753,  2759,  2762,  2776, -3833, -3833,  -134,  -134, -3833,
   -3833,   815, -3833,   890, -3833, -3833, -3833, -3833,  -134,  -134,
    -134,  -134,  2729,  -134,  -134,  1654, -3833, -3833,   815,   815,
   -3833,   353, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  1192,
   -3833,  2355,  3167,  2872,   815,   815,  3167,   815,  2879,  2884,
     815,   815,  2703,  3116,   815,  3004,  2735,  2928,  3010,   815,
   -3833,  2744,  3137,   815,   815,   815,   815,  3167,  2890,  3229,
     815,   815, -3833,   815,  2894,  2899,   159,  2904,  2905,   815,
     183, 48544,   815,   815,  2907,   815, -3833, -3833,  5097, -3833,
   -3833, -3833, -3833, -3833, -3833,   705, 23454, -3833, -3833,   815,
     218, -3833,  2845, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  2659, -3833, -3833, 11562,  2661,
    2729,  -134,  -134,   806,  -134,  2729,  -134,  -134,  -134,  -134,
    -134,  2729,  2729,  -134,  1252,  -134,  2729,  3947, -3833, -3833,
   -3833, -3833,   185,   815,   815,   815,   815, -3833,  2369, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, 41823,  3021,  2088,
     -51, -3833, -3833, 41823, -3833, 48544, -3833,  1401, 48544,  2672,
    -153,  3423,   236,   236, -3833, 24688, 24688, 24688, 48544,  2730,
    2585, 30214, -3833, -3833,  1222, -3833,  2681, 14094, -3833,  2684,
   -3833, 11562, -3833, -3833, -3833,  1824, 11562, 11562,  3164,  2737,
   -3833, 40601, -3833, -3833, -3833, 11562, 11562, -3833, 11562, 11562,
   11562, 11562, -3833, 11562, 40601,  2737, 11562, -3833,  2692, -3833,
    3086,  3088, -3833, -3833, -3833, -3833, 11562, -3833, 11562, 11562,
   -3833, 11562, 11562, 11562, 11562, -3833, 11562, -3833, -3833, 16626,
   -3833,  2696,  2699, -3833, -3833, -3833,  2710, -3833, 11562, -3833,
   -3833, -3833, -3833, -3833, -3833, 11562, -3833, 11562, -3833, 11562,
   11562, 11562, 11562, -3833, -3833, -3833, 14727, 11562, 11562,  2715,
   -3833, -3833, 11562, 11562, 11562, -3833, 11562,   241, 11562,  1615,
   11562,  1850, 11562, -3833, 11562, -3833, -3833, -3833, -3833, 11562,
   -3833,  1659, -3833, -3833,  2558, -3833,  1094,  2724, -3833, -3833,
    1629, -3833, -3833,  2707,  2713,  2716, 41823, 11562, -3833, -3833,
   -3833, -3833, -3833, -3833, 16626,   310,  2727, 16626, -3833,  2749,
    3347,  3347,  2197, 11562,  1109,  2749, 11562,  2732,  2734, -3833,
   11562, 48544, -3833, -3833, -3833, -3833, -3833, -3833, 41823, -3833,
   -3833, -3833, -3833,   149, -3833,  2270, -3833,  2370, -3833, -3833,
    1666, -3833, 39379,  2740, -3833,  2745,  2809,  2810,  2816, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2371,  1650, -3833, -3833,  2754, -3833, -3833,  2412,  2838,
    2768,  3094,  3293, -3833, -3833, 48544, 16626, -3833,  3336,  2755,
    2765,  3234,  2767,  2044, -3833,  2848, -3833, -3833, -3833, -3833,
    3065, -3833, -3833, -3833, -3833,   104, -3833, -3833,  2778,  2778,
   20372, -3833, -3833, -3833,  3244,   -64,   -64,   -64, -3833, -3833,
   -3833, -3833,  3038, 39379,  3218,  3224,  3225,  1026, -3833,   403,
   -3833,   192,  3178,  2371, -3833,  3228, 42434, -3833, 30825, -3833,
    2784,  3176,  2788,   815, 35102,   908, 27762, 36935, -3833, -3833,
     806, -3833,   261, -3833, 37546,  3256, 37546, 37546, -3833,  3072,
   -3833, -3833, -3833, -3833,  2585,   193, -3833, -3833, -3833,  2800,
   -3833, -3833,  1123,  3181,  3183, -3833,  3060,   746,  3060,  1123,
    1123, 25918,  1222,  2010, -3833,  2729,  3118, -3833, -3833, -3833,
   41212, 38157, -3833, -3833, -3833, -3833,  3327, -3833,  3328,  1381,
   -3833, -3833,  2714,    21, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2322,
    2714,  2714,  1096, -3833,   134, -3833, -3833, -3833, -3833, -3833,
   26533,  1005, -3833,   204, -3833, 26533, -3833,  1007,  1007, -3833,
   26533,  1005,   806,  2729, 26533,  2729, 46100,  1005,  -134,  -134,
    2284,   815,  2729, -3833, -3833,  3191, 48544,  3192, 26533, 26533,
   -3833, 41823, -3833,   815,  1052,  2729,   806,   806, 26533,  1005,
   25918,   946,  2666, -3833,  -134,  1005, -3833, -3833, -3833, -3833,
   24688,  1005,  1005,  3048, -3833, -3833, -3833,  2729,  2666, 46100,
   -3833, -3833,  4943, -3833, -3833, -3833, 19757, 48544,   964,   189,
   -3833,  2807, 33269,   809,   313,  2896,  1344,  2814,  2822, 46711,
    2044,  2729, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  -134,  2675,  2714,  2714,  1825,
   -3833,  3085,  3247,   815, -3833,  1268, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  2915, -3833,   166,  3006,  2832,
   -3833, -3833,   318, -3833, -3833,  1010, 24688, 19142, -3833,  3068,
   -3833,  2945, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2825,  1222,  3090,  1335,  2585,  2840, -3833, 12195,  1369,
   -3833,  2044, 11562,  2044,  2003, -3833,  2842,  2842,  2842, -3833,
    2843, -3833, -3833,  2842,  3235,  2842,  3237,  2854, -3833,  2857,
   -3833,  1724,  2015, -3833,  1755,  1386,  2048,  1418,  2868,  2874,
    1465, -3833, 11562, 11562,  1451,  1478,  -118,   977,  1035,   340,
   -3833,  1482,  2766, -3833, -3833,  1501,  1506,  1580,  1587,  1068,
    1611,  1761, 12195,  1617,   947,   347, -3833,  1687,  1070,  1075,
    1698, 11562,  1708, 11562,  1712, 11562,  1732,  1734,  1783, -3833,
    1983,  2558, -3833, -3833,  2876, -3833, -3833, -3833, -3833, -3833,
    2855,  2044,  2878, -3833, -3833, 11562, -3833,   895, -3833, -3833,
   16626,   380,  2882, -3833,  2044, -3833, -3833,  2885,  1465, -3833,
   -3833, -3833, -3833, -3833,  2889, -3833, 48544,   823,  2895, 31436,
   39379, 39379, 39379,  2880, 11562, -3833, -3833,  3134, 24688, -3833,
    3275, -3833, -3833, -3833, -3833, -3833,  2886,  2883, -3833, -3833,
   -3833,  2749,  3233,  3129, -3833, -3833,  2675, 48544, 39379, -3833,
   -3833,  2540, 25918, -3833,  2898, -3833,  2898,  1324,  2893,  1771,
   -3833, -3833, -3833,  2903,  2029, 18525,  3330,  2273, 39379, 39379,
   39379, -3833,  2585,  2585,   935,  2942,  3282, -3833, -3833, -3833,
   -3833, 47322, -3833, -3833, -3833, -3833,  1118, 48544,  3265, 48544,
    9030, -3833, -3833,  3460, 11562, 39379,  1116,   772,   815, -3833,
   -3833, -3833, -3833, -3833, -3833,  2371, -3833, -3833, -3833, -3833,
   37546, -3833, -3833, -3833,  2371, -3833,    18,  1837,  -181,  1281,
   -3833,  1082, -3833, -3833, -3833,  3281,  1123,  3060,  3060,  3285,
    3170,   -54,  2911, -3833,   815, -3833, -3833, -3833,  2540, -3833,
   -3833, 11562, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833,  1192, -3833, -3833, -3833, -3833,  2916,
    3292,  3294,  1007, -3833, 26533, -3833, -3833, 26533, 26533,    72,
   46100, -3833, -3833, -3833, -3833, -3833, -3833,  2919, -3833, -3833,
    2675, -3833, -3833, 38157,  -134, -3833, 26533,  2919, -3833, -3833,
     194, -3833,  -134, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, 46100,  2921, -3833,   339, -3833, -3833, -3833, -3833, -3833,
    1745, -3833, 46100, -3833, -3833, 46100, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2929,  2643,  1167,
   -3833,  2926,  2939, -3833, -3833, -3833, -3833, 48544, -3833, -3833,
   24688, -3833, -3833, -3833,  4563, 48544, -3833, -3833, -3833, -3833,
    3158, -3833, 11562, 11562,  3194, 48544,  3197, -3833,  3481, 48544,
    3550, 46100, -3833,  2943, -3833,  2941, -3833,  1796, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  2946, 48544,  2714,  2088, -3833,
   -3833, -3833, -3833,  -134,  1010, -3833, -3833, -3833, -3833,  3211,
    3214, 48544, -3833, -3833, -3833, -3833,  3087, -3833, 24688,  3533,
   -3833,  3119, -3833,  2955,   259,  4688, -3833,  2954,  2958,  2959,
   30214,  2585,  3322, -3833, -3833,  3347, -3833,  2044, 11562,   918,
   -3833, -3833,   274, -3833,   980, -3833, -3833, -3833,  2963, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833,  2445, -3833, -3833, -3833,
    2737, -3833, -3833, -3833,  2964,  3347,  3347, -3833, -3833,  3546,
    3127, 11562, 11562, -3833, 11562, -3833,   199,  2969,  2994, -3833,
   -3833, -3833, -3833, 11562, -3833, -3833,  3347, -3833, 11562, -3833,
   -3833, 11562, -3833, 11562, 11562, -3833,  1878, -3833,  1899, -3833,
    1920, -3833, -3833, -3833,  2329, -3833, -3833,  1083, 48544, -3833,
   -3833,  1826, -3833, -3833, 11562, -3833, 42434, -3833, -3833,  3184,
   -3833, -3833,  3398, -3833, -3833, -3833,  -144,  -144,  -144, 15360,
    2044,  3457, -3833, -3833, -3833,  3275,  3345, -3833,    65, -3833,
   48544,  2977,   703, -3833,  1846, -3833, -3833,  2978, -3833,  1983,
    2979, -3833,   815, 15360,  2778,  3119, -3833, -3833,  1324, 25918,
   30825, -3833, -3833, 39379,  2273,  2273,  2273,  2371,  3404,  2838,
    2838, -3833, 28376, -3833, -3833,  3136, -3833, -3833, 32047, -3833,
     -38, -3833, -3833, 16626,  1589, -3833,  2044, -3833, 41212, -3833,
    2044,   815,  2985,  2986, -3833, -3833, 47933, 11562, -3833, -3833,
   -3833, -3833, -3833,  1629,  2227, -3833,  1222, -3833,  1123, -3833,
    3366,  3370,  1123, -3833, -3833, -3833, 25918,  2585, 15360, -3833,
      88,  1983,  2044,  2991,   339, -3833,  -119, 11562, 26533, -3833,
   -3833, -3833,  2987, -3833, -3833,  3495,  3497, -3833, 26533,  2702,
   48544, -3833,  3460, -3833, -3833, -3833, -3833,  4563, -3833, 25918,
   -3833, -3833, -3833, -3833, -3833, 48544, -3833, 24688, -3833, 19757,
   -3833,  2998, -3833,  2842,  2842,  2842, -3833, -3833, -3833,  2842,
   -3833,  2843,  3230, -3833,  2843,  2843, -3833, -3833, -3833, -3833,
   -3833,   274,  1320, -3833, -3833,   274, -3833, -3833, -3833,   117,
     938,  2843, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2842,
    2842,  2842, -3833, -3833,   274,  2842, -3833,  2842, -3833,  3572,
   -3833,   271,   109,  2842,  2842,  2842,  2963,  2993, -3833,  2044,
    3347,  3545, -3833, -3833,  3147,  -134,  3489, -3833,  1858, -3833,
    3007, -3833, 46711, -3833,  2729,  2322, -3833, -3833, -3833, -3833,
    3145,   950, -3833,  3177,  3008,  3013, -3833, -3833,  -134,  3011,
    3016, -3833, -3833, -3833, -3833,  3629, -3833, 48544, 48544, 48544,
    2681, -3833, 38768, -3833,  1137,  2044,  3020,  3022,  3025,  3027,
    3617,   175, -3833,  3624, 40601, -3833, -3833, -3833,  1866,  3301,
   -3833, -3833,  2842, -3833,  2843, -3833, -3833, -3833,  3600, -3833,
   -3833,  2842,  3420,   274, -3833, -3833,  3033, -3833,  3034,  3035,
   -3833,   186,  3036,  1926,  1087,  1870,  3341,  3416, -3833,  3260,
   -3833,  1947,  1171,  1957,  1981,  1991,  2005, -3833, -3833, -3833,
     794,  1281, -3833, -3833,  1876, -3833,  3400,  3305,   766,  3076,
    3076,  3076,  1589,  2044,  1882, -3833, -3833, -3833, -3833,  3443,
   -3833, -3833,  3056,  3190, 48544, -3833,  3129, -3833,  2329, 25918,
   15360,  3057,  3058, -3833,   688, -3833, -3833,  3051,  2273, -3833,
    3644,  3482, -3833, -3833, 41823,  3063, -3833, -3833,  3368, -3833,
     161,  3278, -3833, -3833, -3833,  1116,  3157,  3159,   815,  2044,
   -3833, -3833,  2592,  2850,  3117,  1123,  1123,  3377,  3128, 11562,
   11562,  3091, -3833,  3090, -3833, -3833,   437,  2329, 11562, -3833,
    2675,  3129, -3833,  2028,  3095,  3097, 48544,  3098,  3099, -3833,
    3561,   964, -3833, -3833, -3833, -3833,  1005, -3833, -3833,  2919,
     104,  3071, -3833, 48544,  3412, -3833, -3833, -3833, -3833,  1062,
   -3833,  3100,  1062,  1062, -3833,  2140, -3833,  3122,   274, -3833,
   -3833,  3138, -3833, -3833, -3833,  1062,  3102,   274, -3833, -3833,
   -3833, -3833,  1062, -3833, 41823,  -134,  2981,  3709, -3833,  3154,
   -3833,  3606,  3483,  3719, -3833,  2731, -3833,  3488,  3386,   815,
   -3833,   274, -3833, -3833,  3711, -3833,   274,  3711,  1062,  1062,
   48544, -3833, -3833, -3833, -3833, -3833, -3833, 48544, -3833,  1135,
   -3833, -3833, -3833,  1887,  -134, -3833, -3833, -3833,  3120,  3121,
   -3833, -3833, -3833,   313, -3833, 48544,  4563, -3833, -3833, -3833,
    5097, -3833,  1147,  1891,   339,  3124,  1902,  1923,  3579,  3297,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, 40601, -3833,
    3711,  3393,  3125, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, 11562, -3833, -3833, -3833, 11562, -3833, -3833,  3430,
    3584, -3833, -3833, -3833, -3833, -3833, -3833,   192,   192, -3833,
   -3833, -3833,  3745, -3833,  3220,  3227, -3833, -3833,  3231, -3833,
   -3833,   129,  2001, -3833, -3833, -3833, -3833, 15360,  3511,  3238,
   -3833, -3833,  3139,  3193, -3833, -3833,   794, -3833, -3833, -3833,
   -3833, 11562, -3833,  3090,  2284, -3833, 28376, -3833, -3833, -3833,
   -3833, -3833,  3143,  3149,  9030,  1083, -3833,  3199, -3833, -3833,
   -3833,  3202,  2044,  2044, 48544,  3322, -3833, -3833,  1007,  1007,
   -3833,   437,   794,   339, -3833,  1927, -3833, 48544, 48544,  1967,
   48544, 48544,   -64,   -64,   -64,  1252,  1252, -3833, -3833, -3833,
     964, -3833,  3547, -3833, -3833,  1982, -3833,   940,  3426, -3833,
   -3833, -3833, -3833,  1062, -3833,   186, -3833, -3833, -3833, -3833,
   -3833,   186, -3833, -3833, -3833, -3833,  1508, -3833, -3833, -3833,
    3437,  3203, -3833, -3833, -3833, -3833, -3833, 33880, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833,  3286, -3833, 54654, -3833, -3833,
     550,  3195, -3833, -3833, -3833,  1723, 48544, 24688,  3194,  3348,
   -3833,  3460, -3833,   688,  3068,  3119, -3833,   854, 48544, -3833,
    3439,   191,  1483, -3833,  3632, -3833, -3833,  3169,  3173,   339,
    2034, -3833, -3833, -3833, -3833,  3668, -3833, -3833, -3833, -3833,
   -3833,   362,  3438,  2729,  2729,  2729,  -102,  2001, -3833, -3833,
    3236, 24688, 16626,  3288, 48544,  1475,  2756, -3833,  1467,   339,
   11562,  2371, 38157, -3833, -3833, -3833, -3833, -3833, -3833, 11562,
    3186, 11562,  3187,  1997, -3833, -3833,  3628,  3628, -3833, -3833,
   -3833, -3833,  2006,  2023, -3833,  2054,  2059, -3833, -3833, -3833,
    3200, -3833, 48544, -3833, -3833, -3833,   277, -3833, -3833,  2062,
   -3833,  2064, -3833,  1508, -3833,  3206, -3833, -3833, -3833, -3833,
   11562,  3651,  3216, 48544,   145, -3833, 55876, 55876, 48544, -3833,
   -3833, -3833, -3833,  6288, -3833, -3833,   608, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  3789, -3833,
    3185, -3833, -3833,  3209,  1138, -3833, -3833, -3833,  4563,  3631,
    1344, -3833, -3833, -3833, -3833,   259,  3215,  2029,  -134,   815,
   -3833,   854, -3833, -3833, -3833,   815,   339,  3217,  3456, -3833,
     191, -3833, -3833, -3833,  1483, -3833, -3833, -3833, -3833, 11562,
   -3833, -3833,  3761, -3833, -3833, -3833, -3833, -3833, -3833,   112,
   -3833, -3833, 25918, -3833, -3833,  2675, -3833,  2073, -3833, -3833,
   -3833,  3299,   815,   815,  3707,  3712,   815,   815,   815,   815,
    3219,  2756, -3833,  3687, -3833, -3833, 11562, -3833, -3833,  2044,
    3447, -3833,  3782,  1281,  2044, 48544,  2044, 48544, -3833, 48544,
    1286, -3833, -3833,  3432, -3833,   854, -3833, -3833,  3129, -3833,
    1009,  1009,   274,   186,   274, -3833, -3833,  2044, 11562, -3833,
   11562,  3253, -3833, -3833,  3667, 48544, -3833, -3833, -3833, -3833,
   11562, -3833, 54654, 54654, -3833, -3833, -3833, -3833,  3829,   688,
    3798,  3492,  3800,  3499, -3833, -3833,  3481,  4563, -3833, -3833,
   -3833, -3833,  2729, -3833, 34491, -3833, -3833,  1449, -3833, -3833,
     339, -3833, -3833, -3833,  3240, -3833,   815,  2284,  3239, -3833,
   -3833, 48544,  3243, -3833,  -134,  -134,   815,   815,  2793,  2793,
    2675, 41823,  3343, -3833, -3833,   815,   339, 48544, -3833,   963,
    3597, -3833,  2077,  2095, -3833,  3826, -3833,  3827,  3246,  3248,
   -3833,   854, -3833,   191,  1483,  2097, -3833,  3871, -3833,   172,
    3516,  3517, -3833, -3833, -3833,  3252,  2044,  2044, -3833,   195,
   -3833, -3833,  3642,  3729, 11562,  2044, 51599,  3250, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, 55265, 11562, -3833,   608,  3789, -3833,  3518, -3833,  3520,
   -3833, -3833, -3833,  3750, 54654, -3833,  3747, -3833,   688, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, 25918, 15360, -3833, -3833,
    3288, -3833,  3266, -3833, -3833,   635, -3833, -3833,  -134,  -134,
   -3833, -3833, -3833, -3833, -3833,  2117, -3833, 41823, -3833, -3833,
    3847,  3849,  3744,  3850,   963, -3833,  -103, -3833, -3833, -3833,
   -3833, -3833, 46711, 46711, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  3321,  3768,   -98,  3298, 11562, 54654, -3833,  3749, -3833,
    3680,  2036,  3625,  3273, -3833,  3272,  2094,  3785, 55876, 55876,
   -3833, -3833, -3833, -3833,  3763, -3833, -3833, -3833, -3833, -3833,
    3459, -3833, -3833,  2120, -3833, 15993, -3833, -3833, -3833, -3833,
   -3833, 41823, -3833,  3343, -3833,  3291,   186,   186,  3867,   186,
   -3833,  3870,  3874,  -103, -3833,  3295,  2122,  1009,  1009, -3833,
   -3833,   230, -3833,   222, -3833,  2044, 52210,  3869, 48544, -3833,
   -3833, -3833, -3833, 11562, -3833, 43045, 52821,  3302, -3833, -3833,
   -3833,  3467, -3833,  3499,  3710,  3782, -3833,  3266, -3833,  3303,
   -3833,  2749,  2756, -3833, -3833,  3300, -3833, -3833,   186, -3833,
     186,   186, -3833, -3833, -3833, -3833, -3833,  -134,  3678, -3833,
     230, -3833, 11562, -3833,  3781,  3399, -3833,  3308, -3833, 54654,
    2159, 54654, -3833, -3833,  3733,  3312,  1103, -3833,  3309, -3833,
   -3833, 54654,  3898,  3597, -3833, 15993,  3316, -3833, 11562,  3317,
    3320, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2044,  3895,
   54654, 48544, 49766,  3512, 53432,  3766, 48544,  4563,  3769,  3771,
   -3833, 54654, -3833,   186,  3727, -3833, -3833,  2044, -3833, -3833,
    3422, -3833, 50377, -3833,  2388, -3833,  3362, -3833, -3833,  3841,
    2449, -3833, -3833, -3833,  3613,  3344, -3833, -3833, 54654, 54654,
   -3833, -3833, -3833, 32658, 11562, -3833, -3833, -3833, -3833, -3833,
    1026,   689, 20987,  3501, 50988, 54043, -3833, -3833, -3833, 28990,
   -3833, -3833, -3833,  3787, -3833,  2044, -3833, -3833, -3833, -3833,
   -3833, 41823,  2138, -3833, -3833, 25918, -3833, 32658, -3833, -3833,
   -3833, -3833, 24071,  3349, -3833,   815, -3833, -3833, 25918, -3833,
   -3833, 15360, -3833, -3833
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3833, -3833, -3833, -3833, -3833,    69, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833,  1714, -3833, -3833, -3833, -3833, -3833,
    1925, -3833,   657, -1783, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,   658,  1546,  3329, -3833,   395, -3833,    56, -3833,
   -3833, -3833, -2855,   -67,  -255, -3833, -3833,   346,    17,  2989,
    -252, -3787, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,   406,   405, -3833, -3833,   213, -3833, -3833, -2740, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833,  -442,  -394,  1806,
   -3833, -3833, -3833,  3962, -3833,  3429, -3833,  1245,  2193, -3833,
   -3833, -3833,  -294,   235, -3833,   237, -3833,   238, -3833,   240,
   -3833,   243,   244,   246,   247, -3833,   248, -3833, -3833,  -397,
   -3833, -3833, -3833, -3833,   249, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,  -267, -3833, -3833,  -111, -3833, -3833,  -264,   250,
   -3833,  -209,   255, -3833,   256, -3833,  -121, -3833,  -117, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  2996, -3833, -3833, -3833, -2213, -3833, -3833, -2335,  2563,
   -3833, -1710, -3833, -3833, -1736, -3833, -3833, -1725,   814, -3833,
   -3833,   -97,  -344, -3833, -1376, -1863, -1859, -3833, -3833, -3833,
   -1951, -1947,  -779,  2296, -1199, -2217, -3833, -3833, -3833, -3833,
     106, -3833, -3833, -2535,  2027,  2572, -3833,  2565, -3833, -3833,
    1126, -3833, -3833,  1307,   617,  1306, -3833,   921,  2736, -1257,
   -3833, -3833, -3833, -3833, -3833, -3833,   -25,   227,  -116, -3833,
   -3289,   625, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3832, -3833, -3833, -3833,  -295, -3833, -3833,  -200, -3833, -3833,
    -247, -3833,    75, -2270, -3833, -3833, -3833, -3833,  2542, -1309,
   -3833,  3548, -3833,  -536,   468,  2063, -2358, -1382, -3833,  -927,
    -923, -2434, -3833, -3833, -3833, -3273,  1076,  1485, -3833,   824,
    2058, -1866, -3833, -3833, -3833, -3833, -3833,  1557, -3833, -3833,
     849, -3833,   842, -3833, -3833, -3833, -3833, -3833,  -249, -3833,
      57, -2012, -3833, -3833, -3833, -2776,  1038,   816, -3833, -3833,
   -3833, -1058, -2774,  -727, -3833,   343, -2469, -2412,   783, -3833,
   -3833,   537, -3702, -3833, -3833,  -577, -2046, -2355,    16, -3833,
   -3833,   551, -3060,   916, -3833, -3833, -3833, -3118, -3169, -3833,
      83, -3833, -3833, -3833, -3833, -2630, -3833, -3833, -1454, -2237,
   -3833, -3833,  4086,  4089, -1033, -2612, -3634,   -10,    -8, -3833,
   -3833, -3833,  2566, -2120,   163,   155,   160,  2019, -1561,   315,
   -2306, -3833,   360, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2099,
   -1127, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -2362,   885,
   -3833, -3833,  1606, -3833, -3833, -3833, -1846,  3146, -3833, -3833,
   -3833, -3833,  3487, -2128, -2577, -3833, -3833, -3833, -3833, -3833,
   -3833,  1348, -3833, -3833,  2224,  2688, -3833, -3833, -3833, -3833,
   -3833, -3833,   612,  1798, -3833, -3833, -3833, -3833, -3833, -3833,
     896,  2603, -3833, -3833, -3833,   -15, -3833, -3833, -3833, -3833,
    2318, -3833, -3833, -3833, -3833,  2647, -3833, -3833, -3833, -3833,
   -3833, -3833,  1404, -3833,  1836, -3833, -1433, -3833, -3833,  1008,
    -982,  1789,  -594,  1921,   359, -3833,  3538, -3833, -3833, -3833,
   -1642, -2386, -3833,  3242,  -822, -2490,  2315,  -552, -1801,  1040,
    1170,  -678,  4040, -3833, -1145, -1141, -3833, -3833,  -647, -3833,
   -3833, -3833, -3833, -3833,  2020,  2024,  -653, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  1444, -3833,
   -3833, -3833, -3833, -1720, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833,  1541, -3833, -2027, -3833, -3833,  -471, -3833,  3023, -3833,
   -3833, -3833, -2250, -1757,  1756,   959, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -2307, -3833, -3833, -3833, -3833,
   -3833,  1942, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -1701,
   -3833, -1770,   303, -3833,   451, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,   -48,   841,   -47, -2845, -1099,  1665, -3833, -3833,
   -1265,  3064, -2036, -3833, -3833, -3833,  1928, -3833, -3833, -3833,
   -3833, -3833,   928, -2538,  2719, -3833, -3833, -3089,  -922, -2241,
    -882, -3833, -1346,  1363,   470, -3833, -1768, -1781,  -508, -2470,
   -1093, -3833,  1668, -3833, -3833, -3833, -3833,  -220, -3833, -3833,
   -3833,   491,  1827, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833,  -547,  -735, -3833,  2080,  2203, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833,  2897,  2849,  1893,
   -3833, -3833, -2521, -3833, -3833,  1857, -3833,   748, -1976, -1804,
    1044, -3833, -3833,  1047, -3122, -3833, -3833, -3833, -3833, -3833,
   -3833,   987, -3833,    19,  3603, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833,  2646, -1050,  3526, -3833, -3833, -3833, -3833, -3833,
   -3833,  2319, -3833, -3833, -3833, -3833, -3833, -3833,  2817,  3620,
    -576, -1295, -3833,  -601,  2791,  2323,  -867, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
    2439,   956, -3833, -3833, -3833, -3833,  2875, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833, -3833,  1081,   -95, -3833,
       4,  -142, -3833,   -60, -3833, -3833, -3833, -3833, -3833,  -238,
   -3833, -3833,  -243,  -673,  -969, -1350,   670, -1773, -2005,  1069,
    2852, -3144,  -687, -1163, -1167, -1914,    37, -3833, -3833,  3365,
      97,   391,  -316,    -6, -2700,  -107,  -606, -3833, -2464, -3833,
   -3833, -3833, -3833,  2385, -3833, -3833, -3833, -3833,  1423, -3833,
   -3833, -3833,  1036, -3833,   756,   529, -3833, -3833,   156,  3663,
   -3833,  2436, -3833, -3833, -3833, -3833, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833, -3833,  2902,  3659,  3339, -3833,
    2947, -3833, -3833, -3833, -3833, -3833,   427, -3833,   607, -2207,
   -1794, -3833, -3833,  2721,   636, -3833,  1545,  -270,  -545, -3833,
   -3833,   425, -3833, -3833,  1540,  3684,  3360, -3833, -3833, -3833,
   -3833, -3833, -2701,  -890, -3833, -3307, -2761, -1669, -3833, -3833,
   -2116, -2935, -3833, -3833, -1021, -3833, -3833, -3833, -3833, -1844,
   -3833, -3833, -3833,    42,  3748,  3751, -3833, -3833,  -177, -3833,
    -150, -3833, -3833, -3833, -3833, -3833, -3833, -3833,  3604, -3833,
   -3833, -3833, -3833,  3607, -3833, -3833, -3833, -3833, -3833,  3610,
   -3833, -3833, -3833, -3833, -3833,  1633, -3833, -3833, -3833, -3833,
   -3833, -3833, -3833, -3833, -3833
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2578
static const yytype_int16 yytable[] =
{
     494,  1039,   952,   956,   868,   539,  1452,  1658,   984,  1361,
     997,  1682,  1592,   538,   555,  1681,   544,   623,  1104,  2307,
    1454,   563,  1082,   492,  2219,  1635,   558,  1553,  1112,  1417,
    2356,  2357,  2035,   570,  1241,  1131,   573,  1866,  1543,  1544,
     570,  1865,  1747,  2522,  1389,  1790,  2340,  2901,   592,  2551,
    2725,  2032,  2957,   796,  3014,  1703,  2846,  1383,  3195,   542,
    2758,  1799,  1711,  3151,  2603,  3022,  1459,  1713,  1714,  1389,
    1460,  1717,  1718,  1719,  1720,  2629,  1722,  1723,  1725,  1727,
    1728,  1729,  1730,  1731,  1162,  1418,  3484,  1166,  2638,  1175,
     612,  1935,  2830,  2008,  1600,  2452,  2447,  1028,  1031,  2339,
    2448,   137,  2520,  1873,  2686,  1053,  1061,  2388,  2639,  3312,
    2410,  2411,  2779,   615,  2897,   494,  2460,   494,   622,   628,
    2464,  1883,  1183,  1184,  1185,  3489,  1069,  2422,  2571,  1886,
    1887,  2479,  2572,   611,  1226,  2712,  2767,  3680,   617,  1225,
     619,  2488,  2821,  3563,  2440,  2441,  3820,  1332,  1913,  2875,
    2831,  3037,  2070,  3524,  3529,  1192,  1193,  3530,  1794,  1948,
    2462,  2463,  3411,  2465,   500,  1294,  2468,  2469,  1192,  1193,
    2472,  2119,  3504,   637,  2435,  2481,  3540,  3531,  2497,  2484,
    2485,  2486,  2487,  3562,   554,  2991,  2491,  2492,  2352,  2494,
    3094,   562,  1192,  1193,   646,  2503,  3616,  1805,  2507,  2508,
    2260,  2510,  3715,  1289,  2404,  3032,  3033,  1294,  2424,  1244,
    2116,  3039,  2080,  3041,  1192,  1193,  2568,  3225,  1192,  1193,
    2569,  2878,   972,  2861,  2862,  1511,  4054,   550,  1192,  1193,
    2989,  2865,  1435,  3016,   917,   918,  3146,  1515,   850,  1192,
    1193,  2443,  3396,  1169,  3688,  2260,  1286, -1945,  1414,  1192,
    1193,  1456,  2869,   118,  1931,  3059,  3968,  1192,  1193,  2555,
    2556,  2557,  2558,  3222,  3370,  3628,  4161,  2869,  1937,  3490,
    3383,  1326,  2532,  3938,  1192,  1193, -1441,  2542,   732,  2319,
    -865,  1456,  2592,  2548,  2549,  1372, -2457,  2397,  2553,  1855,
     638,  3342,  3360,  4279,  1442,  3360,  2320,  2585,  1744,  3418,
    4219,  1032,   667, -1481,  2523,  3361,  1042,  1295,  3361,  3204,
    -529,  1050,  4327,  1456, -1441,  1192,  1193,  1463,  3678,  3362,
    2498,  2300,  3362,  2504,   917,   918,  1192,  1193,  2349,  2076,
     917,   918,  2560,   917,   918,  1927,  2962,  4033,   661,  2575,
    2982,  2983,  -530,   551,  3713,  1856,  4226,  2605,  2815,  1295,
    4254,   136,  1419,  4258,  1516,  4167,  1192,  1193,  1517,  3240,
    2023,   668,  1387,  1192,  1193,  3139,   547,  1931,   588,  1518,
    2682,   120,   583,  4226,  1192,  1193,  1744,  2350,  1948,  1034,
    3460,  4112,  2775,  1429,  1802,  1390,   571,  2790,  2794,  2796,
    2187,  3193,  1049,  2870,  4072,  3769,  1192,  1193,  3771,   973,
     974,  3461,   651,  3837,  2202,  4271,   136,  1536,  1394,  4020,
    3748,  1014,   138,   262,   653,   264,  -433,   497,   498,  3752,
    1170,  1171,   499,  1192,  1193,  2806,  3654,  1599,  1803,  2092,
    1192,  1193,  3462,  2671,  1537,   813,  4272,  1391,   853,  3859,
     584,  1131,  1949,  3768,  3939,  1399,  2593,  1321,  3770,  3194,
    2996,  3806,  3211,  2093,  2301,  1192,  1193,  1430,  1035,  1743,
    1192,  1193,  1051,   548,  1512,   589,  1238,  1909,  1906,  2776,
    4073,  1480,  3241, -1481,  2024,  4354,   756,  4214,  2717,  1928,
    1192,  1193,  2963,  1068,   642,  3342,  3934,  1532,  3809,  2576,
     669,  1624,  1443,  4034,  1625,  1519,  3527,  1533,  1534,  1535,
    2505,  4280,  1110,   622, -2577,   628,  3343,  1055,  1063,  1909,
    3491,  1194, -1766,  1229,  1195,  3799,  4161,   852,  2321,  3199,
    3969,  1857,   809,  2478,  1194,  1868,   628,  1195,  1871,  4220,
    1459,  3205,  3370,  1875,  1460,   848,   947,  3839,  3232,   622,
    3397,   858,  1415,  1745,  1747,  3829,  2879,  3226,  1194,  2772,
    2883,  1195,  1192,  1193,   876,  2997,  1708,  1935,  1716,  1888,
    1889,  3154,  3155,  3156,  2899,  2900,  1332,  1911,  3221,  3024,
    1194,  3223,  3224,  1195,  2910,  1737,  1192,  1193,  1192,  1193,
    2239,  2447,   968,  2446,  1194,  2448,  1931,  1195,   851,  2384,
    3234,  2242,  2773,  1520,  2245,  1194,  1332,  2261,  1195,  1033,
    1459,   987,  2520,  2364,  1460,  1194, -1481,  2871,  1195,  3495,
     622,  3655,  1001,  1194,  2571,  2950,  1195,   655,  2572,  1567,
    1568,  1745,  1373,   612,  3860,  3706,  2008,  3445,  2829,   494,
    1194,  1192,  1193,  1195,   612,  3220,  1026,  2839,   612,   612,
    1192,  1193,  2261,  1040,  1001,   859,  1623,  2302,   622,  3438,
    3650,  3215,  1013,  3328,  1636,  2365,  1638,  3346,  1070,  1071,
    1072,  1949,  2117,  3707,  1077,  1287,  1011,  2894,  1651,  1652,
    1653,  1194, -1441,  2520,  1195,  4399,  1657,  1023,  1767,  2902,
    2524,  1513,  1194,  1192,  1193,  1195,   969,  2322,  1936,  1290,
    2820,  1422,  2070,   817,  2236,  2882,  2594,  2884,  2859,  1750,
    3343,  1067,  2568,  2567,  2895,  1240,  2569,  1592,  1744,  3532,
    2499,   866,  1194,  2780,  1795,  1195,  1132,  2907,  1806,  1194,
    3960,  3487,  1195,  2916,  2918,  3689,   975,   552,   897,  4115,
    1194,  3933,  2863,  1195,  1937, -2457,  3157,  3158,  3029,  2934,
    2918,  3340,  4156,  1192,  1193,  3617,   970,  1172,  1821,  2075,
    3998,  2992,  1194,  1913,  1196,  1195,  1192,  1193,  -865,  2987,
    3848,  2134,  2081,  2979, -2457,  2864,  1792,  1196,  1192,  1193,
    3327,  2082,  3235,  2222,  1189,  2981,  1191,  2872,  2058,  1194,
    1513, -1481,  1195,  1812,  3515,  3516,  1194,  1050,  -529,  1195,
    1872,  1196,  3037,  1192,  1193,  3037,  3037,  3948,  4128, -1481,
    1234,   494,  1236,  4328,  1001,   494,   622,  2135,   494,   622,
    1513,  1194,  3037,  1196,  1195,  4070,  1194,  1196,  1386,  1195,
    -530,  1885,  3187,  2984,  1235,  4282,  3541,  1196,  1239,  2188,
    3654,  1243,  3561,  3564,  3566,  3567,  1194,  3095,  1196,  1195,
    1848,  3363,  2203,  3517,  3363,  3021,  1299,  3518,  1196,  1395,
    1192,  1193,  4096,  1688,  1689,  4021,  1196,  4065,  3208,   612,
     654,  4247,  2807,  1688,  2153,  2730,  3560,  1479,   947,  2076,
    1895,   622,   612,  1196,  2376,  2758,   612,  3537,  3538,  3539,
    2574,   815,  3658,  3509,  1915,  3542,  1400,  1014,  2191,  2192,
    1771,  3474,  4042,  3568,  -433,  3478,  2998,  1192,  1193,  1732,
    3029,  2366,  1310,  3106,  4122,  3037,  4124,   877,  1194,  1192,
    1193,  1195,  3494,  3432,  1196,  1329,  3449,  1539,  1303,   622,
    1626,  1192,  1193,  1627,  3729,  1196,  3116,  3117,  3118,  2208,
    2209,  2535,  1194,  3931,  1194,  1195,  3938,  1195,  1051,  3131,
    2694,  2695,  3299,  1192,  1193,  3705,  3448,  4256,  3473,  1192,
    1193,  1556,  3477,  1745,  2160,  1196, -2525,  3433,  2380,  4437,
    3623,   612,  1196,  1192,  1193,  3136,  1227,   860,  1323,  3626,
    3063,  3064,  2947,  1196,  2223,  1272,  2255,  3080,  3081,  1307,
   -2577,  4175,   872,  1455,  2442,  3351,  2349,  1194,  2409,  2107,
    1195,  2536,  2340,  1192,  1193,  1196,  1194,  2826,  1389,  1195,
    2088,  2447,   504,  2876,  2876,  2448,  2378,  4198,  1822,  2827,
    3103,  3104,   612,   556,   884,  3655,  2383,   601,  2652,  2386,
    2387,  3708,  1196,  3386,  1866,  1423,  1866,  1866,  1389,  1196,
    2811,  2812,  1896,  2319,  3192,   560,  1897,  2571,  2125,  1194,
    2229,  2572,  1195,  3356,  2108,  2339,  2224,  1935,  4043, -1766,
    2320,  1192,  1193,  2745,  1196,  4249,  2607,  3200,  3201,  1196,
    4116, -2525,  1387,   612,   577,  2250,  1556,  1549,  2446,  2255,
    2126,  2429,  2452,  2251,  2915,  2129,   262,  3470,   264,  1196,
    1557,  2244,  3159,  1698,  1192,  1193,  1192,  1193,  2537,  2693,
    2816,  1192,  1193,  2479,  1992,  2130,  1192,  1193,  2795,  1194,
    1772,   585,  1195,  1192,  1193,  3356,  1540,  3939,  1132,  3231,
    1547,  1733,  1194,   732,   586,  1195,  3656,  4200,  1192,  1193,
    1736,  1948,  1132,  1931,  1194,  2568,   885,  1195,  4201,  2569,
    2008,  2430,  2341,  3873,  1734,  1459,  3002,  3078,  2836,  1460,
    1995,  2698,  2699,  2259,  2377,  3841,  4438,  2948,  1424,  1194,
    2219,  1196,  1195,  3869,  1936,  1192,  1193,  1192,  1193,  2431,
    4102,  2960,  4103,  1682,  2538,  2741,  3440,  2131,  3698,  3699,
    1376,  3483,  1683,  1425, -2388,  1196,  1308,  1196,  2293,   602,
    1227,   990, -1788,  2070,   622,  3585,  2393,  2246,  1230,  2567,
    4050,  2133,  4378,  2140,  3586,  1580,  4037,  4038,   886,  2828,
    3357,  4051,  2315,  2316,  2263,  3465,  1194,  1192,  1193,  1195,
    2961,  4379,  2692,  4044,  1804,  1192,  1193,  1948,  1823,  2230,
   -2389,   622,  2702,   604,  1937,  3299,  1740,  1377,  2432,  1773,
    1196,   612,  1192,  1193,  1682,  2903,  4060,  2033,  2834,  1196,
     612,  1304,  4101,  2306,  2225,  1744,  2141,  2449,   861,   873,
    1192,  1193,  3003,  1194,  1378,  2151,  1195,  1192,  1193,  3935,
    1359,  2034,  3357,  2367,  4252,  1194,  1192,  1193,  1195,  1228,
    1192,  1193,  2321,  3657,  1742,  2237,  3358,  1194,   622,   132,
    1195,  1338,  1196,  1192,  1193, -2388,  3658,  1192,  1193,  2075,
    1776,  2256,  1779,  1948,  1735,   612,  3125,  3887,  2152,  1194,
    2573,   605,  1195,  4151,  2433,  1194,   880,   612,  1195,  2904,
     607,   756,  3160,  3921,  2520,   622,  2394,  1835,  3620,  1194,
    1192,  1193,  1195,  1682,   612,   612,  3874,  2914,  3587,  1931,
     630, -2389,  3796,  2395,  4202,  2520,  2512,  1110,  3368,  4462,
    1426,  3360,  1196, -1789, -1788,  2396,   613,  1773,   622,  1194,
    2063,  1825,  1195,  1209,  3361,  1196,  2475,  1917,  2156,  1833,
    2076,   133,   732,  4117,  1037,  1038,  2574,  1196,  3362,  2539,
    2120,   494,   494,   494,   612,   494,   612,   703,  3659,   917,
    3525,  1867,  2936,  2168,  2256,  1192,  1193,  1869,   494,  1836,
     622,  4121,  1196,   494,  1849,  1850,  1851,  2033,  1853,  1783,
    1111,   991,  1192,  1193,  1949,   947,  2905,  1194,  2175,  2580,
    1195,  1870,  4052,   612,   616,  2092,  1874,  1852,  2876,  1854,
    2231,  2034,  1427,  2397,  3875,  1931,   618, -1766,   992,  3112,
    3004,  2581,  3921,  3921,  1192,  1193,  2232,   708,   629,  2093,
    1194,  2322,  1194,  1195,  2563,  1195,  1536,  1194,   635,  1196,
    1195,  1744,  1194,   732,  1532,  1195,  1884,  4118,   622,  1194,
    1866,   881,  1195,  1592,  1379,  2179,  1556,  1192,  1193,  1845,
     631,   120,   612,  1538,  1194,  2028,   612,  1195,  3182,  1837,
    1584,  3359,  2966,  1228,  4119,  2478,  4286,  4001,  2446,  1513,
    1745,  4105,  3694,    43,  1192,  1193,  1196,  2967,  1192,  1193,
    1949,  1931,  4203,  1230,   643, -1789,  3183,   612,  1196,  2434,
    2849,  1194,  2180,  1194,  1195,  2025,  1195,  1192,  1193,  2030,
    1196,  2423,  1192,  1193,  2181,  3936,   622,  3005,   494,   494,
    3533,  2090,   494,  3534,   721,  2398,  2182,  4106,  4299,  4299,
    1585,  1212,  1196,  3359,  1077,  3739,  2106,   646,  1196, -2525,
    1691,  2086,  2087,  1230,  3023,  3102,  2979,  1230,  2186,  1556,
     756,  2215,  1196,  1194,  2204,  3938,  1195,  1947,  1586,   498,
    2477,  1194,  3805,   499,  1195,   854,  1949,  3079,  3921,  3921,
    -198,   572,   642,  3767,  2697,  1682,  1110,  1838,  1194,  3142,
    1895,  1195,  1196,  1380,  4171,  1643,  1192,  1193,  2399,  4372,
    4000,  4374,  3779,  1192,  1193,  1556,  1194,   648,  3061,  1195,
     737,   947,  2567,  1194,  2326,  1381,  1195,  2064,  4190,  4191,
     561, -2388,  1194,  1744,  2850,  1195,  1194,  1192,  1193,  1195,
    4392,  1192,  1193,  1192,  1193,  1132,  2161,  1587,  3740,  1194,
   -1682,  1826,  1195,  1194,  1936,  2264,  1195,  4325,  4326,  1161,
    1196,   756, -2388,  1592, -2525,    57,  3184,  1382,  2634,  4107,
     855,   650,  1112,  1162,  1166,  2640,  3062, -2389,  4424,  4425,
     498,   262,  3921,   264,   499,   639,  1194,  1110,  2646,  1195,
    3741,  3951,  3955,  1196,   662,  1196, -1682,  3921,  1647,  1895,
    1196,  2730,  2101,  2228,   512,  1196,  1745,   805, -2389,  3073,
    3921,  3083,  1196,  1192,  1193,   262,  3084,   264,   849,  3714,
    2124,  2661,  1692,  1588,  1192,  1193,  3197,  1196,  3636,  3980,
    3867,  3868,   581,  2216,  1192,  1193,   582,  3728,  1192,  1193,
     856,   810,  2132,   664,  1669,  2252,  3939,  1244,   501,  3981,
    1165,  1194,  2219,   622,  1195,   612,   622,  2250,  1192,  1193,
    1192,  1193,  1896,  3227,  1196,  3168,  1196,   612,  1194,  2269,
    2154,  1195,  3921,  4264,  3780,  2275,  2275,  3610,  2275,  2142,
    1827,  2143,   665,  3728,  3921,  3921,  3795,   863,   622,  2708,
    2075,   612,   666,   947,  3238,   612,  2573,  3606,  3607,  2574,
    1194,  2326,   869,  1195,  2154,  3244,   871,  1592,  3246,  1192,
    1193,  3642,   622,   622,   612,   612,  1196,  2673,  2274,  2274,
     889,  2274,   891,  1132,  1196,   764,  2275,  2275,  2275,  1472,
    1473,  2150,  3921,  1194,  2298,   964,  1195,   985,  1310,  2164,
    3951,  1196,  3921,  2362,  3955,  1221,  1222,  1223,  1224,  1704,
    1192,  1193,  2373,  2121,  3320,   567,  2165,  1329,  2318,  1196,
    1194,  1896,   567,  1195,  1194,  1897,  1196,  1195,  1530,  2274,
    2274,  2274,  2804,   881,  2169,  1196,  1192,  1193,  1745,  1196,
     986,  2173,   994,  1194,  1361,  3921,  1195,  3921,  1194,   612,
    2174,  1195,  1196,  3188,  2178,   852,  1196,  3921,  2122,  1229,
    3363,  2392,  3190,  2893,  1192,  1193,  1003,  2183,   612,  2988,
    1014,  2195,  1024,  2314,  1043,  1143,  3921,  2063,  3921,  1044,
    3921,  3526,  3296,  2328,  2329,  1192,  1193,  3921,  1589,  1196,
   -1682,  1768,  2385,  1389,  1769,  1160,  3354,  1770,  3921,  3471,
     962,   963,  1389,   966,  2210,  3719,  1192,  1193,  1176,  1177,
    2369,  2403,  1192,  1193,  3921,  3921,  2123,  1229,  1316,  3191,
    1048,  1317,  1194,  3145,  2881,  1195,  3388,  3389,  3585,  1194,
    3921,  3921,  1195,  1192,  1193,  3921, -1682,  3586,  1079,  4064,
    2561,   118,  2606,  1192,  1193,  1080,  2577,  3402,  2908,  2909,
    2127,  2128,  1682,  1194,  1196,  1590,  1195,  1194,  1081,  1194,
    1195,  1918,  1195,  3951,  3955,  2506,  1083,  1192,  1193,  3026,
    1084,  1196,  1866,  1085,  1605,  1919,  3609,  1192,  1193,  1088,
    2521,   975,  1037,  1038,  2630,  2413,  3049,  1089,  1705,  1192,
    1193,  1192,  1193,  1090,  2420,  2421,  1091,  2630,  1092,  1294,
    1232,  1192,  1193,  1196,  3046,  2425,  2426,  2427,  2428,  1682,
    2436,  2437,  2675,  2834,  1192,  1193,  2147,  1229,  3051,  1093,
    1192,  1193,  1192,  1193,  1094,  3965,  3966,  3967,  1931,  1194,
    1192,  1193,  1195,  2234,  1192,  1193,  1196,  3050,  2155,  1229,
    1194,   622,  1682,  1195,  3994,  3995,  2914,   622,  2341,  2578,
    1194,  3057,   494,  1195,  1194,  2157,  1229,  1195,  1095,   612,
     612,   612,  2601,  1196,  1318,  2604,  1229,  1196,  3996,  1096,
    4177,  3587,  1609,  1097,  1194,  2583,  1194,  1195,  3058,  1195,
    1192,  1193,  3065,  1948, -1481,   622,  1196,  2326,  1098,  2690,
    1099,  1196,  1100,  1401,  1101,  2327,  1493,  1494,   622,  2158,
    1641,  3069,  2597,  2598,  2599,  4062,  3070,  1102,  2533,  2534,
    1105,  2541,  3138,  2543,  2544,  2545,  2546,  2547,  2170,  1229,
    2550,  2711,  2552,  1402,  2246,  1194,  3862,  3863,  1195,  3865,
    3866,  1107,  1244,  1244,  1244,  1920,  1108, -1481,  2171,  1229,
    2063,  1295,  1109,  4078,  2064,  1192,  1193,  1113,  4084,  4085,
    1744,  1233,  4088,  4089,  4090,  4091,  2172,  1229,  1209,  3181,
    3497,  3498,  2176,  1229,  4079,  1196,  1194,  1004, -1481,  1195,
   -1481,  1610,  1196,  3519,  3822,  1613,  3522,  3523,  1403,  2573,
    3071,  3571,  1614,  1404,  2700, -1481,  1237,  3072,  1114,  1706,
     622, -1481,  1194,  3535,  3101,  1195,  1196,  1115,   979,   980,
    1196,   981,  1196,   982,  1116,  1707, -1481,  1921,  4294,  2328,
    2329,  3074,  1192,  1193, -1481,  2709,  1294,  3077,  1005,  2065,
    1194, -1481,   622,  1195,  3856,  3857,  1117,  2630,  1248,  2798,
    2803, -1481,   947,  1922,  2563,  1118,   622,  1506,  1507,   917,
     918,  1194,  1682, -1481,  1195,  1119,  3142,  1120, -1481,  2330,
    1121,  1914,  4188,  4189,  2438,  2439,  1122, -1481,   593,  2679,
    1229,  4197,  1194,  1615,  4169,  1195,  2715,  2716,  1194,  2739,
    3023,  1195,  1196,  2845,  2630,  1125,  3823,  3824,  1273,  4192,
    1126,  3825,  3826,  1196,  4373,  1127,  3624,  3082,  1133,  1194,
    1134,  1931,  1195,  1196,  2763,  1923,  1135,  1196,  3085,  1194,
    1136, -1481,  1195,  1137,  2219,  1138,  1006,   622,  3087,  1209,
     947,   594,  3089,   917,   918,  1139,  1617,  1196,  1140,  1196,
    2784, -1481,  2786,  1194,  3045,  2128,  1195,  1405,   622,  1141,
     622,   622,  3091,  1194,  3092,  1144,  1195,  2612,  1867,  1145,
    1867,  1867,  1146, -1481,  2711,  1194,  1212,  1194,  1195,  2277,
    1195,  2278,  1147, -1481, -1481,  3048,  1229,  1194,  1295,  1148,
    1195,  3075,  1229,  2066,  1149,  1683,  1949,  1592,  1196,  1150,
    1194,  3148,  3149,  1195,   622,   622,  1194,  1151,  1194,  1195,
    1152,  1195,   595,  3093,  1924, -1481,  1194, -1481,  -620,  1195,
    1194,  1153,  3633,  1195,  1154,  1745,  3323,  3324,  1406,  2344,
    2345,  2346, -1481,  1938,  1276,  2449,  2868,  2064, -1481,  1196,
    1155,  1209,  1156,  1744,  2521,  1157,  2880,  2450,  1158,  2521,
    1159,  2063,  2890,  2783,  2521,  1275,  3413,  1229,  2521,  1163,
    2889, -1481,  1164, -1481,  1167,  1196,  1194,  1168, -1481,  1195,
    2889,  1174,  2521,  2521,  2911,   622,  3435,  3436, -1481,  4459,
    2922,  1178,  2521,  1618,  1683, -1481,  2924,  2925,  3576,  3577,
   -1481,  1179,  1407,  1196,   612, -1481,  3613,  3621,  1620,   118,
    3637,  1229,  1180,  2889, -1481,  3258,  3651,  1229,  3407,  1277,
    2521,  2946,  3666,  3667,  1196,  1278,  2959,  3782,  2439,  1181,
    1082,  3797,  3798,  2976,  1214,  1215, -1481,  1212, -1766,  3408,
    1182,  1194,  3801,  3798,  1195,  1196,  1231,  2923,  1939,  4409,
    4410,  1196,  1281,  1007,  -620,  1284,  3028,  1244,  1283,   507,
    3409,  1292,   900,  3802,  3798,  1293,  3635,  3861,  3436,  1279,
    3372,  1300,  1196,  3373,  1306,  2891,  2892,  1302, -1481,  1314,
     900,  3374,  1196,  1324,  2429,  1335,  1280,  3641,  1354,  4290,
     612,  2521, -1481,  1337,  1209,  2033,  4406,  3643,  3375,  1356,
   -1481,  2921,  1355,  3395, -1481, -1481,  1196,  3864,  3798,   119,
   -1481,  1359,  1931,   947,  1408,  1370,  1196,  1362,  1008,  2034,
    1009,  3644,  3871,  3872, -1481,  1371, -1481,   120,  1196,  2958,
    1196,  3645,  1375,  3007,  1560,  1561,  1562,  4008,  4009,  1212,
    1196,  3376, -1481,  3414,  2430,  3646,  4013,  3798,  1409,  1387,
   -1481, -1481,  1581,  1196, -1481, -1481,  1396,  1209,  1397,  1196,
    1413,  1196,  2980,  4014,  3798,  1398, -2568,   596,  3716,  1196,
    1416,  4463,  2431,  1196,  3961,  1420,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,  1644,  1214,  1215,  1648,  1421,   597,
   -1481,   901,  1434,   121,  4016,  3798,  1437,  3377,  1745,  4017,
    3798,  2741,  4022,  4023,  4024,  4023,  1665,  1666,  1438,   901,
    1670,  1940, -1481,  4080,  4081,  1440,  -620,  4208,  4009,  1196,
    2269,   598,  1941,  1299,   622,   622,   622,  1208,  2064,  1942,
    1684,  1685,   612,  2449,  1744,  4209,  4009,  4217,  3436,   807,
     808,  2432,  1445,   811,   812,  2450,  2393,   814,  1450,   816,
    1456,  2739,   622, -1481,  2451,  1462,  1683,  4262,  4263,  2177,
    4306,  4307,  4324,  3322,  1464,   902,  1466,  3543,  -620,  1132,
    1515,  1469,   622,   622,   622,  3124,   122,   599,  4451,  4452,
    1470,  2616,  1212,   902,  1196,  3167,  3880,  1214,  1215,  1474,
    3592,  3169,  3880,  3171,  3618,  3378,  2630,  1477,  3379,   622,
    1478,  2429,  1481,  2065,  2917,  3746,  3747,  2617,  1482, -1481,
    1584,  1483,  3544,  1524,  1867,  1682,  1525,  2433,  3750,  4076,
    1526,  1943, -1481,  3545,  1529,  3753,  1531,  1217,  1218,  1219,
    1220,  1221,  1222,  1223,  1224,  3813,  3814,  1209,  1672,  1673,
    1532, -1481,  -620, -1481,  1227,  1212,  1550,   507,  3982,  1584,
    1556,  3772,  3773,  3452,  3453,  1552,  3983,  3420,  3421,   510,
    1563,  2430,  2618,  1583,  2429,  2619,  1172, -1481, -1481,  3546,
    1585, -1481, -1481,  2620,  1594,  3380,  2394,  1629,  2521,  1640,
    3984,  2521,  2521,  2033,  2889,  3664,  3665,  1516,  3166,  2431,
    2621,  1517,  1592,  2395,   947,  1641,  1642,   622,  1586,  1680,
    2521,  1209,  1518,   123,  1690,  2396,  1715,  2034,  1699,  1585,
    1721,  1748,  1741,  1944,  1749,  2889,  1752,  1755,  1209,  1756,
     525,  1759,  1762,  1757,  2430, -1766,  2889,  1764,  1584,  2889,
    1218,  1219,  1220,  1221,  1222,  1223,  1224,  2851,  -620,  1210,
    1758,  1760,  1761,  1765,  1788,  1800,   262,  2066,   264,  1791,
    1808,  3250,  2431,  1809,   612,  1810,   566,  1811,  2432,  3307,
    1815,  1818,  1211,   262,  2393,   264,  1819,  1587,  1820,   494,
    1829,   124,  1834,  3317,  1843,  2889,  1847,   526,  1876,  1745,
    1878,  1964,  1965,  2397,  1877,  1879,  1881,  1890,  1585,  2622,
    3326,  1892,  3313,  1214,  1215,  -786,  3985,  3251,  1894,  1907,
    1916,  3233,  3381, -2568,   527,  3337,  2852,  1592,  2020,  3236,
    2559,  1513,   612,  2038,  -769,  -769,  2851,  1967,  2449,  1682,
    3066,  2432,  2434,  4076,  3350,  1212,  -769,   676,  1519,   125,
    1247,  3382,  2039,  2037,  2433,  2040,  2041,  1970,  2042,   528,
    2043,  2044,  2045,  1588,  2046,  1971,  1037,  1038,  2047,   903,
     904,   905,   906,   907,   908,  3339,  -620,  1361,  2048,  1112,
    1162,  1166,  2049,  2050,  4123,  3457,   909,   903,   904,  1973,
     906,  2051,   908,  3986,  1219,  1220,  1221,  1222,  1223,  1224,
    2052,  2845,  2853,  1456,   909,  2852,  1974,   529,  3882,  1212,
    2623,  3987,  1037,  1038,  2394,  2398, -2568,  2433,  3548,  2057,
    3329,  2053,  3412,  2054,  3549,  2055,  1212,  2056,  2109,  3722,
    2784,  2395,  2059,  2077,  1979,  3988,   703,  3842,  2078,  2085,
    2098,  2095,  1213,  2396,  4311,  2096,  1520,  2475,  3832,  2104,
    2097,  2110,  2112,  2138,  2739,  1217,  1218,  1219,  1220,  1221,
    1222,  1223,  1224,  2926,  3550,  2927,  2113,   510,  2114,  2137,
    2139,  2144,  2145,  2763,  3447,  2146,  2159,   622,  2399,  2148,
    2154,  2853,  2163,  2227,  2220,  2167,   622, -1170,  2033,   707,
    2184,  2185,  2709,  1214,  1215,  2190,   708,   262,  2193,   264,
    2194,  2205,   622,  2206,  2207,  1982,  2928,  1216,  2233,  1224,
    2362, -1307,  2034,  1983,  2162,  2243,  3923,  2272,  2166,  2290,
    2265,  2397,  2299,  2305,   712,   713,  2308,  2929,  1984,   -65,
    1683,  2311,  3551,  2783,   530,  4025,  2342,  2343,  2358,  2370,
    2189,  1339,  2521,  3696,  4311,  2374,  -620,  2372,  2375,  2379,
    2624,  1340,  2521,  2402,  2889,  1209,  2401,  1214,  1215,  2434,
    2405,  2406,  2930,  1683,  1199,  1200,  2408,  1341,  1589,  2889,
    2412,   612,  2419,  2521,  1214,  1215,  2414,  2449,  2415,  1342,
    1343,  1344,  1985,  2471,  2470,  1682,  2473,  2630,  2416,  4444,
    3993,  2461,  2480,   721,  2417,  1345,  2474,  2418,  2466,  1201,
    1986,   947,   531,  2467,  2483,  2482,  2490,  2854,  1682,  2489,
    1202,  2525,  4455,  2495,  2625,  1682,  2496,  3989,  2529,  4444,
    2531,  1682,  2434,  2501,  2502,  4455,  2509,  4316,  4317,  2562,
    4319,  2584,  2279,  2398,  3552,  1217,  1218,  1219,  1220,  1221,
    1222,  1223,  1224,  2626,  2610,  2602,  2976,  2476,  2606,  2615,
    1203,   506,  2641,   732,  2280,  1990,  2642,  1991,  2643,  2653,
     532,  2477,  1204,  2251,  3756,  1993,   533,  2281,   736,   737,
    2654,  3605,  3605,  3605,  2687,  2666,  1867,  3685,  2282,  4362,
    2688,  4363,  4364,  2689,  2685,   534,  2854,  2696,   622,  1205,
    2720,  2721,  2705,  1192,  1193,  2706,  2399,  2722,  2734,  1217,
    1218,  1219,  1220,  1221,  1222,  1223,  1224,  2718,  2731,  2733,
     535,  2735,  2719,  2742,  2743,  2728,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,  1795,  2746,  2747,   536,  2283,  2748,
    2284,  2749,  1961,  1999,   507,  2765,  4163,  2753,  2766,  1962,
    2768,  1963,  3573,  1212,  4403,  3993,  2769,  2770,  1206,  2350,
    2349,  2787,  1964,  1965,  2788,  2789,  2810,  2285,  3674,  2931,
    2813,  2817,  2822,  1683,  2823,  3597,  2824,  2845,  4436,  2840,
    -817,  2847,  2848,  2969,  2955,  2896,  2898,  2965,   622,  1964,
    1965,  2971,  2986,  1966,  2985,  2990,  2994,  1992,  1967,  1968,
    2000,  2995,  3020,  1909,  2105,  1969,  1601,  1602,  1603,  1604,
    1605,  3029,  3034,  2932,   868,  1346,  2001,  3040,  1970,  3042,
    2002,  2393,  -769,  -769,  3043,  1967,  1971,  3044,   508,  2286,
    3605,  3731,  3098,  1347,  -769,  3109,  1972,  3121,  3052,  2003,
    3842,  3126,  1316,  4165,  3053,  1970,  3096,  3736,  3100,  3119,
    1973,  2630,  3105,  1971,  3130,  3108,  3129,  2005,  3133,  3114,
    3164,   756,  3153,  3147,  1456,  3723,  3165,  1974,  3724,  3144,
    3170,  3178,  3198,  3203,  1975,  1976,  3202,  1973,   622,   762,
    3150,  1977,  3206,  2287,   764,  3217,  3218,   765,  3219,  1978,
    3230,  1456,  3239,  -892,  1974,  1979,  3248,  3311,  3247,  3308,
    3314,  1214,  1215,  3315,  3774,  1606,  1607,  1608,  1609,  3319,
    3249,  3778,  3322,  3321,  3332,  3325,  3015,  3333,  3338,  3457,
    -443,  1918,  1979,  3347,  1980,  3341,  2326,  3348,  3349,  3337,
    3352,  -628,  3369,  3390,  3387,  1919,  3391,   676,  3543,  3398,
    3399,  3417,  3416,  3725,  3726,  3426,  3428,  3431,  3437,  3450,
    3439,  2394,   622,  3458,  3466,  3467,  3496,  3475,   262,  1348,
     264,  3476,  3488,  3499,  1981,  3500,  1982,  3513,  2395,  3520,
    3570,  2523,  3572,  3574,  1983,  4160,  3584,  3580,  3594,  3593,
    2396,  3598,  3755,  3544,  3595,   262,  3599,   264,  3601,  1984,
    3611,  3615,  3612,  1982,  3545,  3613,  4163,  3614,  3619,  3622,
    3625,  1983,  3627,  3629,  3630,  3631,  3634,  1610,  3638,  1611,
    1612,  1613,  3639,  3640,  1349,  3653,  1984,  3652,  1614,  3722,
     622,  3783,  3662,   509,  3669,  3670,   703,  3679,  3168,  3667,
    2586,  3681,  1350,  3682,  3686,  3687,  3690,  3692,  3854,  3693,
    3546,  3734, -1396,  1985,   510,  1219,  1220,  1221,  1222,  1223,
    1224,  3605,  3605, -1401,  3605,  3605,  3737,  3560,  2397,  1194,
    3704,  1986,  1195,  3759,  3717,  1987,  3718,  3720,  3721,  3745,
    1985,  3751,  3760,  3749,  3761,  2630,  3993,  3762,  3763,   707,
    3700,   511,  3765,  3766,  -535,  3563,   708,   512,  1986,  3803,
    3784,  3807,  3785,  3800,  3804,  1920,  3621,  3811,  3812,  1615,
    3817,  3889,  3815,  4358,  1988,  3830,  4433,  3818,  3834,  1989,
    3547,  3819,  3831,  3845,   712,   713,  1990,  1250,  1991,  3846,
    3928,   612,  3835,   513,  3850,  1992,  1993,  3852,  3870,  3876,
    3883,   514,  3605,  3884,   262,  3890,   264,  3947,  3932,  3958,
    4433,  3924,  3957,  1990,  3959,  1991,  3962,  4028,  3964,  3975,
    1251,  1616,  1617,  1993,  3972,  4005,  4007,  1994,  4010,  -309,
    4046,  4055,  4071,  4048,  3929,   612,  -786,  1921,  3979,  4018,
    2398,  1995,  1996,  1997,  1998,  4026,   622,  4358,   821,  4049,
    4067,  4083,  4233,   721,  4086,  4059,  4095,  4066,  4092,  4087,
    1037,  1038,  4097,  1922,  1999,  4099,  4128,  4233,  2950,  4131,
    -327,  4157,  4158,  4159,  3888,  4194,  4019,  4206,  3973,  4179,
    4243,  4176,  4182,  4210,  4211,  4212,  4218,  4213,  1252,  4221,
    4222,  1999,  4223,  4229,  4230,  4234,  4242,  4032,  4240,   803,
    4241,  4245,  4039,  2399,  4266,  4252,  4267,  4269,  4268,  4277,
    4278,  4282,  1253,   732,  4287,  4289,  1254,  4461,  4292,  4291,
   -2302,  2000,  4295,  4301,  4318,  1923,  4304,  4320,   736,   737,
    4315,  4321,  4336,  1037,  1038,  4323,  4350,  2001,   822,  3548,
   -1565,  2002,  4366,  4352,  4355,  3549,  4369,  4349,  2000,  4371,
    1255,  4375,  4370,  4376,  4380,  4383,  4386,  4388,  4391,  1618,
    2003,  4389,  4395,  4404,  2001,  2004,  4397,   823,  2002,  4400,
    1256,  4401,  1196,  1619,  1620,  4408,  1683,  4412,  2005,  4414,
     824,  4421,  4041,  4422,  1257,  3550,  4445,  2003,  4449,  2713,
    4458,  3582,  2554,  3583,  4193,  2860,  4056,  1060,  3788,  4166,
    4302,  1468,  4233,   825,  4303,  2005,   826,  3786,  3927,  3854,
    3790,  3854,  4348,  4104,  1924,  4456,  4416,   827,   580,   959,
    3152,  2334,  3901,  4426,  3902,  3904,  4333,  3905,  4227,  4334,
    3907,  3908,  1258,  3909,  3910,  3911,  3912,  3915,   828,  4132,
    4300,  -892,  3916,  3917,  4239,  4061,  1960,  4238,  1528,  2254,
     803,  4058,  2513,  3551,  1259,   803,  3243,  2006,  2031,  3132,
    3672,  3430,  2587,  3137,  1798,   829,  4181,  4382,  4173,  3974,
    4385,  3675,   830,  4314,  4251,  4357,  4094,   663,  3794,  2062,
    3330,  2511,  3013,  3512,  2518,  3979,  2952,  3501,  4233,  3505,
    4233,  4367,   803,  4125,  3384,   622,  3878,  4402,  3528,  3569,
    2711,  4199,  3764,  4178,  3464,  3754,  4110,   521,  4233,   803,
     522,   756,   831,  4215,  4063,  3723,  4216,  2094,  3724,  4069,
    4068,  3881,  2596,  3946,  2515,  3503,  2390,  1436,  2940,   762,
    1012,  1893,  3733,  2750,   764,  3502,  2060,   765,  2317,  2029,
    4233,  4233,  3123,  3427,  2729,  4448,  2771,  2684,  3922,   983,
     803,   803,   803,   803,  2348,  3552,  3415,  1260,  2633,  2631,
    3107,  1639,   803,  1366,  4313,  3472,  1261,  2683,  2835,  1250,
    4012,  4172,  3858,  3581,  4275,  1582,  4276,  3507,  1910,  4407,
    1683,  1262,  2703,  3189,  1490,  3855,  2935,  3844,  2600,  2778,
    1813,  4186,  4187,  3725,  3726,  2727,  2756,  3677,  3443,  1263,
    3442,   622,  1251,  3482,   971,  4248,  2103,  1078,  1782,   955,
    2381,  2266,  1859,  3511,  1882,  2382,  2976,  2976,  4270,  3429,
    4353,  4384,  1817,  4322,  4457,  4460,  3758,  1832,  3446,  2359,
    3186,  3691,  3468,  3847,   820,   821,   879,  2304,  1264,  1265,
     896,   832,  1353,   803,  1491,  1492,  1493,  1494,  1495,  1496,
    1775,  1497,  1498,  1499,  1500,  1501,  1502,  1503,  3963,  1504,
    1505,   834,  3971,  2084,  1266,   622,   898,  1824,  1358,   835,
    1252,  3111,  1064,   657,     0,  1065,   658,   836,  1066,     0,
       0,     0,     0,   498,     0,     0,  1267,   499,     0,     0,
       0,     0,  4338,     0,  1253,  4259,  4260,     0,  1254,  4346,
       0,     0,   837,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   838,   839,     0,     0,     0,
       0,     0,     0,     0,     0,   822,     0,     0,     0,     0,
       0,     0,  1255,     0,     0,  1268,     0,     0,     0,     0,
       0,     0,     0,     0,  4450,     0,     0,     0,     0,     0,
       0,     0,  1256,     0,   823,     0,     0,     0,     0,     0,
     840,     0,     0,     0,     0,     0,  1257,   824,     0,     0,
       0,     0,     0,     0,     0,  4393,     0,     0,     0,     0,
    4398,     0,     0,     0,     0,     0,     0,  1506,  1507,     0,
     825,   841,     0,   826,     0,     0,     0,     0,     0,   803,
       0,     0,     0,     0,   827,     0,     0,     0,     0,     0,
       0,     0,     0,   842,  1258,   843,     0,  4434,     0,     0,
       0,     0,     0,     0,     0,   828,  1683,     0,     0,     0,
       0,     0,     0,     0,  4365,     0,  1259,     0,     0,     0,
       0,     0,     0,     0,     0,   622,     0,     0,     0,  1683,
       0,  4434,   829,     0,   803,   803,  1683,     0,     0,   830,
       0,     0,  1683,   803,   803,   803,   803,   803,   803,   803,
     803,   803,   803,   803,   803,   803,     0,     0,  1601,  1602,
    1603,  1604,  1605,   803,   803,     0,   803,     0,   803,     0,
       0,     0,   803,     0,     0,   803,   803,   803,   803,   831,
     803,   803,   803,     0,     0,     0,     0,     0,     0,   803,
     803,     0,   803,   803,   803,   803,   803,   893,   821,   803,
     803,   803,   803,   803,   803,   803,   803,   803,   803,   803,
       0,     0,   803,   803,     0,     0,   803,     0,     0,  1260,
     803,     0,   803,   803,     0,     0,     0,     0,  1261,     0,
       0,     0,     0,     0,     0,     0,   803,   803,     0,     0,
       0,     0,     0,  1262,   803,     0,     0,     0,     0,     0,
       0,   803,   803,   803,     0,   803,     0,  1606,  1607,  1608,
    1609,  1263,   803,   803,   803,     0,   803,   803,   803,   803,
     803,     0,   803,   803,   803,   803,   803,   803,   803,   803,
       0,     0,     0,   803,   803,     0,  3252,  3253,   822,     0,
       0,     0,  3254,     0,  3255,     0,  3256,  3257,     0,     0,
    1264,  1265,     0,     0,     0,     0,     0,     0,   832,     0,
       0,     0,   833,  3258,     0,     0,     0,   823,     0,     0,
       0,     0,     0,     0,     0,     0,  1266,     0,   834,     0,
     824,     0,     0,     0,     0,     0,   835,     0,     0,     0,
       0,     0,     0,     0,   836,     0,     0,     0,  1267,     0,
       0,     0,     0,   825,     0,     0,   826,     0,     0,  1610,
     803,  1611,  1612,  1613,     0,     0,     0,   827,  3259,   837,
    1614,  3260,     0,     0,     0,     0,     0,     0,     0,  3261,
       0,     0,   838,   839,     0,     0,     0,     0,   828,     0,
       0,     0,     0,     0,     0,     0,  3262,  1268,     0,     0,
       0,     0,     0,     0,  1964,  1965,     0,     0,     0,     0,
    1086,     0,     0,  3263,     0,   829,     0,     0,     0,     0,
     803,     0,   830,     0,     0,     0,     0,   840,   803,     0,
       0,     0,     0,     0,     0,     0,     0,  3264,     0,  3265,
    1967,     0,     0,     0,     0,     0,     0,  1124,     0,     0,
       0,  1615,  3266,  3267,     0,     0,     0,     0,   841,     0,
    1970,     0,   831,     0,  1142,     0,     0,     0,  1971,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     842,     0,   843,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1973,     0,     0,  3268,     0,     0,     0,     0,
       0,     0,     0,  1616,  1617,     0,  1456,     0,  1186,  1974,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3269,     0,     0,     0,     0,     0,
    2019,     0,     0,  3270,  3271,     0,  3272,  1979,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3273,  3274,  3275,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3276,  3277,  3278,     0,     0,
       0,   832,     0,  3279,     0,   894,  3280,     0,  1315,     0,
     262,     0,   264,     0,     0,     0,     0,     0,  1982,     0,
       0,   834,  3281,  3282,     0,     0,  1983,     0,   803,   835,
       0,     0,     0,     0,     0,     0,     0,   836,     0,     0,
       0,  1984,     0,     0,     0,     0,     0,     0,     0,  2938,
       0,  1618,     0,     0,     0,     0,  1962,     0,  3283,  3284,
       0,     0,   837,     0,     0,  1619,  1620,     0,     0,  1964,
    1965,     0,     0,     0,     0,   838,   839,     0,     0,     0,
       0,     0,     0,  3285,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1985,     0,     0,     0,     0,
    1966,     0,     0,     0,     0,  1967,     0,     0,     0,     0,
       0,     0,     0,  1986,     0,     0,     0,     0,     0,     0,
     840,     0,     0,     0,     0,  1970,     0,     0,     0,     0,
       0,     0,     0,  1971,  3286,     0,     0,     0,  3287,     0,
     803,   803,   803,  1972,     0,     0,     0,     0,     0,     0,
    3288,   841,     0,     0,   803,     0,     0,  1973,     0,     0,
       0,     0,     0,     0,  1489,     0,     0,     0,  1990,     0,
    1991,  1456,     0,   842,  1974,   843,     0,     0,  1993,     0,
     803,  1975,     0,     0,     0,     0,   803,     0,  2939,   803,
       0,   803,     0,     0,     0,     0,  1978,   803,     0,   803,
     803,     0,  1979,     0,  3289,     0,     0,  3290,     0,     0,
    3291,  3292,  3293,  3294,     0,     0,     0,     0,     0,  1554,
    1555,     0,     0,  1964,  1965,     0,     0,     0,  1565,  1566,
       0,  1980,  1569,  1570,  1571,  1574,  1575,  1576,  1577,  1578,
    1579,     0,     0,     0,     0,     0,  1999,     0,  1595,  1596,
       0,  1597,     0,  1598,  3295,  3296,  -769,  -769,     0,  1967,
    1631,  1632,  1633,  1634,     0,   262,  1637,   264,  -769,     0,
     803,     0,     0,  1982,  1645,  1646,     0,  1649,  1650,  1970,
    3297,  1983,     0,     0,  1654,  1655,  1656,  1971,     0,  1659,
    1660,  1661,  1662,  1663,  1664,     0,  1984,  1667,  1668,     0,
       0,  1671,     0,  2000,     0,  1674,     0,  1678,  1679,     0,
       0,  1973,     0,     0,     0,     0,     0,     0,     0,  2001,
       0,  1686,  1687,  2002,     0,  1456,     0,     0,  1974,  1695,
       0,     0,     0,     0,     0,     0,  1700,  1701,  1702,     0,
       0,     0,  2003,     0,     0,     0,     0,     0,     0,     0,
    1985,     0,     0,     0,     0,     0,  1979,     0,     0,     0,
    2005,     0,     0,     0,     0,     0,     0,     0,  1986,  1738,
       0,     0,  1987,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1989,     0,     0,   262,
       0,   264,     0,  1990,     0,  1991,     0,  1982,     0,     0,
       0,     0,     0,  1993,     0,  1983,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1785,     0,     0,     0,     0,
    1984,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2019,     0,     0,     0,     0,     0,  1996,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1999,     0,   803,  1985,  1831,     0,     0,     0,     0,
       0,     0,     0,  1846,     0,     0,     0,     0,     0,     0,
       0,     0,  1986,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2019,     0,  2000,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,  2001,     0,   803,  1990,  2002,  1991,
       0,   803,   803,     0,     0,     0,     0,  1993,     0,     0,
     803,   803,     0,   803,   803,   803,   803,  2003,   803,     0,
       0,   803,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   803,     0,   803,   803,  2005,   803,   803,   803,   803,
       0,   803,     0,     0,   803,     0,     0,     0,     0,     0,
       0,     0,     0,   803,     0,     0,     0,     0,     0,     0,
     803,     0,   803,     0,   803,   803,   803,   803,     0,     0,
       0,   803,   803,   803,     0,  1999,     0,   803,   803,   803,
       0,   803,     0,   803,     0,   803,     0,   803,     0,   803,
       0,     0,     0,     0,   803,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,   803,
       0,     0,   803,  2115,     0,     0,     0,     0,   803,     0,
       0,   803,  2000,     0,     0,   803,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2001,     0,
       0,     0,  2002,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2003,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2005,
       0,   803,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       1,     0,     2,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2197,  2199,  2201,     3,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     6,     0,     0,
       0,     0,     0,     0,     7,     0,     0,     0,     0,     8,
       9,     0,     0,     0,     0,  2235,     0,     0,     0,     0,
       0,     0,     0,     0,  2240,     0,  2241,     0,     0,     0,
       0,    10,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2858,     0,     0,
      11,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2858,  2858,     0,     0,     0,
       0,    12,     0,     0,     0,     0,     0,     0,     0,    13,
      14,    15,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    16,    17,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    18,  2313,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,  2019,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,     0,     0,     0,    22,     0,     0,     0,    23,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2858,  2858,    24,     0,    25,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    26,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2019,     0,     0,     0,
      27,     0,     0,     0,    28,     0,     0,     0,     0,     0,
       0,     0,     0,   803,     0,     0,     0,   803,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   803,   803,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   803,     0,     0,
       0,     0,     0,     0,     0,     0,   803,     0,   803,     0,
     803,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    29,     0,     0,     0,     0,
     803,     0,     0,     0,     0,   803,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,    31,     0,  2530,     0,
       0,     0,     0,     0,     0,     0,     0,    32,     0,   803,
       0,     0,     0,     0,     0,     0,     0,     0,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      34,     0,     0,    35,     0,    36,     0,     0,    37,     0,
       0,    38,    39,     0,     0,     0,     0,     0,     0,    40,
       0,    41,     0,     0,     0,     0,     0,  2609,    42,     0,
       0,  2611,     0,     0,    43,   803,  2613,  2614,     0,   803,
       0,     0,    44,     0,     0,  1571,  2632,    45,  1571,    46,
    2635,  2636,    47,  2637,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2644,     0,  2645,     0,
       0,  2647,  2648,  2649,  2650,     0,  2651,    48,     0,     0,
       0,    49,     0,     0,     0,     0,   803,     0,  2655,     0,
       0,     0,     0,     0,     0,  2656,     0,  2657,     0,  2658,
    2659,  2660,     0,     0,     0,     0,  2663,  2664,  2665,     0,
       0,     0,  2667,  2668,  2669,     0,  2670,     0,  2672,     0,
    2674,     0,  2676,     0,  2677,     0,    50,     0,     0,  2678,
       0,     0,     0,     0,     0,     0,     0,     0,    51,     0,
       0,     0,    52,     0,     0,    53,     0,  2691,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2701,     0,     0,  2704,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     1,     0,     2,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,   803,   803,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     6,     0,
       0,     0,     0,     0,     0,     7,     0,     0,     0,     0,
       8,     9,  2858,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    10,     0,     0,     0,     0,     0,     0,     0,
    2019,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    11,     0,   803,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,     0,     0,     0,     0,     0,     0,     0,
      13,    14,    15,     0,     0,     0,   803,   803,     0,   803,
       0,     0,    16,    17,     0,     0,     0,     0,   803,     0,
       0,     0,     0,   803,     0,     0,   803,     0,   803,   803,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    19,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   803,
       0,     0,     0,     0,     0,    20,     0,     0,     0,     0,
       0,     0,     0,     0,   803,     0,     0,     0,     0,     0,
       0,    21,     0,     0,     0,     0,    22,     0,     0,     0,
      23,     0,     0,     0,     0,     0,     0,     0,   803,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    24,     0,    25,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   803,     0,
       0,     0,     0,    26,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,     0,
       0,    27,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,   803,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3025,     0,
       0,     0,  3027,     0,     0,     0,    29,     0,     0,     0,
       0,     0,     0,     0,  3559,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,     0,     0,    31,     0,     0,
       0,     0,  3055,  3056,     0,     0,     0,     0,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    33,
       0,     0,  3076,     0,     0,     0,     0,     0,     0,     0,
       0,  3086,     0,  3088,     0,  3090,     0,     0,     0,     0,
       0,    34,     0,     0,    35,     0,    36,     0,     0,    37,
       0,     0,    38,    39,     0,     0,     0,     0,     0,     0,
      40,     0,    41,     0,     0,     0,     0,     0,     0,    42,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,    44,  3120,     0,     0,     0,    45,     0,
      46,     0,     0,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,    49,     0,     0,   803,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3176,     0,     0,     0,  3180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   803,   803,     0,    50,     0,     0,
       0,     0,     0,   803,     0,     0,     0,     0,     0,    51,
       0,     0,     0,    52,     0,     0,    53,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,     0,     0,
       0,  3212,     0,     0,     0,     0,     0,   915,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   872,   916,     0,
       0,    55,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    57,     0,     0,
    3559,     0,   917,   918,     0,     0,     0,     0,     0,     0,
     919,     0,     0,     0,     0,   920,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   921,     0,   922,  2019,   923,     0,     0,     0,
       0,     0,     0,     0,     0,   924,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   803,     0,     0,
       0,   803,  3309,  3310,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1766,   925,     0,     0,     0,     0,   926,     0,     0,
     927,     0,   803,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   928,     0,   929,   803,
       0,     0,     0,     0,     0,   930,     0,   931,  3355,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   932,   933,   934,     0,     0,     0,     0,     0,
       0,  3393,  3394,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3401,     0,   935,     0,     0,  3403,     0,
       0,  3404,     0,  3405,  3406,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   936,     0,     0,
       0,     0,  3919,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3423,
       0,     0,  3945,     0,   937,     0,  3945,  3945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3423,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   803,     0,     0,
       0,     0,     0,     0,     0,   803,     0,     0,     0,     0,
       0,     0,     0,     0,   803,     0,   803,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3469,     0,     0,
     938,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3423,     0,
       0,     0,     0,     0,     0,   803,   939,  3493,     0,     0,
       0,  3919,  3919,     0,     0,     0,     0,   940,   941,     0,
       0,   942,   943,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   944,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3945,     0,     0,     0,
       0,     0,     0,     0,     0,  3945,     0,     0,     0,  3945,
       0,     0,     0,     0,   803,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   945,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   946,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   803,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2332,     0,     0,     0,   947,     0,
    3945,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   803,     0,   803,   948,   949,     0,     0,
       0,     0,     0,     0,     0,   803,     0,  3919,  3919,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4174,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   950,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2332,     0,     0,     0,
       0,     0,     0,     0,   951,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3945,     0,  3945,  3945,
    3423,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   803,
       0,  3919,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3919,   803,     0,  3702,
    3703,     0,     0,     0,     0,     0,     0,     0,  3212,  3919,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     803,  3919,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3919,  3919,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     803,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3919,     0,     0,     0,     0,     0,     0,   803,     0,
       0,  3919,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3212,     0,     0,     0,  3810,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   803,     0,     0,
       0,     0,     0,     0,  3919,     0,  3919,  3423,     0,     0,
       0,     0,     0,     0,     0,     0,  3919,     0,     0,     0,
     803,  3212,     0,   803,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3176,  3919,     0,  3919,     0,  3919,
       0,     0,     0,     0,     0,     0,  3919,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3919,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3919,  3919,     0,     0,     0,     0,   803,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3919,
    3919,     0,     0,     0,  3919,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   803,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3999,     0,     0,     0,     0,     0,     0,     0,     0,  4004,
       0,  4006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4027,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4126,     0,
    4127,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4135,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3423,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4285,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4340,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4368,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4387,     0,
       0,     0,   139,     0,   672,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   673,     0,
     148,   149,   150,   151,   152,   674,   154,     0,   155,     0,
       0,   675,   156,   676,   677,   678,   157,   679,     0,   158,
     159,   160,  1675,   161,     0,   162,   163,     0,     0,   164,
     680,   681,   165,   166,  4435,   167,   682,   683,   169,   170,
       0,   171,   172,   173,   174,   175,   684,   177,     0,   685,
     179,   686,   687,   688,   689,   690,   691,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   692,   200,     0,   201,   693,   694,   202,
       0,  3423,   203,   695,   696,     0,   204,   697,   698,     0,
     205,   206,   207,   699,   700,   701,     0,     0,     0,     0,
     702,   210,   703,     0,     0,   704,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,   705,
       0,   236,   237,   238,   706,   707,   239,   240,     0,   241,
     242,   243,   708,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   709,   251,   710,   253,
       0,   254,     0,   711,     0,   255,   256,   257,     0,   258,
     712,   713,     0,   259,   260,     0,     0,     0,   714,   262,
     263,   264,   715,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,   716,   270,   271,   717,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   718,     0,  1676,   281,     0,
     719,   282,   283,     0,     0,     0,     0,     0,   720,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   721,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,   722,   306,   307,   308,   309,   723,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   724,   317,     0,
       0,   725,   319,   726,   320,     0,   321,   727,   728,   729,
     730,   731,   326,   327,   328,   329,   330,   331,     0,   732,
     332,   333,     0,     0,   334,   335,   336,   337,   733,   734,
     735,   338,   339,     0,   736,   737,     0,   340,   341,   738,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
     739,   352,     0,   353,   354,   355,   356,   740,   358,   359,
     360,   361,   741,   742,   364,   743,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   744,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,   745,   746,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
     747,   399,   400,   401,   402,   403,   748,   405,   406,   407,
     408,     0,   749,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,   750,
     751,   434,   435,     0,   436,   437,   752,   439,   440,   441,
     753,   754,   442,   443,   444,   445,   755,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,   756,   453,   454,
       0,   757,   758,   759,   760,     0,     0,     0,     0,  1677,
     459,   460,   461,     0,   761,   762,   763,   463,   464,   465,
     764,   466,   467,   765,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   766,   476,
     477,     0,     0,   767,   768,   769,   770,   478,     0,     0,
     479,   771,     0,   772,   480,   481,   482,   483,   484,   773,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,     0,   774,     0,     0,     0,     0,   775,
     776,     0,     0,     0,     0,   777,   778,     0,     0,   779,
     780,     0,     0,   781,   782,   139,     0,   672,   141,   142,
     143,   144,  3172,     0,   145,     0,     0,     0,   146,     0,
       0,   673,     0,   148,   149,   150,   151,   152,   674,   154,
       0,   155,     0,     0,  3173,   156,   676,   677,   678,   157,
     679,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,   680,   681,   165,   166,     0,   167,   682,
     683,   169,   170,     0,   171,   172,   173,   174,   175,   684,
     177,     0,   685,   179,   686,   687,   688,   689,   690,   691,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   692,   200,     0,   201,
     693,   694,   202,     0,     0,   203,   695,   696,     0,   204,
     697,   698,     0,   205,   206,   207,   699,   700,   701,     0,
       0,     0,     0,   702,   210,   703,     0,     0,  3174,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,   705,     0,   236,   237,   238,   706,   707,   239,
     240,     0,   241,   242,   243,   708,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   709,
     251,   710,   253,     0,   254,     0,   711,     0,   255,   256,
     257,     0,   258,   712,   713,     0,   259,   260,     0,     0,
       0,   714,   262,   263,   264,   715,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,   716,   270,   271,
     717,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   718,     0,
       0,   281,     0,   719,   282,   283,     0,     0,     0,     0,
       0,   720,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,   721,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,   722,   306,   307,   308,   309,   723,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     724,   317,     0,     0,   725,   319,   726,   320,     0,   321,
     727,   728,   729,   730,   731,   326,   327,   328,   329,   330,
     331,     0,   732,   332,   333,     0,     0,   334,   335,   336,
     337,   733,   734,   735,   338,   339,     0,   736,   737,     0,
     340,   341,   738,  3175,   343,   344,   345,   346,     0,   347,
     348,     0,     0,     0,     0,     0,     0,     0,     0,   349,
     350,   351,     0,   739,   352,     0,   353,   354,   355,   356,
     740,   358,   359,   360,   361,   741,   742,   364,   743,     0,
     365,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   744,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,   389,     0,   390,   391,   392,
     745,   746,   393,     0,   394,     0,   395,   396,     0,   397,
     398,     0,     0,   747,   399,   400,   401,   402,   403,   748,
     405,   406,   407,   408,     0,   749,   410,     0,     0,     0,
     411,   412,   413,   414,     0,     0,     0,   415,     0,     0,
       0,   416,     0,   417,   418,   419,   420,     0,   421,   422,
     423,   424,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
     432,   433,   750,   751,   434,   435,     0,   436,   437,   752,
     439,   440,   441,   753,   754,   442,   443,   444,   445,   755,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
     756,   453,   454,     0,   757,   758,   759,   760,     0,     0,
       0,     0,     0,   459,   460,   461,     0,   761,   762,   763,
     463,   464,   465,   764,   466,   467,   765,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   766,   476,   477,     0,     0,   767,   768,   769,   770,
     478,     0,     0,   479,   771,     0,   772,   480,   481,   482,
     483,   484,   773,     0,     0,     0,     0,     0,     0,   486,
     487,     0,   488,   489,   490,     0,     0,   774,     0,     0,
       0,     0,   775,   776,     0,     0,     0,     0,   777,   778,
       0,     0,   779,   780,     0,     0,   781,   782,   139,     0,
     672,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   673,     0,   148,   149,   150,   151,
     152,   674,   154,     0,   155,     0,     0,   675,   156,   676,
     677,   678,   157,   679,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,   680,   681,   165,   166,
       0,   167,   682,   683,   169,   170,     0,   171,   172,   173,
     174,   175,   684,   177,     0,   685,   179,   686,   687,   688,
     689,   690,   691,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   692,
     200,     0,   201,   693,   694,   202,     0,     0,   203,   695,
     696,     0,   204,   697,   698,     0,   205,   206,   207,   699,
     700,   701,     0,     0,     0,     0,   702,   210,   703,     0,
       0,   704,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,   705,     0,   236,   237,   238,
     706,   707,   239,   240,     0,   241,   242,   243,   708,     0,
     244,     0,     0,     0,   245,  2196,   246,     0,   247,     0,
     248,   249,   709,   251,   710,   253,     0,   254,     0,   711,
       0,   255,   256,   257,     0,   258,   712,   713,     0,   259,
     260,     0,     0,     0,   714,   262,   263,   264,   715,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
     716,   270,   271,   717,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   718,     0,     0,   281,     0,   719,   282,   283,     0,
       0,     0,     0,     0,   720,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,   721,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,   722,   306,   307,
     308,   309,   723,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   724,   317,     0,     0,   725,   319,   726,
     320,     0,   321,   727,   728,   729,   730,   731,   326,   327,
     328,   329,   330,   331,     0,   732,   332,   333,     0,     0,
     334,   335,   336,   337,   733,   734,   735,   338,   339,     0,
     736,   737,     0,   340,   341,   738,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,   739,   352,     0,   353,
     354,   355,   356,   740,   358,   359,   360,   361,   741,   742,
     364,   743,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   744,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,   745,   746,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,   747,   399,   400,   401,
     402,   403,   748,   405,   406,   407,   408,     0,   749,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,   750,   751,   434,   435,     0,
     436,   437,   752,   439,   440,   441,   753,   754,   442,   443,
     444,   445,   755,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,   756,   453,   454,     0,   757,   758,   759,
     760,     0,     0,     0,     0,     0,   459,   460,   461,     0,
     761,   762,   763,   463,   464,   465,   764,   466,   467,   765,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   766,   476,   477,     0,     0,   767,
     768,   769,   770,   478,     0,     0,   479,   771,     0,   772,
     480,   481,   482,   483,   484,   773,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,     0,
     774,     0,     0,     0,     0,   775,   776,     0,     0,     0,
       0,   777,   778,     0,     0,   779,   780,     0,     0,   781,
     782,   139,     0,   672,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   673,     0,   148,
     149,   150,   151,   152,   674,   154,     0,   155,     0,     0,
     675,   156,   676,   677,   678,   157,   679,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,   680,
     681,   165,   166,     0,   167,   682,   683,   169,   170,     0,
     171,   172,   173,   174,   175,   684,   177,     0,   685,   179,
     686,   687,   688,   689,   690,   691,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   692,   200,     0,   201,   693,   694,   202,     0,
       0,   203,   695,   696,     0,   204,   697,   698,     0,   205,
     206,   207,   699,   700,   701,     0,     0,     0,     0,   702,
     210,   703,     0,     0,   704,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,   705,     0,
     236,   237,   238,   706,   707,   239,   240,     0,   241,   242,
     243,   708,     0,   244,     0,     0,     0,   245,  2198,   246,
       0,   247,     0,   248,   249,   709,   251,   710,   253,     0,
     254,     0,   711,     0,   255,   256,   257,     0,   258,   712,
     713,     0,   259,   260,     0,     0,     0,   714,   262,   263,
     264,   715,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,   716,   270,   271,   717,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   718,     0,     0,   281,     0,   719,
     282,   283,     0,     0,     0,     0,     0,   720,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,   721,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
     722,   306,   307,   308,   309,   723,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   724,   317,     0,     0,
     725,   319,   726,   320,     0,   321,   727,   728,   729,   730,
     731,   326,   327,   328,   329,   330,   331,     0,   732,   332,
     333,     0,     0,   334,   335,   336,   337,   733,   734,   735,
     338,   339,     0,   736,   737,     0,   340,   341,   738,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,   739,
     352,     0,   353,   354,   355,   356,   740,   358,   359,   360,
     361,   741,   742,   364,   743,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   744,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,   745,   746,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,   747,
     399,   400,   401,   402,   403,   748,   405,   406,   407,   408,
       0,   749,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,   750,   751,
     434,   435,     0,   436,   437,   752,   439,   440,   441,   753,
     754,   442,   443,   444,   445,   755,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,   756,   453,   454,     0,
     757,   758,   759,   760,     0,     0,     0,     0,     0,   459,
     460,   461,     0,   761,   762,   763,   463,   464,   465,   764,
     466,   467,   765,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   766,   476,   477,
       0,     0,   767,   768,   769,   770,   478,     0,     0,   479,
     771,     0,   772,   480,   481,   482,   483,   484,   773,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,     0,   774,     0,     0,     0,     0,   775,   776,
       0,     0,     0,     0,   777,   778,     0,     0,   779,   780,
       0,     0,   781,   782,   139,     0,   672,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     673,     0,   148,   149,   150,   151,   152,   674,   154,     0,
     155,     0,     0,   675,   156,   676,   677,   678,   157,   679,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,   680,   681,   165,   166,     0,   167,   682,   683,
     169,   170,     0,   171,   172,   173,   174,   175,   684,   177,
       0,   685,   179,   686,   687,   688,   689,   690,   691,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   692,   200,     0,   201,   693,
     694,   202,     0,     0,   203,   695,   696,     0,   204,   697,
     698,     0,   205,   206,   207,   699,   700,   701,     0,     0,
       0,     0,   702,   210,   703,     0,     0,   704,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,   705,     0,   236,   237,   238,   706,   707,   239,   240,
       0,   241,   242,   243,   708,     0,   244,     0,     0,     0,
     245,  2200,   246,     0,   247,     0,   248,   249,   709,   251,
     710,   253,     0,   254,     0,   711,     0,   255,   256,   257,
       0,   258,   712,   713,     0,   259,   260,     0,     0,     0,
     714,   262,   263,   264,   715,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,   716,   270,   271,   717,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   718,     0,     0,
     281,     0,   719,   282,   283,     0,     0,     0,     0,     0,
     720,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,   721,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,   722,   306,   307,   308,   309,   723,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   724,
     317,     0,     0,   725,   319,   726,   320,     0,   321,   727,
     728,   729,   730,   731,   326,   327,   328,   329,   330,   331,
       0,   732,   332,   333,     0,     0,   334,   335,   336,   337,
     733,   734,   735,   338,   339,     0,   736,   737,     0,   340,
     341,   738,     0,   343,   344,   345,   346,     0,   347,   348,
       0,     0,     0,     0,     0,     0,     0,     0,   349,   350,
     351,     0,   739,   352,     0,   353,   354,   355,   356,   740,
     358,   359,   360,   361,   741,   742,   364,   743,     0,   365,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   744,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,   389,     0,   390,   391,   392,   745,
     746,   393,     0,   394,     0,   395,   396,     0,   397,   398,
       0,     0,   747,   399,   400,   401,   402,   403,   748,   405,
     406,   407,   408,     0,   749,   410,     0,     0,     0,   411,
     412,   413,   414,     0,     0,     0,   415,     0,     0,     0,
     416,     0,   417,   418,   419,   420,     0,   421,   422,   423,
     424,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,   432,
     433,   750,   751,   434,   435,     0,   436,   437,   752,   439,
     440,   441,   753,   754,   442,   443,   444,   445,   755,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,   756,
     453,   454,     0,   757,   758,   759,   760,     0,     0,     0,
       0,     0,   459,   460,   461,     0,   761,   762,   763,   463,
     464,   465,   764,   466,   467,   765,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     766,   476,   477,     0,     0,   767,   768,   769,   770,   478,
       0,     0,   479,   771,     0,   772,   480,   481,   482,   483,
     484,   773,     0,     0,     0,     0,     0,     0,   486,   487,
       0,   488,   489,   490,     0,     0,   774,     0,     0,     0,
       0,   775,   776,     0,     0,     0,     0,   777,   778,     0,
       0,   779,   780,     0,     0,   781,   782,   139,     0,   672,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   673,     0,   148,   149,   150,   151,   152,
     674,   154,     0,   155,     0,     0,   675,   156,   676,   677,
     678,   157,   679,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,   680,   681,   165,   166,     0,
     167,   682,   683,   169,   170,     0,   171,   172,   173,   174,
     175,   684,   177,     0,   685,   179,   686,   687,   688,   689,
     690,   691,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   692,   200,
       0,   201,   693,   694,   202,     0,     0,   203,   695,   696,
       0,   204,   697,   698,     0,   205,   206,   207,   699,   700,
     701,     0,     0,     0,     0,   702,   210,   703,     0,     0,
     704,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,   705,     0,   236,   237,   238,   706,
     707,   239,   240,     0,   241,   242,   243,   708,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   709,   251,   710,   253,     0,   254,     0,   711,     0,
     255,   256,   257,     0,   258,   712,   713,     0,   259,   260,
       0,     0,     0,   714,   262,   263,   264,   715,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,   716,
     270,   271,   717,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     718,     0,     0,   281,     0,   719,   282,   283,     0,     0,
       0,     0,     0,   720,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,   721,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,   722,   306,   307,   308,
     309,   723,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   724,   317,     0,     0,   725,   319,   726,   320,
       0,   321,   727,   728,   729,   730,   731,   326,   327,   328,
     329,   330,   331,     0,   732,   332,   333,     0,     0,   334,
     335,   336,   337,   733,   734,   735,   338,   339,     0,   736,
     737,     0,   340,   341,   738,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,   739,   352,     0,   353,   354,
     355,   356,   740,   358,   359,   360,   361,   741,   742,   364,
     743,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   744,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,   745,   746,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,   747,   399,   400,   401,   402,
     403,   748,   405,   406,   407,   408,     0,   749,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,   750,   751,   434,   435,     0,   436,
     437,   752,   439,   440,   441,   753,   754,   442,   443,   444,
     445,   755,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   756,   453,   454,     0,   757,   758,   759,   760,
       0,     0,     0,     0,     0,   459,   460,   461,     0,   761,
     762,   763,   463,   464,   465,   764,   466,   467,   765,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   766,   476,   477,     0,     0,   767,   768,
     769,   770,   478,     0,     0,   479,   771,     0,   772,   480,
     481,   482,   483,   484,   773,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,     0,   774,
       0,     0,     0,     0,   775,   776,     0,     0,     0,     0,
     777,   778,     0,     0,   779,   780,     0,     0,   781,   782,
     139,     0,   672,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   673,     0,   148,   149,
     150,   151,   152,   674,   154,     0,   155,     0,     0,   675,
     156,   676,   677,   678,   157,   679,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,   680,   681,
     165,   166,     0,   167,   682,   683,   169,   170,     0,   171,
     172,   173,   174,   175,   684,   177,     0,   685,   179,   686,
     687,   688,   689,   690,   691,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   692,   200,     0,   201,   693,   694,   202,     0,     0,
     203,   695,   696,     0,   204,   697,   698,     0,   205,   206,
     207,   699,   700,   701,     0,     0,     0,     0,   702,   210,
     703,     0,     0,   704,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,   705,     0,   236,
     237,   238,   706,   707,   239,   240,     0,   241,   242,   243,
     708,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   709,   251,   710,   253,     0,   254,
       0,   711,     0,   255,   256,   257,     0,   258,   712,   713,
       0,   259,   260,     0,     0,     0,   714,   262,   263,   264,
     715,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,   716,   270,   271,   717,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   718,     0,     0,   281,     0,   719,   282,
     283,     0,     0,     0,     0,     0,   720,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   721,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,   722,
     306,   307,   308,   309,   723,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   724,   317,     0,     0,   725,
     319,   726,   320,     0,   321,   727,   728,   729,   730,   731,
     326,   327,   328,   329,   330,   331,     0,   732,   332,   333,
       0,     0,   334,   335,   336,   337,   733,   734,   735,   338,
     339,     0,   736,   737,     0,   340,   341,   738,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,   739,   352,
       0,   353,   354,   355,   356,   740,   358,   359,   360,   361,
     741,   742,   364,   743,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   744,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,   745,   746,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,   747,   399,
     400,   401,   402,   403,   748,   405,   406,   407,   408,     0,
     749,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,   750,   751,   434,
     435,     0,   436,   437,   752,   439,   440,   441,   753,   754,
     442,   443,   444,   445,   755,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,   756,   453,   454,     0,   757,
     758,   759,   760,     0,     0,     0,     0,     0,   459,   460,
     461,     0,   761,   762,   763,   463,   464,   465,   764,   466,
     467,   765,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   766,   476,   477,     0,
       0,   767,   768,   769,   770,   478,     0,     0,   479,   771,
       0,   772,   480,   481,   482,   483,   484,   773,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,     0,   774,     0,     0,     0,     0,   775,   776,     0,
       0,     0,     0,   777,  1123,     0,     0,   779,   780,     0,
       0,   781,   782,   139,     0,   672,   141,   142,   143,   144,
    1709,     0,   145,     0,     0,     0,  1710,     0,     0,   673,
       0,   148,   149,   150,   151,   152,   674,   154,     0,   155,
       0,     0,   675,   156,   676,   677,   678,   157,   679,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,   680,   681,   165,   166,     0,   167,   682,   683,   169,
     170,     0,   171,   172,   173,   174,   175,   684,   177,     0,
     685,   179,   686,   687,   688,   689,   690,   691,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   692,   200,     0,   201,   693,   694,
     202,     0,     0,   203,   695,   696,     0,   204,   697,   698,
       0,   205,   206,   207,   699,   700,   701,     0,     0,     0,
       0,   702,   210,   703,     0,     0,   704,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
     705,     0,   236,   237,   238,   706,   707,   239,   240,     0,
     241,   242,   243,   708,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   709,   251,   710,
     253,     0,   254,     0,   711,     0,   255,   256,   257,     0,
     258,   712,   713,     0,   259,   260,     0,     0,     0,   714,
     262,   263,   264,   715,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,   716,   270,   271,   717,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   718,     0,     0,   281,
       0,   719,   282,   283,     0,     0,     0,     0,     0,   720,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
     721,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,   722,   306,   307,   308,   309,   723,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   724,   317,
       0,     0,   725,   319,   726,   320,     0,   321,   727,   728,
     729,   730,   731,   326,   327,   328,   329,   330,   331,     0,
     732,   332,   333,     0,     0,   334,   335,   336,   337,   733,
       0,   735,   338,   339,     0,   736,   737,     0,   340,   341,
     738,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,   739,   352,     0,   353,   354,   355,   356,   740,   358,
     359,   360,   361,   741,   742,   364,   743,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     744,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,   745,   746,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,   747,   399,   400,   401,   402,   403,   748,   405,   406,
     407,   408,     0,   749,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
     750,   751,   434,   435,     0,   436,   437,   752,   439,   440,
     441,   753,   754,   442,   443,   444,   445,   755,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,   756,   453,
     454,     0,   757,   758,   759,   760,     0,     0,     0,     0,
       0,   459,   460,   461,     0,   761,   762,   763,   463,   464,
     465,   764,   466,   467,   765,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   766,
     476,   477,     0,     0,   767,   768,   769,   770,   478,     0,
       0,   479,   771,     0,   772,   480,   481,   482,   483,   484,
     773,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,     0,   774,     0,     0,     0,     0,
     775,   776,     0,     0,     0,     0,   777,   778,     0,     0,
     779,   780,     0,     0,   781,   782,   139,     0,   672,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   673,     0,   148,   149,   150,   151,   152,   674,
     154,     0,   155,     0,     0,   675,   156,   676,   677,   678,
     157,   679,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,   680,   681,   165,   166,     0,   167,
     682,   683,   169,   170,     0,   171,   172,   173,   174,   175,
     684,   177,     0,   685,   179,   686,   687,   688,   689,   690,
     691,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   692,   200,     0,
     201,   693,   694,   202,     0,     0,   203,   695,   696,     0,
     204,   697,   698,     0,   205,   206,   207,   699,   700,   701,
       0,     0,     0,     0,   702,   210,   703,     0,     0,   704,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,   705,     0,   236,   237,   238,   706,   707,
     239,   240,     0,   241,   242,   243,   708,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     709,   251,   710,   253,     0,   254,     0,   711,     0,   255,
     256,   257,     0,   258,   712,   713,     0,   259,   260,     0,
       0,     0,   714,   262,   263,   264,   715,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,   716,   270,
     271,   717,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   718,
       0,     0,   281,     0,   719,   282,   283,     0,     0,     0,
       0,     0,   720,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,   721,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,   722,   306,   307,   308,   309,
     723,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   724,   317,     0,     0,   725,   319,   726,   320,     0,
     321,   727,   728,   729,   730,   731,   326,   327,   328,   329,
     330,   331,     0,   732,   332,   333,     0,     0,   334,   335,
     336,   337,   733,   734,   735,   338,   339,     0,   736,   737,
       0,   340,   341,   738,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,   739,   352,     0,   353,   354,   355,
     356,   740,   358,   359,   360,   361,   741,   742,   364,   743,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   744,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,   745,   746,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,   747,   399,   400,   401,   402,   403,
     748,   405,   406,   407,   408,     0,   749,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,   750,   751,   434,   435,     0,   436,   437,
     752,   439,   440,   441,   753,   754,   442,   443,   444,   445,
     755,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,   756,   453,   454,     0,   757,   758,   759,   760,     0,
       0,     0,     0,     0,   459,   460,   461,     0,   761,   762,
     763,   463,   464,   465,   764,   466,   467,   765,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,  1784,   476,   477,     0,     0,   767,   768,   769,
     770,   478,     0,     0,   479,   771,     0,   772,   480,   481,
     482,   483,   484,   773,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,     0,   774,     0,
       0,     0,     0,   775,   776,     0,     0,     0,     0,   777,
     778,     0,     0,   779,   780,     0,     0,   781,   782,   139,
       0,   672,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,     0,     0,   673,     0,   148,   149,   150,
     151,   152,   674,   154,     0,   155,     0,     0,   675,   156,
     676,   677,   678,   157,   679,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,   680,   681,   165,
     166,     0,   167,   682,   683,   169,   170,     0,   171,   172,
     173,   174,   175,   684,   177,     0,   685,   179,   686,   687,
     688,   689,   690,   691,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     692,   200,     0,   201,   693,   694,   202,     0,     0,   203,
     695,   696,     0,   204,   697,   698,     0,   205,   206,   207,
     699,   700,   701,     0,     0,     0,     0,   702,   210,   703,
       0,     0,   704,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,   705,     0,   236,   237,
     238,   706,   707,   239,   240,     0,   241,   242,   243,   708,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   709,   251,   710,   253,     0,   254,     0,
     711,     0,   255,   256,   257,     0,   258,   712,   713,     0,
     259,   260,     0,     0,     0,   714,   262,   263,   264,   715,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,   716,   270,   271,  2608,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   718,     0,     0,   281,     0,   719,   282,   283,
       0,     0,     0,     0,     0,   720,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,   721,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,   722,   306,
     307,   308,   309,   723,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   724,   317,     0,     0,   725,   319,
     726,   320,     0,   321,   727,   728,   729,   730,   731,   326,
     327,   328,   329,   330,   331,     0,   732,   332,   333,     0,
       0,   334,   335,   336,   337,   733,   734,   735,   338,   339,
       0,   736,   737,     0,   340,   341,   738,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,   739,   352,     0,
     353,   354,   355,   356,   740,   358,   359,   360,   361,   741,
     742,   364,   743,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   744,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,   745,   746,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,   747,   399,   400,
     401,   402,   403,   748,   405,   406,   407,   408,     0,   749,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,   750,   751,   434,   435,
       0,   436,   437,   752,   439,   440,   441,   753,   754,   442,
     443,   444,   445,   755,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,   756,   453,   454,     0,   757,   758,
     759,   760,     0,     0,     0,     0,     0,   459,   460,   461,
       0,   761,   762,   763,   463,   464,   465,   764,   466,   467,
     765,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   766,   476,   477,     0,     0,
     767,   768,   769,   770,   478,     0,     0,   479,   771,     0,
     772,   480,   481,   482,   483,   484,   773,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
       0,   774,     0,     0,     0,     0,   775,   776,     0,     0,
       0,     0,   777,   778,     0,     0,   779,   780,     0,     0,
     781,   782,   139,     0,   672,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   673,     0,
     148,   149,   150,   151,   152,   674,   154,     0,   155,     0,
       0,   675,   156,   676,   677,   678,   157,   679,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
     680,   681,   165,   166,     0,   167,   682,   683,   169,   170,
       0,   171,   172,   173,   174,   175,   684,   177,     0,   685,
     179,   686,   687,   688,   689,   690,   691,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   692,   200,     0,   201,   693,   694,   202,
       0,     0,   203,   695,   696,     0,   204,   697,   698,     0,
     205,   206,   207,   699,   700,   701,     0,     0,     0,     0,
     702,   210,   703,     0,     0,   704,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,   705,
       0,   236,   237,   238,   706,   707,   239,   240,     0,   241,
     242,   243,   708,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   709,   251,   710,   253,
       0,   254,     0,   711,     0,   255,   256,   257,     0,   258,
     712,   713,     0,   259,   260,     0,     0,     0,   714,   262,
     263,   264,   715,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,   716,   270,   271,  2662,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   718,     0,     0,   281,     0,
     719,   282,   283,     0,     0,     0,     0,     0,   720,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,   721,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,   722,   306,   307,   308,   309,   723,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   724,   317,     0,
       0,   725,   319,   726,   320,     0,   321,   727,   728,   729,
     730,   731,   326,   327,   328,   329,   330,   331,     0,   732,
     332,   333,     0,     0,   334,   335,   336,   337,   733,   734,
     735,   338,   339,     0,   736,   737,     0,   340,   341,   738,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
     739,   352,     0,   353,   354,   355,   356,   740,   358,   359,
     360,   361,   741,   742,   364,   743,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   744,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,   745,   746,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
     747,   399,   400,   401,   402,   403,   748,   405,   406,   407,
     408,     0,   749,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,   750,
     751,   434,   435,     0,   436,   437,   752,   439,   440,   441,
     753,   754,   442,   443,   444,   445,   755,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,   756,   453,   454,
       0,   757,   758,   759,   760,     0,     0,     0,     0,     0,
     459,   460,   461,     0,   761,   762,   763,   463,   464,   465,
     764,   466,   467,   765,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   766,   476,
     477,     0,     0,   767,   768,   769,   770,   478,     0,     0,
     479,   771,     0,   772,   480,   481,   482,   483,   484,   773,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,     0,   774,     0,     0,     0,     0,   775,
     776,     0,     0,     0,     0,   777,   778,     0,     0,   779,
     780,     0,     0,   781,   782,   139,     0,   672,   141,   142,
     143,   144,     0,     0,   145,     0,     0,     0,   146,     0,
       0,   673,     0,   148,   149,   150,   151,   152,   674,   154,
       0,   155,     0,     0,   675,   156,   676,   677,   678,   157,
     679,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,   680,   681,   165,   166,     0,   167,   682,
     683,   169,   170,     0,   171,   172,   173,   174,   175,   684,
     177,     0,   685,   179,   686,   687,   688,   689,   690,   691,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   692,   200,     0,   201,
     693,   694,   202,     0,     0,   203,   695,   696,     0,   204,
     697,   698,     0,   205,   206,   207,   699,   700,   701,     0,
       0,     0,     0,   702,   210,   703,     0,     0,  3422,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,   705,     0,   236,   237,   238,   706,   707,   239,
     240,     0,   241,   242,   243,   708,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   709,
     251,   710,   253,     0,   254,     0,   711,     0,   255,   256,
     257,     0,   258,   712,   713,     0,   259,   260,     0,     0,
       0,   714,   262,   263,   264,   715,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,   716,   270,   271,
     717,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   718,     0,
       0,   281,     0,   719,   282,   283,     0,     0,     0,     0,
       0,   720,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,   721,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,   722,   306,   307,   308,   309,   723,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     724,   317,     0,     0,   725,   319,   726,   320,     0,   321,
     727,   728,   729,   730,   731,   326,   327,   328,   329,   330,
     331,     0,   732,   332,   333,     0,     0,   334,   335,   336,
     337,   733,   734,   735,   338,   339,     0,   736,   737,     0,
     340,   341,   738,     0,   343,   344,   345,   346,     0,   347,
     348,     0,     0,     0,     0,     0,     0,     0,     0,   349,
     350,   351,     0,   739,   352,     0,   353,   354,   355,   356,
     740,   358,   359,   360,   361,   741,   742,   364,   743,     0,
     365,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   744,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,   389,     0,   390,   391,   392,
     745,   746,   393,     0,   394,     0,   395,   396,     0,   397,
     398,     0,     0,   747,   399,   400,   401,   402,   403,   748,
     405,   406,   407,   408,     0,   749,   410,     0,     0,     0,
     411,   412,   413,   414,     0,     0,     0,   415,     0,     0,
       0,   416,     0,   417,   418,   419,   420,     0,   421,   422,
     423,   424,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
     432,   433,   750,   751,   434,   435,     0,   436,   437,   752,
     439,   440,   441,   753,   754,   442,   443,   444,   445,   755,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
     756,   453,   454,     0,   757,   758,   759,   760,     0,     0,
       0,     0,     0,   459,   460,   461,     0,   761,   762,   763,
     463,   464,   465,   764,   466,   467,   765,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   766,   476,   477,     0,     0,   767,   768,   769,   770,
     478,     0,     0,   479,   771,     0,   772,   480,   481,   482,
     483,   484,   773,     0,     0,     0,     0,     0,     0,   486,
     487,     0,   488,   489,   490,     0,     0,   774,     0,     0,
       0,     0,   775,   776,     0,     0,     0,     0,   777,   778,
       0,     0,   779,   780,     0,     0,   781,   782,   139,     0,
     672,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   673,     0,   148,   149,   150,   151,
     152,   674,   154,     0,   155,     0,     0,   675,   156,   676,
     677,   678,   157,   679,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,   680,   681,   165,   166,
       0,   167,   682,   683,   169,   170,     0,   171,   172,   173,
     174,   175,   684,   177,     0,   685,   179,   686,   687,   688,
     689,   690,   691,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   692,
     200,     0,   201,   693,   694,   202,     0,     0,   203,   695,
     696,     0,   204,   697,   698,     0,   205,   206,   207,   699,
     700,   701,     0,     0,     0,     0,   702,   210,   703,     0,
       0,   704,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,   705,     0,   236,   237,   238,
     706,   707,   239,   240,     0,   241,   242,   243,   708,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   709,   251,   710,   253,     0,   254,     0,   711,
       0,   255,   256,   257,     0,   258,   712,   713,     0,   259,
     260,     0,     0,     0,   714,   262,   263,   264,   715,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
     716,   270,   271,   717,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   718,     0,     0,   281,     0,   719,   282,   283,     0,
       0,     0,     0,     0,   720,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,   721,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,   722,   306,   307,
     308,   309,   723,   310,   311,  4308,     0,     0,     0,   312,
     313,   314,   315,   724,   317,     0,     0,   725,   319,   726,
     320,     0,   321,   727,   728,   729,   730,   731,   326,   327,
     328,   329,   330,   331,     0,   732,   332,   333,     0,     0,
     334,   335,   336,   337,   733,     0,   735,   338,   339,     0,
     736,   737,     0,   340,   341,   738,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,   739,   352,     0,   353,
     354,   355,   356,   740,   358,   359,   360,   361,   741,   742,
     364,   743,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   744,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,   745,   746,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,   747,   399,   400,   401,
     402,   403,   748,   405,   406,   407,   408,     0,   749,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,   750,   751,   434,   435,     0,
     436,   437,   752,   439,   440,   441,   753,   754,   442,   443,
     444,   445,   755,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,   756,   453,   454,     0,   757,   758,   759,
     760,     0,     0,     0,     0,     0,   459,   460,   461,     0,
     761,   762,   763,   463,   464,   465,   764,   466,   467,   765,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   766,   476,   477,     0,     0,   767,
     768,   769,   770,   478,     0,     0,   479,   771,     0,   772,
     480,   481,   482,   483,   484,   773,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,     0,
     774,     0,     0,     0,     0,   775,   776,     0,     0,     0,
       0,   777,   778,     0,     0,   779,   780,     0,     0,   781,
     782,   139,     0,   672,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   673,     0,   148,
     149,   150,   151,   152,   674,   154,     0,   155,     0,     0,
     675,   156,   676,   677,   678,   157,   679,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,   680,
     681,   165,   166,     0,   167,   682,   683,   169,   170,     0,
     171,   172,   173,   174,   175,   684,   177,     0,   685,   179,
     686,   687,   688,   689,   690,   691,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   692,   200,     0,   201,   693,   694,   202,     0,
       0,   203,   695,   696,     0,   204,   697,   698,     0,   205,
     206,   207,   699,   700,   701,     0,     0,     0,     0,   702,
     210,   703,     0,     0,   704,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,   705,     0,
     236,   237,   238,   706,   707,   239,   240,     0,   241,   242,
     243,   708,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   709,   251,   710,   253,     0,
     254,     0,   711,     0,   255,   256,   257,     0,   258,   712,
     713,     0,   259,   260,     0,     0,     0,   714,   262,   263,
     264,   715,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,   716,   270,   271,   717,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   718,     0,     0,   281,     0,   719,
     282,   283,     0,     0,     0,     0,     0,   720,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,   721,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
     722,   306,   307,   308,   309,   723,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   724,   317,     0,     0,
     725,   319,   726,   320,     0,   321,   727,   728,   729,   730,
     731,   326,   327,   328,   329,   330,   331,     0,   732,   332,
     333,     0,     0,   334,   335,   336,   337,   733,     0,   735,
     338,   339,     0,   736,   737,     0,   340,   341,   738,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,   739,
     352,     0,   353,   354,   355,   356,   740,   358,   359,   360,
     361,   741,   742,   364,   743,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   744,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,   745,   746,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,   747,
     399,   400,   401,   402,   403,   748,   405,   406,   407,   408,
       0,   749,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,   750,   751,
     434,   435,     0,   436,   437,   752,   439,   440,   441,   753,
     754,   442,   443,   444,   445,   755,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,   756,   453,   454,     0,
     757,   758,   759,   760,     0,     0,     0,     0,     0,   459,
     460,   461,     0,   761,   762,   763,   463,   464,   465,   764,
     466,   467,   765,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   766,   476,   477,
       0,     0,   767,   768,   769,   770,   478,     0,     0,   479,
     771,     0,   772,   480,   481,   482,   483,   484,   773,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,     0,   774,     0,     0,     0,     0,   775,   776,
       0,     0,     0,     0,   777,   778,     0,     0,   779,   780,
       0,     0,   781,   782,   139,     0,   672,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     673,     0,   148,   149,   150,   151,   152,   674,   154,     0,
     155,     0,     0,   675,   156,   676,   677,   678,   157,   679,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,   680,   681,   165,   166,     0,   167,   682,   683,
     169,   170,     0,   171,   172,   173,   174,   175,   684,   177,
       0,   685,   179,   686,   687,   688,   689,   690,   691,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   692,   200,     0,   201,   693,
     694,   202,     0,     0,   203,   695,   696,     0,   204,   697,
     698,     0,   205,   206,   207,   699,   700,   701,     0,     0,
       0,     0,   702,   210,   703,     0,     0,   704,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,   705,     0,   236,   237,   238,   706,   707,   239,   240,
       0,   241,   242,   243,   708,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   709,   251,
     710,   253,     0,   254,     0,   711,     0,   255,   256,   257,
       0,   258,   712,   713,     0,   259,   260,     0,     0,     0,
     714,   262,   263,   264,   715,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,   716,   270,   271,  1724,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   718,     0,     0,
     281,     0,   719,   282,   283,     0,     0,     0,     0,     0,
     720,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,   721,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,   722,   306,   307,   308,   309,   723,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   724,
     317,     0,     0,   725,   319,   726,   320,     0,   321,   727,
     728,   729,   730,   731,   326,   327,   328,   329,   330,   331,
       0,   732,   332,   333,     0,     0,   334,   335,   336,   337,
     733,     0,   735,   338,   339,     0,   736,   737,     0,   340,
     341,   738,     0,   343,   344,   345,   346,     0,   347,   348,
       0,     0,     0,     0,     0,     0,     0,     0,   349,   350,
     351,     0,   739,   352,     0,   353,   354,   355,   356,   740,
     358,   359,   360,   361,   741,   742,   364,   743,     0,   365,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   744,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,   389,     0,   390,   391,   392,   745,
     746,   393,     0,   394,     0,   395,   396,     0,   397,   398,
       0,     0,   747,   399,   400,   401,   402,   403,   748,   405,
     406,   407,   408,     0,   749,   410,     0,     0,     0,   411,
     412,   413,   414,     0,     0,     0,   415,     0,     0,     0,
     416,     0,   417,   418,   419,   420,     0,   421,   422,   423,
     424,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,   432,
     433,   750,   751,   434,   435,     0,   436,   437,   752,   439,
     440,   441,   753,   754,   442,   443,   444,   445,   755,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,   756,
     453,   454,     0,   757,   758,   759,   760,     0,     0,     0,
       0,     0,   459,   460,   461,     0,   761,   762,   763,   463,
     464,   465,   764,   466,   467,   765,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     766,   476,   477,     0,     0,   767,   768,   769,   770,   478,
       0,     0,   479,   771,     0,   772,   480,   481,   482,   483,
     484,   773,     0,     0,     0,     0,     0,     0,   486,   487,
       0,   488,   489,   490,     0,     0,   774,     0,     0,     0,
       0,   775,   776,     0,     0,     0,     0,   777,   778,     0,
       0,   779,   780,     0,     0,   781,   782,   139,     0,   672,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   673,     0,   148,   149,   150,   151,   152,
     674,   154,     0,   155,     0,     0,   675,   156,   676,   677,
     678,   157,   679,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,   680,   681,   165,   166,     0,
     167,   682,   683,   169,   170,     0,   171,   172,   173,   174,
     175,   684,   177,     0,   685,   179,   686,   687,   688,   689,
     690,   691,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   692,   200,
       0,   201,   693,   694,   202,     0,     0,   203,   695,   696,
       0,   204,   697,   698,     0,   205,   206,   207,   699,   700,
     701,     0,     0,     0,     0,   702,   210,   703,     0,     0,
     704,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,   705,     0,   236,   237,   238,   706,
     707,   239,   240,     0,   241,   242,   243,   708,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   709,   251,   710,   253,     0,   254,     0,   711,     0,
     255,   256,   257,     0,   258,   712,   713,     0,   259,   260,
       0,     0,     0,   714,   262,   263,   264,   715,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,   716,
     270,   271,  1726,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     718,     0,     0,   281,     0,   719,   282,   283,     0,     0,
       0,     0,     0,   720,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,   721,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,   722,   306,   307,   308,
     309,   723,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   724,   317,     0,     0,   725,   319,   726,   320,
       0,   321,   727,   728,   729,   730,   731,   326,   327,   328,
     329,   330,   331,     0,   732,   332,   333,     0,     0,   334,
     335,   336,   337,   733,     0,   735,   338,   339,     0,   736,
     737,     0,   340,   341,   738,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,   739,   352,     0,   353,   354,
     355,   356,   740,   358,   359,   360,   361,   741,   742,   364,
     743,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   744,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,   745,   746,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,   747,   399,   400,   401,   402,
     403,   748,   405,   406,   407,   408,     0,   749,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,   750,   751,   434,   435,     0,   436,
     437,   752,   439,   440,   441,   753,   754,   442,   443,   444,
     445,   755,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   756,   453,   454,     0,   757,   758,   759,   760,
       0,     0,     0,     0,     0,   459,   460,   461,     0,   761,
     762,   763,   463,   464,   465,   764,   466,   467,   765,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   766,   476,   477,     0,     0,   767,   768,
     769,   770,   478,     0,     0,   479,   771,     0,   772,   480,
     481,   482,   483,   484,   773,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,     0,   774,
       0,     0,     0,     0,   775,   776,     0,     0,     0,     0,
     777,   778,     0,     0,   779,   780,     0,     0,   781,   782,
     139,     0,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,   676,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,  2335,     0,     0,     0,     0,   209,   210,
     703,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,   707,   239,   240,     0,   241,   242,   243,
     708,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,   712,   713,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,   721,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,   732,   332,   333,
       0,     0,   334,   335,   336,   337,     0,     0,     0,   338,
     339,     0,   736,   737,     0,   340,   341,   342,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,     0,   352,
       0,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,     0,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,     0,     0,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,     0,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,     0,     0,   434,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,   756,   453,   454,     0,  2336,
     456,   457,  2337,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,   762,   462,   463,   464,   465,   764,   466,
     467,   765,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,     0,   491,     0,     0,     0,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,   781,   782,   147,     0,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,  2450,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,   507,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,  2033,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,  2034,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,     0,  3008,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,  3009,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,  -439,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,   510,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,     0,   491,
       0,     0,   139,     0,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,  2517,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,  2450,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,   507,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,  2033,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,  2034,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,   338,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
       0,   352,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,     0,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,     0,     0,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,     0,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,   510,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,     0,
       0,   434,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,     0,   491,     0,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,  2517,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,     0,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,  2326,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,     0,   491,
       0,     0,   139,     0,   140,   141,   142,   143,   144,     0,
       0,   145,  2757,     0,     0,   146,     0,     0,   147,   782,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,   338,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
       0,   352,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,     0,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,     0,     0,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,     0,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,     0,
       0,   434,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,     0,   491,     0,     0,     0,     0,   139,
       0,   140,   141,   142,   143,   144,     0,  4440,   145,     0,
       0,     0,   146,  4441,   782,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,     0,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
       0,   491,     0,     0,     0,     0,   139,     0,   140,   141,
     142,   143,   144,  1128,     0,   145,     0,     0,     0,   146,
       0,   782,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,  1331,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,     0,   491,     0,
       0,   139,     0,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   147,   541,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
     338,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,     0,
     352,     0,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,     0,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,     0,     0,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
       0,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,     0,     0,
     434,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,     0,   491,     0,     0,     0,     0,     0,   139,
    2273,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,   541,     0,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,     0,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
       0,   491,     0,     0,     0,     0,   139,     0,   140,   141,
     142,   143,   144,  2516,     0,   145,     0,     0,     0,   146,
       0,  2517,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,     0,   491,     0,
       0,     0,     0,   139,     0,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,  4441,   782,   147,
       0,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,   338,   339,     0,     0,     0,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,     0,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,     0,   491,     0,     0,   139,     0,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   147,   541,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   608,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,     0,     0,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,     0,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,   338,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,     0,   352,     0,   353,
     354,   609,   356,   357,   358,   359,   360,   361,   362,   363,
     364,     0,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,     0,     0,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,     0,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,     0,     0,   434,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,     0,
     491,     0,     0,   139,     0,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,   147,
     541,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,   338,   339,     0,     0,     0,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,     0,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,     0,   491,     0,     0,   139,     0,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   147,   782,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   237,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,     0,     0,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,     0,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,   338,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,     0,   352,     0,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,     0,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,     0,     0,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,     0,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,     0,     0,   434,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,     0,
     491,     0,     0,   139,     0,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,   147,
    2517,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,   620,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,   338,   339,     0,     0,     0,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,     0,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,   136,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,     0,   491,     0,   139,     0,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,  1696,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,   620,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   136,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,     0,   491,
       0,   139,     0,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   147,  2797,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,   620,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
     338,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,     0,
     352,     0,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,     0,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,     0,     0,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
       0,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,     0,     0,
     434,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,   136,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,     0,   491,     0,   139,     0,   140,   141,   142,
     143,   144,     0,     0,   145,     0,     0,     0,   146,     0,
       0,     0,  3454,   148,   149,   150,   151,   152,   153,     0,
       0,  -329,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,     0,     0,
       0,     0,   164,  3892,     0,   165,   166,     0,   167,     0,
       0,     0,     0,     0,   171,   172,   173,   174,  3893,   176,
     177,     0,   178,   179,     0,     0,     0,     0,     0,     0,
       0,   186,     0,   188,     0,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,     0,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,     0,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,     0,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
       0,     0,     0,     0,   236,   237,   238,     0,     0,   239,
     240,  3894,   241,   242,   243,     0,     0,     0,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,     0,   256,
     257,     0,     0,     0,     0,     0,     0,   260,     0,     0,
       0,   261,   262,   263,   264,  3895,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,     0,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
    3896,     0,     0,   277,     0,     0,     0,   279,   280,     0,
       0,   281,  3897,     0,   282,   283,     0,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,     0,     0,  -284,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,     0,     0,   332,   333,     0,     0,   334,   335,   336,
     337,     0,     0,     0,     0,   339,     0,     0,     0,     0,
     340,   341,   342,     0,   343,   344,   345,  3898,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     350,   351,     0,     0,     0,     0,   353,   354,   355,     0,
     357,   358,   359,   360,   361,   362,   363,     0,     0,     0,
       0,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   374,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,     0,     0,   390,     0,   392,
    -284,     0,   393,     0,     0,     0,   395,     0,     0,   397,
     398,  3899,     0,     0,     0,   400,   401,   402,   403,   404,
     405,     0,   407,   408,     0,   409,     0,     0,     0,     0,
     411,   412,   413,     0,     0,     0,     0,   415,     0,     0,
       0,   416,     0,     0,   418,     0,   420,     0,   421,     0,
     423,     0,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
       0,   433,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   444,   445,     0,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,   477,     0,     0,     0,     0,     0,     0,
     478,     0,     0,   479,     0,     0,     0,   480,   481,   482,
     483,   484,   485,     0,     0,  -284,     0,     0,     0,   486,
       0,     0,   488,     0,   490,     0,   139,   491,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,  4447,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,   995,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,   620,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,   136,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,     0,   491,   139,
       0,   140,   141,   142,   143,   144,     0,     0,   145,     0,
    1174,     0,   146,     0,     0,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,     0,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
     139,   491,   140,   141,   142,   143,   144,     0,  2105,   145,
       0,     0,     0,   146,     0,     0,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,     0,   239,   240,     0,   241,   242,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,     0,   332,   333,
       0,     0,   334,   335,   336,   337,     0,     0,     0,   338,
     339,     0,     0,     0,     0,   340,   341,   342,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,     0,   352,
       0,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,     0,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,     0,     0,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,     0,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,     0,     0,   434,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,   139,   491,   140,   141,   142,   143,   144,     0,  2785,
     145,     0,     0,     0,   146,     0,     0,   147,     0,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
     338,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,     0,
     352,     0,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,     0,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,     0,     0,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
       0,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,     0,     0,
     434,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,   139,   491,   140,   141,   142,   143,   144,     0,
    3115,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,   338,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
       0,   352,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,     0,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,     0,     0,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,     0,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,     0,
       0,   434,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,   139,   491,   140,   141,   142,   143,   144,
       0,  3459,   145,     0,     0,     0,   146,     0,     0,   147,
       0,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,  2429,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,  2430,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,  2431,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
    2432,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,  1037,
    1038,     0,   338,   339,     0,     0,  2433,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,     0,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,  4427,   566,  4428,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,  2434,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,   139,   491,   140,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     147,     0,   148,   149,   150,   151,   152,   153,   154,     0,
     155,     0,     0,     0,   156,     0,     0,     0,   157,     0,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,     0,     0,   165,   166,     0,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,   178,   179,   180,   181,   182,   183,   184,   185,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   199,   200,     0,   201,     0,
       0,   202,     0,     0,   203,     0,     0,     0,   204,     0,
       0,     0,   205,   206,   207,     0,     0,   208,     0,     0,
       0,     0,   209,   210,  1584,     0,     0,  2956,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,     0,     0,   236,   237,   238,     0,     0,   239,   240,
       0,   241,   242,   243,  1585,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   250,   251,
     252,   253,     0,   254,     0,     0,     0,   255,   256,   257,
       0,   258,  2851,     0,     0,   259,   260,     0,     0,     0,
     261,   262,   263,   264,     0,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,     0,   270,   271,     0,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   280,     0,     0,
     281,     0,     0,   282,   283,     0,     0,     0,     0,     0,
     284,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,  2852,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,     0,   306,   307,   308,   309,     0,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   316,
     317,     0,     0,   318,   319,     0,   320,     0,   321,     0,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
       0,     0,   332,   333,     0,     0,   334,   335,   336,   337,
       0,     0,     0,   338,   339,     0,     0,  2853,     0,   340,
     341,   342,     0,   343,   344,   345,   346,     0,   347,   348,
       0,     0,     0,     0,     0,     0,     0,     0,   349,   350,
     351,     0,     0,   352,     0,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,     0,     0,   365,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   374,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,   389,     0,   390,   391,   392,     0,
       0,   393,     0,   394,     0,   395,   396,     0,   397,   398,
       0,     0,     0,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,     0,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,     0,     0,   415,     0,     0,     0,
     416,     0,   417,   418,   419,   420,     0,   421,   422,   423,
     424,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,   432,
     433,     0,     0,   434,   435,     0,   436,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   444,   445,     0,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,   136,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,   461,     0,     0,     0,   462,   463,
     464,   465,  2854,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,   477,     0,     0,     0,     0,     0,     0,   478,
       0,     0,   479,     0,     0,     0,   480,   481,   482,   483,
     484,   485,     0,     0,     0,     0,     0,     0,   486,   487,
       0,   488,   489,   490,     0,   139,   491,   140,   141,   142,
     143,   144,     0,     0,   145,     0,     0,     0,   146,     0,
       0,   147,     0,   148,   149,   150,   151,   152,   153,   154,
       0,   155,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,     0,     0,   165,   166,     0,   167,   168,
       0,   169,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,   178,   179,   180,   181,   182,   183,   184,   185,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   199,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,   210,  1584,     0,     0,  3886,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,     0,     0,   236,   237,   238,     0,     0,   239,
     240,     0,   241,   242,   243,  1585,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,   255,   256,
     257,     0,   258,  2851,     0,     0,   259,   260,     0,     0,
       0,   261,   262,   263,   264,     0,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,   271,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   280,     0,
       0,   281,     0,     0,   282,   283,     0,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,  2852,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,     0,     0,   332,   333,     0,     0,   334,   335,   336,
     337,     0,     0,     0,   338,   339,     0,     0,  2853,     0,
     340,   341,   342,     0,   343,   344,   345,   346,     0,   347,
     348,     0,     0,     0,     0,     0,     0,     0,     0,   349,
     350,   351,     0,     0,   352,     0,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,     0,     0,
     365,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   374,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,   389,     0,   390,   391,   392,
       0,     0,   393,     0,   394,     0,   395,   396,     0,   397,
     398,     0,     0,     0,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,     0,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,     0,     0,   415,     0,     0,
       0,   416,     0,   417,   418,   419,   420,     0,   421,   422,
     423,   424,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
     432,   433,     0,     0,   434,   435,     0,   436,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   444,   445,     0,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
     136,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,   461,     0,     0,     0,   462,
     463,   464,   465,  2854,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,   477,     0,     0,     0,     0,     0,     0,
     478,     0,     0,   479,     0,     0,     0,   480,   481,   482,
     483,   484,   485,     0,     0,     0,     0,     0,     0,   486,
     487,     0,   488,   489,   490,     0,   139,   491,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,  1584,     0,     0,  4170,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,  1585,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,  2851,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,  2852,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,  2853,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,   136,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,  2854,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,   139,   491,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,     0,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,  2628,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
    2791,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,  2255,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,   620,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,  2256,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   136,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,   139,   491,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   147,     0,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,   972,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   237,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,   973,   974,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,     0,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,   338,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,     0,   352,     0,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,     0,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,     0,     0,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,     0,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,     0,     0,   434,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,   975,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,   139,
     491,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,     0,     0,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,  1860,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,  1861,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,   739,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,  1862,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,  1863,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
     139,   491,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,  2799,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,  2800,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,     0,   239,   240,     0,   241,   242,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,   620,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,     0,   332,   333,
       0,     0,   334,   335,   336,   337,     0,     0,     0,   338,
     339,     0,     0,     0,     0,   340,   341,   342,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,     0,   352,
       0,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,     0,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,     0,     0,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,     0,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,     0,     0,   434,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,   136,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,   139,   491,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   147,     0,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,  1860,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
     338,   339,     0,     0,  1861,     0,   340,   341,   342,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,   739,
     352,     0,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,     0,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,     0,     0,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
       0,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,     0,     0,
     434,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,   462,   463,   464,   465,  1863,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,   139,   491,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,  2628,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,  2791,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,   620,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,   338,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
       0,   352,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,     0,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,     0,     0,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,     0,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,     0,
       0,   434,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,   136,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,   139,   491,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,   147,
       0,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
    1860,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,   338,   339,     0,     0,  1861,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,   739,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,  3608,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,  1863,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,   139,   491,   140,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     147,     0,   148,   149,   150,   151,   152,   153,   154,     0,
     155,     0,     0,     0,   156,     0,     0,     0,   157,     0,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,     0,     0,   165,   166,     0,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,   178,   179,   180,   181,   182,   183,   184,   185,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   199,   200,     0,   201,     0,
       0,   202,     0,     0,   203,     0,   995,     0,   204,     0,
       0,     0,   205,   206,   207,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,     0,     0,     0,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,     0,     0,   236,   237,   238,     0,     0,   239,   240,
       0,   241,   242,   243,     0,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   250,   251,
     252,   253,     0,   254,     0,     0,     0,   255,   256,   257,
       0,   258,     0,     0,     0,   259,   260,     0,     0,     0,
     261,   262,   263,   264,     0,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,     0,   270,   271,     0,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   280,     0,     0,
     281,     0,     0,   282,   283,   620,     0,     0,     0,     0,
     284,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,     0,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,     0,   306,   307,   308,   309,     0,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   316,
     317,     0,     0,   318,   319,     0,   320,     0,   321,     0,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
       0,     0,   332,   333,     0,     0,   334,   335,   336,   337,
       0,     0,     0,   338,   339,     0,     0,     0,     0,   340,
     341,   342,     0,   343,   344,   345,   346,     0,   347,   348,
       0,     0,     0,     0,     0,     0,     0,     0,   349,   350,
     351,     0,     0,   352,     0,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,     0,     0,   365,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   374,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,   389,     0,   390,   391,   392,     0,
       0,   393,     0,   394,     0,   395,   396,     0,   397,   398,
       0,     0,     0,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,     0,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,     0,     0,   415,     0,     0,     0,
     416,     0,   417,   418,   419,   420,     0,   421,   422,   423,
     424,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,   432,
     433,     0,     0,   434,   435,     0,   436,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   444,   445,     0,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,   136,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,   477,     0,     0,     0,     0,     0,     0,   478,
       0,     0,   479,     0,     0,     0,   480,   481,   482,   483,
     484,   485,     0,     0,     0,     0,     0,     0,   486,   487,
       0,   488,   489,   490,     0,   139,   491,   140,   141,   142,
     143,   144,  1384,     0,   145,     0,     0,     0,   146,     0,
       0,   147,     0,   148,   149,   150,   151,   152,   153,   154,
       0,   155,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,     0,     0,   165,   166,     0,   167,   168,
       0,   169,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,   178,   179,   180,   181,   182,   183,   184,   185,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   199,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,   210,     0,     0,     0,     0,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,     0,     0,   236,   237,   238,     0,     0,   239,
     240,     0,   241,   242,   243,     0,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,   255,   256,
     257,     0,   258,     0,     0,     0,   259,   260,     0,     0,
       0,   261,   262,   263,   264,     0,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,   271,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   280,     0,
       0,   281,     0,     0,   282,   283,   620,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,     0,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,     0,     0,   332,   333,     0,     0,   334,   335,   336,
     337,     0,     0,     0,   338,   339,     0,     0,     0,     0,
     340,   341,   342,     0,   343,   344,   345,   346,     0,   347,
     348,     0,     0,     0,     0,     0,     0,     0,     0,   349,
     350,   351,     0,     0,   352,     0,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,     0,     0,
     365,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   374,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,   389,     0,   390,   391,   392,
       0,     0,   393,     0,   394,     0,   395,   396,     0,   397,
     398,     0,     0,     0,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,     0,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,     0,     0,   415,     0,     0,
       0,   416,     0,   417,   418,   419,   420,     0,   421,   422,
     423,   424,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
     432,   433,     0,     0,   434,   435,     0,   436,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   444,   445,     0,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
     136,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,   477,     0,     0,     0,     0,     0,     0,
     478,     0,     0,   479,     0,     0,     0,   480,   481,   482,
     483,   484,   485,     0,     0,     0,     0,     0,     0,   486,
     487,     0,   488,   489,   490,     0,   139,   491,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,  2628,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,   620,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,   136,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,   139,   491,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,     0,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
    2842,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,   620,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   136,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,   139,   491,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   147,     0,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   237,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,     0,     0,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,   620,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,   338,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,     0,   352,     0,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,     0,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,     0,     0,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,     0,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,     0,     0,   434,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,   136,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,   139,
     491,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,  2781,     0,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,     0,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,   136,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
     139,   491,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,  4342,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,  4343,   236,
     237,   238,     0,     0,   239,   240,     0,   241,   242,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,     0,   332,   333,
       0,     0,   334,   335,   336,   337,     0,     0,     0,   338,
     339,     0,     0,     0,     0,   340,   341,   342,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,     0,   352,
       0,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,     0,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,     0,     0,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,     0,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,     0,     0,   434,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,   139,   491,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,   147,     0,   148,
     149,   150,   151,   152,   153,   154,     0,   155,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,   162,   163,     0,     0,   164,     0,
       0,   165,   166,     0,   167,   168,     0,   169,   170,     0,
     171,   172,   173,   174,   175,   176,   177,     0,   178,   179,
     180,   181,   182,   183,   184,   185,     0,   186,   187,   188,
     189,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,   199,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
     210,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
     218,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,   223,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,   234,   235,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,   244,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,   255,   256,   257,     0,   258,     0,
       0,     0,   259,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,   271,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,   278,   279,   280,     0,     0,   281,     0,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
     338,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,   346,     0,   347,   348,     0,     0,     0,
       0,     0,     0,     0,     0,   349,   350,   351,     0,     0,
     352,     0,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,     0,     0,   365,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,   389,     0,   390,   391,   392,     0,     0,   393,     0,
     394,     0,   395,   396,     0,   397,   398,     0,     0,     0,
     399,   400,   401,   402,   403,   404,   405,   406,   407,   408,
       0,   409,   410,     0,     0,     0,   411,   412,   413,   414,
       0,     0,     0,   415,     0,     0,     0,   416,     0,   417,
     418,   419,   420,     0,   421,   422,   423,   424,   425,   426,
       0,     0,     0,   566,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,   432,   433,     0,     0,
     434,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,   470,   471,     0,     0,
     472,     0,     0,   473,     0,   474,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,   487,     0,   488,   489,
     490,     0,   139,   491,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,   147,     0,
     148,   149,   150,   151,   152,   153,   154,     0,   155,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,   162,   163,     0,     0,   164,
       0,     0,   165,   166,     0,   167,   168,     0,   169,   170,
       0,   171,   172,   173,   174,   175,   176,   177,     0,   178,
     179,   180,   181,   182,   183,   184,   185,     0,   186,   187,
     188,   189,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,   199,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,   218,     0,     0,   219,   220,   221,     0,     0,     0,
     222,     0,   223,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,   234,   235,     0,
       0,   236,   237,   238,     0,     0,   239,   240,     0,   241,
     242,   243,     0,     0,   244,     0,     0,     0,   245,  1073,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,   255,   256,   257,     0,   258,
       0,     0,     0,   259,   260,     0,     0,     0,   261,   262,
     263,   264,     0,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,   271,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,     0,     0,     0,
     277,     0,     0,   278,   279,   280,     0,     0,   281,     0,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,     0,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,   338,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,   346,     0,   347,   348,     0,     0,
       0,     0,     0,     0,     0,     0,   349,   350,   351,     0,
       0,   352,     0,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,     0,     0,   365,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,   389,     0,   390,   391,   392,     0,     0,   393,
       0,   394,     0,   395,   396,     0,   397,   398,     0,     0,
       0,   399,   400,   401,   402,   403,   404,   405,   406,   407,
     408,     0,   409,   410,     0,     0,     0,   411,   412,   413,
     414,     0,     0,     0,   415,     0,     0,     0,   416,     0,
     417,   418,   419,   420,     0,   421,   422,   423,   424,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,   432,   433,     0,
       0,   434,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,   470,   471,     0,
       0,   472,     0,     0,   473,     0,   474,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
       0,     0,     0,     0,     0,     0,   486,   487,     0,   488,
     489,   490,     0,   139,   491,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,   147,
       0,   148,   149,   150,   151,   152,   153,   154,     0,   155,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,   162,   163,     0,     0,
     164,     0,     0,   165,   166,     0,   167,   168,     0,   169,
     170,     0,   171,   172,   173,   174,   175,   176,   177,     0,
     178,   179,   180,   181,   182,   183,   184,   185,     0,   186,
     187,   188,   189,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,   199,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,   210,     0,     0,     0,  2026,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,   218,     0,     0,   219,   220,   221,     0,     0,
       0,   222,     0,   223,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,   234,   235,
       0,     0,   236,   237,   238,     0,     0,   239,   240,     0,
     241,   242,   243,     0,     0,   244,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,   255,   256,   257,     0,
     258,     0,     0,     0,   259,   260,     0,     0,     0,   261,
     262,   263,   264,     0,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,   271,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,     0,     0,
       0,   277,     0,     0,   278,   279,   280,     0,     0,   281,
       0,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,     0,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,   338,   339,     0,     0,     0,     0,   340,   341,
     342,     0,   343,   344,   345,   346,     0,   347,   348,     0,
       0,     0,     0,     0,     0,     0,     0,   349,   350,   351,
       0,     0,   352,     0,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,     0,     0,   365,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,   389,     0,   390,   391,   392,     0,     0,
     393,     0,   394,     0,   395,   396,     0,   397,   398,     0,
       0,     0,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,     0,   409,   410,     0,     0,     0,   411,   412,
     413,   414,     0,     0,     0,   415,     0,     0,     0,   416,
       0,   417,   418,   419,   420,     0,   421,   422,   423,   424,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,   432,   433,
       0,     0,   434,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,   470,   471,
       0,     0,   472,     0,     0,   473,     0,   474,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,     0,     0,     0,     0,     0,     0,   486,   487,     0,
     488,   489,   490,     0,   139,   491,   140,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
     147,     0,   148,   149,   150,   151,   152,   153,   154,     0,
     155,     0,     0,     0,   156,     0,     0,     0,   157,     0,
       0,   158,   159,   160,     0,   161,     0,   162,   163,     0,
       0,   164,     0,     0,   165,   166,     0,   167,   168,     0,
     169,   170,     0,   171,   172,   173,   174,   175,   176,   177,
       0,   178,   179,   180,   181,   182,   183,   184,   185,     0,
     186,   187,   188,   189,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,   199,   200,     0,   201,     0,
       0,   202,     0,     0,   203,     0,     0,     0,   204,     0,
       0,     0,   205,   206,   207,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,     0,     0,  2360,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,   218,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,   223,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,   234,
     235,     0,     0,   236,   237,   238,     0,     0,   239,   240,
       0,   241,   242,   243,     0,     0,   244,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   250,   251,
     252,   253,     0,   254,     0,     0,     0,   255,   256,   257,
       0,   258,     0,     0,     0,   259,   260,     0,     0,     0,
     261,   262,   263,   264,     0,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,     0,   270,   271,     0,
       0,     0,   272,     0,   273,   274,     0,   275,   276,     0,
       0,     0,   277,     0,     0,   278,   279,   280,     0,     0,
     281,     0,     0,   282,   283,     0,     0,     0,     0,     0,
     284,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,     0,     0,     0,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,     0,   306,   307,   308,   309,     0,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   316,
     317,     0,     0,   318,   319,     0,   320,     0,   321,     0,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
       0,     0,   332,   333,     0,     0,   334,   335,   336,   337,
       0,     0,     0,   338,   339,     0,     0,     0,     0,   340,
     341,   342,     0,   343,   344,   345,   346,     0,   347,   348,
       0,     0,     0,     0,     0,     0,     0,     0,   349,   350,
     351,     0,     0,   352,     0,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,     0,     0,   365,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   374,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,   389,     0,   390,   391,   392,     0,
       0,   393,     0,   394,     0,   395,   396,     0,   397,   398,
       0,     0,     0,   399,   400,   401,   402,   403,   404,   405,
     406,   407,   408,     0,   409,   410,     0,     0,     0,   411,
     412,   413,   414,     0,     0,     0,   415,     0,     0,     0,
     416,     0,   417,   418,   419,   420,     0,   421,   422,   423,
     424,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,   432,
     433,     0,     0,   434,   435,     0,   436,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   444,   445,     0,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,  2361,   460,   461,     0,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,   470,
     471,     0,     0,   472,     0,     0,   473,     0,   474,     0,
     475,   476,   477,     0,     0,     0,     0,     0,     0,   478,
       0,     0,   479,     0,     0,     0,   480,   481,   482,   483,
     484,   485,     0,     0,     0,     0,     0,     0,   486,   487,
       0,   488,   489,   490,     0,   139,   491,   140,   141,   142,
     143,   144,  2885,     0,   145,     0,     0,     0,   146,     0,
       0,   147,     0,   148,   149,   150,   151,   152,   153,   154,
       0,   155,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,   162,   163,
       0,     0,   164,     0,     0,   165,   166,     0,   167,   168,
       0,   169,   170,     0,   171,   172,   173,   174,   175,   176,
     177,     0,   178,   179,   180,   181,   182,   183,   184,   185,
       0,   186,   187,   188,   189,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,   199,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,   210,     0,     0,     0,     0,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,   218,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,   223,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
     234,   235,     0,     0,   236,   237,   238,     0,     0,   239,
     240,     0,   241,   242,   243,     0,     0,   244,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,   255,   256,
     257,     0,   258,     0,     0,     0,   259,   260,     0,     0,
       0,   261,   262,   263,   264,     0,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,   271,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
       0,     0,     0,   277,     0,     0,   278,   279,   280,     0,
       0,   281,     0,     0,   282,   283,     0,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,     0,     0,     0,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,     0,     0,   332,   333,     0,     0,   334,   335,   336,
     337,     0,     0,     0,   338,   339,     0,     0,     0,     0,
     340,   341,   342,     0,   343,   344,   345,   346,     0,   347,
     348,     0,     0,     0,     0,     0,     0,     0,     0,   349,
     350,   351,     0,     0,   352,     0,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,     0,     0,
     365,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   374,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,   389,     0,   390,   391,   392,
       0,     0,   393,     0,   394,     0,   395,   396,     0,   397,
     398,     0,     0,     0,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,     0,   409,   410,     0,     0,     0,
     411,   412,   413,   414,     0,     0,     0,   415,     0,     0,
       0,   416,     0,   417,   418,   419,   420,     0,   421,   422,
     423,   424,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
     432,   433,     0,     0,   434,   435,     0,   436,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   444,   445,     0,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,   461,     0,     0,     0,   462,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
     470,   471,     0,     0,   472,     0,     0,   473,     0,   474,
       0,   475,   476,   477,     0,     0,     0,     0,     0,     0,
     478,     0,     0,   479,     0,     0,     0,   480,   481,   482,
     483,   484,   485,     0,     0,     0,     0,     0,     0,   486,
     487,     0,   488,   489,   490,     0,   139,   491,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,   147,     0,   148,   149,   150,   151,   152,   153,
     154,     0,   155,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,   162,
     163,     0,     0,   164,     0,     0,   165,   166,     0,   167,
     168,     0,   169,   170,     0,   171,   172,   173,   174,   175,
     176,   177,     0,   178,   179,   180,   181,   182,   183,   184,
     185,     0,   186,   187,   188,   189,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,   199,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,   218,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,   223,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,   234,   235,     0,     0,   236,   237,   238,     0,     0,
     239,   240,     0,   241,   242,   243,     0,     0,   244,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,   255,
     256,   257,     0,   258,     0,     0,     0,   259,   260,     0,
       0,     0,   261,   262,   263,   264,     0,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
     271,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,     0,     0,     0,   277,     0,     0,   278,   279,   280,
       0,     0,   281,     0,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,     0,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,   338,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,   346,     0,
     347,   348,     0,     0,     0,     0,     0,     0,     0,     0,
     349,   350,   351,     0,     0,   352,     0,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,     0,
       0,   365,   366,   367,  2972,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,   389,     0,   390,   391,
     392,     0,     0,   393,     0,   394,     0,   395,   396,     0,
     397,   398,     0,     0,     0,   399,   400,   401,   402,   403,
     404,   405,   406,   407,   408,     0,   409,   410,     0,     0,
       0,   411,   412,   413,   414,     0,     0,     0,   415,     0,
       0,     0,   416,     0,   417,   418,   419,   420,     0,   421,
     422,   423,   424,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,   432,   433,     0,     0,   434,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,   470,   471,     0,     0,   472,     0,     0,   473,     0,
     474,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,     0,     0,     0,     0,
     486,   487,     0,   488,   489,   490,     0,   139,   491,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,   147,     0,   148,   149,   150,   151,   152,
     153,   154,     0,   155,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
     162,   163,     0,     0,   164,     0,     0,   165,   166,     0,
     167,   168,     0,   169,   170,     0,   171,   172,   173,   174,
     175,   176,   177,     0,   178,   179,   180,   181,   182,   183,
     184,   185,     0,   186,   187,   188,   189,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,   199,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,   210,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,   218,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,   223,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,   234,   235,     0,     0,   236,   237,   238,     0,
       0,   239,   240,     0,   241,   242,   243,     0,     0,   244,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
     255,   256,   257,     0,   258,     0,     0,     0,   259,   260,
       0,     0,     0,   261,   262,   263,   264,     0,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,   271,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,     0,     0,     0,   277,     0,     0,   278,   279,
     280,     0,     0,   281,     0,     0,   282,   283,     0,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,     0,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,   338,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,   346,
       0,   347,   348,     0,     0,     0,     0,     0,     0,     0,
       0,   349,   350,   351,     0,     0,   352,     0,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
       0,     0,   365,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,   389,     0,   390,
     391,   392,     0,     0,   393,     0,   394,     0,   395,   396,
       0,   397,   398,     0,     0,     0,   399,   400,   401,   402,
     403,   404,   405,   406,   407,   408,     0,   409,   410,     0,
       0,     0,   411,   412,   413,   414,     0,     0,     0,   415,
       0,     0,     0,   416,     0,   417,   418,   419,   420,     0,
     421,   422,   423,   424,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,   432,   433,     0,     0,   434,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,   136,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,   470,   471,     0,     0,   472,     0,     0,   473,
       0,   474,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,     0,     0,     0,
       0,   486,   487,     0,   488,   489,   490,     0,   139,   491,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,   147,     0,   148,   149,   150,   151,
     152,   153,   154,     0,   155,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,   162,   163,     0,     0,   164,     0,     0,   165,   166,
       0,   167,   168,     0,   169,   170,     0,   171,   172,   173,
     174,   175,   176,   177,     0,   178,   179,   180,   181,   182,
     183,   184,   185,     0,   186,   187,   188,   189,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,   199,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,   210,     0,     0,
       0,  2360,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,   218,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,   223,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,   234,   235,     0,     0,   236,   237,   238,
       0,     0,   239,   240,     0,   241,   242,   243,     0,     0,
     244,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,   255,   256,   257,     0,   258,     0,     0,     0,   259,
     260,     0,     0,     0,   261,   262,   263,   264,     0,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,   271,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,     0,     0,     0,   277,     0,     0,   278,
     279,   280,     0,     0,   281,     0,     0,   282,   283,     0,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,     0,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,   338,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
     346,     0,   347,   348,     0,     0,     0,     0,     0,     0,
       0,     0,   349,   350,   351,     0,     0,   352,     0,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,     0,     0,   365,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,   389,     0,
     390,   391,   392,     0,     0,   393,     0,   394,     0,   395,
     396,     0,   397,   398,     0,     0,     0,   399,   400,   401,
     402,   403,   404,   405,   406,   407,   408,     0,   409,   410,
       0,     0,     0,   411,   412,   413,   414,     0,     0,     0,
     415,     0,     0,     0,   416,     0,   417,   418,   419,   420,
       0,   421,   422,   423,   424,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,   432,   433,     0,     0,   434,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,   470,   471,     0,     0,   472,     0,     0,
     473,     0,   474,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,     0,     0,
       0,     0,   486,   487,     0,   488,   489,   490,     0,   139,
     491,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,     0,     0,   147,     0,   148,   149,   150,
     151,   152,   153,   154,     0,   155,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,   162,   163,     0,     0,   164,     0,     0,   165,
     166,     0,   167,   168,     0,   169,   170,     0,   171,   172,
     173,   174,   175,   176,   177,     0,   178,   179,   180,   181,
     182,   183,   184,   185,     0,   186,   187,   188,   189,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
     199,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,   210,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,   218,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,   223,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,   234,   235,     0,     0,   236,   237,
     238,     0,     0,   239,   240,     0,   241,   242,   243,     0,
       0,   244,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,   255,   256,   257,     0,   258,     0,     0,     0,
     259,   260,     0,     0,     0,   261,   262,   263,   264,     0,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,   271,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,     0,     0,     0,   277,     0,     0,
     278,   279,   280,     0,     0,   281,     0,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,     0,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,   338,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,   346,     0,   347,   348,     0,     0,     0,     0,     0,
       0,     0,     0,   349,   350,   351,     0,     0,   352,     0,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,     0,     0,   365,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,   389,
       0,   390,   391,   392,     0,     0,   393,     0,   394,     0,
     395,   396,     0,   397,   398,     0,     0,     0,   399,   400,
     401,   402,   403,   404,   405,   406,   407,   408,     0,   409,
     410,     0,     0,     0,   411,   412,   413,   414,     0,     0,
       0,   415,     0,     0,     0,   416,     0,   417,   418,   419,
     420,     0,   421,   422,   423,   424,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,   432,   433,     0,     0,   434,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,   470,   471,     0,     0,   472,     0,
       0,   473,     0,   474,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,     0,
       0,     0,     0,   486,   487,     0,   488,   489,   490,     0,
     139,   491,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,   147,     0,   148,   149,
     150,   151,   152,   153,   154,     0,   155,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,   162,   163,     0,     0,   164,     0,     0,
     165,   166,     0,   167,   168,     0,   169,   170,     0,   171,
     172,   173,   174,   175,   176,   177,     0,   178,   179,   180,
     181,   182,   183,   184,   185,     0,   186,   187,   188,   189,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,   199,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,   210,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,   218,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
     223,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,   234,   235,     0,     0,   236,
     237,   238,     0,     0,   239,   240,     0,   241,  1777,   243,
       0,     0,   244,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,   255,   256,   257,     0,   258,     0,     0,
       0,   259,   260,     0,     0,     0,   261,   262,   263,   264,
       0,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,   271,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,     0,     0,     0,   277,     0,
       0,   278,   279,   280,     0,     0,   281,     0,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,     0,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,     0,   332,   333,
       0,     0,   334,  1778,   336,   337,     0,     0,     0,   338,
     339,     0,     0,     0,     0,   340,   341,   342,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,     0,     0,
       0,     0,     0,     0,   349,   350,   351,     0,     0,   352,
       0,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   363,   364,     0,     0,   365,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
     389,     0,   390,   391,   392,     0,     0,   393,     0,   394,
       0,   395,   396,     0,   397,   398,     0,     0,     0,   399,
     400,   401,   402,   403,   404,   405,   406,   407,   408,     0,
     409,   410,     0,     0,     0,   411,   412,   413,   414,     0,
       0,     0,   415,     0,     0,     0,   416,     0,   417,   418,
     419,   420,     0,   421,   422,   423,   424,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,   432,   433,     0,     0,   434,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,   470,   471,     0,     0,   472,
       0,     0,   473,     0,   474,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
       0,     0,     0,     0,   486,   487,     0,   488,   489,   490,
       0,   139,   491,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,     0,     0,   148,
     149,   150,   151,   152,   153,     0,     0,  -329,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,     0,     0,     0,     0,   164,  3892,
       0,   165,   166,     0,   167,     0,     0,     0,     0,     0,
     171,   172,   173,   174,  3893,   176,   177,     0,   178,   179,
       0,     0,     0,     0,     0,     0,     0,   186,     0,   188,
       0,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,     0,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
       0,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
       0,     0,     0,   219,   220,   221,     0,  -299,  -299,   222,
       0,  -299,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,     0,     0,     0,     0,
     236,   237,   238,     0,     0,   239,   240,  3894,   241,   242,
     243,     0,     0,     0,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,     0,   256,   257,     0,     0,     0,
       0,     0,     0,   260,     0,     0,     0,   261,   262,   263,
     264,  3895,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,     0,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,  3896,     0,     0,   277,
       0,     0,     0,   279,   280,     0,     0,   281,  3897,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
    -284,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
       0,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,  3898,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   350,   351,     0,     0,
       0,     0,   353,   354,   355,     0,   357,   358,   359,   360,
     361,   362,   363,     0,     0,     0,     0,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,     0,     0,   390,     0,   392,  -284,     0,   393,     0,
       0,     0,   395,     0,     0,   397,   398,  3899,     0,     0,
       0,   400,   401,   402,   403,   404,   405,     0,   407,   408,
       0,   409,     0,     0,     0,     0,   411,   412,   413,     0,
       0,     0,     0,   415,     0,     0,     0,   416,     0,     0,
     418,     0,   420,     0,   421,     0,   423,     0,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,     0,   433,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,     0,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,     0,     0,     0,     0,
     472,     0,     0,   473,     0,     0,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,  -284,     0,     0,     0,   486,     0,     0,   488,     0,
     490,     0,   139,   491,   140,   141,   142,   143,   144,     0,
       0,   145,     0,     0,     0,   146,     0,     0,     0,     0,
     148,   149,   150,   151,   152,   153,     0,     0,  -329,     0,
       0,     0,   156,     0,     0,     0,   157,     0,     0,   158,
     159,   160,     0,   161,     0,     0,     0,     0,     0,   164,
    3892,     0,   165,   166,     0,   167,     0,     0,     0,     0,
       0,   171,   172,   173,   174,  3893,   176,   177,     0,   178,
     179,     0,     0,     0,     0,     0,     0,     0,   186,     0,
     188,     0,   190,   191,   192,   193,     0,   194,   195,     0,
     196,   197,   198,     0,   200,     0,   201,     0,     0,   202,
       0,     0,   203,     0,     0,     0,   204,     0,     0,     0,
     205,   206,   207,     0,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,     0,   211,     0,   212,     0,
       0,     0,   213,     0,   214,   215,   216,   217,     0,     0,
       0,     0,     0,     0,   219,   220,   221,     0,  -320,     0,
     222,     0,  -320,   224,     0,   225,   226,   227,     0,     0,
     228,   229,     0,   230,   231,   232,   233,     0,     0,     0,
       0,   236,   237,   238,     0,     0,   239,   240,  3894,   241,
     242,   243,     0,     0,     0,     0,     0,     0,   245,     0,
     246,     0,   247,     0,   248,   249,   250,   251,   252,   253,
       0,   254,     0,     0,     0,     0,   256,   257,     0,     0,
       0,     0,     0,     0,   260,     0,     0,     0,   261,   262,
     263,   264,  3895,     0,   265,   266,   267,     0,   268,     0,
     269,     0,     0,     0,     0,   270,     0,     0,     0,     0,
     272,     0,   273,   274,     0,   275,   276,  3896,     0,     0,
     277,     0,     0,     0,   279,   280,     0,     0,   281,  3897,
       0,   282,   283,     0,     0,     0,     0,     0,   284,   285,
       0,   286,     0,   287,     0,   288,   289,     0,     0,     0,
       0,  -284,     0,     0,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,     0,   303,   304,
     305,     0,   306,   307,   308,   309,     0,   310,   311,     0,
       0,     0,     0,   312,   313,   314,   315,   316,   317,     0,
       0,   318,   319,     0,   320,     0,   321,     0,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,     0,     0,
     332,   333,     0,     0,   334,   335,   336,   337,     0,     0,
       0,     0,   339,     0,     0,     0,     0,   340,   341,   342,
       0,   343,   344,   345,  3898,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   350,   351,     0,
       0,     0,     0,   353,   354,   355,     0,   357,   358,   359,
     360,   361,   362,   363,     0,     0,     0,     0,   366,   367,
       0,   368,     0,   369,   370,   371,   372,   373,     0,   374,
     375,   376,     0,     0,   377,     0,     0,     0,   378,   379,
     380,   381,   382,     0,     0,   383,   384,   385,   386,   387,
       0,   388,     0,     0,   390,     0,   392,  -284,     0,   393,
       0,     0,     0,   395,     0,     0,   397,   398,  3899,     0,
       0,     0,   400,   401,   402,   403,   404,   405,     0,   407,
     408,     0,   409,     0,     0,     0,     0,   411,   412,   413,
       0,     0,     0,     0,   415,     0,     0,     0,   416,     0,
       0,   418,     0,   420,     0,   421,     0,   423,     0,   425,
     426,     0,     0,     0,     0,     0,     0,   427,   428,     0,
     429,     0,     0,   430,     0,     0,   431,     0,   433,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,     0,   442,   443,   444,   445,     0,   446,   447,     0,
     448,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,   461,     0,     0,     0,     0,   463,   464,   465,
       0,   466,   467,     0,   468,   469,     0,     0,     0,     0,
       0,   472,     0,     0,   473,     0,     0,     0,   475,   476,
     477,     0,     0,     0,     0,     0,     0,   478,     0,     0,
     479,     0,     0,     0,   480,   481,   482,   483,   484,   485,
    -320,     0,  -284,     0,     0,     0,   486,     0,     0,   488,
       0,   490,     0,   139,   491,   140,   141,   142,   143,   144,
       0,     0,   145,     0,     0,     0,   146,     0,     0,     0,
       0,   148,   149,   150,   151,   152,   153,     0,     0,  -329,
       0,     0,     0,   156,     0,     0,     0,   157,     0,     0,
     158,   159,   160,     0,   161,     0,     0,     0,     0,     0,
     164,  3892,     0,   165,   166,     0,   167,     0,     0,     0,
       0,     0,   171,   172,   173,   174,  3893,   176,   177,     0,
     178,   179,     0,     0,     0,     0,     0,     0,     0,   186,
       0,   188,     0,   190,   191,   192,   193,     0,   194,   195,
       0,   196,   197,   198,     0,   200,     0,   201,     0,     0,
     202,     0,     0,   203,     0,     0,     0,   204,     0,     0,
       0,   205,   206,   207,     0,     0,   208,     0,     0,     0,
       0,   209,     0,     0,     0,     0,     0,   211,     0,   212,
       0,     0,     0,   213,     0,   214,   215,   216,   217,     0,
       0,     0,     0,     0,     0,   219,   220,   221,     0,  -317,
       0,   222,     0,  -317,   224,     0,   225,   226,   227,     0,
       0,   228,   229,     0,   230,   231,   232,   233,     0,     0,
       0,     0,   236,   237,   238,     0,     0,   239,   240,  3894,
     241,   242,   243,     0,     0,     0,     0,     0,     0,   245,
       0,   246,     0,   247,     0,   248,   249,   250,   251,   252,
     253,     0,   254,     0,     0,     0,     0,   256,   257,     0,
       0,     0,     0,     0,     0,   260,     0,     0,     0,   261,
     262,   263,   264,  3895,     0,   265,   266,   267,     0,   268,
       0,   269,     0,     0,     0,     0,   270,     0,     0,     0,
       0,   272,     0,   273,   274,     0,   275,   276,  3896,     0,
       0,   277,     0,     0,     0,   279,   280,     0,     0,   281,
    3897,     0,   282,   283,     0,     0,     0,     0,     0,   284,
     285,     0,   286,     0,   287,     0,   288,   289,     0,     0,
       0,     0,  -284,     0,     0,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,     0,   303,
     304,   305,     0,   306,   307,   308,   309,     0,   310,   311,
       0,     0,     0,     0,   312,   313,   314,   315,   316,   317,
       0,     0,   318,   319,     0,   320,     0,   321,     0,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,     0,
       0,   332,   333,     0,     0,   334,   335,   336,   337,     0,
       0,     0,     0,   339,     0,     0,     0,     0,   340,   341,
     342,     0,   343,   344,   345,  3898,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   350,   351,
       0,     0,     0,     0,   353,   354,   355,     0,   357,   358,
     359,   360,   361,   362,   363,     0,     0,     0,     0,   366,
     367,     0,   368,     0,   369,   370,   371,   372,   373,     0,
     374,   375,   376,     0,     0,   377,     0,     0,     0,   378,
     379,   380,   381,   382,     0,     0,   383,   384,   385,   386,
     387,     0,   388,     0,     0,   390,     0,   392,  -284,     0,
     393,     0,     0,     0,   395,     0,     0,   397,   398,  3899,
       0,     0,     0,   400,   401,   402,   403,   404,   405,     0,
     407,   408,     0,   409,     0,     0,     0,     0,   411,   412,
     413,     0,     0,     0,     0,   415,     0,     0,     0,   416,
       0,     0,   418,     0,   420,     0,   421,     0,   423,     0,
     425,   426,     0,     0,     0,     0,     0,     0,   427,   428,
       0,   429,     0,     0,   430,     0,     0,   431,     0,   433,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,     0,   442,   443,   444,   445,     0,   446,   447,
       0,   448,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,   461,     0,     0,     0,     0,   463,   464,
     465,     0,   466,   467,     0,   468,   469,     0,     0,     0,
       0,     0,   472,     0,     0,   473,     0,     0,     0,   475,
     476,   477,     0,     0,     0,     0,     0,     0,   478,     0,
       0,   479,     0,     0,     0,   480,   481,   482,   483,   484,
     485,  -317,     0,  -284,     0,     0,     0,   486,     0,     0,
     488,     0,   490,     0,   139,   491,   140,   141,   142,   143,
     144,     0,     0,   145,     0,     0,     0,   146,     0,     0,
       0,     0,   148,   149,   150,   151,   152,   153,     0,     0,
    -329,     0,     0,     0,   156,     0,     0,     0,   157,     0,
       0,   158,   159,   160,     0,   161,     0,     0,     0,     0,
       0,   164,  3892,     0,   165,   166,     0,   167,     0,     0,
       0,     0,     0,   171,   172,   173,   174,  3893,   176,   177,
       0,   178,   179,     0,     0,     0,     0,     0,     0,     0,
     186,     0,   188,     0,   190,   191,   192,   193,     0,   194,
     195,     0,   196,   197,   198,     0,   200,     0,   201,     0,
       0,   202,     0,     0,   203,     0,     0,     0,   204,     0,
       0,     0,   205,   206,   207,     0,     0,   208,     0,     0,
       0,     0,   209,     0,     0,     0,     0,     0,   211,     0,
     212,     0,     0,     0,   213,     0,   214,   215,   216,   217,
       0,     0,     0,     0,     0,     0,   219,   220,   221,     0,
       0,     0,   222,     0,  4232,   224,     0,   225,   226,   227,
       0,     0,   228,   229,     0,   230,   231,   232,   233,     0,
       0,     0,     0,   236,   237,   238,     0,     0,   239,   240,
    3894,   241,   242,   243,     0,     0,     0,     0,     0,     0,
     245,     0,   246,     0,   247,     0,   248,   249,   250,   251,
     252,   253,     0,   254,     0,     0,     0,     0,   256,   257,
       0,     0,     0,     0,     0,     0,   260,     0,     0,     0,
     261,   262,   263,   264,  3895,     0,   265,   266,   267,     0,
     268,     0,   269,     0,     0,     0,     0,   270,     0,     0,
       0,     0,   272,     0,   273,   274,     0,   275,   276,  3896,
       0,     0,   277,     0,     0,     0,   279,   280,     0,     0,
     281,  3897,     0,   282,   283,     0,     0,     0,     0,     0,
     284,   285,     0,   286,     0,   287,     0,   288,   289,     0,
       0,     0,     0,  -284,     0,     0,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,     0,
     303,   304,   305,     0,   306,   307,   308,   309,     0,   310,
     311,     0,     0,     0,     0,   312,   313,   314,   315,   316,
     317,     0,     0,   318,   319,     0,   320,     0,   321,     0,
     322,   323,   324,   325,   326,   327,   328,   329,   330,   331,
       0,     0,   332,   333,     0,     0,   334,   335,   336,   337,
       0,     0,     0,     0,   339,     0,     0,     0,     0,   340,
     341,   342,     0,   343,   344,   345,  3898,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   350,
     351,     0,     0,     0,     0,   353,   354,   355,     0,   357,
     358,   359,   360,   361,   362,   363,     0,     0,     0,     0,
     366,   367,     0,   368,     0,   369,   370,   371,   372,   373,
       0,   374,   375,   376,     0,     0,   377,     0,     0,     0,
     378,   379,   380,   381,   382,     0,     0,   383,   384,   385,
     386,   387,     0,   388,     0,     0,   390,     0,   392,  -284,
       0,   393,     0,     0,     0,   395,     0,     0,   397,   398,
    3899,     0,     0,     0,   400,   401,   402,   403,   404,   405,
       0,   407,   408,     0,   409,     0,     0,     0,     0,   411,
     412,   413,     0,     0,     0,     0,   415,     0,     0,     0,
     416,     0,     0,   418,     0,   420,     0,   421,     0,   423,
       0,   425,   426,     0,     0,     0,     0,     0,     0,   427,
     428,     0,   429,     0,     0,   430,     0,     0,   431,     0,
     433,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,     0,   442,   443,   444,   445,     0,   446,
     447,     0,   448,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,   461,     0,     0,     0,     0,   463,
     464,   465,     0,   466,   467,     0,   468,   469,     0,     0,
       0,     0,     0,   472,     0,     0,   473,     0,     0,     0,
     475,   476,   477,     0,     0,     0,     0,     0,     0,   478,
       0,     0,   479,     0,     0,     0,   480,   481,   482,   483,
     484,   485,     0,     0,  -284,     0,     0,     0,   486,     0,
       0,   488,     0,   490,     0,   139,   491,   140,   141,   142,
     143,   144,     0,     0,   145,     0,     0,     0,   146,     0,
       0,     0,     0,   148,   149,   150,   151,   152,   153,     0,
       0,  -329,     0,     0,     0,   156,     0,     0,     0,   157,
       0,     0,   158,   159,   160,     0,   161,     0,     0,     0,
       0,     0,   164,  3892,     0,   165,   166,     0,   167,     0,
       0,     0,     0,     0,   171,   172,   173,   174,  3893,   176,
     177,     0,   178,   179,     0,     0,     0,     0,     0,     0,
       0,   186,     0,   188,     0,   190,   191,   192,   193,     0,
     194,   195,     0,   196,   197,   198,     0,   200,     0,   201,
       0,     0,   202,     0,     0,   203,     0,     0,     0,   204,
       0,     0,     0,   205,   206,   207,     0,     0,   208,     0,
       0,     0,     0,   209,     0,     0,     0,     0,     0,   211,
       0,   212,     0,     0,     0,   213,     0,   214,   215,   216,
     217,     0,     0,     0,     0,     0,     0,   219,   220,   221,
       0,     0,     0,   222,     0,  -322,   224,     0,   225,   226,
     227,     0,     0,   228,   229,     0,   230,   231,   232,   233,
       0,     0,     0,     0,   236,   237,   238,     0,     0,   239,
     240,  3894,   241,   242,   243,     0,     0,     0,     0,     0,
       0,   245,     0,   246,     0,   247,     0,   248,   249,   250,
     251,   252,   253,     0,   254,     0,     0,     0,     0,   256,
     257,     0,     0,     0,     0,     0,     0,   260,     0,     0,
       0,   261,   262,   263,   264,  3895,     0,   265,   266,   267,
       0,   268,     0,   269,     0,     0,     0,     0,   270,     0,
       0,     0,     0,   272,     0,   273,   274,     0,   275,   276,
    3896,     0,     0,   277,     0,     0,     0,   279,   280,     0,
       0,   281,  3897,     0,   282,   283,     0,     0,     0,     0,
       0,   284,   285,     0,   286,     0,   287,     0,   288,   289,
       0,     0,     0,     0,  -284,     0,     0,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
       0,   303,   304,   305,     0,   306,   307,   308,   309,     0,
     310,   311,     0,     0,     0,     0,   312,   313,   314,   315,
     316,   317,     0,     0,   318,   319,     0,   320,     0,   321,
       0,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,     0,     0,   332,   333,     0,     0,   334,   335,   336,
     337,     0,     0,     0,     0,   339,     0,     0,     0,     0,
     340,   341,   342,     0,   343,   344,   345,  3898,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     350,   351,     0,     0,     0,     0,   353,   354,   355,     0,
     357,   358,   359,   360,   361,   362,   363,     0,     0,     0,
       0,   366,   367,     0,   368,     0,   369,   370,   371,   372,
     373,     0,   374,   375,   376,     0,     0,   377,     0,     0,
       0,   378,   379,   380,   381,   382,     0,     0,   383,   384,
     385,   386,   387,     0,   388,     0,     0,   390,     0,   392,
    -284,     0,   393,     0,     0,     0,   395,     0,     0,   397,
     398,  3899,     0,     0,     0,   400,   401,   402,   403,   404,
     405,     0,   407,   408,     0,   409,     0,     0,     0,     0,
     411,   412,   413,     0,     0,     0,     0,   415,     0,     0,
       0,   416,     0,     0,   418,     0,   420,     0,   421,     0,
     423,     0,   425,   426,     0,     0,     0,     0,     0,     0,
     427,   428,     0,   429,     0,     0,   430,     0,     0,   431,
       0,   433,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,     0,   442,   443,   444,   445,     0,
     446,   447,     0,   448,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,   461,     0,     0,     0,     0,
     463,   464,   465,     0,   466,   467,     0,   468,   469,     0,
       0,     0,     0,     0,   472,     0,     0,   473,     0,     0,
       0,   475,   476,   477,     0,     0,     0,     0,     0,     0,
     478,     0,     0,   479,     0,     0,     0,   480,   481,   482,
     483,   484,   485,     0,     0,  -284,     0,     0,     0,   486,
       0,     0,   488,     0,   490,     0,   139,   491,   140,   141,
     142,   143,   144,     0,     0,   145,     0,     0,     0,   146,
       0,     0,     0,     0,   148,   149,   150,   151,   152,   153,
       0,     0,  -329,     0,     0,     0,   156,     0,     0,     0,
     157,     0,     0,   158,   159,   160,     0,   161,     0,     0,
       0,     0,     0,   164,  3892,     0,   165,   166,     0,   167,
       0,     0,     0,     0,     0,   171,   172,   173,   174,  3893,
     176,   177,     0,   178,   179,     0,     0,     0,     0,     0,
       0,     0,   186,     0,   188,     0,   190,   191,   192,   193,
       0,   194,   195,     0,   196,   197,   198,     0,   200,     0,
     201,     0,     0,   202,     0,     0,   203,     0,     0,     0,
     204,     0,     0,     0,   205,   206,   207,     0,     0,   208,
       0,     0,     0,     0,   209,     0,     0,     0,     0,     0,
     211,     0,   212,     0,     0,     0,   213,     0,   214,   215,
     216,   217,     0,     0,     0,     0,     0,     0,   219,   220,
     221,     0,     0,     0,   222,     0,  4347,   224,     0,   225,
     226,   227,     0,     0,   228,   229,     0,   230,   231,   232,
     233,     0,     0,     0,     0,   236,   237,   238,     0,     0,
     239,   240,  3894,   241,   242,   243,     0,     0,     0,     0,
       0,     0,   245,     0,   246,     0,   247,     0,   248,   249,
     250,   251,   252,   253,     0,   254,     0,     0,     0,     0,
     256,   257,     0,     0,     0,     0,     0,     0,   260,     0,
       0,     0,   261,   262,   263,   264,  3895,     0,   265,   266,
     267,     0,   268,     0,   269,     0,     0,     0,     0,   270,
       0,     0,     0,     0,   272,     0,   273,   274,     0,   275,
     276,  3896,     0,     0,   277,     0,     0,     0,   279,   280,
       0,     0,   281,  3897,     0,   282,   283,     0,     0,     0,
       0,     0,   284,   285,     0,   286,     0,   287,     0,   288,
     289,     0,     0,     0,     0,  -284,     0,     0,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,   301,
     302,     0,   303,   304,   305,     0,   306,   307,   308,   309,
       0,   310,   311,     0,     0,     0,     0,   312,   313,   314,
     315,   316,   317,     0,     0,   318,   319,     0,   320,     0,
     321,     0,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,     0,     0,   332,   333,     0,     0,   334,   335,
     336,   337,     0,     0,     0,     0,   339,     0,     0,     0,
       0,   340,   341,   342,     0,   343,   344,   345,  3898,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   350,   351,     0,     0,     0,     0,   353,   354,   355,
       0,   357,   358,   359,   360,   361,   362,   363,     0,     0,
       0,     0,   366,   367,     0,   368,     0,   369,   370,   371,
     372,   373,     0,   374,   375,   376,     0,     0,   377,     0,
       0,     0,   378,   379,   380,   381,   382,     0,     0,   383,
     384,   385,   386,   387,     0,   388,     0,     0,   390,     0,
     392,  -284,     0,   393,     0,     0,     0,   395,     0,     0,
     397,   398,  3899,     0,     0,     0,   400,   401,   402,   403,
     404,   405,     0,   407,   408,     0,   409,     0,     0,     0,
       0,   411,   412,   413,     0,     0,     0,     0,   415,     0,
       0,     0,   416,     0,     0,   418,     0,   420,     0,   421,
       0,   423,     0,   425,   426,     0,     0,     0,     0,     0,
       0,   427,   428,     0,   429,     0,     0,   430,     0,     0,
     431,     0,   433,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,     0,   442,   443,   444,   445,
       0,   446,   447,     0,   448,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,   461,     0,     0,     0,
       0,   463,   464,   465,     0,   466,   467,     0,   468,   469,
       0,     0,     0,     0,     0,   472,     0,     0,   473,     0,
       0,     0,   475,   476,   477,     0,     0,     0,     0,     0,
       0,   478,     0,     0,   479,     0,     0,     0,   480,   481,
     482,   483,   484,   485,     0,     0,  -284,     0,     0,     0,
     486,     0,     0,   488,     0,   490,     0,   139,   491,   140,
     141,   142,   143,   144,     0,     0,   145,     0,     0,     0,
     146,     0,     0,     0,     0,   148,   149,   150,   151,   152,
     153,     0,     0,  -329,     0,     0,     0,   156,     0,     0,
       0,   157,     0,     0,   158,   159,   160,     0,   161,     0,
       0,     0,     0,     0,   164,  3892,     0,   165,   166,     0,
     167,     0,     0,     0,     0,     0,   171,   172,   173,   174,
    3893,   176,   177,     0,   178,   179,     0,     0,     0,     0,
       0,     0,     0,   186,     0,   188,     0,   190,   191,   192,
     193,     0,   194,   195,     0,   196,   197,   198,     0,   200,
       0,   201,     0,     0,   202,     0,     0,   203,     0,     0,
       0,   204,     0,     0,     0,   205,   206,   207,     0,     0,
     208,     0,     0,     0,     0,   209,     0,     0,     0,     0,
       0,   211,     0,   212,     0,     0,     0,   213,     0,   214,
     215,   216,   217,     0,     0,     0,     0,     0,     0,   219,
     220,   221,     0,     0,     0,   222,     0,  4396,   224,     0,
     225,   226,   227,     0,     0,   228,   229,     0,   230,   231,
     232,   233,     0,     0,     0,     0,   236,   237,   238,     0,
       0,   239,   240,  3894,   241,   242,   243,     0,     0,     0,
       0,     0,     0,   245,     0,   246,     0,   247,     0,   248,
     249,   250,   251,   252,   253,     0,   254,     0,     0,     0,
       0,   256,   257,     0,     0,     0,     0,     0,     0,   260,
       0,     0,     0,   261,   262,   263,   264,  3895,     0,   265,
     266,   267,     0,   268,     0,   269,     0,     0,     0,     0,
     270,     0,     0,     0,     0,   272,     0,   273,   274,     0,
     275,   276,  3896,     0,     0,   277,     0,     0,     0,   279,
     280,     0,     0,   281,  3897,     0,   282,   283,     0,     0,
       0,     0,     0,   284,   285,     0,   286,     0,   287,     0,
     288,   289,     0,     0,     0,     0,  -284,     0,     0,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,     0,   303,   304,   305,     0,   306,   307,   308,
     309,     0,   310,   311,     0,     0,     0,     0,   312,   313,
     314,   315,   316,   317,     0,     0,   318,   319,     0,   320,
       0,   321,     0,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,     0,     0,   332,   333,     0,     0,   334,
     335,   336,   337,     0,     0,     0,     0,   339,     0,     0,
       0,     0,   340,   341,   342,     0,   343,   344,   345,  3898,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   350,   351,     0,     0,     0,     0,   353,   354,
     355,     0,   357,   358,   359,   360,   361,   362,   363,     0,
       0,     0,     0,   366,   367,     0,   368,     0,   369,   370,
     371,   372,   373,     0,   374,   375,   376,     0,     0,   377,
       0,     0,     0,   378,   379,   380,   381,   382,     0,     0,
     383,   384,   385,   386,   387,     0,   388,     0,     0,   390,
       0,   392,  -284,     0,   393,     0,     0,     0,   395,     0,
       0,   397,   398,  3899,     0,     0,     0,   400,   401,   402,
     403,   404,   405,     0,   407,   408,     0,   409,     0,     0,
       0,     0,   411,   412,   413,     0,     0,     0,     0,   415,
       0,     0,     0,   416,     0,     0,   418,     0,   420,     0,
     421,     0,   423,     0,   425,   426,     0,     0,     0,     0,
       0,     0,   427,   428,     0,   429,     0,     0,   430,     0,
       0,   431,     0,   433,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,     0,   442,   443,   444,
     445,     0,   446,   447,     0,   448,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,   461,     0,     0,
       0,     0,   463,   464,   465,     0,   466,   467,     0,   468,
     469,     0,     0,     0,     0,     0,   472,     0,     0,   473,
       0,     0,     0,   475,   476,   477,     0,     0,     0,     0,
       0,     0,   478,     0,     0,   479,     0,     0,     0,   480,
     481,   482,   483,   484,   485,     0,     0,  -284,     0,     0,
       0,   486,     0,     0,   488,     0,   490,     0,   139,   491,
     140,   141,   142,   143,   144,     0,     0,   145,     0,     0,
       0,   146,     0,     0,     0,     0,   148,   149,   150,   151,
     152,   153,     0,     0,  -329,     0,     0,     0,   156,     0,
       0,     0,   157,     0,     0,   158,   159,   160,     0,   161,
       0,     0,     0,     0,     0,   164,  3892,     0,   165,   166,
       0,   167,     0,     0,     0,     0,     0,   171,   172,   173,
     174,  3893,   176,   177,     0,   178,   179,     0,     0,     0,
       0,     0,     0,     0,   186,     0,   188,     0,   190,   191,
     192,   193,     0,   194,   195,     0,   196,   197,   198,     0,
     200,     0,   201,     0,     0,   202,     0,     0,   203,     0,
       0,     0,   204,     0,     0,     0,   205,   206,   207,     0,
       0,   208,     0,     0,     0,     0,   209,     0,     0,     0,
       0,     0,   211,     0,   212,     0,     0,     0,   213,     0,
     214,   215,   216,   217,     0,     0,     0,     0,     0,     0,
     219,   220,   221,     0,     0,     0,   222,     0,  -303,   224,
       0,   225,   226,   227,     0,     0,   228,   229,     0,   230,
     231,   232,   233,     0,     0,     0,     0,   236,   237,   238,
       0,     0,   239,   240,  3894,   241,   242,   243,     0,     0,
       0,     0,     0,     0,   245,     0,   246,     0,   247,     0,
     248,   249,   250,   251,   252,   253,     0,   254,     0,     0,
       0,     0,   256,   257,     0,     0,     0,     0,     0,     0,
     260,     0,     0,     0,   261,   262,   263,   264,  3895,     0,
     265,   266,   267,     0,   268,     0,   269,     0,     0,     0,
       0,   270,     0,     0,     0,     0,   272,     0,   273,   274,
       0,   275,   276,  3896,     0,     0,   277,     0,     0,     0,
     279,   280,     0,     0,   281,  3897,     0,   282,   283,     0,
       0,     0,     0,     0,   284,   285,     0,   286,     0,   287,
       0,   288,   289,     0,     0,     0,     0,  -284,     0,     0,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,     0,   303,   304,   305,     0,   306,   307,
     308,   309,     0,   310,   311,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,     0,     0,   318,   319,     0,
     320,     0,   321,     0,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,     0,     0,   332,   333,     0,     0,
     334,   335,   336,   337,     0,     0,     0,     0,   339,     0,
       0,     0,     0,   340,   341,   342,     0,   343,   344,   345,
    3898,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   350,   351,     0,     0,     0,     0,   353,
     354,   355,     0,   357,   358,   359,   360,   361,   362,   363,
       0,     0,     0,     0,   366,   367,     0,   368,     0,   369,
     370,   371,   372,   373,     0,   374,   375,   376,     0,     0,
     377,     0,     0,     0,   378,   379,   380,   381,   382,     0,
       0,   383,   384,   385,   386,   387,     0,   388,     0,     0,
     390,     0,   392,  -284,     0,   393,     0,     0,     0,   395,
       0,     0,   397,   398,  3899,     0,     0,     0,   400,   401,
     402,   403,   404,   405,     0,   407,   408,     0,   409,     0,
       0,     0,     0,   411,   412,   413,     0,     0,     0,     0,
     415,     0,     0,     0,   416,     0,     0,   418,     0,   420,
       0,   421,     0,   423,     0,   425,   426,     0,     0,     0,
       0,     0,     0,   427,   428,     0,   429,     0,     0,   430,
       0,     0,   431,     0,   433,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,     0,   442,   443,
     444,   445,     0,   446,   447,     0,   448,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,   461,     0,
       0,     0,     0,   463,   464,   465,     0,   466,   467,     0,
     468,   469,     0,     0,     0,     0,     0,   472,     0,     0,
     473,     0,     0,     0,   475,   476,   477,     0,     0,     0,
       0,     0,     0,   478,     0,     0,   479,     0,     0,     0,
     480,   481,   482,   483,   484,   485,     0,     0,  -284,     0,
       0,     0,   486,     0,     0,   488,     0,   490,     0,   139,
     491,   140,   141,   142,   143,   144,     0,     0,   145,     0,
       0,     0,   146,     0,     0,     0,     0,   148,   149,   150,
     151,   152,   153,     0,     0,  -329,     0,     0,     0,   156,
       0,     0,     0,   157,     0,     0,   158,   159,   160,     0,
     161,     0,     0,     0,     0,     0,   164,  3892,     0,   165,
     166,     0,   167,     0,     0,     0,     0,     0,   171,   172,
     173,   174,  3893,   176,   177,     0,   178,   179,     0,     0,
       0,     0,     0,     0,     0,   186,     0,   188,     0,   190,
     191,   192,   193,     0,   194,   195,     0,   196,   197,   198,
       0,   200,     0,   201,     0,     0,   202,     0,     0,   203,
       0,     0,     0,   204,     0,     0,     0,   205,   206,   207,
       0,     0,   208,     0,     0,     0,     0,   209,     0,     0,
       0,     0,     0,   211,     0,   212,     0,     0,     0,   213,
       0,   214,   215,   216,   217,     0,     0,     0,     0,     0,
       0,   219,   220,   221,     0,     0,     0,   222,     0,     0,
     224,     0,   225,   226,   227,     0,     0,   228,   229,     0,
     230,   231,   232,   233,     0,     0,     0,     0,   236,   237,
     238,     0,     0,   239,   240,  3894,   241,   242,   243,     0,
       0,     0,     0,     0,     0,   245,     0,   246,     0,   247,
       0,   248,   249,   250,   251,   252,   253,     0,   254,     0,
       0,     0,     0,   256,   257,     0,     0,     0,     0,     0,
       0,   260,     0,     0,     0,   261,   262,   263,   264,  3895,
       0,   265,   266,   267,     0,   268,     0,   269,     0,     0,
       0,     0,   270,     0,     0,     0,     0,   272,     0,   273,
     274,     0,   275,   276,  3896,     0,     0,   277,     0,     0,
       0,   279,   280,     0,     0,   281,  3897,     0,   282,   283,
       0,     0,     0,     0,     0,   284,   285,     0,   286,     0,
     287,     0,   288,   289,     0,     0,     0,     0,  -284,     0,
       0,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,     0,   303,   304,   305,     0,   306,
     307,   308,   309,     0,   310,   311,     0,     0,     0,     0,
     312,   313,   314,   315,   316,   317,     0,     0,   318,   319,
       0,   320,     0,   321,     0,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,     0,     0,   332,   333,     0,
       0,   334,   335,   336,   337,     0,     0,     0,     0,   339,
       0,     0,     0,     0,   340,   341,   342,     0,   343,   344,
     345,  3898,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   350,   351,     0,     0,     0,     0,
     353,   354,   355,     0,   357,   358,   359,   360,   361,   362,
     363,     0,     0,     0,     0,   366,   367,     0,   368,     0,
     369,   370,   371,   372,   373,     0,   374,   375,   376,     0,
       0,   377,     0,     0,     0,   378,   379,   380,   381,   382,
       0,     0,   383,   384,   385,   386,   387,     0,   388,     0,
       0,   390,     0,   392,  -284,     0,   393,     0,     0,     0,
     395,     0,     0,   397,   398,  3899,     0,     0,     0,   400,
     401,   402,   403,   404,   405,     0,   407,   408,     0,   409,
       0,     0,     0,     0,   411,   412,   413,     0,     0,     0,
       0,   415,     0,     0,     0,   416,     0,     0,   418,     0,
     420,     0,   421,     0,   423,     0,   425,   426,     0,     0,
       0,     0,     0,     0,   427,   428,     0,   429,     0,     0,
     430,     0,     0,   431,     0,   433,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,     0,   442,
     443,   444,   445,     0,   446,   447,     0,   448,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,   461,
       0,     0,     0,     0,   463,   464,   465,     0,   466,   467,
       0,   468,   469,     0,     0,     0,     0,     0,   472,     0,
       0,   473,     0,     0,     0,   475,   476,   477,     0,     0,
       0,     0,     0,     0,   478,     0,     0,   479,     0,     0,
       0,   480,   481,   482,   483,   484,   485,     0,     0,  -284,
       0,     0,     0,   486,     0,     0,   488,     0,   490,     0,
     139,   491,   140,   141,   142,   143,   144,     0,     0,   145,
       0,     0,     0,   146,     0,     0,     0,     0,   148,   149,
     150,   151,   152,   153,     0,     0,  -329,     0,     0,     0,
     156,     0,     0,     0,   157,     0,     0,   158,   159,   160,
       0,   161,     0,     0,     0,     0,     0,   164,  3892,     0,
     165,   166,     0,   167,     0,     0,     0,     0,     0,   171,
     172,   173,   174,  3893,   176,   177,     0,   178,   179,     0,
       0,     0,     0,     0,     0,     0,   186,     0,   188,     0,
     190,   191,   192,   193,     0,   194,   195,     0,   196,   197,
     198,     0,   200,     0,   201,     0,     0,   202,     0,     0,
     203,     0,     0,     0,   204,     0,     0,     0,   205,   206,
     207,     0,     0,   208,     0,     0,     0,     0,   209,     0,
       0,     0,     0,     0,   211,     0,   212,     0,     0,     0,
     213,     0,   214,   215,   216,   217,     0,     0,     0,     0,
       0,     0,   219,   220,   221,     0,     0,     0,   222,     0,
       0,   224,     0,   225,   226,   227,     0,     0,   228,   229,
       0,   230,   231,   232,   233,     0,     0,     0,     0,   236,
     237,   238,     0,     0,   239,   240,  3894,   241,   242,   243,
       0,     0,     0,     0,     0,     0,   245,     0,   246,     0,
     247,     0,   248,   249,   250,   251,   252,   253,     0,   254,
       0,     0,     0,     0,   256,   257,     0,     0,     0,     0,
       0,     0,   260,     0,     0,     0,   261,   262,   263,   264,
    3895,     0,   265,   266,   267,     0,   268,     0,   269,     0,
       0,     0,     0,   270,     0,     0,     0,     0,   272,     0,
     273,   274,     0,   275,   276,  3896,     0,     0,   277,     0,
       0,     0,   279,   280,     0,     0,   281,  3897,     0,   282,
     283,     0,     0,     0,     0,     0,   284,   285,     0,   286,
       0,   287,     0,   288,   289,     0,     0,     0,     0,  -284,
       0,     0,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,     0,   303,   304,   305,     0,
     306,   307,   308,   309,     0,   310,   311,     0,     0,     0,
       0,   312,   313,   314,   315,   316,   317,     0,     0,   318,
     319,     0,   320,     0,   321,     0,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,     0,     0,   332,   333,
       0,     0,   334,   335,   336,   337,     0,     0,     0,     0,
     339,     0,     0,     0,     0,   340,   341,   342,     0,   343,
     344,   345,  3898,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   350,   351,     0,     0,     0,
       0,   353,   354,   355,     0,   357,   358,   359,   360,   361,
     362,   363,     0,     0,     0,     0,   366,   367,     0,   368,
       0,   369,   370,   371,   372,   373,     0,   374,   375,   376,
       0,     0,   377,     0,     0,     0,   378,   379,   380,   381,
     382,     0,     0,   383,   384,   385,   386,   387,     0,   388,
       0,     0,   390,     0,   392,  -284,     0,   393,     0,     0,
       0,   395,     0,     0,   397,   398,  3899,     0,     0,     0,
     400,   401,   402,   403,   404,   405,     0,   407,   408,     0,
     409,     0,     0,     0,     0,   411,   412,   413,     0,     0,
       0,     0,   415,     0,     0,     0,   416,     0,     0,   418,
       0,   420,     0,   421,     0,   423,     0,   425,   426,     0,
       0,     0,     0,     0,     0,   427,   428,     0,   429,     0,
       0,   430,     0,     0,   431,     0,   433,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,     0,
     442,   443,   444,   445,     0,   446,   447,     0,   448,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
     461,     0,     0,     0,     0,   463,   464,   465,     0,   466,
     467,     0,   468,   469,     0,     0,     0,     0,     0,   472,
       0,     0,  4235,     0,     0,     0,   475,   476,   477,     0,
       0,     0,     0,     0,     0,   478,     0,     0,   479,     0,
       0,     0,   480,   481,   482,   483,   484,   485,     0,     0,
    -284,     0,     0,     0,   486,     0,     0,   488,     0,   490,
       0,   139,   491,   140,   141,   142,   143,   144,     0,     0,
     145,     0,     0,     0,   146,     0,     0,     0,     0,   148,
     149,   150,   151,   152,   153,     0,     0,     0,     0,     0,
       0,   156,     0,     0,     0,   157,     0,     0,   158,   159,
     160,     0,   161,     0,     0,     0,     0,     0,   164,     0,
       0,   165,   166,     0,   167,     0,     0,     0,     0,     0,
     171,   172,   173,   174,     0,   176,   177,     0,   178,   179,
       0,     0,     0,     0,     0,     0,     0,   186,     0,   188,
       0,   190,   191,   192,   193,     0,   194,   195,     0,   196,
     197,   198,     0,   200,     0,   201,     0,     0,   202,     0,
       0,   203,     0,     0,     0,   204,     0,     0,     0,   205,
     206,   207,     0,     0,   208,     0,     0,     0,     0,   209,
       0,     0,     0,     0,     0,   211,     0,   212,     0,     0,
       0,   213,     0,   214,   215,   216,   217,     0,     0,     0,
       0,     0,     0,   219,   220,   221,     0,     0,     0,   222,
       0,     0,   224,     0,   225,   226,   227,     0,     0,   228,
     229,     0,   230,   231,   232,   233,     0,     0,     0,     0,
     236,   237,   238,     0,     0,   239,   240,     0,   241,   242,
     243,     0,     0,     0,     0,     0,     0,   245,     0,   246,
       0,   247,     0,   248,   249,   250,   251,   252,   253,     0,
     254,     0,     0,     0,     0,   256,   257,     0,     0,     0,
       0,     0,     0,   260,     0,     0,     0,   261,   262,   263,
     264,     0,     0,   265,   266,   267,     0,   268,     0,   269,
       0,     0,     0,     0,   270,     0,     0,     0,     0,   272,
       0,   273,   274,     0,   275,   276,     0,     0,     0,   277,
       0,     0,     0,   279,   280,     0,     0,   281,     0,     0,
     282,   283,     0,     0,     0,     0,     0,   284,   285,     0,
     286,     0,   287,     0,   288,   289,     0,     0,     0,     0,
       0,     0,     0,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,     0,   303,   304,   305,
       0,   306,   307,   308,   309,     0,   310,   311,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,     0,     0,
     318,   319,     0,   320,     0,   321,     0,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,     0,     0,   332,
     333,     0,     0,   334,   335,   336,   337,     0,     0,     0,
       0,   339,     0,     0,     0,     0,   340,   341,   342,     0,
     343,   344,   345,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   350,   351,     0,     0,
       0,     0,   353,   354,   355,     0,   357,   358,   359,   360,
     361,   362,   363,     0,     0,     0,     0,   366,   367,     0,
     368,     0,   369,   370,   371,   372,   373,     0,   374,   375,
     376,     0,     0,   377,     0,     0,     0,   378,   379,   380,
     381,   382,     0,     0,   383,   384,   385,   386,   387,     0,
     388,     0,     0,   390,     0,   392,     0,     0,   393,     0,
       0,     0,   395,     0,     0,   397,   398,     0,     0,     0,
       0,   400,   401,   402,   403,   404,   405,     0,   407,   408,
       0,   409,     0,     0,     0,     0,   411,   412,   413,     0,
       0,     0,     0,   415,     0,     0,     0,   416,     0,     0,
     418,     0,   420,     0,   421,     0,   423,     0,   425,   426,
       0,     0,     0,     0,     0,     0,   427,   428,     0,   429,
       0,     0,   430,     0,     0,   431,     0,   433,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
       0,   442,   443,   444,   445,     0,   446,   447,     0,   448,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,   461,     0,     0,     0,     0,   463,   464,   465,     0,
     466,   467,     0,   468,   469,     0,     0,     0,     0,     0,
     472,     0,     0,   473,     0,     0,     0,   475,   476,   477,
       0,     0,     0,     0,     0,     0,   478,     0,     0,   479,
       0,     0,     0,   480,   481,   482,   483,   484,   485,     0,
       0,     0,     0,     0,     0,   486,     0,     0,   488,     0,
     490,     0,     0,   491
};

static const yytype_int16 yycheck[] =
{
       6,   648,   579,   579,   556,    20,   988,  1148,   602,   899,
     616,  1178,  1105,    19,    29,  1178,    22,   124,   696,  1800,
     989,    36,   675,     6,  1693,  1124,    32,  1077,   701,   951,
    1831,  1832,  1486,    39,   813,   722,    42,  1387,  1071,  1072,
      46,  1387,  1241,  2019,   926,  1310,  1819,  2481,    54,  2054,
    2291,  1484,  2522,   524,  2589,  1200,  2411,   924,  2819,    22,
    2330,  1318,  1207,  2764,  2100,  2603,   993,  1208,  1209,   951,
     993,  1212,  1213,  1214,  1215,  2121,  1217,  1218,  1219,  1220,
    1221,  1222,  1223,  1224,   757,   952,  3208,   760,  2134,   767,
      96,  1467,  2399,  1475,  1115,  1961,  1959,   644,   645,  1819,
    1959,     4,  2016,  1398,  2220,   657,   658,  1890,  2135,  2964,
    1914,  1915,  2353,   119,  2476,   121,  1962,   123,   124,   125,
    1966,  1416,   775,   776,   777,  3214,   662,  1931,  2079,  1424,
    1425,  1977,  2079,    96,   787,  2263,  2343,  3444,   121,   786,
     123,  1987,  2392,    34,  1948,  1949,    17,   882,  1457,  2455,
    2400,  2620,  1528,  3271,  3272,    16,    17,  3275,    73,    25,
    1964,  1965,  3097,  1967,     8,    19,  1970,  1971,    16,    17,
    1974,    19,  3232,   131,  1942,  1979,  3294,    60,    19,  1983,
    1984,  1985,  1986,  3301,    28,    19,  1990,  1991,  1830,  1993,
    2680,    35,    16,    17,    17,  1999,    21,    30,  2002,  2003,
      51,  2005,  3491,   112,  1905,  2617,  2618,    19,  1933,   815,
     151,  2623,    47,  2625,    16,    17,  2079,   145,    16,    17,
    2079,  2458,    36,  2440,  2441,   175,  3928,   114,    16,    17,
    2565,  2444,   967,  2591,    59,    60,  2757,    58,    68,    16,
      17,  1951,    43,    36,    83,    51,    66,   367,   217,    16,
      17,   128,    63,    11,   233,   373,   358,    16,    17,  2063,
    2064,  2065,  2066,  2875,  3038,  3383,  4053,    63,  1467,   388,
    3046,   877,  2040,    82,    16,    17,   188,  2045,   342,   175,
     157,   128,    46,  2051,  2052,   267,   157,   341,  2056,   279,
     134,   226,    21,   391,   251,    21,   192,   450,   355,   443,
     128,    56,   226,   157,    86,    34,   650,   161,    34,   363,
     157,   405,    82,   128,   226,    16,    17,   995,  3440,    48,
     161,   285,    48,   140,    59,    60,    16,    17,   192,  1528,
      59,    60,  2068,    59,    60,   423,    23,   192,   515,   390,
    2557,  2558,   157,   230,  3488,   335,   151,  2104,  2384,   161,
    4182,   540,   953,  4185,   175,  4057,    16,    17,   179,    20,
     129,   285,   268,    16,    17,  2751,   394,   233,   394,   190,
    2214,   129,   485,   151,    16,    17,   355,   241,    25,   354,
     418,  4015,   190,   432,   210,   192,    40,  2363,  2364,  2365,
     192,   572,    10,   189,   282,  3564,    16,    17,  3567,   213,
     214,   439,   509,  3676,   192,   508,   540,   168,    70,   132,
    3528,   505,   230,   222,   511,   224,   157,   301,   530,  3537,
     213,   214,   534,    16,    17,   164,    64,  1114,   254,   561,
      16,    17,   470,   192,   195,   532,   539,   244,   545,  3712,
     553,  1128,   308,  3561,   253,    70,   210,   636,  3566,   630,
     132,  3620,  2838,   585,   418,    16,    17,   506,   433,  1238,
      16,    17,   556,   491,   414,   491,   810,   373,  1437,   277,
     358,  1018,   133,   285,   243,  4307,   540,  4111,  2272,   567,
      16,    17,   169,   660,   637,   226,  3793,   631,  3632,   540,
     414,   115,   449,   348,   118,   316,  3272,  1049,  1050,  1051,
     317,   599,   566,   509,   598,   511,   441,   657,   658,   373,
     629,   372,   159,   631,   375,  3604,  4303,   637,   414,  2826,
     622,   511,   528,  1977,   372,  1392,   532,   375,  1395,   357,
    1457,   585,  3306,  1400,  1457,   541,   515,  3681,  2893,   545,
     341,   547,   511,   600,  1743,  3667,  2460,   475,   372,   146,
    2464,   375,    16,    17,   560,   237,  1203,  1933,  1211,  1426,
    1427,  2768,  2769,  2770,  2478,  2479,  1301,  1449,  2874,  2605,
     372,  2877,  2878,   375,  2488,  1228,    16,    17,    16,    17,
    1721,  2444,   588,  1959,   372,  2444,   233,   375,   418,  1884,
    2896,  1732,  2349,   414,  1735,   372,  1331,   448,   375,   354,
    1527,   607,  2516,   338,  1527,   372,   418,   403,   375,  3221,
     616,   249,   618,   372,  2565,   426,   375,   375,  2565,  1090,
    1091,   600,   604,   629,  3713,   188,  2008,  3148,  2398,   635,
     372,    16,    17,   375,   640,  2872,   642,  2405,   644,   645,
      16,    17,   448,   649,   650,   548,  1117,   611,   654,  3139,
    3411,  2864,   635,  2988,  1125,   390,  1127,  3015,   664,   665,
     666,   308,   603,   226,   670,   485,   629,  2471,  1139,  1140,
    1141,   372,   584,  2587,   375,  4377,  1147,   640,  1284,  2483,
     462,   631,   372,    16,    17,   375,   589,   583,  1467,   598,
    2391,    73,  2068,   537,  1715,  2463,   460,  2465,  2423,  1246,
     441,   659,  2565,  2079,  2472,   812,  2565,  1800,   355,   592,
     551,   555,   372,  2355,   629,   375,   722,  2485,   551,   372,
    3809,  3211,   375,  2491,  2492,   564,   540,   614,   551,  4018,
     372,  3791,  2442,   375,  1933,   606,  2772,  2773,   629,  2507,
    2508,  3011,  4049,    16,    17,   570,   590,   540,  1354,  1528,
    3839,   585,   372,  2062,   615,   375,    16,    17,   635,  2563,
    3695,   585,   597,  2531,   635,   631,  1313,   615,    16,    17,
    2987,   606,  2900,   634,   780,  2556,   782,   573,  1513,   372,
     631,   635,   375,  1330,  3253,  3254,   372,   405,   635,   375,
    1396,   615,  3261,    16,    17,  3264,  3265,   606,   603,   611,
     806,   807,   808,   573,   810,   811,   812,   631,   814,   815,
     631,   372,  3281,   615,   375,  3959,   372,   615,   925,   375,
     635,  1422,  2798,  2559,   807,   603,  3295,   615,   811,   631,
      64,   814,  3301,  3302,  3303,  3304,   372,  2681,   615,   375,
    1376,   570,   630,  3255,   570,  2602,   852,  3259,   615,   511,
      16,    17,  3996,   630,   631,   578,   615,  3946,  2834,   865,
     514,  4168,   601,   630,   631,  2298,   595,  1017,   515,  2068,
     467,   877,   878,   615,   361,  3145,   882,  3289,  3290,  3291,
    2079,   535,   520,  3245,  1461,  3297,   511,   505,   630,   631,
     195,  3198,   284,  3305,   635,  3202,   578,    16,    17,    32,
     629,   636,   865,  2704,  4022,  3374,  4024,   561,   372,    16,
      17,   375,  3218,   210,   615,   878,  3157,  1067,    90,   925,
     544,    16,    17,   547,  3501,   615,  2720,  2721,  2722,   630,
     631,   125,   372,  3788,   372,   375,    82,   375,   556,  2740,
     630,   631,  2954,    16,    17,  3483,  3153,   312,  3198,    16,
      17,    12,  3202,   600,  1641,   615,   268,   254,  1880,   270,
    3372,   967,   615,    16,    17,  2746,    71,   209,   871,  3381,
     630,   631,     8,   615,   202,   819,   161,   630,   631,    88,
     598,  4070,    34,   989,   631,  3021,   192,   372,  1910,   631,
     375,   185,  2765,    16,    17,   615,   372,   251,  1880,   375,
    1536,  2864,   609,  2457,  2458,  2864,  1873,  4096,   195,   263,
     630,   631,  1018,   629,   301,   249,  1883,   467,  2159,  1886,
    1887,   584,   615,  3050,  2374,   407,  2376,  2377,  1910,   615,
    2376,  2377,   629,   175,  2817,   461,   633,  2988,   631,   372,
     178,  2988,   375,   125,   630,  2765,   274,  2423,   440,   159,
     192,    16,    17,  2310,   615,  4177,  2106,  2827,  2828,   615,
      51,   373,   268,  1069,   370,   629,    12,  1073,  2444,   161,
     631,   125,  2938,   637,   128,   631,   222,  3193,   224,   615,
     141,  1734,   147,  1190,    16,    17,    16,    17,   282,  2234,
    2385,    16,    17,  2939,   389,   631,    16,    17,   190,   372,
     405,   485,   375,    16,    17,   125,  1069,   253,  1114,  2890,
    1073,   244,   372,   342,   534,   375,   350,   154,    16,    17,
    1227,    25,  1128,   233,   372,  2988,   413,   375,   165,  2988,
    2512,   185,  1819,   193,   267,  2062,   126,   190,  2403,  2062,
     435,  2240,  2241,  1749,   631,  3683,   457,   183,   530,   372,
    2819,   615,   375,  3730,  1933,    16,    17,    16,    17,   213,
    4005,   352,  4007,  2330,   358,  2306,  3142,   631,  3475,  3476,
     111,  3207,  1178,   555,   157,   615,   285,   615,  1784,   629,
      71,   318,   467,  2559,  1190,   235,   104,  1739,   797,  2565,
      52,   631,    89,   631,   244,   141,  3896,  3897,   485,   453,
     282,    63,  1808,  1809,  1751,  3181,   372,    16,    17,   375,
     401,   108,  2233,   605,  1321,    16,    17,    25,   405,   357,
     157,  1227,  2243,     0,  2423,  3237,  1232,   168,   282,   534,
     615,  1237,    16,    17,  2401,   183,  3937,   230,  2401,   615,
    1246,   413,  4003,  1795,   472,   355,   631,    80,   490,   301,
      16,    17,   242,   372,   195,   631,   375,    16,    17,  3794,
     572,   254,   282,  1840,   629,   372,    16,    17,   375,   374,
      16,    17,   414,   507,  1237,   166,   358,   372,  1284,   274,
     375,   890,   615,    16,    17,   268,   520,    16,    17,  2068,
    1296,   476,  1298,    25,   427,  1301,  2729,  3767,   631,   372,
    2079,   157,   375,  4043,   358,   372,   130,  1313,   375,   257,
     400,   540,   377,  3777,  3228,  1321,   234,   202,  3364,   372,
      16,    17,   375,  2490,  1330,  1331,   386,  2490,   378,   233,
     226,   268,  3602,   251,   371,  3249,   631,   566,   358,  4461,
     511,    21,   615,   467,   629,   263,   161,   534,  1354,   372,
      82,  1357,   375,   142,    34,   615,   189,  1464,   631,  1365,
    2559,   356,   342,   354,   351,   352,  2565,   615,    48,   563,
     630,  1377,  1378,  1379,  1380,  1381,  1382,   125,   612,    59,
      60,  1387,  2509,   631,   476,    16,    17,  1393,  1394,   274,
    1396,  4021,   615,  1399,  1377,  1378,  1379,   230,  1381,  1302,
     629,   538,    16,    17,   308,   515,   354,   372,   631,     8,
     375,  1394,   274,  1419,   161,   561,  1399,  1380,  2872,  1382,
     558,   254,   593,   341,   484,   233,   205,   159,   565,   606,
     420,    30,  3896,  3897,    16,    17,   574,   185,   534,   585,
     372,   583,   372,   375,   176,   375,   168,   372,   168,   615,
     375,   355,   372,   342,   631,   375,  1419,   448,  1464,   372,
    2810,   285,   375,  2556,   405,   631,    12,    16,    17,  1372,
     366,   129,  1478,   195,   372,  1481,  1482,   375,   362,   364,
     125,   563,   138,   374,   475,  2939,  4226,  3842,  2864,   631,
     600,   205,  3468,   467,    16,    17,   615,   153,    16,    17,
     308,   233,   539,  1112,   551,   629,   390,  1513,   615,   563,
     129,   372,   631,   372,   375,  1478,   375,    16,    17,  1482,
     615,   631,    16,    17,   631,  3795,  1532,   517,  1534,  1535,
     592,  1537,  1538,   595,   282,   453,   631,   251,  4238,  4239,
     185,   330,   615,   563,  1550,   483,  1552,    17,   615,   268,
     467,  1534,  1535,  1162,  2604,  2700,  3324,  1166,   631,    12,
     540,   467,   615,   372,   631,    82,   375,  1470,   213,   530,
     403,   372,  3618,   534,   375,   130,   308,   630,  4042,  4043,
     630,    41,   637,  3559,  2237,  2752,   566,   472,   372,  2752,
     467,   375,   615,   534,  4064,   141,    16,    17,   516,  4339,
    3841,  4341,   467,    16,    17,    12,   372,   225,   631,   375,
     358,   515,  2988,   372,   467,   556,   375,   349,  4088,  4089,
     581,   604,   372,   355,   243,   375,   372,    16,    17,   375,
    4370,    16,    17,    16,    17,  1641,  1642,   282,   576,   372,
     585,    12,   375,   372,  2423,  1752,   375,  4277,  4278,   629,
     615,   540,   635,  2746,   373,   629,   540,   598,  2129,   373,
     215,   205,  2335,  2336,  2337,  2136,   631,   604,  4408,  4409,
     530,   222,  4136,   224,   534,   135,   372,   566,  2149,   375,
     618,  3801,  3802,   615,   534,   615,   631,  4151,   141,   467,
     615,  3124,   637,  1699,   537,   615,   600,   225,   635,   631,
    4164,   631,   615,    16,    17,   222,   631,   224,   367,  3490,
     630,  2182,   629,   358,    16,    17,   634,   615,   631,   244,
    3725,  3726,   510,   629,    16,    17,   514,  3500,    16,    17,
     285,   205,   630,   230,   141,  1741,   253,  2343,   598,   264,
     629,   372,  3411,  1749,   375,  1751,  1752,   629,    16,    17,
      16,    17,   629,  2880,   615,   637,   615,  1763,   372,  1765,
     623,   375,  4226,  4197,   629,  1771,  1772,   630,  1774,   630,
     141,   630,   230,  3546,  4238,  4239,   629,   241,  1784,  2250,
    2559,  1787,   230,   515,  2911,  1791,  2565,  3348,  3349,  2988,
     372,   467,    47,   375,   623,  2922,   192,  2890,  2925,    16,
      17,   630,  1808,  1809,  1810,  1811,   615,   192,  1771,  1772,
     590,  1774,   475,  1819,   615,   563,  1822,  1823,  1824,  1005,
    1006,   630,  4286,   372,  1787,   606,   375,   630,  1791,   630,
    3950,   615,  4296,  1839,  3954,   624,   625,   626,   627,   178,
      16,    17,  1848,   585,  2971,    39,   630,  1810,  1811,   615,
     372,   629,    46,   375,   372,   633,   615,   375,  1044,  1822,
    1823,  1824,  2370,   285,   630,   615,    16,    17,   600,   615,
     635,   630,   579,   372,  2764,  4339,   375,  4341,   372,  1885,
     630,   375,   615,  2805,   630,   637,   615,  4351,   630,   631,
     570,  1897,  2814,  2470,    16,    17,   369,   630,  1904,   631,
     505,   630,   629,  1806,   189,   735,  4370,    82,  4372,     6,
    4374,   591,   592,   589,   590,    16,    17,  4381,   563,   615,
     585,  1285,  1885,  2805,  1288,   755,  3025,  1291,  4392,  3194,
     582,   583,  2814,   585,   630,  3496,    16,    17,   768,   769,
    1843,  1904,    16,    17,  4408,  4409,   630,   631,   269,  2816,
     441,   272,   372,   629,  2462,   375,  3055,  3056,   235,   372,
    4424,  4425,   375,    16,    17,  4429,   631,   244,   629,  3945,
    2077,    11,   637,    16,    17,   629,  2083,  3076,  2486,  2487,
     630,   631,  3149,   372,   615,   630,   375,   372,   629,   372,
     375,    82,   375,  4113,  4114,  2001,   629,    16,    17,   630,
     629,   615,  3352,   629,   123,    96,  3352,    16,    17,   629,
    2016,   540,   351,   352,  2121,  1918,   630,   629,   357,    16,
      17,    16,    17,   629,  1927,  1928,   629,  2134,   629,    19,
     637,    16,    17,   615,    19,  1938,  1939,  1940,  1941,  3206,
    1943,  1944,   192,  3206,    16,    17,   630,   631,   630,   629,
      16,    17,    16,    17,   629,  3823,  3824,  3825,   233,   372,
      16,    17,   375,    17,    16,    17,   615,    19,   630,   631,
     372,  2077,  3239,   375,   607,   608,  3239,  2083,  2765,  2085,
     372,   630,  2088,   375,   372,   630,   631,   375,   629,  2095,
    2096,  2097,  2098,   615,   415,  2101,   631,   615,   631,   629,
    4076,   378,   221,   629,   372,  2088,   372,   375,   630,   375,
      16,    17,   630,    25,   104,  2121,   615,   467,   629,  2226,
     629,   615,   629,    12,   629,   475,   289,   290,  2134,   630,
     631,   630,  2095,  2096,  2097,  3939,   630,   629,  2041,  2042,
     629,  2044,  2748,  2046,  2047,  2048,  2049,  2050,   630,   631,
    2053,  2258,  2055,    42,  2706,   372,  3717,  3718,   375,  3720,
    3721,   629,  2768,  2769,  2770,   256,   629,   157,   630,   631,
      82,   161,   629,  3974,   349,    16,    17,   629,  3982,  3983,
     355,   172,  3986,  3987,  3988,  3989,   630,   631,   142,  2795,
    3223,  3224,   630,   631,  3975,   615,   372,     6,   188,   375,
     190,   320,   615,  3261,   203,   324,  3264,  3265,    97,  2988,
     630,  3310,   331,   102,    17,   205,   363,   630,   629,   558,
    2226,   211,   372,  3281,  2695,   375,   615,   629,   595,   596,
     615,   598,   615,   600,   629,   574,   226,   328,   144,   589,
     590,   630,    16,    17,   234,  2251,    19,   630,    57,   424,
     372,   241,  2258,   375,  3708,  3709,   629,  2364,   585,  2366,
    2367,   251,   515,   354,   176,   629,  2272,   430,   431,    59,
      60,   372,  3439,   263,   375,   629,  3439,   629,   268,   629,
     629,    71,  4086,  4087,   630,   631,   629,   277,    31,   630,
     631,  4095,   372,   412,  4062,   375,   630,   631,   372,  2305,
    3350,   375,   615,  2410,  2411,   629,   305,   306,   404,  4090,
     629,   310,   311,   615,   155,   629,  3374,   630,   629,   372,
     629,   233,   375,   615,  2330,   416,   629,   615,   630,   372,
     629,   104,   375,   629,  4003,   629,   145,  2343,   630,   142,
     515,    84,   630,    59,    60,   629,   465,   615,   629,   615,
    2356,   341,  2358,   372,   630,   631,   375,   246,  2364,   629,
    2366,  2367,   630,   372,   630,   629,   375,   543,  2374,   629,
    2376,  2377,   629,   363,  2481,   372,   330,   372,   375,  1772,
     375,  1774,   629,   373,   157,   630,   631,   372,   161,   629,
     375,   630,   631,   568,   629,  2401,   308,  3490,   615,   629,
     372,   630,   631,   375,  2410,  2411,   372,   629,   372,   375,
     629,   375,   155,   630,   505,   405,   372,   190,    63,   375,
     372,   629,  3391,   375,   629,   600,   630,   631,   317,  1822,
    1823,  1824,   205,   111,   456,    80,  2451,   349,   211,   615,
     629,   142,   629,   355,  2450,   629,  2461,    92,   629,  2455,
     629,    82,  2467,  2356,  2460,   456,   630,   631,  2464,   629,
    2466,   234,   629,   453,   629,   615,   372,   629,   241,   375,
    2476,   629,  2478,  2479,  2489,  2481,   630,   631,   251,  4455,
    2495,   629,  2488,   602,  2490,   475,  2501,  2502,   630,   631,
     263,   629,   381,   615,  2500,   268,   630,   631,   617,    11,
     630,   631,   629,  2509,   277,    60,   630,   631,   630,   531,
    2516,  2517,   630,   631,   615,   537,  2522,   630,   631,   629,
    3173,   630,   631,  2529,   478,   479,   516,   330,   159,   630,
     629,   372,   630,   631,   375,   615,   629,  2500,   216,   151,
     152,   615,   370,   352,   189,   363,   543,  3153,   530,   194,
     630,   363,    12,   630,   631,   631,   630,   630,   631,   581,
     115,   226,   615,   118,    49,  2468,  2469,   491,   341,   630,
      12,   126,   615,   279,   125,    49,   598,   630,   363,   543,
    2586,  2587,   572,   631,   142,   230,  4387,   630,   143,   461,
     363,  2494,   363,  3064,   584,   585,   615,   630,   631,   111,
     373,   572,   233,   515,   493,   167,   615,   624,   417,   254,
     419,   630,   630,   631,   604,   475,   606,   129,   615,  2522,
     615,   630,   629,  2586,  1083,  1084,  1085,   630,   631,   330,
     615,   186,   405,  3104,   185,   630,   630,   631,   527,   268,
     630,   631,  1101,   615,   634,   635,   190,   142,   511,   615,
     167,   615,  2555,   630,   631,   530,   168,   400,   630,   615,
     511,  4462,   213,   615,   630,   279,   620,   621,   622,   623,
     624,   625,   626,   627,  1133,   478,   479,  1136,   158,   422,
     453,   141,    91,   195,   630,   631,   631,   242,   600,   630,
     631,  3832,   630,   631,   630,   631,  1155,  1156,   365,   141,
    1159,   379,   475,   630,   631,   526,    63,   630,   631,   615,
    2716,   454,   390,  2719,  2720,  2721,  2722,    32,   349,   397,
    1179,  1180,  2728,    80,   355,   630,   631,   630,   631,   526,
     527,   282,   630,   530,   531,    92,   104,   534,   157,   536,
     128,  2747,  2748,   516,   389,   114,  2752,   630,   631,   244,
     630,   631,   630,   631,   636,   215,     6,    26,   403,  2765,
      58,   629,  2768,  2769,  2770,  2728,   278,   510,   630,   631,
     113,    34,   330,   215,   615,  2781,  3745,   478,   479,     4,
    3332,  2787,  3751,  2789,  3361,   340,  2893,   466,   343,  2795,
     598,   125,   244,   424,   128,  3522,  3523,    60,   631,   572,
     125,   389,    71,    56,  2810,  3972,   433,   358,  3535,  3972,
     172,   489,   585,    82,   114,  3542,   223,   620,   621,   622,
     623,   624,   625,   626,   627,  3647,  3648,   142,  1163,  1164,
     631,   604,   189,   606,    71,   330,   631,   194,    82,   125,
      12,  3568,  3569,  3159,  3160,   637,    90,  3117,  3118,   494,
     603,   185,   115,   630,   125,   118,   540,   630,   631,   128,
     185,   634,   635,   126,   630,   420,   234,   141,  2874,     9,
     114,  2877,  2878,   230,  2880,  3420,  3421,   175,  2781,   213,
     143,   179,  3975,   251,   515,   631,   637,  2893,   213,   630,
    2896,   142,   190,   405,   630,   263,   629,   254,   637,   185,
     267,   159,   637,   581,   631,  2911,   636,   279,   142,   279,
     111,    49,   631,   279,   185,   159,  2922,   530,   125,  2925,
     621,   622,   623,   624,   625,   626,   627,   213,   573,   244,
     279,   279,   279,   629,   274,   388,   222,   568,   224,   631,
     631,  2947,   213,   551,  2950,   631,   497,   551,   282,  2955,
      12,   631,   267,   222,   104,   224,   161,   282,   631,  2965,
     631,   473,   631,  2969,   244,  2971,   624,   168,   245,   600,
     180,    26,    27,   341,   528,   190,   631,   577,   185,   242,
    2986,   631,  2965,   478,   479,   254,   230,  2950,   488,   392,
     137,  2894,   547,   505,   195,  3001,   282,  4090,   363,  2902,
     631,   631,  3008,   631,    59,    60,   213,    62,    80,  4176,
     244,   282,   563,  4176,  3020,   330,    71,    36,   316,   531,
     817,   576,   161,   630,   358,   161,   161,    82,   161,   230,
     161,   161,   161,   358,   161,    90,   351,   352,   161,   499,
     500,   501,   502,   503,   504,  3008,   403,  3937,   161,  3722,
    3723,  3724,   161,   161,  4023,  3162,   516,   499,   500,   114,
     502,   161,   504,   307,   622,   623,   624,   625,   626,   627,
     161,  3178,   358,   128,   516,   282,   131,   278,  3756,   330,
     343,   325,   351,   352,   234,   453,   598,   358,   357,   631,
    2993,   161,  3098,   161,   363,   161,   330,   161,  1557,   118,
    3106,   251,   579,   610,   159,   349,   125,  3684,   584,   195,
     631,   363,   427,   263,  4255,   363,   414,   189,  3670,   192,
     363,   630,   630,   624,  3130,   620,   621,   622,   623,   624,
     625,   626,   627,    85,   403,    87,   630,   494,   630,   630,
     630,   630,   630,  3149,  3150,   192,   629,  3153,   516,   631,
     623,   358,   630,   476,   572,   630,  3162,   629,   230,   178,
     630,   630,  3168,   478,   479,   630,   185,   222,   631,   224,
     631,   630,  3178,   630,   630,   230,   128,   492,   629,   627,
    3186,   630,   254,   238,  1643,   629,  3780,   551,  1647,   604,
     631,   341,   232,   629,   213,   214,   522,   149,   253,   400,
    3206,    11,   471,  3106,   405,  3883,   203,   192,   637,   192,
    1669,    55,  3218,   363,  4355,   170,   573,   630,   457,   413,
     483,    65,  3228,   631,  3230,   142,   475,   478,   479,   563,
     631,   190,   184,  3239,   161,   162,    47,    81,   563,  3245,
     339,  3247,   466,  3249,   478,   479,   505,    80,   505,    93,
      94,    95,   307,   137,   551,  4422,   252,  3364,   505,  4422,
    3836,   389,   252,   282,   505,   109,   531,   505,   389,   196,
     325,   515,   473,   389,   137,   531,    47,   563,  4445,   389,
     207,   436,  4445,   389,   547,  4452,   387,   531,   629,  4452,
     629,  4458,   563,   389,   389,  4458,   389,  4266,  4267,   278,
    4269,   629,   161,   453,   573,   620,   621,   622,   623,   624,
     625,   626,   627,   576,   630,   585,  3322,   389,   637,   155,
     247,   111,   630,   342,   183,   380,   240,   382,   240,   630,
     531,   403,   259,   637,   353,   390,   537,   196,   357,   358,
     630,  3347,  3348,  3349,   637,   630,  3352,  3454,   207,  4318,
     637,  4320,  4321,   637,   630,   556,   563,   630,  3364,   286,
     551,   551,   630,    16,    17,   631,   516,   551,   274,   620,
     621,   622,   623,   624,   625,   626,   627,   637,   540,   611,
     581,    88,   637,    47,   629,   631,   620,   621,   622,   623,
     624,   625,   626,   627,   629,   161,   629,   598,   257,   551,
     259,   336,     6,   458,   194,   161,  4053,   629,   370,    13,
     192,    15,  3315,   330,  4383,  3991,   192,   192,   345,   241,
     192,   637,    26,    27,   248,   637,   170,   286,  3434,   381,
     358,   631,   251,  3439,   251,  3338,   376,  3544,  4420,   321,
     230,   114,   114,   629,   637,   254,   254,   551,  3454,    26,
      27,   629,   205,    57,   369,   540,   450,   389,    62,    63,
     515,   629,   637,   373,   624,    69,   119,   120,   121,   122,
     123,   629,   629,   425,  4026,   319,   531,   242,    82,   242,
     535,   104,    59,    60,   630,    62,    90,   630,   278,   348,
    3496,  3506,   637,   337,    71,   606,   100,   363,   630,   554,
    4077,   226,   269,  4055,   630,    82,   630,  3513,   630,   629,
     114,  3618,   630,    90,   631,   630,   630,   572,   389,   624,
     578,   540,   192,   630,   128,   544,   244,   131,   547,   631,
     265,    71,   251,   363,   138,   139,   251,   114,  3544,   558,
     637,   145,   631,   402,   563,   629,   254,   566,   254,   153,
     631,   128,   631,   157,   131,   159,   630,   363,   629,   401,
     363,   478,   479,    82,  3570,   218,   219,   220,   221,    19,
     631,  3577,   631,   630,   363,   629,   631,   363,   491,  3686,
      47,    82,   159,   629,   188,   630,   467,   629,   629,  3595,
     268,    19,   629,    47,   630,    96,   469,    36,    26,   630,
     606,   203,   418,   622,   623,   148,   261,   630,   630,   205,
     631,   234,  3618,   477,   629,   629,   629,   251,   222,   463,
     224,   251,   631,   128,   228,   128,   230,   629,   251,   399,
     637,    86,   485,   144,   238,   136,   491,   630,   630,   462,
     263,   630,  3545,    71,   631,   222,   630,   224,    19,   253,
     630,    34,   630,   230,    82,   630,  4303,   630,    34,   358,
      60,   238,   242,   630,   630,   630,   630,   320,   327,   322,
     323,   324,   256,   413,   518,   370,   253,   277,   331,   118,
    3686,  3584,   606,   473,   241,   629,   125,   630,   637,   631,
     267,    47,   536,   211,   631,   327,   418,   540,  3704,   540,
     128,   630,   585,   307,   494,   622,   623,   624,   625,   626,
     627,  3717,  3718,   585,  3720,  3721,   304,   595,   341,   372,
     629,   325,   375,    14,   629,   329,   629,   629,   629,   629,
     307,   629,   578,   595,   128,  3842,  4312,   254,    19,   178,
     363,   531,   254,   357,   534,    34,   185,   537,   325,   170,
     630,   358,   631,   629,   457,   256,   631,   327,   174,   412,
     540,  3767,    17,  4315,   368,   254,  4413,   540,   629,   373,
     198,   540,   534,   630,   213,   214,   380,    34,   382,   630,
    3786,  3787,   589,   573,   585,   389,   390,   585,   241,   363,
     353,   581,  3798,   590,   222,   509,   224,   358,   450,   630,
    4447,   606,   170,   380,   631,   382,   138,   156,   370,   521,
      67,   464,   465,   390,   578,   629,   629,   421,   190,   603,
      31,   190,    61,   638,  3787,  3831,   254,   328,  3834,   629,
     453,   435,   436,   437,   438,   629,  3842,  4389,    13,   630,
     384,   542,  4136,   282,   137,   630,   159,   630,   629,   137,
     351,   352,   405,   354,   458,    73,   603,  4151,   426,   192,
      31,    63,   370,    63,  3767,   522,  3872,   270,  3831,   630,
    4164,   631,   629,    47,    47,   629,     5,   629,   135,   363,
     363,   458,   630,   241,   155,   635,   136,  3893,   370,   524,
     370,   144,  3898,   516,    47,   629,    47,    47,   154,   578,
     132,   603,   159,   342,   155,   225,   163,  4459,   635,   284,
     638,   515,   127,   150,    47,   416,   457,    47,   357,   358,
     629,    47,    53,   351,   352,   630,   459,   531,   103,   357,
     630,   535,   254,   223,   631,   363,   155,   635,   515,   631,
     197,   208,   543,   631,   635,    47,   630,   630,    53,   602,
     554,   631,   440,   226,   531,   559,   190,   132,   535,   190,
     217,   190,   615,   616,   617,   543,  3972,   605,   572,   128,
     145,   358,  3903,   629,   231,   403,   475,   554,   191,  2265,
     631,  3324,  2057,  3325,  4091,  2439,  3930,   658,  3593,  4056,
    4245,  1002,  4286,   168,  4246,   572,   171,  3591,  3785,  4005,
    3595,  4007,  4296,  4009,   505,  4447,  4400,   182,    46,   580,
    2765,  1818,  3777,  4410,  3777,  3777,  4283,  3777,  4129,  4283,
    3777,  3777,   279,  3777,  3777,  3777,  3777,  3777,   203,  4035,
    4239,   635,  3777,  3777,  4155,  3938,  1473,  4154,  1042,  1743,
     675,  3935,  2015,   471,   301,   680,  2920,  1475,  1483,  2742,
    3433,  3130,   629,  2747,  1318,   230,  4081,  4351,  4064,  3832,
    4355,  3436,   237,  4263,  4180,  4312,  3991,   519,  3600,  1527,
    2994,  2008,  2587,  3249,  2016,  4081,  2519,  3228,  4372,  3237,
    4374,  4330,   717,  4026,  3046,  4091,  3743,  4381,  3272,  3306,
    4197,  4097,  3555,  4077,  3178,  3544,  4013,    11,  4392,   734,
      11,   540,   277,  4113,  3941,   544,  4114,  1541,   547,  3954,
    3950,  3751,  2093,  3798,  2015,  3230,  1892,   971,  2512,   558,
     633,  1433,  3510,  2325,   563,  3229,  1523,   566,  1810,  1482,
    4424,  4425,  2728,  3125,  2298,  4429,  2347,  2216,  3779,   601,
     775,   776,   777,   778,  1829,   573,  3106,   404,  2128,  2125,
    2706,  1128,   787,   911,  4261,  3196,   413,  2215,  2402,    34,
    3857,  4064,  3711,  3322,  4212,  1101,  4213,  3239,  1449,  4389,
    4176,   428,  2244,  2810,   227,  3705,  2508,  3686,  2098,  2352,
    1331,  4084,  4085,   622,   623,  2292,  2329,  3439,  3144,   446,
    3143,  4197,    67,  3206,   591,  4176,  1550,   671,  1301,   579,
    1881,  1762,  1385,  3247,  1413,  1882,  4212,  4213,  4204,  3128,
    4305,  4353,  1337,  4273,  4452,  4458,  3546,  1365,  3149,  1834,
    2797,  3465,  3186,  3694,    12,    13,   563,  1791,   485,   486,
     571,   406,   893,   868,   287,   288,   289,   290,   291,   292,
    1293,   294,   295,   296,   297,   298,   299,   300,  3821,   302,
     303,   426,  3827,  1532,   511,  4261,   572,  1355,   898,   434,
     135,  2716,   658,   515,    -1,   658,   515,   442,   658,    -1,
      -1,    -1,    -1,   530,    -1,    -1,   533,   534,    -1,    -1,
      -1,    -1,  4288,    -1,   159,  4188,  4189,    -1,   163,  4295,
      -1,    -1,   467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   480,   481,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,   197,    -1,    -1,   582,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   217,    -1,   132,    -1,    -1,    -1,    -1,    -1,
     525,    -1,    -1,    -1,    -1,    -1,   231,   145,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4371,    -1,    -1,    -1,    -1,
    4376,    -1,    -1,    -1,    -1,    -1,    -1,   430,   431,    -1,
     168,   556,    -1,   171,    -1,    -1,    -1,    -1,    -1,  1024,
      -1,    -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   578,   279,   580,    -1,  4413,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   203,  4422,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4327,    -1,   301,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4441,    -1,    -1,    -1,  4445,
      -1,  4447,   230,    -1,  1079,  1080,  4452,    -1,    -1,   237,
      -1,    -1,  4458,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,    -1,    -1,   119,   120,
     121,   122,   123,  1108,  1109,    -1,  1111,    -1,  1113,    -1,
      -1,    -1,  1117,    -1,    -1,  1120,  1121,  1122,  1123,   277,
    1125,  1126,  1127,    -1,    -1,    -1,    -1,    -1,    -1,  1134,
    1135,    -1,  1137,  1138,  1139,  1140,  1141,    12,    13,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
      -1,    -1,  1157,  1158,    -1,    -1,  1161,    -1,    -1,   404,
    1165,    -1,  1167,  1168,    -1,    -1,    -1,    -1,   413,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1181,  1182,    -1,    -1,
      -1,    -1,    -1,   428,  1189,    -1,    -1,    -1,    -1,    -1,
      -1,  1196,  1197,  1198,    -1,  1200,    -1,   218,   219,   220,
     221,   446,  1207,  1208,  1209,    -1,  1211,  1212,  1213,  1214,
    1215,    -1,  1217,  1218,  1219,  1220,  1221,  1222,  1223,  1224,
      -1,    -1,    -1,  1228,  1229,    -1,    33,    34,   103,    -1,
      -1,    -1,    39,    -1,    41,    -1,    43,    44,    -1,    -1,
     485,   486,    -1,    -1,    -1,    -1,    -1,    -1,   406,    -1,
      -1,    -1,   410,    60,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   511,    -1,   426,    -1,
     145,    -1,    -1,    -1,    -1,    -1,   434,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   442,    -1,    -1,    -1,   533,    -1,
      -1,    -1,    -1,   168,    -1,    -1,   171,    -1,    -1,   320,
    1305,   322,   323,   324,    -1,    -1,    -1,   182,   115,   467,
     331,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   126,
      -1,    -1,   480,   481,    -1,    -1,    -1,    -1,   203,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   143,   582,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    27,    -1,    -1,    -1,    -1,
     680,    -1,    -1,   160,    -1,   230,    -1,    -1,    -1,    -1,
    1365,    -1,   237,    -1,    -1,    -1,    -1,   525,  1373,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   184,    -1,   186,
      62,    -1,    -1,    -1,    -1,    -1,    -1,   717,    -1,    -1,
      -1,   412,   199,   200,    -1,    -1,    -1,    -1,   556,    -1,
      82,    -1,   277,    -1,   734,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     578,    -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   114,    -1,    -1,   242,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   464,   465,    -1,   128,    -1,   778,   131,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   271,    -1,    -1,    -1,    -1,    -1,
    1475,    -1,    -1,   280,   281,    -1,   283,   159,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   313,   314,   315,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   332,   333,   334,    -1,    -1,
      -1,   406,    -1,   340,    -1,   410,   343,    -1,   868,    -1,
     222,    -1,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,
      -1,   426,   359,   360,    -1,    -1,   238,    -1,  1563,   434,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   442,    -1,    -1,
      -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,
      -1,   602,    -1,    -1,    -1,    -1,    13,    -1,   395,   396,
      -1,    -1,   467,    -1,    -1,   616,   617,    -1,    -1,    26,
      27,    -1,    -1,    -1,    -1,   480,   481,    -1,    -1,    -1,
      -1,    -1,    -1,   420,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   307,    -1,    -1,    -1,    -1,
      57,    -1,    -1,    -1,    -1,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   325,    -1,    -1,    -1,    -1,    -1,    -1,
     525,    -1,    -1,    -1,    -1,    82,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,   471,    -1,    -1,    -1,   475,    -1,
    1675,  1676,  1677,   100,    -1,    -1,    -1,    -1,    -1,    -1,
     487,   556,    -1,    -1,  1689,    -1,    -1,   114,    -1,    -1,
      -1,    -1,    -1,    -1,  1024,    -1,    -1,    -1,   380,    -1,
     382,   128,    -1,   578,   131,   580,    -1,    -1,   390,    -1,
    1715,   138,    -1,    -1,    -1,    -1,  1721,    -1,   145,  1724,
      -1,  1726,    -1,    -1,    -1,    -1,   153,  1732,    -1,  1734,
    1735,    -1,   159,    -1,   541,    -1,    -1,   544,    -1,    -1,
     547,   548,   549,   550,    -1,    -1,    -1,    -1,    -1,  1079,
    1080,    -1,    -1,    26,    27,    -1,    -1,    -1,  1088,  1089,
      -1,   188,  1092,  1093,  1094,  1095,  1096,  1097,  1098,  1099,
    1100,    -1,    -1,    -1,    -1,    -1,   458,    -1,  1108,  1109,
      -1,  1111,    -1,  1113,   591,   592,    59,    60,    -1,    62,
    1120,  1121,  1122,  1123,    -1,   222,  1126,   224,    71,    -1,
    1805,    -1,    -1,   230,  1134,  1135,    -1,  1137,  1138,    82,
     617,   238,    -1,    -1,  1144,  1145,  1146,    90,    -1,  1149,
    1150,  1151,  1152,  1153,  1154,    -1,   253,  1157,  1158,    -1,
      -1,  1161,    -1,   515,    -1,  1165,    -1,  1167,  1168,    -1,
      -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,
      -1,  1181,  1182,   535,    -1,   128,    -1,    -1,   131,  1189,
      -1,    -1,    -1,    -1,    -1,    -1,  1196,  1197,  1198,    -1,
      -1,    -1,   554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     307,    -1,    -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,
     572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   325,  1229,
      -1,    -1,   329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   373,    -1,    -1,   222,
      -1,   224,    -1,   380,    -1,   382,    -1,   230,    -1,    -1,
      -1,    -1,    -1,   390,    -1,   238,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1305,    -1,    -1,    -1,    -1,
     253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2008,    -1,    -1,    -1,    -1,    -1,   436,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   458,    -1,  2038,   307,  1365,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1373,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2091,    -1,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2107,    -1,   531,    -1,  2111,   380,   535,   382,
      -1,  2116,  2117,    -1,    -1,    -1,    -1,   390,    -1,    -1,
    2125,  2126,    -1,  2128,  2129,  2130,  2131,   554,  2133,    -1,
      -1,  2136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2146,    -1,  2148,  2149,   572,  2151,  2152,  2153,  2154,
      -1,  2156,    -1,    -1,  2159,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2168,    -1,    -1,    -1,    -1,    -1,    -1,
    2175,    -1,  2177,    -1,  2179,  2180,  2181,  2182,    -1,    -1,
      -1,  2186,  2187,  2188,    -1,   458,    -1,  2192,  2193,  2194,
      -1,  2196,    -1,  2198,    -1,  2200,    -1,  2202,    -1,  2204,
      -1,    -1,    -1,    -1,  2209,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2227,    -1,    -1,    -1,    -1,    -1,    -1,  2234,
      -1,    -1,  2237,  1563,    -1,    -1,    -1,    -1,  2243,    -1,
      -1,  2246,   515,    -1,    -1,  2250,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,    -1,
      -1,    -1,   535,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   572,
      -1,  2306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    -1,    15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1675,  1676,  1677,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    -1,    -1,
      -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,    62,
      63,    -1,    -1,    -1,    -1,  1715,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1724,    -1,  1726,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2422,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2440,  2441,    -1,    -1,    -1,
      -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
     133,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,   145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   157,  1805,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   171,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   187,    -1,    -1,  2512,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     203,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2557,  2558,   237,    -1,   239,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2591,    -1,    -1,    -1,
     273,    -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2608,    -1,    -1,    -1,  2612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2642,  2643,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2662,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2671,    -1,  2673,    -1,
    2675,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,
    2695,    -1,    -1,    -1,    -1,  2700,    -1,    -1,    -1,    -1,
      -1,    -1,   385,    -1,    -1,    -1,   389,    -1,  2038,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,  2724,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     433,    -1,    -1,   436,    -1,   438,    -1,    -1,   441,    -1,
      -1,   444,   445,    -1,    -1,    -1,    -1,    -1,    -1,   452,
      -1,   454,    -1,    -1,    -1,    -1,    -1,  2107,   461,    -1,
      -1,  2111,    -1,    -1,   467,  2790,  2116,  2117,    -1,  2794,
      -1,    -1,   475,    -1,    -1,  2125,  2126,   480,  2128,   482,
    2130,  2131,   485,  2133,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2146,    -1,  2148,    -1,
      -1,  2151,  2152,  2153,  2154,    -1,  2156,   510,    -1,    -1,
      -1,   514,    -1,    -1,    -1,    -1,  2841,    -1,  2168,    -1,
      -1,    -1,    -1,    -1,    -1,  2175,    -1,  2177,    -1,  2179,
    2180,  2181,    -1,    -1,    -1,    -1,  2186,  2187,  2188,    -1,
      -1,    -1,  2192,  2193,  2194,    -1,  2196,    -1,  2198,    -1,
    2200,    -1,  2202,    -1,  2204,    -1,   559,    -1,    -1,  2209,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   571,    -1,
      -1,    -1,   575,    -1,    -1,   578,    -1,  2227,    -1,    -1,
      -1,   584,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2243,    -1,    -1,  2246,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     613,    13,    -1,    15,    -1,    -1,   619,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,
      -1,    -1,    -1,    35,    -1,    -1,    -1,  2962,  2963,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    -1,
      -1,    -1,    -1,    -1,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,  2987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3015,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,    -1,  3028,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,   133,   134,    -1,    -1,    -1,  3061,  3062,    -1,  3064,
      -1,    -1,   144,   145,    -1,    -1,    -1,    -1,  3073,    -1,
      -1,    -1,    -1,  3078,    -1,    -1,  3081,    -1,  3083,  3084,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   171,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3104,
      -1,    -1,    -1,    -1,    -1,   187,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3119,    -1,    -1,    -1,    -1,    -1,
      -1,   203,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,
     212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,   239,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3173,    -1,
      -1,    -1,    -1,   255,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,    -1,    -1,    -1,   277,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3208,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2608,    -1,
      -1,    -1,  2612,    -1,    -1,    -1,   368,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3299,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   385,    -1,    -1,    -1,   389,    -1,    -1,
      -1,    -1,  2642,  2643,    -1,    -1,    -1,    -1,   400,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   411,
      -1,    -1,  2662,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2671,    -1,  2673,    -1,  2675,    -1,    -1,    -1,    -1,
      -1,   433,    -1,    -1,   436,    -1,   438,    -1,    -1,   441,
      -1,    -1,   444,   445,    -1,    -1,    -1,    -1,    -1,    -1,
     452,    -1,   454,    -1,    -1,    -1,    -1,    -1,    -1,   461,
      -1,    -1,    -1,    -1,    -1,   467,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   475,  2724,    -1,    -1,    -1,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   510,    -1,
      -1,    -1,   514,    -1,    -1,  3440,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2790,    -1,    -1,    -1,  2794,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3479,  3480,    -1,   559,    -1,    -1,
      -1,    -1,    -1,  3488,    -1,    -1,    -1,    -1,    -1,   571,
      -1,    -1,    -1,   575,    -1,    -1,   578,    -1,    -1,    -1,
      -1,    -1,   584,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2841,    -1,    -1,    -1,    -1,    -1,    24,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    34,    35,    -1,
      -1,   613,    -1,    -1,    -1,    -1,    -1,   619,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   629,    -1,    -1,
    3555,    -1,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,   101,  3600,   103,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   112,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3632,    -1,    -1,
      -1,  3636,  2962,  2963,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   158,   159,    -1,    -1,    -1,    -1,   164,    -1,    -1,
     167,    -1,  3667,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3681,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   193,    -1,   195,  3694,
      -1,    -1,    -1,    -1,    -1,   202,    -1,   204,  3028,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   229,   230,   231,    -1,    -1,    -1,    -1,    -1,
      -1,  3061,  3062,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3073,    -1,   252,    -1,    -1,  3078,    -1,
      -1,  3081,    -1,  3083,  3084,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,    -1,    -1,
      -1,    -1,  3777,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3119,
      -1,    -1,  3797,    -1,   301,    -1,  3801,  3802,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3143,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3832,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3840,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3849,    -1,  3851,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3187,    -1,    -1,
     367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3208,    -1,
      -1,    -1,    -1,    -1,    -1,  3890,   393,  3217,    -1,    -1,
      -1,  3896,  3897,    -1,    -1,    -1,    -1,   404,   405,    -1,
      -1,   408,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   429,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3941,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3950,    -1,    -1,    -1,  3954,
      -1,    -1,    -1,    -1,  3959,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   472,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   485,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3996,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   511,    -1,    -1,    -1,   515,    -1,
    4015,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4028,    -1,  4030,   533,   534,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4040,    -1,  4042,  4043,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4067,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   582,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   601,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4111,    -1,  4113,  4114,
    3440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4134,
      -1,  4136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4151,  4152,    -1,  3479,
    3480,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3488,  4164,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4177,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4225,  4226,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4238,  4239,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4255,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4286,    -1,    -1,    -1,    -1,    -1,    -1,  4293,    -1,
      -1,  4296,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3632,    -1,    -1,    -1,  3636,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4332,    -1,    -1,
      -1,    -1,    -1,    -1,  4339,    -1,  4341,  3667,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4351,    -1,    -1,    -1,
    4355,  3681,    -1,  4358,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3694,  4370,    -1,  4372,    -1,  4374,
      -1,    -1,    -1,    -1,    -1,    -1,  4381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4408,  4409,    -1,    -1,    -1,    -1,  4414,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4424,
    4425,    -1,    -1,    -1,  4429,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4461,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3840,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3849,
      -1,  3851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3890,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3959,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3996,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4028,    -1,
    4030,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4040,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4134,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4225,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4293,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4358,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    45,    46,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    56,  4414,    58,    59,    60,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,   100,   101,   102,
      -1,  4461,   105,   106,   107,    -1,   109,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,   172,
      -1,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,   225,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,   260,   261,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,   398,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,   440,   441,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,
     483,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,
     503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,   512,
     513,   514,   515,    -1,   517,   518,   519,   520,   521,   522,
     523,   524,   525,   526,   527,   528,   529,   530,   531,    -1,
     533,    -1,   535,   536,   537,   538,    -1,   540,   541,   542,
      -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,   552,
     553,   554,   555,    -1,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,    -1,   570,   571,    -1,
      -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,
     583,    -1,    -1,   586,   587,   588,   589,   590,    -1,    -1,
     593,   594,    -1,   596,   597,   598,   599,   600,   601,   602,
      -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,
     613,   614,    -1,    -1,   617,    -1,    -1,    -1,    -1,   622,
     623,    -1,    -1,    -1,    -1,   628,   629,    -1,    -1,   632,
     633,    -1,    -1,   636,   637,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      -1,    31,    -1,    -1,    34,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    66,    67,    68,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    99,
     100,   101,   102,    -1,    -1,   105,   106,   107,    -1,   109,
     110,   111,    -1,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,
      -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,
      -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,
     160,    -1,    -1,   163,   164,    -1,   166,   167,   168,   169,
     170,   171,   172,    -1,   174,   175,   176,   177,   178,   179,
     180,    -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,    -1,   206,    -1,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,
      -1,   221,   222,   223,   224,   225,    -1,   227,   228,   229,
      -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,
     240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,
      -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,
      -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,
      -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
      -1,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,    -1,    -1,   324,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
     440,   441,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,    -1,    -1,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,
     470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,
      -1,   481,    -1,   483,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,
     510,   511,   512,   513,   514,   515,    -1,   517,   518,   519,
     520,   521,   522,   523,   524,   525,   526,   527,   528,   529,
     530,   531,    -1,   533,    -1,   535,   536,   537,   538,    -1,
     540,   541,   542,    -1,   544,   545,   546,   547,    -1,    -1,
      -1,    -1,    -1,   553,   554,   555,    -1,   557,   558,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,    -1,
     570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,
      -1,   581,   582,   583,    -1,    -1,   586,   587,   588,   589,
     590,    -1,    -1,   593,   594,    -1,   596,   597,   598,   599,
     600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,
     610,    -1,   612,   613,   614,    -1,    -1,   617,    -1,    -1,
      -1,    -1,   622,   623,    -1,    -1,    -1,    -1,   628,   629,
      -1,    -1,   632,   633,    -1,    -1,   636,   637,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,   100,   101,   102,    -1,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
     177,   178,   179,   180,    -1,   182,   183,   184,   185,    -1,
     187,    -1,    -1,    -1,   191,   192,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,   206,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
     237,   238,   239,   240,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,   440,   441,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,    -1,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,
      -1,    -1,   509,   510,   511,   512,   513,   514,   515,    -1,
     517,   518,   519,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,   531,    -1,   533,    -1,   535,   536,
     537,   538,    -1,   540,   541,   542,    -1,   544,   545,   546,
     547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,
     557,   558,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,
     577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,   586,
     587,   588,   589,   590,    -1,    -1,   593,   594,    -1,   596,
     597,   598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,
      -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,
     617,    -1,    -1,    -1,    -1,   622,   623,    -1,    -1,    -1,
      -1,   628,   629,    -1,    -1,   632,   633,    -1,    -1,   636,
     637,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      34,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,   100,   101,   102,    -1,
      -1,   105,   106,   107,    -1,   109,   110,   111,    -1,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,
     124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,   172,    -1,
     174,   175,   176,   177,   178,   179,   180,    -1,   182,   183,
     184,   185,    -1,   187,    -1,    -1,    -1,   191,   192,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,   206,    -1,   208,   209,   210,    -1,   212,   213,
     214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,   225,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,
     264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
     344,    -1,    -1,   347,   348,   349,   350,   351,   352,   353,
     354,   355,    -1,   357,   358,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,   440,   441,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,   512,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,   529,   530,   531,    -1,   533,
      -1,   535,   536,   537,   538,    -1,   540,   541,   542,    -1,
     544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,
     554,   555,    -1,   557,   558,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,    -1,   570,   571,    -1,    -1,
     574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,
      -1,    -1,   586,   587,   588,   589,   590,    -1,    -1,   593,
     594,    -1,   596,   597,   598,   599,   600,   601,   602,    -1,
      -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,
     614,    -1,    -1,   617,    -1,    -1,    -1,    -1,   622,   623,
      -1,    -1,    -1,    -1,   628,   629,    -1,    -1,   632,   633,
      -1,    -1,   636,   637,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,   100,
     101,   102,    -1,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,   172,    -1,   174,   175,   176,   177,   178,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,   192,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,   206,    -1,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,   225,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,    -1,   369,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,   440,
     441,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
      -1,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,
     481,    -1,   483,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,
     501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,
     511,   512,   513,   514,   515,    -1,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
     531,    -1,   533,    -1,   535,   536,   537,   538,    -1,   540,
     541,   542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,
      -1,    -1,   553,   554,   555,    -1,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,    -1,   570,
     571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,
     581,   582,   583,    -1,    -1,   586,   587,   588,   589,   590,
      -1,    -1,   593,   594,    -1,   596,   597,   598,   599,   600,
     601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,
      -1,   612,   613,   614,    -1,    -1,   617,    -1,    -1,    -1,
      -1,   622,   623,    -1,    -1,    -1,    -1,   628,   629,    -1,
      -1,   632,   633,    -1,    -1,   636,   637,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,   100,   101,   102,    -1,    -1,   105,   106,   107,
      -1,   109,   110,   111,    -1,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,
     128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,   172,    -1,   174,   175,   176,   177,
     178,   179,   180,    -1,   182,   183,   184,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,   206,    -1,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,
     238,   239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,   344,    -1,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,   440,   441,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,   512,   513,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
     528,   529,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,   540,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,   557,
     558,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,   586,   587,
     588,   589,   590,    -1,    -1,   593,   594,    -1,   596,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,   617,
      -1,    -1,    -1,    -1,   622,   623,    -1,    -1,    -1,    -1,
     628,   629,    -1,    -1,   632,   633,    -1,    -1,   636,   637,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,   100,   101,   102,    -1,    -1,
     105,   106,   107,    -1,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,   172,    -1,   174,
     175,   176,   177,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,   206,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
     225,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,   326,   327,    -1,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,    -1,   364,
     365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,    -1,   400,   401,   402,    -1,   404,
      -1,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,    -1,   434,
     435,    -1,   437,   438,   439,   440,   441,   442,    -1,   444,
      -1,   446,   447,    -1,   449,   450,    -1,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,    -1,
     465,   466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,
      -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,
      -1,   506,    -1,    -1,   509,   510,   511,   512,   513,   514,
     515,    -1,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,    -1,   533,    -1,
     535,   536,   537,   538,    -1,   540,   541,   542,    -1,   544,
     545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,
     555,    -1,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,    -1,   570,   571,    -1,    -1,   574,
      -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,
      -1,   586,   587,   588,   589,   590,    -1,    -1,   593,   594,
      -1,   596,   597,   598,   599,   600,   601,   602,    -1,    -1,
      -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,
      -1,    -1,   617,    -1,    -1,    -1,    -1,   622,   623,    -1,
      -1,    -1,    -1,   628,   629,    -1,    -1,   632,   633,    -1,
      -1,   636,   637,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    34,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,   100,   101,
     102,    -1,    -1,   105,   106,   107,    -1,   109,   110,   111,
      -1,   113,   114,   115,   116,   117,   118,    -1,    -1,    -1,
      -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
     172,    -1,   174,   175,   176,   177,   178,   179,   180,    -1,
     182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,   225,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
     282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,   343,   344,    -1,    -1,   347,   348,   349,   350,   351,
      -1,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,   398,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,   440,   441,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,
      -1,   453,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,
      -1,   483,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,
      -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,
     512,   513,   514,   515,    -1,   517,   518,   519,   520,   521,
     522,   523,   524,   525,   526,   527,   528,   529,   530,   531,
      -1,   533,    -1,   535,   536,   537,   538,    -1,   540,   541,
     542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,
      -1,   553,   554,   555,    -1,   557,   558,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,    -1,   570,   571,
      -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,
     582,   583,    -1,    -1,   586,   587,   588,   589,   590,    -1,
      -1,   593,   594,    -1,   596,   597,   598,   599,   600,   601,
     602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,
     612,   613,   614,    -1,    -1,   617,    -1,    -1,    -1,    -1,
     622,   623,    -1,    -1,    -1,    -1,   628,   629,    -1,    -1,
     632,   633,    -1,    -1,   636,   637,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,   100,   101,   102,    -1,    -1,   105,   106,   107,    -1,
     109,   110,   111,    -1,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,   172,    -1,   174,   175,   176,   177,   178,
     179,   180,    -1,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,   206,    -1,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,   225,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,
     239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,   326,   327,    -1,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,    -1,
     369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,   398,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,   440,   441,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,    -1,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,
     509,   510,   511,   512,   513,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,   523,   524,   525,   526,   527,   528,
     529,   530,   531,    -1,   533,    -1,   535,   536,   537,   538,
      -1,   540,   541,   542,    -1,   544,   545,   546,   547,    -1,
      -1,    -1,    -1,    -1,   553,   554,   555,    -1,   557,   558,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
      -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,
     579,    -1,   581,   582,   583,    -1,    -1,   586,   587,   588,
     589,   590,    -1,    -1,   593,   594,    -1,   596,   597,   598,
     599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,
     609,   610,    -1,   612,   613,   614,    -1,    -1,   617,    -1,
      -1,    -1,    -1,   622,   623,    -1,    -1,    -1,    -1,   628,
     629,    -1,    -1,   632,   633,    -1,    -1,   636,   637,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    34,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,   100,   101,   102,    -1,    -1,   105,
     106,   107,    -1,   109,   110,   111,    -1,   113,   114,   115,
     116,   117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,
      -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,   172,    -1,   174,   175,
     176,   177,   178,   179,   180,    -1,   182,   183,   184,   185,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
     206,    -1,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,   225,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,   237,   238,   239,   240,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,   263,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,   342,   343,   344,    -1,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,   440,   441,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,    -1,    -1,   453,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,
     506,    -1,    -1,   509,   510,   511,   512,   513,   514,   515,
      -1,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   528,   529,   530,   531,    -1,   533,    -1,   535,
     536,   537,   538,    -1,   540,   541,   542,    -1,   544,   545,
     546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,   557,   558,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,
      -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,
     586,   587,   588,   589,   590,    -1,    -1,   593,   594,    -1,
     596,   597,   598,   599,   600,   601,   602,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,
      -1,   617,    -1,    -1,    -1,    -1,   622,   623,    -1,    -1,
      -1,    -1,   628,   629,    -1,    -1,   632,   633,    -1,    -1,
     636,   637,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,   100,   101,   102,
      -1,    -1,   105,   106,   107,    -1,   109,   110,   111,    -1,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
     123,   124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,   172,
      -1,   174,   175,   176,   177,   178,   179,   180,    -1,   182,
     183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,   206,    -1,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,   225,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
     263,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,   326,   327,    -1,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,   398,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,   440,   441,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,
     483,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,
     503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,   512,
     513,   514,   515,    -1,   517,   518,   519,   520,   521,   522,
     523,   524,   525,   526,   527,   528,   529,   530,   531,    -1,
     533,    -1,   535,   536,   537,   538,    -1,   540,   541,   542,
      -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,
     553,   554,   555,    -1,   557,   558,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,    -1,   570,   571,    -1,
      -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,
     583,    -1,    -1,   586,   587,   588,   589,   590,    -1,    -1,
     593,   594,    -1,   596,   597,   598,   599,   600,   601,   602,
      -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,
     613,   614,    -1,    -1,   617,    -1,    -1,    -1,    -1,   622,
     623,    -1,    -1,    -1,    -1,   628,   629,    -1,    -1,   632,
     633,    -1,    -1,   636,   637,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      -1,    31,    -1,    -1,    34,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    66,    67,    68,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    99,
     100,   101,   102,    -1,    -1,   105,   106,   107,    -1,   109,
     110,   111,    -1,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,
      -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,
      -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,
     160,    -1,    -1,   163,   164,    -1,   166,   167,   168,   169,
     170,   171,   172,    -1,   174,   175,   176,   177,   178,   179,
     180,    -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,    -1,   206,    -1,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,
      -1,   221,   222,   223,   224,   225,    -1,   227,   228,   229,
      -1,   231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,
     240,    -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,
      -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,
      -1,   261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,
      -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
      -1,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,    -1,    -1,   324,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,   342,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,    -1,   364,   365,   366,   367,    -1,   369,
     370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,   398,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
     440,   441,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,    -1,    -1,   453,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,
     470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,
      -1,   481,    -1,   483,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,
     510,   511,   512,   513,   514,   515,    -1,   517,   518,   519,
     520,   521,   522,   523,   524,   525,   526,   527,   528,   529,
     530,   531,    -1,   533,    -1,   535,   536,   537,   538,    -1,
     540,   541,   542,    -1,   544,   545,   546,   547,    -1,    -1,
      -1,    -1,    -1,   553,   554,   555,    -1,   557,   558,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,    -1,
     570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,
      -1,   581,   582,   583,    -1,    -1,   586,   587,   588,   589,
     590,    -1,    -1,   593,   594,    -1,   596,   597,   598,   599,
     600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,
     610,    -1,   612,   613,   614,    -1,    -1,   617,    -1,    -1,
      -1,    -1,   622,   623,    -1,    -1,    -1,    -1,   628,   629,
      -1,    -1,   632,   633,    -1,    -1,   636,   637,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,   100,   101,   102,    -1,    -1,   105,   106,
     107,    -1,   109,   110,   111,    -1,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,   128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
     177,   178,   179,   180,    -1,   182,   183,   184,   185,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,   206,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
     237,   238,   239,   240,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,   326,
     327,    -1,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,   398,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,   440,   441,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,    -1,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,
      -1,    -1,   509,   510,   511,   512,   513,   514,   515,    -1,
     517,   518,   519,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,   531,    -1,   533,    -1,   535,   536,
     537,   538,    -1,   540,   541,   542,    -1,   544,   545,   546,
     547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,
     557,   558,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,
     577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,   586,
     587,   588,   589,   590,    -1,    -1,   593,   594,    -1,   596,
     597,   598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,
      -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,
     617,    -1,    -1,    -1,    -1,   622,   623,    -1,    -1,    -1,
      -1,   628,   629,    -1,    -1,   632,   633,    -1,    -1,   636,
     637,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      34,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,   100,   101,   102,    -1,
      -1,   105,   106,   107,    -1,   109,   110,   111,    -1,   113,
     114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,   123,
     124,   125,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,   172,    -1,
     174,   175,   176,   177,   178,   179,   180,    -1,   182,   183,
     184,   185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,   206,    -1,   208,   209,   210,    -1,   212,   213,
     214,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,   225,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,   237,   238,   239,   240,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,   263,
     264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,   342,   343,
     344,    -1,    -1,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,    -1,   357,   358,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,   440,   441,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,   453,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,   512,   513,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,   523,
     524,   525,   526,   527,   528,   529,   530,   531,    -1,   533,
      -1,   535,   536,   537,   538,    -1,   540,   541,   542,    -1,
     544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,
     554,   555,    -1,   557,   558,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,    -1,   570,   571,    -1,    -1,
     574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,
      -1,    -1,   586,   587,   588,   589,   590,    -1,    -1,   593,
     594,    -1,   596,   597,   598,   599,   600,   601,   602,    -1,
      -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,
     614,    -1,    -1,   617,    -1,    -1,    -1,    -1,   622,   623,
      -1,    -1,    -1,    -1,   628,   629,    -1,    -1,   632,   633,
      -1,    -1,   636,   637,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,   100,
     101,   102,    -1,    -1,   105,   106,   107,    -1,   109,   110,
     111,    -1,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,   172,    -1,   174,   175,   176,   177,   178,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,   206,    -1,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,   225,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,   237,   238,   239,   240,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,   263,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,   326,   327,    -1,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,    -1,   369,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,   398,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,   440,
     441,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
      -1,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,
     481,    -1,   483,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,
     501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,
     511,   512,   513,   514,   515,    -1,   517,   518,   519,   520,
     521,   522,   523,   524,   525,   526,   527,   528,   529,   530,
     531,    -1,   533,    -1,   535,   536,   537,   538,    -1,   540,
     541,   542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,
      -1,    -1,   553,   554,   555,    -1,   557,   558,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,    -1,   570,
     571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,
     581,   582,   583,    -1,    -1,   586,   587,   588,   589,   590,
      -1,    -1,   593,   594,    -1,   596,   597,   598,   599,   600,
     601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,
      -1,   612,   613,   614,    -1,    -1,   617,    -1,    -1,    -1,
      -1,   622,   623,    -1,    -1,    -1,    -1,   628,   629,    -1,
      -1,   632,   633,    -1,    -1,   636,   637,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,   100,   101,   102,    -1,    -1,   105,   106,   107,
      -1,   109,   110,   111,    -1,   113,   114,   115,   116,   117,
     118,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,
     128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,   172,    -1,   174,   175,   176,   177,
     178,   179,   180,    -1,   182,   183,   184,   185,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,   206,    -1,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,   225,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,   237,
     238,   239,   240,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,   263,   264,   265,    -1,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,   344,    -1,    -1,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,   440,   441,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,   453,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,   512,   513,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,   523,   524,   525,   526,   527,
     528,   529,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,   540,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,   557,
     558,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,   586,   587,
     588,   589,   590,    -1,    -1,   593,   594,    -1,   596,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,   617,
      -1,    -1,    -1,    -1,   622,   623,    -1,    -1,    -1,    -1,
     628,   629,    -1,    -1,   632,   633,    -1,    -1,   636,   637,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,
      35,    36,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,
     125,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,    -1,    -1,   174,
     175,   176,    -1,   178,   179,   180,    -1,   182,   183,   184,
     185,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
      -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,    -1,   364,
     365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,    -1,   400,   401,   402,    -1,   404,
      -1,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,    -1,   434,
     435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,
      -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,    -1,
     465,   466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,
      -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,
      -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,
     515,    -1,   517,   518,   519,   520,   521,   522,    -1,    -1,
     525,   526,   527,   528,    -1,   530,   531,    -1,   533,    -1,
     535,   536,   537,   538,    -1,   540,   541,   542,    -1,   544,
     545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,
     555,    -1,    -1,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,    -1,   570,   571,    -1,    -1,   574,
      -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,
      -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,
      -1,    -1,   597,   598,   599,   600,   601,   602,    -1,    -1,
      -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,
      -1,    -1,   617,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,   636,   637,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,   194,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,   230,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,   254,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,   267,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,   467,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,    -1,    -1,   525,   526,   527,
     528,    -1,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,    -1,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,
      -1,   559,   560,   561,   562,    -1,   564,   565,    -1,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,
      -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,   617,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   637,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,   194,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,   230,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,   254,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
      -1,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,
     483,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,
     503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,
      -1,   514,   515,    -1,   517,   518,   519,   520,   521,   522,
      -1,    -1,   525,   526,   527,   528,    -1,   530,   531,    -1,
     533,    -1,   535,   536,   537,   538,    -1,    -1,   541,   542,
      -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,
     553,   554,   555,    -1,    -1,    -1,   559,   560,   561,   562,
      -1,   564,   565,    -1,   567,   568,    -1,   570,   571,    -1,
      -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,
     583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,
     593,    -1,    -1,    -1,   597,   598,   599,   600,   601,   602,
      -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,
     613,   614,    -1,    -1,   617,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   637,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,   467,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,    -1,    -1,   525,   526,   527,
     528,    -1,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,    -1,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,
      -1,   559,   560,   561,   562,    -1,   564,   565,    -1,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,
      -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,   617,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,   630,    -1,    -1,    18,    -1,    -1,    21,   637,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
      -1,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,
     483,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,
     503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,
      -1,   514,   515,    -1,   517,   518,   519,   520,   521,   522,
      -1,    -1,   525,   526,   527,   528,    -1,   530,   531,    -1,
     533,    -1,   535,   536,   537,   538,    -1,    -1,   541,   542,
      -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,
     553,   554,   555,    -1,    -1,    -1,   559,   560,   561,   562,
      -1,   564,   565,    -1,   567,   568,    -1,   570,   571,    -1,
      -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,
     583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,
     593,    -1,    -1,    -1,   597,   598,   599,   600,   601,   602,
      -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,
     613,   614,    -1,    -1,   617,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,   630,    14,    -1,
      -1,    -1,    18,   636,   637,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,
     506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,
      -1,   517,   518,   519,   520,   521,   522,    -1,    -1,   525,
     526,   527,   528,    -1,   530,   531,    -1,   533,    -1,   535,
     536,   537,   538,    -1,    -1,   541,   542,    -1,   544,   545,
     546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,    -1,    -1,   559,   560,   561,   562,    -1,   564,   565,
      -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,
      -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,
      -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,
      -1,   597,   598,   599,   600,   601,   602,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,
      -1,   617,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,   629,    -1,    14,    -1,    -1,    -1,    18,
      -1,   637,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,   241,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,    -1,
     369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,    -1,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,    -1,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,
     509,   510,   511,    -1,    -1,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,    -1,    -1,   525,   526,   527,   528,
      -1,   530,   531,    -1,   533,    -1,   535,   536,   537,   538,
      -1,    -1,   541,   542,    -1,   544,   545,   546,   547,    -1,
      -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,
     559,   560,   561,   562,    -1,   564,   565,    -1,   567,   568,
      -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,
     579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,
      -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,
     599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,
     609,   610,    -1,   612,   613,   614,    -1,    -1,   617,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
      -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,
     114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,
     124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,    -1,
     174,   175,   176,    -1,    -1,   179,   180,    -1,   182,   183,
     184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,
     264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
      -1,   305,   306,   307,   308,    -1,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,    -1,   327,    -1,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,    -1,
      -1,   525,   526,   527,   528,    -1,   530,   531,    -1,   533,
      -1,   535,   536,   537,   538,    -1,    -1,   541,   542,    -1,
     544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,
     554,   555,    -1,    -1,    -1,   559,   560,   561,   562,    -1,
     564,   565,    -1,   567,   568,    -1,   570,   571,    -1,    -1,
     574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,
      -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,
      -1,    -1,    -1,   597,   598,   599,   600,   601,   602,    -1,
      -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,
     614,    -1,    -1,   617,    -1,    -1,    -1,    -1,    -1,     5,
     624,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,   637,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,
     506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,
      -1,   517,   518,   519,   520,   521,   522,    -1,    -1,   525,
     526,   527,   528,    -1,   530,   531,    -1,   533,    -1,   535,
     536,   537,   538,    -1,    -1,   541,   542,    -1,   544,   545,
     546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,    -1,    -1,   559,   560,   561,   562,    -1,   564,   565,
      -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,
      -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,
      -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,
      -1,   597,   598,   599,   600,   601,   602,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,
      -1,   617,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,   629,    -1,    14,    -1,    -1,    -1,    18,
      -1,   637,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,    -1,
     369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,    -1,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,    -1,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,
     509,   510,   511,    -1,    -1,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,    -1,    -1,   525,   526,   527,   528,
      -1,   530,   531,    -1,   533,    -1,   535,   536,   537,   538,
      -1,    -1,   541,   542,    -1,   544,   545,   546,   547,    -1,
      -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,
     559,   560,   561,   562,    -1,   564,   565,    -1,   567,   568,
      -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,
     579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,
      -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,
     599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,
     609,   610,    -1,   612,   613,   614,    -1,    -1,   617,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,   636,   637,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,    -1,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,    -1,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,
      -1,   483,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,
      -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,
      -1,    -1,   514,   515,    -1,   517,   518,   519,   520,   521,
     522,    -1,    -1,   525,   526,   527,   528,    -1,   530,   531,
      -1,   533,    -1,   535,   536,   537,   538,    -1,    -1,   541,
     542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,
      -1,   553,   554,   555,    -1,    -1,    -1,   559,   560,   561,
     562,    -1,   564,   565,    -1,   567,   568,    -1,   570,   571,
      -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,
     582,   583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,
      -1,   593,    -1,    -1,    -1,   597,   598,   599,   600,   601,
     602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,
     612,   613,   614,    -1,    -1,   617,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,   637,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,
      -1,    58,    59,    -1,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,
      -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,    -1,    -1,   174,   175,   176,
      -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,    -1,   305,   306,
     307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,    -1,
     327,    -1,   329,    -1,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,
      -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,
     517,   518,   519,   520,   521,   522,    -1,    -1,   525,   526,
     527,   528,    -1,   530,   531,    -1,   533,    -1,   535,   536,
     537,   538,    -1,    -1,   541,   542,    -1,   544,   545,   546,
     547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,
      -1,    -1,   559,   560,   561,   562,    -1,   564,   565,    -1,
     567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,
     577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,
      -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,
     597,   598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,
      -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,
     617,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     637,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,    -1,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,    -1,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,
      -1,   483,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,
      -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,
      -1,    -1,   514,   515,    -1,   517,   518,   519,   520,   521,
     522,    -1,    -1,   525,   526,   527,   528,    -1,   530,   531,
      -1,   533,    -1,   535,   536,   537,   538,    -1,    -1,   541,
     542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,
      -1,   553,   554,   555,    -1,    -1,    -1,   559,   560,   561,
     562,    -1,   564,   565,    -1,   567,   568,    -1,   570,   571,
      -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,
     582,   583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,
      -1,   593,    -1,    -1,    -1,   597,   598,   599,   600,   601,
     602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,
     612,   613,   614,    -1,    -1,   617,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,   637,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,
      -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,
      -1,    58,    59,    -1,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,
      -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,    -1,    -1,   174,   175,   176,
      -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,    -1,   305,   306,
     307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,    -1,
     327,    -1,   329,    -1,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,
      -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,
     517,   518,   519,   520,   521,   522,    -1,    -1,   525,   526,
     527,   528,    -1,   530,   531,    -1,   533,    -1,   535,   536,
     537,   538,    -1,    -1,   541,   542,    -1,   544,   545,   546,
     547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,
      -1,    -1,   559,   560,   561,   562,    -1,   564,   565,    -1,
     567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,
     577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,
      -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,
     597,   598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,
      -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,
     617,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     637,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,   266,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,    -1,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,    -1,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,
      -1,   483,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,
      -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,
      -1,    -1,   514,   515,    -1,   517,   518,   519,   520,   521,
     522,    -1,    -1,   525,   526,   527,   528,    -1,   530,   531,
      -1,   533,    -1,   535,   536,   537,   538,    -1,   540,   541,
     542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,
      -1,   553,   554,   555,    -1,    -1,    -1,   559,   560,   561,
     562,    -1,   564,   565,    -1,   567,   568,    -1,   570,   571,
      -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,
     582,   583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,
      -1,   593,    -1,    -1,    -1,   597,   598,   599,   600,   601,
     602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,
     612,   613,   614,    -1,    -1,   617,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   636,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
      -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,    -1,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,    -1,    -1,   525,   526,   527,
     528,    -1,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,   540,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,
      -1,   559,   560,   561,   562,    -1,   564,   565,    -1,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,
      -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,    -1,   617,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,   636,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
      -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,
     114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,
     124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,    -1,
     174,   175,   176,    -1,    -1,   179,   180,    -1,   182,   183,
     184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,
     264,   265,   266,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
      -1,   305,   306,   307,   308,    -1,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,    -1,   327,    -1,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,    -1,
      -1,   525,   526,   527,   528,    -1,   530,   531,    -1,   533,
      -1,   535,   536,   537,   538,    -1,   540,   541,   542,    -1,
     544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,
     554,   555,    -1,    -1,    -1,   559,   560,   561,   562,    -1,
     564,   565,    -1,   567,   568,    -1,   570,   571,    -1,    -1,
     574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,
      -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,
      -1,    -1,    -1,   597,   598,   599,   600,   601,   602,    -1,
      -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,
     614,    -1,    -1,   617,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    -1,   636,    23,    24,    25,    26,    27,    28,    -1,
      -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    -1,
      -1,    -1,    52,    53,    -1,    55,    56,    -1,    58,    -1,
      -1,    -1,    -1,    -1,    64,    65,    66,    67,    68,    69,
      70,    -1,    72,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    81,    -1,    83,    -1,    85,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    -1,    97,    -1,    99,
      -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,   109,
      -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,    -1,
      -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,   129,
      -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,
     140,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
      -1,    -1,    -1,   153,    -1,    -1,   156,    -1,   158,   159,
     160,    -1,    -1,   163,   164,    -1,   166,   167,   168,   169,
      -1,    -1,    -1,    -1,   174,   175,   176,    -1,    -1,   179,
     180,   181,   182,   183,   184,    -1,    -1,    -1,    -1,    -1,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,    -1,    -1,    -1,    -1,   209,
     210,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,    -1,
      -1,   221,   222,   223,   224,   225,    -1,   227,   228,   229,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,    -1,
      -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,
     250,    -1,    -1,   253,    -1,    -1,    -1,   257,   258,    -1,
      -1,   261,   262,    -1,   264,   265,    -1,    -1,    -1,    -1,
      -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,   279,
      -1,    -1,    -1,    -1,   284,    -1,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
      -1,   301,   302,   303,    -1,   305,   306,   307,   308,    -1,
     310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,    -1,   355,    -1,    -1,    -1,    -1,
     360,   361,   362,    -1,   364,   365,   366,   367,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     380,   381,    -1,    -1,    -1,    -1,   386,   387,   388,    -1,
     390,   391,   392,   393,   394,   395,   396,    -1,    -1,    -1,
      -1,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,    -1,    -1,   437,    -1,   439,
     440,    -1,   442,    -1,    -1,    -1,   446,    -1,    -1,   449,
     450,   451,    -1,    -1,    -1,   455,   456,   457,   458,   459,
     460,    -1,   462,   463,    -1,   465,    -1,    -1,    -1,    -1,
     470,   471,   472,    -1,    -1,    -1,    -1,   477,    -1,    -1,
      -1,   481,    -1,    -1,   484,    -1,   486,    -1,   488,    -1,
     490,    -1,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,
      -1,   511,    -1,    -1,    -1,   515,    -1,   517,   518,   519,
     520,   521,   522,    -1,    -1,   525,   526,   527,   528,    -1,
     530,   531,    -1,   533,    -1,   535,   536,   537,   538,    -1,
      -1,   541,   542,    -1,   544,   545,   546,   547,    -1,    -1,
      -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,    -1,
     560,   561,   562,    -1,   564,   565,    -1,   567,   568,    -1,
      -1,    -1,    -1,    -1,   574,    -1,    -1,   577,    -1,    -1,
      -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,    -1,
     590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,   599,
     600,   601,   602,    -1,    -1,   605,    -1,    -1,    -1,   609,
      -1,    -1,   612,    -1,   614,    -1,     5,   617,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,   631,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,   107,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,    -1,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,    -1,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,    -1,
     369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,    -1,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,    -1,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,
     509,   510,   511,    -1,    -1,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,    -1,    -1,   525,   526,   527,   528,
      -1,   530,   531,    -1,   533,    -1,   535,   536,   537,   538,
      -1,   540,   541,   542,    -1,   544,   545,   546,   547,    -1,
      -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,
     559,   560,   561,   562,    -1,   564,   565,    -1,   567,   568,
      -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,
     579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,
      -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,
     599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,
     609,   610,    -1,   612,   613,   614,    -1,    -1,   617,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
     629,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,
     506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,
      -1,   517,   518,   519,   520,   521,   522,    -1,    -1,   525,
     526,   527,   528,    -1,   530,   531,    -1,   533,    -1,   535,
     536,   537,   538,    -1,    -1,   541,   542,    -1,   544,   545,
     546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,    -1,    -1,   559,   560,   561,   562,    -1,   564,   565,
      -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,
      -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,
      -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,
      -1,   597,   598,   599,   600,   601,   602,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,
       5,   617,     7,     8,     9,    10,    11,    -1,   624,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,
      35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,
      -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,    -1,    -1,   174,
     175,   176,    -1,    -1,   179,   180,    -1,   182,   183,   184,
      -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
      -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,
     265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,    -1,   360,   361,   362,    -1,   364,
     365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,    -1,   400,   401,   402,    -1,   404,
      -1,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,    -1,   434,
     435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,
      -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,    -1,
     465,   466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,
      -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,
      -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,
     515,    -1,   517,   518,   519,   520,   521,   522,    -1,    -1,
     525,   526,   527,   528,    -1,   530,   531,    -1,   533,    -1,
     535,   536,   537,   538,    -1,    -1,   541,   542,    -1,   544,
     545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,
     555,    -1,    -1,    -1,   559,   560,   561,   562,    -1,   564,
     565,    -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,
      -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,
      -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,
      -1,    -1,   597,   598,   599,   600,   601,   602,    -1,    -1,
      -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,
      -1,     5,   617,     7,     8,     9,    10,    11,    -1,   624,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
      -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,
     114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,
     124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,    -1,
     174,   175,   176,    -1,    -1,   179,   180,    -1,   182,   183,
     184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,
     264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
      -1,   305,   306,   307,   308,    -1,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,    -1,   327,    -1,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,
     514,   515,    -1,   517,   518,   519,   520,   521,   522,    -1,
      -1,   525,   526,   527,   528,    -1,   530,   531,    -1,   533,
      -1,   535,   536,   537,   538,    -1,    -1,   541,   542,    -1,
     544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,
     554,   555,    -1,    -1,    -1,   559,   560,   561,   562,    -1,
     564,   565,    -1,   567,   568,    -1,   570,   571,    -1,    -1,
     574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,
      -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,
      -1,    -1,    -1,   597,   598,   599,   600,   601,   602,    -1,
      -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,
     614,    -1,     5,   617,     7,     8,     9,    10,    11,    -1,
     624,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    -1,    31,    -1,
      -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,
      -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,    62,
      -1,    64,    65,    66,    67,    68,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    99,    -1,    -1,   102,
      -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,
     113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,
     123,   124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
     153,    -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,
     163,   164,    -1,   166,   167,   168,   169,   170,   171,    -1,
      -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,   182,
     183,   184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,
     193,    -1,   195,    -1,   197,   198,   199,   200,   201,   202,
      -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,
     223,   224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,
     233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,
     243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,
     253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,
      -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,    -1,   301,   302,
     303,    -1,   305,   306,   307,   308,    -1,   310,   311,    -1,
      -1,    -1,    -1,   316,   317,   318,   319,   320,   321,    -1,
      -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,    -1,   360,   361,   362,
      -1,   364,   365,   366,   367,    -1,   369,   370,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
      -1,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,   397,    -1,    -1,   400,   401,   402,
      -1,   404,    -1,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
      -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,   442,
      -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,
     473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,
     483,   484,   485,   486,    -1,   488,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,
     503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,
      -1,   514,   515,    -1,   517,   518,   519,   520,   521,   522,
      -1,    -1,   525,   526,   527,   528,    -1,   530,   531,    -1,
     533,    -1,   535,   536,   537,   538,    -1,    -1,   541,   542,
      -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,    -1,
     553,   554,   555,    -1,    -1,    -1,   559,   560,   561,   562,
      -1,   564,   565,    -1,   567,   568,    -1,   570,   571,    -1,
      -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,   582,
     583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,
     593,    -1,    -1,    -1,   597,   598,   599,   600,   601,   602,
      -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,   612,
     613,   614,    -1,     5,   617,     7,     8,     9,    10,    11,
      -1,   624,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    -1,    31,
      -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    48,    49,    -1,    -1,
      52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,    61,
      62,    -1,    64,    65,    66,    67,    68,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    99,    -1,    -1,
     102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,    -1,
      -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   123,   124,   125,    -1,    -1,    -1,   129,    -1,   131,
      -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,    -1,
      -1,   153,    -1,   155,   156,    -1,   158,   159,   160,    -1,
      -1,   163,   164,    -1,   166,   167,   168,   169,   170,   171,
      -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,    -1,
     182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,   191,
      -1,   193,    -1,   195,    -1,   197,   198,   199,   200,   201,
     202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,    -1,
     212,   213,    -1,    -1,   216,   217,    -1,    -1,    -1,   221,
     222,   223,   224,    -1,    -1,   227,   228,   229,    -1,   231,
      -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,    -1,
      -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,    -1,
      -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,   261,
      -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,   271,
     272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,    -1,
     282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,    -1,   301,
     302,   303,    -1,   305,   306,   307,   308,    -1,   310,   311,
      -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,   321,
      -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,    -1,    -1,   358,    -1,   360,   361,
     362,    -1,   364,   365,   366,   367,    -1,   369,   370,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,    -1,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,   396,   397,    -1,    -1,   400,   401,
     402,    -1,   404,    -1,   406,   407,   408,   409,   410,    -1,
     412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,    -1,   434,   435,    -1,   437,   438,   439,    -1,    -1,
     442,    -1,   444,    -1,   446,   447,    -1,   449,   450,    -1,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,   471,
     472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,   481,
      -1,   483,   484,   485,   486,    -1,   488,   489,   490,   491,
     492,   493,    -1,    -1,   496,   497,   498,    -1,   500,   501,
      -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,   511,
      -1,    -1,   514,   515,    -1,   517,   518,   519,   520,   521,
     522,    -1,    -1,   525,   526,   527,   528,    -1,   530,   531,
      -1,   533,    -1,   535,   536,   537,   538,    -1,    -1,   541,
     542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,    -1,
      -1,   553,   554,   555,    -1,    -1,    -1,   559,   560,   561,
     562,   563,   564,   565,    -1,   567,   568,    -1,   570,   571,
      -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,   581,
     582,   583,    -1,    -1,    -1,    -1,    -1,    -1,   590,    -1,
      -1,   593,    -1,    -1,    -1,   597,   598,   599,   600,   601,
     602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,    -1,
     612,   613,   614,    -1,     5,   617,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    -1,
      31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      -1,    52,    -1,    -1,    55,    56,    -1,    58,    59,    -1,
      61,    62,    -1,    64,    65,    66,    67,    68,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    99,    -1,
      -1,   102,    -1,    -1,   105,    -1,    -1,    -1,   109,    -1,
      -1,    -1,   113,   114,   115,    -1,    -1,   118,    -1,    -1,
      -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,    -1,
     131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,   160,
      -1,    -1,   163,   164,    -1,   166,   167,   168,   169,   170,
     171,    -1,    -1,   174,   175,   176,    -1,    -1,   179,   180,
      -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,    -1,
     191,    -1,   193,    -1,   195,    -1,   197,   198,   199,   200,
     201,   202,    -1,   204,    -1,    -1,    -1,   208,   209,   210,
      -1,   212,   213,    -1,    -1,   216,   217,    -1,    -1,    -1,
     221,   222,   223,   224,    -1,    -1,   227,   228,   229,    -1,
     231,    -1,   233,    -1,    -1,    -1,    -1,   238,   239,    -1,
      -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,    -1,
      -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,    -1,
     261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,    -1,
     271,   272,    -1,   274,    -1,   276,    -1,   278,   279,    -1,
      -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,    -1,
     301,   302,   303,    -1,   305,   306,   307,   308,    -1,   310,
     311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,   320,
     321,    -1,    -1,   324,   325,    -1,   327,    -1,   329,    -1,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,   358,    -1,   360,
     361,   362,    -1,   364,   365,   366,   367,    -1,   369,   370,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,    -1,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,   397,    -1,    -1,   400,
     401,   402,    -1,   404,    -1,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,    -1,   434,   435,    -1,   437,   438,   439,    -1,
      -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,   450,
      -1,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,   470,
     471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,
     481,    -1,   483,   484,   485,   486,    -1,   488,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,   500,
     501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,   510,
     511,    -1,    -1,   514,   515,    -1,   517,   518,   519,   520,
     521,   522,    -1,    -1,   525,   526,   527,   528,    -1,   530,
     531,    -1,   533,    -1,   535,   536,   537,   538,    -1,   540,
     541,   542,    -1,   544,   545,   546,   547,    -1,    -1,    -1,
      -1,    -1,   553,   554,   555,    -1,    -1,    -1,   559,   560,
     561,   562,   563,   564,   565,    -1,   567,   568,    -1,   570,
     571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,    -1,
     581,   582,   583,    -1,    -1,    -1,    -1,    -1,    -1,   590,
      -1,    -1,   593,    -1,    -1,    -1,   597,   598,   599,   600,
     601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,   610,
      -1,   612,   613,   614,    -1,     5,   617,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    29,
      -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,    39,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,    49,
      -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,    59,
      -1,    61,    62,    -1,    64,    65,    66,    67,    68,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    99,
      -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,   109,
      -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,    -1,
      -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,   129,
      -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,   149,
      -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,   159,
     160,    -1,    -1,   163,   164,    -1,   166,   167,   168,   169,
     170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,   179,
     180,    -1,   182,   183,   184,   185,    -1,   187,    -1,    -1,
      -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,   199,
     200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,   209,
     210,    -1,   212,   213,    -1,    -1,   216,   217,    -1,    -1,
      -1,   221,   222,   223,   224,    -1,    -1,   227,   228,   229,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,   239,
      -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,   249,
      -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,    -1,
      -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,    -1,
      -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,   279,
      -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
      -1,   301,   302,   303,    -1,   305,   306,   307,   308,    -1,
     310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,   319,
     320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,   329,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,   358,    -1,
     360,   361,   362,    -1,   364,   365,   366,   367,    -1,   369,
     370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,    -1,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,   397,    -1,    -1,
     400,   401,   402,    -1,   404,    -1,   406,   407,   408,   409,
     410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,    -1,   434,   435,    -1,   437,   438,   439,
      -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,   449,
     450,    -1,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,    -1,   465,   466,    -1,    -1,    -1,
     470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,    -1,
      -1,   481,    -1,   483,   484,   485,   486,    -1,   488,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,    -1,
     500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,   509,
     510,   511,    -1,    -1,   514,   515,    -1,   517,   518,   519,
     520,   521,   522,    -1,    -1,   525,   526,   527,   528,    -1,
     530,   531,    -1,   533,    -1,   535,   536,   537,   538,    -1,
     540,   541,   542,    -1,   544,   545,   546,   547,    -1,    -1,
      -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,   559,
     560,   561,   562,   563,   564,   565,    -1,   567,   568,    -1,
     570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,   579,
      -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,    -1,
     590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,   599,
     600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,   609,
     610,    -1,   612,   613,   614,    -1,     5,   617,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    -1,    31,    -1,    -1,    -1,    35,    -1,    -1,    -1,
      39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,    58,
      59,    -1,    61,    62,    -1,    64,    65,    66,    67,    68,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,    -1,
     109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,   118,
      -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,   128,
     129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,   158,
     159,   160,    -1,    -1,   163,   164,    -1,   166,   167,   168,
     169,   170,   171,    -1,    -1,   174,   175,   176,    -1,    -1,
     179,   180,    -1,   182,   183,   184,   185,    -1,   187,    -1,
      -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,   198,
     199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,    -1,   212,   213,    -1,    -1,   216,   217,    -1,
      -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,   228,
     229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,   238,
     239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,   248,
     249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,   258,
      -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,    -1,
      -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,   278,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,    -1,   301,   302,   303,    -1,   305,   306,   307,   308,
      -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,   318,
     319,   320,   321,    -1,    -1,   324,   325,    -1,   327,    -1,
     329,    -1,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,   358,
      -1,   360,   361,   362,    -1,   364,   365,   366,   367,    -1,
     369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,    -1,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,   397,    -1,
      -1,   400,   401,   402,    -1,   404,    -1,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,    -1,   417,    -1,
      -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,   428,
     429,   430,   431,   432,    -1,   434,   435,    -1,   437,   438,
     439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,    -1,
     449,   450,    -1,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,    -1,   465,   466,    -1,    -1,
      -1,   470,   471,   472,   473,    -1,    -1,    -1,   477,    -1,
      -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,   488,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
      -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,    -1,
     509,   510,   511,    -1,    -1,   514,   515,    -1,   517,   518,
     519,   520,   521,   522,    -1,    -1,   525,   526,   527,   528,
      -1,   530,   531,    -1,   533,    -1,   535,   536,   537,   538,
      -1,   540,   541,   542,    -1,   544,   545,   546,   547,    -1,
      -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,    -1,
     559,   560,   561,   562,   563,   564,   565,    -1,   567,   568,
      -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,    -1,
     579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,    -1,
      -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,   598,
     599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,    -1,
     609,   610,    -1,   612,   613,   614,    -1,     5,   617,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    29,    -1,    31,    -1,    -1,    34,    35,    -1,    -1,
      -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,    -1,
      58,    59,    -1,    61,    62,    -1,    64,    65,    66,    67,
      68,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,    -1,
      -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,    -1,
     118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,    -1,
     128,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,   137,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,   147,
     148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,    -1,
     158,   159,   160,   161,    -1,   163,   164,    -1,   166,   167,
     168,   169,   170,   171,    -1,    -1,   174,   175,   176,    -1,
      -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,   187,
      -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,   197,
     198,   199,   200,   201,   202,    -1,   204,    -1,    -1,    -1,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,   227,
     228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,
     238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,    -1,
     248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,   257,
     258,    -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,
      -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,    -1,
     278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,    -1,   301,   302,   303,    -1,   305,   306,   307,
     308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,   317,
     318,   319,   320,   321,    -1,    -1,   324,   325,    -1,   327,
      -1,   329,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,    -1,   360,   361,   362,    -1,   364,   365,   366,   367,
      -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
      -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,   407,
     408,   409,   410,    -1,   412,   413,   414,    -1,    -1,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,    -1,   434,   435,    -1,   437,
     438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,   447,
      -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,    -1,   465,   466,    -1,
      -1,    -1,   470,   471,   472,   473,    -1,    -1,   476,   477,
      -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,    -1,
     488,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,    -1,
      -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,   517,
     518,   519,   520,   521,   522,    -1,    -1,   525,   526,   527,
     528,    -1,   530,   531,    -1,   533,    -1,   535,   536,   537,
     538,    -1,   540,   541,   542,    -1,   544,   545,   546,   547,
      -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,    -1,
      -1,   559,   560,   561,   562,    -1,   564,   565,    -1,   567,
     568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,   577,
      -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,    -1,
      -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,   597,
     598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,    -1,
      -1,   609,   610,    -1,   612,   613,   614,    -1,     5,   617,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,    36,
      -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,    56,
      -1,    58,    59,    -1,    61,    62,    -1,    64,    65,    66,
      67,    68,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,    -1,
      -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,    -1,
      -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,    -1,
      -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,   156,
      -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,   166,
     167,   168,   169,   170,   171,    -1,    -1,   174,   175,   176,
      -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,    -1,
     187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,    -1,
     197,   198,   199,   200,   201,   202,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,    -1,
     227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,   246,
      -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,   256,
     257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,
      -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,   276,
      -1,   278,   279,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,    -1,   301,   302,   303,    -1,   305,   306,
     307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,   316,
     317,   318,   319,   320,   321,    -1,    -1,   324,   325,    -1,
     327,    -1,   329,    -1,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,    -1,   360,   361,   362,    -1,   364,   365,   366,
     367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,    -1,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
     397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,    -1,
     417,    -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,
      -1,   428,   429,   430,   431,   432,    -1,   434,   435,    -1,
     437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,   446,
     447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,    -1,   465,   466,
      -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,    -1,
     477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,   486,
      -1,   488,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,   506,
      -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,    -1,
     517,   518,   519,   520,   521,   522,    -1,    -1,   525,   526,
     527,   528,    -1,   530,   531,    -1,   533,    -1,   535,   536,
     537,   538,    -1,   540,   541,   542,    -1,   544,   545,   546,
     547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,    -1,
      -1,    -1,   559,   560,   561,   562,    -1,   564,   565,    -1,
     567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,    -1,
     577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,    -1,
      -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,    -1,
     597,   598,   599,   600,   601,   602,    -1,    -1,    -1,    -1,
      -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,     5,
     617,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    29,    -1,    31,    -1,    -1,    -1,    35,
      -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,    55,
      56,    -1,    58,    59,    -1,    61,    62,    -1,    64,    65,
      66,    67,    68,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,   105,
      -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,   115,
      -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,    -1,   129,    -1,   131,    -1,    -1,    -1,   135,
      -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
      -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,   155,
     156,    -1,   158,   159,   160,    -1,    -1,   163,   164,    -1,
     166,   167,   168,   169,   170,   171,    -1,    -1,   174,   175,
     176,    -1,    -1,   179,   180,    -1,   182,   183,   184,    -1,
      -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,   195,
      -1,   197,   198,   199,   200,   201,   202,    -1,   204,    -1,
      -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,    -1,    -1,    -1,   221,   222,   223,   224,    -1,
      -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,    -1,
      -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,   245,
     246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,    -1,
     256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,   265,
      -1,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,    -1,
     276,    -1,   278,   279,    -1,    -1,   282,    -1,    -1,    -1,
      -1,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,    -1,   301,   302,   303,    -1,   305,
     306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,    -1,
     316,   317,   318,   319,   320,   321,    -1,    -1,   324,   325,
      -1,   327,    -1,   329,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,   358,    -1,   360,   361,   362,    -1,   364,   365,
     366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,    -1,    -1,   400,   401,   402,    -1,   404,    -1,
     406,   407,   408,   409,   410,    -1,   412,   413,   414,    -1,
      -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,    -1,   434,   435,
      -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,    -1,
     446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,    -1,   465,
     466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,    -1,
      -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,   485,
     486,    -1,   488,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,    -1,
     506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,   515,
      -1,   517,   518,   519,   520,   521,   522,    -1,    -1,   525,
     526,   527,   528,    -1,   530,   531,    -1,   533,    -1,   535,
     536,   537,   538,    -1,    -1,   541,   542,    -1,   544,   545,
     546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,   555,
      -1,    -1,    -1,   559,   560,   561,   562,   563,   564,   565,
      -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,    -1,
      -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,    -1,
      -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,    -1,
      -1,   597,   598,   599,   600,   601,   602,    -1,    -1,    -1,
      -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,    -1,
       5,   617,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    -1,    31,    -1,    -1,    34,
      35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,    -1,
      55,    56,    -1,    58,    59,    -1,    61,    62,    -1,    64,
      65,    66,    67,    68,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,    -1,
     105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,   114,
     115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,   124,
      -1,    -1,    -1,   128,   129,    -1,   131,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,    -1,
     155,   156,    -1,   158,   159,   160,    -1,    -1,   163,   164,
      -1,   166,   167,   168,   169,   170,   171,    -1,    -1,   174,
     175,   176,    -1,    -1,   179,   180,    -1,   182,   183,   184,
      -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,    -1,
     195,    -1,   197,   198,   199,   200,   201,   202,    -1,   204,
      -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,   224,
      -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,    -1,
     245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,    -1,    -1,   271,   272,    -1,   274,
      -1,   276,    -1,   278,   279,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,    -1,   301,   302,   303,    -1,
     305,   306,   307,   308,    -1,   310,   311,    -1,    -1,    -1,
      -1,   316,   317,   318,   319,   320,   321,    -1,    -1,   324,
     325,    -1,   327,    -1,   329,    -1,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,    -1,   360,   361,   362,    -1,   364,
     365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,    -1,    -1,   400,   401,   402,    -1,   404,
      -1,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,    -1,   434,
     435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,   444,
      -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,    -1,
     465,   466,    -1,    -1,    -1,   470,   471,   472,   473,    -1,
      -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,   484,
     485,   486,    -1,   488,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,    -1,
      -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,   514,
     515,    -1,   517,   518,   519,   520,   521,   522,    -1,    -1,
     525,   526,   527,   528,    -1,   530,   531,    -1,   533,    -1,
     535,   536,   537,   538,    -1,   540,   541,   542,    -1,   544,
     545,   546,   547,    -1,    -1,    -1,    -1,    -1,   553,   554,
     555,    -1,    -1,    -1,   559,   560,   561,   562,    -1,   564,
     565,    -1,   567,   568,    -1,   570,   571,    -1,    -1,   574,
      -1,    -1,   577,    -1,   579,    -1,   581,   582,   583,    -1,
      -1,    -1,    -1,    -1,    -1,   590,    -1,    -1,   593,    -1,
      -1,    -1,   597,   598,   599,   600,   601,   602,    -1,    -1,
      -1,    -1,    -1,    -1,   609,   610,    -1,   612,   613,   614,
      -1,     5,   617,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    -1,    31,    -1,    -1,
      -1,    35,    -1,    -1,    -1,    39,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    -1,    52,    -1,
      -1,    55,    56,    -1,    58,    59,    -1,    61,    62,    -1,
      64,    65,    66,    67,    68,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    99,    -1,    -1,   102,    -1,
      -1,   105,    -1,    -1,    -1,   109,    -1,    -1,    -1,   113,
     114,   115,    -1,    -1,   118,    -1,    -1,    -1,    -1,   123,
     124,    -1,    -1,    -1,    -1,   129,    -1,   131,    -1,    -1,
      -1,   135,    -1,   137,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,   153,
      -1,   155,   156,    -1,   158,   159,   160,    -1,    -1,   163,
     164,    -1,   166,   167,   168,   169,   170,   171,    -1,    -1,
     174,   175,   176,    -1,    -1,   179,   180,    -1,   182,   183,
     184,    -1,    -1,   187,    -1,    -1,    -1,   191,    -1,   193,
      -1,   195,    -1,   197,   198,   199,   200,   201,   202,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,    -1,    -1,    -1,   221,   222,   223,
     224,    -1,    -1,   227,   228,   229,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,   238,   239,    -1,    -1,    -1,   243,
      -1,   245,   246,    -1,   248,   249,    -1,    -1,    -1,   253,
      -1,    -1,   256,   257,   258,    -1,    -1,   261,    -1,    -1,
     264,   265,    -1,    -1,    -1,    -1,    -1,   271,   272,    -1,
     274,    -1,   276,    -1,   278,   279,    -1,    -1,   282,    -1,
      -1,    -1,    -1,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,    -1,   301,   302,   303,
      -1,   305,   306,   307,   308,    -1,   310,   311,    -1,    -1,
      -1,    -1,   316,   317,   318,   319,   320,   321,    -1,    -1,
     324,   325,    -1,   327,    -1,   329,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,   358,    -1,   360,   361,   362,    -1,
     364,   365,   366,   367,    -1,   369,   370,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,   396,   397,    -1,    -1,   400,   401,   402,    -1,
     404,    -1,   406,   407,   408,   409,   410,    -1,   412,   413,
     414,    -1,    -1,   417,    -1,    -1,    -1,   421,   422,   423,
     424,   425,    -1,    -1,   428,   429,   430,   431,   432,    -1,
     434,   435,    -1,   437,   438,   439,    -1,    -1,   442,    -1,
     444,    -1,   446,   447,    -1,   449,   450,    -1,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
      -1,   465,   466,    -1,    -1,    -1,   470,   471,   472,   473,
      -1,    -1,    -1,   477,    -1,    -1,    -1,   481,    -1,   483,
     484,   485,   486,    -1,   488,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,    -1,   500,   501,    -1,   503,
      -1,    -1,   506,    -1,    -1,   509,   510,   511,    -1,    -1,
     514,