
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 954 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXPORT_SYM = 436,
     EXTENDED_SYM = 437,
     EXTENT_SIZE_SYM = 438,
     EXTRACT_SYM = 439,
     FALSE_SYM = 440,
     FAST_SYM = 441,
     FAULTS_SYM = 442,
     FETCH_SYM = 443,
     FILE_SYM = 444,
     FIRST_SYM = 445,
     FIXED_SYM = 446,
     FLOAT_NUM = 447,
     FLOAT_SYM = 448,
     FLUSH_SYM = 449,
     FORCE_SYM = 450,
     FOREIGN = 451,
     FOR_SYM = 452,
     FOUND_SYM = 453,
     FROM = 454,
     FULL = 455,
     FULLTEXT_SYM = 456,
     FUNCTION_SYM = 457,
     GE = 458,
     GENERAL = 459,
     GENERATED_SYM = 460,
     GEOMETRYCOLLECTION = 461,
     GEOMETRY_SYM = 462,
     GET_FORMAT = 463,
     GET_SYM = 464,
     GLOBAL_SYM = 465,
     GRANT = 466,
     GRANTS = 467,
     GROUP_SYM = 468,
     GROUP_CONCAT_SYM = 469,
     GT_SYM = 470,
     HANDLER_SYM = 471,
     HARD_SYM = 472,
     HASH_SYM = 473,
     HAVING = 474,
     HELP_SYM = 475,
     HEX_NUM = 476,
     HEX_STRING = 477,
     HIGH_PRIORITY = 478,
     HOST_SYM = 479,
     HOSTS_SYM = 480,
     HOUR_MICROSECOND_SYM = 481,
     HOUR_MINUTE_SYM = 482,
     HOUR_SECOND_SYM = 483,
     HOUR_SYM = 484,
     ID_SYM = 485,
     IDENT = 486,
     IDENTIFIED_SYM = 487,
     IDENT_QUOTED = 488,
     IF = 489,
     IGNORE_SYM = 490,
     IGNORE_SERVER_IDS_SYM = 491,
     IMPORT = 492,
     INDEXES = 493,
     INDEX_SYM = 494,
     INDEX_STATS_SYM = 495,
     INFILE = 496,
     INITIAL_SIZE_SYM = 497,
     INNER_SYM = 498,
     INOUT_SYM = 499,
     INSENSITIVE_SYM = 500,
     INSERT = 501,
     INSERT_METHOD = 502,
     INSTALL_SYM = 503,
     INTERVAL_SYM = 504,
     INTO = 505,
     INT_SYM = 506,
     INVOKER_SYM = 507,
     IN_SYM = 508,
     IO_SYM = 509,
     IPC_SYM = 510,
     IS = 511,
     ISOLATION = 512,
     ISSUER_SYM = 513,
     ITERATE_SYM = 514,
     JOIN_SYM = 515,
     KEYS = 516,
     KEY_BLOCK_SIZE = 517,
     KEY_SYM = 518,
     KILL_SYM = 519,
     LANGUAGE_SYM = 520,
     LAST_SYM = 521,
     LAST_VALUE = 522,
     LE = 523,
     LEADING = 524,
     LEAVES = 525,
     LEAVE_SYM = 526,
     LEFT = 527,
     LESS_SYM = 528,
     LEVEL_SYM = 529,
     LEX_HOSTNAME = 530,
     LIKE = 531,
     LIMIT = 532,
     LINEAR_SYM = 533,
     LINES = 534,
     LINESTRING = 535,
     LIST_SYM = 536,
     LOAD = 537,
     LOCAL_SYM = 538,
     LOCATOR_SYM = 539,
     LOCKS_SYM = 540,
     LOCK_SYM = 541,
     LOGFILE_SYM = 542,
     LOGS_SYM = 543,
     LONGBLOB = 544,
     LONGTEXT = 545,
     LONG_NUM = 546,
     LONG_SYM = 547,
     LOOP_SYM = 548,
     LOW_PRIORITY = 549,
     LT = 550,
     MASTER_CONNECT_RETRY_SYM = 551,
     MASTER_GTID_POS_SYM = 552,
     MASTER_HOST_SYM = 553,
     MASTER_LOG_FILE_SYM = 554,
     MASTER_LOG_POS_SYM = 555,
     MASTER_PASSWORD_SYM = 556,
     MASTER_PORT_SYM = 557,
     MASTER_SERVER_ID_SYM = 558,
     MASTER_SSL_CAPATH_SYM = 559,
     MASTER_SSL_CA_SYM = 560,
     MASTER_SSL_CERT_SYM = 561,
     MASTER_SSL_CIPHER_SYM = 562,
     MASTER_SSL_CRL_SYM = 563,
     MASTER_SSL_CRLPATH_SYM = 564,
     MASTER_SSL_KEY_SYM = 565,
     MASTER_SSL_SYM = 566,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 567,
     MASTER_SYM = 568,
     MASTER_USER_SYM = 569,
     MASTER_USE_GTID_SYM = 570,
     MASTER_HEARTBEAT_PERIOD_SYM = 571,
     MATCH = 572,
     MAX_CONNECTIONS_PER_HOUR = 573,
     MAX_QUERIES_PER_HOUR = 574,
     MAX_ROWS = 575,
     MAX_SIZE_SYM = 576,
     MAX_SYM = 577,
     MAX_UPDATES_PER_HOUR = 578,
     MAX_USER_CONNECTIONS_SYM = 579,
     MAX_VALUE_SYM = 580,
     MEDIUMBLOB = 581,
     MEDIUMINT = 582,
     MEDIUMTEXT = 583,
     MEDIUM_SYM = 584,
     MEMORY_SYM = 585,
     MERGE_SYM = 586,
     MESSAGE_TEXT_SYM = 587,
     MICROSECOND_SYM = 588,
     MIGRATE_SYM = 589,
     MINUTE_MICROSECOND_SYM = 590,
     MINUTE_SECOND_SYM = 591,
     MINUTE_SYM = 592,
     MIN_ROWS = 593,
     MIN_SYM = 594,
     MODE_SYM = 595,
     MODIFIES_SYM = 596,
     MODIFY_SYM = 597,
     MOD_SYM = 598,
     MONTH_SYM = 599,
     MULTILINESTRING = 600,
     MULTIPOINT = 601,
     MULTIPOLYGON = 602,
     MUTEX_SYM = 603,
     MYSQL_ERRNO_SYM = 604,
     NAMES_SYM = 605,
     NAME_SYM = 606,
     NATIONAL_SYM = 607,
     NATURAL = 608,
     NCHAR_STRING = 609,
     NCHAR_SYM = 610,
     NDBCLUSTER_SYM = 611,
     NE = 612,
     NEG = 613,
     NEW_SYM = 614,
     NEXT_SYM = 615,
     NODEGROUP_SYM = 616,
     NONE_SYM = 617,
     NOT2_SYM = 618,
     NOT_SYM = 619,
     NOW_SYM = 620,
     NO_SYM = 621,
     NO_WAIT_SYM = 622,
     NO_WRITE_TO_BINLOG = 623,
     NULL_SYM = 624,
     NUM = 625,
     NUMBER_SYM = 626,
     NUMERIC_SYM = 627,
     NVARCHAR_SYM = 628,
     OFFSET_SYM = 629,
     OLD_PASSWORD = 630,
     ON = 631,
     ONE_SYM = 632,
     ONLY_SYM = 633,
     ONLINE_SYM = 634,
     OPEN_SYM = 635,
     OPTIMIZE = 636,
     OPTIONS_SYM = 637,
     OPTION = 638,
     OPTIONALLY = 639,
     OR2_SYM = 640,
     ORDER_SYM = 641,
     OR_OR_SYM = 642,
     OR_SYM = 643,
     OUTER = 644,
     OUTFILE = 645,
     OUT_SYM = 646,
     OWNER_SYM = 647,
     PACK_KEYS_SYM = 648,
     PAGE_SYM = 649,
     PAGE_CHECKSUM_SYM = 650,
     PARAM_MARKER = 651,
     PARSER_SYM = 652,
     PARSE_VCOL_EXPR_SYM = 653,
     PARTIAL = 654,
     PARTITION_SYM = 655,
     PARTITIONS_SYM = 656,
     PARTITIONING_SYM = 657,
     PASSWORD = 658,
     PERSISTENT_SYM = 659,
     PHASE_SYM = 660,
     PLUGINS_SYM = 661,
     PLUGIN_SYM = 662,
     POINT_SYM = 663,
     POLYGON = 664,
     PORT_SYM = 665,
     POSITION_SYM = 666,
     PRECISION = 667,
     PREPARE_SYM = 668,
     PRESERVE_SYM = 669,
     PREV_SYM = 670,
     PRIMARY_SYM = 671,
     PRIVILEGES = 672,
     PROCEDURE_SYM = 673,
     PROCESS = 674,
     PROCESSLIST_SYM = 675,
     PROFILE_SYM = 676,
     PROFILES_SYM = 677,
     PROXY_SYM = 678,
     PURGE = 679,
     QUARTER_SYM = 680,
     QUERY_SYM = 681,
     QUICK = 682,
     RANGE_SYM = 683,
     READS_SYM = 684,
     READ_ONLY_SYM = 685,
     READ_SYM = 686,
     READ_WRITE_SYM = 687,
     REAL = 688,
     REBUILD_SYM = 689,
     RECOVER_SYM = 690,
     REDOFILE_SYM = 691,
     REDO_BUFFER_SIZE_SYM = 692,
     REDUNDANT_SYM = 693,
     REFERENCES = 694,
     REGEXP = 695,
     RELAY = 696,
     RELAYLOG_SYM = 697,
     RELAY_LOG_FILE_SYM = 698,
     RELAY_LOG_POS_SYM = 699,
     RELAY_THREAD = 700,
     RELEASE_SYM = 701,
     RELOAD = 702,
     REMOVE_SYM = 703,
     RENAME = 704,
     REORGANIZE_SYM = 705,
     REPAIR = 706,
     REPEATABLE_SYM = 707,
     REPEAT_SYM = 708,
     REPLACE = 709,
     REPLICATION = 710,
     REQUIRE_SYM = 711,
     RESET_SYM = 712,
     RESIGNAL_SYM = 713,
     RESOURCES = 714,
     RESTORE_SYM = 715,
     RESTRICT = 716,
     RESUME_SYM = 717,
     RETURNED_SQLSTATE_SYM = 718,
     RETURNING_SYM = 719,
     RETURNS_SYM = 720,
     RETURN_SYM = 721,
     REVERSE_SYM = 722,
     REVOKE = 723,
     RIGHT = 724,
     ROLE_SYM = 725,
     ROLLBACK_SYM = 726,
     ROLLUP_SYM = 727,
     ROUTINE_SYM = 728,
     ROWS_SYM = 729,
     ROW_FORMAT_SYM = 730,
     ROW_SYM = 731,
     ROW_COUNT_SYM = 732,
     RTREE_SYM = 733,
     SAVEPOINT_SYM = 734,
     SCHEDULE_SYM = 735,
     SCHEMA_NAME_SYM = 736,
     SECOND_MICROSECOND_SYM = 737,
     SECOND_SYM = 738,
     SECURITY_SYM = 739,
     SELECT_SYM = 740,
     SENSITIVE_SYM = 741,
     SEPARATOR_SYM = 742,
     SERIALIZABLE_SYM = 743,
     SERIAL_SYM = 744,
     SESSION_SYM = 745,
     SERVER_SYM = 746,
     SERVER_OPTIONS = 747,
     SET = 748,
     SET_VAR = 749,
     SHARE_SYM = 750,
     SHIFT_LEFT = 751,
     SHIFT_RIGHT = 752,
     SHOW = 753,
     SHUTDOWN = 754,
     SIGNAL_SYM = 755,
     SIGNED_SYM = 756,
     SIMPLE_SYM = 757,
     SLAVE = 758,
     SLAVES = 759,
     SLAVE_POS_SYM = 760,
     SLOW = 761,
     SMALLINT = 762,
     SNAPSHOT_SYM = 763,
     SOCKET_SYM = 764,
     SOFT_SYM = 765,
     SONAME_SYM = 766,
     SOUNDS_SYM = 767,
     SOURCE_SYM = 768,
     SPATIAL_SYM = 769,
     SPECIFIC_SYM = 770,
     SQLEXCEPTION_SYM = 771,
     SQLSTATE_SYM = 772,
     SQLWARNING_SYM = 773,
     SQL_BIG_RESULT = 774,
     SQL_BUFFER_RESULT = 775,
     SQL_CACHE_SYM = 776,
     SQL_CALC_FOUND_ROWS = 777,
     SQL_NO_CACHE_SYM = 778,
     SQL_SMALL_RESULT = 779,
     SQL_SYM = 780,
     SQL_THREAD = 781,
     SSL_SYM = 782,
     STARTING = 783,
     STARTS_SYM = 784,
     START_SYM = 785,
     STATS_AUTO_RECALC_SYM = 786,
     STATS_PERSISTENT_SYM = 787,
     STATS_SAMPLE_PAGES_SYM = 788,
     STATUS_SYM = 789,
     STDDEV_SAMP_SYM = 790,
     STD_SYM = 791,
     STOP_SYM = 792,
     STORAGE_SYM = 793,
     STRAIGHT_JOIN = 794,
     STRING_SYM = 795,
     SUBCLASS_ORIGIN_SYM = 796,
     SUBDATE_SYM = 797,
     SUBJECT_SYM = 798,
     SUBPARTITIONS_SYM = 799,
     SUBPARTITION_SYM = 800,
     SUBSTRING = 801,
     SUM_SYM = 802,
     SUPER_SYM = 803,
     SUSPEND_SYM = 804,
     SWAPS_SYM = 805,
     SWITCHES_SYM = 806,
     SYSDATE = 807,
     TABLES = 808,
     TABLESPACE = 809,
     TABLE_REF_PRIORITY = 810,
     TABLE_STATS_SYM = 811,
     TABLE_SYM = 812,
     TABLE_CHECKSUM_SYM = 813,
     TABLE_NAME_SYM = 814,
     TEMPORARY = 815,
     TEMPTABLE_SYM = 816,
     TERMINATED = 817,
     TEXT_STRING = 818,
     TEXT_SYM = 819,
     THAN_SYM = 820,
     THEN_SYM = 821,
     TIMESTAMP = 822,
     TIMESTAMP_ADD = 823,
     TIMESTAMP_DIFF = 824,
     TIME_SYM = 825,
     TINYBLOB = 826,
     TINYINT = 827,
     TINYTEXT = 828,
     TO_SYM = 829,
     TRAILING = 830,
     TRANSACTION_SYM = 831,
     TRANSACTIONAL_SYM = 832,
     TRIGGERS_SYM = 833,
     TRIGGER_SYM = 834,
     TRIM = 835,
     TRUE_SYM = 836,
     TRUNCATE_SYM = 837,
     TYPES_SYM = 838,
     TYPE_SYM = 839,
     UDF_RETURNS_SYM = 840,
     ULONGLONG_NUM = 841,
     UNCOMMITTED_SYM = 842,
     UNDEFINED_SYM = 843,
     UNDERSCORE_CHARSET = 844,
     UNDOFILE_SYM = 845,
     UNDO_BUFFER_SIZE_SYM = 846,
     UNDO_SYM = 847,
     UNICODE_SYM = 848,
     UNINSTALL_SYM = 849,
     UNION_SYM = 850,
     UNIQUE_SYM = 851,
     UNKNOWN_SYM = 852,
     UNLOCK_SYM = 853,
     UNSIGNED = 854,
     UNTIL_SYM = 855,
     UPDATE_SYM = 856,
     UPGRADE_SYM = 857,
     USAGE = 858,
     USER = 859,
     USER_STATS_SYM = 860,
     USE_FRM = 861,
     USE_SYM = 862,
     USING = 863,
     UTC_DATE_SYM = 864,
     UTC_TIMESTAMP_SYM = 865,
     UTC_TIME_SYM = 866,
     VALUES = 867,
     VALUE_SYM = 868,
     VARBINARY = 869,
     VARCHAR = 870,
     VARIABLES = 871,
     VARIANCE_SYM = 872,
     VARYING = 873,
     VAR_SAMP_SYM = 874,
     VIA_SYM = 875,
     VIEW_SYM = 876,
     VIRTUAL_SYM = 877,
     WAIT_SYM = 878,
     WARNINGS = 879,
     WEEK_SYM = 880,
     WEIGHT_STRING_SYM = 881,
     WHEN_SYM = 882,
     WHERE = 883,
     WHILE_SYM = 884,
     WITH = 885,
     WITH_CUBE_SYM = 886,
     WITH_ROLLUP_SYM = 887,
     WORK_SYM = 888,
     WRAPPER_SYM = 889,
     WRITE_SYM = 890,
     X509_SYM = 891,
     XA_SYM = 892,
     XML_SYM = 893,
     XOR = 894,
     YEAR_MONTH_SYM = 895,
     YEAR_SYM = 896,
     ZEROFILL = 897,
     IMPOSSIBLE_ACTION = 898
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXPORT_SYM 436
#define EXTENDED_SYM 437
#define EXTENT_SIZE_SYM 438
#define EXTRACT_SYM 439
#define FALSE_SYM 440
#define FAST_SYM 441
#define FAULTS_SYM 442
#define FETCH_SYM 443
#define FILE_SYM 444
#define FIRST_SYM 445
#define FIXED_SYM 446
#define FLOAT_NUM 447
#define FLOAT_SYM 448
#define FLUSH_SYM 449
#define FORCE_SYM 450
#define FOREIGN 451
#define FOR_SYM 452
#define FOUND_SYM 453
#define FROM 454
#define FULL 455
#define FULLTEXT_SYM 456
#define FUNCTION_SYM 457
#define GE 458
#define GENERAL 459
#define GENERATED_SYM 460
#define GEOMETRYCOLLECTION 461
#define GEOMETRY_SYM 462
#define GET_FORMAT 463
#define GET_SYM 464
#define GLOBAL_SYM 465
#define GRANT 466
#define GRANTS 467
#define GROUP_SYM 468
#define GROUP_CONCAT_SYM 469
#define GT_SYM 470
#define HANDLER_SYM 471
#define HARD_SYM 472
#define HASH_SYM 473
#define HAVING 474
#define HELP_SYM 475
#define HEX_NUM 476
#define HEX_STRING 477
#define HIGH_PRIORITY 478
#define HOST_SYM 479
#define HOSTS_SYM 480
#define HOUR_MICROSECOND_SYM 481
#define HOUR_MINUTE_SYM 482
#define HOUR_SECOND_SYM 483
#define HOUR_SYM 484
#define ID_SYM 485
#define IDENT 486
#define IDENTIFIED_SYM 487
#define IDENT_QUOTED 488
#define IF 489
#define IGNORE_SYM 490
#define IGNORE_SERVER_IDS_SYM 491
#define IMPORT 492
#define INDEXES 493
#define INDEX_SYM 494
#define INDEX_STATS_SYM 495
#define INFILE 496
#define INITIAL_SIZE_SYM 497
#define INNER_SYM 498
#define INOUT_SYM 499
#define INSENSITIVE_SYM 500
#define INSERT 501
#define INSERT_METHOD 502
#define INSTALL_SYM 503
#define INTERVAL_SYM 504
#define INTO 505
#define INT_SYM 506
#define INVOKER_SYM 507
#define IN_SYM 508
#define IO_SYM 509
#define IPC_SYM 510
#define IS 511
#define ISOLATION 512
#define ISSUER_SYM 513
#define ITERATE_SYM 514
#define JOIN_SYM 515
#define KEYS 516
#define KEY_BLOCK_SIZE 517
#define KEY_SYM 518
#define KILL_SYM 519
#define LANGUAGE_SYM 520
#define LAST_SYM 521
#define LAST_VALUE 522
#define LE 523
#define LEADING 524
#define LEAVES 525
#define LEAVE_SYM 526
#define LEFT 527
#define LESS_SYM 528
#define LEVEL_SYM 529
#define LEX_HOSTNAME 530
#define LIKE 531
#define LIMIT 532
#define LINEAR_SYM 533
#define LINES 534
#define LINESTRING 535
#define LIST_SYM 536
#define LOAD 537
#define LOCAL_SYM 538
#define LOCATOR_SYM 539
#define LOCKS_SYM 540
#define LOCK_SYM 541
#define LOGFILE_SYM 542
#define LOGS_SYM 543
#define LONGBLOB 544
#define LONGTEXT 545
#define LONG_NUM 546
#define LONG_SYM 547
#define LOOP_SYM 548
#define LOW_PRIORITY 549
#define LT 550
#define MASTER_CONNECT_RETRY_SYM 551
#define MASTER_GTID_POS_SYM 552
#define MASTER_HOST_SYM 553
#define MASTER_LOG_FILE_SYM 554
#define MASTER_LOG_POS_SYM 555
#define MASTER_PASSWORD_SYM 556
#define MASTER_PORT_SYM 557
#define MASTER_SERVER_ID_SYM 558
#define MASTER_SSL_CAPATH_SYM 559
#define MASTER_SSL_CA_SYM 560
#define MASTER_SSL_CERT_SYM 561
#define MASTER_SSL_CIPHER_SYM 562
#define MASTER_SSL_CRL_SYM 563
#define MASTER_SSL_CRLPATH_SYM 564
#define MASTER_SSL_KEY_SYM 565
#define MASTER_SSL_SYM 566
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 567
#define MASTER_SYM 568
#define MASTER_USER_SYM 569
#define MASTER_USE_GTID_SYM 570
#define MASTER_HEARTBEAT_PERIOD_SYM 571
#define MATCH 572
#define MAX_CONNECTIONS_PER_HOUR 573
#define MAX_QUERIES_PER_HOUR 574
#define MAX_ROWS 575
#define MAX_SIZE_SYM 576
#define MAX_SYM 577
#define MAX_UPDATES_PER_HOUR 578
#define MAX_USER_CONNECTIONS_SYM 579
#define MAX_VALUE_SYM 580
#define MEDIUMBLOB 581
#define MEDIUMINT 582
#define MEDIUMTEXT 583
#define MEDIUM_SYM 584
#define MEMORY_SYM 585
#define MERGE_SYM 586
#define MESSAGE_TEXT_SYM 587
#define MICROSECOND_SYM 588
#define MIGRATE_SYM 589
#define MINUTE_MICROSECOND_SYM 590
#define MINUTE_SECOND_SYM 591
#define MINUTE_SYM 592
#define MIN_ROWS 593
#define MIN_SYM 594
#define MODE_SYM 595
#define MODIFIES_SYM 596
#define MODIFY_SYM 597
#define MOD_SYM 598
#define MONTH_SYM 599
#define MULTILINESTRING 600
#define MULTIPOINT 601
#define MULTIPOLYGON 602
#define MUTEX_SYM 603
#define MYSQL_ERRNO_SYM 604
#define NAMES_SYM 605
#define NAME_SYM 606
#define NATIONAL_SYM 607
#define NATURAL 608
#define NCHAR_STRING 609
#define NCHAR_SYM 610
#define NDBCLUSTER_SYM 611
#define NE 612
#define NEG 613
#define NEW_SYM 614
#define NEXT_SYM 615
#define NODEGROUP_SYM 616
#define NONE_SYM 617
#define NOT2_SYM 618
#define NOT_SYM 619
#define NOW_SYM 620
#define NO_SYM 621
#define NO_WAIT_SYM 622
#define NO_WRITE_TO_BINLOG 623
#define NULL_SYM 624
#define NUM 625
#define NUMBER_SYM 626
#define NUMERIC_SYM 627
#define NVARCHAR_SYM 628
#define OFFSET_SYM 629
#define OLD_PASSWORD 630
#define ON 631
#define ONE_SYM 632
#define ONLY_SYM 633
#define ONLINE_SYM 634
#define OPEN_SYM 635
#define OPTIMIZE 636
#define OPTIONS_SYM 637
#define OPTION 638
#define OPTIONALLY 639
#define OR2_SYM 640
#define ORDER_SYM 641
#define OR_OR_SYM 642
#define OR_SYM 643
#define OUTER 644
#define OUTFILE 645
#define OUT_SYM 646
#define OWNER_SYM 647
#define PACK_KEYS_SYM 648
#define PAGE_SYM 649
#define PAGE_CHECKSUM_SYM 650
#define PARAM_MARKER 651
#define PARSER_SYM 652
#define PARSE_VCOL_EXPR_SYM 653
#define PARTIAL 654
#define PARTITION_SYM 655
#define PARTITIONS_SYM 656
#define PARTITIONING_SYM 657
#define PASSWORD 658
#define PERSISTENT_SYM 659
#define PHASE_SYM 660
#define PLUGINS_SYM 661
#define PLUGIN_SYM 662
#define POINT_SYM 663
#define POLYGON 664
#define PORT_SYM 665
#define POSITION_SYM 666
#define PRECISION 667
#define PREPARE_SYM 668
#define PRESERVE_SYM 669
#define PREV_SYM 670
#define PRIMARY_SYM 671
#define PRIVILEGES 672
#define PROCEDURE_SYM 673
#define PROCESS 674
#define PROCESSLIST_SYM 675
#define PROFILE_SYM 676
#define PROFILES_SYM 677
#define PROXY_SYM 678
#define PURGE 679
#define QUARTER_SYM 680
#define QUERY_SYM 681
#define QUICK 682
#define RANGE_SYM 683
#define READS_SYM 684
#define READ_ONLY_SYM 685
#define READ_SYM 686
#define READ_WRITE_SYM 687
#define REAL 688
#define REBUILD_SYM 689
#define RECOVER_SYM 690
#define REDOFILE_SYM 691
#define REDO_BUFFER_SIZE_SYM 692
#define REDUNDANT_SYM 693
#define REFERENCES 694
#define REGEXP 695
#define RELAY 696
#define RELAYLOG_SYM 697
#define RELAY_LOG_FILE_SYM 698
#define RELAY_LOG_POS_SYM 699
#define RELAY_THREAD 700
#define RELEASE_SYM 701
#define RELOAD 702
#define REMOVE_SYM 703
#define RENAME 704
#define REORGANIZE_SYM 705
#define REPAIR 706
#define REPEATABLE_SYM 707
#define REPEAT_SYM 708
#define REPLACE 709
#define REPLICATION 710
#define REQUIRE_SYM 711
#define RESET_SYM 712
#define RESIGNAL_SYM 713
#define RESOURCES 714
#define RESTORE_SYM 715
#define RESTRICT 716
#define RESUME_SYM 717
#define RETURNED_SQLSTATE_SYM 718
#define RETURNING_SYM 719
#define RETURNS_SYM 720
#define RETURN_SYM 721
#define REVERSE_SYM 722
#define REVOKE 723
#define RIGHT 724
#define ROLE_SYM 725
#define ROLLBACK_SYM 726
#define ROLLUP_SYM 727
#define ROUTINE_SYM 728
#define ROWS_SYM 729
#define ROW_FORMAT_SYM 730
#define ROW_SYM 731
#define ROW_COUNT_SYM 732
#define RTREE_SYM 733
#define SAVEPOINT_SYM 734
#define SCHEDULE_SYM 735
#define SCHEMA_NAME_SYM 736
#define SECOND_MICROSECOND_SYM 737
#define SECOND_SYM 738
#define SECURITY_SYM 739
#define SELECT_SYM 740
#define SENSITIVE_SYM 741
#define SEPARATOR_SYM 742
#define SERIALIZABLE_SYM 743
#define SERIAL_SYM 744
#define SESSION_SYM 745
#define SERVER_SYM 746
#define SERVER_OPTIONS 747
#define SET 748
#define SET_VAR 749
#define SHARE_SYM 750
#define SHIFT_LEFT 751
#define SHIFT_RIGHT 752
#define SHOW 753
#define SHUTDOWN 754
#define SIGNAL_SYM 755
#define SIGNED_SYM 756
#define SIMPLE_SYM 757
#define SLAVE 758
#define SLAVES 759
#define SLAVE_POS_SYM 760
#define SLOW 761
#define SMALLINT 762
#define SNAPSHOT_SYM 763
#define SOCKET_SYM 764
#define SOFT_SYM 765
#define SONAME_SYM 766
#define SOUNDS_SYM 767
#define SOURCE_SYM 768
#define SPATIAL_SYM 769
#define SPECIFIC_SYM 770
#define SQLEXCEPTION_SYM 771
#define SQLSTATE_SYM 772
#define SQLWARNING_SYM 773
#define SQL_BIG_RESULT 774
#define SQL_BUFFER_RESULT 775
#define SQL_CACHE_SYM 776
#define SQL_CALC_FOUND_ROWS 777
#define SQL_NO_CACHE_SYM 778
#define SQL_SMALL_RESULT 779
#define SQL_SYM 780
#define SQL_THREAD 781
#define SSL_SYM 782
#define STARTING 783
#define STARTS_SYM 784
#define START_SYM 785
#define STATS_AUTO_RECALC_SYM 786
#define STATS_PERSISTENT_SYM 787
#define STATS_SAMPLE_PAGES_SYM 788
#define STATUS_SYM 789
#define STDDEV_SAMP_SYM 790
#define STD_SYM 791
#define STOP_SYM 792
#define STORAGE_SYM 793
#define STRAIGHT_JOIN 794
#define STRING_SYM 795
#define SUBCLASS_ORIGIN_SYM 796
#define SUBDATE_SYM 797
#define SUBJECT_SYM 798
#define SUBPARTITIONS_SYM 799
#define SUBPARTITION_SYM 800
#define SUBSTRING 801
#define SUM_SYM 802
#define SUPER_SYM 803
#define SUSPEND_SYM 804
#define SWAPS_SYM 805
#define SWITCHES_SYM 806
#define SYSDATE 807
#define TABLES 808
#define TABLESPACE 809
#define TABLE_REF_PRIORITY 810
#define TABLE_STATS_SYM 811
#define TABLE_SYM 812
#define TABLE_CHECKSUM_SYM 813
#define TABLE_NAME_SYM 814
#define TEMPORARY 815
#define TEMPTABLE_SYM 816
#define TERMINATED 817
#define TEXT_STRING 818
#define TEXT_SYM 819
#define THAN_SYM 820
#define THEN_SYM 821
#define TIMESTAMP 822
#define TIMESTAMP_ADD 823
#define TIMESTAMP_DIFF 824
#define TIME_SYM 825
#define TINYBLOB 826
#define TINYINT 827
#define TINYTEXT 828
#define TO_SYM 829
#define TRAILING 830
#define TRANSACTION_SYM 831
#define TRANSACTIONAL_SYM 832
#define TRIGGERS_SYM 833
#define TRIGGER_SYM 834
#define TRIM 835
#define TRUE_SYM 836
#define TRUNCATE_SYM 837
#define TYPES_SYM 838
#define TYPE_SYM 839
#define UDF_RETURNS_SYM 840
#define ULONGLONG_NUM 841
#define UNCOMMITTED_SYM 842
#define UNDEFINED_SYM 843
#define UNDERSCORE_CHARSET 844
#define UNDOFILE_SYM 845
#define UNDO_BUFFER_SIZE_SYM 846
#define UNDO_SYM 847
#define UNICODE_SYM 848
#define UNINSTALL_SYM 849
#define UNION_SYM 850
#define UNIQUE_SYM 851
#define UNKNOWN_SYM 852
#define UNLOCK_SYM 853
#define UNSIGNED 854
#define UNTIL_SYM 855
#define UPDATE_SYM 856
#define UPGRADE_SYM 857
#define USAGE 858
#define USER 859
#define USER_STATS_SYM 860
#define USE_FRM 861
#define USE_SYM 862
#define USING 863
#define UTC_DATE_SYM 864
#define UTC_TIMESTAMP_SYM 865
#define UTC_TIME_SYM 866
#define VALUES 867
#define VALUE_SYM 868
#define VARBINARY 869
#define VARCHAR 870
#define VARIABLES 871
#define VARIANCE_SYM 872
#define VARYING 873
#define VAR_SAMP_SYM 874
#define VIA_SYM 875
#define VIEW_SYM 876
#define VIRTUAL_SYM 877
#define WAIT_SYM 878
#define WARNINGS 879
#define WEEK_SYM 880
#define WEIGHT_STRING_SYM 881
#define WHEN_SYM 882
#define WHERE 883
#define WHILE_SYM 884
#define WITH 885
#define WITH_CUBE_SYM 886
#define WITH_ROLLUP_SYM 887
#define WORK_SYM 888
#define WRAPPER_SYM 889
#define WRITE_SYM 890
#define X509_SYM 891
#define XA_SYM 892
#define XML_SYM 893
#define XOR 894
#define YEAR_MONTH_SYM 895
#define YEAR_SYM 896
#define ZEROFILL 897
#define IMPOSSIBLE_ACTION 898




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 896 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2338 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 956 "/home/buildbot/bzr/build/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2355 "/home/buildbot/bzr/build/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  622
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65820

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  663
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  996
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2819
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4787

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   898

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   656,     2,     2,     2,   650,   645,     2,
     653,   654,   648,   647,   655,   646,   661,   649,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   662,   659,
       2,     2,     2,     2,   660,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   651,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,   644,   658,   652,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1635,  1639,  1640,  1642,
    1644,  1647,  1649,  1652,  1656,  1660,  1664,  1668,  1672,  1676,
    1680,  1684,  1688,  1692,  1696,  1700,  1704,  1708,  1712,  1716,
    1720,  1724,  1728,  1732,  1736,  1737,  1744,  1746,  1748,  1752,
    1757,  1762,  1765,  1768,  1771,  1775,  1779,  1783,  1787,  1791,
    1795,  1799,  1804,  1809,  1811,  1813,  1815,  1817,  1819,  1821,
    1823,  1825,  1827,  1829,  1831,  1833,  1835,  1838,  1840,  1842,
    1844,  1846,  1848,  1850,  1854,  1856,  1858,  1861,  1864,  1865,
    1874,  1875,  1885,  1886,  1896,  1897,  1907,  1916,  1919,  1920,
    1922,  1927,  1928,  1930,  1933,  1934,  1938,  1941,  1950,  1951,
    1954,  1955,  1957,  1959,  1960,  1962,  1965,  1967,  1969,  1972,
    1975,  1980,  1984,  1988,  1992,  1996,  1998,  2001,  2003,  2005,
    2009,  2012,  2016,  2019,  2022,  2024,  2028,  2032,  2035,  2039,
    2041,  2044,  2047,  2050,  2052,  2055,  2057,  2059,  2061,  2064,
    2068,  2071,  2075,  2078,  2081,  2085,  2089,  2093,  2094,  2101,
    2102,  2109,  2112,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2128,  2130,  2132,  2134,  2137,  2140,  2142,  2145,  2147,  2150,
    2154,  2157,  2159,  2161,  2163,  2165,  2167,  2169,  2171,  2174,
    2175,  2177,  2179,  2185,  2186,  2188,  2191,  2193,  2195,  2197,
    2199,  2203,  2207,  2211,  2215,  2216,  2218,  2219,  2221,  2222,
    2224,  2227,  2229,  2231,  2234,  2237,  2242,  2244,  2248,  2251,
    2253,  2256,  2259,  2262,  2266,  2270,  2274,  2278,  2281,  2284,
    2286,  2289,  2291,  2293,  2295,  2297,  2299,  2300,  2303,  2305,
    2307,  2309,  2311,  2313,  2314,  2317,  2319,  2321,  2322,  2324,
    2326,  2329,  2332,  2334,  2337,  2340,  2341,  2343,  2345,  2347,
    2351,  2353,  2357,  2358,  2360,  2361,  2366,  2368,  2370,  2372,
    2373,  2375,  2378,  2380,  2382,  2385,  2387,  2391,  2395,  2397,
    2399,  2400,  2403,  2404,  2406,  2412,  2413,  2417,  2421,  2423,
    2424,  2427,  2430,  2433,  2434,  2438,  2442,  2449,  2456,  2458,
    2460,  2463,  2466,  2469,  2471,  2474,  2477,  2479,  2481,  2482,
    2484,  2486,  2488,  2490,  2491,  2493,  2495,  2497,  2498,  2500,
    2503,  2504,  2506,  2507,  2509,  2510,  2512,  2514,  2517,  2519,
    2522,  2524,  2527,  2530,  2533,  2537,  2540,  2544,  2548,  2552,
    2556,  2558,  2560,  2562,  2564,  2568,  2570,  2572,  2574,  2579,
    2582,  2584,  2589,  2590,  2592,  2595,  2596,  2599,  2601,  2605,
    2606,  2607,  2615,  2616,  2622,  2630,  2631,  2637,  2638,  2644,
    2645,  2651,  2652,  2657,  2658,  2669,  2673,  2678,  2682,  2686,
    2694,  2695,  2699,  2701,  2706,  2707,  2711,  2712,  2715,  2716,
    2718,  2719,  2722,  2725,  2728,  2731,  2733,  2735,  2737,  2742,
    2747,  2748,  2755,  2760,  2761,  2767,  2768,  2775,  2780,  2784,
    2786,  2794,  2797,  2799,  2801,  2802,  2809,  2810,  2814,  2817,
    2818,  2824,  2825,  2826,  2833,  2835,  2839,  2841,  2843,  2847,
    2851,  2855,  2858,  2863,  2864,  2872,  2873,  2874,  2883,  2889,
    2895,  2899,  2904,  2907,  2910,  2917,  2923,  2927,  2933,  2935,
    2937,  2939,  2941,  2943,  2944,  2946,  2948,  2951,  2954,  2958,
    2962,  2966,  2970,  2971,  2973,  2974,  2976,  2977,  2980,  2981,
    2983,  2986,  2988,  2990,  2992,  2993,  2995,  2997,  2998,  3001,
    3003,  3004,  3006,  3008,  3010,  3011,  3018,  3019,  3025,  3030,
    3035,  3039,  3040,  3042,  3044,  3048,  3052,  3055,  3058,  3059,
    3062,  3064,  3068,  3069,  3071,  3073,  3074,  3077,  3082,  3084,
    3088,  3089,  3095,  3096,  3098,  3100,  3101,  3108,  3109,  3111,
    3113,  3116,  3118,  3120,  3122,  3123,  3129,  3131,  3135,  3138,
    3139,  3143,  3145,  3150,  3152,  3153,  3158,  3160,  3161,  3166,
    3167,  3169,  3173,  3174,  3176,  3180,  3182,  3184,  3187,  3188,
    3194,  3195,  3197,  3199,  3202,  3204,  3206,  3208,  3210,  3212,
    3215,  3216,  3222,  3223,  3225,  3227,  3228,  3233,  3238,  3242,
    3248,  3250,  3254,  3258,  3259,  3266,  3268,  3270,  3272,  3276,
    3279,  3283,  3285,  3287,  3288,  3295,  3297,  3299,  3301,  3305,
    3309,  3314,  3315,  3322,  3323,  3326,  3327,  3332,  3333,  3336,
    3338,  3341,  3346,  3349,  3353,  3356,  3360,  3361,  3365,  3366,
    3367,  3374,  3377,  3379,  3381,  3384,  3387,  3396,  3401,  3402,
    3404,  3407,  3409,  3411,  3413,  3415,  3416,  3419,  3424,  3428,
    3430,  3432,  3436,  3441,  3442,  3443,  3444,  3447,  3450,  3452,
    3454,  3455,  3458,  3462,  3463,  3466,  3470,  3471,  3474,  3478,
    3482,  3486,  3489,  3493,  3498,  3502,  3507,  3511,  3516,  3518,
    3522,  3527,  3531,  3535,  3542,  3544,  3550,  3557,  3563,  3571,
    3578,  3587,  3593,  3600,  3605,  3610,  3616,  3620,  3625,  3627,
    3631,  3635,  3639,  3643,  3647,  3651,  3657,  3663,  3667,  3671,
    3675,  3679,  3683,  3687,  3689,  3691,  3693,  3695,  3697,  3699,
    3701,  3703,  3705,  3707,  3709,  3711,  3713,  3715,  3717,  3719,
    3721,  3722,  3725,  3727,  3730,  3732,  3734,  3736,  3739,  3742,
    3744,  3746,  3749,  3752,  3757,  3759,  3763,  3765,  3767,  3769,
    3771,  3773,  3777,  3779,  3781,  3783,  3785,  3789,  3792,  3795,
    3798,  3801,  3805,  3809,  3815,  3822,  3827,  3832,  3840,  3843,
    3850,  3856,  3863,  3870,  3875,  3880,  3886,  3891,  3898,  3901,
    3904,  3909,  3914,  3919,  3930,  3937,  3946,  3953,  3958,  3963,
    3970,  3975,  3980,  3985,  3992,  3997,  4005,  4013,  4021,  4028,
    4035,  4042,  4049,  4053,  4058,  4065,  4074,  4077,  4080,  4089,
    4098,  4105,  4112,  4115,  4122,  4129,  4138,  4147,  4154,  4163,
    4170,  4173,  4182,  4191,  4194,  4197,  4200,  4207,  4214,  4219,
    4224,  4233,  4238,  4243,  4248,  4253,  4257,  4266,  4271,  4276,
    4283,  4288,  4293,  4298,  4305,  4314,  4319,  4323,  4330,  4335,
    4342,  4348,  4357,  4365,  4376,  4378,  4385,  4390,  4395,  4400,
    4405,  4410,  4417,  4422,  4423,  4429,  4436,  4439,  4443,  4444,
    4449,  4450,  4454,  4455,  4457,  4459,  4463,  4468,  4473,  4479,
    4484,  4489,  4494,  4500,  4505,  4506,  4507,  4515,  4520,  4526,
    4531,  4537,  4542,  4547,  4552,  4557,  4562,  4568,  4569,  4578,
    4579,  4583,  4587,  4589,  4594,  4595,  4597,  4598,  4601,  4602,
    4603,  4608,  4613,  4616,  4617,  4621,  4624,  4628,  4631,  4633,
    4635,  4638,  4640,  4643,  4645,  4648,  4651,  4654,  4655,  4659,
    4660,  4662,  4664,  4668,  4670,  4674,  4676,  4680,  4681,  4683,
    4684,  4687,  4692,  4698,  4700,  4702,  4704,  4706,  4711,  4713,
    4717,  4721,  4722,  4729,  4730,  4739,  4744,  4745,  4754,  4755,
    4766,  4773,  4774,  4783,  4784,  4795,  4802,  4804,  4807,  4809,
    4811,  4814,  4815,  4817,  4823,  4824,  4830,  4834,  4840,  4843,
    4844,  4845,  4853,  4855,  4856,  4857,  4864,  4865,  4869,  4870,
    4871,  4877,  4878,  4880,  4881,  4883,  4884,  4887,  4891,  4895,
    4897,  4899,  4900,  4908,  4909,  4917,  4919,  4922,  4923,  4924,
    4927,  4928,  4931,  4932,  4934,  4936,  4938,  4940,  4944,  4946,
    4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,  4968,
    4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,
    4990,  4992,  4994,  4996,  4998,  5000,  5001,  5003,  5005,  5006,
    5009,  5010,  5012,  5013,  5014,  5018,  5019,  5020,  5024,  5027,
    5028,  5029,  5034,  5039,  5042,  5043,  5045,  5047,  5051,  5055,
    5057,  5060,  5061,  5063,  5064,  5069,  5074,  5077,  5078,  5080,
    5082,  5083,  5085,  5086,  5088,  5091,  5097,  5102,  5104,  5108,
    5112,  5114,  5116,  5118,  5120,  5122,  5124,  5125,  5128,  5132,
    5137,  5139,  5142,  5145,  5147,  5149,  5151,  5153,  5155,  5157,
    5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,
    5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,
    5198,  5199,  5206,  5207,  5209,  5213,  5215,  5219,  5220,  5223,
    5227,  5229,  5232,  5234,  5235,  5239,  5240,  5241,  5249,  5252,
    5254,  5255,  5259,  5260,  5268,  5269,  5277,  5282,  5289,  5294,
    5299,  5304,  5309,  5310,  5317,  5322,  5327,  5333,  5340,  5345,
    5347,  5351,  5353,  5356,  5358,  5362,  5364,  5365,  5368,  5369,
    5371,  5372,  5373,  5382,  5383,  5384,  5391,  5392,  5394,  5396,
    5398,  5400,  5402,  5405,  5407,  5409,  5411,  5415,  5420,  5421,
    5425,  5429,  5431,  5434,  5437,  5438,  5442,  5443,  5449,  5453,
    5455,  5459,  5461,  5465,  5467,  5469,  5470,  5472,  5473,  5478,
    5479,  5481,  5485,  5487,  5489,  5491,  5492,  5493,  5500,  5501,
    5502,  5514,  5518,  5520,  5524,  5528,  5530,  5534,  5535,  5537,
    5538,  5543,  5544,  5545,  5555,  5556,  5562,  5563,  5570,  5571,
    5574,  5576,  5580,  5583,  5588,  5589,  5592,  5593,  5596,  5598,
    5600,  5602,  5603,  5608,  5609,  5611,  5612,  5614,  5616,  5620,
    5622,  5624,  5627,  5630,  5633,  5635,  5637,  5639,  5641,  5642,
    5646,  5647,  5651,  5654,  5659,  5664,  5668,  5673,  5678,  5680,
    5684,  5688,  5692,  5696,  5703,  5706,  5709,  5710,  5717,  5718,
    5726,  5732,  5735,  5737,  5739,  5741,  5747,  5753,  5756,  5759,
    5761,  5766,  5770,  5773,  5777,  5780,  5783,  5785,  5789,  5794,
    5798,  5802,  5805,  5809,  5812,  5816,  5818,  5820,  5822,  5824,
    5828,  5832,  5836,  5840,  5844,  5848,  5852,  5856,  5860,  5862,
    5864,  5866,  5868,  5870,  5871,  5873,  5874,  5877,  5878,  5880,
    5882,  5884,  5885,  5888,  5889,  5892,  5893,  5896,  5899,  5900,
    5905,  5906,  5911,  5913,  5915,  5917,  5919,  5921,  5923,  5925,
    5926,  5928,  5930,  5931,  5933,  5935,  5936,  5941,  5942,  5947,
    5949,  5950,  5952,  5957,  5958,  5962,  5966,  5968,  5971,  5974,
    5977,  5980,  5983,  5987,  5990,  5992,  5994,  5996,  5998,  6001,
    6003,  6005,  6007,  6009,  6011,  6013,  6015,  6016,  6018,  6019,
    6023,  6024,  6028,  6032,  6034,  6035,  6040,  6042,  6045,  6046,
    6048,  6049,  6053,  6057,  6060,  6063,  6064,  6070,  6071,  6073,
    6075,  6076,  6078,  6080,  6083,  6085,  6088,  6090,  6093,  6094,
    6095,  6096,  6097,  6120,  6122,  6124,  6125,  6127,  6128,  6130,
    6132,  6133,  6135,  6137,  6138,  6141,  6144,  6146,  6150,  6155,
    6159,  6163,  6164,  6167,  6170,  6172,  6176,  6180,  6181,  6186,
    6187,  6191,  6193,  6195,  6196,  6200,  6203,  6207,  6209,  6211,
    6214,  6215,  6218,  6222,  6224,  6230,  6232,  6234,  6237,  6240,
    6242,  6244,  6246,  6248,  6250,  6252,  6254,  6257,  6260,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6281,  6283,
    6285,  6287,  6289,  6291,  6294,  6297,  6300,  6302,  6304,  6308,
    6314,  6316,  6318,  6320,  6322,  6324,  6328,  6333,  6339,  6341,
    6347,  6351,  6354,  6356,  6360,  6363,  6366,  6371,  6373,  6375,
    6377,  6379,  6381,  6383,  6385,  6387,  6389,  6391,  6393,  6395,
    6397,  6399,  6403,  6406,  6408,  6410,  6412,  6414,  6416,  6418,
    6420,  6422,  6424,  6426,  6428,  6430,  6432,  6434,  6436,  6438,
    6440,  6442,  6444,  6446,  6448,  6450,  6452,  6454,  6456,  6458,
    6460,  6462,  6464,  6466,  6468,  6470,  6472,  6474,  6476,  6478,
    6480,  6482,  6484,  6486,  6488,  6490,  6492,  6494,  6496,  6498,
    6500,  6502,  6504,  6506,  6508,  6510,  6512,  6514,  6516,  6518,
    6520,  6522,  6524,  6526,  6528,  6530,  6532,  6534,  6536,  6538,
    6540,  6542,  6544,  6546,  6548,  6550,  6552,  6554,  6556,  6558,
    6560,  6562,  6564,  6566,  6568,  6570,  6572,  6574,  6576,  6578,
    6580,  6582,  6584,  6586,  6588,  6590,  6592,  6594,  6596,  6598,
    6600,  6602,  6604,  6606,  6608,  6610,  6612,  6614,  6616,  6618,
    6620,  6622,  6624,  6626,  6628,  6630,  6632,  6634,  6636,  6638,
    6640,  6642,  6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,
    6660,  6662,  6664,  6666,  6668,  6670,  6672,  6674,  6676,  6678,
    6680,  6682,  6684,  6686,  6688,  6690,  6692,  6694,  6696,  6698,
    6700,  6702,  6704,  6706,  6708,  6710,  6712,  6714,  6716,  6718,
    6720,  6722,  6724,  6726,  6728,  6730,  6732,  6734,  6736,  6738,
    6740,  6742,  6744,  6746,  6748,  6750,  6752,  6754,  6756,  6758,
    6760,  6762,  6764,  6766,  6768,  6770,  6772,  6774,  6776,  6778,
    6780,  6782,  6784,  6786,  6788,  6790,  6792,  6794,  6796,  6798,
    6800,  6802,  6804,  6806,  6808,  6810,  6812,  6814,  6816,  6818,
    6820,  6822,  6824,  6826,  6828,  6830,  6832,  6834,  6836,  6838,
    6840,  6842,  6844,  6846,  6848,  6850,  6852,  6854,  6856,  6858,
    6860,  6862,  6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,
    6880,  6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,
    6900,  6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,
    6920,  6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,
    6940,  6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,  6958,
    6960,  6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,  6978,
    6980,  6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,  6998,
    7000,  7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,  7018,
    7020,  7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,  7038,
    7040,  7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,
    7060,  7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,
    7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,
    7100,  7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,
    7120,  7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,
    7140,  7142,  7144,  7146,  7148,  7150,  7152,  7153,  7157,  7158,
    7162,  7163,  7167,  7168,  7172,  7173,  7177,  7180,  7181,  7184,
    7185,  7188,  7189,  7194,  7195,  7199,  7201,  7203,  7205,  7207,
    7208,  7210,  7212,  7214,  7215,  7218,  7221,  7224,  7228,  7232,
    7237,  7244,  7247,  7251,  7255,  7258,  7262,  7268,  7270,  7274,
    7278,  7280,  7282,  7286,  7290,  7292,  7296,  7299,  7302,  7305,
    7308,  7311,  7313,  7315,  7320,  7325,  7327,  7329,  7331,  7333,
    7335,  7336,  7341,  7343,  7345,  7347,  7351,  7355,  7357,  7359,
    7362,  7365,  7368,  7369,  7373,  7378,  7382,  7383,  7391,  7393,
    7396,  7398,  7400,  7402,  7404,  7406,  7408,  7409,  7415,  7417,
    7419,  7421,  7423,  7425,  7429,  7436,  7443,  7450,  7458,  7464,
    7468,  7473,  7475,  7479,  7488,  7497,  7506,  7513,  7518,  7519,
    7523,  7524,  7528,  7530,  7534,  7537,  7539,  7541,  7542,  7544,
    7546,  7549,  7550,  7552,  7554,  7558,  7559,  7563,  7564,  7568,
    7569,  7573,  7574,  7578,  7580,  7582,  7584,  7586,  7588,  7590,
    7592,  7594,  7596,  7598,  7600,  7603,  7606,  7608,  7612,  7615,
    7618,  7621,  7624,  7627,  7630,  7633,  7636,  7638,  7640,  7643,
    7644,  7646,  7650,  7652,  7655,  7658,  7661,  7663,  7667,  7671,
    7673,  7675,  7679,  7681,  7685,  7687,  7691,  7693,  7695,  7697,
    7699,  7704,  7710,  7715,  7722,  7724,  7725,  7729,  7733,  7735,
    7737,  7738,  7741,  7744,  7747,  7750,  7751,  7754,  7755,  7759,
    7762,  7764,  7767,  7770,  7773,  7776,  7779,  7780,  7784,  7785,
    7787,  7788,  7792,  7795,  7796,  7798,  7801,  7802,  7804,  7809,
    7814,  7820,  7823,  7827,  7828,  7830,  7831,  7836,  7837,  7839,
    7841,  7842,  7844,  7845,  7848,  7851,  7853,  7854,  7856,  7858,
    7861,  7865,  7868,  7869,  7876,  7880,  7881,  7882,  7883,  7885,
    7888,  7890,  7892,  7894,  7896,  7898,  7900,  7902,  7904,  7906,
    7909,  7912,  7916,  7918,  7920,  7922,  7924,  7926,  7928,  7930,
    7932,  7934,  7936,  7938,  7940,  7942,  7943,  7947,  7951,  7955,
    7959,  7960,  7964,  7968,  7969,  7977,  7978,  7982,  7984,  7988,
    7989,  7993,  7996,  8001,  8002,  8006,  8011,  8016,  8017,  8018,
    8019,  8036,  8045,  8053,  8054,  8055,  8056,  8057,  8058,  8074,
    8075,  8076,  8077,  8078,  8091,  8096,  8101,  8105,  8110,  8114,
    8117,  8119,  8123,  8129,  8131,  8133,  8134,  8136,  8138,  8139,
    8142,  8143,  8144,  8148,  8149,  8152,  8158,  8162,  8166,  8170
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     664,     0,    -1,   162,    -1,    -1,   667,   665,   659,   666,
      -1,   667,   162,    -1,    -1,   162,    -1,   668,    -1,  1588,
      -1,  1053,    -1,  1121,    -1,  1134,    -1,   722,    -1,   680,
      -1,  1135,    -1,  1113,    -1,  1594,    -1,   689,    -1,   669,
      -1,  1386,    -1,  1420,    -1,  1337,    -1,  1339,    -1,   673,
      -1,  1427,    -1,   758,    -1,  1554,    -1,  1544,    -1,   678,
      -1,  1350,    -1,  1656,    -1,  1658,    -1,  1148,    -1,  1448,
      -1,  1455,    -1,  1536,    -1,  1140,    -1,   968,    -1,   877,
      -1,  1155,    -1,   671,    -1,  1444,    -1,  1597,    -1,  1143,
      -1,  1116,    -1,  1353,    -1,  1438,    -1,   757,    -1,  1551,
      -1,  1595,    -1,  1596,    -1,  1167,    -1,  1509,    -1,   750,
      -1,  1406,    -1,  1453,    -1,  1100,    -1,  1103,    -1,  1399,
      -1,  1657,    -1,  1542,    -1,  1378,    -1,  1454,    -1,  1648,
      -1,   670,   413,  1501,    -1,   128,    -1,   150,    -1,   413,
    1501,   199,   672,    -1,  1498,    -1,   660,  1503,    -1,    -1,
     177,  1501,   674,   675,    -1,    -1,   608,   676,    -1,   676,
     655,   677,    -1,   677,    -1,   660,  1503,    -1,    -1,   220,
     679,  1503,    -1,    -1,    59,   313,   687,   574,   681,   682,
      -1,   683,    -1,   682,   655,   683,    -1,   298,   166,  1498,
      -1,   314,   166,  1498,    -1,   301,   166,  1498,    -1,   302,
     166,  1316,    -1,   296,   166,  1316,    -1,   311,   166,  1316,
      -1,   305,   166,  1498,    -1,   304,   166,  1498,    -1,   306,
     166,  1498,    -1,   307,   166,  1498,    -1,   310,   166,  1498,
      -1,   312,   166,  1316,    -1,   308,   166,  1498,    -1,   309,
     166,  1498,    -1,   316,   166,  1485,    -1,   236,   166,   653,
     684,   654,    -1,   686,    -1,    -1,   685,    -1,   684,   655,
     685,    -1,  1316,    -1,   299,   166,  1498,    -1,   300,   166,
    1318,    -1,   443,   166,  1498,    -1,   444,   166,  1316,    -1,
     315,   166,   111,    -1,   315,   166,   505,    -1,   315,   166,
     366,    -1,    -1,   688,    -1,  1498,    -1,    -1,   933,   929,
     557,   932,  1494,   690,   865,    -1,    -1,    -1,   104,  1030,
     239,   932,  1501,  1034,   376,  1494,   691,   653,  1047,   654,
    1035,   692,  1087,    -1,    -1,    -1,   104,  1031,   239,   932,
    1501,  1033,   376,  1494,   693,   653,  1047,   654,  1036,   694,
    1087,    -1,    -1,    -1,   104,  1032,   239,   932,  1501,  1033,
     376,  1494,   695,   653,  1047,   654,  1037,   696,  1087,    -1,
      -1,   104,   115,   932,  1501,   697,   926,    -1,    -1,   933,
     698,  1616,    -1,   104,   604,   715,  1575,    -1,   104,   470,
     715,  1558,  1556,    -1,   104,   287,   213,   828,    -1,   104,
     554,   825,    -1,   104,   699,    -1,   491,  1503,   196,   118,
     634,  1503,   382,   653,   700,   654,    -1,   701,    -1,   700,
     655,   701,    -1,   604,  1498,    -1,   224,  1498,    -1,   115,
    1498,    -1,   392,  1498,    -1,   403,  1498,    -1,   509,  1498,
      -1,   410,  1316,    -1,    -1,  1184,   173,   932,   716,   703,
     376,   480,   704,   709,   706,   711,   149,   712,    -1,    -1,
     174,  1190,  1286,   705,   707,   708,    -1,    24,  1190,    -1,
      -1,   158,    -1,   143,   376,   503,    -1,   143,    -1,    -1,
     529,  1190,    -1,    -1,   161,  1190,    -1,    -1,   710,    -1,
     376,    87,   414,    -1,   376,    87,   364,   414,    -1,    -1,
      83,  1498,    -1,    -1,   713,   714,    -1,   774,    -1,   776,
      -1,   772,    -1,   793,    -1,   811,    -1,   813,    -1,   808,
      -1,   778,    -1,   780,    -1,   781,    -1,   782,    -1,   783,
      -1,   785,    -1,    -1,  1501,   661,  1501,    -1,  1501,    -1,
      -1,   717,   719,    -1,    -1,   718,   720,    -1,    83,  1498,
      -1,   265,   525,    -1,   366,   525,    -1,    97,   525,    -1,
     429,   525,   118,    -1,   341,   525,   118,    -1,   721,    -1,
     719,    -1,   140,    -1,  1196,   140,    -1,   525,   484,   133,
      -1,   525,   484,   252,    -1,    -1,    52,   716,   723,   724,
      -1,    -1,   653,   725,   654,    -1,    -1,   726,    -1,   726,
     655,  1190,    -1,  1190,    -1,    -1,   728,    -1,   728,   655,
     730,    -1,   730,    -1,    -1,  1501,   729,   991,    -1,    -1,
     732,    -1,   732,   655,   733,    -1,   733,    -1,   734,   729,
    1501,   991,    -1,    -1,   253,    -1,   391,    -1,   244,    -1,
      -1,   735,   771,   659,    -1,   771,   659,    -1,   736,   771,
     659,    -1,    -1,   737,   738,   659,    -1,    -1,   131,   769,
     739,   991,   770,    -1,   131,  1501,    90,   197,   746,    -1,
      -1,   131,   743,   216,   197,   740,   744,   771,    -1,   131,
    1501,   112,   197,   741,    -1,    -1,   742,  1167,    -1,   179,
      -1,    99,    -1,   745,    -1,   744,   655,   745,    -1,   749,
      -1,  1316,    -1,   747,    -1,   517,   748,  1499,    -1,    -1,
     613,    -1,   746,    -1,  1501,    -1,   518,    -1,  1196,   198,
      -1,   516,    -1,   500,   751,   753,    -1,  1501,    -1,   747,
      -1,    -1,   751,    -1,    -1,   493,   754,    -1,   756,   166,
     755,    -1,   754,   655,   756,   166,   755,    -1,  1484,    -1,
    1221,    -1,  1490,    -1,    67,    -1,   541,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   481,    -1,   559,    -1,
      82,    -1,   113,    -1,   332,    -1,   349,    -1,   458,   752,
     753,    -1,   209,   759,   141,   760,    -1,    -1,   108,    -1,
     761,    -1,    90,   765,   766,    -1,   762,    -1,   761,   655,
     762,    -1,   763,   166,   764,    -1,  1501,    -1,   660,  1503,
      -1,   371,    -1,   477,    -1,   755,    -1,   767,    -1,   766,
     655,   767,    -1,   763,   166,   768,    -1,    67,    -1,   541,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   481,
      -1,   559,    -1,    82,    -1,   113,    -1,   332,    -1,   349,
      -1,   463,    -1,  1501,    -1,   769,   655,  1501,    -1,    -1,
     132,  1190,    -1,   774,    -1,   776,    -1,   772,    -1,   793,
      -1,   811,    -1,   813,    -1,   808,    -1,   778,    -1,   780,
      -1,   781,    -1,   782,    -1,   783,    -1,   785,    -1,    -1,
     234,   773,   788,   160,   234,    -1,    -1,   775,   668,    -1,
      -1,   466,   777,  1190,    -1,    -1,   779,   817,    -1,   271,
    1502,    -1,   259,  1502,    -1,   380,  1501,    -1,    -1,   188,
     786,  1501,   250,   784,   787,    -1,    70,  1501,    -1,    -1,
     360,   199,    -1,   199,    -1,  1501,    -1,   787,   655,  1501,
      -1,    -1,    -1,    -1,   789,  1190,   566,   790,   736,   791,
     792,    -1,    -1,   157,   788,    -1,   156,   736,    -1,   794,
      -1,   797,    -1,    -1,    -1,    55,   795,  1190,   796,   799,
     807,   160,    55,    -1,    -1,    55,   798,   800,   807,   160,
      55,    -1,   801,    -1,   799,   801,    -1,   804,    -1,   800,
     804,    -1,    -1,    -1,   627,   802,  1190,   803,   566,   736,
      -1,    -1,    -1,   627,   805,  1190,   806,   566,   736,    -1,
      -1,   156,   736,    -1,    -1,  1502,   662,   809,   817,   810,
      -1,    -1,  1502,    -1,    -1,  1502,   662,   812,   815,   810,
      -1,    -1,   814,   815,    -1,    -1,    33,   816,   737,   735,
     160,    -1,   293,   736,   160,   293,    -1,    -1,    -1,   629,
     818,  1190,   149,   819,   736,   160,   629,    -1,    -1,   453,
     736,   600,   820,  1190,   160,   453,    -1,    32,    -1,     9,
      -1,   246,    -1,   601,    -1,   136,    -1,   850,   852,    -1,
     850,    59,   847,   831,    -1,   850,     6,   847,   826,   835,
      -1,    -1,   607,   287,   213,  1501,    -1,   850,     6,   847,
     838,    -1,   850,   150,   847,   838,    -1,   851,   830,   841,
      -1,   851,   830,   844,    -1,     6,   848,    -1,     6,   849,
      -1,    -1,   832,   833,    -1,   834,    -1,   833,   834,    -1,
     833,   655,   834,    -1,   853,    -1,   854,    -1,   855,    -1,
     836,    -1,   837,    -1,   836,   837,    -1,   836,   655,   837,
      -1,   853,    -1,   854,    -1,   855,    -1,   856,    -1,   859,
      -1,   861,    -1,   863,    -1,   860,    -1,   839,    -1,   840,
      -1,   839,   840,    -1,   839,   655,   840,    -1,   853,    -1,
     854,    -1,   855,    -1,   861,    -1,   863,    -1,   842,    -1,
     843,    -1,   842,   843,    -1,   842,   655,   843,    -1,   853,
      -1,   857,    -1,   858,    -1,   859,    -1,   861,    -1,   863,
      -1,   860,    -1,   845,    -1,   846,    -1,   845,   846,    -1,
     845,   655,   846,    -1,   853,    -1,   861,    -1,   863,    -1,
     117,  1498,    -1,   590,  1498,    -1,   436,  1498,    -1,  1501,
      -1,  1501,    -1,   430,    -1,   432,    -1,   364,     4,    -1,
     242,  1370,   864,    -1,    26,  1370,   864,    -1,   321,  1370,
     864,    -1,   183,  1370,   864,    -1,   591,  1370,   864,    -1,
     437,  1370,   864,    -1,   361,  1370,  1317,    -1,    83,  1370,
    1498,    -1,  1413,   164,  1370,   941,    -1,    -1,   863,    -1,
     623,    -1,   367,    -1,  1319,    -1,  1497,    -1,    -1,   653,
     947,   654,   866,   934,   872,   869,    -1,   934,   872,   869,
      -1,    -1,   653,   922,   654,   867,  1601,    -1,   868,    -1,
     276,  1494,    -1,   653,   276,  1494,   654,    -1,    -1,    -1,
    1463,   925,   922,   870,  1598,    -1,    -1,  1463,   925,   653,
     922,   654,   871,  1601,    -1,   873,    -1,    -1,   874,    -1,
      -1,   400,   876,   875,   879,    -1,    -1,    -1,   400,   878,
     879,    -1,    49,   880,   890,   891,   898,    -1,   882,   263,
     883,   653,   884,   654,    -1,    -1,   882,   218,   881,   888,
      -1,   428,   888,    -1,   428,   887,    -1,   281,   888,    -1,
     281,   887,    -1,    -1,   278,    -1,    -1,    12,   166,  1317,
      -1,    -1,   885,    -1,   886,    -1,   885,   655,   886,    -1,
    1501,    -1,    75,   653,   884,   654,    -1,   653,  1184,   896,
    1185,   654,    -1,   653,  1184,   896,  1185,   654,    -1,    -1,
     401,  1317,    -1,    -1,    -1,   545,    49,   882,   218,   889,
     892,   897,    -1,    -1,   545,    49,   882,   263,   883,   653,
     894,   654,   893,   897,    -1,   895,    -1,   894,   655,   895,
      -1,  1501,    -1,  1193,    -1,    -1,   544,  1317,    -1,    -1,
     653,   899,   654,    -1,   900,    -1,   899,   655,   900,    -1,
      -1,   400,   901,   902,   903,   919,   914,    -1,  1501,    -1,
      -1,    -1,   612,   273,   565,   904,   906,    -1,    -1,   612,
     253,   905,   907,    -1,   325,    -1,   909,    -1,   909,    -1,
     653,   908,   654,    -1,   909,    -1,   908,   655,   909,    -1,
      -1,    -1,   653,   910,   912,   911,   654,    -1,   913,    -1,
     912,   655,   913,    -1,   325,    -1,  1193,    -1,    -1,   653,
     915,   654,    -1,   916,    -1,   915,   655,   916,    -1,    -1,
     545,   917,   918,   919,    -1,  1503,    -1,    -1,   920,    -1,
     920,   921,    -1,   921,    -1,   554,  1370,  1503,    -1,  1413,
     164,  1370,   941,    -1,    91,  1370,  1498,    -1,   361,  1370,
    1317,    -1,   320,  1370,  1319,    -1,   338,  1370,  1319,    -1,
     118,   142,  1370,  1498,    -1,   239,   142,  1370,  1498,    -1,
      83,  1370,  1498,    -1,    -1,    -1,   485,   923,  1178,  1182,
     924,   945,    -1,    -1,    20,    -1,    -1,   927,    -1,   928,
      -1,   927,   928,    -1,   940,    -1,   939,    -1,    -1,   930,
      -1,   931,    -1,   931,   930,    -1,   560,    -1,    -1,   234,
    1196,   178,    -1,   104,    -1,   104,   388,   454,    -1,    -1,
     936,    -1,   937,    -1,   937,   935,    -1,   937,    -1,   937,
     936,    -1,   937,   655,   936,    -1,   164,  1370,   941,    -1,
     320,  1370,  1318,    -1,   338,  1370,  1318,    -1,    29,  1370,
    1316,    -1,   403,  1370,  1498,    -1,    83,  1370,  1498,    -1,
      27,  1370,  1318,    -1,   393,  1370,  1316,    -1,   393,  1370,
     132,    -1,   531,  1370,  1316,    -1,   531,  1370,   132,    -1,
     532,  1370,  1316,    -1,   532,  1370,   132,    -1,   533,  1370,
    1316,    -1,   533,  1370,   132,    -1,    64,  1370,  1316,    -1,
     558,  1370,  1316,    -1,   395,  1370,  1322,    -1,   135,  1370,
    1316,    -1,   475,  1370,   943,    -1,    -1,   595,  1370,   938,
     653,  1436,   654,    -1,   939,    -1,   940,    -1,   247,  1370,
     944,    -1,   118,   142,  1370,  1498,    -1,   239,   142,  1370,
    1498,    -1,   554,  1501,    -1,   538,   145,    -1,   538,   330,
      -1,    91,  1370,  1498,    -1,   262,  1370,  1316,    -1,   577,
    1370,  1322,    -1,  1497,  1369,  1498,    -1,  1497,  1369,  1501,
      -1,  1497,  1369,  1319,    -1,  1497,  1369,   132,    -1,  1002,
     993,  1370,   995,    -1,  1002,    73,  1370,  1001,    -1,  1503,
      -1,  1503,    -1,   132,    -1,   191,    -1,   154,    -1,    88,
      -1,   438,    -1,    86,    -1,   394,    -1,   366,    -1,   190,
      -1,   266,    -1,  1309,    -1,  1177,  1181,    -1,   540,    -1,
     433,    -1,   130,    -1,   251,    -1,   948,    -1,   949,    -1,
     948,   655,   949,    -1,   950,    -1,   951,    -1,   960,   956,
      -1,   960,  1019,    -1,    -1,  1025,  1050,  1034,   653,  1047,
     654,   952,  1035,    -1,    -1,  1031,  1028,  1050,  1033,   653,
    1047,   654,   953,  1036,    -1,    -1,  1032,  1028,  1050,  1033,
     653,  1047,   654,   954,  1037,    -1,    -1,   958,  1026,  1050,
    1034,   653,  1047,   654,   955,  1035,    -1,   958,   196,   263,
    1050,   653,  1047,   654,  1019,    -1,   958,   957,    -1,    -1,
     957,    -1,    65,   653,  1190,   654,    -1,    -1,   959,    -1,
      93,  1049,    -1,    -1,  1493,   961,   962,    -1,   970,   988,
      -1,   970,   963,    20,   653,   969,   654,   964,   965,    -1,
      -1,   205,    15,    -1,    -1,   622,    -1,   404,    -1,    -1,
     966,    -1,   966,   967,    -1,   967,    -1,   596,    -1,   596,
     263,    -1,    83,  1498,    -1,   398,   653,   969,   654,    -1,
    1184,  1190,  1185,    -1,   978,   986,   982,    -1,   979,   987,
     982,    -1,   193,   980,   982,    -1,    41,    -1,    41,   985,
      -1,    46,    -1,    45,    -1,   974,   985,  1005,    -1,   974,
    1005,    -1,   975,   985,  1006,    -1,   975,  1006,    -1,    36,
     985,    -1,    36,    -1,   976,   985,  1005,    -1,   977,   985,
    1006,    -1,   614,   985,    -1,   641,   986,   982,    -1,   122,
      -1,   570,   986,    -1,   567,   986,    -1,   119,   986,    -1,
     571,    -1,    43,   986,    -1,   973,    -1,   326,    -1,   289,
      -1,   292,   614,    -1,   292,   976,  1005,    -1,   573,  1005,
      -1,   564,   986,  1005,    -1,   328,  1005,    -1,   290,  1005,
      -1,   130,   980,   982,    -1,   372,   980,   982,    -1,   191,
     980,   982,    -1,    -1,   165,   971,   653,  1052,   654,  1005,
      -1,    -1,   493,   972,   653,  1052,   654,  1005,    -1,   292,
    1005,    -1,   489,    -1,   207,    -1,   206,    -1,   408,    -1,
     346,    -1,   280,    -1,   345,    -1,   409,    -1,   347,    -1,
      62,    -1,   355,    -1,   352,    62,    -1,   974,   618,    -1,
     615,    -1,   352,   615,    -1,   373,    -1,   355,   615,    -1,
     352,    62,   618,    -1,   355,   618,    -1,   251,    -1,   572,
      -1,   507,    -1,   327,    -1,    35,    -1,   433,    -1,   148,
      -1,   148,   412,    -1,    -1,   985,    -1,   981,    -1,   653,
     370,   655,   370,   654,    -1,    -1,   983,    -1,   983,   984,
      -1,   984,    -1,   501,    -1,   599,    -1,   642,    -1,   653,
     291,   654,    -1,   653,   586,   654,    -1,   653,   129,   654,
      -1,   653,   370,   654,    -1,    -1,   985,    -1,    -1,   981,
      -1,    -1,   989,    -1,   989,   990,    -1,   990,    -1,   369,
      -1,  1196,   369,    -1,   132,   992,    -1,   376,   601,   365,
    1187,    -1,    27,    -1,   489,   132,   613,    -1,  1018,   263,
      -1,   596,    -1,   596,   263,    -1,    83,  1498,    -1,    73,
     999,    -1,  1497,  1369,  1498,    -1,  1497,  1369,  1501,    -1,
    1497,  1369,  1319,    -1,  1497,  1369,   132,    -1,   970,  1000,
      -1,   365,  1187,    -1,  1483,    -1,    62,   493,    -1,    61,
      -1,  1503,    -1,    36,    -1,   994,    -1,   132,    -1,    -1,
     993,   995,    -1,  1503,    -1,    36,    -1,   997,    -1,   132,
      -1,  1503,    -1,    -1,    73,  1001,    -1,   999,    -1,   132,
      -1,    -1,   132,    -1,    22,    -1,    36,    22,    -1,    22,
      36,    -1,   593,    -1,   593,    36,    -1,    36,   593,    -1,
      -1,  1003,    -1,  1004,    -1,    50,    -1,   993,   994,  1006,
      -1,    36,    -1,    36,   993,   994,    -1,    -1,    36,    -1,
      -1,   653,  1317,  1008,   654,    -1,    21,    -1,   137,    -1,
     467,    -1,    -1,  1009,    -1,  1009,  1010,    -1,  1010,    -1,
    1317,    -1,  1012,  1011,    -1,  1013,    -1,  1014,   655,  1013,
      -1,  1012,   646,  1012,    -1,  1014,    -1,  1015,    -1,    -1,
     274,  1016,    -1,    -1,   416,    -1,   439,  1494,  1020,  1022,
    1023,    -1,    -1,   653,  1021,   654,    -1,  1021,   655,  1501,
      -1,  1501,    -1,    -1,   317,   200,    -1,   317,   399,    -1,
     317,   502,    -1,    -1,   376,   601,  1024,    -1,   376,   136,
    1024,    -1,   376,   601,  1024,   376,   136,  1024,    -1,   376,
     136,  1024,   376,   601,  1024,    -1,   461,    -1,    53,    -1,
     493,   369,    -1,   366,     5,    -1,   493,   132,    -1,  1027,
      -1,   416,   263,    -1,   596,  1028,    -1,   263,    -1,   239,
      -1,    -1,  1027,    -1,   261,    -1,   239,    -1,   238,    -1,
      -1,   596,    -1,   201,    -1,   514,    -1,    -1,  1033,    -1,
    1033,  1041,    -1,    -1,  1038,    -1,    -1,  1040,    -1,    -1,
    1039,    -1,  1043,    -1,  1038,  1043,    -1,  1044,    -1,  1039,
    1044,    -1,  1045,    -1,  1040,  1045,    -1,   608,  1046,    -1,
     584,  1046,    -1,   262,  1370,  1316,    -1,    83,  1498,    -1,
    1497,  1369,  1498,    -1,  1497,  1369,  1501,    -1,  1497,  1369,
    1319,    -1,  1497,  1369,   132,    -1,  1042,    -1,  1041,    -1,
    1042,    -1,  1042,    -1,   630,   397,  1497,    -1,    48,    -1,
     478,    -1,   218,    -1,  1047,   655,  1048,  1307,    -1,  1048,
    1307,    -1,  1501,    -1,  1501,   653,   370,   654,    -1,    -1,
    1493,    -1,   932,  1049,    -1,    -1,   661,  1501,    -1,  1480,
      -1,  1052,   655,  1480,    -1,    -1,    -1,    14,  1054,  1092,
     557,  1494,  1055,  1066,    -1,    -1,    14,   115,  1065,  1056,
     927,    -1,    14,   115,  1501,   602,   118,   142,   351,    -1,
      -1,    14,   418,   716,  1057,   717,    -1,    -1,    14,   202,
     716,  1058,   717,    -1,    -1,    14,  1622,  1619,  1059,  1624,
      -1,    -1,    14,  1619,  1060,  1624,    -1,    -1,    14,  1619,
     173,   716,  1061,  1062,  1063,   706,   711,  1064,    -1,    14,
     554,   827,    -1,    14,   287,   213,   829,    -1,    14,   554,
     824,    -1,    14,   554,   823,    -1,    14,   491,  1503,   382,
     653,   700,   654,    -1,    -1,   376,   480,   704,    -1,   710,
      -1,   376,   480,   704,   710,    -1,    -1,   449,   574,   716,
      -1,    -1,   149,   712,    -1,    -1,  1501,    -1,    -1,   144,
     554,    -1,   237,   554,    -1,  1081,   873,    -1,  1081,  1070,
      -1,  1070,    -1,   874,    -1,  1072,    -1,   150,   400,  1348,
    1079,    -1,   434,   400,  1142,  1071,    -1,    -1,   381,   400,
    1142,  1071,  1067,  1142,    -1,    16,   400,  1142,  1071,    -1,
      -1,    65,   400,  1071,  1068,  1137,    -1,    -1,   451,   400,
    1142,  1071,  1069,  1118,    -1,    71,   400,  1142,  1317,    -1,
     582,   400,  1071,    -1,  1075,    -1,   175,   400,  1080,   630,
     557,  1494,   876,    -1,   448,   402,    -1,    13,    -1,  1079,
      -1,    -1,     6,   400,   932,  1142,  1073,  1074,    -1,    -1,
     653,   899,   654,    -1,   401,  1317,    -1,    -1,   450,   400,
    1142,  1076,  1077,    -1,    -1,    -1,  1079,  1078,   250,   653,
     899,   654,    -1,  1080,    -1,  1079,   655,  1080,    -1,  1501,
      -1,  1083,    -1,  1081,   655,  1083,    -1,     6,  1090,   932,
      -1,  1082,   950,  1098,    -1,     6,   951,    -1,  1082,   653,
     947,   654,    -1,    -1,    59,  1090,  1348,  1493,  1084,   960,
    1098,    -1,    -1,    -1,   342,  1090,  1348,  1493,  1085,   962,
    1086,  1098,    -1,   150,  1090,  1348,  1493,  1097,    -1,   150,
     196,   263,  1348,  1493,    -1,   150,   416,   263,    -1,   150,
    1027,  1348,  1493,    -1,   143,   261,    -1,   158,   261,    -1,
      14,  1090,  1493,   493,   132,  1483,    -1,    14,  1090,  1493,
     150,   132,    -1,   449,  1099,  1494,    -1,   101,   574,   993,
     995,  1000,    -1,   935,    -1,   195,    -1,  1300,    -1,  1088,
      -1,  1089,    -1,    -1,  1089,    -1,  1088,    -1,  1089,  1088,
      -1,  1088,  1089,    -1,    12,  1370,   132,    -1,    12,  1370,
    1501,    -1,   286,  1370,   132,    -1,   286,  1370,  1501,    -1,
      -1,    81,    -1,    -1,   235,    -1,    -1,  1093,  1094,    -1,
      -1,  1095,    -1,  1095,  1096,    -1,  1096,    -1,   235,    -1,
     379,    -1,    -1,   461,    -1,    53,    -1,    -1,     9,  1501,
      -1,   190,    -1,    -1,   574,    -1,   166,    -1,    20,    -1,
      -1,   530,   503,   687,  1107,  1101,  1111,    -1,    -1,   530,
      13,   504,  1107,  1102,    -1,   537,   503,   687,  1107,    -1,
     537,    13,   504,  1107,    -1,   530,   576,  1104,    -1,    -1,
    1105,    -1,  1106,    -1,  1105,   655,  1106,    -1,   630,    92,
     508,    -1,   431,   378,    -1,   431,   635,    -1,    -1,  1108,
    1109,    -1,  1110,    -1,  1109,   655,  1110,    -1,    -1,   526,
      -1,   445,    -1,    -1,   600,  1112,    -1,   600,   297,   166,
    1498,    -1,   686,    -1,  1112,   655,   686,    -1,    -1,    64,
    1538,  1114,  1343,  1115,    -1,    -1,   427,    -1,   182,    -1,
      -1,   451,  1142,  1538,  1117,  1343,  1118,    -1,    -1,  1119,
      -1,  1120,    -1,  1120,  1119,    -1,   427,    -1,   182,    -1,
     606,    -1,    -1,    16,  1142,  1538,  1122,  1123,    -1,  1124,
      -1,  1123,   655,  1124,    -1,  1344,  1125,    -1,    -1,   404,
     197,  1126,    -1,    13,    -1,    75,  1127,   238,  1129,    -1,
      13,    -1,    -1,   653,  1128,  1131,   654,    -1,    13,    -1,
      -1,   653,  1130,  1132,   654,    -1,    -1,  1501,    -1,  1131,
     655,  1501,    -1,    -1,  1133,    -1,  1132,   655,  1133,    -1,
    1501,    -1,   416,    -1,    37,  1498,    -1,    -1,    65,  1538,
    1136,  1343,  1137,    -1,    -1,  1138,    -1,  1139,    -1,  1139,
    1138,    -1,   427,    -1,   186,    -1,   329,    -1,   182,    -1,
      60,    -1,   197,   602,    -1,    -1,   381,  1142,  1538,  1141,
    1343,    -1,    -1,   368,    -1,   283,    -1,    -1,   449,  1538,
    1144,  1146,    -1,   449,   604,   715,  1145,    -1,  1506,   574,
    1506,    -1,  1145,   655,  1506,   574,  1506,    -1,  1147,    -1,
    1146,   655,  1147,    -1,  1494,   574,  1494,    -1,    -1,    51,
     239,  1149,  1150,   253,  1154,    -1,  1151,    -1,  1153,    -1,
    1152,    -1,  1151,   655,  1152,    -1,  1494,  1163,    -1,  1494,
    1161,  1163,    -1,  1501,    -1,   132,    -1,    -1,   282,   239,
     250,    51,  1156,  1157,    -1,  1160,    -1,  1158,    -1,  1159,
      -1,  1158,   655,  1159,    -1,  1494,  1163,  1166,    -1,  1494,
    1161,  1163,  1166,    -1,    -1,   400,   876,  1162,   653,  1071,
     654,    -1,    -1,  1164,  1165,    -1,    -1,  1027,   653,  1282,
     654,    -1,    -1,   235,   270,    -1,  1168,    -1,   485,  1171,
      -1,   653,  1169,   654,  1601,    -1,   485,  1173,    -1,   653,
    1169,   654,    -1,   485,  1261,    -1,   653,  1170,   654,    -1,
      -1,  1173,  1172,  1598,    -1,    -1,    -1,  1174,  1178,  1182,
    1175,  1176,  1181,    -1,  1303,  1309,    -1,  1332,    -1,  1177,
      -1,  1332,  1177,    -1,  1177,  1332,    -1,   199,  1241,  1292,
    1297,  1294,  1303,  1309,  1323,    -1,   199,   151,  1292,  1309,
      -1,    -1,  1179,    -1,  1179,  1180,    -1,  1180,    -1,  1615,
      -1,   523,    -1,   521,    -1,    -1,   197,   601,    -1,   286,
     253,   495,   340,    -1,  1182,   655,  1183,    -1,  1183,    -1,
     648,    -1,  1184,  1488,  1185,    -1,  1184,  1190,  1185,  1186,
      -1,    -1,    -1,    -1,    20,  1501,    -1,    20,  1498,    -1,
    1501,    -1,  1498,    -1,    -1,   653,   654,    -1,   653,  1317,
     654,    -1,    -1,   653,   654,    -1,   653,  1317,   654,    -1,
      -1,   653,   654,    -1,  1190,  1194,  1190,    -1,  1190,   639,
    1190,    -1,  1190,  1195,  1190,    -1,   364,  1190,    -1,  1191,
     256,   581,    -1,  1191,   256,  1196,   581,    -1,  1191,   256,
     185,    -1,  1191,   256,  1196,   185,    -1,  1191,   256,   597,
      -1,  1191,   256,  1196,   597,    -1,  1191,    -1,  1191,   256,
     369,    -1,  1191,   256,  1196,   369,    -1,  1191,   167,  1192,
      -1,  1191,  1198,  1192,    -1,  1191,  1198,  1199,   653,  1610,
     654,    -1,  1192,    -1,  1193,   253,   653,  1610,   654,    -1,
    1193,  1196,   253,   653,  1610,   654,    -1,  1193,   253,   653,
    1190,   654,    -1,  1193,   253,   653,  1190,   655,  1234,   654,
      -1,  1193,  1196,   253,   653,  1190,   654,    -1,  1193,  1196,
     253,   653,  1190,   655,  1234,   654,    -1,  1193,    34,  1193,
      18,  1192,    -1,  1193,  1196,    34,  1193,    18,  1192,    -1,
    1193,   512,   276,  1193,    -1,  1193,   276,  1204,  1296,    -1,
    1193,  1196,   276,  1204,  1296,    -1,  1193,   440,  1193,    -1,
    1193,  1196,   440,  1193,    -1,  1193,    -1,  1193,   644,  1193,
      -1,  1193,   645,  1193,    -1,  1193,   496,  1193,    -1,  1193,
     497,  1193,    -1,  1193,   647,  1193,    -1,  1193,   646,  1193,
      -1,  1193,   647,   249,  1190,  1286,    -1,  1193,   646,   249,
    1190,  1286,    -1,  1193,   648,  1193,    -1,  1193,   649,  1193,
      -1,  1193,   650,  1193,    -1,  1193,   147,  1193,    -1,  1193,
     343,  1193,    -1,  1193,   651,  1193,    -1,  1204,    -1,   388,
      -1,   385,    -1,    18,    -1,    17,    -1,   364,    -1,   363,
      -1,   656,    -1,   363,    -1,   166,    -1,   203,    -1,   215,
      -1,   268,    -1,   295,    -1,   357,    -1,    13,    -1,    19,
      -1,    -1,    20,  1201,    -1,   251,    -1,   599,   251,    -1,
     148,    -1,   433,    -1,   193,    -1,   130,   980,    -1,   974,
    1005,    -1,   975,    -1,   122,    -1,   570,   986,    -1,   119,
     986,    -1,  1190,   655,  1190,  1200,    -1,  1202,    -1,  1203,
     655,  1202,    -1,  1490,    -1,  1205,    -1,  1206,    -1,  1209,
      -1,  1207,    -1,  1204,    73,  1503,    -1,  1484,    -1,  1482,
      -1,  1221,    -1,  1217,    -1,  1204,   387,  1204,    -1,   647,
    1204,    -1,   646,  1204,    -1,   652,  1204,    -1,  1197,  1204,
      -1,   653,  1610,   654,    -1,   653,  1190,   654,    -1,   653,
    1190,   655,  1234,   654,    -1,   476,   653,  1190,   655,  1234,
     654,    -1,   178,   653,  1610,   654,    -1,   657,  1501,  1190,
     658,    -1,   317,  1235,    10,   653,  1193,  1211,   654,    -1,
      36,  1204,    -1,    56,   653,  1190,    20,  1231,   654,    -1,
      55,  1237,  1239,  1238,   160,    -1,   101,   653,  1190,   655,
    1231,   654,    -1,   101,   653,  1190,   608,   994,   654,    -1,
     132,   653,  1490,   654,    -1,   612,   653,  1491,   654,    -1,
     249,  1190,  1286,   647,  1190,    -1,    62,   653,  1234,   654,
      -1,    62,   653,  1234,   608,   994,   654,    -1,   109,  1189,
      -1,   110,  1189,    -1,   122,   653,  1190,   654,    -1,   127,
     653,  1190,   654,    -1,   229,   653,  1190,   654,    -1,   246,
     653,  1190,   655,  1190,   655,  1190,   655,  1190,   654,    -1,
     249,   653,  1190,   655,  1190,   654,    -1,   249,   653,  1190,
     655,  1190,   655,  1234,   654,    -1,   272,   653,  1190,   655,
    1190,   654,    -1,   337,   653,  1190,   654,    -1,   344,   653,
    1190,   654,    -1,   469,   653,  1190,   655,  1190,   654,    -1,
     483,   653,  1190,   654,    -1,   570,   653,  1190,   654,    -1,
     567,   653,  1190,   654,    -1,   567,   653,  1190,   655,  1190,
     654,    -1,   580,   653,  1190,   654,    -1,   580,   653,   269,
    1190,   199,  1190,   654,    -1,   580,   653,   575,  1190,   199,
    1190,   654,    -1,   580,   653,    47,  1190,   199,  1190,   654,
      -1,   580,   653,   269,   199,  1190,   654,    -1,   580,   653,
     575,   199,  1190,   654,    -1,   580,   653,    47,   199,  1190,
     654,    -1,   580,   653,  1190,   199,  1190,   654,    -1,   604,
     653,   654,    -1,   641,   653,  1190,   654,    -1,     8,   653,
    1190,   655,  1190,   654,    -1,     8,   653,  1190,   655,   249,
    1190,  1286,   654,    -1,   107,  1189,    -1,   114,  1188,    -1,
     120,   653,  1190,   655,   249,  1190,  1286,   654,    -1,   121,
     653,  1190,   655,   249,  1190,  1286,   654,    -1,   184,   653,
    1286,   199,  1190,   654,    -1,   208,   653,  1288,   655,  1190,
     654,    -1,   365,  1188,    -1,   411,   653,  1193,   253,  1190,
     654,    -1,   542,   653,  1190,   655,  1190,   654,    -1,   542,
     653,  1190,   655,   249,  1190,  1286,   654,    -1,   546,   653,
    1190,   655,  1190,   655,  1190,   654,    -1,   546,   653,  1190,
     655,  1190,   654,    -1,   546,   653,  1190,   199,  1190,   197,
    1190,   654,    -1,   546,   653,  1190,   199,  1190,   654,    -1,
     552,  1188,    -1,   568,   653,  1287,   655,  1190,   655,  1190,
     654,    -1,   569,   653,  1287,   655,  1190,   655,  1190,   654,
      -1,   609,  1189,    -1,   611,  1188,    -1,   610,  1188,    -1,
      76,   653,  1190,   655,  1203,   654,    -1,    79,   653,  1190,
     655,  1234,   654,    -1,    77,   653,  1190,   654,    -1,    78,
     653,  1203,   654,    -1,    80,   653,  1190,   655,  1190,    20,
    1231,   654,    -1,    22,   653,  1190,   654,    -1,    61,   653,
    1190,   654,    -1,    71,   653,  1234,   654,    -1,    74,   653,
    1190,   654,    -1,   115,   653,   654,    -1,   234,   653,  1190,
     655,  1190,   655,  1190,   654,    -1,   267,   653,  1234,   654,
      -1,   333,   653,  1190,   654,    -1,   343,   653,  1190,   655,
    1190,   654,    -1,   375,   653,  1190,   654,    -1,   403,   653,
    1190,   654,    -1,   425,   653,  1190,   654,    -1,   453,   653,
    1190,   655,  1190,   654,    -1,   454,   653,  1190,   655,  1190,
     655,  1190,   654,    -1,   467,   653,  1190,   654,    -1,   477,
     653,   654,    -1,   582,   653,  1190,   655,  1190,   654,    -1,
     625,   653,  1190,   654,    -1,   625,   653,  1190,   655,  1190,
     654,    -1,   626,   653,  1190,  1017,   654,    -1,   626,   653,
    1190,    20,    62,  1007,  1017,   654,    -1,   626,   653,  1190,
      20,    36,  1007,   654,    -1,   626,   653,  1190,   655,  1316,
     655,  1316,   655,  1316,   654,    -1,  1208,    -1,    97,   653,
    1190,   655,  1190,   654,    -1,   206,   653,  1234,   654,    -1,
     280,   653,  1234,   654,    -1,   345,   653,  1234,   654,    -1,
     346,   653,  1234,   654,    -1,   347,   653,  1234,   654,    -1,
     408,   653,  1190,   655,  1190,   654,    -1,   409,   653,  1234,
     654,    -1,    -1,  1497,   653,  1210,  1214,   654,    -1,  1501,
     661,  1501,   653,  1233,   654,    -1,  1212,  1213,    -1,   253,
      45,   340,    -1,    -1,   253,   353,   265,   340,    -1,    -1,
     630,   426,   180,    -1,    -1,  1215,    -1,  1216,    -1,  1215,
     655,  1216,    -1,  1184,  1190,  1185,  1186,    -1,    30,   653,
    1229,   654,    -1,    30,   653,   146,  1229,   654,    -1,    39,
     653,  1229,   654,    -1,    40,   653,  1229,   654,    -1,    42,
     653,  1229,   654,    -1,   102,   653,  1291,   648,   654,    -1,
     102,   653,  1229,   654,    -1,    -1,    -1,   102,   653,   146,
    1218,  1234,  1219,   654,    -1,   339,   653,  1229,   654,    -1,
     339,   653,   146,  1229,   654,    -1,   322,   653,  1229,   654,
      -1,   322,   653,   146,  1229,   654,    -1,   536,   653,  1229,
     654,    -1,   617,   653,  1229,   654,    -1,   535,   653,  1229,
     654,    -1,   619,   653,  1229,   654,    -1,   547,   653,  1229,
     654,    -1,   547,   653,   146,  1229,   654,    -1,    -1,   214,
     653,  1224,  1220,  1234,  1226,  1225,   654,    -1,    -1,   660,
    1222,  1223,    -1,  1503,   494,  1190,    -1,  1503,    -1,   660,
    1525,  1503,  1051,    -1,    -1,   146,    -1,    -1,   487,  1480,
      -1,    -1,    -1,   386,    49,  1227,  1228,    -1,  1228,   655,
    1489,  1307,    -1,  1489,  1307,    -1,    -1,  1291,  1230,  1190,
      -1,    36,   986,    -1,    62,   986,  1005,    -1,   355,   986,
      -1,   251,    -1,   501,    -1,   501,   251,    -1,   599,    -1,
     599,   251,    -1,   122,    -1,   570,   986,    -1,   119,   986,
      -1,   130,   980,    -1,    -1,   148,  1232,   987,    -1,    -1,
    1234,    -1,  1190,    -1,  1234,   655,  1190,    -1,  1236,    -1,
     653,  1236,   654,    -1,  1490,    -1,  1236,   655,  1490,    -1,
      -1,  1190,    -1,    -1,   156,  1190,    -1,   627,  1190,   566,
    1190,    -1,  1239,   627,  1190,   566,  1190,    -1,  1255,    -1,
    1244,    -1,  1243,    -1,  1240,    -1,   657,  1501,  1240,   658,
      -1,  1242,    -1,  1243,   655,  1242,    -1,  1240,  1252,  1240,
      -1,    -1,  1240,  1252,  1240,   376,  1245,  1190,    -1,    -1,
    1240,  1252,  1240,   608,  1246,   653,  1285,   654,    -1,  1240,
     353,  1251,  1255,    -1,    -1,  1240,   272,  1271,   260,  1240,
     376,  1247,  1190,    -1,    -1,  1240,   272,  1271,   260,  1255,
    1248,   608,   653,  1285,   654,    -1,  1240,   353,   272,  1271,
     260,  1255,    -1,    -1,  1240,   469,  1271,   260,  1240,   376,
    1249,  1190,    -1,    -1,  1240,   469,  1271,   260,  1255,  1250,
     608,   653,  1285,   654,    -1,  1240,   353,   469,  1271,   260,
    1255,    -1,   260,    -1,   243,   260,    -1,   539,    -1,  1251,
      -1,   105,   260,    -1,    -1,  1254,    -1,   400,   653,  1285,
     654,   876,    -1,    -1,  1256,  1494,  1253,  1290,  1280,    -1,
    1270,  1269,  1266,    -1,   653,  1269,  1257,   654,  1290,    -1,
    1264,  1602,    -1,    -1,    -1,  1257,   595,  1606,  1258,  1607,
    1259,  1602,    -1,  1261,    -1,    -1,    -1,  1262,  1613,  1182,
    1263,   945,  1181,    -1,    -1,  1269,  1265,  1243,    -1,    -1,
      -1,  1267,  1178,  1182,  1268,   945,    -1,    -1,   485,    -1,
      -1,   389,    -1,    -1,   197,   260,    -1,   197,   386,    49,
      -1,   197,   213,    49,    -1,   195,    -1,   235,    -1,    -1,
    1273,  1027,  1272,  1275,   653,  1284,   654,    -1,    -1,   607,
    1027,  1272,  1276,   653,  1282,   654,    -1,  1274,    -1,  1277,
    1274,    -1,    -1,    -1,  1279,  1277,    -1,    -1,  1281,  1278,
      -1,    -1,  1284,    -1,  1501,    -1,   416,    -1,  1283,    -1,
    1284,   655,  1283,    -1,  1501,    -1,  1285,   655,  1501,    -1,
    1287,    -1,   123,    -1,   124,    -1,   125,    -1,   126,    -1,
     226,    -1,   227,    -1,   228,    -1,   335,    -1,   336,    -1,
     482,    -1,   640,    -1,   127,    -1,   625,    -1,   229,    -1,
     337,    -1,   344,    -1,   425,    -1,   483,    -1,   333,    -1,
     641,    -1,   122,    -1,   570,    -1,   119,    -1,   567,    -1,
      -1,    20,    -1,   166,    -1,    -1,  1289,  1501,    -1,    -1,
      13,    -1,    -1,    -1,   628,  1293,  1190,    -1,    -1,    -1,
     219,  1295,  1190,    -1,   171,  1204,    -1,    -1,    -1,   213,
      49,  1298,  1299,    -1,  1298,   655,  1489,  1307,    -1,  1489,
    1307,    -1,    -1,   631,    -1,   632,    -1,   386,    49,  1301,
      -1,  1301,   655,  1302,    -1,  1302,    -1,  1491,  1307,    -1,
      -1,  1304,    -1,    -1,   386,    49,  1305,  1306,    -1,  1306,
     655,  1489,  1307,    -1,  1489,  1307,    -1,    -1,    21,    -1,
     137,    -1,    -1,  1310,    -1,    -1,  1310,    -1,   277,  1311,
      -1,   277,  1311,   474,   176,  1313,    -1,   277,   474,   176,
    1313,    -1,  1312,    -1,  1312,   655,  1312,    -1,  1312,   374,
    1312,    -1,  1501,    -1,  1482,    -1,   586,    -1,   291,    -1,
     370,    -1,  1312,    -1,    -1,   277,  1312,    -1,   277,   474,
     176,    -1,   277,  1312,   474,   176,    -1,   370,    -1,   646,
     370,    -1,   646,   291,    -1,   370,    -1,   221,    -1,   291,
      -1,   586,    -1,   129,    -1,   192,    -1,   370,    -1,   221,
      -1,   291,    -1,   586,    -1,  1320,    -1,   370,    -1,   586,
      -1,   291,    -1,   129,    -1,   192,    -1,   370,    -1,   586,
      -1,   221,    -1,   291,    -1,  1320,    -1,  1321,    -1,   129,
      -1,   192,    -1,  1316,    -1,   132,    -1,    -1,    -1,   418,
    1501,  1324,   653,  1325,   654,    -1,    -1,  1326,    -1,  1326,
     655,  1327,    -1,  1327,    -1,  1184,  1190,  1185,    -1,    -1,
    1329,  1330,    -1,  1330,   655,  1331,    -1,  1331,    -1,   660,
    1503,    -1,  1503,    -1,    -1,   250,  1333,  1334,    -1,    -1,
      -1,   390,  1500,  1335,   996,  1336,  1464,  1467,    -1,   152,
    1500,    -1,  1328,    -1,    -1,   149,  1338,  1234,    -1,    -1,
     150,  1349,  1538,  1348,  1340,  1343,  1097,    -1,    -1,   150,
     239,  1348,  1501,   376,  1494,  1341,    -1,   150,   115,  1348,
    1501,    -1,   150,   202,  1348,  1501,   661,  1501,    -1,   150,
     202,  1348,  1501,    -1,   150,   418,  1348,   716,    -1,   150,
     604,   715,  1574,    -1,   150,   470,   715,  1558,    -1,    -1,
     150,   621,  1348,  1342,  1343,  1097,    -1,   150,   173,  1348,
     716,    -1,   150,   579,  1348,   716,    -1,   150,   554,   850,
     861,   862,    -1,   150,   287,   213,   851,   861,   862,    -1,
     150,   491,  1348,  1503,    -1,  1344,    -1,  1343,   655,  1344,
      -1,  1494,    -1,  1494,  1253,    -1,  1347,    -1,  1346,   655,
    1347,    -1,  1495,    -1,    -1,   234,   178,    -1,    -1,   560,
      -1,    -1,    -1,   246,  1351,  1356,  1091,  1358,  1352,  1360,
    1376,    -1,    -1,    -1,   454,  1354,  1357,  1358,  1355,  1360,
      -1,    -1,   294,    -1,   134,    -1,   223,    -1,  1385,    -1,
     134,    -1,   250,  1359,    -1,  1359,    -1,  1345,    -1,  1363,
      -1,   653,   654,  1363,    -1,   653,  1362,   654,  1363,    -1,
      -1,   493,  1361,  1367,    -1,  1362,   655,  1487,    -1,  1487,
      -1,   612,  1366,    -1,   613,  1366,    -1,    -1,   922,  1364,
    1598,    -1,    -1,   653,   922,   654,  1365,  1601,    -1,  1366,
     655,  1371,    -1,  1371,    -1,  1367,   655,  1368,    -1,  1368,
      -1,  1491,  1369,  1375,    -1,   166,    -1,   494,    -1,    -1,
    1369,    -1,    -1,   653,  1372,  1373,   654,    -1,    -1,  1374,
      -1,  1374,   655,  1375,    -1,  1375,    -1,  1190,    -1,   132,
      -1,    -1,    -1,   376,   153,  1377,   263,   601,  1383,    -1,
      -1,    -1,   601,  1379,  1385,  1091,  1241,   493,  1381,  1380,
    1292,  1303,  1314,    -1,  1381,   655,  1382,    -1,  1382,    -1,
    1491,  1369,  1375,    -1,  1383,   655,  1384,    -1,  1384,    -1,
    1491,  1369,  1375,    -1,    -1,   294,    -1,    -1,   136,  1387,
    1397,  1388,    -1,    -1,    -1,   199,  1494,  1253,  1389,  1292,
    1303,  1314,  1390,  1393,    -1,    -1,  1394,  1391,   199,  1241,
    1292,    -1,    -1,   199,  1346,  1392,   608,  1241,  1292,    -1,
      -1,   464,  1182,    -1,  1395,    -1,  1394,   655,  1395,    -1,
    1501,  1396,    -1,  1501,   661,  1501,  1396,    -1,    -1,   661,
     648,    -1,    -1,  1398,  1397,    -1,   427,    -1,   294,    -1,
     235,    -1,    -1,   582,  1401,  1400,  1344,    -1,    -1,   557,
      -1,    -1,  1403,    -1,  1404,    -1,  1403,   655,  1404,    -1,
     103,    -1,   330,    -1,    44,   254,    -1,    98,   551,    -1,
     394,   187,    -1,   255,    -1,   550,    -1,   513,    -1,    13,
      -1,    -1,   197,   426,   370,    -1,    -1,   498,  1407,  1408,
      -1,   116,  1419,    -1,  1415,   553,  1414,  1419,    -1,  1415,
     578,  1414,  1419,    -1,   172,  1414,  1419,    -1,   557,   534,
    1414,  1419,    -1,   380,   553,  1414,  1419,    -1,   406,    -1,
     406,   511,  1498,    -1,   406,   511,  1419,    -1,   164,   942,
    1411,    -1,   164,    13,  1411,    -1,  1415,    75,  1416,  1494,
    1414,  1419,    -1,  1412,   288,    -1,   503,   225,    -1,    -1,
      37,   172,  1417,  1418,  1409,  1308,    -1,    -1,   442,   687,
     172,  1417,  1418,  1410,  1308,    -1,  1029,  1416,  1494,  1414,
    1292,    -1,  1413,   163,    -1,    25,    -1,   100,    -1,   417,
      -1,   102,   653,   648,   654,   624,    -1,   102,   653,   648,
     654,   169,    -1,   624,  1308,    -1,   169,  1308,    -1,   422,
      -1,   421,  1402,  1405,  1308,    -1,  1524,   534,  1419,    -1,
    1415,   420,    -1,  1524,   616,  1419,    -1,   993,  1419,    -1,
      74,  1419,    -1,   212,    -1,   212,   197,  1505,    -1,   104,
     115,   932,  1501,    -1,   104,   557,  1494,    -1,   104,   621,
    1494,    -1,   313,   534,    -1,    13,   504,   534,    -1,   503,
     534,    -1,   503,   688,   534,    -1,    69,    -1,   605,    -1,
     556,    -1,   240,    -1,   104,   418,   716,    -1,   104,   202,
     716,    -1,   104,   579,   716,    -1,   418,   534,  1419,    -1,
     202,   534,  1419,    -1,   418,    72,   716,    -1,   202,    72,
     716,    -1,   104,   173,   716,    -1,  1424,   197,  1190,    -1,
     534,    -1,   348,    -1,   288,    -1,   313,    -1,    36,    -1,
      -1,   538,    -1,    -1,  1416,  1501,    -1,    -1,   200,    -1,
     199,    -1,   253,    -1,    -1,   253,  1498,    -1,    -1,   199,
    1318,    -1,    -1,   276,  1498,    -1,   628,  1190,    -1,    -1,
    1424,  1494,  1421,  1426,    -1,    -1,  1424,  1425,  1422,  1423,
      -1,  1167,    -1,  1350,    -1,  1353,    -1,  1378,    -1,  1386,
      -1,   137,    -1,   138,    -1,    -1,   182,    -1,   401,    -1,
      -1,  1480,    -1,  1501,    -1,    -1,   194,  1142,  1428,  1429,
      -1,    -1,  1538,  1430,  1436,  1431,    -1,  1434,    -1,    -1,
    1432,    -1,   630,   431,   286,  1437,    -1,    -1,   197,  1433,
     181,    -1,  1434,   655,  1435,    -1,  1435,    -1,   168,   288,
      -1,   164,   288,    -1,   204,   288,    -1,   506,   288,    -1,
      36,   288,    -1,   441,   288,   687,    -1,   426,    51,    -1,
     225,    -1,   417,    -1,   288,    -1,   534,    -1,   503,   687,
      -1,    69,    -1,   605,    -1,   556,    -1,   240,    -1,   313,
      -1,   139,    -1,   459,    -1,    -1,  1343,    -1,    -1,    18,
     143,    63,    -1,    -1,   457,  1439,  1440,    -1,  1440,   655,
    1441,    -1,  1441,    -1,    -1,   503,  1442,   687,  1443,    -1,
     313,    -1,   426,    51,    -1,    -1,    13,    -1,    -1,   424,
    1445,  1446,    -1,  1412,   288,  1447,    -1,   574,  1498,    -1,
      32,  1190,    -1,    -1,   264,  1449,  1450,  1451,  1452,    -1,
      -1,   217,    -1,   510,    -1,    -1,    91,    -1,   426,    -1,
     426,   230,    -1,  1190,    -1,   604,  1506,    -1,   499,    -1,
     607,  1501,    -1,    -1,    -1,    -1,    -1,   282,  1460,  1456,
    1462,  1461,   241,  1500,  1457,  1463,   250,   557,  1494,  1253,
    1458,   996,  1459,  1470,  1464,  1467,  1471,  1473,  1476,    -1,
     118,    -1,   638,    -1,    -1,   283,    -1,    -1,    89,    -1,
     294,    -1,    -1,   454,    -1,   235,    -1,    -1,    75,  1465,
      -1,  1465,  1466,    -1,  1466,    -1,   562,    49,  1480,    -1,
     384,   159,    49,  1480,    -1,   159,    49,  1480,    -1,   170,
      49,  1480,    -1,    -1,   279,  1468,    -1,  1468,  1469,    -1,
    1469,    -1,   562,    49,  1480,    -1,   528,    49,  1480,    -1,
      -1,   474,   232,    49,  1480,    -1,    -1,   235,   370,  1472,
      -1,   279,    -1,   474,    -1,    -1,   653,  1474,   654,    -1,
     653,   654,    -1,  1474,   655,  1475,    -1,  1475,    -1,  1491,
      -1,   660,  1503,    -1,    -1,   493,  1477,    -1,  1477,   655,
    1478,    -1,  1478,    -1,  1491,  1369,  1184,  1375,  1185,    -1,
     563,    -1,   354,    -1,   589,   563,    -1,  1479,  1499,    -1,
    1499,    -1,  1481,    -1,   221,    -1,   222,    -1,    38,    -1,
     396,    -1,  1484,    -1,   647,  1485,    -1,   646,  1485,    -1,
    1479,    -1,  1485,    -1,  1486,    -1,   369,    -1,   185,    -1,
     581,    -1,   221,    -1,   222,    -1,    38,    -1,   589,  1481,
      -1,   370,    -1,   291,    -1,   586,    -1,   129,    -1,   192,
      -1,   122,   563,    -1,   570,   563,    -1,   567,   563,    -1,
    1491,    -1,  1488,    -1,  1501,   661,   648,    -1,  1501,   661,
    1501,   661,   648,    -1,  1190,    -1,  1501,    -1,  1492,    -1,
    1501,    -1,  1492,    -1,  1501,   661,  1501,    -1,   661,  1501,
     661,  1501,    -1,  1501,   661,  1501,   661,  1501,    -1,  1501,
      -1,  1501,   661,  1501,   661,  1501,    -1,  1501,   661,  1501,
      -1,   661,  1501,    -1,  1501,    -1,  1501,   661,  1501,    -1,
     661,  1501,    -1,  1501,  1396,    -1,  1501,   661,  1501,  1396,
      -1,  1501,    -1,   231,    -1,   233,    -1,   563,    -1,   563,
      -1,   563,    -1,  1497,    -1,  1507,    -1,  1497,    -1,  1508,
      -1,  1501,    -1,  1498,    -1,   275,    -1,  1503,    -1,  1503,
     660,  1503,    -1,   109,  1189,    -1,  1504,    -1,  1559,    -1,
    1504,    -1,  1508,    -1,    22,    -1,    31,    -1,    33,    -1,
      50,    -1,    51,    -1,    61,    -1,    64,    -1,    63,    -1,
      70,    -1,    76,    -1,    77,    -1,    78,    -1,    79,    -1,
      80,    -1,    83,    -1,    85,    -1,    97,    -1,   128,    -1,
     149,    -1,   160,    -1,   176,    -1,   177,    -1,   194,    -1,
     209,    -1,   216,    -1,   220,    -1,   224,    -1,   248,    -1,
     265,    -1,   366,    -1,   380,    -1,   383,    -1,   382,    -1,
     392,    -1,   397,    -1,   410,    -1,   413,    -1,   448,    -1,
     451,    -1,   457,    -1,   460,    -1,   471,    -1,   479,    -1,
     484,    -1,   491,    -1,   499,    -1,   501,    -1,   509,    -1,
     503,    -1,   504,    -1,   511,    -1,   530,    -1,   537,    -1,
     582,    -1,   593,    -1,   594,    -1,   634,    -1,   637,    -1,
     602,    -1,     5,    -1,     8,    -1,     7,    -1,     9,    -1,
      10,    -1,    11,    -1,    12,    -1,    15,    -1,    19,    -1,
      24,    -1,    25,    -1,    27,    -1,    26,    -1,    28,    -1,
      29,    -1,    30,    -1,    37,    -1,    41,    -1,    44,    -1,
      46,    -1,    45,    -1,    48,    -1,    54,    -1,    57,    -1,
      58,    -1,    60,    -1,    66,    -1,    69,    -1,    68,    -1,
      67,    -1,    71,    -1,    72,    -1,    74,    -1,    82,    -1,
      75,    -1,    84,    -1,    86,    -1,    87,    -1,    88,    -1,
      89,    -1,    91,    -1,    92,    -1,    94,    -1,    96,    -1,
      95,    -1,    98,    -1,   100,    -1,   111,    -1,   103,    -1,
     106,    -1,   108,    -1,   113,    -1,   118,    -1,   117,    -1,
     119,    -1,   122,    -1,   127,    -1,   133,    -1,   135,    -1,
     139,    -1,   141,    -1,   142,    -1,   143,    -1,   144,    -1,
     145,    -1,   152,    -1,   153,    -1,   154,    -1,   161,    -1,
     165,    -1,   164,    -1,   163,    -1,   168,    -1,   169,    -1,
     171,    -1,   173,    -1,   172,    -1,   174,    -1,   175,    -1,
     180,    -1,   181,    -1,   182,    -1,   183,    -1,   187,    -1,
     186,    -1,   198,    -1,   158,    -1,   200,    -1,   189,    -1,
     190,    -1,   191,    -1,   204,    -1,   205,    -1,   207,    -1,
     206,    -1,   208,    -1,   212,    -1,   210,    -1,   218,    -1,
     217,    -1,   225,    -1,   229,    -1,   230,    -1,   232,    -1,
     236,    -1,   240,    -1,   252,    -1,   237,    -1,   238,    -1,
     242,    -1,   254,    -1,   255,    -1,   257,    -1,   258,    -1,
     247,    -1,   262,    -1,   267,    -1,   266,    -1,   270,    -1,
     273,    -1,   274,    -1,   280,    -1,   281,    -1,   283,    -1,
     285,    -1,   287,    -1,   288,    -1,   320,    -1,   313,    -1,
     316,    -1,   297,    -1,   298,    -1,   302,    -1,   299,    -1,
     300,    -1,   314,    -1,   315,    -1,   301,    -1,   303,    -1,
     296,    -1,   311,    -1,   305,    -1,   304,    -1,   306,    -1,
     307,    -1,   308,    -1,   309,    -1,   310,    -1,   318,    -1,
     319,    -1,   321,    -1,   323,    -1,   324,    -1,   329,    -1,
     330,    -1,   331,    -1,   332,    -1,   333,    -1,   334,    -1,
     337,    -1,   338,    -1,   342,    -1,   340,    -1,   344,    -1,
     345,    -1,   346,    -1,   347,    -1,   348,    -1,   349,    -1,
     351,    -1,   350,    -1,   352,    -1,   355,    -1,   356,    -1,
     360,    -1,   359,    -1,   367,    -1,   361,    -1,   362,    -1,
     371,    -1,   373,    -1,   374,    -1,   375,    -1,   377,    -1,
     379,    -1,   378,    -1,   393,    -1,   394,    -1,   399,    -1,
     402,    -1,   401,    -1,   403,    -1,   404,    -1,   405,    -1,
     407,    -1,   406,    -1,   408,    -1,   409,    -1,   414,    -1,
     415,    -1,   417,    -1,   419,    -1,   420,    -1,   421,    -1,
     422,    -1,   423,    -1,   425,    -1,   426,    -1,   427,    -1,
     430,    -1,   434,    -1,   435,    -1,   437,    -1,   436,    -1,
     438,    -1,   441,    -1,   442,    -1,   443,    -1,   444,    -1,
     445,    -1,   447,    -1,   450,    -1,   452,    -1,   455,    -1,
     459,    -1,   462,    -1,   463,    -1,   465,    -1,   467,    -1,
     470,    -1,   472,    -1,   473,    -1,   474,    -1,   477,    -1,
     475,    -1,   476,    -1,   478,    -1,   480,    -1,   481,    -1,
     483,    -1,   489,    -1,   488,    -1,   490,    -1,   502,    -1,
     495,    -1,   505,    -1,   506,    -1,   508,    -1,   510,    -1,
     512,    -1,   513,    -1,   521,    -1,   520,    -1,   523,    -1,
     526,    -1,   529,    -1,   534,    -1,   538,    -1,   540,    -1,
     541,    -1,   542,    -1,   543,    -1,   545,    -1,   544,    -1,
     548,    -1,   549,    -1,   550,    -1,   551,    -1,   559,    -1,
     556,    -1,   553,    -1,   558,    -1,   554,    -1,   560,    -1,
     561,    -1,   564,    -1,   565,    -1,   576,    -1,   577,    -1,
     578,    -1,   567,    -1,   568,    -1,   569,    -1,   570,    -1,
     583,    -1,   584,    -1,   585,    -1,   202,    -1,   587,    -1,
     588,    -1,   591,    -1,   590,    -1,   597,    -1,   600,    -1,
     604,    -1,   605,    -1,   606,    -1,   616,    -1,   621,    -1,
     622,    -1,   613,    -1,   624,    -1,   623,    -1,   625,    -1,
     626,    -1,   633,    -1,   636,    -1,   638,    -1,   641,    -1,
     620,    -1,    -1,   493,  1510,  1511,    -1,    -1,  1527,  1512,
    1517,    -1,    -1,   576,  1513,  1529,    -1,    -1,  1523,  1514,
    1515,    -1,    -1,  1526,  1516,  1517,    -1,   576,  1529,    -1,
      -1,   655,  1518,    -1,    -1,  1519,  1521,    -1,    -1,  1518,
     655,  1520,  1521,    -1,    -1,  1523,  1522,  1526,    -1,  1527,
      -1,   210,    -1,   283,    -1,   490,    -1,    -1,   210,    -1,
     283,    -1,   490,    -1,    -1,   210,   661,    -1,   283,   661,
      -1,   490,   661,    -1,  1528,  1369,  1535,    -1,  1528,  1369,
    1535,    -1,   660,  1503,  1369,  1190,    -1,   660,   660,  1525,
    1528,  1369,  1535,    -1,   993,   998,    -1,   350,  1369,  1190,
      -1,   350,   995,  1000,    -1,   470,  1503,    -1,   403,  1369,
    1534,    -1,   403,   197,  1506,  1369,  1534,    -1,  1501,    -1,
    1501,   661,  1501,    -1,   132,   661,  1501,    -1,  1530,    -1,
    1531,    -1,  1530,   655,  1531,    -1,  1531,   655,  1530,    -1,
    1532,    -1,   257,   274,  1533,    -1,   431,   378,    -1,   431,
     635,    -1,   431,   587,    -1,   431,    84,    -1,   452,   431,
      -1,   488,    -1,   563,    -1,   403,   653,   563,   654,    -1,
     375,   653,   563,   654,    -1,  1190,    -1,   132,    -1,   376,
      -1,    13,    -1,    36,    -1,    -1,   286,  1538,  1537,  1539,
      -1,   557,    -1,   553,    -1,  1540,    -1,  1539,   655,  1540,
      -1,  1494,  1290,  1541,    -1,   431,    -1,   635,    -1,   635,
      89,    -1,   294,   635,    -1,   431,   283,    -1,    -1,   598,
    1543,  1538,    -1,   216,  1494,   380,  1290,    -1,   216,  1496,
      70,    -1,    -1,   216,  1496,   431,  1545,  1546,  1292,  1309,
      -1,  1547,    -1,  1501,  1548,    -1,   190,    -1,   360,    -1,
     190,    -1,   360,    -1,   415,    -1,   266,    -1,    -1,  1550,
    1549,   653,  1374,   654,    -1,   166,    -1,   203,    -1,   268,
      -1,   215,    -1,   295,    -1,   468,   715,  1552,    -1,  1562,
     376,  1561,  1573,   199,  1576,    -1,  1562,   376,   202,  1573,
     199,  1576,    -1,  1562,   376,   418,  1573,   199,  1576,    -1,
      13,  1563,   655,   211,   383,   199,  1576,    -1,   423,   376,
    1506,   199,  1574,    -1,  1553,   199,  1576,    -1,     7,   383,
     197,  1560,    -1,  1560,    -1,   211,   715,  1555,    -1,  1562,
     376,  1561,  1573,   574,  1575,  1583,  1584,    -1,  1562,   376,
     202,  1573,   574,  1575,  1583,  1584,    -1,  1562,   376,   418,
    1573,   574,  1575,  1583,  1584,    -1,   423,   376,  1506,   574,
    1575,  1585,    -1,  1560,   574,  1575,  1557,    -1,    -1,   630,
       7,  1505,    -1,    -1,   630,     7,   383,    -1,  1560,    -1,
    1558,   655,  1560,    -1,   110,  1189,    -1,  1503,    -1,  1559,
      -1,    -1,   557,    -1,  1564,    -1,    13,  1563,    -1,    -1,
     417,    -1,  1565,    -1,  1564,   655,  1565,    -1,    -1,   485,
    1566,  1580,    -1,    -1,   246,  1567,  1580,    -1,    -1,   601,
    1568,  1580,    -1,    -1,   439,  1569,  1580,    -1,   136,    -1,
     603,    -1,   239,    -1,    14,    -1,   104,    -1,   150,    -1,
     177,    -1,   447,    -1,   499,    -1,   419,    -1,   189,    -1,
     211,   383,    -1,   498,   116,    -1,   548,    -1,   104,   560,
     553,    -1,   286,   553,    -1,   455,   503,    -1,   455,    68,
      -1,   104,   621,    -1,   498,   621,    -1,   104,   473,    -1,
      14,   473,    -1,   104,   604,    -1,   173,    -1,   579,    -1,
     104,   554,    -1,    -1,    18,    -1,  1572,  1570,  1571,    -1,
    1572,    -1,   543,   563,    -1,   258,   563,    -1,    66,   563,
      -1,   648,    -1,  1501,   661,   648,    -1,   648,   661,   648,
      -1,  1494,    -1,  1506,    -1,  1574,   655,  1506,    -1,  1579,
      -1,  1575,   655,  1579,    -1,  1505,    -1,  1576,   655,  1505,
      -1,   620,    -1,   630,    -1,   608,    -1,    20,    -1,  1506,
     232,    49,   563,    -1,  1506,   232,    49,   403,   563,    -1,
    1506,   232,  1577,  1503,    -1,  1506,   232,  1577,  1503,  1578,
    1498,    -1,  1505,    -1,    -1,   653,  1581,   654,    -1,  1581,
     655,  1582,    -1,  1582,    -1,  1501,    -1,    -1,   456,  1571,
      -1,   456,   527,    -1,   456,   636,    -1,   456,   362,    -1,
      -1,   630,  1586,    -1,    -1,   630,   211,   383,    -1,  1586,
    1587,    -1,  1587,    -1,   211,   383,    -1,   319,  1316,    -1,
     323,  1316,    -1,   318,  1316,    -1,   324,  1315,    -1,    -1,
      33,  1589,  1590,    -1,    -1,   633,    -1,    -1,    18,   366,
      58,    -1,    18,    58,    -1,    -1,   446,    -1,   366,   446,
      -1,    -1,   479,    -1,    85,  1590,  1591,  1592,    -1,   471,
    1590,  1591,  1592,    -1,   471,  1590,   574,  1593,  1501,    -1,
     479,  1501,    -1,   446,   479,  1501,    -1,    -1,  1599,    -1,
      -1,   595,  1606,  1600,  1168,    -1,    -1,  1599,    -1,  1603,
      -1,    -1,  1603,    -1,    -1,  1604,  1605,    -1,  1304,  1308,
      -1,  1310,    -1,    -1,   146,    -1,    13,    -1,   485,  1260,
      -1,   653,  1170,   654,    -1,  1607,  1602,    -1,    -1,  1608,
     595,  1606,  1609,  1607,  1602,    -1,  1611,  1608,  1612,    -1,
      -1,    -1,    -1,  1614,    -1,  1614,  1615,    -1,  1615,    -1,
     539,    -1,   223,    -1,   146,    -1,   524,    -1,   519,    -1,
     520,    -1,   522,    -1,    13,    -1,  1621,  1617,    -1,  1620,
    1618,    -1,  1622,  1619,  1624,    -1,  1624,    -1,  1632,    -1,
    1643,    -1,  1637,    -1,   702,    -1,  1624,    -1,  1632,    -1,
    1643,    -1,  1637,    -1,  1636,    -1,   702,    -1,  1620,    -1,
    1621,    -1,    -1,   133,   166,  1505,    -1,    12,   166,   588,
      -1,    12,   166,   331,    -1,    12,   166,   561,    -1,    -1,
     525,   484,   133,    -1,   525,   484,   252,    -1,    -1,  1623,
     621,  1494,  1625,  1626,    20,  1628,    -1,    -1,   653,  1627,
     654,    -1,  1501,    -1,  1627,   655,  1501,    -1,    -1,  1629,
    1630,  1631,    -1,   485,  1171,    -1,   653,  1169,   654,  1601,
      -1,    -1,   630,    65,   383,    -1,   630,    54,    65,   383,
      -1,   630,   283,    65,   383,    -1,    -1,    -1,    -1,   579,
    1184,   716,   821,   822,   376,  1184,  1633,  1494,   197,  1184,
    1634,   155,   476,  1635,   771,    -1,    11,  1184,   202,  1501,
     465,   946,   511,  1498,    -1,  1184,   202,  1501,   465,   946,
     511,  1498,    -1,    -1,    -1,    -1,    -1,    -1,  1184,   202,
     716,   653,  1638,   727,   654,  1639,   465,  1640,   991,  1641,
     718,  1642,   771,    -1,    -1,    -1,    -1,    -1,   418,  1184,
     716,  1644,   653,  1645,   731,   654,  1646,   718,  1647,   771,
      -1,   637,  1650,  1649,  1651,    -1,   637,   160,  1649,  1653,
      -1,   637,   413,  1649,    -1,   637,    85,  1649,  1652,    -1,
     637,   471,  1649,    -1,   637,   435,    -1,  1480,    -1,  1480,
     655,  1480,    -1,  1480,   655,  1480,   655,  1316,    -1,    33,
      -1,   530,    -1,    -1,   260,    -1,   462,    -1,    -1,   377,
     405,    -1,    -1,    -1,   549,  1654,  1655,    -1,    -1,   197,
     334,    -1,   248,   407,  1501,   511,  1498,    -1,   248,   511,
    1498,    -1,   594,   407,  1501,    -1,   594,   511,  1498,    -1,
     643,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1936,  1936,  1948,  1947,  1972,  1979,  1981,  1985,  1986,
    1991,  1992,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,
    2001,  2002,  2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,
    2011,  2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2049,  2058,  2059,  2063,  2072,
    2078,  2088,  2087,  2097,  2099,  2103,  2104,  2108,  2121,  2120,
    2140,  2139,  2148,  2149,  2153,  2157,  2161,  2165,  2169,  2173,
    2178,  2182,  2186,  2190,  2194,  2198,  2203,  2207,  2212,  2243,
    2248,  2251,  2253,  2254,  2258,  2264,  2268,  2284,  2288,  2294,
    2304,  2314,  2327,  2331,  2335,  2351,  2350,  2395,  2400,  2394,
    2407,  2412,  2405,  2419,  2424,  2417,  2430,  2429,  2442,  2441,
    2457,  2461,  2465,  2469,  2473,  2480,  2493,  2494,  2498,  2502,
    2506,  2510,  2514,  2518,  2522,  2530,  2529,  2560,  2559,  2566,
    2573,  2574,  2580,  2586,  2596,  2602,  2608,  2610,  2617,  2618,
    2622,  2628,  2637,  2638,  2646,  2646,  2702,  2703,  2704,  2705,
    2706,  2707,  2708,  2709,  2710,  2711,  2712,  2713,  2714,  2719,
    2733,  2749,  2767,  2768,  2772,  2773,  2778,  2780,  2782,  2784,
    2786,  2788,  2790,  2796,  2797,  2798,  2802,  2806,  2814,  2813,
    2826,  2828,  2831,  2833,  2837,  2841,  2848,  2850,  2854,  2855,
    2860,  2880,  2908,  2910,  2914,  2915,  2919,  2946,  2947,  2948,
    2949,  2953,  2954,  2958,  2959,  2964,  2967,  2994,  2993,  3057,
    3073,  3072,  3128,  3154,  3154,  3177,  3178,  3183,  3185,  3190,
    3212,  3223,  3227,  3249,  3250,  3254,  3258,  3267,  3273,  3279,
    3288,  3302,  3325,  3331,  3332,  3338,  3341,  3345,  3353,  3373,
    3375,  3393,  3399,  3401,  3403,  3405,  3407,  3409,  3411,  3413,
    3415,  3417,  3419,  3421,  3426,  3441,  3457,  3458,  3463,  3469,
    3478,  3484,  3493,  3501,  3510,  3519,  3521,  3530,  3535,  3541,
    3550,  3558,  3560,  3562,  3564,  3566,  3568,  3570,  3572,  3574,
    3576,  3578,  3580,  3582,  3587,  3605,  3626,  3627,  3631,  3632,
    3633,  3634,  3635,  3636,  3637,  3638,  3639,  3640,  3641,  3642,
    3643,  3648,  3647,  3654,  3654,  3709,  3708,  3737,  3737,  3752,
    3805,  3848,  3869,  3868,  3890,  3909,  3911,  3912,  3916,  3936,
    3959,  3961,  3977,  3959,  3996,  3998,  3999,  4003,  4004,  4009,
    4015,  4008,  4036,  4035,  4051,  4052,  4056,  4057,  4062,  4066,
    4061,  4087,  4091,  4086,  4110,  4120,  4125,  4124,  4159,  4160,
    4165,  4164,  4196,  4196,  4211,  4210,  4247,  4259,  4261,  4258,
    4288,  4287,  4308,  4310,  4315,  4317,  4319,  4336,  4341,  4347,
    4354,  4355,  4363,  4369,  4378,  4384,  4390,  4391,  4395,  4395,
    4400,  4401,  4402,  4406,  4407,  4408,  4412,  4416,  4417,  4418,
    4422,  4423,  4424,  4425,  4426,  4427,  4428,  4429,  4433,  4437,
    4438,  4439,  4443,  4444,  4445,  4446,  4447,  4451,  4455,  4456,
    4457,  4461,  4462,  4463,  4464,  4465,  4466,  4467,  4471,  4475,
    4476,  4477,  4481,  4482,  4483,  4488,  4496,  4504,  4512,  4524,
    4536,  4541,  4546,  4554,  4562,  4570,  4578,  4586,  4594,  4602,
    4615,  4628,  4641,  4643,  4647,  4652,  4665,  4666,  4718,  4717,
    4720,  4726,  4726,  4727,  4741,  4742,  4746,  4748,  4747,  4751,
    4750,  4756,  4793,  4794,  4799,  4798,  4817,  4836,  4835,  4852,
    4856,  4864,  4863,  4866,  4868,  4870,  4872,  4877,  4878,  4884,
    4885,  4902,  4903,  4907,  4908,  4912,  4931,  4941,  4952,  4961,
    4962,  4978,  4980,  4979,  4984,  4982,  4993,  4994,  4998,  5016,
    5032,  5033,  5049,  5064,  5086,  5087,  5092,  5091,  5115,  5125,
    5147,  5146,  5164,  5163,  5183,  5205,  5209,  5238,  5250,  5251,
    5256,  5267,  5255,  5292,  5293,  5297,  5310,  5331,  5344,  5370,
    5371,  5376,  5375,  5412,  5417,  5418,  5422,  5423,  5427,  5429,
    5435,  5441,  5443,  5445,  5447,  5449,  5451,  5461,  5476,  5460,
    5490,  5491,  5495,  5496,  5500,  5501,  5505,  5506,  5510,  5511,
    5515,  5516,  5520,  5525,  5529,  5537,  5541,  5547,  5549,  5553,
    5554,  5558,  5559,  5560,  5564,  5569,  5574,  5579,  5584,  5589,
    5594,  5599,  5614,  5620,  5635,  5640,  5655,  5661,  5679,  5684,
    5689,  5694,  5699,  5704,  5710,  5709,  5735,  5736,  5737,  5742,
    5747,  5752,  5754,  5756,  5758,  5764,  5769,  5774,  5780,  5786,
    5792,  5801,  5819,  5836,  5859,  5873,  5874,  5875,  5876,  5877,
    5878,  5879,  5883,  5884,  5885,  5889,  5890,  5894,  5895,  5896,
    5897,  5902,  5909,  5910,  5914,  5915,  5919,  5920,  5928,  5927,
    5936,  5934,  5944,  5942,  5952,  5950,  5958,  5979,  5985,  5987,
    5991,  5995,  5996,  6000,  6005,  6004,  6030,  6031,  6040,  6042,
    6047,  6050,  6054,  6061,  6062,  6066,  6067,  6071,  6077,  6083,
    6087,  6103,  6119,  6120,  6121,  6122,  6127,  6131,  6136,  6141,
    6145,  6150,  6155,  6161,  6166,  6172,  6176,  6181,  6186,  6204,
    6206,  6208,  6221,  6223,  6228,  6233,  6245,  6250,  6255,  6260,
    6262,  6264,  6266,  6268,  6270,  6272,  6274,  6277,  6276,  6281,
    6280,  6284,  6286,  6295,  6296,  6297,  6303,  6304,  6305,  6306,
    6307,  6311,  6315,  6316,  6320,  6321,  6325,  6326,  6327,  6328,
    6329,  6333,  6334,  6335,  6336,  6337,  6341,  6346,  6348,  6354,
    6355,  6357,  6362,  6371,  6372,  6376,  6377,  6381,  6382,  6383,
    6387,  6388,  6389,  6390,  6393,  6394,  6398,  6399,  6403,  6404,
    6408,  6409,  6413,  6414,  6415,  6416,  6423,  6424,  6430,  6436,
    6442,  6448,  6449,  6462,  6468,  6474,  6480,  6489,  6510,  6516,
    6521,  6522,  6526,  6534,  6538,  6539,  6543,  6544,  6548,  6557,
    6561,  6562,  6566,  6574,  6575,  6579,  6580,  6584,  6585,  6590,
    6591,  6595,  6602,  6611,  6616,  6624,  6625,  6626,  6627,  6628,
    6629,  6634,  6642,  6643,  6648,  6647,  6660,  6661,  6665,  6668,
    6669,  6670,  6671,  6675,  6683,  6690,  6691,  6695,  6705,  6706,
    6710,  6711,  6714,  6716,  6720,  6732,  6733,  6737,  6744,  6757,
    6758,  6760,  6762,  6768,  6773,  6779,  6785,  6792,  6802,  6803,
    6804,  6805,  6806,  6810,  6814,  6815,  6819,  6820,  6824,  6825,
    6829,  6830,  6831,  6835,  6836,  6840,  6844,  6857,  6869,  6870,
    6874,  6875,  6879,  6880,  6884,  6885,  6889,  6890,  6894,  6895,
    6899,  6900,  6904,  6905,  6909,  6911,  6912,  6918,  6924,  6930,
    6938,  6939,  6943,  6947,  6948,  6961,  6962,  6963,  6967,  6968,
    6972,  6978,  6992,  6993,  6997,  7009,  7010,  7014,  7015,  7023,
    7040,  7022,  7060,  7059,  7073,  7085,  7084,  7103,  7102,  7121,
    7120,  7139,  7133,  7153,  7152,  7185,  7190,  7195,  7200,  7205,
    7215,  7216,  7217,  7218,  7222,  7223,  7235,  7236,  7240,  7241,
    7244,  7246,  7254,  7262,  7264,  7266,  7267,  7275,  7276,  7280,
    7289,  7287,  7300,  7313,  7312,  7325,  7323,  7336,  7343,  7353,
    7354,  7381,  7388,  7392,  7397,  7396,  7412,  7414,  7419,  7427,
    7426,  7442,  7446,  7445,  7457,  7458,  7462,  7477,  7478,  7482,
    7491,  7495,  7500,  7506,  7505,  7517,  7528,  7516,  7544,  7553,
    7562,  7572,  7581,  7587,  7593,  7602,  7611,  7630,  7650,  7660,
    7664,  7669,  7670,  7673,  7675,  7676,  7677,  7678,  7681,  7686,
    7697,  7702,  7713,  7714,  7718,  7719,  7723,  7723,  7726,  7728,
    7732,  7733,  7737,  7738,  7746,  7747,  7748,  7752,  7753,  7758,
    7766,  7767,  7768,  7769,  7774,  7773,  7783,  7782,  7789,  7796,
    7806,  7823,  7826,  7833,  7837,  7844,  7848,  7852,  7859,  7859,
    7865,  7866,  7870,  7871,  7872,  7876,  7877,  7890,  7897,  7898,
    7903,  7902,  7914,  7915,  7916,  7921,  7920,  7941,  7942,  7946,
    7947,  7951,  7952,  7953,  7958,  7957,  7978,  7979,  7983,  7988,
    7989,  7996,  7998,  8002,  8004,  8003,  8015,  8017,  8016,  8029,
    8030,  8035,  8044,  8045,  8046,  8050,  8056,  8065,  8074,  8073,
    8099,  8100,  8104,  8105,  8109,  8110,  8111,  8112,  8113,  8114,
    8119,  8118,  8139,  8140,  8141,  8146,  8145,  8151,  8158,  8163,
    8171,  8172,  8176,  8190,  8189,  8202,  8203,  8207,  8208,  8212,
    8222,  8232,  8233,  8238,  8237,  8248,  8249,  8253,  8254,  8258,
    8268,  8279,  8278,  8286,  8286,  8295,  8296,  8301,  8302,  8311,
    8320,  8321,  8325,  8330,  8335,  8340,  8345,  8344,  8364,  8372,
    8364,  8379,  8380,  8381,  8382,  8383,  8387,  8394,  8401,  8403,
    8414,  8415,  8419,  8420,  8448,  8478,  8480,  8486,  8496,  8497,
    8498,  8512,  8517,  8542,  8548,  8554,  8555,  8556,  8557,  8558,
    8562,  8563,  8564,  8568,  8569,  8570,  8574,  8575,  8580,  8631,
    8638,  8681,  8687,  8693,  8699,  8705,  8711,  8717,  8723,  8727,
    8733,  8739,  8745,  8751,  8757,  8761,  8767,  8776,  8782,  8790,
    8796,  8806,  8812,  8821,  8831,  8837,  8847,  8853,  8862,  8866,
    8872,  8878,  8884,  8890,  8896,  8902,  8908,  8914,  8920,  8926,
    8932,  8938,  8944,  8950,  8954,  8955,  8959,  8960,  8964,  8965,
    8969,  8970,  8974,  8975,  8976,  8977,  8978,  8979,  8983,  8984,
    8989,  8995,  8999,  9006,  9013,  9020,  9027,  9034,  9039,  9045,
    9052,  9059,  9067,  9078,  9100,  9107,  9115,  9116,  9117,  9118,
    9119,  9120,  9131,  9132,  9133,  9134,  9135,  9141,  9145,  9151,
    9157,  9163,  9169,  9171,  9178,  9185,  9191,  9215,  9224,  9231,
    9239,  9245,  9252,  9258,  9272,  9279,  9295,  9301,  9307,  9315,
    9323,  9329,  9335,  9341,  9347,  9361,  9372,  9378,  9384,  9390,
    9396,  9402,  9408,  9414,  9420,  9426,  9432,  9438,  9444,  9450,
    9456,  9462,  9468,  9476,  9497,  9504,  9510,  9517,  9524,  9531,
    9538,  9544,  9550,  9557,  9563,  9570,  9576,  9582,  9588,  9594,
    9600,  9618,  9624,  9630,  9637,  9644,  9652,  9659,  9666,  9673,
    9680,  9697,  9703,  9709,  9715,  9721,  9728,  9734,  9740,  9746,
    9752,  9758,  9769,  9775,  9781,  9787,  9793,  9801,  9807,  9818,
    9824,  9830,  9838,  9848,  9854,  9870,  9876,  9883,  9890,  9897,
    9904,  9911,  9915,  9935,  9934, 10006, 10047, 10049, 10054, 10055,
   10059, 10060, 10064, 10065, 10069, 10076, 10084, 10110, 10116, 10122,
   10128, 10134, 10140, 10149, 10156, 10158, 10155, 10165, 10176, 10182,
   10188, 10194, 10200, 10206, 10212, 10218, 10224, 10231, 10230, 10250,
   10249, 10264, 10274, 10282, 10298, 10299, 10304, 10309, 10312, 10315,
   10314, 10331, 10333, 10339, 10338, 10355, 10357, 10359, 10361, 10363,
   10365, 10367, 10369, 10371, 10373, 10379, 10385, 10388, 10387, 10393,
   10394, 10398, 10405, 10413, 10414, 10418, 10425, 10433, 10434, 10438,
   10439, 10443, 10451, 10462, 10463, 10475, 10486, 10487, 10493, 10494,
   10514, 10518, 10516, 10534, 10532, 10543, 10553, 10551, 10569, 10568,
   10578, 10589, 10587, 10606, 10605, 10616, 10628, 10629, 10630, 10634,
   10635, 10643, 10644, 10648, 10663, 10663, 10678, 10718, 10794, 10805,
   10810, 10802, 10829, 10849, 10857, 10849, 10866, 10865, 10888, 10905,
   10888, 10912, 10916, 10942, 10943, 10948, 10951, 10952, 10953, 10957,
   10958, 10963, 10962, 10968, 10967, 10975, 10976, 10979, 10981, 10981,
   10985, 10985, 10990, 10991, 10995, 10997, 11002, 11003, 11007, 11018,
   11031, 11032, 11033, 11034, 11035, 11036, 11037, 11038, 11039, 11040,
   11041, 11042, 11046, 11047, 11048, 11049, 11050, 11051, 11052, 11053,
   11054, 11058, 11059, 11060, 11061, 11064, 11066, 11067, 11071, 11072,
   11080, 11082, 11086, 11088, 11087, 11101, 11104, 11103, 11118, 11124,
   11138, 11140, 11144, 11146, 11151, 11152, 11172, 11197, 11201, 11202,
   11206, 11218, 11220, 11225, 11224, 11259, 11261, 11266, 11267, 11268,
   11273, 11280, 11284, 11285, 11289, 11296, 11300, 11307, 11314, 11321,
   11331, 11364, 11368, 11374, 11380, 11389, 11397, 11401, 11408, 11409,
   11413, 11414, 11415, 11419, 11420, 11421, 11422, 11423, 11424, 11428,
   11429, 11430, 11431, 11432, 11436, 11437, 11438, 11439, 11440, 11444,
   11445, 11446, 11447, 11448, 11452, 11457, 11458, 11462, 11463, 11466,
   11469, 11468, 11499, 11500, 11504, 11505, 11509, 11519, 11519, 11529,
   11530, 11534, 11553, 11586, 11585, 11598, 11606, 11597, 11608, 11620,
   11632, 11631, 11649, 11648, 11659, 11659, 11675, 11682, 11704, 11724,
   11736, 11740, 11745, 11744, 11754, 11760, 11767, 11772, 11777, 11787,
   11788, 11792, 11803, 11816, 11817, 11821, 11833, 11837, 11845, 11846,
   11854, 11862, 11853, 11872, 11879, 11871, 11889, 11897, 11898, 11906,
   11910, 11911, 11922, 11923, 11927, 11936, 11937, 11938, 11940, 11939,
   11950, 11951, 11955, 11956, 11958, 11957, 11961, 11960, 11966, 11967,
   11971, 11972, 11976, 11986, 11987, 11991, 11992, 11997, 11996, 12010,
   12011, 12015, 12020, 12028, 12029, 12037, 12039, 12039, 12047, 12055,
   12046, 12077, 12078, 12082, 12090, 12091, 12095, 12105, 12106, 12113,
   12112, 12128, 12139, 12127, 12142, 12141, 12153, 12152, 12165, 12167,
   12171, 12172, 12176, 12189, 12205, 12206, 12210, 12211, 12215, 12216,
   12217, 12222, 12221, 12242, 12244, 12247, 12249, 12252, 12253, 12256,
   12260, 12264, 12268, 12272, 12276, 12280, 12284, 12288, 12296, 12299,
   12309, 12308, 12324, 12331, 12339, 12347, 12355, 12363, 12371, 12378,
   12385, 12391, 12393, 12395, 12404, 12408, 12413, 12412, 12418, 12417,
   12422, 12431, 12438, 12443, 12448, 12453, 12455, 12457, 12459, 12461,
   12463, 12470, 12478, 12480, 12488, 12495, 12502, 12509, 12515, 12521,
   12530, 12538, 12542, 12547, 12554, 12559, 12566, 12573, 12580, 12587,
   12594, 12601, 12607, 12614, 12621, 12626, 12631, 12636, 12646, 12648,
   12650, 12655, 12656, 12659, 12661, 12665, 12666, 12670, 12671, 12675,
   12676, 12680, 12681, 12685, 12686, 12689, 12691, 12698, 12709, 12708,
   12724, 12723, 12733, 12734, 12735, 12736, 12737, 12741, 12742, 12746,
   12747, 12748, 12752, 12753, 12754, 12769, 12768, 12781, 12780, 12791,
   12795, 12796, 12809, 12812, 12811, 12823, 12824, 12829, 12831, 12833,
   12835, 12837, 12839, 12850, 12852, 12854, 12856, 12862, 12864, 12875,
   12877, 12879, 12881, 12883, 12885, 12887, 12892, 12893, 12897, 12898,
   12902, 12901, 12911, 12912, 12916, 12916, 12919, 12920, 12924, 12925,
   12930, 12929, 12940, 12944, 12948, 12961, 12960, 12975, 12976, 12977,
   12980, 12981, 12982, 12983, 12991, 12995, 13004, 13010, 13022, 13033,
   13043, 13053, 13021, 13061, 13062, 13066, 13067, 13071, 13072, 13080,
   13084, 13085, 13086, 13089, 13091, 13095, 13096, 13100, 13105, 13112,
   13117, 13124, 13126, 13130, 13131, 13135, 13140, 13148, 13149, 13152,
   13154, 13162, 13164, 13168, 13169, 13170, 13174, 13176, 13181, 13182,
   13191, 13192, 13196, 13197, 13201, 13214, 13237, 13249, 13256, 13275,
   13283, 13288, 13300, 13308, 13323, 13343, 13344, 13345, 13353, 13354,
   13355, 13356, 13363, 13369, 13375, 13381, 13387, 13393, 13405, 13415,
   13425, 13431, 13440, 13452, 13458, 13464, 13480, 13481, 13485, 13494,
   13509, 13513, 13559, 13563, 13580, 13584, 13662, 13686, 13716, 13717,
   13733, 13743, 13747, 13753, 13759, 13769, 13775, 13784, 13794, 13795,
   13823, 13837, 13851, 13866, 13867, 13877, 13878, 13888, 13889, 13890,
   13894, 13909, 13941, 13951, 13951, 13953, 13963, 13964, 13965, 13966,
   13967, 13968, 13969, 13970, 13971, 13972, 13973, 13974, 13975, 13976,
   13977, 13978, 13979, 13980, 13981, 13982, 13983, 13984, 13985, 13986,
   13987, 13988, 13989, 13990, 13991, 13992, 13993, 13994, 13995, 13996,
   13997, 13998, 13999, 14000, 14001, 14002, 14003, 14004, 14005, 14006,
   14007, 14008, 14009, 14010, 14011, 14012, 14013, 14014, 14015, 14016,
   14017, 14018, 14019, 14020, 14021, 14022, 14032, 14033, 14034, 14035,
   14036, 14037, 14038, 14039, 14040, 14041, 14042, 14043, 14044, 14045,
   14046, 14047, 14048, 14049, 14050, 14051, 14052, 14053, 14054, 14055,
   14056, 14057, 14058, 14059, 14060, 14061, 14062, 14063, 14064, 14065,
   14066, 14067, 14068, 14069, 14070, 14071, 14072, 14073, 14074, 14075,
   14076, 14077, 14078, 14079, 14080, 14081, 14086, 14087, 14088, 14089,
   14090, 14091, 14092, 14093, 14094, 14095, 14096, 14097, 14098, 14099,
   14100, 14101, 14102, 14103, 14104, 14105, 14106, 14107, 14108, 14109,
   14110, 14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118, 14119,
   14120, 14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128, 14129,
   14130, 14131, 14132, 14133, 14134, 14135, 14136, 14137, 14138, 14139,
   14140, 14141, 14142, 14143, 14144, 14145, 14146, 14147, 14148, 14149,
   14150, 14151, 14152, 14153, 14154, 14155, 14156, 14157, 14158, 14159,
   14160, 14161, 14162, 14163, 14164, 14165, 14166, 14167, 14168, 14169,
   14170, 14171, 14172, 14173, 14174, 14175, 14176, 14177, 14178, 14179,
   14180, 14181, 14182, 14183, 14184, 14185, 14186, 14187, 14188, 14189,
   14190, 14191, 14192, 14193, 14194, 14195, 14196, 14197, 14198, 14199,
   14200, 14201, 14202, 14203, 14204, 14205, 14206, 14207, 14208, 14209,
   14210, 14211, 14212, 14213, 14214, 14215, 14216, 14217, 14218, 14219,
   14220, 14221, 14222, 14223, 14224, 14225, 14226, 14227, 14228, 14229,
   14230, 14231, 14232, 14233, 14234, 14235, 14236, 14237, 14238, 14239,
   14240, 14241, 14242, 14243, 14244, 14245, 14246, 14247, 14248, 14249,
   14250, 14251, 14252, 14253, 14254, 14255, 14256, 14257, 14258, 14259,
   14260, 14261, 14262, 14263, 14264, 14265, 14266, 14267, 14268, 14269,
   14270, 14271, 14272, 14273, 14274, 14275, 14276, 14277, 14278, 14279,
   14280, 14281, 14282, 14283, 14284, 14285, 14286, 14287, 14288, 14289,
   14290, 14291, 14292, 14293, 14294, 14295, 14296, 14297, 14298, 14299,
   14300, 14301, 14302, 14303, 14304, 14305, 14306, 14307, 14308, 14309,
   14310, 14311, 14312, 14313, 14314, 14315, 14316, 14317, 14318, 14319,
   14320, 14321, 14322, 14323, 14324, 14325, 14326, 14327, 14328, 14329,
   14330, 14331, 14332, 14333, 14334, 14335, 14336, 14337, 14338, 14339,
   14340, 14341, 14342, 14343, 14344, 14345, 14357, 14356, 14374, 14373,
   14380, 14379, 14389, 14388, 14399, 14398, 14404, 14412, 14414, 14419,
   14419, 14428, 14427, 14441, 14440, 14445, 14449, 14450, 14451, 14455,
   14456, 14457, 14458, 14462, 14463, 14464, 14465, 14470, 14494, 14520,
   14531, 14543, 14556, 14571, 14590, 14596, 14621, 14634, 14660, 14703,
   14717, 14718, 14719, 14720, 14724, 14741, 14758, 14759, 14763, 14764,
   14765, 14766, 14770, 14771, 14780, 14791, 14792, 14793, 14799, 14805,
   14817, 14816, 14832, 14833, 14837, 14838, 14842, 14857, 14858, 14859,
   14864, 14865, 14870, 14869, 14889, 14901, 14914, 14913, 14947, 14948,
   14952, 14953, 14957, 14958, 14959, 14960, 14962, 14961, 14974, 14975,
   14976, 14977, 14978, 14984, 14989, 14995, 15006, 15017, 15021, 15028,
   15037, 15039, 15044, 15049, 15056, 15068, 15080, 15087, 15099, 15100,
   15103, 15104, 15107, 15112, 15120, 15131, 15151, 15154, 15156, 15160,
   15161, 15168, 15170, 15174, 15175, 15180, 15179, 15183, 15182, 15186,
   15185, 15189, 15188, 15191, 15192, 15193, 15194, 15195, 15196, 15197,
   15198, 15199, 15200, 15201, 15202, 15203, 15204, 15205, 15206, 15207,
   15208, 15209, 15210, 15211, 15212, 15213, 15214, 15215, 15216, 15220,
   15221, 15225, 15226, 15230, 15240, 15250, 15263, 15278, 15291, 15304,
   15316, 15321, 15329, 15334, 15342, 15347, 15354, 15354, 15355, 15355,
   15358, 15387, 15392, 15398, 15404, 15410, 15414, 15418, 15419, 15423,
   15450, 15452, 15456, 15460, 15464, 15471, 15472, 15476, 15477, 15481,
   15482, 15486, 15487, 15493, 15499, 15505, 15515, 15514, 15524, 15525,
   15530, 15531, 15532, 15537, 15538, 15539, 15543, 15544, 15548, 15560,
   15569, 15579, 15588, 15602, 15603, 15608, 15607, 15623, 15624, 15625,
   15629, 15630, 15634, 15634, 15656, 15657, 15661, 15662, 15663, 15667,
   15671, 15678, 15681, 15679, 15695, 15702, 15723, 15740, 15742, 15746,
   15747, 15751, 15752, 15760, 15761, 15762, 15763, 15769, 15775, 15785,
   15787, 15789, 15794, 15795, 15796, 15797, 15798, 15802, 15803, 15804,
   15805, 15806, 15807, 15817, 15818, 15823, 15836, 15849, 15851, 15853,
   15859, 15860, 15862, 15868, 15867, 15884, 15885, 15889, 15894, 15902,
   15902, 15926, 15927, 15932, 15933, 15935, 15937, 15955, 15961, 15966,
   15948, 16027, 16044, 16068, 16099, 16103, 16112, 16135, 16064, 16198,
   16222, 16231, 16238, 16197, 16258, 16262, 16266, 16270, 16274, 16278,
   16285, 16292, 16299, 16309, 16310, 16314, 16315, 16316, 16320, 16321,
   16326, 16328, 16327, 16333, 16334, 16338, 16345, 16355, 16361, 16372
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY",
  "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "ONLINE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM", "PARTIAL",
  "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD",
  "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM",
  "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM",
  "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNED_SQLSTATE_SYM", "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM",
  "REVERSE_SYM", "REVOKE", "RIGHT", "ROLE_SYM", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "ROW_COUNT_SYM", "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM",
  "SCHEMA_NAME_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM",
  "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM",
  "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNAL_SYM", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SLAVES", "SLAVE_POS_SYM", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM",
  "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM",
  "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_STATS_SYM",
  "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY",
  "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM",
  "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM",
  "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@67", "$@68", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@69", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@70", "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@78", "$@79", "$@80",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@81", "add_part_extra", "reorg_partition_rule", "$@82",
  "reorg_parts_rule", "$@83", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@84", "$@85", "$@86",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@87",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@88", "$@89", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@90",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@91", "opt_checksum_type", "repair",
  "$@92", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@93", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@94", "persistent_index_stat_spec",
  "$@95", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check", "$@96", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "$@97",
  "opt_no_write_to_binlog", "rename", "$@98", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@99",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@100",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@101", "cache_keys_spec",
  "$@102", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "select_init", "select_paren", "select_paren_derived", "select_init2",
  "$@103", "select_part2", "$@104", "$@105", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_default_time_precision",
  "opt_time_precision", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "not2", "comp_op", "all_or_any",
  "opt_dyncol_type", "dyncol_type", "dyncall_create_element",
  "dyncall_create_list", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@106", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@107", "$@108", "$@109",
  "variable", "$@110", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@111", "gorder_list",
  "in_sum_expr", "$@112", "cast_type", "$@113", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "$@114", "$@115", "$@116", "$@117",
  "$@118", "$@119", "inner_join", "normal_join", "opt_use_partition",
  "use_partition", "table_factor", "$@120", "select_derived_union",
  "$@121", "$@122", "select_init2_derived", "select_part2_derived",
  "$@123", "$@124", "select_derived", "$@125", "select_derived2", "$@126",
  "$@127", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@128",
  "$@129", "index_hints_list", "opt_index_hints_list", "$@130",
  "opt_key_definition", "$@131", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@132", "having_clause", "$@133", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@134", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@135", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@136",
  "select_var_list", "select_var_ident", "into", "$@137",
  "into_destination", "$@138", "$@139", "do", "$@140", "drop", "$@141",
  "$@142", "$@143", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@144",
  "$@145", "replace", "$@146", "$@147", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@148", "fields", "insert_values", "$@149", "$@150", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@151", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@152", "update", "$@153", "$@154", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@155", "single_multi", "$@156", "$@157", "$@158", "$@159",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@160", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@161", "show_param",
  "$@162", "$@163", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@164", "$@165", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@166", "flush_options", "$@167", "opt_flush_lock",
  "flush_lock", "$@168", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@169",
  "reset_options", "reset_option", "$@170", "slave_reset_options", "purge",
  "$@171", "purge_options", "purge_option", "kill", "$@172", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@173", "$@174",
  "$@175", "$@176", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "hex_or_bin_String", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user_maybe_role",
  "user_or_role", "user", "keyword", "keyword_sp", "set", "$@177",
  "start_option_value_list", "$@178", "$@179", "$@180",
  "start_option_value_list_following_option_type", "$@181",
  "option_value_list_continued", "option_value_list", "$@182", "$@183",
  "option_value", "$@184", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@185",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@186", "handler", "$@187", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@188",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@189", "$@190", "$@191", "$@192", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@193", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@194",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@195",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@196", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@197", "view_list_opt", "view_list", "view_select",
  "$@198", "view_select_aux", "view_check_option", "trigger_tail", "$@199",
  "$@200", "$@201", "udf_tail", "sf_tail", "$@202", "$@203", "$@204",
  "$@205", "$@206", "sp_tail", "$@207", "$@208", "$@209", "$@210", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@211", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   124,    38,    45,    43,    42,    47,
      37,    94,   126,    40,    41,    44,    33,   123,   125,    59,
      64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   663,   664,   665,   664,   664,   666,   666,   667,   667,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   668,   668,   668,   668,   669,   670,   670,   671,   672,
     672,   674,   673,   675,   675,   676,   676,   677,   679,   678,
     681,   680,   682,   682,   683,   683,   683,   683,   683,   683,
     683,   683,   683,   683,   683,   683,   683,   683,   683,   683,
     683,   684,   684,   684,   685,   686,   686,   686,   686,   686,
     686,   686,   687,   687,   688,   690,   689,   691,   692,   689,
     693,   694,   689,   695,   696,   689,   697,   689,   698,   689,
     689,   689,   689,   689,   689,   699,   700,   700,   701,   701,
     701,   701,   701,   701,   701,   703,   702,   705,   704,   704,
     706,   706,   706,   706,   707,   707,   708,   708,   709,   709,
     710,   710,   711,   711,   713,   712,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   715,
     716,   716,   717,   717,   718,   718,   719,   719,   719,   719,
     719,   719,   719,   720,   720,   720,   721,   721,   723,   722,
     724,   724,   725,   725,   726,   726,   727,   727,   728,   728,
     729,   730,   731,   731,   732,   732,   733,   734,   734,   734,
     734,   735,   735,   736,   736,   737,   737,   739,   738,   738,
     740,   738,   738,   742,   741,   743,   743,   744,   744,   745,
     746,   746,   747,   748,   748,   749,   749,   749,   749,   749,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     755,   755,   756,   756,   756,   756,   756,   756,   756,   756,
     756,   756,   756,   756,   757,   758,   759,   759,   760,   760,
     761,   761,   762,   763,   763,   764,   764,   765,   766,   766,
     767,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   769,   769,   770,   770,   771,   771,
     771,   771,   771,   771,   771,   771,   771,   771,   771,   771,
     771,   773,   772,   775,   774,   777,   776,   779,   778,   780,
     781,   782,   784,   783,   785,   786,   786,   786,   787,   787,
     789,   790,   791,   788,   792,   792,   792,   793,   793,   795,
     796,   794,   798,   797,   799,   799,   800,   800,   802,   803,
     801,   805,   806,   804,   807,   807,   809,   808,   810,   810,
     812,   811,   814,   813,   816,   815,   817,   818,   819,   817,
     820,   817,   821,   821,   822,   822,   822,   823,   824,   825,
     826,   826,   827,   827,   828,   829,   830,   830,   832,   831,
     833,   833,   833,   834,   834,   834,   835,   836,   836,   836,
     837,   837,   837,   837,   837,   837,   837,   837,   838,   839,
     839,   839,   840,   840,   840,   840,   840,   841,   842,   842,
     842,   843,   843,   843,   843,   843,   843,   843,   844,   845,
     845,   845,   846,   846,   846,   847,   848,   849,   850,   851,
     852,   852,   852,   853,   854,   855,   856,   857,   858,   859,
     860,   861,   862,   862,   863,   863,   864,   864,   866,   865,
     865,   867,   865,   865,   868,   868,   869,   870,   869,   871,
     869,   872,   873,   873,   875,   874,   876,   878,   877,   879,
     880,   881,   880,   880,   880,   880,   880,   882,   882,   883,
     883,   884,   884,   885,   885,   886,   887,   888,   889,   890,
     890,   891,   892,   891,   893,   891,   894,   894,   895,   896,
     897,   897,   898,   898,   899,   899,   901,   900,   902,   903,
     904,   903,   905,   903,   906,   906,   907,   907,   908,   908,
     910,   911,   909,   912,   912,   913,   913,   914,   914,   915,
     915,   917,   916,   918,   919,   919,   920,   920,   921,   921,
     921,   921,   921,   921,   921,   921,   921,   923,   924,   922,
     925,   925,   926,   926,   927,   927,   928,   928,   929,   929,
     930,   930,   931,   932,   932,   933,   933,   934,   934,   935,
     935,   936,   936,   936,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   938,   937,   937,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   937,   937,   937,   937,
     937,   939,   940,   941,   942,   943,   943,   943,   943,   943,
     943,   943,   944,   944,   944,   945,   945,   946,   946,   946,
     946,   947,   948,   948,   949,   949,   950,   950,   952,   951,
     953,   951,   954,   951,   955,   951,   951,   951,   956,   956,
     957,   958,   958,   959,   961,   960,   962,   962,   963,   963,
     964,   964,   964,   965,   965,   966,   966,   967,   967,   967,
     968,   969,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   970,   970,   970,
     970,   970,   970,   970,   970,   970,   970,   971,   970,   972,
     970,   970,   970,   973,   973,   973,   973,   973,   973,   973,
     973,   974,   975,   975,   976,   976,   977,   977,   977,   977,
     977,   978,   978,   978,   978,   978,   979,   979,   979,   980,
     980,   980,   981,   982,   982,   983,   983,   984,   984,   984,
     985,   985,   985,   985,   986,   986,   987,   987,   988,   988,
     989,   989,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   991,   992,   992,
     993,   993,   994,   994,   995,   995,   996,   996,   997,   997,
     998,   998,   999,  1000,  1000,  1001,  1001,  1002,  1002,  1003,
    1003,  1003,  1004,  1004,  1004,  1005,  1005,  1005,  1005,  1005,
    1005,  1005,  1006,  1006,  1008,  1007,  1009,  1009,  1010,  1011,
    1011,  1011,  1011,  1012,  1013,  1014,  1014,  1015,  1016,  1016,
    1017,  1017,  1018,  1018,  1019,  1020,  1020,  1021,  1021,  1022,
    1022,  1022,  1022,  1023,  1023,  1023,  1023,  1023,  1024,  1024,
    1024,  1024,  1024,  1025,  1026,  1026,  1027,  1027,  1028,  1028,
    1029,  1029,  1029,  1030,  1030,  1031,  1032,  1033,  1034,  1034,
    1035,  1035,  1036,  1036,  1037,  1037,  1038,  1038,  1039,  1039,
    1040,  1040,  1041,  1041,  1042,  1042,  1042,  1042,  1042,  1042,
    1043,  1043,  1044,  1045,  1045,  1046,  1046,  1046,  1047,  1047,
    1048,  1048,  1049,  1049,  1050,  1051,  1051,  1052,  1052,  1054,
    1055,  1053,  1056,  1053,  1053,  1057,  1053,  1058,  1053,  1059,
    1053,  1060,  1053,  1061,  1053,  1053,  1053,  1053,  1053,  1053,
    1062,  1062,  1062,  1062,  1063,  1063,  1064,  1064,  1065,  1065,
    1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,  1066,
    1067,  1066,  1066,  1068,  1066,  1069,  1066,  1066,  1066,  1066,
    1066,  1070,  1071,  1071,  1073,  1072,  1074,  1074,  1074,  1076,
    1075,  1077,  1078,  1077,  1079,  1079,  1080,  1081,  1081,  1082,
    1083,  1083,  1083,  1084,  1083,  1085,  1086,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1087,  1087,  1087,  1087,  1087,  1088,  1088,
    1089,  1089,  1090,  1090,  1091,  1091,  1093,  1092,  1094,  1094,
    1095,  1095,  1096,  1096,  1097,  1097,  1097,  1098,  1098,  1098,
    1099,  1099,  1099,  1099,  1101,  1100,  1102,  1100,  1100,  1100,
    1103,  1104,  1104,  1105,  1105,  1106,  1106,  1106,  1108,  1107,
    1109,  1109,  1110,  1110,  1110,  1111,  1111,  1111,  1112,  1112,
    1114,  1113,  1115,  1115,  1115,  1117,  1116,  1118,  1118,  1119,
    1119,  1120,  1120,  1120,  1122,  1121,  1123,  1123,  1124,  1125,
    1125,  1126,  1126,  1127,  1128,  1127,  1129,  1130,  1129,  1131,
    1131,  1131,  1132,  1132,  1132,  1133,  1133,  1134,  1136,  1135,
    1137,  1137,  1138,  1138,  1139,  1139,  1139,  1139,  1139,  1139,
    1141,  1140,  1142,  1142,  1142,  1144,  1143,  1143,  1145,  1145,
    1146,  1146,  1147,  1149,  1148,  1150,  1150,  1151,  1151,  1152,
    1153,  1154,  1154,  1156,  1155,  1157,  1157,  1158,  1158,  1159,
    1160,  1162,  1161,  1164,  1163,  1165,  1165,  1166,  1166,  1167,
    1168,  1168,  1169,  1169,  1170,  1170,  1172,  1171,  1174,  1175,
    1173,  1176,  1176,  1176,  1176,  1176,  1177,  1177,  1178,  1178,
    1179,  1179,  1180,  1180,  1180,  1181,  1181,  1181,  1182,  1182,
    1182,  1183,  1183,  1184,  1185,  1186,  1186,  1186,  1186,  1186,
    1187,  1187,  1187,  1188,  1188,  1188,  1189,  1189,  1190,  1190,
    1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1190,  1191,
    1191,  1191,  1191,  1191,  1191,  1192,  1192,  1192,  1192,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1193,
    1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,  1193,
    1193,  1193,  1193,  1193,  1194,  1194,  1195,  1195,  1196,  1196,
    1197,  1197,  1198,  1198,  1198,  1198,  1198,  1198,  1199,  1199,
    1200,  1200,  1201,  1201,  1201,  1201,  1201,  1201,  1201,  1201,
    1201,  1201,  1201,  1202,  1203,  1203,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1210,  1209,  1209,  1211,  1211,  1212,  1212,
    1213,  1213,  1214,  1214,  1215,  1215,  1216,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1218,  1219,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1220,  1217,  1222,
    1221,  1223,  1223,  1223,  1224,  1224,  1225,  1225,  1226,  1227,
    1226,  1228,  1228,  1230,  1229,  1231,  1231,  1231,  1231,  1231,
    1231,  1231,  1231,  1231,  1231,  1231,  1231,  1232,  1231,  1233,
    1233,  1234,  1234,  1235,  1235,  1236,  1236,  1237,  1237,  1238,
    1238,  1239,  1239,  1240,  1240,  1241,  1242,  1242,  1243,  1243,
    1244,  1245,  1244,  1246,  1244,  1244,  1247,  1244,  1248,  1244,
    1244,  1249,  1244,  1250,  1244,  1244,  1251,  1251,  1251,  1252,
    1252,  1253,  1253,  1254,  1256,  1255,  1255,  1255,  1257,  1258,
    1259,  1257,  1260,  1262,  1263,  1261,  1265,  1264,  1267,  1268,
    1266,  1269,  1270,  1271,  1271,  1272,  1272,  1272,  1272,  1273,
    1273,  1275,  1274,  1276,  1274,  1277,  1277,  1278,  1279,  1278,
    1281,  1280,  1282,  1282,  1283,  1283,  1284,  1284,  1285,  1285,
    1286,  1286,  1286,  1286,  1286,  1286,  1286,  1286,  1286,  1286,
    1286,  1286,  1287,  1287,  1287,  1287,  1287,  1287,  1287,  1287,
    1287,  1288,  1288,  1288,  1288,  1289,  1289,  1289,  1290,  1290,
    1291,  1291,  1292,  1293,  1292,  1294,  1295,  1294,  1296,  1296,
    1297,  1297,  1298,  1298,  1299,  1299,  1299,  1300,  1301,  1301,
    1302,  1303,  1303,  1305,  1304,  1306,  1306,  1307,  1307,  1307,
    1308,  1308,  1309,  1309,  1310,  1310,  1310,  1311,  1311,  1311,
    1312,  1312,  1312,  1312,  1312,  1313,  1314,  1314,  1314,  1314,
    1315,  1315,  1315,  1316,  1316,  1316,  1316,  1316,  1316,  1317,
    1317,  1317,  1317,  1317,  1318,  1318,  1318,  1318,  1318,  1319,
    1319,  1319,  1319,  1319,  1320,  1321,  1321,  1322,  1322,  1323,
    1324,  1323,  1325,  1325,  1326,  1326,  1327,  1329,  1328,  1330,
    1330,  1331,  1331,  1333,  1332,  1335,  1336,  1334,  1334,  1334,
    1338,  1337,  1340,  1339,  1341,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1342,  1339,  1339,  1339,  1339,  1339,  1339,  1343,
    1343,  1344,  1345,  1346,  1346,  1347,  1348,  1348,  1349,  1349,
    1351,  1352,  1350,  1354,  1355,  1353,  1356,  1356,  1356,  1356,
    1357,  1357,  1358,  1358,  1359,  1360,  1360,  1360,  1361,  1360,
    1362,  1362,  1363,  1363,  1364,  1363,  1365,  1363,  1366,  1366,
    1367,  1367,  1368,  1369,  1369,  1370,  1370,  1372,  1371,  1373,
    1373,  1374,  1374,  1375,  1375,  1376,  1377,  1376,  1379,  1380,
    1378,  1381,  1381,  1382,  1383,  1383,  1384,  1385,  1385,  1387,
    1386,  1389,  1390,  1388,  1391,  1388,  1392,  1388,  1393,  1393,
    1394,  1394,  1395,  1395,  1396,  1396,  1397,  1397,  1398,  1398,
    1398,  1400,  1399,  1401,  1401,  1402,  1402,  1403,  1403,  1404,
    1404,  1404,  1404,  1404,  1404,  1404,  1404,  1404,  1405,  1405,
    1407,  1406,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1409,  1408,  1410,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1411,  1411,
    1411,  1412,  1412,  1413,  1413,  1414,  1414,  1415,  1415,  1416,
    1416,  1417,  1417,  1418,  1418,  1419,  1419,  1419,  1421,  1420,
    1422,  1420,  1423,  1423,  1423,  1423,  1423,  1424,  1424,  1425,
    1425,  1425,  1426,  1426,  1426,  1428,  1427,  1430,  1429,  1429,
    1431,  1431,  1432,  1433,  1432,  1434,  1434,  1435,  1435,  1435,
    1435,  1435,  1435,  1435,  1435,  1435,  1435,  1435,  1435,  1435,
    1435,  1435,  1435,  1435,  1435,  1435,  1436,  1436,  1437,  1437,
    1439,  1438,  1440,  1440,  1442,  1441,  1441,  1441,  1443,  1443,
    1445,  1444,  1446,  1447,  1447,  1449,  1448,  1450,  1450,  1450,
    1451,  1451,  1451,  1451,  1452,  1452,  1453,  1454,  1456,  1457,
    1458,  1459,  1455,  1460,  1460,  1461,  1461,  1462,  1462,  1462,
    1463,  1463,  1463,  1464,  1464,  1465,  1465,  1466,  1466,  1466,
    1466,  1467,  1467,  1468,  1468,  1469,  1469,  1470,  1470,  1471,
    1471,  1472,  1472,  1473,  1473,  1473,  1474,  1474,  1475,  1475,
    1476,  1476,  1477,  1477,  1478,  1479,  1479,  1479,  1479,  1480,
    1480,  1481,  1481,  1481,  1482,  1483,  1483,  1483,  1484,  1484,
    1484,  1484,  1484,  1484,  1484,  1484,  1484,  1484,  1485,  1485,
    1485,  1485,  1485,  1486,  1486,  1486,  1487,  1487,  1488,  1488,
    1489,  1490,  1490,  1491,  1491,  1492,  1492,  1492,  1493,  1493,
    1493,  1493,  1494,  1494,  1494,  1495,  1495,  1496,  1497,  1497,
    1498,  1499,  1500,  1501,  1501,  1502,  1502,  1503,  1503,  1503,
    1504,  1504,  1504,  1505,  1505,  1506,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,  1507,
    1507,  1507,  1507,  1507,  1507,  1507,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,  1508,
    1508,  1508,  1508,  1508,  1508,  1508,  1510,  1509,  1512,  1511,
    1513,  1511,  1514,  1511,  1516,  1515,  1515,  1517,  1517,  1519,
    1518,  1520,  1518,  1522,  1521,  1521,  1523,  1523,  1523,  1524,
    1524,  1524,  1524,  1525,  1525,  1525,  1525,  1526,  1527,  1527,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1528,  1528,  1528,
    1529,  1529,  1529,  1529,  1530,  1531,  1532,  1532,  1533,  1533,
    1533,  1533,  1534,  1534,  1534,  1535,  1535,  1535,  1535,  1535,
    1537,  1536,  1538,  1538,  1539,  1539,  1540,  1541,  1541,  1541,
    1541,  1541,  1543,  1542,  1544,  1544,  1545,  1544,  1546,  1546,
    1547,  1547,  1548,  1548,  1548,  1548,  1549,  1548,  1550,  1550,
    1550,  1550,  1550,  1551,  1552,  1552,  1552,  1552,  1552,  1552,
    1553,  1553,  1554,  1555,  1555,  1555,  1555,  1555,  1556,  1556,
    1557,  1557,  1558,  1558,  1559,  1560,  1560,  1561,  1561,  1562,
    1562,  1563,  1563,  1564,  1564,  1566,  1565,  1567,  1565,  1568,
    1565,  1569,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,
    1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,
    1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1565,  1570,
    1570,  1571,  1571,  1572,  1572,  1572,  1573,  1573,  1573,  1573,
    1574,  1574,  1575,  1575,  1576,  1576,  1577,  1577,  1578,  1578,
    1579,  1579,  1579,  1579,  1579,  1580,  1580,  1581,  1581,  1582,
    1583,  1583,  1583,  1583,  1583,  1584,  1584,  1585,  1585,  1586,
    1586,  1587,  1587,  1587,  1587,  1587,  1589,  1588,  1590,  1590,
    1591,  1591,  1591,  1592,  1592,  1592,  1593,  1593,  1594,  1595,
    1595,  1596,  1597,  1598,  1598,  1600,  1599,  1601,  1601,  1601,
    1602,  1602,  1604,  1603,  1605,  1605,  1606,  1606,  1606,  1607,
    1607,  1608,  1609,  1608,  1610,  1611,  1612,  1613,  1613,  1614,
    1614,  1615,  1615,  1615,  1615,  1615,  1615,  1615,  1615,  1616,
    1616,  1616,  1617,  1617,  1617,  1617,  1617,  1618,  1618,  1618,
    1618,  1618,  1618,  1619,  1619,  1620,  1621,  1622,  1622,  1622,
    1623,  1623,  1623,  1625,  1624,  1626,  1626,  1627,  1627,  1629,
    1628,  1630,  1630,  1631,  1631,  1631,  1631,  1633,  1634,  1635,
    1632,  1636,  1636,  1638,  1639,  1640,  1641,  1642,  1637,  1644,
    1645,  1646,  1647,  1643,  1648,  1648,  1648,  1648,  1648,  1648,
    1649,  1649,  1649,  1650,  1650,  1651,  1651,  1651,  1652,  1652,
    1653,  1654,  1653,  1655,  1655,  1656,  1656,  1657,  1657,  1658
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     1,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     0,     6,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     0,     8,
       0,     9,     0,     9,     0,     9,     8,     2,     0,     1,
       4,     0,     1,     2,     0,     3,     2,     8,     0,     2,
       0,     1,     1,     0,     1,     2,     1,     1,     2,     2,
       4,     3,     3,     3,     3,     1,     2,     1,     1,     3,
       2,     3,     2,     2,     1,     3,     3,     2,     3,     1,
       2,     2,     2,     1,     2,     1,     1,     1,     2,     3,
       2,     3,     2,     2,     3,     3,     3,     0,     6,     0,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     2,     1,     2,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     5,     0,     1,     2,     1,     1,     1,     1,
       3,     3,     3,     3,     0,     1,     0,     1,     0,     1,
       2,     1,     1,     2,     2,     4,     1,     3,     2,     1,
       2,     2,     2,     3,     3,     3,     3,     2,     2,     1,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     1,
       2,     2,     1,     2,     2,     0,     1,     1,     1,     3,
       1,     3,     0,     1,     0,     4,     1,     1,     1,     0,
       1,     2,     1,     1,     2,     1,     3,     3,     1,     1,
       0,     2,     0,     1,     5,     0,     3,     3,     1,     0,
       2,     2,     2,     0,     3,     3,     6,     6,     1,     1,
       2,     2,     2,     1,     2,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     0,     1,     2,
       0,     1,     0,     1,     0,     1,     1,     2,     1,     2,
       1,     2,     2,     2,     3,     2,     3,     3,     3,     3,
       1,     1,     1,     1,     3,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     2,     0,     2,     1,     3,     0,
       0,     7,     0,     5,     7,     0,     5,     0,     5,     0,
       5,     0,     4,     0,    10,     3,     4,     3,     3,     7,
       0,     3,     1,     4,     0,     3,     0,     2,     0,     1,
       0,     2,     2,     2,     2,     1,     1,     1,     4,     4,
       0,     6,     4,     0,     5,     0,     6,     4,     3,     1,
       7,     2,     1,     1,     0,     6,     0,     3,     2,     0,
       5,     0,     0,     6,     1,     3,     1,     1,     3,     3,
       3,     2,     4,     0,     7,     0,     0,     8,     5,     5,
       3,     4,     2,     2,     6,     5,     3,     5,     1,     1,
       1,     1,     1,     0,     1,     1,     2,     2,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     2,     0,     1,
       2,     1,     1,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     6,     0,     5,     4,     4,
       3,     0,     1,     1,     3,     3,     2,     2,     0,     2,
       1,     3,     0,     1,     1,     0,     2,     4,     1,     3,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     1,     3,     2,     0,
       3,     1,     4,     1,     0,     4,     1,     0,     4,     0,
       1,     3,     0,     1,     3,     1,     1,     2,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     5,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     0,     6,     1,     1,     1,     3,     2,
       3,     1,     1,     0,     6,     1,     1,     1,     3,     3,
       4,     0,     6,     0,     2,     0,     4,     0,     2,     1,
       2,     4,     2,     3,     2,     3,     0,     3,     0,     0,
       6,     2,     1,     1,     2,     2,     8,     4,     0,     1,
       2,     1,     1,     1,     1,     0,     2,     4,     3,     1,
       1,     3,     4,     0,     0,     0,     2,     2,     1,     1,
       0,     2,     3,     0,     2,     3,     0,     2,     3,     3,
       3,     2,     3,     4,     3,     4,     3,     4,     1,     3,
       4,     3,     3,     6,     1,     5,     6,     5,     7,     6,
       8,     5,     6,     4,     4,     5,     3,     4,     1,     3,
       3,     3,     3,     3,     3,     5,     5,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     2,     1,     1,     1,     2,     2,     1,
       1,     2,     2,     4,     1,     3,     1,     1,     1,     1,
       1,     3,     1,     1,     1,     1,     3,     2,     2,     2,
       2,     3,     3,     5,     6,     4,     4,     7,     2,     6,
       5,     6,     6,     4,     4,     5,     4,     6,     2,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     8,     8,
       6,     6,     2,     6,     6,     8,     8,     6,     8,     6,
       2,     8,     8,     2,     2,     2,     6,     6,     4,     4,
       8,     4,     4,     4,     4,     3,     8,     4,     4,     6,
       4,     4,     4,     6,     8,     4,     3,     6,     4,     6,
       5,     8,     7,    10,     1,     6,     4,     4,     4,     4,
       4,     6,     4,     0,     5,     6,     2,     3,     0,     4,
       0,     3,     0,     1,     1,     3,     4,     4,     5,     4,
       4,     4,     5,     4,     0,     0,     7,     4,     5,     4,
       5,     4,     4,     4,     4,     4,     5,     0,     8,     0,
       3,     3,     1,     4,     0,     1,     0,     2,     0,     0,
       4,     4,     2,     0,     3,     2,     3,     2,     1,     1,
       2,     1,     2,     1,     2,     2,     2,     0,     3,     0,
       1,     1,     3,     1,     3,     1,     3,     0,     1,     0,
       2,     4,     5,     1,     1,     1,     1,     4,     1,     3,
       3,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     1,     1,
       2,     0,     1,     5,     0,     5,     3,     5,     2,     0,
       0,     7,     1,     0,     0,     6,     0,     3,     0,     0,
       5,     0,     1,     0,     1,     0,     2,     3,     3,     1,
       1,     0,     7,     0,     7,     1,     2,     0,     0,     2,
       0,     2,     0,     1,     1,     1,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     0,     2,
       0,     1,     0,     0,     3,     0,     0,     3,     2,     0,
       0,     4,     4,     2,     0,     1,     1,     3,     3,     1,
       2,     0,     1,     0,     4,     4,     2,     0,     1,     1,
       0,     1,     0,     1,     2,     5,     4,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     0,     2,     3,     4,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       0,     6,     0,     1,     3,     1,     3,     0,     2,     3,
       1,     2,     1,     0,     3,     0,     0,     7,     2,     1,
       0,     3,     0,     7,     0,     7,     4,     6,     4,     4,
       4,     4,     0,     6,     4,     4,     5,     6,     4,     1,
       3,     1,     2,     1,     3,     1,     0,     2,     0,     1,
       0,     0,     8,     0,     0,     6,     0,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     3,     4,     0,     3,
       3,     1,     2,     2,     0,     3,     0,     5,     3,     1,
       3,     1,     3,     1,     1,     0,     1,     0,     4,     0,
       1,     3,     1,     1,     1,     0,     0,     6,     0,     0,
      11,     3,     1,     3,     3,     1,     3,     0,     1,     0,
       4,     0,     0,     9,     0,     5,     0,     6,     0,     2,
       1,     3,     2,     4,     0,     2,     0,     2,     1,     1,
       1,     0,     4,     0,     1,     0,     1,     1,     3,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       0,     3,     2,     4,     4,     3,     4,     4,     1,     3,
       3,     3,     3,     6,     2,     2,     0,     6,     0,     7,
       5,     2,     1,     1,     1,     5,     5,     2,     2,     1,
       4,     3,     2,     3,     2,     2,     1,     3,     4,     3,
       3,     2,     3,     2,     3,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     0,     1,     0,     2,     0,     1,     1,
       1,     0,     2,     0,     2,     0,     2,     2,     0,     4,
       0,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     0,     1,     1,     0,     4,     0,     4,     1,
       0,     1,     4,     0,     3,     3,     1,     2,     2,     2,
       2,     2,     3,     2,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     3,
       0,     3,     3,     1,     0,     4,     1,     2,     0,     1,
       0,     3,     3,     2,     2,     0,     5,     0,     1,     1,
       0,     1,     1,     2,     1,     2,     1,     2,     0,     0,
       0,     0,    22,     1,     1,     0,     1,     0,     1,     1,
       0,     1,     1,     0,     2,     2,     1,     3,     4,     3,
       3,     0,     2,     2,     1,     3,     3,     0,     4,     0,
       3,     1,     1,     0,     3,     2,     3,     1,     1,     2,
       0,     2,     3,     1,     5,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     2,     2,     1,     1,     3,     5,
       1,     1,     1,     1,     1,     3,     4,     5,     1,     5,
       3,     2,     1,     3,     2,     2,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     0,     3,
       0,     3,     0,     3,     0,     3,     2,     0,     2,     0,
       2,     0,     4,     0,     3,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     3,     3,     4,
       6,     2,     3,     3,     2,     3,     5,     1,     3,     3,
       1,     1,     3,     3,     1,     3,     2,     2,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     2,     0,     3,     4,     3,     0,     7,     1,     2,
       1,     1,     1,     1,     1,     1,     0,     5,     1,     1,
       1,     1,     1,     3,     6,     6,     6,     7,     5,     3,
       4,     1,     3,     8,     8,     8,     6,     4,     0,     3,
       0,     3,     1,     3,     2,     1,     1,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     2,     0,
       1,     3,     1,     2,     2,     2,     1,     3,     3,     1,
       1,     3,     1,     3,     1,     3,     1,     1,     1,     1,
       4,     5,     4,     6,     1,     0,     3,     3,     1,     1,
       0,     2,     2,     2,     2,     0,     2,     0,     3,     2,
       1,     2,     2,     2,     2,     2,     0,     3,     0,     1,
       0,     3,     2,     0,     1,     2,     0,     1,     4,     4,
       5,     2,     3,     0,     1,     0,     4,     0,     1,     1,
       0,     1,     0,     2,     2,     1,     0,     1,     1,     2,
       3,     2,     0,     6,     3,     0,     0,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     3,     3,     3,
       0,     3,     3,     0,     7,     0,     3,     1,     3,     0,
       3,     2,     4,     0,     3,     4,     4,     0,     0,     0,
      16,     8,     7,     0,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    12,     4,     4,     3,     4,     3,     2,
       1,     3,     5,     1,     1,     0,     1,     1,     0,     2,
       0,     0,     3,     0,     2,     5,     3,     3,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   929,  1132,  2686,     0,     0,     0,     0,     0,     0,
    2688,   585,    66,  1789,  1917,  1918,  1700,  1728,     2,     0,
    1132,   276,   179,     0,    78,  1730,     0,  1975,     0,     0,
    1132,     0,   487,     0,  1970,     0,     0,  1132,  1733,  1960,
     253,   179,  2688,     0,  1178,  2476,  1830,  1986,     0,     0,
       0,  1813,     0,  2552,  1778,     0,     0,  2819,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1169,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1919,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   958,     0,     0,     0,     0,     0,     0,
    1036,   941,  2753,  2754,  2755,  1134,  1133,     0,  2688,  2090,
    1117,  1143,  2166,  2168,  2167,  2169,  2170,  2171,  2172,  2173,
    2174,  2107,  2175,  2176,  2178,  2177,  2179,  2180,  2181,  2108,
    2109,  2182,  2183,  2184,  2186,  2185,  2187,  2110,  2111,  2188,
    2189,  2190,  2191,  2112,  2114,  2113,  2192,  2195,  2194,  2193,
    2115,  2196,  2197,  2198,  2200,  2116,  2117,  2118,  2119,  2120,
    2199,  2121,  2201,  2122,  2202,  2203,  2204,  2205,  2206,  2207,
    2208,  2210,  2209,  2123,  2211,  2212,  2214,  2215,  2216,  2213,
    2217,  2219,  2218,  2220,  2221,  2222,  2124,  2223,  2224,  2225,
    2226,  2227,  2228,  2229,  2230,  2125,  2231,  2232,  2233,  2252,
    2126,  2234,  2237,  2236,  2235,  2238,  2239,  2240,  2242,  2241,
    2243,  2244,  2127,  2128,  2245,  2246,  2247,  2248,  2250,  2249,
    2254,  2255,  2256,  2129,  2251,  2253,  2453,  2257,  2258,  2260,
    2259,  2261,  2130,  2263,  2262,  2131,  2265,  2264,  2132,  2133,
    2266,  2267,  2268,  2088,  2269,  2089,  2270,  2273,  2274,  2271,
    2275,  2280,  2134,  2272,  2276,  2277,  2278,  2279,  2281,  2135,
    2283,  2282,  2284,  2285,  2286,  2287,  2288,  2289,  2290,  2291,
    2292,  2305,  2296,  2297,  2299,  2300,  2303,  2298,  2304,  2308,
    2307,  2309,  2310,  2311,  2312,  2313,  2306,  2294,  2301,  2302,
    2295,  2314,  2315,  2293,  2316,  2317,  2318,  2319,  2320,  2321,
    2322,  2323,  2324,  2325,  2326,  2328,  2327,  2329,  2330,  2331,
    2332,  2333,  2334,  2336,  2335,  2337,  2338,  2339,  2341,  2340,
    2343,  2344,  2136,  2342,  2345,  2346,  2347,  2348,  2349,  2351,
    2350,  2137,  2139,  2138,  2140,  2352,  2353,  2141,  2354,  2356,
    2355,  2357,  2358,  2359,  2361,  2360,  2362,  2363,  2142,  2143,
    2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,  2373,
    2374,  2375,  2376,  2377,  2379,  2378,  2380,  2381,  2382,  2383,
    2384,  2385,  2386,  2144,  2387,  2145,  2388,  2389,  2146,  2390,
    2147,  2391,  2392,  2393,  2394,  2395,  2148,  2396,  2397,  2398,
    2400,  2401,  2399,  2402,  2149,  2403,  2404,  2405,  2150,  2407,
    2406,  2408,  2151,  2410,  2152,  2153,  2409,  2155,  2156,  2411,
    2412,  2413,  2154,  2414,  2157,  2415,  2416,  2418,  2417,  2419,
    2420,  2421,  2158,  2422,  2159,  2423,  2424,  2425,  2426,  2427,
    2429,  2428,  2430,  2431,  2432,  2433,  2436,  2438,  2435,  2437,
    2434,  2439,  2440,  2441,  2442,  2446,  2447,  2448,  2449,  2443,
    2444,  2445,  2160,  2450,  2451,  2452,  2454,  2455,  2457,  2456,
    2161,  2162,  2458,  2459,  2165,  2460,  2461,  2462,  2466,  2463,
    2475,  2464,  2465,  2468,  2467,  2469,  2470,  2471,  2163,  2472,
    2164,  2473,  2474,   198,  2093,   181,  2094,  2106,   112,  2543,
    2542,  1080,  1118,  2689,  2690,   583,   885,     0,     0,   179,
       0,   886,     0,   884,   179,   134,     0,     0,     0,  1806,
       0,  1726,  1726,  1726,  1726,     0,  1726,   179,  1726,     0,
    1729,  1726,   179,  1726,     0,    71,  1925,   277,     0,     0,
       0,     0,     0,  2087,     0,  1736,     0,     0,  1977,  1993,
       0,  1994,  1988,  2540,     0,  1203,     0,     0,     0,     0,
     179,  1135,     0,  1787,     0,   243,   252,   254,   255,   251,
       0,  2690,  2701,  1170,  1176,  1188,     0,  1897,   255,     0,
     112,  1061,     0,   112,  1814,  1811,     0,     0,     0,  1787,
    1987,  2803,     0,     0,     0,  2799,     0,  2804,     0,  1178,
       0,     0,     1,     5,     0,     0,   582,  2755,     0,   579,
     580,  2247,  2356,  1910,  1908,  2082,     0,   932,   959,     0,
     937,     0,   935,  2099,  2098,  2097,     0,   948,   947,   945,
       0,   448,     0,  1038,     0,  2760,   939,  1094,  2687,     0,
     200,     0,     0,   113,   114,     0,     0,     0,  2693,     0,
       0,     0,   586,     0,     0,   133,     0,     0,   583,   583,
     583,  1810,  1809,  1808,     0,  1806,  2167,  2107,  2181,     0,
    2056,     0,     0,     0,  1487,     0,  2112,     0,  2196,  2198,
    2116,  2117,  2118,  2119,  2120,  2123,     0,     0,  1216,  1216,
    1216,  1213,     0,     0,     0,  2221,  2222,  2061,     0,     0,
       0,  2052,  2062,  2260,  2261,     0,  2054,  2055,  2267,     0,
       0,     0,  2282,     0,  2287,  2059,     0,     0,  2323,  2325,
       0,     0,  2329,  2330,  2331,  2332,  2036,  1271,     0,  1213,
    2051,  2058,  2348,  2044,  2357,  2362,  2363,     0,  2372,     0,
       0,  2394,     0,  2401,  2399,  2405,     0,     0,  2426,     0,
       0,  1213,  2035,  2446,  2447,  2448,  2449,     0,  2053,  2160,
    2060,     0,  2460,  1216,  1213,  1213,     0,     0,     0,  2469,
    2470,  2474,     0,     0,     0,  2725,  1270,     0,  1449,     0,
    1481,  1228,  1234,  1248,     0,  1263,  1297,  1298,  1300,  1404,
    1299,  1305,  1304,  1701,  2048,  1303,  1302,  2049,  2050,  1296,
    2072,  2093,  2071,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,  1712,  1726,    73,     0,     0,
    2601,  2616,  2617,  1216,  2613,  2618,  2241,  2128,  2254,     0,
    2615,  2607,     0,  2367,  2371,  2611,  2386,  2389,  2605,     0,
    2152,  2430,  2637,  2609,  2614,  2595,  2582,  2596,     0,     0,
    2599,  2603,  2084,  1595,  2555,  2556,     0,    79,  1738,  1739,
    1737,  1034,     0,  2816,  1978,  1979,  1980,     0,  1997,     0,
    1130,     0,     0,   497,   488,     0,  1892,  1891,     0,  1971,
    2702,     0,     0,  1085,  1741,  1788,     0,  1740,  1966,     0,
    1964,  1961,  1963,   244,     0,     0,   274,  2168,  2601,  2371,
    2573,     0,  2581,     0,  2696,  2693,  2703,  2738,  2733,  2732,
    2735,  2736,  1194,  2737,  1193,  2734,  2731,  1203,  1189,  1191,
    1192,   801,     0,     0,  2496,  2497,  2336,  2357,  2395,  2498,
    2443,     0,     0,  2517,  2477,  2482,  2478,     0,     0,  1852,
       0,   801,  1875,  1905,  1853,     0,     0,  1905,     0,  1630,
    1895,  1898,     0,  2500,  1866,   882,   881,  1878,   880,  2501,
    1891,     0,  1838,  1854,     0,  1815,  1859,   112,  2502,     0,
    1894,  1877,     0,  1876,  1630,  1905,     0,  1831,     0,     0,
       0,     0,     0,   250,  1068,  1068,     0,     0,  1060,  1062,
    1063,  1068,  1068,     0,  2817,  2818,  2553,  1034,  2043,  2041,
    2042,  2091,  2800,  2040,  2039,  2808,  2810,  2796,  2798,  2805,
    1172,     0,  2707,     6,    65,   129,  1203,  1203,  2755,   583,
     581,     0,  1922,  2758,  2759,  2757,   817,     0,  1216,  2100,
    2103,  2756,  2104,   182,   946,     0,   449,   182,     0,     0,
       0,     0,     0,   450,   451,   387,     0,  1042,  1043,  1037,
    1039,  1041,   943,     0,     0,   942,  2760,     0,     0,  1145,
    1147,  1146,  1163,   202,   199,   180,    80,  1082,  1719,  1721,
    1120,  2692,     0,     0,  2694,  2698,  1269,  1268,     0,   126,
     132,     0,  2588,  2592,     0,     0,  2103,  2664,     0,   130,
    2652,     0,     0,     0,     0,  1790,  1794,  1800,  1804,  1807,
       0,     0,  1600,  1318,  1600,  1600,  1600,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1600,     0,  1356,  1328,  1329,     0,  1357,     0,     0,
       0,  2063,     0,     0,     0,  2725,     0,     0,     0,  1454,
       0,     0,     0,  2725,     0,     0,     0,     0,     0,     0,
    1483,  1485,  2071,  1600,     0,     0,  1600,     0,     0,     0,
       0,     0,  1221,  1362,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1600,  1600,     0,
       0,  1600,  1370,  2065,     0,     0,     0,  2064,     0,     0,
       0,  2037,  2057,     0,  1373,  1375,  1374,     0,  1600,  1600,
       0,     0,     0,  1308,  1307,  1309,     0,     0,     0,     0,
       0,     0,  1267,  1266,  1265,  1264,     0,     0,     0,  1272,
       0,  1273,  1274,     0,  1275,  1276,  1277,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1310,     0,     0,     0,
    2038,  1413,     0,  1727,  1706,  1714,  1708,     0,  1893,  1709,
    1711,  1718,   462,     0,  1715,  2105,  2650,  1710,     0,  1702,
       0,    72,     0,  1949,  1954,     0,     0,     0,  1944,  1952,
    1946,  1953,  1945,     0,     0,  1955,   112,     0,  1947,  1951,
    1950,  1926,  1929,  1936,  1927,     0,     0,   275,   278,   280,
       0,   283,  2602,  2600,  2634,  2633,  2638,     0,  2635,  2631,
    2594,  2624,  2665,  2628,     0,  2665,  2630,  2629,  2665,  2625,
    2632,  2665,     0,  2597,     0,  1596,  1597,     0,  2554,     0,
    2083,  1035,     0,     0,  1981,  1982,     0,  1153,  1998,  1999,
    1995,  1595,  2541,  2544,     0,   690,  1204,   498,     0,     0,
     509,     0,     0,    68,    69,     0,  1137,     0,  1136,  1140,
       0,     0,     0,  1744,  1734,  1743,  1521,  1967,   112,     0,
     242,   267,   262,   270,   264,   266,   265,   271,   272,   273,
     268,   263,   269,   256,     0,     0,  2600,     0,     0,  2597,
    2697,     0,  2699,  2716,  1177,  2704,  1200,  1179,  1199,     0,
    1190,   800,     0,   803,   805,  1763,  1764,   804,   813,     0,
     802,     0,     0,  2514,     0,  2503,     0,   809,   811,   810,
    2511,   808,     0,     0,  2487,     0,     0,  1901,     0,     0,
    1865,     0,   583,     0,     0,     0,     0,     0,     0,  1832,
       0,     0,   634,     0,  1858,  1631,  1899,  1900,  1905,     0,
       0,  1905,     0,  1871,  1895,  1905,     0,  1905,  1827,     0,
       0,  1819,  1824,  1820,     0,  1826,  1825,  1828,  1816,  1817,
       0,  1845,  1873,     0,  1895,  1857,  1864,     0,  1844,  1851,
       0,  1862,  1895,  1895,     0,  1905,  1905,  1056,  1072,  1054,
    1066,  1067,     0,     0,  1059,  1058,  1812,  1524,     0,     0,
    2797,  2811,  2795,  2806,  2807,  2794,  1173,  2708,  1171,  2709,
       0,     7,     4,  1203,  1203,  1203,  2752,     0,  2740,  2747,
    2748,  2751,  2750,  2749,  2746,     0,  2739,  2742,  2743,  2745,
    2744,  2760,     0,  1912,  1913,  1914,  1915,  1916,  1911,  1909,
    1923,  1924,   818,   817,   574,   577,   576,     0,     0,  2102,
       0,   938,     0,  1893,   936,     0,     0,  1893,   398,  1893,
     452,   930,  1040,   950,     0,     0,   940,  1095,  1096,  1099,
       0,     0,   486,  1163,  1149,  1165,     0,   203,   205,     0,
    1084,  1083,     0,  1081,  1128,  1127,  1125,     0,  1126,  1124,
    1119,  1121,  1122,  2691,  2695,   584,   817,  1893,     0,     0,
     131,     0,   390,     0,     0,   887,   887,   887,  1796,  1723,
    1521,  1725,  2082,     0,     0,     0,  1802,     0,     0,  1601,
    1600,     0,  1463,     0,     0,     0,     0,  1489,     0,     0,
       0,     0,     0,     0,     0,     0,  1294,     0,     0,     0,
       0,     0,  1434,     0,  1463,  1217,  1675,  1676,  1660,  1661,
    1659,  1662,  1214,     0,  1663,  1674,  1385,     0,     0,     0,
       0,     0,     0,  1571,  1572,  1573,  1574,  1582,  1575,  1576,
    1577,  1584,  1589,  1578,  1579,  1585,  1586,  1587,  1580,  1588,
    1583,  1581,  1590,     0,  1570,     0,  1593,  1591,  1594,  1592,
       0,  1455,  1447,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1600,     0,     0,     0,  1600,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1396,     0,     0,
       0,     0,     0,  1600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1352,     0,  2074,  2073,     0,     0,
       0,   850,     0,  1312,     0,  1311,  1533,     0,  2710,  2726,
       0,  2503,  1450,  1452,     0,  1219,  1218,  1220,  1231,  1224,
    1229,  1222,  1226,     0,  1278,  2174,  1232,     0,     0,  1260,
    2725,  1609,  1261,  1246,  1251,  1252,     0,  1249,  1250,     0,
    1254,     0,  1253,  1257,  1258,  1259,  1262,     0,     0,     0,
       0,  1301,  1306,  1482,  1203,  2075,     0,     0,   462,   465,
     464,  1716,   463,  1765,     0,  1044,     0,     0,    74,    76,
    1941,  1938,  1937,  1939,  1943,   112,  1948,  1940,     0,  1956,
    2221,  2446,  2449,   287,     0,   260,   259,   261,   284,     0,
       0,  2627,     0,  2608,     0,  2612,  2606,  2610,  2590,     0,
       0,  2598,     0,  2636,  2619,  2623,  2622,  2620,     0,  2621,
    2626,  2604,  1599,  2255,  2340,     0,  1602,  2558,  1731,  2815,
    1983,  2460,  1984,  1976,     0,  1996,     0,     0,     0,  1131,
     691,     0,  1203,   496,   495,   494,   493,     0,   511,   491,
     499,    70,     0,     0,  1972,     0,     0,     0,     0,  1087,
    1742,     0,     0,  1722,  1522,  1968,  1962,     0,     0,     0,
       0,     0,  2654,  2579,     0,     0,     0,  2700,  2718,  2717,
    2705,  1203,  1621,  1204,  1204,  2071,  2519,     0,  2513,  2512,
       0,     0,     0,  2532,  2515,     0,     0,  2481,  2520,  2521,
    2524,     0,     0,     0,     0,     0,  2518,  2443,  2483,  2484,
       0,  2489,  2479,  2538,  2539,  2536,  2537,  2535,  2508,  1872,
       0,  1903,  1906,  1907,     0,     0,  1886,  1880,  1879,  1869,
    1881,  1870,  1890,  1889,  1888,  1842,  1841,  1643,  1644,  2398,
    1642,  1634,  1637,  1641,  1640,  1835,  1896,  1885,  1883,  1867,
    1905,  1840,  1839,  1884,  1882,  1821,  1822,  1823,     0,  1630,
       0,  1901,  1874,  1905,  1895,     0,  1905,  1905,  1887,  1861,
    1863,  1057,  1074,  1073,  1069,  1070,  1075,  1065,  1064,  1542,
    1541,     0,  1496,     0,  1498,  1495,  1494,  1493,     0,  1541,
    2801,  2809,  2813,     0,  1630,  2715,  2713,     0,     0,     0,
     583,     0,     0,  2741,   115,   575,  1765,  1765,     0,  2101,
       0,     0,     0,     0,     0,     0,     0,   183,   192,     0,
       0,   396,   397,  1765,   395,   438,   439,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,     0,   136,   445,
    1765,  1765,   392,   418,   419,   422,   423,   424,   425,   426,
     388,     0,   393,   817,     0,   952,   954,  2761,  2762,  2763,
       0,     0,  1098,  1152,  1144,  1151,  1148,  1163,  1161,  1150,
     877,   876,     0,  1164,   201,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,    82,   100,
    1720,  1129,  1123,   127,   817,  1765,  1765,  1765,  1765,   394,
     427,   428,   431,   432,   433,   434,   437,   435,   436,     0,
    2593,     0,     0,  1893,     0,  2656,  2657,     0,  2653,   888,
       0,     0,     0,     0,     0,  1791,     0,  2085,  1801,  1524,
    1805,  1804,     0,  1381,     0,  1427,     0,  1429,  1430,  1431,
       0,     0,     0,     0,     0,  1382,     0,  1326,  1383,  1384,
       0,  1378,     0,  1379,     0,     0,     0,     0,     0,     0,
       0,  1433,     0,  1215,     0,     0,  1330,  1331,  1323,  1315,
       0,  1406,     0,     0,  1332,     0,     0,     0,     0,  1387,
       0,  1407,  1484,     0,  1486,  2075,     0,  1439,  1388,  1337,
       0,  1437,     0,  1338,  1408,  1409,  1410,  1390,  1391,     0,
    1412,     0,  1392,     0,     0,  1395,     0,     0,  1340,  1443,
    1441,     0,     0,     0,     0,  1445,  1342,     0,     0,     0,
    1341,     0,     0,     0,     0,     0,     0,     0,  1344,     0,
    1324,  1442,  1444,  1398,     0,     0,     0,     0,     0,  1353,
       0,  2719,  1532,  2727,  1533,     0,     0,  2721,  2711,  2716,
    2724,  1316,     0,     0,  2076,  1225,  1230,  1223,  1227,  2725,
       0,     0,     0,     0,  1244,  1243,     0,     0,     0,  2725,
    1609,  1247,     0,     0,  1423,  1424,  1479,     0,  1707,  1704,
    1717,  1766,     0,  2651,  1046,  1045,  1713,  1044,    77,     0,
    1942,  1935,  1957,  1930,     0,   279,   288,   281,   285,   286,
     282,  2669,     0,  2668,     0,     0,  2587,  2646,  2649,  2082,
       0,     0,     0,  2568,  2562,  2569,  2571,  2565,  2570,  2572,
    2563,  2564,  2559,  2566,  1603,  1632,     0,  1985,  1154,  1156,
    1157,  1155,  1163,     0,     0,  2547,  2548,  2546,  2545,   501,
       0,   510,     0,   522,     0,     0,     0,  1974,  1973,     0,
    1138,  1141,  1142,  1092,  1091,  1093,  1086,  1088,  1089,   567,
    1748,     0,     0,     0,  1754,  1735,  1745,     0,  1969,  1965,
       0,   257,  2580,     0,     0,     0,     0,     0,     0,     0,
    1198,  1524,  1693,  1195,  1183,  1632,  1622,  1182,  1205,  1201,
       0,   816,   815,   814,   812,     0,     0,     0,     0,  2526,
    2527,     0,     0,  2504,  2505,  2506,     0,  2509,  2486,  2487,
       0,  2488,     0,  1902,     0,  1846,     0,  1868,     0,     0,
       0,     0,  1837,     0,  1860,  1818,  1903,  1836,  1602,  1895,
    1833,  1834,  1072,     0,  1055,  1541,  1524,     0,     0,  1516,
    1543,     0,  1543,  1518,  1519,  1524,     0,  1524,  1521,  1538,
       0,     0,  2812,  1623,  2714,     0,  2789,     0,     0,     0,
     181,   587,     0,     0,   934,   186,   189,   187,     0,   188,
       0,     0,   447,   446,     0,  1893,   440,   140,   139,   141,
     142,  1657,  1658,  1654,  1655,  1653,  1656,   144,   143,   138,
     949,     0,     0,     0,  1893,   420,   399,   400,   403,   404,
     405,  1032,  1765,  1032,     0,  1765,  1765,  1032,  1765,     0,
       0,  1765,  1765,     0,     0,  1765,     0,     0,  1032,     0,
    1765,     0,  1019,     0,     0,  1765,  1765,  1765,  1765,  1765,
    1032,     0,     0,  1765,  1765,   486,  1765,     0,     0,  1050,
       0,     0,  1765,  1765,  1765,  1765,     0,     0,  1765,  1765,
       0,  1765,   966,  1018,   589,   616,   617,   931,   965,   967,
     979,   482,     0,   997,  1021,  1022,  1020,     0,     0,     0,
       0,   150,  2765,  1097,     0,     0,  1562,   204,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1893,   429,  2589,     0,     0,  1765,
     389,   406,   407,   410,   411,   412,   413,   414,   417,   415,
     416,     0,  2660,  2662,     0,     0,   889,     0,     0,     0,
    1724,  1804,  1524,  1602,  2083,  1602,     0,  1803,     0,     0,
    1428,  1464,     0,  1490,     0,  1320,   774,   774,   774,  1473,
     759,  1477,  1468,   774,  1469,   774,  1471,     0,     0,     0,
    1280,  1295,     0,     0,     0,     0,     0,  1435,  1432,     0,
       0,     0,     0,  1458,     0,     0,     0,  1325,     0,  1418,
    1440,  1438,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1446,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   839,   845,
     848,   849,   851,   843,     0,  1400,  1313,  1203,  2728,  2730,
    1174,     0,  2720,  2722,   925,  1451,     0,  1241,  1237,     0,
    1235,  1608,  1256,  1255,     0,     0,     0,  1245,  1204,  1414,
    1203,     0,  1480,  2077,  1705,   461,   633,  1703,    75,  1933,
       0,  1928,  1931,     0,     0,  2666,     0,  2677,     0,     0,
       0,     0,     0,     0,     0,     0,  2557,  1633,  1775,     0,
    1163,  1167,  2092,  1989,  2550,  2551,  2549,     0,   502,   503,
     505,  1204,   519,   497,     0,   489,   492,     0,   501,     0,
    1090,  1188,     0,  1767,  1752,  1759,  1753,     0,     0,     0,
    1751,  2067,  2066,  2073,  2703,     0,  1568,     0,     0,  2578,
    2655,     0,     0,     0,  2706,  1602,  1602,  1687,     0,     0,
    1180,  1185,  1181,  1184,     0,  1202,  1209,  1208,  2068,  2075,
    2516,     0,     0,     0,     0,  2531,  2525,  2522,  2523,     0,
    2485,  2507,  2491,  2490,  2493,  2495,  1667,  1668,  1666,  1664,
    1665,  1904,  1630,  1856,  1855,  1645,  1636,     0,  1639,  1638,
    1829,  1848,  1850,  1905,  1071,     0,  1078,  1076,     0,  2710,
    1536,     0,  1520,  1517,  1544,     0,  1543,  1543,  1524,     0,
    1500,  1779,  1782,     0,  1499,  1595,  1526,  1188,  2802,  2814,
       0,     0,     0,   383,   382,     0,   145,  2783,     0,     0,
     671,   116,   473,   482,   588,   591,   632,   631,   191,   190,
     196,   197,  1671,  1672,  1669,  1670,   453,   466,  1673,   467,
     441,   137,   454,   455,   421,     0,   401,  1033,   922,   583,
    1001,     0,   672,   583,   873,   878,   878,   583,     0,     0,
    1132,     0,     0,  1726,     0,     0,  1132,     0,     0,     0,
    1765,     0,  1012,   961,     0,  1726,     0,  1726,  1726,  1013,
       0,     0,   962,  1765,     0,     0,     0,     0,     0,  1726,
    1132,     0,     0,     0,   484,     0,  1132,   981,  1053,  1052,
    1051,     0,  1132,  1132,     0,     0,     0,     0,   622,   623,
     621,     0,     0,     0,   614,   590,   817,   963,   483,   964,
     671,     0,  1047,   668,   674,  2078,     0,     0,   160,     0,
       0,   951,     0,   153,   151,   162,     0,     0,  1101,     0,
    1100,     0,  1565,     0,  1566,  1563,  1564,   101,    88,    84,
     105,   106,    86,    87,    91,    90,    92,    93,    96,    97,
      94,    89,    95,    85,   109,   111,   110,    98,   107,   108,
      83,   460,   459,   458,   457,   430,     0,     0,     0,  1893,
     408,  2661,  2659,  2658,     0,   915,   917,   916,   903,   902,
     117,   120,   123,     0,  1602,  1621,  2086,  1795,     0,  1354,
    1491,     0,     0,   775,  1465,   825,  1475,     0,  1476,   761,
     760,   776,  1467,  1470,  1474,  1472,  1319,  1327,  1376,     0,
    1293,  1377,     0,  1405,  1322,  1321,     0,     0,     0,  1360,
    1361,     0,  1456,     0,     0,  1334,     0,  1336,     0,     0,
    1420,  1389,  1411,  1363,  1393,     0,  1339,  1314,     0,  1364,
       0,  1369,  1367,     0,  1343,     0,     0,  1350,     0,  1348,
       0,  1349,     0,  1351,  1397,  1399,     0,     0,   850,   836,
     837,   838,     0,   840,   842,   844,     0,     0,  1534,  2729,
    1175,     0,     0,  1453,  1233,     0,  1242,  1239,     0,  1236,
    1205,  1425,  1415,     0,     0,   296,   291,   299,   293,   295,
     294,   300,   301,   302,   303,   297,   292,   298,   290,   289,
    2667,     0,  2586,  2591,  2648,  2647,  2670,  2670,  2670,     0,
    1604,     0,  1732,  1158,  1163,  1167,     0,  1159,  2000,   506,
       0,     0,     0,   526,     0,   524,   500,     0,  1139,  1203,
    1749,  1761,     0,  1769,     0,     0,  1746,  1756,     0,     0,
       0,  1755,   486,     0,   258,     0,  2575,  2576,  2574,  1632,
    1610,     0,     0,  1699,     0,  1694,  1196,     0,  1207,  1206,
       0,  2534,  2533,  2529,  2528,  2530,  2510,     0,     0,  1847,
    1635,  1630,  1843,     0,     0,  2716,  1595,  1528,  1524,  1497,
    1524,     0,     0,  1505,  1524,  1501,  1503,     0,  1602,     0,
    1560,  1203,  2070,  1624,  1627,     0,  2790,   386,   384,   385,
       0,     0,   206,   649,   650,   648,   647,     0,   474,     0,
       0,     0,   651,   652,   654,   655,  2000,   481,   817,   592,
     402,   673,   923,  1132,     0,     0,     0,   878,   667,   583,
     922,   887,   879,   583,   583,   999,  1028,  1029,     0,     0,
     600,   597,     0,   609,   982,   973,   983,   994,   996,     0,
     599,   624,     0,     0,   612,  1726,     0,  1010,     0,     0,
     594,     0,     0,   643,   644,   642,   618,   625,  1030,  1031,
     595,   596,     0,     0,  1617,  1619,  1627,   602,   601,  1678,
    1677,   611,     0,   598,     0,  1016,   989,     0,   640,   638,
     635,   637,   636,   641,   639,   613,   604,   603,   606,   605,
     608,   607,   610,   626,   978,     0,  1032,  1032,   998,     0,
    2081,     0,  1049,  1000,     0,   656,   669,   657,     0,     0,
     630,   629,   627,   628,   161,   149,     0,     0,   953,   955,
       0,     0,   956,  2767,     0,  2769,  1103,  1104,     0,     0,
    1166,     0,     0,   102,   104,     0,   391,   456,   409,  2663,
       0,     0,     0,  1804,  1797,  1646,     0,  1492,     0,     0,
       0,     0,   819,   830,   828,   822,     0,   826,   827,  1466,
       0,     0,   777,  1478,   741,   774,  1290,   759,  1284,  1286,
    1282,     0,   742,  1285,   774,     0,   825,  1289,  1281,     0,
    1436,     0,     0,  1459,     0,     0,     0,     0,     0,     0,
       0,  1317,     0,  1416,     0,     0,     0,     0,     0,     0,
    1347,  1345,  1346,   834,  1402,     0,   847,   841,   839,   846,
       0,  1632,  2710,   926,  1238,     0,  1426,  1934,  1958,     0,
       0,  2675,  2675,  2675,  1774,  1773,     0,  1772,  1776,  1160,
    1168,  2002,  2001,     0,   504,   507,     0,   499,     0,   523,
       0,   490,   568,     0,     0,     0,  1770,  1758,  2707,  1747,
    1750,  2075,  1523,  1569,  2577,  1187,     0,  1605,  1698,  1695,
       0,  1688,  1690,  1692,     0,  2069,  2492,  2494,  1849,  1077,
    1079,  1529,  1527,  1537,     0,  1493,  1524,  1524,     0,  1493,
       0,     0,  1781,  1621,  1783,  1525,  1557,  1539,     0,  1628,
    1629,  1626,     0,   217,  1203,     0,     0,   207,   209,   210,
       0,     0,   471,   468,   671,   470,   570,   593,   984,     0,
     583,   874,   875,   887,   924,     0,   887,   887,     0,     0,
     972,  1003,  1120,     0,   977,   813,   619,     0,   968,  1011,
    1044,     0,   620,  1005,   970,     0,  1620,   485,   969,   991,
     975,  1956,  1002,  1048,   855,   755,   704,   695,   774,   698,
     697,   774,   709,   759,   757,   727,   759,   759,   734,   733,
     751,   737,   717,   825,   825,   716,   754,   825,   738,   736,
     740,     0,   742,   759,   747,   735,   739,   756,   732,   729,
     753,   774,   774,   774,   713,   752,   825,     0,   745,   774,
     675,   778,   715,   825,   832,     0,     0,   774,   776,  2080,
     147,   152,   163,   164,   944,  2766,     0,  2764,     0,  1109,
       0,  1162,  1567,    99,     0,     0,     0,     0,     0,     0,
    1792,  1355,   772,   770,   773,   771,   821,   820,   824,     0,
     823,   832,     0,     0,  1292,  1287,   743,  1291,  1283,  1288,
    1380,  1358,  1359,     0,  1457,  1448,  1386,     0,  1335,  1417,
       0,     0,  1394,  1365,  1368,  1366,  1371,  1372,     0,  1401,
       0,  1195,  1195,   645,  2723,  1240,     0,  1932,  2678,     0,
       0,  2674,  2672,     0,  2673,  2671,  2639,     0,  2584,  2585,
    2583,  2567,     0,     0,     0,  1203,   512,     0,   529,   528,
     525,  1632,  1760,  1762,  1768,  1757,     0,  1606,  1621,   806,
    1691,     0,  1197,     0,  1506,     0,  1510,  1515,  1511,     0,
    1502,     0,  1646,  1561,     0,  1632,  1627,     0,   220,   218,
     219,     0,   213,   215,   210,  2777,     0,  2784,     0,     0,
    2782,   475,  2707,   587,   653,   571,     0,   986,     0,     0,
       0,     0,     0,     0,  1015,     0,     0,   974,   995,  1017,
    1009,  1008,     0,     0,  1132,  1618,   990,   992,  1087,     0,
       0,   859,   703,   696,   714,   712,   763,   758,     0,   763,
     763,   723,   741,   718,     0,   825,   731,   722,   743,   746,
     748,   750,   763,     0,   825,   711,   710,   720,   707,   763,
     786,     0,     0,     0,     0,   782,     0,   853,     0,   789,
       0,   676,   779,   781,     0,     0,     0,   744,   825,   700,
     833,   832,   702,   825,   832,   763,   763,     0,   154,   957,
     323,  2768,  1178,     0,  2773,     0,  1110,  1106,  1107,  1102,
     103,   135,     0,  1627,   920,     0,     0,  2398,  1647,  1798,
     831,   829,     0,  1460,  1627,     0,  1419,  1421,   835,     0,
    1535,   646,     0,  2645,  2644,  2643,  2640,     0,     0,     0,
       0,     0,     0,  2676,  2680,  1771,     0,     0,     0,   520,
       0,     0,   554,   569,  1614,  1627,     0,  1632,     0,  1696,
    1689,  1530,     0,     0,     0,     0,     0,  1780,  1549,  1550,
       0,     0,  1555,  1559,  1540,  1625,  2781,  2791,   217,     0,
       0,   158,     0,   208,   813,   211,   472,   482,     0,   477,
       0,     0,   985,   670,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1014,  2045,  1047,   486,  1006,   971,
       0,   976,   615,     0,   858,     0,   863,   767,   768,   769,
     724,   764,   766,     0,   726,   694,   719,   749,   725,     0,
     721,   708,   792,   791,  1210,   784,   799,   679,     0,     0,
     790,     0,   780,   788,   783,     0,   699,   701,   705,   706,
     692,   693,  2079,     0,   156,   349,     0,   335,   321,     0,
       0,     0,   325,   165,   168,   166,     0,   167,   173,     0,
     174,   175,   176,   177,   178,   169,   347,   348,   172,   170,
     171,     0,  2095,     0,  2096,  2771,     0,     0,  2770,  1105,
       0,  1112,   890,     0,   919,     0,   892,   894,  1648,     0,
    1203,  1793,   762,     0,  1462,  1333,  1403,  1959,  2641,  2681,
    2684,  2682,  2683,  1650,     0,  2685,  2679,     0,  1521,  1204,
       0,   513,     0,   516,   518,   532,     0,  1765,  1765,     0,
       0,  1765,  1765,  1765,  1765,   547,   555,   557,     0,  1615,
    1616,     0,  1611,  1613,  1607,  1679,   807,  2003,  2710,  1507,
       0,  1512,     0,  1504,  1545,  1545,  1556,   184,   214,     0,
       0,   150,   159,  2785,   797,  2000,     0,  2703,   988,     0,
       0,     0,   658,     0,     0,  2047,  2046,  1004,   980,  1047,
       0,   856,     0,   860,   861,   862,     0,   854,   765,     0,
     927,     0,     0,   798,  1210,   787,  1203,   796,   795,   793,
     794,   155,     0,   148,     0,     0,   334,   337,     0,     0,
     340,   330,   329,   331,     0,   324,   323,   323,   377,   328,
     374,   373,   366,  2707,     0,     0,     0,  1111,  1116,     0,
    1113,  1115,     0,  1765,   118,   891,   911,   910,   896,     0,
    1627,     0,     0,   121,   893,   913,   900,   124,   895,   912,
     898,  1649,  1799,  1627,  1652,  1651,  1777,  1785,     0,  1990,
       0,   521,   514,     0,     0,   530,     0,     0,  1765,  1765,
       0,     0,     0,     0,     0,   527,   556,  1765,  1627,     0,
    1186,     0,  2011,  1531,     0,     0,     0,  1553,  1551,  2792,
     216,  1203,   162,     0,   469,   479,   478,   987,     0,   664,
     890,   660,   662,  1007,     0,   857,     0,     0,   825,     0,
     825,  1211,     0,   785,     0,   157,   350,   361,   364,   356,
     336,     0,     0,     0,   326,   323,     0,   310,   308,   309,
     315,   316,   317,   318,   319,   320,   311,   314,   312,   313,
     323,     0,   225,     0,     0,  2772,     0,  2774,     0,  1108,
       0,   905,     0,  1023,   897,     0,   918,   921,     0,  1023,
     901,  1023,   899,  1461,     0,     0,   806,   508,   520,   517,
     540,   533,   536,     0,   566,   560,     0,     0,   562,   563,
     561,   558,   551,     0,   549,     0,  1612,  1680,     0,     0,
       0,     0,  2004,  2006,     0,  1697,  1509,  1514,     0,  1546,
       0,     0,     0,   194,   193,   185,     0,   323,  2778,     0,
    2786,  2707,   666,   890,   659,   892,   894,     0,   869,     0,
     868,     0,   865,   864,   728,   928,   730,  1212,   680,     0,
       0,   323,   357,     0,   332,     0,     0,     0,     0,   223,
     380,     0,   221,   368,   368,  2775,  2776,  1114,   904,   119,
    1025,  1024,   909,   908,   906,   907,   914,   122,   125,  1784,
    1786,  1991,   515,   540,     0,   538,     0,   534,   531,   535,
     564,   565,     0,   548,     0,   559,     0,     0,     0,     0,
       0,  2005,     0,     0,  2012,  2014,  1548,  1547,  1562,     0,
     195,  2793,     0,   164,   184,   480,   665,   661,   663,   993,
     871,   872,   870,     0,     0,   682,   681,   683,   358,   364,
     354,   362,   323,     0,     0,   322,   341,   376,   224,     0,
     378,     0,   323,     0,   367,   369,   371,  1027,  1026,  2017,
     537,     0,   545,   541,   543,   546,   554,   553,   550,  1203,
    2009,  2010,     0,  2007,     0,     0,  2013,     0,     0,     0,
     146,  2787,     0,     0,     0,   687,   677,   684,   686,     0,
     355,     0,     0,   353,   333,   338,   323,     0,   323,   236,
     235,     0,   227,   304,   375,     0,   226,     0,  2003,   539,
       0,     0,   552,     0,     0,  1683,  1685,  2008,  2016,  2015,
    1554,  1552,  2779,   323,   867,   866,   689,   688,   685,   359,
       0,   323,     0,   323,     0,   323,     0,     0,     0,     0,
       0,   222,     0,  2011,   544,   542,  1204,  1681,  1203,   323,
    2788,     0,   351,   323,   339,   344,   381,     0,   230,   305,
     306,     0,   233,     0,  2019,  1686,  1684,  2780,   323,   323,
     340,   343,   379,     0,     0,   228,   229,   241,   240,   232,
       0,  2018,     0,  2023,   323,   323,   345,   249,   247,   323,
     237,   245,   239,     0,   246,   307,   234,     0,     0,  2030,
       0,   231,   248,  2021,  2022,  2020,  2025,     0,     0,  2027,
    2028,     0,  1992,   238,  2029,  2024,     0,  2031,  2033,     0,
    2026,     0,  1203,  2032,     0,  1204,  2034
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   624,  1532,    60,    61,    62,    63,    64,  1373,
      65,   837,  1291,  1838,  1839,    66,   564,    67,  1599,  2157,
    2158,  3502,  3503,  2159,   662,   663,    68,  2531,  3510,  4443,
    3511,  4449,  3512,  4451,  1616,   627,   535,  2097,  2098,  1536,
    3361,  3081,  3988,  3085,  4144,  4293,  4251,  2115,  3492,  3989,
    3990,  4153,   559,  2529,  1571,  4379,  2077,  4495,  2078,    69,
     660,  1084,  1596,  1597,  3666,  3667,  3899,  3668,  3891,  3892,
    3893,  3894,  4612,  4415,  4532,  4613,  4698,  4733,  4739,  4740,
    4661,  4749,  4750,  4751,  4737,   914,  4752,    70,   587,   588,
     916,  1403,  1853,  1404,    71,    72,   558,  1317,  1318,  1319,
    1320,  2370,  1854,  2365,  2366,  3258,  4662,  4735,  4416,  4417,
    4300,  4418,  4156,  4419,  4304,  4420,  4159,  4421,  4422,  4423,
    4424,  4604,  4425,  4299,  4654,  4412,  4413,  4656,  4715,  4731,
    4426,  4166,  4294,  4519,  4167,  4295,  4599,  4408,  4600,  4649,
    4711,  4409,  4520,  4652,  4523,  4427,  4433,  4614,  4428,  4434,
    4429,  4171,  4311,  4432,  4309,  4431,  4658,  4609,  2965,  3360,
     647,   648,   675,  2183,   649,  1100,  1054,  1573,  2110,  2111,
    2566,  2567,  2680,  2681,  2682,  2102,  2103,  2104,  2169,  2170,
    2171,  2084,  2085,  2086,  1577,  2081,  2082,   650,  1055,  1065,
    2105,  2106,  2107,  2686,  2173,  2174,  2175,  2176,  2108,  1831,
    2109,  2986,  2971,  3903,  3902,  2972,  3675,  4257,  4501,  3376,
    3377,  3068,  3442,  2128,    73,   576,   894,  1370,  2414,  1371,
    2416,  2847,  2848,  2849,  1903,  1904,  3856,  1908,  2413,  4039,
    4458,  4212,  4213,  2851,  4211,  2855,  3284,  3285,  3608,  3858,
    4042,  4463,  4354,  4558,  4461,  4554,  4462,  4556,  4671,  4623,
    4624,  4365,  4473,  4474,  4562,  4626,  4225,  4226,  4227,  2434,
    2861,  3861,  3906,  2163,  1563,  1564,   628,   629,   630,  3390,
      74,  2973,  2623,  2974,  2975,  3465,  2625,  2626,  2815,  1461,
    3455,  3426,  3831,  3367,  3371,  3372,  3373,  3374,  3375,  4390,
    4505,  4506,  4503,  3475,  3388,  3001,  3002,  3073,  3478,  3760,
    3970,  4597,  4646,  4647,  4648,    75,   891,  4074,  3938,  3953,
    3762,  3763,  3764,  3765,  3766,  3767,  3768,  3158,  3159,  4110,
    4111,  4112,  3153,  3154,  3533,  3971,  3972,  3973,  4075,  4125,
    3526,  1427,  1428,  4049,  1439,  1440,  2462,  1948,  2463,  1567,
    3527,  3528,  3529,  3982,  3217,  3828,  3223,  3224,  3225,  2778,
    2779,  2780,  2781,  2782,  2308,  3974,  3477,  3931,  4103,  4106,
    4277,  4512,  3003,  3389,  3004,  3393,   996,   536,  3005,  3006,
    2189,  2190,  4324,  4333,  4337,  4325,  4338,  4334,  4326,  4327,
    4328,  4340,  4336,  3138,  4002,  4003,  3381,  3391,  3233,  4279,
      76,   130,  2113,  1046,  1057,  1053,  1076,   655,  1583,  2116,
    2641,  3774,   637,  2627,  3924,  3692,  3928,  2628,  3405,  2629,
    3907,  4082,  2630,  3709,  3926,  4100,  3406,  3407,  2631,  2632,
    2633,  3916,  3923,  4269,  4539,  4540,  4541,  3007,  1352,   652,
     653,  1069,  1070,  1071,  2356,  3473,  3051,    77,  2036,  2031,
      78,  1008,  1009,  1010,  1507,  1508,  2034,  2035,  2504,  2937,
      79,   665,  1603,    80,  1381,  2426,  2427,  2428,    81,  1077,
    1587,  1588,  2122,  3090,  3498,  3779,  3999,  4181,  3995,  4319,
    4320,    82,    83,   666,  1610,  1611,  1612,    84,  1364,   137,
      85,   902,  1376,  1378,  1379,    86,   659,  1078,  1079,  1080,
    1081,  2124,    87,  1894,  2398,  2399,  2400,  2401,  1593,  2645,
    1594,  1595,  2133,  3277,    88,    89,   621,  2316,   593,   926,
     594,   595,  1942,  2453,  3832,   937,   938,   939,  2890,  1417,
    1418,  1419,  1900,  2895,  4283,  1147,  1143,   800,   801,   802,
     803,  1237,  1238,  3975,   804,  1247,  1797,  3170,  3548,  1656,
    1657,   805,   806,   807,   808,   809,   810,  1824,  3189,  3190,
    3563,  2343,  2344,  2345,   811,  2230,  3176,  2243,   812,  1230,
    1782,  1712,  3555,  3182,  3813,  4013,  1641,  2206,  2727,  3161,
    2811,  2310,  1169,  1170,  1128,  2213,  1647,  2042,  2043,  2044,
    2045,  2046,  3650,  3651,  4052,  3875,  4054,  3879,  2514,  2515,
    1923,  1924,  2047,  2048,  2938,  3873,  4238,  2311,  2312,  2313,
    3581,  2939,  3338,  2956,  2957,  3885,  2505,  2049,  2945,  4377,
    4061,  4062,  4492,  4491,  4063,  3883,  3884,  3655,  3656,  3093,
    3094,  3095,  2875,  1703,  1704,  1710,  1347,  1348,  1642,  2395,
    2835,  3868,  4046,  2334,  3627,  4044,  4232,  2636,  3434,  3435,
    2455,  2456,  2960,  3353,  3661,  1464,  3833,  2837,  2001,  2925,
    2926,  3790,  4205,  4738,  2783,  2921,  2987,  1674,  1675,  3441,
    4370,  4566,  4674,  4675,  4676,  3313,  3314,  3631,  3632,  2457,
    2887,  3315,  3869,  4237,    90,   540,    91,  1836,  2814,  1288,
    2362,  1088,  1383,  1628,  1629,   824,   554,    92,   565,  2396,
      93,   583,  1921,   881,   906,  1384,  1385,  2435,  2862,  2869,
    2436,  2874,  3618,  2864,  3290,  3291,  2351,  2352,  2865,  3293,
    3615,  3596,  3597,  3272,  3853,    94,   609,  3348,  2951,  2952,
    4346,  4347,   907,    95,   539,  1115,  2703,  4009,  1634,  2194,
    4191,  1116,  1117,  2197,   684,   685,    96,  1013,   605,  1487,
    1488,  1489,  2019,    97,   597,   997,  2922,  3331,  1995,   898,
    1283,  1468,  1000,  1469,  1981,  2485,  1450,    98,  1042,  1041,
    1558,    99,   633,  1559,   100,   838,  1311,  1849,  2821,  2822,
    3243,  1312,  1313,  2363,  3837,   101,   584,   911,   912,  1388,
    2439,   102,   578,   899,  1914,   103,   568,   886,  1356,  1893,
     104,   105,   106,   888,  3278,  4456,  4619,   572,  1896,  1360,
    3676,  4372,  4482,  4483,  4485,  4574,  4575,  4668,  4743,  4765,
    4759,  4768,  4769,  4772,  4777,  4778,   814,  1022,  1023,   815,
    4094,   816,   817,   818,  2870,  2871,  3354,   819,  2872,   820,
    3074,  1089,  1631,   562,   514,   644,  1024,  2843,   822,  4173,
    1049,  1285,  1107,  1108,   516,   517,   107,   596,   954,  1444,
    1434,  1443,  1968,  2479,  1972,  2481,  2482,  3327,  2913,  3328,
    2914,  1002,  1964,  1969,  2915,   957,  1957,  1958,  1959,  1960,
    2906,  1954,  1978,   108,   889,   521,  1362,  1363,  2407,   109,
     608,   110,  1349,  1886,  1887,  2392,  2834,  2393,   111,   920,
     921,   112,   866,  1620,  2376,  1102,  1052,  1103,  1872,   869,
    1323,   870,   871,  1338,  1332,  1341,  1335,  4027,  3845,  3846,
    2380,  1287,  1109,  1933,  2187,  3134,  1110,  1863,  2372,  2373,
    3591,  3848,  3262,  4033,  4034,   113,   138,   524,   668,  1095,
    1411,   114,   115,   116,   117,  1414,  1527,  2449,  1528,  2317,
    1529,  1530,  2056,  1940,  1778,  1779,  3231,  1227,  1228,  2320,
    2787,  2788,   940,  1035,  1546,  1538,   131,   132,   133,   134,
    1074,  1075,  2642,  3087,  3494,  3777,  3778,  3994,  4178,  1540,
    4070,  4582,  4709,  1541,  1542,  3362,  4072,  4383,  4584,  4683,
    1543,  2962,  3663,  4247,  4497,   118,  1025,   618,  1525,  1520,
    1522,  2052,  2522,   119,   120,   121
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4102
static const int yypact[] =
{
    3590,  2421,  1499, -4102,   494,   884, 57559,   992,  -167,  -167,
     748,  3223, -4102, -4102, -4102, -4102, -4102,  3741, -4102, 57559,
    1499,  1284, -4102, 25776, -4102, -4102,   784, -4102,    85,  -167,
    1499,   987, -4102, 57559, -4102,  1177,  1416,  1499, -4102, -4102,
   50574, -4102,   748, 57559, -4102, -4102, -4102, -4102, 50574,   268,
     206,  1136,  1097, -4102, -4102, 57559,  1293, -4102,   585,  1780,
    1634, -4102, -4102,  1395, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102,  1085, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, 26414,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  1653, 57559,  1674, 57559,  1597, 57559, 48669, 57559,
   -4102,  1677, -4102, -4102,  1735, -4102, -4102,  -167,   748, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  1219, -4102, -4102,   494, -4102,
   -4102, -4102, -4102, -4102,  1864,  1657, -4102,  1701,  1454, -4102,
   48669, -4102, 57559, -4102, -4102, -4102,  1678,  1692,  1703,    79,
   12153,  1714,  1714,  1714,  1714,  1744,  1714, -4102,  1714, 57559,
   -4102,  1714, -4102,  1714,  -167, -4102, -4102, -4102,  1818, 36604,
   57559,  1608,   191,   -92, 48669,   227, 57559,   494,    58, -4102,
    1742, -4102, -4102, -4102,  -167, -4102,  1952,  1807,  1029, 57559,
   -4102, -4102,  -167,   970,  1335,  1409, -4102, -4102,  1540, -4102,
   37239,   171, -4102, -4102, -4102,  2446, 28328,  5746,  1540,  1539,
     494,  -121,  1555,   494, -4102, -4102, 57559,   494,  -167,  1767,
   -4102, -4102,   162,   162,   162, -4102,   162, -4102,   162, -4102,
     585,  1414, -4102, -4102,  1443, 57559, -4102,  1683,  1558, -4102,
    1562,  1497,  2209, -4102, -4102,  1471,  1158, -4102,  1534, 41049,
   -4102, 57559, -4102, -4102, -4102, -4102,  1771, -4102, -4102, -4102,
    1110, -4102,  1601,    80, 57559,  1635, -4102, -4102, -4102, 25776,
    1519, 57559,  1602, -4102, -4102, 25776, 25776,   964,  1348,  1708,
   57559, 57559, -4102, 45494,  1992, -4102,  2199, 41049,  1657,  1657,
    1657, -4102, -4102, -4102, 51209,    79,  1545,  1576,  1581, 17409,
   -4102,  1593,  1605,  1623, 12153,  1629,  1633,  1639,  1670,  1679,
    1682,  1684,  1687,  1700,  1709,  1712,  1721,  1725,  1734,  1734,
    1734,  1740,  1747,  1775,  1789,   575,  1795, -4102,  1798,  1800,
    1805, -4102, -4102,  1808,  1811,  1813, -4102, -4102,  1834,  1837,
    1844, 12810,  1846,  1856,  1862, -4102, 22574,  1877,  1884,  1899,
    1935,  1955,  1960,  1968,  1971,  1988, -4102, -4102, 12153,  1740,
   -4102, -4102,  1990, -4102,  2003,  2017,  2045,  2047,  2049,  2054,
    2058,  2063,  2072,  2074,  2076,  2100,  2102,  2109,  2112,  2119,
    2130,  1740, -4102,   969,  2133,  2138,  1237,  2140, -4102,  2158,
   -4102,   193,  2160,  1734,  1740,  1740,  2166,  2179,  2185,  2196,
    2202,  2206, 17409, 17409, 17409, 12153, -4102, 57559, -4102, 57559,
    2296,  3599, -4102,  2940, 17409,  1047, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  1599,  1688, -4102, -4102, -4102, -4102, -4102,
   -4102,  2208,  1669,  2165, 57559, 57559, 57559, 57559, 57559, 57559,
   45494, 48669,  1759, 57559, 46129, -4102,  1714,  1748,  4594, 31513,
    1931,  1912,  1940,  1734, -4102, -4102,   649,   679,   736,  2014,
   -4102, -4102,  1855,   752,  2095, -4102,   759,   194, -4102,    94,
     813,   881, -4102, -4102, -4102, -4102, -4102, -4102,  1921,  2204,
    1938, -4102, -4102,   131, -4102, -4102, 57559, -4102, -4102, -4102,
   -4102,  2299,  2090, -4102, -4102, -4102,   165,  2554,   217, 25776,
   -4102,  2012, 12153,  1595, -4102,  1205, -4102, -4102,  2401, -4102,
   -4102, 46129, 25776, -4102, -4102, -4102, 23214, -4102, -4102,  2748,
   -4102,  2187, -4102, -4102,  1688,  3738, -4102,  2461,  1931,  2487,
   -4102,  2666, -4102,  2494,  2402,  1348,  2288, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102,  2239,  2446, -4102,
   -4102,    68,  2405,  2244,    78,   210, 40414,  1075, 48669,   232,
      69, 28965, 41684,  2253, -4102, -4102, -4102,  1079,  2396, -4102,
    2754, -4102, -4102,    -7, -4102,  2279,  2376,    -7, 46764,  2663,
    1153, -4102,   262, -4102,  2746, -4102, -4102, -4102, -4102, -4102,
    2413,  2406,  2440, -4102,   360,  2706, -4102,   494, -4102,   801,
   -4102, -4102,  2420, -4102,  2663,    -7,  1153, -4102,  2674,  2810,
     625,  2782,  -163, -4102, -4102, -4102,   -98,  2896, -4102,  2345,
   -4102, -4102, -4102, 25776, -4102, -4102, -4102,  2299, -4102, -4102,
   -4102, -4102,  2355, -4102, -4102,  2641,  2474, -4102, -4102,    32,
   -4102,  2372,     9,  2870, -4102, -4102,   750,   -82,  1735,  1657,
   -4102,  2233, 42319, -4102, -4102, -4102,  2902,  2923,  1734,  2394,
   -4102, -4102, -4102, -4102, -4102,  3050, -4102, -4102,  2426,  2966,
    2966,  2966,  3092, -4102, -4102, -4102, 25776, -4102, -4102, -4102,
      80, -4102, -4102,  2613,  2480, -4102,  1635, 25776,  2849,  2451,
   -4102, -4102,  2707, 12153, -4102, -4102, -4102,   665, -4102, -4102,
     203, -4102,  3052,  2665, -4102, -4102, -4102, -4102,  2934, -4102,
   -4102,  3050,  -242, -4102,  2999,  2966,  2888, -4102,  2890,  2468,
   -4102, 57559, 57559, 57559, 25776, -4102,  2470, -4102,  2469, -4102,
   12153, 12153,   346,  3056,  3121,  3121,  3121,  2296,  2504, 12153,
   12153, 12153, 12153, 12153, 12153, 12153, 12153, 12153, 12153, 12153,
   12153,  1038,  2486, -4102, -4102, -4102,  1786, -4102,  2489, 12153,
   12153, -4102, 12153, 12153, 27052, -4102,  3277, 12153,   356,  2995,
   12153, 12153, 12153, 12153,  3033, 12153, 12153, 12153, 27052,  3135,
    2491, -4102,  2488,  1613, 12153, 12153,  1665, 12153, 12153, 12153,
   12153, 12153, -4102, -4102, 12153, 12153, 12153, 12153, 17409, 12153,
   12153, 12153, 12153, 12153, 12153,  2499, 12153,  3121,  3121, 12153,
   12153,  1690, -4102, -4102, 12153,  1966,  1966, -4102, 12153,  8868,
   12153, -4102, -4102,  2501, -4102, -4102, -4102, 27052,  3121,  3121,
   12153, 12153, 12153,  3056,  3056,  3056,   218,  2507,   614, 12153,
   29602,  2503, -4102, -4102, -4102, -4102, 12153, 12153, 12153, -4102,
   17409, -4102, -4102,  2397, -4102, -4102, -4102, 13467, 17409, 17409,
    2512, 17409, 17409, 17409, 17409, 17409,  2892, 17409, 17409, 18066,
   18723, 17409, 17409, 17409, 17409,   944,  3056, 48669, 17409, 12153,
   -4102, -4102, 57559, -4102, -4102, -4102,  2505,  2795,  1759, -4102,
    2518, -4102,   645,  3013, -4102, -4102, -4102,  2529, 25776, -4102,
    2525, -4102,  2898, -4102, -4102,  2900,  2901,  2904, -4102, -4102,
   -4102, -4102, -4102,  3139,  2907, -4102,   494,  2916, -4102, -4102,
   -4102, -4102,  2551, -4102, -4102, 19380, 48669, -4102,  2558, -4102,
    3041, -4102, -4102, -4102, -4102, -4102, -4102,  2656, -4102, -4102,
   -4102, -4102,  2569, -4102, 46129,  2569, -4102, -4102,  2569, -4102,
   -4102,  2569, 41049,    77,  3711, -4102, -4102, 57559, -4102, 58194,
   -4102, -4102, 23214,   494, -4102,  2994, 14124, -4102, -4102, -4102,
    2942,   128,  2573, -4102, 25776, -4102,  2296, -4102,   100,   100,
    2830,   161, 48669, -4102, -4102,   136,  2574,  2658,  2580, -4102,
    2669, 25776, 25776, -4102, -4102, -4102,  2840, -4102,   494,  1335,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  2591,  3083,  3053,  2596, 46129, 41049,   840,
   -4102, 57559, -4102,  1749, -4102, -4102, -4102,  2603, -4102, 12153,
   -4102, -4102, 57559, -4102, -4102, -4102, -4102, -4102,  3180, 12153,
   -4102, 46129,   -70, -4102,   973,    55,  1079, -4102, -4102, -4102,
   -4102, -4102, 57559, 51844,  2608,  9525,  2736,  3023,   494, 12153,
   -4102,  2629,  1657, 57559, 57559, 57559, 25776, 57559, 25776, -4102,
     753,   753, -4102, 42954, -4102, -4102, -4102, -4102,    -7, 57559,
   57559,    -7, 41049, -4102,  1153,   -17, 57559,    -7, -4102,  3024,
    2728, -4102, -4102, -4102,  3097, -4102, -4102,  3089,  2633, -4102,
    3120, -4102, -4102,  2761,  1153, -4102, -4102, 25776, -4102, -4102,
    1153, -4102,  1153,  1153, 12153,    -7,    -7, -4102,   -63, -4102,
   -4102, -4102,  2797,  -121, -4102, -4102, -4102,   953,   162,  2885,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
      62, -4102, -4102, -4102, -4102, -4102, -4102,   219, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  1428, -4102, -4102, -4102, -4102,
   -4102,  1635, 25776, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,    49, -4102, -4102, -4102,  2245,  3169, -4102,
   48669,  2828,   700,  1510,  2828,  1947,   494,   685, -4102,   685,
   -4102, -4102, -4102,  2936,   991, 25776, -4102,  2662, -4102,  2909,
   52479, 25776, -4102, -4102, -4102,  1630,  2664,  2668,  2296,  4096,
   -4102, -4102, 25776, -4102, -4102, -4102, -4102,  2717, -4102, -4102,
   -4102, -4102,  3026, -4102, -4102, -4102,    81,  1446,  3313, 45494,
   -4102,  2690,  2729,   117, 41049, -4102, -4102, -4102,  2682, -4102,
    2840, -4102,  1487, 57559,  3147, 34057, -4102,   313,   792, -4102,
    3121,  2697, -4102,  2698,  2703,  2704, 12153,   202,   333,   933,
    1588,  1457,  1232,   379,  1262,   389, -4102,  1515,   391,   428,
     447,   253, -4102,  2705,  2712, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  2708, -4102, -4102, -4102,   517,   531,  1285,
    1298,  2710,  2711, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  3168, -4102,  1548, -4102, -4102, -4102, -4102,
    2718, -4102, -4102,  1410,   598,   859,   259,  2731,  1636,   863,
    1650,  1705,  2723, 27052, 57559,  3121,  2727,  1427,  1437,  3121,
    2732,   867,  1469,  1741,  1761,  1764,  1490,  1550,   871,  1792,
    2552,  1582,   889,   911,  1587,   952,   959, -4102,  1598,  2733,
    2734,   997,   211,  3121,  2740,   281,  2730,  2742,  1614, 10182,
   10839, 11496,  1170,  1002, -4102,  2741, -4102,  2488,  2745,  2751,
     294,   207,  1644, -4102, 12153, -4102, -4102,   950,    93,  2787,
     153,    55, -4102,  2889, 57559,  2475,   169, -4102, -4102, -4102,
   -4102, -4102, -4102,   980, -4102,  2755, -4102,  2762,  1142,  2763,
   12153,  1008,  2763,  2784,  2875,  2875, 17409,  2829,  2893, 12810,
    1126, 12810,  1126,  2763,  2763,  2763, -4102, 17409,  2766, 17409,
   17409, -4102,  3056,  2296,  2768,  1350, 57559, 25776,   645, -4102,
   -4102, -4102, -4102,  1079, 46129,   179, 25776, 48669,  2770, -4102,
   -4102, -4102, -4102, -4102, -4102,   494, -4102, -4102,  4775, 25776,
    2853,  2876,  2879, -4102, 32150, -4102, -4102, -4102, -4102, 32150,
     -28, -4102, 57559, -4102,  2869, -4102, -4102, -4102,  -236, 23852,
   23852, -4102, 23852, -4102, -4102, -4102, -4102, -4102,   194, -4102,
   -4102, -4102, -4102,   231,   250,  3696,  2818, -4102, -4102, -4102,
   -4102, 33422,  2296, -4102, 25776, -4102,  3209,   804, 25776,  2801,
   -4102,  2802, -4102, -4102, -4102, -4102, -4102,  2756,  2912, -4102,
    3451, -4102, 12153,   494, -4102, 46129, 46129, 25776, 25776,    57,
   -4102,  1321,  2811, -4102, -4102,  3454, -4102,  3738, 19380, 45494,
    3258,  3271, -4102,  2816, 23852, 23852, 23852, -4102, -4102, -4102,
   -4102, -4102,  1280,  2296, -4102,  2820, -4102, 47399, -4102,  2296,
    1079,  2819,  2833, -4102, -4102,  3213,   716, -4102,  2835,  2836,
   -4102,  2822,  2831,  2837, 53114, 12153, -4102,   973, -4102, -4102,
    1079, -4102, -4102, -4102, 17409,  1798, -4102,  2296, -4102, -4102,
     494,  3295, -4102,  2296,  2842, 57559, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  3323,
   -4102,  3028,   607, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
      -7, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  3085,  2663,
    2706,  3023, -4102,    -7,  1153, 25776,    -7,    -7,  2296, -4102,
   -4102, -4102, -4102, -4102,  2852, -4102,  2913, -4102, -4102, -4102,
   -4102, 57559,  1105,  3021, -4102,  2862, -4102, -4102, 25776, -4102,
    2863, -4102,  3322,  3479,  2663, -4102, -4102,  3329, 57559, 57559,
    1657, 57559, 57559, -4102, -4102, -4102,  1079,  1079,  3182, -4102,
     494,  3009,  3011,  3020,  3022,  3025,  3054, -4102, -4102,   494,
     494, -4102, -4102,  1079, -4102,   662, -4102, -4102, -4102, -4102,
     494,   494,   494,   494,  3081,   494,   494,  1853, -4102, -4102,
    1079,  1079, -4102,  1942, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  1344, -4102,  4737,   499, -4102,  3099, -4102, -4102, -4102,
   25776,  3349, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  2899, -4102, -4102, 12153,  3385,  3387,  3388,  3389,
    3392,  3393,  3394,  3395,  3397,  3400,  3402,  3407,  3409,  3410,
    3411,  3414,  3416,  3417,  3426,  3427,  3429,  2943, -4102, -4102,
   -4102, -4102, -4102, -4102,    98,  1079,  1079,  1079,  1079, -4102,
    2361, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, 41049,
   -4102, 48669,  3318,   246,  1134, -4102, -4102, 48669, -4102,  1455,
    3232,  3233,  3239, 57559,  3010, -4102, 34057, -4102, -4102,   953,
   -4102,  2956, 14781, -4102,  2965, -4102, 12153, -4102, -4102, -4102,
     699, 12153, 12153,  3460,  2302, -4102, 48034, -4102, -4102, -4102,
   12153, -4102, 12153, -4102, 12153, 12153, 12153, 12153, 48034,  2302,
   12153, -4102,  2971, -4102,  3377,  3380, -4102, -4102, -4102, -4102,
   12153, -4102, 12153, 12153, -4102, 12153, 12153, 12153, 12153, -4102,
   12153, -4102, -4102, 17409, -4102,  2969,  2977, -4102, -4102, -4102,
    2979, -4102, 12153, -4102, -4102, -4102, -4102, -4102, -4102, 12153,
   -4102, 12153, -4102, 12153, 12153, -4102, 12153, 12153, -4102, -4102,
   -4102, 15438, 12153, 12153,  2980, -4102, -4102, 12153, 12153, 12153,
   -4102, 12153,  1266, 12153,  1382, 12153,  1842, 12153, -4102, 12153,
   -4102, -4102, -4102, -4102, 12153,   382,  2756,  3081,  2981, -4102,
    1887, -4102, -4102,  1696, -4102,   950,  2982, -4102, -4102,  1749,
   -4102, -4102, 48669, 12153, -4102, -4102, -4102, -4102, -4102, -4102,
   17409,   300,  2983, 17409, -4102,  2784,  3033,  3033,  2027, 12153,
    1008,  2784, 12153,  2989,  2990, -4102, 12153, 57559, -4102, -4102,
   -4102, -4102, 48669, -4102, -4102, -4102, -4102,   179, -4102,  2525,
   -4102, -4102,  2801,   280,  3478,  2992, -4102, -4102, -4102, -4102,
   -4102, -4102,  1902, -4102, 41049,  3639, -4102,  2987, -4102,  2996,
    3076,  3077,  3078, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  2663,  1321, -4102, -4102,  2998,
   -4102, -4102,  2707,  3093,  3027,  3376,  3571, -4102, -4102, 57559,
   17409, -4102,  3612,  3012,  3016,  3497,  3018,  2296, -4102,  3090,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,   774, -4102,
   -4102,  3029,  3029, 21296, -4102, -4102, -4102, 57559, -4102, -4102,
    3500, -4102, -4102,  3293, 46129, 41049,  3480,  3481,  3482,   956,
   -4102,   318, -4102,   172,  3428,  2663, -4102,  3484, 49304, -4102,
   34692, -4102, -4102, -4102, -4102,   -70,  3114,  3123,  1563, -4102,
   -4102,  3431,  3253, -4102, -4102, -4102,  1079,  2296, -4102,  2608,
    9525,  3034, 30239, -4102,   812, -4102,   291, -4102, 43589,  3514,
   43589, 43589, -4102,  3325, -4102, -4102,  3295, -4102,  2818,  1153,
   -4102, -4102,   -63,  3001, -4102, -4102,  1011,  3432,  3437, -4102,
    3311,  2594,  3311, -4102, -4102,  1011, 27052,   953,  2840, -4102,
    3081,  3372, -4102, -4102, -4102, 57559, -4102,  1506, 57559,  3055,
    -156,  4963, 47399, 44224, -4102, -4102, -4102, -4102,  3589, -4102,
    3592,  1479, -4102, -4102,  1390,  1510, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  1947,  1390,  1390,   685, -4102,   120, -4102, -4102, -4102,
   -4102,  2719,  1079,  3631,  3315,  1079,  1079,  3631,  1079,  3317,
    3319,  1079,  1079,  3150,  3588,  1079,  3452,  3177,  2991,  3473,
    1079,  3335, -4102,  3184,  3594,  1079,  1079,  1079,  1079,  1079,
    3631,  3341,  3693,  1079,  1079, -4102,  1079,  3343,  3344,   157,
    3345,  3347,  1079,  1079,  1079,  1079,   940, 57559,  1079,  1079,
    3350,  1079, -4102, -4102,  5548, -4102, -4102, -4102, -4102, -4102,
   -4102,  -113, 24496, -4102, -4102, -4102, -4102,  1079,    17,  1568,
    3179,  1778,  3098, -4102,   362,  3101, 53749,  2296,  3102,  3081,
     494,   494,   812,   494,  3081,   494,   494,   494,   494,   494,
     494,   494,  3081,  3081,   494,   850,   908,   494,  3081,  4096,
     494,  2756,  1390,  1390,  1446, -4102, -4102,  3374,  3545,  1079,
   -4102,  2632, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  3198, -4102,   147,   925,   925, -4102, 25776, 25776, 25776,
   -4102,  3103,   953,  2818,  1589,  2818,  3115, -4102, 12810,  1672,
   -4102,  2296, 12153,  2296,  1948, -4102,  3109,  3109,  3109, -4102,
    3116, -4102, -4102,  3109,  3520,  3109,  3521,  3122,  3124,  1941,
     454, -4102,  1965,   559,  1695,  3133,  3134,  1599, -4102, 12153,
   12153,  1732,  1736,  -119,  1030,  1032,   304, -4102,  1755,  2684,
   -4102, -4102,  1766,  1829,  1879,  1881,  1036,  1908,  1975, 12810,
    1927,  1045,   348, -4102,  1932,  1041,  1071,  1936, 12153,  1973,
   12153,  1978, 12153,  1996,  2013,  2029,  3137,  3137,   195, -4102,
    3119, -4102, -4102, -4102,  3136, -4102, -4102,  2239,  1696, -4102,
   -4102,  3140, -4102, -4102,  3142,  2296,  3143, -4102, -4102, 12153,
   -4102,  1047, -4102, -4102, 17409,   384,  3144, -4102,  2296, -4102,
   -4102,  3146,  1599, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
    3365, -4102, -4102,  3722, 32150, -4102, 57559,  -204,  3424,  3127,
   35327, 41049, 41049, 41049,  3155, 12153, -4102, -4102,  3433, 25776,
   -4102,  3577, -4102, -4102, -4102, -4102, -4102,  3159,  3171, -4102,
   -4102, -4102,  2784,  3546,  3423, -4102, -4102,  2756, 57559, 46129,
   -4102,  2446, 27052, -4102,  3173, -4102,  3173,  1385,  3175,  1979,
   -4102, -4102, -4102,  3170,  2288,  2000, -4102, 19380,  3638,  2529,
   -4102, 41049, 41049, 41049, -4102,  2818,  2818,   132,  3229,  3586,
   -4102, -4102, -4102, -4102, 54384, -4102, -4102, -4102, -4102,  1429,
   -4102,  3186,  3187,   212,  3413, -4102, -4102, -4102, -4102,  9525,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  2663, -4102, -4102, -4102, -4102, 43589, -4102, -4102,
   -4102, -4102, -4102,    -7, -4102,  3679, -4102,  3191,  -215,    93,
   -4102,  1107, -4102, -4102, -4102,  3597,  3311,  3311,  1011,  3603,
     935,  3193, -4102,  1079, -4102,  1815, -4102,  2446, -4102, -4102,
   12153,  3384,  3197, -4102, -4102,   118, -4102, -4102,  1055, 25776,
   20020, -4102, -4102,  3459, -4102,  4255, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  1344, -4102, -4102, 27690,  1657,
   -4102,   518, -4102,  1657, -4102,  1630,  1630,  1657, 55019, 27690,
    1499,   812,  3081,  1714,  3081, 55654,  1499,   494,   494,  2598,
    1079,  3081, -4102, -4102,  3601,  1714,  3606,  1714,  1714, -4102,
   48669, 57559, -4102,  1079,   151,  3081, 56289,   812,   812,  1714,
    1499, 27052,  1042,  2215, -4102,   494,  1499, -4102, -4102, -4102,
   -4102, 25776,  1499,  1499,  3449,  2812,  2926,  2984, -4102, -4102,
   -4102,  3081,  2215, 55654, -4102, -4102,  5861, -4102, -4102, -4102,
   20658, 57559,   328,   888, -4102,  3199, 38509,  3438, -4102, 12153,
   12153,  3490, 57559,  3494, -4102,  3788, 57559,  3853, -4102,   148,
   -4102, 55654, -4102,  3220, -4102,  3222, -4102,  3081, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102,  3226, 57559,  1390,   246,
   -4102, -4102, -4102, -4102,   494, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, 34057,  2818,  3495, -4102, -4102,  3033, -4102,
    2296, 12153,   927, -4102, -4102,   190, -4102,  1171, -4102, -4102,
   -4102,  3227, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  2584,
   -4102, -4102,  2302, -4102, -4102, -4102,  3231,  3033,  3033, -4102,
   -4102,  3834,  3403, 12153, 12153, -4102, 12153, -4102,   245,  3235,
    3263, -4102, -4102, -4102, -4102, 12153, -4102, -4102,  3033, -4102,
   12153, -4102, -4102, 12153, -4102, 12153, 12153, -4102,  2087, -4102,
    2113, -4102,  2117, -4102, -4102, -4102,  2756,  3242,  3623, -4102,
   -4102, -4102,  2756,  3434, -4102, -4102,  2756,  3081,  2603, -4102,
   -4102,   614, 57559, -4102, -4102,  2025, -4102, -4102, 12153, -4102,
   49304, -4102, -4102,  3717,  3617, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  3695, -4102, -4102, -4102, -4102,  -136,  -136,  -136, 16095,
    2296,  3751, -4102, -4102, -4102,  3577,  3637, -4102,    66, -4102,
   57559,  3254,  1616, -4102,  2041, -4102, -4102,  3255, -4102,  2239,
    3257, -4102,  1079, 16095,  3029,  3435, -4102, -4102,  1385, 27052,
   34692, -4102, -4102, 57559, -4102, 41049,  2816,  2816,  2816,  2663,
    3700,  3093,  3093, -4102, 30876, -4102, -4102,  3430, -4102, -4102,
   35962, -4102, -4102, -4102, -4102, -4102, -4102, 30239, 53114, -4102,
   -4102,  2663, -4102,   494,  1656,  1749,  2520, -4102,   953, -4102,
    1011,  3659,  3661, -4102,  1011, -4102, -4102, 27052,  2818, 16095,
   -4102,  2239,  2296,  3268,  1776,  1055, -4102, -4102, -4102, -4102,
    3550,  3551, 57559, -4102, -4102, -4102, -4102,  3418, -4102, 25776,
    3274,  3276,  3278, -4102, -4102, -4102,   266, -4102,  6491, -4102,
   -4102, -4102, -4102,  1499,  3279,  3668,  3671,  1630, -4102,  1657,
   27690, -4102, -4102,  1657,  1657, -4102, -4102, -4102,   135, 55654,
   -4102, -4102, 27690, -4102, -4102, -4102,  3281, -4102, -4102,  2756,
   -4102, -4102, 44224,   494, -4102,  1714, 57559, -4102, 27690, 27690,
   -4102,  3307,   494, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, 27690, 55654,  3283, -4102,  1776, -4102, -4102, -4102,
   -4102, -4102,  1952, -4102, 55654, -4102, -4102, 55654, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  3286,  3043,  2655, -4102,  3287,
   -4102, 57559, -4102, -4102, 25776, -4102, -4102, -4102,  6945, 57559,
   -4102, -4102, -4102, -4102, -4102,  2296,  3033,  3857, -4102, -4102,
    3444,   494,  3791, -4102,  2050, -4102, -4102, -4102,  3710,  3297,
   -4102, 53749,  2066, -4102, -4102,  1947, -4102, -4102, -4102, -4102,
    3299,  3300,  3305,  2956, -4102,  3682,  -214,  2296,  3309,  3312,
    3321,  3324,  3925,   180, -4102,  3931, 48034, -4102, -4102, -4102,
    2069,  3602, -4102, -4102, -4102,  3109, -4102,  3116, -4102, -4102,
   -4102,  3914, -4102, -4102,  3109,  3726,   190, -4102, -4102,  3328,
   -4102,  3330,  3331, -4102,   162,  3332,  2175,  1124,  2080,  3643,
    3714, -4102,  3563, -4102,  2182,  1370,  2189,  2191,  2230,  2243,
   -4102, -4102, -4102, -4102, -4102,  3338, -4102, -4102,   465, -4102,
    3339,   918,    93, -4102, -4102,  2104, -4102, -4102,  3975,  3613,
    1527,  3368,  3368,  3368,  1798,  2296,  2121, -4102, -4102, -4102,
   -4102, -4102, -4102,  3745, -4102, -4102,  3346,  3451, 57559, -4102,
    3423, -4102,  2603, 27052, 16095,  3348,  3351, -4102,     9, -4102,
   -4102,  3340, -4102, -4102,  2816, -4102,  3951,  3785, -4102, -4102,
   48669,  3352, -4102, -4102,  3665, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  2862,  2059,  3401,  1011,  1011,  3356,  3404,
   12153,  3355, -4102,  3495, -4102, -4102,   315,  2603, 12153, -4102,
   -4102, -4102,  3499,    20, -4102,  3531,  3361,  3362, -4102, -4102,
     494,  3364, -4102, -4102, 20658, -4102,  3996, -4102, -4102, 12153,
    1657, -4102, -4102, -4102, -4102,  3366, -4102, -4102,  3888,  3889,
   -4102, -4102,  3026, 57559, -4102,  3180, -4102, 27690,  3281, -4102,
     470,  3465, -4102, -4102, -4102, 27052, -4102, -4102, -4102, 57559,
   -4102, 25776, -4102, -4102,  3370, -4102,  3109,  3109,  3109, -4102,
   -4102,  3109, -4102,  3116,  3615, -4102,  3116,  3116, -4102, -4102,
   -4102, -4102, -4102,   190,  1495, -4102, -4102,   190, -4102, -4102,
   -4102,   126,  1040,  3116, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  3109,  3109,  3109, -4102, -4102,   190,  3109, -4102,  3109,
   -4102,  2775, -4102,   187,   129,  3109,  3109,  3109,  3227,  3363,
   -4102, -4102, -4102, -4102, -4102, -4102, 57559, -4102,  1015, 57559,
     149, -4102, -4102, -4102,  3081,  2124, 57559, 57559, 57559, 44859,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, 48034,
   -4102,  3993,  3660,  3378, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, 12153, -4102, -4102, -4102, 12153, -4102, -4102,
    3697,  3855, -4102, -4102, -4102, -4102, -4102, -4102,  3391, -4102,
    3081,   172,   172, -4102, -4102, -4102,  3895, -4102, -4102,  3483,
    3488, -4102, -4102,  3489, -4102, -4102,   138,  2450, -4102, -4102,
   -4102, -4102, 16095,  3780,  3496, -4102, -4102,  3415,  3443, -4102,
   -4102,   918, -4102, -4102, -4102, -4102, 12153, -4102,  3495,  2598,
   -4102, 30876, -4102,   614, -4102,  3458, -4102, -4102, -4102,  3464,
    2296, 57559,  3682, -4102,   317,   918,  1776,   494, -4102, -4102,
   -4102,  3406,  3412, -4102, -4102, -4102,  1568, -4102, 57559,  6945,
   -4102, -4102,     9,  5548, -4102, -4102,  1039,   930,  2254,  3420,
    3421, 57559,  3440,  3441, -4102,  3600, 27690, -4102, -4102, -4102,
   -4102, -4102, 25776,  6945,  1499, -4102, -4102,  3281,   774,  3408,
   57559,  3740, -4102, -4102, -4102, -4102,  1301, -4102,  3442,  1301,
    1301, -4102,  2405, -4102,  3462,   190, -4102, -4102,  3466, -4102,
   -4102, -4102,  1301,  3445,   190, -4102, -4102, -4102, -4102,  1301,
   -4102, 48669,   494,  3379,  4061, -4102,  3476, -4102,  3953,  3823,
    4071, -4102,  2851, -4102,  3833,  3728,  1079, -4102,   190, -4102,
   -4102,  3993, -4102,   190,  3993,  1301,  1301, 57559,  3570, -4102,
   63909, -4102, -4102,   585,  3470,  2153, -4102, -4102, -4102, -4102,
   -4102, -4102,  2162,  1776,  3448,  2168,  2186,  3926,  3629,  3640,
   -4102, -4102,  3453,  3450,  1776,  2263, -4102, -4102, -4102,  3455,
   -4102, -4102,  4043, -4102, -4102, -4102, -4102,   339,  3725,  3081,
    3081,  3081,   630,  2450, -4102, -4102,  3509, 25776, 17409,  3568,
   57559,  1528,  2928, -4102,  1600,  1776, 12153,  2663, 44224, -4102,
   -4102, -4102, 12153,  3461, 12153,  3463,  2192, -4102, -4102, -4102,
    1630,  1630, -4102,   317, -4102, -4102, -4102, -4102,  1483, 57559,
   25776,  3490,  3648, -4102,  3180, -4102, -4102,  3459,  3435, -4102,
    2756,  3423, -4102, -4102, 57559, 57559,  2213, 57559, 57559,  2853,
    2876,  2879,   908,   908, -4102, -4102,   328, -4102, -4102, -4102,
    3865, -4102, -4102,  2225, -4102,    83,  3742, -4102, -4102, -4102,
   -4102,  1301, -4102,   162, -4102, -4102, -4102, -4102, -4102,   162,
   -4102, -4102, -4102, -4102,  3469, -4102, -4102, -4102,  3752,  3506,
   -4102,  3471, -4102, -4102, -4102, 39144, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, 12153,  3962,  3498, 57559,   143, -4102, 65179,
   65179, 57559, -4102, -4102, -4102, -4102,  6464, -4102, -4102,   728,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102,  4093, -4102,  3472, -4102, -4102,  3485,   248, -4102, -4102,
   57559, 56924,   271, 57559, -4102,  3762,   221,  1596, -4102,  3959,
    2239, -4102, -4102, 12153, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102,  1570, -4102, -4102, 27052,  2840, -4102,
    2756, -4102,  2235, -4102, -4102, -4102,  3572,  1079,  1079,  4000,
    4001,  1079,  1079,  1079,  1079,  3491,  2928, -4102,  3982, -4102,
   -4102, 12153, -4102, -4102,  2296,  3730, -4102,  4074,    93,  2296,
   57559,  2296, 57559, -4102,  3955,  3955, -4102, -4102, -4102,  6945,
    3956,  1778, -4102, -4102, -4102,   266,  3501,  2288, -4102,  2237,
    2249,  2255, -4102,  2268,  2274, -4102, -4102, -4102, -4102,   328,
    3503, -4102, 57559, -4102, -4102, -4102,   236, -4102, -4102,  2295,
   -4102,  2332,  2036, -4102,  3469, -4102, -4102, -4102, -4102, -4102,
   -4102,  2296, 12153, -4102, 12153,  3530, -4102, -4102,  3961, 57559,
   -4102, -4102, -4102, -4102, 12153, -4102, 63909, 63909, -4102, -4102,
   -4102, -4102,  4129,     9,  4099,  3782,  4103, -4102, -4102,  2336,
   -4102, -4102,   494,  1079, -4102,   271, -4102, -4102, -4102,  1079,
    1776,  3515,  3774, -4102,   221, -4102, -4102, -4102,  1596, -4102,
   -4102, -4102,  2603,  1776, -4102, -4102,  3518, -4102,  1079, -4102,
    3522, -4102, -4102, 57559,  3526, -4102,   494,   494,  1079,  1079,
    3118,  3118,  2756, 48669,  3635, -4102, -4102,  1079,  1776, 57559,
   -4102,  1186,  3911, -4102,  2341,  2360,   139, -4102, -4102,  3357,
   -4102, -4102,  3788,  6945, -4102, -4102, -4102, -4102,  3753, -4102,
     271, -4102, -4102, -4102,  3423, -4102,  1066,  1066,   190,   162,
     190, -4102,  3539, -4102,  3540,  2296,  2296, -4102,   247, -4102,
   -4102,  3948,  4039, 12153,  2296, 60734,  3541, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   64544, 12153, -4102,   728,  4093, -4102,  3819, -4102,  3821, -4102,
   56924, -4102,  3081,  1125, -4102, 39779, -4102, -4102,  1618,  1125,
   -4102,  1125, -4102, -4102, 27052, 16095,  2598, -4102,  3568, -4102,
    3552, -4102, -4102,   766, -4102, -4102,   494,   494, -4102, -4102,
   -4102, -4102, -4102,  2366, -4102, 48669, -4102, -4102,  4157,  4158,
    4049,  4164,  1186, -4102,  -105, -4102, -4102, -4102,  4165, -4102,
    4166,  3564,  3565, -4102, -4102, -4102,  4076, 63909, -4102,  4072,
   -4102,     9, -4102,   271, -4102,   221,  1596,  2374, -4102,  4218,
   -4102,   159,  3844,  3848, -4102, -4102, -4102, -4102,  -115,  3598,
   12153, 63909, -4102,  4066, -4102,  3994,  2221,  3936,  3576, -4102,
    3569,   178,  4106, 65179, 65179, -4102, -4102, -4102, -4102, -4102,
    3944,  4226, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102,  2398, -4102, 16752, -4102, -4102, -4102,
   -4102, -4102, 48669, -4102,  3635, -4102,  3591,   162,   162,  4196,
     162, -4102,  4199,  4200,  -105, -4102, -4102, -4102, 53749, 53749,
   -4102, -4102,  4095, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  3651,  4117, -4102, -4102,   199, -4102,   264,
   -4102,  2296, 61369,  4201, 57559, -4102, -4102, -4102, -4102, 12153,
   -4102, 49939, 62004,  3595, -4102, -4102, -4102, -4102, -4102,  3781,
   -4102,  3552, -4102,  3607, -4102,  2784,  2928, -4102, -4102,  3604,
   -4102, -4102,   162, -4102,   162,   162, -4102,  3610,  2407,  3789,
   -4102,  3357,  1066,  1066,   494,  3998, -4102,   199, -4102, 12153,
   -4102,  4097,  3701, -4102,  3614, -4102, 63909,  2277, 63909, -4102,
   -4102,  4052,  3616,  1371, -4102,  3611, -4102,  4040,  4074, -4102,
   16752,  3619, -4102, 12153,  3620,  3621, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, 63909, -4102, -4102, -4102, -4102, -4102,  2296,
    4220, 63909, 57559, 58829,  3824, 62639,  4081, 57559,  6945,  4083,
    4086, -4102,  4236,  3911, -4102, -4102,  2296, -4102, -4102, 63909,
   -4102,  3720, -4102, 59464, -4102,  2800, -4102,  3658, -4102, -4102,
    4156,  2721, -4102,   162,  4054, -4102, -4102, -4102, 63909, 63909,
   -4102, -4102, -4102, 37874, 12153, -4102, -4102, -4102, -4102, -4102,
     956, -4102,  3921,  3641, 60099, 63274, -4102, -4102, -4102, 32787,
   -4102, -4102, -4102,  4094, -4102,  2296, -4102,    16, 21934,  3803,
   37874, -4102, -4102, -4102, -4102, -4102, -4102, 48669,  2412, -4102,
   -4102, 27052, -4102, -4102, -4102, -4102, 25136,  3644, -4102,  1079,
   -4102, 27052, -4102, -4102, 16095, -4102, -4102
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4102, -4102, -4102, -4102, -4102,   142, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102,  1943, -4102, -4102, -4102, -4102, -4102,
    1631, -4102,   519, -2360,  -491,  3316, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102,   799,  1745,  3270,
   -4102,   412, -4102,    59, -4102, -4102, -4102, -2956,   -73,  -272,
   -4102, -4102,   943,    27,  3256,  -269, -4101, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102,   424,   423, -4102, -4102,
     254, -4102, -4102, -2170, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  -437,  -397,  2146, -4102, -4102, -4102,  4277, -4102,
    3729, -4102, -1800,  2399, -4102, -4102, -4102, -4102, -4102,  2471,
   -1727, -4102, -4102, -4102,  1505, -4102, -4102, -4102,  -562,   341,
   -4102,   343, -4102,   344, -4102,   345, -4102,   347,   350,   351,
     352, -4102,   353, -4102, -4102,  -394, -4102, -4102, -4102, -4102,
     354, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  -251, -4102,
   -4102,   -59, -4102, -4102,  -249,   361, -4102,  -182,   363, -4102,
     364, -4102,   -79, -4102,   -77, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102,  3259, -4102, -4102,
   -4102, -2311, -4102, -4102, -2443,  2779, -4102, -1665, -4102, -4102,
   -1925, -4102, -4102, -1707,   757, -4102, -4102,  -102,  -343, -4102,
   -1435, -1985, -1978, -4102, -4102, -4102, -2054, -2049,  -787,  2531,
   -1182, -2316, -4102, -4102, -4102, -4102,   106, -4102, -4102,   287,
    1737,  2252, -4102, -2517, -4102, -4102,   924, -4102, -4102,  1514,
     762,  1513, -4102,  1090,  3005, -1267, -4102, -4102, -4102, -4102,
   -4102, -4102,    22,   338,   -81, -4102, -3807,   768, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -2866, -4102, -4102, -4102,
    -291, -4102, -4102,  -184, -4102, -4102,  -245, -4102,   156, -2358,
   -4102, -4102, -4102, -4102,  2767, -1366, -4102,  3754, -4102,  -495,
   -4102,   482,  1762, -2418, -1993, -4102,  -943,  -939, -2974, -4102,
   -4102, -4102, -1782,  1033,  1319, -4102,   717,  1781, -2431, -4102,
   -4102, -4102, -4102, -4102,  1320, -4102, -4102,   483, -4102,   491,
   -4102, -4102, -4102, -4102,  -232, -4102,   130, -3228, -4102, -4102,
   -4102, -2968,  1248,   684, -4102, -4102, -4102, -1154, -2998, -1560,
   -4102,   309, -2404, -2545,   653, -4102, -4102,   450, -3996, -4102,
    -578, -2132, -2446,   -33, -4102, -4102,   463, -3429,  1893, -4102,
   -4102, -4102, -3389, -2129,  1649, -4102, -4102,  1204, -4102, -2059,
    1202, -4102, -4102, -4102,  1211, -4102,    42, -4102, -4102, -4102,
   -4102, -3008, -4102, -4102, -1583, -2738, -4102, -4102,  4420,  4421,
   -1568, -3170, -4030,   -72,   -71, -4102, -4102, -4102,  2247, -1724,
     112,   102,   104,  1746,  -816,   263,  1052, -2021, -4102,   326,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102,  1816, -1292, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -2384, -2886, -4102, -4102,
    1383, -4102, -4102, -4102, -4015, -2081, -2075, -2424,  3436, -4102,
   -4102, -4102, -4102,  3381, -2258, -3771, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  2937,  1317, -4102, -4102,  1950, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,   526,  2028, -4102, -4102, -4102,
   -4102,  2335, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
      18, -4102, -4102, -4102,   765,  2848, -4102, -4102, -4102,    -9,
   -4102, -4102, -4102, -4102,  2544, -4102, -4102, -4102, -4102,  2871,
   -4102, -4102, -4102, -4102, -4102, -4102,  1624, -4102,  2062, -4102,
   -1539, -4102, -4102,  1190, -1039,  2018,  -614,  2151,   476, -4102,
    3851, -4102, -4102, -4102, -1735, -2515, -4102,  3533,  -763, -2679,
    2532,  -570, -1921,  1234,   188,  1516,  1197,  4215, -4102, -1155,
   -1181, -4102, -4102,  -668, -4102, -4102, -4102, -4102, -4102,  2251,
    2256,  -600, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102,  1667, -4102, -4102, -4102, -4102, -1253, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102,  1512, -4102, -2090, -4102,
   -4102,  -474, -4102,  3310, -4102, -4102, -4102, -2346, -1896,  1962,
    1143, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  1969, -4102,
   -1606, -4102, -2793, -4102, -4102, -4102, -4102, -4102,  2169, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -1594, -4102, -1951,   237,
   -4102,   421, -4102, -4102, -4102, -4102, -4102, -4102, -4102,   -93,
     986,   -90, -2854, -1104,  1868, -4102, -4102, -1318,  3354, -2356,
   -4102, -4102, -4102,  2150, -4102, -4102, -4102, -4102, -4102,   786,
   -3001,  2962, -4102, -4102, -3128,  -958, -2342,  -929, -4102, -1412,
    1566,   615, -4102, -1903, -1120, -1448, -2952, -2458, -4102,  1434,
   -4102, -4102, -4102, -4102,  -210, -4102, -4102, -4102,   628,  2046,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
    -550,  -903, -4102, -4102,  2308,  -496, -4102,  3467, -4102, -4102,
    3468, -4102, -4102, -4102, -4102,  3151,  3125,  2108, -4102, -4102,
   -2397, -4102, -4102,  2073, -4102,   893,  -937,  -874,  1216, -4102,
   -4102,  1218, -3259, -4102, -4102,  3474, -4102, -4102, -4102,  1165,
   -4102,    60,  3904,  3475, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  2886, -1079,  3835, -4102, -4102, -4102, -4102, -4102,
   -4102,  2498, -4102, -4102, -4102, -4102, -4102, -4102,  3060,  3927,
    -594, -1344, -4102,  -738,  2502,  2026,  -897, -4102, -4102, -4102,
   -4102,  3928, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102,  2678,   816, -4102, -4102, -4102, -4102,  3145, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
    1250,  -139, -4102,    51,  -172, -4102,   -39, -4102, -4102, -4102,
   -4102, -4102,  -240, -4102, -4102,  -244, -4102, -1038,  3757, -1422,
     578, -1299, -2572, -4102,  1243,  3126, -3450,  -692, -1209, -1202,
   -2776,    91, -4102, -4102,  3447,    87,  -446,  -234,    -6, -3000,
    -103,  -608,  -604,  -770, -4102, -2145, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102,  2064, -4102, -4102, -4102,  1217, -4102,
    3950, -4102,  2769,  1220,  3963, -1382,  2582,  2075,  2081, -4102,
   -4102,  2086, -1991, -4102, -4102,   170, -4102,  2657, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102,  3727,  -453,  -458,  3149,  3970,
    3645, -4102,  3217, -4102, -4102, -4102, -4102, -4102,   535, -4102,
     277,  2120, -1279, -2367, -4102, -4102,  2941,   921, -4102,  1743,
    -179,  -494, -4102, -4102,   533, -4102, -4102,  1577,  3979,  3646,
   -4102, -4102, -4102, -4102, -4102, -2779,  -912, -4102, -3477, -2828,
   -1749, -4102, -4102, -2201, -3084, -4102, -4102, -1058, -4102, -4102,
   -4102, -4102, -1994, -4102, -4102, -4102,     2,  3947,  3964,  3965,
   -4102,  -819, -4102, -4102, -4102, -4102, -4102, -4102, -4102,  3553,
   -4102, -4102, -4102, -4102,  3557, -4102, -4102, -4102, -4102, -4102,
    3558, -4102, -4102, -4102, -4102, -4102,  2031, -4102, -4102, -4102,
   -4102, -4102, -4102, -4102, -4102, -4102
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2761
static const yytype_int16 yytable[] =
{
     515,  1098,  1553,   999,  1560,   892,  1031,  1740,  1765,  1429,
    1432,   556,  2132,   555,  1415,  1766,  1856,   563,   952,   995,
    1445,   574,  2458,  2459,  2195,   646,  1673,   577,   582,  2318,
     670,  1050,  2634,   513,   589,  1051,  1495,   592,  2635,  1636,
    1465,  2003,   589,  1897,  1171,  1282,   825,   826,   827,   610,
     829,  2002,   831,  2836,  2129,   833,  3420,   835,  2191,  2192,
    1717,  1970,  1855,  1868,  1286,  1465,   813,  1798,  1799,  1106,
    1459,  1802,  1803,  1804,  1805,  2868,  1807,  1808,  1810,  1812,
    1813,  1814,  1815,  1816,  2728,  1788,  2988,  2977,  3044,  1123,
    3654,   140,  1796,   635,  3117,  3301,  2735,  1682,  1496,  2817,
    1832,   868,  1906,  1565,  2988,  2988,   867,  1566,  3228,  1005,
    1516,  3337,  1012,  2892,   561,  1087,  1090,   638,  2793,   515,
    2624,   515,   645,   651,  3481,  3488,  2569,  2364,  2441,  2687,
    2010,  1377,   922,  2570,  2688,  1265,   656,   867,  2087,  2736,
    3000,  3865,  2932,  2936,  3515,  3421,  2100,  3582,  1345,  3009,
    2023,  1345,   640,  3013,   642,  3343,  4026,  3809,  2026,  2027,
    2941,  3496,  3997,  3532,  3028,  3980,  2184,  3132,  1912,  2950,
    1232,  1233,  3155,  3156,  1589,  1901,  3039,  3048,  3162,   522,
    3164,  1562,  2172,  1111,  1112,  1113,  1232,  1233,  3948,   667,
     634,  2557,  1223,  1224,  1225,  1232,  1233,  2065,  2684,   573,
    1018,  3546,  3797,   569,  1266,  2685,   581,  2454,  3886,  3522,
    1339,  -933,  3522,  1562,  2988,  2988,  3219,  1539,  1547,   602,
     867,  3685,  3382,  3523,  1232,  1233,  3523,  2305,  1232,  1233,
    1562,  1018,  2354,  3398, -2112,  1232,  1233,  3524,  3130,  2423,
    3524,   961,   942,  -572, -2263,  2675,  2992,  2993,   961,   942,
    3761,   961,   942,  4380,  3357,  2996,  1354,  1586,  1497,  1448,
    -573,   874,  1336,  1604,  3888,  1961,  3919,  3181,  3394,  1448,
    1232,  1233,  2100,  3889,  4259,   884,  1232,  1233,  4494,  1869,
    1510,   599,  4644,  4273,  3311,  3688, -2712,  2605, -2082,  4595,
    3559,  4591,  1523, -1598,  1346,  4763,  3323,  1346,  1232,  1233,
   -2642,  3601,  4314,  2705,  4322,  1951,  1358,   657,  3706,  2968,
    1006,  1232,  1233,  4315,   681,  1067,  3160,  1232,  1233,  2789,
    3590,  1232,  1233,  3049,   570,  4267, -2480,  4610,  1101,  2165,
    1232,  1233,  3220,  1952,  1470,  2608,  1534,  3471,  1962,  1463,
    1289,  3423,  4297,  2368,  3941,  3946,  3289,  3145,  3947,  3147,
    1232,  1233,  4488,  2214,  4322,  3863,  3123,  3124,  2211,  1639,
    4504,   878,  2083,  4014,  3358,  1232,  1233,  3957,  1270,  2888,
   -2712,  1505,  4396,   682,  3979,  3088, -2289,   867,  2546,  1909,
    3335,  3077,  2032,  1019,  1020,  1605,   519,  4500,  1618,  1606,
     520,  2089,  2060, -2560,  2375, -2712,  1232,  1233, -2408,  4489,
    1607,  1232,  1233,  4521,  2784,  3839,  1232,  1233,  1232,  1233,
    2282,  3890, -2561,  1619,  1019,  1020,  4045,  3424,  2776,  1624,
    4521,  2061, -1598,  4572,  1910,  4076,  3261,   674,  -476,  2679,
     676,  3078,  1476,  2248,  4547,  2178,  4548,  3089,  2565,  3336,
    3791,  2101,  3351,  1073,  2777,  1232,  1233,   832,  2053,  2369,
     879,  1624,   273,  1506,   275,  2519,   865,  4573,  2889,  1068,
    2923,   877,  1681,  2033,  1232,  1233,  1537,  1545,  1390,  2885,
    3296,  1232,  1233,  4586,  3169,  1706,  1171,  2819,  1707, -2712,
    2050,  2306,  4274,  4323,  2424,  1278,  3219,   865,  2083,  2911,
    4764,  1828,  1640,  1953,  1524,  1870,  1490,  1535,  4393,  1965,
   -2480,  3601,   273,  4298,   275,   661,   683,  4596, -2560,  1007,
   -1558,  1359,  4058,  3910,  3306,  3307,  3308,  3425,  3472,  1624,
    3602,   880,  3312,  2354,   645,  4490,   651, -2561,  4592,  3309,
    3310,  4316,  1608,  4323,  1232,  1233,  1269,  1511,  1234, -2760,
    4494,  1235,  3066,   651,  1552,  1963,   139,  3645,  1232,  1233,
   -1558,  3649,  4059,   645,   872,  2886,  4116,  3379,   645, -1598,
     882,  2949, -2112,  1234,  1864,  4120,  1235,  2101,   885,   876,
     865,  2005, -2263,   900,  2008,  1793,  1232,  1233,  2011,  3172,
    2014,  2569,  2476,  3384,   645,  4275,  2638,  4507,  2570,  4136,
     953,  1355,  1234,  4035,  4138,  1235,  1234,  3840,  3560,  1235,
    1014,  2055,  3220,  1234,  1413,   664,  1235,  2166,  2029,  2030,
    3612,  1449,  3370,  1829,  3382,  1232,  1233,  2958,  2988,  1034,
    1565,  1449,   875,  1857,  1566,  2335,  3691,  2687,  3689,  1856,
    1609,  2624,  2688,   645,  1871,  1056,  2338,  1931,  1234,  2341,
    2355,  1235,  3699,  3700,  1234,  4254,  1832,  1235,   515,  3682,
    2087,  1801,  3882,   635,   883,  1085,  3703,  1650,  1651,   635,
     635,  1950,  3221,  2425,  1099,  1056,  1234,   645,  1822,  1235,
    2988,   645,  3657,  1565,  -212,  1855,  2568,  1566,  1118,  1234,
    2498,  1072,  1235,  1705,  3380,  1234,  3508,   664,  1235,  1234,
     664,  1718,  1235,  1720,  1015,  3761,  2684,  1337,  1234,  2160,
    1500,  1235,  4720,  2685, -2289,  1733,  1734,  1735,  -933,   603,
    1913,  2100,  1602,  1739,  3385,  1340,  1232,  1233,  1234,  3359,
    3602,  1235,  2893,   571,   836,  1021, -2408,   865,  1281, -2112,
    1172,  3050,  2063,  1234,  1106,  2172,  1235,  2185,  1835, -2263,
    -572,  3949,  2332,  4343,   890,   924,  3098,  2186,  2683,  3125,
    1082,  3103,   903,  1902,  3834,  3133,  1211,  -573,  4065,  3111,
    3112,  1533,  2025, -1598,  1234,  3119,  3944,  1235, -2642,  1234,
    3532,   600,  1235,  3798,  1234,  2995,  1234,  1235,  1016,  1235,
    3525,  4368,  3152,  3525,   990,  3622,  2088,  2411,  3514,  4051,
   -1598,  1229,  1236,  1231,  3229,  4645,  1471, -2642,  2065,  3324,
    1050,  3497,  3998,  2039,  1932,  3977,  3144,  3918,  1236,  1232,
    1233,  2321,  3507,  1234,  1899,  1846,  1235,  1236,  1274,   515,
    1276,  1277,  1056,   515,   645,   645, -1893,   515,   645,  2212,
    2177,  1919,  1234,  1321,  1602,  1235,  4435,  4397,  2990,  1234,
    3152,  3222,  1235,  1430,   601,  1433,  1236,  1600,  1436,  1441,
    1236,  4332,  1275,  3876,  3877,  2694,  1279,  1236,  1602, -2560,
    1284,  2228,  2307,  2841,  1050,  1462,  2283,  4047,  2009,  1830,
    1350, -2289,  1773,  1774,  4407,  4184,  1232,  1233, -2561,  2695,
    1232,  1233,  3843,   635,  1232,  1233,  4194,  3240,  1232,  1233,
   -2560,  4598,  1236, -2408,  1477,   645,   635,  1925,  1236,  2994,
     635,  3619,  1234,  2089,  2083,  1235,  1232,  1233,  2229, -2561,
    2820,  2940,  2955,  1773,  2247,  2924,  1234,  4233,  3326,  1235,
    1236,  3920, -1558,  1708,  4060,  -476,  1709,  2083,  1232,  1233,
    3281,  2355,  3221,  1236,  3386,  2286,  2287,  2868,  3624,  1236,
     645,  2916,   645,  1236,  1234,   645,   645,  1235,  2303,  2304,
    1232,  1233,  1236,  3384,  2798,  2799,  2423,  1985,  3185,  3186,
    3677,  3114,   645,  2057,  2058,  2059,  3695,  3625,  2202,  1232,
    1233,  2040,  1236,  3135,  3640,  2041,  1232,  1233,  1817,  2639,
    1361,  2490,  1374,  1234,   590,  2634,  1235,  1236,  2178,  2067,
    3804,  2635,  3653,  1380,  3644,  3341,  3342,  1386,  3648,  3807,
    4203,  2690,  3202,  3203,  2917,  3027,  2101,   635,  1314,  4514,
    2569,  4516,  1829,  2465,  1232,  1233,  1106,  2570,  1236,  1232,
    1233,  4306,  1091,  1236,  4585, -2636,  1491,  4056,  1236,  1829,
    1236,  2254,  3698,  2480,  2220,  3000,  1561,   717,  3237,  3238,
    1551,  1992,  1934,  3028,  2222,  1501,  2225,  1232,  1233,  1232,
    1233,  1639,  1829,  1232,  1233, -2619,  3518,   139,  1232,  1233,
     635,  2494,  1232,  1233,  2353,   896,  2003,  1236,  2003,  2003,
     619,   635,  2749,  2624,   664,  2687,   664,  3304,  2928,  2929,
    2688,  1267,  3549,  2226,  1234,  3058,  1236,  1235,  1232,  1233,
    1465,  4557,  1601,  1236,  2469,  2827,  2524,  2364,  2404,  1776,
     722,  1993,  2227,  2918,   904,  1625,  1626,  1627,  1632,  3401,
    2087,  3403, -2623,  2492,  3387,  4252,  1059,  2451,  3414,  4508,
    1267,  2397,  2707,   141,  2117,  1465,  2497,  1783, -2622,  2500,
    2501,  2568,  3427,  3160,  3641, -2620,  2079,  2572,  1151,  3438,
    3440,  1232,  1233,  3136,  2684,  2419,  2420,  2856,  1172,  4301,
    4302,  2685,  3457,  3459,  3461,  2933,  1236,  1581,  3462,  3440,
    2330,  2180,  1172,  3576,  1821,  2325,   867,  3578,  1534,  1060,
    1236,  2551,  2234,  3934,  3437,  2797,  3935,  1234,  1502,  2333,
    1235,  4307,  2919,  4288,  1662,  3363,  2235,  1232,  1233, -2621,
    2318,   566,  2532,  2533,  3504,  1463,  4550,  1818,  1236,   735,
     990,  2424,  4446,  1503,  3101,  1630,  3954,  3955,  3956,  2544,
    2507,  1767,  2507,  1858,  3959,  4453,  3115,  1589,  3519,  2340,
    1819,  1565,  3985,   990,   645,  1566,  2562,  2563,  1152,  2852,
    1955,  1766,  2802,  2803,  2552,  2405,  1857,  1236,   620,  2172,
    4476,  1425,  3200,  2118,  1234,  1425,  2683,  1235,  1234,  1232,
    1233,  1235,  1234,  2245,  2342,  1235,  1234, -2626,  1935,  1235,
    1061,   645,  2491,  2553,   905,  2712,  1825,  1777,  1830,  1911,
    3059,  2796,  1431,  1249,  1234,  1073,  4204,  1235,   751,  1232,
    1233,  2806,   635,  1232,  1233,  1830,  2357,  1994,  2511,  1249,
    2080,  2670,  2671,  2672,  2673,   567,  1234,  3520,  2088,  1235,
    3518,  3275,  1232,  1233, -2636,   518,  3364,  2953,  1830,  1172,
     645,  3345,  3932,  3933,  1766,  1232,  1233,  2545,  1234,  3160,
    1602,  1235,  3160,  3160,  3580,  3927,   611,  3474,   645,  1535,
    1092,  4080,  2410,  2554, -2619,  1492,   645,  1234,  1236,  3160,
    1235,  1882,   897,  1885,  1234,  4478,   635,  1235,  2508,  2326,
    2508,  2470,  1466,  3958,  2360,  3116,  4479,  4308,   635,  3978,
    3981,  3983,  3984,  2089,   139,  2509,   645,  2509,  3683,  2297,
    2100, -2760,  3686,  3687,  1123,   635,   635,  2510,   612,  2510,
    2425,   523,  1234,  2177,  1820,  1235,  4374,  1234,  4375,  4513,
    1235, -2623,   557,   664,  3801,  1268,  2689,  1871,  2920,  1232,
    1233,   645,   645,  3137,  1956,  1937,  1467, -2622,  4468,  4469,
    4373,  2597,  2555,  1945, -2620,  1234,  1946,  1234,  1235,  4553,
    1235,  1234,  3392,  3392,  1235,   645,  1234,  1232,  1233,  1235,
    1234,  1236,  4509,  1235,  1268,  2314,  1966,   953,  2039,  2406,
    1889,    44,  3921,  1386,  1232,  1233,  2203,   515,   515,   515,
     635,   515,   635,   613,  1232,  1233,  1234,  2004,  2511,  1235,
    2511,  4699,  3519,  2006,   515,  2768,   645,  2069, -2621,  1252,
     515,  2442,   673,  1386,  1062,   664,   867,   677,  4386,  2451,
    1986,  1987,  1988,  4700,  1990,  1252,  1232,  1233,  3365,  1043,
     830,   635,  2178,  4543,   780,   834,  2039,  2007,  1236,  2690,
    3992,  4565,  1236,  2013,   606,  2003,  1236,  1232,  1233,  1234,
    1236,  4342,  1235,  3521,  2246,  2963,   865,  3522,  2250,  1666,
    4265,  4266,  2262,   901,  2429,  4785,  2269,  4510,  1236,  2165,
    2452,  3523,  1203,  4615,  4615,  1982, -2626,  2691,  2964,  2909,
    1063,  3530,  1064,  3346,  2273,  3524,   635,  1989,  4079,  1991,
    1236,  3122,  3266,  3267,  3268,  1234,   961,  3942,  1235,  4511,
    2568,  2327,  2012,  3400,   645,  2528,  2274,  1232,  1233,  1426,
    4480,  1050,  1236,  1426,  2512,  2676,  2512,  2328,  1856,   635,
    4268,  2770,  1667,  4081,  2125,   635,  2083,  2215,  2024,  3430,
    3431,  1236,  3079,  3839,  4555,  3366,   635,  4559,  1236,  1232,
    1233,  2060,  4236,  2315,  1232,  1233,  2040,  2276,   607,    58,
    2041,  2982,  2980,   645,  2277,  1232,  1233,  1234,   645,   591,
    1235,   273,  1204,   275,  1855,  3146,  1639,  1118,  2556,  2201,
    2062,  1232,  1233, -1920,  4684,  4685,  1236,  3350,  1254,  1255,
     575,  1236,  -578,  2064,  2513,   626,  2513,  1234,   908,  3236,
    1235,  1234,  2281,  3292,  1235,  3950,   579,  2299,  3951,  3909,
    1766,  1232,  1233,  2099,  2040,  2101,  2053,  4010,  3993,  1236,
    1234,  1236,  4011,  1235,  1286,  1236,  2119,  2988,  1639,  4322,
    1236,  2983,  2127,  1234,  1236,  3183,  1235,  3184,  2083,  1232,
    1233,  3195,  4078,   604,  2683,   122,  3205,  2692,  3008,  3201,
    3076,  3011,  3012,  1639,  3014,  4235,   614,  3017,  3018,   927,
    1236,  3021,  1232,  1233,  1093,   658,  3030,  1172,  2255,  1044,
    4256,  3034,  3035,  3036,  3037,  3038,  3206,  3888,   615,  3042,
    3043,  2981,  3045,  2801,  2358,  2841,  3889,  3286,  3054,  3055,
    3056,  3057,  3080, -1920,  3061,  3062,  1045,  3064,  4481,  1232,
    1233,  2732,  2083,  1232,  1233,  4669,  2737,  3521,  2088,  1725,
    2984,   909,  1938,  1236,   616,  3339,  1106,  1234,   139,  2743,
    1235,  3464,  1232,  1233,  1261,  1262,  1263,  1264,  2324,  3817,
     622,  4215,   135,  1232,  1233,  3840,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  1094,  1234,   623,  3659,  1235,  3499,
    1207,  4216,  4107,  2758,  3392,  3128,  2429,  2166,   625,  1236,
     641,  1729,  1234,  1829,  2430,  1235,   124,  1578,  1579,   636,
    2348,   635,  1234,   617,  2298,  1235,   865,   273,   645,   275,
     635,   645,  3436,  2318,  3606,  1345,  1753,  1050,   910,  1766,
     639,  2880,   928,   635,  2464,  4174,  1232,  1233,  1321,   273,
     654,   275,  4137,  1321,  1234,  4139,  2371,  1235,  4323,  1232,
    1233,  4344,  1622,  2379,  2379,  1372,  2379,   136,   124,  2130,
    2429,  1236,  2812,  1367,  3890,  1234,  1368,  1829,  1235,  3607,
     661,  3504,   667,  2167,  3027,   645,  2219,  2177,   635,  3841,
    1208,   669,   635,  2131,  2689,  1939,  1232,  1233,  1232,  1233,
    4108,  1236,  2988,  2988,   952,  1236,  1144,  1145,   672,   645,
     645,   635,   635,  3660,   671,  1666,  2221,   678,  2349,   929,
   -1598,  3083,  1172,   645,  1236,  1232,  1233,  4019,  2379,  2379,
    2379,   679,   664,  2431,  2432,  1234,  3084,  1236,  1235,  2236,
    4345,   645,   680,  4109,  1232,  1233,  1970,  2690,   823,  1232,
    1233, -1920,  2237,  1232,  1233,  2139,  2140,   828,   953,   839,
    2378,  2378,  1415,  2378,  3329,  1232,  1233,  1234,  2100,   519,
    1235,  2153,  1234,   520,  2433,  1235,  2985, -1598,  1667,  2487,
    1214,  1346, -1920,  1234,   990,  2402,  1235,  2988,   873,  1361,
    1232,  1233,   887,  1465,  2903,  1232,  1233,  2431,  2432,  1234,
    2418,   893,  1235,  2346,  4174,  4174,   895,  1668,  1380,  2422,
   -1598,  2347, -1598,  1232,  1233,  2904,  3349,  2248,  3642,   635,
     580,  1236,   913,  1369,  3823,  2378,  2378,  2378, -1598,  1234,
    1232,  1233,  1235,   915, -1598,  2506,  3332,  2168,  3295,  2694,
    1330,  2772,   635,  1004,  3516,  2804,  1232,  1233,   990,  1236,
   -1598,  2905,   515,   515,  3842,  2530,   515,  1234, -1598,  1011,
    1235,   905,  2090,  2695,  2244, -1598,  1236,  2483,  1032,  1830,
    3843,  1096,  1097,  3551,  3552, -1598,  1236,  1669,  2677,  4043,
    1234,  2258,  2346,  1235,  2693,  2526,  2527, -1598,  3525,  3288,
    3320,  2259, -1598,  1687,  3565, -1804,  3573,  1766, -1920,  2155,
    2156, -1598,  1033,  4064,  1232,  1233, -1893,  3690,  1236,  3943,
    3758,  2218,  1269,  1430,   635,  1039,  2499,  1234,  3912,  3913,
    1235,  1234,   626,  2263,  1235,  1430,  4200,  4201,  4202,  1236,
    1232,  1233,   876,  1830,  1232,  1233,  1047,  4430,  2953,  2518,
    1234,  3704, -1804,  1235,  2267,  1766,  3413,  2381,  2196,  2382,
   -1920,  1234,  3708,  1058,  1235,  3710,  1670,  2535,  1066,  3422,
    1073,  4174,  4174,  3844,  2507,  1666,  2542,  2543, -1598,  2223,
    2224,  2091,  1083,   645,  1249,   645,  1086,  2547,  2548,  2549,
    2550,   645,  2558,  2559,  2083,  1857,   586,  2701,  1104,  1236,
    2704, -1598,  1232,  1233,   586,  1691,  2216, -1804,  1120,  1232,
    1233, -1598,  2241,  1269,  2268,  1105,  1232,  1233,  1232,  1233,
     645,  2446,  2447,  2448,  1234,   930,   931,  1235,   933,  2794,
     935,  1236,   645,  1106,  1106,  1106,  1236,  1234,  1667,  1121,
    1235,  4229,  4230, -1598,  1122,   936,  2272,  1236,  1232,  1233,
    2342,  2275,  2217,  1269, -1804,  1569,  1124,  1232,  1233,  2816,
    2706,  1021,  2278,  1236,  1269,  4231,  1865,  1668,  1125,  1866,
    1232,  1233,  1867,  2101,  1234,  1183,  1234,  1235,  2290,  1235,
    4174,  1232,  1233,  1050,  1050,  1050,  1126,  1932,  1932,  1932,
    1232,  1233,  1129,  1236, -1598,  4174,  1130,  1202,  4350,  3694,
    2249,  1269,  1131,  1234,  1232,  1233,  1235,   990,  2309,  1692,
    1215,  1216,  2508,  1695,  2251,  1269,   961,   942, -1598,  1829,
    1696,  1236,  1234,  1232,  1233,  1235,   645,  1234,  2066,  2509,
    1235,  1234,  1509,  1132,  1235,  3235,  3149,  1669,  1514,  1515,
    1272,  2510,  1133,  1234,  1236,  1134,  1235,  1135,  2716,  2092,
    1136,  2813,  2689,  1273,  2551, -1921,   645,  3439,  1322,  3173,
    2093,  4602,  4174,  1137, -1598,  3614,  1290,  2094,  1234,  2252,
    1723,  1235,  1138,  1234,  2717,  1139,  1235,  2003,   645,    13,
    1252,  1236,  1671,  3638,  1140,  1236,  4174,  4008,  1141,  4114,
    4115,  1234,  3770,  3805,  1235,  1324,  3179,  1142,  4174,  4174,
    3180,  1697,  4118,  1146,  1236,  2264,  1269,  1331,  1234,  4121,
    1148,  1235,  1465,  2850,  3292,  1236,  1670,  2552,  1333,  3187,
   -1598,  1766,  2511,  1325,  1234,  2265,  1269,  1235,  2266,  1269,
    3191,  2718, -1598, -1598,  2719,  4140,  4141,  2873,  1149,  2464,
    1430,  2876,  2720,   122,  3146,  3874,  2553,  4694,   645,   645,
    1672,  3412,  1150, -1598,  2165, -1598,  2270,  1269,  1153,  1699,
    2721,  1154,  2897,  1155,  2899, -1921,  2095,  4174,  1156,   927,
    4618,  1157,  4335,  4339,  1158,  4617,  1159,  4174,  1236, -1598,
   -1598,  1334,  1234, -1598, -1598,  1235,   953,  4244,  4245,    25,
     990,  1236,  2004,  3192,  2004,  2004,  4693,  1160,  4695,  2318,
    1161,  1452,  1232,  1233,  1326,  1342,  3436,  1162,  1234,  1165,
    1327,  1235,  1234,  1766,  3383,  1235,  2554,  2560,  2561,  1166,
    1767,  4174,  3395,  4174,  3151,  1167,  3814,  3402,  1236,  2961,
    1236,  4713,   515,  1254,  1255, -1893,   645,   645,  2512,  3416,
    1173,  3418,  3419,  3193,  1351,  3194,   123,  1174,  4174,  4538,
    1345,  2786,  1269,  3432,  1328,  2896,  4174,  1236,  4174,  1453,
    4174,  2096,  1175,  2722,   124,  2966,  2825,  2826,  4744,  4745,
    1234,  1329,  3196,  1235,  4174,  1830,  1236,  1234,  4174,  3936,
    1235,  1236,  3939,  3940,  1234,  1236,  1234,  1235,  1454,  1235,
    1343,  3199,  1789,  4174,  4174,  2555,  3204,  1236,  1176,  3952,
    3207,  1700,   928,  1344, -2755,  3168,  2224,  2564,  2513,  4174,
    4174,  1353,  4349,  2083,  4174,  1357,  1234,  1702,  1177,  1235,
    4335,  3060,  1236,  1178,  4339,  1234,  4095,  1236,  1235,  3171,
    1269,  1179,  1671,   125,  1180, -1598,  3075,  3209,  1234,  3197,
    1269,  1235,  3211,  3298,  3299,  1236,  1643,  1644,  1645,  1234,
    3096,  1181,  1235,  1184,  1026,  1027,  3534,  1028,  1234,  1029,
    3213,  1235,  1236,  1663,  3302,  3303,  1185,  2723,  2100,   961,
     942,  4028,  1234, -1921,  4095,  1235,  1365,  3214,  1236,   929,
    1186,  1257,  1258,  1259,  1260,  1261,  1262,  1263,  1264,  3584,
    1269,  1234, -1598,  3215,  1235,  1726,  1346,    38,  1730,  1375,
    4401,   635,   635,   635, -1921,  3609,  3610,  1050,  1187,  1249,
    1188,  1932,  1189,  3535,  3775,  3776,  3536,  1190,   126,  1749,
    1750,  1191,  3558,  1754,  3537,  2165,  1192, -1598,    44,  1478,
    3783,  3784,  2166,  3794,  3802,  1193,  1236,  1194,  1829,  1195,
    1768,  1769,  3538, -1598,  3818,  1269,  2997,  3099,  3100, -1598,
    3102,  3570,  3104,  3105,  3106,  3107,  3108,  3109,  3110,   952,
    1479,  3113,  1236,  1196,  3118,  1197,  1236,  3121,  3835,  1269,
    1096,  1097,  1198, -1598,  3585,  1199,  1790,  3571,  4029,  4030,
   -1598,  3572,  1200,  4031,  4032,  3851,  3852,  3539,  4001,  2561,
   -1598,  4335,  4339,  1201,  -671,  4725,  1205,  4606,  3140,  3141,
    3142,  1206, -1598,  1209,  1455,  -678, -1893, -1598,  2167,  1387,
    2997,  2556,  3960,  2724,  1480,  2271, -1598,  4179,  4180,  1481,
   -1921,  1210,  2998,  1213,  1236,  2679,  4182,  4183,  1321,  1217,
    2371,  1236,  4186,  4183,  1350,   645,   645,   645,  1236,  3816,
    1236,  1249,  1218,   635,    54,  3540,  3822,  2508,  1219,   127,
    4187,  4183,  1389,  3824,  1405,  3825,  4243,  3303,  3961,  1220,
    2551,  3024,  2850,   645,  2509,  1221,  1767,  2852,  3962,  1222,
    1236,  1271, -1921,  1407,  4786,  1408,  2946,  4262,  4183,  1236,
    1409,  1172,  2725, -1598,  2083,   645,   645,   645,  3960,  4271,
    4272,  1410,  1236,  1413,  3826,  1666,    58,  1416,  3319,  4352,
    4353,  4387,  3610,  1236,  2130,  1252, -1598,  3827,  1421,   990,
    1446,  2726,  1236,  4388,  4183,  1422, -1598,  3963,  4083,  4389,
    4183,  2070,   128,  2552,  1442,  -671,  1236,  4195,  2131,  3697,
     526,  2004,  4391,  4183,  3961,  2071,  1447,  2816,  4392,  4183,
    3274,  1249,  1451,  1456,  3962,  1236,  3541,  3188, -1598,  3542,
    1463,  2551,  2553,  1472,  3456,  3799, -2755,  1473,  1667,  4398,
    4399,  1475,  2168,  2101,  1494,  1457,  4729,  4730,  2130,  1474,
    4258,  1482,  1498,   635,  3075,   930,   931,   932,   933,   934,
     935,  4005,  4006,  1499,  1248,   129,  1249,  1668,  1791,  1504,
    3964,  3318,  2131,  3963,  1830,   936,  4400,  4399,  1512, -1598,
    4439,  4440,  3075,  2166,  1792,  4486,  3303,  1458,  4348,  1829,
    1513,  3399,  3397,  3075,  2552,  1766,   273,  3409,   275,  3408,
    1518,  4217,  2554, -1598,  4487,  3303,  2674,  3543,  1519,  4218,
    4563,  4564,  1249,  1521,   645,  3408,  1526,  1252,  4589,  3610,
    3429,  3433,  1531,  2553,  1562,  1767,  1483,  3444,  -852,  4135,
    1249,  1568, -2755,  3446,  3447,   635,  4219,  1669,  1254,  1255,
    1232,  1233,  4620,  4621,  1570,  2551,  1572,  3408,  3458, -1598,
    3368,  4681,  3501,  2947,  3075,  3470,  4775,  4776,  4020,  4021,
    3483,  3026,  2997,  1756,  1757,  4280,   515,  3628,  3629,  1575,
    3493,  4280,   273,  1576,   275,  3408,  1604,  1249,  3592,  3593,
    4351,  2555, -1893,  2072,  3895,  4086,  1580,  1584,  3849,  3850,
    1484,  1585,  1590,  2554,  3410,  3411,  1591,  1592,  -671,  3489,
    1613,  1614,  1615,  2551,  -852, -1598,  3460,  1621,  2552,  2999,
   -2105,  3506,  1623,  1624,  2997,  1633,  1670,  1252, -1598,  1267,
    1635,  1646,  3443,  2513,  1639,  -671,  2998,  3513,  1096,  1097,
    1665,  1711,  3445,  1676,  3965,  1722,  1723,  2553, -1598,  1724,
   -1598,  3966,  2204,  1747,  3544,  1764,  1683,  1684,  1685,  1686,
    1687,  1775,  4402,  3482,  1784,  1800,  1826,  4220,  1806,  2073,
     990,  1827,  1252,  1619, -1598, -1598,  2552,  1833, -1598, -1598,
    1254,  1255,  2555,  3545,  1834,  1837,  1840,  3024,  1841,  1842,
    1844,  3967,  1843,  1250,  2074,  1845,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  1847,  2553,  1848,  1860,  1605,  1861,
    2551,  3633,  1606,  1859,  1096,  1097,  1251,  2554,  1252,  1485,
    3965,  3509,  1862,  1607,  1890,  1895,  3583,  3966,  1898,  1915,
    2130,  1907,  1916,   531,  2897,  1917,  1252,  2256,   585,  -671,
    1922,  2260,  4470,  1918,   526,  4348,  1927,  1666,  4221,  1928,
    1929,  1930,  1766,  1947,  2131,  1830,  1486,  2075,  1941,  1688,
    1689,  1690,  1691,  1971,  3968,  2284,  4222,  3967,  4260,  4261,
    1979,  4263,  4264,  2552,  2850,  2554,  1980,  1984,  2015,  2016,
    1254,  1255,  2130,  1252,  2017,  4038,  2018,  3129,  2020,  4223,
    2051,  4048,  2021,  2873,  3621,  2022,  2555,  3623,  2935,   645,
    2139,  2140,  2553,  1096,  1097,  2037,  2131,  2556,   645,  1430,
    1667,  2068,  2114,  2121,  2813,  -671,  2153,  2120,  2134,  2161,
    2179,   953,   953,  2135,  2181,  1254,  1255,  2896,  1257,  1258,
    1259,  1260,  1261,  1262,  1263,  1264,  2182,  2193,   525,  2982,
    3968,  1767,  1671,  4356,  4357,  1415,  2199,  4360,  4361,  4362,
    4363,  2205,  2207,  2076,  2555,  1608,  3669,  2208,  2209,  2231,
    2232,  4515,  2233,   635,  2238,  2239,  1692,  2240,  1693,  1694,
    1695,  3969,  2554,  2242,  3678,  4625,  2253,  1696,  2248,  4176,
    1253,  2257,  2319,  2323,  3075,  2288,  2261,  2279,  2280,  1254,
    1255,  3025,  4445,  3408,  2285,  2300,  3075,  2289,  2556,  2301,
    1683,  1684,  1685,  1686,  1687,  2302,   645,  3026, -1279,  2983,
    3408,  4455,  3075,  3075,  1264,  2329,  1151,   690,  1234,  2339,
    3639,  1235, -1422,  1430,   526,  2359,  3075,  3408,  1257,  1258,
    1259,  1260,  1261,  1262,  1263,  1264,  1254,  1255,  3408,  1203,
    2070,  3408,  1207,  2374,  2155,  2156,  2394,  3969,  4228,  4442,
    2403,  2555,  1256,  1609,  2071,  2409,  1602,  2412,  1697,  -671,
    3671,  2507,  -883,  2415,  2437,  3713,   990,  2438,   635,  2443,
    2444,  2445,  2466,  3769,  1258,  1259,  1260,  1261,  1262,  1263,
    1264,  2460,  4224,  2473,  4466,  4467,  2467,  2468,  2984,  4625,
    2471,  2472,  2474,  4475,  2484,  3096,  2486,  4493,  2475,  2488,
    3696,  4089,  2489,  1688,  1689,  1690,  1691,  2502,   717,  3702,
     527,  2493,  2556,  2503,  2516,  1698,  1699,  2517,  2520,  2521,
     645,  1259,  1260,  1261,  1262,  1263,  1264,  3870,  2523,  4630,
    4631,  2525,  4633,  2534,  2536,  3448,  2537,  3449,  2541,  1259,
    1260,  1261,  1262,  1263,  1264,  2538,  2644,  2539,  2640,  4770,
    2540,  2648,  2646,  2649,  2650,  2651,  1766,   531,  2652,  2653,
    2654,  2655,  4779,  2656,   721,  3714,  2657,  4770,  2658,  1766,
    2556,   722,  4779,  2659,  1766,  2660,  2661,  2662,  3772,  1766,
    2663,  3450,  2664,  2665,  1257,  1258,  1259,  1260,  1261,  1262,
    1263,  1264,  2666,  2667,  4677,  2668,  4678,  4679,  2669,  2508,
     726,   727,  3859,  3451,     1,  2678,     2,  1767,  2697,  2698,
    1692,   528,  1693,  1694,  1695,  2699,  2509,  2706,  2702,  2710,
    2715,  1696,  2072,     3,   645,  2738,  2739,     4,  2510,  2740,
    2347,  2750,  4228,  2751,  2763,  2785,  2792,  2800,   690,  -671,
    3452,     5,     6,  2809,  2823,  2810,  2828,  2824,  2829,     7,
    2831,  2832,  2833,  2839,     8,     9,  2842,  2830,  1700,  2845,
    2846,  2853,  2844,  2857,  2859,  2854,  2877,  2556,  3075,  1902,
     735,  2858,  1236,  1701,  1702,    10,  2878,  2901,  2452,  2881,
    2882,  2883,  2863,  2451,  1956,  4741,  2902,  3408,  1955,  2912,
    2927,  3075,  2942,   529,    11,  2930,  1430,  2943,  2073,  1767,
    2944,  4756,  1697,  3408,  2985,   635,  2959,  2978,  2967,  2511,
    2979,  4496,  2997,  3022,   530,  3010,   892,  3015,    12,  3016,
    1096,  1097,  4089,  2074,  3019,   841,    13,    14,    15,   717,
    3020,  3023,  3878,   746,  3029,  3031,  3033,   531,  3032,    16,
      17,  3040,  3041,  3046,  4124,  3052,  3047,  3053,   750,   751,
    3063,  3086,    18,  3082,  3091,  3097,  3126,  3900,  3127,  1698,
    1699,  3131,  3152,  2200,  3143,  1239,  1240,    19,  3633,  3157,
    3991,  3163,  3165,  3996,  3226,  3264,  3166,   532,  3167,  3245,
    4004,  4004,  4004,  2004,    20,   721,  2075,  3174,  3175,  3246,
    3216,  3227,   722,   645,  3230,  1391,  3244,  3234,  3239,    21,
    3242,    22,  1241,  3232,  3247,  1392,    23,  3263,  3269,  3271,
      24,  4498,  3276,  3279,  1242,   842,  3248,  3249,  3250,   533,
    1393,   726,   727,  3283,  1367,  2512,  3280,   534,  3294,  3297,
    3316,  3300,  1394,  1395,  1396,  3251,    25,  3305,    26,  3317,
    3321,  3322,  4782,  3453,  3325,  3333,  3334,   844,  3347,  3355,
    3356,  1397,  3484,  4528,    27,  1243,   541,  3340,  2464,  2605,
    3479,   845,  2383,  3344,  3415,   645,  3487,  1244,  4528,  3417,
    3490,  3491,    28,  3495,  3500,  2876,    29,  3501,  4048,  3505,
    3531,  2053,  2076,  3553,  1873,  3550,  2384,  3454,  1874,  3561,
    3554,   735,  3669,  3562,  1245,  2513,  3574,  2306,  3587,  2385,
    1875,  3221,  1700,  3588,  3598,  4004,  3589,  3600,  3605,  3611,
    3075,  2386,  3613,  3626,   542,  4099,   635,  1701,  1702,  3646,
    2429,  3647,   849,  3658,  4104,  3634,  3664,  3665,  3672,  3670,
    3673,  3680,  3679,  3674,  3681,  4581,  3693,  3701,  3705,  3711,
    3773,  3712,   772,   543,  2638,  1430,  4090,  3771,  3780,  4091,
     850,  3781,  3786,  3787,   746,   645,  1246,   851,  3788,  3789,
     778,  3796,  2387,  3792,  2388,   780,  3793,  3800,   781,   750,
     751,    30,  3803,  4496,  4066,  3794,  3806,  3808,  3795,  3820,
     544,  4142,  3810,  3819,  3811,  3812,  3815,   821,    31,  3821,
      32,  2389,  3829,  3836,  3830,  3854,  3838,   852,  3847,  3855,
    3866,  3320,  3864,    33,  3867,  3872,  3852,  3871,  3881, -1508,
    3887,  3896, -1513,  4097,    34,  3897,  3905,  3898,  3901,  3911,
    3914,  3915,  3922,  3930,  3987,  4092,  4093,  3937,   545,  3980,
    4012,   635,  4228,  3802,  4214,  4017,    35,  4016,  4022,    36,
    4528,    37,   645,  4036,    38,  4018,  4023,    39,    40,  4123,
    4665,  4024,  4025,  4037,  3252,  4041,  2390,  4105,    41,  4673,
    4067,    42,  4102,  4249,   635,  4753,  4053,  4068,  4040,    43,
    1398,  3253,  4055,  4084,  4085,    44,  4127,  4128,  4004,  4004,
    3977,  4004,  4004,    45,  4117,  4129,  4130,  1399,    46,    47,
      48,  4131,  4753,  4087,  4088,  4113,  4133,  4134,  4119,  4143,
    4177,  4185,  4188,  4189,  4190,  4193,  4197,  4192,  4199,  4196,
    4207,  2391,  4210,  4253,  4240,  4270,  4242,  4284,  4276,  4285,
      49,  4710,  4282,  4292,  4286,  -352,  4310,    50,  4208,  4290,
    1876,  4528,  4331,  4528,  4312,  4341,   821,  4355,  4673,  4313,
    4296,   821,  4358,  4359,  4364,  4303,  4367,  4727,  4369,  4371,
     855,  4528,  4376,  4381,   -67,  4385,  4394,  4407,  1877,   546,
    4410,  4250,  -370,   772,  4436,  4437,  1878,  4090,  4438,  4447,
    4091,  4448,    51,  4454,  4317,  4321,  4457,  4004,   821,  4460,
    4472,   778,  4528,  4528,    52,  3254,   780,  4761,    53,   781,
    4484,    54,  3474,  4517,  4518,   821,   858,    55,  4524,  4525,
    4529,  1767,  4535,  3255,  4536,  4553,  4567,  4568,  4569,   859,
    1879,   547,  4784,  4570,  4576,  4577,  4580,  4578,  4579,  1400,
    4593,  4583,  4289,  4590,  4594,  4598,  4603,    56,  4605,  4607,
    2597, -2459,   548,    57,  2876,  4608,  2876,  4611,  2572,   821,
     821,   821,   821,    58,  4629,  4632,  4092,  4093,  4634,  4635,
    4639,   821,  4642,  4643,  4666,  4667,  4653,  4690, -1682,  1880,
    4471,  4687,  4670,  3256,  4680,  4682,  4395,  4691,  4696,  4692,
    4701,  4697,  4702,  4705,  4707,  4712,  4708,  4716,  4718,  1401,
    4721,  3257,  2575,  4722,  2576,  4723,  4728,  4732,  4734,  4742,
     862,  4757,  4762,  4411,  4758,   549,  4771,  1402,  4305,  4781,
    3120,   550,  2818,  4000,  3785,  1493,  2991,  1544,  4071,  4499,
    4382,  4640,   863,  1574,   864,  4641,  -817,  -817,  4069,  2578,
     551,  4073,  4248,  4773,  4736,   598,  2440,  1003,  -817,  3259,
    2367,  4154,  2136,  4155,  4157,  4158,  4746,  4160,  2581,   821,
    4161,  4162,  4163,  4164,  4165,   552,  2582,  4214,  4650,  4522,
    4651,  4168,  4616,  4169,  4170,  4534,  4533,   645,  2112,  2350,
    1617,  4384,   553,  4477,  4255,  2622,  3707,  3282,  3067,  3857,
    3604,  3287,  2816,  2584,  1905,  4459,  4209,  4552,  3860,  4704,
    4628,  4672,  4366,  2164,  1040,  4077,  3065,  1562,  3662,  3469,
    2585,  3904,  2137,  3476,  2138,  2139,  2140,  2141,  2142,  4096,
    2143,  2144,  2145,  2146,  2147,  2148,  2149,  2150,  2151,  4441,
    2152,  2153,  2154,  3072,  4098,  4688,  4404,  3547,  3945,  2590,
    4278,  3986,  4132,  4551,  4122,  2976,  3218,  3577,  3579,  3575,
    4502,   537,   538,  4587,  4321,  4588,  2696,  4444,  4450,  4545,
    4452,  3139,  3684,  4464,  4465,  4281,  4330,  3069,  1767,  3468,
    2038,  1582,  2934,  1517,  4101,  2643,  2860,  3917,  4537,  4627,
    2162,  2421,  2126,  3273,  2840,  3599,  2791,  2884,  4175,   645,
    1030,  1420,  4403,  2450,  3586,  2731,  2729,  3241,  1721,  2954,
    2948,  3643,  4378,  2790,  4246,  4637,   273,  3782,   275,  4638,
    2807,  3925,  2054,  3330,  2594,  1664,  3463,  4057,  4726,  4050,
    2891,  2700,  2595,  1888,  2838,  2866,  3862,  1920,  1554,  1555,
    3617,  3616,  3652,  1017,  4549,  1556,  1557,  2596,  2495,  2198,
    1119,  1996,  2931,  2496,   998,  1001,  2361,  3929,  3603,  4703,
     821,  4724,  4544,  4571,  1926,  4636,  4780,  4783,  1212,  2155,
    2156,  4126,  3620,  2910,  3636,  1944,   955,  2908,  3637,  2478,
    2322,  2900,  2907,  4560,  4561,  2408,   645,  1280,  1936,   956,
     923,  1881,  4198,  1406,  2879,  2188,  4206,   821,   821,  3260,
     925,  1412,  3096,  3096,  1036,  2598,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,     0,     0,
    1548,  1037,  1038,  2599,  1549,  1550,   821,   821,  4655,   821,
     821,     0,     0,     0,   821,  4663,     0,   821,   821,   821,
     821,     0,   821,   821,   821,     0,     0,     0,     0,     0,
       0,   821,   821,     0,   821,   821,   821,   821,   821,     0,
    1292,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,     0,   821,     0,     0,   821,   821,  2603,     0,
    2604,   821,     0,     0,     0,   821,   821,   821,  2606,     0,
       0,     0,     0,  1293,  4774,     0,     0,   821,   821,   821,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,   821,   821,   821,  4714,   821,     0,     0,
       0,  4719,     0,     0,   821,   821,   821,     0,   821,   821,
     821,   821,   821,     0,   821,   821,   821,   821,   821,   821,
     821,   821,     0,     0,     0,   821,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4754,     0,     0,
    2612,  4686,     0,  1294,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2571,     0,     0,     0,     0,     0,  2572,
       0,  2573,  1767,  2574,  4754,     0,     0,     0,  1295,     0,
       0,   645,  1296,     0,  2575,  1767,  2576,     0,     0,     0,
    1767,     0,     0,     0,     0,  1767,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2613,  2614,  2615,     0,
       0,     0,     0,  2616,     0,     0,  2577,     0,  1297,     0,
       0,  2578,  2579,   821,     0,     0,     0,     0,  2580,  2617,
       0,  1292,     0,  2618,     0,     0,     0,     0,     0,  1298,
    2581,     0,     0,     0,     0,     0,     0,     0,  2582,     0,
       0,     0,  2619,     0,  1299,     0,     0,     0,  2583,     0,
       0,     0,     0,     0,  1293,     0,     0,     0,     0,     0,
    2621,     0,     0,     0,     0,  2584,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,  1562,
       0,     0,  2585,     0,     0,     0,   821,     0,     0,     0,
    2586,  2587,  1300,     0,     0,     0,     0,  2588,     0,     0,
       0,     0,   821,     0,     0,  2589,   821,     0,     0,  -960,
       0,  2590,     0,     0,     0,     0,     0,  1301,     0,  1127,
    3378,     0,  2591,     0,  1294,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2592,     0,     0,     0,     0,     0,     0,  1295,
       0,     0,     0,  1296,     0,     0,  1164,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1182,     0,     0,     0,     0,   273,     0,
     275,     0,     0,     0,  2593,     0,  2594,     0,     0,  1297,
       0,     0,     0,     0,  2595,     0,     0,     0,     0,     0,
    2575,     0,  2576,     0,     0,     0,     0,     0,     0,  2596,
    1298,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1226,  1302,     0,     0,     0,  1299,     0,     0,     0,     0,
    1303,     0,     0,  2597,  -817,  -817,     0,  2578,     0,     0,
       0,     0,     0,     0,     0,  1304,  -817,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2581,     0,     0,     0,
       0,     0,     0,  1305,  2582,     0,     0,  2598,     0,     0,
       0,     0,     0,  1300,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2599,     0,     0,     0,  2600,
       0,  2584,     0,     0,     0,     0,     0,     0,  1301,     0,
       0,     0,     0,   821,     0,  1562,     0,  1306,  2585,     0,
    1307,     0,     0,     0,     0,     0,     0,  1366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2601,     0,
       0,     0,     0,  2602,     0,     0,     0,  2590,  1308,     0,
    2603,     0,  2604,     0,     0,     0,     0,  2605,     0,     0,
    2606,     0,     0,     0,     0,     0,     0,   519,     0,     0,
    1309,   520,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2607,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2608,  2609,  2610,  2611,     0,
       0,     0,  1302,     0,   273,     0,   275,     0,     0,  1310,
       0,  1303,  2594,     0,     0,     0,   821,   821,   821,     0,
    2595,     0,  2612,     0,     0,     0,  1304,     0,     0,     0,
       0,   821,     0,     0,     0,  2596,     0,     0,     0,     0,
       0,     0,     0,     0,  1305,     0,     0,     0,     0,  2969,
       0,     0,     0,     0,     0,     0,     0,   821,     0,     0,
       0,     0,     0,   821,     0,     0,   821,     0,   821,     0,
       0,     0,     0,     0,   821,     0,   821,   821,  2613,  2614,
    2615,     0,     0,     0,     0,  2616,     0,     0,  1306,     0,
       0,  1307,     0,  2598,     0,     0,     0,     0,     0,     0,
       0,  2617,     0,     0,     0,  2618,     0,     0,  1598,     0,
       0,  2599,     0,     0,     0,     0,     0,     0,     0,  1308,
       0,     0,     0,     0,  2619,     0,     0,     0,     0,  2620,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1309,  2621,     0,     0,  1637,  1638,     0,     0,     0,
       0,     0,     0,     0,  1648,  1649,     0,     0,  1652,  1653,
    1654,  1655,  1658,  1659,  1660,  1661,  2603,     0,  2604,   821,
       0,     0,     0,     0,  1677,  1678,  2606,  1679,  1680,     0,
       0,     0,     0,     0,     0,  1713,  1714,  1715,  1716,     0,
    1310,  1719,     0,     0,     0,     0,     0,     0,     0,  1727,
    1728,     0,  1731,  1732,     0,     0,  -960,     0,     0,  1736,
    1737,  1738,     0,     0,  1741,  1742,  1743,  1744,  1745,  1746,
       0,  1748,   821,     0,  1751,  1752,     0,     0,     0,  1755,
       0,   821,     0,  1758,  1762,  1763,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1770,  1771,  1772,  2612,     0,
       0,     0,     0,     0,  1780,     0,     0,     0,     0,     0,
       0,  1785,  1786,  1787,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1823,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2613,  2614,  2615,     0,     0,     0,
       0,  2616,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2617,     0,     0,
       0,  2618,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2619,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2621,     0,
    2637,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1892,     0,     0,     0,  2575,     0,  2576,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -817,
    -817,     0,  2578,     0,     0,     0,  2970,     0,     0,     0,
       0,  -817,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2581,     0,     0,  1943,     0,     0,     0,     0,  2582,
       0,     0,     0,     0,  1949,     0,     0,     0,     0,   821,
       0,     0,     0,   821,     0,     0,     0,     0,   821,   821,
    1977,     0,     0,     0,  1983,     0,  2584,   821,     0,   821,
       0,   821,   821,   821,   821,     0,     0,   821,     0,     0,
    1562,     0,     0,  2585,     0,     0,     0,   821,     0,   821,
     821,     0,   821,   821,   821,   821,     0,   821,     0,     0,
     821,     0,     0,     0,     0,     0,     0,     0,     0,   821,
       0,     0,  2590,     0,     0,     0,   821,     0,   821,  2028,
     821,   821,     0,   821,   821,     0,     0,     0,   821,   821,
     821,     0,     0,     0,   821,   821,   821,     0,   821,     0,
     821,     0,   821,     0,   821,     0,   821,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,   958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,   959,     0,     0,     0,     0,     0,   821,     0,   273,
     821,   275,   896,   960,     0,     0,   821,  2594,     0,   821,
       0,     0,     0,   821,     0,  2595,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   961,   942,     0,
    2596,     0,     0,     0,     0,   962,     0,     0,     0,     0,
     963,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   964,     0,   965,     0,
     966,     0,     0,     0,     0,     0,     0,   821,     0,     0,
       0,  2210,   967,     0,     0,     0,     0,  3466,  2598,     0,
       0,     0,     0,  2572,     0,  2573,     0,     0,     0,     0,
       0,     0,     0,    14,    15,     0,  2599,     0,  2575,     0,
    2576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1893,
     968,     0,     0,     0,     0,   969,     0,     0,   970,     0,
    2577,     0,     0,     0,     0,  2578,     0,   821,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2603,     0,  2604,  2581,     0,   971,     0,   972,     0,
       0,  2606,  2582,     0,     0,     0,   973,     0,   974,     0,
       0,     0,  2583,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2292,  2294,  2296,     0,  2637,  2584,
       0,     0,     0,     0,   975,   976,   977,     0,     0,     0,
       0,  2989,     0,  1562,     0,     0,  2585,     0,     0,     0,
       0,     0,     0,     0,  2586,     0,     0,   978,     0,  2989,
    2989,  3467,     0,     0,     0,  2331,     0,     0,     0,  2589,
       0,     0,     0,  2612,  2336,  2590,  2337,     0,     0,   979,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2592,     0,     0,   980,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2637,     0,     0,     0,     0,     0,     0,     0,  2613,
    2614,  2615,     0,     0,     0,     0,  2616,     0,     0,     0,
       0,     0,   273,     0,   275,     0,     0,     0,     0,     0,
    2594,     0,  2617,     0,     0,     0,  2618,     0,  2595,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2989,
    2989,     0,     0,  2596,     0,  2619,   981,  2417,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2621,     0,     0,     0,  2597,     0,     0,
       0,     0,   982,     0,     0,   821,     0,     0,     0,   821,
       0,     0,     0,   983,   984,     0,     0,   985,   986,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2477,  2598,     0,     0,     0,     0,   821,   821,   987,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2599,
       0,     0,     0,  2600,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,   821,     0,   821,     0,   821,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   988,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,  2602,     0,   989,
       0,   821,     0,     0,  2603,     0,  2604,     0,     0,     0,
       0,     0,     0,     0,  2606,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2499,     0,   821,     0,   990,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   991,   992,     0,     0,     0,     0,     0,     0,
    2609,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2612,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2647,   993,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0, -2499,     0,     0,     0,     0,     0,     0,     0,
     994,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2613,  2614,  2615,     0,     0,     0,     0,  2616,
       0,     0,     0,     0,     0,     0,     0,   821,     0,     0,
       0,     0,     0,     0,     0,  2617,     0,  2709,     0,  2618,
       0,  2711,  2637,     0,     0,     0,  2713,  2714,     0,     0,
       0,     0,     0,     0,     0,  1655,     0,  2730,  2619,  1655,
       0,  2733,  2734,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2741,  2621,  2742,     0,     0,
    2744,  2745,  2746,  2747,     0,  2748,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2752,     1,     0,
       2,     0,     0,     0,  2753,     0,  2754,     0,  2755,  2756,
       0,  2757,     0,     0,     0,     0,  2760,  2761,  2762,     0,
       0,     4,  2764,  2765,  2766,     0,  2767,     0,  2769,     0,
    2771,     0,  2773,  2637,  2774,     5,     6,     0,  2575,  2775,
    2576,     0,     0,     7,     0,     0,   821,   821,     8,     9,
       0,     0,     0,     0,     0,     0,     0,     0,  2795,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    10,
       0,     0,     0,     0,  2805,  2578,     0,  2808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    11,     0,
       0,     0,     0,     0,  2581,  2989,     0,     0,     0,     0,
       0,     0,  2582,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,     0,     0,     0,     0,     0,   821,     0,
      13,    14,    15,     0,     0,     0,     0,     0,     0,  2584,
       0,     0,     0,    16,    17,     0,     0,     0,     0,     0,
       0,     0,     0,  1562,     0,     0,  2585,     0,     0,     0,
     821,   821,     0,   821,     0,     0,     0,     0,     0,     0,
       0,    19,   821,     0,     0,     0,     0,   821,     0,     0,
     821,     0,   821,   821,     0,  2590,     0,     0,    20,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    21,     0,    22,     0,     0,     0,     0,
      23,     0,     0,     0,    24,   821,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1977,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      25,     0,    26,     0,     0,     0,   821,     0,     0,     0,
       0,     0,   273,     0,   275,     0,     0,     0,    27,     0,
    2594,     0,     0,     0,     0,     0,     0,     0,  2595,     0,
     821,     0,     0,     0,     0,     0,    28,     0,     0,     0,
      29,     0,     0,  2596,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2598,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2637,     0,     0,     0,  2599,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,    32,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,     0,     0,
       0,     0,     0,     0,  2603,     0,  2604,     0,    34,     0,
       0,     0,     0,     0,  2606,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,    36,     0,    37,     0,     0,    38,     0,
       0,    39,    40,  3148,     0,     0,     0,  3150,     0,     0,
       0,     0,    41,     0,     0,    42,     0,     0,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,  3177,  3178,     0,    45,     0,     0,
       0,     0,    46,    47,    48,     0,  2612,     0,     0,     0,
       0,     0,     0,     0,  3198,     0,     0,     0,     0,     0,
    3715,  3716,     0,  3208,     0,  3210,  3717,  3212,  3718,     0,
    3719,  3720,     0,     0,    49,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,  3534,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2613,  2614,  2615,     0,     0,     0,     0,  2616,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2617,    51,     0,     0,  2618,
    3270,     0,     0,     0,     0,     0,     0,     0,    52,     0,
       0,   821,    53,     0,  3721,    54,     0,  3722,  2619,     0,
       0,    55,     0,     0,     0,  3723,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2621,     0,     0,     0,
       0,     0,     0,  3724,     0,     0,     0,   821,     0,     0,
       0,    56,     0,     0,     0,   821,     0,    57,     0,     0,
    3725,     0,     0,     0,     0,     0,     0,    58,     0,     0,
       0,     0,     0,     0,  1977,     0,   821,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3726,     0,  3727,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3728,  3729,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3352,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3730,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3976,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3731,     0,     0,     0,     0,
       0,     0,     0,     0,  3732,  3733,     0,  3734,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,     0,     0,   821,     0,     0,     0,     0,     0,
       0,  3735,  3736,  3737,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3738,  3739,  3740,     0,  3485,  3486,     0,  3741,     0,   821,
    3742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,  3743,  3744,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2637,     0,     0,  3745,  3746,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3517,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3747,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3556,  3557,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3564,     0,     0,     0,     0,  3566,     0,     0,  3567,  3976,
    3568,  3569,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3748,     0,     0,  4172,  3749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3750,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3595,   821,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,   821,
       0,   821,     0,     0,     0,     0,     0,     0,  3595,  3751,
       0,     0,  3752,     0,     0,  3753,  3754,  3755,  3756,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3757,
    3758,     0,     0,     0,  3595,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3759,     0,     0,     0,
     821,     0,     0,     0,     0,     0,  4172,  4172,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4329,
       0,     0,     0,  4329,  4329,     0,     0,     0,     0,     0,
     821,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   821,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,  4172,  4172,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4329,     0,     0,     0,     0,     0,     0,     0,
       0,  4329,     0,     0,     0,  4329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3595,
       0,     0,     0,     0,     0,     0,     0,  4329,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     821,     0,  4172,     0,     0,  3880,     0,     0,     0,     0,
       0,     0,     0,  3352,     0,     0,     0,  4172,   821,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3908,  4546,     0,     0,     0,     0,
       0,     0,   821,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4172,     0,     0,     0,     0,     0,
    4329,     0,  4329,  4329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,  4172,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4172,  4172,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   821,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3352,     0,
       0,     0,  4015,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4172,
       0,     0,     0,     0,     0,     0,   821,     0,     0,  4172,
       0,     0,     0,     0,     0,     0,     0,  3595,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3352,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   821,     0,     0,     0,
       0,     0,     0,  4172,     0,  4172,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   821,     0,     0,
     821,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4172,     0,     0,     0,     0,     0,     0,     0,  4172,     0,
    4172,     0,  4172,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4172,     0,     0,     0,
    4172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4172,  4172,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4172,  4172,     0,     0,     0,  4172,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   821,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4234,     0,     0,     0,     0,     0,  4239,     0,  4241,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4291,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3352,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3352,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4405,     0,  4406,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4414,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4526,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4531,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3595,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4601,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4657,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4689,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,  4706,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,  1759,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,  4755,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,  3595,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,   731,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,  1760,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,   748,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,  1761,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,  1973,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,  1974,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,  1975,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,   731,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,   748,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,  1976,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     686,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   687,     0,   152,   153,   154,   155,
     156,   157,   688,   159,     0,   160,     0,     0,   689,   161,
     690,   691,   692,   162,   693,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   694,   695,   170,
     171,     0,   172,   696,   697,   174,   175,     0,   176,   177,
     178,   179,   180,   698,   182,     0,   699,   184,   700,   701,
     702,   703,   704,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   705,
     204,     0,   205,   706,   707,   206,     0,     0,   207,   708,
     208,   709,   710,   209,     0,   210,   711,   712,     0,   211,
     212,   213,   713,   714,   715,     0,     0,     0,     0,   716,
     216,   717,     0,     0,   718,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
     719,     0,   244,   245,   246,   247,   720,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,  2291,   255,     0,   256,     0,   257,   258,   723,   260,
     724,   262,   263,     0,   264,     0,   725,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   728,   272,   273,   274,   275,   729,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   730,   281,
     282,   731,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   732,
       0,     0,   292,     0,   733,   293,   294,     0,     0,     0,
       0,     0,   734,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,   736,
     321,   322,   323,   324,   737,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   738,   332,     0,     0,   739,
     334,   740,   335,     0,   336,   741,   742,   743,   744,   745,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,   747,   748,   749,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   752,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,   753,   367,
       0,   368,     0,   369,   370,   754,   372,   373,   374,   375,
     755,   756,   378,   757,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   758,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,   759,   760,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   761,
       0,   762,   415,   416,   417,   418,   419,   420,   763,   764,
     423,   424,   425,   426,     0,   765,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,   766,   767,   454,
     455,     0,   456,   457,   768,   459,   460,   461,   769,   770,
     462,   463,   464,   465,   771,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,   773,
     774,   775,   776,     0,     0,     0,     0,     0,   479,   480,
     481,     0,   777,   778,   779,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   782,   496,   497,     0,
       0,   783,   784,   785,   786,   498,     0,     0,   499,   787,
       0,   788,   500,   501,   502,   503,   504,   789,   790,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   791,     0,     0,     0,     0,   792,   793,
       0,     0,     0,     0,   794,   795,     0,     0,   796,   797,
       0,     0,   798,   799,   142,     0,   143,   686,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   687,     0,   152,   153,   154,   155,   156,   157,   688,
     159,     0,   160,     0,     0,   689,   161,   690,   691,   692,
     162,   693,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   694,   695,   170,   171,     0,   172,
     696,   697,   174,   175,     0,   176,   177,   178,   179,   180,
     698,   182,     0,   699,   184,   700,   701,   702,   703,   704,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   705,   204,     0,   205,
     706,   707,   206,     0,     0,   207,   708,   208,   709,   710,
     209,     0,   210,   711,   712,     0,   211,   212,   213,   713,
     714,   715,     0,     0,     0,     0,   716,   216,   717,     0,
       0,   718,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   719,     0,   244,
     245,   246,   247,   720,   721,   248,   249,     0,   250,   251,
     252,   722,     0,   253,     0,     0,     0,   254,  2293,   255,
       0,   256,     0,   257,   258,   723,   260,   724,   262,   263,
       0,   264,     0,   725,     0,   265,   266,   267,     0,   268,
     726,   727,     0,   269,   270,     0,     0,     0,   728,   272,
     273,   274,   275,   729,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   730,   281,   282,   731,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   732,     0,     0,   292,
       0,   733,   293,   294,     0,     0,     0,     0,     0,   734,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     735,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   736,   321,   322,   323,
     324,   737,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   738,   332,     0,     0,   739,   334,   740,   335,
       0,   336,   741,   742,   743,   744,   745,   341,   342,   343,
     344,   345,     0,   746,   346,   347,     0,     0,   348,   349,
     350,   351,   747,   748,   749,   352,   353,     0,   750,   751,
     354,     0,   355,   356,   752,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   754,   372,   373,   374,   375,   755,   756,   378,
     757,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   758,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,   759,   760,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   761,     0,   762,   415,
     416,   417,   418,   419,   420,   763,   764,   423,   424,   425,
     426,     0,   765,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,   766,   767,   454,   455,     0,   456,
     457,   768,   459,   460,   461,   769,   770,   462,   463,   464,
     465,   771,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   772,   473,   474,     0,   773,   774,   775,   776,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   777,
     778,   779,   483,   484,   485,   780,   486,   487,   781,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   782,   496,   497,     0,     0,   783,   784,
     785,   786,   498,     0,     0,   499,   787,     0,   788,   500,
     501,   502,   503,   504,   789,   790,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     791,     0,     0,     0,     0,   792,   793,     0,     0,     0,
       0,   794,   795,     0,     0,   796,   797,     0,     0,   798,
     799,   142,     0,   143,   686,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   687,     0,
     152,   153,   154,   155,   156,   157,   688,   159,     0,   160,
       0,     0,   689,   161,   690,   691,   692,   162,   693,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   694,   695,   170,   171,     0,   172,   696,   697,   174,
     175,     0,   176,   177,   178,   179,   180,   698,   182,     0,
     699,   184,   700,   701,   702,   703,   704,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   705,   204,     0,   205,   706,   707,   206,
       0,     0,   207,   708,   208,   709,   710,   209,     0,   210,
     711,   712,     0,   211,   212,   213,   713,   714,   715,     0,
       0,     0,     0,   716,   216,   717,     0,     0,   718,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,   719,     0,   244,   245,   246,   247,
     720,   721,   248,   249,     0,   250,   251,   252,   722,     0,
     253,     0,     0,     0,   254,  2295,   255,     0,   256,     0,
     257,   258,   723,   260,   724,   262,   263,     0,   264,     0,
     725,     0,   265,   266,   267,     0,   268,   726,   727,     0,
     269,   270,     0,     0,     0,   728,   272,   273,   274,   275,
     729,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   730,   281,   282,   731,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   732,     0,     0,   292,     0,   733,   293,
     294,     0,     0,     0,     0,     0,   734,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   735,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,   736,   321,   322,   323,   324,   737,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   738,
     332,     0,     0,   739,   334,   740,   335,     0,   336,   741,
     742,   743,   744,   745,   341,   342,   343,   344,   345,     0,
     746,   346,   347,     0,     0,   348,   349,   350,   351,   747,
     748,   749,   352,   353,     0,   750,   751,   354,     0,   355,
     356,   752,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,   753,   367,     0,   368,     0,   369,   370,   754,
     372,   373,   374,   375,   755,   756,   378,   757,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   758,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,   759,
     760,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   761,     0,   762,   415,   416,   417,   418,
     419,   420,   763,   764,   423,   424,   425,   426,     0,   765,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,   766,   767,   454,   455,     0,   456,   457,   768,   459,
     460,   461,   769,   770,   462,   463,   464,   465,   771,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   772,
     473,   474,     0,   773,   774,   775,   776,     0,     0,     0,
       0,     0,   479,   480,   481,     0,   777,   778,   779,   483,
     484,   485,   780,   486,   487,   781,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     782,   496,   497,     0,     0,   783,   784,   785,   786,   498,
       0,     0,   499,   787,     0,   788,   500,   501,   502,   503,
     504,   789,   790,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   791,     0,     0,
       0,     0,   792,   793,     0,     0,     0,     0,   794,   795,
       0,     0,   796,   797,     0,     0,   798,   799,   142,     0,
     143,   686,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   687,     0,   152,   153,   154,
     155,   156,   157,   688,   159,     0,   160,     0,     0,   689,
     161,   690,   691,   692,   162,   693,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   694,   695,
     170,   171,     0,   172,   696,   697,   174,   175,     0,   176,
     177,   178,   179,   180,   698,   182,     0,   699,   184,   700,
     701,   702,   703,   704,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     705,   204,     0,   205,   706,   707,   206,     0,     0,   207,
     708,   208,   709,   710,   209,     0,   210,   711,   712,     0,
     211,   212,   213,   713,   714,   715,     0,     0,     0,     0,
     716,   216,   717,     0,     0,   718,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   719,     0,   244,   245,   246,   247,   720,   721,   248,
     249,     0,   250,   251,   252,   722,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   723,
     260,   724,   262,   263,     0,   264,     0,   725,     0,   265,
     266,   267,     0,   268,   726,   727,     0,   269,   270,     0,
       0,     0,   728,   272,   273,   274,   275,   729,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   730,
     281,   282,   731,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     732,     0,     0,   292,     0,   733,   293,   294,     0,     0,
       0,     0,     0,   734,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   735,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     736,   321,   322,   323,   324,   737,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   738,   332,     0,     0,
     739,   334,   740,   335,     0,   336,   741,   742,   743,   744,
     745,   341,   342,   343,   344,   345,     0,   746,   346,   347,
       0,     0,   348,   349,   350,   351,   747,   748,   749,   352,
     353,     0,   750,   751,   354,     0,   355,   356,   752,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,   753,
     367,     0,   368,     0,   369,   370,   754,   372,   373,   374,
     375,   755,   756,   378,   757,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   758,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,   759,   760,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     761,     0,   762,   415,   416,   417,   418,   419,   420,   763,
     764,   423,   424,   425,   426,     0,   765,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,   766,   767,
     454,   455,     0,   456,   457,   768,   459,   460,   461,   769,
     770,   462,   463,   464,   465,   771,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,   772,   473,   474,     0,
     773,   774,   775,   776,     0,     0,     0,     0,     0,   479,
     480,   481,     0,   777,   778,   779,   483,   484,   485,   780,
     486,   487,   781,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   782,   496,   497,
       0,     0,   783,   784,   785,   786,   498,     0,     0,   499,
     787,     0,   788,   500,   501,   502,   503,   504,   789,   790,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,     0,   791,     0,     0,     0,     0,   792,
     793,     0,     0,     0,     0,   794,   795,     0,     0,   796,
     797,     0,     0,   798,   799,   142,     0,   143,   686,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   687,     0,   152,   153,   154,   155,   156,   157,
     688,   159,     0,   160,     0,     0,   689,   161,   690,   691,
     692,   162,   693,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,   694,   695,   170,   171,     0,
     172,   696,   697,   174,   175,     0,   176,   177,   178,   179,
     180,   698,   182,     0,   699,   184,   700,   701,   702,   703,
     704,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   705,   204,     0,
     205,   706,   707,   206,     0,     0,   207,   708,   208,   709,
     710,   209,     0,   210,   711,   712,     0,   211,   212,   213,
     713,   714,   715,     0,     0,     0,     0,   716,   216,   717,
       0,     0,   718,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,   719,     0,
     244,   245,   246,   247,   720,   721,   248,   249,     0,   250,
     251,   252,   722,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   723,   260,   724,   262,
     263,     0,   264,     0,   725,     0,   265,   266,   267,     0,
     268,   726,   727,     0,   269,   270,     0,     0,     0,   728,
     272,   273,   274,   275,   729,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,   730,   281,   282,   731,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   732,     0,     0,
     292,     0,   733,   293,   294,     0,     0,     0,     0,     0,
     734,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   735,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,   736,   321,   322,
     323,   324,   737,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   738,   332,     0,     0,   739,   334,   740,
     335,     0,   336,   741,   742,   743,   744,   745,   341,   342,
     343,   344,   345,     0,   746,   346,   347,     0,     0,   348,
     349,   350,   351,   747,   748,   749,   352,   353,     0,   750,
     751,   354,     0,   355,   356,   752,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,   753,   367,     0,   368,
       0,   369,   370,   754,   372,   373,   374,   375,   755,   756,
     378,   757,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   758,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,   759,   760,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   761,     0,   762,
     415,   416,   417,   418,   419,   420,   763,   764,   423,   424,
     425,   426,     0,   765,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,   766,   767,   454,   455,     0,
     456,   457,   768,   459,   460,   461,   769,   770,   462,   463,
     464,   465,   771,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   772,   473,   474,     0,   773,   774,   775,
     776,     0,     0,     0,     0,     0,   479,   480,   481,     0,
     777,   778,   779,   483,   484,   485,   780,   486,   487,   781,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   782,   496,   497,     0,     0,   783,
     784,   785,   786,   498,     0,     0,   499,   787,     0,   788,
     500,   501,   502,   503,   504,   789,   790,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   791,     0,     0,     0,     0,   792,   793,     0,     0,
       0,     0,   794,  1163,     0,     0,   796,   797,     0,     0,
     798,   799,   142,     0,   143,   686,   145,   146,   147,   148,
    1794,     0,   149,     0,     0,     0,  1795,     0,     0,   687,
       0,   152,   153,   154,   155,   156,   157,   688,   159,     0,
     160,     0,     0,   689,   161,   690,   691,   692,   162,   693,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   694,   695,   170,   171,     0,   172,   696,   697,
     174,   175,     0,   176,   177,   178,   179,   180,   698,   182,
       0,   699,   184,   700,   701,   702,   703,   704,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   705,   204,     0,   205,   706,   707,
     206,     0,     0,   207,   708,   208,   709,   710,   209,     0,
     210,   711,   712,     0,   211,   212,   213,   713,   714,   715,
       0,     0,     0,     0,   716,   216,   717,     0,     0,   718,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   719,     0,   244,   245,   246,
     247,   720,   721,   248,   249,     0,   250,   251,   252,   722,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   723,   260,   724,   262,   263,     0,   264,
       0,   725,     0,   265,   266,   267,     0,   268,   726,   727,
       0,   269,   270,     0,     0,     0,   728,   272,   273,   274,
     275,   729,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   730,   281,   282,   731,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   732,     0,     0,   292,     0,   733,
     293,   294,     0,     0,     0,     0,     0,   734,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   735,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   736,   321,   322,   323,   324,   737,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     738,   332,     0,     0,   739,   334,   740,   335,     0,   336,
     741,   742,   743,   744,   745,   341,   342,   343,   344,   345,
       0,   746,   346,   347,     0,     0,   348,   349,   350,   351,
     747,     0,   749,   352,   353,     0,   750,   751,   354,     0,
     355,   356,   752,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,   753,   367,     0,   368,     0,   369,   370,
     754,   372,   373,   374,   375,   755,   756,   378,   757,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   758,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
     759,   760,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   761,     0,   762,   415,   416,   417,
     418,   419,   420,   763,   764,   423,   424,   425,   426,     0,
     765,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,   766,   767,   454,   455,     0,   456,   457,   768,
     459,   460,   461,   769,   770,   462,   463,   464,   465,   771,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
     772,   473,   474,     0,   773,   774,   775,   776,     0,     0,
       0,     0,     0,   479,   480,   481,     0,   777,   778,   779,
     483,   484,   485,   780,   486,   487,   781,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   782,   496,   497,     0,     0,   783,   784,   785,   786,
     498,     0,     0,   499,   787,     0,   788,   500,   501,   502,
     503,   504,   789,   790,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,     0,   791,     0,
       0,     0,     0,   792,   793,     0,     0,     0,     0,   794,
     795,     0,     0,   796,   797,     0,     0,   798,   799,   142,
       0,   143,   686,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   687,     0,   152,   153,
     154,   155,   156,   157,   688,   159,     0,   160,     0,     0,
     689,   161,   690,   691,   692,   162,   693,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,   694,
     695,   170,   171,     0,   172,   696,   697,   174,   175,     0,
     176,   177,   178,   179,   180,   698,   182,     0,   699,   184,
     700,   701,   702,   703,   704,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   705,   204,     0,   205,   706,   707,   206,     0,     0,
     207,   708,   208,   709,   710,   209,     0,   210,   711,   712,
       0,   211,   212,   213,   713,   714,   715,     0,     0,     0,
       0,   716,   216,   717,     0,     0,   718,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,   719,     0,   244,   245,   246,   247,   720,   721,
     248,   249,     0,   250,   251,   252,   722,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     723,   260,   724,   262,   263,     0,   264,     0,   725,     0,
     265,   266,   267,     0,   268,   726,   727,     0,   269,   270,
       0,     0,     0,   728,   272,   273,   274,   275,   729,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
     730,   281,   282,   731,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   732,     0,     0,   292,     0,   733,   293,   294,     0,
       0,     0,     0,     0,   734,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,   735,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,   736,   321,   322,   323,   324,   737,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   738,   332,     0,
       0,   739,   334,   740,   335,     0,   336,   741,   742,   743,
     744,   745,   341,   342,   343,   344,   345,     0,   746,   346,
     347,     0,     0,   348,   349,   350,   351,   747,   748,   749,
     352,   353,     0,   750,   751,   354,     0,   355,   356,   752,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   754,   372,   373,
     374,   375,   755,   756,   378,   757,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   758,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,   759,   760,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   761,     0,   762,   415,   416,   417,   418,   419,   420,
     763,   764,   423,   424,   425,   426,     0,   765,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,   766,
     767,   454,   455,     0,   456,   457,   768,   459,   460,   461,
     769,   770,   462,   463,   464,   465,   771,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   772,   473,   474,
       0,   773,   774,   775,   776,     0,     0,     0,     0,     0,
     479,   480,   481,     0,   777,   778,   779,   483,   484,   485,
     780,   486,   487,   781,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,  1891,   496,
     497,     0,     0,   783,   784,   785,   786,   498,     0,     0,
     499,   787,     0,   788,   500,   501,   502,   503,   504,   789,
     790,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   791,     0,     0,     0,     0,
     792,   793,     0,     0,     0,     0,   794,   795,     0,     0,
     796,   797,     0,     0,   798,   799,   142,     0,   143,   686,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   687,     0,   152,   153,   154,   155,   156,
     157,   688,   159,     0,   160,     0,     0,   689,   161,   690,
     691,   692,   162,   693,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   694,   695,   170,   171,
       0,   172,   696,   697,   174,   175,     0,   176,   177,   178,
     179,   180,   698,   182,     0,   699,   184,   700,   701,   702,
     703,   704,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   705,   204,
       0,   205,   706,   707,   206,     0,     0,   207,   708,   208,
     709,   710,   209,     0,   210,   711,   712,     0,   211,   212,
     213,   713,   714,   715,     0,     0,     0,     0,   716,   216,
     717,     0,     0,   718,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   719,
       0,   244,   245,   246,   247,   720,   721,   248,   249,     0,
     250,   251,   252,   722,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   723,   260,   724,
     262,   263,     0,   264,     0,   725,     0,   265,   266,   267,
       0,   268,   726,   727,     0,   269,   270,     0,     0,     0,
     728,   272,   273,   274,   275,   729,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   730,   281,   282,
    2708,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   732,     0,
       0,   292,     0,   733,   293,   294,     0,     0,     0,     0,
       0,   734,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   735,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   736,   321,
     322,   323,   324,   737,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   738,   332,     0,     0,   739,   334,
     740,   335,     0,   336,   741,   742,   743,   744,   745,   341,
     342,   343,   344,   345,     0,   746,   346,   347,     0,     0,
     348,   349,   350,   351,   747,   748,   749,   352,   353,     0,
     750,   751,   354,     0,   355,   356,   752,     0,   358,   359,
     360,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,     0,   364,   365,   366,     0,   753,   367,     0,
     368,     0,   369,   370,   754,   372,   373,   374,   375,   755,
     756,   378,   757,     0,   379,   380,   381,     0,   382,     0,
     383,   384,   385,   386,   387,     0,   758,   389,   390,     0,
       0,   391,     0,     0,     0,   392,   393,   394,   395,   396,
       0,     0,   397,   398,   399,   400,   401,     0,   402,   403,
       0,   404,   405,   406,   759,   760,   407,     0,   408,     0,
     409,   410,     0,   411,   412,     0,   413,     0,   761,     0,
     762,   415,   416,   417,   418,   419,   420,   763,   764,   423,
     424,   425,   426,     0,   765,   428,     0,     0,     0,   429,
     430,   431,   432,     0,     0,     0,   433,     0,     0,     0,
     434,     0,   435,   436,   437,   438,   439,   440,     0,   441,
     442,   443,   444,   445,   446,     0,     0,     0,     0,     0,
       0,   447,   448,     0,   449,     0,     0,   450,     0,     0,
     451,   452,     0,     0,     0,   453,   766,   767,   454,   455,
       0,   456,   457,   768,   459,   460,   461,   769,   770,   462,
     463,   464,   465,   771,   466,   467,     0,   468,     0,   469,
     470,   471,   472,     0,   772,   473,   474,     0,   773,   774,
     775,   776,     0,     0,     0,     0,     0,   479,   480,   481,
       0,   777,   778,   779,   483,   484,   485,   780,   486,   487,
     781,   488,   489,     0,   490,   491,     0,     0,   492,     0,
       0,   493,     0,   494,     0,   782,   496,   497,     0,     0,
     783,   784,   785,   786,   498,     0,     0,   499,   787,     0,
     788,   500,   501,   502,   503,   504,   789,   790,     0,     0,
       0,     0,     0,     0,   507,   508,     0,   509,   510,   511,
       0,     0,   791,     0,     0,     0,     0,   792,   793,     0,
       0,     0,     0,   794,   795,     0,     0,   796,   797,     0,
       0,   798,   799,   142,     0,   143,   686,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     687,     0,   152,   153,   154,   155,   156,   157,   688,   159,
       0,   160,     0,     0,   689,   161,   690,   691,   692,   162,
     693,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,   694,   695,   170,   171,     0,   172,   696,
     697,   174,   175,     0,   176,   177,   178,   179,   180,   698,
     182,     0,   699,   184,   700,   701,   702,   703,   704,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   705,   204,     0,   205,   706,
     707,   206,     0,     0,   207,   708,   208,   709,   710,   209,
       0,   210,   711,   712,     0,   211,   212,   213,   713,   714,
     715,     0,     0,     0,     0,   716,   216,   717,     0,     0,
     718,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,   719,     0,   244,   245,
     246,   247,   720,   721,   248,   249,     0,   250,   251,   252,
     722,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   723,   260,   724,   262,   263,     0,
     264,     0,   725,     0,   265,   266,   267,     0,   268,   726,
     727,     0,   269,   270,     0,     0,     0,   728,   272,   273,
     274,   275,   729,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,   730,   281,   282,  2759,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   732,     0,     0,   292,     0,
     733,   293,   294,     0,     0,     0,     0,     0,   734,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,   735,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,   736,   321,   322,   323,   324,
     737,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   738,   332,     0,     0,   739,   334,   740,   335,     0,
     336,   741,   742,   743,   744,   745,   341,   342,   343,   344,
     345,     0,   746,   346,   347,     0,     0,   348,   349,   350,
     351,   747,   748,   749,   352,   353,     0,   750,   751,   354,
       0,   355,   356,   752,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,   753,   367,     0,   368,     0,   369,
     370,   754,   372,   373,   374,   375,   755,   756,   378,   757,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   758,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,   759,   760,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   761,     0,   762,   415,   416,
     417,   418,   419,   420,   763,   764,   423,   424,   425,   426,
       0,   765,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,   766,   767,   454,   455,     0,   456,   457,
     768,   459,   460,   461,   769,   770,   462,   463,   464,   465,
     771,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,   772,   473,   474,     0,   773,   774,   775,   776,     0,
       0,     0,     0,     0,   479,   480,   481,     0,   777,   778,
     779,   483,   484,   485,   780,   486,   487,   781,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   782,   496,   497,     0,     0,   783,   784,   785,
     786,   498,     0,     0,   499,   787,     0,   788,   500,   501,
     502,   503,   504,   789,   790,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   791,
       0,     0,     0,     0,   792,   793,     0,     0,     0,     0,
     794,   795,     0,     0,   796,   797,     0,     0,   798,   799,
     142,     0,   143,   686,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   687,     0,   152,
     153,   154,   155,   156,   157,   688,   159,     0,   160,     0,
       0,   689,   161,   690,   691,   692,   162,   693,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     694,   695,   170,   171,     0,   172,   696,   697,   174,   175,
       0,   176,   177,   178,   179,   180,   698,   182,     0,   699,
     184,   700,   701,   702,   703,   704,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   705,   204,     0,   205,   706,   707,   206,     0,
       0,   207,   708,   208,   709,   710,   209,     0,   210,   711,
     712,     0,   211,   212,   213,   713,   714,   715,     0,     0,
       0,     0,   716,   216,   717,     0,     0,  3594,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   719,     0,   244,   245,   246,   247,   720,
     721,   248,   249,     0,   250,   251,   252,   722,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   723,   260,   724,   262,   263,     0,   264,     0,   725,
       0,   265,   266,   267,     0,   268,   726,   727,     0,   269,
     270,     0,     0,     0,   728,   272,   273,   274,   275,   729,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   730,   281,   282,   731,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   732,     0,     0,   292,     0,   733,   293,   294,
       0,     0,     0,     0,     0,   734,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   735,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   736,   321,   322,   323,   324,   737,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   738,   332,
       0,     0,   739,   334,   740,   335,     0,   336,   741,   742,
     743,   744,   745,   341,   342,   343,   344,   345,     0,   746,
     346,   347,     0,     0,   348,   349,   350,   351,   747,   748,
     749,   352,   353,     0,   750,   751,   354,     0,   355,   356,
     752,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,   753,   367,     0,   368,     0,   369,   370,   754,   372,
     373,   374,   375,   755,   756,   378,   757,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     758,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,   759,   760,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   761,     0,   762,   415,   416,   417,   418,   419,
     420,   763,   764,   423,   424,   425,   426,     0,   765,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
     766,   767,   454,   455,     0,   456,   457,   768,   459,   460,
     461,   769,   770,   462,   463,   464,   465,   771,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   772,   473,
     474,     0,   773,   774,   775,   776,     0,     0,     0,     0,
       0,   479,   480,   481,     0,   777,   778,   779,   483,   484,
     485,   780,   486,   487,   781,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   782,
     496,   497,     0,     0,   783,   784,   785,   786,   498,     0,
       0,   499,   787,     0,   788,   500,   501,   502,   503,   504,
     789,   790,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   791,     0,     0,     0,
       0,   792,   793,     0,     0,     0,     0,   794,   795,     0,
       0,   796,   797,     0,     0,   798,   799,   142,     0,   143,
     686,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   687,     0,   152,   153,   154,   155,
     156,   157,   688,   159,     0,   160,     0,     0,   689,   161,
     690,   691,   692,   162,   693,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,   694,   695,   170,
     171,     0,   172,   696,   697,   174,   175,     0,   176,   177,
     178,   179,   180,   698,   182,     0,   699,   184,   700,   701,
     702,   703,   704,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   705,
     204,     0,   205,   706,   707,   206,     0,     0,   207,   708,
     208,   709,   710,   209,     0,   210,   711,   712,     0,   211,
     212,   213,   713,   714,   715,     0,     0,     0,     0,   716,
     216,   717,     0,     0,   718,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
     719,     0,   244,   245,   246,   247,   720,   721,   248,   249,
       0,   250,   251,   252,   722,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   723,   260,
     724,   262,   263,     0,   264,     0,   725,     0,   265,   266,
     267,     0,   268,   726,   727,     0,   269,   270,     0,     0,
       0,   728,   272,   273,   274,   275,   729,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,   730,   281,
     282,   731,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   732,
       0,     0,   292,     0,   733,   293,   294,     0,     0,     0,
       0,     0,   734,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,   735,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,   736,
     321,   322,   323,   324,   737,   325,   326,  4622,     0,     0,
       0,   327,   328,   329,   330,   738,   332,     0,     0,   739,
     334,   740,   335,     0,   336,   741,   742,   743,   744,   745,
     341,   342,   343,   344,   345,     0,   746,   346,   347,     0,
       0,   348,   349,   350,   351,   747,     0,   749,   352,   353,
       0,   750,   751,   354,     0,   355,   356,   752,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,   753,   367,
       0,   368,     0,   369,   370,   754,   372,   373,   374,   375,
     755,   756,   378,   757,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   758,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,   759,   760,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   761,
       0,   762,   415,   416,   417,   418,   419,   420,   763,   764,
     423,   424,   425,   426,     0,   765,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,   766,   767,   454,
     455,     0,   456,   457,   768,   459,   460,   461,   769,   770,
     462,   463,   464,   465,   771,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   772,   473,   474,     0,   773,
     774,   775,   776,     0,     0,     0,     0,     0,   479,   480,
     481,     0,   777,   778,   779,   483,   484,   485,   780,   486,
     487,   781,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   782,   496,   497,     0,
       0,   783,   784,   785,   786,   498,     0,     0,   499,   787,
       0,   788,   500,   501,   502,   503,   504,   789,   790,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   791,     0,     0,     0,     0,   792,   793,
       0,     0,     0,     0,   794,   795,     0,     0,   796,   797,
       0,     0,   798,   799,   142,     0,   143,   686,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   687,     0,   152,   153,   154,   155,   156,   157,   688,
     159,     0,   160,     0,     0,   689,   161,   690,   691,   692,
     162,   693,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   694,   695,   170,   171,     0,   172,
     696,   697,   174,   175,     0,   176,   177,   178,   179,   180,
     698,   182,     0,   699,   184,   700,   701,   702,   703,   704,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   705,   204,     0,   205,
     706,   707,   206,     0,     0,   207,   708,   208,   709,   710,
     209,     0,   210,   711,   712,     0,   211,   212,   213,   713,
     714,   715,     0,     0,     0,     0,   716,   216,   717,     0,
       0,   718,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   719,     0,   244,
     245,   246,   247,   720,   721,   248,   249,     0,   250,   251,
     252,   722,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   723,   260,   724,   262,   263,
       0,   264,     0,   725,     0,   265,   266,   267,     0,   268,
     726,   727,     0,   269,   270,     0,     0,     0,   728,   272,
     273,   274,   275,   729,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   730,   281,   282,   731,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   732,     0,     0,   292,
       0,   733,   293,   294,     0,     0,     0,     0,     0,   734,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     735,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   736,   321,   322,   323,
     324,   737,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   738,   332,     0,     0,   739,   334,   740,   335,
       0,   336,   741,   742,   743,   744,   745,   341,   342,   343,
     344,   345,     0,   746,   346,   347,     0,     0,   348,   349,
     350,   351,   747,     0,   749,   352,   353,     0,   750,   751,
     354,     0,   355,   356,   752,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   754,   372,   373,   374,   375,   755,   756,   378,
     757,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   758,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,   759,   760,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   761,     0,   762,   415,
     416,   417,   418,   419,   420,   763,   764,   423,   424,   425,
     426,     0,   765,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,   766,   767,   454,   455,     0,   456,
     457,   768,   459,   460,   461,   769,   770,   462,   463,   464,
     465,   771,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   772,   473,   474,     0,   773,   774,   775,   776,
       0,     0,     0,     0,     0,   479,   480,   481,     0,   777,
     778,   779,   483,   484,   485,   780,   486,   487,   781,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   782,   496,   497,     0,     0,   783,   784,
     785,   786,   498,     0,     0,   499,   787,     0,   788,   500,
     501,   502,   503,   504,   789,   790,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     791,     0,     0,     0,     0,   792,   793,     0,     0,     0,
       0,   794,   795,     0,     0,   796,   797,     0,     0,   798,
     799,   142,     0,   143,   686,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   687,     0,
     152,   153,   154,   155,   156,   157,   688,   159,     0,   160,
       0,     0,   689,   161,   690,   691,   692,   162,   693,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,   694,   695,   170,   171,     0,   172,   696,   697,   174,
     175,     0,   176,   177,   178,   179,   180,   698,   182,     0,
     699,   184,   700,   701,   702,   703,   704,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   705,   204,     0,   205,   706,   707,   206,
       0,     0,   207,   708,   208,   709,   710,   209,     0,   210,
     711,   712,     0,   211,   212,   213,   713,   714,   715,     0,
       0,     0,     0,   716,   216,   717,     0,     0,   718,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,   719,     0,   244,   245,   246,   247,
     720,   721,   248,   249,     0,   250,   251,   252,   722,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   723,   260,   724,   262,   263,     0,   264,     0,
     725,     0,   265,   266,   267,     0,   268,   726,   727,     0,
     269,   270,     0,     0,     0,   728,   272,   273,   274,   275,
     729,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,   730,   281,   282,  1809,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   732,     0,     0,   292,     0,   733,   293,
     294,     0,     0,     0,     0,     0,   734,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,   735,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,   736,   321,   322,   323,   324,   737,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   738,
     332,     0,     0,   739,   334,   740,   335,     0,   336,   741,
     742,   743,   744,   745,   341,   342,   343,   344,   345,     0,
     746,   346,   347,     0,     0,   348,   349,   350,   351,   747,
       0,   749,   352,   353,     0,   750,   751,   354,     0,   355,
     356,   752,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,   753,   367,     0,   368,     0,   369,   370,   754,
     372,   373,   374,   375,   755,   756,   378,   757,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   758,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,   759,
     760,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   761,     0,   762,   415,   416,   417,   418,
     419,   420,   763,   764,   423,   424,   425,   426,     0,   765,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,   766,   767,   454,   455,     0,   456,   457,   768,   459,
     460,   461,   769,   770,   462,   463,   464,   465,   771,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   772,
     473,   474,     0,   773,   774,   775,   776,     0,     0,     0,
       0,     0,   479,   480,   481,     0,   777,   778,   779,   483,
     484,   485,   780,   486,   487,   781,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     782,   496,   497,     0,     0,   783,   784,   785,   786,   498,
       0,     0,   499,   787,     0,   788,   500,   501,   502,   503,
     504,   789,   790,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   791,     0,     0,
       0,     0,   792,   793,     0,     0,     0,     0,   794,   795,
       0,     0,   796,   797,     0,     0,   798,   799,   142,     0,
     143,   686,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   687,     0,   152,   153,   154,
     155,   156,   157,   688,   159,     0,   160,     0,     0,   689,
     161,   690,   691,   692,   162,   693,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   694,   695,
     170,   171,     0,   172,   696,   697,   174,   175,     0,   176,
     177,   178,   179,   180,   698,   182,     0,   699,   184,   700,
     701,   702,   703,   704,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     705,   204,     0,   205,   706,   707,   206,     0,     0,   207,
     708,   208,   709,   710,   209,     0,   210,   711,   712,     0,
     211,   212,   213,   713,   714,   715,     0,     0,     0,     0,
     716,   216,   717,     0,     0,   718,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   719,     0,   244,   245,   246,   247,   720,   721,   248,
     249,     0,   250,   251,   252,   722,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   723,
     260,   724,   262,   263,     0,   264,     0,   725,     0,   265,
     266,   267,     0,   268,   726,   727,     0,   269,   270,     0,
       0,     0,   728,   272,   273,   274,   275,   729,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   730,
     281,   282,  1811,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     732,     0,     0,   292,     0,   733,   293,   294,     0,     0,
       0,     0,     0,   734,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   735,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     736,   321,   322,   323,   324,   737,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   738,   332,     0,     0,
     739,   334,   740,   335,     0,   336,   741,   742,   743,   744,
     745,   341,   342,   343,   344,   345,     0,   746,   346,   347,
       0,     0,   348,   349,   350,   351,   747,     0,   749,   352,
     353,     0,   750,   751,   354,     0,   355,   356,   752,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,   753,
     367,     0,   368,     0,   369,   370,   754,   372,   373,   374,
     375,   755,   756,   378,   757,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   758,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,   759,   760,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     761,     0,   762,   415,   416,   417,   418,   419,   420,   763,
     764,   423,   424,   425,   426,     0,   765,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,   766,   767,
     454,   455,     0,   456,   457,   768,   459,   460,   461,   769,
     770,   462,   463,   464,   465,   771,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,   772,   473,   474,     0,
     773,   774,   775,   776,     0,     0,     0,     0,     0,   479,
     480,   481,     0,   777,   778,   779,   483,   484,   485,   780,
     486,   487,   781,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   782,   496,   497,
       0,     0,   783,   784,   785,   786,   498,     0,     0,   499,
     787,     0,   788,   500,   501,   502,   503,   504,   789,   790,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,     0,   791,     0,     0,     0,     0,   792,
     793,     0,     0,     0,     0,   794,   795,     0,     0,   796,
     797,     0,     0,   798,   799,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,   690,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,  1850,     0,     0,     0,     0,   215,   216,   717,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,   721,   248,   249,     0,   250,
     251,   252,   722,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,   726,   727,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,   735,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,   746,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,   750,
     751,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,   772,   473,   474,     0,  1851,   476,   477,
    1852,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,   778,   482,   483,   484,   485,   780,   486,   487,   781,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
     798,   799,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,  2998,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,   526,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,  2130,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,  2131,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,  3369,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,  2429,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,   531,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,  3071,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,  2998,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,   526,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,  2130,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,  2131,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   431,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,   531,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   479,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,  3071,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,  2429,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
    2867,     0,     0,   150,     0,     0,   151,   799,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,  4766,   149,
       0,     0,     0,   150,  4767,   799,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,  1168,     0,   149,
       0,     0,     0,   150,     0,   799,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,  1382,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,   560,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,     0,     0,     0,     0,     0,
    2377,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,   560,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,  3070,
       0,   149,     0,     0,     0,   150,     0,  3071,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,  4767,   799,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,     0,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,   560,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   631,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   632,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,     0,   512,     0,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,   560,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,   799,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,  3071,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   941,
     942,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
     943,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   944,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   945,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   946,   344,
     345,     0,     0,   346,   347,     0,     0,   348,   349,   350,
     351,     0,     0,     0,   352,   353,     0,     0,     0,   354,
       0,   355,   356,   357,     0,   358,   359,   360,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,     0,
     364,   365,   366,     0,     0,   367,     0,   368,     0,   369,
     370,   947,   372,   373,   374,   375,   376,   377,   378,     0,
       0,   379,   380,   381,     0,   382,     0,   383,   384,   385,
     386,   387,     0,   388,   389,   390,     0,     0,   391,     0,
       0,     0,   392,   393,   394,   395,   396,     0,     0,   397,
     398,   399,   400,   401,     0,   402,   403,     0,   404,   405,
     406,     0,     0,   407,     0,   408,     0,   409,   410,     0,
     411,   412,     0,   413,     0,   414,     0,     0,   948,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
       0,   427,   428,     0,     0,     0,   429,   430,   949,   432,
       0,     0,     0,   433,     0,     0,     0,   434,     0,   435,
     436,   437,   438,   439,   440,     0,   441,   442,   443,   444,
     445,   446,     0,     0,     0,     0,     0,     0,   447,   448,
       0,   449,     0,     0,   450,     0,     0,   451,   452,     0,
       0,     0,   453,     0,     0,   454,   455,     0,   456,   457,
     458,   459,   460,   461,     0,     0,   462,   463,   464,   465,
       0,   466,   467,     0,   468,     0,   469,   470,   471,   472,
       0,     0,   473,   474,     0,   475,   476,   477,   478,     0,
       0,     0,     0,     0,   950,   480,   481,     0,     0,     0,
     482,   483,   484,   485,     0,   486,   487,     0,   488,   489,
       0,   490,   491,     0,     0,   492,     0,     0,   493,     0,
     494,     0,   495,   496,   497,     0,     0,     0,     0,     0,
       0,   498,     0,     0,   499,     0,     0,     0,   500,   501,
     502,   503,   504,   505,   506,     0,     0,     0,     0,     0,
       0,   507,   508,     0,   509,   510,   511,     0,     0,   512,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,   951,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     643,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,     0,     0,
     346,   347,     0,     0,   348,   349,   350,   351,     0,     0,
       0,   352,   353,     0,     0,     0,   354,     0,   355,   356,
     357,     0,   358,   359,   360,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,     0,   364,   365,   366,
       0,     0,   367,     0,   368,     0,   369,   370,   371,   372,
     373,   374,   375,   376,   377,   378,     0,     0,   379,   380,
     381,     0,   382,     0,   383,   384,   385,   386,   387,     0,
     388,   389,   390,     0,     0,   391,     0,     0,     0,   392,
     393,   394,   395,   396,     0,     0,   397,   398,   399,   400,
     401,     0,   402,   403,     0,   404,   405,   406,     0,     0,
     407,     0,   408,     0,   409,   410,     0,   411,   412,     0,
     413,     0,   414,     0,     0,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,     0,   427,   428,
       0,     0,     0,   429,   430,   431,   432,     0,     0,     0,
     433,     0,     0,     0,   434,     0,   435,   436,   437,   438,
     439,   440,     0,   441,   442,   443,   444,   445,   446,     0,
       0,     0,     0,     0,     0,   447,   448,     0,   449,     0,
       0,   450,     0,     0,   451,   452,     0,     0,     0,   453,
       0,     0,   454,   455,     0,   456,   457,   458,   459,   460,
     461,     0,     0,   462,   463,   464,   465,     0,   466,   467,
       0,   468,     0,   469,   470,   471,   472,     0,   139,   473,
     474,     0,   475,   476,   477,   478,     0,     0,     0,     0,
       0,   479,   480,   481,     0,     0,     0,   482,   483,   484,
     485,     0,   486,   487,     0,   488,   489,     0,   490,   491,
       0,     0,   492,     0,     0,   493,     0,   494,     0,   495,
     496,   497,     0,     0,     0,     0,     0,     0,   498,     0,
       0,   499,     0,     0,     0,   500,   501,   502,   503,   504,
     505,   506,     0,     0,     0,     0,     0,     0,   507,   508,
       0,   509,   510,   511,     0,     0,   512,   142,     0,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,  1435,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   643,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   139,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,  1781,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     941,   942,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,   943,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   944,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   945,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   946,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   947,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   948,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   949,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,     0,
     512,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,   951,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   643,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,     0,
       0,   346,   347,     0,     0,   348,   349,   350,   351,     0,
       0,     0,   352,   353,     0,     0,     0,   354,     0,   355,
     356,   357,     0,   358,   359,   360,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,     0,   364,   365,
     366,     0,     0,   367,     0,   368,     0,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,   379,
     380,   381,     0,   382,     0,   383,   384,   385,   386,   387,
       0,   388,   389,   390,     0,     0,   391,     0,     0,     0,
     392,   393,   394,   395,   396,     0,     0,   397,   398,   399,
     400,   401,     0,   402,   403,     0,   404,   405,   406,     0,
       0,   407,     0,   408,     0,   409,   410,     0,   411,   412,
       0,   413,     0,   414,     0,     0,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,     0,   427,
     428,     0,     0,     0,   429,   430,   431,   432,     0,     0,
       0,   433,     0,     0,     0,   434,     0,   435,   436,   437,
     438,   439,   440,     0,   441,   442,   443,   444,   445,   446,
       0,     0,     0,     0,     0,     0,   447,   448,     0,   449,
       0,     0,   450,     0,     0,   451,   452,     0,     0,     0,
     453,     0,     0,   454,   455,     0,   456,   457,   458,   459,
     460,   461,     0,     0,   462,   463,   464,   465,     0,   466,
     467,     0,   468,     0,   469,   470,   471,   472,     0,   139,
     473,   474,     0,   475,   476,   477,   478,     0,     0,     0,
       0,     0,   479,   480,   481,     0,     0,     0,   482,   483,
     484,   485,     0,   486,   487,     0,   488,   489,     0,   490,
     491,     0,     0,   492,     0,     0,   493,     0,   494,     0,
     495,   496,   497,     0,     0,     0,     0,     0,     0,   498,
       0,     0,   499,     0,     0,     0,   500,   501,   502,   503,
     504,   505,   506,     0,     0,     0,     0,     0,     0,   507,
     508,     0,   509,   510,   511,     0,     0,   512,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,  3630,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,  1315,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,     0,     0,   346,   347,
       0,     0,   348,   349,   350,   351,     0,     0,     0,   352,
     353,     0,     0,     0,   354,     0,   355,   356,   357,     0,
     358,   359,   360,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,     0,   364,   365,   366,     0,     0,
     367,     0,   368,     0,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,   379,   380,   381,     0,
     382,     0,   383,   384,   385,   386,   387,     0,   388,   389,
     390,     0,     0,   391,     0,     0,     0,   392,   393,   394,
     395,   396,     0,     0,   397,   398,   399,   400,   401,     0,
     402,   403,     0,   404,   405,   406,     0,     0,   407,     0,
     408,     0,   409,   410,     0,   411,   412,     0,   413,     0,
     414,     0,     0,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,     0,   427,   428,     0,     0,
       0,   429,   430,   431,   432,     0,     0,     0,   433,     0,
       0,     0,   434,     0,   435,   436,   437,   438,   439,   440,
       0,   441,   442,   443,   444,   445,   446,     0,     0,     0,
       0,     0,     0,   447,   448,     0,   449,     0,     0,   450,
       0,     0,   451,   452,     0,     0,     0,   453,     0,     0,
     454,   455,     0,   456,   457,   458,   459,   460,   461,     0,
       0,   462,   463,   464,   465,     0,   466,   467,     0,   468,
       0,   469,   470,   471,   472,     0,     0,   473,   474,     0,
     475,   476,   477,   478,     0,     0,     0,     0,     0,   479,
     480,   481,     0,     0,     0,   482,   483,   484,   485,     0,
     486,   487,     0,   488,   489,     0,   490,   491,     0,     0,
     492,     0,     0,   493,     0,   494,     0,   495,   496,   497,
       0,     0,     0,     0,     0,     0,   498,     0,     0,   499,
       0,     0,     0,   500,   501,   502,   503,   504,   505,   506,
       0,     0,     0,     0,     0,     0,   507,   508,     0,   509,
     510,   511,     0,     0,   512,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,  1316,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,     0,     0,   346,   347,     0,     0,   348,
     349,   350,   351,     0,     0,     0,   352,   353,     0,     0,
       0,   354,     0,   355,   356,   357,     0,   358,   359,   360,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,     0,   364,   365,   366,     0,     0,   367,     0,   368,
       0,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,   379,   380,   381,     0,   382,     0,   383,
     384,   385,   386,   387,     0,   388,   389,   390,     0,     0,
     391,     0,     0,     0,   392,   393,   394,   395,   396,     0,
       0,   397,   398,   399,   400,   401,     0,   402,   403,     0,
     404,   405,   406,     0,     0,   407,     0,   408,     0,   409,
     410,     0,   411,   412,     0,   413,     0,   414,     0,     0,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,     0,   427,   428,     0,     0,     0,   429,   430,
     431,   432,     0,     0,     0,   433,     0,     0,     0,   434,
       0,   435,   436,   437,   438,   439,   440,     0,   441,   442,
     443,   444,   445,   446,     0,     0,     0,     0,     0,     0,
     447,   448,     0,   449,     0,     0,   450,     0,     0,   451,
     452,     0,     0,     0,   453,     0,     0,   454,   455,     0,
     456,   457,   458,   459,   460,   461,     0,     0,   462,   463,
     464,   465,     0,   466,   467,     0,   468,     0,   469,   470,
     471,   472,     0,     0,   473,   474,     0,   475,   476,   477,
     478,     0,     0,     0,     0,     0,   479,   480,   481,     0,
       0,     0,   482,   483,   484,   485,     0,   486,   487,     0,
     488,   489,     0,   490,   491,     0,     0,   492,     0,     0,
     493,     0,   494,     0,   495,   496,   497,     0,     0,     0,
       0,     0,     0,   498,     0,     0,   499,     0,     0,     0,
     500,   501,   502,   503,   504,   505,   506,     0,     0,     0,
       0,     0,     0,   507,   508,     0,   509,   510,   511,     0,
       0,   512,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,     0,
    1316,   152,   153,   154,   155,   156,   157,   158,     0,     0,
    -372,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,     0,     0,     0,
       0,   169,  4145,     0,   170,   171,     0,   172,     0,     0,
       0,     0,     0,   176,   177,   178,   179,  4146,   181,   182,
       0,   183,   184,     0,     0,     0,     0,     0,     0,   190,
       0,   192,     0,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,     0,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,     0,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,     0,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,     0,     0,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,  4147,   250,   251,   252,     0,
       0,     0,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,     0,   263,     0,   264,
       0,     0,     0,     0,   266,   267,     0,     0,     0,     0,
       0,     0,   270,     0,     0,     0,   271,   272,   273,   274,
     275,  4148,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,     0,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,  4149,     0,     0,   288,
       0,     0,     0,   290,   291,     0,     0,   292,  4150,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
    -327,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
       0,     0,   346,   347,     0,     0,   348,   349,   350,   351,
       0,     0,     0,     0,   353,     0,     0,     0,   354,     0,
     355,   356,   357,     0,   358,   359,   360,  4151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,     0,     0,     0,     0,   368,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,     0,     0,     0,
       0,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   388,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,     0,     0,   404,     0,   406,
    -327,     0,   407,     0,     0,     0,   409,     0,     0,   411,
     412,     0,   413,  4152,   414,     0,     0,   415,     0,   417,
     418,   419,   420,   421,   422,   423,     0,   425,   426,     0,
     427,     0,     0,     0,     0,   429,   430,   431,     0,     0,
       0,     0,   433,     0,     0,     0,     0,     0,     0,   436,
       0,     0,   439,   440,     0,   441,     0,   443,     0,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,     0,     0,     0,
       0,   453,     0,     0,     0,   455,     0,   456,   457,   458,
     459,   460,   461,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
       0,   473,   474,     0,   475,   476,   477,   478,     0,     0,
       0,     0,     0,   479,   480,   481,     0,     0,     0,     0,
     483,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,     0,     0,     0,   492,     0,     0,   493,     0,     0,
       0,   495,   496,   497,     0,     0,     0,     0,     0,     0,
     498,     0,     0,   499,     0,     0,     0,   500,   501,   502,
     503,   504,   505,   506,     0,     0,  -327,     0,     0,     0,
     507,     0,     0,   509,     0,   511,     0,   142,   512,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,  4760,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,  1048,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   643,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,   139,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,   142,   512,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,  1213,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
       0,     0,   346,   347,     0,     0,   348,   349,   350,   351,
       0,     0,     0,   352,   353,     0,     0,     0,   354,     0,
     355,   356,   357,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,     0,   367,     0,   368,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   388,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
       0,     0,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   414,     0,     0,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,     0,     0,   454,   455,     0,   456,   457,   458,
     459,   460,   461,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
       0,   473,   474,     0,   475,   476,   477,   478,     0,     0,
       0,     0,     0,   479,   480,   481,     0,     0,     0,   482,
     483,   484,   485,     0,   486,   487,     0,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   495,   496,   497,     0,     0,     0,     0,     0,     0,
     498,     0,     0,   499,     0,     0,     0,   500,   501,   502,
     503,   504,   505,   506,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,   142,   512,   143,
     144,   145,   146,   147,   148,  2200,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,   142,   512,   143,   144,   145,   146,   147,   148,
    2898,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
       0,     0,   346,   347,     0,     0,   348,   349,   350,   351,
       0,     0,     0,   352,   353,     0,     0,     0,   354,     0,
     355,   356,   357,     0,   358,   359,   360,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,     0,   364,
     365,   366,     0,     0,   367,     0,   368,     0,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,     0,     0,
     379,   380,   381,     0,   382,     0,   383,   384,   385,   386,
     387,     0,   388,   389,   390,     0,     0,   391,     0,     0,
       0,   392,   393,   394,   395,   396,     0,     0,   397,   398,
     399,   400,   401,     0,   402,   403,     0,   404,   405,   406,
       0,     0,   407,     0,   408,     0,   409,   410,     0,   411,
     412,     0,   413,     0,   414,     0,     0,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,     0,
     427,   428,     0,     0,     0,   429,   430,   431,   432,     0,
       0,     0,   433,     0,     0,     0,   434,     0,   435,   436,
     437,   438,   439,   440,     0,   441,   442,   443,   444,   445,
     446,     0,     0,     0,     0,     0,     0,   447,   448,     0,
     449,     0,     0,   450,     0,     0,   451,   452,     0,     0,
       0,   453,     0,     0,   454,   455,     0,   456,   457,   458,
     459,   460,   461,     0,     0,   462,   463,   464,   465,     0,
     466,   467,     0,   468,     0,   469,   470,   471,   472,     0,
       0,   473,   474,     0,   475,   476,   477,   478,     0,     0,
       0,     0,     0,   479,   480,   481,     0,     0,     0,   482,
     483,   484,   485,     0,   486,   487,     0,   488,   489,     0,
     490,   491,     0,     0,   492,     0,     0,   493,     0,   494,
       0,   495,   496,   497,     0,     0,     0,     0,     0,     0,
     498,     0,     0,   499,     0,     0,     0,   500,   501,   502,
     503,   504,   505,   506,     0,     0,     0,     0,     0,     0,
     507,   508,     0,   509,   510,   511,     0,   142,   512,   143,
     144,   145,   146,   147,   148,  3265,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,     0,     0,   346,   347,     0,
       0,   348,   349,   350,   351,     0,     0,     0,   352,   353,
       0,     0,     0,   354,     0,   355,   356,   357,     0,   358,
     359,   360,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,     0,   364,   365,   366,     0,     0,   367,
       0,   368,     0,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,   379,   380,   381,     0,   382,
       0,   383,   384,   385,   386,   387,     0,   388,   389,   390,
       0,     0,   391,     0,     0,     0,   392,   393,   394,   395,
     396,     0,     0,   397,   398,   399,   400,   401,     0,   402,
     403,     0,   404,   405,   406,     0,     0,   407,     0,   408,
       0,   409,   410,     0,   411,   412,     0,   413,     0,   414,
       0,     0,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,     0,   427,   428,     0,     0,     0,
     429,   430,   431,   432,     0,     0,     0,   433,     0,     0,
       0,   434,     0,   435,   436,   437,   438,   439,   440,     0,
     441,   442,   443,   444,   445,   446,     0,     0,     0,     0,
       0,     0,   447,   448,     0,   449,     0,     0,   450,     0,
       0,   451,   452,     0,     0,     0,   453,     0,     0,   454,
     455,     0,   456,   457,   458,   459,   460,   461,     0,     0,
     462,   463,   464,   465,     0,   466,   467,     0,   468,     0,
     469,   470,   471,   472,     0,     0,   473,   474,     0,   475,
     476,   477,   478,     0,     0,     0,     0,     0,   479,   480,
     481,     0,     0,     0,   482,   483,   484,   485,     0,   486,
     487,     0,   488,   489,     0,   490,   491,     0,     0,   492,
       0,     0,   493,     0,   494,     0,   495,   496,   497,     0,
       0,     0,     0,     0,     0,   498,     0,     0,   499,     0,
       0,     0,   500,   501,   502,   503,   504,   505,   506,     0,
       0,     0,     0,     0,     0,   507,   508,     0,   509,   510,
     511,     0,     0,   512,     0,     0,     0,     0,     0,   142,
    3635,   143,   144,   145,   146,   147,   148,   840,   841,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,   842,     0,
     207,     0,   208,     0,   843,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
     844,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,   845,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   846,   240,   241,
     242,   847,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   848,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,   849,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,   850,   279,     0,   280,     0,     0,     0,
     851,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
     852,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   853,   384,   385,   386,   854,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,   855,     0,   397,   398,   399,   400,   401,
       0,   856,   403,     0,   404,   405,   406,     0,     0,   857,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,   858,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,   859,   860,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   861,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,   862,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,   863,   494,   864,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   917,   144,   145,   146,
     147,   148,   918,   841,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,   842,     0,   207,     0,   208,     0,   843,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,   844,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,   845,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   846,   240,   241,   242,   847,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   848,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
     849,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,   850,   279,
       0,   280,     0,     0,     0,   851,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   643,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,   852,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   853,   384,
     385,   386,   919,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,   855,     0,
     397,   398,   399,   400,   401,     0,   856,   403,     0,   404,
     405,   406,     0,     0,   857,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,   858,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,   859,   860,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   861,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,   862,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
     863,   494,   864,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,  2551,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,  2552,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,  2553,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2554,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,  1096,  1097,     0,
     352,   353,     0,     0,  2555,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
    4747,   585,  4748,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
    2556,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,  1666,     0,
       0,  3480,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,  1667,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
    2982,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
    2983,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,  2984,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,  2985,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,  1666,     0,     0,  4287,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,  1667,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,  2982,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2983,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,  2984,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
    2985,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,  1666,     0,
       0,  4542,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,  1667,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
    2982,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
    2983,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,  2984,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,  2985,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1423,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  1424,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
    1425,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,  1426,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,  1048,   843,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   643,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1437,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  1438,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,  1018,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
    1019,  1020,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,  1021,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  1997,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,  1998,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
     753,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,  1999,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
    2000,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
    1997,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,  1998,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,  2000,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1423,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  1424,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
    1997,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,  1998,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,   753,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,  4007,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,  2000,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,   843,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,  1048,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   643,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,  1460,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,  2461,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   643,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1423,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   643,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   643,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,   139,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,  2894,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,  4659,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,  4660,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,   585,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,  1114,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,   943,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
    1967,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,  2123,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,   943,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,  3092,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,   139,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,  3396,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,  3404,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,  3428,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
    4318,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,   352,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
       0,   364,   365,   366,     0,     0,   367,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
       0,     0,   379,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,   403,     0,   404,
     405,   406,     0,     0,   407,     0,   408,     0,   409,   410,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,     0,   427,   428,     0,     0,     0,   429,   430,   431,
     432,     0,     0,     0,   433,     0,     0,     0,   434,     0,
     435,   436,   437,   438,   439,   440,     0,   441,   442,   443,
     444,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,   452,
       0,     0,     0,   453,     0,     0,   454,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,   482,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,   490,   491,     0,     0,   492,     0,     0,   493,
       0,   494,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,   508,     0,   509,   510,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,  1883,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,  1884,   350,   351,     0,     0,     0,
     352,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,     0,   364,   365,   366,     0,
       0,   367,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,   379,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,   403,     0,   404,   405,   406,     0,     0,   407,
       0,   408,     0,   409,   410,     0,   411,   412,     0,   413,
       0,   414,     0,     0,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,     0,   427,   428,     0,
       0,     0,   429,   430,   431,   432,     0,     0,     0,   433,
       0,     0,     0,   434,     0,   435,   436,   437,   438,   439,
     440,     0,   441,   442,   443,   444,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,   452,     0,     0,     0,   453,     0,
       0,   454,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,   482,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,   490,   491,     0,
       0,   492,     0,     0,   493,     0,   494,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,     0,     0,     0,     0,   507,   508,     0,
     509,   510,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,  -342,  -342,   229,     0,  -342,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4145,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4146,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
    -363,     0,   229,     0,  -363,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4147,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4148,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4149,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4150,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
       0,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,     0,
       0,     0,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,     0,     0,   404,     0,   406,  -327,     0,   407,
       0,     0,     0,   409,     0,     0,   411,   412,     0,   413,
    4152,   414,     0,     0,   415,     0,   417,   418,   419,   420,
     421,   422,   423,     0,   425,   426,     0,   427,     0,     0,
       0,     0,   429,   430,   431,     0,     0,     0,     0,   433,
       0,     0,     0,     0,     0,     0,   436,     0,     0,   439,
     440,     0,   441,     0,   443,     0,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,     0,     0,     0,     0,   453,     0,
       0,     0,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,     0,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,     0,     0,
       0,   492,     0,     0,   493,     0,     0,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,  -363,     0,  -327,     0,     0,     0,   507,     0,     0,
     509,     0,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,  -360,     0,   229,     0,  -360,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,  -360,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4145,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4146,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  4527,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4147,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4148,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4149,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4150,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
       0,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,     0,
       0,     0,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,     0,     0,   404,     0,   406,  -327,     0,   407,
       0,     0,     0,   409,     0,     0,   411,   412,     0,   413,
    4152,   414,     0,     0,   415,     0,   417,   418,   419,   420,
     421,   422,   423,     0,   425,   426,     0,   427,     0,     0,
       0,     0,   429,   430,   431,     0,     0,     0,     0,   433,
       0,     0,     0,     0,     0,     0,   436,     0,     0,   439,
     440,     0,   441,     0,   443,     0,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,     0,     0,     0,     0,   453,     0,
       0,     0,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,     0,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,     0,     0,
       0,   492,     0,     0,   493,     0,     0,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,  -327,     0,     0,     0,   507,     0,     0,
     509,     0,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,  -365,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4145,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4146,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  4664,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4147,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4148,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4149,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4150,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
       0,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,     0,
       0,     0,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,     0,     0,   404,     0,   406,  -327,     0,   407,
       0,     0,     0,   409,     0,     0,   411,   412,     0,   413,
    4152,   414,     0,     0,   415,     0,   417,   418,   419,   420,
     421,   422,   423,     0,   425,   426,     0,   427,     0,     0,
       0,     0,   429,   430,   431,     0,     0,     0,     0,   433,
       0,     0,     0,     0,     0,     0,   436,     0,     0,   439,
     440,     0,   441,     0,   443,     0,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,     0,     0,     0,     0,   453,     0,
       0,     0,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,     0,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,     0,     0,
       0,   492,     0,     0,   493,     0,     0,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,  -327,     0,     0,     0,   507,     0,     0,
     509,     0,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,  4717,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4145,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4146,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  -346,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4147,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4148,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4149,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4150,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
       0,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,     0,
       0,     0,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,     0,     0,   404,     0,   406,  -327,     0,   407,
       0,     0,     0,   409,     0,     0,   411,   412,     0,   413,
    4152,   414,     0,     0,   415,     0,   417,   418,   419,   420,
     421,   422,   423,     0,   425,   426,     0,   427,     0,     0,
       0,     0,   429,   430,   431,     0,     0,     0,     0,   433,
       0,     0,     0,     0,     0,     0,   436,     0,     0,   439,
     440,     0,   441,     0,   443,     0,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,     0,     0,     0,     0,   453,     0,
       0,     0,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,     0,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,     0,     0,
       0,   492,     0,     0,   493,     0,     0,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,  -327,     0,     0,     0,   507,     0,     0,
     509,     0,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,  -372,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,  4145,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,  4146,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,     0,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,  4147,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,  4148,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,  4149,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
    4150,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,  -327,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,  4151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,  -327,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,  4152,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,  -327,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,   142,
     512,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4145,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4146,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,     0,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4147,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4148,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4149,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4150,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,     0,     0,   346,
     347,     0,     0,   348,   349,   350,   351,     0,     0,     0,
       0,   353,     0,     0,     0,   354,     0,   355,   356,   357,
       0,   358,   359,   360,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,     0,
       0,     0,     0,   368,     0,   369,   370,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,   380,   381,
       0,   382,     0,   383,   384,   385,   386,   387,     0,   388,
     389,   390,     0,     0,   391,     0,     0,     0,   392,   393,
     394,   395,   396,     0,     0,   397,   398,   399,   400,   401,
       0,   402,     0,     0,   404,     0,   406,  -327,     0,   407,
       0,     0,     0,   409,     0,     0,   411,   412,     0,   413,
    4152,   414,     0,     0,   415,     0,   417,   418,   419,   420,
     421,   422,   423,     0,   425,   426,     0,   427,     0,     0,
       0,     0,   429,   430,   431,     0,     0,     0,     0,   433,
       0,     0,     0,     0,     0,     0,   436,     0,     0,   439,
     440,     0,   441,     0,   443,     0,   445,   446,     0,     0,
       0,     0,     0,     0,   447,   448,     0,   449,     0,     0,
     450,     0,     0,   451,     0,     0,     0,     0,   453,     0,
       0,     0,   455,     0,   456,   457,   458,   459,   460,   461,
       0,     0,   462,   463,   464,   465,     0,   466,   467,     0,
     468,     0,   469,   470,   471,   472,     0,     0,   473,   474,
       0,   475,   476,   477,   478,     0,     0,     0,     0,     0,
     479,   480,   481,     0,     0,     0,     0,   483,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,     0,     0,
       0,   492,     0,     0,  4530,     0,     0,     0,   495,   496,
     497,     0,     0,     0,     0,     0,     0,   498,     0,     0,
     499,     0,     0,     0,   500,   501,   502,   503,   504,   505,
     506,     0,     0,  -327,     0,     0,     0,   507,     0,     0,
     509,     0,   511,     0,   142,   512,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,   152,   153,   154,   155,   156,   157,   158,
       0,     0,     0,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,     0,
       0,     0,     0,   169,     0,     0,   170,   171,     0,   172,
       0,     0,     0,     0,     0,   176,   177,   178,   179,     0,
     181,   182,     0,   183,   184,     0,     0,     0,     0,     0,
       0,   190,     0,   192,     0,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,     0,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,     0,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,     0,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,     0,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,     0,     0,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,     0,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,     0,   263,
       0,   264,     0,     0,     0,     0,   266,   267,     0,     0,
       0,     0,     0,     0,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,     0,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,     0,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,     0,     0,   346,   347,     0,     0,   348,   349,
     350,   351,     0,     0,     0,     0,   353,     0,     0,     0,
     354,     0,   355,   356,   357,     0,   358,   359,   360,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,     0,     0,     0,     0,   368,     0,
     369,   370,   371,   372,   373,   374,   375,   376,   377,     0,
       0,     0,     0,   380,   381,     0,   382,     0,   383,   384,
     385,   386,   387,     0,   388,   389,   390,     0,     0,   391,
       0,     0,     0,   392,   393,   394,   395,   396,     0,     0,
     397,   398,   399,   400,   401,     0,   402,     0,     0,   404,
       0,   406,     0,     0,   407,     0,     0,     0,   409,     0,
       0,   411,   412,     0,   413,     0,   414,     0,     0,   415,
       0,   417,   418,   419,   420,   421,   422,   423,     0,   425,
     426,     0,   427,     0,     0,     0,     0,   429,   430,   431,
       0,     0,     0,     0,   433,     0,     0,     0,     0,     0,
       0,   436,     0,     0,   439,   440,     0,   441,     0,   443,
       0,   445,   446,     0,     0,     0,     0,     0,     0,   447,
     448,     0,   449,     0,     0,   450,     0,     0,   451,     0,
       0,     0,     0,   453,     0,     0,     0,   455,     0,   456,
     457,   458,   459,   460,   461,     0,     0,   462,   463,   464,
     465,     0,   466,   467,     0,   468,     0,   469,   470,   471,
     472,     0,     0,   473,   474,     0,   475,   476,   477,   478,
       0,     0,     0,     0,     0,   479,   480,   481,     0,     0,
       0,     0,   483,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,     0,     0,     0,   492,     0,     0,   493,
       0,     0,     0,   495,   496,   497,     0,     0,     0,     0,
       0,     0,   498,     0,     0,   499,     0,     0,     0,   500,
     501,   502,   503,   504,   505,   506,     0,     0,     0,     0,
       0,     0,   507,     0,     0,   509,     0,   511,     0,     0,
     512
};

static const yytype_int16 yycheck[] =
{
       6,   669,  1041,   597,  1042,   575,   620,  1188,  1217,   946,
     947,    20,  1595,    19,   926,  1217,  1315,    23,   596,   597,
     957,    30,  1943,  1944,  1630,   128,  1146,    33,    37,  1778,
     525,   639,  2113,     6,    40,   639,   994,    43,  2113,  1118,
     969,  1463,    48,  1361,   736,   832,   542,   543,   544,    55,
     546,  1463,   548,  2395,  1593,   551,  3030,   553,  1626,  1627,
    1164,  1443,  1315,  1342,   834,   994,   540,  1248,  1249,   677,
     967,  1252,  1253,  1254,  1255,  2433,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  2216,  1240,  2544,  2533,  2605,   689,
    3349,     4,  1247,    99,  2666,  2874,  2228,  1155,   995,  2357,
    1282,   559,  1369,  1046,  2562,  2563,   559,  1046,  2787,   600,
    1013,  2939,   603,  2455,    23,   665,   666,   123,  2319,   125,
    2113,   127,   128,   129,  3076,  3081,  2111,  1854,  1928,  2183,
    1474,   901,   590,  2111,  2183,   803,   134,   590,  1573,  2229,
    2571,  3618,  2498,  2503,  3145,  3031,    26,  3231,    20,  2573,
    1494,    20,   125,  2577,   127,  2948,    18,  3546,  1502,  1503,
    2506,    13,    13,  3161,  2588,    36,    49,    20,    32,  2515,
      17,    18,  2717,  2718,  1077,    75,  2600,    20,  2723,     9,
    2725,   132,  1617,   678,   679,   680,    17,    18,    62,    18,
      99,  2094,   792,   793,   794,    17,    18,  1563,  2183,    29,
      38,  3169,    22,   118,   804,  2183,    36,  1942,  3658,    22,
     116,   162,    22,   132,  2672,  2673,    21,  1036,  1037,    13,
     673,  3391,  2998,    36,    17,    18,    36,    20,    17,    18,
     132,    38,    53,  3009,   166,    17,    18,    50,  2681,   182,
      50,    61,    62,   162,   166,  2170,  2562,  2563,    61,    62,
    3478,    61,    62,  4249,   136,  2566,    91,  1076,   996,   276,
     162,    70,    68,    60,   244,   210,  3695,   386,  3006,   276,
      17,    18,    26,   253,  4081,   217,    17,    18,  4379,   202,
     378,    13,    83,   200,   152,   150,   277,   400,   380,   404,
      45,   132,   260,   162,   166,   279,    84,   166,    17,    18,
     162,   235,    54,  2199,    83,   375,    89,   137,  3436,   465,
     431,    17,    18,    65,   235,   235,  2720,    17,    18,  2313,
     456,    17,    18,   166,   239,  4096,   257,   149,   671,    83,
      17,    18,   137,   403,    72,   448,   418,     9,   283,   277,
     836,   190,   199,   371,  3733,  3734,  2861,  2703,  3737,  2705,
      17,    18,   213,    20,    83,  3614,  2672,  2673,   156,    13,
    4390,   134,   242,  3813,   246,    17,    18,  3756,   814,   197,
     277,   534,   136,   294,  3763,    13,   166,   830,  2085,   218,
     595,   364,   445,   221,   222,   182,   553,  4383,   630,   186,
     557,  1573,   173,   162,   630,   386,    17,    18,   166,   260,
     197,    17,    18,   156,  2307,    66,    17,    18,    17,    18,
     199,   391,   162,   655,   221,   222,  3866,   266,    36,   655,
     156,   202,   294,   528,   263,  3902,   630,   530,   162,   183,
     532,   414,    72,   647,  4449,  1617,  4451,    75,  2103,   654,
     654,   321,  2957,   525,    62,    17,    18,   549,   386,   477,
     223,   655,   231,   616,   233,  2049,   559,   562,   286,   379,
     169,   564,  1154,   526,    17,    18,  1036,  1037,   914,   151,
    2867,    17,    18,  4503,    20,   119,  1168,   197,   122,   386,
    1518,   274,   399,   262,   427,   828,    21,   590,   242,  2480,
     474,  1278,   146,   563,   462,   418,   987,   579,  4269,  1436,
     431,   235,   231,   360,   233,   661,   427,   622,   277,   630,
     195,   294,   195,  3683,  2881,  2882,  2883,   366,   190,   655,
     454,   294,   390,    53,   530,   386,   532,   277,   369,  2885,
    2886,   283,   329,   262,    17,    18,   655,   635,   385,   621,
    4641,   388,   655,   549,  1039,   490,   563,  3340,    17,    18,
     235,  3344,   235,   559,   560,  2451,  3945,  2975,   564,   431,
     566,  2512,   494,   385,  1334,  3954,   388,   321,   510,   661,
     673,  1468,   494,   579,  1471,  1243,    17,    18,  1475,    20,
    1477,  2566,  1964,    65,   590,   502,    87,  4394,  2566,  3978,
     596,   426,   385,  3852,  3983,   388,   385,   258,   353,   388,
     606,  1530,   137,   385,   595,   518,   388,   361,  1505,  1506,
    3289,   628,  2970,   367,  3390,    17,    18,  2520,  3076,   625,
    1563,   628,   431,  1315,  1563,  1806,  3402,  2681,   493,  1928,
     427,  2624,  2681,   639,   557,   641,  1817,  1407,   385,  1820,
     461,   388,  3418,  3419,   385,  4074,  1828,   388,   654,  3387,
    2085,  1251,  3653,   659,   567,   661,  3432,  1131,  1132,   665,
     666,  1431,   467,   606,   670,   671,   385,   673,  1268,   388,
    3128,   677,  3351,  1616,   654,  1928,  2111,  1616,   684,   385,
    2024,   654,   388,  1157,  2995,   385,  3129,   600,   388,   385,
     603,  1165,   388,  1167,   607,  3923,  2681,   503,   385,  1602,
      75,   388,  4698,  2681,   494,  1179,  1180,  1181,   659,   503,
     574,    26,   655,  1187,   196,   621,    17,    18,   385,   601,
     454,   388,  2457,   638,   554,   563,   494,   830,   831,   661,
     736,   574,  1551,   385,  1342,  2170,   388,   620,  1288,   661,
     659,   615,  1800,  4193,   574,   574,  2649,   630,  2183,  2674,
     659,  2654,   582,   653,  3582,   608,   563,   659,  3886,  2662,
    2663,    11,  1500,   635,   385,  2668,  3734,   388,   630,   385,
    3768,   503,   388,   593,   385,   655,   385,   388,   608,   388,
     593,  4231,   653,   593,   538,  3302,  1573,  1907,  3144,  3873,
     659,   797,   639,   799,  2788,   596,   534,   659,  2164,   587,
    1408,   653,   653,   485,  1408,   618,  2702,  3693,   639,    17,
      18,   658,  3128,   385,  1364,  1306,   388,   639,   824,   825,
     826,   827,   828,   829,   830,   831,   164,   833,   834,   627,
    1617,  1381,   385,   839,   655,   388,  4313,   601,  2545,   385,
     653,   646,   388,   946,   576,   948,   639,   182,   951,   952,
     639,   630,   825,  3646,  3647,   584,   829,   639,   655,   628,
     833,   608,   655,  2402,  1472,   968,   655,  3868,  1472,   623,
     876,   661,   654,   655,   627,  4003,    17,    18,   628,   608,
      17,    18,   543,   889,    17,    18,  4014,  2808,    17,    18,
     659,   627,   639,   661,   534,   901,   902,  1388,   639,  2564,
     906,  3298,   385,  2085,   242,   388,    17,    18,   655,   659,
     630,  2505,  2518,   654,   655,   624,   385,  4045,  2909,   388,
     639,  3697,   607,   567,   607,   659,   570,   242,    17,    18,
    2851,   461,   467,   639,   416,   654,   655,  3295,  3305,   639,
     946,   129,   948,   639,   385,   951,   952,   388,   654,   655,
      17,    18,   639,    65,   654,   655,   182,  1452,   654,   655,
    3378,   111,   968,  1533,  1534,  1535,  3412,  3309,   655,    17,
      18,   653,   639,    48,  3334,   657,    17,    18,    34,   480,
     889,   374,   895,   385,    41,  3066,   388,   639,  2170,  1567,
    3535,  3066,  3348,   902,  3340,  2946,  2947,   906,  3344,  3544,
     370,  2183,   654,   655,   192,  2588,   321,  1013,   838,  4398,
    2995,  4400,   367,  1950,    17,    18,  1624,  2995,   639,    17,
      18,   293,    58,   639,  4501,   376,   225,  3881,   639,   367,
     639,  1723,  3416,  1970,   655,  3466,  1042,   129,   654,   655,
    1038,   288,   202,  3467,   655,   420,   655,    17,    18,    17,
      18,    13,   367,    17,    18,   376,   129,   563,    17,    18,
    1066,  2019,    17,    18,  1834,    36,  2488,   639,  2490,  2491,
     485,  1077,  2253,  3066,   987,  3129,   989,  2877,  2490,  2491,
    3129,    73,  3172,   655,   385,   145,   639,   388,    17,    18,
    2019,   325,   427,   639,   378,  2374,  2054,  2824,   294,   485,
     192,   348,   655,   291,   134,  1111,  1112,  1113,  1114,  3012,
    2545,  3014,   376,  2010,   596,  4071,     6,   199,  3021,    53,
      73,  1891,  2201,   239,   133,  2054,  2023,  1230,   376,  2026,
    2027,  2566,  3035,  3537,  3335,   376,   436,    12,   563,  3042,
    3043,    17,    18,   218,  3129,  1915,  1916,  2414,  1154,  4149,
    4150,  3129,  3055,  3056,  3057,  2499,   639,  1066,  3061,  3062,
      18,  1619,  1168,  3222,  1267,   185,  1619,  3226,   418,    59,
     639,   129,   655,  3718,   132,  2330,  3721,   385,   553,   171,
     388,   453,   370,  4135,   146,   130,   655,    17,    18,   376,
    2939,   407,  2066,  2067,  3097,   277,  4455,   253,   639,   291,
     538,   427,  4330,   578,  2652,  1114,  3751,  3752,  3753,  2083,
     105,  1217,   105,  1316,  3759,  4343,   366,  2120,   291,  1819,
     276,  2164,  3767,   538,  1230,  2164,  2100,  2101,   653,  2410,
     257,  2433,  2336,  2337,   192,   431,  1928,   639,   653,  2674,
    4368,   166,   197,   252,   385,   166,  2681,   388,   385,    17,
      18,   388,   385,   655,  1824,   388,   385,   376,   418,   388,
     150,  1267,   655,   221,   294,   566,  1272,   653,   623,  1372,
     330,  2329,   197,   147,   385,   525,   646,   388,   370,    17,
      18,  2339,  1288,    17,    18,   623,  1836,   534,   353,   147,
     590,  2165,  2166,  2167,  2168,   511,   385,   370,  2085,   388,
     129,  2840,    17,    18,   655,   313,   251,  2516,   623,  1315,
    1316,   376,  3716,  3717,  2516,    17,    18,   655,   385,  3723,
     655,   388,  3726,  3727,  3227,  3709,    33,   439,  1334,   579,
     366,   401,  1902,   291,   655,   534,  1342,   385,   639,  3743,
     388,  1347,   313,  1349,   385,   159,  1352,   388,   243,   369,
     243,   635,   199,  3757,  1845,   505,   170,   629,  1364,  3763,
    3764,  3765,  3766,  2545,   563,   260,  1372,   260,  3389,   199,
      26,   621,  3393,  3394,  1974,  1381,  1382,   272,    85,   272,
     606,   633,   385,  2170,   440,   388,  4240,   385,  4242,  4397,
     388,   655,   108,  1306,  3526,   387,  2183,   557,   586,    17,
      18,  1407,  1408,   478,   431,  1411,   253,   655,  4360,  4361,
    4238,   286,   370,  1419,   655,   385,  1422,   385,   388,   653,
     388,   385,  3005,  3006,   388,  1431,   385,    17,    18,   388,
     385,   639,   366,   388,   387,   485,  1442,  1443,   485,   635,
    1353,   485,  3700,  1352,    17,    18,   654,  1453,  1454,  1455,
    1456,  1457,  1458,   160,    17,    18,   385,  1463,   353,   388,
     353,    90,   291,  1469,  1470,   199,  1472,  1570,   655,   343,
    1476,  1929,   529,  1382,   364,  1388,  1929,   534,  4257,   199,
    1453,  1454,  1455,   112,  1457,   343,    17,    18,   433,   331,
     547,  1497,  2674,  4445,   586,   552,   485,  1470,   639,  2681,
     485,  4475,   639,  1476,   407,  2927,   639,    17,    18,   385,
     639,  4190,   388,   586,   655,     9,  1619,    22,   655,   129,
    4092,  4093,   655,   580,   485,  4784,   655,   461,   639,    83,
     250,    36,   563,  4533,  4534,  1448,   655,   403,    32,  2476,
     430,   370,   432,   608,   655,    50,  1552,  1456,  3906,  1458,
     639,  2671,  2831,  2832,  2833,   385,    61,    62,   388,   493,
    2995,   581,  1475,  3011,  1570,  2060,   655,    17,    18,   494,
     384,  2179,   639,   494,   469,  2179,   469,   597,  2877,  1585,
    4097,   199,   192,   653,  1590,  1591,   242,   654,  1497,  3037,
    3038,   639,    24,    66,  4460,   540,  1602,  4463,   639,    17,
      18,   173,  4048,   653,    17,    18,   653,   655,   511,   653,
     657,   221,   133,  1619,   655,    17,    18,   385,  1624,    42,
     388,   231,   653,   233,  2877,  2704,    13,  1633,   586,  1635,
     202,    17,    18,   136,  4642,  4643,   639,  2955,   496,   497,
     653,   639,   557,  1552,   539,   560,   539,   385,   313,  2804,
     388,   385,   655,  2862,   388,   615,   479,   655,   618,  3680,
    2862,    17,    18,  1576,   653,   321,   386,  3799,   653,   639,
     385,   639,  3801,   388,  2444,   639,  1585,  4135,    13,    83,
     639,   291,  1591,   385,   639,   655,   388,   655,   242,    17,
      18,   655,   653,   557,  3129,    12,   655,   563,  2572,   654,
    2637,  2575,  2576,    13,  2578,  4047,   413,  2581,  2582,    13,
     639,  2585,    17,    18,   366,   138,  2590,  1723,  1724,   561,
    4078,  2595,  2596,  2597,  2598,  2599,   655,   244,   435,  2603,
    2604,   252,  2606,  2333,  1837,  3274,   253,  2857,  2612,  2613,
    2614,  2615,   174,   246,  2618,  2619,   588,  2621,   562,    17,
      18,  2225,   242,    17,    18,  4621,  2230,   586,  2545,   146,
     370,   426,    13,   639,   471,   658,  2374,   385,   563,  2243,
     388,  3063,    17,    18,   648,   649,   650,   651,  1784,   655,
       0,   253,   283,    17,    18,   258,   644,   645,   646,   647,
     648,   649,   650,   651,   446,   385,   162,    21,   388,  3091,
     563,   273,   501,  2277,  3387,  2679,   485,   361,   413,   639,
     213,   146,   385,   367,   493,   388,   133,  1060,  1061,   166,
    1826,  1827,   385,   530,   654,   388,  1929,   231,  1834,   233,
    1836,  1837,  3041,  3582,   218,    20,   146,  2445,   503,  3041,
     166,  2445,   146,  1849,  1947,  3990,    17,    18,  1854,   231,
     173,   233,  3981,  1859,   385,  3984,  1862,   388,   262,    17,
      18,   291,  1105,  1869,  1870,   660,  1872,   368,   133,   239,
     485,   639,  2346,   278,   391,   385,   281,   367,   388,   263,
     661,  3784,    18,   437,  3467,  1891,   654,  2674,  1894,   362,
     653,   234,  1898,   263,  2681,   146,    17,    18,    17,    18,
     599,   639,  4360,  4361,  2482,   639,   709,   710,   454,  1915,
    1916,  1917,  1918,   137,   213,   129,   654,   239,  1827,   223,
     105,   143,  1928,  1929,   639,    17,    18,  3830,  1934,  1935,
    1936,   239,  1845,   612,   613,   385,   158,   639,   388,   654,
     370,  1947,   239,   642,    17,    18,  3328,  3129,   234,    17,
      18,   454,   654,    17,    18,   299,   300,   213,  1964,   141,
    1869,  1870,  2874,  1872,  2922,    17,    18,   385,    26,   553,
     388,   315,   385,   557,   653,   388,   586,   162,   192,  1985,
     783,   166,   485,   385,   538,  1894,   388,  4445,   380,  1898,
      17,    18,   250,  2922,   431,    17,    18,   612,   613,   385,
    1913,    49,   388,   653,  4149,  4150,   199,   221,  1917,  1918,
     195,   661,   197,    17,    18,   452,  2953,   647,  3336,  2025,
     604,   639,   613,   428,   654,  1934,  1935,  1936,   213,   385,
      17,    18,   388,   493,   219,  2041,  2933,   591,   653,   584,
     843,   199,  2048,   504,  3148,    18,    17,    18,   538,   639,
     235,   488,  2058,  2059,   527,  2061,  2062,   385,   243,   504,
     388,   294,   115,   608,   654,   250,   639,  1980,   654,   623,
     543,   363,   364,  3177,  3178,   260,   639,   291,  2181,  3861,
     385,   654,   653,   388,  2187,  2058,  2059,   272,   593,  2859,
     661,   654,   277,   127,  3198,   608,  3216,  3299,   601,   443,
     444,   286,   659,  3885,    17,    18,   164,  3399,   639,   614,
     615,   654,   655,  2216,  2120,   557,  2025,   385,  3686,  3687,
     388,   385,   560,   654,   388,  2228,  4029,  4030,  4031,   639,
      17,    18,   661,   623,    17,    18,   602,  4307,  3347,  2048,
     385,  3433,   655,   388,   654,  3347,  3020,  1870,   661,  1872,
     653,   385,  3444,   382,   388,  3447,   370,  2070,   557,  3033,
     525,  4306,  4307,   636,   105,   129,  2079,  2080,   353,   654,
     655,   224,   653,  2179,   147,  2181,   574,  2090,  2091,  2092,
    2093,  2187,  2095,  2096,   242,  2877,    40,  2193,   196,   639,
    2196,   376,    17,    18,    48,   229,   608,   608,   653,    17,
      18,   386,   654,   655,   654,     6,    17,    18,    17,    18,
    2216,  1934,  1935,  1936,   385,   519,   520,   388,   522,  2322,
     524,   639,  2228,  2831,  2832,  2833,   639,   385,   192,   653,
     388,   631,   632,   418,   653,   539,   654,   639,    17,    18,
    2810,   654,   654,   655,   655,  1048,   653,    17,    18,  2352,
     661,   563,   654,   639,   655,   655,  1335,   221,   653,  1338,
      17,    18,  1341,   321,   385,   749,   385,   388,   654,   388,
    4415,    17,    18,  2881,  2882,  2883,   653,  2881,  2882,  2883,
      17,    18,   653,   639,   469,  4430,   653,   771,  4209,  3409,
     654,   655,   653,   385,    17,    18,   388,   538,   654,   333,
     784,   785,   243,   337,   654,   655,    61,    62,   493,   367,
     344,   639,   385,    17,    18,   388,  2322,   385,    73,   260,
     388,   385,  1005,   653,   388,  2799,   654,   291,  1011,  1012,
     661,   272,   653,   385,   639,   653,   388,   653,    36,   392,
     653,  2347,  3129,   178,   129,   136,  2352,   132,   417,   654,
     403,  4521,  4497,   653,   539,  3292,   608,   410,   385,   654,
     655,   388,   653,   385,    62,   653,   388,  3789,  2374,   136,
     343,   639,   586,  3331,   653,   639,  4521,  3789,   653,  3939,
    3940,   385,  3486,  3537,   388,   473,   654,   653,  4533,  4534,
     654,   425,  3952,   653,   639,   654,   655,   383,   385,  3959,
     653,   388,  3331,  2409,  3613,   639,   370,   192,   553,   654,
     595,  3613,   353,   473,   385,   654,   655,   388,   654,   655,
     654,   119,   607,   608,   122,  3985,  3986,  2433,   653,  2532,
    2533,  2437,   130,    12,  3513,   376,   221,   160,  2444,  2445,
     654,  3019,   653,   628,    83,   630,   654,   655,   653,   483,
     148,   653,  2458,   653,  2460,   246,   509,  4602,   653,    13,
    4541,   653,  4186,  4187,   653,  4540,   653,  4612,   639,   654,
     655,   376,   385,   658,   659,   388,  2482,  4060,  4061,   246,
     538,   639,  2488,   654,  2490,  2491,  4656,   653,  4658,  4238,
     653,   115,    17,    18,   554,   574,  3705,   653,   385,   653,
     560,   388,   385,  3705,  2999,   388,   291,   654,   655,   653,
    2516,  4656,  3007,  4658,   566,   653,  3554,  3013,   639,  2525,
     639,  4691,  2528,   496,   497,   164,  2532,  2533,   469,  3025,
     653,  3027,  3028,   654,   235,   654,   115,   653,  4683,  4442,
      20,   654,   655,  3039,   604,  2458,  4691,   639,  4693,   173,
    4695,   604,   653,   251,   133,  2528,   654,   655,  4728,  4729,
     385,   621,   654,   388,  4709,   623,   639,   385,  4713,  3723,
     388,   639,  3726,  3727,   385,   639,   385,   388,   202,   388,
     376,   654,   185,  4728,  4729,   370,   654,   639,   653,  3743,
     654,   625,   146,   655,   173,   654,   655,   655,   539,  4744,
    4745,   511,  4208,   242,  4749,    51,   385,   641,   653,   388,
    4334,  2617,   639,   653,  4338,   385,  3915,   639,   388,   654,
     655,   653,   586,   202,   653,   105,  2632,   654,   385,   654,
     655,   388,   654,   654,   655,   639,  1124,  1125,  1126,   385,
    2646,   653,   388,   653,   613,   614,    62,   616,   385,   618,
     654,   388,   639,  1141,   654,   655,   653,   355,    26,    61,
      62,   211,   385,   454,  3963,   388,   654,   654,   639,   223,
     653,   644,   645,   646,   647,   648,   649,   650,   651,   654,
     655,   385,   162,   654,   388,  1173,   166,   454,  1176,   288,
     654,  2697,  2698,  2699,   485,   654,   655,  3305,   653,   147,
     653,  3305,   653,   119,   654,   655,   122,   653,   287,  1197,
    1198,   653,  3186,  1201,   130,    83,   653,   197,   485,    13,
     654,   655,   361,   654,   655,   653,   639,   653,   367,   653,
    1218,  1219,   148,   213,   654,   655,    81,  2650,  2651,   219,
    2653,   654,  2655,  2656,  2657,  2658,  2659,  2660,  2661,  3327,
      44,  2664,   639,   653,  2667,   653,   639,  2670,   654,   655,
     363,   364,   653,   243,  3238,   653,   369,   654,   318,   319,
     250,   654,   653,   323,   324,   654,   655,   193,   654,   655,
     260,  4505,  4506,   653,    65,  4706,   653,   566,  2697,  2698,
    2699,   653,   272,   653,   418,    20,   164,   277,   437,    51,
      81,   586,    27,   501,    98,   253,   286,   654,   655,   103,
     601,   653,    93,   653,   639,   183,   654,   655,  2824,   653,
    2826,   639,   654,   655,  2830,  2831,  2832,  2833,   639,   654,
     639,   147,   653,  2839,   601,   251,   654,   243,   653,   418,
     654,   655,   655,   654,   383,   654,   654,   655,    73,   653,
     129,   196,  2858,  2859,   260,   653,  2862,  4038,    83,   653,
     639,   653,   653,   376,  4785,   199,   272,   654,   655,   639,
     376,  2877,   570,   353,   242,  2881,  2882,  2883,    27,   654,
     655,   479,   639,   595,   654,   129,   653,   648,  2894,   654,
     655,   654,   655,   639,   239,   343,   376,   654,   493,   538,
     504,   599,   639,   654,   655,   661,   386,   132,   654,   654,
     655,    83,   491,   192,   661,   196,   639,   654,   263,  3415,
     201,  2927,   654,   655,    73,    97,   172,  3030,   654,   655,
    2839,   147,   653,   557,    83,   639,   352,   253,   418,   355,
     277,   129,   221,   197,   132,  3523,   525,   534,   192,   654,
     655,   511,   591,   321,   534,   579,   156,   157,   239,   553,
    4080,   255,   288,  2969,  2970,   519,   520,   521,   522,   523,
     524,  3787,  3788,   163,    34,   554,   147,   221,   581,   197,
     205,  2894,   263,   132,   623,   539,   654,   655,    92,   469,
     654,   655,  2998,   361,   597,   654,   655,   621,  4207,   367,
     655,  3010,  3008,  3009,   192,  4207,   231,  3016,   233,  3015,
     655,    83,   291,   493,   654,   655,   655,   433,   377,    91,
     654,   655,   147,   549,  3030,  3031,   654,   343,   654,   655,
    3036,  3040,   162,   221,   132,  3041,   330,  3046,   263,  3976,
     147,   118,   621,  3052,  3053,  3051,   118,   291,   496,   497,
      17,    18,   654,   655,   660,   129,     6,  3063,   132,   539,
    2969,   654,   655,   469,  3070,  3071,   654,   655,  3831,  3832,
    3076,   416,    81,  1205,  1206,  4113,  3082,  3311,  3312,   653,
    3086,  4119,   231,   117,   233,  3091,    60,   147,  3267,  3268,
    4210,   370,   164,   265,  3664,  3911,     4,   484,  3592,  3593,
     394,   621,   253,   291,  3017,  3018,   655,   400,    65,  3082,
      58,   446,   178,   129,   263,   595,   132,   118,   192,   400,
     232,  3127,   232,   655,    81,   655,   370,   343,   608,    73,
     661,   627,  3045,   539,    13,   416,    93,  3143,   363,   364,
     654,   146,  3051,   654,   369,    10,   655,   221,   628,   661,
     630,   376,  1640,   654,   570,   654,   123,   124,   125,   126,
     127,   654,  4282,  3076,   661,   653,   661,   239,   276,   341,
     538,   376,   343,   655,   654,   655,   192,   164,   658,   659,
     496,   497,   370,   599,   655,   660,   288,   196,   288,   288,
      51,   416,   288,   253,   366,   288,   644,   645,   646,   647,
     648,   649,   650,   651,   288,   221,   655,   166,   182,   553,
     129,  3314,   186,   655,   363,   364,   276,   291,   343,   513,
     369,  3134,   653,   197,   230,   283,  3232,   376,   655,   655,
     239,   401,   574,   514,  3240,   655,   343,  1725,   517,   196,
     400,  1729,  4362,   574,   201,  4454,   655,   129,   320,   166,
     197,   655,  4454,    73,   263,   623,   550,   429,   655,   226,
     227,   228,   229,   655,   489,  1753,   338,   416,  4084,  4085,
     534,  4087,  4088,   192,  3280,   291,   253,   648,   254,   551,
     496,   497,   239,   343,   187,  3855,   197,   655,   655,   361,
     405,  3869,   172,  3299,  3300,   534,   370,  3303,   297,  3305,
     299,   300,   221,   363,   364,   508,   263,   586,  3314,  3412,
     192,   142,   376,   404,  3320,   596,   315,   655,   654,   602,
       7,  3327,  3328,   655,   634,   496,   497,  3240,   644,   645,
     646,   647,   648,   649,   650,   651,   607,   655,   115,   221,
     489,  3347,   586,  4217,  4218,  4257,   199,  4221,  4222,  4223,
    4224,   654,   654,   525,   370,   329,  3362,   654,   654,   654,
     648,  4399,   654,  3369,   654,   654,   333,   199,   335,   336,
     337,   596,   291,   655,  3383,  4556,   653,   344,   647,  3993,
     440,   654,   595,   494,  3390,   655,   654,   654,   654,   496,
     497,   400,  4329,  3399,   654,   654,  3402,   655,   586,   654,
     123,   124,   125,   126,   127,   654,  3412,   416,   653,   291,
    3416,  4348,  3418,  3419,   651,   653,   563,    38,   385,   653,
    3333,   388,   654,  3526,   201,   655,  3432,  3433,   644,   645,
     646,   647,   648,   649,   650,   651,   496,   497,  3444,   563,
      83,  3447,   563,   574,   443,   444,   628,   596,  4042,  4323,
     241,   370,   512,   427,    97,   653,   655,   545,   425,   416,
    3369,   105,   239,    12,   653,  3471,   538,    13,  3474,   211,
     199,   655,   653,  3479,   645,   646,   647,   648,   649,   650,
     651,   661,   554,   661,  4358,  4359,   653,   274,   370,  4670,
     655,   655,   661,  4367,   199,  3501,   654,   140,   661,   176,
    3413,   122,   474,   226,   227,   228,   229,   655,   129,  3422,
     287,   426,   586,   600,   493,   482,   483,   655,   655,   197,
    3526,   646,   647,   648,   649,   650,   651,  3630,    49,  4567,
    4568,   202,  4570,   351,   525,    86,   525,    88,   484,   646,
     647,   648,   649,   650,   651,   525,   197,   525,   449,  4758,
     525,   166,   653,   166,   166,   166,  4758,   514,   166,   166,
     166,   166,  4771,   166,   185,  3474,   166,  4776,   166,  4771,
     586,   192,  4781,   166,  4776,   166,   166,   166,  3491,  4781,
     166,   132,   166,   166,   644,   645,   646,   647,   648,   649,
     650,   651,   166,   166,  4632,   166,  4634,  4635,   655,   243,
     221,   222,  3608,   154,    14,   287,    16,  3613,   376,   376,
     333,   388,   335,   336,   337,   376,   260,   661,   608,   654,
     160,   344,   265,    33,  3630,   654,   249,    37,   272,   249,
     661,   654,  4226,   654,   654,   654,   654,   654,    38,   596,
     191,    51,    52,   654,   166,   655,     7,   655,   661,    59,
     574,   574,   574,   655,    64,    65,   563,   661,   625,   283,
      89,    49,   635,   166,   574,   653,   166,   586,  3674,   653,
     291,   653,   639,   640,   641,    85,   383,   563,   250,   199,
     199,   199,   653,   199,   431,  4723,   563,  3693,   257,   655,
     176,  3697,   260,   470,   104,   370,  3799,   260,   341,  3705,
     389,  4740,   425,  3709,   586,  3711,   334,   118,   653,   353,
     118,  4379,    81,   261,   491,   400,  4286,   400,   128,   400,
     363,   364,   122,   366,   574,    14,   136,   137,   138,   129,
     142,   554,   376,   354,   261,   400,   142,   514,   554,   149,
     150,   400,    49,   400,   365,   400,   402,   400,   369,   370,
     400,   653,   162,   574,   653,   653,   382,  3670,   213,   482,
     483,   563,   653,   648,   661,   166,   167,   177,  3871,   653,
    3776,   251,   251,  3779,   655,   648,   654,   554,   654,    57,
    3786,  3787,  3788,  3789,   194,   185,   429,   654,   654,    67,
     653,   655,   192,  3799,   654,    57,   431,   654,   654,   209,
     654,   211,   203,   661,    82,    67,   216,   383,   653,   376,
     220,  4381,   235,   654,   215,   104,    94,    95,    96,   596,
      82,   221,   222,   400,   278,   469,   655,   604,   655,   654,
     601,   661,    94,    95,    96,   113,   246,   199,   248,   253,
     654,   654,  4779,   394,   431,   166,   655,   136,   655,   465,
     653,   113,   414,  4415,   264,   256,   115,   260,  3961,   400,
     661,   150,   166,   260,   263,  3871,   376,   268,  4430,   263,
     376,    83,   282,    20,   654,  3881,   286,   655,  4456,   653,
     653,   386,   525,    49,   173,   654,   190,   438,   177,   654,
     487,   291,  3898,   630,   295,   539,   654,   274,   181,   203,
     189,   467,   625,   286,   153,  3911,   211,   270,   654,   654,
    3916,   215,   655,   213,   173,  3924,  3922,   640,   641,   260,
     485,   260,   211,   655,  3930,   495,   376,   376,   654,   511,
     654,   263,   653,   655,   263,  4497,   655,   630,   655,   653,
     149,   654,   563,   202,    87,  4048,   567,   503,   238,   570,
     239,   654,   653,   653,   354,  3961,   357,   246,   653,   277,
     581,    36,   266,   654,   268,   586,   654,    36,   589,   369,
     370,   381,   370,  4641,  3887,   654,    62,   251,   654,   265,
     239,  3987,   654,   340,   654,   654,   654,   540,   398,   426,
     400,   295,   654,    18,   655,   250,   383,   286,   630,   653,
      49,   661,   654,   413,   219,   340,   655,   655,   653,   608,
     511,   480,   608,  3922,   424,   654,    20,   655,   654,   653,
     132,   132,   557,   653,   661,   646,   647,   412,   287,    36,
     370,  4037,  4626,   655,  4040,   180,   446,   340,   143,   449,
    4602,   451,  4048,   263,   454,   654,   563,   457,   458,  3962,
    4612,   563,   563,   557,   332,   612,   360,   317,   468,  4629,
     654,   471,   654,  4069,  4070,  4733,   608,   655,   653,   479,
     332,   349,   608,   653,   653,   485,    15,   601,  4084,  4085,
     618,  4087,  4088,   493,   618,   132,   263,   349,   498,   499,
     500,    20,  4760,   653,   653,   653,   263,   369,   653,   529,
     630,   653,   176,   474,   464,   655,    63,   654,   383,   654,
     601,   415,   544,   465,   653,   250,   653,   365,   376,   613,
     530,  4683,   653,   161,   653,   627,    33,   537,  4037,  4135,
     419,  4693,   370,  4695,   662,   176,   689,   565,  4708,   654,
    4146,   694,   142,   142,   653,  4151,   164,  4709,   418,    75,
     439,  4713,   197,   197,   413,   654,   653,   627,   447,   418,
     199,  4070,    33,   563,    65,   383,   455,   567,    65,   654,
     570,   397,   582,   655,  4180,  4181,   654,  4183,   731,   653,
     545,   581,  4744,  4745,   594,   463,   586,  4749,   598,   589,
     279,   601,   439,   654,   654,   748,   485,   607,   250,   160,
     659,  4207,   383,   481,   383,   653,    49,    49,   159,   498,
     499,   470,  4782,    49,    49,    49,   140,   653,   653,   481,
     376,   149,  4135,     5,   376,   627,   160,   637,   234,   293,
     286,   662,   491,   643,  4240,   659,  4242,   131,    12,   792,
     793,   794,   795,   653,   653,    49,   646,   647,    49,    49,
     155,   804,   601,   136,   659,   474,    55,   160,   654,   548,
    4363,   263,   655,   541,   654,   476,  4272,   566,   216,   655,
     659,   655,   232,   654,   654,    55,   655,   453,   197,   541,
     197,   559,    27,   197,    29,    49,   566,   629,   132,   235,
     579,   370,   198,  4299,   653,   554,   493,   559,  4156,   655,
    2669,   560,  2359,  3784,  3505,   989,  2561,  1037,  3896,  4382,
    4251,  4583,   601,  1057,   603,  4584,    61,    62,  3894,    64,
     579,  3898,  4068,  4760,  4721,    48,  1927,   598,    73,  2824,
    1859,  3990,   236,  3990,  3990,  3990,  4730,  3990,    83,   892,
    3990,  3990,  3990,  3990,  3990,   604,    91,  4353,  4599,  4408,
    4599,  3990,  4534,  3990,  3990,  4434,  4433,  4363,  1579,  1828,
    1101,  4255,   621,  4369,  4077,  2113,  3442,  2853,  2631,  3607,
    3280,  2858,  4475,   118,  1369,  4353,  4038,  4458,  3610,  4670,
    4564,  4626,  4226,  1616,   630,  3903,  2624,   132,  3355,  3070,
     135,  3674,   296,  3073,   298,   299,   300,   301,   302,  3916,
     304,   305,   306,   307,   308,   309,   310,   311,   312,  4322,
     314,   315,   316,  2632,  3923,  4647,  4286,  3169,  3734,   164,
    4111,  3768,  3972,  4456,  3961,  2532,  2777,  3223,  3226,  3218,
    4388,    11,    11,  4505,  4440,  4506,  2189,  4325,  4334,  4445,
    4338,  2695,  3390,  4356,  4357,  4119,  4183,  2631,  4454,  3066,
    1513,  1070,  2502,  1017,  3928,  2120,  2428,  3692,  4440,  4562,
    1612,  1917,  1591,  2839,  2402,  3275,  2315,  2449,  3992,  4475,
     619,   938,  4284,  1941,  3240,  2224,  2220,  2810,  1168,  2517,
    2511,  3338,  4245,  2314,  4063,  4578,   231,  3501,   233,  4579,
    2340,  3705,  1530,  2927,   239,  1141,  3062,  3882,  4708,  3871,
    2454,  2193,   247,  1352,  2396,  2432,  3613,  1382,  1041,  1041,
    3294,  3293,  3347,   609,  4454,  1041,  1041,   262,  2020,  1633,
     685,  1461,  2496,  2021,   597,   597,  1848,  3711,  3278,  4668,
    1083,  4703,  4445,  4482,  1389,  4574,  4776,  4781,   781,   443,
     444,  3963,  3299,  2479,  3327,  1419,   596,  2472,  3328,  1967,
    1781,  2465,  2471,  4466,  4467,  1898,  4562,   830,  1409,   596,
     590,  1344,  4027,   918,  2444,  1624,  4033,  1120,  1121,  2826,
     591,   925,  4578,  4579,   627,   320,  1129,  1130,  1131,  1132,
    1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,    -1,    -1,
    1037,   627,   627,   338,  1037,  1037,  1149,  1150,  4604,  1152,
    1153,    -1,    -1,    -1,  1157,  4611,    -1,  1160,  1161,  1162,
    1163,    -1,  1165,  1166,  1167,    -1,    -1,    -1,    -1,    -1,
      -1,  1174,  1175,    -1,  1177,  1178,  1179,  1180,  1181,    -1,
      36,  1184,  1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,
    1193,  1194,    -1,  1196,    -1,    -1,  1199,  1200,   393,    -1,
     395,  1204,    -1,    -1,    -1,  1208,  1209,  1210,   403,    -1,
      -1,    -1,    -1,    69,  4767,    -1,    -1,  1220,  1221,  1222,
      -1,    -1,    -1,    -1,    -1,    -1,  1229,    -1,    -1,    -1,
      -1,    -1,    -1,  1236,  1237,  1238,  4692,  1240,    -1,    -1,
      -1,  4697,    -1,    -1,  1247,  1248,  1249,    -1,  1251,  1252,
    1253,  1254,  1255,    -1,  1257,  1258,  1259,  1260,  1261,  1262,
    1263,  1264,    -1,    -1,    -1,  1268,  1269,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4733,    -1,    -1,
     475,  4644,    -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,    -1,    12,
      -1,    14,  4758,    16,  4760,    -1,    -1,    -1,   164,    -1,
      -1,  4767,   168,    -1,    27,  4771,    29,    -1,    -1,    -1,
    4776,    -1,    -1,    -1,    -1,  4781,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   531,   532,   533,    -1,
      -1,    -1,    -1,   538,    -1,    -1,    59,    -1,   204,    -1,
      -1,    64,    65,  1356,    -1,    -1,    -1,    -1,    71,   554,
      -1,    36,    -1,   558,    -1,    -1,    -1,    -1,    -1,   225,
      83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,   577,    -1,   240,    -1,    -1,    -1,   101,    -1,
      -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,
     595,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1419,    -1,    -1,   132,
      -1,    -1,   135,    -1,    -1,    -1,  1429,    -1,    -1,    -1,
     143,   144,   288,    -1,    -1,    -1,    -1,   150,    -1,    -1,
      -1,    -1,  1445,    -1,    -1,   158,  1449,    -1,    -1,   162,
      -1,   164,    -1,    -1,    -1,    -1,    -1,   313,    -1,   694,
     655,    -1,   175,    -1,   139,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   195,    -1,    -1,    -1,    -1,    -1,    -1,   164,
      -1,    -1,    -1,   168,    -1,    -1,   731,    -1,    -1,    -1,
      -1,  1504,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   748,    -1,    -1,    -1,    -1,   231,    -1,
     233,    -1,    -1,    -1,   237,    -1,   239,    -1,    -1,   204,
      -1,    -1,    -1,    -1,   247,    -1,    -1,    -1,    -1,    -1,
      27,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,   262,
     225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     795,   417,    -1,    -1,    -1,   240,    -1,    -1,    -1,    -1,
     426,    -1,    -1,   286,    61,    62,    -1,    64,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   441,    73,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      -1,    -1,    -1,   459,    91,    -1,    -1,   320,    -1,    -1,
      -1,    -1,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,   342,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,   313,    -1,
      -1,    -1,    -1,  1646,    -1,   132,    -1,   503,   135,    -1,
     506,    -1,    -1,    -1,    -1,    -1,    -1,   892,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      -1,    -1,    -1,   386,    -1,    -1,    -1,   164,   534,    -1,
     393,    -1,   395,    -1,    -1,    -1,    -1,   400,    -1,    -1,
     403,    -1,    -1,    -1,    -1,    -1,    -1,   553,    -1,    -1,
     556,   557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   448,   449,   450,   451,    -1,
      -1,    -1,   417,    -1,   231,    -1,   233,    -1,    -1,   605,
      -1,   426,   239,    -1,    -1,    -1,  1759,  1760,  1761,    -1,
     247,    -1,   475,    -1,    -1,    -1,   441,    -1,    -1,    -1,
      -1,  1774,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   459,    -1,    -1,    -1,    -1,   276,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1800,    -1,    -1,
      -1,    -1,    -1,  1806,    -1,    -1,  1809,    -1,  1811,    -1,
      -1,    -1,    -1,    -1,  1817,    -1,  1819,  1820,   531,   532,
     533,    -1,    -1,    -1,    -1,   538,    -1,    -1,   503,    -1,
      -1,   506,    -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   554,    -1,    -1,    -1,   558,    -1,    -1,  1083,    -1,
      -1,   338,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,    -1,    -1,    -1,   577,    -1,    -1,    -1,    -1,   582,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   556,   595,    -1,    -1,  1120,  1121,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1129,  1130,    -1,    -1,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,   393,    -1,   395,  1912,
      -1,    -1,    -1,    -1,  1149,  1150,   403,  1152,  1153,    -1,
      -1,    -1,    -1,    -1,    -1,  1160,  1161,  1162,  1163,    -1,
     605,  1166,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1174,
    1175,    -1,  1177,  1178,    -1,    -1,   659,    -1,    -1,  1184,
    1185,  1186,    -1,    -1,  1189,  1190,  1191,  1192,  1193,  1194,
      -1,  1196,  1965,    -1,  1199,  1200,    -1,    -1,    -1,  1204,
      -1,  1974,    -1,  1208,  1209,  1210,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1220,  1221,  1222,   475,    -1,
      -1,    -1,    -1,    -1,  1229,    -1,    -1,    -1,    -1,    -1,
      -1,  1236,  1237,  1238,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1269,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   531,   532,   533,    -1,    -1,    -1,
      -1,   538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   554,    -1,    -1,
      -1,   558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
    2113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1356,    -1,    -1,    -1,    27,    -1,    29,    -1,    -1,
      -1,    -1,  2135,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      62,    -1,    64,    -1,    -1,    -1,   653,    -1,    -1,    -1,
      -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,  1419,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    -1,  1429,    -1,    -1,    -1,    -1,  2202,
      -1,    -1,    -1,  2206,    -1,    -1,    -1,    -1,  2211,  2212,
    1445,    -1,    -1,    -1,  1449,    -1,   118,  2220,    -1,  2222,
      -1,  2224,  2225,  2226,  2227,    -1,    -1,  2230,    -1,    -1,
     132,    -1,    -1,   135,    -1,    -1,    -1,  2240,    -1,  2242,
    2243,    -1,  2245,  2246,  2247,  2248,    -1,  2250,    -1,    -1,
    2253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2262,
      -1,    -1,   164,    -1,    -1,    -1,  2269,    -1,  2271,  1504,
    2273,  2274,    -1,  2276,  2277,    -1,    -1,    -1,  2281,  2282,
    2283,    -1,    -1,    -1,  2287,  2288,  2289,    -1,  2291,    -1,
    2293,    -1,  2295,    -1,  2297,    -1,  2299,    -1,    -1,    -1,
      -1,  2304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2323,    25,    -1,    -1,    -1,    -1,    -1,  2330,    -1,   231,
    2333,   233,    36,    37,    -1,    -1,  2339,   239,    -1,  2342,
      -1,    -1,    -1,  2346,    -1,   247,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    62,    -1,
     262,    -1,    -1,    -1,    -1,    69,    -1,    -1,    -1,    -1,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   100,    -1,   102,    -1,
     104,    -1,    -1,    -1,    -1,    -1,    -1,  2410,    -1,    -1,
      -1,  1646,   116,    -1,    -1,    -1,    -1,     6,   320,    -1,
      -1,    -1,    -1,    12,    -1,    14,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,    -1,   338,    -1,    27,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   163,
     164,    -1,    -1,    -1,    -1,   169,    -1,    -1,   172,    -1,
      59,    -1,    -1,    -1,    -1,    64,    -1,  2480,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   393,    -1,   395,    83,    -1,   200,    -1,   202,    -1,
      -1,   403,    91,    -1,    -1,    -1,   210,    -1,   212,    -1,
      -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1759,  1760,  1761,    -1,  2531,   118,
      -1,    -1,    -1,    -1,   238,   239,   240,    -1,    -1,    -1,
      -1,  2544,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   143,    -1,    -1,   261,    -1,  2562,
    2563,   150,    -1,    -1,    -1,  1800,    -1,    -1,    -1,   158,
      -1,    -1,    -1,   475,  1809,   164,  1811,    -1,    -1,   283,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,   313,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2624,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   531,
     532,   533,    -1,    -1,    -1,    -1,   538,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,
     239,    -1,   554,    -1,    -1,    -1,   558,    -1,   247,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2672,
    2673,    -1,    -1,   262,    -1,   577,   380,  1912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,   286,    -1,    -1,
      -1,    -1,   406,    -1,    -1,  2708,    -1,    -1,    -1,  2712,
      -1,    -1,    -1,   417,   418,    -1,    -1,   421,   422,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1965,   320,    -1,    -1,    -1,    -1,  2739,  2740,   442,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,
      -1,    -1,    -1,   342,    -1,    -1,  2759,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2768,    -1,  2770,    -1,  2772,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   490,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2799,   386,    -1,   503,
      -1,  2804,    -1,    -1,   393,    -1,   395,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     534,    -1,  2835,    -1,   538,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   556,   557,    -1,    -1,    -1,    -1,    -1,    -1,
     449,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   475,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2135,   605,    -1,    -1,    -1,    -1,  2909,    -1,    -1,    -1,
      -1,    -1,   616,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     624,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   531,   532,   533,    -1,    -1,    -1,    -1,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2960,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   554,    -1,  2202,    -1,   558,
      -1,  2206,  2975,    -1,    -1,    -1,  2211,  2212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2220,    -1,  2222,   577,  2224,
      -1,  2226,  2227,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2240,   595,  2242,    -1,    -1,
    2245,  2246,  2247,  2248,    -1,  2250,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2262,    14,    -1,
      16,    -1,    -1,    -1,  2269,    -1,  2271,    -1,  2273,  2274,
      -1,  2276,    -1,    -1,    -1,    -1,  2281,  2282,  2283,    -1,
      -1,    37,  2287,  2288,  2289,    -1,  2291,    -1,  2293,    -1,
    2295,    -1,  2297,  3066,  2299,    51,    52,    -1,    27,  2304,
      29,    -1,    -1,    59,    -1,    -1,  3079,  3080,    64,    65,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2323,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,
      -1,    -1,    -1,    -1,  2339,    64,    -1,  2342,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   104,    -1,
      -1,    -1,    -1,    -1,    83,  3128,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   128,    -1,    -1,    -1,    -1,    -1,  3151,    -1,
     136,   137,   138,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,   135,    -1,    -1,    -1,
    3183,  3184,    -1,  3186,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   177,  3195,    -1,    -1,    -1,    -1,  3200,    -1,    -1,
    3203,    -1,  3205,  3206,    -1,   164,    -1,    -1,   194,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   209,    -1,   211,    -1,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,  3238,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2480,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     246,    -1,   248,    -1,    -1,    -1,  3269,    -1,    -1,    -1,
      -1,    -1,   231,    -1,   233,    -1,    -1,    -1,   264,    -1,
     239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,
    3293,    -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,    -1,
     286,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3349,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3378,    -1,    -1,    -1,   338,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   398,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,
      -1,    -1,    -1,    -1,   393,    -1,   395,    -1,   424,    -1,
      -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     446,    -1,    -1,   449,    -1,   451,    -1,    -1,   454,    -1,
      -1,   457,   458,  2708,    -1,    -1,    -1,  2712,    -1,    -1,
      -1,    -1,   468,    -1,    -1,   471,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   479,    -1,    -1,    -1,    -1,    -1,   485,
      -1,    -1,    -1,    -1,  2739,  2740,    -1,   493,    -1,    -1,
      -1,    -1,   498,   499,   500,    -1,   475,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2759,    -1,    -1,    -1,    -1,    -1,
      35,    36,    -1,  2768,    -1,  2770,    41,  2772,    43,    -1,
      45,    46,    -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,
      -1,   537,    -1,    -1,    -1,    -1,    -1,    62,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   531,   532,   533,    -1,    -1,    -1,    -1,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   554,   582,    -1,    -1,   558,
    2835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   594,    -1,
      -1,  3614,   598,    -1,   119,   601,    -1,   122,   577,    -1,
      -1,   607,    -1,    -1,    -1,   130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,    -1,    -1,
      -1,    -1,    -1,   148,    -1,    -1,    -1,  3650,    -1,    -1,
      -1,   637,    -1,    -1,    -1,  3658,    -1,   643,    -1,    -1,
     165,    -1,    -1,    -1,    -1,    -1,    -1,   653,    -1,    -1,
      -1,    -1,    -1,    -1,  2909,    -1,  3679,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   206,   207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2960,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3761,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   280,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   289,   290,    -1,   292,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3813,    -1,    -1,    -1,  3817,    -1,    -1,    -1,    -1,    -1,
      -1,   326,   327,   328,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     345,   346,   347,    -1,  3079,  3080,    -1,   352,    -1,  3852,
     355,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3866,    -1,    -1,    -1,   372,   373,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3903,    -1,    -1,   408,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3151,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   433,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3183,  3184,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3195,    -1,    -1,    -1,    -1,  3200,    -1,    -1,  3203,  3972,
    3205,  3206,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   489,    -1,    -1,  3990,   493,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3269,  4038,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4046,    -1,    -1,    -1,    -1,    -1,  4052,
      -1,  4054,    -1,    -1,    -1,    -1,    -1,    -1,  3293,   564,
      -1,    -1,   567,    -1,    -1,   570,   571,   572,   573,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   614,
     615,    -1,    -1,    -1,  3349,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   641,    -1,    -1,    -1,
    4143,    -1,    -1,    -1,    -1,    -1,  4149,  4150,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4182,
      -1,    -1,    -1,  4186,  4187,    -1,    -1,    -1,    -1,    -1,
    4193,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4292,
      -1,  4294,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4304,    -1,  4306,  4307,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4334,    -1,    -1,    -1,  4338,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3614,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4390,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4413,    -1,  4415,    -1,    -1,  3650,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3658,    -1,    -1,    -1,  4430,  4431,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3679,  4448,    -1,    -1,    -1,    -1,
      -1,    -1,  4455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4497,    -1,    -1,    -1,    -1,    -1,
    4503,    -1,  4505,  4506,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4520,  4521,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4533,  4534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4556,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3813,    -1,
      -1,    -1,  3817,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4602,
      -1,    -1,    -1,    -1,    -1,    -1,  4609,    -1,    -1,  4612,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3852,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4649,    -1,    -1,    -1,
      -1,    -1,    -1,  4656,    -1,  4658,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4670,    -1,    -1,
    4673,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4691,    -1,
    4693,    -1,  4695,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4709,    -1,    -1,    -1,
    4713,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4728,  4729,    -1,    -1,    -1,
      -1,  4734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4744,  4745,    -1,    -1,    -1,  4749,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4046,    -1,    -1,    -1,    -1,    -1,  4052,    -1,  4054,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4143,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4193,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4292,    -1,  4294,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4304,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4413,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4431,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4520,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4609,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4649,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,  4673,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    47,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,  4734,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,  4784,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,   269,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,   575,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    13,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,   376,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
     178,    -1,   180,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,   199,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,   214,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,   234,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,
     248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,   339,   340,    -1,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,   453,   454,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,   609,   610,   611,   612,   613,    -1,    -1,   616,   617,
      -1,   619,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,
      -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,
      -1,    -1,   660,   661,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,   199,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,    -1,    -1,   359,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,   370,
     371,    -1,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,   393,   394,    -1,   396,   397,    -1,   399,    -1,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,    -1,   417,    -1,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,
     441,   442,   443,   444,   445,    -1,   447,   448,    -1,   450,
     451,   452,   453,   454,   455,    -1,   457,    -1,   459,   460,
      -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,
     501,   502,   503,   504,   505,   506,    -1,   508,   509,   510,
     511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,
     521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
      -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,    -1,   556,    -1,   558,   559,   560,
     561,    -1,   563,   564,   565,    -1,   567,   568,   569,   570,
      -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,
      -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,   610,
     611,   612,   613,    -1,    -1,   616,   617,    -1,   619,   620,
     621,   622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,
      -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,
     641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,
     661,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,   178,    -1,   180,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,   191,   192,    -1,
     194,    -1,    -1,    -1,   198,   199,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
     214,    -1,   216,   217,   218,    -1,   220,   221,   222,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
     234,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,   339,   340,    -1,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,    -1,    -1,   359,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,   369,   370,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,   396,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,   453,
     454,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,   535,   536,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,   563,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,   609,   610,   611,   612,   613,
      -1,    -1,   616,   617,    -1,   619,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,
      -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,    -1,   354,   355,   356,
      -1,    -1,   359,   360,   361,   362,   363,   364,   365,   366,
     367,    -1,   369,   370,   371,    -1,   373,   374,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,
     397,    -1,   399,    -1,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,    -1,
     417,    -1,   419,   420,   421,   422,   423,    -1,   425,   426,
     427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,    -1,    -1,   441,   442,   443,   444,   445,    -1,
     447,   448,    -1,   450,   451,   452,   453,   454,   455,    -1,
     457,    -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,
     467,    -1,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,    -1,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,
      -1,    -1,   499,    -1,   501,   502,   503,   504,   505,   506,
      -1,   508,   509,   510,   511,   512,   513,    -1,    -1,    -1,
      -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,
     537,   538,    -1,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,    -1,   556,
      -1,   558,   559,   560,   561,    -1,   563,   564,   565,    -1,
     567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,
     577,   578,    -1,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,    -1,   593,   594,    -1,    -1,
     597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,
      -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,   616,
     617,    -1,   619,   620,   621,   622,   623,   624,   625,   626,
      -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,
     637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,
     647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,
     657,    -1,    -1,   660,   661,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    36,    37,    38,    39,
      40,    41,    42,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    55,    56,    57,    58,    -1,
      60,    61,    62,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,   101,   102,   103,    -1,    -1,   106,   107,   108,   109,
     110,   111,    -1,   113,   114,   115,    -1,   117,   118,   119,
     120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,   178,    -1,
     180,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,
     220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,   234,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,   339,
     340,    -1,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,    -1,    -1,   359,
     360,   361,   362,   363,   364,   365,   366,   367,    -1,   369,
     370,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,   453,   454,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
     580,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,
     610,   611,   612,   613,    -1,    -1,   616,   617,    -1,   619,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,
      -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,
     660,   661,     5,    -1,     7,     8,     9,    10,    11,    12,
      13,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
      -1,   354,   355,   356,    -1,    -1,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,   370,   371,    -1,
     373,   374,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,
     393,   394,    -1,   396,   397,    -1,   399,    -1,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,    -1,   417,    -1,   419,   420,   421,   422,
     423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,    -1,    -1,   441,   442,
     443,   444,   445,    -1,   447,   448,    -1,   450,   451,   452,
     453,   454,   455,    -1,   457,    -1,   459,   460,    -1,   462,
     463,    -1,   465,    -1,   467,    -1,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,    -1,
     483,   484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,
      -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,
     503,   504,   505,   506,    -1,   508,   509,   510,   511,   512,
     513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,
      -1,   534,   535,   536,   537,   538,    -1,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,    -1,   556,    -1,   558,   559,   560,   561,    -1,
     563,   564,   565,    -1,   567,   568,   569,   570,    -1,    -1,
      -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,    -1,
     593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,
      -1,   604,   605,   606,    -1,    -1,   609,   610,   611,   612,
     613,    -1,    -1,   616,   617,    -1,   619,   620,   621,   622,
     623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,
     633,   634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,
      -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,
     653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,
      56,    57,    58,    -1,    60,    61,    62,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,   101,   102,   103,    -1,    -1,
     106,   107,   108,   109,   110,   111,    -1,   113,   114,   115,
      -1,   117,   118,   119,   120,   121,   122,    -1,    -1,    -1,
      -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,   178,    -1,   180,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,   191,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,   214,    -1,
     216,   217,   218,    -1,   220,   221,   222,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,   234,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
     246,   247,   248,   249,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,   339,   340,    -1,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,   354,   355,
     356,    -1,    -1,   359,   360,   361,   362,   363,   364,   365,
     366,   367,    -1,   369,   370,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
     396,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,   453,   454,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,
     536,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
     546,   547,   548,   549,   550,   551,   552,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,   563,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,   580,   581,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,
     616,   617,    -1,   619,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,
     646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,
     656,   657,    -1,    -1,   660,   661,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,    -1,   354,   355,   356,    -1,    -1,
     359,   360,   361,   362,   363,   364,   365,   366,   367,    -1,
     369,   370,   371,    -1,   373,   374,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,    -1,
     399,    -1,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,    -1,   417,    -1,
     419,   420,   421,   422,   423,    -1,   425,   426,   427,    -1,
      -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
      -1,    -1,   441,   442,   443,   444,   445,    -1,   447,   448,
      -1,   450,   451,   452,   453,   454,   455,    -1,   457,    -1,
     459,   460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,
     489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,
     499,    -1,   501,   502,   503,   504,   505,   506,    -1,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
      -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,    -1,    -1,    -1,   534,   535,   536,   537,   538,
      -1,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,    -1,   556,    -1,   558,
     559,   560,   561,    -1,   563,   564,   565,    -1,   567,   568,
     569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,
      -1,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,
      -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,
     609,   610,   611,   612,   613,    -1,    -1,   616,   617,    -1,
     619,   620,   621,   622,   623,   624,   625,   626,    -1,    -1,
      -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,
      -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,    -1,
      -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,    -1,
      -1,   660,   661,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,    -1,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    55,    56,    57,    58,    -1,    60,    61,
      62,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,   101,
     102,   103,    -1,    -1,   106,   107,   108,   109,   110,   111,
      -1,   113,   114,   115,    -1,   117,   118,   119,   120,   121,
     122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,
     132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,   178,    -1,   180,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,   191,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,   214,    -1,   216,   217,   218,    -1,   220,   221,
     222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,   234,    -1,   236,   237,   238,    -1,   240,    -1,
     242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
     272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,   339,   340,    -1,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,   354,   355,   356,    -1,    -1,   359,   360,   361,
     362,   363,   364,   365,   366,   367,    -1,   369,   370,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,   396,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,   411,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,   453,   454,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,   535,   536,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,   546,   547,   548,   549,   550,   551,
     552,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,   563,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,   581,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,   609,   610,   611,
     612,   613,    -1,    -1,   616,   617,    -1,   619,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,    -1,
     652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,   661,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,    -1,   354,
     355,   356,    -1,    -1,   359,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,   370,   371,    -1,   373,   374,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,
      -1,   396,   397,    -1,   399,    -1,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,    -1,   417,    -1,   419,   420,   421,   422,   423,    -1,
     425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,    -1,    -1,   441,   442,   443,   444,
     445,    -1,   447,   448,    -1,   450,   451,   452,   453,   454,
     455,    -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,
     465,    -1,   467,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,    -1,   483,   484,
      -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,
     495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,
     505,   506,    -1,   508,   509,   510,   511,   512,   513,    -1,
      -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,
     535,   536,   537,   538,    -1,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
      -1,   556,    -1,   558,   559,   560,   561,    -1,   563,   564,
     565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,
      -1,   576,   577,   578,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,    -1,   593,   594,
      -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,
     605,   606,    -1,    -1,   609,   610,   611,   612,   613,    -1,
      -1,   616,   617,    -1,   619,   620,   621,   622,   623,   624,
     625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,
      -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,
      -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,    -1,
      -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    36,    37,
      38,    39,    40,    41,    42,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    55,    56,    57,
      58,    -1,    60,    61,    62,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,   101,   102,   103,    -1,    -1,   106,   107,
     108,   109,   110,   111,    -1,   113,   114,   115,    -1,   117,
     118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,
     128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
     178,    -1,   180,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,   214,    -1,   216,   217,
     218,    -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,   234,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,
     248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,   339,   340,    -1,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,   354,   355,   356,    -1,
      -1,   359,   360,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,   370,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,   411,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,   453,   454,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,   469,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,   546,   547,
     548,   549,   550,   551,   552,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,   563,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,   580,   581,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,   609,   610,   611,   612,   613,    -1,    -1,   616,   617,
      -1,   619,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,   647,
      -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,   657,
      -1,    -1,   660,   661,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,    -1,   354,   355,   356,    -1,    -1,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,   370,
     371,    -1,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   392,   393,   394,    -1,   396,   397,    -1,   399,    -1,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,    -1,   417,    -1,   419,   420,
     421,   422,   423,    -1,   425,   426,   427,    -1,    -1,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,
     441,   442,   443,   444,   445,    -1,   447,   448,    -1,   450,
     451,   452,   453,   454,   455,    -1,   457,    -1,   459,   460,
      -1,   462,   463,    -1,   465,    -1,   467,    -1,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,
     491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,
     501,   502,   503,   504,   505,   506,    -1,   508,   509,   510,
     511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,   520,
     521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
      -1,    -1,    -1,   534,   535,   536,   537,   538,    -1,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,    -1,   556,    -1,   558,   559,   560,
     561,    -1,   563,   564,   565,    -1,   567,   568,   569,   570,
      -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,
      -1,   602,    -1,   604,   605,   606,    -1,    -1,   609,   610,
     611,   612,   613,    -1,    -1,   616,   617,    -1,   619,   620,
     621,   622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,
      -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,
     641,    -1,    -1,    -1,    -1,   646,   647,    -1,    -1,    -1,
      -1,   652,   653,    -1,    -1,   656,   657,    -1,    -1,   660,
     661,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    55,    56,    57,    58,    -1,    60,    61,    62,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,   101,   102,   103,
      -1,    -1,   106,   107,   108,   109,   110,   111,    -1,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,    -1,
      -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,   178,    -1,   180,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,   191,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
     214,    -1,   216,   217,   218,    -1,   220,   221,   222,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
     234,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,   339,   340,    -1,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
     354,   355,   356,    -1,    -1,   359,   360,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,   370,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,   396,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,   453,
     454,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,   469,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,   535,   536,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,   546,   547,   548,   549,   550,   551,   552,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,   563,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,   580,   581,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,   609,   610,   611,   612,   613,
      -1,    -1,   616,   617,    -1,   619,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,    -1,   646,   647,    -1,    -1,    -1,    -1,   652,   653,
      -1,    -1,   656,   657,    -1,    -1,   660,   661,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,    -1,   354,   355,   356,
      -1,    -1,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,   370,   371,    -1,   373,   374,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,   396,
     397,    -1,   399,    -1,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,    -1,
     417,    -1,   419,   420,   421,   422,   423,    -1,   425,   426,
     427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,    -1,    -1,   441,   442,   443,   444,   445,    -1,
     447,   448,    -1,   450,   451,   452,   453,   454,   455,    -1,
     457,    -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,
     467,    -1,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,    -1,   483,   484,    -1,    -1,
      -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,
      -1,    -1,   499,    -1,   501,   502,   503,   504,   505,   506,
      -1,   508,   509,   510,   511,   512,   513,    -1,    -1,    -1,
      -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,    -1,    -1,    -1,   534,   535,   536,
     537,   538,    -1,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,    -1,   556,
      -1,   558,   559,   560,   561,    -1,   563,   564,   565,    -1,
     567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,
     577,   578,    -1,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,    -1,   593,   594,    -1,    -1,
     597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,
      -1,    -1,   609,   610,   611,   612,   613,    -1,    -1,   616,
     617,    -1,   619,   620,   621,   622,   623,   624,   625,   626,
      -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,
     637,   638,    -1,    -1,   641,    -1,    -1,    -1,    -1,   646,
     647,    -1,    -1,    -1,    -1,   652,   653,    -1,    -1,   656,
     657,    -1,    -1,   660,   661,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    38,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,   129,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,   185,   186,   187,    -1,   189,
     190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,   369,
     370,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,    -1,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,   563,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,   581,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
     660,   661,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    93,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,   201,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,   239,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,   263,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,   276,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,    -1,    -1,   355,   356,    -1,    -1,   359,
     360,   361,   362,    -1,    -1,    -1,   366,   367,    -1,    -1,
      -1,   371,    -1,   373,   374,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   392,   393,   394,    -1,    -1,   397,    -1,   399,
      -1,   401,   402,   403,   404,   405,   406,   407,   408,   409,
     410,    -1,    -1,   413,   414,   415,    -1,   417,    -1,   419,
     420,   421,   422,   423,    -1,   425,   426,   427,    -1,    -1,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,    -1,
      -1,   441,   442,   443,   444,   445,    -1,   447,   448,    -1,
     450,   451,   452,    -1,    -1,   455,    -1,   457,    -1,   459,
     460,    -1,   462,   463,    -1,   465,    -1,   467,    -1,    -1,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,    -1,   483,   484,   485,    -1,    -1,   488,   489,
     490,   491,    -1,    -1,    -1,   495,    -1,    -1,    -1,   499,
      -1,   501,   502,   503,   504,   505,   506,    -1,   508,   509,
     510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,
     520,   521,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,    -1,    -1,    -1,   534,    -1,    -1,   537,   538,    -1,
     540,   541,   542,   543,   544,   545,    -1,    -1,   548,   549,
     550,   551,    -1,   553,   554,    -1,   556,    -1,   558,   559,
     560,   561,    -1,    -1,   564,   565,    -1,   567,   568,   569,
     570,    -1,    -1,    -1,    -1,    -1,   576,   577,   578,    -1,
      -1,    -1,   582,   583,   584,   585,    -1,   587,   588,    -1,
     590,   591,    -1,   593,   594,    -1,    -1,   597,    -1,    -1,
     600,    -1,   602,    -1,   604,   605,   606,    -1,    -1,    -1,
      -1,    -1,    -1,   613,    -1,    -1,   616,    -1,    -1,    -1,
     620,   621,   622,   623,   624,   625,   626,    -1,    -1,    -1,
      -1,    -1,    -1,   633,   634,    -1,   636,   637,   638,    -1,
      -1,   641,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,   661,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    93,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,   183,    -1,    -1,   186,   187,    -1,   189,   190,   191,
      -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,   201,
     202,    -1,   204,   205,   206,   207,   208,   209,   210,    -1,
     212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,
     232,   233,    -1,    -1,   236,   237,   238,   239,   240,    -1,
     242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,    -1,
     252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,
     262,   263,    -1,   265,   266,   267,    -1,    -1,   270,    -1,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,
      -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
      -1,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
      -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,
     332,   333,   334,    -1,    -1,   337,   338,    -1,   340,    -1,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,   351,
     352,    -1,    -1,   355,   356,    -1,    -1,   359,   360,   361,
     362,    -1,    -1,    -1,   366,   367,    -1,    -1,    -1,   371,
      -1,   373,   374,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,   399,    -1,   401,
     402,   403,   404,   405,   406,   407,   408,   409,   410,    -1,
      -1,   413,   414,   415,    -1,   417,    -1,   419,   420,   421,
     422,   423,    -1,   425,   426,   427,    -1,    -1,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,    -1,    -1,   441,
     442,   443,   444,   445,    -1,   447,   448,    -1,   450,   451,
     452,    -1,    -1,   455,    -1,   457,    -1,   459,   460,    -1,
     462,   463,    -1,   465,    -1,   467,    -1,    -1,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
      -1,   483,   484,    -1,    -1,    -1,   488,   489,   490,   491,
      -1,    -1,    -1,   495,    -1,    -1,    -1,   499,    -1,   501,
     502,   503,   504,   505,   506,    -1,   508,   509,   510,   511,
     512,   513,   514,    -1,    -1,    -1,    -1,    -1,   520,   521,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,    -1,
      -1,    -1,   534,    -1,    -1,   537,   538,    -1,   540,   541,
     542,   543,   544,   545,    -1,    -1,   548,   549,   550,   551,
      -1,   553,   554,    -1,   556,    -1,   558,   559,   560,   561,
      -1,    -1,   564,   565,    -1,   567,   568,   569,   570,    -1,
      -1,    -1,    -1,    -1,   576,   577,   578,    -1,    -1,    -1,
     582,   583,   584,   585,    -1,   587,   588,    -1,   590,   591,
      -1,   593,   594,    -1,    -1,   597,    -1,    -1,   600,    -1,
     602,    -1,   604,   605,   606,    -1,    -1,    -1,    -1,    -1,
      -1,   613,    -1,    -1,   616,    -1,    -1,    -1,   620,   621,
     622,   623,   624,   625,   626,    -1,    -1,    -1,    -1,    -1,
      -1,   633,   634,    -1,   636,   637,   638,    -1,    -1,   641,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,   661,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,   485,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
     654,    -1,    -1,    19,    -1,    -1,    22,   661,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,    -1,    -1,   359,   360,   361,   362,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,    -1,    -1,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,    -1,
      -1,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
      -1,    -1,   548,   549,   550,   551,    -1,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,    -1,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,    -1,    -1,   582,   583,   584,   585,
      -1,   587,   588,    -1,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,    -1,    -1,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,   654,    15,
      -1,    -1,    -1,    19,   660,   661,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,    -1,    -1,   359,   360,   361,   362,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,    -1,    -1,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,    -1,
      -1,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
      -1,    -1,   548,   549,   550,   551,    -1,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,    -1,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,    -1,    -1,   582,   583,   584,   585,
      -1,   587,   588,    -1,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,    -1,    -1,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,   653,    -1,    15,
      -1,    -1,    -1,    19,    -1,   661,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,    -1,    -1,   355,
     356,    -1,    -1,   359,   360,   361,   362,    -1,    -1,    -1,
     366,   367,    -1,    -1,    -1,   371,    -1,   373,   374,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,   399,    -1,   401,   402,   403,   404,   405,
     406,   407,   408,   409,   410,    -1,    -1,   413,   414,   415,
      -1,   417,    -1,   419,   420,   421,   422,   423,    -1,   425,
     426,   427,    -1,    -1,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,    -1,    -1,   441,   442,   443,   444,   445,
      -1,   447,   448,    -1,   450,   451,   452,    -1,    -1,   455,
      -1,   457,    -1,   459,   460,    -1,   462,   463,    -1,   465,
      -1,   467,    -1,    -1,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,    -1,   483,   484,    -1,
      -1,    -1,   488,   489,   490,   491,    -1,    -1,    -1,   495,
      -1,    -1,    -1,   499,    -1,   501,   502,   503,   504,   505,
     506,    -1,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,    -1,   520,   521,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,    -1,    -1,    -1,   534,    -1,
      -1,   537,   538,    -1,   540,   541,   542,   543,   544,   545,
      -1,    -1,   548,   549,   550,   551,    -1,   553,   554,    -1,
     556,    -1,   558,   559,   560,   561,    -1,    -1,   564,   565,
      -1,   567,   568,   569,   570,    -1,    -1,    -1,    -1,    -1,
     576,   577,   578,    -1,    -1,    -1,   582,   583,   584,   585,
      -1,   587,   588,    -1,   590,   591,    -1,   593,   594,    -1,
      -1,   597,    -1,    -1,   600,    -1,   602,    -1,   604,   605,
     606,    -1,    -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,
     616,    -1,    -1,    -1,   620,   621,   622,   623,   624,   625,
     626,    -1,    -1,    -1,    -1,    -1,    -1,   633,   634,    -1,
     636,   637,   638,    -1,    -1,   641,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,    -1,    22,   661,    24,    25,    26,    27,
      28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    61,    -1,    63,    64,    -1,    66,    67,
      68,    69,    70,    71,    72,    -1,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    97,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,   176,   177,
      -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,   187,
      -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,   204,   205,   206,   207,
     208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,   217,
     218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,   230,   231,   232,   233,    -1,    -1,   236,   237,
     238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,   247,
     248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,   257,
     258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,
      -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,    -1,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,    -1,   323,   324,    -1,    -1,    -1,
      -1,   329,   330,   331,   332,   333,   334,    -1,    -1,   337,
     338,    -1,   340,    -1,   342,    -1,   344,   345,   346,   347,
     348,   349,   350,   351,   352,    -1,    -1,   355,   356,    -1,
      -1,   359,   360,   361,   362,    -1,    -1,    -1,   366,   367,
      -1,    -1,    -1,   371,    -1,   373,   374,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,   399,    -1,   401,   402,   403,   404,   405,   406,   407,
     408,   409,   410,    -1,    -1,   413,   414,   415,    -1,   417,
      -1,   419,   420,   421,   422,   423,    -1,   425,   426,   427,
      -1,    -1,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,    -1,    -1,   441,   442,   443,   444,   445,    -1,   447,
     448,    -1,   450,   451,   452,    -1,    -1,   455,    -1,   457,
      -1,   459,   460,    -1,   462,   463,    -1,   465,    -1,   467,
      -1,    -1,   470,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,    -1,   483,   484,    -1,    -1,    -1,
     488,   489,   490,   491,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   499,    -1,   501,   502,   503,   504,   505,   506,    -1,
     508,   509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,
      -1,    -1,   520,   521,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,    -1,    -1,    -1,   534,    -1,    -1,   537,
     538,    -1,   540,   541,   542,   543,   544,   545,    -1,    -1,
     548,   549,   550,   551,    -1,   553,   554,    -1,   556,    -1,
     558,   559,   560,   561,    -1,    -1,   564,   565,    -1,   567,
     568,   569,   570,    -1,    -1,    -1,    -1,    -1,   576,   577,
     578,    -1,    -1,    -1,   582,   583,   584,   585,    -1,   587,
     588,    -1,   590,   591,    -1,   593,   594,    -1,    -1,   597,
      -1,    -1,   600,    -1,   602,    -1,   604,   605,   606,    -1,
      -1,    -1,    -1,    -1,    -1,   613,    -1,    -1,   616,    -1,
      -1,    -1,   620,   621,   622,   623,   624,   625,   626,    -1,
      -1,    -1,    -1,    -1,    -1,   633,   634,    -1,   636,   637,
     638,    -1,    -1,   641,    -1,    -1,    -1,    -1,    -1,    -1,
     648,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,   661,    -1,    19,    -1,    -1,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,    -1,
      -1,   355,   356,    -1,    -1,   359,   360,   361,   362,    -1,
      -1,    -1,   366,   367,    -1,    -1,    -1,   371,    -1,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,   399,    -1,   401,   402,   403,
     404,   405,   406,   407,   408,   409,   410,    -1,    -1,   413,
     414,   415,    -1,   417,    -1,   419,   420,   421,   422,   423,
      -1,   425,   426,   427,    -1,    -1,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,    -1,    -1,   441,   442,   443,
     444,   445,    -1,   447,   448,    -1,   450,   451,   452,    -1,
      -1,   455,    -1,   457,    -1,   459,   460,    -1,   462,   463,
      -1,   465,    -1,   467,    -1,    -1,   470,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,    -1,   483,
     484,    -1,    -1,    -1,   488,   489,   490,   491,    -1,    -1,
      -1,   495,    -1,    -1,    -1,   499,    -1,   501,   502,   503,
     504,   505,   506,    -1,   508,   509,   510,   511,   512,   513,
      -1,    -1,    -1,    -1,    -1,    -1,   520,   521,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,    -1,    -1,    -1,
     534,    -1,    -1,   537,   538,    -1,   540,   541,   542,   543,
     544,   545,    -1,    -1,   548,   549,   550,   551,    -1,   553,
     554,    -1,   556,    -1,   558,   559,   560,   561,    -1,    -1,
     564,   565,    -1,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,   576,   577,   578,    -1,    -1,    -1,   582,   583,
     584,   585,    -1,   587,   588,    -1,   590,   591,    -1,   593,
     594,    -1,    -1,   597,    -1,    -1,   600,    -1,   602,    -1,
     604,   605,   606,    -1,    -1,    -1,    -1,    -1,    -1,   613,
      -1,    -1,   616,    -1,    -1,    -1,   620,   621,   622,   623,
     624,   625,   626,    -1,    -1,    -1,    -1,    -1,    -1,   633,
     634,    -1,   636,   637,   638,    -1,    -1,   641,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,   653,
      -1,    15,    -1,    -1,    -1,    19,    -1,   661,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    -1,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323