# How to contribute to MapServer

Contributions to the MapServer project are most welcome, and can take many forms such as detailed bug reports, documentation, 
tests, features, and patches.  Note that all contributions are managed by the MapServer [Project Steering Committee](https://mapserver.org/psc.html).

## Bugs and Help

GitHub issues should only be created to log bugs. For general help and support the MapServer [mailing lists](http://mapserver.org/community/lists.html)
should be used. If you are unsure if you have discovered a bug, or may need help with configuring MapServer please 
post to the [mapserver-users list](http://lists.osgeo.org/mailman/listinfo/mapserver-users). There is also 
a [MapServer FAQ](http://www.mapserver.org/faq.html) which may have a solution to your problem. 

If you have discovered a bug, please refer to the [Bug Submission page](http://mapserver.org/development/bugs.html) for
guidelines on creating an issue on GitHub. Please also search the existing issues to see if the bug has already been reported, and
add any further details to the existing issue. 

For professional support please see the [MapServer Service Providers page](http://mapserver.org/community/service_providers.html). 

## Development

A separate [mapserver-dev mailing list](http://lists.osgeo.org/mailman/listinfo/mapserver-dev) is available for developers
working on the MapServer code. 

Details on using GitHub can be found on the [MapServer GitHub page](http://mapserver.org/development/git.html)  

Additional developer notes can be found in the [MapServer wiki](https://github.com/mapserver/mapserver/wiki#developer-notes), including
coding style and guidelines, memory management, and working with Git. 

## Documentation

The MapServer documentation is stored in a [separate repository](https://github.com/mapserver/docs). Please submit any documentation
issues or changes there. See the [Documentation Development Guide](http://mapserver.org/development/documentation.html) for further details. 
