/*
 *  The ManaPlus Client
 *  Copyright (C) 2016  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "catch.hpp"

#include "logger.h"

#include "utils/checkutils.h"
#include "utils/delete2.h"

#include "debug.h"

namespace
{
    bool flag = false;
}  // namespace

static void testReturnFalseV(const bool val)
{
    flag = false;
    returnFalseV(val);
    flag = true;
}

static void testReturnTrueV(const bool val)
{
    flag = false;
    returnTrueV(val);
    flag = true;
}

static int testReturnFalse(const bool val)
{
    returnFalse(0, val);
    return 1;
}

static int testReturnTrue(const bool val)
{
    returnTrue(0, val);
    return 1;
}

static int testReturnNullptr(void *val)
{
    returnNullptr(0, val);
    return 1;
}

static void testReturnNullptrV(void *val)
{
    flag = false;
    returnNullptrV(val);
    flag = true;
}

TEST_CASE("CheckUtils")
{
    logger = new Logger;

    SECTION("reportFalse")
    {
        REQUIRE(reportFalse(false) == false);
        REQUIRE(reportFalse(true) == true);
    }

    SECTION("reportTrue")
    {
        REQUIRE(reportTrue(false) == false);
        REQUIRE(reportTrue(true) == true);
    }

    SECTION("failFalse")
    {
        REQUIRE_THROWS(failFalse(false) == false);
        REQUIRE(failFalse(true) == true);
    }

    SECTION("failTrue")
    {
        REQUIRE(failTrue(false) == false);
        REQUIRE_THROWS(failTrue(true) == true);
    }

    SECTION("returnFalseV")
    {
        testReturnFalseV(false);
        REQUIRE(flag == false);
        testReturnFalseV(true);
        REQUIRE(flag == true);
    }

    SECTION("returnTrueV")
    {
        testReturnTrueV(false);
        REQUIRE(flag == true);
        testReturnTrueV(true);
        REQUIRE(flag == false);
    }

    SECTION("returnFalse")
    {
        REQUIRE(testReturnFalse(false) == 0);
        REQUIRE(testReturnFalse(true) == 1);
    }

    SECTION("returnTrue")
    {
        REQUIRE(testReturnTrue(false) == 1);
        REQUIRE(testReturnTrue(true) == 0);
    }

    SECTION("returnNullptr")
    {
        REQUIRE(testReturnNullptr(nullptr) == 0);
        REQUIRE(testReturnNullptr(reinterpret_cast<void*>(1)) == 1);
    }

    SECTION("returnNullptrV")
    {
        testReturnNullptrV(nullptr);
        REQUIRE(flag == false);
        testReturnNullptrV(reinterpret_cast<void*>(1));
        REQUIRE(flag == true);
    }

    delete2(logger);
}
