/*
 *  The ManaPlus Client
 *  Copyright (C) 2004-2009  The Mana World Development Team
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2015  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef RENDER_MOBILEOPENGLGRAPHICS_H
#define RENDER_MOBILEOPENGLGRAPHICS_H

#if defined(USE_OPENGL) && !defined(__native_client__)

#include "localconsts.h"
#include "render/graphics.h"

#include "resources/fboinfo.h"

#ifdef ANDROID
#include <GLES/gl.h>
#include <GLES/glext.h>
#include <GLES2/gl2.h>
#else
#ifndef USE_SDL2
#define GL_GLEXT_PROTOTYPES 1
#endif
#include <SDL_opengl.h>
#ifndef __native_client__
#include <GL/glext.h>
#endif
#endif

class OpenGLGraphicsVertexes;

class MobileOpenGLGraphics final : public Graphics
{
    public:
        MobileOpenGLGraphics();

        A_DELETE_COPY(MobileOpenGLGraphics)

        ~MobileOpenGLGraphics();

        void postInit() restrict2 override final;

        inline void drawTriangleArrayfs(const GLshort *restrict const
                                        shortVertArray,
                                        const GLfloat *restrict const
                                        floatTexArray,
                                        const int size) restrict2;

        inline void drawTriangleArrayfs(const int size) restrict2;

        inline void drawTriangleArrayfsCached(const int size) restrict2;

        inline void drawLineArrays(const int size) restrict2;

        #include "render/graphicsdef.hpp"

        #include "render/openglgraphicsdef1.hpp"

        #include "render/openglgraphicsdef.hpp"

        #include "render/openglgraphicsdefadvanced.hpp"

    private:
        GLfloat *mFloatTexArray;
        GLshort *mShortVertArray;
        GLfloat *mFloatTexArrayCached;
        GLshort *mShortVertArrayCached;
        float mAlphaCached;
        int mVpCached;
        bool mTexture;

        bool mIsByteColor;
        Color mByteColor;
        GLuint mImageCached;
        float mFloatColor;
        int mMaxVertices;
        bool mColorAlpha;
#ifdef DEBUG_BIND_TEXTURE
        std::string mOldTexture;
        unsigned mOldTextureId;
#endif
        FBOInfo mFbo;
};
#endif  // defined(USE_OPENGL) && !defined(__native_client__)

#endif  // RENDER_MOBILEOPENGLGRAPHICS_H
