/*
 *  The ManaPlus Client
 *  Copyright (C) 2004-2009  The Mana World Development Team
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2016  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// < 20131223
if (serverVersion > 0 && serverVersion <= 10)
{
    packet(SMSG_BEING_VISIBLE,                 0x0915,  -1, &BeingRecv::processBeingVisible);
    packet(SMSG_BEING_ACTION2,                 0x02e1,  33, &BeingRecv::processBeingAction2);
    packet(SMSG_BEING_SPAWN,                   0x090f,  -1, &BeingRecv::processBeingSpawn);
    packet(SMSG_BEING_MOVE,                    0x0914,  -1, &BeingRecv::processBeingMove);
}

// 20150000 or near
packet(SMSG_ADMIN_ACCOUNT_STATS,           0x0214,  42, &AdminRecv::processAccountStats);
packet(SMSG_ADMIN_GET_LOGIN_ACK,           0x01e0,  30, &AdminRecv::processAdminGetLoginAck);
packet(SMSG_ADMIN_KICK_ACK,                0x00cd,   6, &Ea::AdminRecv::processKickAck);
packet(SMSG_ADMIN_SET_TILE_TYPE,           0x0192,  24, &AdminRecv::processSetTileType);
packet(SMSG_MAP_SET_TILES_TYPE,            0x0b1b,  34, &MapRecv::processSetTilesType);
packet(SMSG_ALCHEMIST_RANKS_LIST,          0x021a, 282, &BeingRecv::processAlchemistRanksList);
packet(SMSG_AUCTION_CLOSE,                 0x025d,   4, &AuctionRecv::processAuctionClose);
packet(SMSG_AUCTION_MESSAGE,               0x0250,   3, &AuctionRecv::processAuctionMessage);
packet(SMSG_AUCTION_OPEN_WINDOW,           0x025f,   6, &AuctionRecv::processOpenWindow);
packet(SMSG_AUCTION_RESULTS,               0x0252,  -1, &AuctionRecv::processAuctionResults);
packet(SMSG_AUCTION_SET_ITEM,              0x0256,   5, &AuctionRecv::processAuctionSetItem);
packet(SMSG_AUTOSHADOW_SPELL_LIST,         0x0442,  -1, &PlayerRecv::processPlayerAutoShadowSpellList);
packet(SMSG_BANK_DEPOSIT,                  0x09a8,  16, &BankRecv::processBankDeposit);
packet(SMSG_BANK_STATUS,                   0x09a6,  12, &BankRecv::processBankStatus);
packet(SMSG_BANK_WITHDRAW,                 0x09aa,  16, &BankRecv::processBankWithdraw);
packet(SMSG_BATTLE_BEGINS,                 0x08df,  50, &BattleGroundRecv::processBattleBegins);
packet(SMSG_BATTLE_CHAT_MESSAGE,           0x02dc,  -1, &ChatRecv::processBattleChatMessage);
packet(SMSG_BATTLE_EMBLEM,                 0x02dd,  32, &BattleGroundRecv::processBattleEmblem);
packet(SMSG_BATTLE_EMBLEM2,                0x0b1a,  34, &BattleGroundRecv::processBattleEmblem2);
packet(SMSG_BATTLE_JOINED,                 0x08d9,  30, &BattleGroundRecv::processBattleJoined);
packet(SMSG_BATTLE_NOTICE_DELETE,          0x08db,  27, &BattleGroundRecv::processBattleNoticeDelete);
packet(SMSG_BATTLE_PLAY,                   0x07fe,  26, &BattleGroundRecv::processBattlePlay);
packet(SMSG_BATTLE_QUEUE_ACK,              0x08d8,  27, &BattleGroundRecv::processBattleQueueAck);
packet(SMSG_BATTLE_UPDATE_COORDS,          0x02df,  36, &BattleGroundRecv::processBattleUpdateCoords);
packet(SMSG_BATTLE_UPDATE_SCORE,           0x02de,   6, &BattleGroundRecv::processBattleUpdateScore);
packet(SMSG_BEING_ACTION,                  0x008a,  29, &Ea::BeingRecv::processBeingAction);
packet(SMSG_BEING_ATTRS,                   0x0b0a,  -1, &BeingRecv::processBeingAttrs);
packet(SMSG_BEING_CHANGE_DIRECTION,        0x009c,   9, &BeingRecv::processBeingChangeDirection);
packet(SMSG_BEING_CHANGE_LOOKS2,           0x01d7,  11, &BeingRecv::processBeingChangeLook2);
packet(SMSG_BEING_CHANGE_LOOKS_CARDS,      0x0b17,  19, &BeingRecv::processBeingChangeLookCards);
packet(SMSG_BEING_CHANGE_LOOKS_OUTDATED,   0x00c3,   8, nullptr);
packet(SMSG_BEING_CHARM,                   0x08cf,  10, &BeingRecv::processBeingCharm);
packet(SMSG_BEING_CHAT,                    0x008d,  -1, &ChatRecv::processBeingChat);
packet(SMSG_BEING_EMOTION,                 0x00c0,   7, &Ea::BeingRecv::processBeingEmotion);
packet(SMSG_BEING_FAKE_NAME,               0x0078,  55, &BeingRecv::processBeingFakeName);
packet(SMSG_BEING_FONT,                    0x02ef,   8, &BeingRecv::processBeingFont);
packet(SMSG_BEING_MILLENIUM_SHIELD,        0x0440,  10, &BeingRecv::processBeingMilleniumShield);
packet(SMSG_BEING_MOVE2,                   0x0086,  16, &BeingRecv::processBeingMove2);
packet(SMSG_BEING_MOVE3,                   0x0b04,  -1, &Ea::BeingRecv::processBeingMove3);
packet(SMSG_BEING_NAME_RESPONSE,           0x0095,  30, &Ea::BeingRecv::processNameResponse);
packet(SMSG_BEING_NAME_RESPONSE2,          0x0b01,  -1, &BeingRecv::processNameResponse2);
packet(SMSG_BEING_REMOVE,                  0x0080,   7, &Ea::BeingRecv::processBeingRemove);
packet(SMSG_BEING_REMOVE_SKILL,            0x0120,   6, &BeingRecv::processBeingRemoveSkill);
packet(SMSG_BEING_RESURRECT,               0x0148,   8, &BeingRecv::processBeingResurrect);
packet(SMSG_BEING_SELFEFFECT,              0x019b,  10, &BeingRecv::processBeingSelfEffect);
packet(SMSG_BEING_SLIDE,                   0x01ff,  10, &BeingRecv::processBeingSlide);
packet(SMSG_BEING_SOUND_EFFECT,            0x01d3,  35, &BeingRecv::processBeingSoundEffect);
packet(SMSG_BEING_SPECIAL_EFFECT,          0x01f3,  10, &BeingRecv::processBeingSpecialEffect);
packet(SMSG_BEING_SPECIAL_EFFECT_NUM,      0x0284,  14, &BeingRecv::processBeingSpecialEffectNum);
packet(SMSG_BEING_STATUS_CHANGE,           0x0983,  29, &BeingRecv::processBeingStatusChange);
packet(SMSG_BEING_STATUS_CHANGE2,          0x043f,  25, &BeingRecv::processBeingStatusChange2);
packet(SMSG_BEING_STAT_UPDATE_1,           0x01ab,  12, &BeingRecv::processBeingStatUpdate1);
packet(SMSG_BEING_VIEW_EQUIPMENT,          0x0997,  -1, &BeingRecv::processBeingViewEquipment);
packet(SMSG_BIND_ITEM,                     0x02d3,   4, &InventoryRecv::processBindItem);
packet(SMSG_BLACKSMITH_RANKS_LIST,         0x0219, 282, &BeingRecv::processBlacksmithRanksList);
packet(SMSG_BLADE_STOP,                    0x01d1,  14, &BeingRecv::processBladeStop);
packet(SMSG_BOSS_MAP_INFO,                 0x0293,  70, &BeingRecv::processBossMapInfo);
packet(SMSG_BUYINGSTORE_CREATE_FAILED,     0x0812,   8, &BuyingStoreRecv::processBuyingStoreCreateFailed);
packet(SMSG_BUYINGSTORE_DELETE_ITEM,       0x081c,  10, &BuyingStoreRecv::processBuyingStoreDeleteItem);
packet(SMSG_BUYINGSTORE_HIDE_BOARD,        0x0816,   6, &BuyingStoreRecv::processBuyingStoreHideBoard);
packet(SMSG_BUYINGSTORE_ITEMS_LIST,        0x0818,  -1, &BuyingStoreRecv::processBuyingStoreItemsList);
packet(SMSG_BUYINGSTORE_OPEN,              0x0810,   3, &BuyingStoreRecv::processBuyingStoreOpen);
packet(SMSG_BUYINGSTORE_OWN_ITEMS,         0x0813,  -1, &BuyingStoreRecv::processBuyingStoreOwnItems);
packet(SMSG_BUYINGSTORE_REPORT,            0x081b,  10, &BuyingStoreRecv::processBuyingStoreReport);
packet(SMSG_BUYINGSTORE_SELLER_SELL_FAILED, 0x0824,   6, &BuyingStoreRecv::processBuyingStoreSellerSellFailed);
packet(SMSG_BUYINGSTORE_SELL_FAILED,       0x081a,   4, &BuyingStoreRecv::processBuyingStoreSellFailed);
packet(SMSG_BUYINGSTORE_SHOW_BOARD,        0x0814,  86, &BuyingStoreRecv::processBuyingStoreShowBoard);
packet(SMSG_CART_INFO,                     0x0121,  14, &InventoryRecv::processCartInfo);
packet(SMSG_CART_REMOVE,                   0x012b,   2, &InventoryRecv::processCartRemove);
packet(SMSG_CHANGE_MAP_SERVER,             0x0092,  28, &CharServerRecv::processChangeMapServer);
packet(SMSG_CHAR_BAN_CHAR_LIST,            0x020d,  -1, &CharServerRecv::processCharBanCharList);
packet(SMSG_CHAR_CAPTCHA_NOT_SUPPORTED,    0x07e9,   5, &CharServerRecv::processCharCaptchaNotSupported);
packet(SMSG_CHAR_CHANGE_SLOT,              0x08d5,  -1, &CharServerRecv::processCharChangeSlot);
packet(SMSG_CHAR_CHARACTERS,               0x099d,  -1, &CharServerRecv::processCharCharacters);
packet(SMSG_CHAR_CHECK_RENAME,             0x028e,   4, &CharServerRecv::processCharCheckRename);
packet(SMSG_CHAR_CREATE_FAILED,            0x006e,   3, &Ea::CharServerRecv::processCharCreateFailed);
packet(SMSG_CHAR_CREATE_SUCCEEDED,         0x006d, 149, &CharServerRecv::processCharCreate);
packet(SMSG_CHAR_DELETE2_ACCEPT_ACTUAL_ACK, 0x082a,  10, &CharServerRecv::processCharDelete2AcceptActual);
packet(SMSG_CHAR_DELETE2_ACK,              0x0828,  14, &CharServerRecv::processCharDelete2Ack);
packet(SMSG_CHAR_DELETE2_CANCEL_ACK,       0x082c,  10, &CharServerRecv::processCharDelete2CancelAck);
packet(SMSG_CHAR_DELETE_FAILED,            0x0070,   3, &CharServerRecv::processCharDeleteFailed);
packet(SMSG_CHAR_DELETE_SUCCEEDED,         0x006f,   2, &Ea::CharServerRecv::processCharDelete);
packet(SMSG_CHAR_LOGIN,                    0x006b,  -1, &CharServerRecv::processCharLogin);
packet(SMSG_CHAR_LOGIN2,                   0x082d,  -1, &CharServerRecv::processCharLogin2);
packet(SMSG_CHAR_LOGIN_ERROR,              0x006c,   3, &Ea::CharServerRecv::processCharLoginError);
packet(SMSG_CHAR_MAP_INFO,                 0x0071,  28, &CharServerRecv::processCharMapInfo);
packet(SMSG_CHAR_PASSWORD_RESPONSE,        0x0062,   3, &LoginRecv::processCharPasswordResponse);
packet(SMSG_CHAR_PINCODE_STATUS,           0x08b9,  12, &CharServerRecv::processPincodeStatus);
packet(SMSG_CHAR_RENAME,                   0x0290,   4, &CharServerRecv::processCharRename);
packet(SMSG_CHAR_SWITCH_RESPONSE,          0x00b3,   3, &Ea::GameRecv::processCharSwitchResponse);
packet(SMSG_CHAT_DISPLAY,                  0x00d7,  -1, &ChatRecv::processChatDisplay);
packet(SMSG_CHAT_IGNORE_LIST,              0x00d4,  -1, &ChatRecv::processChatIgnoreList);
packet(SMSG_CHAT_JOIN_CHANNEL,             0x0b08,  27, &ChatRecv::processJoinChannel);
packet(SMSG_CHAT_ROOM_ADD_MEMBER,          0x00dc,  28, &ChatRecv::processChatRoomAddMember);
packet(SMSG_CHAT_ROOM_CREATE_ACK,          0x00d6,   3, &ChatRecv::processChatRoomCreateAck);
packet(SMSG_CHAT_ROOM_DESTROY,             0x00d8,   6, &ChatRecv::processChatRoomDestroy);
packet(SMSG_CHAT_ROOM_JOIN_ACK,            0x00db,  -1, &ChatRecv::processChatRoomJoinAck);
packet(SMSG_CHAT_ROOM_JOIN_FAILED,         0x00da,   3, &ChatRecv::processChatRoomJoinFailed);
packet(SMSG_CHAT_ROOM_LEAVE,               0x00dd,  29, &ChatRecv::processChatRoomLeave);
packet(SMSG_CHAT_ROOM_ROLE_CHANGE,         0x00e1,  30, &ChatRecv::processChatRoomRoleChange);
packet(SMSG_CHAT_ROOM_SETTINGS,            0x00df,  -1, &ChatRecv::processChatRoomSettings);
packet(SMSG_CHAT_SILENCE,                  0x014b,  27, &ChatRecv::processChatSilence);
packet(SMSG_CHAT_TALKIE_BOX,               0x0191,  86, &ChatRecv::processChatTalkieBox);
packet(SMSG_CLASS_CHANGE,                  0x01b0,  11, &BeingRecv::processClassChange);
packet(SMSG_COLOR_MESSAGE,                 0x02c1,  -1, &ChatRecv::processColorChat);
packet(SMSG_COMBO_DELAY,                   0x01d2,  10, &BeingRecv::processComboDelay);
packet(SMSG_CONNECTION_PROBLEM,            0x0081,   3, &GeneralRecv::processConnectionProblem);
packet(SMSG_ELEMENTAL_INFO,                0x081d,  22, &ElementalRecv::processElementalInfo);
packet(SMSG_ELEMENTAL_UPDATE_STATUS,       0x081e,   8, &ElementalRecv::processElementalUpdateStatus);
packet(SMSG_FAMILY_ASK_FOR_CHILD,          0x01f6,  34, &FamilyRecv::processAskForChild);
packet(SMSG_FAMILY_ASK_FOR_CHILD_REPLY,    0x0216,   6, &FamilyRecv::processAskForChildReply);
packet(SMSG_FAMILY_CALL_PARTNER,           0x01e6,  26, &FamilyRecv::processCallPartner);
packet(SMSG_FAMILY_DIVORCED,               0x0205,  26, &FamilyRecv::processDivorced);
packet(SMSG_FORMAT_MESSAGE,                0x0291,   4, &ChatRecv::processFormatMessage);
packet(SMSG_FORMAT_MESSAGE_NUMBER,         0x07e2,   8, &ChatRecv::processFormatMessageNumber);
packet(SMSG_FORMAT_MESSAGE_SKILL,          0x07e6,   8, &ChatRecv::processFormatMessageSkill);
packet(SMSG_FRIENDS_DELETE_PLAYER,         0x020a,  10, &FriendsRecv::processDeletePlayer);
packet(SMSG_FRIENDS_LIST,                  0x0201,  -1, &FriendsRecv::processFriendsList);
packet(SMSG_FRIENDS_PLAYER_ONLINE,         0x0206,  11, &FriendsRecv::processPlayerOnline);
packet(SMSG_FRIENDS_REQUEST,               0x0207,  34, &FriendsRecv::processRequest);
packet(SMSG_FRIENDS_REQUEST_ACK,           0x0209,  36, &FriendsRecv::processRequestAck);
packet(SMSG_GLADIATOR_FEEL_REQUEST,        0x0253,   3, &BeingRecv::processGladiatorFeelRequest);
packet(SMSG_GM_CHAT,                       0x009a,  -1, &ChatRecv::processGmChat);
packet(SMSG_GM_CHAT2,                      0x01c3,  -1, &ChatRecv::processGmChat2);
packet(SMSG_GRAFFITI_VISIBLE,              0x01c9,  97, &BeingRecv::processGraffiti);
packet(SMSG_GUILD_ALIANCE_INFO,            0x014c,  -1, &Ea::GuildRecv::processGuildAlianceInfo);
packet(SMSG_GUILD_ALLIANCE_ADDED_DISABLED, 0x0185,  34, nullptr);
packet(SMSG_GUILD_BASIC_INFO,              0x01b6, 114, &Ea::GuildRecv::processGuildBasicInfo);
packet(SMSG_GUILD_BROKEN,                  0x015e,   6, &Ea::GuildRecv::processGuildBroken);
packet(SMSG_GUILD_CREATE_RESPONSE,         0x0167,   3, &Ea::GuildRecv::processGuildCreateResponse);
packet(SMSG_GUILD_DEL_ALLIANCE,            0x0184,  10, &Ea::GuildRecv::processGuildDelAlliance);
packet(SMSG_GUILD_EMBLEM,                  0x01b4,  12, &GuildRecv::processGuildEmblem);
packet(SMSG_GUILD_EMBLEM_DATA,             0x0152,  -1, &Ea::GuildRecv::processGuildEmblemData);
packet(SMSG_GUILD_EXPULSION,               0x0839,  66, &GuildRecv::processGuildExpulsion);
packet(SMSG_GUILD_EXPULSION_LIST,          0x0163,  -1, &GuildRecv::processGuildExpulsionList);
packet(SMSG_GUILD_INVITE,                  0x016a,  30, &Ea::GuildRecv::processGuildInvite);
packet(SMSG_GUILD_INVITE_ACK,              0x0169,   3, &Ea::GuildRecv::processGuildInviteAck);
packet(SMSG_GUILD_LEAVE,                   0x015a,  66, &Ea::GuildRecv::processGuildLeave);
packet(SMSG_GUILD_MASTER_OR_MEMBER,        0x014e,   6, &Ea::GuildRecv::processGuildMasterOrMember);
packet(SMSG_GUILD_MEMBER_LIST,             0x0154,  -1, &Ea::GuildRecv::processGuildMemberList);
packet(SMSG_GUILD_MEMBER_LOGIN,            0x01f2,  20, &GuildRecv::processGuildMemberLogin);
packet(SMSG_GUILD_MEMBER_POS_CHANGE,       0x0156,  -1, &Ea::GuildRecv::processGuildMemberPosChange);
packet(SMSG_GUILD_MESSAGE,                 0x017f,  -1, &Ea::GuildRecv::processGuildMessage);
packet(SMSG_GUILD_NOTICE,                  0x016f, 182, &Ea::GuildRecv::processGuildNotice);
packet(SMSG_GUILD_OPPOSITION_ACK,          0x0181,   3, &Ea::GuildRecv::processGuildOppositionAck);
packet(SMSG_GUILD_POSITION_CHANGED,        0x0174,  -1, &Ea::GuildRecv::processGuildPositionChanged);
packet(SMSG_GUILD_POSITION_INFO,           0x016c,  43, &GuildRecv::processGuildPositionInfo);
packet(SMSG_GUILD_POS_INFO_LIST,           0x0160,  -1, &Ea::GuildRecv::processGuildPosInfoList);
packet(SMSG_GUILD_POS_NAME_LIST,           0x0166,  -1, &Ea::GuildRecv::processGuildPosNameList);
packet(SMSG_GUILD_REQ_ALLIANCE,            0x0171,  30, &Ea::GuildRecv::processGuildReqAlliance);
packet(SMSG_GUILD_REQ_ALLIANCE_ACK,        0x0173,   3, &Ea::GuildRecv::processGuildReqAllianceAck);
packet(SMSG_GUILD_SKILL_INFO,              0x0162,  -1, &Ea::GuildRecv::processGuildSkillInfo);
packet(SMSG_GUILD_SKILL_UP,                0x010e,  11, &Ea::GuildRecv::processGuildSkillUp);
packet(SMSG_GUILD_UPDATE_COORDS,           0x01eb,  10, &GuildRecv::processGuildUpdateCoords);
packet(SMSG_HOMUNCULUS_DATA,               0x0230,  12, &HomunculusRecv::processHomunculusData);
packet(SMSG_HOMUNCULUS_FOOD,               0x022f,   5, &HomunculusRecv::processHomunculusFood);
packet(SMSG_HOMUNCULUS_INFO,               0x022e,  71, &HomunculusRecv::processHomunculusInfo);
packet(SMSG_HOMUNCULUS_SKILLS,             0x0235,  -1, &HomunculusRecv::processHomunculusSkills);
packet(SMSG_HOMUNCULUS_SKILL_UP,           0x0239,   0, &HomunculusRecv::processHomunculusSkillUp);
packet(SMSG_IGNORE_ALL_RESPONSE,           0x00d2,   4, &Ea::ChatRecv::processIgnoreAllResponse);
packet(SMSG_IGNORE_NICK_ACK,               0x00d1,   4, &ChatRecv::processIgnoreNickAck);
packet(SMSG_INSTANCE_CREATE,               0x02cc,   4, &MapRecv::processInstanceCreate);
packet(SMSG_INSTANCE_DELETE,               0x02ce,  10, &MapRecv::processInstanceDelete);
packet(SMSG_INSTANCE_INFO,                 0x02cd,  71, &MapRecv::processInstanceInfo);
packet(SMSG_INSTANCE_START,                0x02cb,  65, &MapRecv::processInstanceStart);
packet(SMSG_ITEM_DAMAGED,                  0x02bb,   8, &InventoryRecv::processItemDamaged);
packet(SMSG_ITEM_DROPPED,                  0x084b,  19, &ItemRecv::processItemDropped);
packet(SMSG_ITEM_DROPPED2,                 0x0b19,  28, &ItemRecv::processItemDropped2);
packet(SMSG_ITEM_MVP_DROPPED,              0x07fd,  59, &ItemRecv::processItemMvpDropped);
packet(SMSG_ITEM_REMOVE,                   0x00a1,   6, &Ea::ItemRecv::processItemRemove);
packet(SMSG_ITEM_USE_RESPONSE,             0x00a8,   7, &Ea::InventoryRecv::processItemUseResponse);
packet(SMSG_ITEM_VISIBLE,                  0x009d,  17, &ItemRecv::processItemVisible);
packet(SMSG_ITEM_VISIBLE2,                 0x0b18,  28, &ItemRecv::processItemVisible2);
packet(SMSG_LOGIN_CODING_KEY,              0x01dc,  -1, &LoginRecv::processCondingKey);
packet(SMSG_LOGIN_DATA,                    0x0069,  -1, &Ea::LoginRecv::processLoginData);
packet(SMSG_LOGIN_ERROR,                   0x006a,  23, &Ea::LoginRecv::processLoginError);
packet(SMSG_LOGIN_ERROR2,                  0x083e,  26, &LoginRecv::processLoginError2);
packet(SMSG_MAIL_DELETE_MAIL_ACK,          0x0257,   8, &MailRecv::processDeleteAck);
packet(SMSG_MAIL_GET_ATTACHMENT,           0x0245,   3, &MailRecv::processGetAttachment);
packet(SMSG_MAIL_MAILS_LIST,               0x0240,  -1, &MailRecv::processMailList);
packet(SMSG_MAIL_NEW_MAIL,                 0x024a,  70, &MailRecv::processNewMail);
packet(SMSG_MAIL_OPEN_WINDOW,              0x0260,   6, &MailRecv::processMailOpen);
packet(SMSG_MAIL_READ_MAIL,                0x0242,  -1, &MailRecv::processReadMail);
packet(SMSG_MAIL_RETURN,                   0x0274,   8, &MailRecv::processMailReturn);
packet(SMSG_MAIL_SEND_MAIL_ACK,            0x0249,   3, &MailRecv::processSendMailAck);
packet(SMSG_MAIL_SET_ATTACHMENT_ACK,       0x0255,   5, &MailRecv::processSetAttachmentAck);
packet(SMSG_MANNER_MESSAGE,                0x014a,   6, &ChatRecv::processMannerMessage);
packet(SMSG_MAP_ACCOUNT_ID,                0x0283,   6, &GameRecv::processMapAccountId);
packet(SMSG_MAP_AUTH_REFUSE,               0x0074,   3, &GameRecv::processMapAuthRefuse);
packet(SMSG_MAP_LOGIN_SUCCESS,             0x0a18,  14, &GameRecv::processMapLogin);
packet(SMSG_MAP_MASK,                      0x0b02,  10, &Ea::PlayerRecv::processMapMask);
packet(SMSG_MAP_MUSIC,                     0x0b05,  -1, &Ea::PlayerRecv::processMapMusic);
packet(SMSG_MAP_NOT_FOUND,                 0x0840,  -1, &GeneralRecv::processMapNotFound);
packet(SMSG_MAP_QUIT_RESPONSE,             0x018b,   4, &Ea::GameRecv::processMapQuitResponse);
packet(SMSG_MAP_TYPE,                      0x01d6,   4, &BeingRecv::processMapType);
packet(SMSG_MAP_TYPE_PROPERTY2,            0x099b,   8, &BeingRecv::processMapTypeProperty);
packet(SMSG_MARRIAGE_PROCESS_OUTDATED,     0x01e4,   2, nullptr);
packet(SMSG_MARRIAGE_PROPOSAL_OUTDATED,    0x01e2,  34, nullptr);
packet(SMSG_MERCENARY_INFO,                0x029b,  80, &MercenaryRecv::processMercenaryInfo);
packet(SMSG_MERCENARY_SKILLS,              0x029d,  -1, &MercenaryRecv::processMercenarySkills);
packet(SMSG_MERCENARY_UPDATE,              0x02a2,   8, &MercenaryRecv::processMercenaryUpdate);
packet(SMSG_MOB_INFO,                      0x0b03,  -1, &BeingRecv::processMobInfo);
packet(SMSG_MONSTER_HP,                    0x0977,  14, &BeingRecv::processMonsterHp);
packet(SMSG_MONSTER_INFO,                  0x018c,  29, &BeingRecv::processMonsterInfo);
packet(SMSG_MVP_EFFECT,                    0x010c,   6, &Ea::ChatRecv::processMVPEffect);
packet(SMSG_MVP_EXP,                       0x010b,   6, &ChatRecv::processMVPExp);
packet(SMSG_MVP_ITEM,                      0x010a,   4, &ChatRecv::processMVPItem);
packet(SMSG_MVP_NO_ITEM,                   0x010d,   2, &ChatRecv::processMVPNoItem);
packet(SMSG_NPC_AREA,                      0x0b0b,  -1, &NpcRecv::processArea);
packet(SMSG_NPC_BUY,                       0x00c6,  -1, &BuySellRecv::processNpcBuy);
packet(SMSG_NPC_BUY_RESPONSE,              0x00ca,   3, &Ea::BuySellRecv::processNpcBuyResponse);
packet(SMSG_NPC_BUY_SELL_CHOICE,           0x00c4,   6, &Ea::BuySellRecv::processNpcBuySellChoice);
packet(SMSG_NPC_CASH_BUY,                  0x0849,  16, &CashShopRecv::processCashShopBuy);
packet(SMSG_NPC_CASH_BUY_ACK,              0x0289,  12, &CashShopRecv::processCashShopBuyAck);
packet(SMSG_NPC_CASH_POINTS,               0x0845,  10, &CashShopRecv::processCashShopPoints);
packet(SMSG_NPC_CASH_SCHEDULE,             0x08ca,  -1, &CashShopRecv::processCashShopSchedule);
packet(SMSG_NPC_CASH_SHOP_OPEN,            0x0287,  -1, &CashShopRecv::processCashShopOpen);
packet(SMSG_NPC_CASH_TAB_PRICE_LIST,       0x08c0,  -1, &CashShopRecv::processCashShopTabPriceList);
packet(SMSG_NPC_CHANGETITLE,               0x0b06,  -1, &Ea::NpcRecv::processChangeTitle);
packet(SMSG_NPC_CHOICE,                    0x00b7,  -1, &Ea::NpcRecv::processNpcChoice);
packet(SMSG_NPC_CLOSE,                     0x00b6,   6, &Ea::NpcRecv::processNpcClose);
packet(SMSG_NPC_CLOSE_TIMEOUT,             0x08d6,   6, &NpcRecv::processNpcCloseTimeout);
packet(SMSG_NPC_COMMAND,                   0x0b00,  16, &Ea::NpcRecv::processNpcCommand);
packet(SMSG_NPC_CUTIN,                     0x01b3,  67, &NpcRecv::processNpcCutin);
packet(SMSG_NPC_INT_INPUT,                 0x0142,   6, &Ea::NpcRecv::processNpcIntInput);
packet(SMSG_NPC_MARKET_BUY_ACK,            0x09d7,  -1, &MarketRecv::processMarketBuyAck);
packet(SMSG_NPC_MARKET_OPEN,               0x09d5,  -1, &MarketRecv::processMarketOpen);
packet(SMSG_NPC_MESSAGE,                   0x00b4,  -1, &Ea::NpcRecv::processNpcMessage);
packet(SMSG_NPC_NEXT,                      0x00b5,   6, &Ea::NpcRecv::processNpcNext);
packet(SMSG_NPC_PROGRESS_BAR_ABORT,        0x02f2,   2, &NpcRecv::processProgressBarAbort);
packet(SMSG_NPC_SELL,                      0x00c7,  -1, &Ea::BuySellRecv::processNpcSell);
packet(SMSG_NPC_SELL_RESPONSE,             0x00cb,   3, &BuySellRecv::processNpcSellResponse);
packet(SMSG_NPC_SHOW_DIGIT,                0x01b1,   7, &NpcRecv::processShowDigit);
packet(SMSG_NPC_SHOW_PROGRESS_BAR,         0x02f0,  10, &NpcRecv::processNpcShowProgressBar);
packet(SMSG_NPC_STR_INPUT,                 0x01d4,   6, &Ea::NpcRecv::processNpcStrInput);
packet(SMSG_NPC_VIEWPOINT,                 0x0144,  23, &NpcRecv::processNpcViewPoint);
packet(SMSG_NPC_SKIN,                      0x0b1c,  -1, &NpcRecv::processNpcSkin);
packet(SMSG_ONLINE_LIST,                   0x0b10,  -1, &PlayerRecv::processOnlineList);
packet(SMSG_PARTY_CREATE,                  0x00fa,   3, &Ea::PartyRecv::processPartyCreate);
packet(SMSG_PARTY_INFO,                    0x00fb,  -1, &PartyRecv::processPartyInfo);
packet(SMSG_PARTY_INVITATION_STATS,        0x02c9,   3, &PartyRecv::processPartyInvitationStats);
packet(SMSG_PARTY_INVITED,                 0x02c6,  30, &PartyRecv::processPartyInvited);
packet(SMSG_PARTY_INVITE_RESPONSE,         0x02c5,  30, &PartyRecv::processPartyInviteResponse);
packet(SMSG_PARTY_INVITE_RESPONSE_OUTDATED, 0x00fd,  27, nullptr);
packet(SMSG_PARTY_ITEM_PICKUP,             0x02b8,  22, &PartyRecv::processPartyItemPickup);
packet(SMSG_PARTY_LEADER,                  0x07fc,  10, &PartyRecv::processPartyLeader);
packet(SMSG_PARTY_LEAVE,                   0x0105,  31, &Ea::PartyRecv::processPartyLeave);
packet(SMSG_PARTY_MEMBER_INFO,             0x01e9,  81, &PartyRecv::processPartyMemberInfo);
packet(SMSG_PARTY_MESSAGE,                 0x0109,  -1, &PartyRecv::processPartyMessage);
packet(SMSG_PARTY_SETTINGS,                0x07d8,   8, &PartyRecv::processPartySettings);
packet(SMSG_PARTY_UPDATE_COORDS,           0x0107,  10, &Ea::PartyRecv::processPartyUpdateCoords);
packet(SMSG_PET_CATCH_PROCESS,             0x019e,   2, &PetRecv::processPetCatchProcess);
packet(SMSG_PET_DATA,                      0x01a4,  11, &PetRecv::processPetData);
packet(SMSG_PET_EGGS_LIST,                 0x01a6,  -1, &PetRecv::processEggsList);
packet(SMSG_PET_FOOD,                      0x01a3,   5, &PetRecv::processPetFood);
packet(SMSG_PET_MESSAGE,                   0x01aa,  10, &PetRecv::processPetMessage);
packet(SMSG_PET_ROULETTE,                  0x01a0,   3, &PetRecv::processPetRoulette);
packet(SMSG_PET_STATUS,                    0x01a2,  37, &PetRecv::processPetStatus);
packet(SMSG_PK_RANKS_LIST,                 0x0238, 282, &BeingRecv::processPkRanksList);
packet(SMSG_PLAYER_ADD_SKILL,              0x0111,  39, &SkillRecv::processSkillAdd);
packet(SMSG_PLAYER_ARROW_EQUIP,            0x013c,   4, &Ea::InventoryRecv::processPlayerArrowEquip);
packet(SMSG_PLAYER_ARROW_MESSAGE,          0x013b,   4, &Ea::PlayerRecv::processPlayerArrowMessage);
packet(SMSG_PLAYER_ATTACK_RANGE,           0x013a,   4, &Ea::InventoryRecv::processPlayerAttackRange);
packet(SMSG_PLAYER_CART_ADD,               0x01c5,  22, &InventoryRecv::processPlayerCartAdd);
packet(SMSG_PLAYER_CART_ADD_ERROR,         0x012c,   3, &InventoryRecv::processCartAddError);
packet(SMSG_PLAYER_CART_ADD_OUTDATED,      0x0124,  21, nullptr);
packet(SMSG_PLAYER_CART_EQUIP,             0x0994,  -1, &InventoryRecv::processPlayerCartEquip);
packet(SMSG_PLAYER_CART_ITEMS,             0x0993,  -1, &InventoryRecv::processPlayerCartItems);
packet(SMSG_PLAYER_CART_REMOVE,            0x0125,   8, &InventoryRecv::processPlayerCartRemove);
packet(SMSG_PLAYER_CHAT,                   0x008e,  -1, &ChatRecv::processChat);
packet(SMSG_PLAYER_CLIENT_COMMAND,         0x0b16,  -1, &PlayerRecv::processPlayerClientCommand);
packet(SMSG_PLAYER_COOKING_LIST,           0x025a,  -1, &InventoryRecv::processPlayerCookingList);
packet(SMSG_PLAYER_DELETE_SKILL,           0x0441,   4, &SkillRecv::processSkillDelete);
packet(SMSG_PLAYER_EQUIP,                  0x0999,  11, &InventoryRecv::processPlayerEquip);
packet(SMSG_PLAYER_EQUIPMENT,              0x0992,  -1, &InventoryRecv::processPlayerEquipment);
packet(SMSG_PLAYER_EQUIP_TICK_ACK,         0x02d9,  10, &PlayerRecv::processPlayerEquipTickAck);
packet(SMSG_PLAYER_FAME_ALCHEMIST,         0x021c,  10, &PlayerRecv::processPlayerFameAlchemist);
packet(SMSG_PLAYER_FAME_BLACKSMITH,        0x021b,  10, &PlayerRecv::processPlayerFameBlacksmith);
packet(SMSG_PLAYER_FAME_TAEKWON,           0x0224,  10, &PlayerRecv::processPlayerFameTaekwon);
packet(SMSG_PLAYER_FAVORITE_ITEM,          0x0908,   5, &InventoryRecv::processFavoriteItem);
packet(SMSG_PLAYER_GET_EXP,                0x07f6,  14, &PlayerRecv::processPlayerGetExp);
packet(SMSG_PLAYER_GUILD_PARTY_INFO,       0x0195, 102, &BeingRecv::processPlayerGuilPartyInfo);
packet(SMSG_PLAYER_HEAL,                   0x013d,   6, &PlayerRecv::processPlayerHeal);
packet(SMSG_PLAYER_HP,                     0x080e,  14, &BeingRecv::processMonsterHp);
packet(SMSG_PLAYER_IDENTIFIED,             0x0179,   5, &InventoryRecv::processPlayerIdentified);
packet(SMSG_PLAYER_IDENTIFY_LIST,          0x0177,  -1, &InventoryRecv::processPlayerIdentifyList);
packet(SMSG_PLAYER_INSERT_CARD,            0x017d,   7, &InventoryRecv::processPlayerInsertCard);
packet(SMSG_PLAYER_INVENTORY,              0x0991,  -1, &InventoryRecv::processPlayerInventory);
packet(SMSG_PLAYER_INVENTORY_ADD,          0x0990,  31, &InventoryRecv::processPlayerInventoryAdd);
packet(SMSG_PLAYER_INVENTORY_REMOVE,       0x00af,   6, &InventoryRecv::processPlayerInventoryRemove);
packet(SMSG_PLAYER_INVENTORY_REMOVE2,      0x07fa,   8, &InventoryRecv::processPlayerInventoryRemove2);
packet(SMSG_PLAYER_INVENTORY_USE,          0x01c8,  13, &Ea::InventoryRecv::processPlayerInventoryUse);
packet(SMSG_PLAYER_ITEM_RENTAL_EXPIRED,    0x0299,   6, &InventoryRecv::processPlayerItemRentalExpired);
packet(SMSG_PLAYER_ITEM_RENTAL_TIME,       0x0298,   8, &InventoryRecv::processPlayerItemRentalTime);
packet(SMSG_PLAYER_MOVE_TO_ATTACK,         0x0139,  16, &Ea::BeingRecv::processPlayerMoveToAttack);
packet(SMSG_PLAYER_NOTIFY_MAPINFO,         0x0189,   4, &PlayerRecv::processNotifyMapInfo);
packet(SMSG_PLAYER_RANK_POINTS,            0x097e,  12, &PlayerRecv::processPlayerRankPoints);
packet(SMSG_PLAYER_READ_BOOK,              0x0294,  10, &PlayerRecv::processPlayerReadBook);
packet(SMSG_PLAYER_REFINE,                 0x0188,   8, &InventoryRecv::processPlayerRefine);
packet(SMSG_PLAYER_REFINE_LIST,            0x0221,  -1, &InventoryRecv::processPlayerRefineList);
packet(SMSG_PLAYER_REPAIR_EFFECT,          0x01fe,   5, &InventoryRecv::processPlayerRepairEffect);
packet(SMSG_PLAYER_REPAIR_LIST,            0x01fc,  -1, &InventoryRecv::processPlayerRepairList);
packet(SMSG_PLAYER_SHORTCUTS,              0x0a00, 269, &PlayerRecv::processPlayerShortcuts);
packet(SMSG_PLAYER_SHOW_EQUIP,             0x02da,   3, &PlayerRecv::processPlayerShowEquip);
packet(SMSG_PLAYER_SKILLS,                 0x010f,  -1, &SkillRecv::processPlayerSkills);
packet(SMSG_PLAYER_SKILL_AUTO_SPELLS,      0x01cd,  29, &SkillRecv::processSkillAutoSpells);
packet(SMSG_PLAYER_SKILL_COOLDOWN,         0x043d,   8, &SkillRecv::processSkillCoolDown);
packet(SMSG_PLAYER_SKILL_COOLDOWN_LIST,    0x0985,  -1, &SkillRecv::processSkillCoolDownList);
packet(SMSG_PLAYER_SKILL_COOLDOWN_LIST_OUTDATED, 0x043e,   0, nullptr);
packet(SMSG_PLAYER_SKILL_MESSAGE,          0x0215,   6, &PlayerRecv::processPlayerSkillMessage);
packet(SMSG_PLAYER_SKILL_PRODUCE_EFFECT,   0x018f,   6, &SkillRecv::processSkillProduceEffect);
packet(SMSG_PLAYER_SKILL_PRODUCE_MIX_LIST, 0x018d,  -1, &SkillRecv::processSkillProduceMixList);
packet(SMSG_PLAYER_SKILL_UP,               0x010e,  11, &Ea::SkillRecv::processPlayerSkillUp);
packet(SMSG_PLAYER_STATUS_CHANGE,          0x0229,  15, &BeingRecv::processPlaterStatusChange);
packet(SMSG_PLAYER_STATUS_CHANGE2,         0x028a,  18, &BeingRecv::processPlaterStatusChange2);
packet(SMSG_PLAYER_STATUS_CHANGE_NO_TICK,  0x0196,   9, &BeingRecv::processPlaterStatusChangeNoTick);
packet(SMSG_PLAYER_STATUS_CHANGE_OUTDATED, 0x0119,  13, nullptr);
packet(SMSG_PLAYER_STAT_UPDATE_1,          0x00b0,   8, &Ea::PlayerRecv::processPlayerStatUpdate1);
packet(SMSG_PLAYER_STAT_UPDATE_2,          0x00b1,   8, &Ea::PlayerRecv::processPlayerStatUpdate2);
packet(SMSG_PLAYER_STAT_UPDATE_3,          0x0141,  14, &Ea::PlayerRecv::processPlayerStatUpdate3);
packet(SMSG_PLAYER_STAT_UPDATE_4,          0x00bc,   6, &Ea::PlayerRecv::processPlayerStatUpdate4);
packet(SMSG_PLAYER_STAT_UPDATE_5,          0x00bd,  44, &PlayerRecv::processPlayerStatUpdate5);
packet(SMSG_PLAYER_STAT_UPDATE_6,          0x00be,   5, &Ea::PlayerRecv::processPlayerStatUpdate6);
packet(SMSG_PLAYER_STOP,                   0x0088,  10, &Ea::BeingRecv::processPlayerStop);
packet(SMSG_PLAYER_STORAGE_ADD,            0x01c4,  22, &InventoryRecv::processPlayerStorageAdd);
packet(SMSG_PLAYER_STORAGE_ADD_OUTDATED,   0x00f4,  21, nullptr);
packet(SMSG_PLAYER_STORAGE_CLOSE,          0x00f8,   2, &Ea::InventoryRecv::processPlayerStorageClose);
packet(SMSG_PLAYER_STORAGE_EQUIP,          0x0996,  -1, &InventoryRecv::processPlayerStorageEquip);
packet(SMSG_PLAYER_STORAGE_ITEMS,          0x0995,  -1, &InventoryRecv::processPlayerStorage);
packet(SMSG_PLAYER_STORAGE_PASSWORD,       0x023a,   4, &InventoryRecv::processPlayerStoragePassword);
packet(SMSG_PLAYER_STORAGE_PASSWORD_RESULT, 0x023c,   6, &InventoryRecv::processPlayerStoragePasswordResult);
packet(SMSG_PLAYER_STORAGE_REMOVE,         0x00f6,   8, &InventoryRecv::processPlayerStorageRemove);
packet(SMSG_PLAYER_STORAGE_STATUS,         0x00f2,   6, &Ea::InventoryRecv::processPlayerStorageStatus);
packet(SMSG_PLAYER_UNEQUIP,                0x099a,   9, &InventoryRecv::processPlayerUnEquip);
packet(SMSG_PLAYER_UPDATE_SKILL,           0x07e1,  15, &SkillRecv::processSkillUpdate);
packet(SMSG_PLAYER_UPGRADE_MESSAGE,        0x0223,   8, &PlayerRecv::processPlayerUpgradeMessage);
packet(SMSG_PLAYER_USE_CARD,               0x017b,  -1, &InventoryRecv::processPlayerUseCard);
packet(SMSG_PLAYER_WARP,                   0x0091,  22, &Ea::PlayerRecv::processPlayerWarp);
packet(SMSG_PVP_INFO,                      0x0210,  22, &PlayerRecv::processPvpInfo);
packet(SMSG_PVP_MAP_MODE,                  0x0199,   4, &Ea::BeingRecv::processPvpMapMode);
packet(SMSG_PVP_SET,                       0x019a,  14, &BeingRecv::processPvpSet);
packet(SMSG_QUEST_ACTIVATE,                0x02b7,   7, &QuestRecv::processActivateQuest);
packet(SMSG_QUEST_ADD,                     0x02b3, 107, &QuestRecv::processAddQuest);
packet(SMSG_QUEST_LIST,                    0x097a,  -1, &QuestRecv::processAddQuests);
packet(SMSG_QUEST_LIST_OBJECTIVES,         0x02b2,  -1, &QuestRecv::processAddQuestsObjectives);
packet(SMSG_QUEST_LIST_OUTDATED,           0x02b1,  -1, nullptr);
packet(SMSG_QUEST_NPC_EFFECT,              0x0446,  14, &QuestRecv::processNpcQuestEffect);
packet(SMSG_QUEST_REMOVE,                  0x02b4,   6, &QuestRecv::processRemoveQuest);
packet(SMSG_QUEST_UPDATE_OBJECTIVES,       0x02b5,  -1, &QuestRecv::processUpdateQuestsObjectives);
packet(SMSG_RANKS_LIST,                    0x097d, 288, &BeingRecv::processRanksList);
packet(SMSG_ROULETTE_GENERATE_ACK_TYPE,    0x0a20,  21, &RouletteRecv::processRouletteGenerateAckType);
packet(SMSG_ROULETTE_INFO_ACK_TYPE,        0x0a1c, 344, &RouletteRecv::processRouletteInfoAckType);
packet(SMSG_ROULETTE_OPEN_ACK,             0x0a1a,  23, &RouletteRecv::processRouletteOpenAck);
packet(SMSG_ROULETTE_RECV_ITEM_ACK,        0x0a22,   5, &RouletteRecv::processRouletteItemAck);
packet(SMSG_SCRIPT_MESSAGE,                0x08b3,  -1, &ChatRecv::processScriptMessage);
packet(SMSG_SEARCHSTORE_CLICK_ACK,         0x083d,   6, &SearchStoreRecv::processSearchClickAck);
packet(SMSG_SEARCHSTORE_OPEN,              0x083a,   5, &SearchStoreRecv::processSearchOpen);
packet(SMSG_SEARCHSTORE_SEARCH_ACK,        0x0836,   0, &SearchStoreRecv::processSearchAck);
packet(SMSG_SEARCHSTORE_SEARCH_FAILED,     0x0837,   0, &SearchStoreRecv::processSearchFailed);
packet(SMSG_SERVER_PING,                   0x007f,   6, &GameRecv::processServerTick);
packet(SMSG_SERVER_VERSION_RESPONSE,       0x7531,  -1, &LoginRecv::processServerVersion);
packet(SMSG_SKILL_ARROW_CREATE_LIST,       0x01ad,  -1, &SkillRecv::processSkillArrowCreateList);
packet(SMSG_SKILL_AUTO_CAST,               0x0147,  39, &BeingRecv::processSkillAutoCast);
packet(SMSG_SKILL_CASTING,                 0x07fb,  25, &BeingRecv::processSkillCasting);
packet(SMSG_SKILL_CAST_CANCEL,             0x01b9,   6, &BeingRecv::processSkillCancel);
packet(SMSG_SKILL_DAMAGE,                  0x01de,  33, &Ea::BeingRecv::processSkillDamage);
packet(SMSG_SKILL_DAMAGE_OUTDATED,         0x0114,  31, nullptr);
packet(SMSG_SKILL_DEVOTION_EFFECT,         0x01cf,  28, &SkillRecv::processSkillDevotionEffect);
packet(SMSG_SKILL_ENTRY,                   0x09ca,  -1, &BeingRecv::processSkillEntry);
packet(SMSG_SKILL_FAILED,                  0x0110,  10, &SkillRecv::processSkillFailed);
packet(SMSG_SKILL_GROUND_DAMAGE_UNUSED,    0x0115,  35, nullptr);
packet(SMSG_SKILL_GROUND_NO_DAMAGE,        0x0117,  18, &BeingRecv::processSkillGroundNoDamage);
packet(SMSG_SKILL_ITEM_LIST_WINDOW,        0x07e3,   6, &SkillRecv::processSkillItemListWindow);
packet(SMSG_SKILL_MEMO_MESSAGE,            0x011e,   3, &SkillRecv::processSkillMemoMessage);
packet(SMSG_SKILL_NO_DAMAGE,               0x011a,  15, &Ea::BeingRecv::processSkillNoDamage);
packet(SMSG_SKILL_SNAP,                    0x08d2,  10, &BeingRecv::processBeingSlide);
packet(SMSG_SKILL_UNIT_UPDATE,             0x01ac,   6, &SkillRecv::processSkillUnitUpdate);
packet(SMSG_SKILL_WARP_POINT,              0x011c,  68, &SkillRecv::processSkillWarpPoint);
packet(SMSG_SOLVE_CHAR_NAME,               0x0194,  30, &BeingRecv::processSolveCharName);
packet(SMSG_SPIRIT_BALLS,                  0x01d0,   8, &BeingRecv::processSpiritBalls);
packet(SMSG_SPIRIT_BALL_SINGLE,            0x01e1,   8, &BeingRecv::processSpiritBalls);
packet(SMSG_STARS_KILL,                    0x020e,  32, &BeingRecv::processStarsKill);
packet(SMSG_TAEKWON_RANKS_LIST,            0x0226, 282, &BeingRecv::processTaekwonRanksList);
packet(SMSG_TRADE_CANCEL,                  0x00ee,   2, &Ea::TradeRecv::processTradeCancel);
packet(SMSG_TRADE_COMPLETE,                0x00f0,   3, &Ea::TradeRecv::processTradeComplete);
packet(SMSG_TRADE_ITEM_ADD,                0x080f,  20, &TradeRecv::processTradeItemAdd);
packet(SMSG_TRADE_ITEM_ADD_RESPONSE,       0x00ea,   5, &TradeRecv::processTradeItemAddResponse);
packet(SMSG_TRADE_OK,                      0x00ec,   3, &Ea::TradeRecv::processTradeOk);
packet(SMSG_TRADE_REQUEST,                 0x01f4,  32, &TradeRecv::processTradeRequest);
packet(SMSG_TRADE_REQUEST_OUTDATED,        0x00e5,  26, nullptr);
packet(SMSG_TRADE_RESPONSE,                0x01f5,   9, &TradeRecv::processTradeResponse);
packet(SMSG_TRADE_RESPONSE_OUTDATED,       0x00e7,   3, nullptr);
packet(SMSG_TRADE_UNDO,                    0x00f1,   2, &TradeRecv::processTradeUndo);
packet(SMSG_UPDATE_HOST,                   0x0063,  -1, &Ea::LoginRecv::processUpdateHost);
packet(SMSG_VENDING_BUY_ACK,               0x0135,   7, &VendingRecv::processBuyAck);
packet(SMSG_VENDING_HIDE_BOARD,            0x0132,   6, &VendingRecv::processHideBoard);
packet(SMSG_VENDING_ITEMS_LIST,            0x0800,  -1, &VendingRecv::processItemsList);
packet(SMSG_VENDING_OPEN,                  0x0136,  -1, &VendingRecv::processOpen);
packet(SMSG_VENDING_OPEN_REQ,              0x012d,   4, &VendingRecv::processOpenReq);
packet(SMSG_VENDING_OPEN_STATUS,           0x0a28,   3, &VendingRecv::processOpenStatus);
packet(SMSG_VENDING_REPORT,                0x0137,   6, &VendingRecv::processReport);
packet(SMSG_VENDING_SHOW_BOARD,            0x0131,  86, &VendingRecv::processShowBoard);
packet(SMSG_WALK_RESPONSE,                 0x0087,  12, &PlayerRecv::processWalkResponse);
packet(SMSG_WEDDING_EFFECT,                0x01ea,   6, &BeingRecv::processWddingEffect);
packet(SMSG_WHISPER,                       0x0097,  -1, &ChatRecv::processWhisper);
packet(SMSG_WHISPER_RESPONSE,              0x09df,   7, &ChatRecv::processWhisperResponse);
packet(SMSG_WHO_ANSWER,                    0x00c2,   6, &Ea::GameRecv::processWhoAnswer);

// 20150000 fix
if (serverVersion >= 11)
{
    packet(SMSG_BEING_VISIBLE,                 0x09dd,  -1, &BeingRecv::processBeingVisible);
    packet(SMSG_BEING_ACTION2,                 0x08c8,  34, &BeingRecv::processBeingAction2);
    packet(SMSG_BEING_SPAWN,                   0x09dc,  -1, &BeingRecv::processBeingSpawn);
    packet(SMSG_BEING_MOVE,                    0x09db,  -1, &BeingRecv::processBeingMove);
}

if (serverVersion >= 8 && packetVersion >= 20150226)
{
    packet(SMSG_VENDING_OPEN,                  0x0136,  -1, &VendingRecv::processOpen);
    packet(SMSG_VENDING_ITEMS_LIST,            0x0800,  -1, &VendingRecv::processItemsList);

    packet(SMSG_TRADE_ITEM_ADD,                0x0a09,  45, &TradeRecv::processTradeItemAdd);
    packet(SMSG_PLAYER_STORAGE_ADD,            0x0a0a,  47, &InventoryRecv::processPlayerStorageAdd);
    packet(SMSG_PLAYER_CART_ADD,               0x0a0b,  47, &InventoryRecv::processPlayerCartAdd);
    packet(SMSG_PLAYER_INVENTORY_ADD,          0x0a0c,  56, &InventoryRecv::processPlayerInventoryAdd);
    packet(SMSG_PLAYER_EQUIPMENT,              0x0a0d,  -1, &InventoryRecv::processPlayerEquipment);
    packet(SMSG_PLAYER_CART_EQUIP,             0x0a0f,  -1, &InventoryRecv::processPlayerCartEquip);
    packet(SMSG_PLAYER_STORAGE_EQUIP,          0x0a10,  -1, &InventoryRecv::processPlayerStorageEquip);
    packet(SMSG_BEING_VIEW_EQUIPMENT,          0x0a2d,  -1, &BeingRecv::processBeingViewEquipment);
}

// partial implimentation for future use
if (packetVersion >= 20150513)
{
    packet(SMSG_DRESS_ROOM_OPEN,               0x0a02,   4, &PlayerRecv::processDressRoomOpen);
    packet(SMSG_BEING_VISIBLE,                 0x09ff,  -1, &BeingRecv::processBeingVisible);
    packet(SMSG_BEING_SPAWN,                   0x09fe,  -1, &BeingRecv::processBeingSpawn);
    packet(SMSG_BEING_MOVE,                    0x09fd,  -1, &BeingRecv::processBeingMove);
}

// introduced in 20150805
packet(SMSG_SELECT_CART,                   0x00c2,  -1, &InventoryRecv::processSelectCart);
