/*
 *  Custom keyboard shortcuts configuration
 *  Copyright (C) 2007  Joshua Langley <joshlangley@optusnet.com.au>
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2013  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INPUT_KEYBOARDDATA_H
#define INPUT_KEYBOARDDATA_H

#include "actionmanager.h"
#include "localconsts.h"

#include "input/inputmanager.h"

#include "utils/gettext.h"

#include <string>

// keyData must be in same order as enum keyAction.
static const KeyData keyData[Input::KEY_TOTAL] = {
    {"keyMoveUp",
        INPUT_KEYBOARD, SDLK_UP,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveUp,
        Input::KEY_NO_VALUE, 50,
        COND_GAME2},
    {"keyMoveDown",
        INPUT_KEYBOARD, SDLK_DOWN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveDown,
        Input::KEY_NO_VALUE, 50,
        COND_GAME2},
    {"keyMoveLeft",
        INPUT_KEYBOARD, SDLK_LEFT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveLeft,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyMoveRight",
        INPUT_KEYBOARD, SDLK_RIGHT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveRight,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyAttack",
        INPUT_KEYBOARD, SDLK_LCTRL,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &ActionManager::attack,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOFOLLOW | COND_VALIDSPEED},
    {"keyTargetAttack",
        INPUT_KEYBOARD, SDLK_x,
        INPUT_JOYSTICK, 0,
        Input::GRP_DEFAULT,
        &ActionManager::targetAttack,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOFOLLOW | COND_VALIDSPEED},
    {"keyMoveToTarget",
        INPUT_KEYBOARD, SDLK_v,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveToTarget,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyChangeMoveToTarget",
        INPUT_KEYBOARD, SDLK_PERIOD,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMoveToTarget,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyMoveToHome",
        INPUT_KEYBOARD, SDLK_d,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveToHome,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keySetHome",
        INPUT_KEYBOARD, SDLK_KP5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::setHome,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyMoveToPoint",
        INPUT_KEYBOARD, SDLK_RSHIFT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyTalk",
        INPUT_KEYBOARD, SDLK_t,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::talk,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyTarget",
        INPUT_KEYBOARD, SDLK_LSHIFT,
        INPUT_JOYSTICK, 4,
        Input::GRP_DEFAULT,
        &ActionManager::stopAttack,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyUnTarget",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::untarget,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyTargetMonster",
        INPUT_KEYBOARD, SDLK_a,
        INPUT_JOYSTICK, 3,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &ActionManager::targetMonster,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET | COND_VALIDSPEED},
    {"keyTargetNPC",
        INPUT_KEYBOARD, SDLK_n,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::targetNPC,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyTargetPlayer",
        INPUT_KEYBOARD, SDLK_q,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::targetPlayer,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyPickup",
        INPUT_KEYBOARD, SDLK_z,
        INPUT_JOYSTICK, 1,
        Input::GRP_DEFAULT,
        &ActionManager::pickup,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyChangePickupType",
        INPUT_KEYBOARD, SDLK_o,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changePickupType,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyHideWindows",
        INPUT_KEYBOARD, SDLK_h,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::hideWindows,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyBeingSit",
        INPUT_KEYBOARD, SDLK_s,
        INPUT_JOYSTICK, 2,
        Input::GRP_DEFAULT,
        &ActionManager::sit,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyScreenshot",
        INPUT_KEYBOARD, SDLK_p,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::screenshot,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyTrade",
        INPUT_KEYBOARD, SDLK_r,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeTrade,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyPathfind",
        INPUT_KEYBOARD, SDLK_f,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMapMode,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET | COND_EMODS},
    {"keyOK",
        INPUT_KEYBOARD, SDLK_SPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::ok,
        Input::KEY_NO_VALUE, 50,
        COND_NOMODAL | COND_NOAWAY | COND_NONPCINPUT},
    {"keyQuit",
        INPUT_KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        INPUT_KEYBOARD, SDLK_AC_BACK,
#else
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
#endif
        Input::GRP_DEFAULT,
        &ActionManager::quit,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyShortcutsKey",
        INPUT_KEYBOARD, SDLK_MENU,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyShortcut1",
        INPUT_KEYBOARD, SDLK_1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut2",
        INPUT_KEYBOARD, SDLK_2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut3",
        INPUT_KEYBOARD, SDLK_3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut4",
        INPUT_KEYBOARD, SDLK_4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut5",
        INPUT_KEYBOARD, SDLK_5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut6",
        INPUT_KEYBOARD, SDLK_6,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut7",
        INPUT_KEYBOARD, SDLK_7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut8",
        INPUT_KEYBOARD, SDLK_8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut9",
        INPUT_KEYBOARD, SDLK_9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut10",
        INPUT_KEYBOARD, SDLK_0,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut11",
        INPUT_KEYBOARD, SDLK_MINUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut12",
        INPUT_KEYBOARD, SDLK_EQUALS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut13",
        INPUT_KEYBOARD, SDLK_BACKSPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut14",
        INPUT_KEYBOARD, SDLK_INSERT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut15",
        INPUT_KEYBOARD, SDLK_HOME,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut16",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut17",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut18",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut19",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyShortcut20",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::shortcut,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT},
    {"keyWindowHelp",
        INPUT_KEYBOARD, SDLK_F1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::helpWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT0},
    {"keyWindowStatus",
        INPUT_KEYBOARD, SDLK_F2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::statusWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowInventory",
        INPUT_KEYBOARD, SDLK_F3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::inventoryWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowEquipment",
        INPUT_KEYBOARD, SDLK_F4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::equipmentWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowSkill",
        INPUT_KEYBOARD, SDLK_F5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::skillDialogShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowMinimap",
        INPUT_KEYBOARD, SDLK_F6,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::minimapWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowChat",
        INPUT_KEYBOARD, SDLK_F7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::chatWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowShortcut",
        INPUT_KEYBOARD, SDLK_F8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::shortcutWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowSetup",
        INPUT_KEYBOARD, SDLK_F9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::setupWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_NOTARGET | COND_NOINPUT | COND_ENABLED},
    {"keyWindowDebug",
        INPUT_KEYBOARD, SDLK_F10,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::debugWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowSocial",
        INPUT_KEYBOARD, SDLK_F11,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::socialWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowEmoteBar",
        INPUT_KEYBOARD, SDLK_F12,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::emoteShortcutWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowOutfit",
        INPUT_KEYBOARD, SDLK_BACKQUOTE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::outfitWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowShop",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::shopWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowDrop",
        INPUT_KEYBOARD, SDLK_w,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::dropShortcutWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowKills",
        INPUT_KEYBOARD, SDLK_e,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::killStatsWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowSpells",
        INPUT_KEYBOARD, SDLK_j,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::spellShortcutWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowBotChecker",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::botcheckerWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowOnline",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::whoIsOnlineWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keyWindowDidYouKnow",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::didYouKnowWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_SHORTCUT0},
    {"keyWindowQuests",
        INPUT_KEYBOARD, SDLK_LEFTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::questsWindowShow,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_NOTARGET},
    {"keySocialPrevTab",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevSocialTab,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_INGAME},
    {"keySocialNextTab",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextSocialTab,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_INGAME},
    {"keySmilie",
        INPUT_KEYBOARD, SDLK_LALT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyEmoteShortcut1",
        INPUT_KEYBOARD, SDLK_1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut2",
        INPUT_KEYBOARD, SDLK_2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut3",
        INPUT_KEYBOARD, SDLK_3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut4",
        INPUT_KEYBOARD, SDLK_4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut5",
        INPUT_KEYBOARD, SDLK_5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut6",
        INPUT_KEYBOARD, SDLK_6,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut7",
        INPUT_KEYBOARD, SDLK_7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut8",
        INPUT_KEYBOARD, SDLK_8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut9",
        INPUT_KEYBOARD, SDLK_9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut10",
        INPUT_KEYBOARD, SDLK_0,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut11",
        INPUT_KEYBOARD, SDLK_MINUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut12",
        INPUT_KEYBOARD, SDLK_EQUALS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut13",
        INPUT_KEYBOARD, SDLK_BACKSPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut14",
        INPUT_KEYBOARD, SDLK_INSERT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut15",
        INPUT_KEYBOARD, SDLK_HOME,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut16",
        INPUT_KEYBOARD, SDLK_q,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut17",
        INPUT_KEYBOARD, SDLK_w,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut18",
        INPUT_KEYBOARD, SDLK_e,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut19",
        INPUT_KEYBOARD, SDLK_r,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut20",
        INPUT_KEYBOARD, SDLK_t,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut21",
        INPUT_KEYBOARD, SDLK_y,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut22",
        INPUT_KEYBOARD, SDLK_u,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut23",
        INPUT_KEYBOARD, SDLK_i,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut24",
        INPUT_KEYBOARD, SDLK_o,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut25",
        INPUT_KEYBOARD, SDLK_p,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut26",
        INPUT_KEYBOARD, SDLK_LEFTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut27",
        INPUT_KEYBOARD, SDLK_RIGHTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut28",
        INPUT_KEYBOARD, SDLK_BACKSLASH,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut29",
        INPUT_KEYBOARD, SDLK_a,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut30",
        INPUT_KEYBOARD, SDLK_s,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut31",
        INPUT_KEYBOARD, SDLK_d,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut32",
        INPUT_KEYBOARD, SDLK_f,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut33",
        INPUT_KEYBOARD, SDLK_g,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut34",
        INPUT_KEYBOARD, SDLK_h,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut35",
        INPUT_KEYBOARD, SDLK_j,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut36",
        INPUT_KEYBOARD, SDLK_k,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut37",
        INPUT_KEYBOARD, SDLK_l,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut38",
        INPUT_KEYBOARD, SDLK_SEMICOLON,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut39",
        INPUT_KEYBOARD, SDLK_QUOTE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut40",
        INPUT_KEYBOARD, SDLK_z,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut41",
        INPUT_KEYBOARD, SDLK_x,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut42",
        INPUT_KEYBOARD, SDLK_c,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut43",
        INPUT_KEYBOARD, SDLK_v,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut44",
        INPUT_KEYBOARD, SDLK_b,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut45",
        INPUT_KEYBOARD, SDLK_n,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut46",
        INPUT_KEYBOARD, SDLK_m,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut47",
        INPUT_KEYBOARD, SDLK_COMMA,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyEmoteShortcut48",
        INPUT_KEYBOARD, SDLK_PERIOD,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_EMOTION,
        &ActionManager::emote,
        Input::KEY_EMOTE, 100,
        COND_GAME},
    {"keyWearOutfit",
        INPUT_KEYBOARD, SDLK_RCTRL,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyCopyOutfit",
        INPUT_KEYBOARD, SDLK_RALT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyCopyEquipedOutfit",
        INPUT_KEYBOARD, SDLK_RIGHTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::copyEquippedToOutfit,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyOutfitShortcut1",
        INPUT_KEYBOARD, SDLK_1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut2",
        INPUT_KEYBOARD, SDLK_2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut3",
        INPUT_KEYBOARD, SDLK_3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut4",
        INPUT_KEYBOARD, SDLK_4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut5",
        INPUT_KEYBOARD, SDLK_5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut6",
        INPUT_KEYBOARD, SDLK_6,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut7",
        INPUT_KEYBOARD, SDLK_7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut8",
        INPUT_KEYBOARD, SDLK_8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut9",
        INPUT_KEYBOARD, SDLK_9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut10",
        INPUT_KEYBOARD, SDLK_0,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut11",
        INPUT_KEYBOARD, SDLK_MINUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut12",
        INPUT_KEYBOARD, SDLK_EQUALS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut13",
        INPUT_KEYBOARD, SDLK_BACKSPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut14",
        INPUT_KEYBOARD, SDLK_INSERT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut15",
        INPUT_KEYBOARD, SDLK_HOME,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut16",
        INPUT_KEYBOARD, SDLK_q,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut17",
        INPUT_KEYBOARD, SDLK_w,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut18",
        INPUT_KEYBOARD, SDLK_e,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut19",
        INPUT_KEYBOARD, SDLK_r,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut20",
        INPUT_KEYBOARD, SDLK_t,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut21",
        INPUT_KEYBOARD, SDLK_y,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut22",
        INPUT_KEYBOARD, SDLK_u,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut23",
        INPUT_KEYBOARD, SDLK_i,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut24",
        INPUT_KEYBOARD, SDLK_o,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut25",
        INPUT_KEYBOARD, SDLK_p,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut26",
        INPUT_KEYBOARD, SDLK_LEFTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut27",
        INPUT_KEYBOARD, SDLK_RIGHTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut28",
        INPUT_KEYBOARD, SDLK_BACKSLASH,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut29",
        INPUT_KEYBOARD, SDLK_a,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut30",
        INPUT_KEYBOARD, SDLK_s,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut31",
        INPUT_KEYBOARD, SDLK_d,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut32",
        INPUT_KEYBOARD, SDLK_f,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut33",
        INPUT_KEYBOARD, SDLK_g,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut34",
        INPUT_KEYBOARD, SDLK_h,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut35",
        INPUT_KEYBOARD, SDLK_j,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut36",
        INPUT_KEYBOARD, SDLK_k,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut37",
        INPUT_KEYBOARD, SDLK_l,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut38",
        INPUT_KEYBOARD, SDLK_SEMICOLON,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut39",
        INPUT_KEYBOARD, SDLK_QUOTE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut40",
        INPUT_KEYBOARD, SDLK_z,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut41",
        INPUT_KEYBOARD, SDLK_x,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut42",
        INPUT_KEYBOARD, SDLK_c,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut43",
        INPUT_KEYBOARD, SDLK_v,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut44",
        INPUT_KEYBOARD, SDLK_b,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut45",
        INPUT_KEYBOARD, SDLK_n,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut46",
        INPUT_KEYBOARD, SDLK_m,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut47",
        INPUT_KEYBOARD, SDLK_COMMA,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyOutfitShortcut48",
        INPUT_KEYBOARD, SDLK_PERIOD,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_OUTFIT,
        &ActionManager::outfit,
        Input::KEY_NO_VALUE, 100,
        COND_GAME},
    {"keyMoveToPointShortcut1",
        INPUT_KEYBOARD, SDLK_1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut2",
        INPUT_KEYBOARD, SDLK_2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut3",
        INPUT_KEYBOARD, SDLK_3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut4",
        INPUT_KEYBOARD, SDLK_4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut5",
        INPUT_KEYBOARD, SDLK_5,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut6",
        INPUT_KEYBOARD, SDLK_6,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut7",
        INPUT_KEYBOARD, SDLK_7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut8",
        INPUT_KEYBOARD, SDLK_8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut9",
        INPUT_KEYBOARD, SDLK_9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut10",
        INPUT_KEYBOARD, SDLK_0,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut11",
        INPUT_KEYBOARD, SDLK_MINUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut12",
        INPUT_KEYBOARD, SDLK_EQUALS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut13",
        INPUT_KEYBOARD, SDLK_BACKSPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut14",
        INPUT_KEYBOARD, SDLK_INSERT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut15",
        INPUT_KEYBOARD, SDLK_HOME,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut16",
        INPUT_KEYBOARD, SDLK_q,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut17",
        INPUT_KEYBOARD, SDLK_w,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut18",
        INPUT_KEYBOARD, SDLK_e,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut19",
        INPUT_KEYBOARD, SDLK_r,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut20",
        INPUT_KEYBOARD, SDLK_t,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut21",
        INPUT_KEYBOARD, SDLK_y,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut22",
        INPUT_KEYBOARD, SDLK_u,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut23",
        INPUT_KEYBOARD, SDLK_i,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut24",
        INPUT_KEYBOARD, SDLK_o,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut25",
        INPUT_KEYBOARD, SDLK_p,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut26",
        INPUT_KEYBOARD, SDLK_LEFTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut27",
        INPUT_KEYBOARD, SDLK_RIGHTBRACKET,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut28",
        INPUT_KEYBOARD, SDLK_BACKSLASH,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut29",
        INPUT_KEYBOARD, SDLK_a,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut30",
        INPUT_KEYBOARD, SDLK_s,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut31",
        INPUT_KEYBOARD, SDLK_d,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut32",
        INPUT_KEYBOARD, SDLK_f,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut33",
        INPUT_KEYBOARD, SDLK_g,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut34",
        INPUT_KEYBOARD, SDLK_h,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut35",
        INPUT_KEYBOARD, SDLK_j,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut36",
        INPUT_KEYBOARD, SDLK_k,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut37",
        INPUT_KEYBOARD, SDLK_l,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut38",
        INPUT_KEYBOARD, SDLK_SEMICOLON,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut39",
        INPUT_KEYBOARD, SDLK_QUOTE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut40",
        INPUT_KEYBOARD, SDLK_z,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut41",
        INPUT_KEYBOARD, SDLK_x,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut42",
        INPUT_KEYBOARD, SDLK_c,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut43",
        INPUT_KEYBOARD, SDLK_v,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut44",
        INPUT_KEYBOARD, SDLK_b,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut45",
        INPUT_KEYBOARD, SDLK_n,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut46",
        INPUT_KEYBOARD, SDLK_m,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut47",
        INPUT_KEYBOARD, SDLK_COMMA,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyMoveToPointShortcut48",
        INPUT_KEYBOARD, SDLK_PERIOD,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &ActionManager::moveToPoint,
        Input::KEY_MOVE_TO_POINT, 100,
        COND_GAME},
    {"keyChat",
        INPUT_KEYBOARD, SDLK_RETURN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_CHAT,
        &ActionManager::toggleChat,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_NOAWAY | COND_NOMODAL | COND_INGAME},
    {"keyChatScrollUp",
        INPUT_KEYBOARD, SDLK_PAGEUP,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::scrollChatUp,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyChatScrollDown",
        INPUT_KEYBOARD, SDLK_PAGEDOWN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::scrollChatDown,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyChatPrevTab",
        INPUT_KEYBOARD, SDLK_KP7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::prevChatTab,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_INGAME},
    {"keyChatNextTab",
        INPUT_KEYBOARD, SDLK_KP9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::nextChatTab,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_INGAME},
    {"keyChatCloseTab",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &ActionManager::closeChatTab,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_INGAME},
    {"keyChatPrevHistory",
        INPUT_KEYBOARD, SDLK_KP7,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyChatNextHistory",
        INPUT_KEYBOARD, SDLK_KP9,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyIgnoreInput1",
#ifdef USE_SDL2
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
#else
        INPUT_KEYBOARD, SDLK_LSUPER,
#endif
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::ignoreInput,
        Input::KEY_NO_VALUE, 500,
        COND_DEFAULT},
    {"keyIgnoreInput2",
#ifdef USE_SDL2
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
#else
        INPUT_KEYBOARD, SDLK_RSUPER,
#endif
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::ignoreInput,
        Input::KEY_NO_VALUE, 500,
        COND_DEFAULT},
    {"keyDirectUp",
        INPUT_KEYBOARD, SDLK_l,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directUp,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyDirectDown",
        INPUT_KEYBOARD, SDLK_SEMICOLON,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directDown,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyDirectLeft",
        INPUT_KEYBOARD, SDLK_k,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directLeft,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyDirectRight",
        INPUT_KEYBOARD, SDLK_QUOTE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::directRight,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyCrazyMoves",
        INPUT_KEYBOARD, SDLK_SLASH,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::crazyMoves,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyChangeCrazyMoveType",
        INPUT_KEYBOARD, SDLK_BACKSLASH,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeCrazyMove,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyQuickDrop",
        INPUT_KEYBOARD, SDLK_y,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::dropItem0,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyQuickDropN",
        INPUT_KEYBOARD, SDLK_u,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::dropItem,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keySwitchQuickDrop",
        INPUT_KEYBOARD, SDLK_i,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::switchQuickDrop,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyMagicInma1",
        INPUT_KEYBOARD, SDLK_c,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::heal,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyMagicItenplz",
        INPUT_KEYBOARD, SDLK_m,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::itenplz,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyMagicAttack",
        INPUT_KEYBOARD, SDLK_b,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::magicAttack,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keySwitchMagicAttack",
        INPUT_KEYBOARD, SDLK_COMMA,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMagicAttack,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keySwitchPvpAttack",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changePvpMode,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyInvertDirection",
        INPUT_KEYBOARD, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeMoveType,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyChangeAttackWeaponType",
        INPUT_KEYBOARD, SDLK_g,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAttackWeaponType,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyChangeAttackType",
        INPUT_KEYBOARD, SDLK_END,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAttackType,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyChangeFollowMode",
        INPUT_KEYBOARD, SDLK_KP1,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeFollowMode,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyChangeImitationMode",
        INPUT_KEYBOARD, SDLK_KP4,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeImitationMode,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyDisableGameModifiers",
        INPUT_KEYBOARD, SDLK_KP8,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeGameModifier,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyChangeAudio",
        INPUT_KEYBOARD, SDLK_KP3,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::changeAudio,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyAway",
        INPUT_KEYBOARD, SDLK_KP2,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::away,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED},
    {"keyRightClick",
        INPUT_KEYBOARD, SDLK_TAB,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::mouseClick,
        Input::KEY_NO_VALUE, 50,
        COND_NOINPUT | COND_NOAWAY | COND_NOMODAL | COND_INGAME},
    {"keyCameraMode",
        INPUT_KEYBOARD, SDLK_KP_PLUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::camera,
        Input::KEY_NO_VALUE, 50,
        COND_GAME | COND_VALIDSPEED | COND_EMODS},
    {"keyMod",
        INPUT_KEYBOARD, SDLK_LSHIFT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUI,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIUp",
        INPUT_KEYBOARD, SDLK_UP,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIDown",
        INPUT_KEYBOARD, SDLK_DOWN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUILeft",
        INPUT_KEYBOARD, SDLK_LEFT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIRight",
        INPUT_KEYBOARD, SDLK_RIGHT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUISelect",
        INPUT_KEYBOARD, SDLK_SPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUISelect2",
        INPUT_KEYBOARD, SDLK_RETURN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUICancel",
        INPUT_KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        INPUT_KEYBOARD, SDLK_AC_BACK,
#else
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
#endif
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIHome",
        INPUT_KEYBOARD, SDLK_HOME,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIEnd",
        INPUT_KEYBOARD, SDLK_END,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIDelete",
        INPUT_KEYBOARD, SDLK_DELETE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIBackSpace",
        INPUT_KEYBOARD, SDLK_BACKSPACE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUITab",
        INPUT_KEYBOARD, SDLK_TAB,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIPageUp",
        INPUT_KEYBOARD, SDLK_PAGEUP,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIPageDown",
        INPUT_KEYBOARD, SDLK_PAGEDOWN,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIInsert",
        INPUT_KEYBOARD, SDLK_INSERT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIMod",
        INPUT_KEYBOARD, SDLK_LSHIFT,
        INPUT_KEYBOARD, SDLK_RSHIFT,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keySafeVideo",
        INPUT_KEYBOARD, SDLK_KP_MINUS,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::safeVideoMode,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyStopSit",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::stopSit,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyShowKeyboard",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::showKeyboard,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyShowWindows",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::showWindows,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyChatMod",
        INPUT_KEYBOARD, SDLK_LSHIFT,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_CHAT,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT | COND_INGAME},
    {"keyMoveForward",
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_DEFAULT,
        &ActionManager::moveForward,
        Input::KEY_NO_VALUE, 50,
        COND_GAME},
    {"keyGUICtrl",
        INPUT_KEYBOARD, SDLK_LCTRL,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIb",
        INPUT_KEYBOARD, SDLK_b,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIc",
        INPUT_KEYBOARD, SDLK_c,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUId",
        INPUT_KEYBOARD, SDLK_d,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIe",
        INPUT_KEYBOARD, SDLK_e,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIf",
        INPUT_KEYBOARD, SDLK_f,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIh",
        INPUT_KEYBOARD, SDLK_h,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIk",
        INPUT_KEYBOARD, SDLK_k,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIu",
        INPUT_KEYBOARD, SDLK_u,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIv",
        INPUT_KEYBOARD, SDLK_v,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT},
    {"keyGUIw",
        INPUT_KEYBOARD, SDLK_w,
        INPUT_UNKNOWN, Input::KEY_NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        Input::KEY_NO_VALUE, 50,
        COND_DEFAULT}
};

#endif  // INPUT_KEYBOARDDATA_H
