/*      _______   __   __   __   ______   __   __   _______   __   __
 *     / _____/\ / /\ / /\ / /\ / ____/\ / /\ / /\ / ___  /\ /  |\/ /\
 *    / /\____\// / // / // / // /\___\// /_// / // /\_/ / // , |/ / /
 *   / / /__   / / // / // / // / /    / ___  / // ___  / // /| ' / /
 *  / /_// /\ / /_// / // / // /_/_   / / // / // /\_/ / // / |  / /
 * /______/ //______/ //_/ //_____/\ /_/ //_/ //_/ //_/ //_/ /|_/ /
 * \______\/ \______\/ \_\/ \_____\/ \_\/ \_\/ \_\/ \_\/ \_\/ \_\/
 *
 * Copyright (c) 2004 - 2008 Olof Naessn and Per Larsson
 * Copyright (C) 2011-2013  The ManaPlus Developers
 *
 *
 * Per Larsson a.k.a finalman
 * Olof Naessn a.k.a jansem/yakslem
 *
 * Visit: http://guichan.sourceforge.net
 *
 * License: (BSD)
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of Guichan nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * For comments regarding functions please see the header file.
 */

#include "guichan/keyinput.hpp"

#include "debug.h"

namespace gcn
{
    KeyInput::KeyInput(const Key& key, unsigned int type) :
             mKey(key),
             mType(type),
             mShiftPressed(false),
             mControlPressed(false),
             mAltPressed(false),
             mMetaPressed(false),
             mNumericPad(false)
    {
    }

    void KeyInput::setType(unsigned int type)
    {
        mType = type;
    }

    int KeyInput::getType() const
    {
        return mType;
    }

    void KeyInput::setKey(const Key& key)
    {
        mKey = key;
    }

    const Key& KeyInput::getKey() const
    {
        return mKey;
    }

    bool KeyInput::isShiftPressed() const
    {
        return mShiftPressed;
    }

    void KeyInput::setShiftPressed(bool pressed)
    {
        mShiftPressed = pressed;
    }

    bool KeyInput::isControlPressed() const
    {
        return mControlPressed;
    }

    void KeyInput::setControlPressed(bool pressed)
    {
        mControlPressed = pressed;
    }

    bool KeyInput::isAltPressed() const
    {
        return mAltPressed;
    }

    void KeyInput::setAltPressed(bool pressed)
    {
        mAltPressed = pressed;
    }

    bool KeyInput::isMetaPressed() const
    {
        return mMetaPressed;
    }

    void KeyInput::setMetaPressed(bool pressed)
    {
        mMetaPressed = pressed;
    }

    bool KeyInput::isNumericPad() const
    {
        return mNumericPad;
    }

    void KeyInput::setNumericPad(bool numpad)
    {
        mNumericPad = numpad;
    }
}  // namespace gcn
